// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _VHT_SIG_B_SU40_H_
#define _VHT_SIG_B_SU40_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	length[18:0], vhtb_reserved[20:19], tail[26:21], reserved[30:27], rx_ndp[31]
//	1	length_copy[18:0], vhtb_reserved_copy[20:19], tail_copy[26:21], reserved_copy[30:27], rx_ndp_copy[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_VHT_SIG_B_SU40 2

struct vht_sig_b_su40 {
    volatile uint32_t length                          : 19, //[18:0]
                      vhtb_reserved                   :  2, //[20:19]
                      tail                            :  6, //[26:21]
                      reserved                        :  4, //[30:27]
                      rx_ndp                          :  1; //[31]
    volatile uint32_t length_copy                     : 19, //[18:0]
                      vhtb_reserved_copy              :  2, //[20:19]
                      tail_copy                       :  6, //[26:21]
                      reserved_copy                   :  4, //[30:27]
                      rx_ndp_copy                     :  1; //[31]
};

/*

length
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)
			
			<legal all>

vhtb_reserved
			
			Reserved:  Set  to all ones and ignored on receive 
			<legal 3>

tail
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>

reserved
			
			Not part of VHT-SIG-B.
			
			Reserved: Set to 0 and ignored on receive  <legal 0>

rx_ndp
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>

length_copy
			
			Same as length <legal all>

vhtb_reserved_copy
			
			Same as vhtb_reserved  <legal 3>

tail_copy
			
			Same as tail  <legal 0>

reserved_copy
			
			Same as reserved  <legal 0>

rx_ndp_copy
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/


/* Description		VHT_SIG_B_SU40_0_LENGTH
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)
			
			<legal all>
*/
#define VHT_SIG_B_SU40_0_LENGTH_OFFSET                               0x00000000
#define VHT_SIG_B_SU40_0_LENGTH_LSB                                  0
#define VHT_SIG_B_SU40_0_LENGTH_MASK                                 0x0007ffff

/* Description		VHT_SIG_B_SU40_0_VHTB_RESERVED
			
			Reserved:  Set  to all ones and ignored on receive 
			<legal 3>
*/
#define VHT_SIG_B_SU40_0_VHTB_RESERVED_OFFSET                        0x00000000
#define VHT_SIG_B_SU40_0_VHTB_RESERVED_LSB                           19
#define VHT_SIG_B_SU40_0_VHTB_RESERVED_MASK                          0x00180000

/* Description		VHT_SIG_B_SU40_0_TAIL
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>
*/
#define VHT_SIG_B_SU40_0_TAIL_OFFSET                                 0x00000000
#define VHT_SIG_B_SU40_0_TAIL_LSB                                    21
#define VHT_SIG_B_SU40_0_TAIL_MASK                                   0x07e00000

/* Description		VHT_SIG_B_SU40_0_RESERVED
			
			Not part of VHT-SIG-B.
			
			Reserved: Set to 0 and ignored on receive  <legal 0>
*/
#define VHT_SIG_B_SU40_0_RESERVED_OFFSET                             0x00000000
#define VHT_SIG_B_SU40_0_RESERVED_LSB                                27
#define VHT_SIG_B_SU40_0_RESERVED_MASK                               0x78000000

/* Description		VHT_SIG_B_SU40_0_RX_NDP
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/
#define VHT_SIG_B_SU40_0_RX_NDP_OFFSET                               0x00000000
#define VHT_SIG_B_SU40_0_RX_NDP_LSB                                  31
#define VHT_SIG_B_SU40_0_RX_NDP_MASK                                 0x80000000

/* Description		VHT_SIG_B_SU40_1_LENGTH_COPY
			
			Same as length <legal all>
*/
#define VHT_SIG_B_SU40_1_LENGTH_COPY_OFFSET                          0x00000004
#define VHT_SIG_B_SU40_1_LENGTH_COPY_LSB                             0
#define VHT_SIG_B_SU40_1_LENGTH_COPY_MASK                            0x0007ffff

/* Description		VHT_SIG_B_SU40_1_VHTB_RESERVED_COPY
			
			Same as vhtb_reserved  <legal 3>
*/
#define VHT_SIG_B_SU40_1_VHTB_RESERVED_COPY_OFFSET                   0x00000004
#define VHT_SIG_B_SU40_1_VHTB_RESERVED_COPY_LSB                      19
#define VHT_SIG_B_SU40_1_VHTB_RESERVED_COPY_MASK                     0x00180000

/* Description		VHT_SIG_B_SU40_1_TAIL_COPY
			
			Same as tail  <legal 0>
*/
#define VHT_SIG_B_SU40_1_TAIL_COPY_OFFSET                            0x00000004
#define VHT_SIG_B_SU40_1_TAIL_COPY_LSB                               21
#define VHT_SIG_B_SU40_1_TAIL_COPY_MASK                              0x07e00000

/* Description		VHT_SIG_B_SU40_1_RESERVED_COPY
			
			Same as reserved  <legal 0>
*/
#define VHT_SIG_B_SU40_1_RESERVED_COPY_OFFSET                        0x00000004
#define VHT_SIG_B_SU40_1_RESERVED_COPY_LSB                           27
#define VHT_SIG_B_SU40_1_RESERVED_COPY_MASK                          0x78000000

/* Description		VHT_SIG_B_SU40_1_RX_NDP_COPY
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/
#define VHT_SIG_B_SU40_1_RX_NDP_COPY_OFFSET                          0x00000004
#define VHT_SIG_B_SU40_1_RX_NDP_COPY_LSB                             31
#define VHT_SIG_B_SU40_1_RX_NDP_COPY_MASK                            0x80000000


#endif // _VHT_SIG_B_SU40_H_
