// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _VHT_SIG_B_SU20_H_
#define _VHT_SIG_B_SU20_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	length[16:0], vhtb_reserved[19:17], tail[25:20], reserved[30:26], rx_ndp[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_VHT_SIG_B_SU20 1

struct vht_sig_b_su20 {
    volatile uint32_t length                          : 17, //[16:0]
                      vhtb_reserved                   :  3, //[19:17]
                      tail                            :  6, //[25:20]
                      reserved                        :  5, //[30:26]
                      rx_ndp                          :  1; //[31]
};

/*

length
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)
			
			<legal all>

vhtb_reserved
			
			Reserved:  Set  to all ones for non-NDP frames and
			ignored on receive
			
			<legal 2,7>

tail
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>

reserved
			
			Not part of VHT-SIG-B.
			
			Reserved: Set to 0 and ignored on receive  <legal 0>

rx_ndp
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/


/* Description		VHT_SIG_B_SU20_0_LENGTH
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)
			
			<legal all>
*/
#define VHT_SIG_B_SU20_0_LENGTH_OFFSET                               0x00000000
#define VHT_SIG_B_SU20_0_LENGTH_LSB                                  0
#define VHT_SIG_B_SU20_0_LENGTH_MASK                                 0x0001ffff

/* Description		VHT_SIG_B_SU20_0_VHTB_RESERVED
			
			Reserved:  Set  to all ones for non-NDP frames and
			ignored on receive
			
			<legal 2,7>
*/
#define VHT_SIG_B_SU20_0_VHTB_RESERVED_OFFSET                        0x00000000
#define VHT_SIG_B_SU20_0_VHTB_RESERVED_LSB                           17
#define VHT_SIG_B_SU20_0_VHTB_RESERVED_MASK                          0x000e0000

/* Description		VHT_SIG_B_SU20_0_TAIL
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>
*/
#define VHT_SIG_B_SU20_0_TAIL_OFFSET                                 0x00000000
#define VHT_SIG_B_SU20_0_TAIL_LSB                                    20
#define VHT_SIG_B_SU20_0_TAIL_MASK                                   0x03f00000

/* Description		VHT_SIG_B_SU20_0_RESERVED
			
			Not part of VHT-SIG-B.
			
			Reserved: Set to 0 and ignored on receive  <legal 0>
*/
#define VHT_SIG_B_SU20_0_RESERVED_OFFSET                             0x00000000
#define VHT_SIG_B_SU20_0_RESERVED_LSB                                26
#define VHT_SIG_B_SU20_0_RESERVED_MASK                               0x7c000000

/* Description		VHT_SIG_B_SU20_0_RX_NDP
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/
#define VHT_SIG_B_SU20_0_RX_NDP_OFFSET                               0x00000000
#define VHT_SIG_B_SU20_0_RX_NDP_LSB                                  31
#define VHT_SIG_B_SU20_0_RX_NDP_MASK                                 0x80000000


#endif // _VHT_SIG_B_SU20_H_
