// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _RX_PKT_END_H_
#define _RX_PKT_END_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	rx_success[0], reserved_0a[2:1], error_tx_interrupt_rx[3], error_ofdm_power_drop[4], error_ofdm_restart[5], error_cck_power_drop[6], error_cck_restart[7], reserved_0b[31:8]
//	1	phy_timestamp_1[31:0]
//	2	phy_timestamp_2[31:0]
//	3-4	struct rx_location_info rx_location_info;
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_RX_PKT_END 5

struct rx_pkt_end {
             uint32_t rx_success                      :  1, //[0]
                      reserved_0a                     :  2, //[2:1]
                      error_tx_interrupt_rx           :  1, //[3]
                      error_ofdm_power_drop           :  1, //[4]
                      error_ofdm_restart              :  1, //[5]
                      error_cck_power_drop            :  1, //[6]
                      error_cck_restart               :  1, //[7]
                      reserved_0b                     : 24; //[31:8]
             uint32_t phy_timestamp_1                 : 32; //[31:0]
             uint32_t phy_timestamp_2                 : 32; //[31:0]
             struct   rx_location_info                rx_location_info;
};

/*

rx_success
			
			PHY successfully completed transfer of PSDU

reserved_0a
			
			Reserved: Generator should set to 0 and consumer shall
			ignore<legal 0>

error_tx_interrupt_rx
			
			PSDU terminated due to TX_PHY_DESC message during
			receive.  Any receive packet will be terminated if a
			transmit starts

error_ofdm_power_drop
			
			PSDU terminated due to power drop during OFDM reception

error_ofdm_restart
			
			PSDU terminated due to large increase in receive power
			during OFDM reception

error_cck_power_drop
			
			PSDU terminated due to power drop during CCK reception

error_cck_restart
			
			PSDU terminated due to large increase in receive power
			during CCK reception

reserved_0b
			
			Reserved: Generator should set to 0 and consumer shall
			ignore<legal 0>

phy_timestamp_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.

phy_timestamp_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.

struct rx_location_info rx_location_info
			
			Format defined in beeliner_mac_phy_interace document 
*/


/* Description		RX_PKT_END_0_RX_SUCCESS
			
			PHY successfully completed transfer of PSDU
*/
#define RX_PKT_END_0_RX_SUCCESS_OFFSET                               0x00000000
#define RX_PKT_END_0_RX_SUCCESS_LSB                                  0
#define RX_PKT_END_0_RX_SUCCESS_MASK                                 0x00000001

/* Description		RX_PKT_END_0_RESERVED_0A
			
			Reserved: Generator should set to 0 and consumer shall
			ignore<legal 0>
*/
#define RX_PKT_END_0_RESERVED_0A_OFFSET                              0x00000000
#define RX_PKT_END_0_RESERVED_0A_LSB                                 1
#define RX_PKT_END_0_RESERVED_0A_MASK                                0x00000006

/* Description		RX_PKT_END_0_ERROR_TX_INTERRUPT_RX
			
			PSDU terminated due to TX_PHY_DESC message during
			receive.  Any receive packet will be terminated if a
			transmit starts
*/
#define RX_PKT_END_0_ERROR_TX_INTERRUPT_RX_OFFSET                    0x00000000
#define RX_PKT_END_0_ERROR_TX_INTERRUPT_RX_LSB                       3
#define RX_PKT_END_0_ERROR_TX_INTERRUPT_RX_MASK                      0x00000008

/* Description		RX_PKT_END_0_ERROR_OFDM_POWER_DROP
			
			PSDU terminated due to power drop during OFDM reception
*/
#define RX_PKT_END_0_ERROR_OFDM_POWER_DROP_OFFSET                    0x00000000
#define RX_PKT_END_0_ERROR_OFDM_POWER_DROP_LSB                       4
#define RX_PKT_END_0_ERROR_OFDM_POWER_DROP_MASK                      0x00000010

/* Description		RX_PKT_END_0_ERROR_OFDM_RESTART
			
			PSDU terminated due to large increase in receive power
			during OFDM reception
*/
#define RX_PKT_END_0_ERROR_OFDM_RESTART_OFFSET                       0x00000000
#define RX_PKT_END_0_ERROR_OFDM_RESTART_LSB                          5
#define RX_PKT_END_0_ERROR_OFDM_RESTART_MASK                         0x00000020

/* Description		RX_PKT_END_0_ERROR_CCK_POWER_DROP
			
			PSDU terminated due to power drop during CCK reception
*/
#define RX_PKT_END_0_ERROR_CCK_POWER_DROP_OFFSET                     0x00000000
#define RX_PKT_END_0_ERROR_CCK_POWER_DROP_LSB                        6
#define RX_PKT_END_0_ERROR_CCK_POWER_DROP_MASK                       0x00000040

/* Description		RX_PKT_END_0_ERROR_CCK_RESTART
			
			PSDU terminated due to large increase in receive power
			during CCK reception
*/
#define RX_PKT_END_0_ERROR_CCK_RESTART_OFFSET                        0x00000000
#define RX_PKT_END_0_ERROR_CCK_RESTART_LSB                           7
#define RX_PKT_END_0_ERROR_CCK_RESTART_MASK                          0x00000080

/* Description		RX_PKT_END_0_RESERVED_0B
			
			Reserved: Generator should set to 0 and consumer shall
			ignore<legal 0>
*/
#define RX_PKT_END_0_RESERVED_0B_OFFSET                              0x00000000
#define RX_PKT_END_0_RESERVED_0B_LSB                                 8
#define RX_PKT_END_0_RESERVED_0B_MASK                                0xffffff00

/* Description		RX_PKT_END_1_PHY_TIMESTAMP_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.
*/
#define RX_PKT_END_1_PHY_TIMESTAMP_1_OFFSET                          0x00000004
#define RX_PKT_END_1_PHY_TIMESTAMP_1_LSB                             0
#define RX_PKT_END_1_PHY_TIMESTAMP_1_MASK                            0xffffffff

/* Description		RX_PKT_END_2_PHY_TIMESTAMP_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.
*/
#define RX_PKT_END_2_PHY_TIMESTAMP_2_OFFSET                          0x00000008
#define RX_PKT_END_2_PHY_TIMESTAMP_2_LSB                             0
#define RX_PKT_END_2_PHY_TIMESTAMP_2_MASK                            0xffffffff
#define RX_PKT_END_3_RX_LOCATION_INFO_RX_LOCATION_INFO_OFFSET        0x0000000c
#define RX_PKT_END_3_RX_LOCATION_INFO_RX_LOCATION_INFO_LSB           0
#define RX_PKT_END_3_RX_LOCATION_INFO_RX_LOCATION_INFO_MASK          0xffffffff
#define RX_PKT_END_4_RX_LOCATION_INFO_RX_LOCATION_INFO_OFFSET        0x00000010
#define RX_PKT_END_4_RX_LOCATION_INFO_RX_LOCATION_INFO_LSB           0
#define RX_PKT_END_4_RX_LOCATION_INFO_RX_LOCATION_INFO_MASK          0xffffffff


#endif // _RX_PKT_END_H_
