/*
 * Copyright (c) 2015 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

#ifndef _DBI_REG_H_
#define _DBI_REG_H_


#ifndef __DBI_REG_BASE_ADDRESS
#define __DBI_REG_BASE_ADDRESS (0x89000)
#endif


// 0x0 (DBI_WINDOW_REG)
#define DBI_WINDOW_REG_DATA_LSB                                                0
#define DBI_WINDOW_REG_DATA_MSB                                                31
#define DBI_WINDOW_REG_DATA_MASK                                               0xffffffff
#define DBI_WINDOW_REG_DATA_GET(x)                                             (((x) & DBI_WINDOW_REG_DATA_MASK) >> DBI_WINDOW_REG_DATA_LSB)
#define DBI_WINDOW_REG_DATA_SET(x)                                             (((0 | (x)) << DBI_WINDOW_REG_DATA_LSB) & DBI_WINDOW_REG_DATA_MASK)
#define DBI_WINDOW_REG_DATA_RESET                                              0x0
#define DBI_WINDOW_REG_ADDRESS                                                 (0x0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_RSTMASK                                                 0xffffffff
#define DBI_WINDOW_REG_RESET                                                   0x0

// 0x0 (DBI_WINDOW_REG_0)
#define DBI_WINDOW_REG_DATA_0_LSB                                              0
#define DBI_WINDOW_REG_DATA_0_MSB                                              31
#define DBI_WINDOW_REG_DATA_0_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_0_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_0_MASK) >> DBI_WINDOW_REG_DATA_0_LSB)
#define DBI_WINDOW_REG_DATA_0_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_0_LSB) & DBI_WINDOW_REG_DATA_0_MASK)
#define DBI_WINDOW_REG_DATA_0_RESET                                            0x0
#define DBI_WINDOW_REG_0_ADDRESS                                               (0x0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_0_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_0_RESET                                                 0x0

// 0x4 (DBI_WINDOW_REG_1)
#define DBI_WINDOW_REG_DATA_1_LSB                                              0
#define DBI_WINDOW_REG_DATA_1_MSB                                              31
#define DBI_WINDOW_REG_DATA_1_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_1_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_1_MASK) >> DBI_WINDOW_REG_DATA_1_LSB)
#define DBI_WINDOW_REG_DATA_1_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_1_LSB) & DBI_WINDOW_REG_DATA_1_MASK)
#define DBI_WINDOW_REG_DATA_1_RESET                                            0x0
#define DBI_WINDOW_REG_1_ADDRESS                                               (0x4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_1_RESET                                                 0x0

// 0x8 (DBI_WINDOW_REG_2)
#define DBI_WINDOW_REG_DATA_2_LSB                                              0
#define DBI_WINDOW_REG_DATA_2_MSB                                              31
#define DBI_WINDOW_REG_DATA_2_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_2_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_2_MASK) >> DBI_WINDOW_REG_DATA_2_LSB)
#define DBI_WINDOW_REG_DATA_2_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_2_LSB) & DBI_WINDOW_REG_DATA_2_MASK)
#define DBI_WINDOW_REG_DATA_2_RESET                                            0x0
#define DBI_WINDOW_REG_2_ADDRESS                                               (0x8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_2_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_2_RESET                                                 0x0

// 0xc (DBI_WINDOW_REG_3)
#define DBI_WINDOW_REG_DATA_3_LSB                                              0
#define DBI_WINDOW_REG_DATA_3_MSB                                              31
#define DBI_WINDOW_REG_DATA_3_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_3_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_3_MASK) >> DBI_WINDOW_REG_DATA_3_LSB)
#define DBI_WINDOW_REG_DATA_3_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_3_LSB) & DBI_WINDOW_REG_DATA_3_MASK)
#define DBI_WINDOW_REG_DATA_3_RESET                                            0x0
#define DBI_WINDOW_REG_3_ADDRESS                                               (0xc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_3_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_3_RESET                                                 0x0

// 0x10 (DBI_WINDOW_REG_4)
#define DBI_WINDOW_REG_DATA_4_LSB                                              0
#define DBI_WINDOW_REG_DATA_4_MSB                                              31
#define DBI_WINDOW_REG_DATA_4_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_4_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_4_MASK) >> DBI_WINDOW_REG_DATA_4_LSB)
#define DBI_WINDOW_REG_DATA_4_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_4_LSB) & DBI_WINDOW_REG_DATA_4_MASK)
#define DBI_WINDOW_REG_DATA_4_RESET                                            0x0
#define DBI_WINDOW_REG_4_ADDRESS                                               (0x10 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_4_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_4_RESET                                                 0x0

// 0x14 (DBI_WINDOW_REG_5)
#define DBI_WINDOW_REG_DATA_5_LSB                                              0
#define DBI_WINDOW_REG_DATA_5_MSB                                              31
#define DBI_WINDOW_REG_DATA_5_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_5_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_5_MASK) >> DBI_WINDOW_REG_DATA_5_LSB)
#define DBI_WINDOW_REG_DATA_5_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_5_LSB) & DBI_WINDOW_REG_DATA_5_MASK)
#define DBI_WINDOW_REG_DATA_5_RESET                                            0x0
#define DBI_WINDOW_REG_5_ADDRESS                                               (0x14 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_5_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_5_RESET                                                 0x0

// 0x18 (DBI_WINDOW_REG_6)
#define DBI_WINDOW_REG_DATA_6_LSB                                              0
#define DBI_WINDOW_REG_DATA_6_MSB                                              31
#define DBI_WINDOW_REG_DATA_6_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_6_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_6_MASK) >> DBI_WINDOW_REG_DATA_6_LSB)
#define DBI_WINDOW_REG_DATA_6_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_6_LSB) & DBI_WINDOW_REG_DATA_6_MASK)
#define DBI_WINDOW_REG_DATA_6_RESET                                            0x0
#define DBI_WINDOW_REG_6_ADDRESS                                               (0x18 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_6_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_6_RESET                                                 0x0

// 0x1c (DBI_WINDOW_REG_7)
#define DBI_WINDOW_REG_DATA_7_LSB                                              0
#define DBI_WINDOW_REG_DATA_7_MSB                                              31
#define DBI_WINDOW_REG_DATA_7_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_7_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_7_MASK) >> DBI_WINDOW_REG_DATA_7_LSB)
#define DBI_WINDOW_REG_DATA_7_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_7_LSB) & DBI_WINDOW_REG_DATA_7_MASK)
#define DBI_WINDOW_REG_DATA_7_RESET                                            0x0
#define DBI_WINDOW_REG_7_ADDRESS                                               (0x1c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_7_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_7_RESET                                                 0x0

// 0x20 (DBI_WINDOW_REG_8)
#define DBI_WINDOW_REG_DATA_8_LSB                                              0
#define DBI_WINDOW_REG_DATA_8_MSB                                              31
#define DBI_WINDOW_REG_DATA_8_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_8_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_8_MASK) >> DBI_WINDOW_REG_DATA_8_LSB)
#define DBI_WINDOW_REG_DATA_8_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_8_LSB) & DBI_WINDOW_REG_DATA_8_MASK)
#define DBI_WINDOW_REG_DATA_8_RESET                                            0x0
#define DBI_WINDOW_REG_8_ADDRESS                                               (0x20 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_8_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_8_RESET                                                 0x0

// 0x24 (DBI_WINDOW_REG_9)
#define DBI_WINDOW_REG_DATA_9_LSB                                              0
#define DBI_WINDOW_REG_DATA_9_MSB                                              31
#define DBI_WINDOW_REG_DATA_9_MASK                                             0xffffffff
#define DBI_WINDOW_REG_DATA_9_GET(x)                                           (((x) & DBI_WINDOW_REG_DATA_9_MASK) >> DBI_WINDOW_REG_DATA_9_LSB)
#define DBI_WINDOW_REG_DATA_9_SET(x)                                           (((0 | (x)) << DBI_WINDOW_REG_DATA_9_LSB) & DBI_WINDOW_REG_DATA_9_MASK)
#define DBI_WINDOW_REG_DATA_9_RESET                                            0x0
#define DBI_WINDOW_REG_9_ADDRESS                                               (0x24 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_9_RSTMASK                                               0xffffffff
#define DBI_WINDOW_REG_9_RESET                                                 0x0

// 0x28 (DBI_WINDOW_REG_10)
#define DBI_WINDOW_REG_DATA_10_LSB                                             0
#define DBI_WINDOW_REG_DATA_10_MSB                                             31
#define DBI_WINDOW_REG_DATA_10_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_10_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_10_MASK) >> DBI_WINDOW_REG_DATA_10_LSB)
#define DBI_WINDOW_REG_DATA_10_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_10_LSB) & DBI_WINDOW_REG_DATA_10_MASK)
#define DBI_WINDOW_REG_DATA_10_RESET                                           0x0
#define DBI_WINDOW_REG_10_ADDRESS                                              (0x28 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_10_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_10_RESET                                                0x0

// 0x2c (DBI_WINDOW_REG_11)
#define DBI_WINDOW_REG_DATA_11_LSB                                             0
#define DBI_WINDOW_REG_DATA_11_MSB                                             31
#define DBI_WINDOW_REG_DATA_11_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_11_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_11_MASK) >> DBI_WINDOW_REG_DATA_11_LSB)
#define DBI_WINDOW_REG_DATA_11_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_11_LSB) & DBI_WINDOW_REG_DATA_11_MASK)
#define DBI_WINDOW_REG_DATA_11_RESET                                           0x0
#define DBI_WINDOW_REG_11_ADDRESS                                              (0x2c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_11_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_11_RESET                                                0x0

// 0x30 (DBI_WINDOW_REG_12)
#define DBI_WINDOW_REG_DATA_12_LSB                                             0
#define DBI_WINDOW_REG_DATA_12_MSB                                             31
#define DBI_WINDOW_REG_DATA_12_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_12_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_12_MASK) >> DBI_WINDOW_REG_DATA_12_LSB)
#define DBI_WINDOW_REG_DATA_12_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_12_LSB) & DBI_WINDOW_REG_DATA_12_MASK)
#define DBI_WINDOW_REG_DATA_12_RESET                                           0x0
#define DBI_WINDOW_REG_12_ADDRESS                                              (0x30 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_12_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_12_RESET                                                0x0

// 0x34 (DBI_WINDOW_REG_13)
#define DBI_WINDOW_REG_DATA_13_LSB                                             0
#define DBI_WINDOW_REG_DATA_13_MSB                                             31
#define DBI_WINDOW_REG_DATA_13_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_13_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_13_MASK) >> DBI_WINDOW_REG_DATA_13_LSB)
#define DBI_WINDOW_REG_DATA_13_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_13_LSB) & DBI_WINDOW_REG_DATA_13_MASK)
#define DBI_WINDOW_REG_DATA_13_RESET                                           0x0
#define DBI_WINDOW_REG_13_ADDRESS                                              (0x34 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_13_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_13_RESET                                                0x0

// 0x38 (DBI_WINDOW_REG_14)
#define DBI_WINDOW_REG_DATA_14_LSB                                             0
#define DBI_WINDOW_REG_DATA_14_MSB                                             31
#define DBI_WINDOW_REG_DATA_14_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_14_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_14_MASK) >> DBI_WINDOW_REG_DATA_14_LSB)
#define DBI_WINDOW_REG_DATA_14_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_14_LSB) & DBI_WINDOW_REG_DATA_14_MASK)
#define DBI_WINDOW_REG_DATA_14_RESET                                           0x0
#define DBI_WINDOW_REG_14_ADDRESS                                              (0x38 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_14_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_14_RESET                                                0x0

// 0x3c (DBI_WINDOW_REG_15)
#define DBI_WINDOW_REG_DATA_15_LSB                                             0
#define DBI_WINDOW_REG_DATA_15_MSB                                             31
#define DBI_WINDOW_REG_DATA_15_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_15_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_15_MASK) >> DBI_WINDOW_REG_DATA_15_LSB)
#define DBI_WINDOW_REG_DATA_15_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_15_LSB) & DBI_WINDOW_REG_DATA_15_MASK)
#define DBI_WINDOW_REG_DATA_15_RESET                                           0x0
#define DBI_WINDOW_REG_15_ADDRESS                                              (0x3c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_15_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_15_RESET                                                0x0

// 0x40 (DBI_WINDOW_REG_16)
#define DBI_WINDOW_REG_DATA_16_LSB                                             0
#define DBI_WINDOW_REG_DATA_16_MSB                                             31
#define DBI_WINDOW_REG_DATA_16_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_16_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_16_MASK) >> DBI_WINDOW_REG_DATA_16_LSB)
#define DBI_WINDOW_REG_DATA_16_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_16_LSB) & DBI_WINDOW_REG_DATA_16_MASK)
#define DBI_WINDOW_REG_DATA_16_RESET                                           0x0
#define DBI_WINDOW_REG_16_ADDRESS                                              (0x40 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_16_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_16_RESET                                                0x0

// 0x44 (DBI_WINDOW_REG_17)
#define DBI_WINDOW_REG_DATA_17_LSB                                             0
#define DBI_WINDOW_REG_DATA_17_MSB                                             31
#define DBI_WINDOW_REG_DATA_17_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_17_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_17_MASK) >> DBI_WINDOW_REG_DATA_17_LSB)
#define DBI_WINDOW_REG_DATA_17_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_17_LSB) & DBI_WINDOW_REG_DATA_17_MASK)
#define DBI_WINDOW_REG_DATA_17_RESET                                           0x0
#define DBI_WINDOW_REG_17_ADDRESS                                              (0x44 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_17_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_17_RESET                                                0x0

// 0x48 (DBI_WINDOW_REG_18)
#define DBI_WINDOW_REG_DATA_18_LSB                                             0
#define DBI_WINDOW_REG_DATA_18_MSB                                             31
#define DBI_WINDOW_REG_DATA_18_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_18_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_18_MASK) >> DBI_WINDOW_REG_DATA_18_LSB)
#define DBI_WINDOW_REG_DATA_18_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_18_LSB) & DBI_WINDOW_REG_DATA_18_MASK)
#define DBI_WINDOW_REG_DATA_18_RESET                                           0x0
#define DBI_WINDOW_REG_18_ADDRESS                                              (0x48 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_18_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_18_RESET                                                0x0

// 0x4c (DBI_WINDOW_REG_19)
#define DBI_WINDOW_REG_DATA_19_LSB                                             0
#define DBI_WINDOW_REG_DATA_19_MSB                                             31
#define DBI_WINDOW_REG_DATA_19_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_19_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_19_MASK) >> DBI_WINDOW_REG_DATA_19_LSB)
#define DBI_WINDOW_REG_DATA_19_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_19_LSB) & DBI_WINDOW_REG_DATA_19_MASK)
#define DBI_WINDOW_REG_DATA_19_RESET                                           0x0
#define DBI_WINDOW_REG_19_ADDRESS                                              (0x4c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_19_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_19_RESET                                                0x0

// 0x50 (DBI_WINDOW_REG_20)
#define DBI_WINDOW_REG_DATA_20_LSB                                             0
#define DBI_WINDOW_REG_DATA_20_MSB                                             31
#define DBI_WINDOW_REG_DATA_20_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_20_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_20_MASK) >> DBI_WINDOW_REG_DATA_20_LSB)
#define DBI_WINDOW_REG_DATA_20_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_20_LSB) & DBI_WINDOW_REG_DATA_20_MASK)
#define DBI_WINDOW_REG_DATA_20_RESET                                           0x0
#define DBI_WINDOW_REG_20_ADDRESS                                              (0x50 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_20_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_20_RESET                                                0x0

// 0x54 (DBI_WINDOW_REG_21)
#define DBI_WINDOW_REG_DATA_21_LSB                                             0
#define DBI_WINDOW_REG_DATA_21_MSB                                             31
#define DBI_WINDOW_REG_DATA_21_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_21_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_21_MASK) >> DBI_WINDOW_REG_DATA_21_LSB)
#define DBI_WINDOW_REG_DATA_21_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_21_LSB) & DBI_WINDOW_REG_DATA_21_MASK)
#define DBI_WINDOW_REG_DATA_21_RESET                                           0x0
#define DBI_WINDOW_REG_21_ADDRESS                                              (0x54 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_21_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_21_RESET                                                0x0

// 0x58 (DBI_WINDOW_REG_22)
#define DBI_WINDOW_REG_DATA_22_LSB                                             0
#define DBI_WINDOW_REG_DATA_22_MSB                                             31
#define DBI_WINDOW_REG_DATA_22_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_22_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_22_MASK) >> DBI_WINDOW_REG_DATA_22_LSB)
#define DBI_WINDOW_REG_DATA_22_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_22_LSB) & DBI_WINDOW_REG_DATA_22_MASK)
#define DBI_WINDOW_REG_DATA_22_RESET                                           0x0
#define DBI_WINDOW_REG_22_ADDRESS                                              (0x58 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_22_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_22_RESET                                                0x0

// 0x5c (DBI_WINDOW_REG_23)
#define DBI_WINDOW_REG_DATA_23_LSB                                             0
#define DBI_WINDOW_REG_DATA_23_MSB                                             31
#define DBI_WINDOW_REG_DATA_23_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_23_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_23_MASK) >> DBI_WINDOW_REG_DATA_23_LSB)
#define DBI_WINDOW_REG_DATA_23_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_23_LSB) & DBI_WINDOW_REG_DATA_23_MASK)
#define DBI_WINDOW_REG_DATA_23_RESET                                           0x0
#define DBI_WINDOW_REG_23_ADDRESS                                              (0x5c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_23_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_23_RESET                                                0x0

// 0x60 (DBI_WINDOW_REG_24)
#define DBI_WINDOW_REG_DATA_24_LSB                                             0
#define DBI_WINDOW_REG_DATA_24_MSB                                             31
#define DBI_WINDOW_REG_DATA_24_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_24_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_24_MASK) >> DBI_WINDOW_REG_DATA_24_LSB)
#define DBI_WINDOW_REG_DATA_24_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_24_LSB) & DBI_WINDOW_REG_DATA_24_MASK)
#define DBI_WINDOW_REG_DATA_24_RESET                                           0x0
#define DBI_WINDOW_REG_24_ADDRESS                                              (0x60 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_24_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_24_RESET                                                0x0

// 0x64 (DBI_WINDOW_REG_25)
#define DBI_WINDOW_REG_DATA_25_LSB                                             0
#define DBI_WINDOW_REG_DATA_25_MSB                                             31
#define DBI_WINDOW_REG_DATA_25_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_25_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_25_MASK) >> DBI_WINDOW_REG_DATA_25_LSB)
#define DBI_WINDOW_REG_DATA_25_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_25_LSB) & DBI_WINDOW_REG_DATA_25_MASK)
#define DBI_WINDOW_REG_DATA_25_RESET                                           0x0
#define DBI_WINDOW_REG_25_ADDRESS                                              (0x64 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_25_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_25_RESET                                                0x0

// 0x68 (DBI_WINDOW_REG_26)
#define DBI_WINDOW_REG_DATA_26_LSB                                             0
#define DBI_WINDOW_REG_DATA_26_MSB                                             31
#define DBI_WINDOW_REG_DATA_26_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_26_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_26_MASK) >> DBI_WINDOW_REG_DATA_26_LSB)
#define DBI_WINDOW_REG_DATA_26_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_26_LSB) & DBI_WINDOW_REG_DATA_26_MASK)
#define DBI_WINDOW_REG_DATA_26_RESET                                           0x0
#define DBI_WINDOW_REG_26_ADDRESS                                              (0x68 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_26_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_26_RESET                                                0x0

// 0x6c (DBI_WINDOW_REG_27)
#define DBI_WINDOW_REG_DATA_27_LSB                                             0
#define DBI_WINDOW_REG_DATA_27_MSB                                             31
#define DBI_WINDOW_REG_DATA_27_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_27_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_27_MASK) >> DBI_WINDOW_REG_DATA_27_LSB)
#define DBI_WINDOW_REG_DATA_27_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_27_LSB) & DBI_WINDOW_REG_DATA_27_MASK)
#define DBI_WINDOW_REG_DATA_27_RESET                                           0x0
#define DBI_WINDOW_REG_27_ADDRESS                                              (0x6c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_27_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_27_RESET                                                0x0

// 0x70 (DBI_WINDOW_REG_28)
#define DBI_WINDOW_REG_DATA_28_LSB                                             0
#define DBI_WINDOW_REG_DATA_28_MSB                                             31
#define DBI_WINDOW_REG_DATA_28_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_28_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_28_MASK) >> DBI_WINDOW_REG_DATA_28_LSB)
#define DBI_WINDOW_REG_DATA_28_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_28_LSB) & DBI_WINDOW_REG_DATA_28_MASK)
#define DBI_WINDOW_REG_DATA_28_RESET                                           0x0
#define DBI_WINDOW_REG_28_ADDRESS                                              (0x70 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_28_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_28_RESET                                                0x0

// 0x74 (DBI_WINDOW_REG_29)
#define DBI_WINDOW_REG_DATA_29_LSB                                             0
#define DBI_WINDOW_REG_DATA_29_MSB                                             31
#define DBI_WINDOW_REG_DATA_29_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_29_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_29_MASK) >> DBI_WINDOW_REG_DATA_29_LSB)
#define DBI_WINDOW_REG_DATA_29_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_29_LSB) & DBI_WINDOW_REG_DATA_29_MASK)
#define DBI_WINDOW_REG_DATA_29_RESET                                           0x0
#define DBI_WINDOW_REG_29_ADDRESS                                              (0x74 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_29_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_29_RESET                                                0x0

// 0x78 (DBI_WINDOW_REG_30)
#define DBI_WINDOW_REG_DATA_30_LSB                                             0
#define DBI_WINDOW_REG_DATA_30_MSB                                             31
#define DBI_WINDOW_REG_DATA_30_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_30_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_30_MASK) >> DBI_WINDOW_REG_DATA_30_LSB)
#define DBI_WINDOW_REG_DATA_30_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_30_LSB) & DBI_WINDOW_REG_DATA_30_MASK)
#define DBI_WINDOW_REG_DATA_30_RESET                                           0x0
#define DBI_WINDOW_REG_30_ADDRESS                                              (0x78 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_30_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_30_RESET                                                0x0

// 0x7c (DBI_WINDOW_REG_31)
#define DBI_WINDOW_REG_DATA_31_LSB                                             0
#define DBI_WINDOW_REG_DATA_31_MSB                                             31
#define DBI_WINDOW_REG_DATA_31_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_31_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_31_MASK) >> DBI_WINDOW_REG_DATA_31_LSB)
#define DBI_WINDOW_REG_DATA_31_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_31_LSB) & DBI_WINDOW_REG_DATA_31_MASK)
#define DBI_WINDOW_REG_DATA_31_RESET                                           0x0
#define DBI_WINDOW_REG_31_ADDRESS                                              (0x7c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_31_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_31_RESET                                                0x0

// 0x80 (DBI_WINDOW_REG_32)
#define DBI_WINDOW_REG_DATA_32_LSB                                             0
#define DBI_WINDOW_REG_DATA_32_MSB                                             31
#define DBI_WINDOW_REG_DATA_32_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_32_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_32_MASK) >> DBI_WINDOW_REG_DATA_32_LSB)
#define DBI_WINDOW_REG_DATA_32_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_32_LSB) & DBI_WINDOW_REG_DATA_32_MASK)
#define DBI_WINDOW_REG_DATA_32_RESET                                           0x0
#define DBI_WINDOW_REG_32_ADDRESS                                              (0x80 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_32_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_32_RESET                                                0x0

// 0x84 (DBI_WINDOW_REG_33)
#define DBI_WINDOW_REG_DATA_33_LSB                                             0
#define DBI_WINDOW_REG_DATA_33_MSB                                             31
#define DBI_WINDOW_REG_DATA_33_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_33_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_33_MASK) >> DBI_WINDOW_REG_DATA_33_LSB)
#define DBI_WINDOW_REG_DATA_33_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_33_LSB) & DBI_WINDOW_REG_DATA_33_MASK)
#define DBI_WINDOW_REG_DATA_33_RESET                                           0x0
#define DBI_WINDOW_REG_33_ADDRESS                                              (0x84 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_33_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_33_RESET                                                0x0

// 0x88 (DBI_WINDOW_REG_34)
#define DBI_WINDOW_REG_DATA_34_LSB                                             0
#define DBI_WINDOW_REG_DATA_34_MSB                                             31
#define DBI_WINDOW_REG_DATA_34_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_34_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_34_MASK) >> DBI_WINDOW_REG_DATA_34_LSB)
#define DBI_WINDOW_REG_DATA_34_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_34_LSB) & DBI_WINDOW_REG_DATA_34_MASK)
#define DBI_WINDOW_REG_DATA_34_RESET                                           0x0
#define DBI_WINDOW_REG_34_ADDRESS                                              (0x88 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_34_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_34_RESET                                                0x0

// 0x8c (DBI_WINDOW_REG_35)
#define DBI_WINDOW_REG_DATA_35_LSB                                             0
#define DBI_WINDOW_REG_DATA_35_MSB                                             31
#define DBI_WINDOW_REG_DATA_35_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_35_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_35_MASK) >> DBI_WINDOW_REG_DATA_35_LSB)
#define DBI_WINDOW_REG_DATA_35_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_35_LSB) & DBI_WINDOW_REG_DATA_35_MASK)
#define DBI_WINDOW_REG_DATA_35_RESET                                           0x0
#define DBI_WINDOW_REG_35_ADDRESS                                              (0x8c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_35_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_35_RESET                                                0x0

// 0x90 (DBI_WINDOW_REG_36)
#define DBI_WINDOW_REG_DATA_36_LSB                                             0
#define DBI_WINDOW_REG_DATA_36_MSB                                             31
#define DBI_WINDOW_REG_DATA_36_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_36_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_36_MASK) >> DBI_WINDOW_REG_DATA_36_LSB)
#define DBI_WINDOW_REG_DATA_36_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_36_LSB) & DBI_WINDOW_REG_DATA_36_MASK)
#define DBI_WINDOW_REG_DATA_36_RESET                                           0x0
#define DBI_WINDOW_REG_36_ADDRESS                                              (0x90 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_36_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_36_RESET                                                0x0

// 0x94 (DBI_WINDOW_REG_37)
#define DBI_WINDOW_REG_DATA_37_LSB                                             0
#define DBI_WINDOW_REG_DATA_37_MSB                                             31
#define DBI_WINDOW_REG_DATA_37_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_37_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_37_MASK) >> DBI_WINDOW_REG_DATA_37_LSB)
#define DBI_WINDOW_REG_DATA_37_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_37_LSB) & DBI_WINDOW_REG_DATA_37_MASK)
#define DBI_WINDOW_REG_DATA_37_RESET                                           0x0
#define DBI_WINDOW_REG_37_ADDRESS                                              (0x94 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_37_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_37_RESET                                                0x0

// 0x98 (DBI_WINDOW_REG_38)
#define DBI_WINDOW_REG_DATA_38_LSB                                             0
#define DBI_WINDOW_REG_DATA_38_MSB                                             31
#define DBI_WINDOW_REG_DATA_38_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_38_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_38_MASK) >> DBI_WINDOW_REG_DATA_38_LSB)
#define DBI_WINDOW_REG_DATA_38_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_38_LSB) & DBI_WINDOW_REG_DATA_38_MASK)
#define DBI_WINDOW_REG_DATA_38_RESET                                           0x0
#define DBI_WINDOW_REG_38_ADDRESS                                              (0x98 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_38_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_38_RESET                                                0x0

// 0x9c (DBI_WINDOW_REG_39)
#define DBI_WINDOW_REG_DATA_39_LSB                                             0
#define DBI_WINDOW_REG_DATA_39_MSB                                             31
#define DBI_WINDOW_REG_DATA_39_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_39_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_39_MASK) >> DBI_WINDOW_REG_DATA_39_LSB)
#define DBI_WINDOW_REG_DATA_39_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_39_LSB) & DBI_WINDOW_REG_DATA_39_MASK)
#define DBI_WINDOW_REG_DATA_39_RESET                                           0x0
#define DBI_WINDOW_REG_39_ADDRESS                                              (0x9c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_39_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_39_RESET                                                0x0

// 0xa0 (DBI_WINDOW_REG_40)
#define DBI_WINDOW_REG_DATA_40_LSB                                             0
#define DBI_WINDOW_REG_DATA_40_MSB                                             31
#define DBI_WINDOW_REG_DATA_40_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_40_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_40_MASK) >> DBI_WINDOW_REG_DATA_40_LSB)
#define DBI_WINDOW_REG_DATA_40_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_40_LSB) & DBI_WINDOW_REG_DATA_40_MASK)
#define DBI_WINDOW_REG_DATA_40_RESET                                           0x0
#define DBI_WINDOW_REG_40_ADDRESS                                              (0xa0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_40_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_40_RESET                                                0x0

// 0xa4 (DBI_WINDOW_REG_41)
#define DBI_WINDOW_REG_DATA_41_LSB                                             0
#define DBI_WINDOW_REG_DATA_41_MSB                                             31
#define DBI_WINDOW_REG_DATA_41_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_41_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_41_MASK) >> DBI_WINDOW_REG_DATA_41_LSB)
#define DBI_WINDOW_REG_DATA_41_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_41_LSB) & DBI_WINDOW_REG_DATA_41_MASK)
#define DBI_WINDOW_REG_DATA_41_RESET                                           0x0
#define DBI_WINDOW_REG_41_ADDRESS                                              (0xa4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_41_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_41_RESET                                                0x0

// 0xa8 (DBI_WINDOW_REG_42)
#define DBI_WINDOW_REG_DATA_42_LSB                                             0
#define DBI_WINDOW_REG_DATA_42_MSB                                             31
#define DBI_WINDOW_REG_DATA_42_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_42_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_42_MASK) >> DBI_WINDOW_REG_DATA_42_LSB)
#define DBI_WINDOW_REG_DATA_42_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_42_LSB) & DBI_WINDOW_REG_DATA_42_MASK)
#define DBI_WINDOW_REG_DATA_42_RESET                                           0x0
#define DBI_WINDOW_REG_42_ADDRESS                                              (0xa8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_42_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_42_RESET                                                0x0

// 0xac (DBI_WINDOW_REG_43)
#define DBI_WINDOW_REG_DATA_43_LSB                                             0
#define DBI_WINDOW_REG_DATA_43_MSB                                             31
#define DBI_WINDOW_REG_DATA_43_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_43_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_43_MASK) >> DBI_WINDOW_REG_DATA_43_LSB)
#define DBI_WINDOW_REG_DATA_43_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_43_LSB) & DBI_WINDOW_REG_DATA_43_MASK)
#define DBI_WINDOW_REG_DATA_43_RESET                                           0x0
#define DBI_WINDOW_REG_43_ADDRESS                                              (0xac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_43_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_43_RESET                                                0x0

// 0xb0 (DBI_WINDOW_REG_44)
#define DBI_WINDOW_REG_DATA_44_LSB                                             0
#define DBI_WINDOW_REG_DATA_44_MSB                                             31
#define DBI_WINDOW_REG_DATA_44_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_44_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_44_MASK) >> DBI_WINDOW_REG_DATA_44_LSB)
#define DBI_WINDOW_REG_DATA_44_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_44_LSB) & DBI_WINDOW_REG_DATA_44_MASK)
#define DBI_WINDOW_REG_DATA_44_RESET                                           0x0
#define DBI_WINDOW_REG_44_ADDRESS                                              (0xb0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_44_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_44_RESET                                                0x0

// 0xb4 (DBI_WINDOW_REG_45)
#define DBI_WINDOW_REG_DATA_45_LSB                                             0
#define DBI_WINDOW_REG_DATA_45_MSB                                             31
#define DBI_WINDOW_REG_DATA_45_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_45_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_45_MASK) >> DBI_WINDOW_REG_DATA_45_LSB)
#define DBI_WINDOW_REG_DATA_45_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_45_LSB) & DBI_WINDOW_REG_DATA_45_MASK)
#define DBI_WINDOW_REG_DATA_45_RESET                                           0x0
#define DBI_WINDOW_REG_45_ADDRESS                                              (0xb4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_45_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_45_RESET                                                0x0

// 0xb8 (DBI_WINDOW_REG_46)
#define DBI_WINDOW_REG_DATA_46_LSB                                             0
#define DBI_WINDOW_REG_DATA_46_MSB                                             31
#define DBI_WINDOW_REG_DATA_46_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_46_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_46_MASK) >> DBI_WINDOW_REG_DATA_46_LSB)
#define DBI_WINDOW_REG_DATA_46_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_46_LSB) & DBI_WINDOW_REG_DATA_46_MASK)
#define DBI_WINDOW_REG_DATA_46_RESET                                           0x0
#define DBI_WINDOW_REG_46_ADDRESS                                              (0xb8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_46_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_46_RESET                                                0x0

// 0xbc (DBI_WINDOW_REG_47)
#define DBI_WINDOW_REG_DATA_47_LSB                                             0
#define DBI_WINDOW_REG_DATA_47_MSB                                             31
#define DBI_WINDOW_REG_DATA_47_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_47_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_47_MASK) >> DBI_WINDOW_REG_DATA_47_LSB)
#define DBI_WINDOW_REG_DATA_47_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_47_LSB) & DBI_WINDOW_REG_DATA_47_MASK)
#define DBI_WINDOW_REG_DATA_47_RESET                                           0x0
#define DBI_WINDOW_REG_47_ADDRESS                                              (0xbc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_47_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_47_RESET                                                0x0

// 0xc0 (DBI_WINDOW_REG_48)
#define DBI_WINDOW_REG_DATA_48_LSB                                             0
#define DBI_WINDOW_REG_DATA_48_MSB                                             31
#define DBI_WINDOW_REG_DATA_48_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_48_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_48_MASK) >> DBI_WINDOW_REG_DATA_48_LSB)
#define DBI_WINDOW_REG_DATA_48_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_48_LSB) & DBI_WINDOW_REG_DATA_48_MASK)
#define DBI_WINDOW_REG_DATA_48_RESET                                           0x0
#define DBI_WINDOW_REG_48_ADDRESS                                              (0xc0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_48_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_48_RESET                                                0x0

// 0xc4 (DBI_WINDOW_REG_49)
#define DBI_WINDOW_REG_DATA_49_LSB                                             0
#define DBI_WINDOW_REG_DATA_49_MSB                                             31
#define DBI_WINDOW_REG_DATA_49_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_49_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_49_MASK) >> DBI_WINDOW_REG_DATA_49_LSB)
#define DBI_WINDOW_REG_DATA_49_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_49_LSB) & DBI_WINDOW_REG_DATA_49_MASK)
#define DBI_WINDOW_REG_DATA_49_RESET                                           0x0
#define DBI_WINDOW_REG_49_ADDRESS                                              (0xc4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_49_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_49_RESET                                                0x0

// 0xc8 (DBI_WINDOW_REG_50)
#define DBI_WINDOW_REG_DATA_50_LSB                                             0
#define DBI_WINDOW_REG_DATA_50_MSB                                             31
#define DBI_WINDOW_REG_DATA_50_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_50_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_50_MASK) >> DBI_WINDOW_REG_DATA_50_LSB)
#define DBI_WINDOW_REG_DATA_50_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_50_LSB) & DBI_WINDOW_REG_DATA_50_MASK)
#define DBI_WINDOW_REG_DATA_50_RESET                                           0x0
#define DBI_WINDOW_REG_50_ADDRESS                                              (0xc8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_50_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_50_RESET                                                0x0

// 0xcc (DBI_WINDOW_REG_51)
#define DBI_WINDOW_REG_DATA_51_LSB                                             0
#define DBI_WINDOW_REG_DATA_51_MSB                                             31
#define DBI_WINDOW_REG_DATA_51_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_51_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_51_MASK) >> DBI_WINDOW_REG_DATA_51_LSB)
#define DBI_WINDOW_REG_DATA_51_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_51_LSB) & DBI_WINDOW_REG_DATA_51_MASK)
#define DBI_WINDOW_REG_DATA_51_RESET                                           0x0
#define DBI_WINDOW_REG_51_ADDRESS                                              (0xcc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_51_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_51_RESET                                                0x0

// 0xd0 (DBI_WINDOW_REG_52)
#define DBI_WINDOW_REG_DATA_52_LSB                                             0
#define DBI_WINDOW_REG_DATA_52_MSB                                             31
#define DBI_WINDOW_REG_DATA_52_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_52_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_52_MASK) >> DBI_WINDOW_REG_DATA_52_LSB)
#define DBI_WINDOW_REG_DATA_52_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_52_LSB) & DBI_WINDOW_REG_DATA_52_MASK)
#define DBI_WINDOW_REG_DATA_52_RESET                                           0x0
#define DBI_WINDOW_REG_52_ADDRESS                                              (0xd0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_52_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_52_RESET                                                0x0

// 0xd4 (DBI_WINDOW_REG_53)
#define DBI_WINDOW_REG_DATA_53_LSB                                             0
#define DBI_WINDOW_REG_DATA_53_MSB                                             31
#define DBI_WINDOW_REG_DATA_53_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_53_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_53_MASK) >> DBI_WINDOW_REG_DATA_53_LSB)
#define DBI_WINDOW_REG_DATA_53_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_53_LSB) & DBI_WINDOW_REG_DATA_53_MASK)
#define DBI_WINDOW_REG_DATA_53_RESET                                           0x0
#define DBI_WINDOW_REG_53_ADDRESS                                              (0xd4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_53_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_53_RESET                                                0x0

// 0xd8 (DBI_WINDOW_REG_54)
#define DBI_WINDOW_REG_DATA_54_LSB                                             0
#define DBI_WINDOW_REG_DATA_54_MSB                                             31
#define DBI_WINDOW_REG_DATA_54_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_54_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_54_MASK) >> DBI_WINDOW_REG_DATA_54_LSB)
#define DBI_WINDOW_REG_DATA_54_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_54_LSB) & DBI_WINDOW_REG_DATA_54_MASK)
#define DBI_WINDOW_REG_DATA_54_RESET                                           0x0
#define DBI_WINDOW_REG_54_ADDRESS                                              (0xd8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_54_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_54_RESET                                                0x0

// 0xdc (DBI_WINDOW_REG_55)
#define DBI_WINDOW_REG_DATA_55_LSB                                             0
#define DBI_WINDOW_REG_DATA_55_MSB                                             31
#define DBI_WINDOW_REG_DATA_55_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_55_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_55_MASK) >> DBI_WINDOW_REG_DATA_55_LSB)
#define DBI_WINDOW_REG_DATA_55_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_55_LSB) & DBI_WINDOW_REG_DATA_55_MASK)
#define DBI_WINDOW_REG_DATA_55_RESET                                           0x0
#define DBI_WINDOW_REG_55_ADDRESS                                              (0xdc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_55_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_55_RESET                                                0x0

// 0xe0 (DBI_WINDOW_REG_56)
#define DBI_WINDOW_REG_DATA_56_LSB                                             0
#define DBI_WINDOW_REG_DATA_56_MSB                                             31
#define DBI_WINDOW_REG_DATA_56_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_56_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_56_MASK) >> DBI_WINDOW_REG_DATA_56_LSB)
#define DBI_WINDOW_REG_DATA_56_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_56_LSB) & DBI_WINDOW_REG_DATA_56_MASK)
#define DBI_WINDOW_REG_DATA_56_RESET                                           0x0
#define DBI_WINDOW_REG_56_ADDRESS                                              (0xe0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_56_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_56_RESET                                                0x0

// 0xe4 (DBI_WINDOW_REG_57)
#define DBI_WINDOW_REG_DATA_57_LSB                                             0
#define DBI_WINDOW_REG_DATA_57_MSB                                             31
#define DBI_WINDOW_REG_DATA_57_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_57_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_57_MASK) >> DBI_WINDOW_REG_DATA_57_LSB)
#define DBI_WINDOW_REG_DATA_57_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_57_LSB) & DBI_WINDOW_REG_DATA_57_MASK)
#define DBI_WINDOW_REG_DATA_57_RESET                                           0x0
#define DBI_WINDOW_REG_57_ADDRESS                                              (0xe4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_57_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_57_RESET                                                0x0

// 0xe8 (DBI_WINDOW_REG_58)
#define DBI_WINDOW_REG_DATA_58_LSB                                             0
#define DBI_WINDOW_REG_DATA_58_MSB                                             31
#define DBI_WINDOW_REG_DATA_58_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_58_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_58_MASK) >> DBI_WINDOW_REG_DATA_58_LSB)
#define DBI_WINDOW_REG_DATA_58_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_58_LSB) & DBI_WINDOW_REG_DATA_58_MASK)
#define DBI_WINDOW_REG_DATA_58_RESET                                           0x0
#define DBI_WINDOW_REG_58_ADDRESS                                              (0xe8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_58_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_58_RESET                                                0x0

// 0xec (DBI_WINDOW_REG_59)
#define DBI_WINDOW_REG_DATA_59_LSB                                             0
#define DBI_WINDOW_REG_DATA_59_MSB                                             31
#define DBI_WINDOW_REG_DATA_59_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_59_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_59_MASK) >> DBI_WINDOW_REG_DATA_59_LSB)
#define DBI_WINDOW_REG_DATA_59_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_59_LSB) & DBI_WINDOW_REG_DATA_59_MASK)
#define DBI_WINDOW_REG_DATA_59_RESET                                           0x0
#define DBI_WINDOW_REG_59_ADDRESS                                              (0xec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_59_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_59_RESET                                                0x0

// 0xf0 (DBI_WINDOW_REG_60)
#define DBI_WINDOW_REG_DATA_60_LSB                                             0
#define DBI_WINDOW_REG_DATA_60_MSB                                             31
#define DBI_WINDOW_REG_DATA_60_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_60_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_60_MASK) >> DBI_WINDOW_REG_DATA_60_LSB)
#define DBI_WINDOW_REG_DATA_60_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_60_LSB) & DBI_WINDOW_REG_DATA_60_MASK)
#define DBI_WINDOW_REG_DATA_60_RESET                                           0x0
#define DBI_WINDOW_REG_60_ADDRESS                                              (0xf0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_60_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_60_RESET                                                0x0

// 0xf4 (DBI_WINDOW_REG_61)
#define DBI_WINDOW_REG_DATA_61_LSB                                             0
#define DBI_WINDOW_REG_DATA_61_MSB                                             31
#define DBI_WINDOW_REG_DATA_61_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_61_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_61_MASK) >> DBI_WINDOW_REG_DATA_61_LSB)
#define DBI_WINDOW_REG_DATA_61_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_61_LSB) & DBI_WINDOW_REG_DATA_61_MASK)
#define DBI_WINDOW_REG_DATA_61_RESET                                           0x0
#define DBI_WINDOW_REG_61_ADDRESS                                              (0xf4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_61_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_61_RESET                                                0x0

// 0xf8 (DBI_WINDOW_REG_62)
#define DBI_WINDOW_REG_DATA_62_LSB                                             0
#define DBI_WINDOW_REG_DATA_62_MSB                                             31
#define DBI_WINDOW_REG_DATA_62_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_62_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_62_MASK) >> DBI_WINDOW_REG_DATA_62_LSB)
#define DBI_WINDOW_REG_DATA_62_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_62_LSB) & DBI_WINDOW_REG_DATA_62_MASK)
#define DBI_WINDOW_REG_DATA_62_RESET                                           0x0
#define DBI_WINDOW_REG_62_ADDRESS                                              (0xf8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_62_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_62_RESET                                                0x0

// 0xfc (DBI_WINDOW_REG_63)
#define DBI_WINDOW_REG_DATA_63_LSB                                             0
#define DBI_WINDOW_REG_DATA_63_MSB                                             31
#define DBI_WINDOW_REG_DATA_63_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_63_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_63_MASK) >> DBI_WINDOW_REG_DATA_63_LSB)
#define DBI_WINDOW_REG_DATA_63_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_63_LSB) & DBI_WINDOW_REG_DATA_63_MASK)
#define DBI_WINDOW_REG_DATA_63_RESET                                           0x0
#define DBI_WINDOW_REG_63_ADDRESS                                              (0xfc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_63_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_63_RESET                                                0x0

// 0x100 (DBI_WINDOW_REG_64)
#define DBI_WINDOW_REG_DATA_64_LSB                                             0
#define DBI_WINDOW_REG_DATA_64_MSB                                             31
#define DBI_WINDOW_REG_DATA_64_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_64_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_64_MASK) >> DBI_WINDOW_REG_DATA_64_LSB)
#define DBI_WINDOW_REG_DATA_64_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_64_LSB) & DBI_WINDOW_REG_DATA_64_MASK)
#define DBI_WINDOW_REG_DATA_64_RESET                                           0x0
#define DBI_WINDOW_REG_64_ADDRESS                                              (0x100 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_64_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_64_RESET                                                0x0

// 0x104 (DBI_WINDOW_REG_65)
#define DBI_WINDOW_REG_DATA_65_LSB                                             0
#define DBI_WINDOW_REG_DATA_65_MSB                                             31
#define DBI_WINDOW_REG_DATA_65_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_65_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_65_MASK) >> DBI_WINDOW_REG_DATA_65_LSB)
#define DBI_WINDOW_REG_DATA_65_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_65_LSB) & DBI_WINDOW_REG_DATA_65_MASK)
#define DBI_WINDOW_REG_DATA_65_RESET                                           0x0
#define DBI_WINDOW_REG_65_ADDRESS                                              (0x104 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_65_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_65_RESET                                                0x0

// 0x108 (DBI_WINDOW_REG_66)
#define DBI_WINDOW_REG_DATA_66_LSB                                             0
#define DBI_WINDOW_REG_DATA_66_MSB                                             31
#define DBI_WINDOW_REG_DATA_66_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_66_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_66_MASK) >> DBI_WINDOW_REG_DATA_66_LSB)
#define DBI_WINDOW_REG_DATA_66_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_66_LSB) & DBI_WINDOW_REG_DATA_66_MASK)
#define DBI_WINDOW_REG_DATA_66_RESET                                           0x0
#define DBI_WINDOW_REG_66_ADDRESS                                              (0x108 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_66_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_66_RESET                                                0x0

// 0x10c (DBI_WINDOW_REG_67)
#define DBI_WINDOW_REG_DATA_67_LSB                                             0
#define DBI_WINDOW_REG_DATA_67_MSB                                             31
#define DBI_WINDOW_REG_DATA_67_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_67_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_67_MASK) >> DBI_WINDOW_REG_DATA_67_LSB)
#define DBI_WINDOW_REG_DATA_67_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_67_LSB) & DBI_WINDOW_REG_DATA_67_MASK)
#define DBI_WINDOW_REG_DATA_67_RESET                                           0x0
#define DBI_WINDOW_REG_67_ADDRESS                                              (0x10c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_67_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_67_RESET                                                0x0

// 0x110 (DBI_WINDOW_REG_68)
#define DBI_WINDOW_REG_DATA_68_LSB                                             0
#define DBI_WINDOW_REG_DATA_68_MSB                                             31
#define DBI_WINDOW_REG_DATA_68_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_68_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_68_MASK) >> DBI_WINDOW_REG_DATA_68_LSB)
#define DBI_WINDOW_REG_DATA_68_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_68_LSB) & DBI_WINDOW_REG_DATA_68_MASK)
#define DBI_WINDOW_REG_DATA_68_RESET                                           0x0
#define DBI_WINDOW_REG_68_ADDRESS                                              (0x110 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_68_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_68_RESET                                                0x0

// 0x114 (DBI_WINDOW_REG_69)
#define DBI_WINDOW_REG_DATA_69_LSB                                             0
#define DBI_WINDOW_REG_DATA_69_MSB                                             31
#define DBI_WINDOW_REG_DATA_69_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_69_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_69_MASK) >> DBI_WINDOW_REG_DATA_69_LSB)
#define DBI_WINDOW_REG_DATA_69_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_69_LSB) & DBI_WINDOW_REG_DATA_69_MASK)
#define DBI_WINDOW_REG_DATA_69_RESET                                           0x0
#define DBI_WINDOW_REG_69_ADDRESS                                              (0x114 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_69_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_69_RESET                                                0x0

// 0x118 (DBI_WINDOW_REG_70)
#define DBI_WINDOW_REG_DATA_70_LSB                                             0
#define DBI_WINDOW_REG_DATA_70_MSB                                             31
#define DBI_WINDOW_REG_DATA_70_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_70_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_70_MASK) >> DBI_WINDOW_REG_DATA_70_LSB)
#define DBI_WINDOW_REG_DATA_70_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_70_LSB) & DBI_WINDOW_REG_DATA_70_MASK)
#define DBI_WINDOW_REG_DATA_70_RESET                                           0x0
#define DBI_WINDOW_REG_70_ADDRESS                                              (0x118 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_70_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_70_RESET                                                0x0

// 0x11c (DBI_WINDOW_REG_71)
#define DBI_WINDOW_REG_DATA_71_LSB                                             0
#define DBI_WINDOW_REG_DATA_71_MSB                                             31
#define DBI_WINDOW_REG_DATA_71_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_71_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_71_MASK) >> DBI_WINDOW_REG_DATA_71_LSB)
#define DBI_WINDOW_REG_DATA_71_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_71_LSB) & DBI_WINDOW_REG_DATA_71_MASK)
#define DBI_WINDOW_REG_DATA_71_RESET                                           0x0
#define DBI_WINDOW_REG_71_ADDRESS                                              (0x11c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_71_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_71_RESET                                                0x0

// 0x120 (DBI_WINDOW_REG_72)
#define DBI_WINDOW_REG_DATA_72_LSB                                             0
#define DBI_WINDOW_REG_DATA_72_MSB                                             31
#define DBI_WINDOW_REG_DATA_72_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_72_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_72_MASK) >> DBI_WINDOW_REG_DATA_72_LSB)
#define DBI_WINDOW_REG_DATA_72_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_72_LSB) & DBI_WINDOW_REG_DATA_72_MASK)
#define DBI_WINDOW_REG_DATA_72_RESET                                           0x0
#define DBI_WINDOW_REG_72_ADDRESS                                              (0x120 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_72_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_72_RESET                                                0x0

// 0x124 (DBI_WINDOW_REG_73)
#define DBI_WINDOW_REG_DATA_73_LSB                                             0
#define DBI_WINDOW_REG_DATA_73_MSB                                             31
#define DBI_WINDOW_REG_DATA_73_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_73_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_73_MASK) >> DBI_WINDOW_REG_DATA_73_LSB)
#define DBI_WINDOW_REG_DATA_73_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_73_LSB) & DBI_WINDOW_REG_DATA_73_MASK)
#define DBI_WINDOW_REG_DATA_73_RESET                                           0x0
#define DBI_WINDOW_REG_73_ADDRESS                                              (0x124 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_73_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_73_RESET                                                0x0

// 0x128 (DBI_WINDOW_REG_74)
#define DBI_WINDOW_REG_DATA_74_LSB                                             0
#define DBI_WINDOW_REG_DATA_74_MSB                                             31
#define DBI_WINDOW_REG_DATA_74_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_74_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_74_MASK) >> DBI_WINDOW_REG_DATA_74_LSB)
#define DBI_WINDOW_REG_DATA_74_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_74_LSB) & DBI_WINDOW_REG_DATA_74_MASK)
#define DBI_WINDOW_REG_DATA_74_RESET                                           0x0
#define DBI_WINDOW_REG_74_ADDRESS                                              (0x128 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_74_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_74_RESET                                                0x0

// 0x12c (DBI_WINDOW_REG_75)
#define DBI_WINDOW_REG_DATA_75_LSB                                             0
#define DBI_WINDOW_REG_DATA_75_MSB                                             31
#define DBI_WINDOW_REG_DATA_75_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_75_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_75_MASK) >> DBI_WINDOW_REG_DATA_75_LSB)
#define DBI_WINDOW_REG_DATA_75_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_75_LSB) & DBI_WINDOW_REG_DATA_75_MASK)
#define DBI_WINDOW_REG_DATA_75_RESET                                           0x0
#define DBI_WINDOW_REG_75_ADDRESS                                              (0x12c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_75_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_75_RESET                                                0x0

// 0x130 (DBI_WINDOW_REG_76)
#define DBI_WINDOW_REG_DATA_76_LSB                                             0
#define DBI_WINDOW_REG_DATA_76_MSB                                             31
#define DBI_WINDOW_REG_DATA_76_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_76_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_76_MASK) >> DBI_WINDOW_REG_DATA_76_LSB)
#define DBI_WINDOW_REG_DATA_76_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_76_LSB) & DBI_WINDOW_REG_DATA_76_MASK)
#define DBI_WINDOW_REG_DATA_76_RESET                                           0x0
#define DBI_WINDOW_REG_76_ADDRESS                                              (0x130 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_76_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_76_RESET                                                0x0

// 0x134 (DBI_WINDOW_REG_77)
#define DBI_WINDOW_REG_DATA_77_LSB                                             0
#define DBI_WINDOW_REG_DATA_77_MSB                                             31
#define DBI_WINDOW_REG_DATA_77_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_77_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_77_MASK) >> DBI_WINDOW_REG_DATA_77_LSB)
#define DBI_WINDOW_REG_DATA_77_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_77_LSB) & DBI_WINDOW_REG_DATA_77_MASK)
#define DBI_WINDOW_REG_DATA_77_RESET                                           0x0
#define DBI_WINDOW_REG_77_ADDRESS                                              (0x134 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_77_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_77_RESET                                                0x0

// 0x138 (DBI_WINDOW_REG_78)
#define DBI_WINDOW_REG_DATA_78_LSB                                             0
#define DBI_WINDOW_REG_DATA_78_MSB                                             31
#define DBI_WINDOW_REG_DATA_78_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_78_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_78_MASK) >> DBI_WINDOW_REG_DATA_78_LSB)
#define DBI_WINDOW_REG_DATA_78_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_78_LSB) & DBI_WINDOW_REG_DATA_78_MASK)
#define DBI_WINDOW_REG_DATA_78_RESET                                           0x0
#define DBI_WINDOW_REG_78_ADDRESS                                              (0x138 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_78_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_78_RESET                                                0x0

// 0x13c (DBI_WINDOW_REG_79)
#define DBI_WINDOW_REG_DATA_79_LSB                                             0
#define DBI_WINDOW_REG_DATA_79_MSB                                             31
#define DBI_WINDOW_REG_DATA_79_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_79_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_79_MASK) >> DBI_WINDOW_REG_DATA_79_LSB)
#define DBI_WINDOW_REG_DATA_79_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_79_LSB) & DBI_WINDOW_REG_DATA_79_MASK)
#define DBI_WINDOW_REG_DATA_79_RESET                                           0x0
#define DBI_WINDOW_REG_79_ADDRESS                                              (0x13c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_79_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_79_RESET                                                0x0

// 0x140 (DBI_WINDOW_REG_80)
#define DBI_WINDOW_REG_DATA_80_LSB                                             0
#define DBI_WINDOW_REG_DATA_80_MSB                                             31
#define DBI_WINDOW_REG_DATA_80_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_80_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_80_MASK) >> DBI_WINDOW_REG_DATA_80_LSB)
#define DBI_WINDOW_REG_DATA_80_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_80_LSB) & DBI_WINDOW_REG_DATA_80_MASK)
#define DBI_WINDOW_REG_DATA_80_RESET                                           0x0
#define DBI_WINDOW_REG_80_ADDRESS                                              (0x140 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_80_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_80_RESET                                                0x0

// 0x144 (DBI_WINDOW_REG_81)
#define DBI_WINDOW_REG_DATA_81_LSB                                             0
#define DBI_WINDOW_REG_DATA_81_MSB                                             31
#define DBI_WINDOW_REG_DATA_81_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_81_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_81_MASK) >> DBI_WINDOW_REG_DATA_81_LSB)
#define DBI_WINDOW_REG_DATA_81_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_81_LSB) & DBI_WINDOW_REG_DATA_81_MASK)
#define DBI_WINDOW_REG_DATA_81_RESET                                           0x0
#define DBI_WINDOW_REG_81_ADDRESS                                              (0x144 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_81_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_81_RESET                                                0x0

// 0x148 (DBI_WINDOW_REG_82)
#define DBI_WINDOW_REG_DATA_82_LSB                                             0
#define DBI_WINDOW_REG_DATA_82_MSB                                             31
#define DBI_WINDOW_REG_DATA_82_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_82_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_82_MASK) >> DBI_WINDOW_REG_DATA_82_LSB)
#define DBI_WINDOW_REG_DATA_82_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_82_LSB) & DBI_WINDOW_REG_DATA_82_MASK)
#define DBI_WINDOW_REG_DATA_82_RESET                                           0x0
#define DBI_WINDOW_REG_82_ADDRESS                                              (0x148 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_82_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_82_RESET                                                0x0

// 0x14c (DBI_WINDOW_REG_83)
#define DBI_WINDOW_REG_DATA_83_LSB                                             0
#define DBI_WINDOW_REG_DATA_83_MSB                                             31
#define DBI_WINDOW_REG_DATA_83_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_83_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_83_MASK) >> DBI_WINDOW_REG_DATA_83_LSB)
#define DBI_WINDOW_REG_DATA_83_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_83_LSB) & DBI_WINDOW_REG_DATA_83_MASK)
#define DBI_WINDOW_REG_DATA_83_RESET                                           0x0
#define DBI_WINDOW_REG_83_ADDRESS                                              (0x14c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_83_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_83_RESET                                                0x0

// 0x150 (DBI_WINDOW_REG_84)
#define DBI_WINDOW_REG_DATA_84_LSB                                             0
#define DBI_WINDOW_REG_DATA_84_MSB                                             31
#define DBI_WINDOW_REG_DATA_84_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_84_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_84_MASK) >> DBI_WINDOW_REG_DATA_84_LSB)
#define DBI_WINDOW_REG_DATA_84_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_84_LSB) & DBI_WINDOW_REG_DATA_84_MASK)
#define DBI_WINDOW_REG_DATA_84_RESET                                           0x0
#define DBI_WINDOW_REG_84_ADDRESS                                              (0x150 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_84_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_84_RESET                                                0x0

// 0x154 (DBI_WINDOW_REG_85)
#define DBI_WINDOW_REG_DATA_85_LSB                                             0
#define DBI_WINDOW_REG_DATA_85_MSB                                             31
#define DBI_WINDOW_REG_DATA_85_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_85_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_85_MASK) >> DBI_WINDOW_REG_DATA_85_LSB)
#define DBI_WINDOW_REG_DATA_85_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_85_LSB) & DBI_WINDOW_REG_DATA_85_MASK)
#define DBI_WINDOW_REG_DATA_85_RESET                                           0x0
#define DBI_WINDOW_REG_85_ADDRESS                                              (0x154 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_85_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_85_RESET                                                0x0

// 0x158 (DBI_WINDOW_REG_86)
#define DBI_WINDOW_REG_DATA_86_LSB                                             0
#define DBI_WINDOW_REG_DATA_86_MSB                                             31
#define DBI_WINDOW_REG_DATA_86_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_86_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_86_MASK) >> DBI_WINDOW_REG_DATA_86_LSB)
#define DBI_WINDOW_REG_DATA_86_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_86_LSB) & DBI_WINDOW_REG_DATA_86_MASK)
#define DBI_WINDOW_REG_DATA_86_RESET                                           0x0
#define DBI_WINDOW_REG_86_ADDRESS                                              (0x158 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_86_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_86_RESET                                                0x0

// 0x15c (DBI_WINDOW_REG_87)
#define DBI_WINDOW_REG_DATA_87_LSB                                             0
#define DBI_WINDOW_REG_DATA_87_MSB                                             31
#define DBI_WINDOW_REG_DATA_87_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_87_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_87_MASK) >> DBI_WINDOW_REG_DATA_87_LSB)
#define DBI_WINDOW_REG_DATA_87_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_87_LSB) & DBI_WINDOW_REG_DATA_87_MASK)
#define DBI_WINDOW_REG_DATA_87_RESET                                           0x0
#define DBI_WINDOW_REG_87_ADDRESS                                              (0x15c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_87_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_87_RESET                                                0x0

// 0x160 (DBI_WINDOW_REG_88)
#define DBI_WINDOW_REG_DATA_88_LSB                                             0
#define DBI_WINDOW_REG_DATA_88_MSB                                             31
#define DBI_WINDOW_REG_DATA_88_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_88_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_88_MASK) >> DBI_WINDOW_REG_DATA_88_LSB)
#define DBI_WINDOW_REG_DATA_88_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_88_LSB) & DBI_WINDOW_REG_DATA_88_MASK)
#define DBI_WINDOW_REG_DATA_88_RESET                                           0x0
#define DBI_WINDOW_REG_88_ADDRESS                                              (0x160 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_88_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_88_RESET                                                0x0

// 0x164 (DBI_WINDOW_REG_89)
#define DBI_WINDOW_REG_DATA_89_LSB                                             0
#define DBI_WINDOW_REG_DATA_89_MSB                                             31
#define DBI_WINDOW_REG_DATA_89_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_89_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_89_MASK) >> DBI_WINDOW_REG_DATA_89_LSB)
#define DBI_WINDOW_REG_DATA_89_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_89_LSB) & DBI_WINDOW_REG_DATA_89_MASK)
#define DBI_WINDOW_REG_DATA_89_RESET                                           0x0
#define DBI_WINDOW_REG_89_ADDRESS                                              (0x164 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_89_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_89_RESET                                                0x0

// 0x168 (DBI_WINDOW_REG_90)
#define DBI_WINDOW_REG_DATA_90_LSB                                             0
#define DBI_WINDOW_REG_DATA_90_MSB                                             31
#define DBI_WINDOW_REG_DATA_90_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_90_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_90_MASK) >> DBI_WINDOW_REG_DATA_90_LSB)
#define DBI_WINDOW_REG_DATA_90_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_90_LSB) & DBI_WINDOW_REG_DATA_90_MASK)
#define DBI_WINDOW_REG_DATA_90_RESET                                           0x0
#define DBI_WINDOW_REG_90_ADDRESS                                              (0x168 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_90_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_90_RESET                                                0x0

// 0x16c (DBI_WINDOW_REG_91)
#define DBI_WINDOW_REG_DATA_91_LSB                                             0
#define DBI_WINDOW_REG_DATA_91_MSB                                             31
#define DBI_WINDOW_REG_DATA_91_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_91_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_91_MASK) >> DBI_WINDOW_REG_DATA_91_LSB)
#define DBI_WINDOW_REG_DATA_91_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_91_LSB) & DBI_WINDOW_REG_DATA_91_MASK)
#define DBI_WINDOW_REG_DATA_91_RESET                                           0x0
#define DBI_WINDOW_REG_91_ADDRESS                                              (0x16c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_91_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_91_RESET                                                0x0

// 0x170 (DBI_WINDOW_REG_92)
#define DBI_WINDOW_REG_DATA_92_LSB                                             0
#define DBI_WINDOW_REG_DATA_92_MSB                                             31
#define DBI_WINDOW_REG_DATA_92_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_92_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_92_MASK) >> DBI_WINDOW_REG_DATA_92_LSB)
#define DBI_WINDOW_REG_DATA_92_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_92_LSB) & DBI_WINDOW_REG_DATA_92_MASK)
#define DBI_WINDOW_REG_DATA_92_RESET                                           0x0
#define DBI_WINDOW_REG_92_ADDRESS                                              (0x170 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_92_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_92_RESET                                                0x0

// 0x174 (DBI_WINDOW_REG_93)
#define DBI_WINDOW_REG_DATA_93_LSB                                             0
#define DBI_WINDOW_REG_DATA_93_MSB                                             31
#define DBI_WINDOW_REG_DATA_93_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_93_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_93_MASK) >> DBI_WINDOW_REG_DATA_93_LSB)
#define DBI_WINDOW_REG_DATA_93_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_93_LSB) & DBI_WINDOW_REG_DATA_93_MASK)
#define DBI_WINDOW_REG_DATA_93_RESET                                           0x0
#define DBI_WINDOW_REG_93_ADDRESS                                              (0x174 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_93_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_93_RESET                                                0x0

// 0x178 (DBI_WINDOW_REG_94)
#define DBI_WINDOW_REG_DATA_94_LSB                                             0
#define DBI_WINDOW_REG_DATA_94_MSB                                             31
#define DBI_WINDOW_REG_DATA_94_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_94_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_94_MASK) >> DBI_WINDOW_REG_DATA_94_LSB)
#define DBI_WINDOW_REG_DATA_94_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_94_LSB) & DBI_WINDOW_REG_DATA_94_MASK)
#define DBI_WINDOW_REG_DATA_94_RESET                                           0x0
#define DBI_WINDOW_REG_94_ADDRESS                                              (0x178 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_94_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_94_RESET                                                0x0

// 0x17c (DBI_WINDOW_REG_95)
#define DBI_WINDOW_REG_DATA_95_LSB                                             0
#define DBI_WINDOW_REG_DATA_95_MSB                                             31
#define DBI_WINDOW_REG_DATA_95_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_95_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_95_MASK) >> DBI_WINDOW_REG_DATA_95_LSB)
#define DBI_WINDOW_REG_DATA_95_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_95_LSB) & DBI_WINDOW_REG_DATA_95_MASK)
#define DBI_WINDOW_REG_DATA_95_RESET                                           0x0
#define DBI_WINDOW_REG_95_ADDRESS                                              (0x17c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_95_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_95_RESET                                                0x0

// 0x180 (DBI_WINDOW_REG_96)
#define DBI_WINDOW_REG_DATA_96_LSB                                             0
#define DBI_WINDOW_REG_DATA_96_MSB                                             31
#define DBI_WINDOW_REG_DATA_96_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_96_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_96_MASK) >> DBI_WINDOW_REG_DATA_96_LSB)
#define DBI_WINDOW_REG_DATA_96_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_96_LSB) & DBI_WINDOW_REG_DATA_96_MASK)
#define DBI_WINDOW_REG_DATA_96_RESET                                           0x0
#define DBI_WINDOW_REG_96_ADDRESS                                              (0x180 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_96_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_96_RESET                                                0x0

// 0x184 (DBI_WINDOW_REG_97)
#define DBI_WINDOW_REG_DATA_97_LSB                                             0
#define DBI_WINDOW_REG_DATA_97_MSB                                             31
#define DBI_WINDOW_REG_DATA_97_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_97_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_97_MASK) >> DBI_WINDOW_REG_DATA_97_LSB)
#define DBI_WINDOW_REG_DATA_97_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_97_LSB) & DBI_WINDOW_REG_DATA_97_MASK)
#define DBI_WINDOW_REG_DATA_97_RESET                                           0x0
#define DBI_WINDOW_REG_97_ADDRESS                                              (0x184 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_97_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_97_RESET                                                0x0

// 0x188 (DBI_WINDOW_REG_98)
#define DBI_WINDOW_REG_DATA_98_LSB                                             0
#define DBI_WINDOW_REG_DATA_98_MSB                                             31
#define DBI_WINDOW_REG_DATA_98_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_98_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_98_MASK) >> DBI_WINDOW_REG_DATA_98_LSB)
#define DBI_WINDOW_REG_DATA_98_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_98_LSB) & DBI_WINDOW_REG_DATA_98_MASK)
#define DBI_WINDOW_REG_DATA_98_RESET                                           0x0
#define DBI_WINDOW_REG_98_ADDRESS                                              (0x188 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_98_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_98_RESET                                                0x0

// 0x18c (DBI_WINDOW_REG_99)
#define DBI_WINDOW_REG_DATA_99_LSB                                             0
#define DBI_WINDOW_REG_DATA_99_MSB                                             31
#define DBI_WINDOW_REG_DATA_99_MASK                                            0xffffffff
#define DBI_WINDOW_REG_DATA_99_GET(x)                                          (((x) & DBI_WINDOW_REG_DATA_99_MASK) >> DBI_WINDOW_REG_DATA_99_LSB)
#define DBI_WINDOW_REG_DATA_99_SET(x)                                          (((0 | (x)) << DBI_WINDOW_REG_DATA_99_LSB) & DBI_WINDOW_REG_DATA_99_MASK)
#define DBI_WINDOW_REG_DATA_99_RESET                                           0x0
#define DBI_WINDOW_REG_99_ADDRESS                                              (0x18c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_99_RSTMASK                                              0xffffffff
#define DBI_WINDOW_REG_99_RESET                                                0x0

// 0x190 (DBI_WINDOW_REG_100)
#define DBI_WINDOW_REG_DATA_100_LSB                                            0
#define DBI_WINDOW_REG_DATA_100_MSB                                            31
#define DBI_WINDOW_REG_DATA_100_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_100_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_100_MASK) >> DBI_WINDOW_REG_DATA_100_LSB)
#define DBI_WINDOW_REG_DATA_100_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_100_LSB) & DBI_WINDOW_REG_DATA_100_MASK)
#define DBI_WINDOW_REG_DATA_100_RESET                                          0x0
#define DBI_WINDOW_REG_100_ADDRESS                                             (0x190 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_100_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_100_RESET                                               0x0

// 0x194 (DBI_WINDOW_REG_101)
#define DBI_WINDOW_REG_DATA_101_LSB                                            0
#define DBI_WINDOW_REG_DATA_101_MSB                                            31
#define DBI_WINDOW_REG_DATA_101_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_101_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_101_MASK) >> DBI_WINDOW_REG_DATA_101_LSB)
#define DBI_WINDOW_REG_DATA_101_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_101_LSB) & DBI_WINDOW_REG_DATA_101_MASK)
#define DBI_WINDOW_REG_DATA_101_RESET                                          0x0
#define DBI_WINDOW_REG_101_ADDRESS                                             (0x194 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_101_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_101_RESET                                               0x0

// 0x198 (DBI_WINDOW_REG_102)
#define DBI_WINDOW_REG_DATA_102_LSB                                            0
#define DBI_WINDOW_REG_DATA_102_MSB                                            31
#define DBI_WINDOW_REG_DATA_102_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_102_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_102_MASK) >> DBI_WINDOW_REG_DATA_102_LSB)
#define DBI_WINDOW_REG_DATA_102_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_102_LSB) & DBI_WINDOW_REG_DATA_102_MASK)
#define DBI_WINDOW_REG_DATA_102_RESET                                          0x0
#define DBI_WINDOW_REG_102_ADDRESS                                             (0x198 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_102_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_102_RESET                                               0x0

// 0x19c (DBI_WINDOW_REG_103)
#define DBI_WINDOW_REG_DATA_103_LSB                                            0
#define DBI_WINDOW_REG_DATA_103_MSB                                            31
#define DBI_WINDOW_REG_DATA_103_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_103_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_103_MASK) >> DBI_WINDOW_REG_DATA_103_LSB)
#define DBI_WINDOW_REG_DATA_103_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_103_LSB) & DBI_WINDOW_REG_DATA_103_MASK)
#define DBI_WINDOW_REG_DATA_103_RESET                                          0x0
#define DBI_WINDOW_REG_103_ADDRESS                                             (0x19c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_103_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_103_RESET                                               0x0

// 0x1a0 (DBI_WINDOW_REG_104)
#define DBI_WINDOW_REG_DATA_104_LSB                                            0
#define DBI_WINDOW_REG_DATA_104_MSB                                            31
#define DBI_WINDOW_REG_DATA_104_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_104_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_104_MASK) >> DBI_WINDOW_REG_DATA_104_LSB)
#define DBI_WINDOW_REG_DATA_104_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_104_LSB) & DBI_WINDOW_REG_DATA_104_MASK)
#define DBI_WINDOW_REG_DATA_104_RESET                                          0x0
#define DBI_WINDOW_REG_104_ADDRESS                                             (0x1a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_104_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_104_RESET                                               0x0

// 0x1a4 (DBI_WINDOW_REG_105)
#define DBI_WINDOW_REG_DATA_105_LSB                                            0
#define DBI_WINDOW_REG_DATA_105_MSB                                            31
#define DBI_WINDOW_REG_DATA_105_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_105_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_105_MASK) >> DBI_WINDOW_REG_DATA_105_LSB)
#define DBI_WINDOW_REG_DATA_105_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_105_LSB) & DBI_WINDOW_REG_DATA_105_MASK)
#define DBI_WINDOW_REG_DATA_105_RESET                                          0x0
#define DBI_WINDOW_REG_105_ADDRESS                                             (0x1a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_105_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_105_RESET                                               0x0

// 0x1a8 (DBI_WINDOW_REG_106)
#define DBI_WINDOW_REG_DATA_106_LSB                                            0
#define DBI_WINDOW_REG_DATA_106_MSB                                            31
#define DBI_WINDOW_REG_DATA_106_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_106_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_106_MASK) >> DBI_WINDOW_REG_DATA_106_LSB)
#define DBI_WINDOW_REG_DATA_106_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_106_LSB) & DBI_WINDOW_REG_DATA_106_MASK)
#define DBI_WINDOW_REG_DATA_106_RESET                                          0x0
#define DBI_WINDOW_REG_106_ADDRESS                                             (0x1a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_106_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_106_RESET                                               0x0

// 0x1ac (DBI_WINDOW_REG_107)
#define DBI_WINDOW_REG_DATA_107_LSB                                            0
#define DBI_WINDOW_REG_DATA_107_MSB                                            31
#define DBI_WINDOW_REG_DATA_107_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_107_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_107_MASK) >> DBI_WINDOW_REG_DATA_107_LSB)
#define DBI_WINDOW_REG_DATA_107_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_107_LSB) & DBI_WINDOW_REG_DATA_107_MASK)
#define DBI_WINDOW_REG_DATA_107_RESET                                          0x0
#define DBI_WINDOW_REG_107_ADDRESS                                             (0x1ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_107_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_107_RESET                                               0x0

// 0x1b0 (DBI_WINDOW_REG_108)
#define DBI_WINDOW_REG_DATA_108_LSB                                            0
#define DBI_WINDOW_REG_DATA_108_MSB                                            31
#define DBI_WINDOW_REG_DATA_108_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_108_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_108_MASK) >> DBI_WINDOW_REG_DATA_108_LSB)
#define DBI_WINDOW_REG_DATA_108_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_108_LSB) & DBI_WINDOW_REG_DATA_108_MASK)
#define DBI_WINDOW_REG_DATA_108_RESET                                          0x0
#define DBI_WINDOW_REG_108_ADDRESS                                             (0x1b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_108_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_108_RESET                                               0x0

// 0x1b4 (DBI_WINDOW_REG_109)
#define DBI_WINDOW_REG_DATA_109_LSB                                            0
#define DBI_WINDOW_REG_DATA_109_MSB                                            31
#define DBI_WINDOW_REG_DATA_109_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_109_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_109_MASK) >> DBI_WINDOW_REG_DATA_109_LSB)
#define DBI_WINDOW_REG_DATA_109_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_109_LSB) & DBI_WINDOW_REG_DATA_109_MASK)
#define DBI_WINDOW_REG_DATA_109_RESET                                          0x0
#define DBI_WINDOW_REG_109_ADDRESS                                             (0x1b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_109_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_109_RESET                                               0x0

// 0x1b8 (DBI_WINDOW_REG_110)
#define DBI_WINDOW_REG_DATA_110_LSB                                            0
#define DBI_WINDOW_REG_DATA_110_MSB                                            31
#define DBI_WINDOW_REG_DATA_110_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_110_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_110_MASK) >> DBI_WINDOW_REG_DATA_110_LSB)
#define DBI_WINDOW_REG_DATA_110_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_110_LSB) & DBI_WINDOW_REG_DATA_110_MASK)
#define DBI_WINDOW_REG_DATA_110_RESET                                          0x0
#define DBI_WINDOW_REG_110_ADDRESS                                             (0x1b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_110_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_110_RESET                                               0x0

// 0x1bc (DBI_WINDOW_REG_111)
#define DBI_WINDOW_REG_DATA_111_LSB                                            0
#define DBI_WINDOW_REG_DATA_111_MSB                                            31
#define DBI_WINDOW_REG_DATA_111_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_111_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_111_MASK) >> DBI_WINDOW_REG_DATA_111_LSB)
#define DBI_WINDOW_REG_DATA_111_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_111_LSB) & DBI_WINDOW_REG_DATA_111_MASK)
#define DBI_WINDOW_REG_DATA_111_RESET                                          0x0
#define DBI_WINDOW_REG_111_ADDRESS                                             (0x1bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_111_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_111_RESET                                               0x0

// 0x1c0 (DBI_WINDOW_REG_112)
#define DBI_WINDOW_REG_DATA_112_LSB                                            0
#define DBI_WINDOW_REG_DATA_112_MSB                                            31
#define DBI_WINDOW_REG_DATA_112_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_112_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_112_MASK) >> DBI_WINDOW_REG_DATA_112_LSB)
#define DBI_WINDOW_REG_DATA_112_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_112_LSB) & DBI_WINDOW_REG_DATA_112_MASK)
#define DBI_WINDOW_REG_DATA_112_RESET                                          0x0
#define DBI_WINDOW_REG_112_ADDRESS                                             (0x1c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_112_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_112_RESET                                               0x0

// 0x1c4 (DBI_WINDOW_REG_113)
#define DBI_WINDOW_REG_DATA_113_LSB                                            0
#define DBI_WINDOW_REG_DATA_113_MSB                                            31
#define DBI_WINDOW_REG_DATA_113_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_113_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_113_MASK) >> DBI_WINDOW_REG_DATA_113_LSB)
#define DBI_WINDOW_REG_DATA_113_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_113_LSB) & DBI_WINDOW_REG_DATA_113_MASK)
#define DBI_WINDOW_REG_DATA_113_RESET                                          0x0
#define DBI_WINDOW_REG_113_ADDRESS                                             (0x1c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_113_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_113_RESET                                               0x0

// 0x1c8 (DBI_WINDOW_REG_114)
#define DBI_WINDOW_REG_DATA_114_LSB                                            0
#define DBI_WINDOW_REG_DATA_114_MSB                                            31
#define DBI_WINDOW_REG_DATA_114_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_114_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_114_MASK) >> DBI_WINDOW_REG_DATA_114_LSB)
#define DBI_WINDOW_REG_DATA_114_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_114_LSB) & DBI_WINDOW_REG_DATA_114_MASK)
#define DBI_WINDOW_REG_DATA_114_RESET                                          0x0
#define DBI_WINDOW_REG_114_ADDRESS                                             (0x1c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_114_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_114_RESET                                               0x0

// 0x1cc (DBI_WINDOW_REG_115)
#define DBI_WINDOW_REG_DATA_115_LSB                                            0
#define DBI_WINDOW_REG_DATA_115_MSB                                            31
#define DBI_WINDOW_REG_DATA_115_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_115_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_115_MASK) >> DBI_WINDOW_REG_DATA_115_LSB)
#define DBI_WINDOW_REG_DATA_115_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_115_LSB) & DBI_WINDOW_REG_DATA_115_MASK)
#define DBI_WINDOW_REG_DATA_115_RESET                                          0x0
#define DBI_WINDOW_REG_115_ADDRESS                                             (0x1cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_115_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_115_RESET                                               0x0

// 0x1d0 (DBI_WINDOW_REG_116)
#define DBI_WINDOW_REG_DATA_116_LSB                                            0
#define DBI_WINDOW_REG_DATA_116_MSB                                            31
#define DBI_WINDOW_REG_DATA_116_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_116_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_116_MASK) >> DBI_WINDOW_REG_DATA_116_LSB)
#define DBI_WINDOW_REG_DATA_116_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_116_LSB) & DBI_WINDOW_REG_DATA_116_MASK)
#define DBI_WINDOW_REG_DATA_116_RESET                                          0x0
#define DBI_WINDOW_REG_116_ADDRESS                                             (0x1d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_116_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_116_RESET                                               0x0

// 0x1d4 (DBI_WINDOW_REG_117)
#define DBI_WINDOW_REG_DATA_117_LSB                                            0
#define DBI_WINDOW_REG_DATA_117_MSB                                            31
#define DBI_WINDOW_REG_DATA_117_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_117_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_117_MASK) >> DBI_WINDOW_REG_DATA_117_LSB)
#define DBI_WINDOW_REG_DATA_117_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_117_LSB) & DBI_WINDOW_REG_DATA_117_MASK)
#define DBI_WINDOW_REG_DATA_117_RESET                                          0x0
#define DBI_WINDOW_REG_117_ADDRESS                                             (0x1d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_117_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_117_RESET                                               0x0

// 0x1d8 (DBI_WINDOW_REG_118)
#define DBI_WINDOW_REG_DATA_118_LSB                                            0
#define DBI_WINDOW_REG_DATA_118_MSB                                            31
#define DBI_WINDOW_REG_DATA_118_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_118_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_118_MASK) >> DBI_WINDOW_REG_DATA_118_LSB)
#define DBI_WINDOW_REG_DATA_118_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_118_LSB) & DBI_WINDOW_REG_DATA_118_MASK)
#define DBI_WINDOW_REG_DATA_118_RESET                                          0x0
#define DBI_WINDOW_REG_118_ADDRESS                                             (0x1d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_118_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_118_RESET                                               0x0

// 0x1dc (DBI_WINDOW_REG_119)
#define DBI_WINDOW_REG_DATA_119_LSB                                            0
#define DBI_WINDOW_REG_DATA_119_MSB                                            31
#define DBI_WINDOW_REG_DATA_119_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_119_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_119_MASK) >> DBI_WINDOW_REG_DATA_119_LSB)
#define DBI_WINDOW_REG_DATA_119_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_119_LSB) & DBI_WINDOW_REG_DATA_119_MASK)
#define DBI_WINDOW_REG_DATA_119_RESET                                          0x0
#define DBI_WINDOW_REG_119_ADDRESS                                             (0x1dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_119_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_119_RESET                                               0x0

// 0x1e0 (DBI_WINDOW_REG_120)
#define DBI_WINDOW_REG_DATA_120_LSB                                            0
#define DBI_WINDOW_REG_DATA_120_MSB                                            31
#define DBI_WINDOW_REG_DATA_120_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_120_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_120_MASK) >> DBI_WINDOW_REG_DATA_120_LSB)
#define DBI_WINDOW_REG_DATA_120_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_120_LSB) & DBI_WINDOW_REG_DATA_120_MASK)
#define DBI_WINDOW_REG_DATA_120_RESET                                          0x0
#define DBI_WINDOW_REG_120_ADDRESS                                             (0x1e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_120_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_120_RESET                                               0x0

// 0x1e4 (DBI_WINDOW_REG_121)
#define DBI_WINDOW_REG_DATA_121_LSB                                            0
#define DBI_WINDOW_REG_DATA_121_MSB                                            31
#define DBI_WINDOW_REG_DATA_121_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_121_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_121_MASK) >> DBI_WINDOW_REG_DATA_121_LSB)
#define DBI_WINDOW_REG_DATA_121_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_121_LSB) & DBI_WINDOW_REG_DATA_121_MASK)
#define DBI_WINDOW_REG_DATA_121_RESET                                          0x0
#define DBI_WINDOW_REG_121_ADDRESS                                             (0x1e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_121_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_121_RESET                                               0x0

// 0x1e8 (DBI_WINDOW_REG_122)
#define DBI_WINDOW_REG_DATA_122_LSB                                            0
#define DBI_WINDOW_REG_DATA_122_MSB                                            31
#define DBI_WINDOW_REG_DATA_122_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_122_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_122_MASK) >> DBI_WINDOW_REG_DATA_122_LSB)
#define DBI_WINDOW_REG_DATA_122_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_122_LSB) & DBI_WINDOW_REG_DATA_122_MASK)
#define DBI_WINDOW_REG_DATA_122_RESET                                          0x0
#define DBI_WINDOW_REG_122_ADDRESS                                             (0x1e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_122_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_122_RESET                                               0x0

// 0x1ec (DBI_WINDOW_REG_123)
#define DBI_WINDOW_REG_DATA_123_LSB                                            0
#define DBI_WINDOW_REG_DATA_123_MSB                                            31
#define DBI_WINDOW_REG_DATA_123_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_123_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_123_MASK) >> DBI_WINDOW_REG_DATA_123_LSB)
#define DBI_WINDOW_REG_DATA_123_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_123_LSB) & DBI_WINDOW_REG_DATA_123_MASK)
#define DBI_WINDOW_REG_DATA_123_RESET                                          0x0
#define DBI_WINDOW_REG_123_ADDRESS                                             (0x1ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_123_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_123_RESET                                               0x0

// 0x1f0 (DBI_WINDOW_REG_124)
#define DBI_WINDOW_REG_DATA_124_LSB                                            0
#define DBI_WINDOW_REG_DATA_124_MSB                                            31
#define DBI_WINDOW_REG_DATA_124_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_124_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_124_MASK) >> DBI_WINDOW_REG_DATA_124_LSB)
#define DBI_WINDOW_REG_DATA_124_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_124_LSB) & DBI_WINDOW_REG_DATA_124_MASK)
#define DBI_WINDOW_REG_DATA_124_RESET                                          0x0
#define DBI_WINDOW_REG_124_ADDRESS                                             (0x1f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_124_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_124_RESET                                               0x0

// 0x1f4 (DBI_WINDOW_REG_125)
#define DBI_WINDOW_REG_DATA_125_LSB                                            0
#define DBI_WINDOW_REG_DATA_125_MSB                                            31
#define DBI_WINDOW_REG_DATA_125_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_125_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_125_MASK) >> DBI_WINDOW_REG_DATA_125_LSB)
#define DBI_WINDOW_REG_DATA_125_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_125_LSB) & DBI_WINDOW_REG_DATA_125_MASK)
#define DBI_WINDOW_REG_DATA_125_RESET                                          0x0
#define DBI_WINDOW_REG_125_ADDRESS                                             (0x1f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_125_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_125_RESET                                               0x0

// 0x1f8 (DBI_WINDOW_REG_126)
#define DBI_WINDOW_REG_DATA_126_LSB                                            0
#define DBI_WINDOW_REG_DATA_126_MSB                                            31
#define DBI_WINDOW_REG_DATA_126_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_126_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_126_MASK) >> DBI_WINDOW_REG_DATA_126_LSB)
#define DBI_WINDOW_REG_DATA_126_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_126_LSB) & DBI_WINDOW_REG_DATA_126_MASK)
#define DBI_WINDOW_REG_DATA_126_RESET                                          0x0
#define DBI_WINDOW_REG_126_ADDRESS                                             (0x1f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_126_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_126_RESET                                               0x0

// 0x1fc (DBI_WINDOW_REG_127)
#define DBI_WINDOW_REG_DATA_127_LSB                                            0
#define DBI_WINDOW_REG_DATA_127_MSB                                            31
#define DBI_WINDOW_REG_DATA_127_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_127_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_127_MASK) >> DBI_WINDOW_REG_DATA_127_LSB)
#define DBI_WINDOW_REG_DATA_127_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_127_LSB) & DBI_WINDOW_REG_DATA_127_MASK)
#define DBI_WINDOW_REG_DATA_127_RESET                                          0x0
#define DBI_WINDOW_REG_127_ADDRESS                                             (0x1fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_127_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_127_RESET                                               0x0

// 0x200 (DBI_WINDOW_REG_128)
#define DBI_WINDOW_REG_DATA_128_LSB                                            0
#define DBI_WINDOW_REG_DATA_128_MSB                                            31
#define DBI_WINDOW_REG_DATA_128_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_128_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_128_MASK) >> DBI_WINDOW_REG_DATA_128_LSB)
#define DBI_WINDOW_REG_DATA_128_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_128_LSB) & DBI_WINDOW_REG_DATA_128_MASK)
#define DBI_WINDOW_REG_DATA_128_RESET                                          0x0
#define DBI_WINDOW_REG_128_ADDRESS                                             (0x200 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_128_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_128_RESET                                               0x0

// 0x204 (DBI_WINDOW_REG_129)
#define DBI_WINDOW_REG_DATA_129_LSB                                            0
#define DBI_WINDOW_REG_DATA_129_MSB                                            31
#define DBI_WINDOW_REG_DATA_129_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_129_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_129_MASK) >> DBI_WINDOW_REG_DATA_129_LSB)
#define DBI_WINDOW_REG_DATA_129_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_129_LSB) & DBI_WINDOW_REG_DATA_129_MASK)
#define DBI_WINDOW_REG_DATA_129_RESET                                          0x0
#define DBI_WINDOW_REG_129_ADDRESS                                             (0x204 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_129_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_129_RESET                                               0x0

// 0x208 (DBI_WINDOW_REG_130)
#define DBI_WINDOW_REG_DATA_130_LSB                                            0
#define DBI_WINDOW_REG_DATA_130_MSB                                            31
#define DBI_WINDOW_REG_DATA_130_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_130_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_130_MASK) >> DBI_WINDOW_REG_DATA_130_LSB)
#define DBI_WINDOW_REG_DATA_130_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_130_LSB) & DBI_WINDOW_REG_DATA_130_MASK)
#define DBI_WINDOW_REG_DATA_130_RESET                                          0x0
#define DBI_WINDOW_REG_130_ADDRESS                                             (0x208 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_130_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_130_RESET                                               0x0

// 0x20c (DBI_WINDOW_REG_131)
#define DBI_WINDOW_REG_DATA_131_LSB                                            0
#define DBI_WINDOW_REG_DATA_131_MSB                                            31
#define DBI_WINDOW_REG_DATA_131_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_131_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_131_MASK) >> DBI_WINDOW_REG_DATA_131_LSB)
#define DBI_WINDOW_REG_DATA_131_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_131_LSB) & DBI_WINDOW_REG_DATA_131_MASK)
#define DBI_WINDOW_REG_DATA_131_RESET                                          0x0
#define DBI_WINDOW_REG_131_ADDRESS                                             (0x20c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_131_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_131_RESET                                               0x0

// 0x210 (DBI_WINDOW_REG_132)
#define DBI_WINDOW_REG_DATA_132_LSB                                            0
#define DBI_WINDOW_REG_DATA_132_MSB                                            31
#define DBI_WINDOW_REG_DATA_132_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_132_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_132_MASK) >> DBI_WINDOW_REG_DATA_132_LSB)
#define DBI_WINDOW_REG_DATA_132_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_132_LSB) & DBI_WINDOW_REG_DATA_132_MASK)
#define DBI_WINDOW_REG_DATA_132_RESET                                          0x0
#define DBI_WINDOW_REG_132_ADDRESS                                             (0x210 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_132_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_132_RESET                                               0x0

// 0x214 (DBI_WINDOW_REG_133)
#define DBI_WINDOW_REG_DATA_133_LSB                                            0
#define DBI_WINDOW_REG_DATA_133_MSB                                            31
#define DBI_WINDOW_REG_DATA_133_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_133_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_133_MASK) >> DBI_WINDOW_REG_DATA_133_LSB)
#define DBI_WINDOW_REG_DATA_133_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_133_LSB) & DBI_WINDOW_REG_DATA_133_MASK)
#define DBI_WINDOW_REG_DATA_133_RESET                                          0x0
#define DBI_WINDOW_REG_133_ADDRESS                                             (0x214 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_133_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_133_RESET                                               0x0

// 0x218 (DBI_WINDOW_REG_134)
#define DBI_WINDOW_REG_DATA_134_LSB                                            0
#define DBI_WINDOW_REG_DATA_134_MSB                                            31
#define DBI_WINDOW_REG_DATA_134_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_134_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_134_MASK) >> DBI_WINDOW_REG_DATA_134_LSB)
#define DBI_WINDOW_REG_DATA_134_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_134_LSB) & DBI_WINDOW_REG_DATA_134_MASK)
#define DBI_WINDOW_REG_DATA_134_RESET                                          0x0
#define DBI_WINDOW_REG_134_ADDRESS                                             (0x218 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_134_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_134_RESET                                               0x0

// 0x21c (DBI_WINDOW_REG_135)
#define DBI_WINDOW_REG_DATA_135_LSB                                            0
#define DBI_WINDOW_REG_DATA_135_MSB                                            31
#define DBI_WINDOW_REG_DATA_135_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_135_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_135_MASK) >> DBI_WINDOW_REG_DATA_135_LSB)
#define DBI_WINDOW_REG_DATA_135_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_135_LSB) & DBI_WINDOW_REG_DATA_135_MASK)
#define DBI_WINDOW_REG_DATA_135_RESET                                          0x0
#define DBI_WINDOW_REG_135_ADDRESS                                             (0x21c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_135_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_135_RESET                                               0x0

// 0x220 (DBI_WINDOW_REG_136)
#define DBI_WINDOW_REG_DATA_136_LSB                                            0
#define DBI_WINDOW_REG_DATA_136_MSB                                            31
#define DBI_WINDOW_REG_DATA_136_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_136_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_136_MASK) >> DBI_WINDOW_REG_DATA_136_LSB)
#define DBI_WINDOW_REG_DATA_136_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_136_LSB) & DBI_WINDOW_REG_DATA_136_MASK)
#define DBI_WINDOW_REG_DATA_136_RESET                                          0x0
#define DBI_WINDOW_REG_136_ADDRESS                                             (0x220 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_136_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_136_RESET                                               0x0

// 0x224 (DBI_WINDOW_REG_137)
#define DBI_WINDOW_REG_DATA_137_LSB                                            0
#define DBI_WINDOW_REG_DATA_137_MSB                                            31
#define DBI_WINDOW_REG_DATA_137_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_137_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_137_MASK) >> DBI_WINDOW_REG_DATA_137_LSB)
#define DBI_WINDOW_REG_DATA_137_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_137_LSB) & DBI_WINDOW_REG_DATA_137_MASK)
#define DBI_WINDOW_REG_DATA_137_RESET                                          0x0
#define DBI_WINDOW_REG_137_ADDRESS                                             (0x224 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_137_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_137_RESET                                               0x0

// 0x228 (DBI_WINDOW_REG_138)
#define DBI_WINDOW_REG_DATA_138_LSB                                            0
#define DBI_WINDOW_REG_DATA_138_MSB                                            31
#define DBI_WINDOW_REG_DATA_138_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_138_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_138_MASK) >> DBI_WINDOW_REG_DATA_138_LSB)
#define DBI_WINDOW_REG_DATA_138_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_138_LSB) & DBI_WINDOW_REG_DATA_138_MASK)
#define DBI_WINDOW_REG_DATA_138_RESET                                          0x0
#define DBI_WINDOW_REG_138_ADDRESS                                             (0x228 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_138_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_138_RESET                                               0x0

// 0x22c (DBI_WINDOW_REG_139)
#define DBI_WINDOW_REG_DATA_139_LSB                                            0
#define DBI_WINDOW_REG_DATA_139_MSB                                            31
#define DBI_WINDOW_REG_DATA_139_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_139_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_139_MASK) >> DBI_WINDOW_REG_DATA_139_LSB)
#define DBI_WINDOW_REG_DATA_139_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_139_LSB) & DBI_WINDOW_REG_DATA_139_MASK)
#define DBI_WINDOW_REG_DATA_139_RESET                                          0x0
#define DBI_WINDOW_REG_139_ADDRESS                                             (0x22c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_139_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_139_RESET                                               0x0

// 0x230 (DBI_WINDOW_REG_140)
#define DBI_WINDOW_REG_DATA_140_LSB                                            0
#define DBI_WINDOW_REG_DATA_140_MSB                                            31
#define DBI_WINDOW_REG_DATA_140_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_140_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_140_MASK) >> DBI_WINDOW_REG_DATA_140_LSB)
#define DBI_WINDOW_REG_DATA_140_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_140_LSB) & DBI_WINDOW_REG_DATA_140_MASK)
#define DBI_WINDOW_REG_DATA_140_RESET                                          0x0
#define DBI_WINDOW_REG_140_ADDRESS                                             (0x230 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_140_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_140_RESET                                               0x0

// 0x234 (DBI_WINDOW_REG_141)
#define DBI_WINDOW_REG_DATA_141_LSB                                            0
#define DBI_WINDOW_REG_DATA_141_MSB                                            31
#define DBI_WINDOW_REG_DATA_141_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_141_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_141_MASK) >> DBI_WINDOW_REG_DATA_141_LSB)
#define DBI_WINDOW_REG_DATA_141_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_141_LSB) & DBI_WINDOW_REG_DATA_141_MASK)
#define DBI_WINDOW_REG_DATA_141_RESET                                          0x0
#define DBI_WINDOW_REG_141_ADDRESS                                             (0x234 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_141_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_141_RESET                                               0x0

// 0x238 (DBI_WINDOW_REG_142)
#define DBI_WINDOW_REG_DATA_142_LSB                                            0
#define DBI_WINDOW_REG_DATA_142_MSB                                            31
#define DBI_WINDOW_REG_DATA_142_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_142_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_142_MASK) >> DBI_WINDOW_REG_DATA_142_LSB)
#define DBI_WINDOW_REG_DATA_142_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_142_LSB) & DBI_WINDOW_REG_DATA_142_MASK)
#define DBI_WINDOW_REG_DATA_142_RESET                                          0x0
#define DBI_WINDOW_REG_142_ADDRESS                                             (0x238 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_142_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_142_RESET                                               0x0

// 0x23c (DBI_WINDOW_REG_143)
#define DBI_WINDOW_REG_DATA_143_LSB                                            0
#define DBI_WINDOW_REG_DATA_143_MSB                                            31
#define DBI_WINDOW_REG_DATA_143_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_143_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_143_MASK) >> DBI_WINDOW_REG_DATA_143_LSB)
#define DBI_WINDOW_REG_DATA_143_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_143_LSB) & DBI_WINDOW_REG_DATA_143_MASK)
#define DBI_WINDOW_REG_DATA_143_RESET                                          0x0
#define DBI_WINDOW_REG_143_ADDRESS                                             (0x23c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_143_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_143_RESET                                               0x0

// 0x240 (DBI_WINDOW_REG_144)
#define DBI_WINDOW_REG_DATA_144_LSB                                            0
#define DBI_WINDOW_REG_DATA_144_MSB                                            31
#define DBI_WINDOW_REG_DATA_144_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_144_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_144_MASK) >> DBI_WINDOW_REG_DATA_144_LSB)
#define DBI_WINDOW_REG_DATA_144_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_144_LSB) & DBI_WINDOW_REG_DATA_144_MASK)
#define DBI_WINDOW_REG_DATA_144_RESET                                          0x0
#define DBI_WINDOW_REG_144_ADDRESS                                             (0x240 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_144_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_144_RESET                                               0x0

// 0x244 (DBI_WINDOW_REG_145)
#define DBI_WINDOW_REG_DATA_145_LSB                                            0
#define DBI_WINDOW_REG_DATA_145_MSB                                            31
#define DBI_WINDOW_REG_DATA_145_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_145_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_145_MASK) >> DBI_WINDOW_REG_DATA_145_LSB)
#define DBI_WINDOW_REG_DATA_145_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_145_LSB) & DBI_WINDOW_REG_DATA_145_MASK)
#define DBI_WINDOW_REG_DATA_145_RESET                                          0x0
#define DBI_WINDOW_REG_145_ADDRESS                                             (0x244 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_145_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_145_RESET                                               0x0

// 0x248 (DBI_WINDOW_REG_146)
#define DBI_WINDOW_REG_DATA_146_LSB                                            0
#define DBI_WINDOW_REG_DATA_146_MSB                                            31
#define DBI_WINDOW_REG_DATA_146_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_146_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_146_MASK) >> DBI_WINDOW_REG_DATA_146_LSB)
#define DBI_WINDOW_REG_DATA_146_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_146_LSB) & DBI_WINDOW_REG_DATA_146_MASK)
#define DBI_WINDOW_REG_DATA_146_RESET                                          0x0
#define DBI_WINDOW_REG_146_ADDRESS                                             (0x248 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_146_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_146_RESET                                               0x0

// 0x24c (DBI_WINDOW_REG_147)
#define DBI_WINDOW_REG_DATA_147_LSB                                            0
#define DBI_WINDOW_REG_DATA_147_MSB                                            31
#define DBI_WINDOW_REG_DATA_147_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_147_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_147_MASK) >> DBI_WINDOW_REG_DATA_147_LSB)
#define DBI_WINDOW_REG_DATA_147_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_147_LSB) & DBI_WINDOW_REG_DATA_147_MASK)
#define DBI_WINDOW_REG_DATA_147_RESET                                          0x0
#define DBI_WINDOW_REG_147_ADDRESS                                             (0x24c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_147_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_147_RESET                                               0x0

// 0x250 (DBI_WINDOW_REG_148)
#define DBI_WINDOW_REG_DATA_148_LSB                                            0
#define DBI_WINDOW_REG_DATA_148_MSB                                            31
#define DBI_WINDOW_REG_DATA_148_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_148_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_148_MASK) >> DBI_WINDOW_REG_DATA_148_LSB)
#define DBI_WINDOW_REG_DATA_148_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_148_LSB) & DBI_WINDOW_REG_DATA_148_MASK)
#define DBI_WINDOW_REG_DATA_148_RESET                                          0x0
#define DBI_WINDOW_REG_148_ADDRESS                                             (0x250 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_148_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_148_RESET                                               0x0

// 0x254 (DBI_WINDOW_REG_149)
#define DBI_WINDOW_REG_DATA_149_LSB                                            0
#define DBI_WINDOW_REG_DATA_149_MSB                                            31
#define DBI_WINDOW_REG_DATA_149_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_149_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_149_MASK) >> DBI_WINDOW_REG_DATA_149_LSB)
#define DBI_WINDOW_REG_DATA_149_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_149_LSB) & DBI_WINDOW_REG_DATA_149_MASK)
#define DBI_WINDOW_REG_DATA_149_RESET                                          0x0
#define DBI_WINDOW_REG_149_ADDRESS                                             (0x254 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_149_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_149_RESET                                               0x0

// 0x258 (DBI_WINDOW_REG_150)
#define DBI_WINDOW_REG_DATA_150_LSB                                            0
#define DBI_WINDOW_REG_DATA_150_MSB                                            31
#define DBI_WINDOW_REG_DATA_150_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_150_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_150_MASK) >> DBI_WINDOW_REG_DATA_150_LSB)
#define DBI_WINDOW_REG_DATA_150_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_150_LSB) & DBI_WINDOW_REG_DATA_150_MASK)
#define DBI_WINDOW_REG_DATA_150_RESET                                          0x0
#define DBI_WINDOW_REG_150_ADDRESS                                             (0x258 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_150_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_150_RESET                                               0x0

// 0x25c (DBI_WINDOW_REG_151)
#define DBI_WINDOW_REG_DATA_151_LSB                                            0
#define DBI_WINDOW_REG_DATA_151_MSB                                            31
#define DBI_WINDOW_REG_DATA_151_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_151_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_151_MASK) >> DBI_WINDOW_REG_DATA_151_LSB)
#define DBI_WINDOW_REG_DATA_151_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_151_LSB) & DBI_WINDOW_REG_DATA_151_MASK)
#define DBI_WINDOW_REG_DATA_151_RESET                                          0x0
#define DBI_WINDOW_REG_151_ADDRESS                                             (0x25c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_151_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_151_RESET                                               0x0

// 0x260 (DBI_WINDOW_REG_152)
#define DBI_WINDOW_REG_DATA_152_LSB                                            0
#define DBI_WINDOW_REG_DATA_152_MSB                                            31
#define DBI_WINDOW_REG_DATA_152_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_152_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_152_MASK) >> DBI_WINDOW_REG_DATA_152_LSB)
#define DBI_WINDOW_REG_DATA_152_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_152_LSB) & DBI_WINDOW_REG_DATA_152_MASK)
#define DBI_WINDOW_REG_DATA_152_RESET                                          0x0
#define DBI_WINDOW_REG_152_ADDRESS                                             (0x260 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_152_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_152_RESET                                               0x0

// 0x264 (DBI_WINDOW_REG_153)
#define DBI_WINDOW_REG_DATA_153_LSB                                            0
#define DBI_WINDOW_REG_DATA_153_MSB                                            31
#define DBI_WINDOW_REG_DATA_153_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_153_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_153_MASK) >> DBI_WINDOW_REG_DATA_153_LSB)
#define DBI_WINDOW_REG_DATA_153_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_153_LSB) & DBI_WINDOW_REG_DATA_153_MASK)
#define DBI_WINDOW_REG_DATA_153_RESET                                          0x0
#define DBI_WINDOW_REG_153_ADDRESS                                             (0x264 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_153_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_153_RESET                                               0x0

// 0x268 (DBI_WINDOW_REG_154)
#define DBI_WINDOW_REG_DATA_154_LSB                                            0
#define DBI_WINDOW_REG_DATA_154_MSB                                            31
#define DBI_WINDOW_REG_DATA_154_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_154_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_154_MASK) >> DBI_WINDOW_REG_DATA_154_LSB)
#define DBI_WINDOW_REG_DATA_154_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_154_LSB) & DBI_WINDOW_REG_DATA_154_MASK)
#define DBI_WINDOW_REG_DATA_154_RESET                                          0x0
#define DBI_WINDOW_REG_154_ADDRESS                                             (0x268 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_154_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_154_RESET                                               0x0

// 0x26c (DBI_WINDOW_REG_155)
#define DBI_WINDOW_REG_DATA_155_LSB                                            0
#define DBI_WINDOW_REG_DATA_155_MSB                                            31
#define DBI_WINDOW_REG_DATA_155_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_155_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_155_MASK) >> DBI_WINDOW_REG_DATA_155_LSB)
#define DBI_WINDOW_REG_DATA_155_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_155_LSB) & DBI_WINDOW_REG_DATA_155_MASK)
#define DBI_WINDOW_REG_DATA_155_RESET                                          0x0
#define DBI_WINDOW_REG_155_ADDRESS                                             (0x26c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_155_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_155_RESET                                               0x0

// 0x270 (DBI_WINDOW_REG_156)
#define DBI_WINDOW_REG_DATA_156_LSB                                            0
#define DBI_WINDOW_REG_DATA_156_MSB                                            31
#define DBI_WINDOW_REG_DATA_156_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_156_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_156_MASK) >> DBI_WINDOW_REG_DATA_156_LSB)
#define DBI_WINDOW_REG_DATA_156_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_156_LSB) & DBI_WINDOW_REG_DATA_156_MASK)
#define DBI_WINDOW_REG_DATA_156_RESET                                          0x0
#define DBI_WINDOW_REG_156_ADDRESS                                             (0x270 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_156_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_156_RESET                                               0x0

// 0x274 (DBI_WINDOW_REG_157)
#define DBI_WINDOW_REG_DATA_157_LSB                                            0
#define DBI_WINDOW_REG_DATA_157_MSB                                            31
#define DBI_WINDOW_REG_DATA_157_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_157_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_157_MASK) >> DBI_WINDOW_REG_DATA_157_LSB)
#define DBI_WINDOW_REG_DATA_157_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_157_LSB) & DBI_WINDOW_REG_DATA_157_MASK)
#define DBI_WINDOW_REG_DATA_157_RESET                                          0x0
#define DBI_WINDOW_REG_157_ADDRESS                                             (0x274 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_157_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_157_RESET                                               0x0

// 0x278 (DBI_WINDOW_REG_158)
#define DBI_WINDOW_REG_DATA_158_LSB                                            0
#define DBI_WINDOW_REG_DATA_158_MSB                                            31
#define DBI_WINDOW_REG_DATA_158_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_158_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_158_MASK) >> DBI_WINDOW_REG_DATA_158_LSB)
#define DBI_WINDOW_REG_DATA_158_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_158_LSB) & DBI_WINDOW_REG_DATA_158_MASK)
#define DBI_WINDOW_REG_DATA_158_RESET                                          0x0
#define DBI_WINDOW_REG_158_ADDRESS                                             (0x278 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_158_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_158_RESET                                               0x0

// 0x27c (DBI_WINDOW_REG_159)
#define DBI_WINDOW_REG_DATA_159_LSB                                            0
#define DBI_WINDOW_REG_DATA_159_MSB                                            31
#define DBI_WINDOW_REG_DATA_159_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_159_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_159_MASK) >> DBI_WINDOW_REG_DATA_159_LSB)
#define DBI_WINDOW_REG_DATA_159_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_159_LSB) & DBI_WINDOW_REG_DATA_159_MASK)
#define DBI_WINDOW_REG_DATA_159_RESET                                          0x0
#define DBI_WINDOW_REG_159_ADDRESS                                             (0x27c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_159_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_159_RESET                                               0x0

// 0x280 (DBI_WINDOW_REG_160)
#define DBI_WINDOW_REG_DATA_160_LSB                                            0
#define DBI_WINDOW_REG_DATA_160_MSB                                            31
#define DBI_WINDOW_REG_DATA_160_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_160_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_160_MASK) >> DBI_WINDOW_REG_DATA_160_LSB)
#define DBI_WINDOW_REG_DATA_160_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_160_LSB) & DBI_WINDOW_REG_DATA_160_MASK)
#define DBI_WINDOW_REG_DATA_160_RESET                                          0x0
#define DBI_WINDOW_REG_160_ADDRESS                                             (0x280 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_160_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_160_RESET                                               0x0

// 0x284 (DBI_WINDOW_REG_161)
#define DBI_WINDOW_REG_DATA_161_LSB                                            0
#define DBI_WINDOW_REG_DATA_161_MSB                                            31
#define DBI_WINDOW_REG_DATA_161_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_161_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_161_MASK) >> DBI_WINDOW_REG_DATA_161_LSB)
#define DBI_WINDOW_REG_DATA_161_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_161_LSB) & DBI_WINDOW_REG_DATA_161_MASK)
#define DBI_WINDOW_REG_DATA_161_RESET                                          0x0
#define DBI_WINDOW_REG_161_ADDRESS                                             (0x284 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_161_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_161_RESET                                               0x0

// 0x288 (DBI_WINDOW_REG_162)
#define DBI_WINDOW_REG_DATA_162_LSB                                            0
#define DBI_WINDOW_REG_DATA_162_MSB                                            31
#define DBI_WINDOW_REG_DATA_162_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_162_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_162_MASK) >> DBI_WINDOW_REG_DATA_162_LSB)
#define DBI_WINDOW_REG_DATA_162_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_162_LSB) & DBI_WINDOW_REG_DATA_162_MASK)
#define DBI_WINDOW_REG_DATA_162_RESET                                          0x0
#define DBI_WINDOW_REG_162_ADDRESS                                             (0x288 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_162_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_162_RESET                                               0x0

// 0x28c (DBI_WINDOW_REG_163)
#define DBI_WINDOW_REG_DATA_163_LSB                                            0
#define DBI_WINDOW_REG_DATA_163_MSB                                            31
#define DBI_WINDOW_REG_DATA_163_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_163_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_163_MASK) >> DBI_WINDOW_REG_DATA_163_LSB)
#define DBI_WINDOW_REG_DATA_163_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_163_LSB) & DBI_WINDOW_REG_DATA_163_MASK)
#define DBI_WINDOW_REG_DATA_163_RESET                                          0x0
#define DBI_WINDOW_REG_163_ADDRESS                                             (0x28c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_163_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_163_RESET                                               0x0

// 0x290 (DBI_WINDOW_REG_164)
#define DBI_WINDOW_REG_DATA_164_LSB                                            0
#define DBI_WINDOW_REG_DATA_164_MSB                                            31
#define DBI_WINDOW_REG_DATA_164_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_164_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_164_MASK) >> DBI_WINDOW_REG_DATA_164_LSB)
#define DBI_WINDOW_REG_DATA_164_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_164_LSB) & DBI_WINDOW_REG_DATA_164_MASK)
#define DBI_WINDOW_REG_DATA_164_RESET                                          0x0
#define DBI_WINDOW_REG_164_ADDRESS                                             (0x290 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_164_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_164_RESET                                               0x0

// 0x294 (DBI_WINDOW_REG_165)
#define DBI_WINDOW_REG_DATA_165_LSB                                            0
#define DBI_WINDOW_REG_DATA_165_MSB                                            31
#define DBI_WINDOW_REG_DATA_165_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_165_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_165_MASK) >> DBI_WINDOW_REG_DATA_165_LSB)
#define DBI_WINDOW_REG_DATA_165_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_165_LSB) & DBI_WINDOW_REG_DATA_165_MASK)
#define DBI_WINDOW_REG_DATA_165_RESET                                          0x0
#define DBI_WINDOW_REG_165_ADDRESS                                             (0x294 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_165_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_165_RESET                                               0x0

// 0x298 (DBI_WINDOW_REG_166)
#define DBI_WINDOW_REG_DATA_166_LSB                                            0
#define DBI_WINDOW_REG_DATA_166_MSB                                            31
#define DBI_WINDOW_REG_DATA_166_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_166_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_166_MASK) >> DBI_WINDOW_REG_DATA_166_LSB)
#define DBI_WINDOW_REG_DATA_166_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_166_LSB) & DBI_WINDOW_REG_DATA_166_MASK)
#define DBI_WINDOW_REG_DATA_166_RESET                                          0x0
#define DBI_WINDOW_REG_166_ADDRESS                                             (0x298 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_166_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_166_RESET                                               0x0

// 0x29c (DBI_WINDOW_REG_167)
#define DBI_WINDOW_REG_DATA_167_LSB                                            0
#define DBI_WINDOW_REG_DATA_167_MSB                                            31
#define DBI_WINDOW_REG_DATA_167_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_167_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_167_MASK) >> DBI_WINDOW_REG_DATA_167_LSB)
#define DBI_WINDOW_REG_DATA_167_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_167_LSB) & DBI_WINDOW_REG_DATA_167_MASK)
#define DBI_WINDOW_REG_DATA_167_RESET                                          0x0
#define DBI_WINDOW_REG_167_ADDRESS                                             (0x29c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_167_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_167_RESET                                               0x0

// 0x2a0 (DBI_WINDOW_REG_168)
#define DBI_WINDOW_REG_DATA_168_LSB                                            0
#define DBI_WINDOW_REG_DATA_168_MSB                                            31
#define DBI_WINDOW_REG_DATA_168_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_168_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_168_MASK) >> DBI_WINDOW_REG_DATA_168_LSB)
#define DBI_WINDOW_REG_DATA_168_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_168_LSB) & DBI_WINDOW_REG_DATA_168_MASK)
#define DBI_WINDOW_REG_DATA_168_RESET                                          0x0
#define DBI_WINDOW_REG_168_ADDRESS                                             (0x2a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_168_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_168_RESET                                               0x0

// 0x2a4 (DBI_WINDOW_REG_169)
#define DBI_WINDOW_REG_DATA_169_LSB                                            0
#define DBI_WINDOW_REG_DATA_169_MSB                                            31
#define DBI_WINDOW_REG_DATA_169_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_169_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_169_MASK) >> DBI_WINDOW_REG_DATA_169_LSB)
#define DBI_WINDOW_REG_DATA_169_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_169_LSB) & DBI_WINDOW_REG_DATA_169_MASK)
#define DBI_WINDOW_REG_DATA_169_RESET                                          0x0
#define DBI_WINDOW_REG_169_ADDRESS                                             (0x2a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_169_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_169_RESET                                               0x0

// 0x2a8 (DBI_WINDOW_REG_170)
#define DBI_WINDOW_REG_DATA_170_LSB                                            0
#define DBI_WINDOW_REG_DATA_170_MSB                                            31
#define DBI_WINDOW_REG_DATA_170_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_170_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_170_MASK) >> DBI_WINDOW_REG_DATA_170_LSB)
#define DBI_WINDOW_REG_DATA_170_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_170_LSB) & DBI_WINDOW_REG_DATA_170_MASK)
#define DBI_WINDOW_REG_DATA_170_RESET                                          0x0
#define DBI_WINDOW_REG_170_ADDRESS                                             (0x2a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_170_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_170_RESET                                               0x0

// 0x2ac (DBI_WINDOW_REG_171)
#define DBI_WINDOW_REG_DATA_171_LSB                                            0
#define DBI_WINDOW_REG_DATA_171_MSB                                            31
#define DBI_WINDOW_REG_DATA_171_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_171_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_171_MASK) >> DBI_WINDOW_REG_DATA_171_LSB)
#define DBI_WINDOW_REG_DATA_171_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_171_LSB) & DBI_WINDOW_REG_DATA_171_MASK)
#define DBI_WINDOW_REG_DATA_171_RESET                                          0x0
#define DBI_WINDOW_REG_171_ADDRESS                                             (0x2ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_171_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_171_RESET                                               0x0

// 0x2b0 (DBI_WINDOW_REG_172)
#define DBI_WINDOW_REG_DATA_172_LSB                                            0
#define DBI_WINDOW_REG_DATA_172_MSB                                            31
#define DBI_WINDOW_REG_DATA_172_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_172_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_172_MASK) >> DBI_WINDOW_REG_DATA_172_LSB)
#define DBI_WINDOW_REG_DATA_172_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_172_LSB) & DBI_WINDOW_REG_DATA_172_MASK)
#define DBI_WINDOW_REG_DATA_172_RESET                                          0x0
#define DBI_WINDOW_REG_172_ADDRESS                                             (0x2b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_172_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_172_RESET                                               0x0

// 0x2b4 (DBI_WINDOW_REG_173)
#define DBI_WINDOW_REG_DATA_173_LSB                                            0
#define DBI_WINDOW_REG_DATA_173_MSB                                            31
#define DBI_WINDOW_REG_DATA_173_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_173_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_173_MASK) >> DBI_WINDOW_REG_DATA_173_LSB)
#define DBI_WINDOW_REG_DATA_173_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_173_LSB) & DBI_WINDOW_REG_DATA_173_MASK)
#define DBI_WINDOW_REG_DATA_173_RESET                                          0x0
#define DBI_WINDOW_REG_173_ADDRESS                                             (0x2b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_173_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_173_RESET                                               0x0

// 0x2b8 (DBI_WINDOW_REG_174)
#define DBI_WINDOW_REG_DATA_174_LSB                                            0
#define DBI_WINDOW_REG_DATA_174_MSB                                            31
#define DBI_WINDOW_REG_DATA_174_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_174_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_174_MASK) >> DBI_WINDOW_REG_DATA_174_LSB)
#define DBI_WINDOW_REG_DATA_174_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_174_LSB) & DBI_WINDOW_REG_DATA_174_MASK)
#define DBI_WINDOW_REG_DATA_174_RESET                                          0x0
#define DBI_WINDOW_REG_174_ADDRESS                                             (0x2b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_174_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_174_RESET                                               0x0

// 0x2bc (DBI_WINDOW_REG_175)
#define DBI_WINDOW_REG_DATA_175_LSB                                            0
#define DBI_WINDOW_REG_DATA_175_MSB                                            31
#define DBI_WINDOW_REG_DATA_175_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_175_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_175_MASK) >> DBI_WINDOW_REG_DATA_175_LSB)
#define DBI_WINDOW_REG_DATA_175_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_175_LSB) & DBI_WINDOW_REG_DATA_175_MASK)
#define DBI_WINDOW_REG_DATA_175_RESET                                          0x0
#define DBI_WINDOW_REG_175_ADDRESS                                             (0x2bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_175_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_175_RESET                                               0x0

// 0x2c0 (DBI_WINDOW_REG_176)
#define DBI_WINDOW_REG_DATA_176_LSB                                            0
#define DBI_WINDOW_REG_DATA_176_MSB                                            31
#define DBI_WINDOW_REG_DATA_176_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_176_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_176_MASK) >> DBI_WINDOW_REG_DATA_176_LSB)
#define DBI_WINDOW_REG_DATA_176_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_176_LSB) & DBI_WINDOW_REG_DATA_176_MASK)
#define DBI_WINDOW_REG_DATA_176_RESET                                          0x0
#define DBI_WINDOW_REG_176_ADDRESS                                             (0x2c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_176_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_176_RESET                                               0x0

// 0x2c4 (DBI_WINDOW_REG_177)
#define DBI_WINDOW_REG_DATA_177_LSB                                            0
#define DBI_WINDOW_REG_DATA_177_MSB                                            31
#define DBI_WINDOW_REG_DATA_177_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_177_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_177_MASK) >> DBI_WINDOW_REG_DATA_177_LSB)
#define DBI_WINDOW_REG_DATA_177_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_177_LSB) & DBI_WINDOW_REG_DATA_177_MASK)
#define DBI_WINDOW_REG_DATA_177_RESET                                          0x0
#define DBI_WINDOW_REG_177_ADDRESS                                             (0x2c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_177_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_177_RESET                                               0x0

// 0x2c8 (DBI_WINDOW_REG_178)
#define DBI_WINDOW_REG_DATA_178_LSB                                            0
#define DBI_WINDOW_REG_DATA_178_MSB                                            31
#define DBI_WINDOW_REG_DATA_178_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_178_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_178_MASK) >> DBI_WINDOW_REG_DATA_178_LSB)
#define DBI_WINDOW_REG_DATA_178_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_178_LSB) & DBI_WINDOW_REG_DATA_178_MASK)
#define DBI_WINDOW_REG_DATA_178_RESET                                          0x0
#define DBI_WINDOW_REG_178_ADDRESS                                             (0x2c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_178_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_178_RESET                                               0x0

// 0x2cc (DBI_WINDOW_REG_179)
#define DBI_WINDOW_REG_DATA_179_LSB                                            0
#define DBI_WINDOW_REG_DATA_179_MSB                                            31
#define DBI_WINDOW_REG_DATA_179_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_179_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_179_MASK) >> DBI_WINDOW_REG_DATA_179_LSB)
#define DBI_WINDOW_REG_DATA_179_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_179_LSB) & DBI_WINDOW_REG_DATA_179_MASK)
#define DBI_WINDOW_REG_DATA_179_RESET                                          0x0
#define DBI_WINDOW_REG_179_ADDRESS                                             (0x2cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_179_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_179_RESET                                               0x0

// 0x2d0 (DBI_WINDOW_REG_180)
#define DBI_WINDOW_REG_DATA_180_LSB                                            0
#define DBI_WINDOW_REG_DATA_180_MSB                                            31
#define DBI_WINDOW_REG_DATA_180_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_180_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_180_MASK) >> DBI_WINDOW_REG_DATA_180_LSB)
#define DBI_WINDOW_REG_DATA_180_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_180_LSB) & DBI_WINDOW_REG_DATA_180_MASK)
#define DBI_WINDOW_REG_DATA_180_RESET                                          0x0
#define DBI_WINDOW_REG_180_ADDRESS                                             (0x2d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_180_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_180_RESET                                               0x0

// 0x2d4 (DBI_WINDOW_REG_181)
#define DBI_WINDOW_REG_DATA_181_LSB                                            0
#define DBI_WINDOW_REG_DATA_181_MSB                                            31
#define DBI_WINDOW_REG_DATA_181_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_181_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_181_MASK) >> DBI_WINDOW_REG_DATA_181_LSB)
#define DBI_WINDOW_REG_DATA_181_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_181_LSB) & DBI_WINDOW_REG_DATA_181_MASK)
#define DBI_WINDOW_REG_DATA_181_RESET                                          0x0
#define DBI_WINDOW_REG_181_ADDRESS                                             (0x2d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_181_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_181_RESET                                               0x0

// 0x2d8 (DBI_WINDOW_REG_182)
#define DBI_WINDOW_REG_DATA_182_LSB                                            0
#define DBI_WINDOW_REG_DATA_182_MSB                                            31
#define DBI_WINDOW_REG_DATA_182_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_182_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_182_MASK) >> DBI_WINDOW_REG_DATA_182_LSB)
#define DBI_WINDOW_REG_DATA_182_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_182_LSB) & DBI_WINDOW_REG_DATA_182_MASK)
#define DBI_WINDOW_REG_DATA_182_RESET                                          0x0
#define DBI_WINDOW_REG_182_ADDRESS                                             (0x2d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_182_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_182_RESET                                               0x0

// 0x2dc (DBI_WINDOW_REG_183)
#define DBI_WINDOW_REG_DATA_183_LSB                                            0
#define DBI_WINDOW_REG_DATA_183_MSB                                            31
#define DBI_WINDOW_REG_DATA_183_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_183_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_183_MASK) >> DBI_WINDOW_REG_DATA_183_LSB)
#define DBI_WINDOW_REG_DATA_183_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_183_LSB) & DBI_WINDOW_REG_DATA_183_MASK)
#define DBI_WINDOW_REG_DATA_183_RESET                                          0x0
#define DBI_WINDOW_REG_183_ADDRESS                                             (0x2dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_183_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_183_RESET                                               0x0

// 0x2e0 (DBI_WINDOW_REG_184)
#define DBI_WINDOW_REG_DATA_184_LSB                                            0
#define DBI_WINDOW_REG_DATA_184_MSB                                            31
#define DBI_WINDOW_REG_DATA_184_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_184_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_184_MASK) >> DBI_WINDOW_REG_DATA_184_LSB)
#define DBI_WINDOW_REG_DATA_184_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_184_LSB) & DBI_WINDOW_REG_DATA_184_MASK)
#define DBI_WINDOW_REG_DATA_184_RESET                                          0x0
#define DBI_WINDOW_REG_184_ADDRESS                                             (0x2e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_184_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_184_RESET                                               0x0

// 0x2e4 (DBI_WINDOW_REG_185)
#define DBI_WINDOW_REG_DATA_185_LSB                                            0
#define DBI_WINDOW_REG_DATA_185_MSB                                            31
#define DBI_WINDOW_REG_DATA_185_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_185_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_185_MASK) >> DBI_WINDOW_REG_DATA_185_LSB)
#define DBI_WINDOW_REG_DATA_185_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_185_LSB) & DBI_WINDOW_REG_DATA_185_MASK)
#define DBI_WINDOW_REG_DATA_185_RESET                                          0x0
#define DBI_WINDOW_REG_185_ADDRESS                                             (0x2e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_185_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_185_RESET                                               0x0

// 0x2e8 (DBI_WINDOW_REG_186)
#define DBI_WINDOW_REG_DATA_186_LSB                                            0
#define DBI_WINDOW_REG_DATA_186_MSB                                            31
#define DBI_WINDOW_REG_DATA_186_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_186_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_186_MASK) >> DBI_WINDOW_REG_DATA_186_LSB)
#define DBI_WINDOW_REG_DATA_186_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_186_LSB) & DBI_WINDOW_REG_DATA_186_MASK)
#define DBI_WINDOW_REG_DATA_186_RESET                                          0x0
#define DBI_WINDOW_REG_186_ADDRESS                                             (0x2e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_186_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_186_RESET                                               0x0

// 0x2ec (DBI_WINDOW_REG_187)
#define DBI_WINDOW_REG_DATA_187_LSB                                            0
#define DBI_WINDOW_REG_DATA_187_MSB                                            31
#define DBI_WINDOW_REG_DATA_187_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_187_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_187_MASK) >> DBI_WINDOW_REG_DATA_187_LSB)
#define DBI_WINDOW_REG_DATA_187_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_187_LSB) & DBI_WINDOW_REG_DATA_187_MASK)
#define DBI_WINDOW_REG_DATA_187_RESET                                          0x0
#define DBI_WINDOW_REG_187_ADDRESS                                             (0x2ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_187_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_187_RESET                                               0x0

// 0x2f0 (DBI_WINDOW_REG_188)
#define DBI_WINDOW_REG_DATA_188_LSB                                            0
#define DBI_WINDOW_REG_DATA_188_MSB                                            31
#define DBI_WINDOW_REG_DATA_188_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_188_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_188_MASK) >> DBI_WINDOW_REG_DATA_188_LSB)
#define DBI_WINDOW_REG_DATA_188_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_188_LSB) & DBI_WINDOW_REG_DATA_188_MASK)
#define DBI_WINDOW_REG_DATA_188_RESET                                          0x0
#define DBI_WINDOW_REG_188_ADDRESS                                             (0x2f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_188_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_188_RESET                                               0x0

// 0x2f4 (DBI_WINDOW_REG_189)
#define DBI_WINDOW_REG_DATA_189_LSB                                            0
#define DBI_WINDOW_REG_DATA_189_MSB                                            31
#define DBI_WINDOW_REG_DATA_189_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_189_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_189_MASK) >> DBI_WINDOW_REG_DATA_189_LSB)
#define DBI_WINDOW_REG_DATA_189_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_189_LSB) & DBI_WINDOW_REG_DATA_189_MASK)
#define DBI_WINDOW_REG_DATA_189_RESET                                          0x0
#define DBI_WINDOW_REG_189_ADDRESS                                             (0x2f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_189_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_189_RESET                                               0x0

// 0x2f8 (DBI_WINDOW_REG_190)
#define DBI_WINDOW_REG_DATA_190_LSB                                            0
#define DBI_WINDOW_REG_DATA_190_MSB                                            31
#define DBI_WINDOW_REG_DATA_190_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_190_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_190_MASK) >> DBI_WINDOW_REG_DATA_190_LSB)
#define DBI_WINDOW_REG_DATA_190_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_190_LSB) & DBI_WINDOW_REG_DATA_190_MASK)
#define DBI_WINDOW_REG_DATA_190_RESET                                          0x0
#define DBI_WINDOW_REG_190_ADDRESS                                             (0x2f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_190_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_190_RESET                                               0x0

// 0x2fc (DBI_WINDOW_REG_191)
#define DBI_WINDOW_REG_DATA_191_LSB                                            0
#define DBI_WINDOW_REG_DATA_191_MSB                                            31
#define DBI_WINDOW_REG_DATA_191_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_191_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_191_MASK) >> DBI_WINDOW_REG_DATA_191_LSB)
#define DBI_WINDOW_REG_DATA_191_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_191_LSB) & DBI_WINDOW_REG_DATA_191_MASK)
#define DBI_WINDOW_REG_DATA_191_RESET                                          0x0
#define DBI_WINDOW_REG_191_ADDRESS                                             (0x2fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_191_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_191_RESET                                               0x0

// 0x300 (DBI_WINDOW_REG_192)
#define DBI_WINDOW_REG_DATA_192_LSB                                            0
#define DBI_WINDOW_REG_DATA_192_MSB                                            31
#define DBI_WINDOW_REG_DATA_192_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_192_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_192_MASK) >> DBI_WINDOW_REG_DATA_192_LSB)
#define DBI_WINDOW_REG_DATA_192_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_192_LSB) & DBI_WINDOW_REG_DATA_192_MASK)
#define DBI_WINDOW_REG_DATA_192_RESET                                          0x0
#define DBI_WINDOW_REG_192_ADDRESS                                             (0x300 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_192_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_192_RESET                                               0x0

// 0x304 (DBI_WINDOW_REG_193)
#define DBI_WINDOW_REG_DATA_193_LSB                                            0
#define DBI_WINDOW_REG_DATA_193_MSB                                            31
#define DBI_WINDOW_REG_DATA_193_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_193_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_193_MASK) >> DBI_WINDOW_REG_DATA_193_LSB)
#define DBI_WINDOW_REG_DATA_193_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_193_LSB) & DBI_WINDOW_REG_DATA_193_MASK)
#define DBI_WINDOW_REG_DATA_193_RESET                                          0x0
#define DBI_WINDOW_REG_193_ADDRESS                                             (0x304 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_193_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_193_RESET                                               0x0

// 0x308 (DBI_WINDOW_REG_194)
#define DBI_WINDOW_REG_DATA_194_LSB                                            0
#define DBI_WINDOW_REG_DATA_194_MSB                                            31
#define DBI_WINDOW_REG_DATA_194_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_194_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_194_MASK) >> DBI_WINDOW_REG_DATA_194_LSB)
#define DBI_WINDOW_REG_DATA_194_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_194_LSB) & DBI_WINDOW_REG_DATA_194_MASK)
#define DBI_WINDOW_REG_DATA_194_RESET                                          0x0
#define DBI_WINDOW_REG_194_ADDRESS                                             (0x308 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_194_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_194_RESET                                               0x0

// 0x30c (DBI_WINDOW_REG_195)
#define DBI_WINDOW_REG_DATA_195_LSB                                            0
#define DBI_WINDOW_REG_DATA_195_MSB                                            31
#define DBI_WINDOW_REG_DATA_195_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_195_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_195_MASK) >> DBI_WINDOW_REG_DATA_195_LSB)
#define DBI_WINDOW_REG_DATA_195_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_195_LSB) & DBI_WINDOW_REG_DATA_195_MASK)
#define DBI_WINDOW_REG_DATA_195_RESET                                          0x0
#define DBI_WINDOW_REG_195_ADDRESS                                             (0x30c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_195_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_195_RESET                                               0x0

// 0x310 (DBI_WINDOW_REG_196)
#define DBI_WINDOW_REG_DATA_196_LSB                                            0
#define DBI_WINDOW_REG_DATA_196_MSB                                            31
#define DBI_WINDOW_REG_DATA_196_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_196_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_196_MASK) >> DBI_WINDOW_REG_DATA_196_LSB)
#define DBI_WINDOW_REG_DATA_196_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_196_LSB) & DBI_WINDOW_REG_DATA_196_MASK)
#define DBI_WINDOW_REG_DATA_196_RESET                                          0x0
#define DBI_WINDOW_REG_196_ADDRESS                                             (0x310 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_196_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_196_RESET                                               0x0

// 0x314 (DBI_WINDOW_REG_197)
#define DBI_WINDOW_REG_DATA_197_LSB                                            0
#define DBI_WINDOW_REG_DATA_197_MSB                                            31
#define DBI_WINDOW_REG_DATA_197_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_197_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_197_MASK) >> DBI_WINDOW_REG_DATA_197_LSB)
#define DBI_WINDOW_REG_DATA_197_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_197_LSB) & DBI_WINDOW_REG_DATA_197_MASK)
#define DBI_WINDOW_REG_DATA_197_RESET                                          0x0
#define DBI_WINDOW_REG_197_ADDRESS                                             (0x314 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_197_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_197_RESET                                               0x0

// 0x318 (DBI_WINDOW_REG_198)
#define DBI_WINDOW_REG_DATA_198_LSB                                            0
#define DBI_WINDOW_REG_DATA_198_MSB                                            31
#define DBI_WINDOW_REG_DATA_198_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_198_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_198_MASK) >> DBI_WINDOW_REG_DATA_198_LSB)
#define DBI_WINDOW_REG_DATA_198_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_198_LSB) & DBI_WINDOW_REG_DATA_198_MASK)
#define DBI_WINDOW_REG_DATA_198_RESET                                          0x0
#define DBI_WINDOW_REG_198_ADDRESS                                             (0x318 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_198_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_198_RESET                                               0x0

// 0x31c (DBI_WINDOW_REG_199)
#define DBI_WINDOW_REG_DATA_199_LSB                                            0
#define DBI_WINDOW_REG_DATA_199_MSB                                            31
#define DBI_WINDOW_REG_DATA_199_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_199_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_199_MASK) >> DBI_WINDOW_REG_DATA_199_LSB)
#define DBI_WINDOW_REG_DATA_199_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_199_LSB) & DBI_WINDOW_REG_DATA_199_MASK)
#define DBI_WINDOW_REG_DATA_199_RESET                                          0x0
#define DBI_WINDOW_REG_199_ADDRESS                                             (0x31c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_199_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_199_RESET                                               0x0

// 0x320 (DBI_WINDOW_REG_200)
#define DBI_WINDOW_REG_DATA_200_LSB                                            0
#define DBI_WINDOW_REG_DATA_200_MSB                                            31
#define DBI_WINDOW_REG_DATA_200_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_200_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_200_MASK) >> DBI_WINDOW_REG_DATA_200_LSB)
#define DBI_WINDOW_REG_DATA_200_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_200_LSB) & DBI_WINDOW_REG_DATA_200_MASK)
#define DBI_WINDOW_REG_DATA_200_RESET                                          0x0
#define DBI_WINDOW_REG_200_ADDRESS                                             (0x320 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_200_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_200_RESET                                               0x0

// 0x324 (DBI_WINDOW_REG_201)
#define DBI_WINDOW_REG_DATA_201_LSB                                            0
#define DBI_WINDOW_REG_DATA_201_MSB                                            31
#define DBI_WINDOW_REG_DATA_201_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_201_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_201_MASK) >> DBI_WINDOW_REG_DATA_201_LSB)
#define DBI_WINDOW_REG_DATA_201_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_201_LSB) & DBI_WINDOW_REG_DATA_201_MASK)
#define DBI_WINDOW_REG_DATA_201_RESET                                          0x0
#define DBI_WINDOW_REG_201_ADDRESS                                             (0x324 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_201_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_201_RESET                                               0x0

// 0x328 (DBI_WINDOW_REG_202)
#define DBI_WINDOW_REG_DATA_202_LSB                                            0
#define DBI_WINDOW_REG_DATA_202_MSB                                            31
#define DBI_WINDOW_REG_DATA_202_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_202_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_202_MASK) >> DBI_WINDOW_REG_DATA_202_LSB)
#define DBI_WINDOW_REG_DATA_202_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_202_LSB) & DBI_WINDOW_REG_DATA_202_MASK)
#define DBI_WINDOW_REG_DATA_202_RESET                                          0x0
#define DBI_WINDOW_REG_202_ADDRESS                                             (0x328 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_202_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_202_RESET                                               0x0

// 0x32c (DBI_WINDOW_REG_203)
#define DBI_WINDOW_REG_DATA_203_LSB                                            0
#define DBI_WINDOW_REG_DATA_203_MSB                                            31
#define DBI_WINDOW_REG_DATA_203_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_203_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_203_MASK) >> DBI_WINDOW_REG_DATA_203_LSB)
#define DBI_WINDOW_REG_DATA_203_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_203_LSB) & DBI_WINDOW_REG_DATA_203_MASK)
#define DBI_WINDOW_REG_DATA_203_RESET                                          0x0
#define DBI_WINDOW_REG_203_ADDRESS                                             (0x32c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_203_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_203_RESET                                               0x0

// 0x330 (DBI_WINDOW_REG_204)
#define DBI_WINDOW_REG_DATA_204_LSB                                            0
#define DBI_WINDOW_REG_DATA_204_MSB                                            31
#define DBI_WINDOW_REG_DATA_204_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_204_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_204_MASK) >> DBI_WINDOW_REG_DATA_204_LSB)
#define DBI_WINDOW_REG_DATA_204_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_204_LSB) & DBI_WINDOW_REG_DATA_204_MASK)
#define DBI_WINDOW_REG_DATA_204_RESET                                          0x0
#define DBI_WINDOW_REG_204_ADDRESS                                             (0x330 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_204_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_204_RESET                                               0x0

// 0x334 (DBI_WINDOW_REG_205)
#define DBI_WINDOW_REG_DATA_205_LSB                                            0
#define DBI_WINDOW_REG_DATA_205_MSB                                            31
#define DBI_WINDOW_REG_DATA_205_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_205_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_205_MASK) >> DBI_WINDOW_REG_DATA_205_LSB)
#define DBI_WINDOW_REG_DATA_205_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_205_LSB) & DBI_WINDOW_REG_DATA_205_MASK)
#define DBI_WINDOW_REG_DATA_205_RESET                                          0x0
#define DBI_WINDOW_REG_205_ADDRESS                                             (0x334 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_205_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_205_RESET                                               0x0

// 0x338 (DBI_WINDOW_REG_206)
#define DBI_WINDOW_REG_DATA_206_LSB                                            0
#define DBI_WINDOW_REG_DATA_206_MSB                                            31
#define DBI_WINDOW_REG_DATA_206_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_206_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_206_MASK) >> DBI_WINDOW_REG_DATA_206_LSB)
#define DBI_WINDOW_REG_DATA_206_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_206_LSB) & DBI_WINDOW_REG_DATA_206_MASK)
#define DBI_WINDOW_REG_DATA_206_RESET                                          0x0
#define DBI_WINDOW_REG_206_ADDRESS                                             (0x338 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_206_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_206_RESET                                               0x0

// 0x33c (DBI_WINDOW_REG_207)
#define DBI_WINDOW_REG_DATA_207_LSB                                            0
#define DBI_WINDOW_REG_DATA_207_MSB                                            31
#define DBI_WINDOW_REG_DATA_207_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_207_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_207_MASK) >> DBI_WINDOW_REG_DATA_207_LSB)
#define DBI_WINDOW_REG_DATA_207_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_207_LSB) & DBI_WINDOW_REG_DATA_207_MASK)
#define DBI_WINDOW_REG_DATA_207_RESET                                          0x0
#define DBI_WINDOW_REG_207_ADDRESS                                             (0x33c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_207_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_207_RESET                                               0x0

// 0x340 (DBI_WINDOW_REG_208)
#define DBI_WINDOW_REG_DATA_208_LSB                                            0
#define DBI_WINDOW_REG_DATA_208_MSB                                            31
#define DBI_WINDOW_REG_DATA_208_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_208_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_208_MASK) >> DBI_WINDOW_REG_DATA_208_LSB)
#define DBI_WINDOW_REG_DATA_208_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_208_LSB) & DBI_WINDOW_REG_DATA_208_MASK)
#define DBI_WINDOW_REG_DATA_208_RESET                                          0x0
#define DBI_WINDOW_REG_208_ADDRESS                                             (0x340 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_208_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_208_RESET                                               0x0

// 0x344 (DBI_WINDOW_REG_209)
#define DBI_WINDOW_REG_DATA_209_LSB                                            0
#define DBI_WINDOW_REG_DATA_209_MSB                                            31
#define DBI_WINDOW_REG_DATA_209_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_209_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_209_MASK) >> DBI_WINDOW_REG_DATA_209_LSB)
#define DBI_WINDOW_REG_DATA_209_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_209_LSB) & DBI_WINDOW_REG_DATA_209_MASK)
#define DBI_WINDOW_REG_DATA_209_RESET                                          0x0
#define DBI_WINDOW_REG_209_ADDRESS                                             (0x344 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_209_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_209_RESET                                               0x0

// 0x348 (DBI_WINDOW_REG_210)
#define DBI_WINDOW_REG_DATA_210_LSB                                            0
#define DBI_WINDOW_REG_DATA_210_MSB                                            31
#define DBI_WINDOW_REG_DATA_210_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_210_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_210_MASK) >> DBI_WINDOW_REG_DATA_210_LSB)
#define DBI_WINDOW_REG_DATA_210_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_210_LSB) & DBI_WINDOW_REG_DATA_210_MASK)
#define DBI_WINDOW_REG_DATA_210_RESET                                          0x0
#define DBI_WINDOW_REG_210_ADDRESS                                             (0x348 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_210_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_210_RESET                                               0x0

// 0x34c (DBI_WINDOW_REG_211)
#define DBI_WINDOW_REG_DATA_211_LSB                                            0
#define DBI_WINDOW_REG_DATA_211_MSB                                            31
#define DBI_WINDOW_REG_DATA_211_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_211_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_211_MASK) >> DBI_WINDOW_REG_DATA_211_LSB)
#define DBI_WINDOW_REG_DATA_211_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_211_LSB) & DBI_WINDOW_REG_DATA_211_MASK)
#define DBI_WINDOW_REG_DATA_211_RESET                                          0x0
#define DBI_WINDOW_REG_211_ADDRESS                                             (0x34c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_211_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_211_RESET                                               0x0

// 0x350 (DBI_WINDOW_REG_212)
#define DBI_WINDOW_REG_DATA_212_LSB                                            0
#define DBI_WINDOW_REG_DATA_212_MSB                                            31
#define DBI_WINDOW_REG_DATA_212_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_212_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_212_MASK) >> DBI_WINDOW_REG_DATA_212_LSB)
#define DBI_WINDOW_REG_DATA_212_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_212_LSB) & DBI_WINDOW_REG_DATA_212_MASK)
#define DBI_WINDOW_REG_DATA_212_RESET                                          0x0
#define DBI_WINDOW_REG_212_ADDRESS                                             (0x350 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_212_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_212_RESET                                               0x0

// 0x354 (DBI_WINDOW_REG_213)
#define DBI_WINDOW_REG_DATA_213_LSB                                            0
#define DBI_WINDOW_REG_DATA_213_MSB                                            31
#define DBI_WINDOW_REG_DATA_213_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_213_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_213_MASK) >> DBI_WINDOW_REG_DATA_213_LSB)
#define DBI_WINDOW_REG_DATA_213_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_213_LSB) & DBI_WINDOW_REG_DATA_213_MASK)
#define DBI_WINDOW_REG_DATA_213_RESET                                          0x0
#define DBI_WINDOW_REG_213_ADDRESS                                             (0x354 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_213_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_213_RESET                                               0x0

// 0x358 (DBI_WINDOW_REG_214)
#define DBI_WINDOW_REG_DATA_214_LSB                                            0
#define DBI_WINDOW_REG_DATA_214_MSB                                            31
#define DBI_WINDOW_REG_DATA_214_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_214_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_214_MASK) >> DBI_WINDOW_REG_DATA_214_LSB)
#define DBI_WINDOW_REG_DATA_214_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_214_LSB) & DBI_WINDOW_REG_DATA_214_MASK)
#define DBI_WINDOW_REG_DATA_214_RESET                                          0x0
#define DBI_WINDOW_REG_214_ADDRESS                                             (0x358 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_214_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_214_RESET                                               0x0

// 0x35c (DBI_WINDOW_REG_215)
#define DBI_WINDOW_REG_DATA_215_LSB                                            0
#define DBI_WINDOW_REG_DATA_215_MSB                                            31
#define DBI_WINDOW_REG_DATA_215_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_215_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_215_MASK) >> DBI_WINDOW_REG_DATA_215_LSB)
#define DBI_WINDOW_REG_DATA_215_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_215_LSB) & DBI_WINDOW_REG_DATA_215_MASK)
#define DBI_WINDOW_REG_DATA_215_RESET                                          0x0
#define DBI_WINDOW_REG_215_ADDRESS                                             (0x35c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_215_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_215_RESET                                               0x0

// 0x360 (DBI_WINDOW_REG_216)
#define DBI_WINDOW_REG_DATA_216_LSB                                            0
#define DBI_WINDOW_REG_DATA_216_MSB                                            31
#define DBI_WINDOW_REG_DATA_216_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_216_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_216_MASK) >> DBI_WINDOW_REG_DATA_216_LSB)
#define DBI_WINDOW_REG_DATA_216_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_216_LSB) & DBI_WINDOW_REG_DATA_216_MASK)
#define DBI_WINDOW_REG_DATA_216_RESET                                          0x0
#define DBI_WINDOW_REG_216_ADDRESS                                             (0x360 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_216_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_216_RESET                                               0x0

// 0x364 (DBI_WINDOW_REG_217)
#define DBI_WINDOW_REG_DATA_217_LSB                                            0
#define DBI_WINDOW_REG_DATA_217_MSB                                            31
#define DBI_WINDOW_REG_DATA_217_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_217_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_217_MASK) >> DBI_WINDOW_REG_DATA_217_LSB)
#define DBI_WINDOW_REG_DATA_217_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_217_LSB) & DBI_WINDOW_REG_DATA_217_MASK)
#define DBI_WINDOW_REG_DATA_217_RESET                                          0x0
#define DBI_WINDOW_REG_217_ADDRESS                                             (0x364 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_217_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_217_RESET                                               0x0

// 0x368 (DBI_WINDOW_REG_218)
#define DBI_WINDOW_REG_DATA_218_LSB                                            0
#define DBI_WINDOW_REG_DATA_218_MSB                                            31
#define DBI_WINDOW_REG_DATA_218_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_218_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_218_MASK) >> DBI_WINDOW_REG_DATA_218_LSB)
#define DBI_WINDOW_REG_DATA_218_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_218_LSB) & DBI_WINDOW_REG_DATA_218_MASK)
#define DBI_WINDOW_REG_DATA_218_RESET                                          0x0
#define DBI_WINDOW_REG_218_ADDRESS                                             (0x368 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_218_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_218_RESET                                               0x0

// 0x36c (DBI_WINDOW_REG_219)
#define DBI_WINDOW_REG_DATA_219_LSB                                            0
#define DBI_WINDOW_REG_DATA_219_MSB                                            31
#define DBI_WINDOW_REG_DATA_219_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_219_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_219_MASK) >> DBI_WINDOW_REG_DATA_219_LSB)
#define DBI_WINDOW_REG_DATA_219_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_219_LSB) & DBI_WINDOW_REG_DATA_219_MASK)
#define DBI_WINDOW_REG_DATA_219_RESET                                          0x0
#define DBI_WINDOW_REG_219_ADDRESS                                             (0x36c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_219_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_219_RESET                                               0x0

// 0x370 (DBI_WINDOW_REG_220)
#define DBI_WINDOW_REG_DATA_220_LSB                                            0
#define DBI_WINDOW_REG_DATA_220_MSB                                            31
#define DBI_WINDOW_REG_DATA_220_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_220_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_220_MASK) >> DBI_WINDOW_REG_DATA_220_LSB)
#define DBI_WINDOW_REG_DATA_220_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_220_LSB) & DBI_WINDOW_REG_DATA_220_MASK)
#define DBI_WINDOW_REG_DATA_220_RESET                                          0x0
#define DBI_WINDOW_REG_220_ADDRESS                                             (0x370 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_220_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_220_RESET                                               0x0

// 0x374 (DBI_WINDOW_REG_221)
#define DBI_WINDOW_REG_DATA_221_LSB                                            0
#define DBI_WINDOW_REG_DATA_221_MSB                                            31
#define DBI_WINDOW_REG_DATA_221_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_221_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_221_MASK) >> DBI_WINDOW_REG_DATA_221_LSB)
#define DBI_WINDOW_REG_DATA_221_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_221_LSB) & DBI_WINDOW_REG_DATA_221_MASK)
#define DBI_WINDOW_REG_DATA_221_RESET                                          0x0
#define DBI_WINDOW_REG_221_ADDRESS                                             (0x374 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_221_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_221_RESET                                               0x0

// 0x378 (DBI_WINDOW_REG_222)
#define DBI_WINDOW_REG_DATA_222_LSB                                            0
#define DBI_WINDOW_REG_DATA_222_MSB                                            31
#define DBI_WINDOW_REG_DATA_222_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_222_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_222_MASK) >> DBI_WINDOW_REG_DATA_222_LSB)
#define DBI_WINDOW_REG_DATA_222_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_222_LSB) & DBI_WINDOW_REG_DATA_222_MASK)
#define DBI_WINDOW_REG_DATA_222_RESET                                          0x0
#define DBI_WINDOW_REG_222_ADDRESS                                             (0x378 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_222_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_222_RESET                                               0x0

// 0x37c (DBI_WINDOW_REG_223)
#define DBI_WINDOW_REG_DATA_223_LSB                                            0
#define DBI_WINDOW_REG_DATA_223_MSB                                            31
#define DBI_WINDOW_REG_DATA_223_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_223_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_223_MASK) >> DBI_WINDOW_REG_DATA_223_LSB)
#define DBI_WINDOW_REG_DATA_223_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_223_LSB) & DBI_WINDOW_REG_DATA_223_MASK)
#define DBI_WINDOW_REG_DATA_223_RESET                                          0x0
#define DBI_WINDOW_REG_223_ADDRESS                                             (0x37c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_223_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_223_RESET                                               0x0

// 0x380 (DBI_WINDOW_REG_224)
#define DBI_WINDOW_REG_DATA_224_LSB                                            0
#define DBI_WINDOW_REG_DATA_224_MSB                                            31
#define DBI_WINDOW_REG_DATA_224_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_224_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_224_MASK) >> DBI_WINDOW_REG_DATA_224_LSB)
#define DBI_WINDOW_REG_DATA_224_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_224_LSB) & DBI_WINDOW_REG_DATA_224_MASK)
#define DBI_WINDOW_REG_DATA_224_RESET                                          0x0
#define DBI_WINDOW_REG_224_ADDRESS                                             (0x380 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_224_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_224_RESET                                               0x0

// 0x384 (DBI_WINDOW_REG_225)
#define DBI_WINDOW_REG_DATA_225_LSB                                            0
#define DBI_WINDOW_REG_DATA_225_MSB                                            31
#define DBI_WINDOW_REG_DATA_225_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_225_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_225_MASK) >> DBI_WINDOW_REG_DATA_225_LSB)
#define DBI_WINDOW_REG_DATA_225_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_225_LSB) & DBI_WINDOW_REG_DATA_225_MASK)
#define DBI_WINDOW_REG_DATA_225_RESET                                          0x0
#define DBI_WINDOW_REG_225_ADDRESS                                             (0x384 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_225_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_225_RESET                                               0x0

// 0x388 (DBI_WINDOW_REG_226)
#define DBI_WINDOW_REG_DATA_226_LSB                                            0
#define DBI_WINDOW_REG_DATA_226_MSB                                            31
#define DBI_WINDOW_REG_DATA_226_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_226_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_226_MASK) >> DBI_WINDOW_REG_DATA_226_LSB)
#define DBI_WINDOW_REG_DATA_226_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_226_LSB) & DBI_WINDOW_REG_DATA_226_MASK)
#define DBI_WINDOW_REG_DATA_226_RESET                                          0x0
#define DBI_WINDOW_REG_226_ADDRESS                                             (0x388 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_226_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_226_RESET                                               0x0

// 0x38c (DBI_WINDOW_REG_227)
#define DBI_WINDOW_REG_DATA_227_LSB                                            0
#define DBI_WINDOW_REG_DATA_227_MSB                                            31
#define DBI_WINDOW_REG_DATA_227_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_227_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_227_MASK) >> DBI_WINDOW_REG_DATA_227_LSB)
#define DBI_WINDOW_REG_DATA_227_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_227_LSB) & DBI_WINDOW_REG_DATA_227_MASK)
#define DBI_WINDOW_REG_DATA_227_RESET                                          0x0
#define DBI_WINDOW_REG_227_ADDRESS                                             (0x38c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_227_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_227_RESET                                               0x0

// 0x390 (DBI_WINDOW_REG_228)
#define DBI_WINDOW_REG_DATA_228_LSB                                            0
#define DBI_WINDOW_REG_DATA_228_MSB                                            31
#define DBI_WINDOW_REG_DATA_228_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_228_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_228_MASK) >> DBI_WINDOW_REG_DATA_228_LSB)
#define DBI_WINDOW_REG_DATA_228_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_228_LSB) & DBI_WINDOW_REG_DATA_228_MASK)
#define DBI_WINDOW_REG_DATA_228_RESET                                          0x0
#define DBI_WINDOW_REG_228_ADDRESS                                             (0x390 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_228_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_228_RESET                                               0x0

// 0x394 (DBI_WINDOW_REG_229)
#define DBI_WINDOW_REG_DATA_229_LSB                                            0
#define DBI_WINDOW_REG_DATA_229_MSB                                            31
#define DBI_WINDOW_REG_DATA_229_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_229_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_229_MASK) >> DBI_WINDOW_REG_DATA_229_LSB)
#define DBI_WINDOW_REG_DATA_229_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_229_LSB) & DBI_WINDOW_REG_DATA_229_MASK)
#define DBI_WINDOW_REG_DATA_229_RESET                                          0x0
#define DBI_WINDOW_REG_229_ADDRESS                                             (0x394 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_229_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_229_RESET                                               0x0

// 0x398 (DBI_WINDOW_REG_230)
#define DBI_WINDOW_REG_DATA_230_LSB                                            0
#define DBI_WINDOW_REG_DATA_230_MSB                                            31
#define DBI_WINDOW_REG_DATA_230_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_230_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_230_MASK) >> DBI_WINDOW_REG_DATA_230_LSB)
#define DBI_WINDOW_REG_DATA_230_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_230_LSB) & DBI_WINDOW_REG_DATA_230_MASK)
#define DBI_WINDOW_REG_DATA_230_RESET                                          0x0
#define DBI_WINDOW_REG_230_ADDRESS                                             (0x398 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_230_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_230_RESET                                               0x0

// 0x39c (DBI_WINDOW_REG_231)
#define DBI_WINDOW_REG_DATA_231_LSB                                            0
#define DBI_WINDOW_REG_DATA_231_MSB                                            31
#define DBI_WINDOW_REG_DATA_231_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_231_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_231_MASK) >> DBI_WINDOW_REG_DATA_231_LSB)
#define DBI_WINDOW_REG_DATA_231_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_231_LSB) & DBI_WINDOW_REG_DATA_231_MASK)
#define DBI_WINDOW_REG_DATA_231_RESET                                          0x0
#define DBI_WINDOW_REG_231_ADDRESS                                             (0x39c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_231_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_231_RESET                                               0x0

// 0x3a0 (DBI_WINDOW_REG_232)
#define DBI_WINDOW_REG_DATA_232_LSB                                            0
#define DBI_WINDOW_REG_DATA_232_MSB                                            31
#define DBI_WINDOW_REG_DATA_232_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_232_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_232_MASK) >> DBI_WINDOW_REG_DATA_232_LSB)
#define DBI_WINDOW_REG_DATA_232_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_232_LSB) & DBI_WINDOW_REG_DATA_232_MASK)
#define DBI_WINDOW_REG_DATA_232_RESET                                          0x0
#define DBI_WINDOW_REG_232_ADDRESS                                             (0x3a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_232_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_232_RESET                                               0x0

// 0x3a4 (DBI_WINDOW_REG_233)
#define DBI_WINDOW_REG_DATA_233_LSB                                            0
#define DBI_WINDOW_REG_DATA_233_MSB                                            31
#define DBI_WINDOW_REG_DATA_233_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_233_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_233_MASK) >> DBI_WINDOW_REG_DATA_233_LSB)
#define DBI_WINDOW_REG_DATA_233_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_233_LSB) & DBI_WINDOW_REG_DATA_233_MASK)
#define DBI_WINDOW_REG_DATA_233_RESET                                          0x0
#define DBI_WINDOW_REG_233_ADDRESS                                             (0x3a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_233_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_233_RESET                                               0x0

// 0x3a8 (DBI_WINDOW_REG_234)
#define DBI_WINDOW_REG_DATA_234_LSB                                            0
#define DBI_WINDOW_REG_DATA_234_MSB                                            31
#define DBI_WINDOW_REG_DATA_234_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_234_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_234_MASK) >> DBI_WINDOW_REG_DATA_234_LSB)
#define DBI_WINDOW_REG_DATA_234_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_234_LSB) & DBI_WINDOW_REG_DATA_234_MASK)
#define DBI_WINDOW_REG_DATA_234_RESET                                          0x0
#define DBI_WINDOW_REG_234_ADDRESS                                             (0x3a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_234_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_234_RESET                                               0x0

// 0x3ac (DBI_WINDOW_REG_235)
#define DBI_WINDOW_REG_DATA_235_LSB                                            0
#define DBI_WINDOW_REG_DATA_235_MSB                                            31
#define DBI_WINDOW_REG_DATA_235_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_235_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_235_MASK) >> DBI_WINDOW_REG_DATA_235_LSB)
#define DBI_WINDOW_REG_DATA_235_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_235_LSB) & DBI_WINDOW_REG_DATA_235_MASK)
#define DBI_WINDOW_REG_DATA_235_RESET                                          0x0
#define DBI_WINDOW_REG_235_ADDRESS                                             (0x3ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_235_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_235_RESET                                               0x0

// 0x3b0 (DBI_WINDOW_REG_236)
#define DBI_WINDOW_REG_DATA_236_LSB                                            0
#define DBI_WINDOW_REG_DATA_236_MSB                                            31
#define DBI_WINDOW_REG_DATA_236_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_236_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_236_MASK) >> DBI_WINDOW_REG_DATA_236_LSB)
#define DBI_WINDOW_REG_DATA_236_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_236_LSB) & DBI_WINDOW_REG_DATA_236_MASK)
#define DBI_WINDOW_REG_DATA_236_RESET                                          0x0
#define DBI_WINDOW_REG_236_ADDRESS                                             (0x3b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_236_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_236_RESET                                               0x0

// 0x3b4 (DBI_WINDOW_REG_237)
#define DBI_WINDOW_REG_DATA_237_LSB                                            0
#define DBI_WINDOW_REG_DATA_237_MSB                                            31
#define DBI_WINDOW_REG_DATA_237_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_237_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_237_MASK) >> DBI_WINDOW_REG_DATA_237_LSB)
#define DBI_WINDOW_REG_DATA_237_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_237_LSB) & DBI_WINDOW_REG_DATA_237_MASK)
#define DBI_WINDOW_REG_DATA_237_RESET                                          0x0
#define DBI_WINDOW_REG_237_ADDRESS                                             (0x3b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_237_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_237_RESET                                               0x0

// 0x3b8 (DBI_WINDOW_REG_238)
#define DBI_WINDOW_REG_DATA_238_LSB                                            0
#define DBI_WINDOW_REG_DATA_238_MSB                                            31
#define DBI_WINDOW_REG_DATA_238_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_238_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_238_MASK) >> DBI_WINDOW_REG_DATA_238_LSB)
#define DBI_WINDOW_REG_DATA_238_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_238_LSB) & DBI_WINDOW_REG_DATA_238_MASK)
#define DBI_WINDOW_REG_DATA_238_RESET                                          0x0
#define DBI_WINDOW_REG_238_ADDRESS                                             (0x3b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_238_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_238_RESET                                               0x0

// 0x3bc (DBI_WINDOW_REG_239)
#define DBI_WINDOW_REG_DATA_239_LSB                                            0
#define DBI_WINDOW_REG_DATA_239_MSB                                            31
#define DBI_WINDOW_REG_DATA_239_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_239_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_239_MASK) >> DBI_WINDOW_REG_DATA_239_LSB)
#define DBI_WINDOW_REG_DATA_239_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_239_LSB) & DBI_WINDOW_REG_DATA_239_MASK)
#define DBI_WINDOW_REG_DATA_239_RESET                                          0x0
#define DBI_WINDOW_REG_239_ADDRESS                                             (0x3bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_239_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_239_RESET                                               0x0

// 0x3c0 (DBI_WINDOW_REG_240)
#define DBI_WINDOW_REG_DATA_240_LSB                                            0
#define DBI_WINDOW_REG_DATA_240_MSB                                            31
#define DBI_WINDOW_REG_DATA_240_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_240_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_240_MASK) >> DBI_WINDOW_REG_DATA_240_LSB)
#define DBI_WINDOW_REG_DATA_240_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_240_LSB) & DBI_WINDOW_REG_DATA_240_MASK)
#define DBI_WINDOW_REG_DATA_240_RESET                                          0x0
#define DBI_WINDOW_REG_240_ADDRESS                                             (0x3c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_240_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_240_RESET                                               0x0

// 0x3c4 (DBI_WINDOW_REG_241)
#define DBI_WINDOW_REG_DATA_241_LSB                                            0
#define DBI_WINDOW_REG_DATA_241_MSB                                            31
#define DBI_WINDOW_REG_DATA_241_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_241_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_241_MASK) >> DBI_WINDOW_REG_DATA_241_LSB)
#define DBI_WINDOW_REG_DATA_241_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_241_LSB) & DBI_WINDOW_REG_DATA_241_MASK)
#define DBI_WINDOW_REG_DATA_241_RESET                                          0x0
#define DBI_WINDOW_REG_241_ADDRESS                                             (0x3c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_241_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_241_RESET                                               0x0

// 0x3c8 (DBI_WINDOW_REG_242)
#define DBI_WINDOW_REG_DATA_242_LSB                                            0
#define DBI_WINDOW_REG_DATA_242_MSB                                            31
#define DBI_WINDOW_REG_DATA_242_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_242_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_242_MASK) >> DBI_WINDOW_REG_DATA_242_LSB)
#define DBI_WINDOW_REG_DATA_242_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_242_LSB) & DBI_WINDOW_REG_DATA_242_MASK)
#define DBI_WINDOW_REG_DATA_242_RESET                                          0x0
#define DBI_WINDOW_REG_242_ADDRESS                                             (0x3c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_242_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_242_RESET                                               0x0

// 0x3cc (DBI_WINDOW_REG_243)
#define DBI_WINDOW_REG_DATA_243_LSB                                            0
#define DBI_WINDOW_REG_DATA_243_MSB                                            31
#define DBI_WINDOW_REG_DATA_243_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_243_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_243_MASK) >> DBI_WINDOW_REG_DATA_243_LSB)
#define DBI_WINDOW_REG_DATA_243_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_243_LSB) & DBI_WINDOW_REG_DATA_243_MASK)
#define DBI_WINDOW_REG_DATA_243_RESET                                          0x0
#define DBI_WINDOW_REG_243_ADDRESS                                             (0x3cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_243_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_243_RESET                                               0x0

// 0x3d0 (DBI_WINDOW_REG_244)
#define DBI_WINDOW_REG_DATA_244_LSB                                            0
#define DBI_WINDOW_REG_DATA_244_MSB                                            31
#define DBI_WINDOW_REG_DATA_244_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_244_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_244_MASK) >> DBI_WINDOW_REG_DATA_244_LSB)
#define DBI_WINDOW_REG_DATA_244_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_244_LSB) & DBI_WINDOW_REG_DATA_244_MASK)
#define DBI_WINDOW_REG_DATA_244_RESET                                          0x0
#define DBI_WINDOW_REG_244_ADDRESS                                             (0x3d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_244_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_244_RESET                                               0x0

// 0x3d4 (DBI_WINDOW_REG_245)
#define DBI_WINDOW_REG_DATA_245_LSB                                            0
#define DBI_WINDOW_REG_DATA_245_MSB                                            31
#define DBI_WINDOW_REG_DATA_245_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_245_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_245_MASK) >> DBI_WINDOW_REG_DATA_245_LSB)
#define DBI_WINDOW_REG_DATA_245_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_245_LSB) & DBI_WINDOW_REG_DATA_245_MASK)
#define DBI_WINDOW_REG_DATA_245_RESET                                          0x0
#define DBI_WINDOW_REG_245_ADDRESS                                             (0x3d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_245_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_245_RESET                                               0x0

// 0x3d8 (DBI_WINDOW_REG_246)
#define DBI_WINDOW_REG_DATA_246_LSB                                            0
#define DBI_WINDOW_REG_DATA_246_MSB                                            31
#define DBI_WINDOW_REG_DATA_246_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_246_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_246_MASK) >> DBI_WINDOW_REG_DATA_246_LSB)
#define DBI_WINDOW_REG_DATA_246_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_246_LSB) & DBI_WINDOW_REG_DATA_246_MASK)
#define DBI_WINDOW_REG_DATA_246_RESET                                          0x0
#define DBI_WINDOW_REG_246_ADDRESS                                             (0x3d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_246_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_246_RESET                                               0x0

// 0x3dc (DBI_WINDOW_REG_247)
#define DBI_WINDOW_REG_DATA_247_LSB                                            0
#define DBI_WINDOW_REG_DATA_247_MSB                                            31
#define DBI_WINDOW_REG_DATA_247_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_247_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_247_MASK) >> DBI_WINDOW_REG_DATA_247_LSB)
#define DBI_WINDOW_REG_DATA_247_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_247_LSB) & DBI_WINDOW_REG_DATA_247_MASK)
#define DBI_WINDOW_REG_DATA_247_RESET                                          0x0
#define DBI_WINDOW_REG_247_ADDRESS                                             (0x3dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_247_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_247_RESET                                               0x0

// 0x3e0 (DBI_WINDOW_REG_248)
#define DBI_WINDOW_REG_DATA_248_LSB                                            0
#define DBI_WINDOW_REG_DATA_248_MSB                                            31
#define DBI_WINDOW_REG_DATA_248_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_248_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_248_MASK) >> DBI_WINDOW_REG_DATA_248_LSB)
#define DBI_WINDOW_REG_DATA_248_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_248_LSB) & DBI_WINDOW_REG_DATA_248_MASK)
#define DBI_WINDOW_REG_DATA_248_RESET                                          0x0
#define DBI_WINDOW_REG_248_ADDRESS                                             (0x3e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_248_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_248_RESET                                               0x0

// 0x3e4 (DBI_WINDOW_REG_249)
#define DBI_WINDOW_REG_DATA_249_LSB                                            0
#define DBI_WINDOW_REG_DATA_249_MSB                                            31
#define DBI_WINDOW_REG_DATA_249_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_249_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_249_MASK) >> DBI_WINDOW_REG_DATA_249_LSB)
#define DBI_WINDOW_REG_DATA_249_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_249_LSB) & DBI_WINDOW_REG_DATA_249_MASK)
#define DBI_WINDOW_REG_DATA_249_RESET                                          0x0
#define DBI_WINDOW_REG_249_ADDRESS                                             (0x3e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_249_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_249_RESET                                               0x0

// 0x3e8 (DBI_WINDOW_REG_250)
#define DBI_WINDOW_REG_DATA_250_LSB                                            0
#define DBI_WINDOW_REG_DATA_250_MSB                                            31
#define DBI_WINDOW_REG_DATA_250_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_250_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_250_MASK) >> DBI_WINDOW_REG_DATA_250_LSB)
#define DBI_WINDOW_REG_DATA_250_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_250_LSB) & DBI_WINDOW_REG_DATA_250_MASK)
#define DBI_WINDOW_REG_DATA_250_RESET                                          0x0
#define DBI_WINDOW_REG_250_ADDRESS                                             (0x3e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_250_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_250_RESET                                               0x0

// 0x3ec (DBI_WINDOW_REG_251)
#define DBI_WINDOW_REG_DATA_251_LSB                                            0
#define DBI_WINDOW_REG_DATA_251_MSB                                            31
#define DBI_WINDOW_REG_DATA_251_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_251_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_251_MASK) >> DBI_WINDOW_REG_DATA_251_LSB)
#define DBI_WINDOW_REG_DATA_251_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_251_LSB) & DBI_WINDOW_REG_DATA_251_MASK)
#define DBI_WINDOW_REG_DATA_251_RESET                                          0x0
#define DBI_WINDOW_REG_251_ADDRESS                                             (0x3ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_251_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_251_RESET                                               0x0

// 0x3f0 (DBI_WINDOW_REG_252)
#define DBI_WINDOW_REG_DATA_252_LSB                                            0
#define DBI_WINDOW_REG_DATA_252_MSB                                            31
#define DBI_WINDOW_REG_DATA_252_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_252_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_252_MASK) >> DBI_WINDOW_REG_DATA_252_LSB)
#define DBI_WINDOW_REG_DATA_252_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_252_LSB) & DBI_WINDOW_REG_DATA_252_MASK)
#define DBI_WINDOW_REG_DATA_252_RESET                                          0x0
#define DBI_WINDOW_REG_252_ADDRESS                                             (0x3f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_252_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_252_RESET                                               0x0

// 0x3f4 (DBI_WINDOW_REG_253)
#define DBI_WINDOW_REG_DATA_253_LSB                                            0
#define DBI_WINDOW_REG_DATA_253_MSB                                            31
#define DBI_WINDOW_REG_DATA_253_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_253_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_253_MASK) >> DBI_WINDOW_REG_DATA_253_LSB)
#define DBI_WINDOW_REG_DATA_253_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_253_LSB) & DBI_WINDOW_REG_DATA_253_MASK)
#define DBI_WINDOW_REG_DATA_253_RESET                                          0x0
#define DBI_WINDOW_REG_253_ADDRESS                                             (0x3f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_253_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_253_RESET                                               0x0

// 0x3f8 (DBI_WINDOW_REG_254)
#define DBI_WINDOW_REG_DATA_254_LSB                                            0
#define DBI_WINDOW_REG_DATA_254_MSB                                            31
#define DBI_WINDOW_REG_DATA_254_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_254_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_254_MASK) >> DBI_WINDOW_REG_DATA_254_LSB)
#define DBI_WINDOW_REG_DATA_254_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_254_LSB) & DBI_WINDOW_REG_DATA_254_MASK)
#define DBI_WINDOW_REG_DATA_254_RESET                                          0x0
#define DBI_WINDOW_REG_254_ADDRESS                                             (0x3f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_254_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_254_RESET                                               0x0

// 0x3fc (DBI_WINDOW_REG_255)
#define DBI_WINDOW_REG_DATA_255_LSB                                            0
#define DBI_WINDOW_REG_DATA_255_MSB                                            31
#define DBI_WINDOW_REG_DATA_255_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_255_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_255_MASK) >> DBI_WINDOW_REG_DATA_255_LSB)
#define DBI_WINDOW_REG_DATA_255_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_255_LSB) & DBI_WINDOW_REG_DATA_255_MASK)
#define DBI_WINDOW_REG_DATA_255_RESET                                          0x0
#define DBI_WINDOW_REG_255_ADDRESS                                             (0x3fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_255_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_255_RESET                                               0x0

// 0x400 (DBI_WINDOW_REG_256)
#define DBI_WINDOW_REG_DATA_256_LSB                                            0
#define DBI_WINDOW_REG_DATA_256_MSB                                            31
#define DBI_WINDOW_REG_DATA_256_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_256_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_256_MASK) >> DBI_WINDOW_REG_DATA_256_LSB)
#define DBI_WINDOW_REG_DATA_256_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_256_LSB) & DBI_WINDOW_REG_DATA_256_MASK)
#define DBI_WINDOW_REG_DATA_256_RESET                                          0x0
#define DBI_WINDOW_REG_256_ADDRESS                                             (0x400 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_256_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_256_RESET                                               0x0

// 0x404 (DBI_WINDOW_REG_257)
#define DBI_WINDOW_REG_DATA_257_LSB                                            0
#define DBI_WINDOW_REG_DATA_257_MSB                                            31
#define DBI_WINDOW_REG_DATA_257_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_257_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_257_MASK) >> DBI_WINDOW_REG_DATA_257_LSB)
#define DBI_WINDOW_REG_DATA_257_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_257_LSB) & DBI_WINDOW_REG_DATA_257_MASK)
#define DBI_WINDOW_REG_DATA_257_RESET                                          0x0
#define DBI_WINDOW_REG_257_ADDRESS                                             (0x404 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_257_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_257_RESET                                               0x0

// 0x408 (DBI_WINDOW_REG_258)
#define DBI_WINDOW_REG_DATA_258_LSB                                            0
#define DBI_WINDOW_REG_DATA_258_MSB                                            31
#define DBI_WINDOW_REG_DATA_258_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_258_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_258_MASK) >> DBI_WINDOW_REG_DATA_258_LSB)
#define DBI_WINDOW_REG_DATA_258_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_258_LSB) & DBI_WINDOW_REG_DATA_258_MASK)
#define DBI_WINDOW_REG_DATA_258_RESET                                          0x0
#define DBI_WINDOW_REG_258_ADDRESS                                             (0x408 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_258_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_258_RESET                                               0x0

// 0x40c (DBI_WINDOW_REG_259)
#define DBI_WINDOW_REG_DATA_259_LSB                                            0
#define DBI_WINDOW_REG_DATA_259_MSB                                            31
#define DBI_WINDOW_REG_DATA_259_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_259_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_259_MASK) >> DBI_WINDOW_REG_DATA_259_LSB)
#define DBI_WINDOW_REG_DATA_259_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_259_LSB) & DBI_WINDOW_REG_DATA_259_MASK)
#define DBI_WINDOW_REG_DATA_259_RESET                                          0x0
#define DBI_WINDOW_REG_259_ADDRESS                                             (0x40c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_259_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_259_RESET                                               0x0

// 0x410 (DBI_WINDOW_REG_260)
#define DBI_WINDOW_REG_DATA_260_LSB                                            0
#define DBI_WINDOW_REG_DATA_260_MSB                                            31
#define DBI_WINDOW_REG_DATA_260_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_260_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_260_MASK) >> DBI_WINDOW_REG_DATA_260_LSB)
#define DBI_WINDOW_REG_DATA_260_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_260_LSB) & DBI_WINDOW_REG_DATA_260_MASK)
#define DBI_WINDOW_REG_DATA_260_RESET                                          0x0
#define DBI_WINDOW_REG_260_ADDRESS                                             (0x410 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_260_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_260_RESET                                               0x0

// 0x414 (DBI_WINDOW_REG_261)
#define DBI_WINDOW_REG_DATA_261_LSB                                            0
#define DBI_WINDOW_REG_DATA_261_MSB                                            31
#define DBI_WINDOW_REG_DATA_261_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_261_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_261_MASK) >> DBI_WINDOW_REG_DATA_261_LSB)
#define DBI_WINDOW_REG_DATA_261_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_261_LSB) & DBI_WINDOW_REG_DATA_261_MASK)
#define DBI_WINDOW_REG_DATA_261_RESET                                          0x0
#define DBI_WINDOW_REG_261_ADDRESS                                             (0x414 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_261_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_261_RESET                                               0x0

// 0x418 (DBI_WINDOW_REG_262)
#define DBI_WINDOW_REG_DATA_262_LSB                                            0
#define DBI_WINDOW_REG_DATA_262_MSB                                            31
#define DBI_WINDOW_REG_DATA_262_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_262_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_262_MASK) >> DBI_WINDOW_REG_DATA_262_LSB)
#define DBI_WINDOW_REG_DATA_262_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_262_LSB) & DBI_WINDOW_REG_DATA_262_MASK)
#define DBI_WINDOW_REG_DATA_262_RESET                                          0x0
#define DBI_WINDOW_REG_262_ADDRESS                                             (0x418 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_262_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_262_RESET                                               0x0

// 0x41c (DBI_WINDOW_REG_263)
#define DBI_WINDOW_REG_DATA_263_LSB                                            0
#define DBI_WINDOW_REG_DATA_263_MSB                                            31
#define DBI_WINDOW_REG_DATA_263_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_263_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_263_MASK) >> DBI_WINDOW_REG_DATA_263_LSB)
#define DBI_WINDOW_REG_DATA_263_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_263_LSB) & DBI_WINDOW_REG_DATA_263_MASK)
#define DBI_WINDOW_REG_DATA_263_RESET                                          0x0
#define DBI_WINDOW_REG_263_ADDRESS                                             (0x41c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_263_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_263_RESET                                               0x0

// 0x420 (DBI_WINDOW_REG_264)
#define DBI_WINDOW_REG_DATA_264_LSB                                            0
#define DBI_WINDOW_REG_DATA_264_MSB                                            31
#define DBI_WINDOW_REG_DATA_264_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_264_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_264_MASK) >> DBI_WINDOW_REG_DATA_264_LSB)
#define DBI_WINDOW_REG_DATA_264_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_264_LSB) & DBI_WINDOW_REG_DATA_264_MASK)
#define DBI_WINDOW_REG_DATA_264_RESET                                          0x0
#define DBI_WINDOW_REG_264_ADDRESS                                             (0x420 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_264_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_264_RESET                                               0x0

// 0x424 (DBI_WINDOW_REG_265)
#define DBI_WINDOW_REG_DATA_265_LSB                                            0
#define DBI_WINDOW_REG_DATA_265_MSB                                            31
#define DBI_WINDOW_REG_DATA_265_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_265_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_265_MASK) >> DBI_WINDOW_REG_DATA_265_LSB)
#define DBI_WINDOW_REG_DATA_265_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_265_LSB) & DBI_WINDOW_REG_DATA_265_MASK)
#define DBI_WINDOW_REG_DATA_265_RESET                                          0x0
#define DBI_WINDOW_REG_265_ADDRESS                                             (0x424 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_265_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_265_RESET                                               0x0

// 0x428 (DBI_WINDOW_REG_266)
#define DBI_WINDOW_REG_DATA_266_LSB                                            0
#define DBI_WINDOW_REG_DATA_266_MSB                                            31
#define DBI_WINDOW_REG_DATA_266_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_266_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_266_MASK) >> DBI_WINDOW_REG_DATA_266_LSB)
#define DBI_WINDOW_REG_DATA_266_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_266_LSB) & DBI_WINDOW_REG_DATA_266_MASK)
#define DBI_WINDOW_REG_DATA_266_RESET                                          0x0
#define DBI_WINDOW_REG_266_ADDRESS                                             (0x428 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_266_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_266_RESET                                               0x0

// 0x42c (DBI_WINDOW_REG_267)
#define DBI_WINDOW_REG_DATA_267_LSB                                            0
#define DBI_WINDOW_REG_DATA_267_MSB                                            31
#define DBI_WINDOW_REG_DATA_267_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_267_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_267_MASK) >> DBI_WINDOW_REG_DATA_267_LSB)
#define DBI_WINDOW_REG_DATA_267_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_267_LSB) & DBI_WINDOW_REG_DATA_267_MASK)
#define DBI_WINDOW_REG_DATA_267_RESET                                          0x0
#define DBI_WINDOW_REG_267_ADDRESS                                             (0x42c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_267_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_267_RESET                                               0x0

// 0x430 (DBI_WINDOW_REG_268)
#define DBI_WINDOW_REG_DATA_268_LSB                                            0
#define DBI_WINDOW_REG_DATA_268_MSB                                            31
#define DBI_WINDOW_REG_DATA_268_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_268_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_268_MASK) >> DBI_WINDOW_REG_DATA_268_LSB)
#define DBI_WINDOW_REG_DATA_268_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_268_LSB) & DBI_WINDOW_REG_DATA_268_MASK)
#define DBI_WINDOW_REG_DATA_268_RESET                                          0x0
#define DBI_WINDOW_REG_268_ADDRESS                                             (0x430 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_268_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_268_RESET                                               0x0

// 0x434 (DBI_WINDOW_REG_269)
#define DBI_WINDOW_REG_DATA_269_LSB                                            0
#define DBI_WINDOW_REG_DATA_269_MSB                                            31
#define DBI_WINDOW_REG_DATA_269_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_269_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_269_MASK) >> DBI_WINDOW_REG_DATA_269_LSB)
#define DBI_WINDOW_REG_DATA_269_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_269_LSB) & DBI_WINDOW_REG_DATA_269_MASK)
#define DBI_WINDOW_REG_DATA_269_RESET                                          0x0
#define DBI_WINDOW_REG_269_ADDRESS                                             (0x434 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_269_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_269_RESET                                               0x0

// 0x438 (DBI_WINDOW_REG_270)
#define DBI_WINDOW_REG_DATA_270_LSB                                            0
#define DBI_WINDOW_REG_DATA_270_MSB                                            31
#define DBI_WINDOW_REG_DATA_270_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_270_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_270_MASK) >> DBI_WINDOW_REG_DATA_270_LSB)
#define DBI_WINDOW_REG_DATA_270_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_270_LSB) & DBI_WINDOW_REG_DATA_270_MASK)
#define DBI_WINDOW_REG_DATA_270_RESET                                          0x0
#define DBI_WINDOW_REG_270_ADDRESS                                             (0x438 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_270_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_270_RESET                                               0x0

// 0x43c (DBI_WINDOW_REG_271)
#define DBI_WINDOW_REG_DATA_271_LSB                                            0
#define DBI_WINDOW_REG_DATA_271_MSB                                            31
#define DBI_WINDOW_REG_DATA_271_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_271_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_271_MASK) >> DBI_WINDOW_REG_DATA_271_LSB)
#define DBI_WINDOW_REG_DATA_271_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_271_LSB) & DBI_WINDOW_REG_DATA_271_MASK)
#define DBI_WINDOW_REG_DATA_271_RESET                                          0x0
#define DBI_WINDOW_REG_271_ADDRESS                                             (0x43c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_271_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_271_RESET                                               0x0

// 0x440 (DBI_WINDOW_REG_272)
#define DBI_WINDOW_REG_DATA_272_LSB                                            0
#define DBI_WINDOW_REG_DATA_272_MSB                                            31
#define DBI_WINDOW_REG_DATA_272_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_272_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_272_MASK) >> DBI_WINDOW_REG_DATA_272_LSB)
#define DBI_WINDOW_REG_DATA_272_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_272_LSB) & DBI_WINDOW_REG_DATA_272_MASK)
#define DBI_WINDOW_REG_DATA_272_RESET                                          0x0
#define DBI_WINDOW_REG_272_ADDRESS                                             (0x440 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_272_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_272_RESET                                               0x0

// 0x444 (DBI_WINDOW_REG_273)
#define DBI_WINDOW_REG_DATA_273_LSB                                            0
#define DBI_WINDOW_REG_DATA_273_MSB                                            31
#define DBI_WINDOW_REG_DATA_273_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_273_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_273_MASK) >> DBI_WINDOW_REG_DATA_273_LSB)
#define DBI_WINDOW_REG_DATA_273_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_273_LSB) & DBI_WINDOW_REG_DATA_273_MASK)
#define DBI_WINDOW_REG_DATA_273_RESET                                          0x0
#define DBI_WINDOW_REG_273_ADDRESS                                             (0x444 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_273_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_273_RESET                                               0x0

// 0x448 (DBI_WINDOW_REG_274)
#define DBI_WINDOW_REG_DATA_274_LSB                                            0
#define DBI_WINDOW_REG_DATA_274_MSB                                            31
#define DBI_WINDOW_REG_DATA_274_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_274_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_274_MASK) >> DBI_WINDOW_REG_DATA_274_LSB)
#define DBI_WINDOW_REG_DATA_274_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_274_LSB) & DBI_WINDOW_REG_DATA_274_MASK)
#define DBI_WINDOW_REG_DATA_274_RESET                                          0x0
#define DBI_WINDOW_REG_274_ADDRESS                                             (0x448 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_274_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_274_RESET                                               0x0

// 0x44c (DBI_WINDOW_REG_275)
#define DBI_WINDOW_REG_DATA_275_LSB                                            0
#define DBI_WINDOW_REG_DATA_275_MSB                                            31
#define DBI_WINDOW_REG_DATA_275_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_275_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_275_MASK) >> DBI_WINDOW_REG_DATA_275_LSB)
#define DBI_WINDOW_REG_DATA_275_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_275_LSB) & DBI_WINDOW_REG_DATA_275_MASK)
#define DBI_WINDOW_REG_DATA_275_RESET                                          0x0
#define DBI_WINDOW_REG_275_ADDRESS                                             (0x44c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_275_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_275_RESET                                               0x0

// 0x450 (DBI_WINDOW_REG_276)
#define DBI_WINDOW_REG_DATA_276_LSB                                            0
#define DBI_WINDOW_REG_DATA_276_MSB                                            31
#define DBI_WINDOW_REG_DATA_276_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_276_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_276_MASK) >> DBI_WINDOW_REG_DATA_276_LSB)
#define DBI_WINDOW_REG_DATA_276_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_276_LSB) & DBI_WINDOW_REG_DATA_276_MASK)
#define DBI_WINDOW_REG_DATA_276_RESET                                          0x0
#define DBI_WINDOW_REG_276_ADDRESS                                             (0x450 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_276_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_276_RESET                                               0x0

// 0x454 (DBI_WINDOW_REG_277)
#define DBI_WINDOW_REG_DATA_277_LSB                                            0
#define DBI_WINDOW_REG_DATA_277_MSB                                            31
#define DBI_WINDOW_REG_DATA_277_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_277_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_277_MASK) >> DBI_WINDOW_REG_DATA_277_LSB)
#define DBI_WINDOW_REG_DATA_277_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_277_LSB) & DBI_WINDOW_REG_DATA_277_MASK)
#define DBI_WINDOW_REG_DATA_277_RESET                                          0x0
#define DBI_WINDOW_REG_277_ADDRESS                                             (0x454 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_277_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_277_RESET                                               0x0

// 0x458 (DBI_WINDOW_REG_278)
#define DBI_WINDOW_REG_DATA_278_LSB                                            0
#define DBI_WINDOW_REG_DATA_278_MSB                                            31
#define DBI_WINDOW_REG_DATA_278_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_278_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_278_MASK) >> DBI_WINDOW_REG_DATA_278_LSB)
#define DBI_WINDOW_REG_DATA_278_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_278_LSB) & DBI_WINDOW_REG_DATA_278_MASK)
#define DBI_WINDOW_REG_DATA_278_RESET                                          0x0
#define DBI_WINDOW_REG_278_ADDRESS                                             (0x458 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_278_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_278_RESET                                               0x0

// 0x45c (DBI_WINDOW_REG_279)
#define DBI_WINDOW_REG_DATA_279_LSB                                            0
#define DBI_WINDOW_REG_DATA_279_MSB                                            31
#define DBI_WINDOW_REG_DATA_279_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_279_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_279_MASK) >> DBI_WINDOW_REG_DATA_279_LSB)
#define DBI_WINDOW_REG_DATA_279_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_279_LSB) & DBI_WINDOW_REG_DATA_279_MASK)
#define DBI_WINDOW_REG_DATA_279_RESET                                          0x0
#define DBI_WINDOW_REG_279_ADDRESS                                             (0x45c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_279_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_279_RESET                                               0x0

// 0x460 (DBI_WINDOW_REG_280)
#define DBI_WINDOW_REG_DATA_280_LSB                                            0
#define DBI_WINDOW_REG_DATA_280_MSB                                            31
#define DBI_WINDOW_REG_DATA_280_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_280_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_280_MASK) >> DBI_WINDOW_REG_DATA_280_LSB)
#define DBI_WINDOW_REG_DATA_280_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_280_LSB) & DBI_WINDOW_REG_DATA_280_MASK)
#define DBI_WINDOW_REG_DATA_280_RESET                                          0x0
#define DBI_WINDOW_REG_280_ADDRESS                                             (0x460 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_280_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_280_RESET                                               0x0

// 0x464 (DBI_WINDOW_REG_281)
#define DBI_WINDOW_REG_DATA_281_LSB                                            0
#define DBI_WINDOW_REG_DATA_281_MSB                                            31
#define DBI_WINDOW_REG_DATA_281_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_281_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_281_MASK) >> DBI_WINDOW_REG_DATA_281_LSB)
#define DBI_WINDOW_REG_DATA_281_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_281_LSB) & DBI_WINDOW_REG_DATA_281_MASK)
#define DBI_WINDOW_REG_DATA_281_RESET                                          0x0
#define DBI_WINDOW_REG_281_ADDRESS                                             (0x464 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_281_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_281_RESET                                               0x0

// 0x468 (DBI_WINDOW_REG_282)
#define DBI_WINDOW_REG_DATA_282_LSB                                            0
#define DBI_WINDOW_REG_DATA_282_MSB                                            31
#define DBI_WINDOW_REG_DATA_282_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_282_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_282_MASK) >> DBI_WINDOW_REG_DATA_282_LSB)
#define DBI_WINDOW_REG_DATA_282_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_282_LSB) & DBI_WINDOW_REG_DATA_282_MASK)
#define DBI_WINDOW_REG_DATA_282_RESET                                          0x0
#define DBI_WINDOW_REG_282_ADDRESS                                             (0x468 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_282_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_282_RESET                                               0x0

// 0x46c (DBI_WINDOW_REG_283)
#define DBI_WINDOW_REG_DATA_283_LSB                                            0
#define DBI_WINDOW_REG_DATA_283_MSB                                            31
#define DBI_WINDOW_REG_DATA_283_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_283_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_283_MASK) >> DBI_WINDOW_REG_DATA_283_LSB)
#define DBI_WINDOW_REG_DATA_283_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_283_LSB) & DBI_WINDOW_REG_DATA_283_MASK)
#define DBI_WINDOW_REG_DATA_283_RESET                                          0x0
#define DBI_WINDOW_REG_283_ADDRESS                                             (0x46c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_283_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_283_RESET                                               0x0

// 0x470 (DBI_WINDOW_REG_284)
#define DBI_WINDOW_REG_DATA_284_LSB                                            0
#define DBI_WINDOW_REG_DATA_284_MSB                                            31
#define DBI_WINDOW_REG_DATA_284_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_284_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_284_MASK) >> DBI_WINDOW_REG_DATA_284_LSB)
#define DBI_WINDOW_REG_DATA_284_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_284_LSB) & DBI_WINDOW_REG_DATA_284_MASK)
#define DBI_WINDOW_REG_DATA_284_RESET                                          0x0
#define DBI_WINDOW_REG_284_ADDRESS                                             (0x470 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_284_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_284_RESET                                               0x0

// 0x474 (DBI_WINDOW_REG_285)
#define DBI_WINDOW_REG_DATA_285_LSB                                            0
#define DBI_WINDOW_REG_DATA_285_MSB                                            31
#define DBI_WINDOW_REG_DATA_285_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_285_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_285_MASK) >> DBI_WINDOW_REG_DATA_285_LSB)
#define DBI_WINDOW_REG_DATA_285_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_285_LSB) & DBI_WINDOW_REG_DATA_285_MASK)
#define DBI_WINDOW_REG_DATA_285_RESET                                          0x0
#define DBI_WINDOW_REG_285_ADDRESS                                             (0x474 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_285_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_285_RESET                                               0x0

// 0x478 (DBI_WINDOW_REG_286)
#define DBI_WINDOW_REG_DATA_286_LSB                                            0
#define DBI_WINDOW_REG_DATA_286_MSB                                            31
#define DBI_WINDOW_REG_DATA_286_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_286_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_286_MASK) >> DBI_WINDOW_REG_DATA_286_LSB)
#define DBI_WINDOW_REG_DATA_286_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_286_LSB) & DBI_WINDOW_REG_DATA_286_MASK)
#define DBI_WINDOW_REG_DATA_286_RESET                                          0x0
#define DBI_WINDOW_REG_286_ADDRESS                                             (0x478 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_286_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_286_RESET                                               0x0

// 0x47c (DBI_WINDOW_REG_287)
#define DBI_WINDOW_REG_DATA_287_LSB                                            0
#define DBI_WINDOW_REG_DATA_287_MSB                                            31
#define DBI_WINDOW_REG_DATA_287_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_287_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_287_MASK) >> DBI_WINDOW_REG_DATA_287_LSB)
#define DBI_WINDOW_REG_DATA_287_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_287_LSB) & DBI_WINDOW_REG_DATA_287_MASK)
#define DBI_WINDOW_REG_DATA_287_RESET                                          0x0
#define DBI_WINDOW_REG_287_ADDRESS                                             (0x47c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_287_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_287_RESET                                               0x0

// 0x480 (DBI_WINDOW_REG_288)
#define DBI_WINDOW_REG_DATA_288_LSB                                            0
#define DBI_WINDOW_REG_DATA_288_MSB                                            31
#define DBI_WINDOW_REG_DATA_288_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_288_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_288_MASK) >> DBI_WINDOW_REG_DATA_288_LSB)
#define DBI_WINDOW_REG_DATA_288_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_288_LSB) & DBI_WINDOW_REG_DATA_288_MASK)
#define DBI_WINDOW_REG_DATA_288_RESET                                          0x0
#define DBI_WINDOW_REG_288_ADDRESS                                             (0x480 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_288_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_288_RESET                                               0x0

// 0x484 (DBI_WINDOW_REG_289)
#define DBI_WINDOW_REG_DATA_289_LSB                                            0
#define DBI_WINDOW_REG_DATA_289_MSB                                            31
#define DBI_WINDOW_REG_DATA_289_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_289_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_289_MASK) >> DBI_WINDOW_REG_DATA_289_LSB)
#define DBI_WINDOW_REG_DATA_289_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_289_LSB) & DBI_WINDOW_REG_DATA_289_MASK)
#define DBI_WINDOW_REG_DATA_289_RESET                                          0x0
#define DBI_WINDOW_REG_289_ADDRESS                                             (0x484 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_289_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_289_RESET                                               0x0

// 0x488 (DBI_WINDOW_REG_290)
#define DBI_WINDOW_REG_DATA_290_LSB                                            0
#define DBI_WINDOW_REG_DATA_290_MSB                                            31
#define DBI_WINDOW_REG_DATA_290_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_290_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_290_MASK) >> DBI_WINDOW_REG_DATA_290_LSB)
#define DBI_WINDOW_REG_DATA_290_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_290_LSB) & DBI_WINDOW_REG_DATA_290_MASK)
#define DBI_WINDOW_REG_DATA_290_RESET                                          0x0
#define DBI_WINDOW_REG_290_ADDRESS                                             (0x488 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_290_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_290_RESET                                               0x0

// 0x48c (DBI_WINDOW_REG_291)
#define DBI_WINDOW_REG_DATA_291_LSB                                            0
#define DBI_WINDOW_REG_DATA_291_MSB                                            31
#define DBI_WINDOW_REG_DATA_291_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_291_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_291_MASK) >> DBI_WINDOW_REG_DATA_291_LSB)
#define DBI_WINDOW_REG_DATA_291_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_291_LSB) & DBI_WINDOW_REG_DATA_291_MASK)
#define DBI_WINDOW_REG_DATA_291_RESET                                          0x0
#define DBI_WINDOW_REG_291_ADDRESS                                             (0x48c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_291_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_291_RESET                                               0x0

// 0x490 (DBI_WINDOW_REG_292)
#define DBI_WINDOW_REG_DATA_292_LSB                                            0
#define DBI_WINDOW_REG_DATA_292_MSB                                            31
#define DBI_WINDOW_REG_DATA_292_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_292_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_292_MASK) >> DBI_WINDOW_REG_DATA_292_LSB)
#define DBI_WINDOW_REG_DATA_292_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_292_LSB) & DBI_WINDOW_REG_DATA_292_MASK)
#define DBI_WINDOW_REG_DATA_292_RESET                                          0x0
#define DBI_WINDOW_REG_292_ADDRESS                                             (0x490 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_292_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_292_RESET                                               0x0

// 0x494 (DBI_WINDOW_REG_293)
#define DBI_WINDOW_REG_DATA_293_LSB                                            0
#define DBI_WINDOW_REG_DATA_293_MSB                                            31
#define DBI_WINDOW_REG_DATA_293_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_293_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_293_MASK) >> DBI_WINDOW_REG_DATA_293_LSB)
#define DBI_WINDOW_REG_DATA_293_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_293_LSB) & DBI_WINDOW_REG_DATA_293_MASK)
#define DBI_WINDOW_REG_DATA_293_RESET                                          0x0
#define DBI_WINDOW_REG_293_ADDRESS                                             (0x494 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_293_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_293_RESET                                               0x0

// 0x498 (DBI_WINDOW_REG_294)
#define DBI_WINDOW_REG_DATA_294_LSB                                            0
#define DBI_WINDOW_REG_DATA_294_MSB                                            31
#define DBI_WINDOW_REG_DATA_294_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_294_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_294_MASK) >> DBI_WINDOW_REG_DATA_294_LSB)
#define DBI_WINDOW_REG_DATA_294_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_294_LSB) & DBI_WINDOW_REG_DATA_294_MASK)
#define DBI_WINDOW_REG_DATA_294_RESET                                          0x0
#define DBI_WINDOW_REG_294_ADDRESS                                             (0x498 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_294_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_294_RESET                                               0x0

// 0x49c (DBI_WINDOW_REG_295)
#define DBI_WINDOW_REG_DATA_295_LSB                                            0
#define DBI_WINDOW_REG_DATA_295_MSB                                            31
#define DBI_WINDOW_REG_DATA_295_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_295_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_295_MASK) >> DBI_WINDOW_REG_DATA_295_LSB)
#define DBI_WINDOW_REG_DATA_295_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_295_LSB) & DBI_WINDOW_REG_DATA_295_MASK)
#define DBI_WINDOW_REG_DATA_295_RESET                                          0x0
#define DBI_WINDOW_REG_295_ADDRESS                                             (0x49c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_295_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_295_RESET                                               0x0

// 0x4a0 (DBI_WINDOW_REG_296)
#define DBI_WINDOW_REG_DATA_296_LSB                                            0
#define DBI_WINDOW_REG_DATA_296_MSB                                            31
#define DBI_WINDOW_REG_DATA_296_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_296_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_296_MASK) >> DBI_WINDOW_REG_DATA_296_LSB)
#define DBI_WINDOW_REG_DATA_296_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_296_LSB) & DBI_WINDOW_REG_DATA_296_MASK)
#define DBI_WINDOW_REG_DATA_296_RESET                                          0x0
#define DBI_WINDOW_REG_296_ADDRESS                                             (0x4a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_296_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_296_RESET                                               0x0

// 0x4a4 (DBI_WINDOW_REG_297)
#define DBI_WINDOW_REG_DATA_297_LSB                                            0
#define DBI_WINDOW_REG_DATA_297_MSB                                            31
#define DBI_WINDOW_REG_DATA_297_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_297_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_297_MASK) >> DBI_WINDOW_REG_DATA_297_LSB)
#define DBI_WINDOW_REG_DATA_297_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_297_LSB) & DBI_WINDOW_REG_DATA_297_MASK)
#define DBI_WINDOW_REG_DATA_297_RESET                                          0x0
#define DBI_WINDOW_REG_297_ADDRESS                                             (0x4a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_297_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_297_RESET                                               0x0

// 0x4a8 (DBI_WINDOW_REG_298)
#define DBI_WINDOW_REG_DATA_298_LSB                                            0
#define DBI_WINDOW_REG_DATA_298_MSB                                            31
#define DBI_WINDOW_REG_DATA_298_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_298_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_298_MASK) >> DBI_WINDOW_REG_DATA_298_LSB)
#define DBI_WINDOW_REG_DATA_298_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_298_LSB) & DBI_WINDOW_REG_DATA_298_MASK)
#define DBI_WINDOW_REG_DATA_298_RESET                                          0x0
#define DBI_WINDOW_REG_298_ADDRESS                                             (0x4a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_298_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_298_RESET                                               0x0

// 0x4ac (DBI_WINDOW_REG_299)
#define DBI_WINDOW_REG_DATA_299_LSB                                            0
#define DBI_WINDOW_REG_DATA_299_MSB                                            31
#define DBI_WINDOW_REG_DATA_299_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_299_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_299_MASK) >> DBI_WINDOW_REG_DATA_299_LSB)
#define DBI_WINDOW_REG_DATA_299_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_299_LSB) & DBI_WINDOW_REG_DATA_299_MASK)
#define DBI_WINDOW_REG_DATA_299_RESET                                          0x0
#define DBI_WINDOW_REG_299_ADDRESS                                             (0x4ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_299_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_299_RESET                                               0x0

// 0x4b0 (DBI_WINDOW_REG_300)
#define DBI_WINDOW_REG_DATA_300_LSB                                            0
#define DBI_WINDOW_REG_DATA_300_MSB                                            31
#define DBI_WINDOW_REG_DATA_300_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_300_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_300_MASK) >> DBI_WINDOW_REG_DATA_300_LSB)
#define DBI_WINDOW_REG_DATA_300_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_300_LSB) & DBI_WINDOW_REG_DATA_300_MASK)
#define DBI_WINDOW_REG_DATA_300_RESET                                          0x0
#define DBI_WINDOW_REG_300_ADDRESS                                             (0x4b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_300_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_300_RESET                                               0x0

// 0x4b4 (DBI_WINDOW_REG_301)
#define DBI_WINDOW_REG_DATA_301_LSB                                            0
#define DBI_WINDOW_REG_DATA_301_MSB                                            31
#define DBI_WINDOW_REG_DATA_301_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_301_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_301_MASK) >> DBI_WINDOW_REG_DATA_301_LSB)
#define DBI_WINDOW_REG_DATA_301_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_301_LSB) & DBI_WINDOW_REG_DATA_301_MASK)
#define DBI_WINDOW_REG_DATA_301_RESET                                          0x0
#define DBI_WINDOW_REG_301_ADDRESS                                             (0x4b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_301_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_301_RESET                                               0x0

// 0x4b8 (DBI_WINDOW_REG_302)
#define DBI_WINDOW_REG_DATA_302_LSB                                            0
#define DBI_WINDOW_REG_DATA_302_MSB                                            31
#define DBI_WINDOW_REG_DATA_302_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_302_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_302_MASK) >> DBI_WINDOW_REG_DATA_302_LSB)
#define DBI_WINDOW_REG_DATA_302_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_302_LSB) & DBI_WINDOW_REG_DATA_302_MASK)
#define DBI_WINDOW_REG_DATA_302_RESET                                          0x0
#define DBI_WINDOW_REG_302_ADDRESS                                             (0x4b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_302_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_302_RESET                                               0x0

// 0x4bc (DBI_WINDOW_REG_303)
#define DBI_WINDOW_REG_DATA_303_LSB                                            0
#define DBI_WINDOW_REG_DATA_303_MSB                                            31
#define DBI_WINDOW_REG_DATA_303_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_303_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_303_MASK) >> DBI_WINDOW_REG_DATA_303_LSB)
#define DBI_WINDOW_REG_DATA_303_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_303_LSB) & DBI_WINDOW_REG_DATA_303_MASK)
#define DBI_WINDOW_REG_DATA_303_RESET                                          0x0
#define DBI_WINDOW_REG_303_ADDRESS                                             (0x4bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_303_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_303_RESET                                               0x0

// 0x4c0 (DBI_WINDOW_REG_304)
#define DBI_WINDOW_REG_DATA_304_LSB                                            0
#define DBI_WINDOW_REG_DATA_304_MSB                                            31
#define DBI_WINDOW_REG_DATA_304_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_304_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_304_MASK) >> DBI_WINDOW_REG_DATA_304_LSB)
#define DBI_WINDOW_REG_DATA_304_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_304_LSB) & DBI_WINDOW_REG_DATA_304_MASK)
#define DBI_WINDOW_REG_DATA_304_RESET                                          0x0
#define DBI_WINDOW_REG_304_ADDRESS                                             (0x4c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_304_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_304_RESET                                               0x0

// 0x4c4 (DBI_WINDOW_REG_305)
#define DBI_WINDOW_REG_DATA_305_LSB                                            0
#define DBI_WINDOW_REG_DATA_305_MSB                                            31
#define DBI_WINDOW_REG_DATA_305_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_305_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_305_MASK) >> DBI_WINDOW_REG_DATA_305_LSB)
#define DBI_WINDOW_REG_DATA_305_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_305_LSB) & DBI_WINDOW_REG_DATA_305_MASK)
#define DBI_WINDOW_REG_DATA_305_RESET                                          0x0
#define DBI_WINDOW_REG_305_ADDRESS                                             (0x4c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_305_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_305_RESET                                               0x0

// 0x4c8 (DBI_WINDOW_REG_306)
#define DBI_WINDOW_REG_DATA_306_LSB                                            0
#define DBI_WINDOW_REG_DATA_306_MSB                                            31
#define DBI_WINDOW_REG_DATA_306_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_306_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_306_MASK) >> DBI_WINDOW_REG_DATA_306_LSB)
#define DBI_WINDOW_REG_DATA_306_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_306_LSB) & DBI_WINDOW_REG_DATA_306_MASK)
#define DBI_WINDOW_REG_DATA_306_RESET                                          0x0
#define DBI_WINDOW_REG_306_ADDRESS                                             (0x4c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_306_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_306_RESET                                               0x0

// 0x4cc (DBI_WINDOW_REG_307)
#define DBI_WINDOW_REG_DATA_307_LSB                                            0
#define DBI_WINDOW_REG_DATA_307_MSB                                            31
#define DBI_WINDOW_REG_DATA_307_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_307_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_307_MASK) >> DBI_WINDOW_REG_DATA_307_LSB)
#define DBI_WINDOW_REG_DATA_307_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_307_LSB) & DBI_WINDOW_REG_DATA_307_MASK)
#define DBI_WINDOW_REG_DATA_307_RESET                                          0x0
#define DBI_WINDOW_REG_307_ADDRESS                                             (0x4cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_307_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_307_RESET                                               0x0

// 0x4d0 (DBI_WINDOW_REG_308)
#define DBI_WINDOW_REG_DATA_308_LSB                                            0
#define DBI_WINDOW_REG_DATA_308_MSB                                            31
#define DBI_WINDOW_REG_DATA_308_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_308_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_308_MASK) >> DBI_WINDOW_REG_DATA_308_LSB)
#define DBI_WINDOW_REG_DATA_308_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_308_LSB) & DBI_WINDOW_REG_DATA_308_MASK)
#define DBI_WINDOW_REG_DATA_308_RESET                                          0x0
#define DBI_WINDOW_REG_308_ADDRESS                                             (0x4d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_308_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_308_RESET                                               0x0

// 0x4d4 (DBI_WINDOW_REG_309)
#define DBI_WINDOW_REG_DATA_309_LSB                                            0
#define DBI_WINDOW_REG_DATA_309_MSB                                            31
#define DBI_WINDOW_REG_DATA_309_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_309_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_309_MASK) >> DBI_WINDOW_REG_DATA_309_LSB)
#define DBI_WINDOW_REG_DATA_309_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_309_LSB) & DBI_WINDOW_REG_DATA_309_MASK)
#define DBI_WINDOW_REG_DATA_309_RESET                                          0x0
#define DBI_WINDOW_REG_309_ADDRESS                                             (0x4d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_309_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_309_RESET                                               0x0

// 0x4d8 (DBI_WINDOW_REG_310)
#define DBI_WINDOW_REG_DATA_310_LSB                                            0
#define DBI_WINDOW_REG_DATA_310_MSB                                            31
#define DBI_WINDOW_REG_DATA_310_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_310_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_310_MASK) >> DBI_WINDOW_REG_DATA_310_LSB)
#define DBI_WINDOW_REG_DATA_310_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_310_LSB) & DBI_WINDOW_REG_DATA_310_MASK)
#define DBI_WINDOW_REG_DATA_310_RESET                                          0x0
#define DBI_WINDOW_REG_310_ADDRESS                                             (0x4d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_310_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_310_RESET                                               0x0

// 0x4dc (DBI_WINDOW_REG_311)
#define DBI_WINDOW_REG_DATA_311_LSB                                            0
#define DBI_WINDOW_REG_DATA_311_MSB                                            31
#define DBI_WINDOW_REG_DATA_311_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_311_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_311_MASK) >> DBI_WINDOW_REG_DATA_311_LSB)
#define DBI_WINDOW_REG_DATA_311_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_311_LSB) & DBI_WINDOW_REG_DATA_311_MASK)
#define DBI_WINDOW_REG_DATA_311_RESET                                          0x0
#define DBI_WINDOW_REG_311_ADDRESS                                             (0x4dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_311_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_311_RESET                                               0x0

// 0x4e0 (DBI_WINDOW_REG_312)
#define DBI_WINDOW_REG_DATA_312_LSB                                            0
#define DBI_WINDOW_REG_DATA_312_MSB                                            31
#define DBI_WINDOW_REG_DATA_312_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_312_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_312_MASK) >> DBI_WINDOW_REG_DATA_312_LSB)
#define DBI_WINDOW_REG_DATA_312_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_312_LSB) & DBI_WINDOW_REG_DATA_312_MASK)
#define DBI_WINDOW_REG_DATA_312_RESET                                          0x0
#define DBI_WINDOW_REG_312_ADDRESS                                             (0x4e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_312_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_312_RESET                                               0x0

// 0x4e4 (DBI_WINDOW_REG_313)
#define DBI_WINDOW_REG_DATA_313_LSB                                            0
#define DBI_WINDOW_REG_DATA_313_MSB                                            31
#define DBI_WINDOW_REG_DATA_313_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_313_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_313_MASK) >> DBI_WINDOW_REG_DATA_313_LSB)
#define DBI_WINDOW_REG_DATA_313_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_313_LSB) & DBI_WINDOW_REG_DATA_313_MASK)
#define DBI_WINDOW_REG_DATA_313_RESET                                          0x0
#define DBI_WINDOW_REG_313_ADDRESS                                             (0x4e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_313_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_313_RESET                                               0x0

// 0x4e8 (DBI_WINDOW_REG_314)
#define DBI_WINDOW_REG_DATA_314_LSB                                            0
#define DBI_WINDOW_REG_DATA_314_MSB                                            31
#define DBI_WINDOW_REG_DATA_314_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_314_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_314_MASK) >> DBI_WINDOW_REG_DATA_314_LSB)
#define DBI_WINDOW_REG_DATA_314_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_314_LSB) & DBI_WINDOW_REG_DATA_314_MASK)
#define DBI_WINDOW_REG_DATA_314_RESET                                          0x0
#define DBI_WINDOW_REG_314_ADDRESS                                             (0x4e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_314_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_314_RESET                                               0x0

// 0x4ec (DBI_WINDOW_REG_315)
#define DBI_WINDOW_REG_DATA_315_LSB                                            0
#define DBI_WINDOW_REG_DATA_315_MSB                                            31
#define DBI_WINDOW_REG_DATA_315_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_315_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_315_MASK) >> DBI_WINDOW_REG_DATA_315_LSB)
#define DBI_WINDOW_REG_DATA_315_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_315_LSB) & DBI_WINDOW_REG_DATA_315_MASK)
#define DBI_WINDOW_REG_DATA_315_RESET                                          0x0
#define DBI_WINDOW_REG_315_ADDRESS                                             (0x4ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_315_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_315_RESET                                               0x0

// 0x4f0 (DBI_WINDOW_REG_316)
#define DBI_WINDOW_REG_DATA_316_LSB                                            0
#define DBI_WINDOW_REG_DATA_316_MSB                                            31
#define DBI_WINDOW_REG_DATA_316_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_316_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_316_MASK) >> DBI_WINDOW_REG_DATA_316_LSB)
#define DBI_WINDOW_REG_DATA_316_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_316_LSB) & DBI_WINDOW_REG_DATA_316_MASK)
#define DBI_WINDOW_REG_DATA_316_RESET                                          0x0
#define DBI_WINDOW_REG_316_ADDRESS                                             (0x4f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_316_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_316_RESET                                               0x0

// 0x4f4 (DBI_WINDOW_REG_317)
#define DBI_WINDOW_REG_DATA_317_LSB                                            0
#define DBI_WINDOW_REG_DATA_317_MSB                                            31
#define DBI_WINDOW_REG_DATA_317_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_317_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_317_MASK) >> DBI_WINDOW_REG_DATA_317_LSB)
#define DBI_WINDOW_REG_DATA_317_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_317_LSB) & DBI_WINDOW_REG_DATA_317_MASK)
#define DBI_WINDOW_REG_DATA_317_RESET                                          0x0
#define DBI_WINDOW_REG_317_ADDRESS                                             (0x4f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_317_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_317_RESET                                               0x0

// 0x4f8 (DBI_WINDOW_REG_318)
#define DBI_WINDOW_REG_DATA_318_LSB                                            0
#define DBI_WINDOW_REG_DATA_318_MSB                                            31
#define DBI_WINDOW_REG_DATA_318_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_318_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_318_MASK) >> DBI_WINDOW_REG_DATA_318_LSB)
#define DBI_WINDOW_REG_DATA_318_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_318_LSB) & DBI_WINDOW_REG_DATA_318_MASK)
#define DBI_WINDOW_REG_DATA_318_RESET                                          0x0
#define DBI_WINDOW_REG_318_ADDRESS                                             (0x4f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_318_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_318_RESET                                               0x0

// 0x4fc (DBI_WINDOW_REG_319)
#define DBI_WINDOW_REG_DATA_319_LSB                                            0
#define DBI_WINDOW_REG_DATA_319_MSB                                            31
#define DBI_WINDOW_REG_DATA_319_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_319_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_319_MASK) >> DBI_WINDOW_REG_DATA_319_LSB)
#define DBI_WINDOW_REG_DATA_319_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_319_LSB) & DBI_WINDOW_REG_DATA_319_MASK)
#define DBI_WINDOW_REG_DATA_319_RESET                                          0x0
#define DBI_WINDOW_REG_319_ADDRESS                                             (0x4fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_319_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_319_RESET                                               0x0

// 0x500 (DBI_WINDOW_REG_320)
#define DBI_WINDOW_REG_DATA_320_LSB                                            0
#define DBI_WINDOW_REG_DATA_320_MSB                                            31
#define DBI_WINDOW_REG_DATA_320_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_320_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_320_MASK) >> DBI_WINDOW_REG_DATA_320_LSB)
#define DBI_WINDOW_REG_DATA_320_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_320_LSB) & DBI_WINDOW_REG_DATA_320_MASK)
#define DBI_WINDOW_REG_DATA_320_RESET                                          0x0
#define DBI_WINDOW_REG_320_ADDRESS                                             (0x500 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_320_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_320_RESET                                               0x0

// 0x504 (DBI_WINDOW_REG_321)
#define DBI_WINDOW_REG_DATA_321_LSB                                            0
#define DBI_WINDOW_REG_DATA_321_MSB                                            31
#define DBI_WINDOW_REG_DATA_321_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_321_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_321_MASK) >> DBI_WINDOW_REG_DATA_321_LSB)
#define DBI_WINDOW_REG_DATA_321_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_321_LSB) & DBI_WINDOW_REG_DATA_321_MASK)
#define DBI_WINDOW_REG_DATA_321_RESET                                          0x0
#define DBI_WINDOW_REG_321_ADDRESS                                             (0x504 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_321_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_321_RESET                                               0x0

// 0x508 (DBI_WINDOW_REG_322)
#define DBI_WINDOW_REG_DATA_322_LSB                                            0
#define DBI_WINDOW_REG_DATA_322_MSB                                            31
#define DBI_WINDOW_REG_DATA_322_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_322_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_322_MASK) >> DBI_WINDOW_REG_DATA_322_LSB)
#define DBI_WINDOW_REG_DATA_322_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_322_LSB) & DBI_WINDOW_REG_DATA_322_MASK)
#define DBI_WINDOW_REG_DATA_322_RESET                                          0x0
#define DBI_WINDOW_REG_322_ADDRESS                                             (0x508 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_322_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_322_RESET                                               0x0

// 0x50c (DBI_WINDOW_REG_323)
#define DBI_WINDOW_REG_DATA_323_LSB                                            0
#define DBI_WINDOW_REG_DATA_323_MSB                                            31
#define DBI_WINDOW_REG_DATA_323_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_323_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_323_MASK) >> DBI_WINDOW_REG_DATA_323_LSB)
#define DBI_WINDOW_REG_DATA_323_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_323_LSB) & DBI_WINDOW_REG_DATA_323_MASK)
#define DBI_WINDOW_REG_DATA_323_RESET                                          0x0
#define DBI_WINDOW_REG_323_ADDRESS                                             (0x50c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_323_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_323_RESET                                               0x0

// 0x510 (DBI_WINDOW_REG_324)
#define DBI_WINDOW_REG_DATA_324_LSB                                            0
#define DBI_WINDOW_REG_DATA_324_MSB                                            31
#define DBI_WINDOW_REG_DATA_324_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_324_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_324_MASK) >> DBI_WINDOW_REG_DATA_324_LSB)
#define DBI_WINDOW_REG_DATA_324_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_324_LSB) & DBI_WINDOW_REG_DATA_324_MASK)
#define DBI_WINDOW_REG_DATA_324_RESET                                          0x0
#define DBI_WINDOW_REG_324_ADDRESS                                             (0x510 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_324_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_324_RESET                                               0x0

// 0x514 (DBI_WINDOW_REG_325)
#define DBI_WINDOW_REG_DATA_325_LSB                                            0
#define DBI_WINDOW_REG_DATA_325_MSB                                            31
#define DBI_WINDOW_REG_DATA_325_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_325_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_325_MASK) >> DBI_WINDOW_REG_DATA_325_LSB)
#define DBI_WINDOW_REG_DATA_325_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_325_LSB) & DBI_WINDOW_REG_DATA_325_MASK)
#define DBI_WINDOW_REG_DATA_325_RESET                                          0x0
#define DBI_WINDOW_REG_325_ADDRESS                                             (0x514 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_325_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_325_RESET                                               0x0

// 0x518 (DBI_WINDOW_REG_326)
#define DBI_WINDOW_REG_DATA_326_LSB                                            0
#define DBI_WINDOW_REG_DATA_326_MSB                                            31
#define DBI_WINDOW_REG_DATA_326_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_326_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_326_MASK) >> DBI_WINDOW_REG_DATA_326_LSB)
#define DBI_WINDOW_REG_DATA_326_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_326_LSB) & DBI_WINDOW_REG_DATA_326_MASK)
#define DBI_WINDOW_REG_DATA_326_RESET                                          0x0
#define DBI_WINDOW_REG_326_ADDRESS                                             (0x518 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_326_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_326_RESET                                               0x0

// 0x51c (DBI_WINDOW_REG_327)
#define DBI_WINDOW_REG_DATA_327_LSB                                            0
#define DBI_WINDOW_REG_DATA_327_MSB                                            31
#define DBI_WINDOW_REG_DATA_327_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_327_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_327_MASK) >> DBI_WINDOW_REG_DATA_327_LSB)
#define DBI_WINDOW_REG_DATA_327_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_327_LSB) & DBI_WINDOW_REG_DATA_327_MASK)
#define DBI_WINDOW_REG_DATA_327_RESET                                          0x0
#define DBI_WINDOW_REG_327_ADDRESS                                             (0x51c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_327_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_327_RESET                                               0x0

// 0x520 (DBI_WINDOW_REG_328)
#define DBI_WINDOW_REG_DATA_328_LSB                                            0
#define DBI_WINDOW_REG_DATA_328_MSB                                            31
#define DBI_WINDOW_REG_DATA_328_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_328_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_328_MASK) >> DBI_WINDOW_REG_DATA_328_LSB)
#define DBI_WINDOW_REG_DATA_328_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_328_LSB) & DBI_WINDOW_REG_DATA_328_MASK)
#define DBI_WINDOW_REG_DATA_328_RESET                                          0x0
#define DBI_WINDOW_REG_328_ADDRESS                                             (0x520 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_328_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_328_RESET                                               0x0

// 0x524 (DBI_WINDOW_REG_329)
#define DBI_WINDOW_REG_DATA_329_LSB                                            0
#define DBI_WINDOW_REG_DATA_329_MSB                                            31
#define DBI_WINDOW_REG_DATA_329_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_329_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_329_MASK) >> DBI_WINDOW_REG_DATA_329_LSB)
#define DBI_WINDOW_REG_DATA_329_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_329_LSB) & DBI_WINDOW_REG_DATA_329_MASK)
#define DBI_WINDOW_REG_DATA_329_RESET                                          0x0
#define DBI_WINDOW_REG_329_ADDRESS                                             (0x524 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_329_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_329_RESET                                               0x0

// 0x528 (DBI_WINDOW_REG_330)
#define DBI_WINDOW_REG_DATA_330_LSB                                            0
#define DBI_WINDOW_REG_DATA_330_MSB                                            31
#define DBI_WINDOW_REG_DATA_330_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_330_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_330_MASK) >> DBI_WINDOW_REG_DATA_330_LSB)
#define DBI_WINDOW_REG_DATA_330_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_330_LSB) & DBI_WINDOW_REG_DATA_330_MASK)
#define DBI_WINDOW_REG_DATA_330_RESET                                          0x0
#define DBI_WINDOW_REG_330_ADDRESS                                             (0x528 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_330_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_330_RESET                                               0x0

// 0x52c (DBI_WINDOW_REG_331)
#define DBI_WINDOW_REG_DATA_331_LSB                                            0
#define DBI_WINDOW_REG_DATA_331_MSB                                            31
#define DBI_WINDOW_REG_DATA_331_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_331_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_331_MASK) >> DBI_WINDOW_REG_DATA_331_LSB)
#define DBI_WINDOW_REG_DATA_331_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_331_LSB) & DBI_WINDOW_REG_DATA_331_MASK)
#define DBI_WINDOW_REG_DATA_331_RESET                                          0x0
#define DBI_WINDOW_REG_331_ADDRESS                                             (0x52c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_331_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_331_RESET                                               0x0

// 0x530 (DBI_WINDOW_REG_332)
#define DBI_WINDOW_REG_DATA_332_LSB                                            0
#define DBI_WINDOW_REG_DATA_332_MSB                                            31
#define DBI_WINDOW_REG_DATA_332_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_332_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_332_MASK) >> DBI_WINDOW_REG_DATA_332_LSB)
#define DBI_WINDOW_REG_DATA_332_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_332_LSB) & DBI_WINDOW_REG_DATA_332_MASK)
#define DBI_WINDOW_REG_DATA_332_RESET                                          0x0
#define DBI_WINDOW_REG_332_ADDRESS                                             (0x530 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_332_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_332_RESET                                               0x0

// 0x534 (DBI_WINDOW_REG_333)
#define DBI_WINDOW_REG_DATA_333_LSB                                            0
#define DBI_WINDOW_REG_DATA_333_MSB                                            31
#define DBI_WINDOW_REG_DATA_333_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_333_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_333_MASK) >> DBI_WINDOW_REG_DATA_333_LSB)
#define DBI_WINDOW_REG_DATA_333_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_333_LSB) & DBI_WINDOW_REG_DATA_333_MASK)
#define DBI_WINDOW_REG_DATA_333_RESET                                          0x0
#define DBI_WINDOW_REG_333_ADDRESS                                             (0x534 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_333_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_333_RESET                                               0x0

// 0x538 (DBI_WINDOW_REG_334)
#define DBI_WINDOW_REG_DATA_334_LSB                                            0
#define DBI_WINDOW_REG_DATA_334_MSB                                            31
#define DBI_WINDOW_REG_DATA_334_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_334_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_334_MASK) >> DBI_WINDOW_REG_DATA_334_LSB)
#define DBI_WINDOW_REG_DATA_334_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_334_LSB) & DBI_WINDOW_REG_DATA_334_MASK)
#define DBI_WINDOW_REG_DATA_334_RESET                                          0x0
#define DBI_WINDOW_REG_334_ADDRESS                                             (0x538 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_334_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_334_RESET                                               0x0

// 0x53c (DBI_WINDOW_REG_335)
#define DBI_WINDOW_REG_DATA_335_LSB                                            0
#define DBI_WINDOW_REG_DATA_335_MSB                                            31
#define DBI_WINDOW_REG_DATA_335_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_335_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_335_MASK) >> DBI_WINDOW_REG_DATA_335_LSB)
#define DBI_WINDOW_REG_DATA_335_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_335_LSB) & DBI_WINDOW_REG_DATA_335_MASK)
#define DBI_WINDOW_REG_DATA_335_RESET                                          0x0
#define DBI_WINDOW_REG_335_ADDRESS                                             (0x53c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_335_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_335_RESET                                               0x0

// 0x540 (DBI_WINDOW_REG_336)
#define DBI_WINDOW_REG_DATA_336_LSB                                            0
#define DBI_WINDOW_REG_DATA_336_MSB                                            31
#define DBI_WINDOW_REG_DATA_336_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_336_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_336_MASK) >> DBI_WINDOW_REG_DATA_336_LSB)
#define DBI_WINDOW_REG_DATA_336_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_336_LSB) & DBI_WINDOW_REG_DATA_336_MASK)
#define DBI_WINDOW_REG_DATA_336_RESET                                          0x0
#define DBI_WINDOW_REG_336_ADDRESS                                             (0x540 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_336_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_336_RESET                                               0x0

// 0x544 (DBI_WINDOW_REG_337)
#define DBI_WINDOW_REG_DATA_337_LSB                                            0
#define DBI_WINDOW_REG_DATA_337_MSB                                            31
#define DBI_WINDOW_REG_DATA_337_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_337_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_337_MASK) >> DBI_WINDOW_REG_DATA_337_LSB)
#define DBI_WINDOW_REG_DATA_337_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_337_LSB) & DBI_WINDOW_REG_DATA_337_MASK)
#define DBI_WINDOW_REG_DATA_337_RESET                                          0x0
#define DBI_WINDOW_REG_337_ADDRESS                                             (0x544 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_337_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_337_RESET                                               0x0

// 0x548 (DBI_WINDOW_REG_338)
#define DBI_WINDOW_REG_DATA_338_LSB                                            0
#define DBI_WINDOW_REG_DATA_338_MSB                                            31
#define DBI_WINDOW_REG_DATA_338_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_338_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_338_MASK) >> DBI_WINDOW_REG_DATA_338_LSB)
#define DBI_WINDOW_REG_DATA_338_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_338_LSB) & DBI_WINDOW_REG_DATA_338_MASK)
#define DBI_WINDOW_REG_DATA_338_RESET                                          0x0
#define DBI_WINDOW_REG_338_ADDRESS                                             (0x548 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_338_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_338_RESET                                               0x0

// 0x54c (DBI_WINDOW_REG_339)
#define DBI_WINDOW_REG_DATA_339_LSB                                            0
#define DBI_WINDOW_REG_DATA_339_MSB                                            31
#define DBI_WINDOW_REG_DATA_339_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_339_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_339_MASK) >> DBI_WINDOW_REG_DATA_339_LSB)
#define DBI_WINDOW_REG_DATA_339_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_339_LSB) & DBI_WINDOW_REG_DATA_339_MASK)
#define DBI_WINDOW_REG_DATA_339_RESET                                          0x0
#define DBI_WINDOW_REG_339_ADDRESS                                             (0x54c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_339_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_339_RESET                                               0x0

// 0x550 (DBI_WINDOW_REG_340)
#define DBI_WINDOW_REG_DATA_340_LSB                                            0
#define DBI_WINDOW_REG_DATA_340_MSB                                            31
#define DBI_WINDOW_REG_DATA_340_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_340_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_340_MASK) >> DBI_WINDOW_REG_DATA_340_LSB)
#define DBI_WINDOW_REG_DATA_340_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_340_LSB) & DBI_WINDOW_REG_DATA_340_MASK)
#define DBI_WINDOW_REG_DATA_340_RESET                                          0x0
#define DBI_WINDOW_REG_340_ADDRESS                                             (0x550 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_340_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_340_RESET                                               0x0

// 0x554 (DBI_WINDOW_REG_341)
#define DBI_WINDOW_REG_DATA_341_LSB                                            0
#define DBI_WINDOW_REG_DATA_341_MSB                                            31
#define DBI_WINDOW_REG_DATA_341_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_341_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_341_MASK) >> DBI_WINDOW_REG_DATA_341_LSB)
#define DBI_WINDOW_REG_DATA_341_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_341_LSB) & DBI_WINDOW_REG_DATA_341_MASK)
#define DBI_WINDOW_REG_DATA_341_RESET                                          0x0
#define DBI_WINDOW_REG_341_ADDRESS                                             (0x554 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_341_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_341_RESET                                               0x0

// 0x558 (DBI_WINDOW_REG_342)
#define DBI_WINDOW_REG_DATA_342_LSB                                            0
#define DBI_WINDOW_REG_DATA_342_MSB                                            31
#define DBI_WINDOW_REG_DATA_342_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_342_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_342_MASK) >> DBI_WINDOW_REG_DATA_342_LSB)
#define DBI_WINDOW_REG_DATA_342_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_342_LSB) & DBI_WINDOW_REG_DATA_342_MASK)
#define DBI_WINDOW_REG_DATA_342_RESET                                          0x0
#define DBI_WINDOW_REG_342_ADDRESS                                             (0x558 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_342_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_342_RESET                                               0x0

// 0x55c (DBI_WINDOW_REG_343)
#define DBI_WINDOW_REG_DATA_343_LSB                                            0
#define DBI_WINDOW_REG_DATA_343_MSB                                            31
#define DBI_WINDOW_REG_DATA_343_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_343_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_343_MASK) >> DBI_WINDOW_REG_DATA_343_LSB)
#define DBI_WINDOW_REG_DATA_343_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_343_LSB) & DBI_WINDOW_REG_DATA_343_MASK)
#define DBI_WINDOW_REG_DATA_343_RESET                                          0x0
#define DBI_WINDOW_REG_343_ADDRESS                                             (0x55c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_343_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_343_RESET                                               0x0

// 0x560 (DBI_WINDOW_REG_344)
#define DBI_WINDOW_REG_DATA_344_LSB                                            0
#define DBI_WINDOW_REG_DATA_344_MSB                                            31
#define DBI_WINDOW_REG_DATA_344_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_344_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_344_MASK) >> DBI_WINDOW_REG_DATA_344_LSB)
#define DBI_WINDOW_REG_DATA_344_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_344_LSB) & DBI_WINDOW_REG_DATA_344_MASK)
#define DBI_WINDOW_REG_DATA_344_RESET                                          0x0
#define DBI_WINDOW_REG_344_ADDRESS                                             (0x560 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_344_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_344_RESET                                               0x0

// 0x564 (DBI_WINDOW_REG_345)
#define DBI_WINDOW_REG_DATA_345_LSB                                            0
#define DBI_WINDOW_REG_DATA_345_MSB                                            31
#define DBI_WINDOW_REG_DATA_345_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_345_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_345_MASK) >> DBI_WINDOW_REG_DATA_345_LSB)
#define DBI_WINDOW_REG_DATA_345_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_345_LSB) & DBI_WINDOW_REG_DATA_345_MASK)
#define DBI_WINDOW_REG_DATA_345_RESET                                          0x0
#define DBI_WINDOW_REG_345_ADDRESS                                             (0x564 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_345_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_345_RESET                                               0x0

// 0x568 (DBI_WINDOW_REG_346)
#define DBI_WINDOW_REG_DATA_346_LSB                                            0
#define DBI_WINDOW_REG_DATA_346_MSB                                            31
#define DBI_WINDOW_REG_DATA_346_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_346_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_346_MASK) >> DBI_WINDOW_REG_DATA_346_LSB)
#define DBI_WINDOW_REG_DATA_346_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_346_LSB) & DBI_WINDOW_REG_DATA_346_MASK)
#define DBI_WINDOW_REG_DATA_346_RESET                                          0x0
#define DBI_WINDOW_REG_346_ADDRESS                                             (0x568 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_346_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_346_RESET                                               0x0

// 0x56c (DBI_WINDOW_REG_347)
#define DBI_WINDOW_REG_DATA_347_LSB                                            0
#define DBI_WINDOW_REG_DATA_347_MSB                                            31
#define DBI_WINDOW_REG_DATA_347_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_347_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_347_MASK) >> DBI_WINDOW_REG_DATA_347_LSB)
#define DBI_WINDOW_REG_DATA_347_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_347_LSB) & DBI_WINDOW_REG_DATA_347_MASK)
#define DBI_WINDOW_REG_DATA_347_RESET                                          0x0
#define DBI_WINDOW_REG_347_ADDRESS                                             (0x56c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_347_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_347_RESET                                               0x0

// 0x570 (DBI_WINDOW_REG_348)
#define DBI_WINDOW_REG_DATA_348_LSB                                            0
#define DBI_WINDOW_REG_DATA_348_MSB                                            31
#define DBI_WINDOW_REG_DATA_348_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_348_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_348_MASK) >> DBI_WINDOW_REG_DATA_348_LSB)
#define DBI_WINDOW_REG_DATA_348_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_348_LSB) & DBI_WINDOW_REG_DATA_348_MASK)
#define DBI_WINDOW_REG_DATA_348_RESET                                          0x0
#define DBI_WINDOW_REG_348_ADDRESS                                             (0x570 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_348_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_348_RESET                                               0x0

// 0x574 (DBI_WINDOW_REG_349)
#define DBI_WINDOW_REG_DATA_349_LSB                                            0
#define DBI_WINDOW_REG_DATA_349_MSB                                            31
#define DBI_WINDOW_REG_DATA_349_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_349_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_349_MASK) >> DBI_WINDOW_REG_DATA_349_LSB)
#define DBI_WINDOW_REG_DATA_349_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_349_LSB) & DBI_WINDOW_REG_DATA_349_MASK)
#define DBI_WINDOW_REG_DATA_349_RESET                                          0x0
#define DBI_WINDOW_REG_349_ADDRESS                                             (0x574 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_349_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_349_RESET                                               0x0

// 0x578 (DBI_WINDOW_REG_350)
#define DBI_WINDOW_REG_DATA_350_LSB                                            0
#define DBI_WINDOW_REG_DATA_350_MSB                                            31
#define DBI_WINDOW_REG_DATA_350_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_350_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_350_MASK) >> DBI_WINDOW_REG_DATA_350_LSB)
#define DBI_WINDOW_REG_DATA_350_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_350_LSB) & DBI_WINDOW_REG_DATA_350_MASK)
#define DBI_WINDOW_REG_DATA_350_RESET                                          0x0
#define DBI_WINDOW_REG_350_ADDRESS                                             (0x578 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_350_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_350_RESET                                               0x0

// 0x57c (DBI_WINDOW_REG_351)
#define DBI_WINDOW_REG_DATA_351_LSB                                            0
#define DBI_WINDOW_REG_DATA_351_MSB                                            31
#define DBI_WINDOW_REG_DATA_351_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_351_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_351_MASK) >> DBI_WINDOW_REG_DATA_351_LSB)
#define DBI_WINDOW_REG_DATA_351_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_351_LSB) & DBI_WINDOW_REG_DATA_351_MASK)
#define DBI_WINDOW_REG_DATA_351_RESET                                          0x0
#define DBI_WINDOW_REG_351_ADDRESS                                             (0x57c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_351_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_351_RESET                                               0x0

// 0x580 (DBI_WINDOW_REG_352)
#define DBI_WINDOW_REG_DATA_352_LSB                                            0
#define DBI_WINDOW_REG_DATA_352_MSB                                            31
#define DBI_WINDOW_REG_DATA_352_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_352_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_352_MASK) >> DBI_WINDOW_REG_DATA_352_LSB)
#define DBI_WINDOW_REG_DATA_352_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_352_LSB) & DBI_WINDOW_REG_DATA_352_MASK)
#define DBI_WINDOW_REG_DATA_352_RESET                                          0x0
#define DBI_WINDOW_REG_352_ADDRESS                                             (0x580 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_352_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_352_RESET                                               0x0

// 0x584 (DBI_WINDOW_REG_353)
#define DBI_WINDOW_REG_DATA_353_LSB                                            0
#define DBI_WINDOW_REG_DATA_353_MSB                                            31
#define DBI_WINDOW_REG_DATA_353_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_353_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_353_MASK) >> DBI_WINDOW_REG_DATA_353_LSB)
#define DBI_WINDOW_REG_DATA_353_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_353_LSB) & DBI_WINDOW_REG_DATA_353_MASK)
#define DBI_WINDOW_REG_DATA_353_RESET                                          0x0
#define DBI_WINDOW_REG_353_ADDRESS                                             (0x584 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_353_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_353_RESET                                               0x0

// 0x588 (DBI_WINDOW_REG_354)
#define DBI_WINDOW_REG_DATA_354_LSB                                            0
#define DBI_WINDOW_REG_DATA_354_MSB                                            31
#define DBI_WINDOW_REG_DATA_354_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_354_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_354_MASK) >> DBI_WINDOW_REG_DATA_354_LSB)
#define DBI_WINDOW_REG_DATA_354_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_354_LSB) & DBI_WINDOW_REG_DATA_354_MASK)
#define DBI_WINDOW_REG_DATA_354_RESET                                          0x0
#define DBI_WINDOW_REG_354_ADDRESS                                             (0x588 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_354_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_354_RESET                                               0x0

// 0x58c (DBI_WINDOW_REG_355)
#define DBI_WINDOW_REG_DATA_355_LSB                                            0
#define DBI_WINDOW_REG_DATA_355_MSB                                            31
#define DBI_WINDOW_REG_DATA_355_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_355_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_355_MASK) >> DBI_WINDOW_REG_DATA_355_LSB)
#define DBI_WINDOW_REG_DATA_355_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_355_LSB) & DBI_WINDOW_REG_DATA_355_MASK)
#define DBI_WINDOW_REG_DATA_355_RESET                                          0x0
#define DBI_WINDOW_REG_355_ADDRESS                                             (0x58c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_355_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_355_RESET                                               0x0

// 0x590 (DBI_WINDOW_REG_356)
#define DBI_WINDOW_REG_DATA_356_LSB                                            0
#define DBI_WINDOW_REG_DATA_356_MSB                                            31
#define DBI_WINDOW_REG_DATA_356_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_356_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_356_MASK) >> DBI_WINDOW_REG_DATA_356_LSB)
#define DBI_WINDOW_REG_DATA_356_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_356_LSB) & DBI_WINDOW_REG_DATA_356_MASK)
#define DBI_WINDOW_REG_DATA_356_RESET                                          0x0
#define DBI_WINDOW_REG_356_ADDRESS                                             (0x590 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_356_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_356_RESET                                               0x0

// 0x594 (DBI_WINDOW_REG_357)
#define DBI_WINDOW_REG_DATA_357_LSB                                            0
#define DBI_WINDOW_REG_DATA_357_MSB                                            31
#define DBI_WINDOW_REG_DATA_357_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_357_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_357_MASK) >> DBI_WINDOW_REG_DATA_357_LSB)
#define DBI_WINDOW_REG_DATA_357_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_357_LSB) & DBI_WINDOW_REG_DATA_357_MASK)
#define DBI_WINDOW_REG_DATA_357_RESET                                          0x0
#define DBI_WINDOW_REG_357_ADDRESS                                             (0x594 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_357_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_357_RESET                                               0x0

// 0x598 (DBI_WINDOW_REG_358)
#define DBI_WINDOW_REG_DATA_358_LSB                                            0
#define DBI_WINDOW_REG_DATA_358_MSB                                            31
#define DBI_WINDOW_REG_DATA_358_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_358_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_358_MASK) >> DBI_WINDOW_REG_DATA_358_LSB)
#define DBI_WINDOW_REG_DATA_358_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_358_LSB) & DBI_WINDOW_REG_DATA_358_MASK)
#define DBI_WINDOW_REG_DATA_358_RESET                                          0x0
#define DBI_WINDOW_REG_358_ADDRESS                                             (0x598 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_358_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_358_RESET                                               0x0

// 0x59c (DBI_WINDOW_REG_359)
#define DBI_WINDOW_REG_DATA_359_LSB                                            0
#define DBI_WINDOW_REG_DATA_359_MSB                                            31
#define DBI_WINDOW_REG_DATA_359_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_359_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_359_MASK) >> DBI_WINDOW_REG_DATA_359_LSB)
#define DBI_WINDOW_REG_DATA_359_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_359_LSB) & DBI_WINDOW_REG_DATA_359_MASK)
#define DBI_WINDOW_REG_DATA_359_RESET                                          0x0
#define DBI_WINDOW_REG_359_ADDRESS                                             (0x59c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_359_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_359_RESET                                               0x0

// 0x5a0 (DBI_WINDOW_REG_360)
#define DBI_WINDOW_REG_DATA_360_LSB                                            0
#define DBI_WINDOW_REG_DATA_360_MSB                                            31
#define DBI_WINDOW_REG_DATA_360_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_360_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_360_MASK) >> DBI_WINDOW_REG_DATA_360_LSB)
#define DBI_WINDOW_REG_DATA_360_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_360_LSB) & DBI_WINDOW_REG_DATA_360_MASK)
#define DBI_WINDOW_REG_DATA_360_RESET                                          0x0
#define DBI_WINDOW_REG_360_ADDRESS                                             (0x5a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_360_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_360_RESET                                               0x0

// 0x5a4 (DBI_WINDOW_REG_361)
#define DBI_WINDOW_REG_DATA_361_LSB                                            0
#define DBI_WINDOW_REG_DATA_361_MSB                                            31
#define DBI_WINDOW_REG_DATA_361_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_361_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_361_MASK) >> DBI_WINDOW_REG_DATA_361_LSB)
#define DBI_WINDOW_REG_DATA_361_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_361_LSB) & DBI_WINDOW_REG_DATA_361_MASK)
#define DBI_WINDOW_REG_DATA_361_RESET                                          0x0
#define DBI_WINDOW_REG_361_ADDRESS                                             (0x5a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_361_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_361_RESET                                               0x0

// 0x5a8 (DBI_WINDOW_REG_362)
#define DBI_WINDOW_REG_DATA_362_LSB                                            0
#define DBI_WINDOW_REG_DATA_362_MSB                                            31
#define DBI_WINDOW_REG_DATA_362_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_362_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_362_MASK) >> DBI_WINDOW_REG_DATA_362_LSB)
#define DBI_WINDOW_REG_DATA_362_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_362_LSB) & DBI_WINDOW_REG_DATA_362_MASK)
#define DBI_WINDOW_REG_DATA_362_RESET                                          0x0
#define DBI_WINDOW_REG_362_ADDRESS                                             (0x5a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_362_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_362_RESET                                               0x0

// 0x5ac (DBI_WINDOW_REG_363)
#define DBI_WINDOW_REG_DATA_363_LSB                                            0
#define DBI_WINDOW_REG_DATA_363_MSB                                            31
#define DBI_WINDOW_REG_DATA_363_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_363_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_363_MASK) >> DBI_WINDOW_REG_DATA_363_LSB)
#define DBI_WINDOW_REG_DATA_363_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_363_LSB) & DBI_WINDOW_REG_DATA_363_MASK)
#define DBI_WINDOW_REG_DATA_363_RESET                                          0x0
#define DBI_WINDOW_REG_363_ADDRESS                                             (0x5ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_363_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_363_RESET                                               0x0

// 0x5b0 (DBI_WINDOW_REG_364)
#define DBI_WINDOW_REG_DATA_364_LSB                                            0
#define DBI_WINDOW_REG_DATA_364_MSB                                            31
#define DBI_WINDOW_REG_DATA_364_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_364_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_364_MASK) >> DBI_WINDOW_REG_DATA_364_LSB)
#define DBI_WINDOW_REG_DATA_364_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_364_LSB) & DBI_WINDOW_REG_DATA_364_MASK)
#define DBI_WINDOW_REG_DATA_364_RESET                                          0x0
#define DBI_WINDOW_REG_364_ADDRESS                                             (0x5b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_364_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_364_RESET                                               0x0

// 0x5b4 (DBI_WINDOW_REG_365)
#define DBI_WINDOW_REG_DATA_365_LSB                                            0
#define DBI_WINDOW_REG_DATA_365_MSB                                            31
#define DBI_WINDOW_REG_DATA_365_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_365_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_365_MASK) >> DBI_WINDOW_REG_DATA_365_LSB)
#define DBI_WINDOW_REG_DATA_365_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_365_LSB) & DBI_WINDOW_REG_DATA_365_MASK)
#define DBI_WINDOW_REG_DATA_365_RESET                                          0x0
#define DBI_WINDOW_REG_365_ADDRESS                                             (0x5b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_365_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_365_RESET                                               0x0

// 0x5b8 (DBI_WINDOW_REG_366)
#define DBI_WINDOW_REG_DATA_366_LSB                                            0
#define DBI_WINDOW_REG_DATA_366_MSB                                            31
#define DBI_WINDOW_REG_DATA_366_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_366_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_366_MASK) >> DBI_WINDOW_REG_DATA_366_LSB)
#define DBI_WINDOW_REG_DATA_366_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_366_LSB) & DBI_WINDOW_REG_DATA_366_MASK)
#define DBI_WINDOW_REG_DATA_366_RESET                                          0x0
#define DBI_WINDOW_REG_366_ADDRESS                                             (0x5b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_366_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_366_RESET                                               0x0

// 0x5bc (DBI_WINDOW_REG_367)
#define DBI_WINDOW_REG_DATA_367_LSB                                            0
#define DBI_WINDOW_REG_DATA_367_MSB                                            31
#define DBI_WINDOW_REG_DATA_367_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_367_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_367_MASK) >> DBI_WINDOW_REG_DATA_367_LSB)
#define DBI_WINDOW_REG_DATA_367_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_367_LSB) & DBI_WINDOW_REG_DATA_367_MASK)
#define DBI_WINDOW_REG_DATA_367_RESET                                          0x0
#define DBI_WINDOW_REG_367_ADDRESS                                             (0x5bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_367_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_367_RESET                                               0x0

// 0x5c0 (DBI_WINDOW_REG_368)
#define DBI_WINDOW_REG_DATA_368_LSB                                            0
#define DBI_WINDOW_REG_DATA_368_MSB                                            31
#define DBI_WINDOW_REG_DATA_368_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_368_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_368_MASK) >> DBI_WINDOW_REG_DATA_368_LSB)
#define DBI_WINDOW_REG_DATA_368_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_368_LSB) & DBI_WINDOW_REG_DATA_368_MASK)
#define DBI_WINDOW_REG_DATA_368_RESET                                          0x0
#define DBI_WINDOW_REG_368_ADDRESS                                             (0x5c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_368_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_368_RESET                                               0x0

// 0x5c4 (DBI_WINDOW_REG_369)
#define DBI_WINDOW_REG_DATA_369_LSB                                            0
#define DBI_WINDOW_REG_DATA_369_MSB                                            31
#define DBI_WINDOW_REG_DATA_369_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_369_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_369_MASK) >> DBI_WINDOW_REG_DATA_369_LSB)
#define DBI_WINDOW_REG_DATA_369_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_369_LSB) & DBI_WINDOW_REG_DATA_369_MASK)
#define DBI_WINDOW_REG_DATA_369_RESET                                          0x0
#define DBI_WINDOW_REG_369_ADDRESS                                             (0x5c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_369_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_369_RESET                                               0x0

// 0x5c8 (DBI_WINDOW_REG_370)
#define DBI_WINDOW_REG_DATA_370_LSB                                            0
#define DBI_WINDOW_REG_DATA_370_MSB                                            31
#define DBI_WINDOW_REG_DATA_370_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_370_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_370_MASK) >> DBI_WINDOW_REG_DATA_370_LSB)
#define DBI_WINDOW_REG_DATA_370_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_370_LSB) & DBI_WINDOW_REG_DATA_370_MASK)
#define DBI_WINDOW_REG_DATA_370_RESET                                          0x0
#define DBI_WINDOW_REG_370_ADDRESS                                             (0x5c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_370_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_370_RESET                                               0x0

// 0x5cc (DBI_WINDOW_REG_371)
#define DBI_WINDOW_REG_DATA_371_LSB                                            0
#define DBI_WINDOW_REG_DATA_371_MSB                                            31
#define DBI_WINDOW_REG_DATA_371_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_371_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_371_MASK) >> DBI_WINDOW_REG_DATA_371_LSB)
#define DBI_WINDOW_REG_DATA_371_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_371_LSB) & DBI_WINDOW_REG_DATA_371_MASK)
#define DBI_WINDOW_REG_DATA_371_RESET                                          0x0
#define DBI_WINDOW_REG_371_ADDRESS                                             (0x5cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_371_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_371_RESET                                               0x0

// 0x5d0 (DBI_WINDOW_REG_372)
#define DBI_WINDOW_REG_DATA_372_LSB                                            0
#define DBI_WINDOW_REG_DATA_372_MSB                                            31
#define DBI_WINDOW_REG_DATA_372_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_372_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_372_MASK) >> DBI_WINDOW_REG_DATA_372_LSB)
#define DBI_WINDOW_REG_DATA_372_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_372_LSB) & DBI_WINDOW_REG_DATA_372_MASK)
#define DBI_WINDOW_REG_DATA_372_RESET                                          0x0
#define DBI_WINDOW_REG_372_ADDRESS                                             (0x5d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_372_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_372_RESET                                               0x0

// 0x5d4 (DBI_WINDOW_REG_373)
#define DBI_WINDOW_REG_DATA_373_LSB                                            0
#define DBI_WINDOW_REG_DATA_373_MSB                                            31
#define DBI_WINDOW_REG_DATA_373_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_373_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_373_MASK) >> DBI_WINDOW_REG_DATA_373_LSB)
#define DBI_WINDOW_REG_DATA_373_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_373_LSB) & DBI_WINDOW_REG_DATA_373_MASK)
#define DBI_WINDOW_REG_DATA_373_RESET                                          0x0
#define DBI_WINDOW_REG_373_ADDRESS                                             (0x5d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_373_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_373_RESET                                               0x0

// 0x5d8 (DBI_WINDOW_REG_374)
#define DBI_WINDOW_REG_DATA_374_LSB                                            0
#define DBI_WINDOW_REG_DATA_374_MSB                                            31
#define DBI_WINDOW_REG_DATA_374_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_374_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_374_MASK) >> DBI_WINDOW_REG_DATA_374_LSB)
#define DBI_WINDOW_REG_DATA_374_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_374_LSB) & DBI_WINDOW_REG_DATA_374_MASK)
#define DBI_WINDOW_REG_DATA_374_RESET                                          0x0
#define DBI_WINDOW_REG_374_ADDRESS                                             (0x5d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_374_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_374_RESET                                               0x0

// 0x5dc (DBI_WINDOW_REG_375)
#define DBI_WINDOW_REG_DATA_375_LSB                                            0
#define DBI_WINDOW_REG_DATA_375_MSB                                            31
#define DBI_WINDOW_REG_DATA_375_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_375_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_375_MASK) >> DBI_WINDOW_REG_DATA_375_LSB)
#define DBI_WINDOW_REG_DATA_375_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_375_LSB) & DBI_WINDOW_REG_DATA_375_MASK)
#define DBI_WINDOW_REG_DATA_375_RESET                                          0x0
#define DBI_WINDOW_REG_375_ADDRESS                                             (0x5dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_375_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_375_RESET                                               0x0

// 0x5e0 (DBI_WINDOW_REG_376)
#define DBI_WINDOW_REG_DATA_376_LSB                                            0
#define DBI_WINDOW_REG_DATA_376_MSB                                            31
#define DBI_WINDOW_REG_DATA_376_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_376_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_376_MASK) >> DBI_WINDOW_REG_DATA_376_LSB)
#define DBI_WINDOW_REG_DATA_376_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_376_LSB) & DBI_WINDOW_REG_DATA_376_MASK)
#define DBI_WINDOW_REG_DATA_376_RESET                                          0x0
#define DBI_WINDOW_REG_376_ADDRESS                                             (0x5e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_376_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_376_RESET                                               0x0

// 0x5e4 (DBI_WINDOW_REG_377)
#define DBI_WINDOW_REG_DATA_377_LSB                                            0
#define DBI_WINDOW_REG_DATA_377_MSB                                            31
#define DBI_WINDOW_REG_DATA_377_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_377_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_377_MASK) >> DBI_WINDOW_REG_DATA_377_LSB)
#define DBI_WINDOW_REG_DATA_377_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_377_LSB) & DBI_WINDOW_REG_DATA_377_MASK)
#define DBI_WINDOW_REG_DATA_377_RESET                                          0x0
#define DBI_WINDOW_REG_377_ADDRESS                                             (0x5e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_377_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_377_RESET                                               0x0

// 0x5e8 (DBI_WINDOW_REG_378)
#define DBI_WINDOW_REG_DATA_378_LSB                                            0
#define DBI_WINDOW_REG_DATA_378_MSB                                            31
#define DBI_WINDOW_REG_DATA_378_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_378_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_378_MASK) >> DBI_WINDOW_REG_DATA_378_LSB)
#define DBI_WINDOW_REG_DATA_378_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_378_LSB) & DBI_WINDOW_REG_DATA_378_MASK)
#define DBI_WINDOW_REG_DATA_378_RESET                                          0x0
#define DBI_WINDOW_REG_378_ADDRESS                                             (0x5e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_378_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_378_RESET                                               0x0

// 0x5ec (DBI_WINDOW_REG_379)
#define DBI_WINDOW_REG_DATA_379_LSB                                            0
#define DBI_WINDOW_REG_DATA_379_MSB                                            31
#define DBI_WINDOW_REG_DATA_379_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_379_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_379_MASK) >> DBI_WINDOW_REG_DATA_379_LSB)
#define DBI_WINDOW_REG_DATA_379_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_379_LSB) & DBI_WINDOW_REG_DATA_379_MASK)
#define DBI_WINDOW_REG_DATA_379_RESET                                          0x0
#define DBI_WINDOW_REG_379_ADDRESS                                             (0x5ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_379_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_379_RESET                                               0x0

// 0x5f0 (DBI_WINDOW_REG_380)
#define DBI_WINDOW_REG_DATA_380_LSB                                            0
#define DBI_WINDOW_REG_DATA_380_MSB                                            31
#define DBI_WINDOW_REG_DATA_380_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_380_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_380_MASK) >> DBI_WINDOW_REG_DATA_380_LSB)
#define DBI_WINDOW_REG_DATA_380_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_380_LSB) & DBI_WINDOW_REG_DATA_380_MASK)
#define DBI_WINDOW_REG_DATA_380_RESET                                          0x0
#define DBI_WINDOW_REG_380_ADDRESS                                             (0x5f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_380_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_380_RESET                                               0x0

// 0x5f4 (DBI_WINDOW_REG_381)
#define DBI_WINDOW_REG_DATA_381_LSB                                            0
#define DBI_WINDOW_REG_DATA_381_MSB                                            31
#define DBI_WINDOW_REG_DATA_381_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_381_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_381_MASK) >> DBI_WINDOW_REG_DATA_381_LSB)
#define DBI_WINDOW_REG_DATA_381_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_381_LSB) & DBI_WINDOW_REG_DATA_381_MASK)
#define DBI_WINDOW_REG_DATA_381_RESET                                          0x0
#define DBI_WINDOW_REG_381_ADDRESS                                             (0x5f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_381_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_381_RESET                                               0x0

// 0x5f8 (DBI_WINDOW_REG_382)
#define DBI_WINDOW_REG_DATA_382_LSB                                            0
#define DBI_WINDOW_REG_DATA_382_MSB                                            31
#define DBI_WINDOW_REG_DATA_382_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_382_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_382_MASK) >> DBI_WINDOW_REG_DATA_382_LSB)
#define DBI_WINDOW_REG_DATA_382_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_382_LSB) & DBI_WINDOW_REG_DATA_382_MASK)
#define DBI_WINDOW_REG_DATA_382_RESET                                          0x0
#define DBI_WINDOW_REG_382_ADDRESS                                             (0x5f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_382_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_382_RESET                                               0x0

// 0x5fc (DBI_WINDOW_REG_383)
#define DBI_WINDOW_REG_DATA_383_LSB                                            0
#define DBI_WINDOW_REG_DATA_383_MSB                                            31
#define DBI_WINDOW_REG_DATA_383_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_383_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_383_MASK) >> DBI_WINDOW_REG_DATA_383_LSB)
#define DBI_WINDOW_REG_DATA_383_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_383_LSB) & DBI_WINDOW_REG_DATA_383_MASK)
#define DBI_WINDOW_REG_DATA_383_RESET                                          0x0
#define DBI_WINDOW_REG_383_ADDRESS                                             (0x5fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_383_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_383_RESET                                               0x0

// 0x600 (DBI_WINDOW_REG_384)
#define DBI_WINDOW_REG_DATA_384_LSB                                            0
#define DBI_WINDOW_REG_DATA_384_MSB                                            31
#define DBI_WINDOW_REG_DATA_384_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_384_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_384_MASK) >> DBI_WINDOW_REG_DATA_384_LSB)
#define DBI_WINDOW_REG_DATA_384_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_384_LSB) & DBI_WINDOW_REG_DATA_384_MASK)
#define DBI_WINDOW_REG_DATA_384_RESET                                          0x0
#define DBI_WINDOW_REG_384_ADDRESS                                             (0x600 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_384_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_384_RESET                                               0x0

// 0x604 (DBI_WINDOW_REG_385)
#define DBI_WINDOW_REG_DATA_385_LSB                                            0
#define DBI_WINDOW_REG_DATA_385_MSB                                            31
#define DBI_WINDOW_REG_DATA_385_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_385_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_385_MASK) >> DBI_WINDOW_REG_DATA_385_LSB)
#define DBI_WINDOW_REG_DATA_385_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_385_LSB) & DBI_WINDOW_REG_DATA_385_MASK)
#define DBI_WINDOW_REG_DATA_385_RESET                                          0x0
#define DBI_WINDOW_REG_385_ADDRESS                                             (0x604 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_385_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_385_RESET                                               0x0

// 0x608 (DBI_WINDOW_REG_386)
#define DBI_WINDOW_REG_DATA_386_LSB                                            0
#define DBI_WINDOW_REG_DATA_386_MSB                                            31
#define DBI_WINDOW_REG_DATA_386_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_386_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_386_MASK) >> DBI_WINDOW_REG_DATA_386_LSB)
#define DBI_WINDOW_REG_DATA_386_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_386_LSB) & DBI_WINDOW_REG_DATA_386_MASK)
#define DBI_WINDOW_REG_DATA_386_RESET                                          0x0
#define DBI_WINDOW_REG_386_ADDRESS                                             (0x608 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_386_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_386_RESET                                               0x0

// 0x60c (DBI_WINDOW_REG_387)
#define DBI_WINDOW_REG_DATA_387_LSB                                            0
#define DBI_WINDOW_REG_DATA_387_MSB                                            31
#define DBI_WINDOW_REG_DATA_387_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_387_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_387_MASK) >> DBI_WINDOW_REG_DATA_387_LSB)
#define DBI_WINDOW_REG_DATA_387_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_387_LSB) & DBI_WINDOW_REG_DATA_387_MASK)
#define DBI_WINDOW_REG_DATA_387_RESET                                          0x0
#define DBI_WINDOW_REG_387_ADDRESS                                             (0x60c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_387_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_387_RESET                                               0x0

// 0x610 (DBI_WINDOW_REG_388)
#define DBI_WINDOW_REG_DATA_388_LSB                                            0
#define DBI_WINDOW_REG_DATA_388_MSB                                            31
#define DBI_WINDOW_REG_DATA_388_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_388_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_388_MASK) >> DBI_WINDOW_REG_DATA_388_LSB)
#define DBI_WINDOW_REG_DATA_388_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_388_LSB) & DBI_WINDOW_REG_DATA_388_MASK)
#define DBI_WINDOW_REG_DATA_388_RESET                                          0x0
#define DBI_WINDOW_REG_388_ADDRESS                                             (0x610 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_388_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_388_RESET                                               0x0

// 0x614 (DBI_WINDOW_REG_389)
#define DBI_WINDOW_REG_DATA_389_LSB                                            0
#define DBI_WINDOW_REG_DATA_389_MSB                                            31
#define DBI_WINDOW_REG_DATA_389_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_389_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_389_MASK) >> DBI_WINDOW_REG_DATA_389_LSB)
#define DBI_WINDOW_REG_DATA_389_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_389_LSB) & DBI_WINDOW_REG_DATA_389_MASK)
#define DBI_WINDOW_REG_DATA_389_RESET                                          0x0
#define DBI_WINDOW_REG_389_ADDRESS                                             (0x614 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_389_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_389_RESET                                               0x0

// 0x618 (DBI_WINDOW_REG_390)
#define DBI_WINDOW_REG_DATA_390_LSB                                            0
#define DBI_WINDOW_REG_DATA_390_MSB                                            31
#define DBI_WINDOW_REG_DATA_390_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_390_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_390_MASK) >> DBI_WINDOW_REG_DATA_390_LSB)
#define DBI_WINDOW_REG_DATA_390_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_390_LSB) & DBI_WINDOW_REG_DATA_390_MASK)
#define DBI_WINDOW_REG_DATA_390_RESET                                          0x0
#define DBI_WINDOW_REG_390_ADDRESS                                             (0x618 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_390_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_390_RESET                                               0x0

// 0x61c (DBI_WINDOW_REG_391)
#define DBI_WINDOW_REG_DATA_391_LSB                                            0
#define DBI_WINDOW_REG_DATA_391_MSB                                            31
#define DBI_WINDOW_REG_DATA_391_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_391_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_391_MASK) >> DBI_WINDOW_REG_DATA_391_LSB)
#define DBI_WINDOW_REG_DATA_391_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_391_LSB) & DBI_WINDOW_REG_DATA_391_MASK)
#define DBI_WINDOW_REG_DATA_391_RESET                                          0x0
#define DBI_WINDOW_REG_391_ADDRESS                                             (0x61c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_391_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_391_RESET                                               0x0

// 0x620 (DBI_WINDOW_REG_392)
#define DBI_WINDOW_REG_DATA_392_LSB                                            0
#define DBI_WINDOW_REG_DATA_392_MSB                                            31
#define DBI_WINDOW_REG_DATA_392_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_392_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_392_MASK) >> DBI_WINDOW_REG_DATA_392_LSB)
#define DBI_WINDOW_REG_DATA_392_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_392_LSB) & DBI_WINDOW_REG_DATA_392_MASK)
#define DBI_WINDOW_REG_DATA_392_RESET                                          0x0
#define DBI_WINDOW_REG_392_ADDRESS                                             (0x620 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_392_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_392_RESET                                               0x0

// 0x624 (DBI_WINDOW_REG_393)
#define DBI_WINDOW_REG_DATA_393_LSB                                            0
#define DBI_WINDOW_REG_DATA_393_MSB                                            31
#define DBI_WINDOW_REG_DATA_393_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_393_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_393_MASK) >> DBI_WINDOW_REG_DATA_393_LSB)
#define DBI_WINDOW_REG_DATA_393_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_393_LSB) & DBI_WINDOW_REG_DATA_393_MASK)
#define DBI_WINDOW_REG_DATA_393_RESET                                          0x0
#define DBI_WINDOW_REG_393_ADDRESS                                             (0x624 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_393_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_393_RESET                                               0x0

// 0x628 (DBI_WINDOW_REG_394)
#define DBI_WINDOW_REG_DATA_394_LSB                                            0
#define DBI_WINDOW_REG_DATA_394_MSB                                            31
#define DBI_WINDOW_REG_DATA_394_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_394_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_394_MASK) >> DBI_WINDOW_REG_DATA_394_LSB)
#define DBI_WINDOW_REG_DATA_394_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_394_LSB) & DBI_WINDOW_REG_DATA_394_MASK)
#define DBI_WINDOW_REG_DATA_394_RESET                                          0x0
#define DBI_WINDOW_REG_394_ADDRESS                                             (0x628 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_394_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_394_RESET                                               0x0

// 0x62c (DBI_WINDOW_REG_395)
#define DBI_WINDOW_REG_DATA_395_LSB                                            0
#define DBI_WINDOW_REG_DATA_395_MSB                                            31
#define DBI_WINDOW_REG_DATA_395_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_395_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_395_MASK) >> DBI_WINDOW_REG_DATA_395_LSB)
#define DBI_WINDOW_REG_DATA_395_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_395_LSB) & DBI_WINDOW_REG_DATA_395_MASK)
#define DBI_WINDOW_REG_DATA_395_RESET                                          0x0
#define DBI_WINDOW_REG_395_ADDRESS                                             (0x62c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_395_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_395_RESET                                               0x0

// 0x630 (DBI_WINDOW_REG_396)
#define DBI_WINDOW_REG_DATA_396_LSB                                            0
#define DBI_WINDOW_REG_DATA_396_MSB                                            31
#define DBI_WINDOW_REG_DATA_396_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_396_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_396_MASK) >> DBI_WINDOW_REG_DATA_396_LSB)
#define DBI_WINDOW_REG_DATA_396_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_396_LSB) & DBI_WINDOW_REG_DATA_396_MASK)
#define DBI_WINDOW_REG_DATA_396_RESET                                          0x0
#define DBI_WINDOW_REG_396_ADDRESS                                             (0x630 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_396_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_396_RESET                                               0x0

// 0x634 (DBI_WINDOW_REG_397)
#define DBI_WINDOW_REG_DATA_397_LSB                                            0
#define DBI_WINDOW_REG_DATA_397_MSB                                            31
#define DBI_WINDOW_REG_DATA_397_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_397_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_397_MASK) >> DBI_WINDOW_REG_DATA_397_LSB)
#define DBI_WINDOW_REG_DATA_397_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_397_LSB) & DBI_WINDOW_REG_DATA_397_MASK)
#define DBI_WINDOW_REG_DATA_397_RESET                                          0x0
#define DBI_WINDOW_REG_397_ADDRESS                                             (0x634 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_397_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_397_RESET                                               0x0

// 0x638 (DBI_WINDOW_REG_398)
#define DBI_WINDOW_REG_DATA_398_LSB                                            0
#define DBI_WINDOW_REG_DATA_398_MSB                                            31
#define DBI_WINDOW_REG_DATA_398_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_398_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_398_MASK) >> DBI_WINDOW_REG_DATA_398_LSB)
#define DBI_WINDOW_REG_DATA_398_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_398_LSB) & DBI_WINDOW_REG_DATA_398_MASK)
#define DBI_WINDOW_REG_DATA_398_RESET                                          0x0
#define DBI_WINDOW_REG_398_ADDRESS                                             (0x638 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_398_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_398_RESET                                               0x0

// 0x63c (DBI_WINDOW_REG_399)
#define DBI_WINDOW_REG_DATA_399_LSB                                            0
#define DBI_WINDOW_REG_DATA_399_MSB                                            31
#define DBI_WINDOW_REG_DATA_399_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_399_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_399_MASK) >> DBI_WINDOW_REG_DATA_399_LSB)
#define DBI_WINDOW_REG_DATA_399_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_399_LSB) & DBI_WINDOW_REG_DATA_399_MASK)
#define DBI_WINDOW_REG_DATA_399_RESET                                          0x0
#define DBI_WINDOW_REG_399_ADDRESS                                             (0x63c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_399_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_399_RESET                                               0x0

// 0x640 (DBI_WINDOW_REG_400)
#define DBI_WINDOW_REG_DATA_400_LSB                                            0
#define DBI_WINDOW_REG_DATA_400_MSB                                            31
#define DBI_WINDOW_REG_DATA_400_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_400_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_400_MASK) >> DBI_WINDOW_REG_DATA_400_LSB)
#define DBI_WINDOW_REG_DATA_400_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_400_LSB) & DBI_WINDOW_REG_DATA_400_MASK)
#define DBI_WINDOW_REG_DATA_400_RESET                                          0x0
#define DBI_WINDOW_REG_400_ADDRESS                                             (0x640 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_400_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_400_RESET                                               0x0

// 0x644 (DBI_WINDOW_REG_401)
#define DBI_WINDOW_REG_DATA_401_LSB                                            0
#define DBI_WINDOW_REG_DATA_401_MSB                                            31
#define DBI_WINDOW_REG_DATA_401_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_401_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_401_MASK) >> DBI_WINDOW_REG_DATA_401_LSB)
#define DBI_WINDOW_REG_DATA_401_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_401_LSB) & DBI_WINDOW_REG_DATA_401_MASK)
#define DBI_WINDOW_REG_DATA_401_RESET                                          0x0
#define DBI_WINDOW_REG_401_ADDRESS                                             (0x644 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_401_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_401_RESET                                               0x0

// 0x648 (DBI_WINDOW_REG_402)
#define DBI_WINDOW_REG_DATA_402_LSB                                            0
#define DBI_WINDOW_REG_DATA_402_MSB                                            31
#define DBI_WINDOW_REG_DATA_402_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_402_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_402_MASK) >> DBI_WINDOW_REG_DATA_402_LSB)
#define DBI_WINDOW_REG_DATA_402_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_402_LSB) & DBI_WINDOW_REG_DATA_402_MASK)
#define DBI_WINDOW_REG_DATA_402_RESET                                          0x0
#define DBI_WINDOW_REG_402_ADDRESS                                             (0x648 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_402_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_402_RESET                                               0x0

// 0x64c (DBI_WINDOW_REG_403)
#define DBI_WINDOW_REG_DATA_403_LSB                                            0
#define DBI_WINDOW_REG_DATA_403_MSB                                            31
#define DBI_WINDOW_REG_DATA_403_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_403_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_403_MASK) >> DBI_WINDOW_REG_DATA_403_LSB)
#define DBI_WINDOW_REG_DATA_403_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_403_LSB) & DBI_WINDOW_REG_DATA_403_MASK)
#define DBI_WINDOW_REG_DATA_403_RESET                                          0x0
#define DBI_WINDOW_REG_403_ADDRESS                                             (0x64c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_403_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_403_RESET                                               0x0

// 0x650 (DBI_WINDOW_REG_404)
#define DBI_WINDOW_REG_DATA_404_LSB                                            0
#define DBI_WINDOW_REG_DATA_404_MSB                                            31
#define DBI_WINDOW_REG_DATA_404_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_404_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_404_MASK) >> DBI_WINDOW_REG_DATA_404_LSB)
#define DBI_WINDOW_REG_DATA_404_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_404_LSB) & DBI_WINDOW_REG_DATA_404_MASK)
#define DBI_WINDOW_REG_DATA_404_RESET                                          0x0
#define DBI_WINDOW_REG_404_ADDRESS                                             (0x650 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_404_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_404_RESET                                               0x0

// 0x654 (DBI_WINDOW_REG_405)
#define DBI_WINDOW_REG_DATA_405_LSB                                            0
#define DBI_WINDOW_REG_DATA_405_MSB                                            31
#define DBI_WINDOW_REG_DATA_405_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_405_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_405_MASK) >> DBI_WINDOW_REG_DATA_405_LSB)
#define DBI_WINDOW_REG_DATA_405_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_405_LSB) & DBI_WINDOW_REG_DATA_405_MASK)
#define DBI_WINDOW_REG_DATA_405_RESET                                          0x0
#define DBI_WINDOW_REG_405_ADDRESS                                             (0x654 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_405_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_405_RESET                                               0x0

// 0x658 (DBI_WINDOW_REG_406)
#define DBI_WINDOW_REG_DATA_406_LSB                                            0
#define DBI_WINDOW_REG_DATA_406_MSB                                            31
#define DBI_WINDOW_REG_DATA_406_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_406_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_406_MASK) >> DBI_WINDOW_REG_DATA_406_LSB)
#define DBI_WINDOW_REG_DATA_406_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_406_LSB) & DBI_WINDOW_REG_DATA_406_MASK)
#define DBI_WINDOW_REG_DATA_406_RESET                                          0x0
#define DBI_WINDOW_REG_406_ADDRESS                                             (0x658 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_406_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_406_RESET                                               0x0

// 0x65c (DBI_WINDOW_REG_407)
#define DBI_WINDOW_REG_DATA_407_LSB                                            0
#define DBI_WINDOW_REG_DATA_407_MSB                                            31
#define DBI_WINDOW_REG_DATA_407_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_407_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_407_MASK) >> DBI_WINDOW_REG_DATA_407_LSB)
#define DBI_WINDOW_REG_DATA_407_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_407_LSB) & DBI_WINDOW_REG_DATA_407_MASK)
#define DBI_WINDOW_REG_DATA_407_RESET                                          0x0
#define DBI_WINDOW_REG_407_ADDRESS                                             (0x65c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_407_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_407_RESET                                               0x0

// 0x660 (DBI_WINDOW_REG_408)
#define DBI_WINDOW_REG_DATA_408_LSB                                            0
#define DBI_WINDOW_REG_DATA_408_MSB                                            31
#define DBI_WINDOW_REG_DATA_408_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_408_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_408_MASK) >> DBI_WINDOW_REG_DATA_408_LSB)
#define DBI_WINDOW_REG_DATA_408_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_408_LSB) & DBI_WINDOW_REG_DATA_408_MASK)
#define DBI_WINDOW_REG_DATA_408_RESET                                          0x0
#define DBI_WINDOW_REG_408_ADDRESS                                             (0x660 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_408_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_408_RESET                                               0x0

// 0x664 (DBI_WINDOW_REG_409)
#define DBI_WINDOW_REG_DATA_409_LSB                                            0
#define DBI_WINDOW_REG_DATA_409_MSB                                            31
#define DBI_WINDOW_REG_DATA_409_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_409_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_409_MASK) >> DBI_WINDOW_REG_DATA_409_LSB)
#define DBI_WINDOW_REG_DATA_409_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_409_LSB) & DBI_WINDOW_REG_DATA_409_MASK)
#define DBI_WINDOW_REG_DATA_409_RESET                                          0x0
#define DBI_WINDOW_REG_409_ADDRESS                                             (0x664 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_409_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_409_RESET                                               0x0

// 0x668 (DBI_WINDOW_REG_410)
#define DBI_WINDOW_REG_DATA_410_LSB                                            0
#define DBI_WINDOW_REG_DATA_410_MSB                                            31
#define DBI_WINDOW_REG_DATA_410_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_410_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_410_MASK) >> DBI_WINDOW_REG_DATA_410_LSB)
#define DBI_WINDOW_REG_DATA_410_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_410_LSB) & DBI_WINDOW_REG_DATA_410_MASK)
#define DBI_WINDOW_REG_DATA_410_RESET                                          0x0
#define DBI_WINDOW_REG_410_ADDRESS                                             (0x668 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_410_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_410_RESET                                               0x0

// 0x66c (DBI_WINDOW_REG_411)
#define DBI_WINDOW_REG_DATA_411_LSB                                            0
#define DBI_WINDOW_REG_DATA_411_MSB                                            31
#define DBI_WINDOW_REG_DATA_411_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_411_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_411_MASK) >> DBI_WINDOW_REG_DATA_411_LSB)
#define DBI_WINDOW_REG_DATA_411_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_411_LSB) & DBI_WINDOW_REG_DATA_411_MASK)
#define DBI_WINDOW_REG_DATA_411_RESET                                          0x0
#define DBI_WINDOW_REG_411_ADDRESS                                             (0x66c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_411_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_411_RESET                                               0x0

// 0x670 (DBI_WINDOW_REG_412)
#define DBI_WINDOW_REG_DATA_412_LSB                                            0
#define DBI_WINDOW_REG_DATA_412_MSB                                            31
#define DBI_WINDOW_REG_DATA_412_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_412_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_412_MASK) >> DBI_WINDOW_REG_DATA_412_LSB)
#define DBI_WINDOW_REG_DATA_412_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_412_LSB) & DBI_WINDOW_REG_DATA_412_MASK)
#define DBI_WINDOW_REG_DATA_412_RESET                                          0x0
#define DBI_WINDOW_REG_412_ADDRESS                                             (0x670 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_412_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_412_RESET                                               0x0

// 0x674 (DBI_WINDOW_REG_413)
#define DBI_WINDOW_REG_DATA_413_LSB                                            0
#define DBI_WINDOW_REG_DATA_413_MSB                                            31
#define DBI_WINDOW_REG_DATA_413_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_413_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_413_MASK) >> DBI_WINDOW_REG_DATA_413_LSB)
#define DBI_WINDOW_REG_DATA_413_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_413_LSB) & DBI_WINDOW_REG_DATA_413_MASK)
#define DBI_WINDOW_REG_DATA_413_RESET                                          0x0
#define DBI_WINDOW_REG_413_ADDRESS                                             (0x674 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_413_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_413_RESET                                               0x0

// 0x678 (DBI_WINDOW_REG_414)
#define DBI_WINDOW_REG_DATA_414_LSB                                            0
#define DBI_WINDOW_REG_DATA_414_MSB                                            31
#define DBI_WINDOW_REG_DATA_414_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_414_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_414_MASK) >> DBI_WINDOW_REG_DATA_414_LSB)
#define DBI_WINDOW_REG_DATA_414_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_414_LSB) & DBI_WINDOW_REG_DATA_414_MASK)
#define DBI_WINDOW_REG_DATA_414_RESET                                          0x0
#define DBI_WINDOW_REG_414_ADDRESS                                             (0x678 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_414_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_414_RESET                                               0x0

// 0x67c (DBI_WINDOW_REG_415)
#define DBI_WINDOW_REG_DATA_415_LSB                                            0
#define DBI_WINDOW_REG_DATA_415_MSB                                            31
#define DBI_WINDOW_REG_DATA_415_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_415_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_415_MASK) >> DBI_WINDOW_REG_DATA_415_LSB)
#define DBI_WINDOW_REG_DATA_415_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_415_LSB) & DBI_WINDOW_REG_DATA_415_MASK)
#define DBI_WINDOW_REG_DATA_415_RESET                                          0x0
#define DBI_WINDOW_REG_415_ADDRESS                                             (0x67c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_415_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_415_RESET                                               0x0

// 0x680 (DBI_WINDOW_REG_416)
#define DBI_WINDOW_REG_DATA_416_LSB                                            0
#define DBI_WINDOW_REG_DATA_416_MSB                                            31
#define DBI_WINDOW_REG_DATA_416_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_416_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_416_MASK) >> DBI_WINDOW_REG_DATA_416_LSB)
#define DBI_WINDOW_REG_DATA_416_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_416_LSB) & DBI_WINDOW_REG_DATA_416_MASK)
#define DBI_WINDOW_REG_DATA_416_RESET                                          0x0
#define DBI_WINDOW_REG_416_ADDRESS                                             (0x680 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_416_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_416_RESET                                               0x0

// 0x684 (DBI_WINDOW_REG_417)
#define DBI_WINDOW_REG_DATA_417_LSB                                            0
#define DBI_WINDOW_REG_DATA_417_MSB                                            31
#define DBI_WINDOW_REG_DATA_417_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_417_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_417_MASK) >> DBI_WINDOW_REG_DATA_417_LSB)
#define DBI_WINDOW_REG_DATA_417_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_417_LSB) & DBI_WINDOW_REG_DATA_417_MASK)
#define DBI_WINDOW_REG_DATA_417_RESET                                          0x0
#define DBI_WINDOW_REG_417_ADDRESS                                             (0x684 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_417_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_417_RESET                                               0x0

// 0x688 (DBI_WINDOW_REG_418)
#define DBI_WINDOW_REG_DATA_418_LSB                                            0
#define DBI_WINDOW_REG_DATA_418_MSB                                            31
#define DBI_WINDOW_REG_DATA_418_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_418_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_418_MASK) >> DBI_WINDOW_REG_DATA_418_LSB)
#define DBI_WINDOW_REG_DATA_418_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_418_LSB) & DBI_WINDOW_REG_DATA_418_MASK)
#define DBI_WINDOW_REG_DATA_418_RESET                                          0x0
#define DBI_WINDOW_REG_418_ADDRESS                                             (0x688 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_418_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_418_RESET                                               0x0

// 0x68c (DBI_WINDOW_REG_419)
#define DBI_WINDOW_REG_DATA_419_LSB                                            0
#define DBI_WINDOW_REG_DATA_419_MSB                                            31
#define DBI_WINDOW_REG_DATA_419_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_419_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_419_MASK) >> DBI_WINDOW_REG_DATA_419_LSB)
#define DBI_WINDOW_REG_DATA_419_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_419_LSB) & DBI_WINDOW_REG_DATA_419_MASK)
#define DBI_WINDOW_REG_DATA_419_RESET                                          0x0
#define DBI_WINDOW_REG_419_ADDRESS                                             (0x68c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_419_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_419_RESET                                               0x0

// 0x690 (DBI_WINDOW_REG_420)
#define DBI_WINDOW_REG_DATA_420_LSB                                            0
#define DBI_WINDOW_REG_DATA_420_MSB                                            31
#define DBI_WINDOW_REG_DATA_420_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_420_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_420_MASK) >> DBI_WINDOW_REG_DATA_420_LSB)
#define DBI_WINDOW_REG_DATA_420_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_420_LSB) & DBI_WINDOW_REG_DATA_420_MASK)
#define DBI_WINDOW_REG_DATA_420_RESET                                          0x0
#define DBI_WINDOW_REG_420_ADDRESS                                             (0x690 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_420_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_420_RESET                                               0x0

// 0x694 (DBI_WINDOW_REG_421)
#define DBI_WINDOW_REG_DATA_421_LSB                                            0
#define DBI_WINDOW_REG_DATA_421_MSB                                            31
#define DBI_WINDOW_REG_DATA_421_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_421_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_421_MASK) >> DBI_WINDOW_REG_DATA_421_LSB)
#define DBI_WINDOW_REG_DATA_421_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_421_LSB) & DBI_WINDOW_REG_DATA_421_MASK)
#define DBI_WINDOW_REG_DATA_421_RESET                                          0x0
#define DBI_WINDOW_REG_421_ADDRESS                                             (0x694 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_421_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_421_RESET                                               0x0

// 0x698 (DBI_WINDOW_REG_422)
#define DBI_WINDOW_REG_DATA_422_LSB                                            0
#define DBI_WINDOW_REG_DATA_422_MSB                                            31
#define DBI_WINDOW_REG_DATA_422_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_422_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_422_MASK) >> DBI_WINDOW_REG_DATA_422_LSB)
#define DBI_WINDOW_REG_DATA_422_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_422_LSB) & DBI_WINDOW_REG_DATA_422_MASK)
#define DBI_WINDOW_REG_DATA_422_RESET                                          0x0
#define DBI_WINDOW_REG_422_ADDRESS                                             (0x698 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_422_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_422_RESET                                               0x0

// 0x69c (DBI_WINDOW_REG_423)
#define DBI_WINDOW_REG_DATA_423_LSB                                            0
#define DBI_WINDOW_REG_DATA_423_MSB                                            31
#define DBI_WINDOW_REG_DATA_423_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_423_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_423_MASK) >> DBI_WINDOW_REG_DATA_423_LSB)
#define DBI_WINDOW_REG_DATA_423_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_423_LSB) & DBI_WINDOW_REG_DATA_423_MASK)
#define DBI_WINDOW_REG_DATA_423_RESET                                          0x0
#define DBI_WINDOW_REG_423_ADDRESS                                             (0x69c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_423_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_423_RESET                                               0x0

// 0x6a0 (DBI_WINDOW_REG_424)
#define DBI_WINDOW_REG_DATA_424_LSB                                            0
#define DBI_WINDOW_REG_DATA_424_MSB                                            31
#define DBI_WINDOW_REG_DATA_424_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_424_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_424_MASK) >> DBI_WINDOW_REG_DATA_424_LSB)
#define DBI_WINDOW_REG_DATA_424_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_424_LSB) & DBI_WINDOW_REG_DATA_424_MASK)
#define DBI_WINDOW_REG_DATA_424_RESET                                          0x0
#define DBI_WINDOW_REG_424_ADDRESS                                             (0x6a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_424_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_424_RESET                                               0x0

// 0x6a4 (DBI_WINDOW_REG_425)
#define DBI_WINDOW_REG_DATA_425_LSB                                            0
#define DBI_WINDOW_REG_DATA_425_MSB                                            31
#define DBI_WINDOW_REG_DATA_425_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_425_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_425_MASK) >> DBI_WINDOW_REG_DATA_425_LSB)
#define DBI_WINDOW_REG_DATA_425_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_425_LSB) & DBI_WINDOW_REG_DATA_425_MASK)
#define DBI_WINDOW_REG_DATA_425_RESET                                          0x0
#define DBI_WINDOW_REG_425_ADDRESS                                             (0x6a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_425_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_425_RESET                                               0x0

// 0x6a8 (DBI_WINDOW_REG_426)
#define DBI_WINDOW_REG_DATA_426_LSB                                            0
#define DBI_WINDOW_REG_DATA_426_MSB                                            31
#define DBI_WINDOW_REG_DATA_426_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_426_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_426_MASK) >> DBI_WINDOW_REG_DATA_426_LSB)
#define DBI_WINDOW_REG_DATA_426_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_426_LSB) & DBI_WINDOW_REG_DATA_426_MASK)
#define DBI_WINDOW_REG_DATA_426_RESET                                          0x0
#define DBI_WINDOW_REG_426_ADDRESS                                             (0x6a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_426_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_426_RESET                                               0x0

// 0x6ac (DBI_WINDOW_REG_427)
#define DBI_WINDOW_REG_DATA_427_LSB                                            0
#define DBI_WINDOW_REG_DATA_427_MSB                                            31
#define DBI_WINDOW_REG_DATA_427_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_427_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_427_MASK) >> DBI_WINDOW_REG_DATA_427_LSB)
#define DBI_WINDOW_REG_DATA_427_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_427_LSB) & DBI_WINDOW_REG_DATA_427_MASK)
#define DBI_WINDOW_REG_DATA_427_RESET                                          0x0
#define DBI_WINDOW_REG_427_ADDRESS                                             (0x6ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_427_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_427_RESET                                               0x0

// 0x6b0 (DBI_WINDOW_REG_428)
#define DBI_WINDOW_REG_DATA_428_LSB                                            0
#define DBI_WINDOW_REG_DATA_428_MSB                                            31
#define DBI_WINDOW_REG_DATA_428_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_428_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_428_MASK) >> DBI_WINDOW_REG_DATA_428_LSB)
#define DBI_WINDOW_REG_DATA_428_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_428_LSB) & DBI_WINDOW_REG_DATA_428_MASK)
#define DBI_WINDOW_REG_DATA_428_RESET                                          0x0
#define DBI_WINDOW_REG_428_ADDRESS                                             (0x6b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_428_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_428_RESET                                               0x0

// 0x6b4 (DBI_WINDOW_REG_429)
#define DBI_WINDOW_REG_DATA_429_LSB                                            0
#define DBI_WINDOW_REG_DATA_429_MSB                                            31
#define DBI_WINDOW_REG_DATA_429_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_429_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_429_MASK) >> DBI_WINDOW_REG_DATA_429_LSB)
#define DBI_WINDOW_REG_DATA_429_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_429_LSB) & DBI_WINDOW_REG_DATA_429_MASK)
#define DBI_WINDOW_REG_DATA_429_RESET                                          0x0
#define DBI_WINDOW_REG_429_ADDRESS                                             (0x6b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_429_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_429_RESET                                               0x0

// 0x6b8 (DBI_WINDOW_REG_430)
#define DBI_WINDOW_REG_DATA_430_LSB                                            0
#define DBI_WINDOW_REG_DATA_430_MSB                                            31
#define DBI_WINDOW_REG_DATA_430_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_430_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_430_MASK) >> DBI_WINDOW_REG_DATA_430_LSB)
#define DBI_WINDOW_REG_DATA_430_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_430_LSB) & DBI_WINDOW_REG_DATA_430_MASK)
#define DBI_WINDOW_REG_DATA_430_RESET                                          0x0
#define DBI_WINDOW_REG_430_ADDRESS                                             (0x6b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_430_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_430_RESET                                               0x0

// 0x6bc (DBI_WINDOW_REG_431)
#define DBI_WINDOW_REG_DATA_431_LSB                                            0
#define DBI_WINDOW_REG_DATA_431_MSB                                            31
#define DBI_WINDOW_REG_DATA_431_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_431_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_431_MASK) >> DBI_WINDOW_REG_DATA_431_LSB)
#define DBI_WINDOW_REG_DATA_431_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_431_LSB) & DBI_WINDOW_REG_DATA_431_MASK)
#define DBI_WINDOW_REG_DATA_431_RESET                                          0x0
#define DBI_WINDOW_REG_431_ADDRESS                                             (0x6bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_431_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_431_RESET                                               0x0

// 0x6c0 (DBI_WINDOW_REG_432)
#define DBI_WINDOW_REG_DATA_432_LSB                                            0
#define DBI_WINDOW_REG_DATA_432_MSB                                            31
#define DBI_WINDOW_REG_DATA_432_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_432_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_432_MASK) >> DBI_WINDOW_REG_DATA_432_LSB)
#define DBI_WINDOW_REG_DATA_432_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_432_LSB) & DBI_WINDOW_REG_DATA_432_MASK)
#define DBI_WINDOW_REG_DATA_432_RESET                                          0x0
#define DBI_WINDOW_REG_432_ADDRESS                                             (0x6c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_432_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_432_RESET                                               0x0

// 0x6c4 (DBI_WINDOW_REG_433)
#define DBI_WINDOW_REG_DATA_433_LSB                                            0
#define DBI_WINDOW_REG_DATA_433_MSB                                            31
#define DBI_WINDOW_REG_DATA_433_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_433_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_433_MASK) >> DBI_WINDOW_REG_DATA_433_LSB)
#define DBI_WINDOW_REG_DATA_433_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_433_LSB) & DBI_WINDOW_REG_DATA_433_MASK)
#define DBI_WINDOW_REG_DATA_433_RESET                                          0x0
#define DBI_WINDOW_REG_433_ADDRESS                                             (0x6c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_433_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_433_RESET                                               0x0

// 0x6c8 (DBI_WINDOW_REG_434)
#define DBI_WINDOW_REG_DATA_434_LSB                                            0
#define DBI_WINDOW_REG_DATA_434_MSB                                            31
#define DBI_WINDOW_REG_DATA_434_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_434_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_434_MASK) >> DBI_WINDOW_REG_DATA_434_LSB)
#define DBI_WINDOW_REG_DATA_434_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_434_LSB) & DBI_WINDOW_REG_DATA_434_MASK)
#define DBI_WINDOW_REG_DATA_434_RESET                                          0x0
#define DBI_WINDOW_REG_434_ADDRESS                                             (0x6c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_434_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_434_RESET                                               0x0

// 0x6cc (DBI_WINDOW_REG_435)
#define DBI_WINDOW_REG_DATA_435_LSB                                            0
#define DBI_WINDOW_REG_DATA_435_MSB                                            31
#define DBI_WINDOW_REG_DATA_435_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_435_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_435_MASK) >> DBI_WINDOW_REG_DATA_435_LSB)
#define DBI_WINDOW_REG_DATA_435_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_435_LSB) & DBI_WINDOW_REG_DATA_435_MASK)
#define DBI_WINDOW_REG_DATA_435_RESET                                          0x0
#define DBI_WINDOW_REG_435_ADDRESS                                             (0x6cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_435_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_435_RESET                                               0x0

// 0x6d0 (DBI_WINDOW_REG_436)
#define DBI_WINDOW_REG_DATA_436_LSB                                            0
#define DBI_WINDOW_REG_DATA_436_MSB                                            31
#define DBI_WINDOW_REG_DATA_436_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_436_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_436_MASK) >> DBI_WINDOW_REG_DATA_436_LSB)
#define DBI_WINDOW_REG_DATA_436_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_436_LSB) & DBI_WINDOW_REG_DATA_436_MASK)
#define DBI_WINDOW_REG_DATA_436_RESET                                          0x0
#define DBI_WINDOW_REG_436_ADDRESS                                             (0x6d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_436_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_436_RESET                                               0x0

// 0x6d4 (DBI_WINDOW_REG_437)
#define DBI_WINDOW_REG_DATA_437_LSB                                            0
#define DBI_WINDOW_REG_DATA_437_MSB                                            31
#define DBI_WINDOW_REG_DATA_437_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_437_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_437_MASK) >> DBI_WINDOW_REG_DATA_437_LSB)
#define DBI_WINDOW_REG_DATA_437_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_437_LSB) & DBI_WINDOW_REG_DATA_437_MASK)
#define DBI_WINDOW_REG_DATA_437_RESET                                          0x0
#define DBI_WINDOW_REG_437_ADDRESS                                             (0x6d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_437_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_437_RESET                                               0x0

// 0x6d8 (DBI_WINDOW_REG_438)
#define DBI_WINDOW_REG_DATA_438_LSB                                            0
#define DBI_WINDOW_REG_DATA_438_MSB                                            31
#define DBI_WINDOW_REG_DATA_438_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_438_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_438_MASK) >> DBI_WINDOW_REG_DATA_438_LSB)
#define DBI_WINDOW_REG_DATA_438_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_438_LSB) & DBI_WINDOW_REG_DATA_438_MASK)
#define DBI_WINDOW_REG_DATA_438_RESET                                          0x0
#define DBI_WINDOW_REG_438_ADDRESS                                             (0x6d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_438_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_438_RESET                                               0x0

// 0x6dc (DBI_WINDOW_REG_439)
#define DBI_WINDOW_REG_DATA_439_LSB                                            0
#define DBI_WINDOW_REG_DATA_439_MSB                                            31
#define DBI_WINDOW_REG_DATA_439_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_439_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_439_MASK) >> DBI_WINDOW_REG_DATA_439_LSB)
#define DBI_WINDOW_REG_DATA_439_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_439_LSB) & DBI_WINDOW_REG_DATA_439_MASK)
#define DBI_WINDOW_REG_DATA_439_RESET                                          0x0
#define DBI_WINDOW_REG_439_ADDRESS                                             (0x6dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_439_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_439_RESET                                               0x0

// 0x6e0 (DBI_WINDOW_REG_440)
#define DBI_WINDOW_REG_DATA_440_LSB                                            0
#define DBI_WINDOW_REG_DATA_440_MSB                                            31
#define DBI_WINDOW_REG_DATA_440_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_440_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_440_MASK) >> DBI_WINDOW_REG_DATA_440_LSB)
#define DBI_WINDOW_REG_DATA_440_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_440_LSB) & DBI_WINDOW_REG_DATA_440_MASK)
#define DBI_WINDOW_REG_DATA_440_RESET                                          0x0
#define DBI_WINDOW_REG_440_ADDRESS                                             (0x6e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_440_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_440_RESET                                               0x0

// 0x6e4 (DBI_WINDOW_REG_441)
#define DBI_WINDOW_REG_DATA_441_LSB                                            0
#define DBI_WINDOW_REG_DATA_441_MSB                                            31
#define DBI_WINDOW_REG_DATA_441_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_441_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_441_MASK) >> DBI_WINDOW_REG_DATA_441_LSB)
#define DBI_WINDOW_REG_DATA_441_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_441_LSB) & DBI_WINDOW_REG_DATA_441_MASK)
#define DBI_WINDOW_REG_DATA_441_RESET                                          0x0
#define DBI_WINDOW_REG_441_ADDRESS                                             (0x6e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_441_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_441_RESET                                               0x0

// 0x6e8 (DBI_WINDOW_REG_442)
#define DBI_WINDOW_REG_DATA_442_LSB                                            0
#define DBI_WINDOW_REG_DATA_442_MSB                                            31
#define DBI_WINDOW_REG_DATA_442_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_442_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_442_MASK) >> DBI_WINDOW_REG_DATA_442_LSB)
#define DBI_WINDOW_REG_DATA_442_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_442_LSB) & DBI_WINDOW_REG_DATA_442_MASK)
#define DBI_WINDOW_REG_DATA_442_RESET                                          0x0
#define DBI_WINDOW_REG_442_ADDRESS                                             (0x6e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_442_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_442_RESET                                               0x0

// 0x6ec (DBI_WINDOW_REG_443)
#define DBI_WINDOW_REG_DATA_443_LSB                                            0
#define DBI_WINDOW_REG_DATA_443_MSB                                            31
#define DBI_WINDOW_REG_DATA_443_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_443_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_443_MASK) >> DBI_WINDOW_REG_DATA_443_LSB)
#define DBI_WINDOW_REG_DATA_443_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_443_LSB) & DBI_WINDOW_REG_DATA_443_MASK)
#define DBI_WINDOW_REG_DATA_443_RESET                                          0x0
#define DBI_WINDOW_REG_443_ADDRESS                                             (0x6ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_443_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_443_RESET                                               0x0

// 0x6f0 (DBI_WINDOW_REG_444)
#define DBI_WINDOW_REG_DATA_444_LSB                                            0
#define DBI_WINDOW_REG_DATA_444_MSB                                            31
#define DBI_WINDOW_REG_DATA_444_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_444_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_444_MASK) >> DBI_WINDOW_REG_DATA_444_LSB)
#define DBI_WINDOW_REG_DATA_444_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_444_LSB) & DBI_WINDOW_REG_DATA_444_MASK)
#define DBI_WINDOW_REG_DATA_444_RESET                                          0x0
#define DBI_WINDOW_REG_444_ADDRESS                                             (0x6f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_444_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_444_RESET                                               0x0

// 0x6f4 (DBI_WINDOW_REG_445)
#define DBI_WINDOW_REG_DATA_445_LSB                                            0
#define DBI_WINDOW_REG_DATA_445_MSB                                            31
#define DBI_WINDOW_REG_DATA_445_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_445_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_445_MASK) >> DBI_WINDOW_REG_DATA_445_LSB)
#define DBI_WINDOW_REG_DATA_445_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_445_LSB) & DBI_WINDOW_REG_DATA_445_MASK)
#define DBI_WINDOW_REG_DATA_445_RESET                                          0x0
#define DBI_WINDOW_REG_445_ADDRESS                                             (0x6f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_445_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_445_RESET                                               0x0

// 0x6f8 (DBI_WINDOW_REG_446)
#define DBI_WINDOW_REG_DATA_446_LSB                                            0
#define DBI_WINDOW_REG_DATA_446_MSB                                            31
#define DBI_WINDOW_REG_DATA_446_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_446_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_446_MASK) >> DBI_WINDOW_REG_DATA_446_LSB)
#define DBI_WINDOW_REG_DATA_446_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_446_LSB) & DBI_WINDOW_REG_DATA_446_MASK)
#define DBI_WINDOW_REG_DATA_446_RESET                                          0x0
#define DBI_WINDOW_REG_446_ADDRESS                                             (0x6f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_446_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_446_RESET                                               0x0

// 0x6fc (DBI_WINDOW_REG_447)
#define DBI_WINDOW_REG_DATA_447_LSB                                            0
#define DBI_WINDOW_REG_DATA_447_MSB                                            31
#define DBI_WINDOW_REG_DATA_447_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_447_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_447_MASK) >> DBI_WINDOW_REG_DATA_447_LSB)
#define DBI_WINDOW_REG_DATA_447_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_447_LSB) & DBI_WINDOW_REG_DATA_447_MASK)
#define DBI_WINDOW_REG_DATA_447_RESET                                          0x0
#define DBI_WINDOW_REG_447_ADDRESS                                             (0x6fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_447_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_447_RESET                                               0x0

// 0x700 (DBI_WINDOW_REG_448)
#define DBI_WINDOW_REG_DATA_448_LSB                                            0
#define DBI_WINDOW_REG_DATA_448_MSB                                            31
#define DBI_WINDOW_REG_DATA_448_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_448_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_448_MASK) >> DBI_WINDOW_REG_DATA_448_LSB)
#define DBI_WINDOW_REG_DATA_448_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_448_LSB) & DBI_WINDOW_REG_DATA_448_MASK)
#define DBI_WINDOW_REG_DATA_448_RESET                                          0x0
#define DBI_WINDOW_REG_448_ADDRESS                                             (0x700 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_448_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_448_RESET                                               0x0

// 0x704 (DBI_WINDOW_REG_449)
#define DBI_WINDOW_REG_DATA_449_LSB                                            0
#define DBI_WINDOW_REG_DATA_449_MSB                                            31
#define DBI_WINDOW_REG_DATA_449_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_449_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_449_MASK) >> DBI_WINDOW_REG_DATA_449_LSB)
#define DBI_WINDOW_REG_DATA_449_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_449_LSB) & DBI_WINDOW_REG_DATA_449_MASK)
#define DBI_WINDOW_REG_DATA_449_RESET                                          0x0
#define DBI_WINDOW_REG_449_ADDRESS                                             (0x704 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_449_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_449_RESET                                               0x0

// 0x708 (DBI_WINDOW_REG_450)
#define DBI_WINDOW_REG_DATA_450_LSB                                            0
#define DBI_WINDOW_REG_DATA_450_MSB                                            31
#define DBI_WINDOW_REG_DATA_450_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_450_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_450_MASK) >> DBI_WINDOW_REG_DATA_450_LSB)
#define DBI_WINDOW_REG_DATA_450_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_450_LSB) & DBI_WINDOW_REG_DATA_450_MASK)
#define DBI_WINDOW_REG_DATA_450_RESET                                          0x0
#define DBI_WINDOW_REG_450_ADDRESS                                             (0x708 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_450_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_450_RESET                                               0x0

// 0x70c (DBI_WINDOW_REG_451)
#define DBI_WINDOW_REG_DATA_451_LSB                                            0
#define DBI_WINDOW_REG_DATA_451_MSB                                            31
#define DBI_WINDOW_REG_DATA_451_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_451_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_451_MASK) >> DBI_WINDOW_REG_DATA_451_LSB)
#define DBI_WINDOW_REG_DATA_451_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_451_LSB) & DBI_WINDOW_REG_DATA_451_MASK)
#define DBI_WINDOW_REG_DATA_451_RESET                                          0x0
#define DBI_WINDOW_REG_451_ADDRESS                                             (0x70c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_451_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_451_RESET                                               0x0

// 0x710 (DBI_WINDOW_REG_452)
#define DBI_WINDOW_REG_DATA_452_LSB                                            0
#define DBI_WINDOW_REG_DATA_452_MSB                                            31
#define DBI_WINDOW_REG_DATA_452_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_452_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_452_MASK) >> DBI_WINDOW_REG_DATA_452_LSB)
#define DBI_WINDOW_REG_DATA_452_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_452_LSB) & DBI_WINDOW_REG_DATA_452_MASK)
#define DBI_WINDOW_REG_DATA_452_RESET                                          0x0
#define DBI_WINDOW_REG_452_ADDRESS                                             (0x710 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_452_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_452_RESET                                               0x0

// 0x714 (DBI_WINDOW_REG_453)
#define DBI_WINDOW_REG_DATA_453_LSB                                            0
#define DBI_WINDOW_REG_DATA_453_MSB                                            31
#define DBI_WINDOW_REG_DATA_453_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_453_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_453_MASK) >> DBI_WINDOW_REG_DATA_453_LSB)
#define DBI_WINDOW_REG_DATA_453_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_453_LSB) & DBI_WINDOW_REG_DATA_453_MASK)
#define DBI_WINDOW_REG_DATA_453_RESET                                          0x0
#define DBI_WINDOW_REG_453_ADDRESS                                             (0x714 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_453_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_453_RESET                                               0x0

// 0x718 (DBI_WINDOW_REG_454)
#define DBI_WINDOW_REG_DATA_454_LSB                                            0
#define DBI_WINDOW_REG_DATA_454_MSB                                            31
#define DBI_WINDOW_REG_DATA_454_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_454_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_454_MASK) >> DBI_WINDOW_REG_DATA_454_LSB)
#define DBI_WINDOW_REG_DATA_454_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_454_LSB) & DBI_WINDOW_REG_DATA_454_MASK)
#define DBI_WINDOW_REG_DATA_454_RESET                                          0x0
#define DBI_WINDOW_REG_454_ADDRESS                                             (0x718 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_454_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_454_RESET                                               0x0

// 0x71c (DBI_WINDOW_REG_455)
#define DBI_WINDOW_REG_DATA_455_LSB                                            0
#define DBI_WINDOW_REG_DATA_455_MSB                                            31
#define DBI_WINDOW_REG_DATA_455_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_455_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_455_MASK) >> DBI_WINDOW_REG_DATA_455_LSB)
#define DBI_WINDOW_REG_DATA_455_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_455_LSB) & DBI_WINDOW_REG_DATA_455_MASK)
#define DBI_WINDOW_REG_DATA_455_RESET                                          0x0
#define DBI_WINDOW_REG_455_ADDRESS                                             (0x71c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_455_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_455_RESET                                               0x0

// 0x720 (DBI_WINDOW_REG_456)
#define DBI_WINDOW_REG_DATA_456_LSB                                            0
#define DBI_WINDOW_REG_DATA_456_MSB                                            31
#define DBI_WINDOW_REG_DATA_456_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_456_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_456_MASK) >> DBI_WINDOW_REG_DATA_456_LSB)
#define DBI_WINDOW_REG_DATA_456_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_456_LSB) & DBI_WINDOW_REG_DATA_456_MASK)
#define DBI_WINDOW_REG_DATA_456_RESET                                          0x0
#define DBI_WINDOW_REG_456_ADDRESS                                             (0x720 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_456_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_456_RESET                                               0x0

// 0x724 (DBI_WINDOW_REG_457)
#define DBI_WINDOW_REG_DATA_457_LSB                                            0
#define DBI_WINDOW_REG_DATA_457_MSB                                            31
#define DBI_WINDOW_REG_DATA_457_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_457_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_457_MASK) >> DBI_WINDOW_REG_DATA_457_LSB)
#define DBI_WINDOW_REG_DATA_457_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_457_LSB) & DBI_WINDOW_REG_DATA_457_MASK)
#define DBI_WINDOW_REG_DATA_457_RESET                                          0x0
#define DBI_WINDOW_REG_457_ADDRESS                                             (0x724 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_457_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_457_RESET                                               0x0

// 0x728 (DBI_WINDOW_REG_458)
#define DBI_WINDOW_REG_DATA_458_LSB                                            0
#define DBI_WINDOW_REG_DATA_458_MSB                                            31
#define DBI_WINDOW_REG_DATA_458_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_458_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_458_MASK) >> DBI_WINDOW_REG_DATA_458_LSB)
#define DBI_WINDOW_REG_DATA_458_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_458_LSB) & DBI_WINDOW_REG_DATA_458_MASK)
#define DBI_WINDOW_REG_DATA_458_RESET                                          0x0
#define DBI_WINDOW_REG_458_ADDRESS                                             (0x728 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_458_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_458_RESET                                               0x0

// 0x72c (DBI_WINDOW_REG_459)
#define DBI_WINDOW_REG_DATA_459_LSB                                            0
#define DBI_WINDOW_REG_DATA_459_MSB                                            31
#define DBI_WINDOW_REG_DATA_459_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_459_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_459_MASK) >> DBI_WINDOW_REG_DATA_459_LSB)
#define DBI_WINDOW_REG_DATA_459_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_459_LSB) & DBI_WINDOW_REG_DATA_459_MASK)
#define DBI_WINDOW_REG_DATA_459_RESET                                          0x0
#define DBI_WINDOW_REG_459_ADDRESS                                             (0x72c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_459_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_459_RESET                                               0x0

// 0x730 (DBI_WINDOW_REG_460)
#define DBI_WINDOW_REG_DATA_460_LSB                                            0
#define DBI_WINDOW_REG_DATA_460_MSB                                            31
#define DBI_WINDOW_REG_DATA_460_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_460_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_460_MASK) >> DBI_WINDOW_REG_DATA_460_LSB)
#define DBI_WINDOW_REG_DATA_460_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_460_LSB) & DBI_WINDOW_REG_DATA_460_MASK)
#define DBI_WINDOW_REG_DATA_460_RESET                                          0x0
#define DBI_WINDOW_REG_460_ADDRESS                                             (0x730 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_460_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_460_RESET                                               0x0

// 0x734 (DBI_WINDOW_REG_461)
#define DBI_WINDOW_REG_DATA_461_LSB                                            0
#define DBI_WINDOW_REG_DATA_461_MSB                                            31
#define DBI_WINDOW_REG_DATA_461_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_461_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_461_MASK) >> DBI_WINDOW_REG_DATA_461_LSB)
#define DBI_WINDOW_REG_DATA_461_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_461_LSB) & DBI_WINDOW_REG_DATA_461_MASK)
#define DBI_WINDOW_REG_DATA_461_RESET                                          0x0
#define DBI_WINDOW_REG_461_ADDRESS                                             (0x734 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_461_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_461_RESET                                               0x0

// 0x738 (DBI_WINDOW_REG_462)
#define DBI_WINDOW_REG_DATA_462_LSB                                            0
#define DBI_WINDOW_REG_DATA_462_MSB                                            31
#define DBI_WINDOW_REG_DATA_462_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_462_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_462_MASK) >> DBI_WINDOW_REG_DATA_462_LSB)
#define DBI_WINDOW_REG_DATA_462_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_462_LSB) & DBI_WINDOW_REG_DATA_462_MASK)
#define DBI_WINDOW_REG_DATA_462_RESET                                          0x0
#define DBI_WINDOW_REG_462_ADDRESS                                             (0x738 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_462_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_462_RESET                                               0x0

// 0x73c (DBI_WINDOW_REG_463)
#define DBI_WINDOW_REG_DATA_463_LSB                                            0
#define DBI_WINDOW_REG_DATA_463_MSB                                            31
#define DBI_WINDOW_REG_DATA_463_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_463_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_463_MASK) >> DBI_WINDOW_REG_DATA_463_LSB)
#define DBI_WINDOW_REG_DATA_463_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_463_LSB) & DBI_WINDOW_REG_DATA_463_MASK)
#define DBI_WINDOW_REG_DATA_463_RESET                                          0x0
#define DBI_WINDOW_REG_463_ADDRESS                                             (0x73c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_463_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_463_RESET                                               0x0

// 0x740 (DBI_WINDOW_REG_464)
#define DBI_WINDOW_REG_DATA_464_LSB                                            0
#define DBI_WINDOW_REG_DATA_464_MSB                                            31
#define DBI_WINDOW_REG_DATA_464_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_464_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_464_MASK) >> DBI_WINDOW_REG_DATA_464_LSB)
#define DBI_WINDOW_REG_DATA_464_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_464_LSB) & DBI_WINDOW_REG_DATA_464_MASK)
#define DBI_WINDOW_REG_DATA_464_RESET                                          0x0
#define DBI_WINDOW_REG_464_ADDRESS                                             (0x740 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_464_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_464_RESET                                               0x0

// 0x744 (DBI_WINDOW_REG_465)
#define DBI_WINDOW_REG_DATA_465_LSB                                            0
#define DBI_WINDOW_REG_DATA_465_MSB                                            31
#define DBI_WINDOW_REG_DATA_465_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_465_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_465_MASK) >> DBI_WINDOW_REG_DATA_465_LSB)
#define DBI_WINDOW_REG_DATA_465_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_465_LSB) & DBI_WINDOW_REG_DATA_465_MASK)
#define DBI_WINDOW_REG_DATA_465_RESET                                          0x0
#define DBI_WINDOW_REG_465_ADDRESS                                             (0x744 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_465_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_465_RESET                                               0x0

// 0x748 (DBI_WINDOW_REG_466)
#define DBI_WINDOW_REG_DATA_466_LSB                                            0
#define DBI_WINDOW_REG_DATA_466_MSB                                            31
#define DBI_WINDOW_REG_DATA_466_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_466_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_466_MASK) >> DBI_WINDOW_REG_DATA_466_LSB)
#define DBI_WINDOW_REG_DATA_466_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_466_LSB) & DBI_WINDOW_REG_DATA_466_MASK)
#define DBI_WINDOW_REG_DATA_466_RESET                                          0x0
#define DBI_WINDOW_REG_466_ADDRESS                                             (0x748 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_466_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_466_RESET                                               0x0

// 0x74c (DBI_WINDOW_REG_467)
#define DBI_WINDOW_REG_DATA_467_LSB                                            0
#define DBI_WINDOW_REG_DATA_467_MSB                                            31
#define DBI_WINDOW_REG_DATA_467_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_467_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_467_MASK) >> DBI_WINDOW_REG_DATA_467_LSB)
#define DBI_WINDOW_REG_DATA_467_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_467_LSB) & DBI_WINDOW_REG_DATA_467_MASK)
#define DBI_WINDOW_REG_DATA_467_RESET                                          0x0
#define DBI_WINDOW_REG_467_ADDRESS                                             (0x74c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_467_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_467_RESET                                               0x0

// 0x750 (DBI_WINDOW_REG_468)
#define DBI_WINDOW_REG_DATA_468_LSB                                            0
#define DBI_WINDOW_REG_DATA_468_MSB                                            31
#define DBI_WINDOW_REG_DATA_468_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_468_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_468_MASK) >> DBI_WINDOW_REG_DATA_468_LSB)
#define DBI_WINDOW_REG_DATA_468_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_468_LSB) & DBI_WINDOW_REG_DATA_468_MASK)
#define DBI_WINDOW_REG_DATA_468_RESET                                          0x0
#define DBI_WINDOW_REG_468_ADDRESS                                             (0x750 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_468_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_468_RESET                                               0x0

// 0x754 (DBI_WINDOW_REG_469)
#define DBI_WINDOW_REG_DATA_469_LSB                                            0
#define DBI_WINDOW_REG_DATA_469_MSB                                            31
#define DBI_WINDOW_REG_DATA_469_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_469_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_469_MASK) >> DBI_WINDOW_REG_DATA_469_LSB)
#define DBI_WINDOW_REG_DATA_469_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_469_LSB) & DBI_WINDOW_REG_DATA_469_MASK)
#define DBI_WINDOW_REG_DATA_469_RESET                                          0x0
#define DBI_WINDOW_REG_469_ADDRESS                                             (0x754 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_469_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_469_RESET                                               0x0

// 0x758 (DBI_WINDOW_REG_470)
#define DBI_WINDOW_REG_DATA_470_LSB                                            0
#define DBI_WINDOW_REG_DATA_470_MSB                                            31
#define DBI_WINDOW_REG_DATA_470_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_470_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_470_MASK) >> DBI_WINDOW_REG_DATA_470_LSB)
#define DBI_WINDOW_REG_DATA_470_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_470_LSB) & DBI_WINDOW_REG_DATA_470_MASK)
#define DBI_WINDOW_REG_DATA_470_RESET                                          0x0
#define DBI_WINDOW_REG_470_ADDRESS                                             (0x758 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_470_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_470_RESET                                               0x0

// 0x75c (DBI_WINDOW_REG_471)
#define DBI_WINDOW_REG_DATA_471_LSB                                            0
#define DBI_WINDOW_REG_DATA_471_MSB                                            31
#define DBI_WINDOW_REG_DATA_471_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_471_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_471_MASK) >> DBI_WINDOW_REG_DATA_471_LSB)
#define DBI_WINDOW_REG_DATA_471_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_471_LSB) & DBI_WINDOW_REG_DATA_471_MASK)
#define DBI_WINDOW_REG_DATA_471_RESET                                          0x0
#define DBI_WINDOW_REG_471_ADDRESS                                             (0x75c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_471_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_471_RESET                                               0x0

// 0x760 (DBI_WINDOW_REG_472)
#define DBI_WINDOW_REG_DATA_472_LSB                                            0
#define DBI_WINDOW_REG_DATA_472_MSB                                            31
#define DBI_WINDOW_REG_DATA_472_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_472_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_472_MASK) >> DBI_WINDOW_REG_DATA_472_LSB)
#define DBI_WINDOW_REG_DATA_472_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_472_LSB) & DBI_WINDOW_REG_DATA_472_MASK)
#define DBI_WINDOW_REG_DATA_472_RESET                                          0x0
#define DBI_WINDOW_REG_472_ADDRESS                                             (0x760 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_472_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_472_RESET                                               0x0

// 0x764 (DBI_WINDOW_REG_473)
#define DBI_WINDOW_REG_DATA_473_LSB                                            0
#define DBI_WINDOW_REG_DATA_473_MSB                                            31
#define DBI_WINDOW_REG_DATA_473_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_473_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_473_MASK) >> DBI_WINDOW_REG_DATA_473_LSB)
#define DBI_WINDOW_REG_DATA_473_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_473_LSB) & DBI_WINDOW_REG_DATA_473_MASK)
#define DBI_WINDOW_REG_DATA_473_RESET                                          0x0
#define DBI_WINDOW_REG_473_ADDRESS                                             (0x764 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_473_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_473_RESET                                               0x0

// 0x768 (DBI_WINDOW_REG_474)
#define DBI_WINDOW_REG_DATA_474_LSB                                            0
#define DBI_WINDOW_REG_DATA_474_MSB                                            31
#define DBI_WINDOW_REG_DATA_474_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_474_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_474_MASK) >> DBI_WINDOW_REG_DATA_474_LSB)
#define DBI_WINDOW_REG_DATA_474_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_474_LSB) & DBI_WINDOW_REG_DATA_474_MASK)
#define DBI_WINDOW_REG_DATA_474_RESET                                          0x0
#define DBI_WINDOW_REG_474_ADDRESS                                             (0x768 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_474_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_474_RESET                                               0x0

// 0x76c (DBI_WINDOW_REG_475)
#define DBI_WINDOW_REG_DATA_475_LSB                                            0
#define DBI_WINDOW_REG_DATA_475_MSB                                            31
#define DBI_WINDOW_REG_DATA_475_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_475_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_475_MASK) >> DBI_WINDOW_REG_DATA_475_LSB)
#define DBI_WINDOW_REG_DATA_475_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_475_LSB) & DBI_WINDOW_REG_DATA_475_MASK)
#define DBI_WINDOW_REG_DATA_475_RESET                                          0x0
#define DBI_WINDOW_REG_475_ADDRESS                                             (0x76c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_475_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_475_RESET                                               0x0

// 0x770 (DBI_WINDOW_REG_476)
#define DBI_WINDOW_REG_DATA_476_LSB                                            0
#define DBI_WINDOW_REG_DATA_476_MSB                                            31
#define DBI_WINDOW_REG_DATA_476_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_476_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_476_MASK) >> DBI_WINDOW_REG_DATA_476_LSB)
#define DBI_WINDOW_REG_DATA_476_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_476_LSB) & DBI_WINDOW_REG_DATA_476_MASK)
#define DBI_WINDOW_REG_DATA_476_RESET                                          0x0
#define DBI_WINDOW_REG_476_ADDRESS                                             (0x770 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_476_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_476_RESET                                               0x0

// 0x774 (DBI_WINDOW_REG_477)
#define DBI_WINDOW_REG_DATA_477_LSB                                            0
#define DBI_WINDOW_REG_DATA_477_MSB                                            31
#define DBI_WINDOW_REG_DATA_477_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_477_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_477_MASK) >> DBI_WINDOW_REG_DATA_477_LSB)
#define DBI_WINDOW_REG_DATA_477_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_477_LSB) & DBI_WINDOW_REG_DATA_477_MASK)
#define DBI_WINDOW_REG_DATA_477_RESET                                          0x0
#define DBI_WINDOW_REG_477_ADDRESS                                             (0x774 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_477_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_477_RESET                                               0x0

// 0x778 (DBI_WINDOW_REG_478)
#define DBI_WINDOW_REG_DATA_478_LSB                                            0
#define DBI_WINDOW_REG_DATA_478_MSB                                            31
#define DBI_WINDOW_REG_DATA_478_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_478_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_478_MASK) >> DBI_WINDOW_REG_DATA_478_LSB)
#define DBI_WINDOW_REG_DATA_478_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_478_LSB) & DBI_WINDOW_REG_DATA_478_MASK)
#define DBI_WINDOW_REG_DATA_478_RESET                                          0x0
#define DBI_WINDOW_REG_478_ADDRESS                                             (0x778 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_478_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_478_RESET                                               0x0

// 0x77c (DBI_WINDOW_REG_479)
#define DBI_WINDOW_REG_DATA_479_LSB                                            0
#define DBI_WINDOW_REG_DATA_479_MSB                                            31
#define DBI_WINDOW_REG_DATA_479_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_479_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_479_MASK) >> DBI_WINDOW_REG_DATA_479_LSB)
#define DBI_WINDOW_REG_DATA_479_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_479_LSB) & DBI_WINDOW_REG_DATA_479_MASK)
#define DBI_WINDOW_REG_DATA_479_RESET                                          0x0
#define DBI_WINDOW_REG_479_ADDRESS                                             (0x77c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_479_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_479_RESET                                               0x0

// 0x780 (DBI_WINDOW_REG_480)
#define DBI_WINDOW_REG_DATA_480_LSB                                            0
#define DBI_WINDOW_REG_DATA_480_MSB                                            31
#define DBI_WINDOW_REG_DATA_480_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_480_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_480_MASK) >> DBI_WINDOW_REG_DATA_480_LSB)
#define DBI_WINDOW_REG_DATA_480_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_480_LSB) & DBI_WINDOW_REG_DATA_480_MASK)
#define DBI_WINDOW_REG_DATA_480_RESET                                          0x0
#define DBI_WINDOW_REG_480_ADDRESS                                             (0x780 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_480_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_480_RESET                                               0x0

// 0x784 (DBI_WINDOW_REG_481)
#define DBI_WINDOW_REG_DATA_481_LSB                                            0
#define DBI_WINDOW_REG_DATA_481_MSB                                            31
#define DBI_WINDOW_REG_DATA_481_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_481_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_481_MASK) >> DBI_WINDOW_REG_DATA_481_LSB)
#define DBI_WINDOW_REG_DATA_481_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_481_LSB) & DBI_WINDOW_REG_DATA_481_MASK)
#define DBI_WINDOW_REG_DATA_481_RESET                                          0x0
#define DBI_WINDOW_REG_481_ADDRESS                                             (0x784 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_481_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_481_RESET                                               0x0

// 0x788 (DBI_WINDOW_REG_482)
#define DBI_WINDOW_REG_DATA_482_LSB                                            0
#define DBI_WINDOW_REG_DATA_482_MSB                                            31
#define DBI_WINDOW_REG_DATA_482_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_482_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_482_MASK) >> DBI_WINDOW_REG_DATA_482_LSB)
#define DBI_WINDOW_REG_DATA_482_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_482_LSB) & DBI_WINDOW_REG_DATA_482_MASK)
#define DBI_WINDOW_REG_DATA_482_RESET                                          0x0
#define DBI_WINDOW_REG_482_ADDRESS                                             (0x788 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_482_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_482_RESET                                               0x0

// 0x78c (DBI_WINDOW_REG_483)
#define DBI_WINDOW_REG_DATA_483_LSB                                            0
#define DBI_WINDOW_REG_DATA_483_MSB                                            31
#define DBI_WINDOW_REG_DATA_483_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_483_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_483_MASK) >> DBI_WINDOW_REG_DATA_483_LSB)
#define DBI_WINDOW_REG_DATA_483_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_483_LSB) & DBI_WINDOW_REG_DATA_483_MASK)
#define DBI_WINDOW_REG_DATA_483_RESET                                          0x0
#define DBI_WINDOW_REG_483_ADDRESS                                             (0x78c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_483_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_483_RESET                                               0x0

// 0x790 (DBI_WINDOW_REG_484)
#define DBI_WINDOW_REG_DATA_484_LSB                                            0
#define DBI_WINDOW_REG_DATA_484_MSB                                            31
#define DBI_WINDOW_REG_DATA_484_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_484_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_484_MASK) >> DBI_WINDOW_REG_DATA_484_LSB)
#define DBI_WINDOW_REG_DATA_484_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_484_LSB) & DBI_WINDOW_REG_DATA_484_MASK)
#define DBI_WINDOW_REG_DATA_484_RESET                                          0x0
#define DBI_WINDOW_REG_484_ADDRESS                                             (0x790 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_484_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_484_RESET                                               0x0

// 0x794 (DBI_WINDOW_REG_485)
#define DBI_WINDOW_REG_DATA_485_LSB                                            0
#define DBI_WINDOW_REG_DATA_485_MSB                                            31
#define DBI_WINDOW_REG_DATA_485_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_485_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_485_MASK) >> DBI_WINDOW_REG_DATA_485_LSB)
#define DBI_WINDOW_REG_DATA_485_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_485_LSB) & DBI_WINDOW_REG_DATA_485_MASK)
#define DBI_WINDOW_REG_DATA_485_RESET                                          0x0
#define DBI_WINDOW_REG_485_ADDRESS                                             (0x794 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_485_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_485_RESET                                               0x0

// 0x798 (DBI_WINDOW_REG_486)
#define DBI_WINDOW_REG_DATA_486_LSB                                            0
#define DBI_WINDOW_REG_DATA_486_MSB                                            31
#define DBI_WINDOW_REG_DATA_486_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_486_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_486_MASK) >> DBI_WINDOW_REG_DATA_486_LSB)
#define DBI_WINDOW_REG_DATA_486_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_486_LSB) & DBI_WINDOW_REG_DATA_486_MASK)
#define DBI_WINDOW_REG_DATA_486_RESET                                          0x0
#define DBI_WINDOW_REG_486_ADDRESS                                             (0x798 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_486_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_486_RESET                                               0x0

// 0x79c (DBI_WINDOW_REG_487)
#define DBI_WINDOW_REG_DATA_487_LSB                                            0
#define DBI_WINDOW_REG_DATA_487_MSB                                            31
#define DBI_WINDOW_REG_DATA_487_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_487_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_487_MASK) >> DBI_WINDOW_REG_DATA_487_LSB)
#define DBI_WINDOW_REG_DATA_487_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_487_LSB) & DBI_WINDOW_REG_DATA_487_MASK)
#define DBI_WINDOW_REG_DATA_487_RESET                                          0x0
#define DBI_WINDOW_REG_487_ADDRESS                                             (0x79c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_487_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_487_RESET                                               0x0

// 0x7a0 (DBI_WINDOW_REG_488)
#define DBI_WINDOW_REG_DATA_488_LSB                                            0
#define DBI_WINDOW_REG_DATA_488_MSB                                            31
#define DBI_WINDOW_REG_DATA_488_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_488_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_488_MASK) >> DBI_WINDOW_REG_DATA_488_LSB)
#define DBI_WINDOW_REG_DATA_488_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_488_LSB) & DBI_WINDOW_REG_DATA_488_MASK)
#define DBI_WINDOW_REG_DATA_488_RESET                                          0x0
#define DBI_WINDOW_REG_488_ADDRESS                                             (0x7a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_488_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_488_RESET                                               0x0

// 0x7a4 (DBI_WINDOW_REG_489)
#define DBI_WINDOW_REG_DATA_489_LSB                                            0
#define DBI_WINDOW_REG_DATA_489_MSB                                            31
#define DBI_WINDOW_REG_DATA_489_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_489_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_489_MASK) >> DBI_WINDOW_REG_DATA_489_LSB)
#define DBI_WINDOW_REG_DATA_489_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_489_LSB) & DBI_WINDOW_REG_DATA_489_MASK)
#define DBI_WINDOW_REG_DATA_489_RESET                                          0x0
#define DBI_WINDOW_REG_489_ADDRESS                                             (0x7a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_489_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_489_RESET                                               0x0

// 0x7a8 (DBI_WINDOW_REG_490)
#define DBI_WINDOW_REG_DATA_490_LSB                                            0
#define DBI_WINDOW_REG_DATA_490_MSB                                            31
#define DBI_WINDOW_REG_DATA_490_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_490_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_490_MASK) >> DBI_WINDOW_REG_DATA_490_LSB)
#define DBI_WINDOW_REG_DATA_490_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_490_LSB) & DBI_WINDOW_REG_DATA_490_MASK)
#define DBI_WINDOW_REG_DATA_490_RESET                                          0x0
#define DBI_WINDOW_REG_490_ADDRESS                                             (0x7a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_490_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_490_RESET                                               0x0

// 0x7ac (DBI_WINDOW_REG_491)
#define DBI_WINDOW_REG_DATA_491_LSB                                            0
#define DBI_WINDOW_REG_DATA_491_MSB                                            31
#define DBI_WINDOW_REG_DATA_491_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_491_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_491_MASK) >> DBI_WINDOW_REG_DATA_491_LSB)
#define DBI_WINDOW_REG_DATA_491_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_491_LSB) & DBI_WINDOW_REG_DATA_491_MASK)
#define DBI_WINDOW_REG_DATA_491_RESET                                          0x0
#define DBI_WINDOW_REG_491_ADDRESS                                             (0x7ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_491_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_491_RESET                                               0x0

// 0x7b0 (DBI_WINDOW_REG_492)
#define DBI_WINDOW_REG_DATA_492_LSB                                            0
#define DBI_WINDOW_REG_DATA_492_MSB                                            31
#define DBI_WINDOW_REG_DATA_492_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_492_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_492_MASK) >> DBI_WINDOW_REG_DATA_492_LSB)
#define DBI_WINDOW_REG_DATA_492_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_492_LSB) & DBI_WINDOW_REG_DATA_492_MASK)
#define DBI_WINDOW_REG_DATA_492_RESET                                          0x0
#define DBI_WINDOW_REG_492_ADDRESS                                             (0x7b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_492_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_492_RESET                                               0x0

// 0x7b4 (DBI_WINDOW_REG_493)
#define DBI_WINDOW_REG_DATA_493_LSB                                            0
#define DBI_WINDOW_REG_DATA_493_MSB                                            31
#define DBI_WINDOW_REG_DATA_493_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_493_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_493_MASK) >> DBI_WINDOW_REG_DATA_493_LSB)
#define DBI_WINDOW_REG_DATA_493_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_493_LSB) & DBI_WINDOW_REG_DATA_493_MASK)
#define DBI_WINDOW_REG_DATA_493_RESET                                          0x0
#define DBI_WINDOW_REG_493_ADDRESS                                             (0x7b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_493_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_493_RESET                                               0x0

// 0x7b8 (DBI_WINDOW_REG_494)
#define DBI_WINDOW_REG_DATA_494_LSB                                            0
#define DBI_WINDOW_REG_DATA_494_MSB                                            31
#define DBI_WINDOW_REG_DATA_494_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_494_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_494_MASK) >> DBI_WINDOW_REG_DATA_494_LSB)
#define DBI_WINDOW_REG_DATA_494_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_494_LSB) & DBI_WINDOW_REG_DATA_494_MASK)
#define DBI_WINDOW_REG_DATA_494_RESET                                          0x0
#define DBI_WINDOW_REG_494_ADDRESS                                             (0x7b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_494_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_494_RESET                                               0x0

// 0x7bc (DBI_WINDOW_REG_495)
#define DBI_WINDOW_REG_DATA_495_LSB                                            0
#define DBI_WINDOW_REG_DATA_495_MSB                                            31
#define DBI_WINDOW_REG_DATA_495_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_495_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_495_MASK) >> DBI_WINDOW_REG_DATA_495_LSB)
#define DBI_WINDOW_REG_DATA_495_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_495_LSB) & DBI_WINDOW_REG_DATA_495_MASK)
#define DBI_WINDOW_REG_DATA_495_RESET                                          0x0
#define DBI_WINDOW_REG_495_ADDRESS                                             (0x7bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_495_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_495_RESET                                               0x0

// 0x7c0 (DBI_WINDOW_REG_496)
#define DBI_WINDOW_REG_DATA_496_LSB                                            0
#define DBI_WINDOW_REG_DATA_496_MSB                                            31
#define DBI_WINDOW_REG_DATA_496_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_496_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_496_MASK) >> DBI_WINDOW_REG_DATA_496_LSB)
#define DBI_WINDOW_REG_DATA_496_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_496_LSB) & DBI_WINDOW_REG_DATA_496_MASK)
#define DBI_WINDOW_REG_DATA_496_RESET                                          0x0
#define DBI_WINDOW_REG_496_ADDRESS                                             (0x7c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_496_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_496_RESET                                               0x0

// 0x7c4 (DBI_WINDOW_REG_497)
#define DBI_WINDOW_REG_DATA_497_LSB                                            0
#define DBI_WINDOW_REG_DATA_497_MSB                                            31
#define DBI_WINDOW_REG_DATA_497_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_497_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_497_MASK) >> DBI_WINDOW_REG_DATA_497_LSB)
#define DBI_WINDOW_REG_DATA_497_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_497_LSB) & DBI_WINDOW_REG_DATA_497_MASK)
#define DBI_WINDOW_REG_DATA_497_RESET                                          0x0
#define DBI_WINDOW_REG_497_ADDRESS                                             (0x7c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_497_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_497_RESET                                               0x0

// 0x7c8 (DBI_WINDOW_REG_498)
#define DBI_WINDOW_REG_DATA_498_LSB                                            0
#define DBI_WINDOW_REG_DATA_498_MSB                                            31
#define DBI_WINDOW_REG_DATA_498_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_498_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_498_MASK) >> DBI_WINDOW_REG_DATA_498_LSB)
#define DBI_WINDOW_REG_DATA_498_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_498_LSB) & DBI_WINDOW_REG_DATA_498_MASK)
#define DBI_WINDOW_REG_DATA_498_RESET                                          0x0
#define DBI_WINDOW_REG_498_ADDRESS                                             (0x7c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_498_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_498_RESET                                               0x0

// 0x7cc (DBI_WINDOW_REG_499)
#define DBI_WINDOW_REG_DATA_499_LSB                                            0
#define DBI_WINDOW_REG_DATA_499_MSB                                            31
#define DBI_WINDOW_REG_DATA_499_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_499_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_499_MASK) >> DBI_WINDOW_REG_DATA_499_LSB)
#define DBI_WINDOW_REG_DATA_499_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_499_LSB) & DBI_WINDOW_REG_DATA_499_MASK)
#define DBI_WINDOW_REG_DATA_499_RESET                                          0x0
#define DBI_WINDOW_REG_499_ADDRESS                                             (0x7cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_499_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_499_RESET                                               0x0

// 0x7d0 (DBI_WINDOW_REG_500)
#define DBI_WINDOW_REG_DATA_500_LSB                                            0
#define DBI_WINDOW_REG_DATA_500_MSB                                            31
#define DBI_WINDOW_REG_DATA_500_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_500_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_500_MASK) >> DBI_WINDOW_REG_DATA_500_LSB)
#define DBI_WINDOW_REG_DATA_500_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_500_LSB) & DBI_WINDOW_REG_DATA_500_MASK)
#define DBI_WINDOW_REG_DATA_500_RESET                                          0x0
#define DBI_WINDOW_REG_500_ADDRESS                                             (0x7d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_500_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_500_RESET                                               0x0

// 0x7d4 (DBI_WINDOW_REG_501)
#define DBI_WINDOW_REG_DATA_501_LSB                                            0
#define DBI_WINDOW_REG_DATA_501_MSB                                            31
#define DBI_WINDOW_REG_DATA_501_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_501_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_501_MASK) >> DBI_WINDOW_REG_DATA_501_LSB)
#define DBI_WINDOW_REG_DATA_501_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_501_LSB) & DBI_WINDOW_REG_DATA_501_MASK)
#define DBI_WINDOW_REG_DATA_501_RESET                                          0x0
#define DBI_WINDOW_REG_501_ADDRESS                                             (0x7d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_501_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_501_RESET                                               0x0

// 0x7d8 (DBI_WINDOW_REG_502)
#define DBI_WINDOW_REG_DATA_502_LSB                                            0
#define DBI_WINDOW_REG_DATA_502_MSB                                            31
#define DBI_WINDOW_REG_DATA_502_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_502_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_502_MASK) >> DBI_WINDOW_REG_DATA_502_LSB)
#define DBI_WINDOW_REG_DATA_502_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_502_LSB) & DBI_WINDOW_REG_DATA_502_MASK)
#define DBI_WINDOW_REG_DATA_502_RESET                                          0x0
#define DBI_WINDOW_REG_502_ADDRESS                                             (0x7d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_502_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_502_RESET                                               0x0

// 0x7dc (DBI_WINDOW_REG_503)
#define DBI_WINDOW_REG_DATA_503_LSB                                            0
#define DBI_WINDOW_REG_DATA_503_MSB                                            31
#define DBI_WINDOW_REG_DATA_503_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_503_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_503_MASK) >> DBI_WINDOW_REG_DATA_503_LSB)
#define DBI_WINDOW_REG_DATA_503_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_503_LSB) & DBI_WINDOW_REG_DATA_503_MASK)
#define DBI_WINDOW_REG_DATA_503_RESET                                          0x0
#define DBI_WINDOW_REG_503_ADDRESS                                             (0x7dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_503_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_503_RESET                                               0x0

// 0x7e0 (DBI_WINDOW_REG_504)
#define DBI_WINDOW_REG_DATA_504_LSB                                            0
#define DBI_WINDOW_REG_DATA_504_MSB                                            31
#define DBI_WINDOW_REG_DATA_504_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_504_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_504_MASK) >> DBI_WINDOW_REG_DATA_504_LSB)
#define DBI_WINDOW_REG_DATA_504_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_504_LSB) & DBI_WINDOW_REG_DATA_504_MASK)
#define DBI_WINDOW_REG_DATA_504_RESET                                          0x0
#define DBI_WINDOW_REG_504_ADDRESS                                             (0x7e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_504_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_504_RESET                                               0x0

// 0x7e4 (DBI_WINDOW_REG_505)
#define DBI_WINDOW_REG_DATA_505_LSB                                            0
#define DBI_WINDOW_REG_DATA_505_MSB                                            31
#define DBI_WINDOW_REG_DATA_505_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_505_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_505_MASK) >> DBI_WINDOW_REG_DATA_505_LSB)
#define DBI_WINDOW_REG_DATA_505_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_505_LSB) & DBI_WINDOW_REG_DATA_505_MASK)
#define DBI_WINDOW_REG_DATA_505_RESET                                          0x0
#define DBI_WINDOW_REG_505_ADDRESS                                             (0x7e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_505_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_505_RESET                                               0x0

// 0x7e8 (DBI_WINDOW_REG_506)
#define DBI_WINDOW_REG_DATA_506_LSB                                            0
#define DBI_WINDOW_REG_DATA_506_MSB                                            31
#define DBI_WINDOW_REG_DATA_506_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_506_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_506_MASK) >> DBI_WINDOW_REG_DATA_506_LSB)
#define DBI_WINDOW_REG_DATA_506_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_506_LSB) & DBI_WINDOW_REG_DATA_506_MASK)
#define DBI_WINDOW_REG_DATA_506_RESET                                          0x0
#define DBI_WINDOW_REG_506_ADDRESS                                             (0x7e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_506_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_506_RESET                                               0x0

// 0x7ec (DBI_WINDOW_REG_507)
#define DBI_WINDOW_REG_DATA_507_LSB                                            0
#define DBI_WINDOW_REG_DATA_507_MSB                                            31
#define DBI_WINDOW_REG_DATA_507_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_507_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_507_MASK) >> DBI_WINDOW_REG_DATA_507_LSB)
#define DBI_WINDOW_REG_DATA_507_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_507_LSB) & DBI_WINDOW_REG_DATA_507_MASK)
#define DBI_WINDOW_REG_DATA_507_RESET                                          0x0
#define DBI_WINDOW_REG_507_ADDRESS                                             (0x7ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_507_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_507_RESET                                               0x0

// 0x7f0 (DBI_WINDOW_REG_508)
#define DBI_WINDOW_REG_DATA_508_LSB                                            0
#define DBI_WINDOW_REG_DATA_508_MSB                                            31
#define DBI_WINDOW_REG_DATA_508_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_508_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_508_MASK) >> DBI_WINDOW_REG_DATA_508_LSB)
#define DBI_WINDOW_REG_DATA_508_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_508_LSB) & DBI_WINDOW_REG_DATA_508_MASK)
#define DBI_WINDOW_REG_DATA_508_RESET                                          0x0
#define DBI_WINDOW_REG_508_ADDRESS                                             (0x7f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_508_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_508_RESET                                               0x0

// 0x7f4 (DBI_WINDOW_REG_509)
#define DBI_WINDOW_REG_DATA_509_LSB                                            0
#define DBI_WINDOW_REG_DATA_509_MSB                                            31
#define DBI_WINDOW_REG_DATA_509_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_509_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_509_MASK) >> DBI_WINDOW_REG_DATA_509_LSB)
#define DBI_WINDOW_REG_DATA_509_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_509_LSB) & DBI_WINDOW_REG_DATA_509_MASK)
#define DBI_WINDOW_REG_DATA_509_RESET                                          0x0
#define DBI_WINDOW_REG_509_ADDRESS                                             (0x7f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_509_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_509_RESET                                               0x0

// 0x7f8 (DBI_WINDOW_REG_510)
#define DBI_WINDOW_REG_DATA_510_LSB                                            0
#define DBI_WINDOW_REG_DATA_510_MSB                                            31
#define DBI_WINDOW_REG_DATA_510_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_510_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_510_MASK) >> DBI_WINDOW_REG_DATA_510_LSB)
#define DBI_WINDOW_REG_DATA_510_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_510_LSB) & DBI_WINDOW_REG_DATA_510_MASK)
#define DBI_WINDOW_REG_DATA_510_RESET                                          0x0
#define DBI_WINDOW_REG_510_ADDRESS                                             (0x7f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_510_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_510_RESET                                               0x0

// 0x7fc (DBI_WINDOW_REG_511)
#define DBI_WINDOW_REG_DATA_511_LSB                                            0
#define DBI_WINDOW_REG_DATA_511_MSB                                            31
#define DBI_WINDOW_REG_DATA_511_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_511_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_511_MASK) >> DBI_WINDOW_REG_DATA_511_LSB)
#define DBI_WINDOW_REG_DATA_511_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_511_LSB) & DBI_WINDOW_REG_DATA_511_MASK)
#define DBI_WINDOW_REG_DATA_511_RESET                                          0x0
#define DBI_WINDOW_REG_511_ADDRESS                                             (0x7fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_511_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_511_RESET                                               0x0

// 0x800 (DBI_WINDOW_REG_512)
#define DBI_WINDOW_REG_DATA_512_LSB                                            0
#define DBI_WINDOW_REG_DATA_512_MSB                                            31
#define DBI_WINDOW_REG_DATA_512_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_512_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_512_MASK) >> DBI_WINDOW_REG_DATA_512_LSB)
#define DBI_WINDOW_REG_DATA_512_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_512_LSB) & DBI_WINDOW_REG_DATA_512_MASK)
#define DBI_WINDOW_REG_DATA_512_RESET                                          0x0
#define DBI_WINDOW_REG_512_ADDRESS                                             (0x800 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_512_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_512_RESET                                               0x0

// 0x804 (DBI_WINDOW_REG_513)
#define DBI_WINDOW_REG_DATA_513_LSB                                            0
#define DBI_WINDOW_REG_DATA_513_MSB                                            31
#define DBI_WINDOW_REG_DATA_513_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_513_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_513_MASK) >> DBI_WINDOW_REG_DATA_513_LSB)
#define DBI_WINDOW_REG_DATA_513_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_513_LSB) & DBI_WINDOW_REG_DATA_513_MASK)
#define DBI_WINDOW_REG_DATA_513_RESET                                          0x0
#define DBI_WINDOW_REG_513_ADDRESS                                             (0x804 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_513_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_513_RESET                                               0x0

// 0x808 (DBI_WINDOW_REG_514)
#define DBI_WINDOW_REG_DATA_514_LSB                                            0
#define DBI_WINDOW_REG_DATA_514_MSB                                            31
#define DBI_WINDOW_REG_DATA_514_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_514_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_514_MASK) >> DBI_WINDOW_REG_DATA_514_LSB)
#define DBI_WINDOW_REG_DATA_514_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_514_LSB) & DBI_WINDOW_REG_DATA_514_MASK)
#define DBI_WINDOW_REG_DATA_514_RESET                                          0x0
#define DBI_WINDOW_REG_514_ADDRESS                                             (0x808 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_514_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_514_RESET                                               0x0

// 0x80c (DBI_WINDOW_REG_515)
#define DBI_WINDOW_REG_DATA_515_LSB                                            0
#define DBI_WINDOW_REG_DATA_515_MSB                                            31
#define DBI_WINDOW_REG_DATA_515_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_515_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_515_MASK) >> DBI_WINDOW_REG_DATA_515_LSB)
#define DBI_WINDOW_REG_DATA_515_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_515_LSB) & DBI_WINDOW_REG_DATA_515_MASK)
#define DBI_WINDOW_REG_DATA_515_RESET                                          0x0
#define DBI_WINDOW_REG_515_ADDRESS                                             (0x80c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_515_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_515_RESET                                               0x0

// 0x810 (DBI_WINDOW_REG_516)
#define DBI_WINDOW_REG_DATA_516_LSB                                            0
#define DBI_WINDOW_REG_DATA_516_MSB                                            31
#define DBI_WINDOW_REG_DATA_516_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_516_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_516_MASK) >> DBI_WINDOW_REG_DATA_516_LSB)
#define DBI_WINDOW_REG_DATA_516_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_516_LSB) & DBI_WINDOW_REG_DATA_516_MASK)
#define DBI_WINDOW_REG_DATA_516_RESET                                          0x0
#define DBI_WINDOW_REG_516_ADDRESS                                             (0x810 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_516_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_516_RESET                                               0x0

// 0x814 (DBI_WINDOW_REG_517)
#define DBI_WINDOW_REG_DATA_517_LSB                                            0
#define DBI_WINDOW_REG_DATA_517_MSB                                            31
#define DBI_WINDOW_REG_DATA_517_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_517_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_517_MASK) >> DBI_WINDOW_REG_DATA_517_LSB)
#define DBI_WINDOW_REG_DATA_517_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_517_LSB) & DBI_WINDOW_REG_DATA_517_MASK)
#define DBI_WINDOW_REG_DATA_517_RESET                                          0x0
#define DBI_WINDOW_REG_517_ADDRESS                                             (0x814 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_517_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_517_RESET                                               0x0

// 0x818 (DBI_WINDOW_REG_518)
#define DBI_WINDOW_REG_DATA_518_LSB                                            0
#define DBI_WINDOW_REG_DATA_518_MSB                                            31
#define DBI_WINDOW_REG_DATA_518_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_518_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_518_MASK) >> DBI_WINDOW_REG_DATA_518_LSB)
#define DBI_WINDOW_REG_DATA_518_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_518_LSB) & DBI_WINDOW_REG_DATA_518_MASK)
#define DBI_WINDOW_REG_DATA_518_RESET                                          0x0
#define DBI_WINDOW_REG_518_ADDRESS                                             (0x818 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_518_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_518_RESET                                               0x0

// 0x81c (DBI_WINDOW_REG_519)
#define DBI_WINDOW_REG_DATA_519_LSB                                            0
#define DBI_WINDOW_REG_DATA_519_MSB                                            31
#define DBI_WINDOW_REG_DATA_519_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_519_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_519_MASK) >> DBI_WINDOW_REG_DATA_519_LSB)
#define DBI_WINDOW_REG_DATA_519_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_519_LSB) & DBI_WINDOW_REG_DATA_519_MASK)
#define DBI_WINDOW_REG_DATA_519_RESET                                          0x0
#define DBI_WINDOW_REG_519_ADDRESS                                             (0x81c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_519_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_519_RESET                                               0x0

// 0x820 (DBI_WINDOW_REG_520)
#define DBI_WINDOW_REG_DATA_520_LSB                                            0
#define DBI_WINDOW_REG_DATA_520_MSB                                            31
#define DBI_WINDOW_REG_DATA_520_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_520_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_520_MASK) >> DBI_WINDOW_REG_DATA_520_LSB)
#define DBI_WINDOW_REG_DATA_520_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_520_LSB) & DBI_WINDOW_REG_DATA_520_MASK)
#define DBI_WINDOW_REG_DATA_520_RESET                                          0x0
#define DBI_WINDOW_REG_520_ADDRESS                                             (0x820 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_520_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_520_RESET                                               0x0

// 0x824 (DBI_WINDOW_REG_521)
#define DBI_WINDOW_REG_DATA_521_LSB                                            0
#define DBI_WINDOW_REG_DATA_521_MSB                                            31
#define DBI_WINDOW_REG_DATA_521_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_521_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_521_MASK) >> DBI_WINDOW_REG_DATA_521_LSB)
#define DBI_WINDOW_REG_DATA_521_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_521_LSB) & DBI_WINDOW_REG_DATA_521_MASK)
#define DBI_WINDOW_REG_DATA_521_RESET                                          0x0
#define DBI_WINDOW_REG_521_ADDRESS                                             (0x824 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_521_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_521_RESET                                               0x0

// 0x828 (DBI_WINDOW_REG_522)
#define DBI_WINDOW_REG_DATA_522_LSB                                            0
#define DBI_WINDOW_REG_DATA_522_MSB                                            31
#define DBI_WINDOW_REG_DATA_522_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_522_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_522_MASK) >> DBI_WINDOW_REG_DATA_522_LSB)
#define DBI_WINDOW_REG_DATA_522_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_522_LSB) & DBI_WINDOW_REG_DATA_522_MASK)
#define DBI_WINDOW_REG_DATA_522_RESET                                          0x0
#define DBI_WINDOW_REG_522_ADDRESS                                             (0x828 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_522_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_522_RESET                                               0x0

// 0x82c (DBI_WINDOW_REG_523)
#define DBI_WINDOW_REG_DATA_523_LSB                                            0
#define DBI_WINDOW_REG_DATA_523_MSB                                            31
#define DBI_WINDOW_REG_DATA_523_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_523_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_523_MASK) >> DBI_WINDOW_REG_DATA_523_LSB)
#define DBI_WINDOW_REG_DATA_523_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_523_LSB) & DBI_WINDOW_REG_DATA_523_MASK)
#define DBI_WINDOW_REG_DATA_523_RESET                                          0x0
#define DBI_WINDOW_REG_523_ADDRESS                                             (0x82c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_523_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_523_RESET                                               0x0

// 0x830 (DBI_WINDOW_REG_524)
#define DBI_WINDOW_REG_DATA_524_LSB                                            0
#define DBI_WINDOW_REG_DATA_524_MSB                                            31
#define DBI_WINDOW_REG_DATA_524_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_524_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_524_MASK) >> DBI_WINDOW_REG_DATA_524_LSB)
#define DBI_WINDOW_REG_DATA_524_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_524_LSB) & DBI_WINDOW_REG_DATA_524_MASK)
#define DBI_WINDOW_REG_DATA_524_RESET                                          0x0
#define DBI_WINDOW_REG_524_ADDRESS                                             (0x830 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_524_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_524_RESET                                               0x0

// 0x834 (DBI_WINDOW_REG_525)
#define DBI_WINDOW_REG_DATA_525_LSB                                            0
#define DBI_WINDOW_REG_DATA_525_MSB                                            31
#define DBI_WINDOW_REG_DATA_525_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_525_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_525_MASK) >> DBI_WINDOW_REG_DATA_525_LSB)
#define DBI_WINDOW_REG_DATA_525_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_525_LSB) & DBI_WINDOW_REG_DATA_525_MASK)
#define DBI_WINDOW_REG_DATA_525_RESET                                          0x0
#define DBI_WINDOW_REG_525_ADDRESS                                             (0x834 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_525_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_525_RESET                                               0x0

// 0x838 (DBI_WINDOW_REG_526)
#define DBI_WINDOW_REG_DATA_526_LSB                                            0
#define DBI_WINDOW_REG_DATA_526_MSB                                            31
#define DBI_WINDOW_REG_DATA_526_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_526_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_526_MASK) >> DBI_WINDOW_REG_DATA_526_LSB)
#define DBI_WINDOW_REG_DATA_526_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_526_LSB) & DBI_WINDOW_REG_DATA_526_MASK)
#define DBI_WINDOW_REG_DATA_526_RESET                                          0x0
#define DBI_WINDOW_REG_526_ADDRESS                                             (0x838 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_526_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_526_RESET                                               0x0

// 0x83c (DBI_WINDOW_REG_527)
#define DBI_WINDOW_REG_DATA_527_LSB                                            0
#define DBI_WINDOW_REG_DATA_527_MSB                                            31
#define DBI_WINDOW_REG_DATA_527_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_527_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_527_MASK) >> DBI_WINDOW_REG_DATA_527_LSB)
#define DBI_WINDOW_REG_DATA_527_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_527_LSB) & DBI_WINDOW_REG_DATA_527_MASK)
#define DBI_WINDOW_REG_DATA_527_RESET                                          0x0
#define DBI_WINDOW_REG_527_ADDRESS                                             (0x83c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_527_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_527_RESET                                               0x0

// 0x840 (DBI_WINDOW_REG_528)
#define DBI_WINDOW_REG_DATA_528_LSB                                            0
#define DBI_WINDOW_REG_DATA_528_MSB                                            31
#define DBI_WINDOW_REG_DATA_528_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_528_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_528_MASK) >> DBI_WINDOW_REG_DATA_528_LSB)
#define DBI_WINDOW_REG_DATA_528_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_528_LSB) & DBI_WINDOW_REG_DATA_528_MASK)
#define DBI_WINDOW_REG_DATA_528_RESET                                          0x0
#define DBI_WINDOW_REG_528_ADDRESS                                             (0x840 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_528_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_528_RESET                                               0x0

// 0x844 (DBI_WINDOW_REG_529)
#define DBI_WINDOW_REG_DATA_529_LSB                                            0
#define DBI_WINDOW_REG_DATA_529_MSB                                            31
#define DBI_WINDOW_REG_DATA_529_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_529_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_529_MASK) >> DBI_WINDOW_REG_DATA_529_LSB)
#define DBI_WINDOW_REG_DATA_529_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_529_LSB) & DBI_WINDOW_REG_DATA_529_MASK)
#define DBI_WINDOW_REG_DATA_529_RESET                                          0x0
#define DBI_WINDOW_REG_529_ADDRESS                                             (0x844 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_529_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_529_RESET                                               0x0

// 0x848 (DBI_WINDOW_REG_530)
#define DBI_WINDOW_REG_DATA_530_LSB                                            0
#define DBI_WINDOW_REG_DATA_530_MSB                                            31
#define DBI_WINDOW_REG_DATA_530_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_530_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_530_MASK) >> DBI_WINDOW_REG_DATA_530_LSB)
#define DBI_WINDOW_REG_DATA_530_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_530_LSB) & DBI_WINDOW_REG_DATA_530_MASK)
#define DBI_WINDOW_REG_DATA_530_RESET                                          0x0
#define DBI_WINDOW_REG_530_ADDRESS                                             (0x848 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_530_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_530_RESET                                               0x0

// 0x84c (DBI_WINDOW_REG_531)
#define DBI_WINDOW_REG_DATA_531_LSB                                            0
#define DBI_WINDOW_REG_DATA_531_MSB                                            31
#define DBI_WINDOW_REG_DATA_531_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_531_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_531_MASK) >> DBI_WINDOW_REG_DATA_531_LSB)
#define DBI_WINDOW_REG_DATA_531_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_531_LSB) & DBI_WINDOW_REG_DATA_531_MASK)
#define DBI_WINDOW_REG_DATA_531_RESET                                          0x0
#define DBI_WINDOW_REG_531_ADDRESS                                             (0x84c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_531_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_531_RESET                                               0x0

// 0x850 (DBI_WINDOW_REG_532)
#define DBI_WINDOW_REG_DATA_532_LSB                                            0
#define DBI_WINDOW_REG_DATA_532_MSB                                            31
#define DBI_WINDOW_REG_DATA_532_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_532_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_532_MASK) >> DBI_WINDOW_REG_DATA_532_LSB)
#define DBI_WINDOW_REG_DATA_532_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_532_LSB) & DBI_WINDOW_REG_DATA_532_MASK)
#define DBI_WINDOW_REG_DATA_532_RESET                                          0x0
#define DBI_WINDOW_REG_532_ADDRESS                                             (0x850 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_532_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_532_RESET                                               0x0

// 0x854 (DBI_WINDOW_REG_533)
#define DBI_WINDOW_REG_DATA_533_LSB                                            0
#define DBI_WINDOW_REG_DATA_533_MSB                                            31
#define DBI_WINDOW_REG_DATA_533_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_533_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_533_MASK) >> DBI_WINDOW_REG_DATA_533_LSB)
#define DBI_WINDOW_REG_DATA_533_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_533_LSB) & DBI_WINDOW_REG_DATA_533_MASK)
#define DBI_WINDOW_REG_DATA_533_RESET                                          0x0
#define DBI_WINDOW_REG_533_ADDRESS                                             (0x854 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_533_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_533_RESET                                               0x0

// 0x858 (DBI_WINDOW_REG_534)
#define DBI_WINDOW_REG_DATA_534_LSB                                            0
#define DBI_WINDOW_REG_DATA_534_MSB                                            31
#define DBI_WINDOW_REG_DATA_534_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_534_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_534_MASK) >> DBI_WINDOW_REG_DATA_534_LSB)
#define DBI_WINDOW_REG_DATA_534_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_534_LSB) & DBI_WINDOW_REG_DATA_534_MASK)
#define DBI_WINDOW_REG_DATA_534_RESET                                          0x0
#define DBI_WINDOW_REG_534_ADDRESS                                             (0x858 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_534_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_534_RESET                                               0x0

// 0x85c (DBI_WINDOW_REG_535)
#define DBI_WINDOW_REG_DATA_535_LSB                                            0
#define DBI_WINDOW_REG_DATA_535_MSB                                            31
#define DBI_WINDOW_REG_DATA_535_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_535_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_535_MASK) >> DBI_WINDOW_REG_DATA_535_LSB)
#define DBI_WINDOW_REG_DATA_535_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_535_LSB) & DBI_WINDOW_REG_DATA_535_MASK)
#define DBI_WINDOW_REG_DATA_535_RESET                                          0x0
#define DBI_WINDOW_REG_535_ADDRESS                                             (0x85c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_535_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_535_RESET                                               0x0

// 0x860 (DBI_WINDOW_REG_536)
#define DBI_WINDOW_REG_DATA_536_LSB                                            0
#define DBI_WINDOW_REG_DATA_536_MSB                                            31
#define DBI_WINDOW_REG_DATA_536_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_536_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_536_MASK) >> DBI_WINDOW_REG_DATA_536_LSB)
#define DBI_WINDOW_REG_DATA_536_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_536_LSB) & DBI_WINDOW_REG_DATA_536_MASK)
#define DBI_WINDOW_REG_DATA_536_RESET                                          0x0
#define DBI_WINDOW_REG_536_ADDRESS                                             (0x860 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_536_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_536_RESET                                               0x0

// 0x864 (DBI_WINDOW_REG_537)
#define DBI_WINDOW_REG_DATA_537_LSB                                            0
#define DBI_WINDOW_REG_DATA_537_MSB                                            31
#define DBI_WINDOW_REG_DATA_537_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_537_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_537_MASK) >> DBI_WINDOW_REG_DATA_537_LSB)
#define DBI_WINDOW_REG_DATA_537_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_537_LSB) & DBI_WINDOW_REG_DATA_537_MASK)
#define DBI_WINDOW_REG_DATA_537_RESET                                          0x0
#define DBI_WINDOW_REG_537_ADDRESS                                             (0x864 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_537_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_537_RESET                                               0x0

// 0x868 (DBI_WINDOW_REG_538)
#define DBI_WINDOW_REG_DATA_538_LSB                                            0
#define DBI_WINDOW_REG_DATA_538_MSB                                            31
#define DBI_WINDOW_REG_DATA_538_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_538_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_538_MASK) >> DBI_WINDOW_REG_DATA_538_LSB)
#define DBI_WINDOW_REG_DATA_538_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_538_LSB) & DBI_WINDOW_REG_DATA_538_MASK)
#define DBI_WINDOW_REG_DATA_538_RESET                                          0x0
#define DBI_WINDOW_REG_538_ADDRESS                                             (0x868 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_538_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_538_RESET                                               0x0

// 0x86c (DBI_WINDOW_REG_539)
#define DBI_WINDOW_REG_DATA_539_LSB                                            0
#define DBI_WINDOW_REG_DATA_539_MSB                                            31
#define DBI_WINDOW_REG_DATA_539_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_539_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_539_MASK) >> DBI_WINDOW_REG_DATA_539_LSB)
#define DBI_WINDOW_REG_DATA_539_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_539_LSB) & DBI_WINDOW_REG_DATA_539_MASK)
#define DBI_WINDOW_REG_DATA_539_RESET                                          0x0
#define DBI_WINDOW_REG_539_ADDRESS                                             (0x86c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_539_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_539_RESET                                               0x0

// 0x870 (DBI_WINDOW_REG_540)
#define DBI_WINDOW_REG_DATA_540_LSB                                            0
#define DBI_WINDOW_REG_DATA_540_MSB                                            31
#define DBI_WINDOW_REG_DATA_540_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_540_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_540_MASK) >> DBI_WINDOW_REG_DATA_540_LSB)
#define DBI_WINDOW_REG_DATA_540_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_540_LSB) & DBI_WINDOW_REG_DATA_540_MASK)
#define DBI_WINDOW_REG_DATA_540_RESET                                          0x0
#define DBI_WINDOW_REG_540_ADDRESS                                             (0x870 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_540_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_540_RESET                                               0x0

// 0x874 (DBI_WINDOW_REG_541)
#define DBI_WINDOW_REG_DATA_541_LSB                                            0
#define DBI_WINDOW_REG_DATA_541_MSB                                            31
#define DBI_WINDOW_REG_DATA_541_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_541_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_541_MASK) >> DBI_WINDOW_REG_DATA_541_LSB)
#define DBI_WINDOW_REG_DATA_541_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_541_LSB) & DBI_WINDOW_REG_DATA_541_MASK)
#define DBI_WINDOW_REG_DATA_541_RESET                                          0x0
#define DBI_WINDOW_REG_541_ADDRESS                                             (0x874 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_541_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_541_RESET                                               0x0

// 0x878 (DBI_WINDOW_REG_542)
#define DBI_WINDOW_REG_DATA_542_LSB                                            0
#define DBI_WINDOW_REG_DATA_542_MSB                                            31
#define DBI_WINDOW_REG_DATA_542_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_542_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_542_MASK) >> DBI_WINDOW_REG_DATA_542_LSB)
#define DBI_WINDOW_REG_DATA_542_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_542_LSB) & DBI_WINDOW_REG_DATA_542_MASK)
#define DBI_WINDOW_REG_DATA_542_RESET                                          0x0
#define DBI_WINDOW_REG_542_ADDRESS                                             (0x878 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_542_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_542_RESET                                               0x0

// 0x87c (DBI_WINDOW_REG_543)
#define DBI_WINDOW_REG_DATA_543_LSB                                            0
#define DBI_WINDOW_REG_DATA_543_MSB                                            31
#define DBI_WINDOW_REG_DATA_543_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_543_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_543_MASK) >> DBI_WINDOW_REG_DATA_543_LSB)
#define DBI_WINDOW_REG_DATA_543_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_543_LSB) & DBI_WINDOW_REG_DATA_543_MASK)
#define DBI_WINDOW_REG_DATA_543_RESET                                          0x0
#define DBI_WINDOW_REG_543_ADDRESS                                             (0x87c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_543_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_543_RESET                                               0x0

// 0x880 (DBI_WINDOW_REG_544)
#define DBI_WINDOW_REG_DATA_544_LSB                                            0
#define DBI_WINDOW_REG_DATA_544_MSB                                            31
#define DBI_WINDOW_REG_DATA_544_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_544_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_544_MASK) >> DBI_WINDOW_REG_DATA_544_LSB)
#define DBI_WINDOW_REG_DATA_544_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_544_LSB) & DBI_WINDOW_REG_DATA_544_MASK)
#define DBI_WINDOW_REG_DATA_544_RESET                                          0x0
#define DBI_WINDOW_REG_544_ADDRESS                                             (0x880 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_544_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_544_RESET                                               0x0

// 0x884 (DBI_WINDOW_REG_545)
#define DBI_WINDOW_REG_DATA_545_LSB                                            0
#define DBI_WINDOW_REG_DATA_545_MSB                                            31
#define DBI_WINDOW_REG_DATA_545_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_545_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_545_MASK) >> DBI_WINDOW_REG_DATA_545_LSB)
#define DBI_WINDOW_REG_DATA_545_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_545_LSB) & DBI_WINDOW_REG_DATA_545_MASK)
#define DBI_WINDOW_REG_DATA_545_RESET                                          0x0
#define DBI_WINDOW_REG_545_ADDRESS                                             (0x884 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_545_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_545_RESET                                               0x0

// 0x888 (DBI_WINDOW_REG_546)
#define DBI_WINDOW_REG_DATA_546_LSB                                            0
#define DBI_WINDOW_REG_DATA_546_MSB                                            31
#define DBI_WINDOW_REG_DATA_546_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_546_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_546_MASK) >> DBI_WINDOW_REG_DATA_546_LSB)
#define DBI_WINDOW_REG_DATA_546_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_546_LSB) & DBI_WINDOW_REG_DATA_546_MASK)
#define DBI_WINDOW_REG_DATA_546_RESET                                          0x0
#define DBI_WINDOW_REG_546_ADDRESS                                             (0x888 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_546_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_546_RESET                                               0x0

// 0x88c (DBI_WINDOW_REG_547)
#define DBI_WINDOW_REG_DATA_547_LSB                                            0
#define DBI_WINDOW_REG_DATA_547_MSB                                            31
#define DBI_WINDOW_REG_DATA_547_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_547_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_547_MASK) >> DBI_WINDOW_REG_DATA_547_LSB)
#define DBI_WINDOW_REG_DATA_547_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_547_LSB) & DBI_WINDOW_REG_DATA_547_MASK)
#define DBI_WINDOW_REG_DATA_547_RESET                                          0x0
#define DBI_WINDOW_REG_547_ADDRESS                                             (0x88c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_547_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_547_RESET                                               0x0

// 0x890 (DBI_WINDOW_REG_548)
#define DBI_WINDOW_REG_DATA_548_LSB                                            0
#define DBI_WINDOW_REG_DATA_548_MSB                                            31
#define DBI_WINDOW_REG_DATA_548_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_548_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_548_MASK) >> DBI_WINDOW_REG_DATA_548_LSB)
#define DBI_WINDOW_REG_DATA_548_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_548_LSB) & DBI_WINDOW_REG_DATA_548_MASK)
#define DBI_WINDOW_REG_DATA_548_RESET                                          0x0
#define DBI_WINDOW_REG_548_ADDRESS                                             (0x890 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_548_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_548_RESET                                               0x0

// 0x894 (DBI_WINDOW_REG_549)
#define DBI_WINDOW_REG_DATA_549_LSB                                            0
#define DBI_WINDOW_REG_DATA_549_MSB                                            31
#define DBI_WINDOW_REG_DATA_549_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_549_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_549_MASK) >> DBI_WINDOW_REG_DATA_549_LSB)
#define DBI_WINDOW_REG_DATA_549_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_549_LSB) & DBI_WINDOW_REG_DATA_549_MASK)
#define DBI_WINDOW_REG_DATA_549_RESET                                          0x0
#define DBI_WINDOW_REG_549_ADDRESS                                             (0x894 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_549_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_549_RESET                                               0x0

// 0x898 (DBI_WINDOW_REG_550)
#define DBI_WINDOW_REG_DATA_550_LSB                                            0
#define DBI_WINDOW_REG_DATA_550_MSB                                            31
#define DBI_WINDOW_REG_DATA_550_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_550_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_550_MASK) >> DBI_WINDOW_REG_DATA_550_LSB)
#define DBI_WINDOW_REG_DATA_550_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_550_LSB) & DBI_WINDOW_REG_DATA_550_MASK)
#define DBI_WINDOW_REG_DATA_550_RESET                                          0x0
#define DBI_WINDOW_REG_550_ADDRESS                                             (0x898 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_550_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_550_RESET                                               0x0

// 0x89c (DBI_WINDOW_REG_551)
#define DBI_WINDOW_REG_DATA_551_LSB                                            0
#define DBI_WINDOW_REG_DATA_551_MSB                                            31
#define DBI_WINDOW_REG_DATA_551_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_551_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_551_MASK) >> DBI_WINDOW_REG_DATA_551_LSB)
#define DBI_WINDOW_REG_DATA_551_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_551_LSB) & DBI_WINDOW_REG_DATA_551_MASK)
#define DBI_WINDOW_REG_DATA_551_RESET                                          0x0
#define DBI_WINDOW_REG_551_ADDRESS                                             (0x89c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_551_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_551_RESET                                               0x0

// 0x8a0 (DBI_WINDOW_REG_552)
#define DBI_WINDOW_REG_DATA_552_LSB                                            0
#define DBI_WINDOW_REG_DATA_552_MSB                                            31
#define DBI_WINDOW_REG_DATA_552_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_552_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_552_MASK) >> DBI_WINDOW_REG_DATA_552_LSB)
#define DBI_WINDOW_REG_DATA_552_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_552_LSB) & DBI_WINDOW_REG_DATA_552_MASK)
#define DBI_WINDOW_REG_DATA_552_RESET                                          0x0
#define DBI_WINDOW_REG_552_ADDRESS                                             (0x8a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_552_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_552_RESET                                               0x0

// 0x8a4 (DBI_WINDOW_REG_553)
#define DBI_WINDOW_REG_DATA_553_LSB                                            0
#define DBI_WINDOW_REG_DATA_553_MSB                                            31
#define DBI_WINDOW_REG_DATA_553_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_553_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_553_MASK) >> DBI_WINDOW_REG_DATA_553_LSB)
#define DBI_WINDOW_REG_DATA_553_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_553_LSB) & DBI_WINDOW_REG_DATA_553_MASK)
#define DBI_WINDOW_REG_DATA_553_RESET                                          0x0
#define DBI_WINDOW_REG_553_ADDRESS                                             (0x8a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_553_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_553_RESET                                               0x0

// 0x8a8 (DBI_WINDOW_REG_554)
#define DBI_WINDOW_REG_DATA_554_LSB                                            0
#define DBI_WINDOW_REG_DATA_554_MSB                                            31
#define DBI_WINDOW_REG_DATA_554_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_554_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_554_MASK) >> DBI_WINDOW_REG_DATA_554_LSB)
#define DBI_WINDOW_REG_DATA_554_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_554_LSB) & DBI_WINDOW_REG_DATA_554_MASK)
#define DBI_WINDOW_REG_DATA_554_RESET                                          0x0
#define DBI_WINDOW_REG_554_ADDRESS                                             (0x8a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_554_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_554_RESET                                               0x0

// 0x8ac (DBI_WINDOW_REG_555)
#define DBI_WINDOW_REG_DATA_555_LSB                                            0
#define DBI_WINDOW_REG_DATA_555_MSB                                            31
#define DBI_WINDOW_REG_DATA_555_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_555_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_555_MASK) >> DBI_WINDOW_REG_DATA_555_LSB)
#define DBI_WINDOW_REG_DATA_555_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_555_LSB) & DBI_WINDOW_REG_DATA_555_MASK)
#define DBI_WINDOW_REG_DATA_555_RESET                                          0x0
#define DBI_WINDOW_REG_555_ADDRESS                                             (0x8ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_555_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_555_RESET                                               0x0

// 0x8b0 (DBI_WINDOW_REG_556)
#define DBI_WINDOW_REG_DATA_556_LSB                                            0
#define DBI_WINDOW_REG_DATA_556_MSB                                            31
#define DBI_WINDOW_REG_DATA_556_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_556_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_556_MASK) >> DBI_WINDOW_REG_DATA_556_LSB)
#define DBI_WINDOW_REG_DATA_556_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_556_LSB) & DBI_WINDOW_REG_DATA_556_MASK)
#define DBI_WINDOW_REG_DATA_556_RESET                                          0x0
#define DBI_WINDOW_REG_556_ADDRESS                                             (0x8b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_556_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_556_RESET                                               0x0

// 0x8b4 (DBI_WINDOW_REG_557)
#define DBI_WINDOW_REG_DATA_557_LSB                                            0
#define DBI_WINDOW_REG_DATA_557_MSB                                            31
#define DBI_WINDOW_REG_DATA_557_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_557_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_557_MASK) >> DBI_WINDOW_REG_DATA_557_LSB)
#define DBI_WINDOW_REG_DATA_557_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_557_LSB) & DBI_WINDOW_REG_DATA_557_MASK)
#define DBI_WINDOW_REG_DATA_557_RESET                                          0x0
#define DBI_WINDOW_REG_557_ADDRESS                                             (0x8b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_557_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_557_RESET                                               0x0

// 0x8b8 (DBI_WINDOW_REG_558)
#define DBI_WINDOW_REG_DATA_558_LSB                                            0
#define DBI_WINDOW_REG_DATA_558_MSB                                            31
#define DBI_WINDOW_REG_DATA_558_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_558_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_558_MASK) >> DBI_WINDOW_REG_DATA_558_LSB)
#define DBI_WINDOW_REG_DATA_558_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_558_LSB) & DBI_WINDOW_REG_DATA_558_MASK)
#define DBI_WINDOW_REG_DATA_558_RESET                                          0x0
#define DBI_WINDOW_REG_558_ADDRESS                                             (0x8b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_558_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_558_RESET                                               0x0

// 0x8bc (DBI_WINDOW_REG_559)
#define DBI_WINDOW_REG_DATA_559_LSB                                            0
#define DBI_WINDOW_REG_DATA_559_MSB                                            31
#define DBI_WINDOW_REG_DATA_559_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_559_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_559_MASK) >> DBI_WINDOW_REG_DATA_559_LSB)
#define DBI_WINDOW_REG_DATA_559_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_559_LSB) & DBI_WINDOW_REG_DATA_559_MASK)
#define DBI_WINDOW_REG_DATA_559_RESET                                          0x0
#define DBI_WINDOW_REG_559_ADDRESS                                             (0x8bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_559_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_559_RESET                                               0x0

// 0x8c0 (DBI_WINDOW_REG_560)
#define DBI_WINDOW_REG_DATA_560_LSB                                            0
#define DBI_WINDOW_REG_DATA_560_MSB                                            31
#define DBI_WINDOW_REG_DATA_560_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_560_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_560_MASK) >> DBI_WINDOW_REG_DATA_560_LSB)
#define DBI_WINDOW_REG_DATA_560_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_560_LSB) & DBI_WINDOW_REG_DATA_560_MASK)
#define DBI_WINDOW_REG_DATA_560_RESET                                          0x0
#define DBI_WINDOW_REG_560_ADDRESS                                             (0x8c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_560_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_560_RESET                                               0x0

// 0x8c4 (DBI_WINDOW_REG_561)
#define DBI_WINDOW_REG_DATA_561_LSB                                            0
#define DBI_WINDOW_REG_DATA_561_MSB                                            31
#define DBI_WINDOW_REG_DATA_561_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_561_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_561_MASK) >> DBI_WINDOW_REG_DATA_561_LSB)
#define DBI_WINDOW_REG_DATA_561_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_561_LSB) & DBI_WINDOW_REG_DATA_561_MASK)
#define DBI_WINDOW_REG_DATA_561_RESET                                          0x0
#define DBI_WINDOW_REG_561_ADDRESS                                             (0x8c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_561_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_561_RESET                                               0x0

// 0x8c8 (DBI_WINDOW_REG_562)
#define DBI_WINDOW_REG_DATA_562_LSB                                            0
#define DBI_WINDOW_REG_DATA_562_MSB                                            31
#define DBI_WINDOW_REG_DATA_562_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_562_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_562_MASK) >> DBI_WINDOW_REG_DATA_562_LSB)
#define DBI_WINDOW_REG_DATA_562_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_562_LSB) & DBI_WINDOW_REG_DATA_562_MASK)
#define DBI_WINDOW_REG_DATA_562_RESET                                          0x0
#define DBI_WINDOW_REG_562_ADDRESS                                             (0x8c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_562_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_562_RESET                                               0x0

// 0x8cc (DBI_WINDOW_REG_563)
#define DBI_WINDOW_REG_DATA_563_LSB                                            0
#define DBI_WINDOW_REG_DATA_563_MSB                                            31
#define DBI_WINDOW_REG_DATA_563_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_563_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_563_MASK) >> DBI_WINDOW_REG_DATA_563_LSB)
#define DBI_WINDOW_REG_DATA_563_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_563_LSB) & DBI_WINDOW_REG_DATA_563_MASK)
#define DBI_WINDOW_REG_DATA_563_RESET                                          0x0
#define DBI_WINDOW_REG_563_ADDRESS                                             (0x8cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_563_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_563_RESET                                               0x0

// 0x8d0 (DBI_WINDOW_REG_564)
#define DBI_WINDOW_REG_DATA_564_LSB                                            0
#define DBI_WINDOW_REG_DATA_564_MSB                                            31
#define DBI_WINDOW_REG_DATA_564_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_564_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_564_MASK) >> DBI_WINDOW_REG_DATA_564_LSB)
#define DBI_WINDOW_REG_DATA_564_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_564_LSB) & DBI_WINDOW_REG_DATA_564_MASK)
#define DBI_WINDOW_REG_DATA_564_RESET                                          0x0
#define DBI_WINDOW_REG_564_ADDRESS                                             (0x8d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_564_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_564_RESET                                               0x0

// 0x8d4 (DBI_WINDOW_REG_565)
#define DBI_WINDOW_REG_DATA_565_LSB                                            0
#define DBI_WINDOW_REG_DATA_565_MSB                                            31
#define DBI_WINDOW_REG_DATA_565_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_565_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_565_MASK) >> DBI_WINDOW_REG_DATA_565_LSB)
#define DBI_WINDOW_REG_DATA_565_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_565_LSB) & DBI_WINDOW_REG_DATA_565_MASK)
#define DBI_WINDOW_REG_DATA_565_RESET                                          0x0
#define DBI_WINDOW_REG_565_ADDRESS                                             (0x8d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_565_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_565_RESET                                               0x0

// 0x8d8 (DBI_WINDOW_REG_566)
#define DBI_WINDOW_REG_DATA_566_LSB                                            0
#define DBI_WINDOW_REG_DATA_566_MSB                                            31
#define DBI_WINDOW_REG_DATA_566_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_566_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_566_MASK) >> DBI_WINDOW_REG_DATA_566_LSB)
#define DBI_WINDOW_REG_DATA_566_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_566_LSB) & DBI_WINDOW_REG_DATA_566_MASK)
#define DBI_WINDOW_REG_DATA_566_RESET                                          0x0
#define DBI_WINDOW_REG_566_ADDRESS                                             (0x8d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_566_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_566_RESET                                               0x0

// 0x8dc (DBI_WINDOW_REG_567)
#define DBI_WINDOW_REG_DATA_567_LSB                                            0
#define DBI_WINDOW_REG_DATA_567_MSB                                            31
#define DBI_WINDOW_REG_DATA_567_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_567_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_567_MASK) >> DBI_WINDOW_REG_DATA_567_LSB)
#define DBI_WINDOW_REG_DATA_567_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_567_LSB) & DBI_WINDOW_REG_DATA_567_MASK)
#define DBI_WINDOW_REG_DATA_567_RESET                                          0x0
#define DBI_WINDOW_REG_567_ADDRESS                                             (0x8dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_567_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_567_RESET                                               0x0

// 0x8e0 (DBI_WINDOW_REG_568)
#define DBI_WINDOW_REG_DATA_568_LSB                                            0
#define DBI_WINDOW_REG_DATA_568_MSB                                            31
#define DBI_WINDOW_REG_DATA_568_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_568_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_568_MASK) >> DBI_WINDOW_REG_DATA_568_LSB)
#define DBI_WINDOW_REG_DATA_568_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_568_LSB) & DBI_WINDOW_REG_DATA_568_MASK)
#define DBI_WINDOW_REG_DATA_568_RESET                                          0x0
#define DBI_WINDOW_REG_568_ADDRESS                                             (0x8e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_568_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_568_RESET                                               0x0

// 0x8e4 (DBI_WINDOW_REG_569)
#define DBI_WINDOW_REG_DATA_569_LSB                                            0
#define DBI_WINDOW_REG_DATA_569_MSB                                            31
#define DBI_WINDOW_REG_DATA_569_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_569_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_569_MASK) >> DBI_WINDOW_REG_DATA_569_LSB)
#define DBI_WINDOW_REG_DATA_569_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_569_LSB) & DBI_WINDOW_REG_DATA_569_MASK)
#define DBI_WINDOW_REG_DATA_569_RESET                                          0x0
#define DBI_WINDOW_REG_569_ADDRESS                                             (0x8e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_569_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_569_RESET                                               0x0

// 0x8e8 (DBI_WINDOW_REG_570)
#define DBI_WINDOW_REG_DATA_570_LSB                                            0
#define DBI_WINDOW_REG_DATA_570_MSB                                            31
#define DBI_WINDOW_REG_DATA_570_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_570_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_570_MASK) >> DBI_WINDOW_REG_DATA_570_LSB)
#define DBI_WINDOW_REG_DATA_570_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_570_LSB) & DBI_WINDOW_REG_DATA_570_MASK)
#define DBI_WINDOW_REG_DATA_570_RESET                                          0x0
#define DBI_WINDOW_REG_570_ADDRESS                                             (0x8e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_570_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_570_RESET                                               0x0

// 0x8ec (DBI_WINDOW_REG_571)
#define DBI_WINDOW_REG_DATA_571_LSB                                            0
#define DBI_WINDOW_REG_DATA_571_MSB                                            31
#define DBI_WINDOW_REG_DATA_571_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_571_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_571_MASK) >> DBI_WINDOW_REG_DATA_571_LSB)
#define DBI_WINDOW_REG_DATA_571_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_571_LSB) & DBI_WINDOW_REG_DATA_571_MASK)
#define DBI_WINDOW_REG_DATA_571_RESET                                          0x0
#define DBI_WINDOW_REG_571_ADDRESS                                             (0x8ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_571_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_571_RESET                                               0x0

// 0x8f0 (DBI_WINDOW_REG_572)
#define DBI_WINDOW_REG_DATA_572_LSB                                            0
#define DBI_WINDOW_REG_DATA_572_MSB                                            31
#define DBI_WINDOW_REG_DATA_572_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_572_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_572_MASK) >> DBI_WINDOW_REG_DATA_572_LSB)
#define DBI_WINDOW_REG_DATA_572_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_572_LSB) & DBI_WINDOW_REG_DATA_572_MASK)
#define DBI_WINDOW_REG_DATA_572_RESET                                          0x0
#define DBI_WINDOW_REG_572_ADDRESS                                             (0x8f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_572_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_572_RESET                                               0x0

// 0x8f4 (DBI_WINDOW_REG_573)
#define DBI_WINDOW_REG_DATA_573_LSB                                            0
#define DBI_WINDOW_REG_DATA_573_MSB                                            31
#define DBI_WINDOW_REG_DATA_573_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_573_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_573_MASK) >> DBI_WINDOW_REG_DATA_573_LSB)
#define DBI_WINDOW_REG_DATA_573_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_573_LSB) & DBI_WINDOW_REG_DATA_573_MASK)
#define DBI_WINDOW_REG_DATA_573_RESET                                          0x0
#define DBI_WINDOW_REG_573_ADDRESS                                             (0x8f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_573_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_573_RESET                                               0x0

// 0x8f8 (DBI_WINDOW_REG_574)
#define DBI_WINDOW_REG_DATA_574_LSB                                            0
#define DBI_WINDOW_REG_DATA_574_MSB                                            31
#define DBI_WINDOW_REG_DATA_574_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_574_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_574_MASK) >> DBI_WINDOW_REG_DATA_574_LSB)
#define DBI_WINDOW_REG_DATA_574_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_574_LSB) & DBI_WINDOW_REG_DATA_574_MASK)
#define DBI_WINDOW_REG_DATA_574_RESET                                          0x0
#define DBI_WINDOW_REG_574_ADDRESS                                             (0x8f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_574_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_574_RESET                                               0x0

// 0x8fc (DBI_WINDOW_REG_575)
#define DBI_WINDOW_REG_DATA_575_LSB                                            0
#define DBI_WINDOW_REG_DATA_575_MSB                                            31
#define DBI_WINDOW_REG_DATA_575_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_575_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_575_MASK) >> DBI_WINDOW_REG_DATA_575_LSB)
#define DBI_WINDOW_REG_DATA_575_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_575_LSB) & DBI_WINDOW_REG_DATA_575_MASK)
#define DBI_WINDOW_REG_DATA_575_RESET                                          0x0
#define DBI_WINDOW_REG_575_ADDRESS                                             (0x8fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_575_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_575_RESET                                               0x0

// 0x900 (DBI_WINDOW_REG_576)
#define DBI_WINDOW_REG_DATA_576_LSB                                            0
#define DBI_WINDOW_REG_DATA_576_MSB                                            31
#define DBI_WINDOW_REG_DATA_576_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_576_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_576_MASK) >> DBI_WINDOW_REG_DATA_576_LSB)
#define DBI_WINDOW_REG_DATA_576_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_576_LSB) & DBI_WINDOW_REG_DATA_576_MASK)
#define DBI_WINDOW_REG_DATA_576_RESET                                          0x0
#define DBI_WINDOW_REG_576_ADDRESS                                             (0x900 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_576_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_576_RESET                                               0x0

// 0x904 (DBI_WINDOW_REG_577)
#define DBI_WINDOW_REG_DATA_577_LSB                                            0
#define DBI_WINDOW_REG_DATA_577_MSB                                            31
#define DBI_WINDOW_REG_DATA_577_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_577_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_577_MASK) >> DBI_WINDOW_REG_DATA_577_LSB)
#define DBI_WINDOW_REG_DATA_577_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_577_LSB) & DBI_WINDOW_REG_DATA_577_MASK)
#define DBI_WINDOW_REG_DATA_577_RESET                                          0x0
#define DBI_WINDOW_REG_577_ADDRESS                                             (0x904 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_577_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_577_RESET                                               0x0

// 0x908 (DBI_WINDOW_REG_578)
#define DBI_WINDOW_REG_DATA_578_LSB                                            0
#define DBI_WINDOW_REG_DATA_578_MSB                                            31
#define DBI_WINDOW_REG_DATA_578_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_578_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_578_MASK) >> DBI_WINDOW_REG_DATA_578_LSB)
#define DBI_WINDOW_REG_DATA_578_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_578_LSB) & DBI_WINDOW_REG_DATA_578_MASK)
#define DBI_WINDOW_REG_DATA_578_RESET                                          0x0
#define DBI_WINDOW_REG_578_ADDRESS                                             (0x908 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_578_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_578_RESET                                               0x0

// 0x90c (DBI_WINDOW_REG_579)
#define DBI_WINDOW_REG_DATA_579_LSB                                            0
#define DBI_WINDOW_REG_DATA_579_MSB                                            31
#define DBI_WINDOW_REG_DATA_579_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_579_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_579_MASK) >> DBI_WINDOW_REG_DATA_579_LSB)
#define DBI_WINDOW_REG_DATA_579_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_579_LSB) & DBI_WINDOW_REG_DATA_579_MASK)
#define DBI_WINDOW_REG_DATA_579_RESET                                          0x0
#define DBI_WINDOW_REG_579_ADDRESS                                             (0x90c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_579_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_579_RESET                                               0x0

// 0x910 (DBI_WINDOW_REG_580)
#define DBI_WINDOW_REG_DATA_580_LSB                                            0
#define DBI_WINDOW_REG_DATA_580_MSB                                            31
#define DBI_WINDOW_REG_DATA_580_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_580_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_580_MASK) >> DBI_WINDOW_REG_DATA_580_LSB)
#define DBI_WINDOW_REG_DATA_580_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_580_LSB) & DBI_WINDOW_REG_DATA_580_MASK)
#define DBI_WINDOW_REG_DATA_580_RESET                                          0x0
#define DBI_WINDOW_REG_580_ADDRESS                                             (0x910 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_580_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_580_RESET                                               0x0

// 0x914 (DBI_WINDOW_REG_581)
#define DBI_WINDOW_REG_DATA_581_LSB                                            0
#define DBI_WINDOW_REG_DATA_581_MSB                                            31
#define DBI_WINDOW_REG_DATA_581_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_581_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_581_MASK) >> DBI_WINDOW_REG_DATA_581_LSB)
#define DBI_WINDOW_REG_DATA_581_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_581_LSB) & DBI_WINDOW_REG_DATA_581_MASK)
#define DBI_WINDOW_REG_DATA_581_RESET                                          0x0
#define DBI_WINDOW_REG_581_ADDRESS                                             (0x914 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_581_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_581_RESET                                               0x0

// 0x918 (DBI_WINDOW_REG_582)
#define DBI_WINDOW_REG_DATA_582_LSB                                            0
#define DBI_WINDOW_REG_DATA_582_MSB                                            31
#define DBI_WINDOW_REG_DATA_582_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_582_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_582_MASK) >> DBI_WINDOW_REG_DATA_582_LSB)
#define DBI_WINDOW_REG_DATA_582_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_582_LSB) & DBI_WINDOW_REG_DATA_582_MASK)
#define DBI_WINDOW_REG_DATA_582_RESET                                          0x0
#define DBI_WINDOW_REG_582_ADDRESS                                             (0x918 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_582_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_582_RESET                                               0x0

// 0x91c (DBI_WINDOW_REG_583)
#define DBI_WINDOW_REG_DATA_583_LSB                                            0
#define DBI_WINDOW_REG_DATA_583_MSB                                            31
#define DBI_WINDOW_REG_DATA_583_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_583_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_583_MASK) >> DBI_WINDOW_REG_DATA_583_LSB)
#define DBI_WINDOW_REG_DATA_583_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_583_LSB) & DBI_WINDOW_REG_DATA_583_MASK)
#define DBI_WINDOW_REG_DATA_583_RESET                                          0x0
#define DBI_WINDOW_REG_583_ADDRESS                                             (0x91c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_583_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_583_RESET                                               0x0

// 0x920 (DBI_WINDOW_REG_584)
#define DBI_WINDOW_REG_DATA_584_LSB                                            0
#define DBI_WINDOW_REG_DATA_584_MSB                                            31
#define DBI_WINDOW_REG_DATA_584_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_584_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_584_MASK) >> DBI_WINDOW_REG_DATA_584_LSB)
#define DBI_WINDOW_REG_DATA_584_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_584_LSB) & DBI_WINDOW_REG_DATA_584_MASK)
#define DBI_WINDOW_REG_DATA_584_RESET                                          0x0
#define DBI_WINDOW_REG_584_ADDRESS                                             (0x920 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_584_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_584_RESET                                               0x0

// 0x924 (DBI_WINDOW_REG_585)
#define DBI_WINDOW_REG_DATA_585_LSB                                            0
#define DBI_WINDOW_REG_DATA_585_MSB                                            31
#define DBI_WINDOW_REG_DATA_585_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_585_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_585_MASK) >> DBI_WINDOW_REG_DATA_585_LSB)
#define DBI_WINDOW_REG_DATA_585_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_585_LSB) & DBI_WINDOW_REG_DATA_585_MASK)
#define DBI_WINDOW_REG_DATA_585_RESET                                          0x0
#define DBI_WINDOW_REG_585_ADDRESS                                             (0x924 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_585_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_585_RESET                                               0x0

// 0x928 (DBI_WINDOW_REG_586)
#define DBI_WINDOW_REG_DATA_586_LSB                                            0
#define DBI_WINDOW_REG_DATA_586_MSB                                            31
#define DBI_WINDOW_REG_DATA_586_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_586_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_586_MASK) >> DBI_WINDOW_REG_DATA_586_LSB)
#define DBI_WINDOW_REG_DATA_586_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_586_LSB) & DBI_WINDOW_REG_DATA_586_MASK)
#define DBI_WINDOW_REG_DATA_586_RESET                                          0x0
#define DBI_WINDOW_REG_586_ADDRESS                                             (0x928 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_586_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_586_RESET                                               0x0

// 0x92c (DBI_WINDOW_REG_587)
#define DBI_WINDOW_REG_DATA_587_LSB                                            0
#define DBI_WINDOW_REG_DATA_587_MSB                                            31
#define DBI_WINDOW_REG_DATA_587_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_587_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_587_MASK) >> DBI_WINDOW_REG_DATA_587_LSB)
#define DBI_WINDOW_REG_DATA_587_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_587_LSB) & DBI_WINDOW_REG_DATA_587_MASK)
#define DBI_WINDOW_REG_DATA_587_RESET                                          0x0
#define DBI_WINDOW_REG_587_ADDRESS                                             (0x92c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_587_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_587_RESET                                               0x0

// 0x930 (DBI_WINDOW_REG_588)
#define DBI_WINDOW_REG_DATA_588_LSB                                            0
#define DBI_WINDOW_REG_DATA_588_MSB                                            31
#define DBI_WINDOW_REG_DATA_588_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_588_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_588_MASK) >> DBI_WINDOW_REG_DATA_588_LSB)
#define DBI_WINDOW_REG_DATA_588_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_588_LSB) & DBI_WINDOW_REG_DATA_588_MASK)
#define DBI_WINDOW_REG_DATA_588_RESET                                          0x0
#define DBI_WINDOW_REG_588_ADDRESS                                             (0x930 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_588_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_588_RESET                                               0x0

// 0x934 (DBI_WINDOW_REG_589)
#define DBI_WINDOW_REG_DATA_589_LSB                                            0
#define DBI_WINDOW_REG_DATA_589_MSB                                            31
#define DBI_WINDOW_REG_DATA_589_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_589_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_589_MASK) >> DBI_WINDOW_REG_DATA_589_LSB)
#define DBI_WINDOW_REG_DATA_589_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_589_LSB) & DBI_WINDOW_REG_DATA_589_MASK)
#define DBI_WINDOW_REG_DATA_589_RESET                                          0x0
#define DBI_WINDOW_REG_589_ADDRESS                                             (0x934 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_589_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_589_RESET                                               0x0

// 0x938 (DBI_WINDOW_REG_590)
#define DBI_WINDOW_REG_DATA_590_LSB                                            0
#define DBI_WINDOW_REG_DATA_590_MSB                                            31
#define DBI_WINDOW_REG_DATA_590_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_590_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_590_MASK) >> DBI_WINDOW_REG_DATA_590_LSB)
#define DBI_WINDOW_REG_DATA_590_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_590_LSB) & DBI_WINDOW_REG_DATA_590_MASK)
#define DBI_WINDOW_REG_DATA_590_RESET                                          0x0
#define DBI_WINDOW_REG_590_ADDRESS                                             (0x938 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_590_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_590_RESET                                               0x0

// 0x93c (DBI_WINDOW_REG_591)
#define DBI_WINDOW_REG_DATA_591_LSB                                            0
#define DBI_WINDOW_REG_DATA_591_MSB                                            31
#define DBI_WINDOW_REG_DATA_591_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_591_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_591_MASK) >> DBI_WINDOW_REG_DATA_591_LSB)
#define DBI_WINDOW_REG_DATA_591_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_591_LSB) & DBI_WINDOW_REG_DATA_591_MASK)
#define DBI_WINDOW_REG_DATA_591_RESET                                          0x0
#define DBI_WINDOW_REG_591_ADDRESS                                             (0x93c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_591_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_591_RESET                                               0x0

// 0x940 (DBI_WINDOW_REG_592)
#define DBI_WINDOW_REG_DATA_592_LSB                                            0
#define DBI_WINDOW_REG_DATA_592_MSB                                            31
#define DBI_WINDOW_REG_DATA_592_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_592_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_592_MASK) >> DBI_WINDOW_REG_DATA_592_LSB)
#define DBI_WINDOW_REG_DATA_592_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_592_LSB) & DBI_WINDOW_REG_DATA_592_MASK)
#define DBI_WINDOW_REG_DATA_592_RESET                                          0x0
#define DBI_WINDOW_REG_592_ADDRESS                                             (0x940 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_592_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_592_RESET                                               0x0

// 0x944 (DBI_WINDOW_REG_593)
#define DBI_WINDOW_REG_DATA_593_LSB                                            0
#define DBI_WINDOW_REG_DATA_593_MSB                                            31
#define DBI_WINDOW_REG_DATA_593_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_593_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_593_MASK) >> DBI_WINDOW_REG_DATA_593_LSB)
#define DBI_WINDOW_REG_DATA_593_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_593_LSB) & DBI_WINDOW_REG_DATA_593_MASK)
#define DBI_WINDOW_REG_DATA_593_RESET                                          0x0
#define DBI_WINDOW_REG_593_ADDRESS                                             (0x944 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_593_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_593_RESET                                               0x0

// 0x948 (DBI_WINDOW_REG_594)
#define DBI_WINDOW_REG_DATA_594_LSB                                            0
#define DBI_WINDOW_REG_DATA_594_MSB                                            31
#define DBI_WINDOW_REG_DATA_594_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_594_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_594_MASK) >> DBI_WINDOW_REG_DATA_594_LSB)
#define DBI_WINDOW_REG_DATA_594_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_594_LSB) & DBI_WINDOW_REG_DATA_594_MASK)
#define DBI_WINDOW_REG_DATA_594_RESET                                          0x0
#define DBI_WINDOW_REG_594_ADDRESS                                             (0x948 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_594_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_594_RESET                                               0x0

// 0x94c (DBI_WINDOW_REG_595)
#define DBI_WINDOW_REG_DATA_595_LSB                                            0
#define DBI_WINDOW_REG_DATA_595_MSB                                            31
#define DBI_WINDOW_REG_DATA_595_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_595_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_595_MASK) >> DBI_WINDOW_REG_DATA_595_LSB)
#define DBI_WINDOW_REG_DATA_595_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_595_LSB) & DBI_WINDOW_REG_DATA_595_MASK)
#define DBI_WINDOW_REG_DATA_595_RESET                                          0x0
#define DBI_WINDOW_REG_595_ADDRESS                                             (0x94c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_595_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_595_RESET                                               0x0

// 0x950 (DBI_WINDOW_REG_596)
#define DBI_WINDOW_REG_DATA_596_LSB                                            0
#define DBI_WINDOW_REG_DATA_596_MSB                                            31
#define DBI_WINDOW_REG_DATA_596_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_596_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_596_MASK) >> DBI_WINDOW_REG_DATA_596_LSB)
#define DBI_WINDOW_REG_DATA_596_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_596_LSB) & DBI_WINDOW_REG_DATA_596_MASK)
#define DBI_WINDOW_REG_DATA_596_RESET                                          0x0
#define DBI_WINDOW_REG_596_ADDRESS                                             (0x950 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_596_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_596_RESET                                               0x0

// 0x954 (DBI_WINDOW_REG_597)
#define DBI_WINDOW_REG_DATA_597_LSB                                            0
#define DBI_WINDOW_REG_DATA_597_MSB                                            31
#define DBI_WINDOW_REG_DATA_597_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_597_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_597_MASK) >> DBI_WINDOW_REG_DATA_597_LSB)
#define DBI_WINDOW_REG_DATA_597_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_597_LSB) & DBI_WINDOW_REG_DATA_597_MASK)
#define DBI_WINDOW_REG_DATA_597_RESET                                          0x0
#define DBI_WINDOW_REG_597_ADDRESS                                             (0x954 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_597_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_597_RESET                                               0x0

// 0x958 (DBI_WINDOW_REG_598)
#define DBI_WINDOW_REG_DATA_598_LSB                                            0
#define DBI_WINDOW_REG_DATA_598_MSB                                            31
#define DBI_WINDOW_REG_DATA_598_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_598_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_598_MASK) >> DBI_WINDOW_REG_DATA_598_LSB)
#define DBI_WINDOW_REG_DATA_598_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_598_LSB) & DBI_WINDOW_REG_DATA_598_MASK)
#define DBI_WINDOW_REG_DATA_598_RESET                                          0x0
#define DBI_WINDOW_REG_598_ADDRESS                                             (0x958 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_598_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_598_RESET                                               0x0

// 0x95c (DBI_WINDOW_REG_599)
#define DBI_WINDOW_REG_DATA_599_LSB                                            0
#define DBI_WINDOW_REG_DATA_599_MSB                                            31
#define DBI_WINDOW_REG_DATA_599_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_599_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_599_MASK) >> DBI_WINDOW_REG_DATA_599_LSB)
#define DBI_WINDOW_REG_DATA_599_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_599_LSB) & DBI_WINDOW_REG_DATA_599_MASK)
#define DBI_WINDOW_REG_DATA_599_RESET                                          0x0
#define DBI_WINDOW_REG_599_ADDRESS                                             (0x95c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_599_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_599_RESET                                               0x0

// 0x960 (DBI_WINDOW_REG_600)
#define DBI_WINDOW_REG_DATA_600_LSB                                            0
#define DBI_WINDOW_REG_DATA_600_MSB                                            31
#define DBI_WINDOW_REG_DATA_600_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_600_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_600_MASK) >> DBI_WINDOW_REG_DATA_600_LSB)
#define DBI_WINDOW_REG_DATA_600_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_600_LSB) & DBI_WINDOW_REG_DATA_600_MASK)
#define DBI_WINDOW_REG_DATA_600_RESET                                          0x0
#define DBI_WINDOW_REG_600_ADDRESS                                             (0x960 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_600_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_600_RESET                                               0x0

// 0x964 (DBI_WINDOW_REG_601)
#define DBI_WINDOW_REG_DATA_601_LSB                                            0
#define DBI_WINDOW_REG_DATA_601_MSB                                            31
#define DBI_WINDOW_REG_DATA_601_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_601_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_601_MASK) >> DBI_WINDOW_REG_DATA_601_LSB)
#define DBI_WINDOW_REG_DATA_601_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_601_LSB) & DBI_WINDOW_REG_DATA_601_MASK)
#define DBI_WINDOW_REG_DATA_601_RESET                                          0x0
#define DBI_WINDOW_REG_601_ADDRESS                                             (0x964 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_601_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_601_RESET                                               0x0

// 0x968 (DBI_WINDOW_REG_602)
#define DBI_WINDOW_REG_DATA_602_LSB                                            0
#define DBI_WINDOW_REG_DATA_602_MSB                                            31
#define DBI_WINDOW_REG_DATA_602_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_602_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_602_MASK) >> DBI_WINDOW_REG_DATA_602_LSB)
#define DBI_WINDOW_REG_DATA_602_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_602_LSB) & DBI_WINDOW_REG_DATA_602_MASK)
#define DBI_WINDOW_REG_DATA_602_RESET                                          0x0
#define DBI_WINDOW_REG_602_ADDRESS                                             (0x968 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_602_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_602_RESET                                               0x0

// 0x96c (DBI_WINDOW_REG_603)
#define DBI_WINDOW_REG_DATA_603_LSB                                            0
#define DBI_WINDOW_REG_DATA_603_MSB                                            31
#define DBI_WINDOW_REG_DATA_603_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_603_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_603_MASK) >> DBI_WINDOW_REG_DATA_603_LSB)
#define DBI_WINDOW_REG_DATA_603_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_603_LSB) & DBI_WINDOW_REG_DATA_603_MASK)
#define DBI_WINDOW_REG_DATA_603_RESET                                          0x0
#define DBI_WINDOW_REG_603_ADDRESS                                             (0x96c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_603_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_603_RESET                                               0x0

// 0x970 (DBI_WINDOW_REG_604)
#define DBI_WINDOW_REG_DATA_604_LSB                                            0
#define DBI_WINDOW_REG_DATA_604_MSB                                            31
#define DBI_WINDOW_REG_DATA_604_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_604_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_604_MASK) >> DBI_WINDOW_REG_DATA_604_LSB)
#define DBI_WINDOW_REG_DATA_604_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_604_LSB) & DBI_WINDOW_REG_DATA_604_MASK)
#define DBI_WINDOW_REG_DATA_604_RESET                                          0x0
#define DBI_WINDOW_REG_604_ADDRESS                                             (0x970 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_604_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_604_RESET                                               0x0

// 0x974 (DBI_WINDOW_REG_605)
#define DBI_WINDOW_REG_DATA_605_LSB                                            0
#define DBI_WINDOW_REG_DATA_605_MSB                                            31
#define DBI_WINDOW_REG_DATA_605_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_605_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_605_MASK) >> DBI_WINDOW_REG_DATA_605_LSB)
#define DBI_WINDOW_REG_DATA_605_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_605_LSB) & DBI_WINDOW_REG_DATA_605_MASK)
#define DBI_WINDOW_REG_DATA_605_RESET                                          0x0
#define DBI_WINDOW_REG_605_ADDRESS                                             (0x974 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_605_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_605_RESET                                               0x0

// 0x978 (DBI_WINDOW_REG_606)
#define DBI_WINDOW_REG_DATA_606_LSB                                            0
#define DBI_WINDOW_REG_DATA_606_MSB                                            31
#define DBI_WINDOW_REG_DATA_606_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_606_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_606_MASK) >> DBI_WINDOW_REG_DATA_606_LSB)
#define DBI_WINDOW_REG_DATA_606_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_606_LSB) & DBI_WINDOW_REG_DATA_606_MASK)
#define DBI_WINDOW_REG_DATA_606_RESET                                          0x0
#define DBI_WINDOW_REG_606_ADDRESS                                             (0x978 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_606_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_606_RESET                                               0x0

// 0x97c (DBI_WINDOW_REG_607)
#define DBI_WINDOW_REG_DATA_607_LSB                                            0
#define DBI_WINDOW_REG_DATA_607_MSB                                            31
#define DBI_WINDOW_REG_DATA_607_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_607_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_607_MASK) >> DBI_WINDOW_REG_DATA_607_LSB)
#define DBI_WINDOW_REG_DATA_607_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_607_LSB) & DBI_WINDOW_REG_DATA_607_MASK)
#define DBI_WINDOW_REG_DATA_607_RESET                                          0x0
#define DBI_WINDOW_REG_607_ADDRESS                                             (0x97c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_607_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_607_RESET                                               0x0

// 0x980 (DBI_WINDOW_REG_608)
#define DBI_WINDOW_REG_DATA_608_LSB                                            0
#define DBI_WINDOW_REG_DATA_608_MSB                                            31
#define DBI_WINDOW_REG_DATA_608_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_608_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_608_MASK) >> DBI_WINDOW_REG_DATA_608_LSB)
#define DBI_WINDOW_REG_DATA_608_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_608_LSB) & DBI_WINDOW_REG_DATA_608_MASK)
#define DBI_WINDOW_REG_DATA_608_RESET                                          0x0
#define DBI_WINDOW_REG_608_ADDRESS                                             (0x980 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_608_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_608_RESET                                               0x0

// 0x984 (DBI_WINDOW_REG_609)
#define DBI_WINDOW_REG_DATA_609_LSB                                            0
#define DBI_WINDOW_REG_DATA_609_MSB                                            31
#define DBI_WINDOW_REG_DATA_609_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_609_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_609_MASK) >> DBI_WINDOW_REG_DATA_609_LSB)
#define DBI_WINDOW_REG_DATA_609_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_609_LSB) & DBI_WINDOW_REG_DATA_609_MASK)
#define DBI_WINDOW_REG_DATA_609_RESET                                          0x0
#define DBI_WINDOW_REG_609_ADDRESS                                             (0x984 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_609_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_609_RESET                                               0x0

// 0x988 (DBI_WINDOW_REG_610)
#define DBI_WINDOW_REG_DATA_610_LSB                                            0
#define DBI_WINDOW_REG_DATA_610_MSB                                            31
#define DBI_WINDOW_REG_DATA_610_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_610_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_610_MASK) >> DBI_WINDOW_REG_DATA_610_LSB)
#define DBI_WINDOW_REG_DATA_610_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_610_LSB) & DBI_WINDOW_REG_DATA_610_MASK)
#define DBI_WINDOW_REG_DATA_610_RESET                                          0x0
#define DBI_WINDOW_REG_610_ADDRESS                                             (0x988 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_610_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_610_RESET                                               0x0

// 0x98c (DBI_WINDOW_REG_611)
#define DBI_WINDOW_REG_DATA_611_LSB                                            0
#define DBI_WINDOW_REG_DATA_611_MSB                                            31
#define DBI_WINDOW_REG_DATA_611_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_611_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_611_MASK) >> DBI_WINDOW_REG_DATA_611_LSB)
#define DBI_WINDOW_REG_DATA_611_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_611_LSB) & DBI_WINDOW_REG_DATA_611_MASK)
#define DBI_WINDOW_REG_DATA_611_RESET                                          0x0
#define DBI_WINDOW_REG_611_ADDRESS                                             (0x98c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_611_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_611_RESET                                               0x0

// 0x990 (DBI_WINDOW_REG_612)
#define DBI_WINDOW_REG_DATA_612_LSB                                            0
#define DBI_WINDOW_REG_DATA_612_MSB                                            31
#define DBI_WINDOW_REG_DATA_612_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_612_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_612_MASK) >> DBI_WINDOW_REG_DATA_612_LSB)
#define DBI_WINDOW_REG_DATA_612_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_612_LSB) & DBI_WINDOW_REG_DATA_612_MASK)
#define DBI_WINDOW_REG_DATA_612_RESET                                          0x0
#define DBI_WINDOW_REG_612_ADDRESS                                             (0x990 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_612_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_612_RESET                                               0x0

// 0x994 (DBI_WINDOW_REG_613)
#define DBI_WINDOW_REG_DATA_613_LSB                                            0
#define DBI_WINDOW_REG_DATA_613_MSB                                            31
#define DBI_WINDOW_REG_DATA_613_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_613_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_613_MASK) >> DBI_WINDOW_REG_DATA_613_LSB)
#define DBI_WINDOW_REG_DATA_613_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_613_LSB) & DBI_WINDOW_REG_DATA_613_MASK)
#define DBI_WINDOW_REG_DATA_613_RESET                                          0x0
#define DBI_WINDOW_REG_613_ADDRESS                                             (0x994 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_613_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_613_RESET                                               0x0

// 0x998 (DBI_WINDOW_REG_614)
#define DBI_WINDOW_REG_DATA_614_LSB                                            0
#define DBI_WINDOW_REG_DATA_614_MSB                                            31
#define DBI_WINDOW_REG_DATA_614_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_614_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_614_MASK) >> DBI_WINDOW_REG_DATA_614_LSB)
#define DBI_WINDOW_REG_DATA_614_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_614_LSB) & DBI_WINDOW_REG_DATA_614_MASK)
#define DBI_WINDOW_REG_DATA_614_RESET                                          0x0
#define DBI_WINDOW_REG_614_ADDRESS                                             (0x998 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_614_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_614_RESET                                               0x0

// 0x99c (DBI_WINDOW_REG_615)
#define DBI_WINDOW_REG_DATA_615_LSB                                            0
#define DBI_WINDOW_REG_DATA_615_MSB                                            31
#define DBI_WINDOW_REG_DATA_615_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_615_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_615_MASK) >> DBI_WINDOW_REG_DATA_615_LSB)
#define DBI_WINDOW_REG_DATA_615_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_615_LSB) & DBI_WINDOW_REG_DATA_615_MASK)
#define DBI_WINDOW_REG_DATA_615_RESET                                          0x0
#define DBI_WINDOW_REG_615_ADDRESS                                             (0x99c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_615_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_615_RESET                                               0x0

// 0x9a0 (DBI_WINDOW_REG_616)
#define DBI_WINDOW_REG_DATA_616_LSB                                            0
#define DBI_WINDOW_REG_DATA_616_MSB                                            31
#define DBI_WINDOW_REG_DATA_616_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_616_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_616_MASK) >> DBI_WINDOW_REG_DATA_616_LSB)
#define DBI_WINDOW_REG_DATA_616_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_616_LSB) & DBI_WINDOW_REG_DATA_616_MASK)
#define DBI_WINDOW_REG_DATA_616_RESET                                          0x0
#define DBI_WINDOW_REG_616_ADDRESS                                             (0x9a0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_616_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_616_RESET                                               0x0

// 0x9a4 (DBI_WINDOW_REG_617)
#define DBI_WINDOW_REG_DATA_617_LSB                                            0
#define DBI_WINDOW_REG_DATA_617_MSB                                            31
#define DBI_WINDOW_REG_DATA_617_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_617_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_617_MASK) >> DBI_WINDOW_REG_DATA_617_LSB)
#define DBI_WINDOW_REG_DATA_617_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_617_LSB) & DBI_WINDOW_REG_DATA_617_MASK)
#define DBI_WINDOW_REG_DATA_617_RESET                                          0x0
#define DBI_WINDOW_REG_617_ADDRESS                                             (0x9a4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_617_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_617_RESET                                               0x0

// 0x9a8 (DBI_WINDOW_REG_618)
#define DBI_WINDOW_REG_DATA_618_LSB                                            0
#define DBI_WINDOW_REG_DATA_618_MSB                                            31
#define DBI_WINDOW_REG_DATA_618_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_618_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_618_MASK) >> DBI_WINDOW_REG_DATA_618_LSB)
#define DBI_WINDOW_REG_DATA_618_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_618_LSB) & DBI_WINDOW_REG_DATA_618_MASK)
#define DBI_WINDOW_REG_DATA_618_RESET                                          0x0
#define DBI_WINDOW_REG_618_ADDRESS                                             (0x9a8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_618_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_618_RESET                                               0x0

// 0x9ac (DBI_WINDOW_REG_619)
#define DBI_WINDOW_REG_DATA_619_LSB                                            0
#define DBI_WINDOW_REG_DATA_619_MSB                                            31
#define DBI_WINDOW_REG_DATA_619_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_619_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_619_MASK) >> DBI_WINDOW_REG_DATA_619_LSB)
#define DBI_WINDOW_REG_DATA_619_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_619_LSB) & DBI_WINDOW_REG_DATA_619_MASK)
#define DBI_WINDOW_REG_DATA_619_RESET                                          0x0
#define DBI_WINDOW_REG_619_ADDRESS                                             (0x9ac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_619_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_619_RESET                                               0x0

// 0x9b0 (DBI_WINDOW_REG_620)
#define DBI_WINDOW_REG_DATA_620_LSB                                            0
#define DBI_WINDOW_REG_DATA_620_MSB                                            31
#define DBI_WINDOW_REG_DATA_620_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_620_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_620_MASK) >> DBI_WINDOW_REG_DATA_620_LSB)
#define DBI_WINDOW_REG_DATA_620_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_620_LSB) & DBI_WINDOW_REG_DATA_620_MASK)
#define DBI_WINDOW_REG_DATA_620_RESET                                          0x0
#define DBI_WINDOW_REG_620_ADDRESS                                             (0x9b0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_620_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_620_RESET                                               0x0

// 0x9b4 (DBI_WINDOW_REG_621)
#define DBI_WINDOW_REG_DATA_621_LSB                                            0
#define DBI_WINDOW_REG_DATA_621_MSB                                            31
#define DBI_WINDOW_REG_DATA_621_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_621_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_621_MASK) >> DBI_WINDOW_REG_DATA_621_LSB)
#define DBI_WINDOW_REG_DATA_621_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_621_LSB) & DBI_WINDOW_REG_DATA_621_MASK)
#define DBI_WINDOW_REG_DATA_621_RESET                                          0x0
#define DBI_WINDOW_REG_621_ADDRESS                                             (0x9b4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_621_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_621_RESET                                               0x0

// 0x9b8 (DBI_WINDOW_REG_622)
#define DBI_WINDOW_REG_DATA_622_LSB                                            0
#define DBI_WINDOW_REG_DATA_622_MSB                                            31
#define DBI_WINDOW_REG_DATA_622_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_622_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_622_MASK) >> DBI_WINDOW_REG_DATA_622_LSB)
#define DBI_WINDOW_REG_DATA_622_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_622_LSB) & DBI_WINDOW_REG_DATA_622_MASK)
#define DBI_WINDOW_REG_DATA_622_RESET                                          0x0
#define DBI_WINDOW_REG_622_ADDRESS                                             (0x9b8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_622_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_622_RESET                                               0x0

// 0x9bc (DBI_WINDOW_REG_623)
#define DBI_WINDOW_REG_DATA_623_LSB                                            0
#define DBI_WINDOW_REG_DATA_623_MSB                                            31
#define DBI_WINDOW_REG_DATA_623_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_623_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_623_MASK) >> DBI_WINDOW_REG_DATA_623_LSB)
#define DBI_WINDOW_REG_DATA_623_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_623_LSB) & DBI_WINDOW_REG_DATA_623_MASK)
#define DBI_WINDOW_REG_DATA_623_RESET                                          0x0
#define DBI_WINDOW_REG_623_ADDRESS                                             (0x9bc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_623_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_623_RESET                                               0x0

// 0x9c0 (DBI_WINDOW_REG_624)
#define DBI_WINDOW_REG_DATA_624_LSB                                            0
#define DBI_WINDOW_REG_DATA_624_MSB                                            31
#define DBI_WINDOW_REG_DATA_624_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_624_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_624_MASK) >> DBI_WINDOW_REG_DATA_624_LSB)
#define DBI_WINDOW_REG_DATA_624_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_624_LSB) & DBI_WINDOW_REG_DATA_624_MASK)
#define DBI_WINDOW_REG_DATA_624_RESET                                          0x0
#define DBI_WINDOW_REG_624_ADDRESS                                             (0x9c0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_624_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_624_RESET                                               0x0

// 0x9c4 (DBI_WINDOW_REG_625)
#define DBI_WINDOW_REG_DATA_625_LSB                                            0
#define DBI_WINDOW_REG_DATA_625_MSB                                            31
#define DBI_WINDOW_REG_DATA_625_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_625_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_625_MASK) >> DBI_WINDOW_REG_DATA_625_LSB)
#define DBI_WINDOW_REG_DATA_625_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_625_LSB) & DBI_WINDOW_REG_DATA_625_MASK)
#define DBI_WINDOW_REG_DATA_625_RESET                                          0x0
#define DBI_WINDOW_REG_625_ADDRESS                                             (0x9c4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_625_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_625_RESET                                               0x0

// 0x9c8 (DBI_WINDOW_REG_626)
#define DBI_WINDOW_REG_DATA_626_LSB                                            0
#define DBI_WINDOW_REG_DATA_626_MSB                                            31
#define DBI_WINDOW_REG_DATA_626_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_626_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_626_MASK) >> DBI_WINDOW_REG_DATA_626_LSB)
#define DBI_WINDOW_REG_DATA_626_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_626_LSB) & DBI_WINDOW_REG_DATA_626_MASK)
#define DBI_WINDOW_REG_DATA_626_RESET                                          0x0
#define DBI_WINDOW_REG_626_ADDRESS                                             (0x9c8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_626_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_626_RESET                                               0x0

// 0x9cc (DBI_WINDOW_REG_627)
#define DBI_WINDOW_REG_DATA_627_LSB                                            0
#define DBI_WINDOW_REG_DATA_627_MSB                                            31
#define DBI_WINDOW_REG_DATA_627_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_627_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_627_MASK) >> DBI_WINDOW_REG_DATA_627_LSB)
#define DBI_WINDOW_REG_DATA_627_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_627_LSB) & DBI_WINDOW_REG_DATA_627_MASK)
#define DBI_WINDOW_REG_DATA_627_RESET                                          0x0
#define DBI_WINDOW_REG_627_ADDRESS                                             (0x9cc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_627_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_627_RESET                                               0x0

// 0x9d0 (DBI_WINDOW_REG_628)
#define DBI_WINDOW_REG_DATA_628_LSB                                            0
#define DBI_WINDOW_REG_DATA_628_MSB                                            31
#define DBI_WINDOW_REG_DATA_628_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_628_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_628_MASK) >> DBI_WINDOW_REG_DATA_628_LSB)
#define DBI_WINDOW_REG_DATA_628_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_628_LSB) & DBI_WINDOW_REG_DATA_628_MASK)
#define DBI_WINDOW_REG_DATA_628_RESET                                          0x0
#define DBI_WINDOW_REG_628_ADDRESS                                             (0x9d0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_628_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_628_RESET                                               0x0

// 0x9d4 (DBI_WINDOW_REG_629)
#define DBI_WINDOW_REG_DATA_629_LSB                                            0
#define DBI_WINDOW_REG_DATA_629_MSB                                            31
#define DBI_WINDOW_REG_DATA_629_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_629_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_629_MASK) >> DBI_WINDOW_REG_DATA_629_LSB)
#define DBI_WINDOW_REG_DATA_629_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_629_LSB) & DBI_WINDOW_REG_DATA_629_MASK)
#define DBI_WINDOW_REG_DATA_629_RESET                                          0x0
#define DBI_WINDOW_REG_629_ADDRESS                                             (0x9d4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_629_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_629_RESET                                               0x0

// 0x9d8 (DBI_WINDOW_REG_630)
#define DBI_WINDOW_REG_DATA_630_LSB                                            0
#define DBI_WINDOW_REG_DATA_630_MSB                                            31
#define DBI_WINDOW_REG_DATA_630_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_630_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_630_MASK) >> DBI_WINDOW_REG_DATA_630_LSB)
#define DBI_WINDOW_REG_DATA_630_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_630_LSB) & DBI_WINDOW_REG_DATA_630_MASK)
#define DBI_WINDOW_REG_DATA_630_RESET                                          0x0
#define DBI_WINDOW_REG_630_ADDRESS                                             (0x9d8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_630_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_630_RESET                                               0x0

// 0x9dc (DBI_WINDOW_REG_631)
#define DBI_WINDOW_REG_DATA_631_LSB                                            0
#define DBI_WINDOW_REG_DATA_631_MSB                                            31
#define DBI_WINDOW_REG_DATA_631_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_631_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_631_MASK) >> DBI_WINDOW_REG_DATA_631_LSB)
#define DBI_WINDOW_REG_DATA_631_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_631_LSB) & DBI_WINDOW_REG_DATA_631_MASK)
#define DBI_WINDOW_REG_DATA_631_RESET                                          0x0
#define DBI_WINDOW_REG_631_ADDRESS                                             (0x9dc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_631_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_631_RESET                                               0x0

// 0x9e0 (DBI_WINDOW_REG_632)
#define DBI_WINDOW_REG_DATA_632_LSB                                            0
#define DBI_WINDOW_REG_DATA_632_MSB                                            31
#define DBI_WINDOW_REG_DATA_632_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_632_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_632_MASK) >> DBI_WINDOW_REG_DATA_632_LSB)
#define DBI_WINDOW_REG_DATA_632_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_632_LSB) & DBI_WINDOW_REG_DATA_632_MASK)
#define DBI_WINDOW_REG_DATA_632_RESET                                          0x0
#define DBI_WINDOW_REG_632_ADDRESS                                             (0x9e0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_632_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_632_RESET                                               0x0

// 0x9e4 (DBI_WINDOW_REG_633)
#define DBI_WINDOW_REG_DATA_633_LSB                                            0
#define DBI_WINDOW_REG_DATA_633_MSB                                            31
#define DBI_WINDOW_REG_DATA_633_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_633_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_633_MASK) >> DBI_WINDOW_REG_DATA_633_LSB)
#define DBI_WINDOW_REG_DATA_633_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_633_LSB) & DBI_WINDOW_REG_DATA_633_MASK)
#define DBI_WINDOW_REG_DATA_633_RESET                                          0x0
#define DBI_WINDOW_REG_633_ADDRESS                                             (0x9e4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_633_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_633_RESET                                               0x0

// 0x9e8 (DBI_WINDOW_REG_634)
#define DBI_WINDOW_REG_DATA_634_LSB                                            0
#define DBI_WINDOW_REG_DATA_634_MSB                                            31
#define DBI_WINDOW_REG_DATA_634_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_634_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_634_MASK) >> DBI_WINDOW_REG_DATA_634_LSB)
#define DBI_WINDOW_REG_DATA_634_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_634_LSB) & DBI_WINDOW_REG_DATA_634_MASK)
#define DBI_WINDOW_REG_DATA_634_RESET                                          0x0
#define DBI_WINDOW_REG_634_ADDRESS                                             (0x9e8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_634_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_634_RESET                                               0x0

// 0x9ec (DBI_WINDOW_REG_635)
#define DBI_WINDOW_REG_DATA_635_LSB                                            0
#define DBI_WINDOW_REG_DATA_635_MSB                                            31
#define DBI_WINDOW_REG_DATA_635_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_635_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_635_MASK) >> DBI_WINDOW_REG_DATA_635_LSB)
#define DBI_WINDOW_REG_DATA_635_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_635_LSB) & DBI_WINDOW_REG_DATA_635_MASK)
#define DBI_WINDOW_REG_DATA_635_RESET                                          0x0
#define DBI_WINDOW_REG_635_ADDRESS                                             (0x9ec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_635_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_635_RESET                                               0x0

// 0x9f0 (DBI_WINDOW_REG_636)
#define DBI_WINDOW_REG_DATA_636_LSB                                            0
#define DBI_WINDOW_REG_DATA_636_MSB                                            31
#define DBI_WINDOW_REG_DATA_636_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_636_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_636_MASK) >> DBI_WINDOW_REG_DATA_636_LSB)
#define DBI_WINDOW_REG_DATA_636_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_636_LSB) & DBI_WINDOW_REG_DATA_636_MASK)
#define DBI_WINDOW_REG_DATA_636_RESET                                          0x0
#define DBI_WINDOW_REG_636_ADDRESS                                             (0x9f0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_636_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_636_RESET                                               0x0

// 0x9f4 (DBI_WINDOW_REG_637)
#define DBI_WINDOW_REG_DATA_637_LSB                                            0
#define DBI_WINDOW_REG_DATA_637_MSB                                            31
#define DBI_WINDOW_REG_DATA_637_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_637_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_637_MASK) >> DBI_WINDOW_REG_DATA_637_LSB)
#define DBI_WINDOW_REG_DATA_637_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_637_LSB) & DBI_WINDOW_REG_DATA_637_MASK)
#define DBI_WINDOW_REG_DATA_637_RESET                                          0x0
#define DBI_WINDOW_REG_637_ADDRESS                                             (0x9f4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_637_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_637_RESET                                               0x0

// 0x9f8 (DBI_WINDOW_REG_638)
#define DBI_WINDOW_REG_DATA_638_LSB                                            0
#define DBI_WINDOW_REG_DATA_638_MSB                                            31
#define DBI_WINDOW_REG_DATA_638_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_638_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_638_MASK) >> DBI_WINDOW_REG_DATA_638_LSB)
#define DBI_WINDOW_REG_DATA_638_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_638_LSB) & DBI_WINDOW_REG_DATA_638_MASK)
#define DBI_WINDOW_REG_DATA_638_RESET                                          0x0
#define DBI_WINDOW_REG_638_ADDRESS                                             (0x9f8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_638_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_638_RESET                                               0x0

// 0x9fc (DBI_WINDOW_REG_639)
#define DBI_WINDOW_REG_DATA_639_LSB                                            0
#define DBI_WINDOW_REG_DATA_639_MSB                                            31
#define DBI_WINDOW_REG_DATA_639_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_639_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_639_MASK) >> DBI_WINDOW_REG_DATA_639_LSB)
#define DBI_WINDOW_REG_DATA_639_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_639_LSB) & DBI_WINDOW_REG_DATA_639_MASK)
#define DBI_WINDOW_REG_DATA_639_RESET                                          0x0
#define DBI_WINDOW_REG_639_ADDRESS                                             (0x9fc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_639_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_639_RESET                                               0x0

// 0xa00 (DBI_WINDOW_REG_640)
#define DBI_WINDOW_REG_DATA_640_LSB                                            0
#define DBI_WINDOW_REG_DATA_640_MSB                                            31
#define DBI_WINDOW_REG_DATA_640_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_640_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_640_MASK) >> DBI_WINDOW_REG_DATA_640_LSB)
#define DBI_WINDOW_REG_DATA_640_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_640_LSB) & DBI_WINDOW_REG_DATA_640_MASK)
#define DBI_WINDOW_REG_DATA_640_RESET                                          0x0
#define DBI_WINDOW_REG_640_ADDRESS                                             (0xa00 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_640_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_640_RESET                                               0x0

// 0xa04 (DBI_WINDOW_REG_641)
#define DBI_WINDOW_REG_DATA_641_LSB                                            0
#define DBI_WINDOW_REG_DATA_641_MSB                                            31
#define DBI_WINDOW_REG_DATA_641_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_641_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_641_MASK) >> DBI_WINDOW_REG_DATA_641_LSB)
#define DBI_WINDOW_REG_DATA_641_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_641_LSB) & DBI_WINDOW_REG_DATA_641_MASK)
#define DBI_WINDOW_REG_DATA_641_RESET                                          0x0
#define DBI_WINDOW_REG_641_ADDRESS                                             (0xa04 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_641_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_641_RESET                                               0x0

// 0xa08 (DBI_WINDOW_REG_642)
#define DBI_WINDOW_REG_DATA_642_LSB                                            0
#define DBI_WINDOW_REG_DATA_642_MSB                                            31
#define DBI_WINDOW_REG_DATA_642_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_642_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_642_MASK) >> DBI_WINDOW_REG_DATA_642_LSB)
#define DBI_WINDOW_REG_DATA_642_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_642_LSB) & DBI_WINDOW_REG_DATA_642_MASK)
#define DBI_WINDOW_REG_DATA_642_RESET                                          0x0
#define DBI_WINDOW_REG_642_ADDRESS                                             (0xa08 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_642_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_642_RESET                                               0x0

// 0xa0c (DBI_WINDOW_REG_643)
#define DBI_WINDOW_REG_DATA_643_LSB                                            0
#define DBI_WINDOW_REG_DATA_643_MSB                                            31
#define DBI_WINDOW_REG_DATA_643_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_643_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_643_MASK) >> DBI_WINDOW_REG_DATA_643_LSB)
#define DBI_WINDOW_REG_DATA_643_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_643_LSB) & DBI_WINDOW_REG_DATA_643_MASK)
#define DBI_WINDOW_REG_DATA_643_RESET                                          0x0
#define DBI_WINDOW_REG_643_ADDRESS                                             (0xa0c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_643_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_643_RESET                                               0x0

// 0xa10 (DBI_WINDOW_REG_644)
#define DBI_WINDOW_REG_DATA_644_LSB                                            0
#define DBI_WINDOW_REG_DATA_644_MSB                                            31
#define DBI_WINDOW_REG_DATA_644_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_644_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_644_MASK) >> DBI_WINDOW_REG_DATA_644_LSB)
#define DBI_WINDOW_REG_DATA_644_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_644_LSB) & DBI_WINDOW_REG_DATA_644_MASK)
#define DBI_WINDOW_REG_DATA_644_RESET                                          0x0
#define DBI_WINDOW_REG_644_ADDRESS                                             (0xa10 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_644_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_644_RESET                                               0x0

// 0xa14 (DBI_WINDOW_REG_645)
#define DBI_WINDOW_REG_DATA_645_LSB                                            0
#define DBI_WINDOW_REG_DATA_645_MSB                                            31
#define DBI_WINDOW_REG_DATA_645_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_645_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_645_MASK) >> DBI_WINDOW_REG_DATA_645_LSB)
#define DBI_WINDOW_REG_DATA_645_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_645_LSB) & DBI_WINDOW_REG_DATA_645_MASK)
#define DBI_WINDOW_REG_DATA_645_RESET                                          0x0
#define DBI_WINDOW_REG_645_ADDRESS                                             (0xa14 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_645_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_645_RESET                                               0x0

// 0xa18 (DBI_WINDOW_REG_646)
#define DBI_WINDOW_REG_DATA_646_LSB                                            0
#define DBI_WINDOW_REG_DATA_646_MSB                                            31
#define DBI_WINDOW_REG_DATA_646_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_646_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_646_MASK) >> DBI_WINDOW_REG_DATA_646_LSB)
#define DBI_WINDOW_REG_DATA_646_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_646_LSB) & DBI_WINDOW_REG_DATA_646_MASK)
#define DBI_WINDOW_REG_DATA_646_RESET                                          0x0
#define DBI_WINDOW_REG_646_ADDRESS                                             (0xa18 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_646_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_646_RESET                                               0x0

// 0xa1c (DBI_WINDOW_REG_647)
#define DBI_WINDOW_REG_DATA_647_LSB                                            0
#define DBI_WINDOW_REG_DATA_647_MSB                                            31
#define DBI_WINDOW_REG_DATA_647_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_647_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_647_MASK) >> DBI_WINDOW_REG_DATA_647_LSB)
#define DBI_WINDOW_REG_DATA_647_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_647_LSB) & DBI_WINDOW_REG_DATA_647_MASK)
#define DBI_WINDOW_REG_DATA_647_RESET                                          0x0
#define DBI_WINDOW_REG_647_ADDRESS                                             (0xa1c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_647_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_647_RESET                                               0x0

// 0xa20 (DBI_WINDOW_REG_648)
#define DBI_WINDOW_REG_DATA_648_LSB                                            0
#define DBI_WINDOW_REG_DATA_648_MSB                                            31
#define DBI_WINDOW_REG_DATA_648_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_648_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_648_MASK) >> DBI_WINDOW_REG_DATA_648_LSB)
#define DBI_WINDOW_REG_DATA_648_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_648_LSB) & DBI_WINDOW_REG_DATA_648_MASK)
#define DBI_WINDOW_REG_DATA_648_RESET                                          0x0
#define DBI_WINDOW_REG_648_ADDRESS                                             (0xa20 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_648_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_648_RESET                                               0x0

// 0xa24 (DBI_WINDOW_REG_649)
#define DBI_WINDOW_REG_DATA_649_LSB                                            0
#define DBI_WINDOW_REG_DATA_649_MSB                                            31
#define DBI_WINDOW_REG_DATA_649_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_649_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_649_MASK) >> DBI_WINDOW_REG_DATA_649_LSB)
#define DBI_WINDOW_REG_DATA_649_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_649_LSB) & DBI_WINDOW_REG_DATA_649_MASK)
#define DBI_WINDOW_REG_DATA_649_RESET                                          0x0
#define DBI_WINDOW_REG_649_ADDRESS                                             (0xa24 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_649_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_649_RESET                                               0x0

// 0xa28 (DBI_WINDOW_REG_650)
#define DBI_WINDOW_REG_DATA_650_LSB                                            0
#define DBI_WINDOW_REG_DATA_650_MSB                                            31
#define DBI_WINDOW_REG_DATA_650_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_650_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_650_MASK) >> DBI_WINDOW_REG_DATA_650_LSB)
#define DBI_WINDOW_REG_DATA_650_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_650_LSB) & DBI_WINDOW_REG_DATA_650_MASK)
#define DBI_WINDOW_REG_DATA_650_RESET                                          0x0
#define DBI_WINDOW_REG_650_ADDRESS                                             (0xa28 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_650_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_650_RESET                                               0x0

// 0xa2c (DBI_WINDOW_REG_651)
#define DBI_WINDOW_REG_DATA_651_LSB                                            0
#define DBI_WINDOW_REG_DATA_651_MSB                                            31
#define DBI_WINDOW_REG_DATA_651_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_651_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_651_MASK) >> DBI_WINDOW_REG_DATA_651_LSB)
#define DBI_WINDOW_REG_DATA_651_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_651_LSB) & DBI_WINDOW_REG_DATA_651_MASK)
#define DBI_WINDOW_REG_DATA_651_RESET                                          0x0
#define DBI_WINDOW_REG_651_ADDRESS                                             (0xa2c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_651_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_651_RESET                                               0x0

// 0xa30 (DBI_WINDOW_REG_652)
#define DBI_WINDOW_REG_DATA_652_LSB                                            0
#define DBI_WINDOW_REG_DATA_652_MSB                                            31
#define DBI_WINDOW_REG_DATA_652_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_652_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_652_MASK) >> DBI_WINDOW_REG_DATA_652_LSB)
#define DBI_WINDOW_REG_DATA_652_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_652_LSB) & DBI_WINDOW_REG_DATA_652_MASK)
#define DBI_WINDOW_REG_DATA_652_RESET                                          0x0
#define DBI_WINDOW_REG_652_ADDRESS                                             (0xa30 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_652_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_652_RESET                                               0x0

// 0xa34 (DBI_WINDOW_REG_653)
#define DBI_WINDOW_REG_DATA_653_LSB                                            0
#define DBI_WINDOW_REG_DATA_653_MSB                                            31
#define DBI_WINDOW_REG_DATA_653_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_653_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_653_MASK) >> DBI_WINDOW_REG_DATA_653_LSB)
#define DBI_WINDOW_REG_DATA_653_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_653_LSB) & DBI_WINDOW_REG_DATA_653_MASK)
#define DBI_WINDOW_REG_DATA_653_RESET                                          0x0
#define DBI_WINDOW_REG_653_ADDRESS                                             (0xa34 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_653_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_653_RESET                                               0x0

// 0xa38 (DBI_WINDOW_REG_654)
#define DBI_WINDOW_REG_DATA_654_LSB                                            0
#define DBI_WINDOW_REG_DATA_654_MSB                                            31
#define DBI_WINDOW_REG_DATA_654_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_654_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_654_MASK) >> DBI_WINDOW_REG_DATA_654_LSB)
#define DBI_WINDOW_REG_DATA_654_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_654_LSB) & DBI_WINDOW_REG_DATA_654_MASK)
#define DBI_WINDOW_REG_DATA_654_RESET                                          0x0
#define DBI_WINDOW_REG_654_ADDRESS                                             (0xa38 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_654_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_654_RESET                                               0x0

// 0xa3c (DBI_WINDOW_REG_655)
#define DBI_WINDOW_REG_DATA_655_LSB                                            0
#define DBI_WINDOW_REG_DATA_655_MSB                                            31
#define DBI_WINDOW_REG_DATA_655_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_655_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_655_MASK) >> DBI_WINDOW_REG_DATA_655_LSB)
#define DBI_WINDOW_REG_DATA_655_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_655_LSB) & DBI_WINDOW_REG_DATA_655_MASK)
#define DBI_WINDOW_REG_DATA_655_RESET                                          0x0
#define DBI_WINDOW_REG_655_ADDRESS                                             (0xa3c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_655_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_655_RESET                                               0x0

// 0xa40 (DBI_WINDOW_REG_656)
#define DBI_WINDOW_REG_DATA_656_LSB                                            0
#define DBI_WINDOW_REG_DATA_656_MSB                                            31
#define DBI_WINDOW_REG_DATA_656_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_656_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_656_MASK) >> DBI_WINDOW_REG_DATA_656_LSB)
#define DBI_WINDOW_REG_DATA_656_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_656_LSB) & DBI_WINDOW_REG_DATA_656_MASK)
#define DBI_WINDOW_REG_DATA_656_RESET                                          0x0
#define DBI_WINDOW_REG_656_ADDRESS                                             (0xa40 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_656_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_656_RESET                                               0x0

// 0xa44 (DBI_WINDOW_REG_657)
#define DBI_WINDOW_REG_DATA_657_LSB                                            0
#define DBI_WINDOW_REG_DATA_657_MSB                                            31
#define DBI_WINDOW_REG_DATA_657_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_657_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_657_MASK) >> DBI_WINDOW_REG_DATA_657_LSB)
#define DBI_WINDOW_REG_DATA_657_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_657_LSB) & DBI_WINDOW_REG_DATA_657_MASK)
#define DBI_WINDOW_REG_DATA_657_RESET                                          0x0
#define DBI_WINDOW_REG_657_ADDRESS                                             (0xa44 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_657_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_657_RESET                                               0x0

// 0xa48 (DBI_WINDOW_REG_658)
#define DBI_WINDOW_REG_DATA_658_LSB                                            0
#define DBI_WINDOW_REG_DATA_658_MSB                                            31
#define DBI_WINDOW_REG_DATA_658_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_658_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_658_MASK) >> DBI_WINDOW_REG_DATA_658_LSB)
#define DBI_WINDOW_REG_DATA_658_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_658_LSB) & DBI_WINDOW_REG_DATA_658_MASK)
#define DBI_WINDOW_REG_DATA_658_RESET                                          0x0
#define DBI_WINDOW_REG_658_ADDRESS                                             (0xa48 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_658_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_658_RESET                                               0x0

// 0xa4c (DBI_WINDOW_REG_659)
#define DBI_WINDOW_REG_DATA_659_LSB                                            0
#define DBI_WINDOW_REG_DATA_659_MSB                                            31
#define DBI_WINDOW_REG_DATA_659_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_659_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_659_MASK) >> DBI_WINDOW_REG_DATA_659_LSB)
#define DBI_WINDOW_REG_DATA_659_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_659_LSB) & DBI_WINDOW_REG_DATA_659_MASK)
#define DBI_WINDOW_REG_DATA_659_RESET                                          0x0
#define DBI_WINDOW_REG_659_ADDRESS                                             (0xa4c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_659_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_659_RESET                                               0x0

// 0xa50 (DBI_WINDOW_REG_660)
#define DBI_WINDOW_REG_DATA_660_LSB                                            0
#define DBI_WINDOW_REG_DATA_660_MSB                                            31
#define DBI_WINDOW_REG_DATA_660_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_660_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_660_MASK) >> DBI_WINDOW_REG_DATA_660_LSB)
#define DBI_WINDOW_REG_DATA_660_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_660_LSB) & DBI_WINDOW_REG_DATA_660_MASK)
#define DBI_WINDOW_REG_DATA_660_RESET                                          0x0
#define DBI_WINDOW_REG_660_ADDRESS                                             (0xa50 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_660_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_660_RESET                                               0x0

// 0xa54 (DBI_WINDOW_REG_661)
#define DBI_WINDOW_REG_DATA_661_LSB                                            0
#define DBI_WINDOW_REG_DATA_661_MSB                                            31
#define DBI_WINDOW_REG_DATA_661_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_661_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_661_MASK) >> DBI_WINDOW_REG_DATA_661_LSB)
#define DBI_WINDOW_REG_DATA_661_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_661_LSB) & DBI_WINDOW_REG_DATA_661_MASK)
#define DBI_WINDOW_REG_DATA_661_RESET                                          0x0
#define DBI_WINDOW_REG_661_ADDRESS                                             (0xa54 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_661_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_661_RESET                                               0x0

// 0xa58 (DBI_WINDOW_REG_662)
#define DBI_WINDOW_REG_DATA_662_LSB                                            0
#define DBI_WINDOW_REG_DATA_662_MSB                                            31
#define DBI_WINDOW_REG_DATA_662_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_662_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_662_MASK) >> DBI_WINDOW_REG_DATA_662_LSB)
#define DBI_WINDOW_REG_DATA_662_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_662_LSB) & DBI_WINDOW_REG_DATA_662_MASK)
#define DBI_WINDOW_REG_DATA_662_RESET                                          0x0
#define DBI_WINDOW_REG_662_ADDRESS                                             (0xa58 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_662_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_662_RESET                                               0x0

// 0xa5c (DBI_WINDOW_REG_663)
#define DBI_WINDOW_REG_DATA_663_LSB                                            0
#define DBI_WINDOW_REG_DATA_663_MSB                                            31
#define DBI_WINDOW_REG_DATA_663_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_663_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_663_MASK) >> DBI_WINDOW_REG_DATA_663_LSB)
#define DBI_WINDOW_REG_DATA_663_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_663_LSB) & DBI_WINDOW_REG_DATA_663_MASK)
#define DBI_WINDOW_REG_DATA_663_RESET                                          0x0
#define DBI_WINDOW_REG_663_ADDRESS                                             (0xa5c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_663_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_663_RESET                                               0x0

// 0xa60 (DBI_WINDOW_REG_664)
#define DBI_WINDOW_REG_DATA_664_LSB                                            0
#define DBI_WINDOW_REG_DATA_664_MSB                                            31
#define DBI_WINDOW_REG_DATA_664_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_664_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_664_MASK) >> DBI_WINDOW_REG_DATA_664_LSB)
#define DBI_WINDOW_REG_DATA_664_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_664_LSB) & DBI_WINDOW_REG_DATA_664_MASK)
#define DBI_WINDOW_REG_DATA_664_RESET                                          0x0
#define DBI_WINDOW_REG_664_ADDRESS                                             (0xa60 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_664_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_664_RESET                                               0x0

// 0xa64 (DBI_WINDOW_REG_665)
#define DBI_WINDOW_REG_DATA_665_LSB                                            0
#define DBI_WINDOW_REG_DATA_665_MSB                                            31
#define DBI_WINDOW_REG_DATA_665_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_665_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_665_MASK) >> DBI_WINDOW_REG_DATA_665_LSB)
#define DBI_WINDOW_REG_DATA_665_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_665_LSB) & DBI_WINDOW_REG_DATA_665_MASK)
#define DBI_WINDOW_REG_DATA_665_RESET                                          0x0
#define DBI_WINDOW_REG_665_ADDRESS                                             (0xa64 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_665_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_665_RESET                                               0x0

// 0xa68 (DBI_WINDOW_REG_666)
#define DBI_WINDOW_REG_DATA_666_LSB                                            0
#define DBI_WINDOW_REG_DATA_666_MSB                                            31
#define DBI_WINDOW_REG_DATA_666_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_666_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_666_MASK) >> DBI_WINDOW_REG_DATA_666_LSB)
#define DBI_WINDOW_REG_DATA_666_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_666_LSB) & DBI_WINDOW_REG_DATA_666_MASK)
#define DBI_WINDOW_REG_DATA_666_RESET                                          0x0
#define DBI_WINDOW_REG_666_ADDRESS                                             (0xa68 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_666_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_666_RESET                                               0x0

// 0xa6c (DBI_WINDOW_REG_667)
#define DBI_WINDOW_REG_DATA_667_LSB                                            0
#define DBI_WINDOW_REG_DATA_667_MSB                                            31
#define DBI_WINDOW_REG_DATA_667_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_667_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_667_MASK) >> DBI_WINDOW_REG_DATA_667_LSB)
#define DBI_WINDOW_REG_DATA_667_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_667_LSB) & DBI_WINDOW_REG_DATA_667_MASK)
#define DBI_WINDOW_REG_DATA_667_RESET                                          0x0
#define DBI_WINDOW_REG_667_ADDRESS                                             (0xa6c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_667_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_667_RESET                                               0x0

// 0xa70 (DBI_WINDOW_REG_668)
#define DBI_WINDOW_REG_DATA_668_LSB                                            0
#define DBI_WINDOW_REG_DATA_668_MSB                                            31
#define DBI_WINDOW_REG_DATA_668_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_668_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_668_MASK) >> DBI_WINDOW_REG_DATA_668_LSB)
#define DBI_WINDOW_REG_DATA_668_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_668_LSB) & DBI_WINDOW_REG_DATA_668_MASK)
#define DBI_WINDOW_REG_DATA_668_RESET                                          0x0
#define DBI_WINDOW_REG_668_ADDRESS                                             (0xa70 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_668_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_668_RESET                                               0x0

// 0xa74 (DBI_WINDOW_REG_669)
#define DBI_WINDOW_REG_DATA_669_LSB                                            0
#define DBI_WINDOW_REG_DATA_669_MSB                                            31
#define DBI_WINDOW_REG_DATA_669_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_669_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_669_MASK) >> DBI_WINDOW_REG_DATA_669_LSB)
#define DBI_WINDOW_REG_DATA_669_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_669_LSB) & DBI_WINDOW_REG_DATA_669_MASK)
#define DBI_WINDOW_REG_DATA_669_RESET                                          0x0
#define DBI_WINDOW_REG_669_ADDRESS                                             (0xa74 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_669_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_669_RESET                                               0x0

// 0xa78 (DBI_WINDOW_REG_670)
#define DBI_WINDOW_REG_DATA_670_LSB                                            0
#define DBI_WINDOW_REG_DATA_670_MSB                                            31
#define DBI_WINDOW_REG_DATA_670_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_670_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_670_MASK) >> DBI_WINDOW_REG_DATA_670_LSB)
#define DBI_WINDOW_REG_DATA_670_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_670_LSB) & DBI_WINDOW_REG_DATA_670_MASK)
#define DBI_WINDOW_REG_DATA_670_RESET                                          0x0
#define DBI_WINDOW_REG_670_ADDRESS                                             (0xa78 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_670_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_670_RESET                                               0x0

// 0xa7c (DBI_WINDOW_REG_671)
#define DBI_WINDOW_REG_DATA_671_LSB                                            0
#define DBI_WINDOW_REG_DATA_671_MSB                                            31
#define DBI_WINDOW_REG_DATA_671_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_671_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_671_MASK) >> DBI_WINDOW_REG_DATA_671_LSB)
#define DBI_WINDOW_REG_DATA_671_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_671_LSB) & DBI_WINDOW_REG_DATA_671_MASK)
#define DBI_WINDOW_REG_DATA_671_RESET                                          0x0
#define DBI_WINDOW_REG_671_ADDRESS                                             (0xa7c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_671_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_671_RESET                                               0x0

// 0xa80 (DBI_WINDOW_REG_672)
#define DBI_WINDOW_REG_DATA_672_LSB                                            0
#define DBI_WINDOW_REG_DATA_672_MSB                                            31
#define DBI_WINDOW_REG_DATA_672_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_672_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_672_MASK) >> DBI_WINDOW_REG_DATA_672_LSB)
#define DBI_WINDOW_REG_DATA_672_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_672_LSB) & DBI_WINDOW_REG_DATA_672_MASK)
#define DBI_WINDOW_REG_DATA_672_RESET                                          0x0
#define DBI_WINDOW_REG_672_ADDRESS                                             (0xa80 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_672_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_672_RESET                                               0x0

// 0xa84 (DBI_WINDOW_REG_673)
#define DBI_WINDOW_REG_DATA_673_LSB                                            0
#define DBI_WINDOW_REG_DATA_673_MSB                                            31
#define DBI_WINDOW_REG_DATA_673_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_673_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_673_MASK) >> DBI_WINDOW_REG_DATA_673_LSB)
#define DBI_WINDOW_REG_DATA_673_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_673_LSB) & DBI_WINDOW_REG_DATA_673_MASK)
#define DBI_WINDOW_REG_DATA_673_RESET                                          0x0
#define DBI_WINDOW_REG_673_ADDRESS                                             (0xa84 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_673_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_673_RESET                                               0x0

// 0xa88 (DBI_WINDOW_REG_674)
#define DBI_WINDOW_REG_DATA_674_LSB                                            0
#define DBI_WINDOW_REG_DATA_674_MSB                                            31
#define DBI_WINDOW_REG_DATA_674_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_674_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_674_MASK) >> DBI_WINDOW_REG_DATA_674_LSB)
#define DBI_WINDOW_REG_DATA_674_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_674_LSB) & DBI_WINDOW_REG_DATA_674_MASK)
#define DBI_WINDOW_REG_DATA_674_RESET                                          0x0
#define DBI_WINDOW_REG_674_ADDRESS                                             (0xa88 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_674_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_674_RESET                                               0x0

// 0xa8c (DBI_WINDOW_REG_675)
#define DBI_WINDOW_REG_DATA_675_LSB                                            0
#define DBI_WINDOW_REG_DATA_675_MSB                                            31
#define DBI_WINDOW_REG_DATA_675_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_675_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_675_MASK) >> DBI_WINDOW_REG_DATA_675_LSB)
#define DBI_WINDOW_REG_DATA_675_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_675_LSB) & DBI_WINDOW_REG_DATA_675_MASK)
#define DBI_WINDOW_REG_DATA_675_RESET                                          0x0
#define DBI_WINDOW_REG_675_ADDRESS                                             (0xa8c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_675_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_675_RESET                                               0x0

// 0xa90 (DBI_WINDOW_REG_676)
#define DBI_WINDOW_REG_DATA_676_LSB                                            0
#define DBI_WINDOW_REG_DATA_676_MSB                                            31
#define DBI_WINDOW_REG_DATA_676_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_676_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_676_MASK) >> DBI_WINDOW_REG_DATA_676_LSB)
#define DBI_WINDOW_REG_DATA_676_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_676_LSB) & DBI_WINDOW_REG_DATA_676_MASK)
#define DBI_WINDOW_REG_DATA_676_RESET                                          0x0
#define DBI_WINDOW_REG_676_ADDRESS                                             (0xa90 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_676_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_676_RESET                                               0x0

// 0xa94 (DBI_WINDOW_REG_677)
#define DBI_WINDOW_REG_DATA_677_LSB                                            0
#define DBI_WINDOW_REG_DATA_677_MSB                                            31
#define DBI_WINDOW_REG_DATA_677_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_677_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_677_MASK) >> DBI_WINDOW_REG_DATA_677_LSB)
#define DBI_WINDOW_REG_DATA_677_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_677_LSB) & DBI_WINDOW_REG_DATA_677_MASK)
#define DBI_WINDOW_REG_DATA_677_RESET                                          0x0
#define DBI_WINDOW_REG_677_ADDRESS                                             (0xa94 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_677_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_677_RESET                                               0x0

// 0xa98 (DBI_WINDOW_REG_678)
#define DBI_WINDOW_REG_DATA_678_LSB                                            0
#define DBI_WINDOW_REG_DATA_678_MSB                                            31
#define DBI_WINDOW_REG_DATA_678_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_678_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_678_MASK) >> DBI_WINDOW_REG_DATA_678_LSB)
#define DBI_WINDOW_REG_DATA_678_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_678_LSB) & DBI_WINDOW_REG_DATA_678_MASK)
#define DBI_WINDOW_REG_DATA_678_RESET                                          0x0
#define DBI_WINDOW_REG_678_ADDRESS                                             (0xa98 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_678_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_678_RESET                                               0x0

// 0xa9c (DBI_WINDOW_REG_679)
#define DBI_WINDOW_REG_DATA_679_LSB                                            0
#define DBI_WINDOW_REG_DATA_679_MSB                                            31
#define DBI_WINDOW_REG_DATA_679_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_679_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_679_MASK) >> DBI_WINDOW_REG_DATA_679_LSB)
#define DBI_WINDOW_REG_DATA_679_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_679_LSB) & DBI_WINDOW_REG_DATA_679_MASK)
#define DBI_WINDOW_REG_DATA_679_RESET                                          0x0
#define DBI_WINDOW_REG_679_ADDRESS                                             (0xa9c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_679_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_679_RESET                                               0x0

// 0xaa0 (DBI_WINDOW_REG_680)
#define DBI_WINDOW_REG_DATA_680_LSB                                            0
#define DBI_WINDOW_REG_DATA_680_MSB                                            31
#define DBI_WINDOW_REG_DATA_680_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_680_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_680_MASK) >> DBI_WINDOW_REG_DATA_680_LSB)
#define DBI_WINDOW_REG_DATA_680_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_680_LSB) & DBI_WINDOW_REG_DATA_680_MASK)
#define DBI_WINDOW_REG_DATA_680_RESET                                          0x0
#define DBI_WINDOW_REG_680_ADDRESS                                             (0xaa0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_680_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_680_RESET                                               0x0

// 0xaa4 (DBI_WINDOW_REG_681)
#define DBI_WINDOW_REG_DATA_681_LSB                                            0
#define DBI_WINDOW_REG_DATA_681_MSB                                            31
#define DBI_WINDOW_REG_DATA_681_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_681_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_681_MASK) >> DBI_WINDOW_REG_DATA_681_LSB)
#define DBI_WINDOW_REG_DATA_681_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_681_LSB) & DBI_WINDOW_REG_DATA_681_MASK)
#define DBI_WINDOW_REG_DATA_681_RESET                                          0x0
#define DBI_WINDOW_REG_681_ADDRESS                                             (0xaa4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_681_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_681_RESET                                               0x0

// 0xaa8 (DBI_WINDOW_REG_682)
#define DBI_WINDOW_REG_DATA_682_LSB                                            0
#define DBI_WINDOW_REG_DATA_682_MSB                                            31
#define DBI_WINDOW_REG_DATA_682_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_682_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_682_MASK) >> DBI_WINDOW_REG_DATA_682_LSB)
#define DBI_WINDOW_REG_DATA_682_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_682_LSB) & DBI_WINDOW_REG_DATA_682_MASK)
#define DBI_WINDOW_REG_DATA_682_RESET                                          0x0
#define DBI_WINDOW_REG_682_ADDRESS                                             (0xaa8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_682_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_682_RESET                                               0x0

// 0xaac (DBI_WINDOW_REG_683)
#define DBI_WINDOW_REG_DATA_683_LSB                                            0
#define DBI_WINDOW_REG_DATA_683_MSB                                            31
#define DBI_WINDOW_REG_DATA_683_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_683_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_683_MASK) >> DBI_WINDOW_REG_DATA_683_LSB)
#define DBI_WINDOW_REG_DATA_683_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_683_LSB) & DBI_WINDOW_REG_DATA_683_MASK)
#define DBI_WINDOW_REG_DATA_683_RESET                                          0x0
#define DBI_WINDOW_REG_683_ADDRESS                                             (0xaac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_683_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_683_RESET                                               0x0

// 0xab0 (DBI_WINDOW_REG_684)
#define DBI_WINDOW_REG_DATA_684_LSB                                            0
#define DBI_WINDOW_REG_DATA_684_MSB                                            31
#define DBI_WINDOW_REG_DATA_684_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_684_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_684_MASK) >> DBI_WINDOW_REG_DATA_684_LSB)
#define DBI_WINDOW_REG_DATA_684_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_684_LSB) & DBI_WINDOW_REG_DATA_684_MASK)
#define DBI_WINDOW_REG_DATA_684_RESET                                          0x0
#define DBI_WINDOW_REG_684_ADDRESS                                             (0xab0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_684_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_684_RESET                                               0x0

// 0xab4 (DBI_WINDOW_REG_685)
#define DBI_WINDOW_REG_DATA_685_LSB                                            0
#define DBI_WINDOW_REG_DATA_685_MSB                                            31
#define DBI_WINDOW_REG_DATA_685_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_685_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_685_MASK) >> DBI_WINDOW_REG_DATA_685_LSB)
#define DBI_WINDOW_REG_DATA_685_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_685_LSB) & DBI_WINDOW_REG_DATA_685_MASK)
#define DBI_WINDOW_REG_DATA_685_RESET                                          0x0
#define DBI_WINDOW_REG_685_ADDRESS                                             (0xab4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_685_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_685_RESET                                               0x0

// 0xab8 (DBI_WINDOW_REG_686)
#define DBI_WINDOW_REG_DATA_686_LSB                                            0
#define DBI_WINDOW_REG_DATA_686_MSB                                            31
#define DBI_WINDOW_REG_DATA_686_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_686_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_686_MASK) >> DBI_WINDOW_REG_DATA_686_LSB)
#define DBI_WINDOW_REG_DATA_686_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_686_LSB) & DBI_WINDOW_REG_DATA_686_MASK)
#define DBI_WINDOW_REG_DATA_686_RESET                                          0x0
#define DBI_WINDOW_REG_686_ADDRESS                                             (0xab8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_686_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_686_RESET                                               0x0

// 0xabc (DBI_WINDOW_REG_687)
#define DBI_WINDOW_REG_DATA_687_LSB                                            0
#define DBI_WINDOW_REG_DATA_687_MSB                                            31
#define DBI_WINDOW_REG_DATA_687_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_687_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_687_MASK) >> DBI_WINDOW_REG_DATA_687_LSB)
#define DBI_WINDOW_REG_DATA_687_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_687_LSB) & DBI_WINDOW_REG_DATA_687_MASK)
#define DBI_WINDOW_REG_DATA_687_RESET                                          0x0
#define DBI_WINDOW_REG_687_ADDRESS                                             (0xabc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_687_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_687_RESET                                               0x0

// 0xac0 (DBI_WINDOW_REG_688)
#define DBI_WINDOW_REG_DATA_688_LSB                                            0
#define DBI_WINDOW_REG_DATA_688_MSB                                            31
#define DBI_WINDOW_REG_DATA_688_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_688_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_688_MASK) >> DBI_WINDOW_REG_DATA_688_LSB)
#define DBI_WINDOW_REG_DATA_688_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_688_LSB) & DBI_WINDOW_REG_DATA_688_MASK)
#define DBI_WINDOW_REG_DATA_688_RESET                                          0x0
#define DBI_WINDOW_REG_688_ADDRESS                                             (0xac0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_688_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_688_RESET                                               0x0

// 0xac4 (DBI_WINDOW_REG_689)
#define DBI_WINDOW_REG_DATA_689_LSB                                            0
#define DBI_WINDOW_REG_DATA_689_MSB                                            31
#define DBI_WINDOW_REG_DATA_689_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_689_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_689_MASK) >> DBI_WINDOW_REG_DATA_689_LSB)
#define DBI_WINDOW_REG_DATA_689_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_689_LSB) & DBI_WINDOW_REG_DATA_689_MASK)
#define DBI_WINDOW_REG_DATA_689_RESET                                          0x0
#define DBI_WINDOW_REG_689_ADDRESS                                             (0xac4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_689_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_689_RESET                                               0x0

// 0xac8 (DBI_WINDOW_REG_690)
#define DBI_WINDOW_REG_DATA_690_LSB                                            0
#define DBI_WINDOW_REG_DATA_690_MSB                                            31
#define DBI_WINDOW_REG_DATA_690_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_690_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_690_MASK) >> DBI_WINDOW_REG_DATA_690_LSB)
#define DBI_WINDOW_REG_DATA_690_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_690_LSB) & DBI_WINDOW_REG_DATA_690_MASK)
#define DBI_WINDOW_REG_DATA_690_RESET                                          0x0
#define DBI_WINDOW_REG_690_ADDRESS                                             (0xac8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_690_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_690_RESET                                               0x0

// 0xacc (DBI_WINDOW_REG_691)
#define DBI_WINDOW_REG_DATA_691_LSB                                            0
#define DBI_WINDOW_REG_DATA_691_MSB                                            31
#define DBI_WINDOW_REG_DATA_691_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_691_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_691_MASK) >> DBI_WINDOW_REG_DATA_691_LSB)
#define DBI_WINDOW_REG_DATA_691_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_691_LSB) & DBI_WINDOW_REG_DATA_691_MASK)
#define DBI_WINDOW_REG_DATA_691_RESET                                          0x0
#define DBI_WINDOW_REG_691_ADDRESS                                             (0xacc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_691_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_691_RESET                                               0x0

// 0xad0 (DBI_WINDOW_REG_692)
#define DBI_WINDOW_REG_DATA_692_LSB                                            0
#define DBI_WINDOW_REG_DATA_692_MSB                                            31
#define DBI_WINDOW_REG_DATA_692_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_692_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_692_MASK) >> DBI_WINDOW_REG_DATA_692_LSB)
#define DBI_WINDOW_REG_DATA_692_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_692_LSB) & DBI_WINDOW_REG_DATA_692_MASK)
#define DBI_WINDOW_REG_DATA_692_RESET                                          0x0
#define DBI_WINDOW_REG_692_ADDRESS                                             (0xad0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_692_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_692_RESET                                               0x0

// 0xad4 (DBI_WINDOW_REG_693)
#define DBI_WINDOW_REG_DATA_693_LSB                                            0
#define DBI_WINDOW_REG_DATA_693_MSB                                            31
#define DBI_WINDOW_REG_DATA_693_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_693_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_693_MASK) >> DBI_WINDOW_REG_DATA_693_LSB)
#define DBI_WINDOW_REG_DATA_693_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_693_LSB) & DBI_WINDOW_REG_DATA_693_MASK)
#define DBI_WINDOW_REG_DATA_693_RESET                                          0x0
#define DBI_WINDOW_REG_693_ADDRESS                                             (0xad4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_693_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_693_RESET                                               0x0

// 0xad8 (DBI_WINDOW_REG_694)
#define DBI_WINDOW_REG_DATA_694_LSB                                            0
#define DBI_WINDOW_REG_DATA_694_MSB                                            31
#define DBI_WINDOW_REG_DATA_694_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_694_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_694_MASK) >> DBI_WINDOW_REG_DATA_694_LSB)
#define DBI_WINDOW_REG_DATA_694_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_694_LSB) & DBI_WINDOW_REG_DATA_694_MASK)
#define DBI_WINDOW_REG_DATA_694_RESET                                          0x0
#define DBI_WINDOW_REG_694_ADDRESS                                             (0xad8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_694_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_694_RESET                                               0x0

// 0xadc (DBI_WINDOW_REG_695)
#define DBI_WINDOW_REG_DATA_695_LSB                                            0
#define DBI_WINDOW_REG_DATA_695_MSB                                            31
#define DBI_WINDOW_REG_DATA_695_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_695_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_695_MASK) >> DBI_WINDOW_REG_DATA_695_LSB)
#define DBI_WINDOW_REG_DATA_695_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_695_LSB) & DBI_WINDOW_REG_DATA_695_MASK)
#define DBI_WINDOW_REG_DATA_695_RESET                                          0x0
#define DBI_WINDOW_REG_695_ADDRESS                                             (0xadc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_695_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_695_RESET                                               0x0

// 0xae0 (DBI_WINDOW_REG_696)
#define DBI_WINDOW_REG_DATA_696_LSB                                            0
#define DBI_WINDOW_REG_DATA_696_MSB                                            31
#define DBI_WINDOW_REG_DATA_696_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_696_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_696_MASK) >> DBI_WINDOW_REG_DATA_696_LSB)
#define DBI_WINDOW_REG_DATA_696_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_696_LSB) & DBI_WINDOW_REG_DATA_696_MASK)
#define DBI_WINDOW_REG_DATA_696_RESET                                          0x0
#define DBI_WINDOW_REG_696_ADDRESS                                             (0xae0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_696_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_696_RESET                                               0x0

// 0xae4 (DBI_WINDOW_REG_697)
#define DBI_WINDOW_REG_DATA_697_LSB                                            0
#define DBI_WINDOW_REG_DATA_697_MSB                                            31
#define DBI_WINDOW_REG_DATA_697_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_697_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_697_MASK) >> DBI_WINDOW_REG_DATA_697_LSB)
#define DBI_WINDOW_REG_DATA_697_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_697_LSB) & DBI_WINDOW_REG_DATA_697_MASK)
#define DBI_WINDOW_REG_DATA_697_RESET                                          0x0
#define DBI_WINDOW_REG_697_ADDRESS                                             (0xae4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_697_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_697_RESET                                               0x0

// 0xae8 (DBI_WINDOW_REG_698)
#define DBI_WINDOW_REG_DATA_698_LSB                                            0
#define DBI_WINDOW_REG_DATA_698_MSB                                            31
#define DBI_WINDOW_REG_DATA_698_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_698_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_698_MASK) >> DBI_WINDOW_REG_DATA_698_LSB)
#define DBI_WINDOW_REG_DATA_698_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_698_LSB) & DBI_WINDOW_REG_DATA_698_MASK)
#define DBI_WINDOW_REG_DATA_698_RESET                                          0x0
#define DBI_WINDOW_REG_698_ADDRESS                                             (0xae8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_698_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_698_RESET                                               0x0

// 0xaec (DBI_WINDOW_REG_699)
#define DBI_WINDOW_REG_DATA_699_LSB                                            0
#define DBI_WINDOW_REG_DATA_699_MSB                                            31
#define DBI_WINDOW_REG_DATA_699_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_699_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_699_MASK) >> DBI_WINDOW_REG_DATA_699_LSB)
#define DBI_WINDOW_REG_DATA_699_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_699_LSB) & DBI_WINDOW_REG_DATA_699_MASK)
#define DBI_WINDOW_REG_DATA_699_RESET                                          0x0
#define DBI_WINDOW_REG_699_ADDRESS                                             (0xaec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_699_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_699_RESET                                               0x0

// 0xaf0 (DBI_WINDOW_REG_700)
#define DBI_WINDOW_REG_DATA_700_LSB                                            0
#define DBI_WINDOW_REG_DATA_700_MSB                                            31
#define DBI_WINDOW_REG_DATA_700_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_700_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_700_MASK) >> DBI_WINDOW_REG_DATA_700_LSB)
#define DBI_WINDOW_REG_DATA_700_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_700_LSB) & DBI_WINDOW_REG_DATA_700_MASK)
#define DBI_WINDOW_REG_DATA_700_RESET                                          0x0
#define DBI_WINDOW_REG_700_ADDRESS                                             (0xaf0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_700_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_700_RESET                                               0x0

// 0xaf4 (DBI_WINDOW_REG_701)
#define DBI_WINDOW_REG_DATA_701_LSB                                            0
#define DBI_WINDOW_REG_DATA_701_MSB                                            31
#define DBI_WINDOW_REG_DATA_701_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_701_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_701_MASK) >> DBI_WINDOW_REG_DATA_701_LSB)
#define DBI_WINDOW_REG_DATA_701_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_701_LSB) & DBI_WINDOW_REG_DATA_701_MASK)
#define DBI_WINDOW_REG_DATA_701_RESET                                          0x0
#define DBI_WINDOW_REG_701_ADDRESS                                             (0xaf4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_701_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_701_RESET                                               0x0

// 0xaf8 (DBI_WINDOW_REG_702)
#define DBI_WINDOW_REG_DATA_702_LSB                                            0
#define DBI_WINDOW_REG_DATA_702_MSB                                            31
#define DBI_WINDOW_REG_DATA_702_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_702_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_702_MASK) >> DBI_WINDOW_REG_DATA_702_LSB)
#define DBI_WINDOW_REG_DATA_702_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_702_LSB) & DBI_WINDOW_REG_DATA_702_MASK)
#define DBI_WINDOW_REG_DATA_702_RESET                                          0x0
#define DBI_WINDOW_REG_702_ADDRESS                                             (0xaf8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_702_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_702_RESET                                               0x0

// 0xafc (DBI_WINDOW_REG_703)
#define DBI_WINDOW_REG_DATA_703_LSB                                            0
#define DBI_WINDOW_REG_DATA_703_MSB                                            31
#define DBI_WINDOW_REG_DATA_703_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_703_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_703_MASK) >> DBI_WINDOW_REG_DATA_703_LSB)
#define DBI_WINDOW_REG_DATA_703_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_703_LSB) & DBI_WINDOW_REG_DATA_703_MASK)
#define DBI_WINDOW_REG_DATA_703_RESET                                          0x0
#define DBI_WINDOW_REG_703_ADDRESS                                             (0xafc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_703_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_703_RESET                                               0x0

// 0xb00 (DBI_WINDOW_REG_704)
#define DBI_WINDOW_REG_DATA_704_LSB                                            0
#define DBI_WINDOW_REG_DATA_704_MSB                                            31
#define DBI_WINDOW_REG_DATA_704_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_704_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_704_MASK) >> DBI_WINDOW_REG_DATA_704_LSB)
#define DBI_WINDOW_REG_DATA_704_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_704_LSB) & DBI_WINDOW_REG_DATA_704_MASK)
#define DBI_WINDOW_REG_DATA_704_RESET                                          0x0
#define DBI_WINDOW_REG_704_ADDRESS                                             (0xb00 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_704_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_704_RESET                                               0x0

// 0xb04 (DBI_WINDOW_REG_705)
#define DBI_WINDOW_REG_DATA_705_LSB                                            0
#define DBI_WINDOW_REG_DATA_705_MSB                                            31
#define DBI_WINDOW_REG_DATA_705_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_705_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_705_MASK) >> DBI_WINDOW_REG_DATA_705_LSB)
#define DBI_WINDOW_REG_DATA_705_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_705_LSB) & DBI_WINDOW_REG_DATA_705_MASK)
#define DBI_WINDOW_REG_DATA_705_RESET                                          0x0
#define DBI_WINDOW_REG_705_ADDRESS                                             (0xb04 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_705_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_705_RESET                                               0x0

// 0xb08 (DBI_WINDOW_REG_706)
#define DBI_WINDOW_REG_DATA_706_LSB                                            0
#define DBI_WINDOW_REG_DATA_706_MSB                                            31
#define DBI_WINDOW_REG_DATA_706_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_706_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_706_MASK) >> DBI_WINDOW_REG_DATA_706_LSB)
#define DBI_WINDOW_REG_DATA_706_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_706_LSB) & DBI_WINDOW_REG_DATA_706_MASK)
#define DBI_WINDOW_REG_DATA_706_RESET                                          0x0
#define DBI_WINDOW_REG_706_ADDRESS                                             (0xb08 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_706_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_706_RESET                                               0x0

// 0xb0c (DBI_WINDOW_REG_707)
#define DBI_WINDOW_REG_DATA_707_LSB                                            0
#define DBI_WINDOW_REG_DATA_707_MSB                                            31
#define DBI_WINDOW_REG_DATA_707_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_707_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_707_MASK) >> DBI_WINDOW_REG_DATA_707_LSB)
#define DBI_WINDOW_REG_DATA_707_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_707_LSB) & DBI_WINDOW_REG_DATA_707_MASK)
#define DBI_WINDOW_REG_DATA_707_RESET                                          0x0
#define DBI_WINDOW_REG_707_ADDRESS                                             (0xb0c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_707_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_707_RESET                                               0x0

// 0xb10 (DBI_WINDOW_REG_708)
#define DBI_WINDOW_REG_DATA_708_LSB                                            0
#define DBI_WINDOW_REG_DATA_708_MSB                                            31
#define DBI_WINDOW_REG_DATA_708_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_708_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_708_MASK) >> DBI_WINDOW_REG_DATA_708_LSB)
#define DBI_WINDOW_REG_DATA_708_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_708_LSB) & DBI_WINDOW_REG_DATA_708_MASK)
#define DBI_WINDOW_REG_DATA_708_RESET                                          0x0
#define DBI_WINDOW_REG_708_ADDRESS                                             (0xb10 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_708_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_708_RESET                                               0x0

// 0xb14 (DBI_WINDOW_REG_709)
#define DBI_WINDOW_REG_DATA_709_LSB                                            0
#define DBI_WINDOW_REG_DATA_709_MSB                                            31
#define DBI_WINDOW_REG_DATA_709_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_709_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_709_MASK) >> DBI_WINDOW_REG_DATA_709_LSB)
#define DBI_WINDOW_REG_DATA_709_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_709_LSB) & DBI_WINDOW_REG_DATA_709_MASK)
#define DBI_WINDOW_REG_DATA_709_RESET                                          0x0
#define DBI_WINDOW_REG_709_ADDRESS                                             (0xb14 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_709_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_709_RESET                                               0x0

// 0xb18 (DBI_WINDOW_REG_710)
#define DBI_WINDOW_REG_DATA_710_LSB                                            0
#define DBI_WINDOW_REG_DATA_710_MSB                                            31
#define DBI_WINDOW_REG_DATA_710_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_710_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_710_MASK) >> DBI_WINDOW_REG_DATA_710_LSB)
#define DBI_WINDOW_REG_DATA_710_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_710_LSB) & DBI_WINDOW_REG_DATA_710_MASK)
#define DBI_WINDOW_REG_DATA_710_RESET                                          0x0
#define DBI_WINDOW_REG_710_ADDRESS                                             (0xb18 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_710_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_710_RESET                                               0x0

// 0xb1c (DBI_WINDOW_REG_711)
#define DBI_WINDOW_REG_DATA_711_LSB                                            0
#define DBI_WINDOW_REG_DATA_711_MSB                                            31
#define DBI_WINDOW_REG_DATA_711_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_711_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_711_MASK) >> DBI_WINDOW_REG_DATA_711_LSB)
#define DBI_WINDOW_REG_DATA_711_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_711_LSB) & DBI_WINDOW_REG_DATA_711_MASK)
#define DBI_WINDOW_REG_DATA_711_RESET                                          0x0
#define DBI_WINDOW_REG_711_ADDRESS                                             (0xb1c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_711_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_711_RESET                                               0x0

// 0xb20 (DBI_WINDOW_REG_712)
#define DBI_WINDOW_REG_DATA_712_LSB                                            0
#define DBI_WINDOW_REG_DATA_712_MSB                                            31
#define DBI_WINDOW_REG_DATA_712_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_712_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_712_MASK) >> DBI_WINDOW_REG_DATA_712_LSB)
#define DBI_WINDOW_REG_DATA_712_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_712_LSB) & DBI_WINDOW_REG_DATA_712_MASK)
#define DBI_WINDOW_REG_DATA_712_RESET                                          0x0
#define DBI_WINDOW_REG_712_ADDRESS                                             (0xb20 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_712_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_712_RESET                                               0x0

// 0xb24 (DBI_WINDOW_REG_713)
#define DBI_WINDOW_REG_DATA_713_LSB                                            0
#define DBI_WINDOW_REG_DATA_713_MSB                                            31
#define DBI_WINDOW_REG_DATA_713_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_713_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_713_MASK) >> DBI_WINDOW_REG_DATA_713_LSB)
#define DBI_WINDOW_REG_DATA_713_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_713_LSB) & DBI_WINDOW_REG_DATA_713_MASK)
#define DBI_WINDOW_REG_DATA_713_RESET                                          0x0
#define DBI_WINDOW_REG_713_ADDRESS                                             (0xb24 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_713_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_713_RESET                                               0x0

// 0xb28 (DBI_WINDOW_REG_714)
#define DBI_WINDOW_REG_DATA_714_LSB                                            0
#define DBI_WINDOW_REG_DATA_714_MSB                                            31
#define DBI_WINDOW_REG_DATA_714_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_714_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_714_MASK) >> DBI_WINDOW_REG_DATA_714_LSB)
#define DBI_WINDOW_REG_DATA_714_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_714_LSB) & DBI_WINDOW_REG_DATA_714_MASK)
#define DBI_WINDOW_REG_DATA_714_RESET                                          0x0
#define DBI_WINDOW_REG_714_ADDRESS                                             (0xb28 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_714_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_714_RESET                                               0x0

// 0xb2c (DBI_WINDOW_REG_715)
#define DBI_WINDOW_REG_DATA_715_LSB                                            0
#define DBI_WINDOW_REG_DATA_715_MSB                                            31
#define DBI_WINDOW_REG_DATA_715_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_715_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_715_MASK) >> DBI_WINDOW_REG_DATA_715_LSB)
#define DBI_WINDOW_REG_DATA_715_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_715_LSB) & DBI_WINDOW_REG_DATA_715_MASK)
#define DBI_WINDOW_REG_DATA_715_RESET                                          0x0
#define DBI_WINDOW_REG_715_ADDRESS                                             (0xb2c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_715_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_715_RESET                                               0x0

// 0xb30 (DBI_WINDOW_REG_716)
#define DBI_WINDOW_REG_DATA_716_LSB                                            0
#define DBI_WINDOW_REG_DATA_716_MSB                                            31
#define DBI_WINDOW_REG_DATA_716_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_716_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_716_MASK) >> DBI_WINDOW_REG_DATA_716_LSB)
#define DBI_WINDOW_REG_DATA_716_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_716_LSB) & DBI_WINDOW_REG_DATA_716_MASK)
#define DBI_WINDOW_REG_DATA_716_RESET                                          0x0
#define DBI_WINDOW_REG_716_ADDRESS                                             (0xb30 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_716_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_716_RESET                                               0x0

// 0xb34 (DBI_WINDOW_REG_717)
#define DBI_WINDOW_REG_DATA_717_LSB                                            0
#define DBI_WINDOW_REG_DATA_717_MSB                                            31
#define DBI_WINDOW_REG_DATA_717_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_717_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_717_MASK) >> DBI_WINDOW_REG_DATA_717_LSB)
#define DBI_WINDOW_REG_DATA_717_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_717_LSB) & DBI_WINDOW_REG_DATA_717_MASK)
#define DBI_WINDOW_REG_DATA_717_RESET                                          0x0
#define DBI_WINDOW_REG_717_ADDRESS                                             (0xb34 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_717_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_717_RESET                                               0x0

// 0xb38 (DBI_WINDOW_REG_718)
#define DBI_WINDOW_REG_DATA_718_LSB                                            0
#define DBI_WINDOW_REG_DATA_718_MSB                                            31
#define DBI_WINDOW_REG_DATA_718_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_718_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_718_MASK) >> DBI_WINDOW_REG_DATA_718_LSB)
#define DBI_WINDOW_REG_DATA_718_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_718_LSB) & DBI_WINDOW_REG_DATA_718_MASK)
#define DBI_WINDOW_REG_DATA_718_RESET                                          0x0
#define DBI_WINDOW_REG_718_ADDRESS                                             (0xb38 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_718_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_718_RESET                                               0x0

// 0xb3c (DBI_WINDOW_REG_719)
#define DBI_WINDOW_REG_DATA_719_LSB                                            0
#define DBI_WINDOW_REG_DATA_719_MSB                                            31
#define DBI_WINDOW_REG_DATA_719_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_719_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_719_MASK) >> DBI_WINDOW_REG_DATA_719_LSB)
#define DBI_WINDOW_REG_DATA_719_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_719_LSB) & DBI_WINDOW_REG_DATA_719_MASK)
#define DBI_WINDOW_REG_DATA_719_RESET                                          0x0
#define DBI_WINDOW_REG_719_ADDRESS                                             (0xb3c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_719_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_719_RESET                                               0x0

// 0xb40 (DBI_WINDOW_REG_720)
#define DBI_WINDOW_REG_DATA_720_LSB                                            0
#define DBI_WINDOW_REG_DATA_720_MSB                                            31
#define DBI_WINDOW_REG_DATA_720_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_720_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_720_MASK) >> DBI_WINDOW_REG_DATA_720_LSB)
#define DBI_WINDOW_REG_DATA_720_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_720_LSB) & DBI_WINDOW_REG_DATA_720_MASK)
#define DBI_WINDOW_REG_DATA_720_RESET                                          0x0
#define DBI_WINDOW_REG_720_ADDRESS                                             (0xb40 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_720_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_720_RESET                                               0x0

// 0xb44 (DBI_WINDOW_REG_721)
#define DBI_WINDOW_REG_DATA_721_LSB                                            0
#define DBI_WINDOW_REG_DATA_721_MSB                                            31
#define DBI_WINDOW_REG_DATA_721_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_721_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_721_MASK) >> DBI_WINDOW_REG_DATA_721_LSB)
#define DBI_WINDOW_REG_DATA_721_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_721_LSB) & DBI_WINDOW_REG_DATA_721_MASK)
#define DBI_WINDOW_REG_DATA_721_RESET                                          0x0
#define DBI_WINDOW_REG_721_ADDRESS                                             (0xb44 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_721_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_721_RESET                                               0x0

// 0xb48 (DBI_WINDOW_REG_722)
#define DBI_WINDOW_REG_DATA_722_LSB                                            0
#define DBI_WINDOW_REG_DATA_722_MSB                                            31
#define DBI_WINDOW_REG_DATA_722_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_722_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_722_MASK) >> DBI_WINDOW_REG_DATA_722_LSB)
#define DBI_WINDOW_REG_DATA_722_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_722_LSB) & DBI_WINDOW_REG_DATA_722_MASK)
#define DBI_WINDOW_REG_DATA_722_RESET                                          0x0
#define DBI_WINDOW_REG_722_ADDRESS                                             (0xb48 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_722_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_722_RESET                                               0x0

// 0xb4c (DBI_WINDOW_REG_723)
#define DBI_WINDOW_REG_DATA_723_LSB                                            0
#define DBI_WINDOW_REG_DATA_723_MSB                                            31
#define DBI_WINDOW_REG_DATA_723_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_723_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_723_MASK) >> DBI_WINDOW_REG_DATA_723_LSB)
#define DBI_WINDOW_REG_DATA_723_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_723_LSB) & DBI_WINDOW_REG_DATA_723_MASK)
#define DBI_WINDOW_REG_DATA_723_RESET                                          0x0
#define DBI_WINDOW_REG_723_ADDRESS                                             (0xb4c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_723_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_723_RESET                                               0x0

// 0xb50 (DBI_WINDOW_REG_724)
#define DBI_WINDOW_REG_DATA_724_LSB                                            0
#define DBI_WINDOW_REG_DATA_724_MSB                                            31
#define DBI_WINDOW_REG_DATA_724_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_724_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_724_MASK) >> DBI_WINDOW_REG_DATA_724_LSB)
#define DBI_WINDOW_REG_DATA_724_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_724_LSB) & DBI_WINDOW_REG_DATA_724_MASK)
#define DBI_WINDOW_REG_DATA_724_RESET                                          0x0
#define DBI_WINDOW_REG_724_ADDRESS                                             (0xb50 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_724_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_724_RESET                                               0x0

// 0xb54 (DBI_WINDOW_REG_725)
#define DBI_WINDOW_REG_DATA_725_LSB                                            0
#define DBI_WINDOW_REG_DATA_725_MSB                                            31
#define DBI_WINDOW_REG_DATA_725_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_725_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_725_MASK) >> DBI_WINDOW_REG_DATA_725_LSB)
#define DBI_WINDOW_REG_DATA_725_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_725_LSB) & DBI_WINDOW_REG_DATA_725_MASK)
#define DBI_WINDOW_REG_DATA_725_RESET                                          0x0
#define DBI_WINDOW_REG_725_ADDRESS                                             (0xb54 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_725_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_725_RESET                                               0x0

// 0xb58 (DBI_WINDOW_REG_726)
#define DBI_WINDOW_REG_DATA_726_LSB                                            0
#define DBI_WINDOW_REG_DATA_726_MSB                                            31
#define DBI_WINDOW_REG_DATA_726_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_726_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_726_MASK) >> DBI_WINDOW_REG_DATA_726_LSB)
#define DBI_WINDOW_REG_DATA_726_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_726_LSB) & DBI_WINDOW_REG_DATA_726_MASK)
#define DBI_WINDOW_REG_DATA_726_RESET                                          0x0
#define DBI_WINDOW_REG_726_ADDRESS                                             (0xb58 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_726_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_726_RESET                                               0x0

// 0xb5c (DBI_WINDOW_REG_727)
#define DBI_WINDOW_REG_DATA_727_LSB                                            0
#define DBI_WINDOW_REG_DATA_727_MSB                                            31
#define DBI_WINDOW_REG_DATA_727_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_727_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_727_MASK) >> DBI_WINDOW_REG_DATA_727_LSB)
#define DBI_WINDOW_REG_DATA_727_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_727_LSB) & DBI_WINDOW_REG_DATA_727_MASK)
#define DBI_WINDOW_REG_DATA_727_RESET                                          0x0
#define DBI_WINDOW_REG_727_ADDRESS                                             (0xb5c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_727_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_727_RESET                                               0x0

// 0xb60 (DBI_WINDOW_REG_728)
#define DBI_WINDOW_REG_DATA_728_LSB                                            0
#define DBI_WINDOW_REG_DATA_728_MSB                                            31
#define DBI_WINDOW_REG_DATA_728_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_728_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_728_MASK) >> DBI_WINDOW_REG_DATA_728_LSB)
#define DBI_WINDOW_REG_DATA_728_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_728_LSB) & DBI_WINDOW_REG_DATA_728_MASK)
#define DBI_WINDOW_REG_DATA_728_RESET                                          0x0
#define DBI_WINDOW_REG_728_ADDRESS                                             (0xb60 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_728_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_728_RESET                                               0x0

// 0xb64 (DBI_WINDOW_REG_729)
#define DBI_WINDOW_REG_DATA_729_LSB                                            0
#define DBI_WINDOW_REG_DATA_729_MSB                                            31
#define DBI_WINDOW_REG_DATA_729_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_729_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_729_MASK) >> DBI_WINDOW_REG_DATA_729_LSB)
#define DBI_WINDOW_REG_DATA_729_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_729_LSB) & DBI_WINDOW_REG_DATA_729_MASK)
#define DBI_WINDOW_REG_DATA_729_RESET                                          0x0
#define DBI_WINDOW_REG_729_ADDRESS                                             (0xb64 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_729_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_729_RESET                                               0x0

// 0xb68 (DBI_WINDOW_REG_730)
#define DBI_WINDOW_REG_DATA_730_LSB                                            0
#define DBI_WINDOW_REG_DATA_730_MSB                                            31
#define DBI_WINDOW_REG_DATA_730_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_730_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_730_MASK) >> DBI_WINDOW_REG_DATA_730_LSB)
#define DBI_WINDOW_REG_DATA_730_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_730_LSB) & DBI_WINDOW_REG_DATA_730_MASK)
#define DBI_WINDOW_REG_DATA_730_RESET                                          0x0
#define DBI_WINDOW_REG_730_ADDRESS                                             (0xb68 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_730_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_730_RESET                                               0x0

// 0xb6c (DBI_WINDOW_REG_731)
#define DBI_WINDOW_REG_DATA_731_LSB                                            0
#define DBI_WINDOW_REG_DATA_731_MSB                                            31
#define DBI_WINDOW_REG_DATA_731_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_731_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_731_MASK) >> DBI_WINDOW_REG_DATA_731_LSB)
#define DBI_WINDOW_REG_DATA_731_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_731_LSB) & DBI_WINDOW_REG_DATA_731_MASK)
#define DBI_WINDOW_REG_DATA_731_RESET                                          0x0
#define DBI_WINDOW_REG_731_ADDRESS                                             (0xb6c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_731_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_731_RESET                                               0x0

// 0xb70 (DBI_WINDOW_REG_732)
#define DBI_WINDOW_REG_DATA_732_LSB                                            0
#define DBI_WINDOW_REG_DATA_732_MSB                                            31
#define DBI_WINDOW_REG_DATA_732_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_732_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_732_MASK) >> DBI_WINDOW_REG_DATA_732_LSB)
#define DBI_WINDOW_REG_DATA_732_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_732_LSB) & DBI_WINDOW_REG_DATA_732_MASK)
#define DBI_WINDOW_REG_DATA_732_RESET                                          0x0
#define DBI_WINDOW_REG_732_ADDRESS                                             (0xb70 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_732_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_732_RESET                                               0x0

// 0xb74 (DBI_WINDOW_REG_733)
#define DBI_WINDOW_REG_DATA_733_LSB                                            0
#define DBI_WINDOW_REG_DATA_733_MSB                                            31
#define DBI_WINDOW_REG_DATA_733_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_733_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_733_MASK) >> DBI_WINDOW_REG_DATA_733_LSB)
#define DBI_WINDOW_REG_DATA_733_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_733_LSB) & DBI_WINDOW_REG_DATA_733_MASK)
#define DBI_WINDOW_REG_DATA_733_RESET                                          0x0
#define DBI_WINDOW_REG_733_ADDRESS                                             (0xb74 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_733_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_733_RESET                                               0x0

// 0xb78 (DBI_WINDOW_REG_734)
#define DBI_WINDOW_REG_DATA_734_LSB                                            0
#define DBI_WINDOW_REG_DATA_734_MSB                                            31
#define DBI_WINDOW_REG_DATA_734_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_734_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_734_MASK) >> DBI_WINDOW_REG_DATA_734_LSB)
#define DBI_WINDOW_REG_DATA_734_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_734_LSB) & DBI_WINDOW_REG_DATA_734_MASK)
#define DBI_WINDOW_REG_DATA_734_RESET                                          0x0
#define DBI_WINDOW_REG_734_ADDRESS                                             (0xb78 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_734_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_734_RESET                                               0x0

// 0xb7c (DBI_WINDOW_REG_735)
#define DBI_WINDOW_REG_DATA_735_LSB                                            0
#define DBI_WINDOW_REG_DATA_735_MSB                                            31
#define DBI_WINDOW_REG_DATA_735_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_735_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_735_MASK) >> DBI_WINDOW_REG_DATA_735_LSB)
#define DBI_WINDOW_REG_DATA_735_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_735_LSB) & DBI_WINDOW_REG_DATA_735_MASK)
#define DBI_WINDOW_REG_DATA_735_RESET                                          0x0
#define DBI_WINDOW_REG_735_ADDRESS                                             (0xb7c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_735_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_735_RESET                                               0x0

// 0xb80 (DBI_WINDOW_REG_736)
#define DBI_WINDOW_REG_DATA_736_LSB                                            0
#define DBI_WINDOW_REG_DATA_736_MSB                                            31
#define DBI_WINDOW_REG_DATA_736_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_736_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_736_MASK) >> DBI_WINDOW_REG_DATA_736_LSB)
#define DBI_WINDOW_REG_DATA_736_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_736_LSB) & DBI_WINDOW_REG_DATA_736_MASK)
#define DBI_WINDOW_REG_DATA_736_RESET                                          0x0
#define DBI_WINDOW_REG_736_ADDRESS                                             (0xb80 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_736_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_736_RESET                                               0x0

// 0xb84 (DBI_WINDOW_REG_737)
#define DBI_WINDOW_REG_DATA_737_LSB                                            0
#define DBI_WINDOW_REG_DATA_737_MSB                                            31
#define DBI_WINDOW_REG_DATA_737_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_737_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_737_MASK) >> DBI_WINDOW_REG_DATA_737_LSB)
#define DBI_WINDOW_REG_DATA_737_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_737_LSB) & DBI_WINDOW_REG_DATA_737_MASK)
#define DBI_WINDOW_REG_DATA_737_RESET                                          0x0
#define DBI_WINDOW_REG_737_ADDRESS                                             (0xb84 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_737_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_737_RESET                                               0x0

// 0xb88 (DBI_WINDOW_REG_738)
#define DBI_WINDOW_REG_DATA_738_LSB                                            0
#define DBI_WINDOW_REG_DATA_738_MSB                                            31
#define DBI_WINDOW_REG_DATA_738_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_738_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_738_MASK) >> DBI_WINDOW_REG_DATA_738_LSB)
#define DBI_WINDOW_REG_DATA_738_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_738_LSB) & DBI_WINDOW_REG_DATA_738_MASK)
#define DBI_WINDOW_REG_DATA_738_RESET                                          0x0
#define DBI_WINDOW_REG_738_ADDRESS                                             (0xb88 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_738_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_738_RESET                                               0x0

// 0xb8c (DBI_WINDOW_REG_739)
#define DBI_WINDOW_REG_DATA_739_LSB                                            0
#define DBI_WINDOW_REG_DATA_739_MSB                                            31
#define DBI_WINDOW_REG_DATA_739_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_739_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_739_MASK) >> DBI_WINDOW_REG_DATA_739_LSB)
#define DBI_WINDOW_REG_DATA_739_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_739_LSB) & DBI_WINDOW_REG_DATA_739_MASK)
#define DBI_WINDOW_REG_DATA_739_RESET                                          0x0
#define DBI_WINDOW_REG_739_ADDRESS                                             (0xb8c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_739_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_739_RESET                                               0x0

// 0xb90 (DBI_WINDOW_REG_740)
#define DBI_WINDOW_REG_DATA_740_LSB                                            0
#define DBI_WINDOW_REG_DATA_740_MSB                                            31
#define DBI_WINDOW_REG_DATA_740_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_740_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_740_MASK) >> DBI_WINDOW_REG_DATA_740_LSB)
#define DBI_WINDOW_REG_DATA_740_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_740_LSB) & DBI_WINDOW_REG_DATA_740_MASK)
#define DBI_WINDOW_REG_DATA_740_RESET                                          0x0
#define DBI_WINDOW_REG_740_ADDRESS                                             (0xb90 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_740_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_740_RESET                                               0x0

// 0xb94 (DBI_WINDOW_REG_741)
#define DBI_WINDOW_REG_DATA_741_LSB                                            0
#define DBI_WINDOW_REG_DATA_741_MSB                                            31
#define DBI_WINDOW_REG_DATA_741_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_741_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_741_MASK) >> DBI_WINDOW_REG_DATA_741_LSB)
#define DBI_WINDOW_REG_DATA_741_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_741_LSB) & DBI_WINDOW_REG_DATA_741_MASK)
#define DBI_WINDOW_REG_DATA_741_RESET                                          0x0
#define DBI_WINDOW_REG_741_ADDRESS                                             (0xb94 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_741_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_741_RESET                                               0x0

// 0xb98 (DBI_WINDOW_REG_742)
#define DBI_WINDOW_REG_DATA_742_LSB                                            0
#define DBI_WINDOW_REG_DATA_742_MSB                                            31
#define DBI_WINDOW_REG_DATA_742_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_742_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_742_MASK) >> DBI_WINDOW_REG_DATA_742_LSB)
#define DBI_WINDOW_REG_DATA_742_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_742_LSB) & DBI_WINDOW_REG_DATA_742_MASK)
#define DBI_WINDOW_REG_DATA_742_RESET                                          0x0
#define DBI_WINDOW_REG_742_ADDRESS                                             (0xb98 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_742_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_742_RESET                                               0x0

// 0xb9c (DBI_WINDOW_REG_743)
#define DBI_WINDOW_REG_DATA_743_LSB                                            0
#define DBI_WINDOW_REG_DATA_743_MSB                                            31
#define DBI_WINDOW_REG_DATA_743_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_743_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_743_MASK) >> DBI_WINDOW_REG_DATA_743_LSB)
#define DBI_WINDOW_REG_DATA_743_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_743_LSB) & DBI_WINDOW_REG_DATA_743_MASK)
#define DBI_WINDOW_REG_DATA_743_RESET                                          0x0
#define DBI_WINDOW_REG_743_ADDRESS                                             (0xb9c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_743_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_743_RESET                                               0x0

// 0xba0 (DBI_WINDOW_REG_744)
#define DBI_WINDOW_REG_DATA_744_LSB                                            0
#define DBI_WINDOW_REG_DATA_744_MSB                                            31
#define DBI_WINDOW_REG_DATA_744_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_744_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_744_MASK) >> DBI_WINDOW_REG_DATA_744_LSB)
#define DBI_WINDOW_REG_DATA_744_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_744_LSB) & DBI_WINDOW_REG_DATA_744_MASK)
#define DBI_WINDOW_REG_DATA_744_RESET                                          0x0
#define DBI_WINDOW_REG_744_ADDRESS                                             (0xba0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_744_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_744_RESET                                               0x0

// 0xba4 (DBI_WINDOW_REG_745)
#define DBI_WINDOW_REG_DATA_745_LSB                                            0
#define DBI_WINDOW_REG_DATA_745_MSB                                            31
#define DBI_WINDOW_REG_DATA_745_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_745_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_745_MASK) >> DBI_WINDOW_REG_DATA_745_LSB)
#define DBI_WINDOW_REG_DATA_745_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_745_LSB) & DBI_WINDOW_REG_DATA_745_MASK)
#define DBI_WINDOW_REG_DATA_745_RESET                                          0x0
#define DBI_WINDOW_REG_745_ADDRESS                                             (0xba4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_745_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_745_RESET                                               0x0

// 0xba8 (DBI_WINDOW_REG_746)
#define DBI_WINDOW_REG_DATA_746_LSB                                            0
#define DBI_WINDOW_REG_DATA_746_MSB                                            31
#define DBI_WINDOW_REG_DATA_746_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_746_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_746_MASK) >> DBI_WINDOW_REG_DATA_746_LSB)
#define DBI_WINDOW_REG_DATA_746_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_746_LSB) & DBI_WINDOW_REG_DATA_746_MASK)
#define DBI_WINDOW_REG_DATA_746_RESET                                          0x0
#define DBI_WINDOW_REG_746_ADDRESS                                             (0xba8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_746_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_746_RESET                                               0x0

// 0xbac (DBI_WINDOW_REG_747)
#define DBI_WINDOW_REG_DATA_747_LSB                                            0
#define DBI_WINDOW_REG_DATA_747_MSB                                            31
#define DBI_WINDOW_REG_DATA_747_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_747_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_747_MASK) >> DBI_WINDOW_REG_DATA_747_LSB)
#define DBI_WINDOW_REG_DATA_747_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_747_LSB) & DBI_WINDOW_REG_DATA_747_MASK)
#define DBI_WINDOW_REG_DATA_747_RESET                                          0x0
#define DBI_WINDOW_REG_747_ADDRESS                                             (0xbac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_747_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_747_RESET                                               0x0

// 0xbb0 (DBI_WINDOW_REG_748)
#define DBI_WINDOW_REG_DATA_748_LSB                                            0
#define DBI_WINDOW_REG_DATA_748_MSB                                            31
#define DBI_WINDOW_REG_DATA_748_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_748_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_748_MASK) >> DBI_WINDOW_REG_DATA_748_LSB)
#define DBI_WINDOW_REG_DATA_748_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_748_LSB) & DBI_WINDOW_REG_DATA_748_MASK)
#define DBI_WINDOW_REG_DATA_748_RESET                                          0x0
#define DBI_WINDOW_REG_748_ADDRESS                                             (0xbb0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_748_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_748_RESET                                               0x0

// 0xbb4 (DBI_WINDOW_REG_749)
#define DBI_WINDOW_REG_DATA_749_LSB                                            0
#define DBI_WINDOW_REG_DATA_749_MSB                                            31
#define DBI_WINDOW_REG_DATA_749_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_749_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_749_MASK) >> DBI_WINDOW_REG_DATA_749_LSB)
#define DBI_WINDOW_REG_DATA_749_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_749_LSB) & DBI_WINDOW_REG_DATA_749_MASK)
#define DBI_WINDOW_REG_DATA_749_RESET                                          0x0
#define DBI_WINDOW_REG_749_ADDRESS                                             (0xbb4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_749_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_749_RESET                                               0x0

// 0xbb8 (DBI_WINDOW_REG_750)
#define DBI_WINDOW_REG_DATA_750_LSB                                            0
#define DBI_WINDOW_REG_DATA_750_MSB                                            31
#define DBI_WINDOW_REG_DATA_750_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_750_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_750_MASK) >> DBI_WINDOW_REG_DATA_750_LSB)
#define DBI_WINDOW_REG_DATA_750_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_750_LSB) & DBI_WINDOW_REG_DATA_750_MASK)
#define DBI_WINDOW_REG_DATA_750_RESET                                          0x0
#define DBI_WINDOW_REG_750_ADDRESS                                             (0xbb8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_750_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_750_RESET                                               0x0

// 0xbbc (DBI_WINDOW_REG_751)
#define DBI_WINDOW_REG_DATA_751_LSB                                            0
#define DBI_WINDOW_REG_DATA_751_MSB                                            31
#define DBI_WINDOW_REG_DATA_751_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_751_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_751_MASK) >> DBI_WINDOW_REG_DATA_751_LSB)
#define DBI_WINDOW_REG_DATA_751_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_751_LSB) & DBI_WINDOW_REG_DATA_751_MASK)
#define DBI_WINDOW_REG_DATA_751_RESET                                          0x0
#define DBI_WINDOW_REG_751_ADDRESS                                             (0xbbc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_751_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_751_RESET                                               0x0

// 0xbc0 (DBI_WINDOW_REG_752)
#define DBI_WINDOW_REG_DATA_752_LSB                                            0
#define DBI_WINDOW_REG_DATA_752_MSB                                            31
#define DBI_WINDOW_REG_DATA_752_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_752_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_752_MASK) >> DBI_WINDOW_REG_DATA_752_LSB)
#define DBI_WINDOW_REG_DATA_752_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_752_LSB) & DBI_WINDOW_REG_DATA_752_MASK)
#define DBI_WINDOW_REG_DATA_752_RESET                                          0x0
#define DBI_WINDOW_REG_752_ADDRESS                                             (0xbc0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_752_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_752_RESET                                               0x0

// 0xbc4 (DBI_WINDOW_REG_753)
#define DBI_WINDOW_REG_DATA_753_LSB                                            0
#define DBI_WINDOW_REG_DATA_753_MSB                                            31
#define DBI_WINDOW_REG_DATA_753_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_753_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_753_MASK) >> DBI_WINDOW_REG_DATA_753_LSB)
#define DBI_WINDOW_REG_DATA_753_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_753_LSB) & DBI_WINDOW_REG_DATA_753_MASK)
#define DBI_WINDOW_REG_DATA_753_RESET                                          0x0
#define DBI_WINDOW_REG_753_ADDRESS                                             (0xbc4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_753_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_753_RESET                                               0x0

// 0xbc8 (DBI_WINDOW_REG_754)
#define DBI_WINDOW_REG_DATA_754_LSB                                            0
#define DBI_WINDOW_REG_DATA_754_MSB                                            31
#define DBI_WINDOW_REG_DATA_754_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_754_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_754_MASK) >> DBI_WINDOW_REG_DATA_754_LSB)
#define DBI_WINDOW_REG_DATA_754_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_754_LSB) & DBI_WINDOW_REG_DATA_754_MASK)
#define DBI_WINDOW_REG_DATA_754_RESET                                          0x0
#define DBI_WINDOW_REG_754_ADDRESS                                             (0xbc8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_754_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_754_RESET                                               0x0

// 0xbcc (DBI_WINDOW_REG_755)
#define DBI_WINDOW_REG_DATA_755_LSB                                            0
#define DBI_WINDOW_REG_DATA_755_MSB                                            31
#define DBI_WINDOW_REG_DATA_755_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_755_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_755_MASK) >> DBI_WINDOW_REG_DATA_755_LSB)
#define DBI_WINDOW_REG_DATA_755_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_755_LSB) & DBI_WINDOW_REG_DATA_755_MASK)
#define DBI_WINDOW_REG_DATA_755_RESET                                          0x0
#define DBI_WINDOW_REG_755_ADDRESS                                             (0xbcc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_755_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_755_RESET                                               0x0

// 0xbd0 (DBI_WINDOW_REG_756)
#define DBI_WINDOW_REG_DATA_756_LSB                                            0
#define DBI_WINDOW_REG_DATA_756_MSB                                            31
#define DBI_WINDOW_REG_DATA_756_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_756_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_756_MASK) >> DBI_WINDOW_REG_DATA_756_LSB)
#define DBI_WINDOW_REG_DATA_756_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_756_LSB) & DBI_WINDOW_REG_DATA_756_MASK)
#define DBI_WINDOW_REG_DATA_756_RESET                                          0x0
#define DBI_WINDOW_REG_756_ADDRESS                                             (0xbd0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_756_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_756_RESET                                               0x0

// 0xbd4 (DBI_WINDOW_REG_757)
#define DBI_WINDOW_REG_DATA_757_LSB                                            0
#define DBI_WINDOW_REG_DATA_757_MSB                                            31
#define DBI_WINDOW_REG_DATA_757_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_757_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_757_MASK) >> DBI_WINDOW_REG_DATA_757_LSB)
#define DBI_WINDOW_REG_DATA_757_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_757_LSB) & DBI_WINDOW_REG_DATA_757_MASK)
#define DBI_WINDOW_REG_DATA_757_RESET                                          0x0
#define DBI_WINDOW_REG_757_ADDRESS                                             (0xbd4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_757_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_757_RESET                                               0x0

// 0xbd8 (DBI_WINDOW_REG_758)
#define DBI_WINDOW_REG_DATA_758_LSB                                            0
#define DBI_WINDOW_REG_DATA_758_MSB                                            31
#define DBI_WINDOW_REG_DATA_758_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_758_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_758_MASK) >> DBI_WINDOW_REG_DATA_758_LSB)
#define DBI_WINDOW_REG_DATA_758_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_758_LSB) & DBI_WINDOW_REG_DATA_758_MASK)
#define DBI_WINDOW_REG_DATA_758_RESET                                          0x0
#define DBI_WINDOW_REG_758_ADDRESS                                             (0xbd8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_758_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_758_RESET                                               0x0

// 0xbdc (DBI_WINDOW_REG_759)
#define DBI_WINDOW_REG_DATA_759_LSB                                            0
#define DBI_WINDOW_REG_DATA_759_MSB                                            31
#define DBI_WINDOW_REG_DATA_759_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_759_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_759_MASK) >> DBI_WINDOW_REG_DATA_759_LSB)
#define DBI_WINDOW_REG_DATA_759_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_759_LSB) & DBI_WINDOW_REG_DATA_759_MASK)
#define DBI_WINDOW_REG_DATA_759_RESET                                          0x0
#define DBI_WINDOW_REG_759_ADDRESS                                             (0xbdc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_759_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_759_RESET                                               0x0

// 0xbe0 (DBI_WINDOW_REG_760)
#define DBI_WINDOW_REG_DATA_760_LSB                                            0
#define DBI_WINDOW_REG_DATA_760_MSB                                            31
#define DBI_WINDOW_REG_DATA_760_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_760_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_760_MASK) >> DBI_WINDOW_REG_DATA_760_LSB)
#define DBI_WINDOW_REG_DATA_760_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_760_LSB) & DBI_WINDOW_REG_DATA_760_MASK)
#define DBI_WINDOW_REG_DATA_760_RESET                                          0x0
#define DBI_WINDOW_REG_760_ADDRESS                                             (0xbe0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_760_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_760_RESET                                               0x0

// 0xbe4 (DBI_WINDOW_REG_761)
#define DBI_WINDOW_REG_DATA_761_LSB                                            0
#define DBI_WINDOW_REG_DATA_761_MSB                                            31
#define DBI_WINDOW_REG_DATA_761_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_761_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_761_MASK) >> DBI_WINDOW_REG_DATA_761_LSB)
#define DBI_WINDOW_REG_DATA_761_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_761_LSB) & DBI_WINDOW_REG_DATA_761_MASK)
#define DBI_WINDOW_REG_DATA_761_RESET                                          0x0
#define DBI_WINDOW_REG_761_ADDRESS                                             (0xbe4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_761_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_761_RESET                                               0x0

// 0xbe8 (DBI_WINDOW_REG_762)
#define DBI_WINDOW_REG_DATA_762_LSB                                            0
#define DBI_WINDOW_REG_DATA_762_MSB                                            31
#define DBI_WINDOW_REG_DATA_762_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_762_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_762_MASK) >> DBI_WINDOW_REG_DATA_762_LSB)
#define DBI_WINDOW_REG_DATA_762_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_762_LSB) & DBI_WINDOW_REG_DATA_762_MASK)
#define DBI_WINDOW_REG_DATA_762_RESET                                          0x0
#define DBI_WINDOW_REG_762_ADDRESS                                             (0xbe8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_762_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_762_RESET                                               0x0

// 0xbec (DBI_WINDOW_REG_763)
#define DBI_WINDOW_REG_DATA_763_LSB                                            0
#define DBI_WINDOW_REG_DATA_763_MSB                                            31
#define DBI_WINDOW_REG_DATA_763_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_763_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_763_MASK) >> DBI_WINDOW_REG_DATA_763_LSB)
#define DBI_WINDOW_REG_DATA_763_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_763_LSB) & DBI_WINDOW_REG_DATA_763_MASK)
#define DBI_WINDOW_REG_DATA_763_RESET                                          0x0
#define DBI_WINDOW_REG_763_ADDRESS                                             (0xbec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_763_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_763_RESET                                               0x0

// 0xbf0 (DBI_WINDOW_REG_764)
#define DBI_WINDOW_REG_DATA_764_LSB                                            0
#define DBI_WINDOW_REG_DATA_764_MSB                                            31
#define DBI_WINDOW_REG_DATA_764_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_764_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_764_MASK) >> DBI_WINDOW_REG_DATA_764_LSB)
#define DBI_WINDOW_REG_DATA_764_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_764_LSB) & DBI_WINDOW_REG_DATA_764_MASK)
#define DBI_WINDOW_REG_DATA_764_RESET                                          0x0
#define DBI_WINDOW_REG_764_ADDRESS                                             (0xbf0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_764_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_764_RESET                                               0x0

// 0xbf4 (DBI_WINDOW_REG_765)
#define DBI_WINDOW_REG_DATA_765_LSB                                            0
#define DBI_WINDOW_REG_DATA_765_MSB                                            31
#define DBI_WINDOW_REG_DATA_765_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_765_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_765_MASK) >> DBI_WINDOW_REG_DATA_765_LSB)
#define DBI_WINDOW_REG_DATA_765_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_765_LSB) & DBI_WINDOW_REG_DATA_765_MASK)
#define DBI_WINDOW_REG_DATA_765_RESET                                          0x0
#define DBI_WINDOW_REG_765_ADDRESS                                             (0xbf4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_765_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_765_RESET                                               0x0

// 0xbf8 (DBI_WINDOW_REG_766)
#define DBI_WINDOW_REG_DATA_766_LSB                                            0
#define DBI_WINDOW_REG_DATA_766_MSB                                            31
#define DBI_WINDOW_REG_DATA_766_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_766_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_766_MASK) >> DBI_WINDOW_REG_DATA_766_LSB)
#define DBI_WINDOW_REG_DATA_766_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_766_LSB) & DBI_WINDOW_REG_DATA_766_MASK)
#define DBI_WINDOW_REG_DATA_766_RESET                                          0x0
#define DBI_WINDOW_REG_766_ADDRESS                                             (0xbf8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_766_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_766_RESET                                               0x0

// 0xbfc (DBI_WINDOW_REG_767)
#define DBI_WINDOW_REG_DATA_767_LSB                                            0
#define DBI_WINDOW_REG_DATA_767_MSB                                            31
#define DBI_WINDOW_REG_DATA_767_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_767_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_767_MASK) >> DBI_WINDOW_REG_DATA_767_LSB)
#define DBI_WINDOW_REG_DATA_767_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_767_LSB) & DBI_WINDOW_REG_DATA_767_MASK)
#define DBI_WINDOW_REG_DATA_767_RESET                                          0x0
#define DBI_WINDOW_REG_767_ADDRESS                                             (0xbfc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_767_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_767_RESET                                               0x0

// 0xc00 (DBI_WINDOW_REG_768)
#define DBI_WINDOW_REG_DATA_768_LSB                                            0
#define DBI_WINDOW_REG_DATA_768_MSB                                            31
#define DBI_WINDOW_REG_DATA_768_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_768_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_768_MASK) >> DBI_WINDOW_REG_DATA_768_LSB)
#define DBI_WINDOW_REG_DATA_768_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_768_LSB) & DBI_WINDOW_REG_DATA_768_MASK)
#define DBI_WINDOW_REG_DATA_768_RESET                                          0x0
#define DBI_WINDOW_REG_768_ADDRESS                                             (0xc00 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_768_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_768_RESET                                               0x0

// 0xc04 (DBI_WINDOW_REG_769)
#define DBI_WINDOW_REG_DATA_769_LSB                                            0
#define DBI_WINDOW_REG_DATA_769_MSB                                            31
#define DBI_WINDOW_REG_DATA_769_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_769_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_769_MASK) >> DBI_WINDOW_REG_DATA_769_LSB)
#define DBI_WINDOW_REG_DATA_769_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_769_LSB) & DBI_WINDOW_REG_DATA_769_MASK)
#define DBI_WINDOW_REG_DATA_769_RESET                                          0x0
#define DBI_WINDOW_REG_769_ADDRESS                                             (0xc04 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_769_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_769_RESET                                               0x0

// 0xc08 (DBI_WINDOW_REG_770)
#define DBI_WINDOW_REG_DATA_770_LSB                                            0
#define DBI_WINDOW_REG_DATA_770_MSB                                            31
#define DBI_WINDOW_REG_DATA_770_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_770_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_770_MASK) >> DBI_WINDOW_REG_DATA_770_LSB)
#define DBI_WINDOW_REG_DATA_770_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_770_LSB) & DBI_WINDOW_REG_DATA_770_MASK)
#define DBI_WINDOW_REG_DATA_770_RESET                                          0x0
#define DBI_WINDOW_REG_770_ADDRESS                                             (0xc08 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_770_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_770_RESET                                               0x0

// 0xc0c (DBI_WINDOW_REG_771)
#define DBI_WINDOW_REG_DATA_771_LSB                                            0
#define DBI_WINDOW_REG_DATA_771_MSB                                            31
#define DBI_WINDOW_REG_DATA_771_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_771_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_771_MASK) >> DBI_WINDOW_REG_DATA_771_LSB)
#define DBI_WINDOW_REG_DATA_771_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_771_LSB) & DBI_WINDOW_REG_DATA_771_MASK)
#define DBI_WINDOW_REG_DATA_771_RESET                                          0x0
#define DBI_WINDOW_REG_771_ADDRESS                                             (0xc0c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_771_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_771_RESET                                               0x0

// 0xc10 (DBI_WINDOW_REG_772)
#define DBI_WINDOW_REG_DATA_772_LSB                                            0
#define DBI_WINDOW_REG_DATA_772_MSB                                            31
#define DBI_WINDOW_REG_DATA_772_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_772_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_772_MASK) >> DBI_WINDOW_REG_DATA_772_LSB)
#define DBI_WINDOW_REG_DATA_772_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_772_LSB) & DBI_WINDOW_REG_DATA_772_MASK)
#define DBI_WINDOW_REG_DATA_772_RESET                                          0x0
#define DBI_WINDOW_REG_772_ADDRESS                                             (0xc10 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_772_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_772_RESET                                               0x0

// 0xc14 (DBI_WINDOW_REG_773)
#define DBI_WINDOW_REG_DATA_773_LSB                                            0
#define DBI_WINDOW_REG_DATA_773_MSB                                            31
#define DBI_WINDOW_REG_DATA_773_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_773_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_773_MASK) >> DBI_WINDOW_REG_DATA_773_LSB)
#define DBI_WINDOW_REG_DATA_773_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_773_LSB) & DBI_WINDOW_REG_DATA_773_MASK)
#define DBI_WINDOW_REG_DATA_773_RESET                                          0x0
#define DBI_WINDOW_REG_773_ADDRESS                                             (0xc14 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_773_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_773_RESET                                               0x0

// 0xc18 (DBI_WINDOW_REG_774)
#define DBI_WINDOW_REG_DATA_774_LSB                                            0
#define DBI_WINDOW_REG_DATA_774_MSB                                            31
#define DBI_WINDOW_REG_DATA_774_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_774_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_774_MASK) >> DBI_WINDOW_REG_DATA_774_LSB)
#define DBI_WINDOW_REG_DATA_774_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_774_LSB) & DBI_WINDOW_REG_DATA_774_MASK)
#define DBI_WINDOW_REG_DATA_774_RESET                                          0x0
#define DBI_WINDOW_REG_774_ADDRESS                                             (0xc18 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_774_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_774_RESET                                               0x0

// 0xc1c (DBI_WINDOW_REG_775)
#define DBI_WINDOW_REG_DATA_775_LSB                                            0
#define DBI_WINDOW_REG_DATA_775_MSB                                            31
#define DBI_WINDOW_REG_DATA_775_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_775_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_775_MASK) >> DBI_WINDOW_REG_DATA_775_LSB)
#define DBI_WINDOW_REG_DATA_775_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_775_LSB) & DBI_WINDOW_REG_DATA_775_MASK)
#define DBI_WINDOW_REG_DATA_775_RESET                                          0x0
#define DBI_WINDOW_REG_775_ADDRESS                                             (0xc1c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_775_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_775_RESET                                               0x0

// 0xc20 (DBI_WINDOW_REG_776)
#define DBI_WINDOW_REG_DATA_776_LSB                                            0
#define DBI_WINDOW_REG_DATA_776_MSB                                            31
#define DBI_WINDOW_REG_DATA_776_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_776_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_776_MASK) >> DBI_WINDOW_REG_DATA_776_LSB)
#define DBI_WINDOW_REG_DATA_776_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_776_LSB) & DBI_WINDOW_REG_DATA_776_MASK)
#define DBI_WINDOW_REG_DATA_776_RESET                                          0x0
#define DBI_WINDOW_REG_776_ADDRESS                                             (0xc20 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_776_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_776_RESET                                               0x0

// 0xc24 (DBI_WINDOW_REG_777)
#define DBI_WINDOW_REG_DATA_777_LSB                                            0
#define DBI_WINDOW_REG_DATA_777_MSB                                            31
#define DBI_WINDOW_REG_DATA_777_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_777_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_777_MASK) >> DBI_WINDOW_REG_DATA_777_LSB)
#define DBI_WINDOW_REG_DATA_777_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_777_LSB) & DBI_WINDOW_REG_DATA_777_MASK)
#define DBI_WINDOW_REG_DATA_777_RESET                                          0x0
#define DBI_WINDOW_REG_777_ADDRESS                                             (0xc24 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_777_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_777_RESET                                               0x0

// 0xc28 (DBI_WINDOW_REG_778)
#define DBI_WINDOW_REG_DATA_778_LSB                                            0
#define DBI_WINDOW_REG_DATA_778_MSB                                            31
#define DBI_WINDOW_REG_DATA_778_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_778_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_778_MASK) >> DBI_WINDOW_REG_DATA_778_LSB)
#define DBI_WINDOW_REG_DATA_778_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_778_LSB) & DBI_WINDOW_REG_DATA_778_MASK)
#define DBI_WINDOW_REG_DATA_778_RESET                                          0x0
#define DBI_WINDOW_REG_778_ADDRESS                                             (0xc28 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_778_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_778_RESET                                               0x0

// 0xc2c (DBI_WINDOW_REG_779)
#define DBI_WINDOW_REG_DATA_779_LSB                                            0
#define DBI_WINDOW_REG_DATA_779_MSB                                            31
#define DBI_WINDOW_REG_DATA_779_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_779_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_779_MASK) >> DBI_WINDOW_REG_DATA_779_LSB)
#define DBI_WINDOW_REG_DATA_779_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_779_LSB) & DBI_WINDOW_REG_DATA_779_MASK)
#define DBI_WINDOW_REG_DATA_779_RESET                                          0x0
#define DBI_WINDOW_REG_779_ADDRESS                                             (0xc2c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_779_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_779_RESET                                               0x0

// 0xc30 (DBI_WINDOW_REG_780)
#define DBI_WINDOW_REG_DATA_780_LSB                                            0
#define DBI_WINDOW_REG_DATA_780_MSB                                            31
#define DBI_WINDOW_REG_DATA_780_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_780_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_780_MASK) >> DBI_WINDOW_REG_DATA_780_LSB)
#define DBI_WINDOW_REG_DATA_780_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_780_LSB) & DBI_WINDOW_REG_DATA_780_MASK)
#define DBI_WINDOW_REG_DATA_780_RESET                                          0x0
#define DBI_WINDOW_REG_780_ADDRESS                                             (0xc30 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_780_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_780_RESET                                               0x0

// 0xc34 (DBI_WINDOW_REG_781)
#define DBI_WINDOW_REG_DATA_781_LSB                                            0
#define DBI_WINDOW_REG_DATA_781_MSB                                            31
#define DBI_WINDOW_REG_DATA_781_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_781_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_781_MASK) >> DBI_WINDOW_REG_DATA_781_LSB)
#define DBI_WINDOW_REG_DATA_781_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_781_LSB) & DBI_WINDOW_REG_DATA_781_MASK)
#define DBI_WINDOW_REG_DATA_781_RESET                                          0x0
#define DBI_WINDOW_REG_781_ADDRESS                                             (0xc34 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_781_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_781_RESET                                               0x0

// 0xc38 (DBI_WINDOW_REG_782)
#define DBI_WINDOW_REG_DATA_782_LSB                                            0
#define DBI_WINDOW_REG_DATA_782_MSB                                            31
#define DBI_WINDOW_REG_DATA_782_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_782_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_782_MASK) >> DBI_WINDOW_REG_DATA_782_LSB)
#define DBI_WINDOW_REG_DATA_782_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_782_LSB) & DBI_WINDOW_REG_DATA_782_MASK)
#define DBI_WINDOW_REG_DATA_782_RESET                                          0x0
#define DBI_WINDOW_REG_782_ADDRESS                                             (0xc38 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_782_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_782_RESET                                               0x0

// 0xc3c (DBI_WINDOW_REG_783)
#define DBI_WINDOW_REG_DATA_783_LSB                                            0
#define DBI_WINDOW_REG_DATA_783_MSB                                            31
#define DBI_WINDOW_REG_DATA_783_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_783_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_783_MASK) >> DBI_WINDOW_REG_DATA_783_LSB)
#define DBI_WINDOW_REG_DATA_783_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_783_LSB) & DBI_WINDOW_REG_DATA_783_MASK)
#define DBI_WINDOW_REG_DATA_783_RESET                                          0x0
#define DBI_WINDOW_REG_783_ADDRESS                                             (0xc3c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_783_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_783_RESET                                               0x0

// 0xc40 (DBI_WINDOW_REG_784)
#define DBI_WINDOW_REG_DATA_784_LSB                                            0
#define DBI_WINDOW_REG_DATA_784_MSB                                            31
#define DBI_WINDOW_REG_DATA_784_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_784_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_784_MASK) >> DBI_WINDOW_REG_DATA_784_LSB)
#define DBI_WINDOW_REG_DATA_784_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_784_LSB) & DBI_WINDOW_REG_DATA_784_MASK)
#define DBI_WINDOW_REG_DATA_784_RESET                                          0x0
#define DBI_WINDOW_REG_784_ADDRESS                                             (0xc40 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_784_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_784_RESET                                               0x0

// 0xc44 (DBI_WINDOW_REG_785)
#define DBI_WINDOW_REG_DATA_785_LSB                                            0
#define DBI_WINDOW_REG_DATA_785_MSB                                            31
#define DBI_WINDOW_REG_DATA_785_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_785_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_785_MASK) >> DBI_WINDOW_REG_DATA_785_LSB)
#define DBI_WINDOW_REG_DATA_785_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_785_LSB) & DBI_WINDOW_REG_DATA_785_MASK)
#define DBI_WINDOW_REG_DATA_785_RESET                                          0x0
#define DBI_WINDOW_REG_785_ADDRESS                                             (0xc44 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_785_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_785_RESET                                               0x0

// 0xc48 (DBI_WINDOW_REG_786)
#define DBI_WINDOW_REG_DATA_786_LSB                                            0
#define DBI_WINDOW_REG_DATA_786_MSB                                            31
#define DBI_WINDOW_REG_DATA_786_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_786_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_786_MASK) >> DBI_WINDOW_REG_DATA_786_LSB)
#define DBI_WINDOW_REG_DATA_786_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_786_LSB) & DBI_WINDOW_REG_DATA_786_MASK)
#define DBI_WINDOW_REG_DATA_786_RESET                                          0x0
#define DBI_WINDOW_REG_786_ADDRESS                                             (0xc48 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_786_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_786_RESET                                               0x0

// 0xc4c (DBI_WINDOW_REG_787)
#define DBI_WINDOW_REG_DATA_787_LSB                                            0
#define DBI_WINDOW_REG_DATA_787_MSB                                            31
#define DBI_WINDOW_REG_DATA_787_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_787_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_787_MASK) >> DBI_WINDOW_REG_DATA_787_LSB)
#define DBI_WINDOW_REG_DATA_787_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_787_LSB) & DBI_WINDOW_REG_DATA_787_MASK)
#define DBI_WINDOW_REG_DATA_787_RESET                                          0x0
#define DBI_WINDOW_REG_787_ADDRESS                                             (0xc4c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_787_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_787_RESET                                               0x0

// 0xc50 (DBI_WINDOW_REG_788)
#define DBI_WINDOW_REG_DATA_788_LSB                                            0
#define DBI_WINDOW_REG_DATA_788_MSB                                            31
#define DBI_WINDOW_REG_DATA_788_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_788_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_788_MASK) >> DBI_WINDOW_REG_DATA_788_LSB)
#define DBI_WINDOW_REG_DATA_788_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_788_LSB) & DBI_WINDOW_REG_DATA_788_MASK)
#define DBI_WINDOW_REG_DATA_788_RESET                                          0x0
#define DBI_WINDOW_REG_788_ADDRESS                                             (0xc50 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_788_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_788_RESET                                               0x0

// 0xc54 (DBI_WINDOW_REG_789)
#define DBI_WINDOW_REG_DATA_789_LSB                                            0
#define DBI_WINDOW_REG_DATA_789_MSB                                            31
#define DBI_WINDOW_REG_DATA_789_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_789_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_789_MASK) >> DBI_WINDOW_REG_DATA_789_LSB)
#define DBI_WINDOW_REG_DATA_789_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_789_LSB) & DBI_WINDOW_REG_DATA_789_MASK)
#define DBI_WINDOW_REG_DATA_789_RESET                                          0x0
#define DBI_WINDOW_REG_789_ADDRESS                                             (0xc54 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_789_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_789_RESET                                               0x0

// 0xc58 (DBI_WINDOW_REG_790)
#define DBI_WINDOW_REG_DATA_790_LSB                                            0
#define DBI_WINDOW_REG_DATA_790_MSB                                            31
#define DBI_WINDOW_REG_DATA_790_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_790_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_790_MASK) >> DBI_WINDOW_REG_DATA_790_LSB)
#define DBI_WINDOW_REG_DATA_790_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_790_LSB) & DBI_WINDOW_REG_DATA_790_MASK)
#define DBI_WINDOW_REG_DATA_790_RESET                                          0x0
#define DBI_WINDOW_REG_790_ADDRESS                                             (0xc58 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_790_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_790_RESET                                               0x0

// 0xc5c (DBI_WINDOW_REG_791)
#define DBI_WINDOW_REG_DATA_791_LSB                                            0
#define DBI_WINDOW_REG_DATA_791_MSB                                            31
#define DBI_WINDOW_REG_DATA_791_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_791_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_791_MASK) >> DBI_WINDOW_REG_DATA_791_LSB)
#define DBI_WINDOW_REG_DATA_791_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_791_LSB) & DBI_WINDOW_REG_DATA_791_MASK)
#define DBI_WINDOW_REG_DATA_791_RESET                                          0x0
#define DBI_WINDOW_REG_791_ADDRESS                                             (0xc5c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_791_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_791_RESET                                               0x0

// 0xc60 (DBI_WINDOW_REG_792)
#define DBI_WINDOW_REG_DATA_792_LSB                                            0
#define DBI_WINDOW_REG_DATA_792_MSB                                            31
#define DBI_WINDOW_REG_DATA_792_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_792_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_792_MASK) >> DBI_WINDOW_REG_DATA_792_LSB)
#define DBI_WINDOW_REG_DATA_792_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_792_LSB) & DBI_WINDOW_REG_DATA_792_MASK)
#define DBI_WINDOW_REG_DATA_792_RESET                                          0x0
#define DBI_WINDOW_REG_792_ADDRESS                                             (0xc60 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_792_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_792_RESET                                               0x0

// 0xc64 (DBI_WINDOW_REG_793)
#define DBI_WINDOW_REG_DATA_793_LSB                                            0
#define DBI_WINDOW_REG_DATA_793_MSB                                            31
#define DBI_WINDOW_REG_DATA_793_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_793_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_793_MASK) >> DBI_WINDOW_REG_DATA_793_LSB)
#define DBI_WINDOW_REG_DATA_793_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_793_LSB) & DBI_WINDOW_REG_DATA_793_MASK)
#define DBI_WINDOW_REG_DATA_793_RESET                                          0x0
#define DBI_WINDOW_REG_793_ADDRESS                                             (0xc64 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_793_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_793_RESET                                               0x0

// 0xc68 (DBI_WINDOW_REG_794)
#define DBI_WINDOW_REG_DATA_794_LSB                                            0
#define DBI_WINDOW_REG_DATA_794_MSB                                            31
#define DBI_WINDOW_REG_DATA_794_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_794_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_794_MASK) >> DBI_WINDOW_REG_DATA_794_LSB)
#define DBI_WINDOW_REG_DATA_794_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_794_LSB) & DBI_WINDOW_REG_DATA_794_MASK)
#define DBI_WINDOW_REG_DATA_794_RESET                                          0x0
#define DBI_WINDOW_REG_794_ADDRESS                                             (0xc68 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_794_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_794_RESET                                               0x0

// 0xc6c (DBI_WINDOW_REG_795)
#define DBI_WINDOW_REG_DATA_795_LSB                                            0
#define DBI_WINDOW_REG_DATA_795_MSB                                            31
#define DBI_WINDOW_REG_DATA_795_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_795_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_795_MASK) >> DBI_WINDOW_REG_DATA_795_LSB)
#define DBI_WINDOW_REG_DATA_795_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_795_LSB) & DBI_WINDOW_REG_DATA_795_MASK)
#define DBI_WINDOW_REG_DATA_795_RESET                                          0x0
#define DBI_WINDOW_REG_795_ADDRESS                                             (0xc6c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_795_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_795_RESET                                               0x0

// 0xc70 (DBI_WINDOW_REG_796)
#define DBI_WINDOW_REG_DATA_796_LSB                                            0
#define DBI_WINDOW_REG_DATA_796_MSB                                            31
#define DBI_WINDOW_REG_DATA_796_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_796_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_796_MASK) >> DBI_WINDOW_REG_DATA_796_LSB)
#define DBI_WINDOW_REG_DATA_796_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_796_LSB) & DBI_WINDOW_REG_DATA_796_MASK)
#define DBI_WINDOW_REG_DATA_796_RESET                                          0x0
#define DBI_WINDOW_REG_796_ADDRESS                                             (0xc70 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_796_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_796_RESET                                               0x0

// 0xc74 (DBI_WINDOW_REG_797)
#define DBI_WINDOW_REG_DATA_797_LSB                                            0
#define DBI_WINDOW_REG_DATA_797_MSB                                            31
#define DBI_WINDOW_REG_DATA_797_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_797_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_797_MASK) >> DBI_WINDOW_REG_DATA_797_LSB)
#define DBI_WINDOW_REG_DATA_797_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_797_LSB) & DBI_WINDOW_REG_DATA_797_MASK)
#define DBI_WINDOW_REG_DATA_797_RESET                                          0x0
#define DBI_WINDOW_REG_797_ADDRESS                                             (0xc74 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_797_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_797_RESET                                               0x0

// 0xc78 (DBI_WINDOW_REG_798)
#define DBI_WINDOW_REG_DATA_798_LSB                                            0
#define DBI_WINDOW_REG_DATA_798_MSB                                            31
#define DBI_WINDOW_REG_DATA_798_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_798_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_798_MASK) >> DBI_WINDOW_REG_DATA_798_LSB)
#define DBI_WINDOW_REG_DATA_798_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_798_LSB) & DBI_WINDOW_REG_DATA_798_MASK)
#define DBI_WINDOW_REG_DATA_798_RESET                                          0x0
#define DBI_WINDOW_REG_798_ADDRESS                                             (0xc78 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_798_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_798_RESET                                               0x0

// 0xc7c (DBI_WINDOW_REG_799)
#define DBI_WINDOW_REG_DATA_799_LSB                                            0
#define DBI_WINDOW_REG_DATA_799_MSB                                            31
#define DBI_WINDOW_REG_DATA_799_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_799_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_799_MASK) >> DBI_WINDOW_REG_DATA_799_LSB)
#define DBI_WINDOW_REG_DATA_799_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_799_LSB) & DBI_WINDOW_REG_DATA_799_MASK)
#define DBI_WINDOW_REG_DATA_799_RESET                                          0x0
#define DBI_WINDOW_REG_799_ADDRESS                                             (0xc7c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_799_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_799_RESET                                               0x0

// 0xc80 (DBI_WINDOW_REG_800)
#define DBI_WINDOW_REG_DATA_800_LSB                                            0
#define DBI_WINDOW_REG_DATA_800_MSB                                            31
#define DBI_WINDOW_REG_DATA_800_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_800_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_800_MASK) >> DBI_WINDOW_REG_DATA_800_LSB)
#define DBI_WINDOW_REG_DATA_800_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_800_LSB) & DBI_WINDOW_REG_DATA_800_MASK)
#define DBI_WINDOW_REG_DATA_800_RESET                                          0x0
#define DBI_WINDOW_REG_800_ADDRESS                                             (0xc80 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_800_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_800_RESET                                               0x0

// 0xc84 (DBI_WINDOW_REG_801)
#define DBI_WINDOW_REG_DATA_801_LSB                                            0
#define DBI_WINDOW_REG_DATA_801_MSB                                            31
#define DBI_WINDOW_REG_DATA_801_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_801_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_801_MASK) >> DBI_WINDOW_REG_DATA_801_LSB)
#define DBI_WINDOW_REG_DATA_801_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_801_LSB) & DBI_WINDOW_REG_DATA_801_MASK)
#define DBI_WINDOW_REG_DATA_801_RESET                                          0x0
#define DBI_WINDOW_REG_801_ADDRESS                                             (0xc84 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_801_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_801_RESET                                               0x0

// 0xc88 (DBI_WINDOW_REG_802)
#define DBI_WINDOW_REG_DATA_802_LSB                                            0
#define DBI_WINDOW_REG_DATA_802_MSB                                            31
#define DBI_WINDOW_REG_DATA_802_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_802_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_802_MASK) >> DBI_WINDOW_REG_DATA_802_LSB)
#define DBI_WINDOW_REG_DATA_802_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_802_LSB) & DBI_WINDOW_REG_DATA_802_MASK)
#define DBI_WINDOW_REG_DATA_802_RESET                                          0x0
#define DBI_WINDOW_REG_802_ADDRESS                                             (0xc88 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_802_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_802_RESET                                               0x0

// 0xc8c (DBI_WINDOW_REG_803)
#define DBI_WINDOW_REG_DATA_803_LSB                                            0
#define DBI_WINDOW_REG_DATA_803_MSB                                            31
#define DBI_WINDOW_REG_DATA_803_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_803_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_803_MASK) >> DBI_WINDOW_REG_DATA_803_LSB)
#define DBI_WINDOW_REG_DATA_803_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_803_LSB) & DBI_WINDOW_REG_DATA_803_MASK)
#define DBI_WINDOW_REG_DATA_803_RESET                                          0x0
#define DBI_WINDOW_REG_803_ADDRESS                                             (0xc8c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_803_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_803_RESET                                               0x0

// 0xc90 (DBI_WINDOW_REG_804)
#define DBI_WINDOW_REG_DATA_804_LSB                                            0
#define DBI_WINDOW_REG_DATA_804_MSB                                            31
#define DBI_WINDOW_REG_DATA_804_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_804_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_804_MASK) >> DBI_WINDOW_REG_DATA_804_LSB)
#define DBI_WINDOW_REG_DATA_804_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_804_LSB) & DBI_WINDOW_REG_DATA_804_MASK)
#define DBI_WINDOW_REG_DATA_804_RESET                                          0x0
#define DBI_WINDOW_REG_804_ADDRESS                                             (0xc90 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_804_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_804_RESET                                               0x0

// 0xc94 (DBI_WINDOW_REG_805)
#define DBI_WINDOW_REG_DATA_805_LSB                                            0
#define DBI_WINDOW_REG_DATA_805_MSB                                            31
#define DBI_WINDOW_REG_DATA_805_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_805_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_805_MASK) >> DBI_WINDOW_REG_DATA_805_LSB)
#define DBI_WINDOW_REG_DATA_805_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_805_LSB) & DBI_WINDOW_REG_DATA_805_MASK)
#define DBI_WINDOW_REG_DATA_805_RESET                                          0x0
#define DBI_WINDOW_REG_805_ADDRESS                                             (0xc94 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_805_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_805_RESET                                               0x0

// 0xc98 (DBI_WINDOW_REG_806)
#define DBI_WINDOW_REG_DATA_806_LSB                                            0
#define DBI_WINDOW_REG_DATA_806_MSB                                            31
#define DBI_WINDOW_REG_DATA_806_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_806_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_806_MASK) >> DBI_WINDOW_REG_DATA_806_LSB)
#define DBI_WINDOW_REG_DATA_806_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_806_LSB) & DBI_WINDOW_REG_DATA_806_MASK)
#define DBI_WINDOW_REG_DATA_806_RESET                                          0x0
#define DBI_WINDOW_REG_806_ADDRESS                                             (0xc98 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_806_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_806_RESET                                               0x0

// 0xc9c (DBI_WINDOW_REG_807)
#define DBI_WINDOW_REG_DATA_807_LSB                                            0
#define DBI_WINDOW_REG_DATA_807_MSB                                            31
#define DBI_WINDOW_REG_DATA_807_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_807_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_807_MASK) >> DBI_WINDOW_REG_DATA_807_LSB)
#define DBI_WINDOW_REG_DATA_807_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_807_LSB) & DBI_WINDOW_REG_DATA_807_MASK)
#define DBI_WINDOW_REG_DATA_807_RESET                                          0x0
#define DBI_WINDOW_REG_807_ADDRESS                                             (0xc9c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_807_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_807_RESET                                               0x0

// 0xca0 (DBI_WINDOW_REG_808)
#define DBI_WINDOW_REG_DATA_808_LSB                                            0
#define DBI_WINDOW_REG_DATA_808_MSB                                            31
#define DBI_WINDOW_REG_DATA_808_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_808_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_808_MASK) >> DBI_WINDOW_REG_DATA_808_LSB)
#define DBI_WINDOW_REG_DATA_808_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_808_LSB) & DBI_WINDOW_REG_DATA_808_MASK)
#define DBI_WINDOW_REG_DATA_808_RESET                                          0x0
#define DBI_WINDOW_REG_808_ADDRESS                                             (0xca0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_808_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_808_RESET                                               0x0

// 0xca4 (DBI_WINDOW_REG_809)
#define DBI_WINDOW_REG_DATA_809_LSB                                            0
#define DBI_WINDOW_REG_DATA_809_MSB                                            31
#define DBI_WINDOW_REG_DATA_809_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_809_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_809_MASK) >> DBI_WINDOW_REG_DATA_809_LSB)
#define DBI_WINDOW_REG_DATA_809_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_809_LSB) & DBI_WINDOW_REG_DATA_809_MASK)
#define DBI_WINDOW_REG_DATA_809_RESET                                          0x0
#define DBI_WINDOW_REG_809_ADDRESS                                             (0xca4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_809_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_809_RESET                                               0x0

// 0xca8 (DBI_WINDOW_REG_810)
#define DBI_WINDOW_REG_DATA_810_LSB                                            0
#define DBI_WINDOW_REG_DATA_810_MSB                                            31
#define DBI_WINDOW_REG_DATA_810_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_810_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_810_MASK) >> DBI_WINDOW_REG_DATA_810_LSB)
#define DBI_WINDOW_REG_DATA_810_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_810_LSB) & DBI_WINDOW_REG_DATA_810_MASK)
#define DBI_WINDOW_REG_DATA_810_RESET                                          0x0
#define DBI_WINDOW_REG_810_ADDRESS                                             (0xca8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_810_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_810_RESET                                               0x0

// 0xcac (DBI_WINDOW_REG_811)
#define DBI_WINDOW_REG_DATA_811_LSB                                            0
#define DBI_WINDOW_REG_DATA_811_MSB                                            31
#define DBI_WINDOW_REG_DATA_811_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_811_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_811_MASK) >> DBI_WINDOW_REG_DATA_811_LSB)
#define DBI_WINDOW_REG_DATA_811_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_811_LSB) & DBI_WINDOW_REG_DATA_811_MASK)
#define DBI_WINDOW_REG_DATA_811_RESET                                          0x0
#define DBI_WINDOW_REG_811_ADDRESS                                             (0xcac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_811_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_811_RESET                                               0x0

// 0xcb0 (DBI_WINDOW_REG_812)
#define DBI_WINDOW_REG_DATA_812_LSB                                            0
#define DBI_WINDOW_REG_DATA_812_MSB                                            31
#define DBI_WINDOW_REG_DATA_812_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_812_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_812_MASK) >> DBI_WINDOW_REG_DATA_812_LSB)
#define DBI_WINDOW_REG_DATA_812_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_812_LSB) & DBI_WINDOW_REG_DATA_812_MASK)
#define DBI_WINDOW_REG_DATA_812_RESET                                          0x0
#define DBI_WINDOW_REG_812_ADDRESS                                             (0xcb0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_812_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_812_RESET                                               0x0

// 0xcb4 (DBI_WINDOW_REG_813)
#define DBI_WINDOW_REG_DATA_813_LSB                                            0
#define DBI_WINDOW_REG_DATA_813_MSB                                            31
#define DBI_WINDOW_REG_DATA_813_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_813_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_813_MASK) >> DBI_WINDOW_REG_DATA_813_LSB)
#define DBI_WINDOW_REG_DATA_813_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_813_LSB) & DBI_WINDOW_REG_DATA_813_MASK)
#define DBI_WINDOW_REG_DATA_813_RESET                                          0x0
#define DBI_WINDOW_REG_813_ADDRESS                                             (0xcb4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_813_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_813_RESET                                               0x0

// 0xcb8 (DBI_WINDOW_REG_814)
#define DBI_WINDOW_REG_DATA_814_LSB                                            0
#define DBI_WINDOW_REG_DATA_814_MSB                                            31
#define DBI_WINDOW_REG_DATA_814_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_814_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_814_MASK) >> DBI_WINDOW_REG_DATA_814_LSB)
#define DBI_WINDOW_REG_DATA_814_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_814_LSB) & DBI_WINDOW_REG_DATA_814_MASK)
#define DBI_WINDOW_REG_DATA_814_RESET                                          0x0
#define DBI_WINDOW_REG_814_ADDRESS                                             (0xcb8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_814_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_814_RESET                                               0x0

// 0xcbc (DBI_WINDOW_REG_815)
#define DBI_WINDOW_REG_DATA_815_LSB                                            0
#define DBI_WINDOW_REG_DATA_815_MSB                                            31
#define DBI_WINDOW_REG_DATA_815_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_815_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_815_MASK) >> DBI_WINDOW_REG_DATA_815_LSB)
#define DBI_WINDOW_REG_DATA_815_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_815_LSB) & DBI_WINDOW_REG_DATA_815_MASK)
#define DBI_WINDOW_REG_DATA_815_RESET                                          0x0
#define DBI_WINDOW_REG_815_ADDRESS                                             (0xcbc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_815_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_815_RESET                                               0x0

// 0xcc0 (DBI_WINDOW_REG_816)
#define DBI_WINDOW_REG_DATA_816_LSB                                            0
#define DBI_WINDOW_REG_DATA_816_MSB                                            31
#define DBI_WINDOW_REG_DATA_816_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_816_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_816_MASK) >> DBI_WINDOW_REG_DATA_816_LSB)
#define DBI_WINDOW_REG_DATA_816_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_816_LSB) & DBI_WINDOW_REG_DATA_816_MASK)
#define DBI_WINDOW_REG_DATA_816_RESET                                          0x0
#define DBI_WINDOW_REG_816_ADDRESS                                             (0xcc0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_816_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_816_RESET                                               0x0

// 0xcc4 (DBI_WINDOW_REG_817)
#define DBI_WINDOW_REG_DATA_817_LSB                                            0
#define DBI_WINDOW_REG_DATA_817_MSB                                            31
#define DBI_WINDOW_REG_DATA_817_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_817_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_817_MASK) >> DBI_WINDOW_REG_DATA_817_LSB)
#define DBI_WINDOW_REG_DATA_817_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_817_LSB) & DBI_WINDOW_REG_DATA_817_MASK)
#define DBI_WINDOW_REG_DATA_817_RESET                                          0x0
#define DBI_WINDOW_REG_817_ADDRESS                                             (0xcc4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_817_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_817_RESET                                               0x0

// 0xcc8 (DBI_WINDOW_REG_818)
#define DBI_WINDOW_REG_DATA_818_LSB                                            0
#define DBI_WINDOW_REG_DATA_818_MSB                                            31
#define DBI_WINDOW_REG_DATA_818_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_818_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_818_MASK) >> DBI_WINDOW_REG_DATA_818_LSB)
#define DBI_WINDOW_REG_DATA_818_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_818_LSB) & DBI_WINDOW_REG_DATA_818_MASK)
#define DBI_WINDOW_REG_DATA_818_RESET                                          0x0
#define DBI_WINDOW_REG_818_ADDRESS                                             (0xcc8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_818_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_818_RESET                                               0x0

// 0xccc (DBI_WINDOW_REG_819)
#define DBI_WINDOW_REG_DATA_819_LSB                                            0
#define DBI_WINDOW_REG_DATA_819_MSB                                            31
#define DBI_WINDOW_REG_DATA_819_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_819_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_819_MASK) >> DBI_WINDOW_REG_DATA_819_LSB)
#define DBI_WINDOW_REG_DATA_819_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_819_LSB) & DBI_WINDOW_REG_DATA_819_MASK)
#define DBI_WINDOW_REG_DATA_819_RESET                                          0x0
#define DBI_WINDOW_REG_819_ADDRESS                                             (0xccc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_819_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_819_RESET                                               0x0

// 0xcd0 (DBI_WINDOW_REG_820)
#define DBI_WINDOW_REG_DATA_820_LSB                                            0
#define DBI_WINDOW_REG_DATA_820_MSB                                            31
#define DBI_WINDOW_REG_DATA_820_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_820_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_820_MASK) >> DBI_WINDOW_REG_DATA_820_LSB)
#define DBI_WINDOW_REG_DATA_820_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_820_LSB) & DBI_WINDOW_REG_DATA_820_MASK)
#define DBI_WINDOW_REG_DATA_820_RESET                                          0x0
#define DBI_WINDOW_REG_820_ADDRESS                                             (0xcd0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_820_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_820_RESET                                               0x0

// 0xcd4 (DBI_WINDOW_REG_821)
#define DBI_WINDOW_REG_DATA_821_LSB                                            0
#define DBI_WINDOW_REG_DATA_821_MSB                                            31
#define DBI_WINDOW_REG_DATA_821_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_821_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_821_MASK) >> DBI_WINDOW_REG_DATA_821_LSB)
#define DBI_WINDOW_REG_DATA_821_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_821_LSB) & DBI_WINDOW_REG_DATA_821_MASK)
#define DBI_WINDOW_REG_DATA_821_RESET                                          0x0
#define DBI_WINDOW_REG_821_ADDRESS                                             (0xcd4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_821_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_821_RESET                                               0x0

// 0xcd8 (DBI_WINDOW_REG_822)
#define DBI_WINDOW_REG_DATA_822_LSB                                            0
#define DBI_WINDOW_REG_DATA_822_MSB                                            31
#define DBI_WINDOW_REG_DATA_822_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_822_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_822_MASK) >> DBI_WINDOW_REG_DATA_822_LSB)
#define DBI_WINDOW_REG_DATA_822_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_822_LSB) & DBI_WINDOW_REG_DATA_822_MASK)
#define DBI_WINDOW_REG_DATA_822_RESET                                          0x0
#define DBI_WINDOW_REG_822_ADDRESS                                             (0xcd8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_822_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_822_RESET                                               0x0

// 0xcdc (DBI_WINDOW_REG_823)
#define DBI_WINDOW_REG_DATA_823_LSB                                            0
#define DBI_WINDOW_REG_DATA_823_MSB                                            31
#define DBI_WINDOW_REG_DATA_823_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_823_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_823_MASK) >> DBI_WINDOW_REG_DATA_823_LSB)
#define DBI_WINDOW_REG_DATA_823_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_823_LSB) & DBI_WINDOW_REG_DATA_823_MASK)
#define DBI_WINDOW_REG_DATA_823_RESET                                          0x0
#define DBI_WINDOW_REG_823_ADDRESS                                             (0xcdc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_823_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_823_RESET                                               0x0

// 0xce0 (DBI_WINDOW_REG_824)
#define DBI_WINDOW_REG_DATA_824_LSB                                            0
#define DBI_WINDOW_REG_DATA_824_MSB                                            31
#define DBI_WINDOW_REG_DATA_824_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_824_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_824_MASK) >> DBI_WINDOW_REG_DATA_824_LSB)
#define DBI_WINDOW_REG_DATA_824_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_824_LSB) & DBI_WINDOW_REG_DATA_824_MASK)
#define DBI_WINDOW_REG_DATA_824_RESET                                          0x0
#define DBI_WINDOW_REG_824_ADDRESS                                             (0xce0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_824_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_824_RESET                                               0x0

// 0xce4 (DBI_WINDOW_REG_825)
#define DBI_WINDOW_REG_DATA_825_LSB                                            0
#define DBI_WINDOW_REG_DATA_825_MSB                                            31
#define DBI_WINDOW_REG_DATA_825_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_825_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_825_MASK) >> DBI_WINDOW_REG_DATA_825_LSB)
#define DBI_WINDOW_REG_DATA_825_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_825_LSB) & DBI_WINDOW_REG_DATA_825_MASK)
#define DBI_WINDOW_REG_DATA_825_RESET                                          0x0
#define DBI_WINDOW_REG_825_ADDRESS                                             (0xce4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_825_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_825_RESET                                               0x0

// 0xce8 (DBI_WINDOW_REG_826)
#define DBI_WINDOW_REG_DATA_826_LSB                                            0
#define DBI_WINDOW_REG_DATA_826_MSB                                            31
#define DBI_WINDOW_REG_DATA_826_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_826_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_826_MASK) >> DBI_WINDOW_REG_DATA_826_LSB)
#define DBI_WINDOW_REG_DATA_826_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_826_LSB) & DBI_WINDOW_REG_DATA_826_MASK)
#define DBI_WINDOW_REG_DATA_826_RESET                                          0x0
#define DBI_WINDOW_REG_826_ADDRESS                                             (0xce8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_826_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_826_RESET                                               0x0

// 0xcec (DBI_WINDOW_REG_827)
#define DBI_WINDOW_REG_DATA_827_LSB                                            0
#define DBI_WINDOW_REG_DATA_827_MSB                                            31
#define DBI_WINDOW_REG_DATA_827_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_827_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_827_MASK) >> DBI_WINDOW_REG_DATA_827_LSB)
#define DBI_WINDOW_REG_DATA_827_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_827_LSB) & DBI_WINDOW_REG_DATA_827_MASK)
#define DBI_WINDOW_REG_DATA_827_RESET                                          0x0
#define DBI_WINDOW_REG_827_ADDRESS                                             (0xcec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_827_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_827_RESET                                               0x0

// 0xcf0 (DBI_WINDOW_REG_828)
#define DBI_WINDOW_REG_DATA_828_LSB                                            0
#define DBI_WINDOW_REG_DATA_828_MSB                                            31
#define DBI_WINDOW_REG_DATA_828_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_828_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_828_MASK) >> DBI_WINDOW_REG_DATA_828_LSB)
#define DBI_WINDOW_REG_DATA_828_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_828_LSB) & DBI_WINDOW_REG_DATA_828_MASK)
#define DBI_WINDOW_REG_DATA_828_RESET                                          0x0
#define DBI_WINDOW_REG_828_ADDRESS                                             (0xcf0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_828_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_828_RESET                                               0x0

// 0xcf4 (DBI_WINDOW_REG_829)
#define DBI_WINDOW_REG_DATA_829_LSB                                            0
#define DBI_WINDOW_REG_DATA_829_MSB                                            31
#define DBI_WINDOW_REG_DATA_829_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_829_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_829_MASK) >> DBI_WINDOW_REG_DATA_829_LSB)
#define DBI_WINDOW_REG_DATA_829_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_829_LSB) & DBI_WINDOW_REG_DATA_829_MASK)
#define DBI_WINDOW_REG_DATA_829_RESET                                          0x0
#define DBI_WINDOW_REG_829_ADDRESS                                             (0xcf4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_829_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_829_RESET                                               0x0

// 0xcf8 (DBI_WINDOW_REG_830)
#define DBI_WINDOW_REG_DATA_830_LSB                                            0
#define DBI_WINDOW_REG_DATA_830_MSB                                            31
#define DBI_WINDOW_REG_DATA_830_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_830_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_830_MASK) >> DBI_WINDOW_REG_DATA_830_LSB)
#define DBI_WINDOW_REG_DATA_830_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_830_LSB) & DBI_WINDOW_REG_DATA_830_MASK)
#define DBI_WINDOW_REG_DATA_830_RESET                                          0x0
#define DBI_WINDOW_REG_830_ADDRESS                                             (0xcf8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_830_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_830_RESET                                               0x0

// 0xcfc (DBI_WINDOW_REG_831)
#define DBI_WINDOW_REG_DATA_831_LSB                                            0
#define DBI_WINDOW_REG_DATA_831_MSB                                            31
#define DBI_WINDOW_REG_DATA_831_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_831_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_831_MASK) >> DBI_WINDOW_REG_DATA_831_LSB)
#define DBI_WINDOW_REG_DATA_831_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_831_LSB) & DBI_WINDOW_REG_DATA_831_MASK)
#define DBI_WINDOW_REG_DATA_831_RESET                                          0x0
#define DBI_WINDOW_REG_831_ADDRESS                                             (0xcfc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_831_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_831_RESET                                               0x0

// 0xd00 (DBI_WINDOW_REG_832)
#define DBI_WINDOW_REG_DATA_832_LSB                                            0
#define DBI_WINDOW_REG_DATA_832_MSB                                            31
#define DBI_WINDOW_REG_DATA_832_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_832_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_832_MASK) >> DBI_WINDOW_REG_DATA_832_LSB)
#define DBI_WINDOW_REG_DATA_832_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_832_LSB) & DBI_WINDOW_REG_DATA_832_MASK)
#define DBI_WINDOW_REG_DATA_832_RESET                                          0x0
#define DBI_WINDOW_REG_832_ADDRESS                                             (0xd00 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_832_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_832_RESET                                               0x0

// 0xd04 (DBI_WINDOW_REG_833)
#define DBI_WINDOW_REG_DATA_833_LSB                                            0
#define DBI_WINDOW_REG_DATA_833_MSB                                            31
#define DBI_WINDOW_REG_DATA_833_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_833_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_833_MASK) >> DBI_WINDOW_REG_DATA_833_LSB)
#define DBI_WINDOW_REG_DATA_833_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_833_LSB) & DBI_WINDOW_REG_DATA_833_MASK)
#define DBI_WINDOW_REG_DATA_833_RESET                                          0x0
#define DBI_WINDOW_REG_833_ADDRESS                                             (0xd04 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_833_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_833_RESET                                               0x0

// 0xd08 (DBI_WINDOW_REG_834)
#define DBI_WINDOW_REG_DATA_834_LSB                                            0
#define DBI_WINDOW_REG_DATA_834_MSB                                            31
#define DBI_WINDOW_REG_DATA_834_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_834_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_834_MASK) >> DBI_WINDOW_REG_DATA_834_LSB)
#define DBI_WINDOW_REG_DATA_834_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_834_LSB) & DBI_WINDOW_REG_DATA_834_MASK)
#define DBI_WINDOW_REG_DATA_834_RESET                                          0x0
#define DBI_WINDOW_REG_834_ADDRESS                                             (0xd08 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_834_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_834_RESET                                               0x0

// 0xd0c (DBI_WINDOW_REG_835)
#define DBI_WINDOW_REG_DATA_835_LSB                                            0
#define DBI_WINDOW_REG_DATA_835_MSB                                            31
#define DBI_WINDOW_REG_DATA_835_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_835_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_835_MASK) >> DBI_WINDOW_REG_DATA_835_LSB)
#define DBI_WINDOW_REG_DATA_835_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_835_LSB) & DBI_WINDOW_REG_DATA_835_MASK)
#define DBI_WINDOW_REG_DATA_835_RESET                                          0x0
#define DBI_WINDOW_REG_835_ADDRESS                                             (0xd0c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_835_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_835_RESET                                               0x0

// 0xd10 (DBI_WINDOW_REG_836)
#define DBI_WINDOW_REG_DATA_836_LSB                                            0
#define DBI_WINDOW_REG_DATA_836_MSB                                            31
#define DBI_WINDOW_REG_DATA_836_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_836_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_836_MASK) >> DBI_WINDOW_REG_DATA_836_LSB)
#define DBI_WINDOW_REG_DATA_836_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_836_LSB) & DBI_WINDOW_REG_DATA_836_MASK)
#define DBI_WINDOW_REG_DATA_836_RESET                                          0x0
#define DBI_WINDOW_REG_836_ADDRESS                                             (0xd10 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_836_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_836_RESET                                               0x0

// 0xd14 (DBI_WINDOW_REG_837)
#define DBI_WINDOW_REG_DATA_837_LSB                                            0
#define DBI_WINDOW_REG_DATA_837_MSB                                            31
#define DBI_WINDOW_REG_DATA_837_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_837_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_837_MASK) >> DBI_WINDOW_REG_DATA_837_LSB)
#define DBI_WINDOW_REG_DATA_837_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_837_LSB) & DBI_WINDOW_REG_DATA_837_MASK)
#define DBI_WINDOW_REG_DATA_837_RESET                                          0x0
#define DBI_WINDOW_REG_837_ADDRESS                                             (0xd14 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_837_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_837_RESET                                               0x0

// 0xd18 (DBI_WINDOW_REG_838)
#define DBI_WINDOW_REG_DATA_838_LSB                                            0
#define DBI_WINDOW_REG_DATA_838_MSB                                            31
#define DBI_WINDOW_REG_DATA_838_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_838_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_838_MASK) >> DBI_WINDOW_REG_DATA_838_LSB)
#define DBI_WINDOW_REG_DATA_838_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_838_LSB) & DBI_WINDOW_REG_DATA_838_MASK)
#define DBI_WINDOW_REG_DATA_838_RESET                                          0x0
#define DBI_WINDOW_REG_838_ADDRESS                                             (0xd18 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_838_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_838_RESET                                               0x0

// 0xd1c (DBI_WINDOW_REG_839)
#define DBI_WINDOW_REG_DATA_839_LSB                                            0
#define DBI_WINDOW_REG_DATA_839_MSB                                            31
#define DBI_WINDOW_REG_DATA_839_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_839_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_839_MASK) >> DBI_WINDOW_REG_DATA_839_LSB)
#define DBI_WINDOW_REG_DATA_839_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_839_LSB) & DBI_WINDOW_REG_DATA_839_MASK)
#define DBI_WINDOW_REG_DATA_839_RESET                                          0x0
#define DBI_WINDOW_REG_839_ADDRESS                                             (0xd1c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_839_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_839_RESET                                               0x0

// 0xd20 (DBI_WINDOW_REG_840)
#define DBI_WINDOW_REG_DATA_840_LSB                                            0
#define DBI_WINDOW_REG_DATA_840_MSB                                            31
#define DBI_WINDOW_REG_DATA_840_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_840_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_840_MASK) >> DBI_WINDOW_REG_DATA_840_LSB)
#define DBI_WINDOW_REG_DATA_840_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_840_LSB) & DBI_WINDOW_REG_DATA_840_MASK)
#define DBI_WINDOW_REG_DATA_840_RESET                                          0x0
#define DBI_WINDOW_REG_840_ADDRESS                                             (0xd20 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_840_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_840_RESET                                               0x0

// 0xd24 (DBI_WINDOW_REG_841)
#define DBI_WINDOW_REG_DATA_841_LSB                                            0
#define DBI_WINDOW_REG_DATA_841_MSB                                            31
#define DBI_WINDOW_REG_DATA_841_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_841_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_841_MASK) >> DBI_WINDOW_REG_DATA_841_LSB)
#define DBI_WINDOW_REG_DATA_841_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_841_LSB) & DBI_WINDOW_REG_DATA_841_MASK)
#define DBI_WINDOW_REG_DATA_841_RESET                                          0x0
#define DBI_WINDOW_REG_841_ADDRESS                                             (0xd24 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_841_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_841_RESET                                               0x0

// 0xd28 (DBI_WINDOW_REG_842)
#define DBI_WINDOW_REG_DATA_842_LSB                                            0
#define DBI_WINDOW_REG_DATA_842_MSB                                            31
#define DBI_WINDOW_REG_DATA_842_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_842_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_842_MASK) >> DBI_WINDOW_REG_DATA_842_LSB)
#define DBI_WINDOW_REG_DATA_842_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_842_LSB) & DBI_WINDOW_REG_DATA_842_MASK)
#define DBI_WINDOW_REG_DATA_842_RESET                                          0x0
#define DBI_WINDOW_REG_842_ADDRESS                                             (0xd28 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_842_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_842_RESET                                               0x0

// 0xd2c (DBI_WINDOW_REG_843)
#define DBI_WINDOW_REG_DATA_843_LSB                                            0
#define DBI_WINDOW_REG_DATA_843_MSB                                            31
#define DBI_WINDOW_REG_DATA_843_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_843_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_843_MASK) >> DBI_WINDOW_REG_DATA_843_LSB)
#define DBI_WINDOW_REG_DATA_843_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_843_LSB) & DBI_WINDOW_REG_DATA_843_MASK)
#define DBI_WINDOW_REG_DATA_843_RESET                                          0x0
#define DBI_WINDOW_REG_843_ADDRESS                                             (0xd2c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_843_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_843_RESET                                               0x0

// 0xd30 (DBI_WINDOW_REG_844)
#define DBI_WINDOW_REG_DATA_844_LSB                                            0
#define DBI_WINDOW_REG_DATA_844_MSB                                            31
#define DBI_WINDOW_REG_DATA_844_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_844_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_844_MASK) >> DBI_WINDOW_REG_DATA_844_LSB)
#define DBI_WINDOW_REG_DATA_844_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_844_LSB) & DBI_WINDOW_REG_DATA_844_MASK)
#define DBI_WINDOW_REG_DATA_844_RESET                                          0x0
#define DBI_WINDOW_REG_844_ADDRESS                                             (0xd30 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_844_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_844_RESET                                               0x0

// 0xd34 (DBI_WINDOW_REG_845)
#define DBI_WINDOW_REG_DATA_845_LSB                                            0
#define DBI_WINDOW_REG_DATA_845_MSB                                            31
#define DBI_WINDOW_REG_DATA_845_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_845_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_845_MASK) >> DBI_WINDOW_REG_DATA_845_LSB)
#define DBI_WINDOW_REG_DATA_845_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_845_LSB) & DBI_WINDOW_REG_DATA_845_MASK)
#define DBI_WINDOW_REG_DATA_845_RESET                                          0x0
#define DBI_WINDOW_REG_845_ADDRESS                                             (0xd34 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_845_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_845_RESET                                               0x0

// 0xd38 (DBI_WINDOW_REG_846)
#define DBI_WINDOW_REG_DATA_846_LSB                                            0
#define DBI_WINDOW_REG_DATA_846_MSB                                            31
#define DBI_WINDOW_REG_DATA_846_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_846_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_846_MASK) >> DBI_WINDOW_REG_DATA_846_LSB)
#define DBI_WINDOW_REG_DATA_846_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_846_LSB) & DBI_WINDOW_REG_DATA_846_MASK)
#define DBI_WINDOW_REG_DATA_846_RESET                                          0x0
#define DBI_WINDOW_REG_846_ADDRESS                                             (0xd38 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_846_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_846_RESET                                               0x0

// 0xd3c (DBI_WINDOW_REG_847)
#define DBI_WINDOW_REG_DATA_847_LSB                                            0
#define DBI_WINDOW_REG_DATA_847_MSB                                            31
#define DBI_WINDOW_REG_DATA_847_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_847_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_847_MASK) >> DBI_WINDOW_REG_DATA_847_LSB)
#define DBI_WINDOW_REG_DATA_847_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_847_LSB) & DBI_WINDOW_REG_DATA_847_MASK)
#define DBI_WINDOW_REG_DATA_847_RESET                                          0x0
#define DBI_WINDOW_REG_847_ADDRESS                                             (0xd3c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_847_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_847_RESET                                               0x0

// 0xd40 (DBI_WINDOW_REG_848)
#define DBI_WINDOW_REG_DATA_848_LSB                                            0
#define DBI_WINDOW_REG_DATA_848_MSB                                            31
#define DBI_WINDOW_REG_DATA_848_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_848_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_848_MASK) >> DBI_WINDOW_REG_DATA_848_LSB)
#define DBI_WINDOW_REG_DATA_848_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_848_LSB) & DBI_WINDOW_REG_DATA_848_MASK)
#define DBI_WINDOW_REG_DATA_848_RESET                                          0x0
#define DBI_WINDOW_REG_848_ADDRESS                                             (0xd40 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_848_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_848_RESET                                               0x0

// 0xd44 (DBI_WINDOW_REG_849)
#define DBI_WINDOW_REG_DATA_849_LSB                                            0
#define DBI_WINDOW_REG_DATA_849_MSB                                            31
#define DBI_WINDOW_REG_DATA_849_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_849_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_849_MASK) >> DBI_WINDOW_REG_DATA_849_LSB)
#define DBI_WINDOW_REG_DATA_849_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_849_LSB) & DBI_WINDOW_REG_DATA_849_MASK)
#define DBI_WINDOW_REG_DATA_849_RESET                                          0x0
#define DBI_WINDOW_REG_849_ADDRESS                                             (0xd44 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_849_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_849_RESET                                               0x0

// 0xd48 (DBI_WINDOW_REG_850)
#define DBI_WINDOW_REG_DATA_850_LSB                                            0
#define DBI_WINDOW_REG_DATA_850_MSB                                            31
#define DBI_WINDOW_REG_DATA_850_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_850_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_850_MASK) >> DBI_WINDOW_REG_DATA_850_LSB)
#define DBI_WINDOW_REG_DATA_850_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_850_LSB) & DBI_WINDOW_REG_DATA_850_MASK)
#define DBI_WINDOW_REG_DATA_850_RESET                                          0x0
#define DBI_WINDOW_REG_850_ADDRESS                                             (0xd48 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_850_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_850_RESET                                               0x0

// 0xd4c (DBI_WINDOW_REG_851)
#define DBI_WINDOW_REG_DATA_851_LSB                                            0
#define DBI_WINDOW_REG_DATA_851_MSB                                            31
#define DBI_WINDOW_REG_DATA_851_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_851_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_851_MASK) >> DBI_WINDOW_REG_DATA_851_LSB)
#define DBI_WINDOW_REG_DATA_851_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_851_LSB) & DBI_WINDOW_REG_DATA_851_MASK)
#define DBI_WINDOW_REG_DATA_851_RESET                                          0x0
#define DBI_WINDOW_REG_851_ADDRESS                                             (0xd4c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_851_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_851_RESET                                               0x0

// 0xd50 (DBI_WINDOW_REG_852)
#define DBI_WINDOW_REG_DATA_852_LSB                                            0
#define DBI_WINDOW_REG_DATA_852_MSB                                            31
#define DBI_WINDOW_REG_DATA_852_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_852_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_852_MASK) >> DBI_WINDOW_REG_DATA_852_LSB)
#define DBI_WINDOW_REG_DATA_852_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_852_LSB) & DBI_WINDOW_REG_DATA_852_MASK)
#define DBI_WINDOW_REG_DATA_852_RESET                                          0x0
#define DBI_WINDOW_REG_852_ADDRESS                                             (0xd50 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_852_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_852_RESET                                               0x0

// 0xd54 (DBI_WINDOW_REG_853)
#define DBI_WINDOW_REG_DATA_853_LSB                                            0
#define DBI_WINDOW_REG_DATA_853_MSB                                            31
#define DBI_WINDOW_REG_DATA_853_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_853_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_853_MASK) >> DBI_WINDOW_REG_DATA_853_LSB)
#define DBI_WINDOW_REG_DATA_853_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_853_LSB) & DBI_WINDOW_REG_DATA_853_MASK)
#define DBI_WINDOW_REG_DATA_853_RESET                                          0x0
#define DBI_WINDOW_REG_853_ADDRESS                                             (0xd54 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_853_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_853_RESET                                               0x0

// 0xd58 (DBI_WINDOW_REG_854)
#define DBI_WINDOW_REG_DATA_854_LSB                                            0
#define DBI_WINDOW_REG_DATA_854_MSB                                            31
#define DBI_WINDOW_REG_DATA_854_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_854_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_854_MASK) >> DBI_WINDOW_REG_DATA_854_LSB)
#define DBI_WINDOW_REG_DATA_854_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_854_LSB) & DBI_WINDOW_REG_DATA_854_MASK)
#define DBI_WINDOW_REG_DATA_854_RESET                                          0x0
#define DBI_WINDOW_REG_854_ADDRESS                                             (0xd58 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_854_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_854_RESET                                               0x0

// 0xd5c (DBI_WINDOW_REG_855)
#define DBI_WINDOW_REG_DATA_855_LSB                                            0
#define DBI_WINDOW_REG_DATA_855_MSB                                            31
#define DBI_WINDOW_REG_DATA_855_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_855_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_855_MASK) >> DBI_WINDOW_REG_DATA_855_LSB)
#define DBI_WINDOW_REG_DATA_855_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_855_LSB) & DBI_WINDOW_REG_DATA_855_MASK)
#define DBI_WINDOW_REG_DATA_855_RESET                                          0x0
#define DBI_WINDOW_REG_855_ADDRESS                                             (0xd5c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_855_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_855_RESET                                               0x0

// 0xd60 (DBI_WINDOW_REG_856)
#define DBI_WINDOW_REG_DATA_856_LSB                                            0
#define DBI_WINDOW_REG_DATA_856_MSB                                            31
#define DBI_WINDOW_REG_DATA_856_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_856_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_856_MASK) >> DBI_WINDOW_REG_DATA_856_LSB)
#define DBI_WINDOW_REG_DATA_856_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_856_LSB) & DBI_WINDOW_REG_DATA_856_MASK)
#define DBI_WINDOW_REG_DATA_856_RESET                                          0x0
#define DBI_WINDOW_REG_856_ADDRESS                                             (0xd60 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_856_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_856_RESET                                               0x0

// 0xd64 (DBI_WINDOW_REG_857)
#define DBI_WINDOW_REG_DATA_857_LSB                                            0
#define DBI_WINDOW_REG_DATA_857_MSB                                            31
#define DBI_WINDOW_REG_DATA_857_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_857_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_857_MASK) >> DBI_WINDOW_REG_DATA_857_LSB)
#define DBI_WINDOW_REG_DATA_857_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_857_LSB) & DBI_WINDOW_REG_DATA_857_MASK)
#define DBI_WINDOW_REG_DATA_857_RESET                                          0x0
#define DBI_WINDOW_REG_857_ADDRESS                                             (0xd64 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_857_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_857_RESET                                               0x0

// 0xd68 (DBI_WINDOW_REG_858)
#define DBI_WINDOW_REG_DATA_858_LSB                                            0
#define DBI_WINDOW_REG_DATA_858_MSB                                            31
#define DBI_WINDOW_REG_DATA_858_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_858_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_858_MASK) >> DBI_WINDOW_REG_DATA_858_LSB)
#define DBI_WINDOW_REG_DATA_858_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_858_LSB) & DBI_WINDOW_REG_DATA_858_MASK)
#define DBI_WINDOW_REG_DATA_858_RESET                                          0x0
#define DBI_WINDOW_REG_858_ADDRESS                                             (0xd68 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_858_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_858_RESET                                               0x0

// 0xd6c (DBI_WINDOW_REG_859)
#define DBI_WINDOW_REG_DATA_859_LSB                                            0
#define DBI_WINDOW_REG_DATA_859_MSB                                            31
#define DBI_WINDOW_REG_DATA_859_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_859_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_859_MASK) >> DBI_WINDOW_REG_DATA_859_LSB)
#define DBI_WINDOW_REG_DATA_859_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_859_LSB) & DBI_WINDOW_REG_DATA_859_MASK)
#define DBI_WINDOW_REG_DATA_859_RESET                                          0x0
#define DBI_WINDOW_REG_859_ADDRESS                                             (0xd6c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_859_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_859_RESET                                               0x0

// 0xd70 (DBI_WINDOW_REG_860)
#define DBI_WINDOW_REG_DATA_860_LSB                                            0
#define DBI_WINDOW_REG_DATA_860_MSB                                            31
#define DBI_WINDOW_REG_DATA_860_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_860_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_860_MASK) >> DBI_WINDOW_REG_DATA_860_LSB)
#define DBI_WINDOW_REG_DATA_860_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_860_LSB) & DBI_WINDOW_REG_DATA_860_MASK)
#define DBI_WINDOW_REG_DATA_860_RESET                                          0x0
#define DBI_WINDOW_REG_860_ADDRESS                                             (0xd70 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_860_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_860_RESET                                               0x0

// 0xd74 (DBI_WINDOW_REG_861)
#define DBI_WINDOW_REG_DATA_861_LSB                                            0
#define DBI_WINDOW_REG_DATA_861_MSB                                            31
#define DBI_WINDOW_REG_DATA_861_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_861_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_861_MASK) >> DBI_WINDOW_REG_DATA_861_LSB)
#define DBI_WINDOW_REG_DATA_861_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_861_LSB) & DBI_WINDOW_REG_DATA_861_MASK)
#define DBI_WINDOW_REG_DATA_861_RESET                                          0x0
#define DBI_WINDOW_REG_861_ADDRESS                                             (0xd74 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_861_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_861_RESET                                               0x0

// 0xd78 (DBI_WINDOW_REG_862)
#define DBI_WINDOW_REG_DATA_862_LSB                                            0
#define DBI_WINDOW_REG_DATA_862_MSB                                            31
#define DBI_WINDOW_REG_DATA_862_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_862_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_862_MASK) >> DBI_WINDOW_REG_DATA_862_LSB)
#define DBI_WINDOW_REG_DATA_862_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_862_LSB) & DBI_WINDOW_REG_DATA_862_MASK)
#define DBI_WINDOW_REG_DATA_862_RESET                                          0x0
#define DBI_WINDOW_REG_862_ADDRESS                                             (0xd78 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_862_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_862_RESET                                               0x0

// 0xd7c (DBI_WINDOW_REG_863)
#define DBI_WINDOW_REG_DATA_863_LSB                                            0
#define DBI_WINDOW_REG_DATA_863_MSB                                            31
#define DBI_WINDOW_REG_DATA_863_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_863_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_863_MASK) >> DBI_WINDOW_REG_DATA_863_LSB)
#define DBI_WINDOW_REG_DATA_863_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_863_LSB) & DBI_WINDOW_REG_DATA_863_MASK)
#define DBI_WINDOW_REG_DATA_863_RESET                                          0x0
#define DBI_WINDOW_REG_863_ADDRESS                                             (0xd7c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_863_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_863_RESET                                               0x0

// 0xd80 (DBI_WINDOW_REG_864)
#define DBI_WINDOW_REG_DATA_864_LSB                                            0
#define DBI_WINDOW_REG_DATA_864_MSB                                            31
#define DBI_WINDOW_REG_DATA_864_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_864_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_864_MASK) >> DBI_WINDOW_REG_DATA_864_LSB)
#define DBI_WINDOW_REG_DATA_864_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_864_LSB) & DBI_WINDOW_REG_DATA_864_MASK)
#define DBI_WINDOW_REG_DATA_864_RESET                                          0x0
#define DBI_WINDOW_REG_864_ADDRESS                                             (0xd80 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_864_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_864_RESET                                               0x0

// 0xd84 (DBI_WINDOW_REG_865)
#define DBI_WINDOW_REG_DATA_865_LSB                                            0
#define DBI_WINDOW_REG_DATA_865_MSB                                            31
#define DBI_WINDOW_REG_DATA_865_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_865_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_865_MASK) >> DBI_WINDOW_REG_DATA_865_LSB)
#define DBI_WINDOW_REG_DATA_865_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_865_LSB) & DBI_WINDOW_REG_DATA_865_MASK)
#define DBI_WINDOW_REG_DATA_865_RESET                                          0x0
#define DBI_WINDOW_REG_865_ADDRESS                                             (0xd84 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_865_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_865_RESET                                               0x0

// 0xd88 (DBI_WINDOW_REG_866)
#define DBI_WINDOW_REG_DATA_866_LSB                                            0
#define DBI_WINDOW_REG_DATA_866_MSB                                            31
#define DBI_WINDOW_REG_DATA_866_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_866_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_866_MASK) >> DBI_WINDOW_REG_DATA_866_LSB)
#define DBI_WINDOW_REG_DATA_866_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_866_LSB) & DBI_WINDOW_REG_DATA_866_MASK)
#define DBI_WINDOW_REG_DATA_866_RESET                                          0x0
#define DBI_WINDOW_REG_866_ADDRESS                                             (0xd88 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_866_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_866_RESET                                               0x0

// 0xd8c (DBI_WINDOW_REG_867)
#define DBI_WINDOW_REG_DATA_867_LSB                                            0
#define DBI_WINDOW_REG_DATA_867_MSB                                            31
#define DBI_WINDOW_REG_DATA_867_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_867_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_867_MASK) >> DBI_WINDOW_REG_DATA_867_LSB)
#define DBI_WINDOW_REG_DATA_867_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_867_LSB) & DBI_WINDOW_REG_DATA_867_MASK)
#define DBI_WINDOW_REG_DATA_867_RESET                                          0x0
#define DBI_WINDOW_REG_867_ADDRESS                                             (0xd8c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_867_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_867_RESET                                               0x0

// 0xd90 (DBI_WINDOW_REG_868)
#define DBI_WINDOW_REG_DATA_868_LSB                                            0
#define DBI_WINDOW_REG_DATA_868_MSB                                            31
#define DBI_WINDOW_REG_DATA_868_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_868_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_868_MASK) >> DBI_WINDOW_REG_DATA_868_LSB)
#define DBI_WINDOW_REG_DATA_868_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_868_LSB) & DBI_WINDOW_REG_DATA_868_MASK)
#define DBI_WINDOW_REG_DATA_868_RESET                                          0x0
#define DBI_WINDOW_REG_868_ADDRESS                                             (0xd90 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_868_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_868_RESET                                               0x0

// 0xd94 (DBI_WINDOW_REG_869)
#define DBI_WINDOW_REG_DATA_869_LSB                                            0
#define DBI_WINDOW_REG_DATA_869_MSB                                            31
#define DBI_WINDOW_REG_DATA_869_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_869_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_869_MASK) >> DBI_WINDOW_REG_DATA_869_LSB)
#define DBI_WINDOW_REG_DATA_869_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_869_LSB) & DBI_WINDOW_REG_DATA_869_MASK)
#define DBI_WINDOW_REG_DATA_869_RESET                                          0x0
#define DBI_WINDOW_REG_869_ADDRESS                                             (0xd94 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_869_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_869_RESET                                               0x0

// 0xd98 (DBI_WINDOW_REG_870)
#define DBI_WINDOW_REG_DATA_870_LSB                                            0
#define DBI_WINDOW_REG_DATA_870_MSB                                            31
#define DBI_WINDOW_REG_DATA_870_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_870_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_870_MASK) >> DBI_WINDOW_REG_DATA_870_LSB)
#define DBI_WINDOW_REG_DATA_870_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_870_LSB) & DBI_WINDOW_REG_DATA_870_MASK)
#define DBI_WINDOW_REG_DATA_870_RESET                                          0x0
#define DBI_WINDOW_REG_870_ADDRESS                                             (0xd98 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_870_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_870_RESET                                               0x0

// 0xd9c (DBI_WINDOW_REG_871)
#define DBI_WINDOW_REG_DATA_871_LSB                                            0
#define DBI_WINDOW_REG_DATA_871_MSB                                            31
#define DBI_WINDOW_REG_DATA_871_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_871_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_871_MASK) >> DBI_WINDOW_REG_DATA_871_LSB)
#define DBI_WINDOW_REG_DATA_871_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_871_LSB) & DBI_WINDOW_REG_DATA_871_MASK)
#define DBI_WINDOW_REG_DATA_871_RESET                                          0x0
#define DBI_WINDOW_REG_871_ADDRESS                                             (0xd9c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_871_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_871_RESET                                               0x0

// 0xda0 (DBI_WINDOW_REG_872)
#define DBI_WINDOW_REG_DATA_872_LSB                                            0
#define DBI_WINDOW_REG_DATA_872_MSB                                            31
#define DBI_WINDOW_REG_DATA_872_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_872_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_872_MASK) >> DBI_WINDOW_REG_DATA_872_LSB)
#define DBI_WINDOW_REG_DATA_872_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_872_LSB) & DBI_WINDOW_REG_DATA_872_MASK)
#define DBI_WINDOW_REG_DATA_872_RESET                                          0x0
#define DBI_WINDOW_REG_872_ADDRESS                                             (0xda0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_872_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_872_RESET                                               0x0

// 0xda4 (DBI_WINDOW_REG_873)
#define DBI_WINDOW_REG_DATA_873_LSB                                            0
#define DBI_WINDOW_REG_DATA_873_MSB                                            31
#define DBI_WINDOW_REG_DATA_873_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_873_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_873_MASK) >> DBI_WINDOW_REG_DATA_873_LSB)
#define DBI_WINDOW_REG_DATA_873_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_873_LSB) & DBI_WINDOW_REG_DATA_873_MASK)
#define DBI_WINDOW_REG_DATA_873_RESET                                          0x0
#define DBI_WINDOW_REG_873_ADDRESS                                             (0xda4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_873_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_873_RESET                                               0x0

// 0xda8 (DBI_WINDOW_REG_874)
#define DBI_WINDOW_REG_DATA_874_LSB                                            0
#define DBI_WINDOW_REG_DATA_874_MSB                                            31
#define DBI_WINDOW_REG_DATA_874_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_874_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_874_MASK) >> DBI_WINDOW_REG_DATA_874_LSB)
#define DBI_WINDOW_REG_DATA_874_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_874_LSB) & DBI_WINDOW_REG_DATA_874_MASK)
#define DBI_WINDOW_REG_DATA_874_RESET                                          0x0
#define DBI_WINDOW_REG_874_ADDRESS                                             (0xda8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_874_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_874_RESET                                               0x0

// 0xdac (DBI_WINDOW_REG_875)
#define DBI_WINDOW_REG_DATA_875_LSB                                            0
#define DBI_WINDOW_REG_DATA_875_MSB                                            31
#define DBI_WINDOW_REG_DATA_875_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_875_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_875_MASK) >> DBI_WINDOW_REG_DATA_875_LSB)
#define DBI_WINDOW_REG_DATA_875_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_875_LSB) & DBI_WINDOW_REG_DATA_875_MASK)
#define DBI_WINDOW_REG_DATA_875_RESET                                          0x0
#define DBI_WINDOW_REG_875_ADDRESS                                             (0xdac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_875_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_875_RESET                                               0x0

// 0xdb0 (DBI_WINDOW_REG_876)
#define DBI_WINDOW_REG_DATA_876_LSB                                            0
#define DBI_WINDOW_REG_DATA_876_MSB                                            31
#define DBI_WINDOW_REG_DATA_876_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_876_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_876_MASK) >> DBI_WINDOW_REG_DATA_876_LSB)
#define DBI_WINDOW_REG_DATA_876_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_876_LSB) & DBI_WINDOW_REG_DATA_876_MASK)
#define DBI_WINDOW_REG_DATA_876_RESET                                          0x0
#define DBI_WINDOW_REG_876_ADDRESS                                             (0xdb0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_876_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_876_RESET                                               0x0

// 0xdb4 (DBI_WINDOW_REG_877)
#define DBI_WINDOW_REG_DATA_877_LSB                                            0
#define DBI_WINDOW_REG_DATA_877_MSB                                            31
#define DBI_WINDOW_REG_DATA_877_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_877_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_877_MASK) >> DBI_WINDOW_REG_DATA_877_LSB)
#define DBI_WINDOW_REG_DATA_877_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_877_LSB) & DBI_WINDOW_REG_DATA_877_MASK)
#define DBI_WINDOW_REG_DATA_877_RESET                                          0x0
#define DBI_WINDOW_REG_877_ADDRESS                                             (0xdb4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_877_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_877_RESET                                               0x0

// 0xdb8 (DBI_WINDOW_REG_878)
#define DBI_WINDOW_REG_DATA_878_LSB                                            0
#define DBI_WINDOW_REG_DATA_878_MSB                                            31
#define DBI_WINDOW_REG_DATA_878_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_878_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_878_MASK) >> DBI_WINDOW_REG_DATA_878_LSB)
#define DBI_WINDOW_REG_DATA_878_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_878_LSB) & DBI_WINDOW_REG_DATA_878_MASK)
#define DBI_WINDOW_REG_DATA_878_RESET                                          0x0
#define DBI_WINDOW_REG_878_ADDRESS                                             (0xdb8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_878_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_878_RESET                                               0x0

// 0xdbc (DBI_WINDOW_REG_879)
#define DBI_WINDOW_REG_DATA_879_LSB                                            0
#define DBI_WINDOW_REG_DATA_879_MSB                                            31
#define DBI_WINDOW_REG_DATA_879_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_879_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_879_MASK) >> DBI_WINDOW_REG_DATA_879_LSB)
#define DBI_WINDOW_REG_DATA_879_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_879_LSB) & DBI_WINDOW_REG_DATA_879_MASK)
#define DBI_WINDOW_REG_DATA_879_RESET                                          0x0
#define DBI_WINDOW_REG_879_ADDRESS                                             (0xdbc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_879_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_879_RESET                                               0x0

// 0xdc0 (DBI_WINDOW_REG_880)
#define DBI_WINDOW_REG_DATA_880_LSB                                            0
#define DBI_WINDOW_REG_DATA_880_MSB                                            31
#define DBI_WINDOW_REG_DATA_880_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_880_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_880_MASK) >> DBI_WINDOW_REG_DATA_880_LSB)
#define DBI_WINDOW_REG_DATA_880_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_880_LSB) & DBI_WINDOW_REG_DATA_880_MASK)
#define DBI_WINDOW_REG_DATA_880_RESET                                          0x0
#define DBI_WINDOW_REG_880_ADDRESS                                             (0xdc0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_880_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_880_RESET                                               0x0

// 0xdc4 (DBI_WINDOW_REG_881)
#define DBI_WINDOW_REG_DATA_881_LSB                                            0
#define DBI_WINDOW_REG_DATA_881_MSB                                            31
#define DBI_WINDOW_REG_DATA_881_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_881_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_881_MASK) >> DBI_WINDOW_REG_DATA_881_LSB)
#define DBI_WINDOW_REG_DATA_881_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_881_LSB) & DBI_WINDOW_REG_DATA_881_MASK)
#define DBI_WINDOW_REG_DATA_881_RESET                                          0x0
#define DBI_WINDOW_REG_881_ADDRESS                                             (0xdc4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_881_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_881_RESET                                               0x0

// 0xdc8 (DBI_WINDOW_REG_882)
#define DBI_WINDOW_REG_DATA_882_LSB                                            0
#define DBI_WINDOW_REG_DATA_882_MSB                                            31
#define DBI_WINDOW_REG_DATA_882_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_882_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_882_MASK) >> DBI_WINDOW_REG_DATA_882_LSB)
#define DBI_WINDOW_REG_DATA_882_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_882_LSB) & DBI_WINDOW_REG_DATA_882_MASK)
#define DBI_WINDOW_REG_DATA_882_RESET                                          0x0
#define DBI_WINDOW_REG_882_ADDRESS                                             (0xdc8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_882_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_882_RESET                                               0x0

// 0xdcc (DBI_WINDOW_REG_883)
#define DBI_WINDOW_REG_DATA_883_LSB                                            0
#define DBI_WINDOW_REG_DATA_883_MSB                                            31
#define DBI_WINDOW_REG_DATA_883_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_883_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_883_MASK) >> DBI_WINDOW_REG_DATA_883_LSB)
#define DBI_WINDOW_REG_DATA_883_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_883_LSB) & DBI_WINDOW_REG_DATA_883_MASK)
#define DBI_WINDOW_REG_DATA_883_RESET                                          0x0
#define DBI_WINDOW_REG_883_ADDRESS                                             (0xdcc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_883_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_883_RESET                                               0x0

// 0xdd0 (DBI_WINDOW_REG_884)
#define DBI_WINDOW_REG_DATA_884_LSB                                            0
#define DBI_WINDOW_REG_DATA_884_MSB                                            31
#define DBI_WINDOW_REG_DATA_884_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_884_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_884_MASK) >> DBI_WINDOW_REG_DATA_884_LSB)
#define DBI_WINDOW_REG_DATA_884_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_884_LSB) & DBI_WINDOW_REG_DATA_884_MASK)
#define DBI_WINDOW_REG_DATA_884_RESET                                          0x0
#define DBI_WINDOW_REG_884_ADDRESS                                             (0xdd0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_884_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_884_RESET                                               0x0

// 0xdd4 (DBI_WINDOW_REG_885)
#define DBI_WINDOW_REG_DATA_885_LSB                                            0
#define DBI_WINDOW_REG_DATA_885_MSB                                            31
#define DBI_WINDOW_REG_DATA_885_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_885_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_885_MASK) >> DBI_WINDOW_REG_DATA_885_LSB)
#define DBI_WINDOW_REG_DATA_885_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_885_LSB) & DBI_WINDOW_REG_DATA_885_MASK)
#define DBI_WINDOW_REG_DATA_885_RESET                                          0x0
#define DBI_WINDOW_REG_885_ADDRESS                                             (0xdd4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_885_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_885_RESET                                               0x0

// 0xdd8 (DBI_WINDOW_REG_886)
#define DBI_WINDOW_REG_DATA_886_LSB                                            0
#define DBI_WINDOW_REG_DATA_886_MSB                                            31
#define DBI_WINDOW_REG_DATA_886_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_886_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_886_MASK) >> DBI_WINDOW_REG_DATA_886_LSB)
#define DBI_WINDOW_REG_DATA_886_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_886_LSB) & DBI_WINDOW_REG_DATA_886_MASK)
#define DBI_WINDOW_REG_DATA_886_RESET                                          0x0
#define DBI_WINDOW_REG_886_ADDRESS                                             (0xdd8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_886_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_886_RESET                                               0x0

// 0xddc (DBI_WINDOW_REG_887)
#define DBI_WINDOW_REG_DATA_887_LSB                                            0
#define DBI_WINDOW_REG_DATA_887_MSB                                            31
#define DBI_WINDOW_REG_DATA_887_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_887_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_887_MASK) >> DBI_WINDOW_REG_DATA_887_LSB)
#define DBI_WINDOW_REG_DATA_887_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_887_LSB) & DBI_WINDOW_REG_DATA_887_MASK)
#define DBI_WINDOW_REG_DATA_887_RESET                                          0x0
#define DBI_WINDOW_REG_887_ADDRESS                                             (0xddc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_887_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_887_RESET                                               0x0

// 0xde0 (DBI_WINDOW_REG_888)
#define DBI_WINDOW_REG_DATA_888_LSB                                            0
#define DBI_WINDOW_REG_DATA_888_MSB                                            31
#define DBI_WINDOW_REG_DATA_888_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_888_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_888_MASK) >> DBI_WINDOW_REG_DATA_888_LSB)
#define DBI_WINDOW_REG_DATA_888_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_888_LSB) & DBI_WINDOW_REG_DATA_888_MASK)
#define DBI_WINDOW_REG_DATA_888_RESET                                          0x0
#define DBI_WINDOW_REG_888_ADDRESS                                             (0xde0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_888_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_888_RESET                                               0x0

// 0xde4 (DBI_WINDOW_REG_889)
#define DBI_WINDOW_REG_DATA_889_LSB                                            0
#define DBI_WINDOW_REG_DATA_889_MSB                                            31
#define DBI_WINDOW_REG_DATA_889_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_889_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_889_MASK) >> DBI_WINDOW_REG_DATA_889_LSB)
#define DBI_WINDOW_REG_DATA_889_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_889_LSB) & DBI_WINDOW_REG_DATA_889_MASK)
#define DBI_WINDOW_REG_DATA_889_RESET                                          0x0
#define DBI_WINDOW_REG_889_ADDRESS                                             (0xde4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_889_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_889_RESET                                               0x0

// 0xde8 (DBI_WINDOW_REG_890)
#define DBI_WINDOW_REG_DATA_890_LSB                                            0
#define DBI_WINDOW_REG_DATA_890_MSB                                            31
#define DBI_WINDOW_REG_DATA_890_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_890_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_890_MASK) >> DBI_WINDOW_REG_DATA_890_LSB)
#define DBI_WINDOW_REG_DATA_890_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_890_LSB) & DBI_WINDOW_REG_DATA_890_MASK)
#define DBI_WINDOW_REG_DATA_890_RESET                                          0x0
#define DBI_WINDOW_REG_890_ADDRESS                                             (0xde8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_890_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_890_RESET                                               0x0

// 0xdec (DBI_WINDOW_REG_891)
#define DBI_WINDOW_REG_DATA_891_LSB                                            0
#define DBI_WINDOW_REG_DATA_891_MSB                                            31
#define DBI_WINDOW_REG_DATA_891_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_891_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_891_MASK) >> DBI_WINDOW_REG_DATA_891_LSB)
#define DBI_WINDOW_REG_DATA_891_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_891_LSB) & DBI_WINDOW_REG_DATA_891_MASK)
#define DBI_WINDOW_REG_DATA_891_RESET                                          0x0
#define DBI_WINDOW_REG_891_ADDRESS                                             (0xdec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_891_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_891_RESET                                               0x0

// 0xdf0 (DBI_WINDOW_REG_892)
#define DBI_WINDOW_REG_DATA_892_LSB                                            0
#define DBI_WINDOW_REG_DATA_892_MSB                                            31
#define DBI_WINDOW_REG_DATA_892_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_892_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_892_MASK) >> DBI_WINDOW_REG_DATA_892_LSB)
#define DBI_WINDOW_REG_DATA_892_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_892_LSB) & DBI_WINDOW_REG_DATA_892_MASK)
#define DBI_WINDOW_REG_DATA_892_RESET                                          0x0
#define DBI_WINDOW_REG_892_ADDRESS                                             (0xdf0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_892_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_892_RESET                                               0x0

// 0xdf4 (DBI_WINDOW_REG_893)
#define DBI_WINDOW_REG_DATA_893_LSB                                            0
#define DBI_WINDOW_REG_DATA_893_MSB                                            31
#define DBI_WINDOW_REG_DATA_893_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_893_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_893_MASK) >> DBI_WINDOW_REG_DATA_893_LSB)
#define DBI_WINDOW_REG_DATA_893_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_893_LSB) & DBI_WINDOW_REG_DATA_893_MASK)
#define DBI_WINDOW_REG_DATA_893_RESET                                          0x0
#define DBI_WINDOW_REG_893_ADDRESS                                             (0xdf4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_893_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_893_RESET                                               0x0

// 0xdf8 (DBI_WINDOW_REG_894)
#define DBI_WINDOW_REG_DATA_894_LSB                                            0
#define DBI_WINDOW_REG_DATA_894_MSB                                            31
#define DBI_WINDOW_REG_DATA_894_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_894_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_894_MASK) >> DBI_WINDOW_REG_DATA_894_LSB)
#define DBI_WINDOW_REG_DATA_894_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_894_LSB) & DBI_WINDOW_REG_DATA_894_MASK)
#define DBI_WINDOW_REG_DATA_894_RESET                                          0x0
#define DBI_WINDOW_REG_894_ADDRESS                                             (0xdf8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_894_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_894_RESET                                               0x0

// 0xdfc (DBI_WINDOW_REG_895)
#define DBI_WINDOW_REG_DATA_895_LSB                                            0
#define DBI_WINDOW_REG_DATA_895_MSB                                            31
#define DBI_WINDOW_REG_DATA_895_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_895_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_895_MASK) >> DBI_WINDOW_REG_DATA_895_LSB)
#define DBI_WINDOW_REG_DATA_895_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_895_LSB) & DBI_WINDOW_REG_DATA_895_MASK)
#define DBI_WINDOW_REG_DATA_895_RESET                                          0x0
#define DBI_WINDOW_REG_895_ADDRESS                                             (0xdfc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_895_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_895_RESET                                               0x0

// 0xe00 (DBI_WINDOW_REG_896)
#define DBI_WINDOW_REG_DATA_896_LSB                                            0
#define DBI_WINDOW_REG_DATA_896_MSB                                            31
#define DBI_WINDOW_REG_DATA_896_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_896_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_896_MASK) >> DBI_WINDOW_REG_DATA_896_LSB)
#define DBI_WINDOW_REG_DATA_896_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_896_LSB) & DBI_WINDOW_REG_DATA_896_MASK)
#define DBI_WINDOW_REG_DATA_896_RESET                                          0x0
#define DBI_WINDOW_REG_896_ADDRESS                                             (0xe00 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_896_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_896_RESET                                               0x0

// 0xe04 (DBI_WINDOW_REG_897)
#define DBI_WINDOW_REG_DATA_897_LSB                                            0
#define DBI_WINDOW_REG_DATA_897_MSB                                            31
#define DBI_WINDOW_REG_DATA_897_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_897_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_897_MASK) >> DBI_WINDOW_REG_DATA_897_LSB)
#define DBI_WINDOW_REG_DATA_897_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_897_LSB) & DBI_WINDOW_REG_DATA_897_MASK)
#define DBI_WINDOW_REG_DATA_897_RESET                                          0x0
#define DBI_WINDOW_REG_897_ADDRESS                                             (0xe04 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_897_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_897_RESET                                               0x0

// 0xe08 (DBI_WINDOW_REG_898)
#define DBI_WINDOW_REG_DATA_898_LSB                                            0
#define DBI_WINDOW_REG_DATA_898_MSB                                            31
#define DBI_WINDOW_REG_DATA_898_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_898_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_898_MASK) >> DBI_WINDOW_REG_DATA_898_LSB)
#define DBI_WINDOW_REG_DATA_898_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_898_LSB) & DBI_WINDOW_REG_DATA_898_MASK)
#define DBI_WINDOW_REG_DATA_898_RESET                                          0x0
#define DBI_WINDOW_REG_898_ADDRESS                                             (0xe08 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_898_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_898_RESET                                               0x0

// 0xe0c (DBI_WINDOW_REG_899)
#define DBI_WINDOW_REG_DATA_899_LSB                                            0
#define DBI_WINDOW_REG_DATA_899_MSB                                            31
#define DBI_WINDOW_REG_DATA_899_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_899_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_899_MASK) >> DBI_WINDOW_REG_DATA_899_LSB)
#define DBI_WINDOW_REG_DATA_899_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_899_LSB) & DBI_WINDOW_REG_DATA_899_MASK)
#define DBI_WINDOW_REG_DATA_899_RESET                                          0x0
#define DBI_WINDOW_REG_899_ADDRESS                                             (0xe0c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_899_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_899_RESET                                               0x0

// 0xe10 (DBI_WINDOW_REG_900)
#define DBI_WINDOW_REG_DATA_900_LSB                                            0
#define DBI_WINDOW_REG_DATA_900_MSB                                            31
#define DBI_WINDOW_REG_DATA_900_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_900_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_900_MASK) >> DBI_WINDOW_REG_DATA_900_LSB)
#define DBI_WINDOW_REG_DATA_900_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_900_LSB) & DBI_WINDOW_REG_DATA_900_MASK)
#define DBI_WINDOW_REG_DATA_900_RESET                                          0x0
#define DBI_WINDOW_REG_900_ADDRESS                                             (0xe10 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_900_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_900_RESET                                               0x0

// 0xe14 (DBI_WINDOW_REG_901)
#define DBI_WINDOW_REG_DATA_901_LSB                                            0
#define DBI_WINDOW_REG_DATA_901_MSB                                            31
#define DBI_WINDOW_REG_DATA_901_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_901_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_901_MASK) >> DBI_WINDOW_REG_DATA_901_LSB)
#define DBI_WINDOW_REG_DATA_901_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_901_LSB) & DBI_WINDOW_REG_DATA_901_MASK)
#define DBI_WINDOW_REG_DATA_901_RESET                                          0x0
#define DBI_WINDOW_REG_901_ADDRESS                                             (0xe14 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_901_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_901_RESET                                               0x0

// 0xe18 (DBI_WINDOW_REG_902)
#define DBI_WINDOW_REG_DATA_902_LSB                                            0
#define DBI_WINDOW_REG_DATA_902_MSB                                            31
#define DBI_WINDOW_REG_DATA_902_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_902_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_902_MASK) >> DBI_WINDOW_REG_DATA_902_LSB)
#define DBI_WINDOW_REG_DATA_902_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_902_LSB) & DBI_WINDOW_REG_DATA_902_MASK)
#define DBI_WINDOW_REG_DATA_902_RESET                                          0x0
#define DBI_WINDOW_REG_902_ADDRESS                                             (0xe18 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_902_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_902_RESET                                               0x0

// 0xe1c (DBI_WINDOW_REG_903)
#define DBI_WINDOW_REG_DATA_903_LSB                                            0
#define DBI_WINDOW_REG_DATA_903_MSB                                            31
#define DBI_WINDOW_REG_DATA_903_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_903_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_903_MASK) >> DBI_WINDOW_REG_DATA_903_LSB)
#define DBI_WINDOW_REG_DATA_903_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_903_LSB) & DBI_WINDOW_REG_DATA_903_MASK)
#define DBI_WINDOW_REG_DATA_903_RESET                                          0x0
#define DBI_WINDOW_REG_903_ADDRESS                                             (0xe1c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_903_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_903_RESET                                               0x0

// 0xe20 (DBI_WINDOW_REG_904)
#define DBI_WINDOW_REG_DATA_904_LSB                                            0
#define DBI_WINDOW_REG_DATA_904_MSB                                            31
#define DBI_WINDOW_REG_DATA_904_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_904_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_904_MASK) >> DBI_WINDOW_REG_DATA_904_LSB)
#define DBI_WINDOW_REG_DATA_904_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_904_LSB) & DBI_WINDOW_REG_DATA_904_MASK)
#define DBI_WINDOW_REG_DATA_904_RESET                                          0x0
#define DBI_WINDOW_REG_904_ADDRESS                                             (0xe20 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_904_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_904_RESET                                               0x0

// 0xe24 (DBI_WINDOW_REG_905)
#define DBI_WINDOW_REG_DATA_905_LSB                                            0
#define DBI_WINDOW_REG_DATA_905_MSB                                            31
#define DBI_WINDOW_REG_DATA_905_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_905_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_905_MASK) >> DBI_WINDOW_REG_DATA_905_LSB)
#define DBI_WINDOW_REG_DATA_905_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_905_LSB) & DBI_WINDOW_REG_DATA_905_MASK)
#define DBI_WINDOW_REG_DATA_905_RESET                                          0x0
#define DBI_WINDOW_REG_905_ADDRESS                                             (0xe24 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_905_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_905_RESET                                               0x0

// 0xe28 (DBI_WINDOW_REG_906)
#define DBI_WINDOW_REG_DATA_906_LSB                                            0
#define DBI_WINDOW_REG_DATA_906_MSB                                            31
#define DBI_WINDOW_REG_DATA_906_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_906_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_906_MASK) >> DBI_WINDOW_REG_DATA_906_LSB)
#define DBI_WINDOW_REG_DATA_906_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_906_LSB) & DBI_WINDOW_REG_DATA_906_MASK)
#define DBI_WINDOW_REG_DATA_906_RESET                                          0x0
#define DBI_WINDOW_REG_906_ADDRESS                                             (0xe28 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_906_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_906_RESET                                               0x0

// 0xe2c (DBI_WINDOW_REG_907)
#define DBI_WINDOW_REG_DATA_907_LSB                                            0
#define DBI_WINDOW_REG_DATA_907_MSB                                            31
#define DBI_WINDOW_REG_DATA_907_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_907_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_907_MASK) >> DBI_WINDOW_REG_DATA_907_LSB)
#define DBI_WINDOW_REG_DATA_907_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_907_LSB) & DBI_WINDOW_REG_DATA_907_MASK)
#define DBI_WINDOW_REG_DATA_907_RESET                                          0x0
#define DBI_WINDOW_REG_907_ADDRESS                                             (0xe2c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_907_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_907_RESET                                               0x0

// 0xe30 (DBI_WINDOW_REG_908)
#define DBI_WINDOW_REG_DATA_908_LSB                                            0
#define DBI_WINDOW_REG_DATA_908_MSB                                            31
#define DBI_WINDOW_REG_DATA_908_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_908_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_908_MASK) >> DBI_WINDOW_REG_DATA_908_LSB)
#define DBI_WINDOW_REG_DATA_908_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_908_LSB) & DBI_WINDOW_REG_DATA_908_MASK)
#define DBI_WINDOW_REG_DATA_908_RESET                                          0x0
#define DBI_WINDOW_REG_908_ADDRESS                                             (0xe30 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_908_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_908_RESET                                               0x0

// 0xe34 (DBI_WINDOW_REG_909)
#define DBI_WINDOW_REG_DATA_909_LSB                                            0
#define DBI_WINDOW_REG_DATA_909_MSB                                            31
#define DBI_WINDOW_REG_DATA_909_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_909_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_909_MASK) >> DBI_WINDOW_REG_DATA_909_LSB)
#define DBI_WINDOW_REG_DATA_909_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_909_LSB) & DBI_WINDOW_REG_DATA_909_MASK)
#define DBI_WINDOW_REG_DATA_909_RESET                                          0x0
#define DBI_WINDOW_REG_909_ADDRESS                                             (0xe34 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_909_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_909_RESET                                               0x0

// 0xe38 (DBI_WINDOW_REG_910)
#define DBI_WINDOW_REG_DATA_910_LSB                                            0
#define DBI_WINDOW_REG_DATA_910_MSB                                            31
#define DBI_WINDOW_REG_DATA_910_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_910_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_910_MASK) >> DBI_WINDOW_REG_DATA_910_LSB)
#define DBI_WINDOW_REG_DATA_910_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_910_LSB) & DBI_WINDOW_REG_DATA_910_MASK)
#define DBI_WINDOW_REG_DATA_910_RESET                                          0x0
#define DBI_WINDOW_REG_910_ADDRESS                                             (0xe38 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_910_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_910_RESET                                               0x0

// 0xe3c (DBI_WINDOW_REG_911)
#define DBI_WINDOW_REG_DATA_911_LSB                                            0
#define DBI_WINDOW_REG_DATA_911_MSB                                            31
#define DBI_WINDOW_REG_DATA_911_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_911_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_911_MASK) >> DBI_WINDOW_REG_DATA_911_LSB)
#define DBI_WINDOW_REG_DATA_911_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_911_LSB) & DBI_WINDOW_REG_DATA_911_MASK)
#define DBI_WINDOW_REG_DATA_911_RESET                                          0x0
#define DBI_WINDOW_REG_911_ADDRESS                                             (0xe3c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_911_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_911_RESET                                               0x0

// 0xe40 (DBI_WINDOW_REG_912)
#define DBI_WINDOW_REG_DATA_912_LSB                                            0
#define DBI_WINDOW_REG_DATA_912_MSB                                            31
#define DBI_WINDOW_REG_DATA_912_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_912_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_912_MASK) >> DBI_WINDOW_REG_DATA_912_LSB)
#define DBI_WINDOW_REG_DATA_912_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_912_LSB) & DBI_WINDOW_REG_DATA_912_MASK)
#define DBI_WINDOW_REG_DATA_912_RESET                                          0x0
#define DBI_WINDOW_REG_912_ADDRESS                                             (0xe40 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_912_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_912_RESET                                               0x0

// 0xe44 (DBI_WINDOW_REG_913)
#define DBI_WINDOW_REG_DATA_913_LSB                                            0
#define DBI_WINDOW_REG_DATA_913_MSB                                            31
#define DBI_WINDOW_REG_DATA_913_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_913_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_913_MASK) >> DBI_WINDOW_REG_DATA_913_LSB)
#define DBI_WINDOW_REG_DATA_913_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_913_LSB) & DBI_WINDOW_REG_DATA_913_MASK)
#define DBI_WINDOW_REG_DATA_913_RESET                                          0x0
#define DBI_WINDOW_REG_913_ADDRESS                                             (0xe44 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_913_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_913_RESET                                               0x0

// 0xe48 (DBI_WINDOW_REG_914)
#define DBI_WINDOW_REG_DATA_914_LSB                                            0
#define DBI_WINDOW_REG_DATA_914_MSB                                            31
#define DBI_WINDOW_REG_DATA_914_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_914_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_914_MASK) >> DBI_WINDOW_REG_DATA_914_LSB)
#define DBI_WINDOW_REG_DATA_914_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_914_LSB) & DBI_WINDOW_REG_DATA_914_MASK)
#define DBI_WINDOW_REG_DATA_914_RESET                                          0x0
#define DBI_WINDOW_REG_914_ADDRESS                                             (0xe48 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_914_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_914_RESET                                               0x0

// 0xe4c (DBI_WINDOW_REG_915)
#define DBI_WINDOW_REG_DATA_915_LSB                                            0
#define DBI_WINDOW_REG_DATA_915_MSB                                            31
#define DBI_WINDOW_REG_DATA_915_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_915_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_915_MASK) >> DBI_WINDOW_REG_DATA_915_LSB)
#define DBI_WINDOW_REG_DATA_915_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_915_LSB) & DBI_WINDOW_REG_DATA_915_MASK)
#define DBI_WINDOW_REG_DATA_915_RESET                                          0x0
#define DBI_WINDOW_REG_915_ADDRESS                                             (0xe4c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_915_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_915_RESET                                               0x0

// 0xe50 (DBI_WINDOW_REG_916)
#define DBI_WINDOW_REG_DATA_916_LSB                                            0
#define DBI_WINDOW_REG_DATA_916_MSB                                            31
#define DBI_WINDOW_REG_DATA_916_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_916_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_916_MASK) >> DBI_WINDOW_REG_DATA_916_LSB)
#define DBI_WINDOW_REG_DATA_916_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_916_LSB) & DBI_WINDOW_REG_DATA_916_MASK)
#define DBI_WINDOW_REG_DATA_916_RESET                                          0x0
#define DBI_WINDOW_REG_916_ADDRESS                                             (0xe50 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_916_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_916_RESET                                               0x0

// 0xe54 (DBI_WINDOW_REG_917)
#define DBI_WINDOW_REG_DATA_917_LSB                                            0
#define DBI_WINDOW_REG_DATA_917_MSB                                            31
#define DBI_WINDOW_REG_DATA_917_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_917_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_917_MASK) >> DBI_WINDOW_REG_DATA_917_LSB)
#define DBI_WINDOW_REG_DATA_917_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_917_LSB) & DBI_WINDOW_REG_DATA_917_MASK)
#define DBI_WINDOW_REG_DATA_917_RESET                                          0x0
#define DBI_WINDOW_REG_917_ADDRESS                                             (0xe54 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_917_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_917_RESET                                               0x0

// 0xe58 (DBI_WINDOW_REG_918)
#define DBI_WINDOW_REG_DATA_918_LSB                                            0
#define DBI_WINDOW_REG_DATA_918_MSB                                            31
#define DBI_WINDOW_REG_DATA_918_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_918_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_918_MASK) >> DBI_WINDOW_REG_DATA_918_LSB)
#define DBI_WINDOW_REG_DATA_918_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_918_LSB) & DBI_WINDOW_REG_DATA_918_MASK)
#define DBI_WINDOW_REG_DATA_918_RESET                                          0x0
#define DBI_WINDOW_REG_918_ADDRESS                                             (0xe58 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_918_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_918_RESET                                               0x0

// 0xe5c (DBI_WINDOW_REG_919)
#define DBI_WINDOW_REG_DATA_919_LSB                                            0
#define DBI_WINDOW_REG_DATA_919_MSB                                            31
#define DBI_WINDOW_REG_DATA_919_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_919_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_919_MASK) >> DBI_WINDOW_REG_DATA_919_LSB)
#define DBI_WINDOW_REG_DATA_919_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_919_LSB) & DBI_WINDOW_REG_DATA_919_MASK)
#define DBI_WINDOW_REG_DATA_919_RESET                                          0x0
#define DBI_WINDOW_REG_919_ADDRESS                                             (0xe5c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_919_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_919_RESET                                               0x0

// 0xe60 (DBI_WINDOW_REG_920)
#define DBI_WINDOW_REG_DATA_920_LSB                                            0
#define DBI_WINDOW_REG_DATA_920_MSB                                            31
#define DBI_WINDOW_REG_DATA_920_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_920_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_920_MASK) >> DBI_WINDOW_REG_DATA_920_LSB)
#define DBI_WINDOW_REG_DATA_920_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_920_LSB) & DBI_WINDOW_REG_DATA_920_MASK)
#define DBI_WINDOW_REG_DATA_920_RESET                                          0x0
#define DBI_WINDOW_REG_920_ADDRESS                                             (0xe60 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_920_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_920_RESET                                               0x0

// 0xe64 (DBI_WINDOW_REG_921)
#define DBI_WINDOW_REG_DATA_921_LSB                                            0
#define DBI_WINDOW_REG_DATA_921_MSB                                            31
#define DBI_WINDOW_REG_DATA_921_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_921_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_921_MASK) >> DBI_WINDOW_REG_DATA_921_LSB)
#define DBI_WINDOW_REG_DATA_921_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_921_LSB) & DBI_WINDOW_REG_DATA_921_MASK)
#define DBI_WINDOW_REG_DATA_921_RESET                                          0x0
#define DBI_WINDOW_REG_921_ADDRESS                                             (0xe64 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_921_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_921_RESET                                               0x0

// 0xe68 (DBI_WINDOW_REG_922)
#define DBI_WINDOW_REG_DATA_922_LSB                                            0
#define DBI_WINDOW_REG_DATA_922_MSB                                            31
#define DBI_WINDOW_REG_DATA_922_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_922_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_922_MASK) >> DBI_WINDOW_REG_DATA_922_LSB)
#define DBI_WINDOW_REG_DATA_922_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_922_LSB) & DBI_WINDOW_REG_DATA_922_MASK)
#define DBI_WINDOW_REG_DATA_922_RESET                                          0x0
#define DBI_WINDOW_REG_922_ADDRESS                                             (0xe68 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_922_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_922_RESET                                               0x0

// 0xe6c (DBI_WINDOW_REG_923)
#define DBI_WINDOW_REG_DATA_923_LSB                                            0
#define DBI_WINDOW_REG_DATA_923_MSB                                            31
#define DBI_WINDOW_REG_DATA_923_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_923_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_923_MASK) >> DBI_WINDOW_REG_DATA_923_LSB)
#define DBI_WINDOW_REG_DATA_923_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_923_LSB) & DBI_WINDOW_REG_DATA_923_MASK)
#define DBI_WINDOW_REG_DATA_923_RESET                                          0x0
#define DBI_WINDOW_REG_923_ADDRESS                                             (0xe6c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_923_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_923_RESET                                               0x0

// 0xe70 (DBI_WINDOW_REG_924)
#define DBI_WINDOW_REG_DATA_924_LSB                                            0
#define DBI_WINDOW_REG_DATA_924_MSB                                            31
#define DBI_WINDOW_REG_DATA_924_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_924_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_924_MASK) >> DBI_WINDOW_REG_DATA_924_LSB)
#define DBI_WINDOW_REG_DATA_924_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_924_LSB) & DBI_WINDOW_REG_DATA_924_MASK)
#define DBI_WINDOW_REG_DATA_924_RESET                                          0x0
#define DBI_WINDOW_REG_924_ADDRESS                                             (0xe70 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_924_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_924_RESET                                               0x0

// 0xe74 (DBI_WINDOW_REG_925)
#define DBI_WINDOW_REG_DATA_925_LSB                                            0
#define DBI_WINDOW_REG_DATA_925_MSB                                            31
#define DBI_WINDOW_REG_DATA_925_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_925_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_925_MASK) >> DBI_WINDOW_REG_DATA_925_LSB)
#define DBI_WINDOW_REG_DATA_925_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_925_LSB) & DBI_WINDOW_REG_DATA_925_MASK)
#define DBI_WINDOW_REG_DATA_925_RESET                                          0x0
#define DBI_WINDOW_REG_925_ADDRESS                                             (0xe74 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_925_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_925_RESET                                               0x0

// 0xe78 (DBI_WINDOW_REG_926)
#define DBI_WINDOW_REG_DATA_926_LSB                                            0
#define DBI_WINDOW_REG_DATA_926_MSB                                            31
#define DBI_WINDOW_REG_DATA_926_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_926_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_926_MASK) >> DBI_WINDOW_REG_DATA_926_LSB)
#define DBI_WINDOW_REG_DATA_926_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_926_LSB) & DBI_WINDOW_REG_DATA_926_MASK)
#define DBI_WINDOW_REG_DATA_926_RESET                                          0x0
#define DBI_WINDOW_REG_926_ADDRESS                                             (0xe78 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_926_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_926_RESET                                               0x0

// 0xe7c (DBI_WINDOW_REG_927)
#define DBI_WINDOW_REG_DATA_927_LSB                                            0
#define DBI_WINDOW_REG_DATA_927_MSB                                            31
#define DBI_WINDOW_REG_DATA_927_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_927_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_927_MASK) >> DBI_WINDOW_REG_DATA_927_LSB)
#define DBI_WINDOW_REG_DATA_927_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_927_LSB) & DBI_WINDOW_REG_DATA_927_MASK)
#define DBI_WINDOW_REG_DATA_927_RESET                                          0x0
#define DBI_WINDOW_REG_927_ADDRESS                                             (0xe7c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_927_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_927_RESET                                               0x0

// 0xe80 (DBI_WINDOW_REG_928)
#define DBI_WINDOW_REG_DATA_928_LSB                                            0
#define DBI_WINDOW_REG_DATA_928_MSB                                            31
#define DBI_WINDOW_REG_DATA_928_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_928_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_928_MASK) >> DBI_WINDOW_REG_DATA_928_LSB)
#define DBI_WINDOW_REG_DATA_928_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_928_LSB) & DBI_WINDOW_REG_DATA_928_MASK)
#define DBI_WINDOW_REG_DATA_928_RESET                                          0x0
#define DBI_WINDOW_REG_928_ADDRESS                                             (0xe80 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_928_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_928_RESET                                               0x0

// 0xe84 (DBI_WINDOW_REG_929)
#define DBI_WINDOW_REG_DATA_929_LSB                                            0
#define DBI_WINDOW_REG_DATA_929_MSB                                            31
#define DBI_WINDOW_REG_DATA_929_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_929_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_929_MASK) >> DBI_WINDOW_REG_DATA_929_LSB)
#define DBI_WINDOW_REG_DATA_929_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_929_LSB) & DBI_WINDOW_REG_DATA_929_MASK)
#define DBI_WINDOW_REG_DATA_929_RESET                                          0x0
#define DBI_WINDOW_REG_929_ADDRESS                                             (0xe84 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_929_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_929_RESET                                               0x0

// 0xe88 (DBI_WINDOW_REG_930)
#define DBI_WINDOW_REG_DATA_930_LSB                                            0
#define DBI_WINDOW_REG_DATA_930_MSB                                            31
#define DBI_WINDOW_REG_DATA_930_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_930_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_930_MASK) >> DBI_WINDOW_REG_DATA_930_LSB)
#define DBI_WINDOW_REG_DATA_930_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_930_LSB) & DBI_WINDOW_REG_DATA_930_MASK)
#define DBI_WINDOW_REG_DATA_930_RESET                                          0x0
#define DBI_WINDOW_REG_930_ADDRESS                                             (0xe88 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_930_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_930_RESET                                               0x0

// 0xe8c (DBI_WINDOW_REG_931)
#define DBI_WINDOW_REG_DATA_931_LSB                                            0
#define DBI_WINDOW_REG_DATA_931_MSB                                            31
#define DBI_WINDOW_REG_DATA_931_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_931_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_931_MASK) >> DBI_WINDOW_REG_DATA_931_LSB)
#define DBI_WINDOW_REG_DATA_931_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_931_LSB) & DBI_WINDOW_REG_DATA_931_MASK)
#define DBI_WINDOW_REG_DATA_931_RESET                                          0x0
#define DBI_WINDOW_REG_931_ADDRESS                                             (0xe8c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_931_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_931_RESET                                               0x0

// 0xe90 (DBI_WINDOW_REG_932)
#define DBI_WINDOW_REG_DATA_932_LSB                                            0
#define DBI_WINDOW_REG_DATA_932_MSB                                            31
#define DBI_WINDOW_REG_DATA_932_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_932_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_932_MASK) >> DBI_WINDOW_REG_DATA_932_LSB)
#define DBI_WINDOW_REG_DATA_932_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_932_LSB) & DBI_WINDOW_REG_DATA_932_MASK)
#define DBI_WINDOW_REG_DATA_932_RESET                                          0x0
#define DBI_WINDOW_REG_932_ADDRESS                                             (0xe90 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_932_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_932_RESET                                               0x0

// 0xe94 (DBI_WINDOW_REG_933)
#define DBI_WINDOW_REG_DATA_933_LSB                                            0
#define DBI_WINDOW_REG_DATA_933_MSB                                            31
#define DBI_WINDOW_REG_DATA_933_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_933_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_933_MASK) >> DBI_WINDOW_REG_DATA_933_LSB)
#define DBI_WINDOW_REG_DATA_933_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_933_LSB) & DBI_WINDOW_REG_DATA_933_MASK)
#define DBI_WINDOW_REG_DATA_933_RESET                                          0x0
#define DBI_WINDOW_REG_933_ADDRESS                                             (0xe94 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_933_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_933_RESET                                               0x0

// 0xe98 (DBI_WINDOW_REG_934)
#define DBI_WINDOW_REG_DATA_934_LSB                                            0
#define DBI_WINDOW_REG_DATA_934_MSB                                            31
#define DBI_WINDOW_REG_DATA_934_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_934_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_934_MASK) >> DBI_WINDOW_REG_DATA_934_LSB)
#define DBI_WINDOW_REG_DATA_934_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_934_LSB) & DBI_WINDOW_REG_DATA_934_MASK)
#define DBI_WINDOW_REG_DATA_934_RESET                                          0x0
#define DBI_WINDOW_REG_934_ADDRESS                                             (0xe98 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_934_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_934_RESET                                               0x0

// 0xe9c (DBI_WINDOW_REG_935)
#define DBI_WINDOW_REG_DATA_935_LSB                                            0
#define DBI_WINDOW_REG_DATA_935_MSB                                            31
#define DBI_WINDOW_REG_DATA_935_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_935_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_935_MASK) >> DBI_WINDOW_REG_DATA_935_LSB)
#define DBI_WINDOW_REG_DATA_935_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_935_LSB) & DBI_WINDOW_REG_DATA_935_MASK)
#define DBI_WINDOW_REG_DATA_935_RESET                                          0x0
#define DBI_WINDOW_REG_935_ADDRESS                                             (0xe9c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_935_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_935_RESET                                               0x0

// 0xea0 (DBI_WINDOW_REG_936)
#define DBI_WINDOW_REG_DATA_936_LSB                                            0
#define DBI_WINDOW_REG_DATA_936_MSB                                            31
#define DBI_WINDOW_REG_DATA_936_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_936_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_936_MASK) >> DBI_WINDOW_REG_DATA_936_LSB)
#define DBI_WINDOW_REG_DATA_936_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_936_LSB) & DBI_WINDOW_REG_DATA_936_MASK)
#define DBI_WINDOW_REG_DATA_936_RESET                                          0x0
#define DBI_WINDOW_REG_936_ADDRESS                                             (0xea0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_936_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_936_RESET                                               0x0

// 0xea4 (DBI_WINDOW_REG_937)
#define DBI_WINDOW_REG_DATA_937_LSB                                            0
#define DBI_WINDOW_REG_DATA_937_MSB                                            31
#define DBI_WINDOW_REG_DATA_937_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_937_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_937_MASK) >> DBI_WINDOW_REG_DATA_937_LSB)
#define DBI_WINDOW_REG_DATA_937_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_937_LSB) & DBI_WINDOW_REG_DATA_937_MASK)
#define DBI_WINDOW_REG_DATA_937_RESET                                          0x0
#define DBI_WINDOW_REG_937_ADDRESS                                             (0xea4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_937_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_937_RESET                                               0x0

// 0xea8 (DBI_WINDOW_REG_938)
#define DBI_WINDOW_REG_DATA_938_LSB                                            0
#define DBI_WINDOW_REG_DATA_938_MSB                                            31
#define DBI_WINDOW_REG_DATA_938_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_938_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_938_MASK) >> DBI_WINDOW_REG_DATA_938_LSB)
#define DBI_WINDOW_REG_DATA_938_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_938_LSB) & DBI_WINDOW_REG_DATA_938_MASK)
#define DBI_WINDOW_REG_DATA_938_RESET                                          0x0
#define DBI_WINDOW_REG_938_ADDRESS                                             (0xea8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_938_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_938_RESET                                               0x0

// 0xeac (DBI_WINDOW_REG_939)
#define DBI_WINDOW_REG_DATA_939_LSB                                            0
#define DBI_WINDOW_REG_DATA_939_MSB                                            31
#define DBI_WINDOW_REG_DATA_939_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_939_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_939_MASK) >> DBI_WINDOW_REG_DATA_939_LSB)
#define DBI_WINDOW_REG_DATA_939_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_939_LSB) & DBI_WINDOW_REG_DATA_939_MASK)
#define DBI_WINDOW_REG_DATA_939_RESET                                          0x0
#define DBI_WINDOW_REG_939_ADDRESS                                             (0xeac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_939_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_939_RESET                                               0x0

// 0xeb0 (DBI_WINDOW_REG_940)
#define DBI_WINDOW_REG_DATA_940_LSB                                            0
#define DBI_WINDOW_REG_DATA_940_MSB                                            31
#define DBI_WINDOW_REG_DATA_940_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_940_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_940_MASK) >> DBI_WINDOW_REG_DATA_940_LSB)
#define DBI_WINDOW_REG_DATA_940_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_940_LSB) & DBI_WINDOW_REG_DATA_940_MASK)
#define DBI_WINDOW_REG_DATA_940_RESET                                          0x0
#define DBI_WINDOW_REG_940_ADDRESS                                             (0xeb0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_940_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_940_RESET                                               0x0

// 0xeb4 (DBI_WINDOW_REG_941)
#define DBI_WINDOW_REG_DATA_941_LSB                                            0
#define DBI_WINDOW_REG_DATA_941_MSB                                            31
#define DBI_WINDOW_REG_DATA_941_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_941_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_941_MASK) >> DBI_WINDOW_REG_DATA_941_LSB)
#define DBI_WINDOW_REG_DATA_941_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_941_LSB) & DBI_WINDOW_REG_DATA_941_MASK)
#define DBI_WINDOW_REG_DATA_941_RESET                                          0x0
#define DBI_WINDOW_REG_941_ADDRESS                                             (0xeb4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_941_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_941_RESET                                               0x0

// 0xeb8 (DBI_WINDOW_REG_942)
#define DBI_WINDOW_REG_DATA_942_LSB                                            0
#define DBI_WINDOW_REG_DATA_942_MSB                                            31
#define DBI_WINDOW_REG_DATA_942_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_942_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_942_MASK) >> DBI_WINDOW_REG_DATA_942_LSB)
#define DBI_WINDOW_REG_DATA_942_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_942_LSB) & DBI_WINDOW_REG_DATA_942_MASK)
#define DBI_WINDOW_REG_DATA_942_RESET                                          0x0
#define DBI_WINDOW_REG_942_ADDRESS                                             (0xeb8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_942_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_942_RESET                                               0x0

// 0xebc (DBI_WINDOW_REG_943)
#define DBI_WINDOW_REG_DATA_943_LSB                                            0
#define DBI_WINDOW_REG_DATA_943_MSB                                            31
#define DBI_WINDOW_REG_DATA_943_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_943_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_943_MASK) >> DBI_WINDOW_REG_DATA_943_LSB)
#define DBI_WINDOW_REG_DATA_943_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_943_LSB) & DBI_WINDOW_REG_DATA_943_MASK)
#define DBI_WINDOW_REG_DATA_943_RESET                                          0x0
#define DBI_WINDOW_REG_943_ADDRESS                                             (0xebc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_943_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_943_RESET                                               0x0

// 0xec0 (DBI_WINDOW_REG_944)
#define DBI_WINDOW_REG_DATA_944_LSB                                            0
#define DBI_WINDOW_REG_DATA_944_MSB                                            31
#define DBI_WINDOW_REG_DATA_944_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_944_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_944_MASK) >> DBI_WINDOW_REG_DATA_944_LSB)
#define DBI_WINDOW_REG_DATA_944_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_944_LSB) & DBI_WINDOW_REG_DATA_944_MASK)
#define DBI_WINDOW_REG_DATA_944_RESET                                          0x0
#define DBI_WINDOW_REG_944_ADDRESS                                             (0xec0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_944_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_944_RESET                                               0x0

// 0xec4 (DBI_WINDOW_REG_945)
#define DBI_WINDOW_REG_DATA_945_LSB                                            0
#define DBI_WINDOW_REG_DATA_945_MSB                                            31
#define DBI_WINDOW_REG_DATA_945_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_945_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_945_MASK) >> DBI_WINDOW_REG_DATA_945_LSB)
#define DBI_WINDOW_REG_DATA_945_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_945_LSB) & DBI_WINDOW_REG_DATA_945_MASK)
#define DBI_WINDOW_REG_DATA_945_RESET                                          0x0
#define DBI_WINDOW_REG_945_ADDRESS                                             (0xec4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_945_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_945_RESET                                               0x0

// 0xec8 (DBI_WINDOW_REG_946)
#define DBI_WINDOW_REG_DATA_946_LSB                                            0
#define DBI_WINDOW_REG_DATA_946_MSB                                            31
#define DBI_WINDOW_REG_DATA_946_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_946_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_946_MASK) >> DBI_WINDOW_REG_DATA_946_LSB)
#define DBI_WINDOW_REG_DATA_946_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_946_LSB) & DBI_WINDOW_REG_DATA_946_MASK)
#define DBI_WINDOW_REG_DATA_946_RESET                                          0x0
#define DBI_WINDOW_REG_946_ADDRESS                                             (0xec8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_946_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_946_RESET                                               0x0

// 0xecc (DBI_WINDOW_REG_947)
#define DBI_WINDOW_REG_DATA_947_LSB                                            0
#define DBI_WINDOW_REG_DATA_947_MSB                                            31
#define DBI_WINDOW_REG_DATA_947_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_947_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_947_MASK) >> DBI_WINDOW_REG_DATA_947_LSB)
#define DBI_WINDOW_REG_DATA_947_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_947_LSB) & DBI_WINDOW_REG_DATA_947_MASK)
#define DBI_WINDOW_REG_DATA_947_RESET                                          0x0
#define DBI_WINDOW_REG_947_ADDRESS                                             (0xecc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_947_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_947_RESET                                               0x0

// 0xed0 (DBI_WINDOW_REG_948)
#define DBI_WINDOW_REG_DATA_948_LSB                                            0
#define DBI_WINDOW_REG_DATA_948_MSB                                            31
#define DBI_WINDOW_REG_DATA_948_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_948_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_948_MASK) >> DBI_WINDOW_REG_DATA_948_LSB)
#define DBI_WINDOW_REG_DATA_948_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_948_LSB) & DBI_WINDOW_REG_DATA_948_MASK)
#define DBI_WINDOW_REG_DATA_948_RESET                                          0x0
#define DBI_WINDOW_REG_948_ADDRESS                                             (0xed0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_948_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_948_RESET                                               0x0

// 0xed4 (DBI_WINDOW_REG_949)
#define DBI_WINDOW_REG_DATA_949_LSB                                            0
#define DBI_WINDOW_REG_DATA_949_MSB                                            31
#define DBI_WINDOW_REG_DATA_949_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_949_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_949_MASK) >> DBI_WINDOW_REG_DATA_949_LSB)
#define DBI_WINDOW_REG_DATA_949_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_949_LSB) & DBI_WINDOW_REG_DATA_949_MASK)
#define DBI_WINDOW_REG_DATA_949_RESET                                          0x0
#define DBI_WINDOW_REG_949_ADDRESS                                             (0xed4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_949_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_949_RESET                                               0x0

// 0xed8 (DBI_WINDOW_REG_950)
#define DBI_WINDOW_REG_DATA_950_LSB                                            0
#define DBI_WINDOW_REG_DATA_950_MSB                                            31
#define DBI_WINDOW_REG_DATA_950_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_950_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_950_MASK) >> DBI_WINDOW_REG_DATA_950_LSB)
#define DBI_WINDOW_REG_DATA_950_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_950_LSB) & DBI_WINDOW_REG_DATA_950_MASK)
#define DBI_WINDOW_REG_DATA_950_RESET                                          0x0
#define DBI_WINDOW_REG_950_ADDRESS                                             (0xed8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_950_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_950_RESET                                               0x0

// 0xedc (DBI_WINDOW_REG_951)
#define DBI_WINDOW_REG_DATA_951_LSB                                            0
#define DBI_WINDOW_REG_DATA_951_MSB                                            31
#define DBI_WINDOW_REG_DATA_951_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_951_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_951_MASK) >> DBI_WINDOW_REG_DATA_951_LSB)
#define DBI_WINDOW_REG_DATA_951_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_951_LSB) & DBI_WINDOW_REG_DATA_951_MASK)
#define DBI_WINDOW_REG_DATA_951_RESET                                          0x0
#define DBI_WINDOW_REG_951_ADDRESS                                             (0xedc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_951_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_951_RESET                                               0x0

// 0xee0 (DBI_WINDOW_REG_952)
#define DBI_WINDOW_REG_DATA_952_LSB                                            0
#define DBI_WINDOW_REG_DATA_952_MSB                                            31
#define DBI_WINDOW_REG_DATA_952_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_952_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_952_MASK) >> DBI_WINDOW_REG_DATA_952_LSB)
#define DBI_WINDOW_REG_DATA_952_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_952_LSB) & DBI_WINDOW_REG_DATA_952_MASK)
#define DBI_WINDOW_REG_DATA_952_RESET                                          0x0
#define DBI_WINDOW_REG_952_ADDRESS                                             (0xee0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_952_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_952_RESET                                               0x0

// 0xee4 (DBI_WINDOW_REG_953)
#define DBI_WINDOW_REG_DATA_953_LSB                                            0
#define DBI_WINDOW_REG_DATA_953_MSB                                            31
#define DBI_WINDOW_REG_DATA_953_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_953_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_953_MASK) >> DBI_WINDOW_REG_DATA_953_LSB)
#define DBI_WINDOW_REG_DATA_953_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_953_LSB) & DBI_WINDOW_REG_DATA_953_MASK)
#define DBI_WINDOW_REG_DATA_953_RESET                                          0x0
#define DBI_WINDOW_REG_953_ADDRESS                                             (0xee4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_953_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_953_RESET                                               0x0

// 0xee8 (DBI_WINDOW_REG_954)
#define DBI_WINDOW_REG_DATA_954_LSB                                            0
#define DBI_WINDOW_REG_DATA_954_MSB                                            31
#define DBI_WINDOW_REG_DATA_954_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_954_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_954_MASK) >> DBI_WINDOW_REG_DATA_954_LSB)
#define DBI_WINDOW_REG_DATA_954_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_954_LSB) & DBI_WINDOW_REG_DATA_954_MASK)
#define DBI_WINDOW_REG_DATA_954_RESET                                          0x0
#define DBI_WINDOW_REG_954_ADDRESS                                             (0xee8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_954_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_954_RESET                                               0x0

// 0xeec (DBI_WINDOW_REG_955)
#define DBI_WINDOW_REG_DATA_955_LSB                                            0
#define DBI_WINDOW_REG_DATA_955_MSB                                            31
#define DBI_WINDOW_REG_DATA_955_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_955_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_955_MASK) >> DBI_WINDOW_REG_DATA_955_LSB)
#define DBI_WINDOW_REG_DATA_955_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_955_LSB) & DBI_WINDOW_REG_DATA_955_MASK)
#define DBI_WINDOW_REG_DATA_955_RESET                                          0x0
#define DBI_WINDOW_REG_955_ADDRESS                                             (0xeec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_955_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_955_RESET                                               0x0

// 0xef0 (DBI_WINDOW_REG_956)
#define DBI_WINDOW_REG_DATA_956_LSB                                            0
#define DBI_WINDOW_REG_DATA_956_MSB                                            31
#define DBI_WINDOW_REG_DATA_956_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_956_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_956_MASK) >> DBI_WINDOW_REG_DATA_956_LSB)
#define DBI_WINDOW_REG_DATA_956_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_956_LSB) & DBI_WINDOW_REG_DATA_956_MASK)
#define DBI_WINDOW_REG_DATA_956_RESET                                          0x0
#define DBI_WINDOW_REG_956_ADDRESS                                             (0xef0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_956_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_956_RESET                                               0x0

// 0xef4 (DBI_WINDOW_REG_957)
#define DBI_WINDOW_REG_DATA_957_LSB                                            0
#define DBI_WINDOW_REG_DATA_957_MSB                                            31
#define DBI_WINDOW_REG_DATA_957_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_957_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_957_MASK) >> DBI_WINDOW_REG_DATA_957_LSB)
#define DBI_WINDOW_REG_DATA_957_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_957_LSB) & DBI_WINDOW_REG_DATA_957_MASK)
#define DBI_WINDOW_REG_DATA_957_RESET                                          0x0
#define DBI_WINDOW_REG_957_ADDRESS                                             (0xef4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_957_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_957_RESET                                               0x0

// 0xef8 (DBI_WINDOW_REG_958)
#define DBI_WINDOW_REG_DATA_958_LSB                                            0
#define DBI_WINDOW_REG_DATA_958_MSB                                            31
#define DBI_WINDOW_REG_DATA_958_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_958_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_958_MASK) >> DBI_WINDOW_REG_DATA_958_LSB)
#define DBI_WINDOW_REG_DATA_958_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_958_LSB) & DBI_WINDOW_REG_DATA_958_MASK)
#define DBI_WINDOW_REG_DATA_958_RESET                                          0x0
#define DBI_WINDOW_REG_958_ADDRESS                                             (0xef8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_958_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_958_RESET                                               0x0

// 0xefc (DBI_WINDOW_REG_959)
#define DBI_WINDOW_REG_DATA_959_LSB                                            0
#define DBI_WINDOW_REG_DATA_959_MSB                                            31
#define DBI_WINDOW_REG_DATA_959_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_959_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_959_MASK) >> DBI_WINDOW_REG_DATA_959_LSB)
#define DBI_WINDOW_REG_DATA_959_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_959_LSB) & DBI_WINDOW_REG_DATA_959_MASK)
#define DBI_WINDOW_REG_DATA_959_RESET                                          0x0
#define DBI_WINDOW_REG_959_ADDRESS                                             (0xefc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_959_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_959_RESET                                               0x0

// 0xf00 (DBI_WINDOW_REG_960)
#define DBI_WINDOW_REG_DATA_960_LSB                                            0
#define DBI_WINDOW_REG_DATA_960_MSB                                            31
#define DBI_WINDOW_REG_DATA_960_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_960_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_960_MASK) >> DBI_WINDOW_REG_DATA_960_LSB)
#define DBI_WINDOW_REG_DATA_960_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_960_LSB) & DBI_WINDOW_REG_DATA_960_MASK)
#define DBI_WINDOW_REG_DATA_960_RESET                                          0x0
#define DBI_WINDOW_REG_960_ADDRESS                                             (0xf00 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_960_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_960_RESET                                               0x0

// 0xf04 (DBI_WINDOW_REG_961)
#define DBI_WINDOW_REG_DATA_961_LSB                                            0
#define DBI_WINDOW_REG_DATA_961_MSB                                            31
#define DBI_WINDOW_REG_DATA_961_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_961_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_961_MASK) >> DBI_WINDOW_REG_DATA_961_LSB)
#define DBI_WINDOW_REG_DATA_961_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_961_LSB) & DBI_WINDOW_REG_DATA_961_MASK)
#define DBI_WINDOW_REG_DATA_961_RESET                                          0x0
#define DBI_WINDOW_REG_961_ADDRESS                                             (0xf04 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_961_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_961_RESET                                               0x0

// 0xf08 (DBI_WINDOW_REG_962)
#define DBI_WINDOW_REG_DATA_962_LSB                                            0
#define DBI_WINDOW_REG_DATA_962_MSB                                            31
#define DBI_WINDOW_REG_DATA_962_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_962_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_962_MASK) >> DBI_WINDOW_REG_DATA_962_LSB)
#define DBI_WINDOW_REG_DATA_962_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_962_LSB) & DBI_WINDOW_REG_DATA_962_MASK)
#define DBI_WINDOW_REG_DATA_962_RESET                                          0x0
#define DBI_WINDOW_REG_962_ADDRESS                                             (0xf08 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_962_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_962_RESET                                               0x0

// 0xf0c (DBI_WINDOW_REG_963)
#define DBI_WINDOW_REG_DATA_963_LSB                                            0
#define DBI_WINDOW_REG_DATA_963_MSB                                            31
#define DBI_WINDOW_REG_DATA_963_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_963_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_963_MASK) >> DBI_WINDOW_REG_DATA_963_LSB)
#define DBI_WINDOW_REG_DATA_963_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_963_LSB) & DBI_WINDOW_REG_DATA_963_MASK)
#define DBI_WINDOW_REG_DATA_963_RESET                                          0x0
#define DBI_WINDOW_REG_963_ADDRESS                                             (0xf0c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_963_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_963_RESET                                               0x0

// 0xf10 (DBI_WINDOW_REG_964)
#define DBI_WINDOW_REG_DATA_964_LSB                                            0
#define DBI_WINDOW_REG_DATA_964_MSB                                            31
#define DBI_WINDOW_REG_DATA_964_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_964_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_964_MASK) >> DBI_WINDOW_REG_DATA_964_LSB)
#define DBI_WINDOW_REG_DATA_964_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_964_LSB) & DBI_WINDOW_REG_DATA_964_MASK)
#define DBI_WINDOW_REG_DATA_964_RESET                                          0x0
#define DBI_WINDOW_REG_964_ADDRESS                                             (0xf10 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_964_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_964_RESET                                               0x0

// 0xf14 (DBI_WINDOW_REG_965)
#define DBI_WINDOW_REG_DATA_965_LSB                                            0
#define DBI_WINDOW_REG_DATA_965_MSB                                            31
#define DBI_WINDOW_REG_DATA_965_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_965_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_965_MASK) >> DBI_WINDOW_REG_DATA_965_LSB)
#define DBI_WINDOW_REG_DATA_965_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_965_LSB) & DBI_WINDOW_REG_DATA_965_MASK)
#define DBI_WINDOW_REG_DATA_965_RESET                                          0x0
#define DBI_WINDOW_REG_965_ADDRESS                                             (0xf14 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_965_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_965_RESET                                               0x0

// 0xf18 (DBI_WINDOW_REG_966)
#define DBI_WINDOW_REG_DATA_966_LSB                                            0
#define DBI_WINDOW_REG_DATA_966_MSB                                            31
#define DBI_WINDOW_REG_DATA_966_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_966_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_966_MASK) >> DBI_WINDOW_REG_DATA_966_LSB)
#define DBI_WINDOW_REG_DATA_966_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_966_LSB) & DBI_WINDOW_REG_DATA_966_MASK)
#define DBI_WINDOW_REG_DATA_966_RESET                                          0x0
#define DBI_WINDOW_REG_966_ADDRESS                                             (0xf18 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_966_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_966_RESET                                               0x0

// 0xf1c (DBI_WINDOW_REG_967)
#define DBI_WINDOW_REG_DATA_967_LSB                                            0
#define DBI_WINDOW_REG_DATA_967_MSB                                            31
#define DBI_WINDOW_REG_DATA_967_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_967_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_967_MASK) >> DBI_WINDOW_REG_DATA_967_LSB)
#define DBI_WINDOW_REG_DATA_967_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_967_LSB) & DBI_WINDOW_REG_DATA_967_MASK)
#define DBI_WINDOW_REG_DATA_967_RESET                                          0x0
#define DBI_WINDOW_REG_967_ADDRESS                                             (0xf1c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_967_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_967_RESET                                               0x0

// 0xf20 (DBI_WINDOW_REG_968)
#define DBI_WINDOW_REG_DATA_968_LSB                                            0
#define DBI_WINDOW_REG_DATA_968_MSB                                            31
#define DBI_WINDOW_REG_DATA_968_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_968_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_968_MASK) >> DBI_WINDOW_REG_DATA_968_LSB)
#define DBI_WINDOW_REG_DATA_968_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_968_LSB) & DBI_WINDOW_REG_DATA_968_MASK)
#define DBI_WINDOW_REG_DATA_968_RESET                                          0x0
#define DBI_WINDOW_REG_968_ADDRESS                                             (0xf20 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_968_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_968_RESET                                               0x0

// 0xf24 (DBI_WINDOW_REG_969)
#define DBI_WINDOW_REG_DATA_969_LSB                                            0
#define DBI_WINDOW_REG_DATA_969_MSB                                            31
#define DBI_WINDOW_REG_DATA_969_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_969_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_969_MASK) >> DBI_WINDOW_REG_DATA_969_LSB)
#define DBI_WINDOW_REG_DATA_969_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_969_LSB) & DBI_WINDOW_REG_DATA_969_MASK)
#define DBI_WINDOW_REG_DATA_969_RESET                                          0x0
#define DBI_WINDOW_REG_969_ADDRESS                                             (0xf24 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_969_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_969_RESET                                               0x0

// 0xf28 (DBI_WINDOW_REG_970)
#define DBI_WINDOW_REG_DATA_970_LSB                                            0
#define DBI_WINDOW_REG_DATA_970_MSB                                            31
#define DBI_WINDOW_REG_DATA_970_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_970_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_970_MASK) >> DBI_WINDOW_REG_DATA_970_LSB)
#define DBI_WINDOW_REG_DATA_970_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_970_LSB) & DBI_WINDOW_REG_DATA_970_MASK)
#define DBI_WINDOW_REG_DATA_970_RESET                                          0x0
#define DBI_WINDOW_REG_970_ADDRESS                                             (0xf28 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_970_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_970_RESET                                               0x0

// 0xf2c (DBI_WINDOW_REG_971)
#define DBI_WINDOW_REG_DATA_971_LSB                                            0
#define DBI_WINDOW_REG_DATA_971_MSB                                            31
#define DBI_WINDOW_REG_DATA_971_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_971_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_971_MASK) >> DBI_WINDOW_REG_DATA_971_LSB)
#define DBI_WINDOW_REG_DATA_971_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_971_LSB) & DBI_WINDOW_REG_DATA_971_MASK)
#define DBI_WINDOW_REG_DATA_971_RESET                                          0x0
#define DBI_WINDOW_REG_971_ADDRESS                                             (0xf2c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_971_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_971_RESET                                               0x0

// 0xf30 (DBI_WINDOW_REG_972)
#define DBI_WINDOW_REG_DATA_972_LSB                                            0
#define DBI_WINDOW_REG_DATA_972_MSB                                            31
#define DBI_WINDOW_REG_DATA_972_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_972_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_972_MASK) >> DBI_WINDOW_REG_DATA_972_LSB)
#define DBI_WINDOW_REG_DATA_972_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_972_LSB) & DBI_WINDOW_REG_DATA_972_MASK)
#define DBI_WINDOW_REG_DATA_972_RESET                                          0x0
#define DBI_WINDOW_REG_972_ADDRESS                                             (0xf30 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_972_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_972_RESET                                               0x0

// 0xf34 (DBI_WINDOW_REG_973)
#define DBI_WINDOW_REG_DATA_973_LSB                                            0
#define DBI_WINDOW_REG_DATA_973_MSB                                            31
#define DBI_WINDOW_REG_DATA_973_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_973_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_973_MASK) >> DBI_WINDOW_REG_DATA_973_LSB)
#define DBI_WINDOW_REG_DATA_973_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_973_LSB) & DBI_WINDOW_REG_DATA_973_MASK)
#define DBI_WINDOW_REG_DATA_973_RESET                                          0x0
#define DBI_WINDOW_REG_973_ADDRESS                                             (0xf34 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_973_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_973_RESET                                               0x0

// 0xf38 (DBI_WINDOW_REG_974)
#define DBI_WINDOW_REG_DATA_974_LSB                                            0
#define DBI_WINDOW_REG_DATA_974_MSB                                            31
#define DBI_WINDOW_REG_DATA_974_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_974_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_974_MASK) >> DBI_WINDOW_REG_DATA_974_LSB)
#define DBI_WINDOW_REG_DATA_974_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_974_LSB) & DBI_WINDOW_REG_DATA_974_MASK)
#define DBI_WINDOW_REG_DATA_974_RESET                                          0x0
#define DBI_WINDOW_REG_974_ADDRESS                                             (0xf38 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_974_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_974_RESET                                               0x0

// 0xf3c (DBI_WINDOW_REG_975)
#define DBI_WINDOW_REG_DATA_975_LSB                                            0
#define DBI_WINDOW_REG_DATA_975_MSB                                            31
#define DBI_WINDOW_REG_DATA_975_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_975_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_975_MASK) >> DBI_WINDOW_REG_DATA_975_LSB)
#define DBI_WINDOW_REG_DATA_975_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_975_LSB) & DBI_WINDOW_REG_DATA_975_MASK)
#define DBI_WINDOW_REG_DATA_975_RESET                                          0x0
#define DBI_WINDOW_REG_975_ADDRESS                                             (0xf3c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_975_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_975_RESET                                               0x0

// 0xf40 (DBI_WINDOW_REG_976)
#define DBI_WINDOW_REG_DATA_976_LSB                                            0
#define DBI_WINDOW_REG_DATA_976_MSB                                            31
#define DBI_WINDOW_REG_DATA_976_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_976_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_976_MASK) >> DBI_WINDOW_REG_DATA_976_LSB)
#define DBI_WINDOW_REG_DATA_976_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_976_LSB) & DBI_WINDOW_REG_DATA_976_MASK)
#define DBI_WINDOW_REG_DATA_976_RESET                                          0x0
#define DBI_WINDOW_REG_976_ADDRESS                                             (0xf40 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_976_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_976_RESET                                               0x0

// 0xf44 (DBI_WINDOW_REG_977)
#define DBI_WINDOW_REG_DATA_977_LSB                                            0
#define DBI_WINDOW_REG_DATA_977_MSB                                            31
#define DBI_WINDOW_REG_DATA_977_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_977_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_977_MASK) >> DBI_WINDOW_REG_DATA_977_LSB)
#define DBI_WINDOW_REG_DATA_977_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_977_LSB) & DBI_WINDOW_REG_DATA_977_MASK)
#define DBI_WINDOW_REG_DATA_977_RESET                                          0x0
#define DBI_WINDOW_REG_977_ADDRESS                                             (0xf44 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_977_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_977_RESET                                               0x0

// 0xf48 (DBI_WINDOW_REG_978)
#define DBI_WINDOW_REG_DATA_978_LSB                                            0
#define DBI_WINDOW_REG_DATA_978_MSB                                            31
#define DBI_WINDOW_REG_DATA_978_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_978_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_978_MASK) >> DBI_WINDOW_REG_DATA_978_LSB)
#define DBI_WINDOW_REG_DATA_978_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_978_LSB) & DBI_WINDOW_REG_DATA_978_MASK)
#define DBI_WINDOW_REG_DATA_978_RESET                                          0x0
#define DBI_WINDOW_REG_978_ADDRESS                                             (0xf48 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_978_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_978_RESET                                               0x0

// 0xf4c (DBI_WINDOW_REG_979)
#define DBI_WINDOW_REG_DATA_979_LSB                                            0
#define DBI_WINDOW_REG_DATA_979_MSB                                            31
#define DBI_WINDOW_REG_DATA_979_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_979_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_979_MASK) >> DBI_WINDOW_REG_DATA_979_LSB)
#define DBI_WINDOW_REG_DATA_979_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_979_LSB) & DBI_WINDOW_REG_DATA_979_MASK)
#define DBI_WINDOW_REG_DATA_979_RESET                                          0x0
#define DBI_WINDOW_REG_979_ADDRESS                                             (0xf4c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_979_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_979_RESET                                               0x0

// 0xf50 (DBI_WINDOW_REG_980)
#define DBI_WINDOW_REG_DATA_980_LSB                                            0
#define DBI_WINDOW_REG_DATA_980_MSB                                            31
#define DBI_WINDOW_REG_DATA_980_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_980_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_980_MASK) >> DBI_WINDOW_REG_DATA_980_LSB)
#define DBI_WINDOW_REG_DATA_980_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_980_LSB) & DBI_WINDOW_REG_DATA_980_MASK)
#define DBI_WINDOW_REG_DATA_980_RESET                                          0x0
#define DBI_WINDOW_REG_980_ADDRESS                                             (0xf50 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_980_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_980_RESET                                               0x0

// 0xf54 (DBI_WINDOW_REG_981)
#define DBI_WINDOW_REG_DATA_981_LSB                                            0
#define DBI_WINDOW_REG_DATA_981_MSB                                            31
#define DBI_WINDOW_REG_DATA_981_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_981_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_981_MASK) >> DBI_WINDOW_REG_DATA_981_LSB)
#define DBI_WINDOW_REG_DATA_981_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_981_LSB) & DBI_WINDOW_REG_DATA_981_MASK)
#define DBI_WINDOW_REG_DATA_981_RESET                                          0x0
#define DBI_WINDOW_REG_981_ADDRESS                                             (0xf54 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_981_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_981_RESET                                               0x0

// 0xf58 (DBI_WINDOW_REG_982)
#define DBI_WINDOW_REG_DATA_982_LSB                                            0
#define DBI_WINDOW_REG_DATA_982_MSB                                            31
#define DBI_WINDOW_REG_DATA_982_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_982_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_982_MASK) >> DBI_WINDOW_REG_DATA_982_LSB)
#define DBI_WINDOW_REG_DATA_982_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_982_LSB) & DBI_WINDOW_REG_DATA_982_MASK)
#define DBI_WINDOW_REG_DATA_982_RESET                                          0x0
#define DBI_WINDOW_REG_982_ADDRESS                                             (0xf58 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_982_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_982_RESET                                               0x0

// 0xf5c (DBI_WINDOW_REG_983)
#define DBI_WINDOW_REG_DATA_983_LSB                                            0
#define DBI_WINDOW_REG_DATA_983_MSB                                            31
#define DBI_WINDOW_REG_DATA_983_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_983_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_983_MASK) >> DBI_WINDOW_REG_DATA_983_LSB)
#define DBI_WINDOW_REG_DATA_983_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_983_LSB) & DBI_WINDOW_REG_DATA_983_MASK)
#define DBI_WINDOW_REG_DATA_983_RESET                                          0x0
#define DBI_WINDOW_REG_983_ADDRESS                                             (0xf5c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_983_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_983_RESET                                               0x0

// 0xf60 (DBI_WINDOW_REG_984)
#define DBI_WINDOW_REG_DATA_984_LSB                                            0
#define DBI_WINDOW_REG_DATA_984_MSB                                            31
#define DBI_WINDOW_REG_DATA_984_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_984_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_984_MASK) >> DBI_WINDOW_REG_DATA_984_LSB)
#define DBI_WINDOW_REG_DATA_984_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_984_LSB) & DBI_WINDOW_REG_DATA_984_MASK)
#define DBI_WINDOW_REG_DATA_984_RESET                                          0x0
#define DBI_WINDOW_REG_984_ADDRESS                                             (0xf60 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_984_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_984_RESET                                               0x0

// 0xf64 (DBI_WINDOW_REG_985)
#define DBI_WINDOW_REG_DATA_985_LSB                                            0
#define DBI_WINDOW_REG_DATA_985_MSB                                            31
#define DBI_WINDOW_REG_DATA_985_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_985_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_985_MASK) >> DBI_WINDOW_REG_DATA_985_LSB)
#define DBI_WINDOW_REG_DATA_985_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_985_LSB) & DBI_WINDOW_REG_DATA_985_MASK)
#define DBI_WINDOW_REG_DATA_985_RESET                                          0x0
#define DBI_WINDOW_REG_985_ADDRESS                                             (0xf64 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_985_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_985_RESET                                               0x0

// 0xf68 (DBI_WINDOW_REG_986)
#define DBI_WINDOW_REG_DATA_986_LSB                                            0
#define DBI_WINDOW_REG_DATA_986_MSB                                            31
#define DBI_WINDOW_REG_DATA_986_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_986_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_986_MASK) >> DBI_WINDOW_REG_DATA_986_LSB)
#define DBI_WINDOW_REG_DATA_986_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_986_LSB) & DBI_WINDOW_REG_DATA_986_MASK)
#define DBI_WINDOW_REG_DATA_986_RESET                                          0x0
#define DBI_WINDOW_REG_986_ADDRESS                                             (0xf68 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_986_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_986_RESET                                               0x0

// 0xf6c (DBI_WINDOW_REG_987)
#define DBI_WINDOW_REG_DATA_987_LSB                                            0
#define DBI_WINDOW_REG_DATA_987_MSB                                            31
#define DBI_WINDOW_REG_DATA_987_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_987_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_987_MASK) >> DBI_WINDOW_REG_DATA_987_LSB)
#define DBI_WINDOW_REG_DATA_987_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_987_LSB) & DBI_WINDOW_REG_DATA_987_MASK)
#define DBI_WINDOW_REG_DATA_987_RESET                                          0x0
#define DBI_WINDOW_REG_987_ADDRESS                                             (0xf6c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_987_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_987_RESET                                               0x0

// 0xf70 (DBI_WINDOW_REG_988)
#define DBI_WINDOW_REG_DATA_988_LSB                                            0
#define DBI_WINDOW_REG_DATA_988_MSB                                            31
#define DBI_WINDOW_REG_DATA_988_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_988_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_988_MASK) >> DBI_WINDOW_REG_DATA_988_LSB)
#define DBI_WINDOW_REG_DATA_988_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_988_LSB) & DBI_WINDOW_REG_DATA_988_MASK)
#define DBI_WINDOW_REG_DATA_988_RESET                                          0x0
#define DBI_WINDOW_REG_988_ADDRESS                                             (0xf70 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_988_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_988_RESET                                               0x0

// 0xf74 (DBI_WINDOW_REG_989)
#define DBI_WINDOW_REG_DATA_989_LSB                                            0
#define DBI_WINDOW_REG_DATA_989_MSB                                            31
#define DBI_WINDOW_REG_DATA_989_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_989_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_989_MASK) >> DBI_WINDOW_REG_DATA_989_LSB)
#define DBI_WINDOW_REG_DATA_989_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_989_LSB) & DBI_WINDOW_REG_DATA_989_MASK)
#define DBI_WINDOW_REG_DATA_989_RESET                                          0x0
#define DBI_WINDOW_REG_989_ADDRESS                                             (0xf74 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_989_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_989_RESET                                               0x0

// 0xf78 (DBI_WINDOW_REG_990)
#define DBI_WINDOW_REG_DATA_990_LSB                                            0
#define DBI_WINDOW_REG_DATA_990_MSB                                            31
#define DBI_WINDOW_REG_DATA_990_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_990_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_990_MASK) >> DBI_WINDOW_REG_DATA_990_LSB)
#define DBI_WINDOW_REG_DATA_990_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_990_LSB) & DBI_WINDOW_REG_DATA_990_MASK)
#define DBI_WINDOW_REG_DATA_990_RESET                                          0x0
#define DBI_WINDOW_REG_990_ADDRESS                                             (0xf78 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_990_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_990_RESET                                               0x0

// 0xf7c (DBI_WINDOW_REG_991)
#define DBI_WINDOW_REG_DATA_991_LSB                                            0
#define DBI_WINDOW_REG_DATA_991_MSB                                            31
#define DBI_WINDOW_REG_DATA_991_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_991_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_991_MASK) >> DBI_WINDOW_REG_DATA_991_LSB)
#define DBI_WINDOW_REG_DATA_991_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_991_LSB) & DBI_WINDOW_REG_DATA_991_MASK)
#define DBI_WINDOW_REG_DATA_991_RESET                                          0x0
#define DBI_WINDOW_REG_991_ADDRESS                                             (0xf7c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_991_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_991_RESET                                               0x0

// 0xf80 (DBI_WINDOW_REG_992)
#define DBI_WINDOW_REG_DATA_992_LSB                                            0
#define DBI_WINDOW_REG_DATA_992_MSB                                            31
#define DBI_WINDOW_REG_DATA_992_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_992_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_992_MASK) >> DBI_WINDOW_REG_DATA_992_LSB)
#define DBI_WINDOW_REG_DATA_992_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_992_LSB) & DBI_WINDOW_REG_DATA_992_MASK)
#define DBI_WINDOW_REG_DATA_992_RESET                                          0x0
#define DBI_WINDOW_REG_992_ADDRESS                                             (0xf80 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_992_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_992_RESET                                               0x0

// 0xf84 (DBI_WINDOW_REG_993)
#define DBI_WINDOW_REG_DATA_993_LSB                                            0
#define DBI_WINDOW_REG_DATA_993_MSB                                            31
#define DBI_WINDOW_REG_DATA_993_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_993_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_993_MASK) >> DBI_WINDOW_REG_DATA_993_LSB)
#define DBI_WINDOW_REG_DATA_993_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_993_LSB) & DBI_WINDOW_REG_DATA_993_MASK)
#define DBI_WINDOW_REG_DATA_993_RESET                                          0x0
#define DBI_WINDOW_REG_993_ADDRESS                                             (0xf84 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_993_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_993_RESET                                               0x0

// 0xf88 (DBI_WINDOW_REG_994)
#define DBI_WINDOW_REG_DATA_994_LSB                                            0
#define DBI_WINDOW_REG_DATA_994_MSB                                            31
#define DBI_WINDOW_REG_DATA_994_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_994_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_994_MASK) >> DBI_WINDOW_REG_DATA_994_LSB)
#define DBI_WINDOW_REG_DATA_994_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_994_LSB) & DBI_WINDOW_REG_DATA_994_MASK)
#define DBI_WINDOW_REG_DATA_994_RESET                                          0x0
#define DBI_WINDOW_REG_994_ADDRESS                                             (0xf88 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_994_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_994_RESET                                               0x0

// 0xf8c (DBI_WINDOW_REG_995)
#define DBI_WINDOW_REG_DATA_995_LSB                                            0
#define DBI_WINDOW_REG_DATA_995_MSB                                            31
#define DBI_WINDOW_REG_DATA_995_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_995_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_995_MASK) >> DBI_WINDOW_REG_DATA_995_LSB)
#define DBI_WINDOW_REG_DATA_995_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_995_LSB) & DBI_WINDOW_REG_DATA_995_MASK)
#define DBI_WINDOW_REG_DATA_995_RESET                                          0x0
#define DBI_WINDOW_REG_995_ADDRESS                                             (0xf8c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_995_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_995_RESET                                               0x0

// 0xf90 (DBI_WINDOW_REG_996)
#define DBI_WINDOW_REG_DATA_996_LSB                                            0
#define DBI_WINDOW_REG_DATA_996_MSB                                            31
#define DBI_WINDOW_REG_DATA_996_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_996_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_996_MASK) >> DBI_WINDOW_REG_DATA_996_LSB)
#define DBI_WINDOW_REG_DATA_996_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_996_LSB) & DBI_WINDOW_REG_DATA_996_MASK)
#define DBI_WINDOW_REG_DATA_996_RESET                                          0x0
#define DBI_WINDOW_REG_996_ADDRESS                                             (0xf90 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_996_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_996_RESET                                               0x0

// 0xf94 (DBI_WINDOW_REG_997)
#define DBI_WINDOW_REG_DATA_997_LSB                                            0
#define DBI_WINDOW_REG_DATA_997_MSB                                            31
#define DBI_WINDOW_REG_DATA_997_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_997_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_997_MASK) >> DBI_WINDOW_REG_DATA_997_LSB)
#define DBI_WINDOW_REG_DATA_997_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_997_LSB) & DBI_WINDOW_REG_DATA_997_MASK)
#define DBI_WINDOW_REG_DATA_997_RESET                                          0x0
#define DBI_WINDOW_REG_997_ADDRESS                                             (0xf94 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_997_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_997_RESET                                               0x0

// 0xf98 (DBI_WINDOW_REG_998)
#define DBI_WINDOW_REG_DATA_998_LSB                                            0
#define DBI_WINDOW_REG_DATA_998_MSB                                            31
#define DBI_WINDOW_REG_DATA_998_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_998_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_998_MASK) >> DBI_WINDOW_REG_DATA_998_LSB)
#define DBI_WINDOW_REG_DATA_998_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_998_LSB) & DBI_WINDOW_REG_DATA_998_MASK)
#define DBI_WINDOW_REG_DATA_998_RESET                                          0x0
#define DBI_WINDOW_REG_998_ADDRESS                                             (0xf98 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_998_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_998_RESET                                               0x0

// 0xf9c (DBI_WINDOW_REG_999)
#define DBI_WINDOW_REG_DATA_999_LSB                                            0
#define DBI_WINDOW_REG_DATA_999_MSB                                            31
#define DBI_WINDOW_REG_DATA_999_MASK                                           0xffffffff
#define DBI_WINDOW_REG_DATA_999_GET(x)                                         (((x) & DBI_WINDOW_REG_DATA_999_MASK) >> DBI_WINDOW_REG_DATA_999_LSB)
#define DBI_WINDOW_REG_DATA_999_SET(x)                                         (((0 | (x)) << DBI_WINDOW_REG_DATA_999_LSB) & DBI_WINDOW_REG_DATA_999_MASK)
#define DBI_WINDOW_REG_DATA_999_RESET                                          0x0
#define DBI_WINDOW_REG_999_ADDRESS                                             (0xf9c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_999_RSTMASK                                             0xffffffff
#define DBI_WINDOW_REG_999_RESET                                               0x0

// 0xfa0 (DBI_WINDOW_REG_1000)
#define DBI_WINDOW_REG_DATA_1000_LSB                                           0
#define DBI_WINDOW_REG_DATA_1000_MSB                                           31
#define DBI_WINDOW_REG_DATA_1000_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1000_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1000_MASK) >> DBI_WINDOW_REG_DATA_1000_LSB)
#define DBI_WINDOW_REG_DATA_1000_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1000_LSB) & DBI_WINDOW_REG_DATA_1000_MASK)
#define DBI_WINDOW_REG_DATA_1000_RESET                                         0x0
#define DBI_WINDOW_REG_1000_ADDRESS                                            (0xfa0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1000_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1000_RESET                                              0x0

// 0xfa4 (DBI_WINDOW_REG_1001)
#define DBI_WINDOW_REG_DATA_1001_LSB                                           0
#define DBI_WINDOW_REG_DATA_1001_MSB                                           31
#define DBI_WINDOW_REG_DATA_1001_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1001_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1001_MASK) >> DBI_WINDOW_REG_DATA_1001_LSB)
#define DBI_WINDOW_REG_DATA_1001_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1001_LSB) & DBI_WINDOW_REG_DATA_1001_MASK)
#define DBI_WINDOW_REG_DATA_1001_RESET                                         0x0
#define DBI_WINDOW_REG_1001_ADDRESS                                            (0xfa4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1001_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1001_RESET                                              0x0

// 0xfa8 (DBI_WINDOW_REG_1002)
#define DBI_WINDOW_REG_DATA_1002_LSB                                           0
#define DBI_WINDOW_REG_DATA_1002_MSB                                           31
#define DBI_WINDOW_REG_DATA_1002_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1002_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1002_MASK) >> DBI_WINDOW_REG_DATA_1002_LSB)
#define DBI_WINDOW_REG_DATA_1002_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1002_LSB) & DBI_WINDOW_REG_DATA_1002_MASK)
#define DBI_WINDOW_REG_DATA_1002_RESET                                         0x0
#define DBI_WINDOW_REG_1002_ADDRESS                                            (0xfa8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1002_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1002_RESET                                              0x0

// 0xfac (DBI_WINDOW_REG_1003)
#define DBI_WINDOW_REG_DATA_1003_LSB                                           0
#define DBI_WINDOW_REG_DATA_1003_MSB                                           31
#define DBI_WINDOW_REG_DATA_1003_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1003_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1003_MASK) >> DBI_WINDOW_REG_DATA_1003_LSB)
#define DBI_WINDOW_REG_DATA_1003_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1003_LSB) & DBI_WINDOW_REG_DATA_1003_MASK)
#define DBI_WINDOW_REG_DATA_1003_RESET                                         0x0
#define DBI_WINDOW_REG_1003_ADDRESS                                            (0xfac + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1003_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1003_RESET                                              0x0

// 0xfb0 (DBI_WINDOW_REG_1004)
#define DBI_WINDOW_REG_DATA_1004_LSB                                           0
#define DBI_WINDOW_REG_DATA_1004_MSB                                           31
#define DBI_WINDOW_REG_DATA_1004_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1004_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1004_MASK) >> DBI_WINDOW_REG_DATA_1004_LSB)
#define DBI_WINDOW_REG_DATA_1004_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1004_LSB) & DBI_WINDOW_REG_DATA_1004_MASK)
#define DBI_WINDOW_REG_DATA_1004_RESET                                         0x0
#define DBI_WINDOW_REG_1004_ADDRESS                                            (0xfb0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1004_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1004_RESET                                              0x0

// 0xfb4 (DBI_WINDOW_REG_1005)
#define DBI_WINDOW_REG_DATA_1005_LSB                                           0
#define DBI_WINDOW_REG_DATA_1005_MSB                                           31
#define DBI_WINDOW_REG_DATA_1005_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1005_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1005_MASK) >> DBI_WINDOW_REG_DATA_1005_LSB)
#define DBI_WINDOW_REG_DATA_1005_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1005_LSB) & DBI_WINDOW_REG_DATA_1005_MASK)
#define DBI_WINDOW_REG_DATA_1005_RESET                                         0x0
#define DBI_WINDOW_REG_1005_ADDRESS                                            (0xfb4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1005_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1005_RESET                                              0x0

// 0xfb8 (DBI_WINDOW_REG_1006)
#define DBI_WINDOW_REG_DATA_1006_LSB                                           0
#define DBI_WINDOW_REG_DATA_1006_MSB                                           31
#define DBI_WINDOW_REG_DATA_1006_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1006_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1006_MASK) >> DBI_WINDOW_REG_DATA_1006_LSB)
#define DBI_WINDOW_REG_DATA_1006_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1006_LSB) & DBI_WINDOW_REG_DATA_1006_MASK)
#define DBI_WINDOW_REG_DATA_1006_RESET                                         0x0
#define DBI_WINDOW_REG_1006_ADDRESS                                            (0xfb8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1006_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1006_RESET                                              0x0

// 0xfbc (DBI_WINDOW_REG_1007)
#define DBI_WINDOW_REG_DATA_1007_LSB                                           0
#define DBI_WINDOW_REG_DATA_1007_MSB                                           31
#define DBI_WINDOW_REG_DATA_1007_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1007_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1007_MASK) >> DBI_WINDOW_REG_DATA_1007_LSB)
#define DBI_WINDOW_REG_DATA_1007_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1007_LSB) & DBI_WINDOW_REG_DATA_1007_MASK)
#define DBI_WINDOW_REG_DATA_1007_RESET                                         0x0
#define DBI_WINDOW_REG_1007_ADDRESS                                            (0xfbc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1007_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1007_RESET                                              0x0

// 0xfc0 (DBI_WINDOW_REG_1008)
#define DBI_WINDOW_REG_DATA_1008_LSB                                           0
#define DBI_WINDOW_REG_DATA_1008_MSB                                           31
#define DBI_WINDOW_REG_DATA_1008_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1008_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1008_MASK) >> DBI_WINDOW_REG_DATA_1008_LSB)
#define DBI_WINDOW_REG_DATA_1008_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1008_LSB) & DBI_WINDOW_REG_DATA_1008_MASK)
#define DBI_WINDOW_REG_DATA_1008_RESET                                         0x0
#define DBI_WINDOW_REG_1008_ADDRESS                                            (0xfc0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1008_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1008_RESET                                              0x0

// 0xfc4 (DBI_WINDOW_REG_1009)
#define DBI_WINDOW_REG_DATA_1009_LSB                                           0
#define DBI_WINDOW_REG_DATA_1009_MSB                                           31
#define DBI_WINDOW_REG_DATA_1009_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1009_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1009_MASK) >> DBI_WINDOW_REG_DATA_1009_LSB)
#define DBI_WINDOW_REG_DATA_1009_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1009_LSB) & DBI_WINDOW_REG_DATA_1009_MASK)
#define DBI_WINDOW_REG_DATA_1009_RESET                                         0x0
#define DBI_WINDOW_REG_1009_ADDRESS                                            (0xfc4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1009_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1009_RESET                                              0x0

// 0xfc8 (DBI_WINDOW_REG_1010)
#define DBI_WINDOW_REG_DATA_1010_LSB                                           0
#define DBI_WINDOW_REG_DATA_1010_MSB                                           31
#define DBI_WINDOW_REG_DATA_1010_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1010_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1010_MASK) >> DBI_WINDOW_REG_DATA_1010_LSB)
#define DBI_WINDOW_REG_DATA_1010_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1010_LSB) & DBI_WINDOW_REG_DATA_1010_MASK)
#define DBI_WINDOW_REG_DATA_1010_RESET                                         0x0
#define DBI_WINDOW_REG_1010_ADDRESS                                            (0xfc8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1010_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1010_RESET                                              0x0

// 0xfcc (DBI_WINDOW_REG_1011)
#define DBI_WINDOW_REG_DATA_1011_LSB                                           0
#define DBI_WINDOW_REG_DATA_1011_MSB                                           31
#define DBI_WINDOW_REG_DATA_1011_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1011_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1011_MASK) >> DBI_WINDOW_REG_DATA_1011_LSB)
#define DBI_WINDOW_REG_DATA_1011_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1011_LSB) & DBI_WINDOW_REG_DATA_1011_MASK)
#define DBI_WINDOW_REG_DATA_1011_RESET                                         0x0
#define DBI_WINDOW_REG_1011_ADDRESS                                            (0xfcc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1011_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1011_RESET                                              0x0

// 0xfd0 (DBI_WINDOW_REG_1012)
#define DBI_WINDOW_REG_DATA_1012_LSB                                           0
#define DBI_WINDOW_REG_DATA_1012_MSB                                           31
#define DBI_WINDOW_REG_DATA_1012_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1012_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1012_MASK) >> DBI_WINDOW_REG_DATA_1012_LSB)
#define DBI_WINDOW_REG_DATA_1012_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1012_LSB) & DBI_WINDOW_REG_DATA_1012_MASK)
#define DBI_WINDOW_REG_DATA_1012_RESET                                         0x0
#define DBI_WINDOW_REG_1012_ADDRESS                                            (0xfd0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1012_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1012_RESET                                              0x0

// 0xfd4 (DBI_WINDOW_REG_1013)
#define DBI_WINDOW_REG_DATA_1013_LSB                                           0
#define DBI_WINDOW_REG_DATA_1013_MSB                                           31
#define DBI_WINDOW_REG_DATA_1013_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1013_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1013_MASK) >> DBI_WINDOW_REG_DATA_1013_LSB)
#define DBI_WINDOW_REG_DATA_1013_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1013_LSB) & DBI_WINDOW_REG_DATA_1013_MASK)
#define DBI_WINDOW_REG_DATA_1013_RESET                                         0x0
#define DBI_WINDOW_REG_1013_ADDRESS                                            (0xfd4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1013_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1013_RESET                                              0x0

// 0xfd8 (DBI_WINDOW_REG_1014)
#define DBI_WINDOW_REG_DATA_1014_LSB                                           0
#define DBI_WINDOW_REG_DATA_1014_MSB                                           31
#define DBI_WINDOW_REG_DATA_1014_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1014_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1014_MASK) >> DBI_WINDOW_REG_DATA_1014_LSB)
#define DBI_WINDOW_REG_DATA_1014_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1014_LSB) & DBI_WINDOW_REG_DATA_1014_MASK)
#define DBI_WINDOW_REG_DATA_1014_RESET                                         0x0
#define DBI_WINDOW_REG_1014_ADDRESS                                            (0xfd8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1014_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1014_RESET                                              0x0

// 0xfdc (DBI_WINDOW_REG_1015)
#define DBI_WINDOW_REG_DATA_1015_LSB                                           0
#define DBI_WINDOW_REG_DATA_1015_MSB                                           31
#define DBI_WINDOW_REG_DATA_1015_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1015_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1015_MASK) >> DBI_WINDOW_REG_DATA_1015_LSB)
#define DBI_WINDOW_REG_DATA_1015_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1015_LSB) & DBI_WINDOW_REG_DATA_1015_MASK)
#define DBI_WINDOW_REG_DATA_1015_RESET                                         0x0
#define DBI_WINDOW_REG_1015_ADDRESS                                            (0xfdc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1015_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1015_RESET                                              0x0

// 0xfe0 (DBI_WINDOW_REG_1016)
#define DBI_WINDOW_REG_DATA_1016_LSB                                           0
#define DBI_WINDOW_REG_DATA_1016_MSB                                           31
#define DBI_WINDOW_REG_DATA_1016_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1016_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1016_MASK) >> DBI_WINDOW_REG_DATA_1016_LSB)
#define DBI_WINDOW_REG_DATA_1016_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1016_LSB) & DBI_WINDOW_REG_DATA_1016_MASK)
#define DBI_WINDOW_REG_DATA_1016_RESET                                         0x0
#define DBI_WINDOW_REG_1016_ADDRESS                                            (0xfe0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1016_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1016_RESET                                              0x0

// 0xfe4 (DBI_WINDOW_REG_1017)
#define DBI_WINDOW_REG_DATA_1017_LSB                                           0
#define DBI_WINDOW_REG_DATA_1017_MSB                                           31
#define DBI_WINDOW_REG_DATA_1017_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1017_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1017_MASK) >> DBI_WINDOW_REG_DATA_1017_LSB)
#define DBI_WINDOW_REG_DATA_1017_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1017_LSB) & DBI_WINDOW_REG_DATA_1017_MASK)
#define DBI_WINDOW_REG_DATA_1017_RESET                                         0x0
#define DBI_WINDOW_REG_1017_ADDRESS                                            (0xfe4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1017_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1017_RESET                                              0x0

// 0xfe8 (DBI_WINDOW_REG_1018)
#define DBI_WINDOW_REG_DATA_1018_LSB                                           0
#define DBI_WINDOW_REG_DATA_1018_MSB                                           31
#define DBI_WINDOW_REG_DATA_1018_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1018_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1018_MASK) >> DBI_WINDOW_REG_DATA_1018_LSB)
#define DBI_WINDOW_REG_DATA_1018_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1018_LSB) & DBI_WINDOW_REG_DATA_1018_MASK)
#define DBI_WINDOW_REG_DATA_1018_RESET                                         0x0
#define DBI_WINDOW_REG_1018_ADDRESS                                            (0xfe8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1018_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1018_RESET                                              0x0

// 0xfec (DBI_WINDOW_REG_1019)
#define DBI_WINDOW_REG_DATA_1019_LSB                                           0
#define DBI_WINDOW_REG_DATA_1019_MSB                                           31
#define DBI_WINDOW_REG_DATA_1019_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1019_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1019_MASK) >> DBI_WINDOW_REG_DATA_1019_LSB)
#define DBI_WINDOW_REG_DATA_1019_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1019_LSB) & DBI_WINDOW_REG_DATA_1019_MASK)
#define DBI_WINDOW_REG_DATA_1019_RESET                                         0x0
#define DBI_WINDOW_REG_1019_ADDRESS                                            (0xfec + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1019_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1019_RESET                                              0x0

// 0xff0 (DBI_WINDOW_REG_1020)
#define DBI_WINDOW_REG_DATA_1020_LSB                                           0
#define DBI_WINDOW_REG_DATA_1020_MSB                                           31
#define DBI_WINDOW_REG_DATA_1020_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1020_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1020_MASK) >> DBI_WINDOW_REG_DATA_1020_LSB)
#define DBI_WINDOW_REG_DATA_1020_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1020_LSB) & DBI_WINDOW_REG_DATA_1020_MASK)
#define DBI_WINDOW_REG_DATA_1020_RESET                                         0x0
#define DBI_WINDOW_REG_1020_ADDRESS                                            (0xff0 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1020_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1020_RESET                                              0x0

// 0xff4 (DBI_WINDOW_REG_1021)
#define DBI_WINDOW_REG_DATA_1021_LSB                                           0
#define DBI_WINDOW_REG_DATA_1021_MSB                                           31
#define DBI_WINDOW_REG_DATA_1021_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1021_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1021_MASK) >> DBI_WINDOW_REG_DATA_1021_LSB)
#define DBI_WINDOW_REG_DATA_1021_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1021_LSB) & DBI_WINDOW_REG_DATA_1021_MASK)
#define DBI_WINDOW_REG_DATA_1021_RESET                                         0x0
#define DBI_WINDOW_REG_1021_ADDRESS                                            (0xff4 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1021_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1021_RESET                                              0x0

// 0xff8 (DBI_WINDOW_REG_1022)
#define DBI_WINDOW_REG_DATA_1022_LSB                                           0
#define DBI_WINDOW_REG_DATA_1022_MSB                                           31
#define DBI_WINDOW_REG_DATA_1022_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1022_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1022_MASK) >> DBI_WINDOW_REG_DATA_1022_LSB)
#define DBI_WINDOW_REG_DATA_1022_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1022_LSB) & DBI_WINDOW_REG_DATA_1022_MASK)
#define DBI_WINDOW_REG_DATA_1022_RESET                                         0x0
#define DBI_WINDOW_REG_1022_ADDRESS                                            (0xff8 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1022_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1022_RESET                                              0x0

// 0xffc (DBI_WINDOW_REG_1023)
#define DBI_WINDOW_REG_DATA_1023_LSB                                           0
#define DBI_WINDOW_REG_DATA_1023_MSB                                           31
#define DBI_WINDOW_REG_DATA_1023_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1023_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1023_MASK) >> DBI_WINDOW_REG_DATA_1023_LSB)
#define DBI_WINDOW_REG_DATA_1023_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1023_LSB) & DBI_WINDOW_REG_DATA_1023_MASK)
#define DBI_WINDOW_REG_DATA_1023_RESET                                         0x0
#define DBI_WINDOW_REG_1023_ADDRESS                                            (0xffc + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1023_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1023_RESET                                              0x0

// 0x1000 (DBI_WINDOW_REG_1024)
#define DBI_WINDOW_REG_DATA_1024_LSB                                           0
#define DBI_WINDOW_REG_DATA_1024_MSB                                           31
#define DBI_WINDOW_REG_DATA_1024_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1024_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1024_MASK) >> DBI_WINDOW_REG_DATA_1024_LSB)
#define DBI_WINDOW_REG_DATA_1024_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1024_LSB) & DBI_WINDOW_REG_DATA_1024_MASK)
#define DBI_WINDOW_REG_DATA_1024_RESET                                         0x0
#define DBI_WINDOW_REG_1024_ADDRESS                                            (0x1000 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1024_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1024_RESET                                              0x0

// 0x1004 (DBI_WINDOW_REG_1025)
#define DBI_WINDOW_REG_DATA_1025_LSB                                           0
#define DBI_WINDOW_REG_DATA_1025_MSB                                           31
#define DBI_WINDOW_REG_DATA_1025_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1025_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1025_MASK) >> DBI_WINDOW_REG_DATA_1025_LSB)
#define DBI_WINDOW_REG_DATA_1025_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1025_LSB) & DBI_WINDOW_REG_DATA_1025_MASK)
#define DBI_WINDOW_REG_DATA_1025_RESET                                         0x0
#define DBI_WINDOW_REG_1025_ADDRESS                                            (0x1004 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1025_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1025_RESET                                              0x0

// 0x1008 (DBI_WINDOW_REG_1026)
#define DBI_WINDOW_REG_DATA_1026_LSB                                           0
#define DBI_WINDOW_REG_DATA_1026_MSB                                           31
#define DBI_WINDOW_REG_DATA_1026_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1026_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1026_MASK) >> DBI_WINDOW_REG_DATA_1026_LSB)
#define DBI_WINDOW_REG_DATA_1026_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1026_LSB) & DBI_WINDOW_REG_DATA_1026_MASK)
#define DBI_WINDOW_REG_DATA_1026_RESET                                         0x0
#define DBI_WINDOW_REG_1026_ADDRESS                                            (0x1008 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1026_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1026_RESET                                              0x0

// 0x100c (DBI_WINDOW_REG_1027)
#define DBI_WINDOW_REG_DATA_1027_LSB                                           0
#define DBI_WINDOW_REG_DATA_1027_MSB                                           31
#define DBI_WINDOW_REG_DATA_1027_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1027_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1027_MASK) >> DBI_WINDOW_REG_DATA_1027_LSB)
#define DBI_WINDOW_REG_DATA_1027_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1027_LSB) & DBI_WINDOW_REG_DATA_1027_MASK)
#define DBI_WINDOW_REG_DATA_1027_RESET                                         0x0
#define DBI_WINDOW_REG_1027_ADDRESS                                            (0x100c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1027_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1027_RESET                                              0x0

// 0x1010 (DBI_WINDOW_REG_1028)
#define DBI_WINDOW_REG_DATA_1028_LSB                                           0
#define DBI_WINDOW_REG_DATA_1028_MSB                                           31
#define DBI_WINDOW_REG_DATA_1028_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1028_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1028_MASK) >> DBI_WINDOW_REG_DATA_1028_LSB)
#define DBI_WINDOW_REG_DATA_1028_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1028_LSB) & DBI_WINDOW_REG_DATA_1028_MASK)
#define DBI_WINDOW_REG_DATA_1028_RESET                                         0x0
#define DBI_WINDOW_REG_1028_ADDRESS                                            (0x1010 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1028_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1028_RESET                                              0x0

// 0x1014 (DBI_WINDOW_REG_1029)
#define DBI_WINDOW_REG_DATA_1029_LSB                                           0
#define DBI_WINDOW_REG_DATA_1029_MSB                                           31
#define DBI_WINDOW_REG_DATA_1029_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1029_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1029_MASK) >> DBI_WINDOW_REG_DATA_1029_LSB)
#define DBI_WINDOW_REG_DATA_1029_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1029_LSB) & DBI_WINDOW_REG_DATA_1029_MASK)
#define DBI_WINDOW_REG_DATA_1029_RESET                                         0x0
#define DBI_WINDOW_REG_1029_ADDRESS                                            (0x1014 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1029_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1029_RESET                                              0x0

// 0x1018 (DBI_WINDOW_REG_1030)
#define DBI_WINDOW_REG_DATA_1030_LSB                                           0
#define DBI_WINDOW_REG_DATA_1030_MSB                                           31
#define DBI_WINDOW_REG_DATA_1030_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1030_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1030_MASK) >> DBI_WINDOW_REG_DATA_1030_LSB)
#define DBI_WINDOW_REG_DATA_1030_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1030_LSB) & DBI_WINDOW_REG_DATA_1030_MASK)
#define DBI_WINDOW_REG_DATA_1030_RESET                                         0x0
#define DBI_WINDOW_REG_1030_ADDRESS                                            (0x1018 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1030_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1030_RESET                                              0x0

// 0x101c (DBI_WINDOW_REG_1031)
#define DBI_WINDOW_REG_DATA_1031_LSB                                           0
#define DBI_WINDOW_REG_DATA_1031_MSB                                           31
#define DBI_WINDOW_REG_DATA_1031_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1031_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1031_MASK) >> DBI_WINDOW_REG_DATA_1031_LSB)
#define DBI_WINDOW_REG_DATA_1031_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1031_LSB) & DBI_WINDOW_REG_DATA_1031_MASK)
#define DBI_WINDOW_REG_DATA_1031_RESET                                         0x0
#define DBI_WINDOW_REG_1031_ADDRESS                                            (0x101c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1031_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1031_RESET                                              0x0

// 0x1020 (DBI_WINDOW_REG_1032)
#define DBI_WINDOW_REG_DATA_1032_LSB                                           0
#define DBI_WINDOW_REG_DATA_1032_MSB                                           31
#define DBI_WINDOW_REG_DATA_1032_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1032_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1032_MASK) >> DBI_WINDOW_REG_DATA_1032_LSB)
#define DBI_WINDOW_REG_DATA_1032_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1032_LSB) & DBI_WINDOW_REG_DATA_1032_MASK)
#define DBI_WINDOW_REG_DATA_1032_RESET                                         0x0
#define DBI_WINDOW_REG_1032_ADDRESS                                            (0x1020 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1032_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1032_RESET                                              0x0

// 0x1024 (DBI_WINDOW_REG_1033)
#define DBI_WINDOW_REG_DATA_1033_LSB                                           0
#define DBI_WINDOW_REG_DATA_1033_MSB                                           31
#define DBI_WINDOW_REG_DATA_1033_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1033_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1033_MASK) >> DBI_WINDOW_REG_DATA_1033_LSB)
#define DBI_WINDOW_REG_DATA_1033_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1033_LSB) & DBI_WINDOW_REG_DATA_1033_MASK)
#define DBI_WINDOW_REG_DATA_1033_RESET                                         0x0
#define DBI_WINDOW_REG_1033_ADDRESS                                            (0x1024 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1033_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1033_RESET                                              0x0

// 0x1028 (DBI_WINDOW_REG_1034)
#define DBI_WINDOW_REG_DATA_1034_LSB                                           0
#define DBI_WINDOW_REG_DATA_1034_MSB                                           31
#define DBI_WINDOW_REG_DATA_1034_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1034_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1034_MASK) >> DBI_WINDOW_REG_DATA_1034_LSB)
#define DBI_WINDOW_REG_DATA_1034_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1034_LSB) & DBI_WINDOW_REG_DATA_1034_MASK)
#define DBI_WINDOW_REG_DATA_1034_RESET                                         0x0
#define DBI_WINDOW_REG_1034_ADDRESS                                            (0x1028 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1034_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1034_RESET                                              0x0

// 0x102c (DBI_WINDOW_REG_1035)
#define DBI_WINDOW_REG_DATA_1035_LSB                                           0
#define DBI_WINDOW_REG_DATA_1035_MSB                                           31
#define DBI_WINDOW_REG_DATA_1035_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1035_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1035_MASK) >> DBI_WINDOW_REG_DATA_1035_LSB)
#define DBI_WINDOW_REG_DATA_1035_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1035_LSB) & DBI_WINDOW_REG_DATA_1035_MASK)
#define DBI_WINDOW_REG_DATA_1035_RESET                                         0x0
#define DBI_WINDOW_REG_1035_ADDRESS                                            (0x102c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1035_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1035_RESET                                              0x0

// 0x1030 (DBI_WINDOW_REG_1036)
#define DBI_WINDOW_REG_DATA_1036_LSB                                           0
#define DBI_WINDOW_REG_DATA_1036_MSB                                           31
#define DBI_WINDOW_REG_DATA_1036_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1036_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1036_MASK) >> DBI_WINDOW_REG_DATA_1036_LSB)
#define DBI_WINDOW_REG_DATA_1036_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1036_LSB) & DBI_WINDOW_REG_DATA_1036_MASK)
#define DBI_WINDOW_REG_DATA_1036_RESET                                         0x0
#define DBI_WINDOW_REG_1036_ADDRESS                                            (0x1030 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1036_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1036_RESET                                              0x0

// 0x1034 (DBI_WINDOW_REG_1037)
#define DBI_WINDOW_REG_DATA_1037_LSB                                           0
#define DBI_WINDOW_REG_DATA_1037_MSB                                           31
#define DBI_WINDOW_REG_DATA_1037_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1037_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1037_MASK) >> DBI_WINDOW_REG_DATA_1037_LSB)
#define DBI_WINDOW_REG_DATA_1037_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1037_LSB) & DBI_WINDOW_REG_DATA_1037_MASK)
#define DBI_WINDOW_REG_DATA_1037_RESET                                         0x0
#define DBI_WINDOW_REG_1037_ADDRESS                                            (0x1034 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1037_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1037_RESET                                              0x0

// 0x1038 (DBI_WINDOW_REG_1038)
#define DBI_WINDOW_REG_DATA_1038_LSB                                           0
#define DBI_WINDOW_REG_DATA_1038_MSB                                           31
#define DBI_WINDOW_REG_DATA_1038_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1038_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1038_MASK) >> DBI_WINDOW_REG_DATA_1038_LSB)
#define DBI_WINDOW_REG_DATA_1038_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1038_LSB) & DBI_WINDOW_REG_DATA_1038_MASK)
#define DBI_WINDOW_REG_DATA_1038_RESET                                         0x0
#define DBI_WINDOW_REG_1038_ADDRESS                                            (0x1038 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1038_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1038_RESET                                              0x0

// 0x103c (DBI_WINDOW_REG_1039)
#define DBI_WINDOW_REG_DATA_1039_LSB                                           0
#define DBI_WINDOW_REG_DATA_1039_MSB                                           31
#define DBI_WINDOW_REG_DATA_1039_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1039_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1039_MASK) >> DBI_WINDOW_REG_DATA_1039_LSB)
#define DBI_WINDOW_REG_DATA_1039_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1039_LSB) & DBI_WINDOW_REG_DATA_1039_MASK)
#define DBI_WINDOW_REG_DATA_1039_RESET                                         0x0
#define DBI_WINDOW_REG_1039_ADDRESS                                            (0x103c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1039_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1039_RESET                                              0x0

// 0x1040 (DBI_WINDOW_REG_1040)
#define DBI_WINDOW_REG_DATA_1040_LSB                                           0
#define DBI_WINDOW_REG_DATA_1040_MSB                                           31
#define DBI_WINDOW_REG_DATA_1040_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1040_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1040_MASK) >> DBI_WINDOW_REG_DATA_1040_LSB)
#define DBI_WINDOW_REG_DATA_1040_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1040_LSB) & DBI_WINDOW_REG_DATA_1040_MASK)
#define DBI_WINDOW_REG_DATA_1040_RESET                                         0x0
#define DBI_WINDOW_REG_1040_ADDRESS                                            (0x1040 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1040_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1040_RESET                                              0x0

// 0x1044 (DBI_WINDOW_REG_1041)
#define DBI_WINDOW_REG_DATA_1041_LSB                                           0
#define DBI_WINDOW_REG_DATA_1041_MSB                                           31
#define DBI_WINDOW_REG_DATA_1041_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1041_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1041_MASK) >> DBI_WINDOW_REG_DATA_1041_LSB)
#define DBI_WINDOW_REG_DATA_1041_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1041_LSB) & DBI_WINDOW_REG_DATA_1041_MASK)
#define DBI_WINDOW_REG_DATA_1041_RESET                                         0x0
#define DBI_WINDOW_REG_1041_ADDRESS                                            (0x1044 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1041_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1041_RESET                                              0x0

// 0x1048 (DBI_WINDOW_REG_1042)
#define DBI_WINDOW_REG_DATA_1042_LSB                                           0
#define DBI_WINDOW_REG_DATA_1042_MSB                                           31
#define DBI_WINDOW_REG_DATA_1042_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1042_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1042_MASK) >> DBI_WINDOW_REG_DATA_1042_LSB)
#define DBI_WINDOW_REG_DATA_1042_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1042_LSB) & DBI_WINDOW_REG_DATA_1042_MASK)
#define DBI_WINDOW_REG_DATA_1042_RESET                                         0x0
#define DBI_WINDOW_REG_1042_ADDRESS                                            (0x1048 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1042_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1042_RESET                                              0x0

// 0x104c (DBI_WINDOW_REG_1043)
#define DBI_WINDOW_REG_DATA_1043_LSB                                           0
#define DBI_WINDOW_REG_DATA_1043_MSB                                           31
#define DBI_WINDOW_REG_DATA_1043_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1043_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1043_MASK) >> DBI_WINDOW_REG_DATA_1043_LSB)
#define DBI_WINDOW_REG_DATA_1043_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1043_LSB) & DBI_WINDOW_REG_DATA_1043_MASK)
#define DBI_WINDOW_REG_DATA_1043_RESET                                         0x0
#define DBI_WINDOW_REG_1043_ADDRESS                                            (0x104c + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1043_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1043_RESET                                              0x0

// 0x1050 (DBI_WINDOW_REG_1044)
#define DBI_WINDOW_REG_DATA_1044_LSB                                           0
#define DBI_WINDOW_REG_DATA_1044_MSB                                           31
#define DBI_WINDOW_REG_DATA_1044_MASK                                          0xffffffff
#define DBI_WINDOW_REG_DATA_1044_GET(x)                                        (((x) & DBI_WINDOW_REG_DATA_1044_MASK) >> DBI_WINDOW_REG_DATA_1044_LSB)
#define DBI_WINDOW_REG_DATA_1044_SET(x)                                        (((0 | (x)) << DBI_WINDOW_REG_DATA_1044_LSB) & DBI_WINDOW_REG_DATA_1044_MASK)
#define DBI_WINDOW_REG_DATA_1044_RESET                                         0x0
#define DBI_WINDOW_REG_1044_ADDRESS                                            (0x1050 + __DBI_REG_BASE_ADDRESS)
#define DBI_WINDOW_REG_1044_RSTMASK                                            0xffffffff
#define DBI_WINDOW_REG_1044_RESET                                              0x0

// 0x1054 (DBI_WINDOW_REG_1045)
#define DBI_WINDOW_REG_DATA_1045_LSB                                           0
#define DBI_WINDOW_REG_DATA_1045_MSB                                           31
#define DBI_WINDOW_REG