// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_CV_START_REFX_H_
#define _TX_CV_START_REFX_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	reserved_0a[0], forced_cv_mem_fetch[1], forced_phy_cv_location[2], user_num[4:3], reserved_0b[7:5], cv_id[15:8], cv_size[31:16]
//	1	cv_address[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_CV_START_REFX 2

struct tx_cv_start_refx {
    volatile uint32_t reserved_0a                     :  1, //[0]
                      forced_cv_mem_fetch             :  1, //[1]
                      forced_phy_cv_location          :  1, //[2]
                      user_num                        :  2, //[4:3]
                      reserved_0b                     :  3, //[7:5]
                      cv_id                           :  8, //[15:8]
                      cv_size                         : 16; //[31:16]
    volatile uint32_t cv_address                      : 32; //[31:0]
};

/*

reserved_0a
			
			When set, usage of CV data is required, for either
			MU-MIMO transmission or SU beam forming.

forced_cv_mem_fetch
			
			When set, the cv data shall be fetched from memory,
			irrespective of what is already present inside the PHY

forced_phy_cv_location
			
			When set, the cv data shall be located in the location
			indicated by user_num
			
			When this field is not set, the scheduler can determine
			the user_num based on it's own user_num assignment logic.

user_num
			
			Field only valid when forced_phy_cv_Location is set.
			When 
			
			Indicates the position that this CV will be stored in
			the PHY.  0 corresponds to user 0 position, 1 corresponds to
			user 1 position, 2 corresponds to user 2 position.  <legal
			0-3>
			
			Field only valid when forced_phy_cv_Location is set.
			When 

reserved_0b
			
			0

cv_id
			
			A unique ID corresponding to the CV data. 
			
			
			
			When cv_mem_fetch is set, this will be the cv_id the
			scheduler will link to the new CV data written into
			cv_position.
			
			
			
			When cv_mem_fetch is NOT set, the scheduler can check if
			this cv_id is equal to the cv_id that scheduler remembers is
			already present in the PHY at cv_position.

cv_size
			
			Size of the CV in units of octets <legal all>

cv_address
			
			The physical address of the CV data in memory.
*/


/* Description		TX_CV_START_REFX_0_RESERVED_0A
			
			When set, usage of CV data is required, for either
			MU-MIMO transmission or SU beam forming.
*/
#define TX_CV_START_REFX_0_RESERVED_0A_OFFSET                        0x00000000
#define TX_CV_START_REFX_0_RESERVED_0A_LSB                           0
#define TX_CV_START_REFX_0_RESERVED_0A_MASK                          0x00000001

/* Description		TX_CV_START_REFX_0_FORCED_CV_MEM_FETCH
			
			When set, the cv data shall be fetched from memory,
			irrespective of what is already present inside the PHY
*/
#define TX_CV_START_REFX_0_FORCED_CV_MEM_FETCH_OFFSET                0x00000000
#define TX_CV_START_REFX_0_FORCED_CV_MEM_FETCH_LSB                   1
#define TX_CV_START_REFX_0_FORCED_CV_MEM_FETCH_MASK                  0x00000002

/* Description		TX_CV_START_REFX_0_FORCED_PHY_CV_LOCATION
			
			When set, the cv data shall be located in the location
			indicated by user_num
			
			When this field is not set, the scheduler can determine
			the user_num based on it's own user_num assignment logic.
*/
#define TX_CV_START_REFX_0_FORCED_PHY_CV_LOCATION_OFFSET             0x00000000
#define TX_CV_START_REFX_0_FORCED_PHY_CV_LOCATION_LSB                2
#define TX_CV_START_REFX_0_FORCED_PHY_CV_LOCATION_MASK               0x00000004

/* Description		TX_CV_START_REFX_0_USER_NUM
			
			Field only valid when forced_phy_cv_Location is set.
			When 
			
			Indicates the position that this CV will be stored in
			the PHY.  0 corresponds to user 0 position, 1 corresponds to
			user 1 position, 2 corresponds to user 2 position.  <legal
			0-3>
			
			Field only valid when forced_phy_cv_Location is set.
			When 
*/
#define TX_CV_START_REFX_0_USER_NUM_OFFSET                           0x00000000
#define TX_CV_START_REFX_0_USER_NUM_LSB                              3
#define TX_CV_START_REFX_0_USER_NUM_MASK                             0x00000018

/* Description		TX_CV_START_REFX_0_RESERVED_0B
			
			0
*/
#define TX_CV_START_REFX_0_RESERVED_0B_OFFSET                        0x00000000
#define TX_CV_START_REFX_0_RESERVED_0B_LSB                           5
#define TX_CV_START_REFX_0_RESERVED_0B_MASK                          0x000000e0

/* Description		TX_CV_START_REFX_0_CV_ID
			
			A unique ID corresponding to the CV data. 
			
			
			
			When cv_mem_fetch is set, this will be the cv_id the
			scheduler will link to the new CV data written into
			cv_position.
			
			
			
			When cv_mem_fetch is NOT set, the scheduler can check if
			this cv_id is equal to the cv_id that scheduler remembers is
			already present in the PHY at cv_position.
*/
#define TX_CV_START_REFX_0_CV_ID_OFFSET                              0x00000000
#define TX_CV_START_REFX_0_CV_ID_LSB                                 8
#define TX_CV_START_REFX_0_CV_ID_MASK                                0x0000ff00

/* Description		TX_CV_START_REFX_0_CV_SIZE
			
			Size of the CV in units of octets <legal all>
*/
#define TX_CV_START_REFX_0_CV_SIZE_OFFSET                            0x00000000
#define TX_CV_START_REFX_0_CV_SIZE_LSB                               16
#define TX_CV_START_REFX_0_CV_SIZE_MASK                              0xffff0000

/* Description		TX_CV_START_REFX_1_CV_ADDRESS
			
			The physical address of the CV data in memory.
*/
#define TX_CV_START_REFX_1_CV_ADDRESS_OFFSET                         0x00000004
#define TX_CV_START_REFX_1_CV_ADDRESS_LSB                            0
#define TX_CV_START_REFX_1_CV_ADDRESS_MASK                           0xffffffff


#endif // _TX_CV_START_REFX_H_
