// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PEER_ENTRY_H_
#define _PEER_ENTRY_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	qcu_filter[15:0], key_type[19:16], a_msdu_wds_ad3_ad4[22:20], capture_ack_ba_sounding[23], reserved_0a[31:24]
//	1	mac_addr_a_31_0[31:0]
//	2	mac_addr_a_47_32[15:0], mac_addr_b_15_0[31:16]
//	3	mac_addr_b_47_16[31:0]
//	4	temporal_key_31_0[31:0]
//	5	temporal_key_63_32[31:0]
//	6	temporal_key_95_64[31:0]
//	7	temporal_key_127_96[31:0]
//	8	temporal_key_159_128[31:0]
//	9	temporal_key_191_160[31:0]
//	10	temporal_key_223_192[31:0]
//	11	temporal_key_255_224[31:0]
//	12	decap_type[1:0], partial_aid[10:2], group_id[16:11], ctrl_resp_pwr_mgmt[17], cbf_resp_pwr_mgmt[18], sch_response_table_id[23:19], use_ad_b[24], strip_vlan[25], strip_vlan_decap[26], ps_poll_sifs_resp[27], uapd_sifs_resp[28], qboost_qosdata_sifs_resp[29], qboost_bar_sifs_resp[30], qboost_explicit_sifs_resp[31]
//	13	uapsd_trigger_bitmap[15:0], qboost_trigger_bitmap[31:16]
//	14	nc_index[2:0], rx_insert_vlan_tag_padding[3], vlan_llc[4], reserved_14[31:5]
//	15	mac_addr_c_31_0[31:0]
//	16	mac_addr_c_47_32[15:0], capture_sounding_1str_20mhz[16], capture_sounding_2str_20mhz[17], capture_sounding_3str_20mhz[18], capture_sounding_4str_20mhz[19], capture_sounding_1str_40mhz[20], capture_sounding_2str_40mhz[21], capture_sounding_3str_40mhz[22], capture_sounding_4str_40mhz[23], capture_sounding_1str_80mhz[24], capture_sounding_2str_80mhz[25], capture_sounding_3str_80mhz[26], capture_sounding_4str_80mhz[27], capture_sounding_1str_160mhz[28], capture_sounding_2str_160mhz[29], capture_sounding_3str_160mhz[30], capture_sounding_4str_160mhz[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PEER_ENTRY 17

struct peer_entry {
    volatile uint32_t qcu_filter                      : 16, //[15:0]
                      key_type                        :  4, //[19:16]
                      a_msdu_wds_ad3_ad4              :  3, //[22:20]
                      capture_ack_ba_sounding         :  1, //[23]
                      reserved_0a                     :  8; //[31:24]
    volatile uint32_t mac_addr_a_31_0                 : 32; //[31:0]
    volatile uint32_t mac_addr_a_47_32                : 16, //[15:0]
                      mac_addr_b_15_0                 : 16; //[31:16]
    volatile uint32_t mac_addr_b_47_16                : 32; //[31:0]
    volatile uint32_t temporal_key_31_0               : 32; //[31:0]
    volatile uint32_t temporal_key_63_32              : 32; //[31:0]
    volatile uint32_t temporal_key_95_64              : 32; //[31:0]
    volatile uint32_t temporal_key_127_96             : 32; //[31:0]
    volatile uint32_t temporal_key_159_128            : 32; //[31:0]
    volatile uint32_t temporal_key_191_160            : 32; //[31:0]
    volatile uint32_t temporal_key_223_192            : 32; //[31:0]
    volatile uint32_t temporal_key_255_224            : 32; //[31:0]
    volatile uint32_t decap_type                      :  2, //[1:0]
                      partial_aid                     :  9, //[10:2]
                      group_id                        :  6, //[16:11]
                      ctrl_resp_pwr_mgmt              :  1, //[17]
                      cbf_resp_pwr_mgmt               :  1, //[18]
                      sch_response_table_id           :  5, //[23:19]
                      use_ad_b                        :  1, //[24]
                      strip_vlan                      :  1, //[25]
                      strip_vlan_decap                :  1, //[26]
                      ps_poll_sifs_resp               :  1, //[27]
                      uapd_sifs_resp                  :  1, //[28]
                      qboost_qosdata_sifs_resp        :  1, //[29]
                      qboost_bar_sifs_resp            :  1, //[30]
                      qboost_explicit_sifs_resp       :  1; //[31]
    volatile uint32_t uapsd_trigger_bitmap            : 16, //[15:0]
                      qboost_trigger_bitmap           : 16; //[31:16]
    volatile uint32_t nc_index                        :  3, //[2:0]
                      rx_insert_vlan_tag_padding      :  1, //[3]
                      vlan_llc                        :  1, //[4]
                      reserved_14                     : 27; //[31:5]
    volatile uint32_t mac_addr_c_31_0                 : 32; //[31:0]
    volatile uint32_t mac_addr_c_47_32                : 16, //[15:0]
                      capture_sounding_1str_20mhz     :  1, //[16]
                      capture_sounding_2str_20mhz     :  1, //[17]
                      capture_sounding_3str_20mhz     :  1, //[18]
                      capture_sounding_4str_20mhz     :  1, //[19]
                      capture_sounding_1str_40mhz     :  1, //[20]
                      capture_sounding_2str_40mhz     :  1, //[21]
                      capture_sounding_3str_40mhz     :  1, //[22]
                      capture_sounding_4str_40mhz     :  1, //[23]
                      capture_sounding_1str_80mhz     :  1, //[24]
                      capture_sounding_2str_80mhz     :  1, //[25]
                      capture_sounding_3str_80mhz     :  1, //[26]
                      capture_sounding_4str_80mhz     :  1, //[27]
                      capture_sounding_1str_160mhz    :  1, //[28]
                      capture_sounding_2str_160mhz    :  1, //[29]
                      capture_sounding_3str_160mhz    :  1, //[30]
                      capture_sounding_4str_160mhz    :  1; //[31]
};

/*

qcu_filter
			
			Bitmap which indicates which queues need to be filtered
			by HW.  HW will read the peer entry for every retry and
			honor these bits for every retry. WiFi 1.0 supports
			qcu_filter[9:0].  The remaining bits are reserved for future
			expansion.

key_type
			
			The key_type indicates the cipher suite corresponding to
			this peer entry:
			
			<enum 0 wep_40> WEP 40-bit
			
			<enum 1 wep_104> WEP 104-bit
			
			<enum 2 tkip_no_mic> TKIP without MIC
			
			<enum 3 wep_128> WEP 128-bit
			
			<enum 4 tkip_with_mic> TKIP with MIC
			
			<enum 5 wapi> WAPI
			
			<enum 6 aes_ccmp_128> AES CCMP 128
			
			<enum 7 no_cipher> No crypto
			
			<enum 8 aes_ccmp_256> AES CCMP 256
			
			<enum 9 aes_gcmp_128> AES GCMP 128
			
			<enum 10 aes_gcmp_256> AES GCMP 256
			
			<legal 0-10>

a_msdu_wds_ad3_ad4
			
			Determines the selection of AD3 and AD4 for A-MSDU 4
			address frames (WDS):
			
			<enum 0 ad3_a__ad4_a> AD3 = AD_A, AD4 = AD_A
			
			<enum 1 ad3_a__ad4_b> AD3 = AD_A, AD4 = AD_B
			
			<enum 2 ad3_b__ad4_a> AD3 = AD_B, AD4 = AD_A
			
			<enum 3 ad3_b__ad4_b> AD3 = AD_B, AD4 = AD_B
			
			<enum 4 ad3_da__ad4_sa> AD3 = DA, AD4 = SA
			
			<legal 0-4>

capture_ack_ba_sounding
			
			If set enables capture of sounding on Ack or BA as long
			as the corresponding capture_sounding_1str_##mhz bits is
			set.  If clear the capture of sounding on Ack or BA is
			disabled even if the corresponding
			capture_sounding_1str_##mhz is set.

reserved_0a
			
			Generator should set to 0 and the consumer shall ignore.
			<legal 0>

mac_addr_a_31_0
			
			Lower 32 bits of the MAC address A used by HW for
			encapsulating 802.11

mac_addr_a_47_32
			
			Upper 16 bits of the MAC address A used by HW for
			encapsulating 802.11

mac_addr_b_15_0
			
			Lower 16 bits of the MAC address B used by HW for
			encapsulating 802.11

mac_addr_b_47_16
			
			Upper 32 bits of the MAC address B used by HW for
			encapsulating 802.11

temporal_key_31_0
			
			First 32 bits of the temporal key material.  The
			temporal key for WEP 40-bit uses the first 40 bits, WEP
			104-bit uses the first 104 bits, WEP 128-bit uses all 128
			bits, TKIP with/without MIC uses 128 bits, WAPI uses all 128
			bits, and AES-CCM uses all 128 bits.

temporal_key_63_32
			
			Second 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.

temporal_key_95_64
			
			Third 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.

temporal_key_127_96
			
			Fourth 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.

temporal_key_159_128
			
			Fifth 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the TX
			MIC key[31:0].

temporal_key_191_160
			
			Final 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the TX
			MIC key[63:32].

temporal_key_223_192
			
			Final 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the RX
			MIC key[31:0].

temporal_key_255_224
			
			Final 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the RX
			MIC key[63:32].

decap_type
			
			Indicates the decapsulation that HW will perform:
			
			<enum 0 PTE_DECAP_RAW> No encapsulation
			
			<enum 1 PTE_DECAP_Native_WiFi>
			
			<enum 2 PTE_DECAP_Ethernet_802_3>  Ethernet 2 (DIX) or
			802.3 (uses SNAP/LLC)
			
			<legal 0-2>
			
			Used by the OLE during decapsulation.

partial_aid
			
			Specifies the partial AID of response frames transmitted
			at VHT rates.

group_id
			
			Specifies the Group ID of response frames transmitted at
			VHT rates.

ctrl_resp_pwr_mgmt
			
			RX PCU passes this bit setting on to TX PCU, where the
			setting of this bit is inserted in the pwr_mgt bit in the
			control field of the SIFS response control frames: ACK, CTS,
			BA
			
			<legal all>

cbf_resp_pwr_mgmt
			
			RX PCU passes this bit setting on to TX PCU, where the
			setting of this bit is inserted in the pwr_mgt bit in the
			control field of the Cbf frame.
			
			<legal all>

sch_response_table_id
			
			Response table id found in the address lookup table for
			this STA. This ID is only valid if it is non zero (Null
			pointer).
			
			The scheduler will only use this ID if based on the
			other fields in this TLV it is determined that a SIFS
			response frame needs to be generated.
			
			<legal all>

use_ad_b
			
			The bit is only evaluated when this MSDU is the first
			MSDU in an MPDU. For other MSDUs this bit setting is
			ignored.
			
			It is part of the sw_msdu_param coming from the QM ADD
			frame command.
			
			
			
			Normally in AP mode the DA address is used as the RA. 
			This is normally fine but the use_ad_b bit should be set
			when DA is a multicast/broadcast address but we want to send
			this packet using the destination STA address which will be
			held in the mac_addr_b field of the peer descriptor.
			
			<legal all>

strip_vlan
			
			Strip the VLAN during encapsulation.  Used by the OLE.
			
			<legal all>

strip_vlan_decap
			
			Strip the VLAN during decapsulation.  Used by the OLE.
			
			<legal all>

ps_poll_sifs_resp
			
			Field used by RX PCU only:
			
			When set, and when a PS-POLL frame is received, generate
			the SIFS response data request interrupt.
			
			<legal all>

uapd_sifs_resp
			
			Field used by RX PCU only:
			
			When set, and when a QoS Data frame is received, with PM
			bit set, AND whose TID is part of the UAPSD_trigger_bitmap,
			generate the SIFS response data request interrupt.
			
			<legal all>

qboost_qosdata_sifs_resp
			
			Field used by RX PCU only:
			
			For Implicit Qboost trigger handling.
			
			When set, and when a QoS Data frame is received, with PM
			bit NOT set, AND whose TID is part of the
			QBoost_trigger_bitmap, generate the SIFS response data
			request interrupt.
			
			<legal all>

qboost_bar_sifs_resp
			
			Field used by RX PCU only:
			
			For Implicit Qboost trigger handling.
			
			When set, and when a BAR frame is received, with PM bit
			NOT set, AND whose TID is part of the QBoost_trigger_bitmap,
			generate the SIFS response data request interrupt.
			
			<legal all>

qboost_explicit_sifs_resp
			
			Field used by RX PCU only:
			
			When set, and when a QoS Data or BAR frame is received,
			with PM bit NOT set, AND whose explicit proprietary Qboost
			trigger field is set, generate the SIFS response data
			request interrupt.
			
			<legal all>

uapsd_trigger_bitmap
			
			Field used by RX PCU only:
			
			A TID bitmap (bit 0: TID0, bit 1, TID 1 etc.) where a
			value of 1 for a TID indicates that this QoS data frame is
			considered a UAPSD trigger frame.
			
			<legal all>

qboost_trigger_bitmap
			
			Field used by RX PCU only:
			
			For implicit Qboost trigger handling
			
			A TID bitmap (bit 0: TID0, bit 1, TID 1 etc.) where a
			value of 1 for a TID indicates that this QoS data frame (or
			BAR frame) is considered a Qboost trigger frame.
			
			<legal all>

nc_index
			
			Nc index used for TxBF CBF generation. 

rx_insert_vlan_tag_padding
			
			Insert 4 byte of all zeros as VLAN tag if the rx payload
			does not have VLAN. Used during decapsulation. <legal all>

vlan_llc
			
			If set encapsulate/decapsulate using the Scorpion
			compatible VLAN LLC format

reserved_14
			
			Generator should set to 0 and the consumer shall ignore.
			<legal 0>

mac_addr_c_31_0
			
			Lower 32 bits of MAC address C.  MAC address C will hold
			the transmitter address (AD2) for RTS frames

mac_addr_c_47_32
			
			Upper 16 bits of MAC address C.

capture_sounding_1str_20mhz
			
			Capture sounding for 1 stream 20 MHz receive packets

capture_sounding_2str_20mhz
			
			Capture sounding for 2 stream 20 MHz receive packets

capture_sounding_3str_20mhz
			
			Capture sounding for 3 stream 20 MHz receive packets

capture_sounding_4str_20mhz
			
			Capture sounding for 4 stream 20 MHz receive packets

capture_sounding_1str_40mhz
			
			Capture sounding for 1 stream 40 MHz receive packets

capture_sounding_2str_40mhz
			
			Capture sounding for 2 stream 40 MHz receive packets

capture_sounding_3str_40mhz
			
			Capture sounding for 3 stream 40 MHz receive packets

capture_sounding_4str_40mhz
			
			Capture sounding for 4 stream 40 MHz receive packets

capture_sounding_1str_80mhz
			
			Capture sounding for 1 stream 80 MHz receive packets

capture_sounding_2str_80mhz
			
			Capture sounding for 2 stream 80 MHz receive packets

capture_sounding_3str_80mhz
			
			Capture sounding for 3 stream 80 MHz receive packets

capture_sounding_4str_80mhz
			
			Capture sounding for 4 stream 80 MHz receive packets

capture_sounding_1str_160mhz
			
			Capture sounding for 1 stream 160 MHz receive packets

capture_sounding_2str_160mhz
			
			Capture sounding for 2 stream 160 MHz receive packets

capture_sounding_3str_160mhz
			
			Capture sounding for 3 stream 160 MHz receive packets

capture_sounding_4str_160mhz
			
			Capture sounding for 4 stream 160 MHz receive packets
*/


/* Description		PEER_ENTRY_0_QCU_FILTER
			
			Bitmap which indicates which queues need to be filtered
			by HW.  HW will read the peer entry for every retry and
			honor these bits for every retry. WiFi 1.0 supports
			qcu_filter[9:0].  The remaining bits are reserved for future
			expansion.
*/
#define PEER_ENTRY_0_QCU_FILTER_OFFSET                               0x00000000
#define PEER_ENTRY_0_QCU_FILTER_LSB                                  0
#define PEER_ENTRY_0_QCU_FILTER_MASK                                 0x0000ffff

/* Description		PEER_ENTRY_0_KEY_TYPE
			
			The key_type indicates the cipher suite corresponding to
			this peer entry:
			
			<enum 0 wep_40> WEP 40-bit
			
			<enum 1 wep_104> WEP 104-bit
			
			<enum 2 tkip_no_mic> TKIP without MIC
			
			<enum 3 wep_128> WEP 128-bit
			
			<enum 4 tkip_with_mic> TKIP with MIC
			
			<enum 5 wapi> WAPI
			
			<enum 6 aes_ccmp_128> AES CCMP 128
			
			<enum 7 no_cipher> No crypto
			
			<enum 8 aes_ccmp_256> AES CCMP 256
			
			<enum 9 aes_gcmp_128> AES GCMP 128
			
			<enum 10 aes_gcmp_256> AES GCMP 256
			
			<legal 0-10>
*/
#define PEER_ENTRY_0_KEY_TYPE_OFFSET                                 0x00000000
#define PEER_ENTRY_0_KEY_TYPE_LSB                                    16
#define PEER_ENTRY_0_KEY_TYPE_MASK                                   0x000f0000

/* Description		PEER_ENTRY_0_A_MSDU_WDS_AD3_AD4
			
			Determines the selection of AD3 and AD4 for A-MSDU 4
			address frames (WDS):
			
			<enum 0 ad3_a__ad4_a> AD3 = AD_A, AD4 = AD_A
			
			<enum 1 ad3_a__ad4_b> AD3 = AD_A, AD4 = AD_B
			
			<enum 2 ad3_b__ad4_a> AD3 = AD_B, AD4 = AD_A
			
			<enum 3 ad3_b__ad4_b> AD3 = AD_B, AD4 = AD_B
			
			<enum 4 ad3_da__ad4_sa> AD3 = DA, AD4 = SA
			
			<legal 0-4>
*/
#define PEER_ENTRY_0_A_MSDU_WDS_AD3_AD4_OFFSET                       0x00000000
#define PEER_ENTRY_0_A_MSDU_WDS_AD3_AD4_LSB                          20
#define PEER_ENTRY_0_A_MSDU_WDS_AD3_AD4_MASK                         0x00700000

/* Description		PEER_ENTRY_0_CAPTURE_ACK_BA_SOUNDING
			
			If set enables capture of sounding on Ack or BA as long
			as the corresponding capture_sounding_1str_##mhz bits is
			set.  If clear the capture of sounding on Ack or BA is
			disabled even if the corresponding
			capture_sounding_1str_##mhz is set.
*/
#define PEER_ENTRY_0_CAPTURE_ACK_BA_SOUNDING_OFFSET                  0x00000000
#define PEER_ENTRY_0_CAPTURE_ACK_BA_SOUNDING_LSB                     23
#define PEER_ENTRY_0_CAPTURE_ACK_BA_SOUNDING_MASK                    0x00800000

/* Description		PEER_ENTRY_0_RESERVED_0A
			
			Generator should set to 0 and the consumer shall ignore.
			<legal 0>
*/
#define PEER_ENTRY_0_RESERVED_0A_OFFSET                              0x00000000
#define PEER_ENTRY_0_RESERVED_0A_LSB                                 24
#define PEER_ENTRY_0_RESERVED_0A_MASK                                0xff000000

/* Description		PEER_ENTRY_1_MAC_ADDR_A_31_0
			
			Lower 32 bits of the MAC address A used by HW for
			encapsulating 802.11
*/
#define PEER_ENTRY_1_MAC_ADDR_A_31_0_OFFSET                          0x00000004
#define PEER_ENTRY_1_MAC_ADDR_A_31_0_LSB                             0
#define PEER_ENTRY_1_MAC_ADDR_A_31_0_MASK                            0xffffffff

/* Description		PEER_ENTRY_2_MAC_ADDR_A_47_32
			
			Upper 16 bits of the MAC address A used by HW for
			encapsulating 802.11
*/
#define PEER_ENTRY_2_MAC_ADDR_A_47_32_OFFSET                         0x00000008
#define PEER_ENTRY_2_MAC_ADDR_A_47_32_LSB                            0
#define PEER_ENTRY_2_MAC_ADDR_A_47_32_MASK                           0x0000ffff

/* Description		PEER_ENTRY_2_MAC_ADDR_B_15_0
			
			Lower 16 bits of the MAC address B used by HW for
			encapsulating 802.11
*/
#define PEER_ENTRY_2_MAC_ADDR_B_15_0_OFFSET                          0x00000008
#define PEER_ENTRY_2_MAC_ADDR_B_15_0_LSB                             16
#define PEER_ENTRY_2_MAC_ADDR_B_15_0_MASK                            0xffff0000

/* Description		PEER_ENTRY_3_MAC_ADDR_B_47_16
			
			Upper 32 bits of the MAC address B used by HW for
			encapsulating 802.11
*/
#define PEER_ENTRY_3_MAC_ADDR_B_47_16_OFFSET                         0x0000000c
#define PEER_ENTRY_3_MAC_ADDR_B_47_16_LSB                            0
#define PEER_ENTRY_3_MAC_ADDR_B_47_16_MASK                           0xffffffff

/* Description		PEER_ENTRY_4_TEMPORAL_KEY_31_0
			
			First 32 bits of the temporal key material.  The
			temporal key for WEP 40-bit uses the first 40 bits, WEP
			104-bit uses the first 104 bits, WEP 128-bit uses all 128
			bits, TKIP with/without MIC uses 128 bits, WAPI uses all 128
			bits, and AES-CCM uses all 128 bits.
*/
#define PEER_ENTRY_4_TEMPORAL_KEY_31_0_OFFSET                        0x00000010
#define PEER_ENTRY_4_TEMPORAL_KEY_31_0_LSB                           0
#define PEER_ENTRY_4_TEMPORAL_KEY_31_0_MASK                          0xffffffff

/* Description		PEER_ENTRY_5_TEMPORAL_KEY_63_32
			
			Second 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.
*/
#define PEER_ENTRY_5_TEMPORAL_KEY_63_32_OFFSET                       0x00000014
#define PEER_ENTRY_5_TEMPORAL_KEY_63_32_LSB                          0
#define PEER_ENTRY_5_TEMPORAL_KEY_63_32_MASK                         0xffffffff

/* Description		PEER_ENTRY_6_TEMPORAL_KEY_95_64
			
			Third 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.
*/
#define PEER_ENTRY_6_TEMPORAL_KEY_95_64_OFFSET                       0x00000018
#define PEER_ENTRY_6_TEMPORAL_KEY_95_64_LSB                          0
#define PEER_ENTRY_6_TEMPORAL_KEY_95_64_MASK                         0xffffffff

/* Description		PEER_ENTRY_7_TEMPORAL_KEY_127_96
			
			Fourth 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.
*/
#define PEER_ENTRY_7_TEMPORAL_KEY_127_96_OFFSET                      0x0000001c
#define PEER_ENTRY_7_TEMPORAL_KEY_127_96_LSB                         0
#define PEER_ENTRY_7_TEMPORAL_KEY_127_96_MASK                        0xffffffff

/* Description		PEER_ENTRY_8_TEMPORAL_KEY_159_128
			
			Fifth 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the TX
			MIC key[31:0].
*/
#define PEER_ENTRY_8_TEMPORAL_KEY_159_128_OFFSET                     0x00000020
#define PEER_ENTRY_8_TEMPORAL_KEY_159_128_LSB                        0
#define PEER_ENTRY_8_TEMPORAL_KEY_159_128_MASK                       0xffffffff

/* Description		PEER_ENTRY_9_TEMPORAL_KEY_191_160
			
			Final 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the TX
			MIC key[63:32].
*/
#define PEER_ENTRY_9_TEMPORAL_KEY_191_160_OFFSET                     0x00000024
#define PEER_ENTRY_9_TEMPORAL_KEY_191_160_LSB                        0
#define PEER_ENTRY_9_TEMPORAL_KEY_191_160_MASK                       0xffffffff

/* Description		PEER_ENTRY_10_TEMPORAL_KEY_223_192
			
			Final 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the RX
			MIC key[31:0].
*/
#define PEER_ENTRY_10_TEMPORAL_KEY_223_192_OFFSET                    0x00000028
#define PEER_ENTRY_10_TEMPORAL_KEY_223_192_LSB                       0
#define PEER_ENTRY_10_TEMPORAL_KEY_223_192_MASK                      0xffffffff

/* Description		PEER_ENTRY_11_TEMPORAL_KEY_255_224
			
			Final 32 bits of the temporal key material.  See the
			description of temporal_key_31_0.  For TKIP this is the RX
			MIC key[63:32].
*/
#define PEER_ENTRY_11_TEMPORAL_KEY_255_224_OFFSET                    0x0000002c
#define PEER_ENTRY_11_TEMPORAL_KEY_255_224_LSB                       0
#define PEER_ENTRY_11_TEMPORAL_KEY_255_224_MASK                      0xffffffff

/* Description		PEER_ENTRY_12_DECAP_TYPE
			
			Indicates the decapsulation that HW will perform:
			
			<enum 0 PTE_DECAP_RAW> No encapsulation
			
			<enum 1 PTE_DECAP_Native_WiFi>
			
			<enum 2 PTE_DECAP_Ethernet_802_3>  Ethernet 2 (DIX) or
			802.3 (uses SNAP/LLC)
			
			<legal 0-2>
			
			Used by the OLE during decapsulation.
*/
#define PEER_ENTRY_12_DECAP_TYPE_OFFSET                              0x00000030
#define PEER_ENTRY_12_DECAP_TYPE_LSB                                 0
#define PEER_ENTRY_12_DECAP_TYPE_MASK                                0x00000003

/* Description		PEER_ENTRY_12_PARTIAL_AID
			
			Specifies the partial AID of response frames transmitted
			at VHT rates.
*/
#define PEER_ENTRY_12_PARTIAL_AID_OFFSET                             0x00000030
#define PEER_ENTRY_12_PARTIAL_AID_LSB                                2
#define PEER_ENTRY_12_PARTIAL_AID_MASK                               0x000007fc

/* Description		PEER_ENTRY_12_GROUP_ID
			
			Specifies the Group ID of response frames transmitted at
			VHT rates.
*/
#define PEER_ENTRY_12_GROUP_ID_OFFSET                                0x00000030
#define PEER_ENTRY_12_GROUP_ID_LSB                                   11
#define PEER_ENTRY_12_GROUP_ID_MASK                                  0x0001f800

/* Description		PEER_ENTRY_12_CTRL_RESP_PWR_MGMT
			
			RX PCU passes this bit setting on to TX PCU, where the
			setting of this bit is inserted in the pwr_mgt bit in the
			control field of the SIFS response control frames: ACK, CTS,
			BA
			
			<legal all>
*/
#define PEER_ENTRY_12_CTRL_RESP_PWR_MGMT_OFFSET                      0x00000030
#define PEER_ENTRY_12_CTRL_RESP_PWR_MGMT_LSB                         17
#define PEER_ENTRY_12_CTRL_RESP_PWR_MGMT_MASK                        0x00020000

/* Description		PEER_ENTRY_12_CBF_RESP_PWR_MGMT
			
			RX PCU passes this bit setting on to TX PCU, where the
			setting of this bit is inserted in the pwr_mgt bit in the
			control field of the Cbf frame.
			
			<legal all>
*/
#define PEER_ENTRY_12_CBF_RESP_PWR_MGMT_OFFSET                       0x00000030
#define PEER_ENTRY_12_CBF_RESP_PWR_MGMT_LSB                          18
#define PEER_ENTRY_12_CBF_RESP_PWR_MGMT_MASK                         0x00040000

/* Description		PEER_ENTRY_12_SCH_RESPONSE_TABLE_ID
			
			Response table id found in the address lookup table for
			this STA. This ID is only valid if it is non zero (Null
			pointer).
			
			The scheduler will only use this ID if based on the
			other fields in this TLV it is determined that a SIFS
			response frame needs to be generated.
			
			<legal all>
*/
#define PEER_ENTRY_12_SCH_RESPONSE_TABLE_ID_OFFSET                   0x00000030
#define PEER_ENTRY_12_SCH_RESPONSE_TABLE_ID_LSB                      19
#define PEER_ENTRY_12_SCH_RESPONSE_TABLE_ID_MASK                     0x00f80000

/* Description		PEER_ENTRY_12_USE_AD_B
			
			The bit is only evaluated when this MSDU is the first
			MSDU in an MPDU. For other MSDUs this bit setting is
			ignored.
			
			It is part of the sw_msdu_param coming from the QM ADD
			frame command.
			
			
			
			Normally in AP mode the DA address is used as the RA. 
			This is normally fine but the use_ad_b bit should be set
			when DA is a multicast/broadcast address but we want to send
			this packet using the destination STA address which will be
			held in the mac_addr_b field of the peer descriptor.
			
			<legal all>
*/
#define PEER_ENTRY_12_USE_AD_B_OFFSET                                0x00000030
#define PEER_ENTRY_12_USE_AD_B_LSB                                   24
#define PEER_ENTRY_12_USE_AD_B_MASK                                  0x01000000

/* Description		PEER_ENTRY_12_STRIP_VLAN
			
			Strip the VLAN during encapsulation.  Used by the OLE.
			
			<legal all>
*/
#define PEER_ENTRY_12_STRIP_VLAN_OFFSET                              0x00000030
#define PEER_ENTRY_12_STRIP_VLAN_LSB                                 25
#define PEER_ENTRY_12_STRIP_VLAN_MASK                                0x02000000

/* Description		PEER_ENTRY_12_STRIP_VLAN_DECAP
			
			Strip the VLAN during decapsulation.  Used by the OLE.
			
			<legal all>
*/
#define PEER_ENTRY_12_STRIP_VLAN_DECAP_OFFSET                        0x00000030
#define PEER_ENTRY_12_STRIP_VLAN_DECAP_LSB                           26
#define PEER_ENTRY_12_STRIP_VLAN_DECAP_MASK                          0x04000000

/* Description		PEER_ENTRY_12_PS_POLL_SIFS_RESP
			
			Field used by RX PCU only:
			
			When set, and when a PS-POLL frame is received, generate
			the SIFS response data request interrupt.
			
			<legal all>
*/
#define PEER_ENTRY_12_PS_POLL_SIFS_RESP_OFFSET                       0x00000030
#define PEER_ENTRY_12_PS_POLL_SIFS_RESP_LSB                          27
#define PEER_ENTRY_12_PS_POLL_SIFS_RESP_MASK                         0x08000000

/* Description		PEER_ENTRY_12_UAPD_SIFS_RESP
			
			Field used by RX PCU only:
			
			When set, and when a QoS Data frame is received, with PM
			bit set, AND whose TID is part of the UAPSD_trigger_bitmap,
			generate the SIFS response data request interrupt.
			
			<legal all>
*/
#define PEER_ENTRY_12_UAPD_SIFS_RESP_OFFSET                          0x00000030
#define PEER_ENTRY_12_UAPD_SIFS_RESP_LSB                             28
#define PEER_ENTRY_12_UAPD_SIFS_RESP_MASK                            0x10000000

/* Description		PEER_ENTRY_12_QBOOST_QOSDATA_SIFS_RESP
			
			Field used by RX PCU only:
			
			For Implicit Qboost trigger handling.
			
			When set, and when a QoS Data frame is received, with PM
			bit NOT set, AND whose TID is part of the
			QBoost_trigger_bitmap, generate the SIFS response data
			request interrupt.
			
			<legal all>
*/
#define PEER_ENTRY_12_QBOOST_QOSDATA_SIFS_RESP_OFFSET                0x00000030
#define PEER_ENTRY_12_QBOOST_QOSDATA_SIFS_RESP_LSB                   29
#define PEER_ENTRY_12_QBOOST_QOSDATA_SIFS_RESP_MASK                  0x20000000

/* Description		PEER_ENTRY_12_QBOOST_BAR_SIFS_RESP
			
			Field used by RX PCU only:
			
			For Implicit Qboost trigger handling.
			
			When set, and when a BAR frame is received, with PM bit
			NOT set, AND whose TID is part of the QBoost_trigger_bitmap,
			generate the SIFS response data request interrupt.
			
			<legal all>
*/
#define PEER_ENTRY_12_QBOOST_BAR_SIFS_RESP_OFFSET                    0x00000030
#define PEER_ENTRY_12_QBOOST_BAR_SIFS_RESP_LSB                       30
#define PEER_ENTRY_12_QBOOST_BAR_SIFS_RESP_MASK                      0x40000000

/* Description		PEER_ENTRY_12_QBOOST_EXPLICIT_SIFS_RESP
			
			Field used by RX PCU only:
			
			When set, and when a QoS Data or BAR frame is received,
			with PM bit NOT set, AND whose explicit proprietary Qboost
			trigger field is set, generate the SIFS response data
			request interrupt.
			
			<legal all>
*/
#define PEER_ENTRY_12_QBOOST_EXPLICIT_SIFS_RESP_OFFSET               0x00000030
#define PEER_ENTRY_12_QBOOST_EXPLICIT_SIFS_RESP_LSB                  31
#define PEER_ENTRY_12_QBOOST_EXPLICIT_SIFS_RESP_MASK                 0x80000000

/* Description		PEER_ENTRY_13_UAPSD_TRIGGER_BITMAP
			
			Field used by RX PCU only:
			
			A TID bitmap (bit 0: TID0, bit 1, TID 1 etc.) where a
			value of 1 for a TID indicates that this QoS data frame is
			considered a UAPSD trigger frame.
			
			<legal all>
*/
#define PEER_ENTRY_13_UAPSD_TRIGGER_BITMAP_OFFSET                    0x00000034
#define PEER_ENTRY_13_UAPSD_TRIGGER_BITMAP_LSB                       0
#define PEER_ENTRY_13_UAPSD_TRIGGER_BITMAP_MASK                      0x0000ffff

/* Description		PEER_ENTRY_13_QBOOST_TRIGGER_BITMAP
			
			Field used by RX PCU only:
			
			For implicit Qboost trigger handling
			
			A TID bitmap (bit 0: TID0, bit 1, TID 1 etc.) where a
			value of 1 for a TID indicates that this QoS data frame (or
			BAR frame) is considered a Qboost trigger frame.
			
			<legal all>
*/
#define PEER_ENTRY_13_QBOOST_TRIGGER_BITMAP_OFFSET                   0x00000034
#define PEER_ENTRY_13_QBOOST_TRIGGER_BITMAP_LSB                      16
#define PEER_ENTRY_13_QBOOST_TRIGGER_BITMAP_MASK                     0xffff0000

/* Description		PEER_ENTRY_14_NC_INDEX
			
			Nc index used for TxBF CBF generation. 
*/
#define PEER_ENTRY_14_NC_INDEX_OFFSET                                0x00000038
#define PEER_ENTRY_14_NC_INDEX_LSB                                   0
#define PEER_ENTRY_14_NC_INDEX_MASK                                  0x00000007

/* Description		PEER_ENTRY_14_RX_INSERT_VLAN_TAG_PADDING
			
			Insert 4 byte of all zeros as VLAN tag if the rx payload
			does not have VLAN. Used during decapsulation. <legal all>
*/
#define PEER_ENTRY_14_RX_INSERT_VLAN_TAG_PADDING_OFFSET              0x00000038
#define PEER_ENTRY_14_RX_INSERT_VLAN_TAG_PADDING_LSB                 3
#define PEER_ENTRY_14_RX_INSERT_VLAN_TAG_PADDING_MASK                0x00000008

/* Description		PEER_ENTRY_14_VLAN_LLC
			
			If set encapsulate/decapsulate using the Scorpion
			compatible VLAN LLC format
*/
#define PEER_ENTRY_14_VLAN_LLC_OFFSET                                0x00000038
#define PEER_ENTRY_14_VLAN_LLC_LSB                                   4
#define PEER_ENTRY_14_VLAN_LLC_MASK                                  0x00000010

/* Description		PEER_ENTRY_14_RESERVED_14
			
			Generator should set to 0 and the consumer shall ignore.
			<legal 0>
*/
#define PEER_ENTRY_14_RESERVED_14_OFFSET                             0x00000038
#define PEER_ENTRY_14_RESERVED_14_LSB                                5
#define PEER_ENTRY_14_RESERVED_14_MASK                               0xffffffe0

/* Description		PEER_ENTRY_15_MAC_ADDR_C_31_0
			
			Lower 32 bits of MAC address C.  MAC address C will hold
			the transmitter address (AD2) for RTS frames
*/
#define PEER_ENTRY_15_MAC_ADDR_C_31_0_OFFSET                         0x0000003c
#define PEER_ENTRY_15_MAC_ADDR_C_31_0_LSB                            0
#define PEER_ENTRY_15_MAC_ADDR_C_31_0_MASK                           0xffffffff

/* Description		PEER_ENTRY_16_MAC_ADDR_C_47_32
			
			Upper 16 bits of MAC address C.
*/
#define PEER_ENTRY_16_MAC_ADDR_C_47_32_OFFSET                        0x00000040
#define PEER_ENTRY_16_MAC_ADDR_C_47_32_LSB                           0
#define PEER_ENTRY_16_MAC_ADDR_C_47_32_MASK                          0x0000ffff

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_20MHZ
			
			Capture sounding for 1 stream 20 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_20MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_20MHZ_LSB                16
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_20MHZ_MASK               0x00010000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_20MHZ
			
			Capture sounding for 2 stream 20 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_20MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_20MHZ_LSB                17
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_20MHZ_MASK               0x00020000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_20MHZ
			
			Capture sounding for 3 stream 20 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_20MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_20MHZ_LSB                18
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_20MHZ_MASK               0x00040000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_20MHZ
			
			Capture sounding for 4 stream 20 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_20MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_20MHZ_LSB                19
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_20MHZ_MASK               0x00080000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_40MHZ
			
			Capture sounding for 1 stream 40 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_40MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_40MHZ_LSB                20
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_40MHZ_MASK               0x00100000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_40MHZ
			
			Capture sounding for 2 stream 40 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_40MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_40MHZ_LSB                21
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_40MHZ_MASK               0x00200000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_40MHZ
			
			Capture sounding for 3 stream 40 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_40MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_40MHZ_LSB                22
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_40MHZ_MASK               0x00400000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_40MHZ
			
			Capture sounding for 4 stream 40 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_40MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_40MHZ_LSB                23
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_40MHZ_MASK               0x00800000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_80MHZ
			
			Capture sounding for 1 stream 80 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_80MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_80MHZ_LSB                24
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_80MHZ_MASK               0x01000000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_80MHZ
			
			Capture sounding for 2 stream 80 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_80MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_80MHZ_LSB                25
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_80MHZ_MASK               0x02000000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_80MHZ
			
			Capture sounding for 3 stream 80 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_80MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_80MHZ_LSB                26
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_80MHZ_MASK               0x04000000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_80MHZ
			
			Capture sounding for 4 stream 80 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_80MHZ_OFFSET             0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_80MHZ_LSB                27
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_80MHZ_MASK               0x08000000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_160MHZ
			
			Capture sounding for 1 stream 160 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_160MHZ_OFFSET            0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_160MHZ_LSB               28
#define PEER_ENTRY_16_CAPTURE_SOUNDING_1STR_160MHZ_MASK              0x10000000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_160MHZ
			
			Capture sounding for 2 stream 160 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_160MHZ_OFFSET            0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_160MHZ_LSB               29
#define PEER_ENTRY_16_CAPTURE_SOUNDING_2STR_160MHZ_MASK              0x20000000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_160MHZ
			
			Capture sounding for 3 stream 160 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_160MHZ_OFFSET            0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_160MHZ_LSB               30
#define PEER_ENTRY_16_CAPTURE_SOUNDING_3STR_160MHZ_MASK              0x40000000

/* Description		PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_160MHZ
			
			Capture sounding for 4 stream 160 MHz receive packets
*/
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_160MHZ_OFFSET            0x00000040
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_160MHZ_LSB               31
#define PEER_ENTRY_16_CAPTURE_SOUNDING_4STR_160MHZ_MASK              0x80000000


#endif // _PEER_ENTRY_H_
