// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _MSDU_RELEASE_H_
#define _MSDU_RELEASE_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	msdu_head_index[15:0], qid[29:16], release_reason[31:30]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_MSDU_RELEASE 1

struct msdu_release {
    volatile uint32_t msdu_head_index                 : 16, //[15:0]
                      qid                             : 14, //[29:16]
                      release_reason                  :  2; //[31:30]
};

/*

msdu_head_index
			
			MSDU head index.
			
			The MSDU index of the MSDU that is released back to SW.
			Note that the MSDU link descriptor corresponding to this
			MSDU index, contains a next_msdu_index  field. If this is
			NOT NULL, will contains a pointer to another MSDU that is
			also released to SW. SW should continue following these MSDU
			links till a NULL pointer is found
			
			<legal all>

qid
			
			Queue ID:  The Index of the MPDU transmit queue from
			which this MSDU frame (and the ones linked to it got
			released. <legal all>

release_reason
			
			<enum 0 received_ack>  Frame has been transmitted and
			got ACKed with an ACK frame or frame got deleted because
			this is a NO ACK flow.
			
			<enum 1 received_ba >  Frame has been transmitted and
			got ACKed with a BA frame
			
			<enum 2 lifetime_expired_or_flush>  Scheduler indicated
			to remove this frame (lifespan expired) or the QM received a
			flush command for this queue
			
			<enum 3 max_mpdu_retry_cnt>  Max MPDU retry count got
			reached
*/


/* Description		MSDU_RELEASE_0_MSDU_HEAD_INDEX
			
			MSDU head index.
			
			The MSDU index of the MSDU that is released back to SW.
			Note that the MSDU link descriptor corresponding to this
			MSDU index, contains a next_msdu_index  field. If this is
			NOT NULL, will contains a pointer to another MSDU that is
			also released to SW. SW should continue following these MSDU
			links till a NULL pointer is found
			
			<legal all>
*/
#define MSDU_RELEASE_0_MSDU_HEAD_INDEX_OFFSET                        0x00000000
#define MSDU_RELEASE_0_MSDU_HEAD_INDEX_LSB                           0
#define MSDU_RELEASE_0_MSDU_HEAD_INDEX_MASK                          0x0000ffff

/* Description		MSDU_RELEASE_0_QID
			
			Queue ID:  The Index of the MPDU transmit queue from
			which this MSDU frame (and the ones linked to it got
			released. <legal all>
*/
#define MSDU_RELEASE_0_QID_OFFSET                                    0x00000000
#define MSDU_RELEASE_0_QID_LSB                                       16
#define MSDU_RELEASE_0_QID_MASK                                      0x3fff0000

/* Description		MSDU_RELEASE_0_RELEASE_REASON
			
			<enum 0 received_ack>  Frame has been transmitted and
			got ACKed with an ACK frame or frame got deleted because
			this is a NO ACK flow.
			
			<enum 1 received_ba >  Frame has been transmitted and
			got ACKed with a BA frame
			
			<enum 2 lifetime_expired_or_flush>  Scheduler indicated
			to remove this frame (lifespan expired) or the QM received a
			flush command for this queue
			
			<enum 3 max_mpdu_retry_cnt>  Max MPDU retry count got
			reached
*/
#define MSDU_RELEASE_0_RELEASE_REASON_OFFSET                         0x00000000
#define MSDU_RELEASE_0_RELEASE_REASON_LSB                            30
#define MSDU_RELEASE_0_RELEASE_REASON_MASK                           0xc0000000


#endif // _MSDU_RELEASE_H_
