// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _SCHEDULER_TRANSMIT_STATUS_H_
#define _SCHEDULER_TRANSMIT_STATUS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	schedule_id[15:0], schedule_cmd_ring_id[20:16], fes_control_mode[22:21], number_of_users[24:23], cmd_ring_stall_status[26:25], data_underrun_warning[27], sch_cmd_result[31:28]
//	1	sch_eval_start_timestamp[31:0]
//	2	sch_eval_end_timestamp[31:0]
//	3	sifs_burst_status[3:0], crypto_rx_idle_status[4], reserved_3a[7:5], flush_req_reason[15:8], reserved_3b[31:16]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_SCHEDULER_TRANSMIT_STATUS 4

struct scheduler_transmit_status {
    volatile uint32_t schedule_id                     : 16, //[15:0]
                      schedule_cmd_ring_id            :  5, //[20:16]
                      fes_control_mode                :  2, //[22:21]
                      number_of_users                 :  2, //[24:23]
                      cmd_ring_stall_status           :  2, //[26:25]
                      data_underrun_warning           :  1, //[27]
                      sch_cmd_result                  :  4; //[31:28]
    volatile uint32_t sch_eval_start_timestamp        : 32; //[31:0]
    volatile uint32_t sch_eval_end_timestamp          : 32; //[31:0]
    volatile uint32_t sifs_burst_status               :  4, //[3:0]
                      crypto_rx_idle_status           :  1, //[4]
                      reserved_3a                     :  3, //[7:5]
                      flush_req_reason                :  8, //[15:8]
                      reserved_3b                     : 16; //[31:16]
};

/*

schedule_id
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.

schedule_cmd_ring_id
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>

fes_control_mode
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>

number_of_users
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users

cmd_ring_stall_status
			
			<enum 0 not_stalled> Scheduler command ring is NOT
			stalled
			
			<enum 1 stalled_on_unsuccessful_transmit> Scheduler
			command ring is Stalled, due to unsuccessfull transmission
			(sch_cmd_ result other then 0), and the scheduling command
			had the stall_schedule_enable field set)
			
			<enum 2 stalled_on_CBF_lower_bw> Scheduler command ring
			is Stalled, due to receiving CBF with lower bandwith then
			requested (and Pause_on_CBF_lower_bw field in scheduling
			command is set)
			
			<enum 3 stalled_on_excessive_requeue> Scheduler command
			ring is stalled due to excessive re-queues
			
			
			
			<legal 0-3>

data_underrun_warning
			
			0: No data under-run happened
			
			1: Data under-run happened

sch_cmd_result
			
			<enum 0 success>
			
			<enum 1 SU_Response_type_mismatch_fail> 
			
			HWSCH sets this enum value if SU_Response_type_mismatch
			is set in fes_transmit_result. 
			
			<enum 2 cbf_mimo_ctrl_mismatch_fail> 
			
			HWSCH sets this enum value if cbf_mimo_ctrl_mismatch is
			set in fes_transmit_result. 
			
			<enum 3 lifespan_expiry_fail> No successful transmission
			due to schedule lifespan expiration
			
			<enum 4 max_schedule_retry_count_fail> No successful
			transmission due to reaching maximum schedule retry count.
			
			<enum 5 qcu_filtered> No successful transmission due to
			qcu_filter set in the peer entry
			
			<enum 6 lower_CBF_bw_fail> lower then required CBF
			bandwidth received
			
			<enum 7 flush_rcvd> Flush request received. Field
			'flush_reason' indicates the reason why the flush command
			was received
			
			
			
			<legal 0-7>

sch_eval_start_timestamp
			
			The timestamp (based on always running system timer) at
			which the scheduler read the schedule command from the
			command ring (or response table)

sch_eval_end_timestamp
			
			The timestamp (based on always running system timer) at
			which the scheduler wrote this status report to the transmit
			status ring

sifs_burst_status
			
			<enum 0 no_SIFS_burst> No SIFS bursting was ongoing
			
			<enum 1 SIFS_burst_in_progress> SIFS burst ongoing and
			continuing with next command
			
			<enum 2 SIFS_burst_end> SIFS burst ended normally: all
			commands of the SIFS burst have been executed, and this
			command was the last one
			
			<enum 3 SIFS_burst_pause_on_filter> SIFS bursting is
			paused due to a filter condition, which was not a forced
			re-queue and SW enabled pause_on_filter
			
			<enum 4 SIFS_burst_split> SIFS burst will continue after
			next  bo expiration. The full SIFS burst has been split into
			two
			
			<enum 5 SIFS_burst_complete_in_PIFS> SIFS burst ongoing
			and HWSCH could not complete in SIFS but completed in PIFS
			
			<enum 6 SIFS_burst_pause_on_requeue> SIFS bursting is
			paused due to a re-queue condition, and SW enabled
			pause_on_filter and force_requeue_to_filter
			
			<enum 7 SIFS_burst_pause_on_no_next_cmd> SIFS bursting
			is paused due to next command not available in a burst
			
			<legal 0-7>

crypto_rx_idle_status
			
			If we flush due to crypto rx being busy, this will be
			zero. Expected to be 0.

reserved_3a
			
			0

flush_req_reason
			
			The reason why the flush request was generated.
			
			Reason codes:
			
			<enum 1 TXPCU_FLREQ_CODE_TXOP_EXCEEDED>
			
			Flush request issued by TXPCU in case of a WCOEX abort.
			
			<enum 2 CRYPT_FLREQ_RX_INT_TX>
			
			This is a corner case scenario. A situation where:
			
			a.A RX is just over and CCA indication is IDLE
			
			b.Crypt is still busy decrypting
			
			c.A TX just starts.
			
			The TX should be tried later. This situation may be
			rare. Just taking an extra precaution.
			
			<enum 3 TXPCU_FLREQ_CODE_RTS_PKT_CCA_ABORT>
			
			This is the static BW failure happening right after
			start_tx for either RTS frame or data packet
			
			<enum 4 TXPCU_FLREQ_CODE_CTS_CCA_ABORT>
			
			This is the static BW failure in the protection sequence
			(CTS).
			
			<enum 5 PDG_FLREQ_CODE_TXOP_ABORT>
			
			This is PDG signaling not enough TXOP for transmission.
			
			
			
			HWSCH internal flush requests:
			
			<enum 6 SW_EXPLICIT_FLUSH_TERMINATION>
			
			When SW issues a flush WHICH CAUSES AN ONGOING FES to
			terminate
			
			<enum 7 FES_STP_NOT_ENOUGH_TXOP_REM>
			
			Not enough TXOP remaining in either SW or HW mode. This
			checks if the remaining TXOP < a parameterized minimum time.
			Currently half SIFS duration (5 us).
			
			<enum 8 FES_STP_SCH_TLV_LEN_ERR>
			
			Scheduler TLV length programmed by SW is incorrect. A
			simple check to see if TLV length does not exceed a max
			parameter (currently  132 dwords). This was calculated based
			on worst case SW mode Scheduler TLV required.
			
			<enum 9 FES_STP_SCH_TLV_ID_ERR>
			
			Error while parsing scheduler TLV. Most likely arising
			from incorrect length programmed in the component TLVs.
			
			<enum 10 FES_STP_TLV_TIME_EXCEEDED_BKOF_EXP>
			
			Issued in case TLV transmission exceeds start_tx time.
			
			<enum 11 FES_STP_SW_FES_TIME_GT_HW>
			
			SW mode abort. When HWSCH determines that none of the SW
			programmed (upto 3) BW times can fit into the current TXOP
			remaining.
			
			<enum 12 TXPCU_FLREQ_PPDU_ALLOW_BW_FIELDS_NOT_SET>
			
			Flush request issued by TXPCU in case none of the
			PPDU_ALLOW_BW_* fields are set in PCU_PPDU_SETUP TLV.
			
			<enum 13 TXPCU_FLREQ_BF_PARAM_BW_NOT_AVAILABLE>
			
			Flush request issued by TXPCU in case the BW indicated
			in TX_BF_PARAM is not available at the transmission attempt
			
			<enum 14 HWSCH_COEX_ABORT>
			
			Flush request issued by HWSCH when a coex event caused
			this transmit to be aborted
			
			<enum 15 HWSCH_SVD_RDY_TIMEOUT>
			
			Flush request issued by HWSCH when the PHY does not
			return the SVD_READY before a timeout expires
			
			<enum 16 NUM_MPDU_CNT_ZERO>
			
			Flush request issued by TXPCU when the number of MPDU
			counter for selected BW is zero. 
			
			<enum 17 UNSUPPORTED_CBF>
			
			Flush request issued by TXPCU if TXPCU receives
			TX_PKT_END with error_unsupported_cbf during CV transfer. 
			
			<legal 1-17>

reserved_3b
			
			0
*/


/* Description		SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.
*/
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID_OFFSET               0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID_LSB                  0
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID_MASK                 0x0000ffff

/* Description		SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>
*/
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID_OFFSET      0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID_LSB         16
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID_MASK        0x001f0000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>
*/
#define SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE_OFFSET          0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE_LSB             21
#define SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE_MASK            0x00600000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users
*/
#define SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS_OFFSET           0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS_LSB              23
#define SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS_MASK             0x01800000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS
			
			<enum 0 not_stalled> Scheduler command ring is NOT
			stalled
			
			<enum 1 stalled_on_unsuccessful_transmit> Scheduler
			command ring is Stalled, due to unsuccessfull transmission
			(sch_cmd_ result other then 0), and the scheduling command
			had the stall_schedule_enable field set)
			
			<enum 2 stalled_on_CBF_lower_bw> Scheduler command ring
			is Stalled, due to receiving CBF with lower bandwith then
			requested (and Pause_on_CBF_lower_bw field in scheduling
			command is set)
			
			<enum 3 stalled_on_excessive_requeue> Scheduler command
			ring is stalled due to excessive re-queues
			
			
			
			<legal 0-3>
*/
#define SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS_OFFSET     0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS_LSB        25
#define SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS_MASK       0x06000000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING
			
			0: No data under-run happened
			
			1: Data under-run happened
*/
#define SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING_OFFSET     0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING_LSB        27
#define SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING_MASK       0x08000000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT
			
			<enum 0 success>
			
			<enum 1 SU_Response_type_mismatch_fail> 
			
			HWSCH sets this enum value if SU_Response_type_mismatch
			is set in fes_transmit_result. 
			
			<enum 2 cbf_mimo_ctrl_mismatch_fail> 
			
			HWSCH sets this enum value if cbf_mimo_ctrl_mismatch is
			set in fes_transmit_result. 
			
			<enum 3 lifespan_expiry_fail> No successful transmission
			due to schedule lifespan expiration
			
			<enum 4 max_schedule_retry_count_fail> No successful
			transmission due to reaching maximum schedule retry count.
			
			<enum 5 qcu_filtered> No successful transmission due to
			qcu_filter set in the peer entry
			
			<enum 6 lower_CBF_bw_fail> lower then required CBF
			bandwidth received
			
			<enum 7 flush_rcvd> Flush request received. Field
			'flush_reason' indicates the reason why the flush command
			was received
			
			
			
			<legal 0-7>
*/
#define SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT_OFFSET            0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT_LSB               28
#define SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT_MASK              0xf0000000

/* Description		SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP
			
			The timestamp (based on always running system timer) at
			which the scheduler read the schedule command from the
			command ring (or response table)
*/
#define SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP_OFFSET  0x00000004
#define SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP_LSB     0
#define SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP_MASK    0xffffffff

/* Description		SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP
			
			The timestamp (based on always running system timer) at
			which the scheduler wrote this status report to the transmit
			status ring
*/
#define SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP_OFFSET    0x00000008
#define SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP_LSB       0
#define SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP_MASK      0xffffffff

/* Description		SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_STATUS
			
			<enum 0 no_SIFS_burst> No SIFS bursting was ongoing
			
			<enum 1 SIFS_burst_in_progress> SIFS burst ongoing and
			continuing with next command
			
			<enum 2 SIFS_burst_end> SIFS burst ended normally: all
			commands of the SIFS burst have been executed, and this
			command was the last one
			
			<enum 3 SIFS_burst_pause_on_filter> SIFS bursting is
			paused due to a filter condition, which was not a forced
			re-queue and SW enabled pause_on_filter
			
			<enum 4 SIFS_burst_split> SIFS burst will continue after
			next  bo expiration. The full SIFS burst has been split into
			two
			
			<enum 5 SIFS_burst_complete_in_PIFS> SIFS burst ongoing
			and HWSCH could not complete in SIFS but completed in PIFS
			
			<enum 6 SIFS_burst_pause_on_requeue> SIFS bursting is
			paused due to a re-queue condition, and SW enabled
			pause_on_filter and force_requeue_to_filter
			
			<enum 7 SIFS_burst_pause_on_no_next_cmd> SIFS bursting
			is paused due to next command not available in a burst
			
			<legal 0-7>
*/
#define SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_STATUS_OFFSET         0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_STATUS_LSB            0
#define SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_STATUS_MASK           0x0000000f

/* Description		SCHEDULER_TRANSMIT_STATUS_3_CRYPTO_RX_IDLE_STATUS
			
			If we flush due to crypto rx being busy, this will be
			zero. Expected to be 0.
*/
#define SCHEDULER_TRANSMIT_STATUS_3_CRYPTO_RX_IDLE_STATUS_OFFSET     0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_CRYPTO_RX_IDLE_STATUS_LSB        4
#define SCHEDULER_TRANSMIT_STATUS_3_CRYPTO_RX_IDLE_STATUS_MASK       0x00000010

/* Description		SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3A
			
			0
*/
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3A_OFFSET               0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3A_LSB                  5
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3A_MASK                 0x000000e0

/* Description		SCHEDULER_TRANSMIT_STATUS_3_FLUSH_REQ_REASON
			
			The reason why the flush request was generated.
			
			Reason codes:
			
			<enum 1 TXPCU_FLREQ_CODE_TXOP_EXCEEDED>
			
			Flush request issued by TXPCU in case of a WCOEX abort.
			
			<enum 2 CRYPT_FLREQ_RX_INT_TX>
			
			This is a corner case scenario. A situation where:
			
			a.A RX is just over and CCA indication is IDLE
			
			b.Crypt is still busy decrypting
			
			c.A TX just starts.
			
			The TX should be tried later. This situation may be
			rare. Just taking an extra precaution.
			
			<enum 3 TXPCU_FLREQ_CODE_RTS_PKT_CCA_ABORT>
			
			This is the static BW failure happening right after
			start_tx for either RTS frame or data packet
			
			<enum 4 TXPCU_FLREQ_CODE_CTS_CCA_ABORT>
			
			This is the static BW failure in the protection sequence
			(CTS).
			
			<enum 5 PDG_FLREQ_CODE_TXOP_ABORT>
			
			This is PDG signaling not enough TXOP for transmission.
			
			
			
			HWSCH internal flush requests:
			
			<enum 6 SW_EXPLICIT_FLUSH_TERMINATION>
			
			When SW issues a flush WHICH CAUSES AN ONGOING FES to
			terminate
			
			<enum 7 FES_STP_NOT_ENOUGH_TXOP_REM>
			
			Not enough TXOP remaining in either SW or HW mode. This
			checks if the remaining TXOP < a parameterized minimum time.
			Currently half SIFS duration (5 us).
			
			<enum 8 FES_STP_SCH_TLV_LEN_ERR>
			
			Scheduler TLV length programmed by SW is incorrect. A
			simple check to see if TLV length does not exceed a max
			parameter (currently  132 dwords). This was calculated based
			on worst case SW mode Scheduler TLV required.
			
			<enum 9 FES_STP_SCH_TLV_ID_ERR>
			
			Error while parsing scheduler TLV. Most likely arising
			from incorrect length programmed in the component TLVs.
			
			<enum 10 FES_STP_TLV_TIME_EXCEEDED_BKOF_EXP>
			
			Issued in case TLV transmission exceeds start_tx time.
			
			<enum 11 FES_STP_SW_FES_TIME_GT_HW>
			
			SW mode abort. When HWSCH determines that none of the SW
			programmed (upto 3) BW times can fit into the current TXOP
			remaining.
			
			<enum 12 TXPCU_FLREQ_PPDU_ALLOW_BW_FIELDS_NOT_SET>
			
			Flush request issued by TXPCU in case none of the
			PPDU_ALLOW_BW_* fields are set in PCU_PPDU_SETUP TLV.
			
			<enum 13 TXPCU_FLREQ_BF_PARAM_BW_NOT_AVAILABLE>
			
			Flush request issued by TXPCU in case the BW indicated
			in TX_BF_PARAM is not available at the transmission attempt
			
			<enum 14 HWSCH_COEX_ABORT>
			
			Flush request issued by HWSCH when a coex event caused
			this transmit to be aborted
			
			<enum 15 HWSCH_SVD_RDY_TIMEOUT>
			
			Flush request issued by HWSCH when the PHY does not
			return the SVD_READY before a timeout expires
			
			<enum 16 NUM_MPDU_CNT_ZERO>
			
			Flush request issued by TXPCU when the number of MPDU
			counter for selected BW is zero. 
			
			<enum 17 UNSUPPORTED_CBF>
			
			Flush request issued by TXPCU if TXPCU receives
			TX_PKT_END with error_unsupported_cbf during CV transfer. 
			
			<legal 1-17>
*/
#define SCHEDULER_TRANSMIT_STATUS_3_FLUSH_REQ_REASON_OFFSET          0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_FLUSH_REQ_REASON_LSB             8
#define SCHEDULER_TRANSMIT_STATUS_3_FLUSH_REQ_REASON_MASK            0x0000ff00

/* Description		SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3B
			
			0
*/
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3B_OFFSET               0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3B_LSB                  16
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3B_MASK                 0xffff0000


#endif // _SCHEDULER_TRANSMIT_STATUS_H_
