// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _RX_MPDU_START_H_
#define _RX_MPDU_START_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	peer_idx[10:0], fr_ds[11], to_ds[12], encrypted[13], retry[14], reserved[15], seq_num[27:16], encrypt_type[31:28]
//	1	pn_31_0[31:0]
//	2	pn_47_32[15:0], reserved_2[27:16], tid[31:28]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_RX_MPDU_START 3

struct rx_mpdu_start {
             uint32_t peer_idx                        : 11, //[10:0]
                      fr_ds                           :  1, //[11]
                      to_ds                           :  1, //[12]
                      encrypted                       :  1, //[13]
                      retry                           :  1, //[14]
                      reserved                        :  1, //[15]
                      seq_num                         : 12, //[27:16]
                      encrypt_type                    :  4; //[31:28]
             uint32_t pn_31_0                         : 32; //[31:0]
             uint32_t pn_47_32                        : 16, //[15:0]
                      reserved_2                      : 12, //[27:16]
                      tid                             :  4; //[31:28]
};

/*

peer_idx
			
			The index of the address search table which associated
			with the peer entry corresponding to this MPDU.  Only valid
			when first_msdu is set.

fr_ds
			
			Set if the from DS bit is set in the frame control. 
			Only valid when first_msdu is set.

to_ds
			
			Set if the to DS bit is set in the frame control.  Only
			valid when first_msdu is set.

encrypted
			
			Protected bit from the frame control.  Only valid when
			first_msdu is set.

retry
			
			Retry bit from the frame control.  Only valid when
			first_msdu is set.

reserved
			
			Reserved: generator should set to 0, consumer shall
			ignore.

seq_num
			
			The sequence number from the 802.11 header.  Only valid
			when first_msdu is set.

encrypt_type
			
			Indicates type of decrypt cipher used (as defined in the
			peer entry)
			
			<enum 0 wep_40> WEP 40-bit
			
			<enum 1 wep_104> WEP 104-bit
			
			<enum 2 tkip_no_mic> TKIP without MIC
			
			<enum 3 wep_128> WEP 128-bit
			
			<enum 4 tkip_with_mic> TKIP with MIC
			
			<enum 5 wapi> WAPI
			
			<enum 6 aes_ccmp_128> AES CCMP 128
			
			<enum 7 no_cipher> No crypto
			
			<enum 8 aes_ccmp_256> AES CCMP 256
			
			<enum 9 aes_gcmp_128> AES CCMP 128
			
			<enum 10 aes_gcmp_256> AES CCMP 256
			
			Only valid when first_msdu_is set

pn_31_0
			
			
			WEP: IV = {key_id_octet, pn2, pn1, pn0}.  Only pn[23:0]
			is valid.
			
			TKIP: IV = {pn5, pn4, pn3, pn2, key_id_octet, pn0,
			WEPSeed[1], pn1}.  Only pn[47:0] is valid.
			
			AES-CCM: IV = {pn5, pn4, pn3, pn2, key_id_octet, 0x0,
			pn1, pn0}.  Only pn[47:0] is valid.
			
			WAPI: IV = {key_id_octet, 0x0, pn15, pn14, pn13, pn12,
			pn11, pn10, pn9, pn8, pn7, pn6, pn5, pn4, pn3, pn2, pn1,
			pn0}.  The ext_wapi_pn[127:48] in the rx_msdu_misc
			descriptor and pn[47:0] are valid.
			
			Only valid when first_msdu is set.

pn_47_32
			
			Bits [47:32] of the PN number.   See description for
			pn_31_0.  The remaining PN fields are in the rx_msdu_end
			descriptor

reserved_2
			
			Reserved: HW should fill with zero.  FW should ignore.

tid
			
			The TID field in the QoS control field
*/


/* Description		RX_MPDU_START_0_PEER_IDX
			
			The index of the address search table which associated
			with the peer entry corresponding to this MPDU.  Only valid
			when first_msdu is set.
*/
#define RX_MPDU_START_0_PEER_IDX_OFFSET                              0x00000000
#define RX_MPDU_START_0_PEER_IDX_LSB                                 0
#define RX_MPDU_START_0_PEER_IDX_MASK                                0x000007ff

/* Description		RX_MPDU_START_0_FR_DS
			
			Set if the from DS bit is set in the frame control. 
			Only valid when first_msdu is set.
*/
#define RX_MPDU_START_0_FR_DS_OFFSET                                 0x00000000
#define RX_MPDU_START_0_FR_DS_LSB                                    11
#define RX_MPDU_START_0_FR_DS_MASK                                   0x00000800

/* Description		RX_MPDU_START_0_TO_DS
			
			Set if the to DS bit is set in the frame control.  Only
			valid when first_msdu is set.
*/
#define RX_MPDU_START_0_TO_DS_OFFSET                                 0x00000000
#define RX_MPDU_START_0_TO_DS_LSB                                    12
#define RX_MPDU_START_0_TO_DS_MASK                                   0x00001000

/* Description		RX_MPDU_START_0_ENCRYPTED
			
			Protected bit from the frame control.  Only valid when
			first_msdu is set.
*/
#define RX_MPDU_START_0_ENCRYPTED_OFFSET                             0x00000000
#define RX_MPDU_START_0_ENCRYPTED_LSB                                13
#define RX_MPDU_START_0_ENCRYPTED_MASK                               0x00002000

/* Description		RX_MPDU_START_0_RETRY
			
			Retry bit from the frame control.  Only valid when
			first_msdu is set.
*/
#define RX_MPDU_START_0_RETRY_OFFSET                                 0x00000000
#define RX_MPDU_START_0_RETRY_LSB                                    14
#define RX_MPDU_START_0_RETRY_MASK                                   0x00004000

/* Description		RX_MPDU_START_0_RESERVED
			
			Reserved: generator should set to 0, consumer shall
			ignore.
*/
#define RX_MPDU_START_0_RESERVED_OFFSET                              0x00000000
#define RX_MPDU_START_0_RESERVED_LSB                                 15
#define RX_MPDU_START_0_RESERVED_MASK                                0x00008000

/* Description		RX_MPDU_START_0_SEQ_NUM
			
			The sequence number from the 802.11 header.  Only valid
			when first_msdu is set.
*/
#define RX_MPDU_START_0_SEQ_NUM_OFFSET                               0x00000000
#define RX_MPDU_START_0_SEQ_NUM_LSB                                  16
#define RX_MPDU_START_0_SEQ_NUM_MASK                                 0x0fff0000

/* Description		RX_MPDU_START_0_ENCRYPT_TYPE
			
			Indicates type of decrypt cipher used (as defined in the
			peer entry)
			
			<enum 0 wep_40> WEP 40-bit
			
			<enum 1 wep_104> WEP 104-bit
			
			<enum 2 tkip_no_mic> TKIP without MIC
			
			<enum 3 wep_128> WEP 128-bit
			
			<enum 4 tkip_with_mic> TKIP with MIC
			
			<enum 5 wapi> WAPI
			
			<enum 6 aes_ccmp_128> AES CCMP 128
			
			<enum 7 no_cipher> No crypto
			
			<enum 8 aes_ccmp_256> AES CCMP 256
			
			<enum 9 aes_gcmp_128> AES CCMP 128
			
			<enum 10 aes_gcmp_256> AES CCMP 256
			
			Only valid when first_msdu_is set
*/
#define RX_MPDU_START_0_ENCRYPT_TYPE_OFFSET                          0x00000000
#define RX_MPDU_START_0_ENCRYPT_TYPE_LSB                             28
#define RX_MPDU_START_0_ENCRYPT_TYPE_MASK                            0xf0000000

/* Description		RX_MPDU_START_1_PN_31_0
			
			
			WEP: IV = {key_id_octet, pn2, pn1, pn0}.  Only pn[23:0]
			is valid.
			
			TKIP: IV = {pn5, pn4, pn3, pn2, key_id_octet, pn0,
			WEPSeed[1], pn1}.  Only pn[47:0] is valid.
			
			AES-CCM: IV = {pn5, pn4, pn3, pn2, key_id_octet, 0x0,
			pn1, pn0}.  Only pn[47:0] is valid.
			
			WAPI: IV = {key_id_octet, 0x0, pn15, pn14, pn13, pn12,
			pn11, pn10, pn9, pn8, pn7, pn6, pn5, pn4, pn3, pn2, pn1,
			pn0}.  The ext_wapi_pn[127:48] in the rx_msdu_misc
			descriptor and pn[47:0] are valid.
			
			Only valid when first_msdu is set.
*/
#define RX_MPDU_START_1_PN_31_0_OFFSET                               0x00000004
#define RX_MPDU_START_1_PN_31_0_LSB                                  0
#define RX_MPDU_START_1_PN_31_0_MASK                                 0xffffffff

/* Description		RX_MPDU_START_2_PN_47_32
			
			Bits [47:32] of the PN number.   See description for
			pn_31_0.  The remaining PN fields are in the rx_msdu_end
			descriptor
*/
#define RX_MPDU_START_2_PN_47_32_OFFSET                              0x00000008
#define RX_MPDU_START_2_PN_47_32_LSB                                 0
#define RX_MPDU_START_2_PN_47_32_MASK                                0x0000ffff

/* Description		RX_MPDU_START_2_RESERVED_2
			
			Reserved: HW should fill with zero.  FW should ignore.
*/
#define RX_MPDU_START_2_RESERVED_2_OFFSET                            0x00000008
#define RX_MPDU_START_2_RESERVED_2_LSB                               16
#define RX_MPDU_START_2_RESERVED_2_MASK                              0x0fff0000

/* Description		RX_MPDU_START_2_TID
			
			The TID field in the QoS control field
*/
#define RX_MPDU_START_2_TID_OFFSET                                   0x00000008
#define RX_MPDU_START_2_TID_LSB                                      28
#define RX_MPDU_START_2_TID_MASK                                     0xf0000000


#endif // _RX_MPDU_START_H_
