// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _QUEUE_NOT_EMPTY_H_
#define _QUEUE_NOT_EMPTY_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	mpdu_qid[13:0], reserved_0a[15:14], trigger_scheduler_ring_id[19:16], trigger_all[20], reserved_0b[31:21]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_QUEUE_NOT_EMPTY 1

struct queue_not_empty {
    volatile uint32_t mpdu_qid                        : 14, //[13:0]
                      reserved_0a                     :  2, //[15:14]
                      trigger_scheduler_ring_id       :  4, //[19:16]
                      trigger_all                     :  1, //[20]
                      reserved_0b                     : 11; //[31:21]
};

/*

mpdu_qid
			
			Queue ID of the queue that is not empty anymore. <legal
			all>

reserved_0a
			
			FW will set to 0, MAC will ignore.  <legal 0>

trigger_scheduler_ring_id
			
			The ID of the scheduler ring that, when operating in
			continuous mode, will be triggered if this frame changes the
			state of the queue from empty to not empty. The value in
			this field is passed on in the  QUEUE_NOT_EMPTY TLV to the
			scheduler  <legal all>

trigger_all
			
			When set, all scheduler queues need to be triggered, and
			should be activated if stalled.<legal all>

reserved_0b
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/


/* Description		QUEUE_NOT_EMPTY_0_MPDU_QID
			
			Queue ID of the queue that is not empty anymore. <legal
			all>
*/
#define QUEUE_NOT_EMPTY_0_MPDU_QID_OFFSET                            0x00000000
#define QUEUE_NOT_EMPTY_0_MPDU_QID_LSB                               0
#define QUEUE_NOT_EMPTY_0_MPDU_QID_MASK                              0x00003fff

/* Description		QUEUE_NOT_EMPTY_0_RESERVED_0A
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define QUEUE_NOT_EMPTY_0_RESERVED_0A_OFFSET                         0x00000000
#define QUEUE_NOT_EMPTY_0_RESERVED_0A_LSB                            14
#define QUEUE_NOT_EMPTY_0_RESERVED_0A_MASK                           0x0000c000

/* Description		QUEUE_NOT_EMPTY_0_TRIGGER_SCHEDULER_RING_ID
			
			The ID of the scheduler ring that, when operating in
			continuous mode, will be triggered if this frame changes the
			state of the queue from empty to not empty. The value in
			this field is passed on in the  QUEUE_NOT_EMPTY TLV to the
			scheduler  <legal all>
*/
#define QUEUE_NOT_EMPTY_0_TRIGGER_SCHEDULER_RING_ID_OFFSET           0x00000000
#define QUEUE_NOT_EMPTY_0_TRIGGER_SCHEDULER_RING_ID_LSB              16
#define QUEUE_NOT_EMPTY_0_TRIGGER_SCHEDULER_RING_ID_MASK             0x000f0000

/* Description		QUEUE_NOT_EMPTY_0_TRIGGER_ALL
			
			When set, all scheduler queues need to be triggered, and
			should be activated if stalled.<legal all>
*/
#define QUEUE_NOT_EMPTY_0_TRIGGER_ALL_OFFSET                         0x00000000
#define QUEUE_NOT_EMPTY_0_TRIGGER_ALL_LSB                            20
#define QUEUE_NOT_EMPTY_0_TRIGGER_ALL_MASK                           0x00100000

/* Description		QUEUE_NOT_EMPTY_0_RESERVED_0B
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define QUEUE_NOT_EMPTY_0_RESERVED_0B_OFFSET                         0x00000000
#define QUEUE_NOT_EMPTY_0_RESERVED_0B_LSB                            21
#define QUEUE_NOT_EMPTY_0_RESERVED_0B_MASK                           0xffe00000


#endif // _QUEUE_NOT_EMPTY_H_
