// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PDG_RESPONSE_H_
#define _PDG_RESPONSE_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	pkt_type[2:0], reserved_0a[3], nss[6:4], rate_mcs[10:7], reserved_0b[21:11], scrambler_seed_override[22], stbc[23], ldpc[24], sgi[25], bandwidth[27:26], response_type[31:28]
//	1	frame_length[15:0], rx_duration_field[31:16]
//	2	group_id[5:0], partial_aid[14:6], reserved_2[31:15]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PDG_RESPONSE 3

struct pdg_response {
    volatile uint32_t pkt_type                        :  3, //[2:0]
                      reserved_0a                     :  1, //[3]
                      nss                             :  3, //[6:4]
                      rate_mcs                        :  4, //[10:7]
                      reserved_0b                     : 11, //[21:11]
                      scrambler_seed_override         :  1, //[22]
                      stbc                            :  1, //[23]
                      ldpc                            :  1, //[24]
                      sgi                             :  1, //[25]
                      bandwidth                       :  2, //[27:26]
                      response_type                   :  4; //[31:28]
    volatile uint32_t frame_length                    : 16, //[15:0]
                      rx_duration_field               : 16; //[31:16]
    volatile uint32_t group_id                        :  6, //[5:0]
                      partial_aid                     :  9, //[14:6]
                      reserved_2                      : 17; //[31:15]
};

/*

pkt_type
			
			Packet type:
			
			<enum_typedef tx_phy_desc pkt_type>
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<enum 4     dot11n_gf>
			
			Note: HT Greenfield packet type is not supported
			
			<legal 0-4>

reserved_0a
			
			Valid for 802.11b packets only.
			
			<enum_typedef tx_phy_desc dot11b_preamble_type>
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>

nss
			
			Number of spatial streams.
			
			<enum 0     1_spatial_stream>
			
			<enum 1     2_spatial_streams>
			
			<enum 2     3_spatial_streams>
			
			<enum 3     4_spatial_streams>
			
			<legal 0-3>
			
			
			
			Note: Will typically be set to 0 for response frames

rate_mcs
			
			When pkt_type indicates dot11b or dot11a:
			
			This field is the rate:
			
			For Packet type == 0 (dot11a)
			
			0: OFDM 48 Mbps
			
			1: OFDM 24 Mbps
			
			2: OFDM 12 Mbps
			
			3: OFDM 6 Mbps
			
			4: OFDM 54 Mbps
			
			5: OFDM 36 Mbps
			
			6: OFDM 18 Mbps
			
			7: OFDM 9 Mbps
			
			For Packet type ==1 (dot11b => cck)
			
			0: CCK 11 Mbps Long
			
			1: CCK 5.5 Mbps Long
			
			2: CCK 2 Mbps Long
			
			3: CCK 1 Mbps Long
			
			4: CCK 11 Mbps Short
			
			5: CCK 5.5 Mbps Short
			
			6: CCK 2 Mbps Short
			
			
			
			When pkt_type indicates dot11n_mm or dot11ac:
			
			This field is the MCS.
			
			For Packet type == 2 (dot11n_mm)
			
			0: HT MCS 0 (BPSK 1/2)
			
			1: HT MCS 1 (QPSK 1/2)
			
			2: HT MCS 2 (QPSK 3/4)
			
			3: HT MCS 3 (16-QAM 1/2)
			
			4: HT MCS 4 (16-QAM 3/4)
			
			5: HT MCS 5 (64-QAM 2/3)
			
			6: HT MCS 6 (64-QAM 3/4)
			
			7: HT MCS 7 (64-QAM 5/6)
			
			Note: to get higher MCS's use the nss field to indicate
			the number of streams.
			
			For Packet type == 3 (dot11ac)
			
			0: VHT MCS 0 (BPSK 1/2)
			
			1: VHT MCS 1 (QPSK 1/2)
			
			2: VHT MCS 2 (QPSK 3/4)
			
			3: VHT MCS 3 (16-QAM 1/2)
			
			4: VHT MCS 4 (16-QAM 3/4)
			
			5: VHT MCS 5 (64-QAM 2/3)
			
			6: VHT MCS 6 (64-QAM 3/4)
			
			7: VHT MCS 7 (64-QAM 5/6)
			
			8: VHT MCS 8 (256-QAM 3/4)
			
			9: VHT MCS 9 (256-QAM 5/6)
			
			Note there are several illegal VHT rates due to
			fractional number of bits per symbol.  Below are the illegal
			rates for 4 streams and lower:
			
			20 MHz, 1 stream, MCS 9
			
			20 MHz, 2 stream, MCS 9
			
			20 MHz, 4 stream, MCS 9
			
			80 MHz, 3 stream, MCS 6
			
			160 MHz, 3 stream, MCS 9 (Unsupported)
			
			160 MHz, 4 stream, MCS 7 (Unsupported)
			
			Although the above rates are illegal according to the
			standard, the above rates are supported for LDPC encoding.
			
			<legal 0-9>

reserved_0b
			
			Set to 0 by the generator, ignored by consumer.  <legal
			0>

scrambler_seed_override
			
			If set PDG will override bits [6:5] of the 
			scrambler_seed  with BW information.  If clear PDG will use
			all 7 bits of the scrambler seed.

stbc
			
			When set, use STBC transmission rates

ldpc
			
			When set, use LDPC transmission rates

sgi
			
			Field only valid when pkt type is HT or VHT
			
			When set, use short Guard interval transmission.

bandwidth
			
			Packet bandwidth:
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>

response_type
			
			Response type
			
			<enum 0     OFDM_RESP> OFDM rate response
			
			<enum 1     CCK_RESP> CCK rate response
			
			<enum 2     CBF> CBF response as BFee
			
			<enum 3     RTT_HTVHT_RESP> HT or VHT rate response to
			RTT location packet
			
			<enum 4     RTT_LEGACY_RESP> Legacy rate response to RTT
			locationing packet (Note that CCK rate is not used for
			legacy rate response for RTT). 
			
			<legal 0-4>

frame_length
			
			The response frame length in bytes
			
			(This includes the FCS field)
			
			<legal all>

rx_duration_field
			
			The duration field in the received frame.
			
			PDG uses this field to calculate what the duration field
			value should be in the response frame.
			
			This is returned to the TX PCU

group_id
			
			Specifies the Group ID of response frames transmitted at
			VHT rates.

partial_aid
			
			Specifies the partial AID of response frames transmitted
			at VHT rates.

reserved_2
			
			Set to 0 by the generator, ignored by consumer.  <legal
			0>
*/


/* Description		PDG_RESPONSE_0_PKT_TYPE
			
			Packet type:
			
			<enum_typedef tx_phy_desc pkt_type>
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<enum 4     dot11n_gf>
			
			Note: HT Greenfield packet type is not supported
			
			<legal 0-4>
*/
#define PDG_RESPONSE_0_PKT_TYPE_OFFSET                               0x00000000
#define PDG_RESPONSE_0_PKT_TYPE_LSB                                  0
#define PDG_RESPONSE_0_PKT_TYPE_MASK                                 0x00000007

/* Description		PDG_RESPONSE_0_RESERVED_0A
			
			Valid for 802.11b packets only.
			
			<enum_typedef tx_phy_desc dot11b_preamble_type>
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>
*/
#define PDG_RESPONSE_0_RESERVED_0A_OFFSET                            0x00000000
#define PDG_RESPONSE_0_RESERVED_0A_LSB                               3
#define PDG_RESPONSE_0_RESERVED_0A_MASK                              0x00000008

/* Description		PDG_RESPONSE_0_NSS
			
			Number of spatial streams.
			
			<enum 0     1_spatial_stream>
			
			<enum 1     2_spatial_streams>
			
			<enum 2     3_spatial_streams>
			
			<enum 3     4_spatial_streams>
			
			<legal 0-3>
			
			
			
			Note: Will typically be set to 0 for response frames
*/
#define PDG_RESPONSE_0_NSS_OFFSET                                    0x00000000
#define PDG_RESPONSE_0_NSS_LSB                                       4
#define PDG_RESPONSE_0_NSS_MASK                                      0x00000070

/* Description		PDG_RESPONSE_0_RATE_MCS
			
			When pkt_type indicates dot11b or dot11a:
			
			This field is the rate:
			
			For Packet type == 0 (dot11a)
			
			0: OFDM 48 Mbps
			
			1: OFDM 24 Mbps
			
			2: OFDM 12 Mbps
			
			3: OFDM 6 Mbps
			
			4: OFDM 54 Mbps
			
			5: OFDM 36 Mbps
			
			6: OFDM 18 Mbps
			
			7: OFDM 9 Mbps
			
			For Packet type ==1 (dot11b => cck)
			
			0: CCK 11 Mbps Long
			
			1: CCK 5.5 Mbps Long
			
			2: CCK 2 Mbps Long
			
			3: CCK 1 Mbps Long
			
			4: CCK 11 Mbps Short
			
			5: CCK 5.5 Mbps Short
			
			6: CCK 2 Mbps Short
			
			
			
			When pkt_type indicates dot11n_mm or dot11ac:
			
			This field is the MCS.
			
			For Packet type == 2 (dot11n_mm)
			
			0: HT MCS 0 (BPSK 1/2)
			
			1: HT MCS 1 (QPSK 1/2)
			
			2: HT MCS 2 (QPSK 3/4)
			
			3: HT MCS 3 (16-QAM 1/2)
			
			4: HT MCS 4 (16-QAM 3/4)
			
			5: HT MCS 5 (64-QAM 2/3)
			
			6: HT MCS 6 (64-QAM 3/4)
			
			7: HT MCS 7 (64-QAM 5/6)
			
			Note: to get higher MCS's use the nss field to indicate
			the number of streams.
			
			For Packet type == 3 (dot11ac)
			
			0: VHT MCS 0 (BPSK 1/2)
			
			1: VHT MCS 1 (QPSK 1/2)
			
			2: VHT MCS 2 (QPSK 3/4)
			
			3: VHT MCS 3 (16-QAM 1/2)
			
			4: VHT MCS 4 (16-QAM 3/4)
			
			5: VHT MCS 5 (64-QAM 2/3)
			
			6: VHT MCS 6 (64-QAM 3/4)
			
			7: VHT MCS 7 (64-QAM 5/6)
			
			8: VHT MCS 8 (256-QAM 3/4)
			
			9: VHT MCS 9 (256-QAM 5/6)
			
			Note there are several illegal VHT rates due to
			fractional number of bits per symbol.  Below are the illegal
			rates for 4 streams and lower:
			
			20 MHz, 1 stream, MCS 9
			
			20 MHz, 2 stream, MCS 9
			
			20 MHz, 4 stream, MCS 9
			
			80 MHz, 3 stream, MCS 6
			
			160 MHz, 3 stream, MCS 9 (Unsupported)
			
			160 MHz, 4 stream, MCS 7 (Unsupported)
			
			Although the above rates are illegal according to the
			standard, the above rates are supported for LDPC encoding.
			
			<legal 0-9>
*/
#define PDG_RESPONSE_0_RATE_MCS_OFFSET                               0x00000000
#define PDG_RESPONSE_0_RATE_MCS_LSB                                  7
#define PDG_RESPONSE_0_RATE_MCS_MASK                                 0x00000780

/* Description		PDG_RESPONSE_0_RESERVED_0B
			
			Set to 0 by the generator, ignored by consumer.  <legal
			0>
*/
#define PDG_RESPONSE_0_RESERVED_0B_OFFSET                            0x00000000
#define PDG_RESPONSE_0_RESERVED_0B_LSB                               11
#define PDG_RESPONSE_0_RESERVED_0B_MASK                              0x003ff800

/* Description		PDG_RESPONSE_0_SCRAMBLER_SEED_OVERRIDE
			
			If set PDG will override bits [6:5] of the 
			scrambler_seed  with BW information.  If clear PDG will use
			all 7 bits of the scrambler seed.
*/
#define PDG_RESPONSE_0_SCRAMBLER_SEED_OVERRIDE_OFFSET                0x00000000
#define PDG_RESPONSE_0_SCRAMBLER_SEED_OVERRIDE_LSB                   22
#define PDG_RESPONSE_0_SCRAMBLER_SEED_OVERRIDE_MASK                  0x00400000

/* Description		PDG_RESPONSE_0_STBC
			
			When set, use STBC transmission rates
*/
#define PDG_RESPONSE_0_STBC_OFFSET                                   0x00000000
#define PDG_RESPONSE_0_STBC_LSB                                      23
#define PDG_RESPONSE_0_STBC_MASK                                     0x00800000

/* Description		PDG_RESPONSE_0_LDPC
			
			When set, use LDPC transmission rates
*/
#define PDG_RESPONSE_0_LDPC_OFFSET                                   0x00000000
#define PDG_RESPONSE_0_LDPC_LSB                                      24
#define PDG_RESPONSE_0_LDPC_MASK                                     0x01000000

/* Description		PDG_RESPONSE_0_SGI
			
			Field only valid when pkt type is HT or VHT
			
			When set, use short Guard interval transmission.
*/
#define PDG_RESPONSE_0_SGI_OFFSET                                    0x00000000
#define PDG_RESPONSE_0_SGI_LSB                                       25
#define PDG_RESPONSE_0_SGI_MASK                                      0x02000000

/* Description		PDG_RESPONSE_0_BANDWIDTH
			
			Packet bandwidth:
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>
*/
#define PDG_RESPONSE_0_BANDWIDTH_OFFSET                              0x00000000
#define PDG_RESPONSE_0_BANDWIDTH_LSB                                 26
#define PDG_RESPONSE_0_BANDWIDTH_MASK                                0x0c000000

/* Description		PDG_RESPONSE_0_RESPONSE_TYPE
			
			Response type
			
			<enum 0     OFDM_RESP> OFDM rate response
			
			<enum 1     CCK_RESP> CCK rate response
			
			<enum 2     CBF> CBF response as BFee
			
			<enum 3     RTT_HTVHT_RESP> HT or VHT rate response to
			RTT location packet
			
			<enum 4     RTT_LEGACY_RESP> Legacy rate response to RTT
			locationing packet (Note that CCK rate is not used for
			legacy rate response for RTT). 
			
			<legal 0-4>
*/
#define PDG_RESPONSE_0_RESPONSE_TYPE_OFFSET                          0x00000000
#define PDG_RESPONSE_0_RESPONSE_TYPE_LSB                             28
#define PDG_RESPONSE_0_RESPONSE_TYPE_MASK                            0xf0000000

/* Description		PDG_RESPONSE_1_FRAME_LENGTH
			
			The response frame length in bytes
			
			(This includes the FCS field)
			
			<legal all>
*/
#define PDG_RESPONSE_1_FRAME_LENGTH_OFFSET                           0x00000004
#define PDG_RESPONSE_1_FRAME_LENGTH_LSB                              0
#define PDG_RESPONSE_1_FRAME_LENGTH_MASK                             0x0000ffff

/* Description		PDG_RESPONSE_1_RX_DURATION_FIELD
			
			The duration field in the received frame.
			
			PDG uses this field to calculate what the duration field
			value should be in the response frame.
			
			This is returned to the TX PCU
*/
#define PDG_RESPONSE_1_RX_DURATION_FIELD_OFFSET                      0x00000004
#define PDG_RESPONSE_1_RX_DURATION_FIELD_LSB                         16
#define PDG_RESPONSE_1_RX_DURATION_FIELD_MASK                        0xffff0000

/* Description		PDG_RESPONSE_2_GROUP_ID
			
			Specifies the Group ID of response frames transmitted at
			VHT rates.
*/
#define PDG_RESPONSE_2_GROUP_ID_OFFSET                               0x00000008
#define PDG_RESPONSE_2_GROUP_ID_LSB                                  0
#define PDG_RESPONSE_2_GROUP_ID_MASK                                 0x0000003f

/* Description		PDG_RESPONSE_2_PARTIAL_AID
			
			Specifies the partial AID of response frames transmitted
			at VHT rates.
*/
#define PDG_RESPONSE_2_PARTIAL_AID_OFFSET                            0x00000008
#define PDG_RESPONSE_2_PARTIAL_AID_LSB                               6
#define PDG_RESPONSE_2_PARTIAL_AID_MASK                              0x00007fc0

/* Description		PDG_RESPONSE_2_RESERVED_2
			
			Set to 0 by the generator, ignored by consumer.  <legal
			0>
*/
#define PDG_RESPONSE_2_RESERVED_2_OFFSET                             0x00000008
#define PDG_RESPONSE_2_RESERVED_2_LSB                                15
#define PDG_RESPONSE_2_RESERVED_2_MASK                               0xffff8000


#endif // _PDG_RESPONSE_H_
