/*
 * Copyright (c) 2015 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

#ifndef _MAC_TXPCU_REG_H_
#define _MAC_TXPCU_REG_H_


#ifndef __MAC_TXPCU_REG_BASE_ADDRESS
#define __MAC_TXPCU_REG_BASE_ADDRESS (0x36000)
#endif


// 0x0 (TXPCU_TIMEOUT)
#define TXPCU_TIMEOUT_DATA_WAIT_TIME_LSB                                       24
#define TXPCU_TIMEOUT_DATA_WAIT_TIME_MSB                                       31
#define TXPCU_TIMEOUT_DATA_WAIT_TIME_MASK                                      0xff000000
#define TXPCU_TIMEOUT_DATA_WAIT_TIME_GET(x)                                    (((x) & TXPCU_TIMEOUT_DATA_WAIT_TIME_MASK) >> TXPCU_TIMEOUT_DATA_WAIT_TIME_LSB)
#define TXPCU_TIMEOUT_DATA_WAIT_TIME_SET(x)                                    (((0 | (x)) << TXPCU_TIMEOUT_DATA_WAIT_TIME_LSB) & TXPCU_TIMEOUT_DATA_WAIT_TIME_MASK)
#define TXPCU_TIMEOUT_DATA_WAIT_TIME_RESET                                     0xc
#define TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_LSB                                   16
#define TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_MSB                                   23
#define TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_MASK                                  0xff0000
#define TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_GET(x)                                (((x) & TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_MASK) >> TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_LSB)
#define TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_SET(x)                                (((0 | (x)) << TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_LSB) & TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_MASK)
#define TXPCU_TIMEOUT_PREAMBLE_WAIT_TIME_RESET                                 0x4
#define TXPCU_TIMEOUT_CTS_TIMEOUT_LSB                                          8
#define TXPCU_TIMEOUT_CTS_TIMEOUT_MSB                                          15
#define TXPCU_TIMEOUT_CTS_TIMEOUT_MASK                                         0xff00
#define TXPCU_TIMEOUT_CTS_TIMEOUT_GET(x)                                       (((x) & TXPCU_TIMEOUT_CTS_TIMEOUT_MASK) >> TXPCU_TIMEOUT_CTS_TIMEOUT_LSB)
#define TXPCU_TIMEOUT_CTS_TIMEOUT_SET(x)                                       (((0 | (x)) << TXPCU_TIMEOUT_CTS_TIMEOUT_LSB) & TXPCU_TIMEOUT_CTS_TIMEOUT_MASK)
#define TXPCU_TIMEOUT_CTS_TIMEOUT_RESET                                        0x30
#define TXPCU_TIMEOUT_ACK_TIMEOUT_LSB                                          0
#define TXPCU_TIMEOUT_ACK_TIMEOUT_MSB                                          7
#define TXPCU_TIMEOUT_ACK_TIMEOUT_MASK                                         0xff
#define TXPCU_TIMEOUT_ACK_TIMEOUT_GET(x)                                       (((x) & TXPCU_TIMEOUT_ACK_TIMEOUT_MASK) >> TXPCU_TIMEOUT_ACK_TIMEOUT_LSB)
#define TXPCU_TIMEOUT_ACK_TIMEOUT_SET(x)                                       (((0 | (x)) << TXPCU_TIMEOUT_ACK_TIMEOUT_LSB) & TXPCU_TIMEOUT_ACK_TIMEOUT_MASK)
#define TXPCU_TIMEOUT_ACK_TIMEOUT_RESET                                        0x40
#define TXPCU_TIMEOUT_ADDRESS                                                  (0x0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TIMEOUT_RSTMASK                                                  0xffffffff
#define TXPCU_TIMEOUT_RESET                                                    0xc043040

// 0x4 (TXPCU_CV_LENGTH_TIMEOUT)
#define TXPCU_CV_LENGTH_TIMEOUT_VALUE_LSB                                      0
#define TXPCU_CV_LENGTH_TIMEOUT_VALUE_MSB                                      7
#define TXPCU_CV_LENGTH_TIMEOUT_VALUE_MASK                                     0xff
#define TXPCU_CV_LENGTH_TIMEOUT_VALUE_GET(x)                                   (((x) & TXPCU_CV_LENGTH_TIMEOUT_VALUE_MASK) >> TXPCU_CV_LENGTH_TIMEOUT_VALUE_LSB)
#define TXPCU_CV_LENGTH_TIMEOUT_VALUE_SET(x)                                   (((0 | (x)) << TXPCU_CV_LENGTH_TIMEOUT_VALUE_LSB) & TXPCU_CV_LENGTH_TIMEOUT_VALUE_MASK)
#define TXPCU_CV_LENGTH_TIMEOUT_VALUE_RESET                                    0x4
#define TXPCU_CV_LENGTH_TIMEOUT_ADDRESS                                        (0x4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_CV_LENGTH_TIMEOUT_RSTMASK                                        0xff
#define TXPCU_CV_LENGTH_TIMEOUT_RESET                                          0x4

// 0x8 (TXPCU_WATCHDOG)
#define TXPCU_WATCHDOG_STATUS_LSB                                              16
#define TXPCU_WATCHDOG_STATUS_MSB                                              31
#define TXPCU_WATCHDOG_STATUS_MASK                                             0xffff0000
#define TXPCU_WATCHDOG_STATUS_GET(x)                                           (((x) & TXPCU_WATCHDOG_STATUS_MASK) >> TXPCU_WATCHDOG_STATUS_LSB)
#define TXPCU_WATCHDOG_STATUS_SET(x)                                           (((0 | (x)) << TXPCU_WATCHDOG_STATUS_LSB) & TXPCU_WATCHDOG_STATUS_MASK)
#define TXPCU_WATCHDOG_STATUS_RESET                                            0x0
#define TXPCU_WATCHDOG_LIMIT_LSB                                               0
#define TXPCU_WATCHDOG_LIMIT_MSB                                               15
#define TXPCU_WATCHDOG_LIMIT_MASK                                              0xffff
#define TXPCU_WATCHDOG_LIMIT_GET(x)                                            (((x) & TXPCU_WATCHDOG_LIMIT_MASK) >> TXPCU_WATCHDOG_LIMIT_LSB)
#define TXPCU_WATCHDOG_LIMIT_SET(x)                                            (((0 | (x)) << TXPCU_WATCHDOG_LIMIT_LSB) & TXPCU_WATCHDOG_LIMIT_MASK)
#define TXPCU_WATCHDOG_LIMIT_RESET                                             0x2710
#define TXPCU_WATCHDOG_ADDRESS                                                 (0x8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_WATCHDOG_RSTMASK                                                 0xffffffff
#define TXPCU_WATCHDOG_RESET                                                   0x2710

// 0xc (TXPCU_INITIAL_CREDIT)
#define TXPCU_INITIAL_CREDIT_VALUE_USER2_LSB                                   16
#define TXPCU_INITIAL_CREDIT_VALUE_USER2_MSB                                   23
#define TXPCU_INITIAL_CREDIT_VALUE_USER2_MASK                                  0xff0000
#define TXPCU_INITIAL_CREDIT_VALUE_USER2_GET(x)                                (((x) & TXPCU_INITIAL_CREDIT_VALUE_USER2_MASK) >> TXPCU_INITIAL_CREDIT_VALUE_USER2_LSB)
#define TXPCU_INITIAL_CREDIT_VALUE_USER2_SET(x)                                (((0 | (x)) << TXPCU_INITIAL_CREDIT_VALUE_USER2_LSB) & TXPCU_INITIAL_CREDIT_VALUE_USER2_MASK)
#define TXPCU_INITIAL_CREDIT_VALUE_USER2_RESET                                 0x8
#define TXPCU_INITIAL_CREDIT_VALUE_USER1_LSB                                   8
#define TXPCU_INITIAL_CREDIT_VALUE_USER1_MSB                                   15
#define TXPCU_INITIAL_CREDIT_VALUE_USER1_MASK                                  0xff00
#define TXPCU_INITIAL_CREDIT_VALUE_USER1_GET(x)                                (((x) & TXPCU_INITIAL_CREDIT_VALUE_USER1_MASK) >> TXPCU_INITIAL_CREDIT_VALUE_USER1_LSB)
#define TXPCU_INITIAL_CREDIT_VALUE_USER1_SET(x)                                (((0 | (x)) << TXPCU_INITIAL_CREDIT_VALUE_USER1_LSB) & TXPCU_INITIAL_CREDIT_VALUE_USER1_MASK)
#define TXPCU_INITIAL_CREDIT_VALUE_USER1_RESET                                 0x8
#define TXPCU_INITIAL_CREDIT_VALUE_USER0_LSB                                   0
#define TXPCU_INITIAL_CREDIT_VALUE_USER0_MSB                                   7
#define TXPCU_INITIAL_CREDIT_VALUE_USER0_MASK                                  0xff
#define TXPCU_INITIAL_CREDIT_VALUE_USER0_GET(x)                                (((x) & TXPCU_INITIAL_CREDIT_VALUE_USER0_MASK) >> TXPCU_INITIAL_CREDIT_VALUE_USER0_LSB)
#define TXPCU_INITIAL_CREDIT_VALUE_USER0_SET(x)                                (((0 | (x)) << TXPCU_INITIAL_CREDIT_VALUE_USER0_LSB) & TXPCU_INITIAL_CREDIT_VALUE_USER0_MASK)
#define TXPCU_INITIAL_CREDIT_VALUE_USER0_RESET                                 0x8
#define TXPCU_INITIAL_CREDIT_ADDRESS                                           (0xc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_INITIAL_CREDIT_RSTMASK                                           0xffffff
#define TXPCU_INITIAL_CREDIT_RESET                                             0x80808

// 0x10 (TXPCU_BASIC_RATE_SET0)
#define TXPCU_BASIC_RATE_SET0_VALUE_LSB                                        0
#define TXPCU_BASIC_RATE_SET0_VALUE_MSB                                        29
#define TXPCU_BASIC_RATE_SET0_VALUE_MASK                                       0x3fffffff
#define TXPCU_BASIC_RATE_SET0_VALUE_GET(x)                                     (((x) & TXPCU_BASIC_RATE_SET0_VALUE_MASK) >> TXPCU_BASIC_RATE_SET0_VALUE_LSB)
#define TXPCU_BASIC_RATE_SET0_VALUE_SET(x)                                     (((0 | (x)) << TXPCU_BASIC_RATE_SET0_VALUE_LSB) & TXPCU_BASIC_RATE_SET0_VALUE_MASK)
#define TXPCU_BASIC_RATE_SET0_VALUE_RESET                                      0x31dcfb5b
#define TXPCU_BASIC_RATE_SET0_ADDRESS                                          (0x10 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_BASIC_RATE_SET0_RSTMASK                                          0x3fffffff
#define TXPCU_BASIC_RATE_SET0_RESET                                            0x31dcfb5b

// 0x14 (TXPCU_BASIC_RATE_SET1)
#define TXPCU_BASIC_RATE_SET1_VALUE_LSB                                        0
#define TXPCU_BASIC_RATE_SET1_VALUE_MSB                                        29
#define TXPCU_BASIC_RATE_SET1_VALUE_MASK                                       0x3fffffff
#define TXPCU_BASIC_RATE_SET1_VALUE_GET(x)                                     (((x) & TXPCU_BASIC_RATE_SET1_VALUE_MASK) >> TXPCU_BASIC_RATE_SET1_VALUE_LSB)
#define TXPCU_BASIC_RATE_SET1_VALUE_SET(x)                                     (((0 | (x)) << TXPCU_BASIC_RATE_SET1_VALUE_LSB) & TXPCU_BASIC_RATE_SET1_VALUE_MASK)
#define TXPCU_BASIC_RATE_SET1_VALUE_RESET                                      0x12a52d7c
#define TXPCU_BASIC_RATE_SET1_ADDRESS                                          (0x14 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_BASIC_RATE_SET1_RSTMASK                                          0x3fffffff
#define TXPCU_BASIC_RATE_SET1_RESET                                            0x12a52d7c

// 0x18 (TXPCU_BASIC_RATE_SET2)
#define TXPCU_BASIC_RATE_SET2_VALUE_LSB                                        0
#define TXPCU_BASIC_RATE_SET2_VALUE_MSB                                        29
#define TXPCU_BASIC_RATE_SET2_VALUE_MASK                                       0x3fffffff
#define TXPCU_BASIC_RATE_SET2_VALUE_GET(x)                                     (((x) & TXPCU_BASIC_RATE_SET2_VALUE_MASK) >> TXPCU_BASIC_RATE_SET2_VALUE_LSB)
#define TXPCU_BASIC_RATE_SET2_VALUE_SET(x)                                     (((0 | (x)) << TXPCU_BASIC_RATE_SET2_VALUE_LSB) & TXPCU_BASIC_RATE_SET2_VALUE_MASK)
#define TXPCU_BASIC_RATE_SET2_VALUE_RESET                                      0x14a5a529
#define TXPCU_BASIC_RATE_SET2_ADDRESS                                          (0x18 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_BASIC_RATE_SET2_RSTMASK                                          0x3fffffff
#define TXPCU_BASIC_RATE_SET2_RESET                                            0x14a5a529

// 0x1c (TXPCU_BASIC_RATE_SET3)
#define TXPCU_BASIC_RATE_SET3_VALUE_LSB                                        0
#define TXPCU_BASIC_RATE_SET3_VALUE_MSB                                        24
#define TXPCU_BASIC_RATE_SET3_VALUE_MASK                                       0x1ffffff
#define TXPCU_BASIC_RATE_SET3_VALUE_GET(x)                                     (((x) & TXPCU_BASIC_RATE_SET3_VALUE_MASK) >> TXPCU_BASIC_RATE_SET3_VALUE_LSB)
#define TXPCU_BASIC_RATE_SET3_VALUE_SET(x)                                     (((0 | (x)) << TXPCU_BASIC_RATE_SET3_VALUE_LSB) & TXPCU_BASIC_RATE_SET3_VALUE_MASK)
#define TXPCU_BASIC_RATE_SET3_VALUE_RESET                                      0x94a529
#define TXPCU_BASIC_RATE_SET3_ADDRESS                                          (0x1c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_BASIC_RATE_SET3_RSTMASK                                          0x1ffffff
#define TXPCU_BASIC_RATE_SET3_RESET                                            0x94a529

// 0x20 (TXPCU_BASIC_RATE_SET4)
#define TXPCU_BASIC_RATE_SET4_VALUE_LSB                                        0
#define TXPCU_BASIC_RATE_SET4_VALUE_MSB                                        9
#define TXPCU_BASIC_RATE_SET4_VALUE_MASK                                       0x3ff
#define TXPCU_BASIC_RATE_SET4_VALUE_GET(x)                                     (((x) & TXPCU_BASIC_RATE_SET4_VALUE_MASK) >> TXPCU_BASIC_RATE_SET4_VALUE_LSB)
#define TXPCU_BASIC_RATE_SET4_VALUE_SET(x)                                     (((0 | (x)) << TXPCU_BASIC_RATE_SET4_VALUE_LSB) & TXPCU_BASIC_RATE_SET4_VALUE_MASK)
#define TXPCU_BASIC_RATE_SET4_VALUE_RESET                                      0x129
#define TXPCU_BASIC_RATE_SET4_ADDRESS                                          (0x20 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_BASIC_RATE_SET4_RSTMASK                                          0x3ff
#define TXPCU_BASIC_RATE_SET4_RESET                                            0x129

// 0x24 (TXPCU_BASIC_SET)
#define TXPCU_BASIC_SET_MCS_LSB                                                0
#define TXPCU_BASIC_SET_MCS_MSB                                                31
#define TXPCU_BASIC_SET_MCS_MASK                                               0xffffffff
#define TXPCU_BASIC_SET_MCS_GET(x)                                             (((x) & TXPCU_BASIC_SET_MCS_MASK) >> TXPCU_BASIC_SET_MCS_LSB)
#define TXPCU_BASIC_SET_MCS_SET(x)                                             (((0 | (x)) << TXPCU_BASIC_SET_MCS_LSB) & TXPCU_BASIC_SET_MCS_MASK)
#define TXPCU_BASIC_SET_MCS_RESET                                              0x0
#define TXPCU_BASIC_SET_ADDRESS                                                (0x24 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_BASIC_SET_RSTMASK                                                0xffffffff
#define TXPCU_BASIC_SET_RESET                                                  0x0

// 0x30 (TXPCU_SIFS_TIMEOUT)
#define TXPCU_SIFS_TIMEOUT_VALUE_LSB                                           0
#define TXPCU_SIFS_TIMEOUT_VALUE_MSB                                           7
#define TXPCU_SIFS_TIMEOUT_VALUE_MASK                                          0xff
#define TXPCU_SIFS_TIMEOUT_VALUE_GET(x)                                        (((x) & TXPCU_SIFS_TIMEOUT_VALUE_MASK) >> TXPCU_SIFS_TIMEOUT_VALUE_LSB)
#define TXPCU_SIFS_TIMEOUT_VALUE_SET(x)                                        (((0 | (x)) << TXPCU_SIFS_TIMEOUT_VALUE_LSB) & TXPCU_SIFS_TIMEOUT_VALUE_MASK)
#define TXPCU_SIFS_TIMEOUT_VALUE_RESET                                         0x10
#define TXPCU_SIFS_TIMEOUT_ADDRESS                                             (0x30 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_SIFS_TIMEOUT_RSTMASK                                             0xff
#define TXPCU_SIFS_TIMEOUT_RESET                                               0x10

// 0x34 (TXPCU_PHY_TX_LATENCY)
#define TXPCU_PHY_TX_LATENCY_VALUE_LSB                                         0
#define TXPCU_PHY_TX_LATENCY_VALUE_MSB                                         7
#define TXPCU_PHY_TX_LATENCY_VALUE_MASK                                        0xff
#define TXPCU_PHY_TX_LATENCY_VALUE_GET(x)                                      (((x) & TXPCU_PHY_TX_LATENCY_VALUE_MASK) >> TXPCU_PHY_TX_LATENCY_VALUE_LSB)
#define TXPCU_PHY_TX_LATENCY_VALUE_SET(x)                                      (((0 | (x)) << TXPCU_PHY_TX_LATENCY_VALUE_LSB) & TXPCU_PHY_TX_LATENCY_VALUE_MASK)
#define TXPCU_PHY_TX_LATENCY_VALUE_RESET                                       0x0
#define TXPCU_PHY_TX_LATENCY_ADDRESS                                           (0x34 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_PHY_TX_LATENCY_RSTMASK                                           0xff
#define TXPCU_PHY_TX_LATENCY_RESET                                             0x0

// 0x3c (TXPCU_TX_ANT_CTL)
#define TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_LSB                               31
#define TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_MSB                               31
#define TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_MASK                              0x80000000
#define TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_GET(x)                            (((x) & TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_MASK) >> TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_LSB)
#define TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_SET(x)                            (((0 | (x)) << TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_LSB) & TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_MASK)
#define TXPCU_TX_ANT_CTL_RUCKUS_ANT_MODE_SEL_RESET                             0x1
#define TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_LSB                                     0
#define TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_MSB                                     23
#define TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_MASK                                    0xffffff
#define TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_GET(x)                                  (((x) & TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_MASK) >> TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_LSB)
#define TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_SET(x)                                  (((0 | (x)) << TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_LSB) & TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_MASK)
#define TXPCU_TX_ANT_CTL_DEF_ANT_VALUE_RESET                                   0x0
#define TXPCU_TX_ANT_CTL_ADDRESS                                               (0x3c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TX_ANT_CTL_RSTMASK                                               0x80ffffff
#define TXPCU_TX_ANT_CTL_RESET                                                 0x80000000

// 0x44 (TXPCU_MGMT_SEQ)
#define TXPCU_MGMT_SEQ_MAX_LSB                                                 16
#define TXPCU_MGMT_SEQ_MAX_MSB                                                 27
#define TXPCU_MGMT_SEQ_MAX_MASK                                                0xfff0000
#define TXPCU_MGMT_SEQ_MAX_GET(x)                                              (((x) & TXPCU_MGMT_SEQ_MAX_MASK) >> TXPCU_MGMT_SEQ_MAX_LSB)
#define TXPCU_MGMT_SEQ_MAX_SET(x)                                              (((0 | (x)) << TXPCU_MGMT_SEQ_MAX_LSB) & TXPCU_MGMT_SEQ_MAX_MASK)
#define TXPCU_MGMT_SEQ_MAX_RESET                                               0x2ff
#define TXPCU_MGMT_SEQ_MIN_LSB                                                 0
#define TXPCU_MGMT_SEQ_MIN_MSB                                                 11
#define TXPCU_MGMT_SEQ_MIN_MASK                                                0xfff
#define TXPCU_MGMT_SEQ_MIN_GET(x)                                              (((x) & TXPCU_MGMT_SEQ_MIN_MASK) >> TXPCU_MGMT_SEQ_MIN_LSB)
#define TXPCU_MGMT_SEQ_MIN_SET(x)                                              (((0 | (x)) << TXPCU_MGMT_SEQ_MIN_LSB) & TXPCU_MGMT_SEQ_MIN_MASK)
#define TXPCU_MGMT_SEQ_MIN_RESET                                               0x0
#define TXPCU_MGMT_SEQ_ADDRESS                                                 (0x44 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_MGMT_SEQ_RSTMASK                                                 0xfff0fff
#define TXPCU_MGMT_SEQ_RESET                                                   0x2ff0000

// 0x48 (TXPCU_MISC_MODE)
#define TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_LSB                          6
#define TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_MSB                          6
#define TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_MASK                         0x40
#define TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_GET(x)                       (((x) & TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_MASK) >> TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_LSB)
#define TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_SET(x)                       (((0 | (x)) << TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_LSB) & TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_MASK)
#define TXPCU_MISC_MODE_ENABLE_SEQNUM_BITMAP_SWAP_RESET                        0x0
#define TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_LSB                              5
#define TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_MSB                              5
#define TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_MASK                             0x20
#define TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_GET(x)                           (((x) & TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_MASK) >> TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_LSB)
#define TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_SET(x)                           (((0 | (x)) << TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_LSB) & TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_MASK)
#define TXPCU_MISC_MODE_ENABLE_BA_BITMAP_SWAP_RESET                            0x0
#define TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_LSB                          1
#define TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_MSB                          1
#define TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_MASK                         0x2
#define TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_GET(x)                       (((x) & TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_MASK) >> TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_LSB)
#define TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_SET(x)                       (((0 | (x)) << TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_LSB) & TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_MASK)
#define TXPCU_MISC_MODE_IGNORE_FLUSH_FOR_CV_VALID_RESET                        0x1
#define TXPCU_MISC_MODE_ALLOW_RAC_LSB                                          0
#define TXPCU_MISC_MODE_ALLOW_RAC_MSB                                          0
#define TXPCU_MISC_MODE_ALLOW_RAC_MASK                                         0x1
#define TXPCU_MISC_MODE_ALLOW_RAC_GET(x)                                       (((x) & TXPCU_MISC_MODE_ALLOW_RAC_MASK) >> TXPCU_MISC_MODE_ALLOW_RAC_LSB)
#define TXPCU_MISC_MODE_ALLOW_RAC_SET(x)                                       (((0 | (x)) << TXPCU_MISC_MODE_ALLOW_RAC_LSB) & TXPCU_MISC_MODE_ALLOW_RAC_MASK)
#define TXPCU_MISC_MODE_ALLOW_RAC_RESET                                        0x0
#define TXPCU_MISC_MODE_ADDRESS                                                (0x48 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_MISC_MODE_RSTMASK                                                0x63
#define TXPCU_MISC_MODE_RESET                                                  0x2

// 0x4c (TXPCU_RTT_CTRL)
#define TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_LSB                                 0
#define TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MSB                                 0
#define TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MASK                                0x1
#define TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_GET(x)                              (((x) & TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MASK) >> TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_LSB)
#define TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_SET(x)                              (((0 | (x)) << TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_LSB) & TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MASK)
#define TXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_RESET                               0x0
#define TXPCU_RTT_CTRL_ADDRESS                                                 (0x4c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_RTT_CTRL_RSTMASK                                                 0x1
#define TXPCU_RTT_CTRL_RESET                                                   0x0

// 0x50 (TXPCU_TXBUF_DRAIN_THRESHOLD)
#define TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_LSB                                  0
#define TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_MSB                                  15
#define TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_MASK                                 0xffff
#define TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_GET(x)                               (((x) & TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_MASK) >> TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_LSB)
#define TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_SET(x)                               (((0 | (x)) << TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_LSB) & TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_MASK)
#define TXPCU_TXBUF_DRAIN_THRESHOLD_VALUE_RESET                                0x0
#define TXPCU_TXBUF_DRAIN_THRESHOLD_ADDRESS                                    (0x50 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_DRAIN_THRESHOLD_RSTMASK                                    0xffff
#define TXPCU_TXBUF_DRAIN_THRESHOLD_RESET                                      0x0

// 0x54 (TXPCU_CBF_RESP_CTL_20)
#define TXPCU_CBF_RESP_CTL_20_VALID_LSB                                        31
#define TXPCU_CBF_RESP_CTL_20_VALID_MSB                                        31
#define TXPCU_CBF_RESP_CTL_20_VALID_MASK                                       0x80000000
#define TXPCU_CBF_RESP_CTL_20_VALID_GET(x)                                     (((x) & TXPCU_CBF_RESP_CTL_20_VALID_MASK) >> TXPCU_CBF_RESP_CTL_20_VALID_LSB)
#define TXPCU_CBF_RESP_CTL_20_VALID_SET(x)                                     (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_VALID_LSB) & TXPCU_CBF_RESP_CTL_20_VALID_MASK)
#define TXPCU_CBF_RESP_CTL_20_VALID_RESET                                      0x0
#define TXPCU_CBF_RESP_CTL_20_PKT_TYPE_LSB                                     21
#define TXPCU_CBF_RESP_CTL_20_PKT_TYPE_MSB                                     22
#define TXPCU_CBF_RESP_CTL_20_PKT_TYPE_MASK                                    0x600000
#define TXPCU_CBF_RESP_CTL_20_PKT_TYPE_GET(x)                                  (((x) & TXPCU_CBF_RESP_CTL_20_PKT_TYPE_MASK) >> TXPCU_CBF_RESP_CTL_20_PKT_TYPE_LSB)
#define TXPCU_CBF_RESP_CTL_20_PKT_TYPE_SET(x)                                  (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_PKT_TYPE_LSB) & TXPCU_CBF_RESP_CTL_20_PKT_TYPE_MASK)
#define TXPCU_CBF_RESP_CTL_20_PKT_TYPE_RESET                                   0x0
#define TXPCU_CBF_RESP_CTL_20_SGI_LSB                                          20
#define TXPCU_CBF_RESP_CTL_20_SGI_MSB                                          20
#define TXPCU_CBF_RESP_CTL_20_SGI_MASK                                         0x100000
#define TXPCU_CBF_RESP_CTL_20_SGI_GET(x)                                       (((x) & TXPCU_CBF_RESP_CTL_20_SGI_MASK) >> TXPCU_CBF_RESP_CTL_20_SGI_LSB)
#define TXPCU_CBF_RESP_CTL_20_SGI_SET(x)                                       (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_SGI_LSB) & TXPCU_CBF_RESP_CTL_20_SGI_MASK)
#define TXPCU_CBF_RESP_CTL_20_SGI_RESET                                        0x0
#define TXPCU_CBF_RESP_CTL_20_LDPC_LSB                                         19
#define TXPCU_CBF_RESP_CTL_20_LDPC_MSB                                         19
#define TXPCU_CBF_RESP_CTL_20_LDPC_MASK                                        0x80000
#define TXPCU_CBF_RESP_CTL_20_LDPC_GET(x)                                      (((x) & TXPCU_CBF_RESP_CTL_20_LDPC_MASK) >> TXPCU_CBF_RESP_CTL_20_LDPC_LSB)
#define TXPCU_CBF_RESP_CTL_20_LDPC_SET(x)                                      (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_LDPC_LSB) & TXPCU_CBF_RESP_CTL_20_LDPC_MASK)
#define TXPCU_CBF_RESP_CTL_20_LDPC_RESET                                       0x0
#define TXPCU_CBF_RESP_CTL_20_STBC_LSB                                         18
#define TXPCU_CBF_RESP_CTL_20_STBC_MSB                                         18
#define TXPCU_CBF_RESP_CTL_20_STBC_MASK                                        0x40000
#define TXPCU_CBF_RESP_CTL_20_STBC_GET(x)                                      (((x) & TXPCU_CBF_RESP_CTL_20_STBC_MASK) >> TXPCU_CBF_RESP_CTL_20_STBC_LSB)
#define TXPCU_CBF_RESP_CTL_20_STBC_SET(x)                                      (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_STBC_LSB) & TXPCU_CBF_RESP_CTL_20_STBC_MASK)
#define TXPCU_CBF_RESP_CTL_20_STBC_RESET                                       0x0
#define TXPCU_CBF_RESP_CTL_20_TX_PWR_LSB                                       11
#define TXPCU_CBF_RESP_CTL_20_TX_PWR_MSB                                       17
#define TXPCU_CBF_RESP_CTL_20_TX_PWR_MASK                                      0x3f800
#define TXPCU_CBF_RESP_CTL_20_TX_PWR_GET(x)                                    (((x) & TXPCU_CBF_RESP_CTL_20_TX_PWR_MASK) >> TXPCU_CBF_RESP_CTL_20_TX_PWR_LSB)
#define TXPCU_CBF_RESP_CTL_20_TX_PWR_SET(x)                                    (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_TX_PWR_LSB) & TXPCU_CBF_RESP_CTL_20_TX_PWR_MASK)
#define TXPCU_CBF_RESP_CTL_20_TX_PWR_RESET                                     0x0
#define TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_LSB                                   10
#define TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_MSB                                   10
#define TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_MASK                                  0x400
#define TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_GET(x)                                (((x) & TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_MASK) >> TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_LSB)
#define TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_SET(x)                                (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_LSB) & TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_MASK)
#define TXPCU_CBF_RESP_CTL_20_DPD_ENABLE_RESET                                 0x0
#define TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_LSB                             7
#define TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_MSB                             9
#define TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_MASK                            0x380
#define TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_GET(x)                          (((x) & TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_MASK) >> TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_LSB)
#define TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_SET(x)                          (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_LSB) & TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_MASK)
#define TXPCU_CBF_RESP_CTL_20_TPC_INIT_PWR_CFG_RESET                           0x0
#define TXPCU_CBF_RESP_CTL_20_NSS_LSB                                          4
#define TXPCU_CBF_RESP_CTL_20_NSS_MSB                                          6
#define TXPCU_CBF_RESP_CTL_20_NSS_MASK                                         0x70
#define TXPCU_CBF_RESP_CTL_20_NSS_GET(x)                                       (((x) & TXPCU_CBF_RESP_CTL_20_NSS_MASK) >> TXPCU_CBF_RESP_CTL_20_NSS_LSB)
#define TXPCU_CBF_RESP_CTL_20_NSS_SET(x)                                       (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_NSS_LSB) & TXPCU_CBF_RESP_CTL_20_NSS_MASK)
#define TXPCU_CBF_RESP_CTL_20_NSS_RESET                                        0x0
#define TXPCU_CBF_RESP_CTL_20_RATE_MCS_LSB                                     0
#define TXPCU_CBF_RESP_CTL_20_RATE_MCS_MSB                                     3
#define TXPCU_CBF_RESP_CTL_20_RATE_MCS_MASK                                    0xf
#define TXPCU_CBF_RESP_CTL_20_RATE_MCS_GET(x)                                  (((x) & TXPCU_CBF_RESP_CTL_20_RATE_MCS_MASK) >> TXPCU_CBF_RESP_CTL_20_RATE_MCS_LSB)
#define TXPCU_CBF_RESP_CTL_20_RATE_MCS_SET(x)                                  (((0 | (x)) << TXPCU_CBF_RESP_CTL_20_RATE_MCS_LSB) & TXPCU_CBF_RESP_CTL_20_RATE_MCS_MASK)
#define TXPCU_CBF_RESP_CTL_20_RATE_MCS_RESET                                   0x0
#define TXPCU_CBF_RESP_CTL_20_ADDRESS                                          (0x54 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_CBF_RESP_CTL_20_RSTMASK                                          0x807fffff
#define TXPCU_CBF_RESP_CTL_20_RESET                                            0x0

// 0x58 (TXPCU_CBF_RESP_CTL_40)
#define TXPCU_CBF_RESP_CTL_40_VALID_LSB                                        31
#define TXPCU_CBF_RESP_CTL_40_VALID_MSB                                        31
#define TXPCU_CBF_RESP_CTL_40_VALID_MASK                                       0x80000000
#define TXPCU_CBF_RESP_CTL_40_VALID_GET(x)                                     (((x) & TXPCU_CBF_RESP_CTL_40_VALID_MASK) >> TXPCU_CBF_RESP_CTL_40_VALID_LSB)
#define TXPCU_CBF_RESP_CTL_40_VALID_SET(x)                                     (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_VALID_LSB) & TXPCU_CBF_RESP_CTL_40_VALID_MASK)
#define TXPCU_CBF_RESP_CTL_40_VALID_RESET                                      0x0
#define TXPCU_CBF_RESP_CTL_40_PKT_TYPE_LSB                                     21
#define TXPCU_CBF_RESP_CTL_40_PKT_TYPE_MSB                                     22
#define TXPCU_CBF_RESP_CTL_40_PKT_TYPE_MASK                                    0x600000
#define TXPCU_CBF_RESP_CTL_40_PKT_TYPE_GET(x)                                  (((x) & TXPCU_CBF_RESP_CTL_40_PKT_TYPE_MASK) >> TXPCU_CBF_RESP_CTL_40_PKT_TYPE_LSB)
#define TXPCU_CBF_RESP_CTL_40_PKT_TYPE_SET(x)                                  (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_PKT_TYPE_LSB) & TXPCU_CBF_RESP_CTL_40_PKT_TYPE_MASK)
#define TXPCU_CBF_RESP_CTL_40_PKT_TYPE_RESET                                   0x2
#define TXPCU_CBF_RESP_CTL_40_SGI_LSB                                          20
#define TXPCU_CBF_RESP_CTL_40_SGI_MSB                                          20
#define TXPCU_CBF_RESP_CTL_40_SGI_MASK                                         0x100000
#define TXPCU_CBF_RESP_CTL_40_SGI_GET(x)                                       (((x) & TXPCU_CBF_RESP_CTL_40_SGI_MASK) >> TXPCU_CBF_RESP_CTL_40_SGI_LSB)
#define TXPCU_CBF_RESP_CTL_40_SGI_SET(x)                                       (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_SGI_LSB) & TXPCU_CBF_RESP_CTL_40_SGI_MASK)
#define TXPCU_CBF_RESP_CTL_40_SGI_RESET                                        0x0
#define TXPCU_CBF_RESP_CTL_40_LDPC_LSB                                         19
#define TXPCU_CBF_RESP_CTL_40_LDPC_MSB                                         19
#define TXPCU_CBF_RESP_CTL_40_LDPC_MASK                                        0x80000
#define TXPCU_CBF_RESP_CTL_40_LDPC_GET(x)                                      (((x) & TXPCU_CBF_RESP_CTL_40_LDPC_MASK) >> TXPCU_CBF_RESP_CTL_40_LDPC_LSB)
#define TXPCU_CBF_RESP_CTL_40_LDPC_SET(x)                                      (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_LDPC_LSB) & TXPCU_CBF_RESP_CTL_40_LDPC_MASK)
#define TXPCU_CBF_RESP_CTL_40_LDPC_RESET                                       0x0
#define TXPCU_CBF_RESP_CTL_40_STBC_LSB                                         18
#define TXPCU_CBF_RESP_CTL_40_STBC_MSB                                         18
#define TXPCU_CBF_RESP_CTL_40_STBC_MASK                                        0x40000
#define TXPCU_CBF_RESP_CTL_40_STBC_GET(x)                                      (((x) & TXPCU_CBF_RESP_CTL_40_STBC_MASK) >> TXPCU_CBF_RESP_CTL_40_STBC_LSB)
#define TXPCU_CBF_RESP_CTL_40_STBC_SET(x)                                      (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_STBC_LSB) & TXPCU_CBF_RESP_CTL_40_STBC_MASK)
#define TXPCU_CBF_RESP_CTL_40_STBC_RESET                                       0x0
#define TXPCU_CBF_RESP_CTL_40_TX_PWR_LSB                                       11
#define TXPCU_CBF_RESP_CTL_40_TX_PWR_MSB                                       17
#define TXPCU_CBF_RESP_CTL_40_TX_PWR_MASK                                      0x3f800
#define TXPCU_CBF_RESP_CTL_40_TX_PWR_GET(x)                                    (((x) & TXPCU_CBF_RESP_CTL_40_TX_PWR_MASK) >> TXPCU_CBF_RESP_CTL_40_TX_PWR_LSB)
#define TXPCU_CBF_RESP_CTL_40_TX_PWR_SET(x)                                    (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_TX_PWR_LSB) & TXPCU_CBF_RESP_CTL_40_TX_PWR_MASK)
#define TXPCU_CBF_RESP_CTL_40_TX_PWR_RESET                                     0x0
#define TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_LSB                                   10
#define TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_MSB                                   10
#define TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_MASK                                  0x400
#define TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_GET(x)                                (((x) & TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_MASK) >> TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_LSB)
#define TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_SET(x)                                (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_LSB) & TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_MASK)
#define TXPCU_CBF_RESP_CTL_40_DPD_ENABLE_RESET                                 0x0
#define TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_LSB                             7
#define TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_MSB                             9
#define TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_MASK                            0x380
#define TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_GET(x)                          (((x) & TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_MASK) >> TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_LSB)
#define TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_SET(x)                          (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_LSB) & TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_MASK)
#define TXPCU_CBF_RESP_CTL_40_TPC_INIT_PWR_CFG_RESET                           0x0
#define TXPCU_CBF_RESP_CTL_40_NSS_LSB                                          4
#define TXPCU_CBF_RESP_CTL_40_NSS_MSB                                          6
#define TXPCU_CBF_RESP_CTL_40_NSS_MASK                                         0x70
#define TXPCU_CBF_RESP_CTL_40_NSS_GET(x)                                       (((x) & TXPCU_CBF_RESP_CTL_40_NSS_MASK) >> TXPCU_CBF_RESP_CTL_40_NSS_LSB)
#define TXPCU_CBF_RESP_CTL_40_NSS_SET(x)                                       (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_NSS_LSB) & TXPCU_CBF_RESP_CTL_40_NSS_MASK)
#define TXPCU_CBF_RESP_CTL_40_NSS_RESET                                        0x0
#define TXPCU_CBF_RESP_CTL_40_RATE_MCS_LSB                                     0
#define TXPCU_CBF_RESP_CTL_40_RATE_MCS_MSB                                     3
#define TXPCU_CBF_RESP_CTL_40_RATE_MCS_MASK                                    0xf
#define TXPCU_CBF_RESP_CTL_40_RATE_MCS_GET(x)                                  (((x) & TXPCU_CBF_RESP_CTL_40_RATE_MCS_MASK) >> TXPCU_CBF_RESP_CTL_40_RATE_MCS_LSB)
#define TXPCU_CBF_RESP_CTL_40_RATE_MCS_SET(x)                                  (((0 | (x)) << TXPCU_CBF_RESP_CTL_40_RATE_MCS_LSB) & TXPCU_CBF_RESP_CTL_40_RATE_MCS_MASK)
#define TXPCU_CBF_RESP_CTL_40_RATE_MCS_RESET                                   0x0
#define TXPCU_CBF_RESP_CTL_40_ADDRESS                                          (0x58 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_CBF_RESP_CTL_40_RSTMASK                                          0x807fffff
#define TXPCU_CBF_RESP_CTL_40_RESET                                            0x400000

// 0x5c (TXPCU_CBF_RESP_CTL_80)
#define TXPCU_CBF_RESP_CTL_80_VALID_LSB                                        31
#define TXPCU_CBF_RESP_CTL_80_VALID_MSB                                        31
#define TXPCU_CBF_RESP_CTL_80_VALID_MASK                                       0x80000000
#define TXPCU_CBF_RESP_CTL_80_VALID_GET(x)                                     (((x) & TXPCU_CBF_RESP_CTL_80_VALID_MASK) >> TXPCU_CBF_RESP_CTL_80_VALID_LSB)
#define TXPCU_CBF_RESP_CTL_80_VALID_SET(x)                                     (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_VALID_LSB) & TXPCU_CBF_RESP_CTL_80_VALID_MASK)
#define TXPCU_CBF_RESP_CTL_80_VALID_RESET                                      0x1
#define TXPCU_CBF_RESP_CTL_80_PKT_TYPE_LSB                                     21
#define TXPCU_CBF_RESP_CTL_80_PKT_TYPE_MSB                                     22
#define TXPCU_CBF_RESP_CTL_80_PKT_TYPE_MASK                                    0x600000
#define TXPCU_CBF_RESP_CTL_80_PKT_TYPE_GET(x)                                  (((x) & TXPCU_CBF_RESP_CTL_80_PKT_TYPE_MASK) >> TXPCU_CBF_RESP_CTL_80_PKT_TYPE_LSB)
#define TXPCU_CBF_RESP_CTL_80_PKT_TYPE_SET(x)                                  (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_PKT_TYPE_LSB) & TXPCU_CBF_RESP_CTL_80_PKT_TYPE_MASK)
#define TXPCU_CBF_RESP_CTL_80_PKT_TYPE_RESET                                   0x3
#define TXPCU_CBF_RESP_CTL_80_SGI_LSB                                          20
#define TXPCU_CBF_RESP_CTL_80_SGI_MSB                                          20
#define TXPCU_CBF_RESP_CTL_80_SGI_MASK                                         0x100000
#define TXPCU_CBF_RESP_CTL_80_SGI_GET(x)                                       (((x) & TXPCU_CBF_RESP_CTL_80_SGI_MASK) >> TXPCU_CBF_RESP_CTL_80_SGI_LSB)
#define TXPCU_CBF_RESP_CTL_80_SGI_SET(x)                                       (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_SGI_LSB) & TXPCU_CBF_RESP_CTL_80_SGI_MASK)
#define TXPCU_CBF_RESP_CTL_80_SGI_RESET                                        0x0
#define TXPCU_CBF_RESP_CTL_80_LDPC_LSB                                         19
#define TXPCU_CBF_RESP_CTL_80_LDPC_MSB                                         19
#define TXPCU_CBF_RESP_CTL_80_LDPC_MASK                                        0x80000
#define TXPCU_CBF_RESP_CTL_80_LDPC_GET(x)                                      (((x) & TXPCU_CBF_RESP_CTL_80_LDPC_MASK) >> TXPCU_CBF_RESP_CTL_80_LDPC_LSB)
#define TXPCU_CBF_RESP_CTL_80_LDPC_SET(x)                                      (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_LDPC_LSB) & TXPCU_CBF_RESP_CTL_80_LDPC_MASK)
#define TXPCU_CBF_RESP_CTL_80_LDPC_RESET                                       0x0
#define TXPCU_CBF_RESP_CTL_80_STBC_LSB                                         18
#define TXPCU_CBF_RESP_CTL_80_STBC_MSB                                         18
#define TXPCU_CBF_RESP_CTL_80_STBC_MASK                                        0x40000
#define TXPCU_CBF_RESP_CTL_80_STBC_GET(x)                                      (((x) & TXPCU_CBF_RESP_CTL_80_STBC_MASK) >> TXPCU_CBF_RESP_CTL_80_STBC_LSB)
#define TXPCU_CBF_RESP_CTL_80_STBC_SET(x)                                      (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_STBC_LSB) & TXPCU_CBF_RESP_CTL_80_STBC_MASK)
#define TXPCU_CBF_RESP_CTL_80_STBC_RESET                                       0x0
#define TXPCU_CBF_RESP_CTL_80_TX_PWR_LSB                                       11
#define TXPCU_CBF_RESP_CTL_80_TX_PWR_MSB                                       17
#define TXPCU_CBF_RESP_CTL_80_TX_PWR_MASK                                      0x3f800
#define TXPCU_CBF_RESP_CTL_80_TX_PWR_GET(x)                                    (((x) & TXPCU_CBF_RESP_CTL_80_TX_PWR_MASK) >> TXPCU_CBF_RESP_CTL_80_TX_PWR_LSB)
#define TXPCU_CBF_RESP_CTL_80_TX_PWR_SET(x)                                    (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_TX_PWR_LSB) & TXPCU_CBF_RESP_CTL_80_TX_PWR_MASK)
#define TXPCU_CBF_RESP_CTL_80_TX_PWR_RESET                                     0x0
#define TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_LSB                                   10
#define TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_MSB                                   10
#define TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_MASK                                  0x400
#define TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_GET(x)                                (((x) & TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_MASK) >> TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_LSB)
#define TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_SET(x)                                (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_LSB) & TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_MASK)
#define TXPCU_CBF_RESP_CTL_80_DPD_ENABLE_RESET                                 0x0
#define TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_LSB                             7
#define TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_MSB                             9
#define TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_MASK                            0x380
#define TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_GET(x)                          (((x) & TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_MASK) >> TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_LSB)
#define TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_SET(x)                          (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_LSB) & TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_MASK)
#define TXPCU_CBF_RESP_CTL_80_TPC_INIT_PWR_CFG_RESET                           0x0
#define TXPCU_CBF_RESP_CTL_80_NSS_LSB                                          4
#define TXPCU_CBF_RESP_CTL_80_NSS_MSB                                          6
#define TXPCU_CBF_RESP_CTL_80_NSS_MASK                                         0x70
#define TXPCU_CBF_RESP_CTL_80_NSS_GET(x)                                       (((x) & TXPCU_CBF_RESP_CTL_80_NSS_MASK) >> TXPCU_CBF_RESP_CTL_80_NSS_LSB)
#define TXPCU_CBF_RESP_CTL_80_NSS_SET(x)                                       (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_NSS_LSB) & TXPCU_CBF_RESP_CTL_80_NSS_MASK)
#define TXPCU_CBF_RESP_CTL_80_NSS_RESET                                        0x0
#define TXPCU_CBF_RESP_CTL_80_RATE_MCS_LSB                                     0
#define TXPCU_CBF_RESP_CTL_80_RATE_MCS_MSB                                     3
#define TXPCU_CBF_RESP_CTL_80_RATE_MCS_MASK                                    0xf
#define TXPCU_CBF_RESP_CTL_80_RATE_MCS_GET(x)                                  (((x) & TXPCU_CBF_RESP_CTL_80_RATE_MCS_MASK) >> TXPCU_CBF_RESP_CTL_80_RATE_MCS_LSB)
#define TXPCU_CBF_RESP_CTL_80_RATE_MCS_SET(x)                                  (((0 | (x)) << TXPCU_CBF_RESP_CTL_80_RATE_MCS_LSB) & TXPCU_CBF_RESP_CTL_80_RATE_MCS_MASK)
#define TXPCU_CBF_RESP_CTL_80_RATE_MCS_RESET                                   0x0
#define TXPCU_CBF_RESP_CTL_80_ADDRESS                                          (0x5c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_CBF_RESP_CTL_80_RSTMASK                                          0x807fffff
#define TXPCU_CBF_RESP_CTL_80_RESET                                            0x80600000

// 0x60 (TXPCU_DYNAMIC_BW_CTL)
#define TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_LSB                           5
#define TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_MSB                           5
#define TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_MASK                          0x20
#define TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_GET(x)                        (((x) & TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_MASK) >> TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_LSB)
#define TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_SET(x)                        (((0 | (x)) << TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_LSB) & TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_MASK)
#define TXPCU_DYNAMIC_BW_CTL_USE_RTS_BW_FOR_PPDU_RESET                         0x0
#define TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_LSB                           4
#define TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_MSB                           4
#define TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_MASK                          0x10
#define TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_GET(x)                        (((x) & TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_MASK) >> TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_LSB)
#define TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_SET(x)                        (((0 | (x)) << TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_LSB) & TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_MASK)
#define TXPCU_DYNAMIC_BW_CTL_VHT_SERVICE_DYNAMIC_RESET                         0x1
#define TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_LSB                      2
#define TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_MSB                      3
#define TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_MASK                     0xc
#define TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_GET(x)                   (((x) & TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_MASK) >> TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_LSB)
#define TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_SET(x)                   (((0 | (x)) << TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_LSB) & TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_MASK)
#define TXPCU_DYNAMIC_BW_CTL_DPD_TRAINING_SELF_CTS_BW_RESET                    0x0
#define TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_LSB                                1
#define TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_MSB                                1
#define TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_MASK                               0x2
#define TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_GET(x)                             (((x) & TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_MASK) >> TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_LSB)
#define TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_SET(x)                             (((0 | (x)) << TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_LSB) & TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_MASK)
#define TXPCU_DYNAMIC_BW_CTL_HT_DYNAMIC_CBW_RESET                              0x0
#define TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_LSB                         0
#define TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_MSB                         0
#define TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_MASK                        0x1
#define TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_GET(x)                      (((x) & TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_MASK) >> TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_LSB)
#define TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_SET(x)                      (((0 | (x)) << TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_LSB) & TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_MASK)
#define TXPCU_DYNAMIC_BW_CTL_HT_AGC_DYNAMIC_BW_SEL_RESET                       0x0
#define TXPCU_DYNAMIC_BW_CTL_ADDRESS                                           (0x60 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DYNAMIC_BW_CTL_RSTMASK                                           0x3f
#define TXPCU_DYNAMIC_BW_CTL_RESET                                             0x10

// 0x64 (TXPCU_TXBUF_CONTROL)
#define TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_LSB                                   0
#define TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_MSB                                   0
#define TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_MASK                                  0x1
#define TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_GET(x)                                (((x) & TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_MASK) >> TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_LSB)
#define TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_SET(x)                                (((0 | (x)) << TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_LSB) & TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_MASK)
#define TXPCU_TXBUF_CONTROL_DEBUG_ENABLE_RESET                                 0x0
#define TXPCU_TXBUF_CONTROL_ADDRESS                                            (0x64 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_CONTROL_RSTMASK                                            0x1
#define TXPCU_TXBUF_CONTROL_RESET                                              0x0

// 0x68 (TXPCU_REQD_TLVS_WAIT_TIME)
#define TXPCU_REQD_TLVS_WAIT_TIME_VALUE_LSB                                    0
#define TXPCU_REQD_TLVS_WAIT_TIME_VALUE_MSB                                    15
#define TXPCU_REQD_TLVS_WAIT_TIME_VALUE_MASK                                   0xffff
#define TXPCU_REQD_TLVS_WAIT_TIME_VALUE_GET(x)                                 (((x) & TXPCU_REQD_TLVS_WAIT_TIME_VALUE_MASK) >> TXPCU_REQD_TLVS_WAIT_TIME_VALUE_LSB)
#define TXPCU_REQD_TLVS_WAIT_TIME_VALUE_SET(x)                                 (((0 | (x)) << TXPCU_REQD_TLVS_WAIT_TIME_VALUE_LSB) & TXPCU_REQD_TLVS_WAIT_TIME_VALUE_MASK)
#define TXPCU_REQD_TLVS_WAIT_TIME_VALUE_RESET                                  0x0
#define TXPCU_REQD_TLVS_WAIT_TIME_ADDRESS                                      (0x68 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_REQD_TLVS_WAIT_TIME_RSTMASK                                      0xffff
#define TXPCU_REQD_TLVS_WAIT_TIME_RESET                                        0x0

// 0x6c (TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME)
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_LSB                            0
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_MSB                            7
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_MASK                           0xff
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_GET(x)                         (((x) & TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_MASK) >> TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_LSB)
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_SET(x)                         (((0 | (x)) << TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_LSB) & TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_MASK)
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_VALUE_RESET                          0xc
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_ADDRESS                              (0x6c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_RSTMASK                              0xff
#define TXPCU_TIMEOUT_11AC_DATA_WAIT_TIME_RESET                                0xc

// 0x70 (TXPCU_DEBUG_STATE)
#define TXPCU_DEBUG_STATE_INFORMATION_LSB                                      0
#define TXPCU_DEBUG_STATE_INFORMATION_MSB                                      31
#define TXPCU_DEBUG_STATE_INFORMATION_MASK                                     0xffffffff
#define TXPCU_DEBUG_STATE_INFORMATION_GET(x)                                   (((x) & TXPCU_DEBUG_STATE_INFORMATION_MASK) >> TXPCU_DEBUG_STATE_INFORMATION_LSB)
#define TXPCU_DEBUG_STATE_INFORMATION_SET(x)                                   (((0 | (x)) << TXPCU_DEBUG_STATE_INFORMATION_LSB) & TXPCU_DEBUG_STATE_INFORMATION_MASK)
#define TXPCU_DEBUG_STATE_INFORMATION_RESET                                    0x2a000000
#define TXPCU_DEBUG_STATE_ADDRESS                                              (0x70 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_STATE_RSTMASK                                              0xffffffff
#define TXPCU_DEBUG_STATE_RESET                                                0x2a000000

// 0x74 (TXPCU_DEBUG_TX_FES_0)
#define TXPCU_DEBUG_TX_FES_0_INFORMATION_LSB                                   0
#define TXPCU_DEBUG_TX_FES_0_INFORMATION_MSB                                   29
#define TXPCU_DEBUG_TX_FES_0_INFORMATION_MASK                                  0x3fffffff
#define TXPCU_DEBUG_TX_FES_0_INFORMATION_GET(x)                                (((x) & TXPCU_DEBUG_TX_FES_0_INFORMATION_MASK) >> TXPCU_DEBUG_TX_FES_0_INFORMATION_LSB)
#define TXPCU_DEBUG_TX_FES_0_INFORMATION_SET(x)                                (((0 | (x)) << TXPCU_DEBUG_TX_FES_0_INFORMATION_LSB) & TXPCU_DEBUG_TX_FES_0_INFORMATION_MASK)
#define TXPCU_DEBUG_TX_FES_0_INFORMATION_RESET                                 0x0
#define TXPCU_DEBUG_TX_FES_0_ADDRESS                                           (0x74 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_FES_0_RSTMASK                                           0x3fffffff
#define TXPCU_DEBUG_TX_FES_0_RESET                                             0x0

// 0x78 (TXPCU_DEBUG_TX_FES_1)
#define TXPCU_DEBUG_TX_FES_1_INFORMATION_LSB                                   0
#define TXPCU_DEBUG_TX_FES_1_INFORMATION_MSB                                   27
#define TXPCU_DEBUG_TX_FES_1_INFORMATION_MASK                                  0xfffffff
#define TXPCU_DEBUG_TX_FES_1_INFORMATION_GET(x)                                (((x) & TXPCU_DEBUG_TX_FES_1_INFORMATION_MASK) >> TXPCU_DEBUG_TX_FES_1_INFORMATION_LSB)
#define TXPCU_DEBUG_TX_FES_1_INFORMATION_SET(x)                                (((0 | (x)) << TXPCU_DEBUG_TX_FES_1_INFORMATION_LSB) & TXPCU_DEBUG_TX_FES_1_INFORMATION_MASK)
#define TXPCU_DEBUG_TX_FES_1_INFORMATION_RESET                                 0x0
#define TXPCU_DEBUG_TX_FES_1_ADDRESS                                           (0x78 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_FES_1_RSTMASK                                           0xfffffff
#define TXPCU_DEBUG_TX_FES_1_RESET                                             0x0

// 0x7c (TXPCU_DEBUG_TX_FES_2)
#define TXPCU_DEBUG_TX_FES_2_INFORMATION_LSB                                   0
#define TXPCU_DEBUG_TX_FES_2_INFORMATION_MSB                                   23
#define TXPCU_DEBUG_TX_FES_2_INFORMATION_MASK                                  0xffffff
#define TXPCU_DEBUG_TX_FES_2_INFORMATION_GET(x)                                (((x) & TXPCU_DEBUG_TX_FES_2_INFORMATION_MASK) >> TXPCU_DEBUG_TX_FES_2_INFORMATION_LSB)
#define TXPCU_DEBUG_TX_FES_2_INFORMATION_SET(x)                                (((0 | (x)) << TXPCU_DEBUG_TX_FES_2_INFORMATION_LSB) & TXPCU_DEBUG_TX_FES_2_INFORMATION_MASK)
#define TXPCU_DEBUG_TX_FES_2_INFORMATION_RESET                                 0x0
#define TXPCU_DEBUG_TX_FES_2_ADDRESS                                           (0x7c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_FES_2_RSTMASK                                           0xffffff
#define TXPCU_DEBUG_TX_FES_2_RESET                                             0x0

// 0x80 (TXPCU_TRACEBUS_CTRL)
#define TXPCU_TRACEBUS_CTRL_SELECT_LSB                                         0
#define TXPCU_TRACEBUS_CTRL_SELECT_MSB                                         7
#define TXPCU_TRACEBUS_CTRL_SELECT_MASK                                        0xff
#define TXPCU_TRACEBUS_CTRL_SELECT_GET(x)                                      (((x) & TXPCU_TRACEBUS_CTRL_SELECT_MASK) >> TXPCU_TRACEBUS_CTRL_SELECT_LSB)
#define TXPCU_TRACEBUS_CTRL_SELECT_SET(x)                                      (((0 | (x)) << TXPCU_TRACEBUS_CTRL_SELECT_LSB) & TXPCU_TRACEBUS_CTRL_SELECT_MASK)
#define TXPCU_TRACEBUS_CTRL_SELECT_RESET                                       0x0
#define TXPCU_TRACEBUS_CTRL_ADDRESS                                            (0x80 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TRACEBUS_CTRL_RSTMASK                                            0xff
#define TXPCU_TRACEBUS_CTRL_RESET                                              0x0

// 0x84 (TXPCU_DEBUG_TRACE_BUS_LOWER)
#define TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_LSB                                  0
#define TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_MSB                                  31
#define TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_MASK                                 0xffffffff
#define TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_GET(x)                               (((x) & TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_MASK) >> TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_LSB)
#define TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_SET(x)                               (((0 | (x)) << TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_LSB) & TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_MASK)
#define TXPCU_DEBUG_TRACE_BUS_LOWER_VALUE_RESET                                0x8000000
#define TXPCU_DEBUG_TRACE_BUS_LOWER_ADDRESS                                    (0x84 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TRACE_BUS_LOWER_RSTMASK                                    0xffffffff
#define TXPCU_DEBUG_TRACE_BUS_LOWER_RESET                                      0x8000000

// 0x88 (TXPCU_DEBUG_TRACE_BUS_UPPER)
#define TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_LSB                                  0
#define TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_MSB                                  7
#define TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_MASK                                 0xff
#define TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_GET(x)                               (((x) & TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_MASK) >> TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_LSB)
#define TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_SET(x)                               (((0 | (x)) << TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_LSB) & TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_MASK)
#define TXPCU_DEBUG_TRACE_BUS_UPPER_VALUE_RESET                                0x0
#define TXPCU_DEBUG_TRACE_BUS_UPPER_ADDRESS                                    (0x88 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TRACE_BUS_UPPER_RSTMASK                                    0xff
#define TXPCU_DEBUG_TRACE_BUS_UPPER_RESET                                      0x0

// 0x8c (TXPCU_DEBUG_CREDIT_COUNTERS)
#define TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_LSB                            0
#define TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_MSB                            31
#define TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_MASK                           0xffffffff
#define TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_GET(x)                         (((x) & TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_MASK) >> TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_LSB)
#define TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_SET(x)                         (((0 | (x)) << TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_LSB) & TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_MASK)
#define TXPCU_DEBUG_CREDIT_COUNTERS_INFORMATION_RESET                          0x0
#define TXPCU_DEBUG_CREDIT_COUNTERS_ADDRESS                                    (0x8c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_CREDIT_COUNTERS_RSTMASK                                    0xffffffff
#define TXPCU_DEBUG_CREDIT_COUNTERS_RESET                                      0x0

// 0x90 (TXPCU_DEBUG_START_TX_CNT)
#define TXPCU_DEBUG_START_TX_CNT_VALUE_LSB                                     0
#define TXPCU_DEBUG_START_TX_CNT_VALUE_MSB                                     31
#define TXPCU_DEBUG_START_TX_CNT_VALUE_MASK                                    0xffffffff
#define TXPCU_DEBUG_START_TX_CNT_VALUE_GET(x)                                  (((x) & TXPCU_DEBUG_START_TX_CNT_VALUE_MASK) >> TXPCU_DEBUG_START_TX_CNT_VALUE_LSB)
#define TXPCU_DEBUG_START_TX_CNT_VALUE_SET(x)                                  (((0 | (x)) << TXPCU_DEBUG_START_TX_CNT_VALUE_LSB) & TXPCU_DEBUG_START_TX_CNT_VALUE_MASK)
#define TXPCU_DEBUG_START_TX_CNT_VALUE_RESET                                   0x0
#define TXPCU_DEBUG_START_TX_CNT_ADDRESS                                       (0x90 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_START_TX_CNT_RSTMASK                                       0xffffffff
#define TXPCU_DEBUG_START_TX_CNT_RESET                                         0x0

// 0x94 (TXPCU_DEBUG_TX_FLUSH_CNT)
#define TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_LSB                                     0
#define TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_MSB                                     31
#define TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_MASK                                    0xffffffff
#define TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_GET(x)                                  (((x) & TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_MASK) >> TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_LSB)
#define TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_SET(x)                                  (((0 | (x)) << TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_LSB) & TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_MASK)
#define TXPCU_DEBUG_TX_FLUSH_CNT_VALUE_RESET                                   0x0
#define TXPCU_DEBUG_TX_FLUSH_CNT_ADDRESS                                       (0x94 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_FLUSH_CNT_RSTMASK                                       0xffffffff
#define TXPCU_DEBUG_TX_FLUSH_CNT_RESET                                         0x0

// 0x98 (TXPCU_DEBUG_RTS_SUCCESS_CNT)
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_LSB                                  0
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_MSB                                  31
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_MASK                                 0xffffffff
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_GET(x)                               (((x) & TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_MASK) >> TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_LSB)
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_SET(x)                               (((0 | (x)) << TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_LSB) & TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_MASK)
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_VALUE_RESET                                0x0
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_ADDRESS                                    (0x98 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_RSTMASK                                    0xffffffff
#define TXPCU_DEBUG_RTS_SUCCESS_CNT_RESET                                      0x0

// 0x9c (TXPCU_DEBUG_RTS_FAIL_CNT)
#define TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_LSB                                     0
#define TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_MSB                                     31
#define TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_MASK                                    0xffffffff
#define TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_GET(x)                                  (((x) & TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_MASK) >> TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_LSB)
#define TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_SET(x)                                  (((0 | (x)) << TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_LSB) & TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_MASK)
#define TXPCU_DEBUG_RTS_FAIL_CNT_VALUE_RESET                                   0x0
#define TXPCU_DEBUG_RTS_FAIL_CNT_ADDRESS                                       (0x9c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RTS_FAIL_CNT_RSTMASK                                       0xffffffff
#define TXPCU_DEBUG_RTS_FAIL_CNT_RESET                                         0x0

// 0xa0 (TXPCU_DEBUG_ACK_SUCCESS_CNT)
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_LSB                                  0
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_MSB                                  31
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_MASK                                 0xffffffff
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_GET(x)                               (((x) & TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_MASK) >> TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_LSB)
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_SET(x)                               (((0 | (x)) << TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_LSB) & TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_MASK)
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_VALUE_RESET                                0x0
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_ADDRESS                                    (0xa0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_RSTMASK                                    0xffffffff
#define TXPCU_DEBUG_ACK_SUCCESS_CNT_RESET                                      0x0

// 0xa4 (TXPCU_DEBUG_ACK_FAIL_CNT)
#define TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_LSB                                     0
#define TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_MSB                                     31
#define TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_MASK                                    0xffffffff
#define TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_GET(x)                                  (((x) & TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_MASK) >> TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_LSB)
#define TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_SET(x)                                  (((0 | (x)) << TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_LSB) & TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_MASK)
#define TXPCU_DEBUG_ACK_FAIL_CNT_VALUE_RESET                                   0x0
#define TXPCU_DEBUG_ACK_FAIL_CNT_ADDRESS                                       (0xa4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_ACK_FAIL_CNT_RSTMASK                                       0xffffffff
#define TXPCU_DEBUG_ACK_FAIL_CNT_RESET                                         0x0

// 0xa8 (TXPCU_DEBUG_MPDU_TX_FRAME_CNT)
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_LSB                                0
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_MSB                                31
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_MASK                               0xffffffff
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_GET(x)                             (((x) & TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_MASK) >> TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_LSB)
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_SET(x)                             (((0 | (x)) << TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_LSB) & TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_MASK)
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_VALUE_RESET                              0x0
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_ADDRESS                                  (0xa8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_RSTMASK                                  0xffffffff
#define TXPCU_DEBUG_MPDU_TX_FRAME_CNT_RESET                                    0x0

// 0xac (TXPCU_DEBUG_AMPDU_TX_FRAME_CNT)
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_LSB                               0
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_MSB                               31
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_MASK                              0xffffffff
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_GET(x)                            (((x) & TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_MASK) >> TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_LSB)
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_SET(x)                            (((0 | (x)) << TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_LSB) & TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_MASK)
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_VALUE_RESET                             0x0
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_ADDRESS                                 (0xac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_RSTMASK                                 0xffffffff
#define TXPCU_DEBUG_AMPDU_TX_FRAME_CNT_RESET                                   0x0

// 0xb0 (TXPCU_DEBUG_TX_PHY_ERROR_CNT)
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_LSB                                 0
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_MSB                                 31
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_MASK                                0xffffffff
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_GET(x)                              (((x) & TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_MASK) >> TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_LSB)
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_SET(x)                              (((0 | (x)) << TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_LSB) & TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_MASK)
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_VALUE_RESET                               0x0
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_ADDRESS                                   (0xb0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_RSTMASK                                   0xffffffff
#define TXPCU_DEBUG_TX_PHY_ERROR_CNT_RESET                                     0x0

// 0xb4 (TXPCU_DEBUG_RX_FRAME_CNT)
#define TXPCU_DEBUG_RX_FRAME_CNT_VALUE_LSB                                     0
#define TXPCU_DEBUG_RX_FRAME_CNT_VALUE_MSB                                     31
#define TXPCU_DEBUG_RX_FRAME_CNT_VALUE_MASK                                    0xffffffff
#define TXPCU_DEBUG_RX_FRAME_CNT_VALUE_GET(x)                                  (((x) & TXPCU_DEBUG_RX_FRAME_CNT_VALUE_MASK) >> TXPCU_DEBUG_RX_FRAME_CNT_VALUE_LSB)
#define TXPCU_DEBUG_RX_FRAME_CNT_VALUE_SET(x)                                  (((0 | (x)) << TXPCU_DEBUG_RX_FRAME_CNT_VALUE_LSB) & TXPCU_DEBUG_RX_FRAME_CNT_VALUE_MASK)
#define TXPCU_DEBUG_RX_FRAME_CNT_VALUE_RESET                                   0x0
#define TXPCU_DEBUG_RX_FRAME_CNT_ADDRESS                                       (0xb4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RX_FRAME_CNT_RSTMASK                                       0xffffffff
#define TXPCU_DEBUG_RX_FRAME_CNT_RESET                                         0x0

// 0xb8 (TXPCU_DEBUG_PDG_RESPONSE_CNT)
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_LSB                                 0
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_MSB                                 31
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_MASK                                0xffffffff
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_GET(x)                              (((x) & TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_MASK) >> TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_LSB)
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_SET(x)                              (((0 | (x)) << TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_LSB) & TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_MASK)
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_VALUE_RESET                               0x0
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_ADDRESS                                   (0xb8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_RSTMASK                                   0xffffffff
#define TXPCU_DEBUG_PDG_RESPONSE_CNT_RESET                                     0x0

// 0xbc (TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT)
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_LSB                           0
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_MSB                           31
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_MASK                          0xffffffff
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_GET(x)                        (((x) & TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_MASK) >> TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_LSB)
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_SET(x)                        (((0 | (x)) << TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_LSB) & TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_MASK)
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_VALUE_RESET                         0x0
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_ADDRESS                             (0xbc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_RSTMASK                             0xffffffff
#define TXPCU_DEBUG_RESP_FRAME_SUCCESS_CNT_RESET                               0x0

// 0xc0 (TXPCU_DEBUG_RESP_FRAME_FAIL_CNT)
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_LSB                              0
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_MSB                              31
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_MASK                             0xffffffff
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_GET(x)                           (((x) & TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_MASK) >> TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_LSB)
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_SET(x)                           (((0 | (x)) << TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_LSB) & TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_MASK)
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_VALUE_RESET                            0x0
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_ADDRESS                                (0xc0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_RSTMASK                                0xffffffff
#define TXPCU_DEBUG_RESP_FRAME_FAIL_CNT_RESET                                  0x0

// 0xc4 (TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT)
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_LSB                         0
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_MSB                         31
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_MASK                        0xffffffff
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_GET(x)                      (((x) & TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_MASK) >> TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_LSB)
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_SET(x)                      (((0 | (x)) << TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_LSB) & TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_MASK)
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_VALUE_RESET                       0x0
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_ADDRESS                           (0xc4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_RSTMASK                           0xffffffff
#define TXPCU_DEBUG_TX_FES_STATUS_UPDATE_CNT_RESET                             0x0

// 0xc8 (TXPCU_SELF_GEN_ERROR)
#define TXPCU_SELF_GEN_ERROR_STATUS_LSB                                        0
#define TXPCU_SELF_GEN_ERROR_STATUS_MSB                                        4
#define TXPCU_SELF_GEN_ERROR_STATUS_MASK                                       0x1f
#define TXPCU_SELF_GEN_ERROR_STATUS_GET(x)                                     (((x) & TXPCU_SELF_GEN_ERROR_STATUS_MASK) >> TXPCU_SELF_GEN_ERROR_STATUS_LSB)
#define TXPCU_SELF_GEN_ERROR_STATUS_SET(x)                                     (((0 | (x)) << TXPCU_SELF_GEN_ERROR_STATUS_LSB) & TXPCU_SELF_GEN_ERROR_STATUS_MASK)
#define TXPCU_SELF_GEN_ERROR_STATUS_RESET                                      0x0
#define TXPCU_SELF_GEN_ERROR_ADDRESS                                           (0xc8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_SELF_GEN_ERROR_RSTMASK                                           0x1f
#define TXPCU_SELF_GEN_ERROR_RESET                                             0x0

// 0xcc (TXPCU_EVENT_BUS_MASK0)
#define TXPCU_EVENT_BUS_MASK0_VALUE_LSB                                        0
#define TXPCU_EVENT_BUS_MASK0_VALUE_MSB                                        31
#define TXPCU_EVENT_BUS_MASK0_VALUE_MASK                                       0xffffffff
#define TXPCU_EVENT_BUS_MASK0_VALUE_GET(x)                                     (((x) & TXPCU_EVENT_BUS_MASK0_VALUE_MASK) >> TXPCU_EVENT_BUS_MASK0_VALUE_LSB)
#define TXPCU_EVENT_BUS_MASK0_VALUE_SET(x)                                     (((0 | (x)) << TXPCU_EVENT_BUS_MASK0_VALUE_LSB) & TXPCU_EVENT_BUS_MASK0_VALUE_MASK)
#define TXPCU_EVENT_BUS_MASK0_VALUE_RESET                                      0xffffffff
#define TXPCU_EVENT_BUS_MASK0_ADDRESS                                          (0xcc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_EVENT_BUS_MASK0_RSTMASK                                          0xffffffff
#define TXPCU_EVENT_BUS_MASK0_RESET                                            0xffffffff

// 0xd0 (TXPCU_EVENT_BUS_MASK1)
#define TXPCU_EVENT_BUS_MASK1_VALUE_LSB                                        0
#define TXPCU_EVENT_BUS_MASK1_VALUE_MSB                                        31
#define TXPCU_EVENT_BUS_MASK1_VALUE_MASK                                       0xffffffff
#define TXPCU_EVENT_BUS_MASK1_VALUE_GET(x)                                     (((x) & TXPCU_EVENT_BUS_MASK1_VALUE_MASK) >> TXPCU_EVENT_BUS_MASK1_VALUE_LSB)
#define TXPCU_EVENT_BUS_MASK1_VALUE_SET(x)                                     (((0 | (x)) << TXPCU_EVENT_BUS_MASK1_VALUE_LSB) & TXPCU_EVENT_BUS_MASK1_VALUE_MASK)
#define TXPCU_EVENT_BUS_MASK1_VALUE_RESET                                      0xffffffff
#define TXPCU_EVENT_BUS_MASK1_ADDRESS                                          (0xd0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_EVENT_BUS_MASK1_RSTMASK                                          0xffffffff
#define TXPCU_EVENT_BUS_MASK1_RESET                                            0xffffffff

// 0xd4 (TXPCU_CLOCK_GATE_DISABLE)
#define TXPCU_CLOCK_GATE_DISABLE_VALUE_LSB                                     0
#define TXPCU_CLOCK_GATE_DISABLE_VALUE_MSB                                     0
#define TXPCU_CLOCK_GATE_DISABLE_VALUE_MASK                                    0x1
#define TXPCU_CLOCK_GATE_DISABLE_VALUE_GET(x)                                  (((x) & TXPCU_CLOCK_GATE_DISABLE_VALUE_MASK) >> TXPCU_CLOCK_GATE_DISABLE_VALUE_LSB)
#define TXPCU_CLOCK_GATE_DISABLE_VALUE_SET(x)                                  (((0 | (x)) << TXPCU_CLOCK_GATE_DISABLE_VALUE_LSB) & TXPCU_CLOCK_GATE_DISABLE_VALUE_MASK)
#define TXPCU_CLOCK_GATE_DISABLE_VALUE_RESET                                   0x1
#define TXPCU_CLOCK_GATE_DISABLE_ADDRESS                                       (0xd4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_CLOCK_GATE_DISABLE_RSTMASK                                       0x1
#define TXPCU_CLOCK_GATE_DISABLE_RESET                                         0x1

// 0xd8 (TXPCU_DEBUG_RX_MESSAGE_TLV)
#define TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_LSB                              16
#define TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_MSB                              31
#define TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_MASK                             0xffff0000
#define TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_GET(x)                           (((x) & TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_MASK) >> TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_SET(x)                           (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_LSB) & TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_TLV_SENT_COUNT_RESET                            0x0
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_LSB                              0
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_MSB                              15
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_MASK                             0xffff
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_GET(x)                           (((x) & TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_MASK) >> TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_SET(x)                           (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_LSB) & TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RCVD_COUNT_RESET                            0x0
#define TXPCU_DEBUG_RX_MESSAGE_TLV_ADDRESS                                     (0xd8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RSTMASK                                     0xffffffff
#define TXPCU_DEBUG_RX_MESSAGE_TLV_RESET                                       0x0

// 0xdc (TXPCU_DEBUG_RX_MESSAGE_COUNT0)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_LSB                              24
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_MSB                              31
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_MASK                             0xff000000
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_GET(x)                           (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_SET(x)                           (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_OFF_RESET                            0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_LSB                               16
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_MSB                               23
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_MASK                              0xff0000
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_GET(x)                            (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_SET(x)                            (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_ON_RESET                             0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_LSB                              8
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_MSB                              15
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_MASK                             0xff00
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_GET(x)                           (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_SET(x)                           (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_PHY_NAP_RESET                            0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_LSB                        0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_MSB                        7
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_MASK                       0xff
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_GET(x)                     (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_SET(x)                     (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RX_CHAIN_MASK_RESET                      0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_ADDRESS                                  (0xdc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RSTMASK                                  0xffffffff
#define TXPCU_DEBUG_RX_MESSAGE_COUNT0_RESET                                    0x0

// 0xe0 (TXPCU_DEBUG_RX_MESSAGE_COUNT1)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_LSB                        24
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_MSB                        31
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_MASK                       0xff000000
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_GET(x)                     (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_SET(x)                     (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_EXPECT_NDP_RESET                      0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_LSB                      16
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_MSB                      23
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_MASK                     0xff0000
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_GET(x)                   (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_SET(x)                   (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_REQ_IMPLICIT_FB_RESET                    0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_LSB                       8
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MSB                       15
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MASK                      0xff00
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_GET(x)                    (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_SET(x)                    (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_RESET                     0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_LSB                        0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_MSB                        7
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_MASK                       0xff
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_GET(x)                     (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_SET(x)                     (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_TX_CBF_OFFSET_RESET                      0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_ADDRESS                                  (0xe0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_RSTMASK                                  0xffffffff
#define TXPCU_DEBUG_RX_MESSAGE_COUNT1_RESET                                    0x0

// 0xe4 (TXPCU_DEBUG_RX_MESSAGE_COUNT2)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_LSB                      8
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_MSB                      15
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_MASK                     0xff00
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_GET(x)                   (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_SET(x)                   (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_CLEAR_NDPA_FLAG_RESET                    0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_LSB            0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_MSB            7
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_MASK           0xff
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_GET(x)         (((x) & TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_MASK) >> TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_LSB)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_SET(x)         (((0 | (x)) << TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_LSB) & TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_MASK)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_TX_FREEZE_CAPTURE_CHANNEL_RESET          0x0
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_ADDRESS                                  (0xe4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_RSTMASK                                  0xffff
#define TXPCU_DEBUG_RX_MESSAGE_COUNT2_RESET                                    0x0

// 0xe8 (TXPCU_DEBUG_TX_MESSAGE_COUNT0)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_LSB                          16
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_MSB                          31
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_MASK                         0xffff0000
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_GET(x)                       (((x) & TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_MASK) >> TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_LSB)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_SET(x)                       (((0 | (x)) << TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_LSB) & TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_MASK)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_MAC_PKT_END_RESET                        0x0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_LSB                           8
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_MSB                           15
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_MASK                          0xff00
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_GET(x)                        (((x) & TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_MASK) >> TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_LSB)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_SET(x)                        (((0 | (x)) << TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_LSB) & TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_MASK)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_EXPECT_CBF_RESET                         0x0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_LSB                            0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_MSB                            7
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_MASK                           0xff
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_GET(x)                         (((x) & TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_MASK) >> TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_LSB)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_SET(x)                         (((0 | (x)) << TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_LSB) & TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_MASK)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_BF_PARAMS_RESET                          0x0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_ADDRESS                                  (0xe8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_RSTMASK                                  0xffffffff
#define TXPCU_DEBUG_TX_MESSAGE_COUNT0_RESET                                    0x0

// 0xec (TXPCU_DEBUG_TX_MESSAGE_COUNT1)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_LSB                       16
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MSB                       23
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MASK                      0xff0000
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_GET(x)                    (((x) & TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MASK) >> TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_LSB)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_SET(x)                    (((0 | (x)) << TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_LSB) & TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_MASK)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TX_MAC_TIMEOUT_RESET                     0x0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_LSB                        8
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_MSB                        15
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_MASK                       0xff00
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_GET(x)                     (((x) & TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_MASK) >> TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_LSB)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_SET(x)                     (((0 | (x)) << TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_LSB) & TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_MASK)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_TERMINATE_RESET                      0x0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_LSB                            0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_MSB                            7
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_MASK                           0xff
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_GET(x)                         (((x) & TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_MASK) >> TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_LSB)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_SET(x)                         (((0 | (x)) << TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_LSB) & TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_MASK)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_TLV_ABORT_RESET                          0x0
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_ADDRESS                                  (0xec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_RSTMASK                                  0xffffff
#define TXPCU_DEBUG_TX_MESSAGE_COUNT1_RESET                                    0x0

// 0x1000 (TXPCU_TXBUF)
#define TXPCU_TXBUF_DATA_LSB                                                   0
#define TXPCU_TXBUF_DATA_MSB                                                   31
#define TXPCU_TXBUF_DATA_MASK                                                  0xffffffff
#define TXPCU_TXBUF_DATA_GET(x)                                                (((x) & TXPCU_TXBUF_DATA_MASK) >> TXPCU_TXBUF_DATA_LSB)
#define TXPCU_TXBUF_DATA_SET(x)                                                (((0 | (x)) << TXPCU_TXBUF_DATA_LSB) & TXPCU_TXBUF_DATA_MASK)
#define TXPCU_TXBUF_DATA_RESET                                                 0x0
#define TXPCU_TXBUF_ADDRESS                                                    (0x1000 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_RSTMASK                                                    0xffffffff
#define TXPCU_TXBUF_RESET                                                      0x0

// 0x1000 (TXPCU_TXBUF_0)
#define TXPCU_TXBUF_DATA_0_LSB                                                 0
#define TXPCU_TXBUF_DATA_0_MSB                                                 31
#define TXPCU_TXBUF_DATA_0_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_0_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_0_MASK) >> TXPCU_TXBUF_DATA_0_LSB)
#define TXPCU_TXBUF_DATA_0_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_0_LSB) & TXPCU_TXBUF_DATA_0_MASK)
#define TXPCU_TXBUF_DATA_0_RESET                                               0x0
#define TXPCU_TXBUF_0_ADDRESS                                                  (0x1000 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_0_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_0_RESET                                                    0x0

// 0x1004 (TXPCU_TXBUF_1)
#define TXPCU_TXBUF_DATA_1_LSB                                                 0
#define TXPCU_TXBUF_DATA_1_MSB                                                 31
#define TXPCU_TXBUF_DATA_1_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_1_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_1_MASK) >> TXPCU_TXBUF_DATA_1_LSB)
#define TXPCU_TXBUF_DATA_1_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_1_LSB) & TXPCU_TXBUF_DATA_1_MASK)
#define TXPCU_TXBUF_DATA_1_RESET                                               0x0
#define TXPCU_TXBUF_1_ADDRESS                                                  (0x1004 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_1_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_1_RESET                                                    0x0

// 0x1008 (TXPCU_TXBUF_2)
#define TXPCU_TXBUF_DATA_2_LSB                                                 0
#define TXPCU_TXBUF_DATA_2_MSB                                                 31
#define TXPCU_TXBUF_DATA_2_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_2_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_2_MASK) >> TXPCU_TXBUF_DATA_2_LSB)
#define TXPCU_TXBUF_DATA_2_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_2_LSB) & TXPCU_TXBUF_DATA_2_MASK)
#define TXPCU_TXBUF_DATA_2_RESET                                               0x0
#define TXPCU_TXBUF_2_ADDRESS                                                  (0x1008 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_2_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_2_RESET                                                    0x0

// 0x100c (TXPCU_TXBUF_3)
#define TXPCU_TXBUF_DATA_3_LSB                                                 0
#define TXPCU_TXBUF_DATA_3_MSB                                                 31
#define TXPCU_TXBUF_DATA_3_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_3_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_3_MASK) >> TXPCU_TXBUF_DATA_3_LSB)
#define TXPCU_TXBUF_DATA_3_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_3_LSB) & TXPCU_TXBUF_DATA_3_MASK)
#define TXPCU_TXBUF_DATA_3_RESET                                               0x0
#define TXPCU_TXBUF_3_ADDRESS                                                  (0x100c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_3_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_3_RESET                                                    0x0

// 0x1010 (TXPCU_TXBUF_4)
#define TXPCU_TXBUF_DATA_4_LSB                                                 0
#define TXPCU_TXBUF_DATA_4_MSB                                                 31
#define TXPCU_TXBUF_DATA_4_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_4_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_4_MASK) >> TXPCU_TXBUF_DATA_4_LSB)
#define TXPCU_TXBUF_DATA_4_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_4_LSB) & TXPCU_TXBUF_DATA_4_MASK)
#define TXPCU_TXBUF_DATA_4_RESET                                               0x0
#define TXPCU_TXBUF_4_ADDRESS                                                  (0x1010 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_4_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_4_RESET                                                    0x0

// 0x1014 (TXPCU_TXBUF_5)
#define TXPCU_TXBUF_DATA_5_LSB                                                 0
#define TXPCU_TXBUF_DATA_5_MSB                                                 31
#define TXPCU_TXBUF_DATA_5_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_5_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_5_MASK) >> TXPCU_TXBUF_DATA_5_LSB)
#define TXPCU_TXBUF_DATA_5_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_5_LSB) & TXPCU_TXBUF_DATA_5_MASK)
#define TXPCU_TXBUF_DATA_5_RESET                                               0x0
#define TXPCU_TXBUF_5_ADDRESS                                                  (0x1014 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_5_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_5_RESET                                                    0x0

// 0x1018 (TXPCU_TXBUF_6)
#define TXPCU_TXBUF_DATA_6_LSB                                                 0
#define TXPCU_TXBUF_DATA_6_MSB                                                 31
#define TXPCU_TXBUF_DATA_6_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_6_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_6_MASK) >> TXPCU_TXBUF_DATA_6_LSB)
#define TXPCU_TXBUF_DATA_6_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_6_LSB) & TXPCU_TXBUF_DATA_6_MASK)
#define TXPCU_TXBUF_DATA_6_RESET                                               0x0
#define TXPCU_TXBUF_6_ADDRESS                                                  (0x1018 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_6_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_6_RESET                                                    0x0

// 0x101c (TXPCU_TXBUF_7)
#define TXPCU_TXBUF_DATA_7_LSB                                                 0
#define TXPCU_TXBUF_DATA_7_MSB                                                 31
#define TXPCU_TXBUF_DATA_7_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_7_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_7_MASK) >> TXPCU_TXBUF_DATA_7_LSB)
#define TXPCU_TXBUF_DATA_7_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_7_LSB) & TXPCU_TXBUF_DATA_7_MASK)
#define TXPCU_TXBUF_DATA_7_RESET                                               0x0
#define TXPCU_TXBUF_7_ADDRESS                                                  (0x101c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_7_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_7_RESET                                                    0x0

// 0x1020 (TXPCU_TXBUF_8)
#define TXPCU_TXBUF_DATA_8_LSB                                                 0
#define TXPCU_TXBUF_DATA_8_MSB                                                 31
#define TXPCU_TXBUF_DATA_8_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_8_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_8_MASK) >> TXPCU_TXBUF_DATA_8_LSB)
#define TXPCU_TXBUF_DATA_8_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_8_LSB) & TXPCU_TXBUF_DATA_8_MASK)
#define TXPCU_TXBUF_DATA_8_RESET                                               0x0
#define TXPCU_TXBUF_8_ADDRESS                                                  (0x1020 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_8_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_8_RESET                                                    0x0

// 0x1024 (TXPCU_TXBUF_9)
#define TXPCU_TXBUF_DATA_9_LSB                                                 0
#define TXPCU_TXBUF_DATA_9_MSB                                                 31
#define TXPCU_TXBUF_DATA_9_MASK                                                0xffffffff
#define TXPCU_TXBUF_DATA_9_GET(x)                                              (((x) & TXPCU_TXBUF_DATA_9_MASK) >> TXPCU_TXBUF_DATA_9_LSB)
#define TXPCU_TXBUF_DATA_9_SET(x)                                              (((0 | (x)) << TXPCU_TXBUF_DATA_9_LSB) & TXPCU_TXBUF_DATA_9_MASK)
#define TXPCU_TXBUF_DATA_9_RESET                                               0x0
#define TXPCU_TXBUF_9_ADDRESS                                                  (0x1024 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_9_RSTMASK                                                  0xffffffff
#define TXPCU_TXBUF_9_RESET                                                    0x0

// 0x1028 (TXPCU_TXBUF_10)
#define TXPCU_TXBUF_DATA_10_LSB                                                0
#define TXPCU_TXBUF_DATA_10_MSB                                                31
#define TXPCU_TXBUF_DATA_10_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_10_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_10_MASK) >> TXPCU_TXBUF_DATA_10_LSB)
#define TXPCU_TXBUF_DATA_10_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_10_LSB) & TXPCU_TXBUF_DATA_10_MASK)
#define TXPCU_TXBUF_DATA_10_RESET                                              0x0
#define TXPCU_TXBUF_10_ADDRESS                                                 (0x1028 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_10_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_10_RESET                                                   0x0

// 0x102c (TXPCU_TXBUF_11)
#define TXPCU_TXBUF_DATA_11_LSB                                                0
#define TXPCU_TXBUF_DATA_11_MSB                                                31
#define TXPCU_TXBUF_DATA_11_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_11_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_11_MASK) >> TXPCU_TXBUF_DATA_11_LSB)
#define TXPCU_TXBUF_DATA_11_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_11_LSB) & TXPCU_TXBUF_DATA_11_MASK)
#define TXPCU_TXBUF_DATA_11_RESET                                              0x0
#define TXPCU_TXBUF_11_ADDRESS                                                 (0x102c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_11_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_11_RESET                                                   0x0

// 0x1030 (TXPCU_TXBUF_12)
#define TXPCU_TXBUF_DATA_12_LSB                                                0
#define TXPCU_TXBUF_DATA_12_MSB                                                31
#define TXPCU_TXBUF_DATA_12_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_12_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_12_MASK) >> TXPCU_TXBUF_DATA_12_LSB)
#define TXPCU_TXBUF_DATA_12_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_12_LSB) & TXPCU_TXBUF_DATA_12_MASK)
#define TXPCU_TXBUF_DATA_12_RESET                                              0x0
#define TXPCU_TXBUF_12_ADDRESS                                                 (0x1030 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_12_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_12_RESET                                                   0x0

// 0x1034 (TXPCU_TXBUF_13)
#define TXPCU_TXBUF_DATA_13_LSB                                                0
#define TXPCU_TXBUF_DATA_13_MSB                                                31
#define TXPCU_TXBUF_DATA_13_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_13_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_13_MASK) >> TXPCU_TXBUF_DATA_13_LSB)
#define TXPCU_TXBUF_DATA_13_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_13_LSB) & TXPCU_TXBUF_DATA_13_MASK)
#define TXPCU_TXBUF_DATA_13_RESET                                              0x0
#define TXPCU_TXBUF_13_ADDRESS                                                 (0x1034 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_13_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_13_RESET                                                   0x0

// 0x1038 (TXPCU_TXBUF_14)
#define TXPCU_TXBUF_DATA_14_LSB                                                0
#define TXPCU_TXBUF_DATA_14_MSB                                                31
#define TXPCU_TXBUF_DATA_14_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_14_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_14_MASK) >> TXPCU_TXBUF_DATA_14_LSB)
#define TXPCU_TXBUF_DATA_14_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_14_LSB) & TXPCU_TXBUF_DATA_14_MASK)
#define TXPCU_TXBUF_DATA_14_RESET                                              0x0
#define TXPCU_TXBUF_14_ADDRESS                                                 (0x1038 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_14_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_14_RESET                                                   0x0

// 0x103c (TXPCU_TXBUF_15)
#define TXPCU_TXBUF_DATA_15_LSB                                                0
#define TXPCU_TXBUF_DATA_15_MSB                                                31
#define TXPCU_TXBUF_DATA_15_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_15_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_15_MASK) >> TXPCU_TXBUF_DATA_15_LSB)
#define TXPCU_TXBUF_DATA_15_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_15_LSB) & TXPCU_TXBUF_DATA_15_MASK)
#define TXPCU_TXBUF_DATA_15_RESET                                              0x0
#define TXPCU_TXBUF_15_ADDRESS                                                 (0x103c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_15_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_15_RESET                                                   0x0

// 0x1040 (TXPCU_TXBUF_16)
#define TXPCU_TXBUF_DATA_16_LSB                                                0
#define TXPCU_TXBUF_DATA_16_MSB                                                31
#define TXPCU_TXBUF_DATA_16_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_16_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_16_MASK) >> TXPCU_TXBUF_DATA_16_LSB)
#define TXPCU_TXBUF_DATA_16_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_16_LSB) & TXPCU_TXBUF_DATA_16_MASK)
#define TXPCU_TXBUF_DATA_16_RESET                                              0x0
#define TXPCU_TXBUF_16_ADDRESS                                                 (0x1040 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_16_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_16_RESET                                                   0x0

// 0x1044 (TXPCU_TXBUF_17)
#define TXPCU_TXBUF_DATA_17_LSB                                                0
#define TXPCU_TXBUF_DATA_17_MSB                                                31
#define TXPCU_TXBUF_DATA_17_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_17_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_17_MASK) >> TXPCU_TXBUF_DATA_17_LSB)
#define TXPCU_TXBUF_DATA_17_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_17_LSB) & TXPCU_TXBUF_DATA_17_MASK)
#define TXPCU_TXBUF_DATA_17_RESET                                              0x0
#define TXPCU_TXBUF_17_ADDRESS                                                 (0x1044 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_17_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_17_RESET                                                   0x0

// 0x1048 (TXPCU_TXBUF_18)
#define TXPCU_TXBUF_DATA_18_LSB                                                0
#define TXPCU_TXBUF_DATA_18_MSB                                                31
#define TXPCU_TXBUF_DATA_18_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_18_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_18_MASK) >> TXPCU_TXBUF_DATA_18_LSB)
#define TXPCU_TXBUF_DATA_18_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_18_LSB) & TXPCU_TXBUF_DATA_18_MASK)
#define TXPCU_TXBUF_DATA_18_RESET                                              0x0
#define TXPCU_TXBUF_18_ADDRESS                                                 (0x1048 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_18_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_18_RESET                                                   0x0

// 0x104c (TXPCU_TXBUF_19)
#define TXPCU_TXBUF_DATA_19_LSB                                                0
#define TXPCU_TXBUF_DATA_19_MSB                                                31
#define TXPCU_TXBUF_DATA_19_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_19_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_19_MASK) >> TXPCU_TXBUF_DATA_19_LSB)
#define TXPCU_TXBUF_DATA_19_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_19_LSB) & TXPCU_TXBUF_DATA_19_MASK)
#define TXPCU_TXBUF_DATA_19_RESET                                              0x0
#define TXPCU_TXBUF_19_ADDRESS                                                 (0x104c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_19_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_19_RESET                                                   0x0

// 0x1050 (TXPCU_TXBUF_20)
#define TXPCU_TXBUF_DATA_20_LSB                                                0
#define TXPCU_TXBUF_DATA_20_MSB                                                31
#define TXPCU_TXBUF_DATA_20_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_20_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_20_MASK) >> TXPCU_TXBUF_DATA_20_LSB)
#define TXPCU_TXBUF_DATA_20_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_20_LSB) & TXPCU_TXBUF_DATA_20_MASK)
#define TXPCU_TXBUF_DATA_20_RESET                                              0x0
#define TXPCU_TXBUF_20_ADDRESS                                                 (0x1050 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_20_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_20_RESET                                                   0x0

// 0x1054 (TXPCU_TXBUF_21)
#define TXPCU_TXBUF_DATA_21_LSB                                                0
#define TXPCU_TXBUF_DATA_21_MSB                                                31
#define TXPCU_TXBUF_DATA_21_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_21_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_21_MASK) >> TXPCU_TXBUF_DATA_21_LSB)
#define TXPCU_TXBUF_DATA_21_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_21_LSB) & TXPCU_TXBUF_DATA_21_MASK)
#define TXPCU_TXBUF_DATA_21_RESET                                              0x0
#define TXPCU_TXBUF_21_ADDRESS                                                 (0x1054 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_21_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_21_RESET                                                   0x0

// 0x1058 (TXPCU_TXBUF_22)
#define TXPCU_TXBUF_DATA_22_LSB                                                0
#define TXPCU_TXBUF_DATA_22_MSB                                                31
#define TXPCU_TXBUF_DATA_22_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_22_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_22_MASK) >> TXPCU_TXBUF_DATA_22_LSB)
#define TXPCU_TXBUF_DATA_22_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_22_LSB) & TXPCU_TXBUF_DATA_22_MASK)
#define TXPCU_TXBUF_DATA_22_RESET                                              0x0
#define TXPCU_TXBUF_22_ADDRESS                                                 (0x1058 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_22_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_22_RESET                                                   0x0

// 0x105c (TXPCU_TXBUF_23)
#define TXPCU_TXBUF_DATA_23_LSB                                                0
#define TXPCU_TXBUF_DATA_23_MSB                                                31
#define TXPCU_TXBUF_DATA_23_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_23_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_23_MASK) >> TXPCU_TXBUF_DATA_23_LSB)
#define TXPCU_TXBUF_DATA_23_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_23_LSB) & TXPCU_TXBUF_DATA_23_MASK)
#define TXPCU_TXBUF_DATA_23_RESET                                              0x0
#define TXPCU_TXBUF_23_ADDRESS                                                 (0x105c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_23_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_23_RESET                                                   0x0

// 0x1060 (TXPCU_TXBUF_24)
#define TXPCU_TXBUF_DATA_24_LSB                                                0
#define TXPCU_TXBUF_DATA_24_MSB                                                31
#define TXPCU_TXBUF_DATA_24_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_24_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_24_MASK) >> TXPCU_TXBUF_DATA_24_LSB)
#define TXPCU_TXBUF_DATA_24_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_24_LSB) & TXPCU_TXBUF_DATA_24_MASK)
#define TXPCU_TXBUF_DATA_24_RESET                                              0x0
#define TXPCU_TXBUF_24_ADDRESS                                                 (0x1060 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_24_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_24_RESET                                                   0x0

// 0x1064 (TXPCU_TXBUF_25)
#define TXPCU_TXBUF_DATA_25_LSB                                                0
#define TXPCU_TXBUF_DATA_25_MSB                                                31
#define TXPCU_TXBUF_DATA_25_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_25_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_25_MASK) >> TXPCU_TXBUF_DATA_25_LSB)
#define TXPCU_TXBUF_DATA_25_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_25_LSB) & TXPCU_TXBUF_DATA_25_MASK)
#define TXPCU_TXBUF_DATA_25_RESET                                              0x0
#define TXPCU_TXBUF_25_ADDRESS                                                 (0x1064 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_25_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_25_RESET                                                   0x0

// 0x1068 (TXPCU_TXBUF_26)
#define TXPCU_TXBUF_DATA_26_LSB                                                0
#define TXPCU_TXBUF_DATA_26_MSB                                                31
#define TXPCU_TXBUF_DATA_26_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_26_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_26_MASK) >> TXPCU_TXBUF_DATA_26_LSB)
#define TXPCU_TXBUF_DATA_26_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_26_LSB) & TXPCU_TXBUF_DATA_26_MASK)
#define TXPCU_TXBUF_DATA_26_RESET                                              0x0
#define TXPCU_TXBUF_26_ADDRESS                                                 (0x1068 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_26_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_26_RESET                                                   0x0

// 0x106c (TXPCU_TXBUF_27)
#define TXPCU_TXBUF_DATA_27_LSB                                                0
#define TXPCU_TXBUF_DATA_27_MSB                                                31
#define TXPCU_TXBUF_DATA_27_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_27_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_27_MASK) >> TXPCU_TXBUF_DATA_27_LSB)
#define TXPCU_TXBUF_DATA_27_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_27_LSB) & TXPCU_TXBUF_DATA_27_MASK)
#define TXPCU_TXBUF_DATA_27_RESET                                              0x0
#define TXPCU_TXBUF_27_ADDRESS                                                 (0x106c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_27_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_27_RESET                                                   0x0

// 0x1070 (TXPCU_TXBUF_28)
#define TXPCU_TXBUF_DATA_28_LSB                                                0
#define TXPCU_TXBUF_DATA_28_MSB                                                31
#define TXPCU_TXBUF_DATA_28_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_28_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_28_MASK) >> TXPCU_TXBUF_DATA_28_LSB)
#define TXPCU_TXBUF_DATA_28_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_28_LSB) & TXPCU_TXBUF_DATA_28_MASK)
#define TXPCU_TXBUF_DATA_28_RESET                                              0x0
#define TXPCU_TXBUF_28_ADDRESS                                                 (0x1070 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_28_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_28_RESET                                                   0x0

// 0x1074 (TXPCU_TXBUF_29)
#define TXPCU_TXBUF_DATA_29_LSB                                                0
#define TXPCU_TXBUF_DATA_29_MSB                                                31
#define TXPCU_TXBUF_DATA_29_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_29_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_29_MASK) >> TXPCU_TXBUF_DATA_29_LSB)
#define TXPCU_TXBUF_DATA_29_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_29_LSB) & TXPCU_TXBUF_DATA_29_MASK)
#define TXPCU_TXBUF_DATA_29_RESET                                              0x0
#define TXPCU_TXBUF_29_ADDRESS                                                 (0x1074 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_29_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_29_RESET                                                   0x0

// 0x1078 (TXPCU_TXBUF_30)
#define TXPCU_TXBUF_DATA_30_LSB                                                0
#define TXPCU_TXBUF_DATA_30_MSB                                                31
#define TXPCU_TXBUF_DATA_30_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_30_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_30_MASK) >> TXPCU_TXBUF_DATA_30_LSB)
#define TXPCU_TXBUF_DATA_30_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_30_LSB) & TXPCU_TXBUF_DATA_30_MASK)
#define TXPCU_TXBUF_DATA_30_RESET                                              0x0
#define TXPCU_TXBUF_30_ADDRESS                                                 (0x1078 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_30_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_30_RESET                                                   0x0

// 0x107c (TXPCU_TXBUF_31)
#define TXPCU_TXBUF_DATA_31_LSB                                                0
#define TXPCU_TXBUF_DATA_31_MSB                                                31
#define TXPCU_TXBUF_DATA_31_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_31_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_31_MASK) >> TXPCU_TXBUF_DATA_31_LSB)
#define TXPCU_TXBUF_DATA_31_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_31_LSB) & TXPCU_TXBUF_DATA_31_MASK)
#define TXPCU_TXBUF_DATA_31_RESET                                              0x0
#define TXPCU_TXBUF_31_ADDRESS                                                 (0x107c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_31_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_31_RESET                                                   0x0

// 0x1080 (TXPCU_TXBUF_32)
#define TXPCU_TXBUF_DATA_32_LSB                                                0
#define TXPCU_TXBUF_DATA_32_MSB                                                31
#define TXPCU_TXBUF_DATA_32_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_32_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_32_MASK) >> TXPCU_TXBUF_DATA_32_LSB)
#define TXPCU_TXBUF_DATA_32_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_32_LSB) & TXPCU_TXBUF_DATA_32_MASK)
#define TXPCU_TXBUF_DATA_32_RESET                                              0x0
#define TXPCU_TXBUF_32_ADDRESS                                                 (0x1080 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_32_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_32_RESET                                                   0x0

// 0x1084 (TXPCU_TXBUF_33)
#define TXPCU_TXBUF_DATA_33_LSB                                                0
#define TXPCU_TXBUF_DATA_33_MSB                                                31
#define TXPCU_TXBUF_DATA_33_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_33_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_33_MASK) >> TXPCU_TXBUF_DATA_33_LSB)
#define TXPCU_TXBUF_DATA_33_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_33_LSB) & TXPCU_TXBUF_DATA_33_MASK)
#define TXPCU_TXBUF_DATA_33_RESET                                              0x0
#define TXPCU_TXBUF_33_ADDRESS                                                 (0x1084 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_33_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_33_RESET                                                   0x0

// 0x1088 (TXPCU_TXBUF_34)
#define TXPCU_TXBUF_DATA_34_LSB                                                0
#define TXPCU_TXBUF_DATA_34_MSB                                                31
#define TXPCU_TXBUF_DATA_34_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_34_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_34_MASK) >> TXPCU_TXBUF_DATA_34_LSB)
#define TXPCU_TXBUF_DATA_34_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_34_LSB) & TXPCU_TXBUF_DATA_34_MASK)
#define TXPCU_TXBUF_DATA_34_RESET                                              0x0
#define TXPCU_TXBUF_34_ADDRESS                                                 (0x1088 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_34_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_34_RESET                                                   0x0

// 0x108c (TXPCU_TXBUF_35)
#define TXPCU_TXBUF_DATA_35_LSB                                                0
#define TXPCU_TXBUF_DATA_35_MSB                                                31
#define TXPCU_TXBUF_DATA_35_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_35_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_35_MASK) >> TXPCU_TXBUF_DATA_35_LSB)
#define TXPCU_TXBUF_DATA_35_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_35_LSB) & TXPCU_TXBUF_DATA_35_MASK)
#define TXPCU_TXBUF_DATA_35_RESET                                              0x0
#define TXPCU_TXBUF_35_ADDRESS                                                 (0x108c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_35_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_35_RESET                                                   0x0

// 0x1090 (TXPCU_TXBUF_36)
#define TXPCU_TXBUF_DATA_36_LSB                                                0
#define TXPCU_TXBUF_DATA_36_MSB                                                31
#define TXPCU_TXBUF_DATA_36_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_36_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_36_MASK) >> TXPCU_TXBUF_DATA_36_LSB)
#define TXPCU_TXBUF_DATA_36_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_36_LSB) & TXPCU_TXBUF_DATA_36_MASK)
#define TXPCU_TXBUF_DATA_36_RESET                                              0x0
#define TXPCU_TXBUF_36_ADDRESS                                                 (0x1090 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_36_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_36_RESET                                                   0x0

// 0x1094 (TXPCU_TXBUF_37)
#define TXPCU_TXBUF_DATA_37_LSB                                                0
#define TXPCU_TXBUF_DATA_37_MSB                                                31
#define TXPCU_TXBUF_DATA_37_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_37_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_37_MASK) >> TXPCU_TXBUF_DATA_37_LSB)
#define TXPCU_TXBUF_DATA_37_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_37_LSB) & TXPCU_TXBUF_DATA_37_MASK)
#define TXPCU_TXBUF_DATA_37_RESET                                              0x0
#define TXPCU_TXBUF_37_ADDRESS                                                 (0x1094 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_37_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_37_RESET                                                   0x0

// 0x1098 (TXPCU_TXBUF_38)
#define TXPCU_TXBUF_DATA_38_LSB                                                0
#define TXPCU_TXBUF_DATA_38_MSB                                                31
#define TXPCU_TXBUF_DATA_38_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_38_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_38_MASK) >> TXPCU_TXBUF_DATA_38_LSB)
#define TXPCU_TXBUF_DATA_38_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_38_LSB) & TXPCU_TXBUF_DATA_38_MASK)
#define TXPCU_TXBUF_DATA_38_RESET                                              0x0
#define TXPCU_TXBUF_38_ADDRESS                                                 (0x1098 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_38_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_38_RESET                                                   0x0

// 0x109c (TXPCU_TXBUF_39)
#define TXPCU_TXBUF_DATA_39_LSB                                                0
#define TXPCU_TXBUF_DATA_39_MSB                                                31
#define TXPCU_TXBUF_DATA_39_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_39_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_39_MASK) >> TXPCU_TXBUF_DATA_39_LSB)
#define TXPCU_TXBUF_DATA_39_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_39_LSB) & TXPCU_TXBUF_DATA_39_MASK)
#define TXPCU_TXBUF_DATA_39_RESET                                              0x0
#define TXPCU_TXBUF_39_ADDRESS                                                 (0x109c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_39_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_39_RESET                                                   0x0

// 0x10a0 (TXPCU_TXBUF_40)
#define TXPCU_TXBUF_DATA_40_LSB                                                0
#define TXPCU_TXBUF_DATA_40_MSB                                                31
#define TXPCU_TXBUF_DATA_40_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_40_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_40_MASK) >> TXPCU_TXBUF_DATA_40_LSB)
#define TXPCU_TXBUF_DATA_40_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_40_LSB) & TXPCU_TXBUF_DATA_40_MASK)
#define TXPCU_TXBUF_DATA_40_RESET                                              0x0
#define TXPCU_TXBUF_40_ADDRESS                                                 (0x10a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_40_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_40_RESET                                                   0x0

// 0x10a4 (TXPCU_TXBUF_41)
#define TXPCU_TXBUF_DATA_41_LSB                                                0
#define TXPCU_TXBUF_DATA_41_MSB                                                31
#define TXPCU_TXBUF_DATA_41_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_41_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_41_MASK) >> TXPCU_TXBUF_DATA_41_LSB)
#define TXPCU_TXBUF_DATA_41_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_41_LSB) & TXPCU_TXBUF_DATA_41_MASK)
#define TXPCU_TXBUF_DATA_41_RESET                                              0x0
#define TXPCU_TXBUF_41_ADDRESS                                                 (0x10a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_41_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_41_RESET                                                   0x0

// 0x10a8 (TXPCU_TXBUF_42)
#define TXPCU_TXBUF_DATA_42_LSB                                                0
#define TXPCU_TXBUF_DATA_42_MSB                                                31
#define TXPCU_TXBUF_DATA_42_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_42_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_42_MASK) >> TXPCU_TXBUF_DATA_42_LSB)
#define TXPCU_TXBUF_DATA_42_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_42_LSB) & TXPCU_TXBUF_DATA_42_MASK)
#define TXPCU_TXBUF_DATA_42_RESET                                              0x0
#define TXPCU_TXBUF_42_ADDRESS                                                 (0x10a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_42_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_42_RESET                                                   0x0

// 0x10ac (TXPCU_TXBUF_43)
#define TXPCU_TXBUF_DATA_43_LSB                                                0
#define TXPCU_TXBUF_DATA_43_MSB                                                31
#define TXPCU_TXBUF_DATA_43_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_43_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_43_MASK) >> TXPCU_TXBUF_DATA_43_LSB)
#define TXPCU_TXBUF_DATA_43_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_43_LSB) & TXPCU_TXBUF_DATA_43_MASK)
#define TXPCU_TXBUF_DATA_43_RESET                                              0x0
#define TXPCU_TXBUF_43_ADDRESS                                                 (0x10ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_43_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_43_RESET                                                   0x0

// 0x10b0 (TXPCU_TXBUF_44)
#define TXPCU_TXBUF_DATA_44_LSB                                                0
#define TXPCU_TXBUF_DATA_44_MSB                                                31
#define TXPCU_TXBUF_DATA_44_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_44_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_44_MASK) >> TXPCU_TXBUF_DATA_44_LSB)
#define TXPCU_TXBUF_DATA_44_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_44_LSB) & TXPCU_TXBUF_DATA_44_MASK)
#define TXPCU_TXBUF_DATA_44_RESET                                              0x0
#define TXPCU_TXBUF_44_ADDRESS                                                 (0x10b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_44_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_44_RESET                                                   0x0

// 0x10b4 (TXPCU_TXBUF_45)
#define TXPCU_TXBUF_DATA_45_LSB                                                0
#define TXPCU_TXBUF_DATA_45_MSB                                                31
#define TXPCU_TXBUF_DATA_45_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_45_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_45_MASK) >> TXPCU_TXBUF_DATA_45_LSB)
#define TXPCU_TXBUF_DATA_45_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_45_LSB) & TXPCU_TXBUF_DATA_45_MASK)
#define TXPCU_TXBUF_DATA_45_RESET                                              0x0
#define TXPCU_TXBUF_45_ADDRESS                                                 (0x10b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_45_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_45_RESET                                                   0x0

// 0x10b8 (TXPCU_TXBUF_46)
#define TXPCU_TXBUF_DATA_46_LSB                                                0
#define TXPCU_TXBUF_DATA_46_MSB                                                31
#define TXPCU_TXBUF_DATA_46_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_46_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_46_MASK) >> TXPCU_TXBUF_DATA_46_LSB)
#define TXPCU_TXBUF_DATA_46_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_46_LSB) & TXPCU_TXBUF_DATA_46_MASK)
#define TXPCU_TXBUF_DATA_46_RESET                                              0x0
#define TXPCU_TXBUF_46_ADDRESS                                                 (0x10b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_46_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_46_RESET                                                   0x0

// 0x10bc (TXPCU_TXBUF_47)
#define TXPCU_TXBUF_DATA_47_LSB                                                0
#define TXPCU_TXBUF_DATA_47_MSB                                                31
#define TXPCU_TXBUF_DATA_47_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_47_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_47_MASK) >> TXPCU_TXBUF_DATA_47_LSB)
#define TXPCU_TXBUF_DATA_47_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_47_LSB) & TXPCU_TXBUF_DATA_47_MASK)
#define TXPCU_TXBUF_DATA_47_RESET                                              0x0
#define TXPCU_TXBUF_47_ADDRESS                                                 (0x10bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_47_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_47_RESET                                                   0x0

// 0x10c0 (TXPCU_TXBUF_48)
#define TXPCU_TXBUF_DATA_48_LSB                                                0
#define TXPCU_TXBUF_DATA_48_MSB                                                31
#define TXPCU_TXBUF_DATA_48_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_48_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_48_MASK) >> TXPCU_TXBUF_DATA_48_LSB)
#define TXPCU_TXBUF_DATA_48_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_48_LSB) & TXPCU_TXBUF_DATA_48_MASK)
#define TXPCU_TXBUF_DATA_48_RESET                                              0x0
#define TXPCU_TXBUF_48_ADDRESS                                                 (0x10c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_48_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_48_RESET                                                   0x0

// 0x10c4 (TXPCU_TXBUF_49)
#define TXPCU_TXBUF_DATA_49_LSB                                                0
#define TXPCU_TXBUF_DATA_49_MSB                                                31
#define TXPCU_TXBUF_DATA_49_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_49_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_49_MASK) >> TXPCU_TXBUF_DATA_49_LSB)
#define TXPCU_TXBUF_DATA_49_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_49_LSB) & TXPCU_TXBUF_DATA_49_MASK)
#define TXPCU_TXBUF_DATA_49_RESET                                              0x0
#define TXPCU_TXBUF_49_ADDRESS                                                 (0x10c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_49_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_49_RESET                                                   0x0

// 0x10c8 (TXPCU_TXBUF_50)
#define TXPCU_TXBUF_DATA_50_LSB                                                0
#define TXPCU_TXBUF_DATA_50_MSB                                                31
#define TXPCU_TXBUF_DATA_50_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_50_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_50_MASK) >> TXPCU_TXBUF_DATA_50_LSB)
#define TXPCU_TXBUF_DATA_50_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_50_LSB) & TXPCU_TXBUF_DATA_50_MASK)
#define TXPCU_TXBUF_DATA_50_RESET                                              0x0
#define TXPCU_TXBUF_50_ADDRESS                                                 (0x10c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_50_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_50_RESET                                                   0x0

// 0x10cc (TXPCU_TXBUF_51)
#define TXPCU_TXBUF_DATA_51_LSB                                                0
#define TXPCU_TXBUF_DATA_51_MSB                                                31
#define TXPCU_TXBUF_DATA_51_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_51_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_51_MASK) >> TXPCU_TXBUF_DATA_51_LSB)
#define TXPCU_TXBUF_DATA_51_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_51_LSB) & TXPCU_TXBUF_DATA_51_MASK)
#define TXPCU_TXBUF_DATA_51_RESET                                              0x0
#define TXPCU_TXBUF_51_ADDRESS                                                 (0x10cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_51_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_51_RESET                                                   0x0

// 0x10d0 (TXPCU_TXBUF_52)
#define TXPCU_TXBUF_DATA_52_LSB                                                0
#define TXPCU_TXBUF_DATA_52_MSB                                                31
#define TXPCU_TXBUF_DATA_52_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_52_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_52_MASK) >> TXPCU_TXBUF_DATA_52_LSB)
#define TXPCU_TXBUF_DATA_52_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_52_LSB) & TXPCU_TXBUF_DATA_52_MASK)
#define TXPCU_TXBUF_DATA_52_RESET                                              0x0
#define TXPCU_TXBUF_52_ADDRESS                                                 (0x10d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_52_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_52_RESET                                                   0x0

// 0x10d4 (TXPCU_TXBUF_53)
#define TXPCU_TXBUF_DATA_53_LSB                                                0
#define TXPCU_TXBUF_DATA_53_MSB                                                31
#define TXPCU_TXBUF_DATA_53_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_53_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_53_MASK) >> TXPCU_TXBUF_DATA_53_LSB)
#define TXPCU_TXBUF_DATA_53_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_53_LSB) & TXPCU_TXBUF_DATA_53_MASK)
#define TXPCU_TXBUF_DATA_53_RESET                                              0x0
#define TXPCU_TXBUF_53_ADDRESS                                                 (0x10d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_53_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_53_RESET                                                   0x0

// 0x10d8 (TXPCU_TXBUF_54)
#define TXPCU_TXBUF_DATA_54_LSB                                                0
#define TXPCU_TXBUF_DATA_54_MSB                                                31
#define TXPCU_TXBUF_DATA_54_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_54_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_54_MASK) >> TXPCU_TXBUF_DATA_54_LSB)
#define TXPCU_TXBUF_DATA_54_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_54_LSB) & TXPCU_TXBUF_DATA_54_MASK)
#define TXPCU_TXBUF_DATA_54_RESET                                              0x0
#define TXPCU_TXBUF_54_ADDRESS                                                 (0x10d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_54_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_54_RESET                                                   0x0

// 0x10dc (TXPCU_TXBUF_55)
#define TXPCU_TXBUF_DATA_55_LSB                                                0
#define TXPCU_TXBUF_DATA_55_MSB                                                31
#define TXPCU_TXBUF_DATA_55_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_55_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_55_MASK) >> TXPCU_TXBUF_DATA_55_LSB)
#define TXPCU_TXBUF_DATA_55_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_55_LSB) & TXPCU_TXBUF_DATA_55_MASK)
#define TXPCU_TXBUF_DATA_55_RESET                                              0x0
#define TXPCU_TXBUF_55_ADDRESS                                                 (0x10dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_55_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_55_RESET                                                   0x0

// 0x10e0 (TXPCU_TXBUF_56)
#define TXPCU_TXBUF_DATA_56_LSB                                                0
#define TXPCU_TXBUF_DATA_56_MSB                                                31
#define TXPCU_TXBUF_DATA_56_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_56_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_56_MASK) >> TXPCU_TXBUF_DATA_56_LSB)
#define TXPCU_TXBUF_DATA_56_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_56_LSB) & TXPCU_TXBUF_DATA_56_MASK)
#define TXPCU_TXBUF_DATA_56_RESET                                              0x0
#define TXPCU_TXBUF_56_ADDRESS                                                 (0x10e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_56_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_56_RESET                                                   0x0

// 0x10e4 (TXPCU_TXBUF_57)
#define TXPCU_TXBUF_DATA_57_LSB                                                0
#define TXPCU_TXBUF_DATA_57_MSB                                                31
#define TXPCU_TXBUF_DATA_57_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_57_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_57_MASK) >> TXPCU_TXBUF_DATA_57_LSB)
#define TXPCU_TXBUF_DATA_57_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_57_LSB) & TXPCU_TXBUF_DATA_57_MASK)
#define TXPCU_TXBUF_DATA_57_RESET                                              0x0
#define TXPCU_TXBUF_57_ADDRESS                                                 (0x10e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_57_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_57_RESET                                                   0x0

// 0x10e8 (TXPCU_TXBUF_58)
#define TXPCU_TXBUF_DATA_58_LSB                                                0
#define TXPCU_TXBUF_DATA_58_MSB                                                31
#define TXPCU_TXBUF_DATA_58_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_58_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_58_MASK) >> TXPCU_TXBUF_DATA_58_LSB)
#define TXPCU_TXBUF_DATA_58_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_58_LSB) & TXPCU_TXBUF_DATA_58_MASK)
#define TXPCU_TXBUF_DATA_58_RESET                                              0x0
#define TXPCU_TXBUF_58_ADDRESS                                                 (0x10e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_58_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_58_RESET                                                   0x0

// 0x10ec (TXPCU_TXBUF_59)
#define TXPCU_TXBUF_DATA_59_LSB                                                0
#define TXPCU_TXBUF_DATA_59_MSB                                                31
#define TXPCU_TXBUF_DATA_59_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_59_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_59_MASK) >> TXPCU_TXBUF_DATA_59_LSB)
#define TXPCU_TXBUF_DATA_59_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_59_LSB) & TXPCU_TXBUF_DATA_59_MASK)
#define TXPCU_TXBUF_DATA_59_RESET                                              0x0
#define TXPCU_TXBUF_59_ADDRESS                                                 (0x10ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_59_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_59_RESET                                                   0x0

// 0x10f0 (TXPCU_TXBUF_60)
#define TXPCU_TXBUF_DATA_60_LSB                                                0
#define TXPCU_TXBUF_DATA_60_MSB                                                31
#define TXPCU_TXBUF_DATA_60_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_60_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_60_MASK) >> TXPCU_TXBUF_DATA_60_LSB)
#define TXPCU_TXBUF_DATA_60_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_60_LSB) & TXPCU_TXBUF_DATA_60_MASK)
#define TXPCU_TXBUF_DATA_60_RESET                                              0x0
#define TXPCU_TXBUF_60_ADDRESS                                                 (0x10f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_60_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_60_RESET                                                   0x0

// 0x10f4 (TXPCU_TXBUF_61)
#define TXPCU_TXBUF_DATA_61_LSB                                                0
#define TXPCU_TXBUF_DATA_61_MSB                                                31
#define TXPCU_TXBUF_DATA_61_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_61_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_61_MASK) >> TXPCU_TXBUF_DATA_61_LSB)
#define TXPCU_TXBUF_DATA_61_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_61_LSB) & TXPCU_TXBUF_DATA_61_MASK)
#define TXPCU_TXBUF_DATA_61_RESET                                              0x0
#define TXPCU_TXBUF_61_ADDRESS                                                 (0x10f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_61_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_61_RESET                                                   0x0

// 0x10f8 (TXPCU_TXBUF_62)
#define TXPCU_TXBUF_DATA_62_LSB                                                0
#define TXPCU_TXBUF_DATA_62_MSB                                                31
#define TXPCU_TXBUF_DATA_62_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_62_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_62_MASK) >> TXPCU_TXBUF_DATA_62_LSB)
#define TXPCU_TXBUF_DATA_62_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_62_LSB) & TXPCU_TXBUF_DATA_62_MASK)
#define TXPCU_TXBUF_DATA_62_RESET                                              0x0
#define TXPCU_TXBUF_62_ADDRESS                                                 (0x10f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_62_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_62_RESET                                                   0x0

// 0x10fc (TXPCU_TXBUF_63)
#define TXPCU_TXBUF_DATA_63_LSB                                                0
#define TXPCU_TXBUF_DATA_63_MSB                                                31
#define TXPCU_TXBUF_DATA_63_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_63_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_63_MASK) >> TXPCU_TXBUF_DATA_63_LSB)
#define TXPCU_TXBUF_DATA_63_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_63_LSB) & TXPCU_TXBUF_DATA_63_MASK)
#define TXPCU_TXBUF_DATA_63_RESET                                              0x0
#define TXPCU_TXBUF_63_ADDRESS                                                 (0x10fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_63_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_63_RESET                                                   0x0

// 0x1100 (TXPCU_TXBUF_64)
#define TXPCU_TXBUF_DATA_64_LSB                                                0
#define TXPCU_TXBUF_DATA_64_MSB                                                31
#define TXPCU_TXBUF_DATA_64_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_64_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_64_MASK) >> TXPCU_TXBUF_DATA_64_LSB)
#define TXPCU_TXBUF_DATA_64_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_64_LSB) & TXPCU_TXBUF_DATA_64_MASK)
#define TXPCU_TXBUF_DATA_64_RESET                                              0x0
#define TXPCU_TXBUF_64_ADDRESS                                                 (0x1100 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_64_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_64_RESET                                                   0x0

// 0x1104 (TXPCU_TXBUF_65)
#define TXPCU_TXBUF_DATA_65_LSB                                                0
#define TXPCU_TXBUF_DATA_65_MSB                                                31
#define TXPCU_TXBUF_DATA_65_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_65_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_65_MASK) >> TXPCU_TXBUF_DATA_65_LSB)
#define TXPCU_TXBUF_DATA_65_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_65_LSB) & TXPCU_TXBUF_DATA_65_MASK)
#define TXPCU_TXBUF_DATA_65_RESET                                              0x0
#define TXPCU_TXBUF_65_ADDRESS                                                 (0x1104 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_65_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_65_RESET                                                   0x0

// 0x1108 (TXPCU_TXBUF_66)
#define TXPCU_TXBUF_DATA_66_LSB                                                0
#define TXPCU_TXBUF_DATA_66_MSB                                                31
#define TXPCU_TXBUF_DATA_66_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_66_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_66_MASK) >> TXPCU_TXBUF_DATA_66_LSB)
#define TXPCU_TXBUF_DATA_66_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_66_LSB) & TXPCU_TXBUF_DATA_66_MASK)
#define TXPCU_TXBUF_DATA_66_RESET                                              0x0
#define TXPCU_TXBUF_66_ADDRESS                                                 (0x1108 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_66_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_66_RESET                                                   0x0

// 0x110c (TXPCU_TXBUF_67)
#define TXPCU_TXBUF_DATA_67_LSB                                                0
#define TXPCU_TXBUF_DATA_67_MSB                                                31
#define TXPCU_TXBUF_DATA_67_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_67_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_67_MASK) >> TXPCU_TXBUF_DATA_67_LSB)
#define TXPCU_TXBUF_DATA_67_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_67_LSB) & TXPCU_TXBUF_DATA_67_MASK)
#define TXPCU_TXBUF_DATA_67_RESET                                              0x0
#define TXPCU_TXBUF_67_ADDRESS                                                 (0x110c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_67_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_67_RESET                                                   0x0

// 0x1110 (TXPCU_TXBUF_68)
#define TXPCU_TXBUF_DATA_68_LSB                                                0
#define TXPCU_TXBUF_DATA_68_MSB                                                31
#define TXPCU_TXBUF_DATA_68_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_68_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_68_MASK) >> TXPCU_TXBUF_DATA_68_LSB)
#define TXPCU_TXBUF_DATA_68_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_68_LSB) & TXPCU_TXBUF_DATA_68_MASK)
#define TXPCU_TXBUF_DATA_68_RESET                                              0x0
#define TXPCU_TXBUF_68_ADDRESS                                                 (0x1110 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_68_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_68_RESET                                                   0x0

// 0x1114 (TXPCU_TXBUF_69)
#define TXPCU_TXBUF_DATA_69_LSB                                                0
#define TXPCU_TXBUF_DATA_69_MSB                                                31
#define TXPCU_TXBUF_DATA_69_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_69_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_69_MASK) >> TXPCU_TXBUF_DATA_69_LSB)
#define TXPCU_TXBUF_DATA_69_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_69_LSB) & TXPCU_TXBUF_DATA_69_MASK)
#define TXPCU_TXBUF_DATA_69_RESET                                              0x0
#define TXPCU_TXBUF_69_ADDRESS                                                 (0x1114 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_69_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_69_RESET                                                   0x0

// 0x1118 (TXPCU_TXBUF_70)
#define TXPCU_TXBUF_DATA_70_LSB                                                0
#define TXPCU_TXBUF_DATA_70_MSB                                                31
#define TXPCU_TXBUF_DATA_70_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_70_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_70_MASK) >> TXPCU_TXBUF_DATA_70_LSB)
#define TXPCU_TXBUF_DATA_70_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_70_LSB) & TXPCU_TXBUF_DATA_70_MASK)
#define TXPCU_TXBUF_DATA_70_RESET                                              0x0
#define TXPCU_TXBUF_70_ADDRESS                                                 (0x1118 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_70_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_70_RESET                                                   0x0

// 0x111c (TXPCU_TXBUF_71)
#define TXPCU_TXBUF_DATA_71_LSB                                                0
#define TXPCU_TXBUF_DATA_71_MSB                                                31
#define TXPCU_TXBUF_DATA_71_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_71_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_71_MASK) >> TXPCU_TXBUF_DATA_71_LSB)
#define TXPCU_TXBUF_DATA_71_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_71_LSB) & TXPCU_TXBUF_DATA_71_MASK)
#define TXPCU_TXBUF_DATA_71_RESET                                              0x0
#define TXPCU_TXBUF_71_ADDRESS                                                 (0x111c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_71_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_71_RESET                                                   0x0

// 0x1120 (TXPCU_TXBUF_72)
#define TXPCU_TXBUF_DATA_72_LSB                                                0
#define TXPCU_TXBUF_DATA_72_MSB                                                31
#define TXPCU_TXBUF_DATA_72_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_72_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_72_MASK) >> TXPCU_TXBUF_DATA_72_LSB)
#define TXPCU_TXBUF_DATA_72_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_72_LSB) & TXPCU_TXBUF_DATA_72_MASK)
#define TXPCU_TXBUF_DATA_72_RESET                                              0x0
#define TXPCU_TXBUF_72_ADDRESS                                                 (0x1120 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_72_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_72_RESET                                                   0x0

// 0x1124 (TXPCU_TXBUF_73)
#define TXPCU_TXBUF_DATA_73_LSB                                                0
#define TXPCU_TXBUF_DATA_73_MSB                                                31
#define TXPCU_TXBUF_DATA_73_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_73_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_73_MASK) >> TXPCU_TXBUF_DATA_73_LSB)
#define TXPCU_TXBUF_DATA_73_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_73_LSB) & TXPCU_TXBUF_DATA_73_MASK)
#define TXPCU_TXBUF_DATA_73_RESET                                              0x0
#define TXPCU_TXBUF_73_ADDRESS                                                 (0x1124 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_73_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_73_RESET                                                   0x0

// 0x1128 (TXPCU_TXBUF_74)
#define TXPCU_TXBUF_DATA_74_LSB                                                0
#define TXPCU_TXBUF_DATA_74_MSB                                                31
#define TXPCU_TXBUF_DATA_74_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_74_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_74_MASK) >> TXPCU_TXBUF_DATA_74_LSB)
#define TXPCU_TXBUF_DATA_74_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_74_LSB) & TXPCU_TXBUF_DATA_74_MASK)
#define TXPCU_TXBUF_DATA_74_RESET                                              0x0
#define TXPCU_TXBUF_74_ADDRESS                                                 (0x1128 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_74_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_74_RESET                                                   0x0

// 0x112c (TXPCU_TXBUF_75)
#define TXPCU_TXBUF_DATA_75_LSB                                                0
#define TXPCU_TXBUF_DATA_75_MSB                                                31
#define TXPCU_TXBUF_DATA_75_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_75_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_75_MASK) >> TXPCU_TXBUF_DATA_75_LSB)
#define TXPCU_TXBUF_DATA_75_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_75_LSB) & TXPCU_TXBUF_DATA_75_MASK)
#define TXPCU_TXBUF_DATA_75_RESET                                              0x0
#define TXPCU_TXBUF_75_ADDRESS                                                 (0x112c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_75_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_75_RESET                                                   0x0

// 0x1130 (TXPCU_TXBUF_76)
#define TXPCU_TXBUF_DATA_76_LSB                                                0
#define TXPCU_TXBUF_DATA_76_MSB                                                31
#define TXPCU_TXBUF_DATA_76_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_76_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_76_MASK) >> TXPCU_TXBUF_DATA_76_LSB)
#define TXPCU_TXBUF_DATA_76_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_76_LSB) & TXPCU_TXBUF_DATA_76_MASK)
#define TXPCU_TXBUF_DATA_76_RESET                                              0x0
#define TXPCU_TXBUF_76_ADDRESS                                                 (0x1130 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_76_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_76_RESET                                                   0x0

// 0x1134 (TXPCU_TXBUF_77)
#define TXPCU_TXBUF_DATA_77_LSB                                                0
#define TXPCU_TXBUF_DATA_77_MSB                                                31
#define TXPCU_TXBUF_DATA_77_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_77_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_77_MASK) >> TXPCU_TXBUF_DATA_77_LSB)
#define TXPCU_TXBUF_DATA_77_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_77_LSB) & TXPCU_TXBUF_DATA_77_MASK)
#define TXPCU_TXBUF_DATA_77_RESET                                              0x0
#define TXPCU_TXBUF_77_ADDRESS                                                 (0x1134 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_77_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_77_RESET                                                   0x0

// 0x1138 (TXPCU_TXBUF_78)
#define TXPCU_TXBUF_DATA_78_LSB                                                0
#define TXPCU_TXBUF_DATA_78_MSB                                                31
#define TXPCU_TXBUF_DATA_78_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_78_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_78_MASK) >> TXPCU_TXBUF_DATA_78_LSB)
#define TXPCU_TXBUF_DATA_78_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_78_LSB) & TXPCU_TXBUF_DATA_78_MASK)
#define TXPCU_TXBUF_DATA_78_RESET                                              0x0
#define TXPCU_TXBUF_78_ADDRESS                                                 (0x1138 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_78_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_78_RESET                                                   0x0

// 0x113c (TXPCU_TXBUF_79)
#define TXPCU_TXBUF_DATA_79_LSB                                                0
#define TXPCU_TXBUF_DATA_79_MSB                                                31
#define TXPCU_TXBUF_DATA_79_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_79_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_79_MASK) >> TXPCU_TXBUF_DATA_79_LSB)
#define TXPCU_TXBUF_DATA_79_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_79_LSB) & TXPCU_TXBUF_DATA_79_MASK)
#define TXPCU_TXBUF_DATA_79_RESET                                              0x0
#define TXPCU_TXBUF_79_ADDRESS                                                 (0x113c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_79_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_79_RESET                                                   0x0

// 0x1140 (TXPCU_TXBUF_80)
#define TXPCU_TXBUF_DATA_80_LSB                                                0
#define TXPCU_TXBUF_DATA_80_MSB                                                31
#define TXPCU_TXBUF_DATA_80_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_80_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_80_MASK) >> TXPCU_TXBUF_DATA_80_LSB)
#define TXPCU_TXBUF_DATA_80_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_80_LSB) & TXPCU_TXBUF_DATA_80_MASK)
#define TXPCU_TXBUF_DATA_80_RESET                                              0x0
#define TXPCU_TXBUF_80_ADDRESS                                                 (0x1140 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_80_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_80_RESET                                                   0x0

// 0x1144 (TXPCU_TXBUF_81)
#define TXPCU_TXBUF_DATA_81_LSB                                                0
#define TXPCU_TXBUF_DATA_81_MSB                                                31
#define TXPCU_TXBUF_DATA_81_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_81_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_81_MASK) >> TXPCU_TXBUF_DATA_81_LSB)
#define TXPCU_TXBUF_DATA_81_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_81_LSB) & TXPCU_TXBUF_DATA_81_MASK)
#define TXPCU_TXBUF_DATA_81_RESET                                              0x0
#define TXPCU_TXBUF_81_ADDRESS                                                 (0x1144 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_81_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_81_RESET                                                   0x0

// 0x1148 (TXPCU_TXBUF_82)
#define TXPCU_TXBUF_DATA_82_LSB                                                0
#define TXPCU_TXBUF_DATA_82_MSB                                                31
#define TXPCU_TXBUF_DATA_82_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_82_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_82_MASK) >> TXPCU_TXBUF_DATA_82_LSB)
#define TXPCU_TXBUF_DATA_82_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_82_LSB) & TXPCU_TXBUF_DATA_82_MASK)
#define TXPCU_TXBUF_DATA_82_RESET                                              0x0
#define TXPCU_TXBUF_82_ADDRESS                                                 (0x1148 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_82_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_82_RESET                                                   0x0

// 0x114c (TXPCU_TXBUF_83)
#define TXPCU_TXBUF_DATA_83_LSB                                                0
#define TXPCU_TXBUF_DATA_83_MSB                                                31
#define TXPCU_TXBUF_DATA_83_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_83_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_83_MASK) >> TXPCU_TXBUF_DATA_83_LSB)
#define TXPCU_TXBUF_DATA_83_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_83_LSB) & TXPCU_TXBUF_DATA_83_MASK)
#define TXPCU_TXBUF_DATA_83_RESET                                              0x0
#define TXPCU_TXBUF_83_ADDRESS                                                 (0x114c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_83_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_83_RESET                                                   0x0

// 0x1150 (TXPCU_TXBUF_84)
#define TXPCU_TXBUF_DATA_84_LSB                                                0
#define TXPCU_TXBUF_DATA_84_MSB                                                31
#define TXPCU_TXBUF_DATA_84_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_84_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_84_MASK) >> TXPCU_TXBUF_DATA_84_LSB)
#define TXPCU_TXBUF_DATA_84_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_84_LSB) & TXPCU_TXBUF_DATA_84_MASK)
#define TXPCU_TXBUF_DATA_84_RESET                                              0x0
#define TXPCU_TXBUF_84_ADDRESS                                                 (0x1150 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_84_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_84_RESET                                                   0x0

// 0x1154 (TXPCU_TXBUF_85)
#define TXPCU_TXBUF_DATA_85_LSB                                                0
#define TXPCU_TXBUF_DATA_85_MSB                                                31
#define TXPCU_TXBUF_DATA_85_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_85_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_85_MASK) >> TXPCU_TXBUF_DATA_85_LSB)
#define TXPCU_TXBUF_DATA_85_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_85_LSB) & TXPCU_TXBUF_DATA_85_MASK)
#define TXPCU_TXBUF_DATA_85_RESET                                              0x0
#define TXPCU_TXBUF_85_ADDRESS                                                 (0x1154 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_85_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_85_RESET                                                   0x0

// 0x1158 (TXPCU_TXBUF_86)
#define TXPCU_TXBUF_DATA_86_LSB                                                0
#define TXPCU_TXBUF_DATA_86_MSB                                                31
#define TXPCU_TXBUF_DATA_86_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_86_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_86_MASK) >> TXPCU_TXBUF_DATA_86_LSB)
#define TXPCU_TXBUF_DATA_86_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_86_LSB) & TXPCU_TXBUF_DATA_86_MASK)
#define TXPCU_TXBUF_DATA_86_RESET                                              0x0
#define TXPCU_TXBUF_86_ADDRESS                                                 (0x1158 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_86_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_86_RESET                                                   0x0

// 0x115c (TXPCU_TXBUF_87)
#define TXPCU_TXBUF_DATA_87_LSB                                                0
#define TXPCU_TXBUF_DATA_87_MSB                                                31
#define TXPCU_TXBUF_DATA_87_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_87_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_87_MASK) >> TXPCU_TXBUF_DATA_87_LSB)
#define TXPCU_TXBUF_DATA_87_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_87_LSB) & TXPCU_TXBUF_DATA_87_MASK)
#define TXPCU_TXBUF_DATA_87_RESET                                              0x0
#define TXPCU_TXBUF_87_ADDRESS                                                 (0x115c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_87_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_87_RESET                                                   0x0

// 0x1160 (TXPCU_TXBUF_88)
#define TXPCU_TXBUF_DATA_88_LSB                                                0
#define TXPCU_TXBUF_DATA_88_MSB                                                31
#define TXPCU_TXBUF_DATA_88_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_88_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_88_MASK) >> TXPCU_TXBUF_DATA_88_LSB)
#define TXPCU_TXBUF_DATA_88_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_88_LSB) & TXPCU_TXBUF_DATA_88_MASK)
#define TXPCU_TXBUF_DATA_88_RESET                                              0x0
#define TXPCU_TXBUF_88_ADDRESS                                                 (0x1160 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_88_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_88_RESET                                                   0x0

// 0x1164 (TXPCU_TXBUF_89)
#define TXPCU_TXBUF_DATA_89_LSB                                                0
#define TXPCU_TXBUF_DATA_89_MSB                                                31
#define TXPCU_TXBUF_DATA_89_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_89_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_89_MASK) >> TXPCU_TXBUF_DATA_89_LSB)
#define TXPCU_TXBUF_DATA_89_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_89_LSB) & TXPCU_TXBUF_DATA_89_MASK)
#define TXPCU_TXBUF_DATA_89_RESET                                              0x0
#define TXPCU_TXBUF_89_ADDRESS                                                 (0x1164 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_89_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_89_RESET                                                   0x0

// 0x1168 (TXPCU_TXBUF_90)
#define TXPCU_TXBUF_DATA_90_LSB                                                0
#define TXPCU_TXBUF_DATA_90_MSB                                                31
#define TXPCU_TXBUF_DATA_90_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_90_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_90_MASK) >> TXPCU_TXBUF_DATA_90_LSB)
#define TXPCU_TXBUF_DATA_90_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_90_LSB) & TXPCU_TXBUF_DATA_90_MASK)
#define TXPCU_TXBUF_DATA_90_RESET                                              0x0
#define TXPCU_TXBUF_90_ADDRESS                                                 (0x1168 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_90_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_90_RESET                                                   0x0

// 0x116c (TXPCU_TXBUF_91)
#define TXPCU_TXBUF_DATA_91_LSB                                                0
#define TXPCU_TXBUF_DATA_91_MSB                                                31
#define TXPCU_TXBUF_DATA_91_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_91_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_91_MASK) >> TXPCU_TXBUF_DATA_91_LSB)
#define TXPCU_TXBUF_DATA_91_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_91_LSB) & TXPCU_TXBUF_DATA_91_MASK)
#define TXPCU_TXBUF_DATA_91_RESET                                              0x0
#define TXPCU_TXBUF_91_ADDRESS                                                 (0x116c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_91_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_91_RESET                                                   0x0

// 0x1170 (TXPCU_TXBUF_92)
#define TXPCU_TXBUF_DATA_92_LSB                                                0
#define TXPCU_TXBUF_DATA_92_MSB                                                31
#define TXPCU_TXBUF_DATA_92_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_92_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_92_MASK) >> TXPCU_TXBUF_DATA_92_LSB)
#define TXPCU_TXBUF_DATA_92_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_92_LSB) & TXPCU_TXBUF_DATA_92_MASK)
#define TXPCU_TXBUF_DATA_92_RESET                                              0x0
#define TXPCU_TXBUF_92_ADDRESS                                                 (0x1170 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_92_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_92_RESET                                                   0x0

// 0x1174 (TXPCU_TXBUF_93)
#define TXPCU_TXBUF_DATA_93_LSB                                                0
#define TXPCU_TXBUF_DATA_93_MSB                                                31
#define TXPCU_TXBUF_DATA_93_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_93_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_93_MASK) >> TXPCU_TXBUF_DATA_93_LSB)
#define TXPCU_TXBUF_DATA_93_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_93_LSB) & TXPCU_TXBUF_DATA_93_MASK)
#define TXPCU_TXBUF_DATA_93_RESET                                              0x0
#define TXPCU_TXBUF_93_ADDRESS                                                 (0x1174 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_93_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_93_RESET                                                   0x0

// 0x1178 (TXPCU_TXBUF_94)
#define TXPCU_TXBUF_DATA_94_LSB                                                0
#define TXPCU_TXBUF_DATA_94_MSB                                                31
#define TXPCU_TXBUF_DATA_94_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_94_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_94_MASK) >> TXPCU_TXBUF_DATA_94_LSB)
#define TXPCU_TXBUF_DATA_94_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_94_LSB) & TXPCU_TXBUF_DATA_94_MASK)
#define TXPCU_TXBUF_DATA_94_RESET                                              0x0
#define TXPCU_TXBUF_94_ADDRESS                                                 (0x1178 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_94_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_94_RESET                                                   0x0

// 0x117c (TXPCU_TXBUF_95)
#define TXPCU_TXBUF_DATA_95_LSB                                                0
#define TXPCU_TXBUF_DATA_95_MSB                                                31
#define TXPCU_TXBUF_DATA_95_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_95_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_95_MASK) >> TXPCU_TXBUF_DATA_95_LSB)
#define TXPCU_TXBUF_DATA_95_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_95_LSB) & TXPCU_TXBUF_DATA_95_MASK)
#define TXPCU_TXBUF_DATA_95_RESET                                              0x0
#define TXPCU_TXBUF_95_ADDRESS                                                 (0x117c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_95_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_95_RESET                                                   0x0

// 0x1180 (TXPCU_TXBUF_96)
#define TXPCU_TXBUF_DATA_96_LSB                                                0
#define TXPCU_TXBUF_DATA_96_MSB                                                31
#define TXPCU_TXBUF_DATA_96_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_96_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_96_MASK) >> TXPCU_TXBUF_DATA_96_LSB)
#define TXPCU_TXBUF_DATA_96_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_96_LSB) & TXPCU_TXBUF_DATA_96_MASK)
#define TXPCU_TXBUF_DATA_96_RESET                                              0x0
#define TXPCU_TXBUF_96_ADDRESS                                                 (0x1180 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_96_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_96_RESET                                                   0x0

// 0x1184 (TXPCU_TXBUF_97)
#define TXPCU_TXBUF_DATA_97_LSB                                                0
#define TXPCU_TXBUF_DATA_97_MSB                                                31
#define TXPCU_TXBUF_DATA_97_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_97_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_97_MASK) >> TXPCU_TXBUF_DATA_97_LSB)
#define TXPCU_TXBUF_DATA_97_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_97_LSB) & TXPCU_TXBUF_DATA_97_MASK)
#define TXPCU_TXBUF_DATA_97_RESET                                              0x0
#define TXPCU_TXBUF_97_ADDRESS                                                 (0x1184 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_97_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_97_RESET                                                   0x0

// 0x1188 (TXPCU_TXBUF_98)
#define TXPCU_TXBUF_DATA_98_LSB                                                0
#define TXPCU_TXBUF_DATA_98_MSB                                                31
#define TXPCU_TXBUF_DATA_98_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_98_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_98_MASK) >> TXPCU_TXBUF_DATA_98_LSB)
#define TXPCU_TXBUF_DATA_98_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_98_LSB) & TXPCU_TXBUF_DATA_98_MASK)
#define TXPCU_TXBUF_DATA_98_RESET                                              0x0
#define TXPCU_TXBUF_98_ADDRESS                                                 (0x1188 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_98_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_98_RESET                                                   0x0

// 0x118c (TXPCU_TXBUF_99)
#define TXPCU_TXBUF_DATA_99_LSB                                                0
#define TXPCU_TXBUF_DATA_99_MSB                                                31
#define TXPCU_TXBUF_DATA_99_MASK                                               0xffffffff
#define TXPCU_TXBUF_DATA_99_GET(x)                                             (((x) & TXPCU_TXBUF_DATA_99_MASK) >> TXPCU_TXBUF_DATA_99_LSB)
#define TXPCU_TXBUF_DATA_99_SET(x)                                             (((0 | (x)) << TXPCU_TXBUF_DATA_99_LSB) & TXPCU_TXBUF_DATA_99_MASK)
#define TXPCU_TXBUF_DATA_99_RESET                                              0x0
#define TXPCU_TXBUF_99_ADDRESS                                                 (0x118c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_99_RSTMASK                                                 0xffffffff
#define TXPCU_TXBUF_99_RESET                                                   0x0

// 0x1190 (TXPCU_TXBUF_100)
#define TXPCU_TXBUF_DATA_100_LSB                                               0
#define TXPCU_TXBUF_DATA_100_MSB                                               31
#define TXPCU_TXBUF_DATA_100_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_100_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_100_MASK) >> TXPCU_TXBUF_DATA_100_LSB)
#define TXPCU_TXBUF_DATA_100_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_100_LSB) & TXPCU_TXBUF_DATA_100_MASK)
#define TXPCU_TXBUF_DATA_100_RESET                                             0x0
#define TXPCU_TXBUF_100_ADDRESS                                                (0x1190 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_100_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_100_RESET                                                  0x0

// 0x1194 (TXPCU_TXBUF_101)
#define TXPCU_TXBUF_DATA_101_LSB                                               0
#define TXPCU_TXBUF_DATA_101_MSB                                               31
#define TXPCU_TXBUF_DATA_101_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_101_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_101_MASK) >> TXPCU_TXBUF_DATA_101_LSB)
#define TXPCU_TXBUF_DATA_101_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_101_LSB) & TXPCU_TXBUF_DATA_101_MASK)
#define TXPCU_TXBUF_DATA_101_RESET                                             0x0
#define TXPCU_TXBUF_101_ADDRESS                                                (0x1194 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_101_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_101_RESET                                                  0x0

// 0x1198 (TXPCU_TXBUF_102)
#define TXPCU_TXBUF_DATA_102_LSB                                               0
#define TXPCU_TXBUF_DATA_102_MSB                                               31
#define TXPCU_TXBUF_DATA_102_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_102_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_102_MASK) >> TXPCU_TXBUF_DATA_102_LSB)
#define TXPCU_TXBUF_DATA_102_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_102_LSB) & TXPCU_TXBUF_DATA_102_MASK)
#define TXPCU_TXBUF_DATA_102_RESET                                             0x0
#define TXPCU_TXBUF_102_ADDRESS                                                (0x1198 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_102_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_102_RESET                                                  0x0

// 0x119c (TXPCU_TXBUF_103)
#define TXPCU_TXBUF_DATA_103_LSB                                               0
#define TXPCU_TXBUF_DATA_103_MSB                                               31
#define TXPCU_TXBUF_DATA_103_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_103_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_103_MASK) >> TXPCU_TXBUF_DATA_103_LSB)
#define TXPCU_TXBUF_DATA_103_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_103_LSB) & TXPCU_TXBUF_DATA_103_MASK)
#define TXPCU_TXBUF_DATA_103_RESET                                             0x0
#define TXPCU_TXBUF_103_ADDRESS                                                (0x119c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_103_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_103_RESET                                                  0x0

// 0x11a0 (TXPCU_TXBUF_104)
#define TXPCU_TXBUF_DATA_104_LSB                                               0
#define TXPCU_TXBUF_DATA_104_MSB                                               31
#define TXPCU_TXBUF_DATA_104_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_104_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_104_MASK) >> TXPCU_TXBUF_DATA_104_LSB)
#define TXPCU_TXBUF_DATA_104_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_104_LSB) & TXPCU_TXBUF_DATA_104_MASK)
#define TXPCU_TXBUF_DATA_104_RESET                                             0x0
#define TXPCU_TXBUF_104_ADDRESS                                                (0x11a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_104_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_104_RESET                                                  0x0

// 0x11a4 (TXPCU_TXBUF_105)
#define TXPCU_TXBUF_DATA_105_LSB                                               0
#define TXPCU_TXBUF_DATA_105_MSB                                               31
#define TXPCU_TXBUF_DATA_105_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_105_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_105_MASK) >> TXPCU_TXBUF_DATA_105_LSB)
#define TXPCU_TXBUF_DATA_105_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_105_LSB) & TXPCU_TXBUF_DATA_105_MASK)
#define TXPCU_TXBUF_DATA_105_RESET                                             0x0
#define TXPCU_TXBUF_105_ADDRESS                                                (0x11a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_105_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_105_RESET                                                  0x0

// 0x11a8 (TXPCU_TXBUF_106)
#define TXPCU_TXBUF_DATA_106_LSB                                               0
#define TXPCU_TXBUF_DATA_106_MSB                                               31
#define TXPCU_TXBUF_DATA_106_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_106_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_106_MASK) >> TXPCU_TXBUF_DATA_106_LSB)
#define TXPCU_TXBUF_DATA_106_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_106_LSB) & TXPCU_TXBUF_DATA_106_MASK)
#define TXPCU_TXBUF_DATA_106_RESET                                             0x0
#define TXPCU_TXBUF_106_ADDRESS                                                (0x11a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_106_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_106_RESET                                                  0x0

// 0x11ac (TXPCU_TXBUF_107)
#define TXPCU_TXBUF_DATA_107_LSB                                               0
#define TXPCU_TXBUF_DATA_107_MSB                                               31
#define TXPCU_TXBUF_DATA_107_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_107_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_107_MASK) >> TXPCU_TXBUF_DATA_107_LSB)
#define TXPCU_TXBUF_DATA_107_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_107_LSB) & TXPCU_TXBUF_DATA_107_MASK)
#define TXPCU_TXBUF_DATA_107_RESET                                             0x0
#define TXPCU_TXBUF_107_ADDRESS                                                (0x11ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_107_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_107_RESET                                                  0x0

// 0x11b0 (TXPCU_TXBUF_108)
#define TXPCU_TXBUF_DATA_108_LSB                                               0
#define TXPCU_TXBUF_DATA_108_MSB                                               31
#define TXPCU_TXBUF_DATA_108_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_108_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_108_MASK) >> TXPCU_TXBUF_DATA_108_LSB)
#define TXPCU_TXBUF_DATA_108_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_108_LSB) & TXPCU_TXBUF_DATA_108_MASK)
#define TXPCU_TXBUF_DATA_108_RESET                                             0x0
#define TXPCU_TXBUF_108_ADDRESS                                                (0x11b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_108_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_108_RESET                                                  0x0

// 0x11b4 (TXPCU_TXBUF_109)
#define TXPCU_TXBUF_DATA_109_LSB                                               0
#define TXPCU_TXBUF_DATA_109_MSB                                               31
#define TXPCU_TXBUF_DATA_109_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_109_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_109_MASK) >> TXPCU_TXBUF_DATA_109_LSB)
#define TXPCU_TXBUF_DATA_109_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_109_LSB) & TXPCU_TXBUF_DATA_109_MASK)
#define TXPCU_TXBUF_DATA_109_RESET                                             0x0
#define TXPCU_TXBUF_109_ADDRESS                                                (0x11b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_109_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_109_RESET                                                  0x0

// 0x11b8 (TXPCU_TXBUF_110)
#define TXPCU_TXBUF_DATA_110_LSB                                               0
#define TXPCU_TXBUF_DATA_110_MSB                                               31
#define TXPCU_TXBUF_DATA_110_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_110_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_110_MASK) >> TXPCU_TXBUF_DATA_110_LSB)
#define TXPCU_TXBUF_DATA_110_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_110_LSB) & TXPCU_TXBUF_DATA_110_MASK)
#define TXPCU_TXBUF_DATA_110_RESET                                             0x0
#define TXPCU_TXBUF_110_ADDRESS                                                (0x11b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_110_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_110_RESET                                                  0x0

// 0x11bc (TXPCU_TXBUF_111)
#define TXPCU_TXBUF_DATA_111_LSB                                               0
#define TXPCU_TXBUF_DATA_111_MSB                                               31
#define TXPCU_TXBUF_DATA_111_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_111_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_111_MASK) >> TXPCU_TXBUF_DATA_111_LSB)
#define TXPCU_TXBUF_DATA_111_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_111_LSB) & TXPCU_TXBUF_DATA_111_MASK)
#define TXPCU_TXBUF_DATA_111_RESET                                             0x0
#define TXPCU_TXBUF_111_ADDRESS                                                (0x11bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_111_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_111_RESET                                                  0x0

// 0x11c0 (TXPCU_TXBUF_112)
#define TXPCU_TXBUF_DATA_112_LSB                                               0
#define TXPCU_TXBUF_DATA_112_MSB                                               31
#define TXPCU_TXBUF_DATA_112_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_112_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_112_MASK) >> TXPCU_TXBUF_DATA_112_LSB)
#define TXPCU_TXBUF_DATA_112_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_112_LSB) & TXPCU_TXBUF_DATA_112_MASK)
#define TXPCU_TXBUF_DATA_112_RESET                                             0x0
#define TXPCU_TXBUF_112_ADDRESS                                                (0x11c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_112_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_112_RESET                                                  0x0

// 0x11c4 (TXPCU_TXBUF_113)
#define TXPCU_TXBUF_DATA_113_LSB                                               0
#define TXPCU_TXBUF_DATA_113_MSB                                               31
#define TXPCU_TXBUF_DATA_113_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_113_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_113_MASK) >> TXPCU_TXBUF_DATA_113_LSB)
#define TXPCU_TXBUF_DATA_113_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_113_LSB) & TXPCU_TXBUF_DATA_113_MASK)
#define TXPCU_TXBUF_DATA_113_RESET                                             0x0
#define TXPCU_TXBUF_113_ADDRESS                                                (0x11c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_113_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_113_RESET                                                  0x0

// 0x11c8 (TXPCU_TXBUF_114)
#define TXPCU_TXBUF_DATA_114_LSB                                               0
#define TXPCU_TXBUF_DATA_114_MSB                                               31
#define TXPCU_TXBUF_DATA_114_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_114_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_114_MASK) >> TXPCU_TXBUF_DATA_114_LSB)
#define TXPCU_TXBUF_DATA_114_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_114_LSB) & TXPCU_TXBUF_DATA_114_MASK)
#define TXPCU_TXBUF_DATA_114_RESET                                             0x0
#define TXPCU_TXBUF_114_ADDRESS                                                (0x11c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_114_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_114_RESET                                                  0x0

// 0x11cc (TXPCU_TXBUF_115)
#define TXPCU_TXBUF_DATA_115_LSB                                               0
#define TXPCU_TXBUF_DATA_115_MSB                                               31
#define TXPCU_TXBUF_DATA_115_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_115_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_115_MASK) >> TXPCU_TXBUF_DATA_115_LSB)
#define TXPCU_TXBUF_DATA_115_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_115_LSB) & TXPCU_TXBUF_DATA_115_MASK)
#define TXPCU_TXBUF_DATA_115_RESET                                             0x0
#define TXPCU_TXBUF_115_ADDRESS                                                (0x11cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_115_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_115_RESET                                                  0x0

// 0x11d0 (TXPCU_TXBUF_116)
#define TXPCU_TXBUF_DATA_116_LSB                                               0
#define TXPCU_TXBUF_DATA_116_MSB                                               31
#define TXPCU_TXBUF_DATA_116_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_116_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_116_MASK) >> TXPCU_TXBUF_DATA_116_LSB)
#define TXPCU_TXBUF_DATA_116_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_116_LSB) & TXPCU_TXBUF_DATA_116_MASK)
#define TXPCU_TXBUF_DATA_116_RESET                                             0x0
#define TXPCU_TXBUF_116_ADDRESS                                                (0x11d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_116_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_116_RESET                                                  0x0

// 0x11d4 (TXPCU_TXBUF_117)
#define TXPCU_TXBUF_DATA_117_LSB                                               0
#define TXPCU_TXBUF_DATA_117_MSB                                               31
#define TXPCU_TXBUF_DATA_117_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_117_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_117_MASK) >> TXPCU_TXBUF_DATA_117_LSB)
#define TXPCU_TXBUF_DATA_117_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_117_LSB) & TXPCU_TXBUF_DATA_117_MASK)
#define TXPCU_TXBUF_DATA_117_RESET                                             0x0
#define TXPCU_TXBUF_117_ADDRESS                                                (0x11d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_117_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_117_RESET                                                  0x0

// 0x11d8 (TXPCU_TXBUF_118)
#define TXPCU_TXBUF_DATA_118_LSB                                               0
#define TXPCU_TXBUF_DATA_118_MSB                                               31
#define TXPCU_TXBUF_DATA_118_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_118_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_118_MASK) >> TXPCU_TXBUF_DATA_118_LSB)
#define TXPCU_TXBUF_DATA_118_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_118_LSB) & TXPCU_TXBUF_DATA_118_MASK)
#define TXPCU_TXBUF_DATA_118_RESET                                             0x0
#define TXPCU_TXBUF_118_ADDRESS                                                (0x11d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_118_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_118_RESET                                                  0x0

// 0x11dc (TXPCU_TXBUF_119)
#define TXPCU_TXBUF_DATA_119_LSB                                               0
#define TXPCU_TXBUF_DATA_119_MSB                                               31
#define TXPCU_TXBUF_DATA_119_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_119_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_119_MASK) >> TXPCU_TXBUF_DATA_119_LSB)
#define TXPCU_TXBUF_DATA_119_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_119_LSB) & TXPCU_TXBUF_DATA_119_MASK)
#define TXPCU_TXBUF_DATA_119_RESET                                             0x0
#define TXPCU_TXBUF_119_ADDRESS                                                (0x11dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_119_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_119_RESET                                                  0x0

// 0x11e0 (TXPCU_TXBUF_120)
#define TXPCU_TXBUF_DATA_120_LSB                                               0
#define TXPCU_TXBUF_DATA_120_MSB                                               31
#define TXPCU_TXBUF_DATA_120_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_120_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_120_MASK) >> TXPCU_TXBUF_DATA_120_LSB)
#define TXPCU_TXBUF_DATA_120_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_120_LSB) & TXPCU_TXBUF_DATA_120_MASK)
#define TXPCU_TXBUF_DATA_120_RESET                                             0x0
#define TXPCU_TXBUF_120_ADDRESS                                                (0x11e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_120_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_120_RESET                                                  0x0

// 0x11e4 (TXPCU_TXBUF_121)
#define TXPCU_TXBUF_DATA_121_LSB                                               0
#define TXPCU_TXBUF_DATA_121_MSB                                               31
#define TXPCU_TXBUF_DATA_121_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_121_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_121_MASK) >> TXPCU_TXBUF_DATA_121_LSB)
#define TXPCU_TXBUF_DATA_121_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_121_LSB) & TXPCU_TXBUF_DATA_121_MASK)
#define TXPCU_TXBUF_DATA_121_RESET                                             0x0
#define TXPCU_TXBUF_121_ADDRESS                                                (0x11e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_121_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_121_RESET                                                  0x0

// 0x11e8 (TXPCU_TXBUF_122)
#define TXPCU_TXBUF_DATA_122_LSB                                               0
#define TXPCU_TXBUF_DATA_122_MSB                                               31
#define TXPCU_TXBUF_DATA_122_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_122_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_122_MASK) >> TXPCU_TXBUF_DATA_122_LSB)
#define TXPCU_TXBUF_DATA_122_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_122_LSB) & TXPCU_TXBUF_DATA_122_MASK)
#define TXPCU_TXBUF_DATA_122_RESET                                             0x0
#define TXPCU_TXBUF_122_ADDRESS                                                (0x11e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_122_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_122_RESET                                                  0x0

// 0x11ec (TXPCU_TXBUF_123)
#define TXPCU_TXBUF_DATA_123_LSB                                               0
#define TXPCU_TXBUF_DATA_123_MSB                                               31
#define TXPCU_TXBUF_DATA_123_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_123_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_123_MASK) >> TXPCU_TXBUF_DATA_123_LSB)
#define TXPCU_TXBUF_DATA_123_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_123_LSB) & TXPCU_TXBUF_DATA_123_MASK)
#define TXPCU_TXBUF_DATA_123_RESET                                             0x0
#define TXPCU_TXBUF_123_ADDRESS                                                (0x11ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_123_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_123_RESET                                                  0x0

// 0x11f0 (TXPCU_TXBUF_124)
#define TXPCU_TXBUF_DATA_124_LSB                                               0
#define TXPCU_TXBUF_DATA_124_MSB                                               31
#define TXPCU_TXBUF_DATA_124_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_124_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_124_MASK) >> TXPCU_TXBUF_DATA_124_LSB)
#define TXPCU_TXBUF_DATA_124_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_124_LSB) & TXPCU_TXBUF_DATA_124_MASK)
#define TXPCU_TXBUF_DATA_124_RESET                                             0x0
#define TXPCU_TXBUF_124_ADDRESS                                                (0x11f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_124_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_124_RESET                                                  0x0

// 0x11f4 (TXPCU_TXBUF_125)
#define TXPCU_TXBUF_DATA_125_LSB                                               0
#define TXPCU_TXBUF_DATA_125_MSB                                               31
#define TXPCU_TXBUF_DATA_125_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_125_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_125_MASK) >> TXPCU_TXBUF_DATA_125_LSB)
#define TXPCU_TXBUF_DATA_125_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_125_LSB) & TXPCU_TXBUF_DATA_125_MASK)
#define TXPCU_TXBUF_DATA_125_RESET                                             0x0
#define TXPCU_TXBUF_125_ADDRESS                                                (0x11f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_125_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_125_RESET                                                  0x0

// 0x11f8 (TXPCU_TXBUF_126)
#define TXPCU_TXBUF_DATA_126_LSB                                               0
#define TXPCU_TXBUF_DATA_126_MSB                                               31
#define TXPCU_TXBUF_DATA_126_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_126_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_126_MASK) >> TXPCU_TXBUF_DATA_126_LSB)
#define TXPCU_TXBUF_DATA_126_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_126_LSB) & TXPCU_TXBUF_DATA_126_MASK)
#define TXPCU_TXBUF_DATA_126_RESET                                             0x0
#define TXPCU_TXBUF_126_ADDRESS                                                (0x11f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_126_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_126_RESET                                                  0x0

// 0x11fc (TXPCU_TXBUF_127)
#define TXPCU_TXBUF_DATA_127_LSB                                               0
#define TXPCU_TXBUF_DATA_127_MSB                                               31
#define TXPCU_TXBUF_DATA_127_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_127_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_127_MASK) >> TXPCU_TXBUF_DATA_127_LSB)
#define TXPCU_TXBUF_DATA_127_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_127_LSB) & TXPCU_TXBUF_DATA_127_MASK)
#define TXPCU_TXBUF_DATA_127_RESET                                             0x0
#define TXPCU_TXBUF_127_ADDRESS                                                (0x11fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_127_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_127_RESET                                                  0x0

// 0x1200 (TXPCU_TXBUF_128)
#define TXPCU_TXBUF_DATA_128_LSB                                               0
#define TXPCU_TXBUF_DATA_128_MSB                                               31
#define TXPCU_TXBUF_DATA_128_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_128_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_128_MASK) >> TXPCU_TXBUF_DATA_128_LSB)
#define TXPCU_TXBUF_DATA_128_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_128_LSB) & TXPCU_TXBUF_DATA_128_MASK)
#define TXPCU_TXBUF_DATA_128_RESET                                             0x0
#define TXPCU_TXBUF_128_ADDRESS                                                (0x1200 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_128_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_128_RESET                                                  0x0

// 0x1204 (TXPCU_TXBUF_129)
#define TXPCU_TXBUF_DATA_129_LSB                                               0
#define TXPCU_TXBUF_DATA_129_MSB                                               31
#define TXPCU_TXBUF_DATA_129_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_129_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_129_MASK) >> TXPCU_TXBUF_DATA_129_LSB)
#define TXPCU_TXBUF_DATA_129_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_129_LSB) & TXPCU_TXBUF_DATA_129_MASK)
#define TXPCU_TXBUF_DATA_129_RESET                                             0x0
#define TXPCU_TXBUF_129_ADDRESS                                                (0x1204 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_129_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_129_RESET                                                  0x0

// 0x1208 (TXPCU_TXBUF_130)
#define TXPCU_TXBUF_DATA_130_LSB                                               0
#define TXPCU_TXBUF_DATA_130_MSB                                               31
#define TXPCU_TXBUF_DATA_130_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_130_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_130_MASK) >> TXPCU_TXBUF_DATA_130_LSB)
#define TXPCU_TXBUF_DATA_130_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_130_LSB) & TXPCU_TXBUF_DATA_130_MASK)
#define TXPCU_TXBUF_DATA_130_RESET                                             0x0
#define TXPCU_TXBUF_130_ADDRESS                                                (0x1208 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_130_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_130_RESET                                                  0x0

// 0x120c (TXPCU_TXBUF_131)
#define TXPCU_TXBUF_DATA_131_LSB                                               0
#define TXPCU_TXBUF_DATA_131_MSB                                               31
#define TXPCU_TXBUF_DATA_131_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_131_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_131_MASK) >> TXPCU_TXBUF_DATA_131_LSB)
#define TXPCU_TXBUF_DATA_131_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_131_LSB) & TXPCU_TXBUF_DATA_131_MASK)
#define TXPCU_TXBUF_DATA_131_RESET                                             0x0
#define TXPCU_TXBUF_131_ADDRESS                                                (0x120c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_131_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_131_RESET                                                  0x0

// 0x1210 (TXPCU_TXBUF_132)
#define TXPCU_TXBUF_DATA_132_LSB                                               0
#define TXPCU_TXBUF_DATA_132_MSB                                               31
#define TXPCU_TXBUF_DATA_132_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_132_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_132_MASK) >> TXPCU_TXBUF_DATA_132_LSB)
#define TXPCU_TXBUF_DATA_132_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_132_LSB) & TXPCU_TXBUF_DATA_132_MASK)
#define TXPCU_TXBUF_DATA_132_RESET                                             0x0
#define TXPCU_TXBUF_132_ADDRESS                                                (0x1210 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_132_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_132_RESET                                                  0x0

// 0x1214 (TXPCU_TXBUF_133)
#define TXPCU_TXBUF_DATA_133_LSB                                               0
#define TXPCU_TXBUF_DATA_133_MSB                                               31
#define TXPCU_TXBUF_DATA_133_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_133_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_133_MASK) >> TXPCU_TXBUF_DATA_133_LSB)
#define TXPCU_TXBUF_DATA_133_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_133_LSB) & TXPCU_TXBUF_DATA_133_MASK)
#define TXPCU_TXBUF_DATA_133_RESET                                             0x0
#define TXPCU_TXBUF_133_ADDRESS                                                (0x1214 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_133_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_133_RESET                                                  0x0

// 0x1218 (TXPCU_TXBUF_134)
#define TXPCU_TXBUF_DATA_134_LSB                                               0
#define TXPCU_TXBUF_DATA_134_MSB                                               31
#define TXPCU_TXBUF_DATA_134_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_134_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_134_MASK) >> TXPCU_TXBUF_DATA_134_LSB)
#define TXPCU_TXBUF_DATA_134_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_134_LSB) & TXPCU_TXBUF_DATA_134_MASK)
#define TXPCU_TXBUF_DATA_134_RESET                                             0x0
#define TXPCU_TXBUF_134_ADDRESS                                                (0x1218 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_134_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_134_RESET                                                  0x0

// 0x121c (TXPCU_TXBUF_135)
#define TXPCU_TXBUF_DATA_135_LSB                                               0
#define TXPCU_TXBUF_DATA_135_MSB                                               31
#define TXPCU_TXBUF_DATA_135_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_135_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_135_MASK) >> TXPCU_TXBUF_DATA_135_LSB)
#define TXPCU_TXBUF_DATA_135_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_135_LSB) & TXPCU_TXBUF_DATA_135_MASK)
#define TXPCU_TXBUF_DATA_135_RESET                                             0x0
#define TXPCU_TXBUF_135_ADDRESS                                                (0x121c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_135_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_135_RESET                                                  0x0

// 0x1220 (TXPCU_TXBUF_136)
#define TXPCU_TXBUF_DATA_136_LSB                                               0
#define TXPCU_TXBUF_DATA_136_MSB                                               31
#define TXPCU_TXBUF_DATA_136_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_136_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_136_MASK) >> TXPCU_TXBUF_DATA_136_LSB)
#define TXPCU_TXBUF_DATA_136_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_136_LSB) & TXPCU_TXBUF_DATA_136_MASK)
#define TXPCU_TXBUF_DATA_136_RESET                                             0x0
#define TXPCU_TXBUF_136_ADDRESS                                                (0x1220 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_136_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_136_RESET                                                  0x0

// 0x1224 (TXPCU_TXBUF_137)
#define TXPCU_TXBUF_DATA_137_LSB                                               0
#define TXPCU_TXBUF_DATA_137_MSB                                               31
#define TXPCU_TXBUF_DATA_137_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_137_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_137_MASK) >> TXPCU_TXBUF_DATA_137_LSB)
#define TXPCU_TXBUF_DATA_137_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_137_LSB) & TXPCU_TXBUF_DATA_137_MASK)
#define TXPCU_TXBUF_DATA_137_RESET                                             0x0
#define TXPCU_TXBUF_137_ADDRESS                                                (0x1224 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_137_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_137_RESET                                                  0x0

// 0x1228 (TXPCU_TXBUF_138)
#define TXPCU_TXBUF_DATA_138_LSB                                               0
#define TXPCU_TXBUF_DATA_138_MSB                                               31
#define TXPCU_TXBUF_DATA_138_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_138_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_138_MASK) >> TXPCU_TXBUF_DATA_138_LSB)
#define TXPCU_TXBUF_DATA_138_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_138_LSB) & TXPCU_TXBUF_DATA_138_MASK)
#define TXPCU_TXBUF_DATA_138_RESET                                             0x0
#define TXPCU_TXBUF_138_ADDRESS                                                (0x1228 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_138_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_138_RESET                                                  0x0

// 0x122c (TXPCU_TXBUF_139)
#define TXPCU_TXBUF_DATA_139_LSB                                               0
#define TXPCU_TXBUF_DATA_139_MSB                                               31
#define TXPCU_TXBUF_DATA_139_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_139_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_139_MASK) >> TXPCU_TXBUF_DATA_139_LSB)
#define TXPCU_TXBUF_DATA_139_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_139_LSB) & TXPCU_TXBUF_DATA_139_MASK)
#define TXPCU_TXBUF_DATA_139_RESET                                             0x0
#define TXPCU_TXBUF_139_ADDRESS                                                (0x122c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_139_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_139_RESET                                                  0x0

// 0x1230 (TXPCU_TXBUF_140)
#define TXPCU_TXBUF_DATA_140_LSB                                               0
#define TXPCU_TXBUF_DATA_140_MSB                                               31
#define TXPCU_TXBUF_DATA_140_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_140_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_140_MASK) >> TXPCU_TXBUF_DATA_140_LSB)
#define TXPCU_TXBUF_DATA_140_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_140_LSB) & TXPCU_TXBUF_DATA_140_MASK)
#define TXPCU_TXBUF_DATA_140_RESET                                             0x0
#define TXPCU_TXBUF_140_ADDRESS                                                (0x1230 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_140_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_140_RESET                                                  0x0

// 0x1234 (TXPCU_TXBUF_141)
#define TXPCU_TXBUF_DATA_141_LSB                                               0
#define TXPCU_TXBUF_DATA_141_MSB                                               31
#define TXPCU_TXBUF_DATA_141_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_141_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_141_MASK) >> TXPCU_TXBUF_DATA_141_LSB)
#define TXPCU_TXBUF_DATA_141_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_141_LSB) & TXPCU_TXBUF_DATA_141_MASK)
#define TXPCU_TXBUF_DATA_141_RESET                                             0x0
#define TXPCU_TXBUF_141_ADDRESS                                                (0x1234 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_141_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_141_RESET                                                  0x0

// 0x1238 (TXPCU_TXBUF_142)
#define TXPCU_TXBUF_DATA_142_LSB                                               0
#define TXPCU_TXBUF_DATA_142_MSB                                               31
#define TXPCU_TXBUF_DATA_142_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_142_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_142_MASK) >> TXPCU_TXBUF_DATA_142_LSB)
#define TXPCU_TXBUF_DATA_142_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_142_LSB) & TXPCU_TXBUF_DATA_142_MASK)
#define TXPCU_TXBUF_DATA_142_RESET                                             0x0
#define TXPCU_TXBUF_142_ADDRESS                                                (0x1238 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_142_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_142_RESET                                                  0x0

// 0x123c (TXPCU_TXBUF_143)
#define TXPCU_TXBUF_DATA_143_LSB                                               0
#define TXPCU_TXBUF_DATA_143_MSB                                               31
#define TXPCU_TXBUF_DATA_143_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_143_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_143_MASK) >> TXPCU_TXBUF_DATA_143_LSB)
#define TXPCU_TXBUF_DATA_143_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_143_LSB) & TXPCU_TXBUF_DATA_143_MASK)
#define TXPCU_TXBUF_DATA_143_RESET                                             0x0
#define TXPCU_TXBUF_143_ADDRESS                                                (0x123c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_143_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_143_RESET                                                  0x0

// 0x1240 (TXPCU_TXBUF_144)
#define TXPCU_TXBUF_DATA_144_LSB                                               0
#define TXPCU_TXBUF_DATA_144_MSB                                               31
#define TXPCU_TXBUF_DATA_144_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_144_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_144_MASK) >> TXPCU_TXBUF_DATA_144_LSB)
#define TXPCU_TXBUF_DATA_144_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_144_LSB) & TXPCU_TXBUF_DATA_144_MASK)
#define TXPCU_TXBUF_DATA_144_RESET                                             0x0
#define TXPCU_TXBUF_144_ADDRESS                                                (0x1240 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_144_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_144_RESET                                                  0x0

// 0x1244 (TXPCU_TXBUF_145)
#define TXPCU_TXBUF_DATA_145_LSB                                               0
#define TXPCU_TXBUF_DATA_145_MSB                                               31
#define TXPCU_TXBUF_DATA_145_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_145_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_145_MASK) >> TXPCU_TXBUF_DATA_145_LSB)
#define TXPCU_TXBUF_DATA_145_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_145_LSB) & TXPCU_TXBUF_DATA_145_MASK)
#define TXPCU_TXBUF_DATA_145_RESET                                             0x0
#define TXPCU_TXBUF_145_ADDRESS                                                (0x1244 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_145_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_145_RESET                                                  0x0

// 0x1248 (TXPCU_TXBUF_146)
#define TXPCU_TXBUF_DATA_146_LSB                                               0
#define TXPCU_TXBUF_DATA_146_MSB                                               31
#define TXPCU_TXBUF_DATA_146_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_146_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_146_MASK) >> TXPCU_TXBUF_DATA_146_LSB)
#define TXPCU_TXBUF_DATA_146_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_146_LSB) & TXPCU_TXBUF_DATA_146_MASK)
#define TXPCU_TXBUF_DATA_146_RESET                                             0x0
#define TXPCU_TXBUF_146_ADDRESS                                                (0x1248 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_146_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_146_RESET                                                  0x0

// 0x124c (TXPCU_TXBUF_147)
#define TXPCU_TXBUF_DATA_147_LSB                                               0
#define TXPCU_TXBUF_DATA_147_MSB                                               31
#define TXPCU_TXBUF_DATA_147_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_147_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_147_MASK) >> TXPCU_TXBUF_DATA_147_LSB)
#define TXPCU_TXBUF_DATA_147_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_147_LSB) & TXPCU_TXBUF_DATA_147_MASK)
#define TXPCU_TXBUF_DATA_147_RESET                                             0x0
#define TXPCU_TXBUF_147_ADDRESS                                                (0x124c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_147_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_147_RESET                                                  0x0

// 0x1250 (TXPCU_TXBUF_148)
#define TXPCU_TXBUF_DATA_148_LSB                                               0
#define TXPCU_TXBUF_DATA_148_MSB                                               31
#define TXPCU_TXBUF_DATA_148_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_148_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_148_MASK) >> TXPCU_TXBUF_DATA_148_LSB)
#define TXPCU_TXBUF_DATA_148_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_148_LSB) & TXPCU_TXBUF_DATA_148_MASK)
#define TXPCU_TXBUF_DATA_148_RESET                                             0x0
#define TXPCU_TXBUF_148_ADDRESS                                                (0x1250 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_148_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_148_RESET                                                  0x0

// 0x1254 (TXPCU_TXBUF_149)
#define TXPCU_TXBUF_DATA_149_LSB                                               0
#define TXPCU_TXBUF_DATA_149_MSB                                               31
#define TXPCU_TXBUF_DATA_149_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_149_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_149_MASK) >> TXPCU_TXBUF_DATA_149_LSB)
#define TXPCU_TXBUF_DATA_149_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_149_LSB) & TXPCU_TXBUF_DATA_149_MASK)
#define TXPCU_TXBUF_DATA_149_RESET                                             0x0
#define TXPCU_TXBUF_149_ADDRESS                                                (0x1254 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_149_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_149_RESET                                                  0x0

// 0x1258 (TXPCU_TXBUF_150)
#define TXPCU_TXBUF_DATA_150_LSB                                               0
#define TXPCU_TXBUF_DATA_150_MSB                                               31
#define TXPCU_TXBUF_DATA_150_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_150_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_150_MASK) >> TXPCU_TXBUF_DATA_150_LSB)
#define TXPCU_TXBUF_DATA_150_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_150_LSB) & TXPCU_TXBUF_DATA_150_MASK)
#define TXPCU_TXBUF_DATA_150_RESET                                             0x0
#define TXPCU_TXBUF_150_ADDRESS                                                (0x1258 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_150_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_150_RESET                                                  0x0

// 0x125c (TXPCU_TXBUF_151)
#define TXPCU_TXBUF_DATA_151_LSB                                               0
#define TXPCU_TXBUF_DATA_151_MSB                                               31
#define TXPCU_TXBUF_DATA_151_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_151_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_151_MASK) >> TXPCU_TXBUF_DATA_151_LSB)
#define TXPCU_TXBUF_DATA_151_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_151_LSB) & TXPCU_TXBUF_DATA_151_MASK)
#define TXPCU_TXBUF_DATA_151_RESET                                             0x0
#define TXPCU_TXBUF_151_ADDRESS                                                (0x125c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_151_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_151_RESET                                                  0x0

// 0x1260 (TXPCU_TXBUF_152)
#define TXPCU_TXBUF_DATA_152_LSB                                               0
#define TXPCU_TXBUF_DATA_152_MSB                                               31
#define TXPCU_TXBUF_DATA_152_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_152_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_152_MASK) >> TXPCU_TXBUF_DATA_152_LSB)
#define TXPCU_TXBUF_DATA_152_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_152_LSB) & TXPCU_TXBUF_DATA_152_MASK)
#define TXPCU_TXBUF_DATA_152_RESET                                             0x0
#define TXPCU_TXBUF_152_ADDRESS                                                (0x1260 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_152_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_152_RESET                                                  0x0

// 0x1264 (TXPCU_TXBUF_153)
#define TXPCU_TXBUF_DATA_153_LSB                                               0
#define TXPCU_TXBUF_DATA_153_MSB                                               31
#define TXPCU_TXBUF_DATA_153_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_153_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_153_MASK) >> TXPCU_TXBUF_DATA_153_LSB)
#define TXPCU_TXBUF_DATA_153_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_153_LSB) & TXPCU_TXBUF_DATA_153_MASK)
#define TXPCU_TXBUF_DATA_153_RESET                                             0x0
#define TXPCU_TXBUF_153_ADDRESS                                                (0x1264 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_153_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_153_RESET                                                  0x0

// 0x1268 (TXPCU_TXBUF_154)
#define TXPCU_TXBUF_DATA_154_LSB                                               0
#define TXPCU_TXBUF_DATA_154_MSB                                               31
#define TXPCU_TXBUF_DATA_154_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_154_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_154_MASK) >> TXPCU_TXBUF_DATA_154_LSB)
#define TXPCU_TXBUF_DATA_154_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_154_LSB) & TXPCU_TXBUF_DATA_154_MASK)
#define TXPCU_TXBUF_DATA_154_RESET                                             0x0
#define TXPCU_TXBUF_154_ADDRESS                                                (0x1268 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_154_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_154_RESET                                                  0x0

// 0x126c (TXPCU_TXBUF_155)
#define TXPCU_TXBUF_DATA_155_LSB                                               0
#define TXPCU_TXBUF_DATA_155_MSB                                               31
#define TXPCU_TXBUF_DATA_155_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_155_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_155_MASK) >> TXPCU_TXBUF_DATA_155_LSB)
#define TXPCU_TXBUF_DATA_155_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_155_LSB) & TXPCU_TXBUF_DATA_155_MASK)
#define TXPCU_TXBUF_DATA_155_RESET                                             0x0
#define TXPCU_TXBUF_155_ADDRESS                                                (0x126c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_155_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_155_RESET                                                  0x0

// 0x1270 (TXPCU_TXBUF_156)
#define TXPCU_TXBUF_DATA_156_LSB                                               0
#define TXPCU_TXBUF_DATA_156_MSB                                               31
#define TXPCU_TXBUF_DATA_156_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_156_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_156_MASK) >> TXPCU_TXBUF_DATA_156_LSB)
#define TXPCU_TXBUF_DATA_156_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_156_LSB) & TXPCU_TXBUF_DATA_156_MASK)
#define TXPCU_TXBUF_DATA_156_RESET                                             0x0
#define TXPCU_TXBUF_156_ADDRESS                                                (0x1270 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_156_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_156_RESET                                                  0x0

// 0x1274 (TXPCU_TXBUF_157)
#define TXPCU_TXBUF_DATA_157_LSB                                               0
#define TXPCU_TXBUF_DATA_157_MSB                                               31
#define TXPCU_TXBUF_DATA_157_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_157_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_157_MASK) >> TXPCU_TXBUF_DATA_157_LSB)
#define TXPCU_TXBUF_DATA_157_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_157_LSB) & TXPCU_TXBUF_DATA_157_MASK)
#define TXPCU_TXBUF_DATA_157_RESET                                             0x0
#define TXPCU_TXBUF_157_ADDRESS                                                (0x1274 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_157_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_157_RESET                                                  0x0

// 0x1278 (TXPCU_TXBUF_158)
#define TXPCU_TXBUF_DATA_158_LSB                                               0
#define TXPCU_TXBUF_DATA_158_MSB                                               31
#define TXPCU_TXBUF_DATA_158_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_158_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_158_MASK) >> TXPCU_TXBUF_DATA_158_LSB)
#define TXPCU_TXBUF_DATA_158_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_158_LSB) & TXPCU_TXBUF_DATA_158_MASK)
#define TXPCU_TXBUF_DATA_158_RESET                                             0x0
#define TXPCU_TXBUF_158_ADDRESS                                                (0x1278 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_158_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_158_RESET                                                  0x0

// 0x127c (TXPCU_TXBUF_159)
#define TXPCU_TXBUF_DATA_159_LSB                                               0
#define TXPCU_TXBUF_DATA_159_MSB                                               31
#define TXPCU_TXBUF_DATA_159_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_159_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_159_MASK) >> TXPCU_TXBUF_DATA_159_LSB)
#define TXPCU_TXBUF_DATA_159_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_159_LSB) & TXPCU_TXBUF_DATA_159_MASK)
#define TXPCU_TXBUF_DATA_159_RESET                                             0x0
#define TXPCU_TXBUF_159_ADDRESS                                                (0x127c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_159_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_159_RESET                                                  0x0

// 0x1280 (TXPCU_TXBUF_160)
#define TXPCU_TXBUF_DATA_160_LSB                                               0
#define TXPCU_TXBUF_DATA_160_MSB                                               31
#define TXPCU_TXBUF_DATA_160_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_160_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_160_MASK) >> TXPCU_TXBUF_DATA_160_LSB)
#define TXPCU_TXBUF_DATA_160_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_160_LSB) & TXPCU_TXBUF_DATA_160_MASK)
#define TXPCU_TXBUF_DATA_160_RESET                                             0x0
#define TXPCU_TXBUF_160_ADDRESS                                                (0x1280 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_160_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_160_RESET                                                  0x0

// 0x1284 (TXPCU_TXBUF_161)
#define TXPCU_TXBUF_DATA_161_LSB                                               0
#define TXPCU_TXBUF_DATA_161_MSB                                               31
#define TXPCU_TXBUF_DATA_161_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_161_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_161_MASK) >> TXPCU_TXBUF_DATA_161_LSB)
#define TXPCU_TXBUF_DATA_161_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_161_LSB) & TXPCU_TXBUF_DATA_161_MASK)
#define TXPCU_TXBUF_DATA_161_RESET                                             0x0
#define TXPCU_TXBUF_161_ADDRESS                                                (0x1284 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_161_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_161_RESET                                                  0x0

// 0x1288 (TXPCU_TXBUF_162)
#define TXPCU_TXBUF_DATA_162_LSB                                               0
#define TXPCU_TXBUF_DATA_162_MSB                                               31
#define TXPCU_TXBUF_DATA_162_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_162_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_162_MASK) >> TXPCU_TXBUF_DATA_162_LSB)
#define TXPCU_TXBUF_DATA_162_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_162_LSB) & TXPCU_TXBUF_DATA_162_MASK)
#define TXPCU_TXBUF_DATA_162_RESET                                             0x0
#define TXPCU_TXBUF_162_ADDRESS                                                (0x1288 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_162_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_162_RESET                                                  0x0

// 0x128c (TXPCU_TXBUF_163)
#define TXPCU_TXBUF_DATA_163_LSB                                               0
#define TXPCU_TXBUF_DATA_163_MSB                                               31
#define TXPCU_TXBUF_DATA_163_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_163_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_163_MASK) >> TXPCU_TXBUF_DATA_163_LSB)
#define TXPCU_TXBUF_DATA_163_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_163_LSB) & TXPCU_TXBUF_DATA_163_MASK)
#define TXPCU_TXBUF_DATA_163_RESET                                             0x0
#define TXPCU_TXBUF_163_ADDRESS                                                (0x128c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_163_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_163_RESET                                                  0x0

// 0x1290 (TXPCU_TXBUF_164)
#define TXPCU_TXBUF_DATA_164_LSB                                               0
#define TXPCU_TXBUF_DATA_164_MSB                                               31
#define TXPCU_TXBUF_DATA_164_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_164_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_164_MASK) >> TXPCU_TXBUF_DATA_164_LSB)
#define TXPCU_TXBUF_DATA_164_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_164_LSB) & TXPCU_TXBUF_DATA_164_MASK)
#define TXPCU_TXBUF_DATA_164_RESET                                             0x0
#define TXPCU_TXBUF_164_ADDRESS                                                (0x1290 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_164_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_164_RESET                                                  0x0

// 0x1294 (TXPCU_TXBUF_165)
#define TXPCU_TXBUF_DATA_165_LSB                                               0
#define TXPCU_TXBUF_DATA_165_MSB                                               31
#define TXPCU_TXBUF_DATA_165_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_165_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_165_MASK) >> TXPCU_TXBUF_DATA_165_LSB)
#define TXPCU_TXBUF_DATA_165_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_165_LSB) & TXPCU_TXBUF_DATA_165_MASK)
#define TXPCU_TXBUF_DATA_165_RESET                                             0x0
#define TXPCU_TXBUF_165_ADDRESS                                                (0x1294 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_165_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_165_RESET                                                  0x0

// 0x1298 (TXPCU_TXBUF_166)
#define TXPCU_TXBUF_DATA_166_LSB                                               0
#define TXPCU_TXBUF_DATA_166_MSB                                               31
#define TXPCU_TXBUF_DATA_166_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_166_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_166_MASK) >> TXPCU_TXBUF_DATA_166_LSB)
#define TXPCU_TXBUF_DATA_166_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_166_LSB) & TXPCU_TXBUF_DATA_166_MASK)
#define TXPCU_TXBUF_DATA_166_RESET                                             0x0
#define TXPCU_TXBUF_166_ADDRESS                                                (0x1298 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_166_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_166_RESET                                                  0x0

// 0x129c (TXPCU_TXBUF_167)
#define TXPCU_TXBUF_DATA_167_LSB                                               0
#define TXPCU_TXBUF_DATA_167_MSB                                               31
#define TXPCU_TXBUF_DATA_167_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_167_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_167_MASK) >> TXPCU_TXBUF_DATA_167_LSB)
#define TXPCU_TXBUF_DATA_167_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_167_LSB) & TXPCU_TXBUF_DATA_167_MASK)
#define TXPCU_TXBUF_DATA_167_RESET                                             0x0
#define TXPCU_TXBUF_167_ADDRESS                                                (0x129c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_167_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_167_RESET                                                  0x0

// 0x12a0 (TXPCU_TXBUF_168)
#define TXPCU_TXBUF_DATA_168_LSB                                               0
#define TXPCU_TXBUF_DATA_168_MSB                                               31
#define TXPCU_TXBUF_DATA_168_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_168_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_168_MASK) >> TXPCU_TXBUF_DATA_168_LSB)
#define TXPCU_TXBUF_DATA_168_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_168_LSB) & TXPCU_TXBUF_DATA_168_MASK)
#define TXPCU_TXBUF_DATA_168_RESET                                             0x0
#define TXPCU_TXBUF_168_ADDRESS                                                (0x12a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_168_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_168_RESET                                                  0x0

// 0x12a4 (TXPCU_TXBUF_169)
#define TXPCU_TXBUF_DATA_169_LSB                                               0
#define TXPCU_TXBUF_DATA_169_MSB                                               31
#define TXPCU_TXBUF_DATA_169_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_169_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_169_MASK) >> TXPCU_TXBUF_DATA_169_LSB)
#define TXPCU_TXBUF_DATA_169_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_169_LSB) & TXPCU_TXBUF_DATA_169_MASK)
#define TXPCU_TXBUF_DATA_169_RESET                                             0x0
#define TXPCU_TXBUF_169_ADDRESS                                                (0x12a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_169_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_169_RESET                                                  0x0

// 0x12a8 (TXPCU_TXBUF_170)
#define TXPCU_TXBUF_DATA_170_LSB                                               0
#define TXPCU_TXBUF_DATA_170_MSB                                               31
#define TXPCU_TXBUF_DATA_170_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_170_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_170_MASK) >> TXPCU_TXBUF_DATA_170_LSB)
#define TXPCU_TXBUF_DATA_170_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_170_LSB) & TXPCU_TXBUF_DATA_170_MASK)
#define TXPCU_TXBUF_DATA_170_RESET                                             0x0
#define TXPCU_TXBUF_170_ADDRESS                                                (0x12a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_170_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_170_RESET                                                  0x0

// 0x12ac (TXPCU_TXBUF_171)
#define TXPCU_TXBUF_DATA_171_LSB                                               0
#define TXPCU_TXBUF_DATA_171_MSB                                               31
#define TXPCU_TXBUF_DATA_171_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_171_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_171_MASK) >> TXPCU_TXBUF_DATA_171_LSB)
#define TXPCU_TXBUF_DATA_171_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_171_LSB) & TXPCU_TXBUF_DATA_171_MASK)
#define TXPCU_TXBUF_DATA_171_RESET                                             0x0
#define TXPCU_TXBUF_171_ADDRESS                                                (0x12ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_171_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_171_RESET                                                  0x0

// 0x12b0 (TXPCU_TXBUF_172)
#define TXPCU_TXBUF_DATA_172_LSB                                               0
#define TXPCU_TXBUF_DATA_172_MSB                                               31
#define TXPCU_TXBUF_DATA_172_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_172_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_172_MASK) >> TXPCU_TXBUF_DATA_172_LSB)
#define TXPCU_TXBUF_DATA_172_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_172_LSB) & TXPCU_TXBUF_DATA_172_MASK)
#define TXPCU_TXBUF_DATA_172_RESET                                             0x0
#define TXPCU_TXBUF_172_ADDRESS                                                (0x12b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_172_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_172_RESET                                                  0x0

// 0x12b4 (TXPCU_TXBUF_173)
#define TXPCU_TXBUF_DATA_173_LSB                                               0
#define TXPCU_TXBUF_DATA_173_MSB                                               31
#define TXPCU_TXBUF_DATA_173_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_173_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_173_MASK) >> TXPCU_TXBUF_DATA_173_LSB)
#define TXPCU_TXBUF_DATA_173_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_173_LSB) & TXPCU_TXBUF_DATA_173_MASK)
#define TXPCU_TXBUF_DATA_173_RESET                                             0x0
#define TXPCU_TXBUF_173_ADDRESS                                                (0x12b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_173_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_173_RESET                                                  0x0

// 0x12b8 (TXPCU_TXBUF_174)
#define TXPCU_TXBUF_DATA_174_LSB                                               0
#define TXPCU_TXBUF_DATA_174_MSB                                               31
#define TXPCU_TXBUF_DATA_174_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_174_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_174_MASK) >> TXPCU_TXBUF_DATA_174_LSB)
#define TXPCU_TXBUF_DATA_174_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_174_LSB) & TXPCU_TXBUF_DATA_174_MASK)
#define TXPCU_TXBUF_DATA_174_RESET                                             0x0
#define TXPCU_TXBUF_174_ADDRESS                                                (0x12b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_174_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_174_RESET                                                  0x0

// 0x12bc (TXPCU_TXBUF_175)
#define TXPCU_TXBUF_DATA_175_LSB                                               0
#define TXPCU_TXBUF_DATA_175_MSB                                               31
#define TXPCU_TXBUF_DATA_175_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_175_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_175_MASK) >> TXPCU_TXBUF_DATA_175_LSB)
#define TXPCU_TXBUF_DATA_175_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_175_LSB) & TXPCU_TXBUF_DATA_175_MASK)
#define TXPCU_TXBUF_DATA_175_RESET                                             0x0
#define TXPCU_TXBUF_175_ADDRESS                                                (0x12bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_175_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_175_RESET                                                  0x0

// 0x12c0 (TXPCU_TXBUF_176)
#define TXPCU_TXBUF_DATA_176_LSB                                               0
#define TXPCU_TXBUF_DATA_176_MSB                                               31
#define TXPCU_TXBUF_DATA_176_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_176_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_176_MASK) >> TXPCU_TXBUF_DATA_176_LSB)
#define TXPCU_TXBUF_DATA_176_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_176_LSB) & TXPCU_TXBUF_DATA_176_MASK)
#define TXPCU_TXBUF_DATA_176_RESET                                             0x0
#define TXPCU_TXBUF_176_ADDRESS                                                (0x12c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_176_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_176_RESET                                                  0x0

// 0x12c4 (TXPCU_TXBUF_177)
#define TXPCU_TXBUF_DATA_177_LSB                                               0
#define TXPCU_TXBUF_DATA_177_MSB                                               31
#define TXPCU_TXBUF_DATA_177_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_177_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_177_MASK) >> TXPCU_TXBUF_DATA_177_LSB)
#define TXPCU_TXBUF_DATA_177_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_177_LSB) & TXPCU_TXBUF_DATA_177_MASK)
#define TXPCU_TXBUF_DATA_177_RESET                                             0x0
#define TXPCU_TXBUF_177_ADDRESS                                                (0x12c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_177_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_177_RESET                                                  0x0

// 0x12c8 (TXPCU_TXBUF_178)
#define TXPCU_TXBUF_DATA_178_LSB                                               0
#define TXPCU_TXBUF_DATA_178_MSB                                               31
#define TXPCU_TXBUF_DATA_178_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_178_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_178_MASK) >> TXPCU_TXBUF_DATA_178_LSB)
#define TXPCU_TXBUF_DATA_178_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_178_LSB) & TXPCU_TXBUF_DATA_178_MASK)
#define TXPCU_TXBUF_DATA_178_RESET                                             0x0
#define TXPCU_TXBUF_178_ADDRESS                                                (0x12c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_178_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_178_RESET                                                  0x0

// 0x12cc (TXPCU_TXBUF_179)
#define TXPCU_TXBUF_DATA_179_LSB                                               0
#define TXPCU_TXBUF_DATA_179_MSB                                               31
#define TXPCU_TXBUF_DATA_179_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_179_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_179_MASK) >> TXPCU_TXBUF_DATA_179_LSB)
#define TXPCU_TXBUF_DATA_179_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_179_LSB) & TXPCU_TXBUF_DATA_179_MASK)
#define TXPCU_TXBUF_DATA_179_RESET                                             0x0
#define TXPCU_TXBUF_179_ADDRESS                                                (0x12cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_179_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_179_RESET                                                  0x0

// 0x12d0 (TXPCU_TXBUF_180)
#define TXPCU_TXBUF_DATA_180_LSB                                               0
#define TXPCU_TXBUF_DATA_180_MSB                                               31
#define TXPCU_TXBUF_DATA_180_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_180_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_180_MASK) >> TXPCU_TXBUF_DATA_180_LSB)
#define TXPCU_TXBUF_DATA_180_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_180_LSB) & TXPCU_TXBUF_DATA_180_MASK)
#define TXPCU_TXBUF_DATA_180_RESET                                             0x0
#define TXPCU_TXBUF_180_ADDRESS                                                (0x12d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_180_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_180_RESET                                                  0x0

// 0x12d4 (TXPCU_TXBUF_181)
#define TXPCU_TXBUF_DATA_181_LSB                                               0
#define TXPCU_TXBUF_DATA_181_MSB                                               31
#define TXPCU_TXBUF_DATA_181_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_181_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_181_MASK) >> TXPCU_TXBUF_DATA_181_LSB)
#define TXPCU_TXBUF_DATA_181_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_181_LSB) & TXPCU_TXBUF_DATA_181_MASK)
#define TXPCU_TXBUF_DATA_181_RESET                                             0x0
#define TXPCU_TXBUF_181_ADDRESS                                                (0x12d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_181_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_181_RESET                                                  0x0

// 0x12d8 (TXPCU_TXBUF_182)
#define TXPCU_TXBUF_DATA_182_LSB                                               0
#define TXPCU_TXBUF_DATA_182_MSB                                               31
#define TXPCU_TXBUF_DATA_182_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_182_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_182_MASK) >> TXPCU_TXBUF_DATA_182_LSB)
#define TXPCU_TXBUF_DATA_182_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_182_LSB) & TXPCU_TXBUF_DATA_182_MASK)
#define TXPCU_TXBUF_DATA_182_RESET                                             0x0
#define TXPCU_TXBUF_182_ADDRESS                                                (0x12d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_182_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_182_RESET                                                  0x0

// 0x12dc (TXPCU_TXBUF_183)
#define TXPCU_TXBUF_DATA_183_LSB                                               0
#define TXPCU_TXBUF_DATA_183_MSB                                               31
#define TXPCU_TXBUF_DATA_183_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_183_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_183_MASK) >> TXPCU_TXBUF_DATA_183_LSB)
#define TXPCU_TXBUF_DATA_183_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_183_LSB) & TXPCU_TXBUF_DATA_183_MASK)
#define TXPCU_TXBUF_DATA_183_RESET                                             0x0
#define TXPCU_TXBUF_183_ADDRESS                                                (0x12dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_183_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_183_RESET                                                  0x0

// 0x12e0 (TXPCU_TXBUF_184)
#define TXPCU_TXBUF_DATA_184_LSB                                               0
#define TXPCU_TXBUF_DATA_184_MSB                                               31
#define TXPCU_TXBUF_DATA_184_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_184_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_184_MASK) >> TXPCU_TXBUF_DATA_184_LSB)
#define TXPCU_TXBUF_DATA_184_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_184_LSB) & TXPCU_TXBUF_DATA_184_MASK)
#define TXPCU_TXBUF_DATA_184_RESET                                             0x0
#define TXPCU_TXBUF_184_ADDRESS                                                (0x12e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_184_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_184_RESET                                                  0x0

// 0x12e4 (TXPCU_TXBUF_185)
#define TXPCU_TXBUF_DATA_185_LSB                                               0
#define TXPCU_TXBUF_DATA_185_MSB                                               31
#define TXPCU_TXBUF_DATA_185_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_185_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_185_MASK) >> TXPCU_TXBUF_DATA_185_LSB)
#define TXPCU_TXBUF_DATA_185_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_185_LSB) & TXPCU_TXBUF_DATA_185_MASK)
#define TXPCU_TXBUF_DATA_185_RESET                                             0x0
#define TXPCU_TXBUF_185_ADDRESS                                                (0x12e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_185_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_185_RESET                                                  0x0

// 0x12e8 (TXPCU_TXBUF_186)
#define TXPCU_TXBUF_DATA_186_LSB                                               0
#define TXPCU_TXBUF_DATA_186_MSB                                               31
#define TXPCU_TXBUF_DATA_186_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_186_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_186_MASK) >> TXPCU_TXBUF_DATA_186_LSB)
#define TXPCU_TXBUF_DATA_186_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_186_LSB) & TXPCU_TXBUF_DATA_186_MASK)
#define TXPCU_TXBUF_DATA_186_RESET                                             0x0
#define TXPCU_TXBUF_186_ADDRESS                                                (0x12e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_186_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_186_RESET                                                  0x0

// 0x12ec (TXPCU_TXBUF_187)
#define TXPCU_TXBUF_DATA_187_LSB                                               0
#define TXPCU_TXBUF_DATA_187_MSB                                               31
#define TXPCU_TXBUF_DATA_187_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_187_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_187_MASK) >> TXPCU_TXBUF_DATA_187_LSB)
#define TXPCU_TXBUF_DATA_187_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_187_LSB) & TXPCU_TXBUF_DATA_187_MASK)
#define TXPCU_TXBUF_DATA_187_RESET                                             0x0
#define TXPCU_TXBUF_187_ADDRESS                                                (0x12ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_187_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_187_RESET                                                  0x0

// 0x12f0 (TXPCU_TXBUF_188)
#define TXPCU_TXBUF_DATA_188_LSB                                               0
#define TXPCU_TXBUF_DATA_188_MSB                                               31
#define TXPCU_TXBUF_DATA_188_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_188_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_188_MASK) >> TXPCU_TXBUF_DATA_188_LSB)
#define TXPCU_TXBUF_DATA_188_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_188_LSB) & TXPCU_TXBUF_DATA_188_MASK)
#define TXPCU_TXBUF_DATA_188_RESET                                             0x0
#define TXPCU_TXBUF_188_ADDRESS                                                (0x12f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_188_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_188_RESET                                                  0x0

// 0x12f4 (TXPCU_TXBUF_189)
#define TXPCU_TXBUF_DATA_189_LSB                                               0
#define TXPCU_TXBUF_DATA_189_MSB                                               31
#define TXPCU_TXBUF_DATA_189_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_189_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_189_MASK) >> TXPCU_TXBUF_DATA_189_LSB)
#define TXPCU_TXBUF_DATA_189_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_189_LSB) & TXPCU_TXBUF_DATA_189_MASK)
#define TXPCU_TXBUF_DATA_189_RESET                                             0x0
#define TXPCU_TXBUF_189_ADDRESS                                                (0x12f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_189_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_189_RESET                                                  0x0

// 0x12f8 (TXPCU_TXBUF_190)
#define TXPCU_TXBUF_DATA_190_LSB                                               0
#define TXPCU_TXBUF_DATA_190_MSB                                               31
#define TXPCU_TXBUF_DATA_190_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_190_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_190_MASK) >> TXPCU_TXBUF_DATA_190_LSB)
#define TXPCU_TXBUF_DATA_190_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_190_LSB) & TXPCU_TXBUF_DATA_190_MASK)
#define TXPCU_TXBUF_DATA_190_RESET                                             0x0
#define TXPCU_TXBUF_190_ADDRESS                                                (0x12f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_190_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_190_RESET                                                  0x0

// 0x12fc (TXPCU_TXBUF_191)
#define TXPCU_TXBUF_DATA_191_LSB                                               0
#define TXPCU_TXBUF_DATA_191_MSB                                               31
#define TXPCU_TXBUF_DATA_191_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_191_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_191_MASK) >> TXPCU_TXBUF_DATA_191_LSB)
#define TXPCU_TXBUF_DATA_191_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_191_LSB) & TXPCU_TXBUF_DATA_191_MASK)
#define TXPCU_TXBUF_DATA_191_RESET                                             0x0
#define TXPCU_TXBUF_191_ADDRESS                                                (0x12fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_191_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_191_RESET                                                  0x0

// 0x1300 (TXPCU_TXBUF_192)
#define TXPCU_TXBUF_DATA_192_LSB                                               0
#define TXPCU_TXBUF_DATA_192_MSB                                               31
#define TXPCU_TXBUF_DATA_192_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_192_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_192_MASK) >> TXPCU_TXBUF_DATA_192_LSB)
#define TXPCU_TXBUF_DATA_192_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_192_LSB) & TXPCU_TXBUF_DATA_192_MASK)
#define TXPCU_TXBUF_DATA_192_RESET                                             0x0
#define TXPCU_TXBUF_192_ADDRESS                                                (0x1300 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_192_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_192_RESET                                                  0x0

// 0x1304 (TXPCU_TXBUF_193)
#define TXPCU_TXBUF_DATA_193_LSB                                               0
#define TXPCU_TXBUF_DATA_193_MSB                                               31
#define TXPCU_TXBUF_DATA_193_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_193_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_193_MASK) >> TXPCU_TXBUF_DATA_193_LSB)
#define TXPCU_TXBUF_DATA_193_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_193_LSB) & TXPCU_TXBUF_DATA_193_MASK)
#define TXPCU_TXBUF_DATA_193_RESET                                             0x0
#define TXPCU_TXBUF_193_ADDRESS                                                (0x1304 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_193_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_193_RESET                                                  0x0

// 0x1308 (TXPCU_TXBUF_194)
#define TXPCU_TXBUF_DATA_194_LSB                                               0
#define TXPCU_TXBUF_DATA_194_MSB                                               31
#define TXPCU_TXBUF_DATA_194_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_194_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_194_MASK) >> TXPCU_TXBUF_DATA_194_LSB)
#define TXPCU_TXBUF_DATA_194_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_194_LSB) & TXPCU_TXBUF_DATA_194_MASK)
#define TXPCU_TXBUF_DATA_194_RESET                                             0x0
#define TXPCU_TXBUF_194_ADDRESS                                                (0x1308 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_194_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_194_RESET                                                  0x0

// 0x130c (TXPCU_TXBUF_195)
#define TXPCU_TXBUF_DATA_195_LSB                                               0
#define TXPCU_TXBUF_DATA_195_MSB                                               31
#define TXPCU_TXBUF_DATA_195_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_195_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_195_MASK) >> TXPCU_TXBUF_DATA_195_LSB)
#define TXPCU_TXBUF_DATA_195_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_195_LSB) & TXPCU_TXBUF_DATA_195_MASK)
#define TXPCU_TXBUF_DATA_195_RESET                                             0x0
#define TXPCU_TXBUF_195_ADDRESS                                                (0x130c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_195_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_195_RESET                                                  0x0

// 0x1310 (TXPCU_TXBUF_196)
#define TXPCU_TXBUF_DATA_196_LSB                                               0
#define TXPCU_TXBUF_DATA_196_MSB                                               31
#define TXPCU_TXBUF_DATA_196_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_196_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_196_MASK) >> TXPCU_TXBUF_DATA_196_LSB)
#define TXPCU_TXBUF_DATA_196_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_196_LSB) & TXPCU_TXBUF_DATA_196_MASK)
#define TXPCU_TXBUF_DATA_196_RESET                                             0x0
#define TXPCU_TXBUF_196_ADDRESS                                                (0x1310 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_196_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_196_RESET                                                  0x0

// 0x1314 (TXPCU_TXBUF_197)
#define TXPCU_TXBUF_DATA_197_LSB                                               0
#define TXPCU_TXBUF_DATA_197_MSB                                               31
#define TXPCU_TXBUF_DATA_197_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_197_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_197_MASK) >> TXPCU_TXBUF_DATA_197_LSB)
#define TXPCU_TXBUF_DATA_197_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_197_LSB) & TXPCU_TXBUF_DATA_197_MASK)
#define TXPCU_TXBUF_DATA_197_RESET                                             0x0
#define TXPCU_TXBUF_197_ADDRESS                                                (0x1314 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_197_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_197_RESET                                                  0x0

// 0x1318 (TXPCU_TXBUF_198)
#define TXPCU_TXBUF_DATA_198_LSB                                               0
#define TXPCU_TXBUF_DATA_198_MSB                                               31
#define TXPCU_TXBUF_DATA_198_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_198_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_198_MASK) >> TXPCU_TXBUF_DATA_198_LSB)
#define TXPCU_TXBUF_DATA_198_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_198_LSB) & TXPCU_TXBUF_DATA_198_MASK)
#define TXPCU_TXBUF_DATA_198_RESET                                             0x0
#define TXPCU_TXBUF_198_ADDRESS                                                (0x1318 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_198_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_198_RESET                                                  0x0

// 0x131c (TXPCU_TXBUF_199)
#define TXPCU_TXBUF_DATA_199_LSB                                               0
#define TXPCU_TXBUF_DATA_199_MSB                                               31
#define TXPCU_TXBUF_DATA_199_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_199_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_199_MASK) >> TXPCU_TXBUF_DATA_199_LSB)
#define TXPCU_TXBUF_DATA_199_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_199_LSB) & TXPCU_TXBUF_DATA_199_MASK)
#define TXPCU_TXBUF_DATA_199_RESET                                             0x0
#define TXPCU_TXBUF_199_ADDRESS                                                (0x131c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_199_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_199_RESET                                                  0x0

// 0x1320 (TXPCU_TXBUF_200)
#define TXPCU_TXBUF_DATA_200_LSB                                               0
#define TXPCU_TXBUF_DATA_200_MSB                                               31
#define TXPCU_TXBUF_DATA_200_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_200_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_200_MASK) >> TXPCU_TXBUF_DATA_200_LSB)
#define TXPCU_TXBUF_DATA_200_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_200_LSB) & TXPCU_TXBUF_DATA_200_MASK)
#define TXPCU_TXBUF_DATA_200_RESET                                             0x0
#define TXPCU_TXBUF_200_ADDRESS                                                (0x1320 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_200_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_200_RESET                                                  0x0

// 0x1324 (TXPCU_TXBUF_201)
#define TXPCU_TXBUF_DATA_201_LSB                                               0
#define TXPCU_TXBUF_DATA_201_MSB                                               31
#define TXPCU_TXBUF_DATA_201_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_201_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_201_MASK) >> TXPCU_TXBUF_DATA_201_LSB)
#define TXPCU_TXBUF_DATA_201_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_201_LSB) & TXPCU_TXBUF_DATA_201_MASK)
#define TXPCU_TXBUF_DATA_201_RESET                                             0x0
#define TXPCU_TXBUF_201_ADDRESS                                                (0x1324 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_201_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_201_RESET                                                  0x0

// 0x1328 (TXPCU_TXBUF_202)
#define TXPCU_TXBUF_DATA_202_LSB                                               0
#define TXPCU_TXBUF_DATA_202_MSB                                               31
#define TXPCU_TXBUF_DATA_202_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_202_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_202_MASK) >> TXPCU_TXBUF_DATA_202_LSB)
#define TXPCU_TXBUF_DATA_202_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_202_LSB) & TXPCU_TXBUF_DATA_202_MASK)
#define TXPCU_TXBUF_DATA_202_RESET                                             0x0
#define TXPCU_TXBUF_202_ADDRESS                                                (0x1328 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_202_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_202_RESET                                                  0x0

// 0x132c (TXPCU_TXBUF_203)
#define TXPCU_TXBUF_DATA_203_LSB                                               0
#define TXPCU_TXBUF_DATA_203_MSB                                               31
#define TXPCU_TXBUF_DATA_203_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_203_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_203_MASK) >> TXPCU_TXBUF_DATA_203_LSB)
#define TXPCU_TXBUF_DATA_203_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_203_LSB) & TXPCU_TXBUF_DATA_203_MASK)
#define TXPCU_TXBUF_DATA_203_RESET                                             0x0
#define TXPCU_TXBUF_203_ADDRESS                                                (0x132c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_203_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_203_RESET                                                  0x0

// 0x1330 (TXPCU_TXBUF_204)
#define TXPCU_TXBUF_DATA_204_LSB                                               0
#define TXPCU_TXBUF_DATA_204_MSB                                               31
#define TXPCU_TXBUF_DATA_204_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_204_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_204_MASK) >> TXPCU_TXBUF_DATA_204_LSB)
#define TXPCU_TXBUF_DATA_204_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_204_LSB) & TXPCU_TXBUF_DATA_204_MASK)
#define TXPCU_TXBUF_DATA_204_RESET                                             0x0
#define TXPCU_TXBUF_204_ADDRESS                                                (0x1330 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_204_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_204_RESET                                                  0x0

// 0x1334 (TXPCU_TXBUF_205)
#define TXPCU_TXBUF_DATA_205_LSB                                               0
#define TXPCU_TXBUF_DATA_205_MSB                                               31
#define TXPCU_TXBUF_DATA_205_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_205_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_205_MASK) >> TXPCU_TXBUF_DATA_205_LSB)
#define TXPCU_TXBUF_DATA_205_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_205_LSB) & TXPCU_TXBUF_DATA_205_MASK)
#define TXPCU_TXBUF_DATA_205_RESET                                             0x0
#define TXPCU_TXBUF_205_ADDRESS                                                (0x1334 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_205_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_205_RESET                                                  0x0

// 0x1338 (TXPCU_TXBUF_206)
#define TXPCU_TXBUF_DATA_206_LSB                                               0
#define TXPCU_TXBUF_DATA_206_MSB                                               31
#define TXPCU_TXBUF_DATA_206_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_206_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_206_MASK) >> TXPCU_TXBUF_DATA_206_LSB)
#define TXPCU_TXBUF_DATA_206_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_206_LSB) & TXPCU_TXBUF_DATA_206_MASK)
#define TXPCU_TXBUF_DATA_206_RESET                                             0x0
#define TXPCU_TXBUF_206_ADDRESS                                                (0x1338 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_206_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_206_RESET                                                  0x0

// 0x133c (TXPCU_TXBUF_207)
#define TXPCU_TXBUF_DATA_207_LSB                                               0
#define TXPCU_TXBUF_DATA_207_MSB                                               31
#define TXPCU_TXBUF_DATA_207_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_207_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_207_MASK) >> TXPCU_TXBUF_DATA_207_LSB)
#define TXPCU_TXBUF_DATA_207_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_207_LSB) & TXPCU_TXBUF_DATA_207_MASK)
#define TXPCU_TXBUF_DATA_207_RESET                                             0x0
#define TXPCU_TXBUF_207_ADDRESS                                                (0x133c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_207_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_207_RESET                                                  0x0

// 0x1340 (TXPCU_TXBUF_208)
#define TXPCU_TXBUF_DATA_208_LSB                                               0
#define TXPCU_TXBUF_DATA_208_MSB                                               31
#define TXPCU_TXBUF_DATA_208_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_208_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_208_MASK) >> TXPCU_TXBUF_DATA_208_LSB)
#define TXPCU_TXBUF_DATA_208_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_208_LSB) & TXPCU_TXBUF_DATA_208_MASK)
#define TXPCU_TXBUF_DATA_208_RESET                                             0x0
#define TXPCU_TXBUF_208_ADDRESS                                                (0x1340 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_208_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_208_RESET                                                  0x0

// 0x1344 (TXPCU_TXBUF_209)
#define TXPCU_TXBUF_DATA_209_LSB                                               0
#define TXPCU_TXBUF_DATA_209_MSB                                               31
#define TXPCU_TXBUF_DATA_209_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_209_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_209_MASK) >> TXPCU_TXBUF_DATA_209_LSB)
#define TXPCU_TXBUF_DATA_209_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_209_LSB) & TXPCU_TXBUF_DATA_209_MASK)
#define TXPCU_TXBUF_DATA_209_RESET                                             0x0
#define TXPCU_TXBUF_209_ADDRESS                                                (0x1344 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_209_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_209_RESET                                                  0x0

// 0x1348 (TXPCU_TXBUF_210)
#define TXPCU_TXBUF_DATA_210_LSB                                               0
#define TXPCU_TXBUF_DATA_210_MSB                                               31
#define TXPCU_TXBUF_DATA_210_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_210_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_210_MASK) >> TXPCU_TXBUF_DATA_210_LSB)
#define TXPCU_TXBUF_DATA_210_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_210_LSB) & TXPCU_TXBUF_DATA_210_MASK)
#define TXPCU_TXBUF_DATA_210_RESET                                             0x0
#define TXPCU_TXBUF_210_ADDRESS                                                (0x1348 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_210_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_210_RESET                                                  0x0

// 0x134c (TXPCU_TXBUF_211)
#define TXPCU_TXBUF_DATA_211_LSB                                               0
#define TXPCU_TXBUF_DATA_211_MSB                                               31
#define TXPCU_TXBUF_DATA_211_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_211_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_211_MASK) >> TXPCU_TXBUF_DATA_211_LSB)
#define TXPCU_TXBUF_DATA_211_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_211_LSB) & TXPCU_TXBUF_DATA_211_MASK)
#define TXPCU_TXBUF_DATA_211_RESET                                             0x0
#define TXPCU_TXBUF_211_ADDRESS                                                (0x134c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_211_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_211_RESET                                                  0x0

// 0x1350 (TXPCU_TXBUF_212)
#define TXPCU_TXBUF_DATA_212_LSB                                               0
#define TXPCU_TXBUF_DATA_212_MSB                                               31
#define TXPCU_TXBUF_DATA_212_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_212_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_212_MASK) >> TXPCU_TXBUF_DATA_212_LSB)
#define TXPCU_TXBUF_DATA_212_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_212_LSB) & TXPCU_TXBUF_DATA_212_MASK)
#define TXPCU_TXBUF_DATA_212_RESET                                             0x0
#define TXPCU_TXBUF_212_ADDRESS                                                (0x1350 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_212_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_212_RESET                                                  0x0

// 0x1354 (TXPCU_TXBUF_213)
#define TXPCU_TXBUF_DATA_213_LSB                                               0
#define TXPCU_TXBUF_DATA_213_MSB                                               31
#define TXPCU_TXBUF_DATA_213_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_213_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_213_MASK) >> TXPCU_TXBUF_DATA_213_LSB)
#define TXPCU_TXBUF_DATA_213_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_213_LSB) & TXPCU_TXBUF_DATA_213_MASK)
#define TXPCU_TXBUF_DATA_213_RESET                                             0x0
#define TXPCU_TXBUF_213_ADDRESS                                                (0x1354 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_213_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_213_RESET                                                  0x0

// 0x1358 (TXPCU_TXBUF_214)
#define TXPCU_TXBUF_DATA_214_LSB                                               0
#define TXPCU_TXBUF_DATA_214_MSB                                               31
#define TXPCU_TXBUF_DATA_214_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_214_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_214_MASK) >> TXPCU_TXBUF_DATA_214_LSB)
#define TXPCU_TXBUF_DATA_214_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_214_LSB) & TXPCU_TXBUF_DATA_214_MASK)
#define TXPCU_TXBUF_DATA_214_RESET                                             0x0
#define TXPCU_TXBUF_214_ADDRESS                                                (0x1358 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_214_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_214_RESET                                                  0x0

// 0x135c (TXPCU_TXBUF_215)
#define TXPCU_TXBUF_DATA_215_LSB                                               0
#define TXPCU_TXBUF_DATA_215_MSB                                               31
#define TXPCU_TXBUF_DATA_215_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_215_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_215_MASK) >> TXPCU_TXBUF_DATA_215_LSB)
#define TXPCU_TXBUF_DATA_215_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_215_LSB) & TXPCU_TXBUF_DATA_215_MASK)
#define TXPCU_TXBUF_DATA_215_RESET                                             0x0
#define TXPCU_TXBUF_215_ADDRESS                                                (0x135c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_215_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_215_RESET                                                  0x0

// 0x1360 (TXPCU_TXBUF_216)
#define TXPCU_TXBUF_DATA_216_LSB                                               0
#define TXPCU_TXBUF_DATA_216_MSB                                               31
#define TXPCU_TXBUF_DATA_216_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_216_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_216_MASK) >> TXPCU_TXBUF_DATA_216_LSB)
#define TXPCU_TXBUF_DATA_216_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_216_LSB) & TXPCU_TXBUF_DATA_216_MASK)
#define TXPCU_TXBUF_DATA_216_RESET                                             0x0
#define TXPCU_TXBUF_216_ADDRESS                                                (0x1360 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_216_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_216_RESET                                                  0x0

// 0x1364 (TXPCU_TXBUF_217)
#define TXPCU_TXBUF_DATA_217_LSB                                               0
#define TXPCU_TXBUF_DATA_217_MSB                                               31
#define TXPCU_TXBUF_DATA_217_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_217_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_217_MASK) >> TXPCU_TXBUF_DATA_217_LSB)
#define TXPCU_TXBUF_DATA_217_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_217_LSB) & TXPCU_TXBUF_DATA_217_MASK)
#define TXPCU_TXBUF_DATA_217_RESET                                             0x0
#define TXPCU_TXBUF_217_ADDRESS                                                (0x1364 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_217_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_217_RESET                                                  0x0

// 0x1368 (TXPCU_TXBUF_218)
#define TXPCU_TXBUF_DATA_218_LSB                                               0
#define TXPCU_TXBUF_DATA_218_MSB                                               31
#define TXPCU_TXBUF_DATA_218_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_218_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_218_MASK) >> TXPCU_TXBUF_DATA_218_LSB)
#define TXPCU_TXBUF_DATA_218_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_218_LSB) & TXPCU_TXBUF_DATA_218_MASK)
#define TXPCU_TXBUF_DATA_218_RESET                                             0x0
#define TXPCU_TXBUF_218_ADDRESS                                                (0x1368 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_218_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_218_RESET                                                  0x0

// 0x136c (TXPCU_TXBUF_219)
#define TXPCU_TXBUF_DATA_219_LSB                                               0
#define TXPCU_TXBUF_DATA_219_MSB                                               31
#define TXPCU_TXBUF_DATA_219_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_219_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_219_MASK) >> TXPCU_TXBUF_DATA_219_LSB)
#define TXPCU_TXBUF_DATA_219_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_219_LSB) & TXPCU_TXBUF_DATA_219_MASK)
#define TXPCU_TXBUF_DATA_219_RESET                                             0x0
#define TXPCU_TXBUF_219_ADDRESS                                                (0x136c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_219_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_219_RESET                                                  0x0

// 0x1370 (TXPCU_TXBUF_220)
#define TXPCU_TXBUF_DATA_220_LSB                                               0
#define TXPCU_TXBUF_DATA_220_MSB                                               31
#define TXPCU_TXBUF_DATA_220_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_220_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_220_MASK) >> TXPCU_TXBUF_DATA_220_LSB)
#define TXPCU_TXBUF_DATA_220_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_220_LSB) & TXPCU_TXBUF_DATA_220_MASK)
#define TXPCU_TXBUF_DATA_220_RESET                                             0x0
#define TXPCU_TXBUF_220_ADDRESS                                                (0x1370 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_220_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_220_RESET                                                  0x0

// 0x1374 (TXPCU_TXBUF_221)
#define TXPCU_TXBUF_DATA_221_LSB                                               0
#define TXPCU_TXBUF_DATA_221_MSB                                               31
#define TXPCU_TXBUF_DATA_221_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_221_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_221_MASK) >> TXPCU_TXBUF_DATA_221_LSB)
#define TXPCU_TXBUF_DATA_221_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_221_LSB) & TXPCU_TXBUF_DATA_221_MASK)
#define TXPCU_TXBUF_DATA_221_RESET                                             0x0
#define TXPCU_TXBUF_221_ADDRESS                                                (0x1374 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_221_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_221_RESET                                                  0x0

// 0x1378 (TXPCU_TXBUF_222)
#define TXPCU_TXBUF_DATA_222_LSB                                               0
#define TXPCU_TXBUF_DATA_222_MSB                                               31
#define TXPCU_TXBUF_DATA_222_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_222_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_222_MASK) >> TXPCU_TXBUF_DATA_222_LSB)
#define TXPCU_TXBUF_DATA_222_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_222_LSB) & TXPCU_TXBUF_DATA_222_MASK)
#define TXPCU_TXBUF_DATA_222_RESET                                             0x0
#define TXPCU_TXBUF_222_ADDRESS                                                (0x1378 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_222_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_222_RESET                                                  0x0

// 0x137c (TXPCU_TXBUF_223)
#define TXPCU_TXBUF_DATA_223_LSB                                               0
#define TXPCU_TXBUF_DATA_223_MSB                                               31
#define TXPCU_TXBUF_DATA_223_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_223_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_223_MASK) >> TXPCU_TXBUF_DATA_223_LSB)
#define TXPCU_TXBUF_DATA_223_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_223_LSB) & TXPCU_TXBUF_DATA_223_MASK)
#define TXPCU_TXBUF_DATA_223_RESET                                             0x0
#define TXPCU_TXBUF_223_ADDRESS                                                (0x137c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_223_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_223_RESET                                                  0x0

// 0x1380 (TXPCU_TXBUF_224)
#define TXPCU_TXBUF_DATA_224_LSB                                               0
#define TXPCU_TXBUF_DATA_224_MSB                                               31
#define TXPCU_TXBUF_DATA_224_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_224_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_224_MASK) >> TXPCU_TXBUF_DATA_224_LSB)
#define TXPCU_TXBUF_DATA_224_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_224_LSB) & TXPCU_TXBUF_DATA_224_MASK)
#define TXPCU_TXBUF_DATA_224_RESET                                             0x0
#define TXPCU_TXBUF_224_ADDRESS                                                (0x1380 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_224_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_224_RESET                                                  0x0

// 0x1384 (TXPCU_TXBUF_225)
#define TXPCU_TXBUF_DATA_225_LSB                                               0
#define TXPCU_TXBUF_DATA_225_MSB                                               31
#define TXPCU_TXBUF_DATA_225_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_225_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_225_MASK) >> TXPCU_TXBUF_DATA_225_LSB)
#define TXPCU_TXBUF_DATA_225_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_225_LSB) & TXPCU_TXBUF_DATA_225_MASK)
#define TXPCU_TXBUF_DATA_225_RESET                                             0x0
#define TXPCU_TXBUF_225_ADDRESS                                                (0x1384 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_225_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_225_RESET                                                  0x0

// 0x1388 (TXPCU_TXBUF_226)
#define TXPCU_TXBUF_DATA_226_LSB                                               0
#define TXPCU_TXBUF_DATA_226_MSB                                               31
#define TXPCU_TXBUF_DATA_226_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_226_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_226_MASK) >> TXPCU_TXBUF_DATA_226_LSB)
#define TXPCU_TXBUF_DATA_226_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_226_LSB) & TXPCU_TXBUF_DATA_226_MASK)
#define TXPCU_TXBUF_DATA_226_RESET                                             0x0
#define TXPCU_TXBUF_226_ADDRESS                                                (0x1388 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_226_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_226_RESET                                                  0x0

// 0x138c (TXPCU_TXBUF_227)
#define TXPCU_TXBUF_DATA_227_LSB                                               0
#define TXPCU_TXBUF_DATA_227_MSB                                               31
#define TXPCU_TXBUF_DATA_227_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_227_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_227_MASK) >> TXPCU_TXBUF_DATA_227_LSB)
#define TXPCU_TXBUF_DATA_227_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_227_LSB) & TXPCU_TXBUF_DATA_227_MASK)
#define TXPCU_TXBUF_DATA_227_RESET                                             0x0
#define TXPCU_TXBUF_227_ADDRESS                                                (0x138c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_227_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_227_RESET                                                  0x0

// 0x1390 (TXPCU_TXBUF_228)
#define TXPCU_TXBUF_DATA_228_LSB                                               0
#define TXPCU_TXBUF_DATA_228_MSB                                               31
#define TXPCU_TXBUF_DATA_228_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_228_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_228_MASK) >> TXPCU_TXBUF_DATA_228_LSB)
#define TXPCU_TXBUF_DATA_228_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_228_LSB) & TXPCU_TXBUF_DATA_228_MASK)
#define TXPCU_TXBUF_DATA_228_RESET                                             0x0
#define TXPCU_TXBUF_228_ADDRESS                                                (0x1390 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_228_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_228_RESET                                                  0x0

// 0x1394 (TXPCU_TXBUF_229)
#define TXPCU_TXBUF_DATA_229_LSB                                               0
#define TXPCU_TXBUF_DATA_229_MSB                                               31
#define TXPCU_TXBUF_DATA_229_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_229_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_229_MASK) >> TXPCU_TXBUF_DATA_229_LSB)
#define TXPCU_TXBUF_DATA_229_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_229_LSB) & TXPCU_TXBUF_DATA_229_MASK)
#define TXPCU_TXBUF_DATA_229_RESET                                             0x0
#define TXPCU_TXBUF_229_ADDRESS                                                (0x1394 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_229_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_229_RESET                                                  0x0

// 0x1398 (TXPCU_TXBUF_230)
#define TXPCU_TXBUF_DATA_230_LSB                                               0
#define TXPCU_TXBUF_DATA_230_MSB                                               31
#define TXPCU_TXBUF_DATA_230_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_230_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_230_MASK) >> TXPCU_TXBUF_DATA_230_LSB)
#define TXPCU_TXBUF_DATA_230_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_230_LSB) & TXPCU_TXBUF_DATA_230_MASK)
#define TXPCU_TXBUF_DATA_230_RESET                                             0x0
#define TXPCU_TXBUF_230_ADDRESS                                                (0x1398 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_230_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_230_RESET                                                  0x0

// 0x139c (TXPCU_TXBUF_231)
#define TXPCU_TXBUF_DATA_231_LSB                                               0
#define TXPCU_TXBUF_DATA_231_MSB                                               31
#define TXPCU_TXBUF_DATA_231_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_231_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_231_MASK) >> TXPCU_TXBUF_DATA_231_LSB)
#define TXPCU_TXBUF_DATA_231_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_231_LSB) & TXPCU_TXBUF_DATA_231_MASK)
#define TXPCU_TXBUF_DATA_231_RESET                                             0x0
#define TXPCU_TXBUF_231_ADDRESS                                                (0x139c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_231_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_231_RESET                                                  0x0

// 0x13a0 (TXPCU_TXBUF_232)
#define TXPCU_TXBUF_DATA_232_LSB                                               0
#define TXPCU_TXBUF_DATA_232_MSB                                               31
#define TXPCU_TXBUF_DATA_232_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_232_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_232_MASK) >> TXPCU_TXBUF_DATA_232_LSB)
#define TXPCU_TXBUF_DATA_232_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_232_LSB) & TXPCU_TXBUF_DATA_232_MASK)
#define TXPCU_TXBUF_DATA_232_RESET                                             0x0
#define TXPCU_TXBUF_232_ADDRESS                                                (0x13a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_232_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_232_RESET                                                  0x0

// 0x13a4 (TXPCU_TXBUF_233)
#define TXPCU_TXBUF_DATA_233_LSB                                               0
#define TXPCU_TXBUF_DATA_233_MSB                                               31
#define TXPCU_TXBUF_DATA_233_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_233_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_233_MASK) >> TXPCU_TXBUF_DATA_233_LSB)
#define TXPCU_TXBUF_DATA_233_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_233_LSB) & TXPCU_TXBUF_DATA_233_MASK)
#define TXPCU_TXBUF_DATA_233_RESET                                             0x0
#define TXPCU_TXBUF_233_ADDRESS                                                (0x13a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_233_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_233_RESET                                                  0x0

// 0x13a8 (TXPCU_TXBUF_234)
#define TXPCU_TXBUF_DATA_234_LSB                                               0
#define TXPCU_TXBUF_DATA_234_MSB                                               31
#define TXPCU_TXBUF_DATA_234_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_234_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_234_MASK) >> TXPCU_TXBUF_DATA_234_LSB)
#define TXPCU_TXBUF_DATA_234_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_234_LSB) & TXPCU_TXBUF_DATA_234_MASK)
#define TXPCU_TXBUF_DATA_234_RESET                                             0x0
#define TXPCU_TXBUF_234_ADDRESS                                                (0x13a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_234_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_234_RESET                                                  0x0

// 0x13ac (TXPCU_TXBUF_235)
#define TXPCU_TXBUF_DATA_235_LSB                                               0
#define TXPCU_TXBUF_DATA_235_MSB                                               31
#define TXPCU_TXBUF_DATA_235_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_235_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_235_MASK) >> TXPCU_TXBUF_DATA_235_LSB)
#define TXPCU_TXBUF_DATA_235_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_235_LSB) & TXPCU_TXBUF_DATA_235_MASK)
#define TXPCU_TXBUF_DATA_235_RESET                                             0x0
#define TXPCU_TXBUF_235_ADDRESS                                                (0x13ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_235_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_235_RESET                                                  0x0

// 0x13b0 (TXPCU_TXBUF_236)
#define TXPCU_TXBUF_DATA_236_LSB                                               0
#define TXPCU_TXBUF_DATA_236_MSB                                               31
#define TXPCU_TXBUF_DATA_236_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_236_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_236_MASK) >> TXPCU_TXBUF_DATA_236_LSB)
#define TXPCU_TXBUF_DATA_236_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_236_LSB) & TXPCU_TXBUF_DATA_236_MASK)
#define TXPCU_TXBUF_DATA_236_RESET                                             0x0
#define TXPCU_TXBUF_236_ADDRESS                                                (0x13b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_236_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_236_RESET                                                  0x0

// 0x13b4 (TXPCU_TXBUF_237)
#define TXPCU_TXBUF_DATA_237_LSB                                               0
#define TXPCU_TXBUF_DATA_237_MSB                                               31
#define TXPCU_TXBUF_DATA_237_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_237_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_237_MASK) >> TXPCU_TXBUF_DATA_237_LSB)
#define TXPCU_TXBUF_DATA_237_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_237_LSB) & TXPCU_TXBUF_DATA_237_MASK)
#define TXPCU_TXBUF_DATA_237_RESET                                             0x0
#define TXPCU_TXBUF_237_ADDRESS                                                (0x13b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_237_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_237_RESET                                                  0x0

// 0x13b8 (TXPCU_TXBUF_238)
#define TXPCU_TXBUF_DATA_238_LSB                                               0
#define TXPCU_TXBUF_DATA_238_MSB                                               31
#define TXPCU_TXBUF_DATA_238_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_238_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_238_MASK) >> TXPCU_TXBUF_DATA_238_LSB)
#define TXPCU_TXBUF_DATA_238_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_238_LSB) & TXPCU_TXBUF_DATA_238_MASK)
#define TXPCU_TXBUF_DATA_238_RESET                                             0x0
#define TXPCU_TXBUF_238_ADDRESS                                                (0x13b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_238_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_238_RESET                                                  0x0

// 0x13bc (TXPCU_TXBUF_239)
#define TXPCU_TXBUF_DATA_239_LSB                                               0
#define TXPCU_TXBUF_DATA_239_MSB                                               31
#define TXPCU_TXBUF_DATA_239_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_239_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_239_MASK) >> TXPCU_TXBUF_DATA_239_LSB)
#define TXPCU_TXBUF_DATA_239_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_239_LSB) & TXPCU_TXBUF_DATA_239_MASK)
#define TXPCU_TXBUF_DATA_239_RESET                                             0x0
#define TXPCU_TXBUF_239_ADDRESS                                                (0x13bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_239_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_239_RESET                                                  0x0

// 0x13c0 (TXPCU_TXBUF_240)
#define TXPCU_TXBUF_DATA_240_LSB                                               0
#define TXPCU_TXBUF_DATA_240_MSB                                               31
#define TXPCU_TXBUF_DATA_240_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_240_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_240_MASK) >> TXPCU_TXBUF_DATA_240_LSB)
#define TXPCU_TXBUF_DATA_240_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_240_LSB) & TXPCU_TXBUF_DATA_240_MASK)
#define TXPCU_TXBUF_DATA_240_RESET                                             0x0
#define TXPCU_TXBUF_240_ADDRESS                                                (0x13c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_240_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_240_RESET                                                  0x0

// 0x13c4 (TXPCU_TXBUF_241)
#define TXPCU_TXBUF_DATA_241_LSB                                               0
#define TXPCU_TXBUF_DATA_241_MSB                                               31
#define TXPCU_TXBUF_DATA_241_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_241_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_241_MASK) >> TXPCU_TXBUF_DATA_241_LSB)
#define TXPCU_TXBUF_DATA_241_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_241_LSB) & TXPCU_TXBUF_DATA_241_MASK)
#define TXPCU_TXBUF_DATA_241_RESET                                             0x0
#define TXPCU_TXBUF_241_ADDRESS                                                (0x13c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_241_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_241_RESET                                                  0x0

// 0x13c8 (TXPCU_TXBUF_242)
#define TXPCU_TXBUF_DATA_242_LSB                                               0
#define TXPCU_TXBUF_DATA_242_MSB                                               31
#define TXPCU_TXBUF_DATA_242_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_242_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_242_MASK) >> TXPCU_TXBUF_DATA_242_LSB)
#define TXPCU_TXBUF_DATA_242_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_242_LSB) & TXPCU_TXBUF_DATA_242_MASK)
#define TXPCU_TXBUF_DATA_242_RESET                                             0x0
#define TXPCU_TXBUF_242_ADDRESS                                                (0x13c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_242_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_242_RESET                                                  0x0

// 0x13cc (TXPCU_TXBUF_243)
#define TXPCU_TXBUF_DATA_243_LSB                                               0
#define TXPCU_TXBUF_DATA_243_MSB                                               31
#define TXPCU_TXBUF_DATA_243_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_243_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_243_MASK) >> TXPCU_TXBUF_DATA_243_LSB)
#define TXPCU_TXBUF_DATA_243_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_243_LSB) & TXPCU_TXBUF_DATA_243_MASK)
#define TXPCU_TXBUF_DATA_243_RESET                                             0x0
#define TXPCU_TXBUF_243_ADDRESS                                                (0x13cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_243_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_243_RESET                                                  0x0

// 0x13d0 (TXPCU_TXBUF_244)
#define TXPCU_TXBUF_DATA_244_LSB                                               0
#define TXPCU_TXBUF_DATA_244_MSB                                               31
#define TXPCU_TXBUF_DATA_244_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_244_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_244_MASK) >> TXPCU_TXBUF_DATA_244_LSB)
#define TXPCU_TXBUF_DATA_244_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_244_LSB) & TXPCU_TXBUF_DATA_244_MASK)
#define TXPCU_TXBUF_DATA_244_RESET                                             0x0
#define TXPCU_TXBUF_244_ADDRESS                                                (0x13d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_244_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_244_RESET                                                  0x0

// 0x13d4 (TXPCU_TXBUF_245)
#define TXPCU_TXBUF_DATA_245_LSB                                               0
#define TXPCU_TXBUF_DATA_245_MSB                                               31
#define TXPCU_TXBUF_DATA_245_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_245_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_245_MASK) >> TXPCU_TXBUF_DATA_245_LSB)
#define TXPCU_TXBUF_DATA_245_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_245_LSB) & TXPCU_TXBUF_DATA_245_MASK)
#define TXPCU_TXBUF_DATA_245_RESET                                             0x0
#define TXPCU_TXBUF_245_ADDRESS                                                (0x13d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_245_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_245_RESET                                                  0x0

// 0x13d8 (TXPCU_TXBUF_246)
#define TXPCU_TXBUF_DATA_246_LSB                                               0
#define TXPCU_TXBUF_DATA_246_MSB                                               31
#define TXPCU_TXBUF_DATA_246_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_246_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_246_MASK) >> TXPCU_TXBUF_DATA_246_LSB)
#define TXPCU_TXBUF_DATA_246_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_246_LSB) & TXPCU_TXBUF_DATA_246_MASK)
#define TXPCU_TXBUF_DATA_246_RESET                                             0x0
#define TXPCU_TXBUF_246_ADDRESS                                                (0x13d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_246_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_246_RESET                                                  0x0

// 0x13dc (TXPCU_TXBUF_247)
#define TXPCU_TXBUF_DATA_247_LSB                                               0
#define TXPCU_TXBUF_DATA_247_MSB                                               31
#define TXPCU_TXBUF_DATA_247_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_247_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_247_MASK) >> TXPCU_TXBUF_DATA_247_LSB)
#define TXPCU_TXBUF_DATA_247_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_247_LSB) & TXPCU_TXBUF_DATA_247_MASK)
#define TXPCU_TXBUF_DATA_247_RESET                                             0x0
#define TXPCU_TXBUF_247_ADDRESS                                                (0x13dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_247_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_247_RESET                                                  0x0

// 0x13e0 (TXPCU_TXBUF_248)
#define TXPCU_TXBUF_DATA_248_LSB                                               0
#define TXPCU_TXBUF_DATA_248_MSB                                               31
#define TXPCU_TXBUF_DATA_248_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_248_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_248_MASK) >> TXPCU_TXBUF_DATA_248_LSB)
#define TXPCU_TXBUF_DATA_248_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_248_LSB) & TXPCU_TXBUF_DATA_248_MASK)
#define TXPCU_TXBUF_DATA_248_RESET                                             0x0
#define TXPCU_TXBUF_248_ADDRESS                                                (0x13e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_248_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_248_RESET                                                  0x0

// 0x13e4 (TXPCU_TXBUF_249)
#define TXPCU_TXBUF_DATA_249_LSB                                               0
#define TXPCU_TXBUF_DATA_249_MSB                                               31
#define TXPCU_TXBUF_DATA_249_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_249_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_249_MASK) >> TXPCU_TXBUF_DATA_249_LSB)
#define TXPCU_TXBUF_DATA_249_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_249_LSB) & TXPCU_TXBUF_DATA_249_MASK)
#define TXPCU_TXBUF_DATA_249_RESET                                             0x0
#define TXPCU_TXBUF_249_ADDRESS                                                (0x13e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_249_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_249_RESET                                                  0x0

// 0x13e8 (TXPCU_TXBUF_250)
#define TXPCU_TXBUF_DATA_250_LSB                                               0
#define TXPCU_TXBUF_DATA_250_MSB                                               31
#define TXPCU_TXBUF_DATA_250_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_250_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_250_MASK) >> TXPCU_TXBUF_DATA_250_LSB)
#define TXPCU_TXBUF_DATA_250_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_250_LSB) & TXPCU_TXBUF_DATA_250_MASK)
#define TXPCU_TXBUF_DATA_250_RESET                                             0x0
#define TXPCU_TXBUF_250_ADDRESS                                                (0x13e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_250_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_250_RESET                                                  0x0

// 0x13ec (TXPCU_TXBUF_251)
#define TXPCU_TXBUF_DATA_251_LSB                                               0
#define TXPCU_TXBUF_DATA_251_MSB                                               31
#define TXPCU_TXBUF_DATA_251_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_251_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_251_MASK) >> TXPCU_TXBUF_DATA_251_LSB)
#define TXPCU_TXBUF_DATA_251_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_251_LSB) & TXPCU_TXBUF_DATA_251_MASK)
#define TXPCU_TXBUF_DATA_251_RESET                                             0x0
#define TXPCU_TXBUF_251_ADDRESS                                                (0x13ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_251_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_251_RESET                                                  0x0

// 0x13f0 (TXPCU_TXBUF_252)
#define TXPCU_TXBUF_DATA_252_LSB                                               0
#define TXPCU_TXBUF_DATA_252_MSB                                               31
#define TXPCU_TXBUF_DATA_252_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_252_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_252_MASK) >> TXPCU_TXBUF_DATA_252_LSB)
#define TXPCU_TXBUF_DATA_252_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_252_LSB) & TXPCU_TXBUF_DATA_252_MASK)
#define TXPCU_TXBUF_DATA_252_RESET                                             0x0
#define TXPCU_TXBUF_252_ADDRESS                                                (0x13f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_252_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_252_RESET                                                  0x0

// 0x13f4 (TXPCU_TXBUF_253)
#define TXPCU_TXBUF_DATA_253_LSB                                               0
#define TXPCU_TXBUF_DATA_253_MSB                                               31
#define TXPCU_TXBUF_DATA_253_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_253_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_253_MASK) >> TXPCU_TXBUF_DATA_253_LSB)
#define TXPCU_TXBUF_DATA_253_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_253_LSB) & TXPCU_TXBUF_DATA_253_MASK)
#define TXPCU_TXBUF_DATA_253_RESET                                             0x0
#define TXPCU_TXBUF_253_ADDRESS                                                (0x13f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_253_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_253_RESET                                                  0x0

// 0x13f8 (TXPCU_TXBUF_254)
#define TXPCU_TXBUF_DATA_254_LSB                                               0
#define TXPCU_TXBUF_DATA_254_MSB                                               31
#define TXPCU_TXBUF_DATA_254_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_254_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_254_MASK) >> TXPCU_TXBUF_DATA_254_LSB)
#define TXPCU_TXBUF_DATA_254_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_254_LSB) & TXPCU_TXBUF_DATA_254_MASK)
#define TXPCU_TXBUF_DATA_254_RESET                                             0x0
#define TXPCU_TXBUF_254_ADDRESS                                                (0x13f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_254_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_254_RESET                                                  0x0

// 0x13fc (TXPCU_TXBUF_255)
#define TXPCU_TXBUF_DATA_255_LSB                                               0
#define TXPCU_TXBUF_DATA_255_MSB                                               31
#define TXPCU_TXBUF_DATA_255_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_255_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_255_MASK) >> TXPCU_TXBUF_DATA_255_LSB)
#define TXPCU_TXBUF_DATA_255_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_255_LSB) & TXPCU_TXBUF_DATA_255_MASK)
#define TXPCU_TXBUF_DATA_255_RESET                                             0x0
#define TXPCU_TXBUF_255_ADDRESS                                                (0x13fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_255_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_255_RESET                                                  0x0

// 0x1400 (TXPCU_TXBUF_256)
#define TXPCU_TXBUF_DATA_256_LSB                                               0
#define TXPCU_TXBUF_DATA_256_MSB                                               31
#define TXPCU_TXBUF_DATA_256_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_256_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_256_MASK) >> TXPCU_TXBUF_DATA_256_LSB)
#define TXPCU_TXBUF_DATA_256_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_256_LSB) & TXPCU_TXBUF_DATA_256_MASK)
#define TXPCU_TXBUF_DATA_256_RESET                                             0x0
#define TXPCU_TXBUF_256_ADDRESS                                                (0x1400 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_256_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_256_RESET                                                  0x0

// 0x1404 (TXPCU_TXBUF_257)
#define TXPCU_TXBUF_DATA_257_LSB                                               0
#define TXPCU_TXBUF_DATA_257_MSB                                               31
#define TXPCU_TXBUF_DATA_257_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_257_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_257_MASK) >> TXPCU_TXBUF_DATA_257_LSB)
#define TXPCU_TXBUF_DATA_257_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_257_LSB) & TXPCU_TXBUF_DATA_257_MASK)
#define TXPCU_TXBUF_DATA_257_RESET                                             0x0
#define TXPCU_TXBUF_257_ADDRESS                                                (0x1404 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_257_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_257_RESET                                                  0x0

// 0x1408 (TXPCU_TXBUF_258)
#define TXPCU_TXBUF_DATA_258_LSB                                               0
#define TXPCU_TXBUF_DATA_258_MSB                                               31
#define TXPCU_TXBUF_DATA_258_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_258_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_258_MASK) >> TXPCU_TXBUF_DATA_258_LSB)
#define TXPCU_TXBUF_DATA_258_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_258_LSB) & TXPCU_TXBUF_DATA_258_MASK)
#define TXPCU_TXBUF_DATA_258_RESET                                             0x0
#define TXPCU_TXBUF_258_ADDRESS                                                (0x1408 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_258_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_258_RESET                                                  0x0

// 0x140c (TXPCU_TXBUF_259)
#define TXPCU_TXBUF_DATA_259_LSB                                               0
#define TXPCU_TXBUF_DATA_259_MSB                                               31
#define TXPCU_TXBUF_DATA_259_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_259_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_259_MASK) >> TXPCU_TXBUF_DATA_259_LSB)
#define TXPCU_TXBUF_DATA_259_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_259_LSB) & TXPCU_TXBUF_DATA_259_MASK)
#define TXPCU_TXBUF_DATA_259_RESET                                             0x0
#define TXPCU_TXBUF_259_ADDRESS                                                (0x140c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_259_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_259_RESET                                                  0x0

// 0x1410 (TXPCU_TXBUF_260)
#define TXPCU_TXBUF_DATA_260_LSB                                               0
#define TXPCU_TXBUF_DATA_260_MSB                                               31
#define TXPCU_TXBUF_DATA_260_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_260_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_260_MASK) >> TXPCU_TXBUF_DATA_260_LSB)
#define TXPCU_TXBUF_DATA_260_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_260_LSB) & TXPCU_TXBUF_DATA_260_MASK)
#define TXPCU_TXBUF_DATA_260_RESET                                             0x0
#define TXPCU_TXBUF_260_ADDRESS                                                (0x1410 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_260_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_260_RESET                                                  0x0

// 0x1414 (TXPCU_TXBUF_261)
#define TXPCU_TXBUF_DATA_261_LSB                                               0
#define TXPCU_TXBUF_DATA_261_MSB                                               31
#define TXPCU_TXBUF_DATA_261_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_261_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_261_MASK) >> TXPCU_TXBUF_DATA_261_LSB)
#define TXPCU_TXBUF_DATA_261_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_261_LSB) & TXPCU_TXBUF_DATA_261_MASK)
#define TXPCU_TXBUF_DATA_261_RESET                                             0x0
#define TXPCU_TXBUF_261_ADDRESS                                                (0x1414 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_261_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_261_RESET                                                  0x0

// 0x1418 (TXPCU_TXBUF_262)
#define TXPCU_TXBUF_DATA_262_LSB                                               0
#define TXPCU_TXBUF_DATA_262_MSB                                               31
#define TXPCU_TXBUF_DATA_262_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_262_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_262_MASK) >> TXPCU_TXBUF_DATA_262_LSB)
#define TXPCU_TXBUF_DATA_262_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_262_LSB) & TXPCU_TXBUF_DATA_262_MASK)
#define TXPCU_TXBUF_DATA_262_RESET                                             0x0
#define TXPCU_TXBUF_262_ADDRESS                                                (0x1418 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_262_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_262_RESET                                                  0x0

// 0x141c (TXPCU_TXBUF_263)
#define TXPCU_TXBUF_DATA_263_LSB                                               0
#define TXPCU_TXBUF_DATA_263_MSB                                               31
#define TXPCU_TXBUF_DATA_263_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_263_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_263_MASK) >> TXPCU_TXBUF_DATA_263_LSB)
#define TXPCU_TXBUF_DATA_263_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_263_LSB) & TXPCU_TXBUF_DATA_263_MASK)
#define TXPCU_TXBUF_DATA_263_RESET                                             0x0
#define TXPCU_TXBUF_263_ADDRESS                                                (0x141c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_263_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_263_RESET                                                  0x0

// 0x1420 (TXPCU_TXBUF_264)
#define TXPCU_TXBUF_DATA_264_LSB                                               0
#define TXPCU_TXBUF_DATA_264_MSB                                               31
#define TXPCU_TXBUF_DATA_264_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_264_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_264_MASK) >> TXPCU_TXBUF_DATA_264_LSB)
#define TXPCU_TXBUF_DATA_264_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_264_LSB) & TXPCU_TXBUF_DATA_264_MASK)
#define TXPCU_TXBUF_DATA_264_RESET                                             0x0
#define TXPCU_TXBUF_264_ADDRESS                                                (0x1420 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_264_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_264_RESET                                                  0x0

// 0x1424 (TXPCU_TXBUF_265)
#define TXPCU_TXBUF_DATA_265_LSB                                               0
#define TXPCU_TXBUF_DATA_265_MSB                                               31
#define TXPCU_TXBUF_DATA_265_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_265_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_265_MASK) >> TXPCU_TXBUF_DATA_265_LSB)
#define TXPCU_TXBUF_DATA_265_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_265_LSB) & TXPCU_TXBUF_DATA_265_MASK)
#define TXPCU_TXBUF_DATA_265_RESET                                             0x0
#define TXPCU_TXBUF_265_ADDRESS                                                (0x1424 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_265_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_265_RESET                                                  0x0

// 0x1428 (TXPCU_TXBUF_266)
#define TXPCU_TXBUF_DATA_266_LSB                                               0
#define TXPCU_TXBUF_DATA_266_MSB                                               31
#define TXPCU_TXBUF_DATA_266_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_266_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_266_MASK) >> TXPCU_TXBUF_DATA_266_LSB)
#define TXPCU_TXBUF_DATA_266_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_266_LSB) & TXPCU_TXBUF_DATA_266_MASK)
#define TXPCU_TXBUF_DATA_266_RESET                                             0x0
#define TXPCU_TXBUF_266_ADDRESS                                                (0x1428 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_266_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_266_RESET                                                  0x0

// 0x142c (TXPCU_TXBUF_267)
#define TXPCU_TXBUF_DATA_267_LSB                                               0
#define TXPCU_TXBUF_DATA_267_MSB                                               31
#define TXPCU_TXBUF_DATA_267_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_267_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_267_MASK) >> TXPCU_TXBUF_DATA_267_LSB)
#define TXPCU_TXBUF_DATA_267_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_267_LSB) & TXPCU_TXBUF_DATA_267_MASK)
#define TXPCU_TXBUF_DATA_267_RESET                                             0x0
#define TXPCU_TXBUF_267_ADDRESS                                                (0x142c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_267_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_267_RESET                                                  0x0

// 0x1430 (TXPCU_TXBUF_268)
#define TXPCU_TXBUF_DATA_268_LSB                                               0
#define TXPCU_TXBUF_DATA_268_MSB                                               31
#define TXPCU_TXBUF_DATA_268_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_268_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_268_MASK) >> TXPCU_TXBUF_DATA_268_LSB)
#define TXPCU_TXBUF_DATA_268_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_268_LSB) & TXPCU_TXBUF_DATA_268_MASK)
#define TXPCU_TXBUF_DATA_268_RESET                                             0x0
#define TXPCU_TXBUF_268_ADDRESS                                                (0x1430 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_268_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_268_RESET                                                  0x0

// 0x1434 (TXPCU_TXBUF_269)
#define TXPCU_TXBUF_DATA_269_LSB                                               0
#define TXPCU_TXBUF_DATA_269_MSB                                               31
#define TXPCU_TXBUF_DATA_269_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_269_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_269_MASK) >> TXPCU_TXBUF_DATA_269_LSB)
#define TXPCU_TXBUF_DATA_269_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_269_LSB) & TXPCU_TXBUF_DATA_269_MASK)
#define TXPCU_TXBUF_DATA_269_RESET                                             0x0
#define TXPCU_TXBUF_269_ADDRESS                                                (0x1434 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_269_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_269_RESET                                                  0x0

// 0x1438 (TXPCU_TXBUF_270)
#define TXPCU_TXBUF_DATA_270_LSB                                               0
#define TXPCU_TXBUF_DATA_270_MSB                                               31
#define TXPCU_TXBUF_DATA_270_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_270_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_270_MASK) >> TXPCU_TXBUF_DATA_270_LSB)
#define TXPCU_TXBUF_DATA_270_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_270_LSB) & TXPCU_TXBUF_DATA_270_MASK)
#define TXPCU_TXBUF_DATA_270_RESET                                             0x0
#define TXPCU_TXBUF_270_ADDRESS                                                (0x1438 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_270_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_270_RESET                                                  0x0

// 0x143c (TXPCU_TXBUF_271)
#define TXPCU_TXBUF_DATA_271_LSB                                               0
#define TXPCU_TXBUF_DATA_271_MSB                                               31
#define TXPCU_TXBUF_DATA_271_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_271_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_271_MASK) >> TXPCU_TXBUF_DATA_271_LSB)
#define TXPCU_TXBUF_DATA_271_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_271_LSB) & TXPCU_TXBUF_DATA_271_MASK)
#define TXPCU_TXBUF_DATA_271_RESET                                             0x0
#define TXPCU_TXBUF_271_ADDRESS                                                (0x143c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_271_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_271_RESET                                                  0x0

// 0x1440 (TXPCU_TXBUF_272)
#define TXPCU_TXBUF_DATA_272_LSB                                               0
#define TXPCU_TXBUF_DATA_272_MSB                                               31
#define TXPCU_TXBUF_DATA_272_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_272_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_272_MASK) >> TXPCU_TXBUF_DATA_272_LSB)
#define TXPCU_TXBUF_DATA_272_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_272_LSB) & TXPCU_TXBUF_DATA_272_MASK)
#define TXPCU_TXBUF_DATA_272_RESET                                             0x0
#define TXPCU_TXBUF_272_ADDRESS                                                (0x1440 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_272_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_272_RESET                                                  0x0

// 0x1444 (TXPCU_TXBUF_273)
#define TXPCU_TXBUF_DATA_273_LSB                                               0
#define TXPCU_TXBUF_DATA_273_MSB                                               31
#define TXPCU_TXBUF_DATA_273_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_273_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_273_MASK) >> TXPCU_TXBUF_DATA_273_LSB)
#define TXPCU_TXBUF_DATA_273_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_273_LSB) & TXPCU_TXBUF_DATA_273_MASK)
#define TXPCU_TXBUF_DATA_273_RESET                                             0x0
#define TXPCU_TXBUF_273_ADDRESS                                                (0x1444 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_273_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_273_RESET                                                  0x0

// 0x1448 (TXPCU_TXBUF_274)
#define TXPCU_TXBUF_DATA_274_LSB                                               0
#define TXPCU_TXBUF_DATA_274_MSB                                               31
#define TXPCU_TXBUF_DATA_274_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_274_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_274_MASK) >> TXPCU_TXBUF_DATA_274_LSB)
#define TXPCU_TXBUF_DATA_274_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_274_LSB) & TXPCU_TXBUF_DATA_274_MASK)
#define TXPCU_TXBUF_DATA_274_RESET                                             0x0
#define TXPCU_TXBUF_274_ADDRESS                                                (0x1448 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_274_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_274_RESET                                                  0x0

// 0x144c (TXPCU_TXBUF_275)
#define TXPCU_TXBUF_DATA_275_LSB                                               0
#define TXPCU_TXBUF_DATA_275_MSB                                               31
#define TXPCU_TXBUF_DATA_275_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_275_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_275_MASK) >> TXPCU_TXBUF_DATA_275_LSB)
#define TXPCU_TXBUF_DATA_275_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_275_LSB) & TXPCU_TXBUF_DATA_275_MASK)
#define TXPCU_TXBUF_DATA_275_RESET                                             0x0
#define TXPCU_TXBUF_275_ADDRESS                                                (0x144c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_275_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_275_RESET                                                  0x0

// 0x1450 (TXPCU_TXBUF_276)
#define TXPCU_TXBUF_DATA_276_LSB                                               0
#define TXPCU_TXBUF_DATA_276_MSB                                               31
#define TXPCU_TXBUF_DATA_276_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_276_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_276_MASK) >> TXPCU_TXBUF_DATA_276_LSB)
#define TXPCU_TXBUF_DATA_276_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_276_LSB) & TXPCU_TXBUF_DATA_276_MASK)
#define TXPCU_TXBUF_DATA_276_RESET                                             0x0
#define TXPCU_TXBUF_276_ADDRESS                                                (0x1450 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_276_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_276_RESET                                                  0x0

// 0x1454 (TXPCU_TXBUF_277)
#define TXPCU_TXBUF_DATA_277_LSB                                               0
#define TXPCU_TXBUF_DATA_277_MSB                                               31
#define TXPCU_TXBUF_DATA_277_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_277_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_277_MASK) >> TXPCU_TXBUF_DATA_277_LSB)
#define TXPCU_TXBUF_DATA_277_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_277_LSB) & TXPCU_TXBUF_DATA_277_MASK)
#define TXPCU_TXBUF_DATA_277_RESET                                             0x0
#define TXPCU_TXBUF_277_ADDRESS                                                (0x1454 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_277_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_277_RESET                                                  0x0

// 0x1458 (TXPCU_TXBUF_278)
#define TXPCU_TXBUF_DATA_278_LSB                                               0
#define TXPCU_TXBUF_DATA_278_MSB                                               31
#define TXPCU_TXBUF_DATA_278_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_278_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_278_MASK) >> TXPCU_TXBUF_DATA_278_LSB)
#define TXPCU_TXBUF_DATA_278_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_278_LSB) & TXPCU_TXBUF_DATA_278_MASK)
#define TXPCU_TXBUF_DATA_278_RESET                                             0x0
#define TXPCU_TXBUF_278_ADDRESS                                                (0x1458 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_278_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_278_RESET                                                  0x0

// 0x145c (TXPCU_TXBUF_279)
#define TXPCU_TXBUF_DATA_279_LSB                                               0
#define TXPCU_TXBUF_DATA_279_MSB                                               31
#define TXPCU_TXBUF_DATA_279_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_279_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_279_MASK) >> TXPCU_TXBUF_DATA_279_LSB)
#define TXPCU_TXBUF_DATA_279_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_279_LSB) & TXPCU_TXBUF_DATA_279_MASK)
#define TXPCU_TXBUF_DATA_279_RESET                                             0x0
#define TXPCU_TXBUF_279_ADDRESS                                                (0x145c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_279_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_279_RESET                                                  0x0

// 0x1460 (TXPCU_TXBUF_280)
#define TXPCU_TXBUF_DATA_280_LSB                                               0
#define TXPCU_TXBUF_DATA_280_MSB                                               31
#define TXPCU_TXBUF_DATA_280_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_280_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_280_MASK) >> TXPCU_TXBUF_DATA_280_LSB)
#define TXPCU_TXBUF_DATA_280_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_280_LSB) & TXPCU_TXBUF_DATA_280_MASK)
#define TXPCU_TXBUF_DATA_280_RESET                                             0x0
#define TXPCU_TXBUF_280_ADDRESS                                                (0x1460 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_280_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_280_RESET                                                  0x0

// 0x1464 (TXPCU_TXBUF_281)
#define TXPCU_TXBUF_DATA_281_LSB                                               0
#define TXPCU_TXBUF_DATA_281_MSB                                               31
#define TXPCU_TXBUF_DATA_281_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_281_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_281_MASK) >> TXPCU_TXBUF_DATA_281_LSB)
#define TXPCU_TXBUF_DATA_281_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_281_LSB) & TXPCU_TXBUF_DATA_281_MASK)
#define TXPCU_TXBUF_DATA_281_RESET                                             0x0
#define TXPCU_TXBUF_281_ADDRESS                                                (0x1464 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_281_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_281_RESET                                                  0x0

// 0x1468 (TXPCU_TXBUF_282)
#define TXPCU_TXBUF_DATA_282_LSB                                               0
#define TXPCU_TXBUF_DATA_282_MSB                                               31
#define TXPCU_TXBUF_DATA_282_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_282_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_282_MASK) >> TXPCU_TXBUF_DATA_282_LSB)
#define TXPCU_TXBUF_DATA_282_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_282_LSB) & TXPCU_TXBUF_DATA_282_MASK)
#define TXPCU_TXBUF_DATA_282_RESET                                             0x0
#define TXPCU_TXBUF_282_ADDRESS                                                (0x1468 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_282_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_282_RESET                                                  0x0

// 0x146c (TXPCU_TXBUF_283)
#define TXPCU_TXBUF_DATA_283_LSB                                               0
#define TXPCU_TXBUF_DATA_283_MSB                                               31
#define TXPCU_TXBUF_DATA_283_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_283_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_283_MASK) >> TXPCU_TXBUF_DATA_283_LSB)
#define TXPCU_TXBUF_DATA_283_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_283_LSB) & TXPCU_TXBUF_DATA_283_MASK)
#define TXPCU_TXBUF_DATA_283_RESET                                             0x0
#define TXPCU_TXBUF_283_ADDRESS                                                (0x146c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_283_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_283_RESET                                                  0x0

// 0x1470 (TXPCU_TXBUF_284)
#define TXPCU_TXBUF_DATA_284_LSB                                               0
#define TXPCU_TXBUF_DATA_284_MSB                                               31
#define TXPCU_TXBUF_DATA_284_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_284_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_284_MASK) >> TXPCU_TXBUF_DATA_284_LSB)
#define TXPCU_TXBUF_DATA_284_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_284_LSB) & TXPCU_TXBUF_DATA_284_MASK)
#define TXPCU_TXBUF_DATA_284_RESET                                             0x0
#define TXPCU_TXBUF_284_ADDRESS                                                (0x1470 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_284_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_284_RESET                                                  0x0

// 0x1474 (TXPCU_TXBUF_285)
#define TXPCU_TXBUF_DATA_285_LSB                                               0
#define TXPCU_TXBUF_DATA_285_MSB                                               31
#define TXPCU_TXBUF_DATA_285_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_285_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_285_MASK) >> TXPCU_TXBUF_DATA_285_LSB)
#define TXPCU_TXBUF_DATA_285_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_285_LSB) & TXPCU_TXBUF_DATA_285_MASK)
#define TXPCU_TXBUF_DATA_285_RESET                                             0x0
#define TXPCU_TXBUF_285_ADDRESS                                                (0x1474 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_285_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_285_RESET                                                  0x0

// 0x1478 (TXPCU_TXBUF_286)
#define TXPCU_TXBUF_DATA_286_LSB                                               0
#define TXPCU_TXBUF_DATA_286_MSB                                               31
#define TXPCU_TXBUF_DATA_286_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_286_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_286_MASK) >> TXPCU_TXBUF_DATA_286_LSB)
#define TXPCU_TXBUF_DATA_286_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_286_LSB) & TXPCU_TXBUF_DATA_286_MASK)
#define TXPCU_TXBUF_DATA_286_RESET                                             0x0
#define TXPCU_TXBUF_286_ADDRESS                                                (0x1478 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_286_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_286_RESET                                                  0x0

// 0x147c (TXPCU_TXBUF_287)
#define TXPCU_TXBUF_DATA_287_LSB                                               0
#define TXPCU_TXBUF_DATA_287_MSB                                               31
#define TXPCU_TXBUF_DATA_287_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_287_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_287_MASK) >> TXPCU_TXBUF_DATA_287_LSB)
#define TXPCU_TXBUF_DATA_287_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_287_LSB) & TXPCU_TXBUF_DATA_287_MASK)
#define TXPCU_TXBUF_DATA_287_RESET                                             0x0
#define TXPCU_TXBUF_287_ADDRESS                                                (0x147c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_287_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_287_RESET                                                  0x0

// 0x1480 (TXPCU_TXBUF_288)
#define TXPCU_TXBUF_DATA_288_LSB                                               0
#define TXPCU_TXBUF_DATA_288_MSB                                               31
#define TXPCU_TXBUF_DATA_288_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_288_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_288_MASK) >> TXPCU_TXBUF_DATA_288_LSB)
#define TXPCU_TXBUF_DATA_288_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_288_LSB) & TXPCU_TXBUF_DATA_288_MASK)
#define TXPCU_TXBUF_DATA_288_RESET                                             0x0
#define TXPCU_TXBUF_288_ADDRESS                                                (0x1480 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_288_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_288_RESET                                                  0x0

// 0x1484 (TXPCU_TXBUF_289)
#define TXPCU_TXBUF_DATA_289_LSB                                               0
#define TXPCU_TXBUF_DATA_289_MSB                                               31
#define TXPCU_TXBUF_DATA_289_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_289_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_289_MASK) >> TXPCU_TXBUF_DATA_289_LSB)
#define TXPCU_TXBUF_DATA_289_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_289_LSB) & TXPCU_TXBUF_DATA_289_MASK)
#define TXPCU_TXBUF_DATA_289_RESET                                             0x0
#define TXPCU_TXBUF_289_ADDRESS                                                (0x1484 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_289_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_289_RESET                                                  0x0

// 0x1488 (TXPCU_TXBUF_290)
#define TXPCU_TXBUF_DATA_290_LSB                                               0
#define TXPCU_TXBUF_DATA_290_MSB                                               31
#define TXPCU_TXBUF_DATA_290_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_290_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_290_MASK) >> TXPCU_TXBUF_DATA_290_LSB)
#define TXPCU_TXBUF_DATA_290_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_290_LSB) & TXPCU_TXBUF_DATA_290_MASK)
#define TXPCU_TXBUF_DATA_290_RESET                                             0x0
#define TXPCU_TXBUF_290_ADDRESS                                                (0x1488 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_290_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_290_RESET                                                  0x0

// 0x148c (TXPCU_TXBUF_291)
#define TXPCU_TXBUF_DATA_291_LSB                                               0
#define TXPCU_TXBUF_DATA_291_MSB                                               31
#define TXPCU_TXBUF_DATA_291_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_291_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_291_MASK) >> TXPCU_TXBUF_DATA_291_LSB)
#define TXPCU_TXBUF_DATA_291_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_291_LSB) & TXPCU_TXBUF_DATA_291_MASK)
#define TXPCU_TXBUF_DATA_291_RESET                                             0x0
#define TXPCU_TXBUF_291_ADDRESS                                                (0x148c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_291_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_291_RESET                                                  0x0

// 0x1490 (TXPCU_TXBUF_292)
#define TXPCU_TXBUF_DATA_292_LSB                                               0
#define TXPCU_TXBUF_DATA_292_MSB                                               31
#define TXPCU_TXBUF_DATA_292_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_292_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_292_MASK) >> TXPCU_TXBUF_DATA_292_LSB)
#define TXPCU_TXBUF_DATA_292_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_292_LSB) & TXPCU_TXBUF_DATA_292_MASK)
#define TXPCU_TXBUF_DATA_292_RESET                                             0x0
#define TXPCU_TXBUF_292_ADDRESS                                                (0x1490 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_292_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_292_RESET                                                  0x0

// 0x1494 (TXPCU_TXBUF_293)
#define TXPCU_TXBUF_DATA_293_LSB                                               0
#define TXPCU_TXBUF_DATA_293_MSB                                               31
#define TXPCU_TXBUF_DATA_293_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_293_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_293_MASK) >> TXPCU_TXBUF_DATA_293_LSB)
#define TXPCU_TXBUF_DATA_293_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_293_LSB) & TXPCU_TXBUF_DATA_293_MASK)
#define TXPCU_TXBUF_DATA_293_RESET                                             0x0
#define TXPCU_TXBUF_293_ADDRESS                                                (0x1494 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_293_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_293_RESET                                                  0x0

// 0x1498 (TXPCU_TXBUF_294)
#define TXPCU_TXBUF_DATA_294_LSB                                               0
#define TXPCU_TXBUF_DATA_294_MSB                                               31
#define TXPCU_TXBUF_DATA_294_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_294_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_294_MASK) >> TXPCU_TXBUF_DATA_294_LSB)
#define TXPCU_TXBUF_DATA_294_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_294_LSB) & TXPCU_TXBUF_DATA_294_MASK)
#define TXPCU_TXBUF_DATA_294_RESET                                             0x0
#define TXPCU_TXBUF_294_ADDRESS                                                (0x1498 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_294_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_294_RESET                                                  0x0

// 0x149c (TXPCU_TXBUF_295)
#define TXPCU_TXBUF_DATA_295_LSB                                               0
#define TXPCU_TXBUF_DATA_295_MSB                                               31
#define TXPCU_TXBUF_DATA_295_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_295_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_295_MASK) >> TXPCU_TXBUF_DATA_295_LSB)
#define TXPCU_TXBUF_DATA_295_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_295_LSB) & TXPCU_TXBUF_DATA_295_MASK)
#define TXPCU_TXBUF_DATA_295_RESET                                             0x0
#define TXPCU_TXBUF_295_ADDRESS                                                (0x149c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_295_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_295_RESET                                                  0x0

// 0x14a0 (TXPCU_TXBUF_296)
#define TXPCU_TXBUF_DATA_296_LSB                                               0
#define TXPCU_TXBUF_DATA_296_MSB                                               31
#define TXPCU_TXBUF_DATA_296_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_296_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_296_MASK) >> TXPCU_TXBUF_DATA_296_LSB)
#define TXPCU_TXBUF_DATA_296_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_296_LSB) & TXPCU_TXBUF_DATA_296_MASK)
#define TXPCU_TXBUF_DATA_296_RESET                                             0x0
#define TXPCU_TXBUF_296_ADDRESS                                                (0x14a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_296_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_296_RESET                                                  0x0

// 0x14a4 (TXPCU_TXBUF_297)
#define TXPCU_TXBUF_DATA_297_LSB                                               0
#define TXPCU_TXBUF_DATA_297_MSB                                               31
#define TXPCU_TXBUF_DATA_297_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_297_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_297_MASK) >> TXPCU_TXBUF_DATA_297_LSB)
#define TXPCU_TXBUF_DATA_297_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_297_LSB) & TXPCU_TXBUF_DATA_297_MASK)
#define TXPCU_TXBUF_DATA_297_RESET                                             0x0
#define TXPCU_TXBUF_297_ADDRESS                                                (0x14a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_297_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_297_RESET                                                  0x0

// 0x14a8 (TXPCU_TXBUF_298)
#define TXPCU_TXBUF_DATA_298_LSB                                               0
#define TXPCU_TXBUF_DATA_298_MSB                                               31
#define TXPCU_TXBUF_DATA_298_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_298_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_298_MASK) >> TXPCU_TXBUF_DATA_298_LSB)
#define TXPCU_TXBUF_DATA_298_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_298_LSB) & TXPCU_TXBUF_DATA_298_MASK)
#define TXPCU_TXBUF_DATA_298_RESET                                             0x0
#define TXPCU_TXBUF_298_ADDRESS                                                (0x14a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_298_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_298_RESET                                                  0x0

// 0x14ac (TXPCU_TXBUF_299)
#define TXPCU_TXBUF_DATA_299_LSB                                               0
#define TXPCU_TXBUF_DATA_299_MSB                                               31
#define TXPCU_TXBUF_DATA_299_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_299_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_299_MASK) >> TXPCU_TXBUF_DATA_299_LSB)
#define TXPCU_TXBUF_DATA_299_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_299_LSB) & TXPCU_TXBUF_DATA_299_MASK)
#define TXPCU_TXBUF_DATA_299_RESET                                             0x0
#define TXPCU_TXBUF_299_ADDRESS                                                (0x14ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_299_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_299_RESET                                                  0x0

// 0x14b0 (TXPCU_TXBUF_300)
#define TXPCU_TXBUF_DATA_300_LSB                                               0
#define TXPCU_TXBUF_DATA_300_MSB                                               31
#define TXPCU_TXBUF_DATA_300_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_300_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_300_MASK) >> TXPCU_TXBUF_DATA_300_LSB)
#define TXPCU_TXBUF_DATA_300_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_300_LSB) & TXPCU_TXBUF_DATA_300_MASK)
#define TXPCU_TXBUF_DATA_300_RESET                                             0x0
#define TXPCU_TXBUF_300_ADDRESS                                                (0x14b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_300_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_300_RESET                                                  0x0

// 0x14b4 (TXPCU_TXBUF_301)
#define TXPCU_TXBUF_DATA_301_LSB                                               0
#define TXPCU_TXBUF_DATA_301_MSB                                               31
#define TXPCU_TXBUF_DATA_301_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_301_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_301_MASK) >> TXPCU_TXBUF_DATA_301_LSB)
#define TXPCU_TXBUF_DATA_301_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_301_LSB) & TXPCU_TXBUF_DATA_301_MASK)
#define TXPCU_TXBUF_DATA_301_RESET                                             0x0
#define TXPCU_TXBUF_301_ADDRESS                                                (0x14b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_301_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_301_RESET                                                  0x0

// 0x14b8 (TXPCU_TXBUF_302)
#define TXPCU_TXBUF_DATA_302_LSB                                               0
#define TXPCU_TXBUF_DATA_302_MSB                                               31
#define TXPCU_TXBUF_DATA_302_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_302_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_302_MASK) >> TXPCU_TXBUF_DATA_302_LSB)
#define TXPCU_TXBUF_DATA_302_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_302_LSB) & TXPCU_TXBUF_DATA_302_MASK)
#define TXPCU_TXBUF_DATA_302_RESET                                             0x0
#define TXPCU_TXBUF_302_ADDRESS                                                (0x14b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_302_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_302_RESET                                                  0x0

// 0x14bc (TXPCU_TXBUF_303)
#define TXPCU_TXBUF_DATA_303_LSB                                               0
#define TXPCU_TXBUF_DATA_303_MSB                                               31
#define TXPCU_TXBUF_DATA_303_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_303_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_303_MASK) >> TXPCU_TXBUF_DATA_303_LSB)
#define TXPCU_TXBUF_DATA_303_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_303_LSB) & TXPCU_TXBUF_DATA_303_MASK)
#define TXPCU_TXBUF_DATA_303_RESET                                             0x0
#define TXPCU_TXBUF_303_ADDRESS                                                (0x14bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_303_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_303_RESET                                                  0x0

// 0x14c0 (TXPCU_TXBUF_304)
#define TXPCU_TXBUF_DATA_304_LSB                                               0
#define TXPCU_TXBUF_DATA_304_MSB                                               31
#define TXPCU_TXBUF_DATA_304_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_304_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_304_MASK) >> TXPCU_TXBUF_DATA_304_LSB)
#define TXPCU_TXBUF_DATA_304_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_304_LSB) & TXPCU_TXBUF_DATA_304_MASK)
#define TXPCU_TXBUF_DATA_304_RESET                                             0x0
#define TXPCU_TXBUF_304_ADDRESS                                                (0x14c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_304_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_304_RESET                                                  0x0

// 0x14c4 (TXPCU_TXBUF_305)
#define TXPCU_TXBUF_DATA_305_LSB                                               0
#define TXPCU_TXBUF_DATA_305_MSB                                               31
#define TXPCU_TXBUF_DATA_305_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_305_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_305_MASK) >> TXPCU_TXBUF_DATA_305_LSB)
#define TXPCU_TXBUF_DATA_305_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_305_LSB) & TXPCU_TXBUF_DATA_305_MASK)
#define TXPCU_TXBUF_DATA_305_RESET                                             0x0
#define TXPCU_TXBUF_305_ADDRESS                                                (0x14c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_305_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_305_RESET                                                  0x0

// 0x14c8 (TXPCU_TXBUF_306)
#define TXPCU_TXBUF_DATA_306_LSB                                               0
#define TXPCU_TXBUF_DATA_306_MSB                                               31
#define TXPCU_TXBUF_DATA_306_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_306_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_306_MASK) >> TXPCU_TXBUF_DATA_306_LSB)
#define TXPCU_TXBUF_DATA_306_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_306_LSB) & TXPCU_TXBUF_DATA_306_MASK)
#define TXPCU_TXBUF_DATA_306_RESET                                             0x0
#define TXPCU_TXBUF_306_ADDRESS                                                (0x14c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_306_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_306_RESET                                                  0x0

// 0x14cc (TXPCU_TXBUF_307)
#define TXPCU_TXBUF_DATA_307_LSB                                               0
#define TXPCU_TXBUF_DATA_307_MSB                                               31
#define TXPCU_TXBUF_DATA_307_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_307_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_307_MASK) >> TXPCU_TXBUF_DATA_307_LSB)
#define TXPCU_TXBUF_DATA_307_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_307_LSB) & TXPCU_TXBUF_DATA_307_MASK)
#define TXPCU_TXBUF_DATA_307_RESET                                             0x0
#define TXPCU_TXBUF_307_ADDRESS                                                (0x14cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_307_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_307_RESET                                                  0x0

// 0x14d0 (TXPCU_TXBUF_308)
#define TXPCU_TXBUF_DATA_308_LSB                                               0
#define TXPCU_TXBUF_DATA_308_MSB                                               31
#define TXPCU_TXBUF_DATA_308_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_308_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_308_MASK) >> TXPCU_TXBUF_DATA_308_LSB)
#define TXPCU_TXBUF_DATA_308_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_308_LSB) & TXPCU_TXBUF_DATA_308_MASK)
#define TXPCU_TXBUF_DATA_308_RESET                                             0x0
#define TXPCU_TXBUF_308_ADDRESS                                                (0x14d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_308_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_308_RESET                                                  0x0

// 0x14d4 (TXPCU_TXBUF_309)
#define TXPCU_TXBUF_DATA_309_LSB                                               0
#define TXPCU_TXBUF_DATA_309_MSB                                               31
#define TXPCU_TXBUF_DATA_309_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_309_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_309_MASK) >> TXPCU_TXBUF_DATA_309_LSB)
#define TXPCU_TXBUF_DATA_309_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_309_LSB) & TXPCU_TXBUF_DATA_309_MASK)
#define TXPCU_TXBUF_DATA_309_RESET                                             0x0
#define TXPCU_TXBUF_309_ADDRESS                                                (0x14d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_309_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_309_RESET                                                  0x0

// 0x14d8 (TXPCU_TXBUF_310)
#define TXPCU_TXBUF_DATA_310_LSB                                               0
#define TXPCU_TXBUF_DATA_310_MSB                                               31
#define TXPCU_TXBUF_DATA_310_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_310_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_310_MASK) >> TXPCU_TXBUF_DATA_310_LSB)
#define TXPCU_TXBUF_DATA_310_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_310_LSB) & TXPCU_TXBUF_DATA_310_MASK)
#define TXPCU_TXBUF_DATA_310_RESET                                             0x0
#define TXPCU_TXBUF_310_ADDRESS                                                (0x14d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_310_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_310_RESET                                                  0x0

// 0x14dc (TXPCU_TXBUF_311)
#define TXPCU_TXBUF_DATA_311_LSB                                               0
#define TXPCU_TXBUF_DATA_311_MSB                                               31
#define TXPCU_TXBUF_DATA_311_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_311_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_311_MASK) >> TXPCU_TXBUF_DATA_311_LSB)
#define TXPCU_TXBUF_DATA_311_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_311_LSB) & TXPCU_TXBUF_DATA_311_MASK)
#define TXPCU_TXBUF_DATA_311_RESET                                             0x0
#define TXPCU_TXBUF_311_ADDRESS                                                (0x14dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_311_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_311_RESET                                                  0x0

// 0x14e0 (TXPCU_TXBUF_312)
#define TXPCU_TXBUF_DATA_312_LSB                                               0
#define TXPCU_TXBUF_DATA_312_MSB                                               31
#define TXPCU_TXBUF_DATA_312_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_312_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_312_MASK) >> TXPCU_TXBUF_DATA_312_LSB)
#define TXPCU_TXBUF_DATA_312_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_312_LSB) & TXPCU_TXBUF_DATA_312_MASK)
#define TXPCU_TXBUF_DATA_312_RESET                                             0x0
#define TXPCU_TXBUF_312_ADDRESS                                                (0x14e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_312_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_312_RESET                                                  0x0

// 0x14e4 (TXPCU_TXBUF_313)
#define TXPCU_TXBUF_DATA_313_LSB                                               0
#define TXPCU_TXBUF_DATA_313_MSB                                               31
#define TXPCU_TXBUF_DATA_313_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_313_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_313_MASK) >> TXPCU_TXBUF_DATA_313_LSB)
#define TXPCU_TXBUF_DATA_313_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_313_LSB) & TXPCU_TXBUF_DATA_313_MASK)
#define TXPCU_TXBUF_DATA_313_RESET                                             0x0
#define TXPCU_TXBUF_313_ADDRESS                                                (0x14e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_313_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_313_RESET                                                  0x0

// 0x14e8 (TXPCU_TXBUF_314)
#define TXPCU_TXBUF_DATA_314_LSB                                               0
#define TXPCU_TXBUF_DATA_314_MSB                                               31
#define TXPCU_TXBUF_DATA_314_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_314_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_314_MASK) >> TXPCU_TXBUF_DATA_314_LSB)
#define TXPCU_TXBUF_DATA_314_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_314_LSB) & TXPCU_TXBUF_DATA_314_MASK)
#define TXPCU_TXBUF_DATA_314_RESET                                             0x0
#define TXPCU_TXBUF_314_ADDRESS                                                (0x14e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_314_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_314_RESET                                                  0x0

// 0x14ec (TXPCU_TXBUF_315)
#define TXPCU_TXBUF_DATA_315_LSB                                               0
#define TXPCU_TXBUF_DATA_315_MSB                                               31
#define TXPCU_TXBUF_DATA_315_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_315_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_315_MASK) >> TXPCU_TXBUF_DATA_315_LSB)
#define TXPCU_TXBUF_DATA_315_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_315_LSB) & TXPCU_TXBUF_DATA_315_MASK)
#define TXPCU_TXBUF_DATA_315_RESET                                             0x0
#define TXPCU_TXBUF_315_ADDRESS                                                (0x14ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_315_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_315_RESET                                                  0x0

// 0x14f0 (TXPCU_TXBUF_316)
#define TXPCU_TXBUF_DATA_316_LSB                                               0
#define TXPCU_TXBUF_DATA_316_MSB                                               31
#define TXPCU_TXBUF_DATA_316_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_316_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_316_MASK) >> TXPCU_TXBUF_DATA_316_LSB)
#define TXPCU_TXBUF_DATA_316_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_316_LSB) & TXPCU_TXBUF_DATA_316_MASK)
#define TXPCU_TXBUF_DATA_316_RESET                                             0x0
#define TXPCU_TXBUF_316_ADDRESS                                                (0x14f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_316_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_316_RESET                                                  0x0

// 0x14f4 (TXPCU_TXBUF_317)
#define TXPCU_TXBUF_DATA_317_LSB                                               0
#define TXPCU_TXBUF_DATA_317_MSB                                               31
#define TXPCU_TXBUF_DATA_317_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_317_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_317_MASK) >> TXPCU_TXBUF_DATA_317_LSB)
#define TXPCU_TXBUF_DATA_317_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_317_LSB) & TXPCU_TXBUF_DATA_317_MASK)
#define TXPCU_TXBUF_DATA_317_RESET                                             0x0
#define TXPCU_TXBUF_317_ADDRESS                                                (0x14f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_317_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_317_RESET                                                  0x0

// 0x14f8 (TXPCU_TXBUF_318)
#define TXPCU_TXBUF_DATA_318_LSB                                               0
#define TXPCU_TXBUF_DATA_318_MSB                                               31
#define TXPCU_TXBUF_DATA_318_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_318_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_318_MASK) >> TXPCU_TXBUF_DATA_318_LSB)
#define TXPCU_TXBUF_DATA_318_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_318_LSB) & TXPCU_TXBUF_DATA_318_MASK)
#define TXPCU_TXBUF_DATA_318_RESET                                             0x0
#define TXPCU_TXBUF_318_ADDRESS                                                (0x14f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_318_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_318_RESET                                                  0x0

// 0x14fc (TXPCU_TXBUF_319)
#define TXPCU_TXBUF_DATA_319_LSB                                               0
#define TXPCU_TXBUF_DATA_319_MSB                                               31
#define TXPCU_TXBUF_DATA_319_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_319_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_319_MASK) >> TXPCU_TXBUF_DATA_319_LSB)
#define TXPCU_TXBUF_DATA_319_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_319_LSB) & TXPCU_TXBUF_DATA_319_MASK)
#define TXPCU_TXBUF_DATA_319_RESET                                             0x0
#define TXPCU_TXBUF_319_ADDRESS                                                (0x14fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_319_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_319_RESET                                                  0x0

// 0x1500 (TXPCU_TXBUF_320)
#define TXPCU_TXBUF_DATA_320_LSB                                               0
#define TXPCU_TXBUF_DATA_320_MSB                                               31
#define TXPCU_TXBUF_DATA_320_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_320_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_320_MASK) >> TXPCU_TXBUF_DATA_320_LSB)
#define TXPCU_TXBUF_DATA_320_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_320_LSB) & TXPCU_TXBUF_DATA_320_MASK)
#define TXPCU_TXBUF_DATA_320_RESET                                             0x0
#define TXPCU_TXBUF_320_ADDRESS                                                (0x1500 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_320_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_320_RESET                                                  0x0

// 0x1504 (TXPCU_TXBUF_321)
#define TXPCU_TXBUF_DATA_321_LSB                                               0
#define TXPCU_TXBUF_DATA_321_MSB                                               31
#define TXPCU_TXBUF_DATA_321_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_321_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_321_MASK) >> TXPCU_TXBUF_DATA_321_LSB)
#define TXPCU_TXBUF_DATA_321_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_321_LSB) & TXPCU_TXBUF_DATA_321_MASK)
#define TXPCU_TXBUF_DATA_321_RESET                                             0x0
#define TXPCU_TXBUF_321_ADDRESS                                                (0x1504 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_321_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_321_RESET                                                  0x0

// 0x1508 (TXPCU_TXBUF_322)
#define TXPCU_TXBUF_DATA_322_LSB                                               0
#define TXPCU_TXBUF_DATA_322_MSB                                               31
#define TXPCU_TXBUF_DATA_322_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_322_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_322_MASK) >> TXPCU_TXBUF_DATA_322_LSB)
#define TXPCU_TXBUF_DATA_322_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_322_LSB) & TXPCU_TXBUF_DATA_322_MASK)
#define TXPCU_TXBUF_DATA_322_RESET                                             0x0
#define TXPCU_TXBUF_322_ADDRESS                                                (0x1508 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_322_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_322_RESET                                                  0x0

// 0x150c (TXPCU_TXBUF_323)
#define TXPCU_TXBUF_DATA_323_LSB                                               0
#define TXPCU_TXBUF_DATA_323_MSB                                               31
#define TXPCU_TXBUF_DATA_323_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_323_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_323_MASK) >> TXPCU_TXBUF_DATA_323_LSB)
#define TXPCU_TXBUF_DATA_323_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_323_LSB) & TXPCU_TXBUF_DATA_323_MASK)
#define TXPCU_TXBUF_DATA_323_RESET                                             0x0
#define TXPCU_TXBUF_323_ADDRESS                                                (0x150c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_323_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_323_RESET                                                  0x0

// 0x1510 (TXPCU_TXBUF_324)
#define TXPCU_TXBUF_DATA_324_LSB                                               0
#define TXPCU_TXBUF_DATA_324_MSB                                               31
#define TXPCU_TXBUF_DATA_324_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_324_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_324_MASK) >> TXPCU_TXBUF_DATA_324_LSB)
#define TXPCU_TXBUF_DATA_324_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_324_LSB) & TXPCU_TXBUF_DATA_324_MASK)
#define TXPCU_TXBUF_DATA_324_RESET                                             0x0
#define TXPCU_TXBUF_324_ADDRESS                                                (0x1510 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_324_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_324_RESET                                                  0x0

// 0x1514 (TXPCU_TXBUF_325)
#define TXPCU_TXBUF_DATA_325_LSB                                               0
#define TXPCU_TXBUF_DATA_325_MSB                                               31
#define TXPCU_TXBUF_DATA_325_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_325_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_325_MASK) >> TXPCU_TXBUF_DATA_325_LSB)
#define TXPCU_TXBUF_DATA_325_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_325_LSB) & TXPCU_TXBUF_DATA_325_MASK)
#define TXPCU_TXBUF_DATA_325_RESET                                             0x0
#define TXPCU_TXBUF_325_ADDRESS                                                (0x1514 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_325_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_325_RESET                                                  0x0

// 0x1518 (TXPCU_TXBUF_326)
#define TXPCU_TXBUF_DATA_326_LSB                                               0
#define TXPCU_TXBUF_DATA_326_MSB                                               31
#define TXPCU_TXBUF_DATA_326_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_326_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_326_MASK) >> TXPCU_TXBUF_DATA_326_LSB)
#define TXPCU_TXBUF_DATA_326_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_326_LSB) & TXPCU_TXBUF_DATA_326_MASK)
#define TXPCU_TXBUF_DATA_326_RESET                                             0x0
#define TXPCU_TXBUF_326_ADDRESS                                                (0x1518 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_326_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_326_RESET                                                  0x0

// 0x151c (TXPCU_TXBUF_327)
#define TXPCU_TXBUF_DATA_327_LSB                                               0
#define TXPCU_TXBUF_DATA_327_MSB                                               31
#define TXPCU_TXBUF_DATA_327_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_327_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_327_MASK) >> TXPCU_TXBUF_DATA_327_LSB)
#define TXPCU_TXBUF_DATA_327_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_327_LSB) & TXPCU_TXBUF_DATA_327_MASK)
#define TXPCU_TXBUF_DATA_327_RESET                                             0x0
#define TXPCU_TXBUF_327_ADDRESS                                                (0x151c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_327_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_327_RESET                                                  0x0

// 0x1520 (TXPCU_TXBUF_328)
#define TXPCU_TXBUF_DATA_328_LSB                                               0
#define TXPCU_TXBUF_DATA_328_MSB                                               31
#define TXPCU_TXBUF_DATA_328_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_328_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_328_MASK) >> TXPCU_TXBUF_DATA_328_LSB)
#define TXPCU_TXBUF_DATA_328_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_328_LSB) & TXPCU_TXBUF_DATA_328_MASK)
#define TXPCU_TXBUF_DATA_328_RESET                                             0x0
#define TXPCU_TXBUF_328_ADDRESS                                                (0x1520 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_328_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_328_RESET                                                  0x0

// 0x1524 (TXPCU_TXBUF_329)
#define TXPCU_TXBUF_DATA_329_LSB                                               0
#define TXPCU_TXBUF_DATA_329_MSB                                               31
#define TXPCU_TXBUF_DATA_329_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_329_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_329_MASK) >> TXPCU_TXBUF_DATA_329_LSB)
#define TXPCU_TXBUF_DATA_329_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_329_LSB) & TXPCU_TXBUF_DATA_329_MASK)
#define TXPCU_TXBUF_DATA_329_RESET                                             0x0
#define TXPCU_TXBUF_329_ADDRESS                                                (0x1524 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_329_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_329_RESET                                                  0x0

// 0x1528 (TXPCU_TXBUF_330)
#define TXPCU_TXBUF_DATA_330_LSB                                               0
#define TXPCU_TXBUF_DATA_330_MSB                                               31
#define TXPCU_TXBUF_DATA_330_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_330_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_330_MASK) >> TXPCU_TXBUF_DATA_330_LSB)
#define TXPCU_TXBUF_DATA_330_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_330_LSB) & TXPCU_TXBUF_DATA_330_MASK)
#define TXPCU_TXBUF_DATA_330_RESET                                             0x0
#define TXPCU_TXBUF_330_ADDRESS                                                (0x1528 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_330_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_330_RESET                                                  0x0

// 0x152c (TXPCU_TXBUF_331)
#define TXPCU_TXBUF_DATA_331_LSB                                               0
#define TXPCU_TXBUF_DATA_331_MSB                                               31
#define TXPCU_TXBUF_DATA_331_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_331_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_331_MASK) >> TXPCU_TXBUF_DATA_331_LSB)
#define TXPCU_TXBUF_DATA_331_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_331_LSB) & TXPCU_TXBUF_DATA_331_MASK)
#define TXPCU_TXBUF_DATA_331_RESET                                             0x0
#define TXPCU_TXBUF_331_ADDRESS                                                (0x152c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_331_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_331_RESET                                                  0x0

// 0x1530 (TXPCU_TXBUF_332)
#define TXPCU_TXBUF_DATA_332_LSB                                               0
#define TXPCU_TXBUF_DATA_332_MSB                                               31
#define TXPCU_TXBUF_DATA_332_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_332_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_332_MASK) >> TXPCU_TXBUF_DATA_332_LSB)
#define TXPCU_TXBUF_DATA_332_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_332_LSB) & TXPCU_TXBUF_DATA_332_MASK)
#define TXPCU_TXBUF_DATA_332_RESET                                             0x0
#define TXPCU_TXBUF_332_ADDRESS                                                (0x1530 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_332_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_332_RESET                                                  0x0

// 0x1534 (TXPCU_TXBUF_333)
#define TXPCU_TXBUF_DATA_333_LSB                                               0
#define TXPCU_TXBUF_DATA_333_MSB                                               31
#define TXPCU_TXBUF_DATA_333_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_333_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_333_MASK) >> TXPCU_TXBUF_DATA_333_LSB)
#define TXPCU_TXBUF_DATA_333_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_333_LSB) & TXPCU_TXBUF_DATA_333_MASK)
#define TXPCU_TXBUF_DATA_333_RESET                                             0x0
#define TXPCU_TXBUF_333_ADDRESS                                                (0x1534 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_333_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_333_RESET                                                  0x0

// 0x1538 (TXPCU_TXBUF_334)
#define TXPCU_TXBUF_DATA_334_LSB                                               0
#define TXPCU_TXBUF_DATA_334_MSB                                               31
#define TXPCU_TXBUF_DATA_334_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_334_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_334_MASK) >> TXPCU_TXBUF_DATA_334_LSB)
#define TXPCU_TXBUF_DATA_334_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_334_LSB) & TXPCU_TXBUF_DATA_334_MASK)
#define TXPCU_TXBUF_DATA_334_RESET                                             0x0
#define TXPCU_TXBUF_334_ADDRESS                                                (0x1538 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_334_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_334_RESET                                                  0x0

// 0x153c (TXPCU_TXBUF_335)
#define TXPCU_TXBUF_DATA_335_LSB                                               0
#define TXPCU_TXBUF_DATA_335_MSB                                               31
#define TXPCU_TXBUF_DATA_335_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_335_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_335_MASK) >> TXPCU_TXBUF_DATA_335_LSB)
#define TXPCU_TXBUF_DATA_335_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_335_LSB) & TXPCU_TXBUF_DATA_335_MASK)
#define TXPCU_TXBUF_DATA_335_RESET                                             0x0
#define TXPCU_TXBUF_335_ADDRESS                                                (0x153c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_335_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_335_RESET                                                  0x0

// 0x1540 (TXPCU_TXBUF_336)
#define TXPCU_TXBUF_DATA_336_LSB                                               0
#define TXPCU_TXBUF_DATA_336_MSB                                               31
#define TXPCU_TXBUF_DATA_336_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_336_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_336_MASK) >> TXPCU_TXBUF_DATA_336_LSB)
#define TXPCU_TXBUF_DATA_336_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_336_LSB) & TXPCU_TXBUF_DATA_336_MASK)
#define TXPCU_TXBUF_DATA_336_RESET                                             0x0
#define TXPCU_TXBUF_336_ADDRESS                                                (0x1540 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_336_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_336_RESET                                                  0x0

// 0x1544 (TXPCU_TXBUF_337)
#define TXPCU_TXBUF_DATA_337_LSB                                               0
#define TXPCU_TXBUF_DATA_337_MSB                                               31
#define TXPCU_TXBUF_DATA_337_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_337_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_337_MASK) >> TXPCU_TXBUF_DATA_337_LSB)
#define TXPCU_TXBUF_DATA_337_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_337_LSB) & TXPCU_TXBUF_DATA_337_MASK)
#define TXPCU_TXBUF_DATA_337_RESET                                             0x0
#define TXPCU_TXBUF_337_ADDRESS                                                (0x1544 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_337_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_337_RESET                                                  0x0

// 0x1548 (TXPCU_TXBUF_338)
#define TXPCU_TXBUF_DATA_338_LSB                                               0
#define TXPCU_TXBUF_DATA_338_MSB                                               31
#define TXPCU_TXBUF_DATA_338_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_338_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_338_MASK) >> TXPCU_TXBUF_DATA_338_LSB)
#define TXPCU_TXBUF_DATA_338_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_338_LSB) & TXPCU_TXBUF_DATA_338_MASK)
#define TXPCU_TXBUF_DATA_338_RESET                                             0x0
#define TXPCU_TXBUF_338_ADDRESS                                                (0x1548 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_338_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_338_RESET                                                  0x0

// 0x154c (TXPCU_TXBUF_339)
#define TXPCU_TXBUF_DATA_339_LSB                                               0
#define TXPCU_TXBUF_DATA_339_MSB                                               31
#define TXPCU_TXBUF_DATA_339_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_339_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_339_MASK) >> TXPCU_TXBUF_DATA_339_LSB)
#define TXPCU_TXBUF_DATA_339_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_339_LSB) & TXPCU_TXBUF_DATA_339_MASK)
#define TXPCU_TXBUF_DATA_339_RESET                                             0x0
#define TXPCU_TXBUF_339_ADDRESS                                                (0x154c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_339_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_339_RESET                                                  0x0

// 0x1550 (TXPCU_TXBUF_340)
#define TXPCU_TXBUF_DATA_340_LSB                                               0
#define TXPCU_TXBUF_DATA_340_MSB                                               31
#define TXPCU_TXBUF_DATA_340_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_340_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_340_MASK) >> TXPCU_TXBUF_DATA_340_LSB)
#define TXPCU_TXBUF_DATA_340_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_340_LSB) & TXPCU_TXBUF_DATA_340_MASK)
#define TXPCU_TXBUF_DATA_340_RESET                                             0x0
#define TXPCU_TXBUF_340_ADDRESS                                                (0x1550 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_340_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_340_RESET                                                  0x0

// 0x1554 (TXPCU_TXBUF_341)
#define TXPCU_TXBUF_DATA_341_LSB                                               0
#define TXPCU_TXBUF_DATA_341_MSB                                               31
#define TXPCU_TXBUF_DATA_341_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_341_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_341_MASK) >> TXPCU_TXBUF_DATA_341_LSB)
#define TXPCU_TXBUF_DATA_341_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_341_LSB) & TXPCU_TXBUF_DATA_341_MASK)
#define TXPCU_TXBUF_DATA_341_RESET                                             0x0
#define TXPCU_TXBUF_341_ADDRESS                                                (0x1554 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_341_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_341_RESET                                                  0x0

// 0x1558 (TXPCU_TXBUF_342)
#define TXPCU_TXBUF_DATA_342_LSB                                               0
#define TXPCU_TXBUF_DATA_342_MSB                                               31
#define TXPCU_TXBUF_DATA_342_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_342_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_342_MASK) >> TXPCU_TXBUF_DATA_342_LSB)
#define TXPCU_TXBUF_DATA_342_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_342_LSB) & TXPCU_TXBUF_DATA_342_MASK)
#define TXPCU_TXBUF_DATA_342_RESET                                             0x0
#define TXPCU_TXBUF_342_ADDRESS                                                (0x1558 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_342_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_342_RESET                                                  0x0

// 0x155c (TXPCU_TXBUF_343)
#define TXPCU_TXBUF_DATA_343_LSB                                               0
#define TXPCU_TXBUF_DATA_343_MSB                                               31
#define TXPCU_TXBUF_DATA_343_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_343_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_343_MASK) >> TXPCU_TXBUF_DATA_343_LSB)
#define TXPCU_TXBUF_DATA_343_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_343_LSB) & TXPCU_TXBUF_DATA_343_MASK)
#define TXPCU_TXBUF_DATA_343_RESET                                             0x0
#define TXPCU_TXBUF_343_ADDRESS                                                (0x155c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_343_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_343_RESET                                                  0x0

// 0x1560 (TXPCU_TXBUF_344)
#define TXPCU_TXBUF_DATA_344_LSB                                               0
#define TXPCU_TXBUF_DATA_344_MSB                                               31
#define TXPCU_TXBUF_DATA_344_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_344_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_344_MASK) >> TXPCU_TXBUF_DATA_344_LSB)
#define TXPCU_TXBUF_DATA_344_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_344_LSB) & TXPCU_TXBUF_DATA_344_MASK)
#define TXPCU_TXBUF_DATA_344_RESET                                             0x0
#define TXPCU_TXBUF_344_ADDRESS                                                (0x1560 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_344_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_344_RESET                                                  0x0

// 0x1564 (TXPCU_TXBUF_345)
#define TXPCU_TXBUF_DATA_345_LSB                                               0
#define TXPCU_TXBUF_DATA_345_MSB                                               31
#define TXPCU_TXBUF_DATA_345_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_345_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_345_MASK) >> TXPCU_TXBUF_DATA_345_LSB)
#define TXPCU_TXBUF_DATA_345_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_345_LSB) & TXPCU_TXBUF_DATA_345_MASK)
#define TXPCU_TXBUF_DATA_345_RESET                                             0x0
#define TXPCU_TXBUF_345_ADDRESS                                                (0x1564 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_345_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_345_RESET                                                  0x0

// 0x1568 (TXPCU_TXBUF_346)
#define TXPCU_TXBUF_DATA_346_LSB                                               0
#define TXPCU_TXBUF_DATA_346_MSB                                               31
#define TXPCU_TXBUF_DATA_346_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_346_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_346_MASK) >> TXPCU_TXBUF_DATA_346_LSB)
#define TXPCU_TXBUF_DATA_346_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_346_LSB) & TXPCU_TXBUF_DATA_346_MASK)
#define TXPCU_TXBUF_DATA_346_RESET                                             0x0
#define TXPCU_TXBUF_346_ADDRESS                                                (0x1568 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_346_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_346_RESET                                                  0x0

// 0x156c (TXPCU_TXBUF_347)
#define TXPCU_TXBUF_DATA_347_LSB                                               0
#define TXPCU_TXBUF_DATA_347_MSB                                               31
#define TXPCU_TXBUF_DATA_347_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_347_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_347_MASK) >> TXPCU_TXBUF_DATA_347_LSB)
#define TXPCU_TXBUF_DATA_347_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_347_LSB) & TXPCU_TXBUF_DATA_347_MASK)
#define TXPCU_TXBUF_DATA_347_RESET                                             0x0
#define TXPCU_TXBUF_347_ADDRESS                                                (0x156c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_347_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_347_RESET                                                  0x0

// 0x1570 (TXPCU_TXBUF_348)
#define TXPCU_TXBUF_DATA_348_LSB                                               0
#define TXPCU_TXBUF_DATA_348_MSB                                               31
#define TXPCU_TXBUF_DATA_348_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_348_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_348_MASK) >> TXPCU_TXBUF_DATA_348_LSB)
#define TXPCU_TXBUF_DATA_348_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_348_LSB) & TXPCU_TXBUF_DATA_348_MASK)
#define TXPCU_TXBUF_DATA_348_RESET                                             0x0
#define TXPCU_TXBUF_348_ADDRESS                                                (0x1570 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_348_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_348_RESET                                                  0x0

// 0x1574 (TXPCU_TXBUF_349)
#define TXPCU_TXBUF_DATA_349_LSB                                               0
#define TXPCU_TXBUF_DATA_349_MSB                                               31
#define TXPCU_TXBUF_DATA_349_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_349_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_349_MASK) >> TXPCU_TXBUF_DATA_349_LSB)
#define TXPCU_TXBUF_DATA_349_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_349_LSB) & TXPCU_TXBUF_DATA_349_MASK)
#define TXPCU_TXBUF_DATA_349_RESET                                             0x0
#define TXPCU_TXBUF_349_ADDRESS                                                (0x1574 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_349_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_349_RESET                                                  0x0

// 0x1578 (TXPCU_TXBUF_350)
#define TXPCU_TXBUF_DATA_350_LSB                                               0
#define TXPCU_TXBUF_DATA_350_MSB                                               31
#define TXPCU_TXBUF_DATA_350_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_350_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_350_MASK) >> TXPCU_TXBUF_DATA_350_LSB)
#define TXPCU_TXBUF_DATA_350_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_350_LSB) & TXPCU_TXBUF_DATA_350_MASK)
#define TXPCU_TXBUF_DATA_350_RESET                                             0x0
#define TXPCU_TXBUF_350_ADDRESS                                                (0x1578 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_350_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_350_RESET                                                  0x0

// 0x157c (TXPCU_TXBUF_351)
#define TXPCU_TXBUF_DATA_351_LSB                                               0
#define TXPCU_TXBUF_DATA_351_MSB                                               31
#define TXPCU_TXBUF_DATA_351_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_351_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_351_MASK) >> TXPCU_TXBUF_DATA_351_LSB)
#define TXPCU_TXBUF_DATA_351_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_351_LSB) & TXPCU_TXBUF_DATA_351_MASK)
#define TXPCU_TXBUF_DATA_351_RESET                                             0x0
#define TXPCU_TXBUF_351_ADDRESS                                                (0x157c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_351_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_351_RESET                                                  0x0

// 0x1580 (TXPCU_TXBUF_352)
#define TXPCU_TXBUF_DATA_352_LSB                                               0
#define TXPCU_TXBUF_DATA_352_MSB                                               31
#define TXPCU_TXBUF_DATA_352_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_352_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_352_MASK) >> TXPCU_TXBUF_DATA_352_LSB)
#define TXPCU_TXBUF_DATA_352_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_352_LSB) & TXPCU_TXBUF_DATA_352_MASK)
#define TXPCU_TXBUF_DATA_352_RESET                                             0x0
#define TXPCU_TXBUF_352_ADDRESS                                                (0x1580 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_352_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_352_RESET                                                  0x0

// 0x1584 (TXPCU_TXBUF_353)
#define TXPCU_TXBUF_DATA_353_LSB                                               0
#define TXPCU_TXBUF_DATA_353_MSB                                               31
#define TXPCU_TXBUF_DATA_353_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_353_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_353_MASK) >> TXPCU_TXBUF_DATA_353_LSB)
#define TXPCU_TXBUF_DATA_353_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_353_LSB) & TXPCU_TXBUF_DATA_353_MASK)
#define TXPCU_TXBUF_DATA_353_RESET                                             0x0
#define TXPCU_TXBUF_353_ADDRESS                                                (0x1584 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_353_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_353_RESET                                                  0x0

// 0x1588 (TXPCU_TXBUF_354)
#define TXPCU_TXBUF_DATA_354_LSB                                               0
#define TXPCU_TXBUF_DATA_354_MSB                                               31
#define TXPCU_TXBUF_DATA_354_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_354_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_354_MASK) >> TXPCU_TXBUF_DATA_354_LSB)
#define TXPCU_TXBUF_DATA_354_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_354_LSB) & TXPCU_TXBUF_DATA_354_MASK)
#define TXPCU_TXBUF_DATA_354_RESET                                             0x0
#define TXPCU_TXBUF_354_ADDRESS                                                (0x1588 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_354_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_354_RESET                                                  0x0

// 0x158c (TXPCU_TXBUF_355)
#define TXPCU_TXBUF_DATA_355_LSB                                               0
#define TXPCU_TXBUF_DATA_355_MSB                                               31
#define TXPCU_TXBUF_DATA_355_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_355_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_355_MASK) >> TXPCU_TXBUF_DATA_355_LSB)
#define TXPCU_TXBUF_DATA_355_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_355_LSB) & TXPCU_TXBUF_DATA_355_MASK)
#define TXPCU_TXBUF_DATA_355_RESET                                             0x0
#define TXPCU_TXBUF_355_ADDRESS                                                (0x158c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_355_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_355_RESET                                                  0x0

// 0x1590 (TXPCU_TXBUF_356)
#define TXPCU_TXBUF_DATA_356_LSB                                               0
#define TXPCU_TXBUF_DATA_356_MSB                                               31
#define TXPCU_TXBUF_DATA_356_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_356_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_356_MASK) >> TXPCU_TXBUF_DATA_356_LSB)
#define TXPCU_TXBUF_DATA_356_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_356_LSB) & TXPCU_TXBUF_DATA_356_MASK)
#define TXPCU_TXBUF_DATA_356_RESET                                             0x0
#define TXPCU_TXBUF_356_ADDRESS                                                (0x1590 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_356_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_356_RESET                                                  0x0

// 0x1594 (TXPCU_TXBUF_357)
#define TXPCU_TXBUF_DATA_357_LSB                                               0
#define TXPCU_TXBUF_DATA_357_MSB                                               31
#define TXPCU_TXBUF_DATA_357_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_357_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_357_MASK) >> TXPCU_TXBUF_DATA_357_LSB)
#define TXPCU_TXBUF_DATA_357_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_357_LSB) & TXPCU_TXBUF_DATA_357_MASK)
#define TXPCU_TXBUF_DATA_357_RESET                                             0x0
#define TXPCU_TXBUF_357_ADDRESS                                                (0x1594 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_357_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_357_RESET                                                  0x0

// 0x1598 (TXPCU_TXBUF_358)
#define TXPCU_TXBUF_DATA_358_LSB                                               0
#define TXPCU_TXBUF_DATA_358_MSB                                               31
#define TXPCU_TXBUF_DATA_358_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_358_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_358_MASK) >> TXPCU_TXBUF_DATA_358_LSB)
#define TXPCU_TXBUF_DATA_358_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_358_LSB) & TXPCU_TXBUF_DATA_358_MASK)
#define TXPCU_TXBUF_DATA_358_RESET                                             0x0
#define TXPCU_TXBUF_358_ADDRESS                                                (0x1598 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_358_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_358_RESET                                                  0x0

// 0x159c (TXPCU_TXBUF_359)
#define TXPCU_TXBUF_DATA_359_LSB                                               0
#define TXPCU_TXBUF_DATA_359_MSB                                               31
#define TXPCU_TXBUF_DATA_359_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_359_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_359_MASK) >> TXPCU_TXBUF_DATA_359_LSB)
#define TXPCU_TXBUF_DATA_359_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_359_LSB) & TXPCU_TXBUF_DATA_359_MASK)
#define TXPCU_TXBUF_DATA_359_RESET                                             0x0
#define TXPCU_TXBUF_359_ADDRESS                                                (0x159c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_359_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_359_RESET                                                  0x0

// 0x15a0 (TXPCU_TXBUF_360)
#define TXPCU_TXBUF_DATA_360_LSB                                               0
#define TXPCU_TXBUF_DATA_360_MSB                                               31
#define TXPCU_TXBUF_DATA_360_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_360_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_360_MASK) >> TXPCU_TXBUF_DATA_360_LSB)
#define TXPCU_TXBUF_DATA_360_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_360_LSB) & TXPCU_TXBUF_DATA_360_MASK)
#define TXPCU_TXBUF_DATA_360_RESET                                             0x0
#define TXPCU_TXBUF_360_ADDRESS                                                (0x15a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_360_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_360_RESET                                                  0x0

// 0x15a4 (TXPCU_TXBUF_361)
#define TXPCU_TXBUF_DATA_361_LSB                                               0
#define TXPCU_TXBUF_DATA_361_MSB                                               31
#define TXPCU_TXBUF_DATA_361_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_361_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_361_MASK) >> TXPCU_TXBUF_DATA_361_LSB)
#define TXPCU_TXBUF_DATA_361_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_361_LSB) & TXPCU_TXBUF_DATA_361_MASK)
#define TXPCU_TXBUF_DATA_361_RESET                                             0x0
#define TXPCU_TXBUF_361_ADDRESS                                                (0x15a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_361_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_361_RESET                                                  0x0

// 0x15a8 (TXPCU_TXBUF_362)
#define TXPCU_TXBUF_DATA_362_LSB                                               0
#define TXPCU_TXBUF_DATA_362_MSB                                               31
#define TXPCU_TXBUF_DATA_362_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_362_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_362_MASK) >> TXPCU_TXBUF_DATA_362_LSB)
#define TXPCU_TXBUF_DATA_362_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_362_LSB) & TXPCU_TXBUF_DATA_362_MASK)
#define TXPCU_TXBUF_DATA_362_RESET                                             0x0
#define TXPCU_TXBUF_362_ADDRESS                                                (0x15a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_362_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_362_RESET                                                  0x0

// 0x15ac (TXPCU_TXBUF_363)
#define TXPCU_TXBUF_DATA_363_LSB                                               0
#define TXPCU_TXBUF_DATA_363_MSB                                               31
#define TXPCU_TXBUF_DATA_363_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_363_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_363_MASK) >> TXPCU_TXBUF_DATA_363_LSB)
#define TXPCU_TXBUF_DATA_363_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_363_LSB) & TXPCU_TXBUF_DATA_363_MASK)
#define TXPCU_TXBUF_DATA_363_RESET                                             0x0
#define TXPCU_TXBUF_363_ADDRESS                                                (0x15ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_363_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_363_RESET                                                  0x0

// 0x15b0 (TXPCU_TXBUF_364)
#define TXPCU_TXBUF_DATA_364_LSB                                               0
#define TXPCU_TXBUF_DATA_364_MSB                                               31
#define TXPCU_TXBUF_DATA_364_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_364_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_364_MASK) >> TXPCU_TXBUF_DATA_364_LSB)
#define TXPCU_TXBUF_DATA_364_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_364_LSB) & TXPCU_TXBUF_DATA_364_MASK)
#define TXPCU_TXBUF_DATA_364_RESET                                             0x0
#define TXPCU_TXBUF_364_ADDRESS                                                (0x15b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_364_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_364_RESET                                                  0x0

// 0x15b4 (TXPCU_TXBUF_365)
#define TXPCU_TXBUF_DATA_365_LSB                                               0
#define TXPCU_TXBUF_DATA_365_MSB                                               31
#define TXPCU_TXBUF_DATA_365_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_365_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_365_MASK) >> TXPCU_TXBUF_DATA_365_LSB)
#define TXPCU_TXBUF_DATA_365_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_365_LSB) & TXPCU_TXBUF_DATA_365_MASK)
#define TXPCU_TXBUF_DATA_365_RESET                                             0x0
#define TXPCU_TXBUF_365_ADDRESS                                                (0x15b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_365_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_365_RESET                                                  0x0

// 0x15b8 (TXPCU_TXBUF_366)
#define TXPCU_TXBUF_DATA_366_LSB                                               0
#define TXPCU_TXBUF_DATA_366_MSB                                               31
#define TXPCU_TXBUF_DATA_366_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_366_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_366_MASK) >> TXPCU_TXBUF_DATA_366_LSB)
#define TXPCU_TXBUF_DATA_366_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_366_LSB) & TXPCU_TXBUF_DATA_366_MASK)
#define TXPCU_TXBUF_DATA_366_RESET                                             0x0
#define TXPCU_TXBUF_366_ADDRESS                                                (0x15b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_366_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_366_RESET                                                  0x0

// 0x15bc (TXPCU_TXBUF_367)
#define TXPCU_TXBUF_DATA_367_LSB                                               0
#define TXPCU_TXBUF_DATA_367_MSB                                               31
#define TXPCU_TXBUF_DATA_367_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_367_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_367_MASK) >> TXPCU_TXBUF_DATA_367_LSB)
#define TXPCU_TXBUF_DATA_367_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_367_LSB) & TXPCU_TXBUF_DATA_367_MASK)
#define TXPCU_TXBUF_DATA_367_RESET                                             0x0
#define TXPCU_TXBUF_367_ADDRESS                                                (0x15bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_367_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_367_RESET                                                  0x0

// 0x15c0 (TXPCU_TXBUF_368)
#define TXPCU_TXBUF_DATA_368_LSB                                               0
#define TXPCU_TXBUF_DATA_368_MSB                                               31
#define TXPCU_TXBUF_DATA_368_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_368_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_368_MASK) >> TXPCU_TXBUF_DATA_368_LSB)
#define TXPCU_TXBUF_DATA_368_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_368_LSB) & TXPCU_TXBUF_DATA_368_MASK)
#define TXPCU_TXBUF_DATA_368_RESET                                             0x0
#define TXPCU_TXBUF_368_ADDRESS                                                (0x15c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_368_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_368_RESET                                                  0x0

// 0x15c4 (TXPCU_TXBUF_369)
#define TXPCU_TXBUF_DATA_369_LSB                                               0
#define TXPCU_TXBUF_DATA_369_MSB                                               31
#define TXPCU_TXBUF_DATA_369_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_369_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_369_MASK) >> TXPCU_TXBUF_DATA_369_LSB)
#define TXPCU_TXBUF_DATA_369_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_369_LSB) & TXPCU_TXBUF_DATA_369_MASK)
#define TXPCU_TXBUF_DATA_369_RESET                                             0x0
#define TXPCU_TXBUF_369_ADDRESS                                                (0x15c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_369_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_369_RESET                                                  0x0

// 0x15c8 (TXPCU_TXBUF_370)
#define TXPCU_TXBUF_DATA_370_LSB                                               0
#define TXPCU_TXBUF_DATA_370_MSB                                               31
#define TXPCU_TXBUF_DATA_370_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_370_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_370_MASK) >> TXPCU_TXBUF_DATA_370_LSB)
#define TXPCU_TXBUF_DATA_370_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_370_LSB) & TXPCU_TXBUF_DATA_370_MASK)
#define TXPCU_TXBUF_DATA_370_RESET                                             0x0
#define TXPCU_TXBUF_370_ADDRESS                                                (0x15c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_370_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_370_RESET                                                  0x0

// 0x15cc (TXPCU_TXBUF_371)
#define TXPCU_TXBUF_DATA_371_LSB                                               0
#define TXPCU_TXBUF_DATA_371_MSB                                               31
#define TXPCU_TXBUF_DATA_371_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_371_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_371_MASK) >> TXPCU_TXBUF_DATA_371_LSB)
#define TXPCU_TXBUF_DATA_371_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_371_LSB) & TXPCU_TXBUF_DATA_371_MASK)
#define TXPCU_TXBUF_DATA_371_RESET                                             0x0
#define TXPCU_TXBUF_371_ADDRESS                                                (0x15cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_371_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_371_RESET                                                  0x0

// 0x15d0 (TXPCU_TXBUF_372)
#define TXPCU_TXBUF_DATA_372_LSB                                               0
#define TXPCU_TXBUF_DATA_372_MSB                                               31
#define TXPCU_TXBUF_DATA_372_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_372_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_372_MASK) >> TXPCU_TXBUF_DATA_372_LSB)
#define TXPCU_TXBUF_DATA_372_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_372_LSB) & TXPCU_TXBUF_DATA_372_MASK)
#define TXPCU_TXBUF_DATA_372_RESET                                             0x0
#define TXPCU_TXBUF_372_ADDRESS                                                (0x15d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_372_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_372_RESET                                                  0x0

// 0x15d4 (TXPCU_TXBUF_373)
#define TXPCU_TXBUF_DATA_373_LSB                                               0
#define TXPCU_TXBUF_DATA_373_MSB                                               31
#define TXPCU_TXBUF_DATA_373_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_373_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_373_MASK) >> TXPCU_TXBUF_DATA_373_LSB)
#define TXPCU_TXBUF_DATA_373_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_373_LSB) & TXPCU_TXBUF_DATA_373_MASK)
#define TXPCU_TXBUF_DATA_373_RESET                                             0x0
#define TXPCU_TXBUF_373_ADDRESS                                                (0x15d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_373_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_373_RESET                                                  0x0

// 0x15d8 (TXPCU_TXBUF_374)
#define TXPCU_TXBUF_DATA_374_LSB                                               0
#define TXPCU_TXBUF_DATA_374_MSB                                               31
#define TXPCU_TXBUF_DATA_374_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_374_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_374_MASK) >> TXPCU_TXBUF_DATA_374_LSB)
#define TXPCU_TXBUF_DATA_374_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_374_LSB) & TXPCU_TXBUF_DATA_374_MASK)
#define TXPCU_TXBUF_DATA_374_RESET                                             0x0
#define TXPCU_TXBUF_374_ADDRESS                                                (0x15d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_374_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_374_RESET                                                  0x0

// 0x15dc (TXPCU_TXBUF_375)
#define TXPCU_TXBUF_DATA_375_LSB                                               0
#define TXPCU_TXBUF_DATA_375_MSB                                               31
#define TXPCU_TXBUF_DATA_375_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_375_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_375_MASK) >> TXPCU_TXBUF_DATA_375_LSB)
#define TXPCU_TXBUF_DATA_375_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_375_LSB) & TXPCU_TXBUF_DATA_375_MASK)
#define TXPCU_TXBUF_DATA_375_RESET                                             0x0
#define TXPCU_TXBUF_375_ADDRESS                                                (0x15dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_375_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_375_RESET                                                  0x0

// 0x15e0 (TXPCU_TXBUF_376)
#define TXPCU_TXBUF_DATA_376_LSB                                               0
#define TXPCU_TXBUF_DATA_376_MSB                                               31
#define TXPCU_TXBUF_DATA_376_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_376_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_376_MASK) >> TXPCU_TXBUF_DATA_376_LSB)
#define TXPCU_TXBUF_DATA_376_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_376_LSB) & TXPCU_TXBUF_DATA_376_MASK)
#define TXPCU_TXBUF_DATA_376_RESET                                             0x0
#define TXPCU_TXBUF_376_ADDRESS                                                (0x15e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_376_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_376_RESET                                                  0x0

// 0x15e4 (TXPCU_TXBUF_377)
#define TXPCU_TXBUF_DATA_377_LSB                                               0
#define TXPCU_TXBUF_DATA_377_MSB                                               31
#define TXPCU_TXBUF_DATA_377_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_377_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_377_MASK) >> TXPCU_TXBUF_DATA_377_LSB)
#define TXPCU_TXBUF_DATA_377_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_377_LSB) & TXPCU_TXBUF_DATA_377_MASK)
#define TXPCU_TXBUF_DATA_377_RESET                                             0x0
#define TXPCU_TXBUF_377_ADDRESS                                                (0x15e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_377_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_377_RESET                                                  0x0

// 0x15e8 (TXPCU_TXBUF_378)
#define TXPCU_TXBUF_DATA_378_LSB                                               0
#define TXPCU_TXBUF_DATA_378_MSB                                               31
#define TXPCU_TXBUF_DATA_378_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_378_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_378_MASK) >> TXPCU_TXBUF_DATA_378_LSB)
#define TXPCU_TXBUF_DATA_378_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_378_LSB) & TXPCU_TXBUF_DATA_378_MASK)
#define TXPCU_TXBUF_DATA_378_RESET                                             0x0
#define TXPCU_TXBUF_378_ADDRESS                                                (0x15e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_378_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_378_RESET                                                  0x0

// 0x15ec (TXPCU_TXBUF_379)
#define TXPCU_TXBUF_DATA_379_LSB                                               0
#define TXPCU_TXBUF_DATA_379_MSB                                               31
#define TXPCU_TXBUF_DATA_379_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_379_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_379_MASK) >> TXPCU_TXBUF_DATA_379_LSB)
#define TXPCU_TXBUF_DATA_379_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_379_LSB) & TXPCU_TXBUF_DATA_379_MASK)
#define TXPCU_TXBUF_DATA_379_RESET                                             0x0
#define TXPCU_TXBUF_379_ADDRESS                                                (0x15ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_379_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_379_RESET                                                  0x0

// 0x15f0 (TXPCU_TXBUF_380)
#define TXPCU_TXBUF_DATA_380_LSB                                               0
#define TXPCU_TXBUF_DATA_380_MSB                                               31
#define TXPCU_TXBUF_DATA_380_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_380_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_380_MASK) >> TXPCU_TXBUF_DATA_380_LSB)
#define TXPCU_TXBUF_DATA_380_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_380_LSB) & TXPCU_TXBUF_DATA_380_MASK)
#define TXPCU_TXBUF_DATA_380_RESET                                             0x0
#define TXPCU_TXBUF_380_ADDRESS                                                (0x15f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_380_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_380_RESET                                                  0x0

// 0x15f4 (TXPCU_TXBUF_381)
#define TXPCU_TXBUF_DATA_381_LSB                                               0
#define TXPCU_TXBUF_DATA_381_MSB                                               31
#define TXPCU_TXBUF_DATA_381_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_381_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_381_MASK) >> TXPCU_TXBUF_DATA_381_LSB)
#define TXPCU_TXBUF_DATA_381_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_381_LSB) & TXPCU_TXBUF_DATA_381_MASK)
#define TXPCU_TXBUF_DATA_381_RESET                                             0x0
#define TXPCU_TXBUF_381_ADDRESS                                                (0x15f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_381_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_381_RESET                                                  0x0

// 0x15f8 (TXPCU_TXBUF_382)
#define TXPCU_TXBUF_DATA_382_LSB                                               0
#define TXPCU_TXBUF_DATA_382_MSB                                               31
#define TXPCU_TXBUF_DATA_382_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_382_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_382_MASK) >> TXPCU_TXBUF_DATA_382_LSB)
#define TXPCU_TXBUF_DATA_382_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_382_LSB) & TXPCU_TXBUF_DATA_382_MASK)
#define TXPCU_TXBUF_DATA_382_RESET                                             0x0
#define TXPCU_TXBUF_382_ADDRESS                                                (0x15f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_382_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_382_RESET                                                  0x0

// 0x15fc (TXPCU_TXBUF_383)
#define TXPCU_TXBUF_DATA_383_LSB                                               0
#define TXPCU_TXBUF_DATA_383_MSB                                               31
#define TXPCU_TXBUF_DATA_383_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_383_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_383_MASK) >> TXPCU_TXBUF_DATA_383_LSB)
#define TXPCU_TXBUF_DATA_383_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_383_LSB) & TXPCU_TXBUF_DATA_383_MASK)
#define TXPCU_TXBUF_DATA_383_RESET                                             0x0
#define TXPCU_TXBUF_383_ADDRESS                                                (0x15fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_383_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_383_RESET                                                  0x0

// 0x1600 (TXPCU_TXBUF_384)
#define TXPCU_TXBUF_DATA_384_LSB                                               0
#define TXPCU_TXBUF_DATA_384_MSB                                               31
#define TXPCU_TXBUF_DATA_384_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_384_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_384_MASK) >> TXPCU_TXBUF_DATA_384_LSB)
#define TXPCU_TXBUF_DATA_384_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_384_LSB) & TXPCU_TXBUF_DATA_384_MASK)
#define TXPCU_TXBUF_DATA_384_RESET                                             0x0
#define TXPCU_TXBUF_384_ADDRESS                                                (0x1600 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_384_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_384_RESET                                                  0x0

// 0x1604 (TXPCU_TXBUF_385)
#define TXPCU_TXBUF_DATA_385_LSB                                               0
#define TXPCU_TXBUF_DATA_385_MSB                                               31
#define TXPCU_TXBUF_DATA_385_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_385_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_385_MASK) >> TXPCU_TXBUF_DATA_385_LSB)
#define TXPCU_TXBUF_DATA_385_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_385_LSB) & TXPCU_TXBUF_DATA_385_MASK)
#define TXPCU_TXBUF_DATA_385_RESET                                             0x0
#define TXPCU_TXBUF_385_ADDRESS                                                (0x1604 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_385_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_385_RESET                                                  0x0

// 0x1608 (TXPCU_TXBUF_386)
#define TXPCU_TXBUF_DATA_386_LSB                                               0
#define TXPCU_TXBUF_DATA_386_MSB                                               31
#define TXPCU_TXBUF_DATA_386_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_386_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_386_MASK) >> TXPCU_TXBUF_DATA_386_LSB)
#define TXPCU_TXBUF_DATA_386_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_386_LSB) & TXPCU_TXBUF_DATA_386_MASK)
#define TXPCU_TXBUF_DATA_386_RESET                                             0x0
#define TXPCU_TXBUF_386_ADDRESS                                                (0x1608 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_386_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_386_RESET                                                  0x0

// 0x160c (TXPCU_TXBUF_387)
#define TXPCU_TXBUF_DATA_387_LSB                                               0
#define TXPCU_TXBUF_DATA_387_MSB                                               31
#define TXPCU_TXBUF_DATA_387_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_387_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_387_MASK) >> TXPCU_TXBUF_DATA_387_LSB)
#define TXPCU_TXBUF_DATA_387_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_387_LSB) & TXPCU_TXBUF_DATA_387_MASK)
#define TXPCU_TXBUF_DATA_387_RESET                                             0x0
#define TXPCU_TXBUF_387_ADDRESS                                                (0x160c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_387_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_387_RESET                                                  0x0

// 0x1610 (TXPCU_TXBUF_388)
#define TXPCU_TXBUF_DATA_388_LSB                                               0
#define TXPCU_TXBUF_DATA_388_MSB                                               31
#define TXPCU_TXBUF_DATA_388_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_388_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_388_MASK) >> TXPCU_TXBUF_DATA_388_LSB)
#define TXPCU_TXBUF_DATA_388_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_388_LSB) & TXPCU_TXBUF_DATA_388_MASK)
#define TXPCU_TXBUF_DATA_388_RESET                                             0x0
#define TXPCU_TXBUF_388_ADDRESS                                                (0x1610 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_388_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_388_RESET                                                  0x0

// 0x1614 (TXPCU_TXBUF_389)
#define TXPCU_TXBUF_DATA_389_LSB                                               0
#define TXPCU_TXBUF_DATA_389_MSB                                               31
#define TXPCU_TXBUF_DATA_389_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_389_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_389_MASK) >> TXPCU_TXBUF_DATA_389_LSB)
#define TXPCU_TXBUF_DATA_389_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_389_LSB) & TXPCU_TXBUF_DATA_389_MASK)
#define TXPCU_TXBUF_DATA_389_RESET                                             0x0
#define TXPCU_TXBUF_389_ADDRESS                                                (0x1614 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_389_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_389_RESET                                                  0x0

// 0x1618 (TXPCU_TXBUF_390)
#define TXPCU_TXBUF_DATA_390_LSB                                               0
#define TXPCU_TXBUF_DATA_390_MSB                                               31
#define TXPCU_TXBUF_DATA_390_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_390_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_390_MASK) >> TXPCU_TXBUF_DATA_390_LSB)
#define TXPCU_TXBUF_DATA_390_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_390_LSB) & TXPCU_TXBUF_DATA_390_MASK)
#define TXPCU_TXBUF_DATA_390_RESET                                             0x0
#define TXPCU_TXBUF_390_ADDRESS                                                (0x1618 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_390_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_390_RESET                                                  0x0

// 0x161c (TXPCU_TXBUF_391)
#define TXPCU_TXBUF_DATA_391_LSB                                               0
#define TXPCU_TXBUF_DATA_391_MSB                                               31
#define TXPCU_TXBUF_DATA_391_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_391_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_391_MASK) >> TXPCU_TXBUF_DATA_391_LSB)
#define TXPCU_TXBUF_DATA_391_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_391_LSB) & TXPCU_TXBUF_DATA_391_MASK)
#define TXPCU_TXBUF_DATA_391_RESET                                             0x0
#define TXPCU_TXBUF_391_ADDRESS                                                (0x161c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_391_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_391_RESET                                                  0x0

// 0x1620 (TXPCU_TXBUF_392)
#define TXPCU_TXBUF_DATA_392_LSB                                               0
#define TXPCU_TXBUF_DATA_392_MSB                                               31
#define TXPCU_TXBUF_DATA_392_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_392_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_392_MASK) >> TXPCU_TXBUF_DATA_392_LSB)
#define TXPCU_TXBUF_DATA_392_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_392_LSB) & TXPCU_TXBUF_DATA_392_MASK)
#define TXPCU_TXBUF_DATA_392_RESET                                             0x0
#define TXPCU_TXBUF_392_ADDRESS                                                (0x1620 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_392_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_392_RESET                                                  0x0

// 0x1624 (TXPCU_TXBUF_393)
#define TXPCU_TXBUF_DATA_393_LSB                                               0
#define TXPCU_TXBUF_DATA_393_MSB                                               31
#define TXPCU_TXBUF_DATA_393_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_393_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_393_MASK) >> TXPCU_TXBUF_DATA_393_LSB)
#define TXPCU_TXBUF_DATA_393_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_393_LSB) & TXPCU_TXBUF_DATA_393_MASK)
#define TXPCU_TXBUF_DATA_393_RESET                                             0x0
#define TXPCU_TXBUF_393_ADDRESS                                                (0x1624 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_393_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_393_RESET                                                  0x0

// 0x1628 (TXPCU_TXBUF_394)
#define TXPCU_TXBUF_DATA_394_LSB                                               0
#define TXPCU_TXBUF_DATA_394_MSB                                               31
#define TXPCU_TXBUF_DATA_394_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_394_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_394_MASK) >> TXPCU_TXBUF_DATA_394_LSB)
#define TXPCU_TXBUF_DATA_394_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_394_LSB) & TXPCU_TXBUF_DATA_394_MASK)
#define TXPCU_TXBUF_DATA_394_RESET                                             0x0
#define TXPCU_TXBUF_394_ADDRESS                                                (0x1628 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_394_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_394_RESET                                                  0x0

// 0x162c (TXPCU_TXBUF_395)
#define TXPCU_TXBUF_DATA_395_LSB                                               0
#define TXPCU_TXBUF_DATA_395_MSB                                               31
#define TXPCU_TXBUF_DATA_395_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_395_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_395_MASK) >> TXPCU_TXBUF_DATA_395_LSB)
#define TXPCU_TXBUF_DATA_395_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_395_LSB) & TXPCU_TXBUF_DATA_395_MASK)
#define TXPCU_TXBUF_DATA_395_RESET                                             0x0
#define TXPCU_TXBUF_395_ADDRESS                                                (0x162c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_395_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_395_RESET                                                  0x0

// 0x1630 (TXPCU_TXBUF_396)
#define TXPCU_TXBUF_DATA_396_LSB                                               0
#define TXPCU_TXBUF_DATA_396_MSB                                               31
#define TXPCU_TXBUF_DATA_396_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_396_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_396_MASK) >> TXPCU_TXBUF_DATA_396_LSB)
#define TXPCU_TXBUF_DATA_396_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_396_LSB) & TXPCU_TXBUF_DATA_396_MASK)
#define TXPCU_TXBUF_DATA_396_RESET                                             0x0
#define TXPCU_TXBUF_396_ADDRESS                                                (0x1630 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_396_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_396_RESET                                                  0x0

// 0x1634 (TXPCU_TXBUF_397)
#define TXPCU_TXBUF_DATA_397_LSB                                               0
#define TXPCU_TXBUF_DATA_397_MSB                                               31
#define TXPCU_TXBUF_DATA_397_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_397_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_397_MASK) >> TXPCU_TXBUF_DATA_397_LSB)
#define TXPCU_TXBUF_DATA_397_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_397_LSB) & TXPCU_TXBUF_DATA_397_MASK)
#define TXPCU_TXBUF_DATA_397_RESET                                             0x0
#define TXPCU_TXBUF_397_ADDRESS                                                (0x1634 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_397_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_397_RESET                                                  0x0

// 0x1638 (TXPCU_TXBUF_398)
#define TXPCU_TXBUF_DATA_398_LSB                                               0
#define TXPCU_TXBUF_DATA_398_MSB                                               31
#define TXPCU_TXBUF_DATA_398_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_398_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_398_MASK) >> TXPCU_TXBUF_DATA_398_LSB)
#define TXPCU_TXBUF_DATA_398_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_398_LSB) & TXPCU_TXBUF_DATA_398_MASK)
#define TXPCU_TXBUF_DATA_398_RESET                                             0x0
#define TXPCU_TXBUF_398_ADDRESS                                                (0x1638 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_398_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_398_RESET                                                  0x0

// 0x163c (TXPCU_TXBUF_399)
#define TXPCU_TXBUF_DATA_399_LSB                                               0
#define TXPCU_TXBUF_DATA_399_MSB                                               31
#define TXPCU_TXBUF_DATA_399_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_399_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_399_MASK) >> TXPCU_TXBUF_DATA_399_LSB)
#define TXPCU_TXBUF_DATA_399_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_399_LSB) & TXPCU_TXBUF_DATA_399_MASK)
#define TXPCU_TXBUF_DATA_399_RESET                                             0x0
#define TXPCU_TXBUF_399_ADDRESS                                                (0x163c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_399_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_399_RESET                                                  0x0

// 0x1640 (TXPCU_TXBUF_400)
#define TXPCU_TXBUF_DATA_400_LSB                                               0
#define TXPCU_TXBUF_DATA_400_MSB                                               31
#define TXPCU_TXBUF_DATA_400_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_400_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_400_MASK) >> TXPCU_TXBUF_DATA_400_LSB)
#define TXPCU_TXBUF_DATA_400_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_400_LSB) & TXPCU_TXBUF_DATA_400_MASK)
#define TXPCU_TXBUF_DATA_400_RESET                                             0x0
#define TXPCU_TXBUF_400_ADDRESS                                                (0x1640 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_400_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_400_RESET                                                  0x0

// 0x1644 (TXPCU_TXBUF_401)
#define TXPCU_TXBUF_DATA_401_LSB                                               0
#define TXPCU_TXBUF_DATA_401_MSB                                               31
#define TXPCU_TXBUF_DATA_401_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_401_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_401_MASK) >> TXPCU_TXBUF_DATA_401_LSB)
#define TXPCU_TXBUF_DATA_401_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_401_LSB) & TXPCU_TXBUF_DATA_401_MASK)
#define TXPCU_TXBUF_DATA_401_RESET                                             0x0
#define TXPCU_TXBUF_401_ADDRESS                                                (0x1644 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_401_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_401_RESET                                                  0x0

// 0x1648 (TXPCU_TXBUF_402)
#define TXPCU_TXBUF_DATA_402_LSB                                               0
#define TXPCU_TXBUF_DATA_402_MSB                                               31
#define TXPCU_TXBUF_DATA_402_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_402_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_402_MASK) >> TXPCU_TXBUF_DATA_402_LSB)
#define TXPCU_TXBUF_DATA_402_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_402_LSB) & TXPCU_TXBUF_DATA_402_MASK)
#define TXPCU_TXBUF_DATA_402_RESET                                             0x0
#define TXPCU_TXBUF_402_ADDRESS                                                (0x1648 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_402_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_402_RESET                                                  0x0

// 0x164c (TXPCU_TXBUF_403)
#define TXPCU_TXBUF_DATA_403_LSB                                               0
#define TXPCU_TXBUF_DATA_403_MSB                                               31
#define TXPCU_TXBUF_DATA_403_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_403_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_403_MASK) >> TXPCU_TXBUF_DATA_403_LSB)
#define TXPCU_TXBUF_DATA_403_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_403_LSB) & TXPCU_TXBUF_DATA_403_MASK)
#define TXPCU_TXBUF_DATA_403_RESET                                             0x0
#define TXPCU_TXBUF_403_ADDRESS                                                (0x164c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_403_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_403_RESET                                                  0x0

// 0x1650 (TXPCU_TXBUF_404)
#define TXPCU_TXBUF_DATA_404_LSB                                               0
#define TXPCU_TXBUF_DATA_404_MSB                                               31
#define TXPCU_TXBUF_DATA_404_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_404_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_404_MASK) >> TXPCU_TXBUF_DATA_404_LSB)
#define TXPCU_TXBUF_DATA_404_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_404_LSB) & TXPCU_TXBUF_DATA_404_MASK)
#define TXPCU_TXBUF_DATA_404_RESET                                             0x0
#define TXPCU_TXBUF_404_ADDRESS                                                (0x1650 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_404_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_404_RESET                                                  0x0

// 0x1654 (TXPCU_TXBUF_405)
#define TXPCU_TXBUF_DATA_405_LSB                                               0
#define TXPCU_TXBUF_DATA_405_MSB                                               31
#define TXPCU_TXBUF_DATA_405_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_405_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_405_MASK) >> TXPCU_TXBUF_DATA_405_LSB)
#define TXPCU_TXBUF_DATA_405_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_405_LSB) & TXPCU_TXBUF_DATA_405_MASK)
#define TXPCU_TXBUF_DATA_405_RESET                                             0x0
#define TXPCU_TXBUF_405_ADDRESS                                                (0x1654 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_405_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_405_RESET                                                  0x0

// 0x1658 (TXPCU_TXBUF_406)
#define TXPCU_TXBUF_DATA_406_LSB                                               0
#define TXPCU_TXBUF_DATA_406_MSB                                               31
#define TXPCU_TXBUF_DATA_406_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_406_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_406_MASK) >> TXPCU_TXBUF_DATA_406_LSB)
#define TXPCU_TXBUF_DATA_406_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_406_LSB) & TXPCU_TXBUF_DATA_406_MASK)
#define TXPCU_TXBUF_DATA_406_RESET                                             0x0
#define TXPCU_TXBUF_406_ADDRESS                                                (0x1658 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_406_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_406_RESET                                                  0x0

// 0x165c (TXPCU_TXBUF_407)
#define TXPCU_TXBUF_DATA_407_LSB                                               0
#define TXPCU_TXBUF_DATA_407_MSB                                               31
#define TXPCU_TXBUF_DATA_407_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_407_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_407_MASK) >> TXPCU_TXBUF_DATA_407_LSB)
#define TXPCU_TXBUF_DATA_407_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_407_LSB) & TXPCU_TXBUF_DATA_407_MASK)
#define TXPCU_TXBUF_DATA_407_RESET                                             0x0
#define TXPCU_TXBUF_407_ADDRESS                                                (0x165c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_407_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_407_RESET                                                  0x0

// 0x1660 (TXPCU_TXBUF_408)
#define TXPCU_TXBUF_DATA_408_LSB                                               0
#define TXPCU_TXBUF_DATA_408_MSB                                               31
#define TXPCU_TXBUF_DATA_408_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_408_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_408_MASK) >> TXPCU_TXBUF_DATA_408_LSB)
#define TXPCU_TXBUF_DATA_408_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_408_LSB) & TXPCU_TXBUF_DATA_408_MASK)
#define TXPCU_TXBUF_DATA_408_RESET                                             0x0
#define TXPCU_TXBUF_408_ADDRESS                                                (0x1660 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_408_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_408_RESET                                                  0x0

// 0x1664 (TXPCU_TXBUF_409)
#define TXPCU_TXBUF_DATA_409_LSB                                               0
#define TXPCU_TXBUF_DATA_409_MSB                                               31
#define TXPCU_TXBUF_DATA_409_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_409_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_409_MASK) >> TXPCU_TXBUF_DATA_409_LSB)
#define TXPCU_TXBUF_DATA_409_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_409_LSB) & TXPCU_TXBUF_DATA_409_MASK)
#define TXPCU_TXBUF_DATA_409_RESET                                             0x0
#define TXPCU_TXBUF_409_ADDRESS                                                (0x1664 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_409_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_409_RESET                                                  0x0

// 0x1668 (TXPCU_TXBUF_410)
#define TXPCU_TXBUF_DATA_410_LSB                                               0
#define TXPCU_TXBUF_DATA_410_MSB                                               31
#define TXPCU_TXBUF_DATA_410_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_410_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_410_MASK) >> TXPCU_TXBUF_DATA_410_LSB)
#define TXPCU_TXBUF_DATA_410_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_410_LSB) & TXPCU_TXBUF_DATA_410_MASK)
#define TXPCU_TXBUF_DATA_410_RESET                                             0x0
#define TXPCU_TXBUF_410_ADDRESS                                                (0x1668 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_410_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_410_RESET                                                  0x0

// 0x166c (TXPCU_TXBUF_411)
#define TXPCU_TXBUF_DATA_411_LSB                                               0
#define TXPCU_TXBUF_DATA_411_MSB                                               31
#define TXPCU_TXBUF_DATA_411_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_411_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_411_MASK) >> TXPCU_TXBUF_DATA_411_LSB)
#define TXPCU_TXBUF_DATA_411_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_411_LSB) & TXPCU_TXBUF_DATA_411_MASK)
#define TXPCU_TXBUF_DATA_411_RESET                                             0x0
#define TXPCU_TXBUF_411_ADDRESS                                                (0x166c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_411_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_411_RESET                                                  0x0

// 0x1670 (TXPCU_TXBUF_412)
#define TXPCU_TXBUF_DATA_412_LSB                                               0
#define TXPCU_TXBUF_DATA_412_MSB                                               31
#define TXPCU_TXBUF_DATA_412_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_412_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_412_MASK) >> TXPCU_TXBUF_DATA_412_LSB)
#define TXPCU_TXBUF_DATA_412_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_412_LSB) & TXPCU_TXBUF_DATA_412_MASK)
#define TXPCU_TXBUF_DATA_412_RESET                                             0x0
#define TXPCU_TXBUF_412_ADDRESS                                                (0x1670 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_412_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_412_RESET                                                  0x0

// 0x1674 (TXPCU_TXBUF_413)
#define TXPCU_TXBUF_DATA_413_LSB                                               0
#define TXPCU_TXBUF_DATA_413_MSB                                               31
#define TXPCU_TXBUF_DATA_413_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_413_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_413_MASK) >> TXPCU_TXBUF_DATA_413_LSB)
#define TXPCU_TXBUF_DATA_413_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_413_LSB) & TXPCU_TXBUF_DATA_413_MASK)
#define TXPCU_TXBUF_DATA_413_RESET                                             0x0
#define TXPCU_TXBUF_413_ADDRESS                                                (0x1674 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_413_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_413_RESET                                                  0x0

// 0x1678 (TXPCU_TXBUF_414)
#define TXPCU_TXBUF_DATA_414_LSB                                               0
#define TXPCU_TXBUF_DATA_414_MSB                                               31
#define TXPCU_TXBUF_DATA_414_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_414_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_414_MASK) >> TXPCU_TXBUF_DATA_414_LSB)
#define TXPCU_TXBUF_DATA_414_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_414_LSB) & TXPCU_TXBUF_DATA_414_MASK)
#define TXPCU_TXBUF_DATA_414_RESET                                             0x0
#define TXPCU_TXBUF_414_ADDRESS                                                (0x1678 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_414_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_414_RESET                                                  0x0

// 0x167c (TXPCU_TXBUF_415)
#define TXPCU_TXBUF_DATA_415_LSB                                               0
#define TXPCU_TXBUF_DATA_415_MSB                                               31
#define TXPCU_TXBUF_DATA_415_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_415_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_415_MASK) >> TXPCU_TXBUF_DATA_415_LSB)
#define TXPCU_TXBUF_DATA_415_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_415_LSB) & TXPCU_TXBUF_DATA_415_MASK)
#define TXPCU_TXBUF_DATA_415_RESET                                             0x0
#define TXPCU_TXBUF_415_ADDRESS                                                (0x167c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_415_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_415_RESET                                                  0x0

// 0x1680 (TXPCU_TXBUF_416)
#define TXPCU_TXBUF_DATA_416_LSB                                               0
#define TXPCU_TXBUF_DATA_416_MSB                                               31
#define TXPCU_TXBUF_DATA_416_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_416_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_416_MASK) >> TXPCU_TXBUF_DATA_416_LSB)
#define TXPCU_TXBUF_DATA_416_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_416_LSB) & TXPCU_TXBUF_DATA_416_MASK)
#define TXPCU_TXBUF_DATA_416_RESET                                             0x0
#define TXPCU_TXBUF_416_ADDRESS                                                (0x1680 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_416_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_416_RESET                                                  0x0

// 0x1684 (TXPCU_TXBUF_417)
#define TXPCU_TXBUF_DATA_417_LSB                                               0
#define TXPCU_TXBUF_DATA_417_MSB                                               31
#define TXPCU_TXBUF_DATA_417_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_417_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_417_MASK) >> TXPCU_TXBUF_DATA_417_LSB)
#define TXPCU_TXBUF_DATA_417_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_417_LSB) & TXPCU_TXBUF_DATA_417_MASK)
#define TXPCU_TXBUF_DATA_417_RESET                                             0x0
#define TXPCU_TXBUF_417_ADDRESS                                                (0x1684 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_417_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_417_RESET                                                  0x0

// 0x1688 (TXPCU_TXBUF_418)
#define TXPCU_TXBUF_DATA_418_LSB                                               0
#define TXPCU_TXBUF_DATA_418_MSB                                               31
#define TXPCU_TXBUF_DATA_418_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_418_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_418_MASK) >> TXPCU_TXBUF_DATA_418_LSB)
#define TXPCU_TXBUF_DATA_418_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_418_LSB) & TXPCU_TXBUF_DATA_418_MASK)
#define TXPCU_TXBUF_DATA_418_RESET                                             0x0
#define TXPCU_TXBUF_418_ADDRESS                                                (0x1688 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_418_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_418_RESET                                                  0x0

// 0x168c (TXPCU_TXBUF_419)
#define TXPCU_TXBUF_DATA_419_LSB                                               0
#define TXPCU_TXBUF_DATA_419_MSB                                               31
#define TXPCU_TXBUF_DATA_419_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_419_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_419_MASK) >> TXPCU_TXBUF_DATA_419_LSB)
#define TXPCU_TXBUF_DATA_419_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_419_LSB) & TXPCU_TXBUF_DATA_419_MASK)
#define TXPCU_TXBUF_DATA_419_RESET                                             0x0
#define TXPCU_TXBUF_419_ADDRESS                                                (0x168c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_419_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_419_RESET                                                  0x0

// 0x1690 (TXPCU_TXBUF_420)
#define TXPCU_TXBUF_DATA_420_LSB                                               0
#define TXPCU_TXBUF_DATA_420_MSB                                               31
#define TXPCU_TXBUF_DATA_420_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_420_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_420_MASK) >> TXPCU_TXBUF_DATA_420_LSB)
#define TXPCU_TXBUF_DATA_420_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_420_LSB) & TXPCU_TXBUF_DATA_420_MASK)
#define TXPCU_TXBUF_DATA_420_RESET                                             0x0
#define TXPCU_TXBUF_420_ADDRESS                                                (0x1690 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_420_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_420_RESET                                                  0x0

// 0x1694 (TXPCU_TXBUF_421)
#define TXPCU_TXBUF_DATA_421_LSB                                               0
#define TXPCU_TXBUF_DATA_421_MSB                                               31
#define TXPCU_TXBUF_DATA_421_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_421_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_421_MASK) >> TXPCU_TXBUF_DATA_421_LSB)
#define TXPCU_TXBUF_DATA_421_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_421_LSB) & TXPCU_TXBUF_DATA_421_MASK)
#define TXPCU_TXBUF_DATA_421_RESET                                             0x0
#define TXPCU_TXBUF_421_ADDRESS                                                (0x1694 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_421_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_421_RESET                                                  0x0

// 0x1698 (TXPCU_TXBUF_422)
#define TXPCU_TXBUF_DATA_422_LSB                                               0
#define TXPCU_TXBUF_DATA_422_MSB                                               31
#define TXPCU_TXBUF_DATA_422_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_422_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_422_MASK) >> TXPCU_TXBUF_DATA_422_LSB)
#define TXPCU_TXBUF_DATA_422_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_422_LSB) & TXPCU_TXBUF_DATA_422_MASK)
#define TXPCU_TXBUF_DATA_422_RESET                                             0x0
#define TXPCU_TXBUF_422_ADDRESS                                                (0x1698 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_422_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_422_RESET                                                  0x0

// 0x169c (TXPCU_TXBUF_423)
#define TXPCU_TXBUF_DATA_423_LSB                                               0
#define TXPCU_TXBUF_DATA_423_MSB                                               31
#define TXPCU_TXBUF_DATA_423_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_423_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_423_MASK) >> TXPCU_TXBUF_DATA_423_LSB)
#define TXPCU_TXBUF_DATA_423_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_423_LSB) & TXPCU_TXBUF_DATA_423_MASK)
#define TXPCU_TXBUF_DATA_423_RESET                                             0x0
#define TXPCU_TXBUF_423_ADDRESS                                                (0x169c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_423_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_423_RESET                                                  0x0

// 0x16a0 (TXPCU_TXBUF_424)
#define TXPCU_TXBUF_DATA_424_LSB                                               0
#define TXPCU_TXBUF_DATA_424_MSB                                               31
#define TXPCU_TXBUF_DATA_424_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_424_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_424_MASK) >> TXPCU_TXBUF_DATA_424_LSB)
#define TXPCU_TXBUF_DATA_424_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_424_LSB) & TXPCU_TXBUF_DATA_424_MASK)
#define TXPCU_TXBUF_DATA_424_RESET                                             0x0
#define TXPCU_TXBUF_424_ADDRESS                                                (0x16a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_424_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_424_RESET                                                  0x0

// 0x16a4 (TXPCU_TXBUF_425)
#define TXPCU_TXBUF_DATA_425_LSB                                               0
#define TXPCU_TXBUF_DATA_425_MSB                                               31
#define TXPCU_TXBUF_DATA_425_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_425_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_425_MASK) >> TXPCU_TXBUF_DATA_425_LSB)
#define TXPCU_TXBUF_DATA_425_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_425_LSB) & TXPCU_TXBUF_DATA_425_MASK)
#define TXPCU_TXBUF_DATA_425_RESET                                             0x0
#define TXPCU_TXBUF_425_ADDRESS                                                (0x16a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_425_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_425_RESET                                                  0x0

// 0x16a8 (TXPCU_TXBUF_426)
#define TXPCU_TXBUF_DATA_426_LSB                                               0
#define TXPCU_TXBUF_DATA_426_MSB                                               31
#define TXPCU_TXBUF_DATA_426_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_426_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_426_MASK) >> TXPCU_TXBUF_DATA_426_LSB)
#define TXPCU_TXBUF_DATA_426_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_426_LSB) & TXPCU_TXBUF_DATA_426_MASK)
#define TXPCU_TXBUF_DATA_426_RESET                                             0x0
#define TXPCU_TXBUF_426_ADDRESS                                                (0x16a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_426_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_426_RESET                                                  0x0

// 0x16ac (TXPCU_TXBUF_427)
#define TXPCU_TXBUF_DATA_427_LSB                                               0
#define TXPCU_TXBUF_DATA_427_MSB                                               31
#define TXPCU_TXBUF_DATA_427_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_427_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_427_MASK) >> TXPCU_TXBUF_DATA_427_LSB)
#define TXPCU_TXBUF_DATA_427_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_427_LSB) & TXPCU_TXBUF_DATA_427_MASK)
#define TXPCU_TXBUF_DATA_427_RESET                                             0x0
#define TXPCU_TXBUF_427_ADDRESS                                                (0x16ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_427_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_427_RESET                                                  0x0

// 0x16b0 (TXPCU_TXBUF_428)
#define TXPCU_TXBUF_DATA_428_LSB                                               0
#define TXPCU_TXBUF_DATA_428_MSB                                               31
#define TXPCU_TXBUF_DATA_428_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_428_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_428_MASK) >> TXPCU_TXBUF_DATA_428_LSB)
#define TXPCU_TXBUF_DATA_428_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_428_LSB) & TXPCU_TXBUF_DATA_428_MASK)
#define TXPCU_TXBUF_DATA_428_RESET                                             0x0
#define TXPCU_TXBUF_428_ADDRESS                                                (0x16b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_428_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_428_RESET                                                  0x0

// 0x16b4 (TXPCU_TXBUF_429)
#define TXPCU_TXBUF_DATA_429_LSB                                               0
#define TXPCU_TXBUF_DATA_429_MSB                                               31
#define TXPCU_TXBUF_DATA_429_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_429_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_429_MASK) >> TXPCU_TXBUF_DATA_429_LSB)
#define TXPCU_TXBUF_DATA_429_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_429_LSB) & TXPCU_TXBUF_DATA_429_MASK)
#define TXPCU_TXBUF_DATA_429_RESET                                             0x0
#define TXPCU_TXBUF_429_ADDRESS                                                (0x16b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_429_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_429_RESET                                                  0x0

// 0x16b8 (TXPCU_TXBUF_430)
#define TXPCU_TXBUF_DATA_430_LSB                                               0
#define TXPCU_TXBUF_DATA_430_MSB                                               31
#define TXPCU_TXBUF_DATA_430_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_430_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_430_MASK) >> TXPCU_TXBUF_DATA_430_LSB)
#define TXPCU_TXBUF_DATA_430_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_430_LSB) & TXPCU_TXBUF_DATA_430_MASK)
#define TXPCU_TXBUF_DATA_430_RESET                                             0x0
#define TXPCU_TXBUF_430_ADDRESS                                                (0x16b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_430_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_430_RESET                                                  0x0

// 0x16bc (TXPCU_TXBUF_431)
#define TXPCU_TXBUF_DATA_431_LSB                                               0
#define TXPCU_TXBUF_DATA_431_MSB                                               31
#define TXPCU_TXBUF_DATA_431_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_431_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_431_MASK) >> TXPCU_TXBUF_DATA_431_LSB)
#define TXPCU_TXBUF_DATA_431_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_431_LSB) & TXPCU_TXBUF_DATA_431_MASK)
#define TXPCU_TXBUF_DATA_431_RESET                                             0x0
#define TXPCU_TXBUF_431_ADDRESS                                                (0x16bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_431_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_431_RESET                                                  0x0

// 0x16c0 (TXPCU_TXBUF_432)
#define TXPCU_TXBUF_DATA_432_LSB                                               0
#define TXPCU_TXBUF_DATA_432_MSB                                               31
#define TXPCU_TXBUF_DATA_432_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_432_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_432_MASK) >> TXPCU_TXBUF_DATA_432_LSB)
#define TXPCU_TXBUF_DATA_432_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_432_LSB) & TXPCU_TXBUF_DATA_432_MASK)
#define TXPCU_TXBUF_DATA_432_RESET                                             0x0
#define TXPCU_TXBUF_432_ADDRESS                                                (0x16c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_432_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_432_RESET                                                  0x0

// 0x16c4 (TXPCU_TXBUF_433)
#define TXPCU_TXBUF_DATA_433_LSB                                               0
#define TXPCU_TXBUF_DATA_433_MSB                                               31
#define TXPCU_TXBUF_DATA_433_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_433_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_433_MASK) >> TXPCU_TXBUF_DATA_433_LSB)
#define TXPCU_TXBUF_DATA_433_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_433_LSB) & TXPCU_TXBUF_DATA_433_MASK)
#define TXPCU_TXBUF_DATA_433_RESET                                             0x0
#define TXPCU_TXBUF_433_ADDRESS                                                (0x16c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_433_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_433_RESET                                                  0x0

// 0x16c8 (TXPCU_TXBUF_434)
#define TXPCU_TXBUF_DATA_434_LSB                                               0
#define TXPCU_TXBUF_DATA_434_MSB                                               31
#define TXPCU_TXBUF_DATA_434_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_434_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_434_MASK) >> TXPCU_TXBUF_DATA_434_LSB)
#define TXPCU_TXBUF_DATA_434_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_434_LSB) & TXPCU_TXBUF_DATA_434_MASK)
#define TXPCU_TXBUF_DATA_434_RESET                                             0x0
#define TXPCU_TXBUF_434_ADDRESS                                                (0x16c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_434_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_434_RESET                                                  0x0

// 0x16cc (TXPCU_TXBUF_435)
#define TXPCU_TXBUF_DATA_435_LSB                                               0
#define TXPCU_TXBUF_DATA_435_MSB                                               31
#define TXPCU_TXBUF_DATA_435_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_435_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_435_MASK) >> TXPCU_TXBUF_DATA_435_LSB)
#define TXPCU_TXBUF_DATA_435_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_435_LSB) & TXPCU_TXBUF_DATA_435_MASK)
#define TXPCU_TXBUF_DATA_435_RESET                                             0x0
#define TXPCU_TXBUF_435_ADDRESS                                                (0x16cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_435_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_435_RESET                                                  0x0

// 0x16d0 (TXPCU_TXBUF_436)
#define TXPCU_TXBUF_DATA_436_LSB                                               0
#define TXPCU_TXBUF_DATA_436_MSB                                               31
#define TXPCU_TXBUF_DATA_436_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_436_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_436_MASK) >> TXPCU_TXBUF_DATA_436_LSB)
#define TXPCU_TXBUF_DATA_436_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_436_LSB) & TXPCU_TXBUF_DATA_436_MASK)
#define TXPCU_TXBUF_DATA_436_RESET                                             0x0
#define TXPCU_TXBUF_436_ADDRESS                                                (0x16d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_436_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_436_RESET                                                  0x0

// 0x16d4 (TXPCU_TXBUF_437)
#define TXPCU_TXBUF_DATA_437_LSB                                               0
#define TXPCU_TXBUF_DATA_437_MSB                                               31
#define TXPCU_TXBUF_DATA_437_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_437_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_437_MASK) >> TXPCU_TXBUF_DATA_437_LSB)
#define TXPCU_TXBUF_DATA_437_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_437_LSB) & TXPCU_TXBUF_DATA_437_MASK)
#define TXPCU_TXBUF_DATA_437_RESET                                             0x0
#define TXPCU_TXBUF_437_ADDRESS                                                (0x16d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_437_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_437_RESET                                                  0x0

// 0x16d8 (TXPCU_TXBUF_438)
#define TXPCU_TXBUF_DATA_438_LSB                                               0
#define TXPCU_TXBUF_DATA_438_MSB                                               31
#define TXPCU_TXBUF_DATA_438_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_438_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_438_MASK) >> TXPCU_TXBUF_DATA_438_LSB)
#define TXPCU_TXBUF_DATA_438_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_438_LSB) & TXPCU_TXBUF_DATA_438_MASK)
#define TXPCU_TXBUF_DATA_438_RESET                                             0x0
#define TXPCU_TXBUF_438_ADDRESS                                                (0x16d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_438_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_438_RESET                                                  0x0

// 0x16dc (TXPCU_TXBUF_439)
#define TXPCU_TXBUF_DATA_439_LSB                                               0
#define TXPCU_TXBUF_DATA_439_MSB                                               31
#define TXPCU_TXBUF_DATA_439_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_439_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_439_MASK) >> TXPCU_TXBUF_DATA_439_LSB)
#define TXPCU_TXBUF_DATA_439_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_439_LSB) & TXPCU_TXBUF_DATA_439_MASK)
#define TXPCU_TXBUF_DATA_439_RESET                                             0x0
#define TXPCU_TXBUF_439_ADDRESS                                                (0x16dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_439_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_439_RESET                                                  0x0

// 0x16e0 (TXPCU_TXBUF_440)
#define TXPCU_TXBUF_DATA_440_LSB                                               0
#define TXPCU_TXBUF_DATA_440_MSB                                               31
#define TXPCU_TXBUF_DATA_440_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_440_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_440_MASK) >> TXPCU_TXBUF_DATA_440_LSB)
#define TXPCU_TXBUF_DATA_440_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_440_LSB) & TXPCU_TXBUF_DATA_440_MASK)
#define TXPCU_TXBUF_DATA_440_RESET                                             0x0
#define TXPCU_TXBUF_440_ADDRESS                                                (0x16e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_440_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_440_RESET                                                  0x0

// 0x16e4 (TXPCU_TXBUF_441)
#define TXPCU_TXBUF_DATA_441_LSB                                               0
#define TXPCU_TXBUF_DATA_441_MSB                                               31
#define TXPCU_TXBUF_DATA_441_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_441_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_441_MASK) >> TXPCU_TXBUF_DATA_441_LSB)
#define TXPCU_TXBUF_DATA_441_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_441_LSB) & TXPCU_TXBUF_DATA_441_MASK)
#define TXPCU_TXBUF_DATA_441_RESET                                             0x0
#define TXPCU_TXBUF_441_ADDRESS                                                (0x16e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_441_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_441_RESET                                                  0x0

// 0x16e8 (TXPCU_TXBUF_442)
#define TXPCU_TXBUF_DATA_442_LSB                                               0
#define TXPCU_TXBUF_DATA_442_MSB                                               31
#define TXPCU_TXBUF_DATA_442_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_442_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_442_MASK) >> TXPCU_TXBUF_DATA_442_LSB)
#define TXPCU_TXBUF_DATA_442_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_442_LSB) & TXPCU_TXBUF_DATA_442_MASK)
#define TXPCU_TXBUF_DATA_442_RESET                                             0x0
#define TXPCU_TXBUF_442_ADDRESS                                                (0x16e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_442_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_442_RESET                                                  0x0

// 0x16ec (TXPCU_TXBUF_443)
#define TXPCU_TXBUF_DATA_443_LSB                                               0
#define TXPCU_TXBUF_DATA_443_MSB                                               31
#define TXPCU_TXBUF_DATA_443_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_443_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_443_MASK) >> TXPCU_TXBUF_DATA_443_LSB)
#define TXPCU_TXBUF_DATA_443_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_443_LSB) & TXPCU_TXBUF_DATA_443_MASK)
#define TXPCU_TXBUF_DATA_443_RESET                                             0x0
#define TXPCU_TXBUF_443_ADDRESS                                                (0x16ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_443_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_443_RESET                                                  0x0

// 0x16f0 (TXPCU_TXBUF_444)
#define TXPCU_TXBUF_DATA_444_LSB                                               0
#define TXPCU_TXBUF_DATA_444_MSB                                               31
#define TXPCU_TXBUF_DATA_444_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_444_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_444_MASK) >> TXPCU_TXBUF_DATA_444_LSB)
#define TXPCU_TXBUF_DATA_444_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_444_LSB) & TXPCU_TXBUF_DATA_444_MASK)
#define TXPCU_TXBUF_DATA_444_RESET                                             0x0
#define TXPCU_TXBUF_444_ADDRESS                                                (0x16f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_444_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_444_RESET                                                  0x0

// 0x16f4 (TXPCU_TXBUF_445)
#define TXPCU_TXBUF_DATA_445_LSB                                               0
#define TXPCU_TXBUF_DATA_445_MSB                                               31
#define TXPCU_TXBUF_DATA_445_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_445_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_445_MASK) >> TXPCU_TXBUF_DATA_445_LSB)
#define TXPCU_TXBUF_DATA_445_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_445_LSB) & TXPCU_TXBUF_DATA_445_MASK)
#define TXPCU_TXBUF_DATA_445_RESET                                             0x0
#define TXPCU_TXBUF_445_ADDRESS                                                (0x16f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_445_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_445_RESET                                                  0x0

// 0x16f8 (TXPCU_TXBUF_446)
#define TXPCU_TXBUF_DATA_446_LSB                                               0
#define TXPCU_TXBUF_DATA_446_MSB                                               31
#define TXPCU_TXBUF_DATA_446_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_446_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_446_MASK) >> TXPCU_TXBUF_DATA_446_LSB)
#define TXPCU_TXBUF_DATA_446_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_446_LSB) & TXPCU_TXBUF_DATA_446_MASK)
#define TXPCU_TXBUF_DATA_446_RESET                                             0x0
#define TXPCU_TXBUF_446_ADDRESS                                                (0x16f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_446_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_446_RESET                                                  0x0

// 0x16fc (TXPCU_TXBUF_447)
#define TXPCU_TXBUF_DATA_447_LSB                                               0
#define TXPCU_TXBUF_DATA_447_MSB                                               31
#define TXPCU_TXBUF_DATA_447_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_447_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_447_MASK) >> TXPCU_TXBUF_DATA_447_LSB)
#define TXPCU_TXBUF_DATA_447_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_447_LSB) & TXPCU_TXBUF_DATA_447_MASK)
#define TXPCU_TXBUF_DATA_447_RESET                                             0x0
#define TXPCU_TXBUF_447_ADDRESS                                                (0x16fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_447_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_447_RESET                                                  0x0

// 0x1700 (TXPCU_TXBUF_448)
#define TXPCU_TXBUF_DATA_448_LSB                                               0
#define TXPCU_TXBUF_DATA_448_MSB                                               31
#define TXPCU_TXBUF_DATA_448_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_448_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_448_MASK) >> TXPCU_TXBUF_DATA_448_LSB)
#define TXPCU_TXBUF_DATA_448_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_448_LSB) & TXPCU_TXBUF_DATA_448_MASK)
#define TXPCU_TXBUF_DATA_448_RESET                                             0x0
#define TXPCU_TXBUF_448_ADDRESS                                                (0x1700 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_448_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_448_RESET                                                  0x0

// 0x1704 (TXPCU_TXBUF_449)
#define TXPCU_TXBUF_DATA_449_LSB                                               0
#define TXPCU_TXBUF_DATA_449_MSB                                               31
#define TXPCU_TXBUF_DATA_449_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_449_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_449_MASK) >> TXPCU_TXBUF_DATA_449_LSB)
#define TXPCU_TXBUF_DATA_449_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_449_LSB) & TXPCU_TXBUF_DATA_449_MASK)
#define TXPCU_TXBUF_DATA_449_RESET                                             0x0
#define TXPCU_TXBUF_449_ADDRESS                                                (0x1704 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_449_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_449_RESET                                                  0x0

// 0x1708 (TXPCU_TXBUF_450)
#define TXPCU_TXBUF_DATA_450_LSB                                               0
#define TXPCU_TXBUF_DATA_450_MSB                                               31
#define TXPCU_TXBUF_DATA_450_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_450_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_450_MASK) >> TXPCU_TXBUF_DATA_450_LSB)
#define TXPCU_TXBUF_DATA_450_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_450_LSB) & TXPCU_TXBUF_DATA_450_MASK)
#define TXPCU_TXBUF_DATA_450_RESET                                             0x0
#define TXPCU_TXBUF_450_ADDRESS                                                (0x1708 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_450_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_450_RESET                                                  0x0

// 0x170c (TXPCU_TXBUF_451)
#define TXPCU_TXBUF_DATA_451_LSB                                               0
#define TXPCU_TXBUF_DATA_451_MSB                                               31
#define TXPCU_TXBUF_DATA_451_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_451_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_451_MASK) >> TXPCU_TXBUF_DATA_451_LSB)
#define TXPCU_TXBUF_DATA_451_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_451_LSB) & TXPCU_TXBUF_DATA_451_MASK)
#define TXPCU_TXBUF_DATA_451_RESET                                             0x0
#define TXPCU_TXBUF_451_ADDRESS                                                (0x170c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_451_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_451_RESET                                                  0x0

// 0x1710 (TXPCU_TXBUF_452)
#define TXPCU_TXBUF_DATA_452_LSB                                               0
#define TXPCU_TXBUF_DATA_452_MSB                                               31
#define TXPCU_TXBUF_DATA_452_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_452_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_452_MASK) >> TXPCU_TXBUF_DATA_452_LSB)
#define TXPCU_TXBUF_DATA_452_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_452_LSB) & TXPCU_TXBUF_DATA_452_MASK)
#define TXPCU_TXBUF_DATA_452_RESET                                             0x0
#define TXPCU_TXBUF_452_ADDRESS                                                (0x1710 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_452_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_452_RESET                                                  0x0

// 0x1714 (TXPCU_TXBUF_453)
#define TXPCU_TXBUF_DATA_453_LSB                                               0
#define TXPCU_TXBUF_DATA_453_MSB                                               31
#define TXPCU_TXBUF_DATA_453_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_453_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_453_MASK) >> TXPCU_TXBUF_DATA_453_LSB)
#define TXPCU_TXBUF_DATA_453_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_453_LSB) & TXPCU_TXBUF_DATA_453_MASK)
#define TXPCU_TXBUF_DATA_453_RESET                                             0x0
#define TXPCU_TXBUF_453_ADDRESS                                                (0x1714 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_453_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_453_RESET                                                  0x0

// 0x1718 (TXPCU_TXBUF_454)
#define TXPCU_TXBUF_DATA_454_LSB                                               0
#define TXPCU_TXBUF_DATA_454_MSB                                               31
#define TXPCU_TXBUF_DATA_454_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_454_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_454_MASK) >> TXPCU_TXBUF_DATA_454_LSB)
#define TXPCU_TXBUF_DATA_454_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_454_LSB) & TXPCU_TXBUF_DATA_454_MASK)
#define TXPCU_TXBUF_DATA_454_RESET                                             0x0
#define TXPCU_TXBUF_454_ADDRESS                                                (0x1718 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_454_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_454_RESET                                                  0x0

// 0x171c (TXPCU_TXBUF_455)
#define TXPCU_TXBUF_DATA_455_LSB                                               0
#define TXPCU_TXBUF_DATA_455_MSB                                               31
#define TXPCU_TXBUF_DATA_455_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_455_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_455_MASK) >> TXPCU_TXBUF_DATA_455_LSB)
#define TXPCU_TXBUF_DATA_455_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_455_LSB) & TXPCU_TXBUF_DATA_455_MASK)
#define TXPCU_TXBUF_DATA_455_RESET                                             0x0
#define TXPCU_TXBUF_455_ADDRESS                                                (0x171c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_455_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_455_RESET                                                  0x0

// 0x1720 (TXPCU_TXBUF_456)
#define TXPCU_TXBUF_DATA_456_LSB                                               0
#define TXPCU_TXBUF_DATA_456_MSB                                               31
#define TXPCU_TXBUF_DATA_456_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_456_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_456_MASK) >> TXPCU_TXBUF_DATA_456_LSB)
#define TXPCU_TXBUF_DATA_456_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_456_LSB) & TXPCU_TXBUF_DATA_456_MASK)
#define TXPCU_TXBUF_DATA_456_RESET                                             0x0
#define TXPCU_TXBUF_456_ADDRESS                                                (0x1720 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_456_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_456_RESET                                                  0x0

// 0x1724 (TXPCU_TXBUF_457)
#define TXPCU_TXBUF_DATA_457_LSB                                               0
#define TXPCU_TXBUF_DATA_457_MSB                                               31
#define TXPCU_TXBUF_DATA_457_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_457_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_457_MASK) >> TXPCU_TXBUF_DATA_457_LSB)
#define TXPCU_TXBUF_DATA_457_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_457_LSB) & TXPCU_TXBUF_DATA_457_MASK)
#define TXPCU_TXBUF_DATA_457_RESET                                             0x0
#define TXPCU_TXBUF_457_ADDRESS                                                (0x1724 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_457_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_457_RESET                                                  0x0

// 0x1728 (TXPCU_TXBUF_458)
#define TXPCU_TXBUF_DATA_458_LSB                                               0
#define TXPCU_TXBUF_DATA_458_MSB                                               31
#define TXPCU_TXBUF_DATA_458_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_458_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_458_MASK) >> TXPCU_TXBUF_DATA_458_LSB)
#define TXPCU_TXBUF_DATA_458_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_458_LSB) & TXPCU_TXBUF_DATA_458_MASK)
#define TXPCU_TXBUF_DATA_458_RESET                                             0x0
#define TXPCU_TXBUF_458_ADDRESS                                                (0x1728 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_458_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_458_RESET                                                  0x0

// 0x172c (TXPCU_TXBUF_459)
#define TXPCU_TXBUF_DATA_459_LSB                                               0
#define TXPCU_TXBUF_DATA_459_MSB                                               31
#define TXPCU_TXBUF_DATA_459_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_459_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_459_MASK) >> TXPCU_TXBUF_DATA_459_LSB)
#define TXPCU_TXBUF_DATA_459_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_459_LSB) & TXPCU_TXBUF_DATA_459_MASK)
#define TXPCU_TXBUF_DATA_459_RESET                                             0x0
#define TXPCU_TXBUF_459_ADDRESS                                                (0x172c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_459_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_459_RESET                                                  0x0

// 0x1730 (TXPCU_TXBUF_460)
#define TXPCU_TXBUF_DATA_460_LSB                                               0
#define TXPCU_TXBUF_DATA_460_MSB                                               31
#define TXPCU_TXBUF_DATA_460_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_460_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_460_MASK) >> TXPCU_TXBUF_DATA_460_LSB)
#define TXPCU_TXBUF_DATA_460_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_460_LSB) & TXPCU_TXBUF_DATA_460_MASK)
#define TXPCU_TXBUF_DATA_460_RESET                                             0x0
#define TXPCU_TXBUF_460_ADDRESS                                                (0x1730 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_460_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_460_RESET                                                  0x0

// 0x1734 (TXPCU_TXBUF_461)
#define TXPCU_TXBUF_DATA_461_LSB                                               0
#define TXPCU_TXBUF_DATA_461_MSB                                               31
#define TXPCU_TXBUF_DATA_461_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_461_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_461_MASK) >> TXPCU_TXBUF_DATA_461_LSB)
#define TXPCU_TXBUF_DATA_461_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_461_LSB) & TXPCU_TXBUF_DATA_461_MASK)
#define TXPCU_TXBUF_DATA_461_RESET                                             0x0
#define TXPCU_TXBUF_461_ADDRESS                                                (0x1734 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_461_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_461_RESET                                                  0x0

// 0x1738 (TXPCU_TXBUF_462)
#define TXPCU_TXBUF_DATA_462_LSB                                               0
#define TXPCU_TXBUF_DATA_462_MSB                                               31
#define TXPCU_TXBUF_DATA_462_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_462_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_462_MASK) >> TXPCU_TXBUF_DATA_462_LSB)
#define TXPCU_TXBUF_DATA_462_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_462_LSB) & TXPCU_TXBUF_DATA_462_MASK)
#define TXPCU_TXBUF_DATA_462_RESET                                             0x0
#define TXPCU_TXBUF_462_ADDRESS                                                (0x1738 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_462_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_462_RESET                                                  0x0

// 0x173c (TXPCU_TXBUF_463)
#define TXPCU_TXBUF_DATA_463_LSB                                               0
#define TXPCU_TXBUF_DATA_463_MSB                                               31
#define TXPCU_TXBUF_DATA_463_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_463_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_463_MASK) >> TXPCU_TXBUF_DATA_463_LSB)
#define TXPCU_TXBUF_DATA_463_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_463_LSB) & TXPCU_TXBUF_DATA_463_MASK)
#define TXPCU_TXBUF_DATA_463_RESET                                             0x0
#define TXPCU_TXBUF_463_ADDRESS                                                (0x173c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_463_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_463_RESET                                                  0x0

// 0x1740 (TXPCU_TXBUF_464)
#define TXPCU_TXBUF_DATA_464_LSB                                               0
#define TXPCU_TXBUF_DATA_464_MSB                                               31
#define TXPCU_TXBUF_DATA_464_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_464_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_464_MASK) >> TXPCU_TXBUF_DATA_464_LSB)
#define TXPCU_TXBUF_DATA_464_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_464_LSB) & TXPCU_TXBUF_DATA_464_MASK)
#define TXPCU_TXBUF_DATA_464_RESET                                             0x0
#define TXPCU_TXBUF_464_ADDRESS                                                (0x1740 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_464_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_464_RESET                                                  0x0

// 0x1744 (TXPCU_TXBUF_465)
#define TXPCU_TXBUF_DATA_465_LSB                                               0
#define TXPCU_TXBUF_DATA_465_MSB                                               31
#define TXPCU_TXBUF_DATA_465_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_465_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_465_MASK) >> TXPCU_TXBUF_DATA_465_LSB)
#define TXPCU_TXBUF_DATA_465_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_465_LSB) & TXPCU_TXBUF_DATA_465_MASK)
#define TXPCU_TXBUF_DATA_465_RESET                                             0x0
#define TXPCU_TXBUF_465_ADDRESS                                                (0x1744 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_465_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_465_RESET                                                  0x0

// 0x1748 (TXPCU_TXBUF_466)
#define TXPCU_TXBUF_DATA_466_LSB                                               0
#define TXPCU_TXBUF_DATA_466_MSB                                               31
#define TXPCU_TXBUF_DATA_466_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_466_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_466_MASK) >> TXPCU_TXBUF_DATA_466_LSB)
#define TXPCU_TXBUF_DATA_466_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_466_LSB) & TXPCU_TXBUF_DATA_466_MASK)
#define TXPCU_TXBUF_DATA_466_RESET                                             0x0
#define TXPCU_TXBUF_466_ADDRESS                                                (0x1748 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_466_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_466_RESET                                                  0x0

// 0x174c (TXPCU_TXBUF_467)
#define TXPCU_TXBUF_DATA_467_LSB                                               0
#define TXPCU_TXBUF_DATA_467_MSB                                               31
#define TXPCU_TXBUF_DATA_467_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_467_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_467_MASK) >> TXPCU_TXBUF_DATA_467_LSB)
#define TXPCU_TXBUF_DATA_467_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_467_LSB) & TXPCU_TXBUF_DATA_467_MASK)
#define TXPCU_TXBUF_DATA_467_RESET                                             0x0
#define TXPCU_TXBUF_467_ADDRESS                                                (0x174c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_467_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_467_RESET                                                  0x0

// 0x1750 (TXPCU_TXBUF_468)
#define TXPCU_TXBUF_DATA_468_LSB                                               0
#define TXPCU_TXBUF_DATA_468_MSB                                               31
#define TXPCU_TXBUF_DATA_468_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_468_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_468_MASK) >> TXPCU_TXBUF_DATA_468_LSB)
#define TXPCU_TXBUF_DATA_468_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_468_LSB) & TXPCU_TXBUF_DATA_468_MASK)
#define TXPCU_TXBUF_DATA_468_RESET                                             0x0
#define TXPCU_TXBUF_468_ADDRESS                                                (0x1750 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_468_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_468_RESET                                                  0x0

// 0x1754 (TXPCU_TXBUF_469)
#define TXPCU_TXBUF_DATA_469_LSB                                               0
#define TXPCU_TXBUF_DATA_469_MSB                                               31
#define TXPCU_TXBUF_DATA_469_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_469_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_469_MASK) >> TXPCU_TXBUF_DATA_469_LSB)
#define TXPCU_TXBUF_DATA_469_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_469_LSB) & TXPCU_TXBUF_DATA_469_MASK)
#define TXPCU_TXBUF_DATA_469_RESET                                             0x0
#define TXPCU_TXBUF_469_ADDRESS                                                (0x1754 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_469_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_469_RESET                                                  0x0

// 0x1758 (TXPCU_TXBUF_470)
#define TXPCU_TXBUF_DATA_470_LSB                                               0
#define TXPCU_TXBUF_DATA_470_MSB                                               31
#define TXPCU_TXBUF_DATA_470_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_470_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_470_MASK) >> TXPCU_TXBUF_DATA_470_LSB)
#define TXPCU_TXBUF_DATA_470_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_470_LSB) & TXPCU_TXBUF_DATA_470_MASK)
#define TXPCU_TXBUF_DATA_470_RESET                                             0x0
#define TXPCU_TXBUF_470_ADDRESS                                                (0x1758 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_470_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_470_RESET                                                  0x0

// 0x175c (TXPCU_TXBUF_471)
#define TXPCU_TXBUF_DATA_471_LSB                                               0
#define TXPCU_TXBUF_DATA_471_MSB                                               31
#define TXPCU_TXBUF_DATA_471_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_471_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_471_MASK) >> TXPCU_TXBUF_DATA_471_LSB)
#define TXPCU_TXBUF_DATA_471_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_471_LSB) & TXPCU_TXBUF_DATA_471_MASK)
#define TXPCU_TXBUF_DATA_471_RESET                                             0x0
#define TXPCU_TXBUF_471_ADDRESS                                                (0x175c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_471_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_471_RESET                                                  0x0

// 0x1760 (TXPCU_TXBUF_472)
#define TXPCU_TXBUF_DATA_472_LSB                                               0
#define TXPCU_TXBUF_DATA_472_MSB                                               31
#define TXPCU_TXBUF_DATA_472_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_472_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_472_MASK) >> TXPCU_TXBUF_DATA_472_LSB)
#define TXPCU_TXBUF_DATA_472_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_472_LSB) & TXPCU_TXBUF_DATA_472_MASK)
#define TXPCU_TXBUF_DATA_472_RESET                                             0x0
#define TXPCU_TXBUF_472_ADDRESS                                                (0x1760 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_472_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_472_RESET                                                  0x0

// 0x1764 (TXPCU_TXBUF_473)
#define TXPCU_TXBUF_DATA_473_LSB                                               0
#define TXPCU_TXBUF_DATA_473_MSB                                               31
#define TXPCU_TXBUF_DATA_473_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_473_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_473_MASK) >> TXPCU_TXBUF_DATA_473_LSB)
#define TXPCU_TXBUF_DATA_473_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_473_LSB) & TXPCU_TXBUF_DATA_473_MASK)
#define TXPCU_TXBUF_DATA_473_RESET                                             0x0
#define TXPCU_TXBUF_473_ADDRESS                                                (0x1764 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_473_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_473_RESET                                                  0x0

// 0x1768 (TXPCU_TXBUF_474)
#define TXPCU_TXBUF_DATA_474_LSB                                               0
#define TXPCU_TXBUF_DATA_474_MSB                                               31
#define TXPCU_TXBUF_DATA_474_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_474_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_474_MASK) >> TXPCU_TXBUF_DATA_474_LSB)
#define TXPCU_TXBUF_DATA_474_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_474_LSB) & TXPCU_TXBUF_DATA_474_MASK)
#define TXPCU_TXBUF_DATA_474_RESET                                             0x0
#define TXPCU_TXBUF_474_ADDRESS                                                (0x1768 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_474_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_474_RESET                                                  0x0

// 0x176c (TXPCU_TXBUF_475)
#define TXPCU_TXBUF_DATA_475_LSB                                               0
#define TXPCU_TXBUF_DATA_475_MSB                                               31
#define TXPCU_TXBUF_DATA_475_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_475_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_475_MASK) >> TXPCU_TXBUF_DATA_475_LSB)
#define TXPCU_TXBUF_DATA_475_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_475_LSB) & TXPCU_TXBUF_DATA_475_MASK)
#define TXPCU_TXBUF_DATA_475_RESET                                             0x0
#define TXPCU_TXBUF_475_ADDRESS                                                (0x176c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_475_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_475_RESET                                                  0x0

// 0x1770 (TXPCU_TXBUF_476)
#define TXPCU_TXBUF_DATA_476_LSB                                               0
#define TXPCU_TXBUF_DATA_476_MSB                                               31
#define TXPCU_TXBUF_DATA_476_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_476_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_476_MASK) >> TXPCU_TXBUF_DATA_476_LSB)
#define TXPCU_TXBUF_DATA_476_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_476_LSB) & TXPCU_TXBUF_DATA_476_MASK)
#define TXPCU_TXBUF_DATA_476_RESET                                             0x0
#define TXPCU_TXBUF_476_ADDRESS                                                (0x1770 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_476_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_476_RESET                                                  0x0

// 0x1774 (TXPCU_TXBUF_477)
#define TXPCU_TXBUF_DATA_477_LSB                                               0
#define TXPCU_TXBUF_DATA_477_MSB                                               31
#define TXPCU_TXBUF_DATA_477_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_477_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_477_MASK) >> TXPCU_TXBUF_DATA_477_LSB)
#define TXPCU_TXBUF_DATA_477_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_477_LSB) & TXPCU_TXBUF_DATA_477_MASK)
#define TXPCU_TXBUF_DATA_477_RESET                                             0x0
#define TXPCU_TXBUF_477_ADDRESS                                                (0x1774 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_477_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_477_RESET                                                  0x0

// 0x1778 (TXPCU_TXBUF_478)
#define TXPCU_TXBUF_DATA_478_LSB                                               0
#define TXPCU_TXBUF_DATA_478_MSB                                               31
#define TXPCU_TXBUF_DATA_478_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_478_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_478_MASK) >> TXPCU_TXBUF_DATA_478_LSB)
#define TXPCU_TXBUF_DATA_478_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_478_LSB) & TXPCU_TXBUF_DATA_478_MASK)
#define TXPCU_TXBUF_DATA_478_RESET                                             0x0
#define TXPCU_TXBUF_478_ADDRESS                                                (0x1778 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_478_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_478_RESET                                                  0x0

// 0x177c (TXPCU_TXBUF_479)
#define TXPCU_TXBUF_DATA_479_LSB                                               0
#define TXPCU_TXBUF_DATA_479_MSB                                               31
#define TXPCU_TXBUF_DATA_479_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_479_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_479_MASK) >> TXPCU_TXBUF_DATA_479_LSB)
#define TXPCU_TXBUF_DATA_479_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_479_LSB) & TXPCU_TXBUF_DATA_479_MASK)
#define TXPCU_TXBUF_DATA_479_RESET                                             0x0
#define TXPCU_TXBUF_479_ADDRESS                                                (0x177c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_479_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_479_RESET                                                  0x0

// 0x1780 (TXPCU_TXBUF_480)
#define TXPCU_TXBUF_DATA_480_LSB                                               0
#define TXPCU_TXBUF_DATA_480_MSB                                               31
#define TXPCU_TXBUF_DATA_480_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_480_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_480_MASK) >> TXPCU_TXBUF_DATA_480_LSB)
#define TXPCU_TXBUF_DATA_480_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_480_LSB) & TXPCU_TXBUF_DATA_480_MASK)
#define TXPCU_TXBUF_DATA_480_RESET                                             0x0
#define TXPCU_TXBUF_480_ADDRESS                                                (0x1780 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_480_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_480_RESET                                                  0x0

// 0x1784 (TXPCU_TXBUF_481)
#define TXPCU_TXBUF_DATA_481_LSB                                               0
#define TXPCU_TXBUF_DATA_481_MSB                                               31
#define TXPCU_TXBUF_DATA_481_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_481_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_481_MASK) >> TXPCU_TXBUF_DATA_481_LSB)
#define TXPCU_TXBUF_DATA_481_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_481_LSB) & TXPCU_TXBUF_DATA_481_MASK)
#define TXPCU_TXBUF_DATA_481_RESET                                             0x0
#define TXPCU_TXBUF_481_ADDRESS                                                (0x1784 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_481_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_481_RESET                                                  0x0

// 0x1788 (TXPCU_TXBUF_482)
#define TXPCU_TXBUF_DATA_482_LSB                                               0
#define TXPCU_TXBUF_DATA_482_MSB                                               31
#define TXPCU_TXBUF_DATA_482_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_482_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_482_MASK) >> TXPCU_TXBUF_DATA_482_LSB)
#define TXPCU_TXBUF_DATA_482_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_482_LSB) & TXPCU_TXBUF_DATA_482_MASK)
#define TXPCU_TXBUF_DATA_482_RESET                                             0x0
#define TXPCU_TXBUF_482_ADDRESS                                                (0x1788 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_482_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_482_RESET                                                  0x0

// 0x178c (TXPCU_TXBUF_483)
#define TXPCU_TXBUF_DATA_483_LSB                                               0
#define TXPCU_TXBUF_DATA_483_MSB                                               31
#define TXPCU_TXBUF_DATA_483_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_483_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_483_MASK) >> TXPCU_TXBUF_DATA_483_LSB)
#define TXPCU_TXBUF_DATA_483_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_483_LSB) & TXPCU_TXBUF_DATA_483_MASK)
#define TXPCU_TXBUF_DATA_483_RESET                                             0x0
#define TXPCU_TXBUF_483_ADDRESS                                                (0x178c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_483_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_483_RESET                                                  0x0

// 0x1790 (TXPCU_TXBUF_484)
#define TXPCU_TXBUF_DATA_484_LSB                                               0
#define TXPCU_TXBUF_DATA_484_MSB                                               31
#define TXPCU_TXBUF_DATA_484_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_484_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_484_MASK) >> TXPCU_TXBUF_DATA_484_LSB)
#define TXPCU_TXBUF_DATA_484_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_484_LSB) & TXPCU_TXBUF_DATA_484_MASK)
#define TXPCU_TXBUF_DATA_484_RESET                                             0x0
#define TXPCU_TXBUF_484_ADDRESS                                                (0x1790 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_484_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_484_RESET                                                  0x0

// 0x1794 (TXPCU_TXBUF_485)
#define TXPCU_TXBUF_DATA_485_LSB                                               0
#define TXPCU_TXBUF_DATA_485_MSB                                               31
#define TXPCU_TXBUF_DATA_485_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_485_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_485_MASK) >> TXPCU_TXBUF_DATA_485_LSB)
#define TXPCU_TXBUF_DATA_485_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_485_LSB) & TXPCU_TXBUF_DATA_485_MASK)
#define TXPCU_TXBUF_DATA_485_RESET                                             0x0
#define TXPCU_TXBUF_485_ADDRESS                                                (0x1794 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_485_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_485_RESET                                                  0x0

// 0x1798 (TXPCU_TXBUF_486)
#define TXPCU_TXBUF_DATA_486_LSB                                               0
#define TXPCU_TXBUF_DATA_486_MSB                                               31
#define TXPCU_TXBUF_DATA_486_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_486_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_486_MASK) >> TXPCU_TXBUF_DATA_486_LSB)
#define TXPCU_TXBUF_DATA_486_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_486_LSB) & TXPCU_TXBUF_DATA_486_MASK)
#define TXPCU_TXBUF_DATA_486_RESET                                             0x0
#define TXPCU_TXBUF_486_ADDRESS                                                (0x1798 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_486_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_486_RESET                                                  0x0

// 0x179c (TXPCU_TXBUF_487)
#define TXPCU_TXBUF_DATA_487_LSB                                               0
#define TXPCU_TXBUF_DATA_487_MSB                                               31
#define TXPCU_TXBUF_DATA_487_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_487_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_487_MASK) >> TXPCU_TXBUF_DATA_487_LSB)
#define TXPCU_TXBUF_DATA_487_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_487_LSB) & TXPCU_TXBUF_DATA_487_MASK)
#define TXPCU_TXBUF_DATA_487_RESET                                             0x0
#define TXPCU_TXBUF_487_ADDRESS                                                (0x179c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_487_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_487_RESET                                                  0x0

// 0x17a0 (TXPCU_TXBUF_488)
#define TXPCU_TXBUF_DATA_488_LSB                                               0
#define TXPCU_TXBUF_DATA_488_MSB                                               31
#define TXPCU_TXBUF_DATA_488_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_488_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_488_MASK) >> TXPCU_TXBUF_DATA_488_LSB)
#define TXPCU_TXBUF_DATA_488_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_488_LSB) & TXPCU_TXBUF_DATA_488_MASK)
#define TXPCU_TXBUF_DATA_488_RESET                                             0x0
#define TXPCU_TXBUF_488_ADDRESS                                                (0x17a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_488_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_488_RESET                                                  0x0

// 0x17a4 (TXPCU_TXBUF_489)
#define TXPCU_TXBUF_DATA_489_LSB                                               0
#define TXPCU_TXBUF_DATA_489_MSB                                               31
#define TXPCU_TXBUF_DATA_489_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_489_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_489_MASK) >> TXPCU_TXBUF_DATA_489_LSB)
#define TXPCU_TXBUF_DATA_489_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_489_LSB) & TXPCU_TXBUF_DATA_489_MASK)
#define TXPCU_TXBUF_DATA_489_RESET                                             0x0
#define TXPCU_TXBUF_489_ADDRESS                                                (0x17a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_489_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_489_RESET                                                  0x0

// 0x17a8 (TXPCU_TXBUF_490)
#define TXPCU_TXBUF_DATA_490_LSB                                               0
#define TXPCU_TXBUF_DATA_490_MSB                                               31
#define TXPCU_TXBUF_DATA_490_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_490_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_490_MASK) >> TXPCU_TXBUF_DATA_490_LSB)
#define TXPCU_TXBUF_DATA_490_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_490_LSB) & TXPCU_TXBUF_DATA_490_MASK)
#define TXPCU_TXBUF_DATA_490_RESET                                             0x0
#define TXPCU_TXBUF_490_ADDRESS                                                (0x17a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_490_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_490_RESET                                                  0x0

// 0x17ac (TXPCU_TXBUF_491)
#define TXPCU_TXBUF_DATA_491_LSB                                               0
#define TXPCU_TXBUF_DATA_491_MSB                                               31
#define TXPCU_TXBUF_DATA_491_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_491_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_491_MASK) >> TXPCU_TXBUF_DATA_491_LSB)
#define TXPCU_TXBUF_DATA_491_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_491_LSB) & TXPCU_TXBUF_DATA_491_MASK)
#define TXPCU_TXBUF_DATA_491_RESET                                             0x0
#define TXPCU_TXBUF_491_ADDRESS                                                (0x17ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_491_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_491_RESET                                                  0x0

// 0x17b0 (TXPCU_TXBUF_492)
#define TXPCU_TXBUF_DATA_492_LSB                                               0
#define TXPCU_TXBUF_DATA_492_MSB                                               31
#define TXPCU_TXBUF_DATA_492_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_492_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_492_MASK) >> TXPCU_TXBUF_DATA_492_LSB)
#define TXPCU_TXBUF_DATA_492_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_492_LSB) & TXPCU_TXBUF_DATA_492_MASK)
#define TXPCU_TXBUF_DATA_492_RESET                                             0x0
#define TXPCU_TXBUF_492_ADDRESS                                                (0x17b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_492_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_492_RESET                                                  0x0

// 0x17b4 (TXPCU_TXBUF_493)
#define TXPCU_TXBUF_DATA_493_LSB                                               0
#define TXPCU_TXBUF_DATA_493_MSB                                               31
#define TXPCU_TXBUF_DATA_493_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_493_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_493_MASK) >> TXPCU_TXBUF_DATA_493_LSB)
#define TXPCU_TXBUF_DATA_493_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_493_LSB) & TXPCU_TXBUF_DATA_493_MASK)
#define TXPCU_TXBUF_DATA_493_RESET                                             0x0
#define TXPCU_TXBUF_493_ADDRESS                                                (0x17b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_493_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_493_RESET                                                  0x0

// 0x17b8 (TXPCU_TXBUF_494)
#define TXPCU_TXBUF_DATA_494_LSB                                               0
#define TXPCU_TXBUF_DATA_494_MSB                                               31
#define TXPCU_TXBUF_DATA_494_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_494_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_494_MASK) >> TXPCU_TXBUF_DATA_494_LSB)
#define TXPCU_TXBUF_DATA_494_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_494_LSB) & TXPCU_TXBUF_DATA_494_MASK)
#define TXPCU_TXBUF_DATA_494_RESET                                             0x0
#define TXPCU_TXBUF_494_ADDRESS                                                (0x17b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_494_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_494_RESET                                                  0x0

// 0x17bc (TXPCU_TXBUF_495)
#define TXPCU_TXBUF_DATA_495_LSB                                               0
#define TXPCU_TXBUF_DATA_495_MSB                                               31
#define TXPCU_TXBUF_DATA_495_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_495_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_495_MASK) >> TXPCU_TXBUF_DATA_495_LSB)
#define TXPCU_TXBUF_DATA_495_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_495_LSB) & TXPCU_TXBUF_DATA_495_MASK)
#define TXPCU_TXBUF_DATA_495_RESET                                             0x0
#define TXPCU_TXBUF_495_ADDRESS                                                (0x17bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_495_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_495_RESET                                                  0x0

// 0x17c0 (TXPCU_TXBUF_496)
#define TXPCU_TXBUF_DATA_496_LSB                                               0
#define TXPCU_TXBUF_DATA_496_MSB                                               31
#define TXPCU_TXBUF_DATA_496_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_496_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_496_MASK) >> TXPCU_TXBUF_DATA_496_LSB)
#define TXPCU_TXBUF_DATA_496_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_496_LSB) & TXPCU_TXBUF_DATA_496_MASK)
#define TXPCU_TXBUF_DATA_496_RESET                                             0x0
#define TXPCU_TXBUF_496_ADDRESS                                                (0x17c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_496_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_496_RESET                                                  0x0

// 0x17c4 (TXPCU_TXBUF_497)
#define TXPCU_TXBUF_DATA_497_LSB                                               0
#define TXPCU_TXBUF_DATA_497_MSB                                               31
#define TXPCU_TXBUF_DATA_497_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_497_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_497_MASK) >> TXPCU_TXBUF_DATA_497_LSB)
#define TXPCU_TXBUF_DATA_497_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_497_LSB) & TXPCU_TXBUF_DATA_497_MASK)
#define TXPCU_TXBUF_DATA_497_RESET                                             0x0
#define TXPCU_TXBUF_497_ADDRESS                                                (0x17c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_497_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_497_RESET                                                  0x0

// 0x17c8 (TXPCU_TXBUF_498)
#define TXPCU_TXBUF_DATA_498_LSB                                               0
#define TXPCU_TXBUF_DATA_498_MSB                                               31
#define TXPCU_TXBUF_DATA_498_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_498_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_498_MASK) >> TXPCU_TXBUF_DATA_498_LSB)
#define TXPCU_TXBUF_DATA_498_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_498_LSB) & TXPCU_TXBUF_DATA_498_MASK)
#define TXPCU_TXBUF_DATA_498_RESET                                             0x0
#define TXPCU_TXBUF_498_ADDRESS                                                (0x17c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_498_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_498_RESET                                                  0x0

// 0x17cc (TXPCU_TXBUF_499)
#define TXPCU_TXBUF_DATA_499_LSB                                               0
#define TXPCU_TXBUF_DATA_499_MSB                                               31
#define TXPCU_TXBUF_DATA_499_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_499_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_499_MASK) >> TXPCU_TXBUF_DATA_499_LSB)
#define TXPCU_TXBUF_DATA_499_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_499_LSB) & TXPCU_TXBUF_DATA_499_MASK)
#define TXPCU_TXBUF_DATA_499_RESET                                             0x0
#define TXPCU_TXBUF_499_ADDRESS                                                (0x17cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_499_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_499_RESET                                                  0x0

// 0x17d0 (TXPCU_TXBUF_500)
#define TXPCU_TXBUF_DATA_500_LSB                                               0
#define TXPCU_TXBUF_DATA_500_MSB                                               31
#define TXPCU_TXBUF_DATA_500_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_500_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_500_MASK) >> TXPCU_TXBUF_DATA_500_LSB)
#define TXPCU_TXBUF_DATA_500_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_500_LSB) & TXPCU_TXBUF_DATA_500_MASK)
#define TXPCU_TXBUF_DATA_500_RESET                                             0x0
#define TXPCU_TXBUF_500_ADDRESS                                                (0x17d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_500_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_500_RESET                                                  0x0

// 0x17d4 (TXPCU_TXBUF_501)
#define TXPCU_TXBUF_DATA_501_LSB                                               0
#define TXPCU_TXBUF_DATA_501_MSB                                               31
#define TXPCU_TXBUF_DATA_501_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_501_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_501_MASK) >> TXPCU_TXBUF_DATA_501_LSB)
#define TXPCU_TXBUF_DATA_501_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_501_LSB) & TXPCU_TXBUF_DATA_501_MASK)
#define TXPCU_TXBUF_DATA_501_RESET                                             0x0
#define TXPCU_TXBUF_501_ADDRESS                                                (0x17d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_501_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_501_RESET                                                  0x0

// 0x17d8 (TXPCU_TXBUF_502)
#define TXPCU_TXBUF_DATA_502_LSB                                               0
#define TXPCU_TXBUF_DATA_502_MSB                                               31
#define TXPCU_TXBUF_DATA_502_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_502_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_502_MASK) >> TXPCU_TXBUF_DATA_502_LSB)
#define TXPCU_TXBUF_DATA_502_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_502_LSB) & TXPCU_TXBUF_DATA_502_MASK)
#define TXPCU_TXBUF_DATA_502_RESET                                             0x0
#define TXPCU_TXBUF_502_ADDRESS                                                (0x17d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_502_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_502_RESET                                                  0x0

// 0x17dc (TXPCU_TXBUF_503)
#define TXPCU_TXBUF_DATA_503_LSB                                               0
#define TXPCU_TXBUF_DATA_503_MSB                                               31
#define TXPCU_TXBUF_DATA_503_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_503_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_503_MASK) >> TXPCU_TXBUF_DATA_503_LSB)
#define TXPCU_TXBUF_DATA_503_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_503_LSB) & TXPCU_TXBUF_DATA_503_MASK)
#define TXPCU_TXBUF_DATA_503_RESET                                             0x0
#define TXPCU_TXBUF_503_ADDRESS                                                (0x17dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_503_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_503_RESET                                                  0x0

// 0x17e0 (TXPCU_TXBUF_504)
#define TXPCU_TXBUF_DATA_504_LSB                                               0
#define TXPCU_TXBUF_DATA_504_MSB                                               31
#define TXPCU_TXBUF_DATA_504_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_504_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_504_MASK) >> TXPCU_TXBUF_DATA_504_LSB)
#define TXPCU_TXBUF_DATA_504_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_504_LSB) & TXPCU_TXBUF_DATA_504_MASK)
#define TXPCU_TXBUF_DATA_504_RESET                                             0x0
#define TXPCU_TXBUF_504_ADDRESS                                                (0x17e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_504_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_504_RESET                                                  0x0

// 0x17e4 (TXPCU_TXBUF_505)
#define TXPCU_TXBUF_DATA_505_LSB                                               0
#define TXPCU_TXBUF_DATA_505_MSB                                               31
#define TXPCU_TXBUF_DATA_505_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_505_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_505_MASK) >> TXPCU_TXBUF_DATA_505_LSB)
#define TXPCU_TXBUF_DATA_505_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_505_LSB) & TXPCU_TXBUF_DATA_505_MASK)
#define TXPCU_TXBUF_DATA_505_RESET                                             0x0
#define TXPCU_TXBUF_505_ADDRESS                                                (0x17e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_505_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_505_RESET                                                  0x0

// 0x17e8 (TXPCU_TXBUF_506)
#define TXPCU_TXBUF_DATA_506_LSB                                               0
#define TXPCU_TXBUF_DATA_506_MSB                                               31
#define TXPCU_TXBUF_DATA_506_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_506_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_506_MASK) >> TXPCU_TXBUF_DATA_506_LSB)
#define TXPCU_TXBUF_DATA_506_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_506_LSB) & TXPCU_TXBUF_DATA_506_MASK)
#define TXPCU_TXBUF_DATA_506_RESET                                             0x0
#define TXPCU_TXBUF_506_ADDRESS                                                (0x17e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_506_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_506_RESET                                                  0x0

// 0x17ec (TXPCU_TXBUF_507)
#define TXPCU_TXBUF_DATA_507_LSB                                               0
#define TXPCU_TXBUF_DATA_507_MSB                                               31
#define TXPCU_TXBUF_DATA_507_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_507_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_507_MASK) >> TXPCU_TXBUF_DATA_507_LSB)
#define TXPCU_TXBUF_DATA_507_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_507_LSB) & TXPCU_TXBUF_DATA_507_MASK)
#define TXPCU_TXBUF_DATA_507_RESET                                             0x0
#define TXPCU_TXBUF_507_ADDRESS                                                (0x17ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_507_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_507_RESET                                                  0x0

// 0x17f0 (TXPCU_TXBUF_508)
#define TXPCU_TXBUF_DATA_508_LSB                                               0
#define TXPCU_TXBUF_DATA_508_MSB                                               31
#define TXPCU_TXBUF_DATA_508_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_508_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_508_MASK) >> TXPCU_TXBUF_DATA_508_LSB)
#define TXPCU_TXBUF_DATA_508_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_508_LSB) & TXPCU_TXBUF_DATA_508_MASK)
#define TXPCU_TXBUF_DATA_508_RESET                                             0x0
#define TXPCU_TXBUF_508_ADDRESS                                                (0x17f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_508_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_508_RESET                                                  0x0

// 0x17f4 (TXPCU_TXBUF_509)
#define TXPCU_TXBUF_DATA_509_LSB                                               0
#define TXPCU_TXBUF_DATA_509_MSB                                               31
#define TXPCU_TXBUF_DATA_509_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_509_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_509_MASK) >> TXPCU_TXBUF_DATA_509_LSB)
#define TXPCU_TXBUF_DATA_509_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_509_LSB) & TXPCU_TXBUF_DATA_509_MASK)
#define TXPCU_TXBUF_DATA_509_RESET                                             0x0
#define TXPCU_TXBUF_509_ADDRESS                                                (0x17f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_509_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_509_RESET                                                  0x0

// 0x17f8 (TXPCU_TXBUF_510)
#define TXPCU_TXBUF_DATA_510_LSB                                               0
#define TXPCU_TXBUF_DATA_510_MSB                                               31
#define TXPCU_TXBUF_DATA_510_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_510_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_510_MASK) >> TXPCU_TXBUF_DATA_510_LSB)
#define TXPCU_TXBUF_DATA_510_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_510_LSB) & TXPCU_TXBUF_DATA_510_MASK)
#define TXPCU_TXBUF_DATA_510_RESET                                             0x0
#define TXPCU_TXBUF_510_ADDRESS                                                (0x17f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_510_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_510_RESET                                                  0x0

// 0x17fc (TXPCU_TXBUF_511)
#define TXPCU_TXBUF_DATA_511_LSB                                               0
#define TXPCU_TXBUF_DATA_511_MSB                                               31
#define TXPCU_TXBUF_DATA_511_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_511_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_511_MASK) >> TXPCU_TXBUF_DATA_511_LSB)
#define TXPCU_TXBUF_DATA_511_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_511_LSB) & TXPCU_TXBUF_DATA_511_MASK)
#define TXPCU_TXBUF_DATA_511_RESET                                             0x0
#define TXPCU_TXBUF_511_ADDRESS                                                (0x17fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_511_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_511_RESET                                                  0x0

// 0x1800 (TXPCU_TXBUF_512)
#define TXPCU_TXBUF_DATA_512_LSB                                               0
#define TXPCU_TXBUF_DATA_512_MSB                                               31
#define TXPCU_TXBUF_DATA_512_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_512_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_512_MASK) >> TXPCU_TXBUF_DATA_512_LSB)
#define TXPCU_TXBUF_DATA_512_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_512_LSB) & TXPCU_TXBUF_DATA_512_MASK)
#define TXPCU_TXBUF_DATA_512_RESET                                             0x0
#define TXPCU_TXBUF_512_ADDRESS                                                (0x1800 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_512_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_512_RESET                                                  0x0

// 0x1804 (TXPCU_TXBUF_513)
#define TXPCU_TXBUF_DATA_513_LSB                                               0
#define TXPCU_TXBUF_DATA_513_MSB                                               31
#define TXPCU_TXBUF_DATA_513_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_513_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_513_MASK) >> TXPCU_TXBUF_DATA_513_LSB)
#define TXPCU_TXBUF_DATA_513_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_513_LSB) & TXPCU_TXBUF_DATA_513_MASK)
#define TXPCU_TXBUF_DATA_513_RESET                                             0x0
#define TXPCU_TXBUF_513_ADDRESS                                                (0x1804 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_513_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_513_RESET                                                  0x0

// 0x1808 (TXPCU_TXBUF_514)
#define TXPCU_TXBUF_DATA_514_LSB                                               0
#define TXPCU_TXBUF_DATA_514_MSB                                               31
#define TXPCU_TXBUF_DATA_514_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_514_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_514_MASK) >> TXPCU_TXBUF_DATA_514_LSB)
#define TXPCU_TXBUF_DATA_514_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_514_LSB) & TXPCU_TXBUF_DATA_514_MASK)
#define TXPCU_TXBUF_DATA_514_RESET                                             0x0
#define TXPCU_TXBUF_514_ADDRESS                                                (0x1808 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_514_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_514_RESET                                                  0x0

// 0x180c (TXPCU_TXBUF_515)
#define TXPCU_TXBUF_DATA_515_LSB                                               0
#define TXPCU_TXBUF_DATA_515_MSB                                               31
#define TXPCU_TXBUF_DATA_515_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_515_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_515_MASK) >> TXPCU_TXBUF_DATA_515_LSB)
#define TXPCU_TXBUF_DATA_515_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_515_LSB) & TXPCU_TXBUF_DATA_515_MASK)
#define TXPCU_TXBUF_DATA_515_RESET                                             0x0
#define TXPCU_TXBUF_515_ADDRESS                                                (0x180c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_515_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_515_RESET                                                  0x0

// 0x1810 (TXPCU_TXBUF_516)
#define TXPCU_TXBUF_DATA_516_LSB                                               0
#define TXPCU_TXBUF_DATA_516_MSB                                               31
#define TXPCU_TXBUF_DATA_516_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_516_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_516_MASK) >> TXPCU_TXBUF_DATA_516_LSB)
#define TXPCU_TXBUF_DATA_516_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_516_LSB) & TXPCU_TXBUF_DATA_516_MASK)
#define TXPCU_TXBUF_DATA_516_RESET                                             0x0
#define TXPCU_TXBUF_516_ADDRESS                                                (0x1810 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_516_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_516_RESET                                                  0x0

// 0x1814 (TXPCU_TXBUF_517)
#define TXPCU_TXBUF_DATA_517_LSB                                               0
#define TXPCU_TXBUF_DATA_517_MSB                                               31
#define TXPCU_TXBUF_DATA_517_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_517_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_517_MASK) >> TXPCU_TXBUF_DATA_517_LSB)
#define TXPCU_TXBUF_DATA_517_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_517_LSB) & TXPCU_TXBUF_DATA_517_MASK)
#define TXPCU_TXBUF_DATA_517_RESET                                             0x0
#define TXPCU_TXBUF_517_ADDRESS                                                (0x1814 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_517_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_517_RESET                                                  0x0

// 0x1818 (TXPCU_TXBUF_518)
#define TXPCU_TXBUF_DATA_518_LSB                                               0
#define TXPCU_TXBUF_DATA_518_MSB                                               31
#define TXPCU_TXBUF_DATA_518_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_518_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_518_MASK) >> TXPCU_TXBUF_DATA_518_LSB)
#define TXPCU_TXBUF_DATA_518_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_518_LSB) & TXPCU_TXBUF_DATA_518_MASK)
#define TXPCU_TXBUF_DATA_518_RESET                                             0x0
#define TXPCU_TXBUF_518_ADDRESS                                                (0x1818 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_518_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_518_RESET                                                  0x0

// 0x181c (TXPCU_TXBUF_519)
#define TXPCU_TXBUF_DATA_519_LSB                                               0
#define TXPCU_TXBUF_DATA_519_MSB                                               31
#define TXPCU_TXBUF_DATA_519_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_519_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_519_MASK) >> TXPCU_TXBUF_DATA_519_LSB)
#define TXPCU_TXBUF_DATA_519_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_519_LSB) & TXPCU_TXBUF_DATA_519_MASK)
#define TXPCU_TXBUF_DATA_519_RESET                                             0x0
#define TXPCU_TXBUF_519_ADDRESS                                                (0x181c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_519_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_519_RESET                                                  0x0

// 0x1820 (TXPCU_TXBUF_520)
#define TXPCU_TXBUF_DATA_520_LSB                                               0
#define TXPCU_TXBUF_DATA_520_MSB                                               31
#define TXPCU_TXBUF_DATA_520_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_520_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_520_MASK) >> TXPCU_TXBUF_DATA_520_LSB)
#define TXPCU_TXBUF_DATA_520_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_520_LSB) & TXPCU_TXBUF_DATA_520_MASK)
#define TXPCU_TXBUF_DATA_520_RESET                                             0x0
#define TXPCU_TXBUF_520_ADDRESS                                                (0x1820 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_520_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_520_RESET                                                  0x0

// 0x1824 (TXPCU_TXBUF_521)
#define TXPCU_TXBUF_DATA_521_LSB                                               0
#define TXPCU_TXBUF_DATA_521_MSB                                               31
#define TXPCU_TXBUF_DATA_521_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_521_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_521_MASK) >> TXPCU_TXBUF_DATA_521_LSB)
#define TXPCU_TXBUF_DATA_521_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_521_LSB) & TXPCU_TXBUF_DATA_521_MASK)
#define TXPCU_TXBUF_DATA_521_RESET                                             0x0
#define TXPCU_TXBUF_521_ADDRESS                                                (0x1824 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_521_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_521_RESET                                                  0x0

// 0x1828 (TXPCU_TXBUF_522)
#define TXPCU_TXBUF_DATA_522_LSB                                               0
#define TXPCU_TXBUF_DATA_522_MSB                                               31
#define TXPCU_TXBUF_DATA_522_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_522_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_522_MASK) >> TXPCU_TXBUF_DATA_522_LSB)
#define TXPCU_TXBUF_DATA_522_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_522_LSB) & TXPCU_TXBUF_DATA_522_MASK)
#define TXPCU_TXBUF_DATA_522_RESET                                             0x0
#define TXPCU_TXBUF_522_ADDRESS                                                (0x1828 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_522_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_522_RESET                                                  0x0

// 0x182c (TXPCU_TXBUF_523)
#define TXPCU_TXBUF_DATA_523_LSB                                               0
#define TXPCU_TXBUF_DATA_523_MSB                                               31
#define TXPCU_TXBUF_DATA_523_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_523_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_523_MASK) >> TXPCU_TXBUF_DATA_523_LSB)
#define TXPCU_TXBUF_DATA_523_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_523_LSB) & TXPCU_TXBUF_DATA_523_MASK)
#define TXPCU_TXBUF_DATA_523_RESET                                             0x0
#define TXPCU_TXBUF_523_ADDRESS                                                (0x182c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_523_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_523_RESET                                                  0x0

// 0x1830 (TXPCU_TXBUF_524)
#define TXPCU_TXBUF_DATA_524_LSB                                               0
#define TXPCU_TXBUF_DATA_524_MSB                                               31
#define TXPCU_TXBUF_DATA_524_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_524_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_524_MASK) >> TXPCU_TXBUF_DATA_524_LSB)
#define TXPCU_TXBUF_DATA_524_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_524_LSB) & TXPCU_TXBUF_DATA_524_MASK)
#define TXPCU_TXBUF_DATA_524_RESET                                             0x0
#define TXPCU_TXBUF_524_ADDRESS                                                (0x1830 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_524_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_524_RESET                                                  0x0

// 0x1834 (TXPCU_TXBUF_525)
#define TXPCU_TXBUF_DATA_525_LSB                                               0
#define TXPCU_TXBUF_DATA_525_MSB                                               31
#define TXPCU_TXBUF_DATA_525_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_525_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_525_MASK) >> TXPCU_TXBUF_DATA_525_LSB)
#define TXPCU_TXBUF_DATA_525_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_525_LSB) & TXPCU_TXBUF_DATA_525_MASK)
#define TXPCU_TXBUF_DATA_525_RESET                                             0x0
#define TXPCU_TXBUF_525_ADDRESS                                                (0x1834 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_525_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_525_RESET                                                  0x0

// 0x1838 (TXPCU_TXBUF_526)
#define TXPCU_TXBUF_DATA_526_LSB                                               0
#define TXPCU_TXBUF_DATA_526_MSB                                               31
#define TXPCU_TXBUF_DATA_526_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_526_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_526_MASK) >> TXPCU_TXBUF_DATA_526_LSB)
#define TXPCU_TXBUF_DATA_526_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_526_LSB) & TXPCU_TXBUF_DATA_526_MASK)
#define TXPCU_TXBUF_DATA_526_RESET                                             0x0
#define TXPCU_TXBUF_526_ADDRESS                                                (0x1838 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_526_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_526_RESET                                                  0x0

// 0x183c (TXPCU_TXBUF_527)
#define TXPCU_TXBUF_DATA_527_LSB                                               0
#define TXPCU_TXBUF_DATA_527_MSB                                               31
#define TXPCU_TXBUF_DATA_527_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_527_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_527_MASK) >> TXPCU_TXBUF_DATA_527_LSB)
#define TXPCU_TXBUF_DATA_527_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_527_LSB) & TXPCU_TXBUF_DATA_527_MASK)
#define TXPCU_TXBUF_DATA_527_RESET                                             0x0
#define TXPCU_TXBUF_527_ADDRESS                                                (0x183c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_527_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_527_RESET                                                  0x0

// 0x1840 (TXPCU_TXBUF_528)
#define TXPCU_TXBUF_DATA_528_LSB                                               0
#define TXPCU_TXBUF_DATA_528_MSB                                               31
#define TXPCU_TXBUF_DATA_528_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_528_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_528_MASK) >> TXPCU_TXBUF_DATA_528_LSB)
#define TXPCU_TXBUF_DATA_528_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_528_LSB) & TXPCU_TXBUF_DATA_528_MASK)
#define TXPCU_TXBUF_DATA_528_RESET                                             0x0
#define TXPCU_TXBUF_528_ADDRESS                                                (0x1840 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_528_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_528_RESET                                                  0x0

// 0x1844 (TXPCU_TXBUF_529)
#define TXPCU_TXBUF_DATA_529_LSB                                               0
#define TXPCU_TXBUF_DATA_529_MSB                                               31
#define TXPCU_TXBUF_DATA_529_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_529_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_529_MASK) >> TXPCU_TXBUF_DATA_529_LSB)
#define TXPCU_TXBUF_DATA_529_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_529_LSB) & TXPCU_TXBUF_DATA_529_MASK)
#define TXPCU_TXBUF_DATA_529_RESET                                             0x0
#define TXPCU_TXBUF_529_ADDRESS                                                (0x1844 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_529_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_529_RESET                                                  0x0

// 0x1848 (TXPCU_TXBUF_530)
#define TXPCU_TXBUF_DATA_530_LSB                                               0
#define TXPCU_TXBUF_DATA_530_MSB                                               31
#define TXPCU_TXBUF_DATA_530_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_530_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_530_MASK) >> TXPCU_TXBUF_DATA_530_LSB)
#define TXPCU_TXBUF_DATA_530_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_530_LSB) & TXPCU_TXBUF_DATA_530_MASK)
#define TXPCU_TXBUF_DATA_530_RESET                                             0x0
#define TXPCU_TXBUF_530_ADDRESS                                                (0x1848 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_530_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_530_RESET                                                  0x0

// 0x184c (TXPCU_TXBUF_531)
#define TXPCU_TXBUF_DATA_531_LSB                                               0
#define TXPCU_TXBUF_DATA_531_MSB                                               31
#define TXPCU_TXBUF_DATA_531_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_531_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_531_MASK) >> TXPCU_TXBUF_DATA_531_LSB)
#define TXPCU_TXBUF_DATA_531_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_531_LSB) & TXPCU_TXBUF_DATA_531_MASK)
#define TXPCU_TXBUF_DATA_531_RESET                                             0x0
#define TXPCU_TXBUF_531_ADDRESS                                                (0x184c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_531_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_531_RESET                                                  0x0

// 0x1850 (TXPCU_TXBUF_532)
#define TXPCU_TXBUF_DATA_532_LSB                                               0
#define TXPCU_TXBUF_DATA_532_MSB                                               31
#define TXPCU_TXBUF_DATA_532_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_532_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_532_MASK) >> TXPCU_TXBUF_DATA_532_LSB)
#define TXPCU_TXBUF_DATA_532_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_532_LSB) & TXPCU_TXBUF_DATA_532_MASK)
#define TXPCU_TXBUF_DATA_532_RESET                                             0x0
#define TXPCU_TXBUF_532_ADDRESS                                                (0x1850 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_532_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_532_RESET                                                  0x0

// 0x1854 (TXPCU_TXBUF_533)
#define TXPCU_TXBUF_DATA_533_LSB                                               0
#define TXPCU_TXBUF_DATA_533_MSB                                               31
#define TXPCU_TXBUF_DATA_533_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_533_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_533_MASK) >> TXPCU_TXBUF_DATA_533_LSB)
#define TXPCU_TXBUF_DATA_533_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_533_LSB) & TXPCU_TXBUF_DATA_533_MASK)
#define TXPCU_TXBUF_DATA_533_RESET                                             0x0
#define TXPCU_TXBUF_533_ADDRESS                                                (0x1854 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_533_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_533_RESET                                                  0x0

// 0x1858 (TXPCU_TXBUF_534)
#define TXPCU_TXBUF_DATA_534_LSB                                               0
#define TXPCU_TXBUF_DATA_534_MSB                                               31
#define TXPCU_TXBUF_DATA_534_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_534_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_534_MASK) >> TXPCU_TXBUF_DATA_534_LSB)
#define TXPCU_TXBUF_DATA_534_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_534_LSB) & TXPCU_TXBUF_DATA_534_MASK)
#define TXPCU_TXBUF_DATA_534_RESET                                             0x0
#define TXPCU_TXBUF_534_ADDRESS                                                (0x1858 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_534_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_534_RESET                                                  0x0

// 0x185c (TXPCU_TXBUF_535)
#define TXPCU_TXBUF_DATA_535_LSB                                               0
#define TXPCU_TXBUF_DATA_535_MSB                                               31
#define TXPCU_TXBUF_DATA_535_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_535_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_535_MASK) >> TXPCU_TXBUF_DATA_535_LSB)
#define TXPCU_TXBUF_DATA_535_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_535_LSB) & TXPCU_TXBUF_DATA_535_MASK)
#define TXPCU_TXBUF_DATA_535_RESET                                             0x0
#define TXPCU_TXBUF_535_ADDRESS                                                (0x185c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_535_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_535_RESET                                                  0x0

// 0x1860 (TXPCU_TXBUF_536)
#define TXPCU_TXBUF_DATA_536_LSB                                               0
#define TXPCU_TXBUF_DATA_536_MSB                                               31
#define TXPCU_TXBUF_DATA_536_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_536_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_536_MASK) >> TXPCU_TXBUF_DATA_536_LSB)
#define TXPCU_TXBUF_DATA_536_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_536_LSB) & TXPCU_TXBUF_DATA_536_MASK)
#define TXPCU_TXBUF_DATA_536_RESET                                             0x0
#define TXPCU_TXBUF_536_ADDRESS                                                (0x1860 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_536_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_536_RESET                                                  0x0

// 0x1864 (TXPCU_TXBUF_537)
#define TXPCU_TXBUF_DATA_537_LSB                                               0
#define TXPCU_TXBUF_DATA_537_MSB                                               31
#define TXPCU_TXBUF_DATA_537_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_537_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_537_MASK) >> TXPCU_TXBUF_DATA_537_LSB)
#define TXPCU_TXBUF_DATA_537_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_537_LSB) & TXPCU_TXBUF_DATA_537_MASK)
#define TXPCU_TXBUF_DATA_537_RESET                                             0x0
#define TXPCU_TXBUF_537_ADDRESS                                                (0x1864 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_537_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_537_RESET                                                  0x0

// 0x1868 (TXPCU_TXBUF_538)
#define TXPCU_TXBUF_DATA_538_LSB                                               0
#define TXPCU_TXBUF_DATA_538_MSB                                               31
#define TXPCU_TXBUF_DATA_538_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_538_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_538_MASK) >> TXPCU_TXBUF_DATA_538_LSB)
#define TXPCU_TXBUF_DATA_538_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_538_LSB) & TXPCU_TXBUF_DATA_538_MASK)
#define TXPCU_TXBUF_DATA_538_RESET                                             0x0
#define TXPCU_TXBUF_538_ADDRESS                                                (0x1868 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_538_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_538_RESET                                                  0x0

// 0x186c (TXPCU_TXBUF_539)
#define TXPCU_TXBUF_DATA_539_LSB                                               0
#define TXPCU_TXBUF_DATA_539_MSB                                               31
#define TXPCU_TXBUF_DATA_539_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_539_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_539_MASK) >> TXPCU_TXBUF_DATA_539_LSB)
#define TXPCU_TXBUF_DATA_539_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_539_LSB) & TXPCU_TXBUF_DATA_539_MASK)
#define TXPCU_TXBUF_DATA_539_RESET                                             0x0
#define TXPCU_TXBUF_539_ADDRESS                                                (0x186c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_539_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_539_RESET                                                  0x0

// 0x1870 (TXPCU_TXBUF_540)
#define TXPCU_TXBUF_DATA_540_LSB                                               0
#define TXPCU_TXBUF_DATA_540_MSB                                               31
#define TXPCU_TXBUF_DATA_540_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_540_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_540_MASK) >> TXPCU_TXBUF_DATA_540_LSB)
#define TXPCU_TXBUF_DATA_540_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_540_LSB) & TXPCU_TXBUF_DATA_540_MASK)
#define TXPCU_TXBUF_DATA_540_RESET                                             0x0
#define TXPCU_TXBUF_540_ADDRESS                                                (0x1870 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_540_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_540_RESET                                                  0x0

// 0x1874 (TXPCU_TXBUF_541)
#define TXPCU_TXBUF_DATA_541_LSB                                               0
#define TXPCU_TXBUF_DATA_541_MSB                                               31
#define TXPCU_TXBUF_DATA_541_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_541_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_541_MASK) >> TXPCU_TXBUF_DATA_541_LSB)
#define TXPCU_TXBUF_DATA_541_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_541_LSB) & TXPCU_TXBUF_DATA_541_MASK)
#define TXPCU_TXBUF_DATA_541_RESET                                             0x0
#define TXPCU_TXBUF_541_ADDRESS                                                (0x1874 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_541_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_541_RESET                                                  0x0

// 0x1878 (TXPCU_TXBUF_542)
#define TXPCU_TXBUF_DATA_542_LSB                                               0
#define TXPCU_TXBUF_DATA_542_MSB                                               31
#define TXPCU_TXBUF_DATA_542_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_542_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_542_MASK) >> TXPCU_TXBUF_DATA_542_LSB)
#define TXPCU_TXBUF_DATA_542_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_542_LSB) & TXPCU_TXBUF_DATA_542_MASK)
#define TXPCU_TXBUF_DATA_542_RESET                                             0x0
#define TXPCU_TXBUF_542_ADDRESS                                                (0x1878 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_542_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_542_RESET                                                  0x0

// 0x187c (TXPCU_TXBUF_543)
#define TXPCU_TXBUF_DATA_543_LSB                                               0
#define TXPCU_TXBUF_DATA_543_MSB                                               31
#define TXPCU_TXBUF_DATA_543_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_543_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_543_MASK) >> TXPCU_TXBUF_DATA_543_LSB)
#define TXPCU_TXBUF_DATA_543_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_543_LSB) & TXPCU_TXBUF_DATA_543_MASK)
#define TXPCU_TXBUF_DATA_543_RESET                                             0x0
#define TXPCU_TXBUF_543_ADDRESS                                                (0x187c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_543_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_543_RESET                                                  0x0

// 0x1880 (TXPCU_TXBUF_544)
#define TXPCU_TXBUF_DATA_544_LSB                                               0
#define TXPCU_TXBUF_DATA_544_MSB                                               31
#define TXPCU_TXBUF_DATA_544_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_544_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_544_MASK) >> TXPCU_TXBUF_DATA_544_LSB)
#define TXPCU_TXBUF_DATA_544_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_544_LSB) & TXPCU_TXBUF_DATA_544_MASK)
#define TXPCU_TXBUF_DATA_544_RESET                                             0x0
#define TXPCU_TXBUF_544_ADDRESS                                                (0x1880 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_544_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_544_RESET                                                  0x0

// 0x1884 (TXPCU_TXBUF_545)
#define TXPCU_TXBUF_DATA_545_LSB                                               0
#define TXPCU_TXBUF_DATA_545_MSB                                               31
#define TXPCU_TXBUF_DATA_545_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_545_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_545_MASK) >> TXPCU_TXBUF_DATA_545_LSB)
#define TXPCU_TXBUF_DATA_545_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_545_LSB) & TXPCU_TXBUF_DATA_545_MASK)
#define TXPCU_TXBUF_DATA_545_RESET                                             0x0
#define TXPCU_TXBUF_545_ADDRESS                                                (0x1884 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_545_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_545_RESET                                                  0x0

// 0x1888 (TXPCU_TXBUF_546)
#define TXPCU_TXBUF_DATA_546_LSB                                               0
#define TXPCU_TXBUF_DATA_546_MSB                                               31
#define TXPCU_TXBUF_DATA_546_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_546_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_546_MASK) >> TXPCU_TXBUF_DATA_546_LSB)
#define TXPCU_TXBUF_DATA_546_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_546_LSB) & TXPCU_TXBUF_DATA_546_MASK)
#define TXPCU_TXBUF_DATA_546_RESET                                             0x0
#define TXPCU_TXBUF_546_ADDRESS                                                (0x1888 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_546_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_546_RESET                                                  0x0

// 0x188c (TXPCU_TXBUF_547)
#define TXPCU_TXBUF_DATA_547_LSB                                               0
#define TXPCU_TXBUF_DATA_547_MSB                                               31
#define TXPCU_TXBUF_DATA_547_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_547_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_547_MASK) >> TXPCU_TXBUF_DATA_547_LSB)
#define TXPCU_TXBUF_DATA_547_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_547_LSB) & TXPCU_TXBUF_DATA_547_MASK)
#define TXPCU_TXBUF_DATA_547_RESET                                             0x0
#define TXPCU_TXBUF_547_ADDRESS                                                (0x188c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_547_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_547_RESET                                                  0x0

// 0x1890 (TXPCU_TXBUF_548)
#define TXPCU_TXBUF_DATA_548_LSB                                               0
#define TXPCU_TXBUF_DATA_548_MSB                                               31
#define TXPCU_TXBUF_DATA_548_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_548_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_548_MASK) >> TXPCU_TXBUF_DATA_548_LSB)
#define TXPCU_TXBUF_DATA_548_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_548_LSB) & TXPCU_TXBUF_DATA_548_MASK)
#define TXPCU_TXBUF_DATA_548_RESET                                             0x0
#define TXPCU_TXBUF_548_ADDRESS                                                (0x1890 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_548_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_548_RESET                                                  0x0

// 0x1894 (TXPCU_TXBUF_549)
#define TXPCU_TXBUF_DATA_549_LSB                                               0
#define TXPCU_TXBUF_DATA_549_MSB                                               31
#define TXPCU_TXBUF_DATA_549_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_549_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_549_MASK) >> TXPCU_TXBUF_DATA_549_LSB)
#define TXPCU_TXBUF_DATA_549_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_549_LSB) & TXPCU_TXBUF_DATA_549_MASK)
#define TXPCU_TXBUF_DATA_549_RESET                                             0x0
#define TXPCU_TXBUF_549_ADDRESS                                                (0x1894 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_549_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_549_RESET                                                  0x0

// 0x1898 (TXPCU_TXBUF_550)
#define TXPCU_TXBUF_DATA_550_LSB                                               0
#define TXPCU_TXBUF_DATA_550_MSB                                               31
#define TXPCU_TXBUF_DATA_550_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_550_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_550_MASK) >> TXPCU_TXBUF_DATA_550_LSB)
#define TXPCU_TXBUF_DATA_550_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_550_LSB) & TXPCU_TXBUF_DATA_550_MASK)
#define TXPCU_TXBUF_DATA_550_RESET                                             0x0
#define TXPCU_TXBUF_550_ADDRESS                                                (0x1898 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_550_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_550_RESET                                                  0x0

// 0x189c (TXPCU_TXBUF_551)
#define TXPCU_TXBUF_DATA_551_LSB                                               0
#define TXPCU_TXBUF_DATA_551_MSB                                               31
#define TXPCU_TXBUF_DATA_551_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_551_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_551_MASK) >> TXPCU_TXBUF_DATA_551_LSB)
#define TXPCU_TXBUF_DATA_551_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_551_LSB) & TXPCU_TXBUF_DATA_551_MASK)
#define TXPCU_TXBUF_DATA_551_RESET                                             0x0
#define TXPCU_TXBUF_551_ADDRESS                                                (0x189c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_551_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_551_RESET                                                  0x0

// 0x18a0 (TXPCU_TXBUF_552)
#define TXPCU_TXBUF_DATA_552_LSB                                               0
#define TXPCU_TXBUF_DATA_552_MSB                                               31
#define TXPCU_TXBUF_DATA_552_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_552_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_552_MASK) >> TXPCU_TXBUF_DATA_552_LSB)
#define TXPCU_TXBUF_DATA_552_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_552_LSB) & TXPCU_TXBUF_DATA_552_MASK)
#define TXPCU_TXBUF_DATA_552_RESET                                             0x0
#define TXPCU_TXBUF_552_ADDRESS                                                (0x18a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_552_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_552_RESET                                                  0x0

// 0x18a4 (TXPCU_TXBUF_553)
#define TXPCU_TXBUF_DATA_553_LSB                                               0
#define TXPCU_TXBUF_DATA_553_MSB                                               31
#define TXPCU_TXBUF_DATA_553_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_553_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_553_MASK) >> TXPCU_TXBUF_DATA_553_LSB)
#define TXPCU_TXBUF_DATA_553_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_553_LSB) & TXPCU_TXBUF_DATA_553_MASK)
#define TXPCU_TXBUF_DATA_553_RESET                                             0x0
#define TXPCU_TXBUF_553_ADDRESS                                                (0x18a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_553_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_553_RESET                                                  0x0

// 0x18a8 (TXPCU_TXBUF_554)
#define TXPCU_TXBUF_DATA_554_LSB                                               0
#define TXPCU_TXBUF_DATA_554_MSB                                               31
#define TXPCU_TXBUF_DATA_554_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_554_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_554_MASK) >> TXPCU_TXBUF_DATA_554_LSB)
#define TXPCU_TXBUF_DATA_554_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_554_LSB) & TXPCU_TXBUF_DATA_554_MASK)
#define TXPCU_TXBUF_DATA_554_RESET                                             0x0
#define TXPCU_TXBUF_554_ADDRESS                                                (0x18a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_554_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_554_RESET                                                  0x0

// 0x18ac (TXPCU_TXBUF_555)
#define TXPCU_TXBUF_DATA_555_LSB                                               0
#define TXPCU_TXBUF_DATA_555_MSB                                               31
#define TXPCU_TXBUF_DATA_555_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_555_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_555_MASK) >> TXPCU_TXBUF_DATA_555_LSB)
#define TXPCU_TXBUF_DATA_555_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_555_LSB) & TXPCU_TXBUF_DATA_555_MASK)
#define TXPCU_TXBUF_DATA_555_RESET                                             0x0
#define TXPCU_TXBUF_555_ADDRESS                                                (0x18ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_555_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_555_RESET                                                  0x0

// 0x18b0 (TXPCU_TXBUF_556)
#define TXPCU_TXBUF_DATA_556_LSB                                               0
#define TXPCU_TXBUF_DATA_556_MSB                                               31
#define TXPCU_TXBUF_DATA_556_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_556_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_556_MASK) >> TXPCU_TXBUF_DATA_556_LSB)
#define TXPCU_TXBUF_DATA_556_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_556_LSB) & TXPCU_TXBUF_DATA_556_MASK)
#define TXPCU_TXBUF_DATA_556_RESET                                             0x0
#define TXPCU_TXBUF_556_ADDRESS                                                (0x18b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_556_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_556_RESET                                                  0x0

// 0x18b4 (TXPCU_TXBUF_557)
#define TXPCU_TXBUF_DATA_557_LSB                                               0
#define TXPCU_TXBUF_DATA_557_MSB                                               31
#define TXPCU_TXBUF_DATA_557_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_557_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_557_MASK) >> TXPCU_TXBUF_DATA_557_LSB)
#define TXPCU_TXBUF_DATA_557_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_557_LSB) & TXPCU_TXBUF_DATA_557_MASK)
#define TXPCU_TXBUF_DATA_557_RESET                                             0x0
#define TXPCU_TXBUF_557_ADDRESS                                                (0x18b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_557_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_557_RESET                                                  0x0

// 0x18b8 (TXPCU_TXBUF_558)
#define TXPCU_TXBUF_DATA_558_LSB                                               0
#define TXPCU_TXBUF_DATA_558_MSB                                               31
#define TXPCU_TXBUF_DATA_558_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_558_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_558_MASK) >> TXPCU_TXBUF_DATA_558_LSB)
#define TXPCU_TXBUF_DATA_558_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_558_LSB) & TXPCU_TXBUF_DATA_558_MASK)
#define TXPCU_TXBUF_DATA_558_RESET                                             0x0
#define TXPCU_TXBUF_558_ADDRESS                                                (0x18b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_558_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_558_RESET                                                  0x0

// 0x18bc (TXPCU_TXBUF_559)
#define TXPCU_TXBUF_DATA_559_LSB                                               0
#define TXPCU_TXBUF_DATA_559_MSB                                               31
#define TXPCU_TXBUF_DATA_559_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_559_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_559_MASK) >> TXPCU_TXBUF_DATA_559_LSB)
#define TXPCU_TXBUF_DATA_559_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_559_LSB) & TXPCU_TXBUF_DATA_559_MASK)
#define TXPCU_TXBUF_DATA_559_RESET                                             0x0
#define TXPCU_TXBUF_559_ADDRESS                                                (0x18bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_559_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_559_RESET                                                  0x0

// 0x18c0 (TXPCU_TXBUF_560)
#define TXPCU_TXBUF_DATA_560_LSB                                               0
#define TXPCU_TXBUF_DATA_560_MSB                                               31
#define TXPCU_TXBUF_DATA_560_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_560_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_560_MASK) >> TXPCU_TXBUF_DATA_560_LSB)
#define TXPCU_TXBUF_DATA_560_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_560_LSB) & TXPCU_TXBUF_DATA_560_MASK)
#define TXPCU_TXBUF_DATA_560_RESET                                             0x0
#define TXPCU_TXBUF_560_ADDRESS                                                (0x18c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_560_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_560_RESET                                                  0x0

// 0x18c4 (TXPCU_TXBUF_561)
#define TXPCU_TXBUF_DATA_561_LSB                                               0
#define TXPCU_TXBUF_DATA_561_MSB                                               31
#define TXPCU_TXBUF_DATA_561_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_561_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_561_MASK) >> TXPCU_TXBUF_DATA_561_LSB)
#define TXPCU_TXBUF_DATA_561_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_561_LSB) & TXPCU_TXBUF_DATA_561_MASK)
#define TXPCU_TXBUF_DATA_561_RESET                                             0x0
#define TXPCU_TXBUF_561_ADDRESS                                                (0x18c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_561_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_561_RESET                                                  0x0

// 0x18c8 (TXPCU_TXBUF_562)
#define TXPCU_TXBUF_DATA_562_LSB                                               0
#define TXPCU_TXBUF_DATA_562_MSB                                               31
#define TXPCU_TXBUF_DATA_562_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_562_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_562_MASK) >> TXPCU_TXBUF_DATA_562_LSB)
#define TXPCU_TXBUF_DATA_562_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_562_LSB) & TXPCU_TXBUF_DATA_562_MASK)
#define TXPCU_TXBUF_DATA_562_RESET                                             0x0
#define TXPCU_TXBUF_562_ADDRESS                                                (0x18c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_562_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_562_RESET                                                  0x0

// 0x18cc (TXPCU_TXBUF_563)
#define TXPCU_TXBUF_DATA_563_LSB                                               0
#define TXPCU_TXBUF_DATA_563_MSB                                               31
#define TXPCU_TXBUF_DATA_563_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_563_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_563_MASK) >> TXPCU_TXBUF_DATA_563_LSB)
#define TXPCU_TXBUF_DATA_563_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_563_LSB) & TXPCU_TXBUF_DATA_563_MASK)
#define TXPCU_TXBUF_DATA_563_RESET                                             0x0
#define TXPCU_TXBUF_563_ADDRESS                                                (0x18cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_563_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_563_RESET                                                  0x0

// 0x18d0 (TXPCU_TXBUF_564)
#define TXPCU_TXBUF_DATA_564_LSB                                               0
#define TXPCU_TXBUF_DATA_564_MSB                                               31
#define TXPCU_TXBUF_DATA_564_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_564_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_564_MASK) >> TXPCU_TXBUF_DATA_564_LSB)
#define TXPCU_TXBUF_DATA_564_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_564_LSB) & TXPCU_TXBUF_DATA_564_MASK)
#define TXPCU_TXBUF_DATA_564_RESET                                             0x0
#define TXPCU_TXBUF_564_ADDRESS                                                (0x18d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_564_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_564_RESET                                                  0x0

// 0x18d4 (TXPCU_TXBUF_565)
#define TXPCU_TXBUF_DATA_565_LSB                                               0
#define TXPCU_TXBUF_DATA_565_MSB                                               31
#define TXPCU_TXBUF_DATA_565_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_565_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_565_MASK) >> TXPCU_TXBUF_DATA_565_LSB)
#define TXPCU_TXBUF_DATA_565_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_565_LSB) & TXPCU_TXBUF_DATA_565_MASK)
#define TXPCU_TXBUF_DATA_565_RESET                                             0x0
#define TXPCU_TXBUF_565_ADDRESS                                                (0x18d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_565_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_565_RESET                                                  0x0

// 0x18d8 (TXPCU_TXBUF_566)
#define TXPCU_TXBUF_DATA_566_LSB                                               0
#define TXPCU_TXBUF_DATA_566_MSB                                               31
#define TXPCU_TXBUF_DATA_566_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_566_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_566_MASK) >> TXPCU_TXBUF_DATA_566_LSB)
#define TXPCU_TXBUF_DATA_566_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_566_LSB) & TXPCU_TXBUF_DATA_566_MASK)
#define TXPCU_TXBUF_DATA_566_RESET                                             0x0
#define TXPCU_TXBUF_566_ADDRESS                                                (0x18d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_566_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_566_RESET                                                  0x0

// 0x18dc (TXPCU_TXBUF_567)
#define TXPCU_TXBUF_DATA_567_LSB                                               0
#define TXPCU_TXBUF_DATA_567_MSB                                               31
#define TXPCU_TXBUF_DATA_567_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_567_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_567_MASK) >> TXPCU_TXBUF_DATA_567_LSB)
#define TXPCU_TXBUF_DATA_567_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_567_LSB) & TXPCU_TXBUF_DATA_567_MASK)
#define TXPCU_TXBUF_DATA_567_RESET                                             0x0
#define TXPCU_TXBUF_567_ADDRESS                                                (0x18dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_567_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_567_RESET                                                  0x0

// 0x18e0 (TXPCU_TXBUF_568)
#define TXPCU_TXBUF_DATA_568_LSB                                               0
#define TXPCU_TXBUF_DATA_568_MSB                                               31
#define TXPCU_TXBUF_DATA_568_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_568_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_568_MASK) >> TXPCU_TXBUF_DATA_568_LSB)
#define TXPCU_TXBUF_DATA_568_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_568_LSB) & TXPCU_TXBUF_DATA_568_MASK)
#define TXPCU_TXBUF_DATA_568_RESET                                             0x0
#define TXPCU_TXBUF_568_ADDRESS                                                (0x18e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_568_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_568_RESET                                                  0x0

// 0x18e4 (TXPCU_TXBUF_569)
#define TXPCU_TXBUF_DATA_569_LSB                                               0
#define TXPCU_TXBUF_DATA_569_MSB                                               31
#define TXPCU_TXBUF_DATA_569_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_569_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_569_MASK) >> TXPCU_TXBUF_DATA_569_LSB)
#define TXPCU_TXBUF_DATA_569_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_569_LSB) & TXPCU_TXBUF_DATA_569_MASK)
#define TXPCU_TXBUF_DATA_569_RESET                                             0x0
#define TXPCU_TXBUF_569_ADDRESS                                                (0x18e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_569_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_569_RESET                                                  0x0

// 0x18e8 (TXPCU_TXBUF_570)
#define TXPCU_TXBUF_DATA_570_LSB                                               0
#define TXPCU_TXBUF_DATA_570_MSB                                               31
#define TXPCU_TXBUF_DATA_570_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_570_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_570_MASK) >> TXPCU_TXBUF_DATA_570_LSB)
#define TXPCU_TXBUF_DATA_570_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_570_LSB) & TXPCU_TXBUF_DATA_570_MASK)
#define TXPCU_TXBUF_DATA_570_RESET                                             0x0
#define TXPCU_TXBUF_570_ADDRESS                                                (0x18e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_570_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_570_RESET                                                  0x0

// 0x18ec (TXPCU_TXBUF_571)
#define TXPCU_TXBUF_DATA_571_LSB                                               0
#define TXPCU_TXBUF_DATA_571_MSB                                               31
#define TXPCU_TXBUF_DATA_571_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_571_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_571_MASK) >> TXPCU_TXBUF_DATA_571_LSB)
#define TXPCU_TXBUF_DATA_571_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_571_LSB) & TXPCU_TXBUF_DATA_571_MASK)
#define TXPCU_TXBUF_DATA_571_RESET                                             0x0
#define TXPCU_TXBUF_571_ADDRESS                                                (0x18ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_571_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_571_RESET                                                  0x0

// 0x18f0 (TXPCU_TXBUF_572)
#define TXPCU_TXBUF_DATA_572_LSB                                               0
#define TXPCU_TXBUF_DATA_572_MSB                                               31
#define TXPCU_TXBUF_DATA_572_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_572_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_572_MASK) >> TXPCU_TXBUF_DATA_572_LSB)
#define TXPCU_TXBUF_DATA_572_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_572_LSB) & TXPCU_TXBUF_DATA_572_MASK)
#define TXPCU_TXBUF_DATA_572_RESET                                             0x0
#define TXPCU_TXBUF_572_ADDRESS                                                (0x18f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_572_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_572_RESET                                                  0x0

// 0x18f4 (TXPCU_TXBUF_573)
#define TXPCU_TXBUF_DATA_573_LSB                                               0
#define TXPCU_TXBUF_DATA_573_MSB                                               31
#define TXPCU_TXBUF_DATA_573_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_573_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_573_MASK) >> TXPCU_TXBUF_DATA_573_LSB)
#define TXPCU_TXBUF_DATA_573_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_573_LSB) & TXPCU_TXBUF_DATA_573_MASK)
#define TXPCU_TXBUF_DATA_573_RESET                                             0x0
#define TXPCU_TXBUF_573_ADDRESS                                                (0x18f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_573_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_573_RESET                                                  0x0

// 0x18f8 (TXPCU_TXBUF_574)
#define TXPCU_TXBUF_DATA_574_LSB                                               0
#define TXPCU_TXBUF_DATA_574_MSB                                               31
#define TXPCU_TXBUF_DATA_574_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_574_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_574_MASK) >> TXPCU_TXBUF_DATA_574_LSB)
#define TXPCU_TXBUF_DATA_574_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_574_LSB) & TXPCU_TXBUF_DATA_574_MASK)
#define TXPCU_TXBUF_DATA_574_RESET                                             0x0
#define TXPCU_TXBUF_574_ADDRESS                                                (0x18f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_574_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_574_RESET                                                  0x0

// 0x18fc (TXPCU_TXBUF_575)
#define TXPCU_TXBUF_DATA_575_LSB                                               0
#define TXPCU_TXBUF_DATA_575_MSB                                               31
#define TXPCU_TXBUF_DATA_575_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_575_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_575_MASK) >> TXPCU_TXBUF_DATA_575_LSB)
#define TXPCU_TXBUF_DATA_575_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_575_LSB) & TXPCU_TXBUF_DATA_575_MASK)
#define TXPCU_TXBUF_DATA_575_RESET                                             0x0
#define TXPCU_TXBUF_575_ADDRESS                                                (0x18fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_575_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_575_RESET                                                  0x0

// 0x1900 (TXPCU_TXBUF_576)
#define TXPCU_TXBUF_DATA_576_LSB                                               0
#define TXPCU_TXBUF_DATA_576_MSB                                               31
#define TXPCU_TXBUF_DATA_576_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_576_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_576_MASK) >> TXPCU_TXBUF_DATA_576_LSB)
#define TXPCU_TXBUF_DATA_576_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_576_LSB) & TXPCU_TXBUF_DATA_576_MASK)
#define TXPCU_TXBUF_DATA_576_RESET                                             0x0
#define TXPCU_TXBUF_576_ADDRESS                                                (0x1900 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_576_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_576_RESET                                                  0x0

// 0x1904 (TXPCU_TXBUF_577)
#define TXPCU_TXBUF_DATA_577_LSB                                               0
#define TXPCU_TXBUF_DATA_577_MSB                                               31
#define TXPCU_TXBUF_DATA_577_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_577_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_577_MASK) >> TXPCU_TXBUF_DATA_577_LSB)
#define TXPCU_TXBUF_DATA_577_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_577_LSB) & TXPCU_TXBUF_DATA_577_MASK)
#define TXPCU_TXBUF_DATA_577_RESET                                             0x0
#define TXPCU_TXBUF_577_ADDRESS                                                (0x1904 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_577_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_577_RESET                                                  0x0

// 0x1908 (TXPCU_TXBUF_578)
#define TXPCU_TXBUF_DATA_578_LSB                                               0
#define TXPCU_TXBUF_DATA_578_MSB                                               31
#define TXPCU_TXBUF_DATA_578_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_578_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_578_MASK) >> TXPCU_TXBUF_DATA_578_LSB)
#define TXPCU_TXBUF_DATA_578_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_578_LSB) & TXPCU_TXBUF_DATA_578_MASK)
#define TXPCU_TXBUF_DATA_578_RESET                                             0x0
#define TXPCU_TXBUF_578_ADDRESS                                                (0x1908 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_578_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_578_RESET                                                  0x0

// 0x190c (TXPCU_TXBUF_579)
#define TXPCU_TXBUF_DATA_579_LSB                                               0
#define TXPCU_TXBUF_DATA_579_MSB                                               31
#define TXPCU_TXBUF_DATA_579_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_579_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_579_MASK) >> TXPCU_TXBUF_DATA_579_LSB)
#define TXPCU_TXBUF_DATA_579_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_579_LSB) & TXPCU_TXBUF_DATA_579_MASK)
#define TXPCU_TXBUF_DATA_579_RESET                                             0x0
#define TXPCU_TXBUF_579_ADDRESS                                                (0x190c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_579_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_579_RESET                                                  0x0

// 0x1910 (TXPCU_TXBUF_580)
#define TXPCU_TXBUF_DATA_580_LSB                                               0
#define TXPCU_TXBUF_DATA_580_MSB                                               31
#define TXPCU_TXBUF_DATA_580_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_580_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_580_MASK) >> TXPCU_TXBUF_DATA_580_LSB)
#define TXPCU_TXBUF_DATA_580_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_580_LSB) & TXPCU_TXBUF_DATA_580_MASK)
#define TXPCU_TXBUF_DATA_580_RESET                                             0x0
#define TXPCU_TXBUF_580_ADDRESS                                                (0x1910 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_580_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_580_RESET                                                  0x0

// 0x1914 (TXPCU_TXBUF_581)
#define TXPCU_TXBUF_DATA_581_LSB                                               0
#define TXPCU_TXBUF_DATA_581_MSB                                               31
#define TXPCU_TXBUF_DATA_581_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_581_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_581_MASK) >> TXPCU_TXBUF_DATA_581_LSB)
#define TXPCU_TXBUF_DATA_581_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_581_LSB) & TXPCU_TXBUF_DATA_581_MASK)
#define TXPCU_TXBUF_DATA_581_RESET                                             0x0
#define TXPCU_TXBUF_581_ADDRESS                                                (0x1914 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_581_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_581_RESET                                                  0x0

// 0x1918 (TXPCU_TXBUF_582)
#define TXPCU_TXBUF_DATA_582_LSB                                               0
#define TXPCU_TXBUF_DATA_582_MSB                                               31
#define TXPCU_TXBUF_DATA_582_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_582_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_582_MASK) >> TXPCU_TXBUF_DATA_582_LSB)
#define TXPCU_TXBUF_DATA_582_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_582_LSB) & TXPCU_TXBUF_DATA_582_MASK)
#define TXPCU_TXBUF_DATA_582_RESET                                             0x0
#define TXPCU_TXBUF_582_ADDRESS                                                (0x1918 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_582_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_582_RESET                                                  0x0

// 0x191c (TXPCU_TXBUF_583)
#define TXPCU_TXBUF_DATA_583_LSB                                               0
#define TXPCU_TXBUF_DATA_583_MSB                                               31
#define TXPCU_TXBUF_DATA_583_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_583_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_583_MASK) >> TXPCU_TXBUF_DATA_583_LSB)
#define TXPCU_TXBUF_DATA_583_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_583_LSB) & TXPCU_TXBUF_DATA_583_MASK)
#define TXPCU_TXBUF_DATA_583_RESET                                             0x0
#define TXPCU_TXBUF_583_ADDRESS                                                (0x191c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_583_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_583_RESET                                                  0x0

// 0x1920 (TXPCU_TXBUF_584)
#define TXPCU_TXBUF_DATA_584_LSB                                               0
#define TXPCU_TXBUF_DATA_584_MSB                                               31
#define TXPCU_TXBUF_DATA_584_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_584_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_584_MASK) >> TXPCU_TXBUF_DATA_584_LSB)
#define TXPCU_TXBUF_DATA_584_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_584_LSB) & TXPCU_TXBUF_DATA_584_MASK)
#define TXPCU_TXBUF_DATA_584_RESET                                             0x0
#define TXPCU_TXBUF_584_ADDRESS                                                (0x1920 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_584_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_584_RESET                                                  0x0

// 0x1924 (TXPCU_TXBUF_585)
#define TXPCU_TXBUF_DATA_585_LSB                                               0
#define TXPCU_TXBUF_DATA_585_MSB                                               31
#define TXPCU_TXBUF_DATA_585_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_585_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_585_MASK) >> TXPCU_TXBUF_DATA_585_LSB)
#define TXPCU_TXBUF_DATA_585_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_585_LSB) & TXPCU_TXBUF_DATA_585_MASK)
#define TXPCU_TXBUF_DATA_585_RESET                                             0x0
#define TXPCU_TXBUF_585_ADDRESS                                                (0x1924 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_585_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_585_RESET                                                  0x0

// 0x1928 (TXPCU_TXBUF_586)
#define TXPCU_TXBUF_DATA_586_LSB                                               0
#define TXPCU_TXBUF_DATA_586_MSB                                               31
#define TXPCU_TXBUF_DATA_586_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_586_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_586_MASK) >> TXPCU_TXBUF_DATA_586_LSB)
#define TXPCU_TXBUF_DATA_586_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_586_LSB) & TXPCU_TXBUF_DATA_586_MASK)
#define TXPCU_TXBUF_DATA_586_RESET                                             0x0
#define TXPCU_TXBUF_586_ADDRESS                                                (0x1928 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_586_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_586_RESET                                                  0x0

// 0x192c (TXPCU_TXBUF_587)
#define TXPCU_TXBUF_DATA_587_LSB                                               0
#define TXPCU_TXBUF_DATA_587_MSB                                               31
#define TXPCU_TXBUF_DATA_587_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_587_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_587_MASK) >> TXPCU_TXBUF_DATA_587_LSB)
#define TXPCU_TXBUF_DATA_587_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_587_LSB) & TXPCU_TXBUF_DATA_587_MASK)
#define TXPCU_TXBUF_DATA_587_RESET                                             0x0
#define TXPCU_TXBUF_587_ADDRESS                                                (0x192c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_587_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_587_RESET                                                  0x0

// 0x1930 (TXPCU_TXBUF_588)
#define TXPCU_TXBUF_DATA_588_LSB                                               0
#define TXPCU_TXBUF_DATA_588_MSB                                               31
#define TXPCU_TXBUF_DATA_588_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_588_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_588_MASK) >> TXPCU_TXBUF_DATA_588_LSB)
#define TXPCU_TXBUF_DATA_588_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_588_LSB) & TXPCU_TXBUF_DATA_588_MASK)
#define TXPCU_TXBUF_DATA_588_RESET                                             0x0
#define TXPCU_TXBUF_588_ADDRESS                                                (0x1930 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_588_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_588_RESET                                                  0x0

// 0x1934 (TXPCU_TXBUF_589)
#define TXPCU_TXBUF_DATA_589_LSB                                               0
#define TXPCU_TXBUF_DATA_589_MSB                                               31
#define TXPCU_TXBUF_DATA_589_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_589_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_589_MASK) >> TXPCU_TXBUF_DATA_589_LSB)
#define TXPCU_TXBUF_DATA_589_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_589_LSB) & TXPCU_TXBUF_DATA_589_MASK)
#define TXPCU_TXBUF_DATA_589_RESET                                             0x0
#define TXPCU_TXBUF_589_ADDRESS                                                (0x1934 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_589_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_589_RESET                                                  0x0

// 0x1938 (TXPCU_TXBUF_590)
#define TXPCU_TXBUF_DATA_590_LSB                                               0
#define TXPCU_TXBUF_DATA_590_MSB                                               31
#define TXPCU_TXBUF_DATA_590_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_590_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_590_MASK) >> TXPCU_TXBUF_DATA_590_LSB)
#define TXPCU_TXBUF_DATA_590_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_590_LSB) & TXPCU_TXBUF_DATA_590_MASK)
#define TXPCU_TXBUF_DATA_590_RESET                                             0x0
#define TXPCU_TXBUF_590_ADDRESS                                                (0x1938 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_590_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_590_RESET                                                  0x0

// 0x193c (TXPCU_TXBUF_591)
#define TXPCU_TXBUF_DATA_591_LSB                                               0
#define TXPCU_TXBUF_DATA_591_MSB                                               31
#define TXPCU_TXBUF_DATA_591_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_591_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_591_MASK) >> TXPCU_TXBUF_DATA_591_LSB)
#define TXPCU_TXBUF_DATA_591_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_591_LSB) & TXPCU_TXBUF_DATA_591_MASK)
#define TXPCU_TXBUF_DATA_591_RESET                                             0x0
#define TXPCU_TXBUF_591_ADDRESS                                                (0x193c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_591_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_591_RESET                                                  0x0

// 0x1940 (TXPCU_TXBUF_592)
#define TXPCU_TXBUF_DATA_592_LSB                                               0
#define TXPCU_TXBUF_DATA_592_MSB                                               31
#define TXPCU_TXBUF_DATA_592_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_592_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_592_MASK) >> TXPCU_TXBUF_DATA_592_LSB)
#define TXPCU_TXBUF_DATA_592_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_592_LSB) & TXPCU_TXBUF_DATA_592_MASK)
#define TXPCU_TXBUF_DATA_592_RESET                                             0x0
#define TXPCU_TXBUF_592_ADDRESS                                                (0x1940 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_592_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_592_RESET                                                  0x0

// 0x1944 (TXPCU_TXBUF_593)
#define TXPCU_TXBUF_DATA_593_LSB                                               0
#define TXPCU_TXBUF_DATA_593_MSB                                               31
#define TXPCU_TXBUF_DATA_593_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_593_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_593_MASK) >> TXPCU_TXBUF_DATA_593_LSB)
#define TXPCU_TXBUF_DATA_593_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_593_LSB) & TXPCU_TXBUF_DATA_593_MASK)
#define TXPCU_TXBUF_DATA_593_RESET                                             0x0
#define TXPCU_TXBUF_593_ADDRESS                                                (0x1944 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_593_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_593_RESET                                                  0x0

// 0x1948 (TXPCU_TXBUF_594)
#define TXPCU_TXBUF_DATA_594_LSB                                               0
#define TXPCU_TXBUF_DATA_594_MSB                                               31
#define TXPCU_TXBUF_DATA_594_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_594_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_594_MASK) >> TXPCU_TXBUF_DATA_594_LSB)
#define TXPCU_TXBUF_DATA_594_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_594_LSB) & TXPCU_TXBUF_DATA_594_MASK)
#define TXPCU_TXBUF_DATA_594_RESET                                             0x0
#define TXPCU_TXBUF_594_ADDRESS                                                (0x1948 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_594_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_594_RESET                                                  0x0

// 0x194c (TXPCU_TXBUF_595)
#define TXPCU_TXBUF_DATA_595_LSB                                               0
#define TXPCU_TXBUF_DATA_595_MSB                                               31
#define TXPCU_TXBUF_DATA_595_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_595_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_595_MASK) >> TXPCU_TXBUF_DATA_595_LSB)
#define TXPCU_TXBUF_DATA_595_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_595_LSB) & TXPCU_TXBUF_DATA_595_MASK)
#define TXPCU_TXBUF_DATA_595_RESET                                             0x0
#define TXPCU_TXBUF_595_ADDRESS                                                (0x194c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_595_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_595_RESET                                                  0x0

// 0x1950 (TXPCU_TXBUF_596)
#define TXPCU_TXBUF_DATA_596_LSB                                               0
#define TXPCU_TXBUF_DATA_596_MSB                                               31
#define TXPCU_TXBUF_DATA_596_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_596_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_596_MASK) >> TXPCU_TXBUF_DATA_596_LSB)
#define TXPCU_TXBUF_DATA_596_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_596_LSB) & TXPCU_TXBUF_DATA_596_MASK)
#define TXPCU_TXBUF_DATA_596_RESET                                             0x0
#define TXPCU_TXBUF_596_ADDRESS                                                (0x1950 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_596_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_596_RESET                                                  0x0

// 0x1954 (TXPCU_TXBUF_597)
#define TXPCU_TXBUF_DATA_597_LSB                                               0
#define TXPCU_TXBUF_DATA_597_MSB                                               31
#define TXPCU_TXBUF_DATA_597_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_597_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_597_MASK) >> TXPCU_TXBUF_DATA_597_LSB)
#define TXPCU_TXBUF_DATA_597_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_597_LSB) & TXPCU_TXBUF_DATA_597_MASK)
#define TXPCU_TXBUF_DATA_597_RESET                                             0x0
#define TXPCU_TXBUF_597_ADDRESS                                                (0x1954 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_597_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_597_RESET                                                  0x0

// 0x1958 (TXPCU_TXBUF_598)
#define TXPCU_TXBUF_DATA_598_LSB                                               0
#define TXPCU_TXBUF_DATA_598_MSB                                               31
#define TXPCU_TXBUF_DATA_598_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_598_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_598_MASK) >> TXPCU_TXBUF_DATA_598_LSB)
#define TXPCU_TXBUF_DATA_598_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_598_LSB) & TXPCU_TXBUF_DATA_598_MASK)
#define TXPCU_TXBUF_DATA_598_RESET                                             0x0
#define TXPCU_TXBUF_598_ADDRESS                                                (0x1958 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_598_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_598_RESET                                                  0x0

// 0x195c (TXPCU_TXBUF_599)
#define TXPCU_TXBUF_DATA_599_LSB                                               0
#define TXPCU_TXBUF_DATA_599_MSB                                               31
#define TXPCU_TXBUF_DATA_599_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_599_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_599_MASK) >> TXPCU_TXBUF_DATA_599_LSB)
#define TXPCU_TXBUF_DATA_599_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_599_LSB) & TXPCU_TXBUF_DATA_599_MASK)
#define TXPCU_TXBUF_DATA_599_RESET                                             0x0
#define TXPCU_TXBUF_599_ADDRESS                                                (0x195c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_599_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_599_RESET                                                  0x0

// 0x1960 (TXPCU_TXBUF_600)
#define TXPCU_TXBUF_DATA_600_LSB                                               0
#define TXPCU_TXBUF_DATA_600_MSB                                               31
#define TXPCU_TXBUF_DATA_600_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_600_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_600_MASK) >> TXPCU_TXBUF_DATA_600_LSB)
#define TXPCU_TXBUF_DATA_600_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_600_LSB) & TXPCU_TXBUF_DATA_600_MASK)
#define TXPCU_TXBUF_DATA_600_RESET                                             0x0
#define TXPCU_TXBUF_600_ADDRESS                                                (0x1960 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_600_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_600_RESET                                                  0x0

// 0x1964 (TXPCU_TXBUF_601)
#define TXPCU_TXBUF_DATA_601_LSB                                               0
#define TXPCU_TXBUF_DATA_601_MSB                                               31
#define TXPCU_TXBUF_DATA_601_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_601_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_601_MASK) >> TXPCU_TXBUF_DATA_601_LSB)
#define TXPCU_TXBUF_DATA_601_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_601_LSB) & TXPCU_TXBUF_DATA_601_MASK)
#define TXPCU_TXBUF_DATA_601_RESET                                             0x0
#define TXPCU_TXBUF_601_ADDRESS                                                (0x1964 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_601_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_601_RESET                                                  0x0

// 0x1968 (TXPCU_TXBUF_602)
#define TXPCU_TXBUF_DATA_602_LSB                                               0
#define TXPCU_TXBUF_DATA_602_MSB                                               31
#define TXPCU_TXBUF_DATA_602_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_602_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_602_MASK) >> TXPCU_TXBUF_DATA_602_LSB)
#define TXPCU_TXBUF_DATA_602_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_602_LSB) & TXPCU_TXBUF_DATA_602_MASK)
#define TXPCU_TXBUF_DATA_602_RESET                                             0x0
#define TXPCU_TXBUF_602_ADDRESS                                                (0x1968 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_602_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_602_RESET                                                  0x0

// 0x196c (TXPCU_TXBUF_603)
#define TXPCU_TXBUF_DATA_603_LSB                                               0
#define TXPCU_TXBUF_DATA_603_MSB                                               31
#define TXPCU_TXBUF_DATA_603_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_603_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_603_MASK) >> TXPCU_TXBUF_DATA_603_LSB)
#define TXPCU_TXBUF_DATA_603_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_603_LSB) & TXPCU_TXBUF_DATA_603_MASK)
#define TXPCU_TXBUF_DATA_603_RESET                                             0x0
#define TXPCU_TXBUF_603_ADDRESS                                                (0x196c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_603_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_603_RESET                                                  0x0

// 0x1970 (TXPCU_TXBUF_604)
#define TXPCU_TXBUF_DATA_604_LSB                                               0
#define TXPCU_TXBUF_DATA_604_MSB                                               31
#define TXPCU_TXBUF_DATA_604_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_604_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_604_MASK) >> TXPCU_TXBUF_DATA_604_LSB)
#define TXPCU_TXBUF_DATA_604_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_604_LSB) & TXPCU_TXBUF_DATA_604_MASK)
#define TXPCU_TXBUF_DATA_604_RESET                                             0x0
#define TXPCU_TXBUF_604_ADDRESS                                                (0x1970 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_604_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_604_RESET                                                  0x0

// 0x1974 (TXPCU_TXBUF_605)
#define TXPCU_TXBUF_DATA_605_LSB                                               0
#define TXPCU_TXBUF_DATA_605_MSB                                               31
#define TXPCU_TXBUF_DATA_605_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_605_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_605_MASK) >> TXPCU_TXBUF_DATA_605_LSB)
#define TXPCU_TXBUF_DATA_605_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_605_LSB) & TXPCU_TXBUF_DATA_605_MASK)
#define TXPCU_TXBUF_DATA_605_RESET                                             0x0
#define TXPCU_TXBUF_605_ADDRESS                                                (0x1974 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_605_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_605_RESET                                                  0x0

// 0x1978 (TXPCU_TXBUF_606)
#define TXPCU_TXBUF_DATA_606_LSB                                               0
#define TXPCU_TXBUF_DATA_606_MSB                                               31
#define TXPCU_TXBUF_DATA_606_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_606_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_606_MASK) >> TXPCU_TXBUF_DATA_606_LSB)
#define TXPCU_TXBUF_DATA_606_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_606_LSB) & TXPCU_TXBUF_DATA_606_MASK)
#define TXPCU_TXBUF_DATA_606_RESET                                             0x0
#define TXPCU_TXBUF_606_ADDRESS                                                (0x1978 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_606_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_606_RESET                                                  0x0

// 0x197c (TXPCU_TXBUF_607)
#define TXPCU_TXBUF_DATA_607_LSB                                               0
#define TXPCU_TXBUF_DATA_607_MSB                                               31
#define TXPCU_TXBUF_DATA_607_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_607_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_607_MASK) >> TXPCU_TXBUF_DATA_607_LSB)
#define TXPCU_TXBUF_DATA_607_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_607_LSB) & TXPCU_TXBUF_DATA_607_MASK)
#define TXPCU_TXBUF_DATA_607_RESET                                             0x0
#define TXPCU_TXBUF_607_ADDRESS                                                (0x197c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_607_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_607_RESET                                                  0x0

// 0x1980 (TXPCU_TXBUF_608)
#define TXPCU_TXBUF_DATA_608_LSB                                               0
#define TXPCU_TXBUF_DATA_608_MSB                                               31
#define TXPCU_TXBUF_DATA_608_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_608_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_608_MASK) >> TXPCU_TXBUF_DATA_608_LSB)
#define TXPCU_TXBUF_DATA_608_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_608_LSB) & TXPCU_TXBUF_DATA_608_MASK)
#define TXPCU_TXBUF_DATA_608_RESET                                             0x0
#define TXPCU_TXBUF_608_ADDRESS                                                (0x1980 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_608_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_608_RESET                                                  0x0

// 0x1984 (TXPCU_TXBUF_609)
#define TXPCU_TXBUF_DATA_609_LSB                                               0
#define TXPCU_TXBUF_DATA_609_MSB                                               31
#define TXPCU_TXBUF_DATA_609_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_609_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_609_MASK) >> TXPCU_TXBUF_DATA_609_LSB)
#define TXPCU_TXBUF_DATA_609_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_609_LSB) & TXPCU_TXBUF_DATA_609_MASK)
#define TXPCU_TXBUF_DATA_609_RESET                                             0x0
#define TXPCU_TXBUF_609_ADDRESS                                                (0x1984 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_609_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_609_RESET                                                  0x0

// 0x1988 (TXPCU_TXBUF_610)
#define TXPCU_TXBUF_DATA_610_LSB                                               0
#define TXPCU_TXBUF_DATA_610_MSB                                               31
#define TXPCU_TXBUF_DATA_610_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_610_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_610_MASK) >> TXPCU_TXBUF_DATA_610_LSB)
#define TXPCU_TXBUF_DATA_610_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_610_LSB) & TXPCU_TXBUF_DATA_610_MASK)
#define TXPCU_TXBUF_DATA_610_RESET                                             0x0
#define TXPCU_TXBUF_610_ADDRESS                                                (0x1988 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_610_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_610_RESET                                                  0x0

// 0x198c (TXPCU_TXBUF_611)
#define TXPCU_TXBUF_DATA_611_LSB                                               0
#define TXPCU_TXBUF_DATA_611_MSB                                               31
#define TXPCU_TXBUF_DATA_611_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_611_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_611_MASK) >> TXPCU_TXBUF_DATA_611_LSB)
#define TXPCU_TXBUF_DATA_611_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_611_LSB) & TXPCU_TXBUF_DATA_611_MASK)
#define TXPCU_TXBUF_DATA_611_RESET                                             0x0
#define TXPCU_TXBUF_611_ADDRESS                                                (0x198c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_611_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_611_RESET                                                  0x0

// 0x1990 (TXPCU_TXBUF_612)
#define TXPCU_TXBUF_DATA_612_LSB                                               0
#define TXPCU_TXBUF_DATA_612_MSB                                               31
#define TXPCU_TXBUF_DATA_612_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_612_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_612_MASK) >> TXPCU_TXBUF_DATA_612_LSB)
#define TXPCU_TXBUF_DATA_612_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_612_LSB) & TXPCU_TXBUF_DATA_612_MASK)
#define TXPCU_TXBUF_DATA_612_RESET                                             0x0
#define TXPCU_TXBUF_612_ADDRESS                                                (0x1990 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_612_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_612_RESET                                                  0x0

// 0x1994 (TXPCU_TXBUF_613)
#define TXPCU_TXBUF_DATA_613_LSB                                               0
#define TXPCU_TXBUF_DATA_613_MSB                                               31
#define TXPCU_TXBUF_DATA_613_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_613_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_613_MASK) >> TXPCU_TXBUF_DATA_613_LSB)
#define TXPCU_TXBUF_DATA_613_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_613_LSB) & TXPCU_TXBUF_DATA_613_MASK)
#define TXPCU_TXBUF_DATA_613_RESET                                             0x0
#define TXPCU_TXBUF_613_ADDRESS                                                (0x1994 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_613_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_613_RESET                                                  0x0

// 0x1998 (TXPCU_TXBUF_614)
#define TXPCU_TXBUF_DATA_614_LSB                                               0
#define TXPCU_TXBUF_DATA_614_MSB                                               31
#define TXPCU_TXBUF_DATA_614_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_614_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_614_MASK) >> TXPCU_TXBUF_DATA_614_LSB)
#define TXPCU_TXBUF_DATA_614_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_614_LSB) & TXPCU_TXBUF_DATA_614_MASK)
#define TXPCU_TXBUF_DATA_614_RESET                                             0x0
#define TXPCU_TXBUF_614_ADDRESS                                                (0x1998 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_614_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_614_RESET                                                  0x0

// 0x199c (TXPCU_TXBUF_615)
#define TXPCU_TXBUF_DATA_615_LSB                                               0
#define TXPCU_TXBUF_DATA_615_MSB                                               31
#define TXPCU_TXBUF_DATA_615_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_615_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_615_MASK) >> TXPCU_TXBUF_DATA_615_LSB)
#define TXPCU_TXBUF_DATA_615_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_615_LSB) & TXPCU_TXBUF_DATA_615_MASK)
#define TXPCU_TXBUF_DATA_615_RESET                                             0x0
#define TXPCU_TXBUF_615_ADDRESS                                                (0x199c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_615_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_615_RESET                                                  0x0

// 0x19a0 (TXPCU_TXBUF_616)
#define TXPCU_TXBUF_DATA_616_LSB                                               0
#define TXPCU_TXBUF_DATA_616_MSB                                               31
#define TXPCU_TXBUF_DATA_616_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_616_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_616_MASK) >> TXPCU_TXBUF_DATA_616_LSB)
#define TXPCU_TXBUF_DATA_616_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_616_LSB) & TXPCU_TXBUF_DATA_616_MASK)
#define TXPCU_TXBUF_DATA_616_RESET                                             0x0
#define TXPCU_TXBUF_616_ADDRESS                                                (0x19a0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_616_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_616_RESET                                                  0x0

// 0x19a4 (TXPCU_TXBUF_617)
#define TXPCU_TXBUF_DATA_617_LSB                                               0
#define TXPCU_TXBUF_DATA_617_MSB                                               31
#define TXPCU_TXBUF_DATA_617_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_617_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_617_MASK) >> TXPCU_TXBUF_DATA_617_LSB)
#define TXPCU_TXBUF_DATA_617_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_617_LSB) & TXPCU_TXBUF_DATA_617_MASK)
#define TXPCU_TXBUF_DATA_617_RESET                                             0x0
#define TXPCU_TXBUF_617_ADDRESS                                                (0x19a4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_617_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_617_RESET                                                  0x0

// 0x19a8 (TXPCU_TXBUF_618)
#define TXPCU_TXBUF_DATA_618_LSB                                               0
#define TXPCU_TXBUF_DATA_618_MSB                                               31
#define TXPCU_TXBUF_DATA_618_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_618_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_618_MASK) >> TXPCU_TXBUF_DATA_618_LSB)
#define TXPCU_TXBUF_DATA_618_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_618_LSB) & TXPCU_TXBUF_DATA_618_MASK)
#define TXPCU_TXBUF_DATA_618_RESET                                             0x0
#define TXPCU_TXBUF_618_ADDRESS                                                (0x19a8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_618_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_618_RESET                                                  0x0

// 0x19ac (TXPCU_TXBUF_619)
#define TXPCU_TXBUF_DATA_619_LSB                                               0
#define TXPCU_TXBUF_DATA_619_MSB                                               31
#define TXPCU_TXBUF_DATA_619_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_619_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_619_MASK) >> TXPCU_TXBUF_DATA_619_LSB)
#define TXPCU_TXBUF_DATA_619_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_619_LSB) & TXPCU_TXBUF_DATA_619_MASK)
#define TXPCU_TXBUF_DATA_619_RESET                                             0x0
#define TXPCU_TXBUF_619_ADDRESS                                                (0x19ac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_619_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_619_RESET                                                  0x0

// 0x19b0 (TXPCU_TXBUF_620)
#define TXPCU_TXBUF_DATA_620_LSB                                               0
#define TXPCU_TXBUF_DATA_620_MSB                                               31
#define TXPCU_TXBUF_DATA_620_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_620_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_620_MASK) >> TXPCU_TXBUF_DATA_620_LSB)
#define TXPCU_TXBUF_DATA_620_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_620_LSB) & TXPCU_TXBUF_DATA_620_MASK)
#define TXPCU_TXBUF_DATA_620_RESET                                             0x0
#define TXPCU_TXBUF_620_ADDRESS                                                (0x19b0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_620_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_620_RESET                                                  0x0

// 0x19b4 (TXPCU_TXBUF_621)
#define TXPCU_TXBUF_DATA_621_LSB                                               0
#define TXPCU_TXBUF_DATA_621_MSB                                               31
#define TXPCU_TXBUF_DATA_621_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_621_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_621_MASK) >> TXPCU_TXBUF_DATA_621_LSB)
#define TXPCU_TXBUF_DATA_621_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_621_LSB) & TXPCU_TXBUF_DATA_621_MASK)
#define TXPCU_TXBUF_DATA_621_RESET                                             0x0
#define TXPCU_TXBUF_621_ADDRESS                                                (0x19b4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_621_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_621_RESET                                                  0x0

// 0x19b8 (TXPCU_TXBUF_622)
#define TXPCU_TXBUF_DATA_622_LSB                                               0
#define TXPCU_TXBUF_DATA_622_MSB                                               31
#define TXPCU_TXBUF_DATA_622_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_622_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_622_MASK) >> TXPCU_TXBUF_DATA_622_LSB)
#define TXPCU_TXBUF_DATA_622_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_622_LSB) & TXPCU_TXBUF_DATA_622_MASK)
#define TXPCU_TXBUF_DATA_622_RESET                                             0x0
#define TXPCU_TXBUF_622_ADDRESS                                                (0x19b8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_622_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_622_RESET                                                  0x0

// 0x19bc (TXPCU_TXBUF_623)
#define TXPCU_TXBUF_DATA_623_LSB                                               0
#define TXPCU_TXBUF_DATA_623_MSB                                               31
#define TXPCU_TXBUF_DATA_623_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_623_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_623_MASK) >> TXPCU_TXBUF_DATA_623_LSB)
#define TXPCU_TXBUF_DATA_623_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_623_LSB) & TXPCU_TXBUF_DATA_623_MASK)
#define TXPCU_TXBUF_DATA_623_RESET                                             0x0
#define TXPCU_TXBUF_623_ADDRESS                                                (0x19bc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_623_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_623_RESET                                                  0x0

// 0x19c0 (TXPCU_TXBUF_624)
#define TXPCU_TXBUF_DATA_624_LSB                                               0
#define TXPCU_TXBUF_DATA_624_MSB                                               31
#define TXPCU_TXBUF_DATA_624_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_624_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_624_MASK) >> TXPCU_TXBUF_DATA_624_LSB)
#define TXPCU_TXBUF_DATA_624_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_624_LSB) & TXPCU_TXBUF_DATA_624_MASK)
#define TXPCU_TXBUF_DATA_624_RESET                                             0x0
#define TXPCU_TXBUF_624_ADDRESS                                                (0x19c0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_624_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_624_RESET                                                  0x0

// 0x19c4 (TXPCU_TXBUF_625)
#define TXPCU_TXBUF_DATA_625_LSB                                               0
#define TXPCU_TXBUF_DATA_625_MSB                                               31
#define TXPCU_TXBUF_DATA_625_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_625_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_625_MASK) >> TXPCU_TXBUF_DATA_625_LSB)
#define TXPCU_TXBUF_DATA_625_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_625_LSB) & TXPCU_TXBUF_DATA_625_MASK)
#define TXPCU_TXBUF_DATA_625_RESET                                             0x0
#define TXPCU_TXBUF_625_ADDRESS                                                (0x19c4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_625_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_625_RESET                                                  0x0

// 0x19c8 (TXPCU_TXBUF_626)
#define TXPCU_TXBUF_DATA_626_LSB                                               0
#define TXPCU_TXBUF_DATA_626_MSB                                               31
#define TXPCU_TXBUF_DATA_626_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_626_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_626_MASK) >> TXPCU_TXBUF_DATA_626_LSB)
#define TXPCU_TXBUF_DATA_626_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_626_LSB) & TXPCU_TXBUF_DATA_626_MASK)
#define TXPCU_TXBUF_DATA_626_RESET                                             0x0
#define TXPCU_TXBUF_626_ADDRESS                                                (0x19c8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_626_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_626_RESET                                                  0x0

// 0x19cc (TXPCU_TXBUF_627)
#define TXPCU_TXBUF_DATA_627_LSB                                               0
#define TXPCU_TXBUF_DATA_627_MSB                                               31
#define TXPCU_TXBUF_DATA_627_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_627_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_627_MASK) >> TXPCU_TXBUF_DATA_627_LSB)
#define TXPCU_TXBUF_DATA_627_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_627_LSB) & TXPCU_TXBUF_DATA_627_MASK)
#define TXPCU_TXBUF_DATA_627_RESET                                             0x0
#define TXPCU_TXBUF_627_ADDRESS                                                (0x19cc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_627_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_627_RESET                                                  0x0

// 0x19d0 (TXPCU_TXBUF_628)
#define TXPCU_TXBUF_DATA_628_LSB                                               0
#define TXPCU_TXBUF_DATA_628_MSB                                               31
#define TXPCU_TXBUF_DATA_628_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_628_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_628_MASK) >> TXPCU_TXBUF_DATA_628_LSB)
#define TXPCU_TXBUF_DATA_628_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_628_LSB) & TXPCU_TXBUF_DATA_628_MASK)
#define TXPCU_TXBUF_DATA_628_RESET                                             0x0
#define TXPCU_TXBUF_628_ADDRESS                                                (0x19d0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_628_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_628_RESET                                                  0x0

// 0x19d4 (TXPCU_TXBUF_629)
#define TXPCU_TXBUF_DATA_629_LSB                                               0
#define TXPCU_TXBUF_DATA_629_MSB                                               31
#define TXPCU_TXBUF_DATA_629_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_629_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_629_MASK) >> TXPCU_TXBUF_DATA_629_LSB)
#define TXPCU_TXBUF_DATA_629_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_629_LSB) & TXPCU_TXBUF_DATA_629_MASK)
#define TXPCU_TXBUF_DATA_629_RESET                                             0x0
#define TXPCU_TXBUF_629_ADDRESS                                                (0x19d4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_629_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_629_RESET                                                  0x0

// 0x19d8 (TXPCU_TXBUF_630)
#define TXPCU_TXBUF_DATA_630_LSB                                               0
#define TXPCU_TXBUF_DATA_630_MSB                                               31
#define TXPCU_TXBUF_DATA_630_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_630_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_630_MASK) >> TXPCU_TXBUF_DATA_630_LSB)
#define TXPCU_TXBUF_DATA_630_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_630_LSB) & TXPCU_TXBUF_DATA_630_MASK)
#define TXPCU_TXBUF_DATA_630_RESET                                             0x0
#define TXPCU_TXBUF_630_ADDRESS                                                (0x19d8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_630_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_630_RESET                                                  0x0

// 0x19dc (TXPCU_TXBUF_631)
#define TXPCU_TXBUF_DATA_631_LSB                                               0
#define TXPCU_TXBUF_DATA_631_MSB                                               31
#define TXPCU_TXBUF_DATA_631_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_631_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_631_MASK) >> TXPCU_TXBUF_DATA_631_LSB)
#define TXPCU_TXBUF_DATA_631_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_631_LSB) & TXPCU_TXBUF_DATA_631_MASK)
#define TXPCU_TXBUF_DATA_631_RESET                                             0x0
#define TXPCU_TXBUF_631_ADDRESS                                                (0x19dc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_631_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_631_RESET                                                  0x0

// 0x19e0 (TXPCU_TXBUF_632)
#define TXPCU_TXBUF_DATA_632_LSB                                               0
#define TXPCU_TXBUF_DATA_632_MSB                                               31
#define TXPCU_TXBUF_DATA_632_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_632_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_632_MASK) >> TXPCU_TXBUF_DATA_632_LSB)
#define TXPCU_TXBUF_DATA_632_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_632_LSB) & TXPCU_TXBUF_DATA_632_MASK)
#define TXPCU_TXBUF_DATA_632_RESET                                             0x0
#define TXPCU_TXBUF_632_ADDRESS                                                (0x19e0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_632_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_632_RESET                                                  0x0

// 0x19e4 (TXPCU_TXBUF_633)
#define TXPCU_TXBUF_DATA_633_LSB                                               0
#define TXPCU_TXBUF_DATA_633_MSB                                               31
#define TXPCU_TXBUF_DATA_633_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_633_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_633_MASK) >> TXPCU_TXBUF_DATA_633_LSB)
#define TXPCU_TXBUF_DATA_633_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_633_LSB) & TXPCU_TXBUF_DATA_633_MASK)
#define TXPCU_TXBUF_DATA_633_RESET                                             0x0
#define TXPCU_TXBUF_633_ADDRESS                                                (0x19e4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_633_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_633_RESET                                                  0x0

// 0x19e8 (TXPCU_TXBUF_634)
#define TXPCU_TXBUF_DATA_634_LSB                                               0
#define TXPCU_TXBUF_DATA_634_MSB                                               31
#define TXPCU_TXBUF_DATA_634_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_634_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_634_MASK) >> TXPCU_TXBUF_DATA_634_LSB)
#define TXPCU_TXBUF_DATA_634_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_634_LSB) & TXPCU_TXBUF_DATA_634_MASK)
#define TXPCU_TXBUF_DATA_634_RESET                                             0x0
#define TXPCU_TXBUF_634_ADDRESS                                                (0x19e8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_634_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_634_RESET                                                  0x0

// 0x19ec (TXPCU_TXBUF_635)
#define TXPCU_TXBUF_DATA_635_LSB                                               0
#define TXPCU_TXBUF_DATA_635_MSB                                               31
#define TXPCU_TXBUF_DATA_635_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_635_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_635_MASK) >> TXPCU_TXBUF_DATA_635_LSB)
#define TXPCU_TXBUF_DATA_635_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_635_LSB) & TXPCU_TXBUF_DATA_635_MASK)
#define TXPCU_TXBUF_DATA_635_RESET                                             0x0
#define TXPCU_TXBUF_635_ADDRESS                                                (0x19ec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_635_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_635_RESET                                                  0x0

// 0x19f0 (TXPCU_TXBUF_636)
#define TXPCU_TXBUF_DATA_636_LSB                                               0
#define TXPCU_TXBUF_DATA_636_MSB                                               31
#define TXPCU_TXBUF_DATA_636_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_636_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_636_MASK) >> TXPCU_TXBUF_DATA_636_LSB)
#define TXPCU_TXBUF_DATA_636_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_636_LSB) & TXPCU_TXBUF_DATA_636_MASK)
#define TXPCU_TXBUF_DATA_636_RESET                                             0x0
#define TXPCU_TXBUF_636_ADDRESS                                                (0x19f0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_636_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_636_RESET                                                  0x0

// 0x19f4 (TXPCU_TXBUF_637)
#define TXPCU_TXBUF_DATA_637_LSB                                               0
#define TXPCU_TXBUF_DATA_637_MSB                                               31
#define TXPCU_TXBUF_DATA_637_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_637_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_637_MASK) >> TXPCU_TXBUF_DATA_637_LSB)
#define TXPCU_TXBUF_DATA_637_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_637_LSB) & TXPCU_TXBUF_DATA_637_MASK)
#define TXPCU_TXBUF_DATA_637_RESET                                             0x0
#define TXPCU_TXBUF_637_ADDRESS                                                (0x19f4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_637_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_637_RESET                                                  0x0

// 0x19f8 (TXPCU_TXBUF_638)
#define TXPCU_TXBUF_DATA_638_LSB                                               0
#define TXPCU_TXBUF_DATA_638_MSB                                               31
#define TXPCU_TXBUF_DATA_638_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_638_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_638_MASK) >> TXPCU_TXBUF_DATA_638_LSB)
#define TXPCU_TXBUF_DATA_638_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_638_LSB) & TXPCU_TXBUF_DATA_638_MASK)
#define TXPCU_TXBUF_DATA_638_RESET                                             0x0
#define TXPCU_TXBUF_638_ADDRESS                                                (0x19f8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_638_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_638_RESET                                                  0x0

// 0x19fc (TXPCU_TXBUF_639)
#define TXPCU_TXBUF_DATA_639_LSB                                               0
#define TXPCU_TXBUF_DATA_639_MSB                                               31
#define TXPCU_TXBUF_DATA_639_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_639_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_639_MASK) >> TXPCU_TXBUF_DATA_639_LSB)
#define TXPCU_TXBUF_DATA_639_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_639_LSB) & TXPCU_TXBUF_DATA_639_MASK)
#define TXPCU_TXBUF_DATA_639_RESET                                             0x0
#define TXPCU_TXBUF_639_ADDRESS                                                (0x19fc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_639_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_639_RESET                                                  0x0

// 0x1a00 (TXPCU_TXBUF_640)
#define TXPCU_TXBUF_DATA_640_LSB                                               0
#define TXPCU_TXBUF_DATA_640_MSB                                               31
#define TXPCU_TXBUF_DATA_640_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_640_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_640_MASK) >> TXPCU_TXBUF_DATA_640_LSB)
#define TXPCU_TXBUF_DATA_640_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_640_LSB) & TXPCU_TXBUF_DATA_640_MASK)
#define TXPCU_TXBUF_DATA_640_RESET                                             0x0
#define TXPCU_TXBUF_640_ADDRESS                                                (0x1a00 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_640_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_640_RESET                                                  0x0

// 0x1a04 (TXPCU_TXBUF_641)
#define TXPCU_TXBUF_DATA_641_LSB                                               0
#define TXPCU_TXBUF_DATA_641_MSB                                               31
#define TXPCU_TXBUF_DATA_641_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_641_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_641_MASK) >> TXPCU_TXBUF_DATA_641_LSB)
#define TXPCU_TXBUF_DATA_641_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_641_LSB) & TXPCU_TXBUF_DATA_641_MASK)
#define TXPCU_TXBUF_DATA_641_RESET                                             0x0
#define TXPCU_TXBUF_641_ADDRESS                                                (0x1a04 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_641_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_641_RESET                                                  0x0

// 0x1a08 (TXPCU_TXBUF_642)
#define TXPCU_TXBUF_DATA_642_LSB                                               0
#define TXPCU_TXBUF_DATA_642_MSB                                               31
#define TXPCU_TXBUF_DATA_642_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_642_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_642_MASK) >> TXPCU_TXBUF_DATA_642_LSB)
#define TXPCU_TXBUF_DATA_642_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_642_LSB) & TXPCU_TXBUF_DATA_642_MASK)
#define TXPCU_TXBUF_DATA_642_RESET                                             0x0
#define TXPCU_TXBUF_642_ADDRESS                                                (0x1a08 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_642_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_642_RESET                                                  0x0

// 0x1a0c (TXPCU_TXBUF_643)
#define TXPCU_TXBUF_DATA_643_LSB                                               0
#define TXPCU_TXBUF_DATA_643_MSB                                               31
#define TXPCU_TXBUF_DATA_643_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_643_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_643_MASK) >> TXPCU_TXBUF_DATA_643_LSB)
#define TXPCU_TXBUF_DATA_643_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_643_LSB) & TXPCU_TXBUF_DATA_643_MASK)
#define TXPCU_TXBUF_DATA_643_RESET                                             0x0
#define TXPCU_TXBUF_643_ADDRESS                                                (0x1a0c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_643_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_643_RESET                                                  0x0

// 0x1a10 (TXPCU_TXBUF_644)
#define TXPCU_TXBUF_DATA_644_LSB                                               0
#define TXPCU_TXBUF_DATA_644_MSB                                               31
#define TXPCU_TXBUF_DATA_644_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_644_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_644_MASK) >> TXPCU_TXBUF_DATA_644_LSB)
#define TXPCU_TXBUF_DATA_644_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_644_LSB) & TXPCU_TXBUF_DATA_644_MASK)
#define TXPCU_TXBUF_DATA_644_RESET                                             0x0
#define TXPCU_TXBUF_644_ADDRESS                                                (0x1a10 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_644_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_644_RESET                                                  0x0

// 0x1a14 (TXPCU_TXBUF_645)
#define TXPCU_TXBUF_DATA_645_LSB                                               0
#define TXPCU_TXBUF_DATA_645_MSB                                               31
#define TXPCU_TXBUF_DATA_645_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_645_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_645_MASK) >> TXPCU_TXBUF_DATA_645_LSB)
#define TXPCU_TXBUF_DATA_645_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_645_LSB) & TXPCU_TXBUF_DATA_645_MASK)
#define TXPCU_TXBUF_DATA_645_RESET                                             0x0
#define TXPCU_TXBUF_645_ADDRESS                                                (0x1a14 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_645_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_645_RESET                                                  0x0

// 0x1a18 (TXPCU_TXBUF_646)
#define TXPCU_TXBUF_DATA_646_LSB                                               0
#define TXPCU_TXBUF_DATA_646_MSB                                               31
#define TXPCU_TXBUF_DATA_646_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_646_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_646_MASK) >> TXPCU_TXBUF_DATA_646_LSB)
#define TXPCU_TXBUF_DATA_646_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_646_LSB) & TXPCU_TXBUF_DATA_646_MASK)
#define TXPCU_TXBUF_DATA_646_RESET                                             0x0
#define TXPCU_TXBUF_646_ADDRESS                                                (0x1a18 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_646_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_646_RESET                                                  0x0

// 0x1a1c (TXPCU_TXBUF_647)
#define TXPCU_TXBUF_DATA_647_LSB                                               0
#define TXPCU_TXBUF_DATA_647_MSB                                               31
#define TXPCU_TXBUF_DATA_647_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_647_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_647_MASK) >> TXPCU_TXBUF_DATA_647_LSB)
#define TXPCU_TXBUF_DATA_647_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_647_LSB) & TXPCU_TXBUF_DATA_647_MASK)
#define TXPCU_TXBUF_DATA_647_RESET                                             0x0
#define TXPCU_TXBUF_647_ADDRESS                                                (0x1a1c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_647_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_647_RESET                                                  0x0

// 0x1a20 (TXPCU_TXBUF_648)
#define TXPCU_TXBUF_DATA_648_LSB                                               0
#define TXPCU_TXBUF_DATA_648_MSB                                               31
#define TXPCU_TXBUF_DATA_648_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_648_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_648_MASK) >> TXPCU_TXBUF_DATA_648_LSB)
#define TXPCU_TXBUF_DATA_648_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_648_LSB) & TXPCU_TXBUF_DATA_648_MASK)
#define TXPCU_TXBUF_DATA_648_RESET                                             0x0
#define TXPCU_TXBUF_648_ADDRESS                                                (0x1a20 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_648_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_648_RESET                                                  0x0

// 0x1a24 (TXPCU_TXBUF_649)
#define TXPCU_TXBUF_DATA_649_LSB                                               0
#define TXPCU_TXBUF_DATA_649_MSB                                               31
#define TXPCU_TXBUF_DATA_649_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_649_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_649_MASK) >> TXPCU_TXBUF_DATA_649_LSB)
#define TXPCU_TXBUF_DATA_649_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_649_LSB) & TXPCU_TXBUF_DATA_649_MASK)
#define TXPCU_TXBUF_DATA_649_RESET                                             0x0
#define TXPCU_TXBUF_649_ADDRESS                                                (0x1a24 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_649_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_649_RESET                                                  0x0

// 0x1a28 (TXPCU_TXBUF_650)
#define TXPCU_TXBUF_DATA_650_LSB                                               0
#define TXPCU_TXBUF_DATA_650_MSB                                               31
#define TXPCU_TXBUF_DATA_650_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_650_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_650_MASK) >> TXPCU_TXBUF_DATA_650_LSB)
#define TXPCU_TXBUF_DATA_650_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_650_LSB) & TXPCU_TXBUF_DATA_650_MASK)
#define TXPCU_TXBUF_DATA_650_RESET                                             0x0
#define TXPCU_TXBUF_650_ADDRESS                                                (0x1a28 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_650_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_650_RESET                                                  0x0

// 0x1a2c (TXPCU_TXBUF_651)
#define TXPCU_TXBUF_DATA_651_LSB                                               0
#define TXPCU_TXBUF_DATA_651_MSB                                               31
#define TXPCU_TXBUF_DATA_651_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_651_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_651_MASK) >> TXPCU_TXBUF_DATA_651_LSB)
#define TXPCU_TXBUF_DATA_651_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_651_LSB) & TXPCU_TXBUF_DATA_651_MASK)
#define TXPCU_TXBUF_DATA_651_RESET                                             0x0
#define TXPCU_TXBUF_651_ADDRESS                                                (0x1a2c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_651_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_651_RESET                                                  0x0

// 0x1a30 (TXPCU_TXBUF_652)
#define TXPCU_TXBUF_DATA_652_LSB                                               0
#define TXPCU_TXBUF_DATA_652_MSB                                               31
#define TXPCU_TXBUF_DATA_652_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_652_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_652_MASK) >> TXPCU_TXBUF_DATA_652_LSB)
#define TXPCU_TXBUF_DATA_652_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_652_LSB) & TXPCU_TXBUF_DATA_652_MASK)
#define TXPCU_TXBUF_DATA_652_RESET                                             0x0
#define TXPCU_TXBUF_652_ADDRESS                                                (0x1a30 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_652_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_652_RESET                                                  0x0

// 0x1a34 (TXPCU_TXBUF_653)
#define TXPCU_TXBUF_DATA_653_LSB                                               0
#define TXPCU_TXBUF_DATA_653_MSB                                               31
#define TXPCU_TXBUF_DATA_653_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_653_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_653_MASK) >> TXPCU_TXBUF_DATA_653_LSB)
#define TXPCU_TXBUF_DATA_653_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_653_LSB) & TXPCU_TXBUF_DATA_653_MASK)
#define TXPCU_TXBUF_DATA_653_RESET                                             0x0
#define TXPCU_TXBUF_653_ADDRESS                                                (0x1a34 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_653_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_653_RESET                                                  0x0

// 0x1a38 (TXPCU_TXBUF_654)
#define TXPCU_TXBUF_DATA_654_LSB                                               0
#define TXPCU_TXBUF_DATA_654_MSB                                               31
#define TXPCU_TXBUF_DATA_654_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_654_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_654_MASK) >> TXPCU_TXBUF_DATA_654_LSB)
#define TXPCU_TXBUF_DATA_654_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_654_LSB) & TXPCU_TXBUF_DATA_654_MASK)
#define TXPCU_TXBUF_DATA_654_RESET                                             0x0
#define TXPCU_TXBUF_654_ADDRESS                                                (0x1a38 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_654_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_654_RESET                                                  0x0

// 0x1a3c (TXPCU_TXBUF_655)
#define TXPCU_TXBUF_DATA_655_LSB                                               0
#define TXPCU_TXBUF_DATA_655_MSB                                               31
#define TXPCU_TXBUF_DATA_655_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_655_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_655_MASK) >> TXPCU_TXBUF_DATA_655_LSB)
#define TXPCU_TXBUF_DATA_655_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_655_LSB) & TXPCU_TXBUF_DATA_655_MASK)
#define TXPCU_TXBUF_DATA_655_RESET                                             0x0
#define TXPCU_TXBUF_655_ADDRESS                                                (0x1a3c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_655_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_655_RESET                                                  0x0

// 0x1a40 (TXPCU_TXBUF_656)
#define TXPCU_TXBUF_DATA_656_LSB                                               0
#define TXPCU_TXBUF_DATA_656_MSB                                               31
#define TXPCU_TXBUF_DATA_656_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_656_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_656_MASK) >> TXPCU_TXBUF_DATA_656_LSB)
#define TXPCU_TXBUF_DATA_656_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_656_LSB) & TXPCU_TXBUF_DATA_656_MASK)
#define TXPCU_TXBUF_DATA_656_RESET                                             0x0
#define TXPCU_TXBUF_656_ADDRESS                                                (0x1a40 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_656_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_656_RESET                                                  0x0

// 0x1a44 (TXPCU_TXBUF_657)
#define TXPCU_TXBUF_DATA_657_LSB                                               0
#define TXPCU_TXBUF_DATA_657_MSB                                               31
#define TXPCU_TXBUF_DATA_657_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_657_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_657_MASK) >> TXPCU_TXBUF_DATA_657_LSB)
#define TXPCU_TXBUF_DATA_657_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_657_LSB) & TXPCU_TXBUF_DATA_657_MASK)
#define TXPCU_TXBUF_DATA_657_RESET                                             0x0
#define TXPCU_TXBUF_657_ADDRESS                                                (0x1a44 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_657_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_657_RESET                                                  0x0

// 0x1a48 (TXPCU_TXBUF_658)
#define TXPCU_TXBUF_DATA_658_LSB                                               0
#define TXPCU_TXBUF_DATA_658_MSB                                               31
#define TXPCU_TXBUF_DATA_658_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_658_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_658_MASK) >> TXPCU_TXBUF_DATA_658_LSB)
#define TXPCU_TXBUF_DATA_658_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_658_LSB) & TXPCU_TXBUF_DATA_658_MASK)
#define TXPCU_TXBUF_DATA_658_RESET                                             0x0
#define TXPCU_TXBUF_658_ADDRESS                                                (0x1a48 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_658_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_658_RESET                                                  0x0

// 0x1a4c (TXPCU_TXBUF_659)
#define TXPCU_TXBUF_DATA_659_LSB                                               0
#define TXPCU_TXBUF_DATA_659_MSB                                               31
#define TXPCU_TXBUF_DATA_659_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_659_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_659_MASK) >> TXPCU_TXBUF_DATA_659_LSB)
#define TXPCU_TXBUF_DATA_659_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_659_LSB) & TXPCU_TXBUF_DATA_659_MASK)
#define TXPCU_TXBUF_DATA_659_RESET                                             0x0
#define TXPCU_TXBUF_659_ADDRESS                                                (0x1a4c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_659_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_659_RESET                                                  0x0

// 0x1a50 (TXPCU_TXBUF_660)
#define TXPCU_TXBUF_DATA_660_LSB                                               0
#define TXPCU_TXBUF_DATA_660_MSB                                               31
#define TXPCU_TXBUF_DATA_660_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_660_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_660_MASK) >> TXPCU_TXBUF_DATA_660_LSB)
#define TXPCU_TXBUF_DATA_660_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_660_LSB) & TXPCU_TXBUF_DATA_660_MASK)
#define TXPCU_TXBUF_DATA_660_RESET                                             0x0
#define TXPCU_TXBUF_660_ADDRESS                                                (0x1a50 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_660_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_660_RESET                                                  0x0

// 0x1a54 (TXPCU_TXBUF_661)
#define TXPCU_TXBUF_DATA_661_LSB                                               0
#define TXPCU_TXBUF_DATA_661_MSB                                               31
#define TXPCU_TXBUF_DATA_661_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_661_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_661_MASK) >> TXPCU_TXBUF_DATA_661_LSB)
#define TXPCU_TXBUF_DATA_661_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_661_LSB) & TXPCU_TXBUF_DATA_661_MASK)
#define TXPCU_TXBUF_DATA_661_RESET                                             0x0
#define TXPCU_TXBUF_661_ADDRESS                                                (0x1a54 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_661_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_661_RESET                                                  0x0

// 0x1a58 (TXPCU_TXBUF_662)
#define TXPCU_TXBUF_DATA_662_LSB                                               0
#define TXPCU_TXBUF_DATA_662_MSB                                               31
#define TXPCU_TXBUF_DATA_662_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_662_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_662_MASK) >> TXPCU_TXBUF_DATA_662_LSB)
#define TXPCU_TXBUF_DATA_662_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_662_LSB) & TXPCU_TXBUF_DATA_662_MASK)
#define TXPCU_TXBUF_DATA_662_RESET                                             0x0
#define TXPCU_TXBUF_662_ADDRESS                                                (0x1a58 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_662_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_662_RESET                                                  0x0

// 0x1a5c (TXPCU_TXBUF_663)
#define TXPCU_TXBUF_DATA_663_LSB                                               0
#define TXPCU_TXBUF_DATA_663_MSB                                               31
#define TXPCU_TXBUF_DATA_663_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_663_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_663_MASK) >> TXPCU_TXBUF_DATA_663_LSB)
#define TXPCU_TXBUF_DATA_663_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_663_LSB) & TXPCU_TXBUF_DATA_663_MASK)
#define TXPCU_TXBUF_DATA_663_RESET                                             0x0
#define TXPCU_TXBUF_663_ADDRESS                                                (0x1a5c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_663_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_663_RESET                                                  0x0

// 0x1a60 (TXPCU_TXBUF_664)
#define TXPCU_TXBUF_DATA_664_LSB                                               0
#define TXPCU_TXBUF_DATA_664_MSB                                               31
#define TXPCU_TXBUF_DATA_664_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_664_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_664_MASK) >> TXPCU_TXBUF_DATA_664_LSB)
#define TXPCU_TXBUF_DATA_664_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_664_LSB) & TXPCU_TXBUF_DATA_664_MASK)
#define TXPCU_TXBUF_DATA_664_RESET                                             0x0
#define TXPCU_TXBUF_664_ADDRESS                                                (0x1a60 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_664_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_664_RESET                                                  0x0

// 0x1a64 (TXPCU_TXBUF_665)
#define TXPCU_TXBUF_DATA_665_LSB                                               0
#define TXPCU_TXBUF_DATA_665_MSB                                               31
#define TXPCU_TXBUF_DATA_665_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_665_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_665_MASK) >> TXPCU_TXBUF_DATA_665_LSB)
#define TXPCU_TXBUF_DATA_665_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_665_LSB) & TXPCU_TXBUF_DATA_665_MASK)
#define TXPCU_TXBUF_DATA_665_RESET                                             0x0
#define TXPCU_TXBUF_665_ADDRESS                                                (0x1a64 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_665_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_665_RESET                                                  0x0

// 0x1a68 (TXPCU_TXBUF_666)
#define TXPCU_TXBUF_DATA_666_LSB                                               0
#define TXPCU_TXBUF_DATA_666_MSB                                               31
#define TXPCU_TXBUF_DATA_666_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_666_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_666_MASK) >> TXPCU_TXBUF_DATA_666_LSB)
#define TXPCU_TXBUF_DATA_666_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_666_LSB) & TXPCU_TXBUF_DATA_666_MASK)
#define TXPCU_TXBUF_DATA_666_RESET                                             0x0
#define TXPCU_TXBUF_666_ADDRESS                                                (0x1a68 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_666_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_666_RESET                                                  0x0

// 0x1a6c (TXPCU_TXBUF_667)
#define TXPCU_TXBUF_DATA_667_LSB                                               0
#define TXPCU_TXBUF_DATA_667_MSB                                               31
#define TXPCU_TXBUF_DATA_667_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_667_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_667_MASK) >> TXPCU_TXBUF_DATA_667_LSB)
#define TXPCU_TXBUF_DATA_667_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_667_LSB) & TXPCU_TXBUF_DATA_667_MASK)
#define TXPCU_TXBUF_DATA_667_RESET                                             0x0
#define TXPCU_TXBUF_667_ADDRESS                                                (0x1a6c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_667_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_667_RESET                                                  0x0

// 0x1a70 (TXPCU_TXBUF_668)
#define TXPCU_TXBUF_DATA_668_LSB                                               0
#define TXPCU_TXBUF_DATA_668_MSB                                               31
#define TXPCU_TXBUF_DATA_668_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_668_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_668_MASK) >> TXPCU_TXBUF_DATA_668_LSB)
#define TXPCU_TXBUF_DATA_668_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_668_LSB) & TXPCU_TXBUF_DATA_668_MASK)
#define TXPCU_TXBUF_DATA_668_RESET                                             0x0
#define TXPCU_TXBUF_668_ADDRESS                                                (0x1a70 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_668_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_668_RESET                                                  0x0

// 0x1a74 (TXPCU_TXBUF_669)
#define TXPCU_TXBUF_DATA_669_LSB                                               0
#define TXPCU_TXBUF_DATA_669_MSB                                               31
#define TXPCU_TXBUF_DATA_669_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_669_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_669_MASK) >> TXPCU_TXBUF_DATA_669_LSB)
#define TXPCU_TXBUF_DATA_669_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_669_LSB) & TXPCU_TXBUF_DATA_669_MASK)
#define TXPCU_TXBUF_DATA_669_RESET                                             0x0
#define TXPCU_TXBUF_669_ADDRESS                                                (0x1a74 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_669_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_669_RESET                                                  0x0

// 0x1a78 (TXPCU_TXBUF_670)
#define TXPCU_TXBUF_DATA_670_LSB                                               0
#define TXPCU_TXBUF_DATA_670_MSB                                               31
#define TXPCU_TXBUF_DATA_670_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_670_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_670_MASK) >> TXPCU_TXBUF_DATA_670_LSB)
#define TXPCU_TXBUF_DATA_670_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_670_LSB) & TXPCU_TXBUF_DATA_670_MASK)
#define TXPCU_TXBUF_DATA_670_RESET                                             0x0
#define TXPCU_TXBUF_670_ADDRESS                                                (0x1a78 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_670_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_670_RESET                                                  0x0

// 0x1a7c (TXPCU_TXBUF_671)
#define TXPCU_TXBUF_DATA_671_LSB                                               0
#define TXPCU_TXBUF_DATA_671_MSB                                               31
#define TXPCU_TXBUF_DATA_671_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_671_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_671_MASK) >> TXPCU_TXBUF_DATA_671_LSB)
#define TXPCU_TXBUF_DATA_671_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_671_LSB) & TXPCU_TXBUF_DATA_671_MASK)
#define TXPCU_TXBUF_DATA_671_RESET                                             0x0
#define TXPCU_TXBUF_671_ADDRESS                                                (0x1a7c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_671_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_671_RESET                                                  0x0

// 0x1a80 (TXPCU_TXBUF_672)
#define TXPCU_TXBUF_DATA_672_LSB                                               0
#define TXPCU_TXBUF_DATA_672_MSB                                               31
#define TXPCU_TXBUF_DATA_672_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_672_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_672_MASK) >> TXPCU_TXBUF_DATA_672_LSB)
#define TXPCU_TXBUF_DATA_672_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_672_LSB) & TXPCU_TXBUF_DATA_672_MASK)
#define TXPCU_TXBUF_DATA_672_RESET                                             0x0
#define TXPCU_TXBUF_672_ADDRESS                                                (0x1a80 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_672_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_672_RESET                                                  0x0

// 0x1a84 (TXPCU_TXBUF_673)
#define TXPCU_TXBUF_DATA_673_LSB                                               0
#define TXPCU_TXBUF_DATA_673_MSB                                               31
#define TXPCU_TXBUF_DATA_673_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_673_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_673_MASK) >> TXPCU_TXBUF_DATA_673_LSB)
#define TXPCU_TXBUF_DATA_673_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_673_LSB) & TXPCU_TXBUF_DATA_673_MASK)
#define TXPCU_TXBUF_DATA_673_RESET                                             0x0
#define TXPCU_TXBUF_673_ADDRESS                                                (0x1a84 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_673_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_673_RESET                                                  0x0

// 0x1a88 (TXPCU_TXBUF_674)
#define TXPCU_TXBUF_DATA_674_LSB                                               0
#define TXPCU_TXBUF_DATA_674_MSB                                               31
#define TXPCU_TXBUF_DATA_674_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_674_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_674_MASK) >> TXPCU_TXBUF_DATA_674_LSB)
#define TXPCU_TXBUF_DATA_674_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_674_LSB) & TXPCU_TXBUF_DATA_674_MASK)
#define TXPCU_TXBUF_DATA_674_RESET                                             0x0
#define TXPCU_TXBUF_674_ADDRESS                                                (0x1a88 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_674_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_674_RESET                                                  0x0

// 0x1a8c (TXPCU_TXBUF_675)
#define TXPCU_TXBUF_DATA_675_LSB                                               0
#define TXPCU_TXBUF_DATA_675_MSB                                               31
#define TXPCU_TXBUF_DATA_675_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_675_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_675_MASK) >> TXPCU_TXBUF_DATA_675_LSB)
#define TXPCU_TXBUF_DATA_675_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_675_LSB) & TXPCU_TXBUF_DATA_675_MASK)
#define TXPCU_TXBUF_DATA_675_RESET                                             0x0
#define TXPCU_TXBUF_675_ADDRESS                                                (0x1a8c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_675_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_675_RESET                                                  0x0

// 0x1a90 (TXPCU_TXBUF_676)
#define TXPCU_TXBUF_DATA_676_LSB                                               0
#define TXPCU_TXBUF_DATA_676_MSB                                               31
#define TXPCU_TXBUF_DATA_676_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_676_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_676_MASK) >> TXPCU_TXBUF_DATA_676_LSB)
#define TXPCU_TXBUF_DATA_676_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_676_LSB) & TXPCU_TXBUF_DATA_676_MASK)
#define TXPCU_TXBUF_DATA_676_RESET                                             0x0
#define TXPCU_TXBUF_676_ADDRESS                                                (0x1a90 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_676_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_676_RESET                                                  0x0

// 0x1a94 (TXPCU_TXBUF_677)
#define TXPCU_TXBUF_DATA_677_LSB                                               0
#define TXPCU_TXBUF_DATA_677_MSB                                               31
#define TXPCU_TXBUF_DATA_677_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_677_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_677_MASK) >> TXPCU_TXBUF_DATA_677_LSB)
#define TXPCU_TXBUF_DATA_677_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_677_LSB) & TXPCU_TXBUF_DATA_677_MASK)
#define TXPCU_TXBUF_DATA_677_RESET                                             0x0
#define TXPCU_TXBUF_677_ADDRESS                                                (0x1a94 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_677_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_677_RESET                                                  0x0

// 0x1a98 (TXPCU_TXBUF_678)
#define TXPCU_TXBUF_DATA_678_LSB                                               0
#define TXPCU_TXBUF_DATA_678_MSB                                               31
#define TXPCU_TXBUF_DATA_678_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_678_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_678_MASK) >> TXPCU_TXBUF_DATA_678_LSB)
#define TXPCU_TXBUF_DATA_678_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_678_LSB) & TXPCU_TXBUF_DATA_678_MASK)
#define TXPCU_TXBUF_DATA_678_RESET                                             0x0
#define TXPCU_TXBUF_678_ADDRESS                                                (0x1a98 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_678_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_678_RESET                                                  0x0

// 0x1a9c (TXPCU_TXBUF_679)
#define TXPCU_TXBUF_DATA_679_LSB                                               0
#define TXPCU_TXBUF_DATA_679_MSB                                               31
#define TXPCU_TXBUF_DATA_679_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_679_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_679_MASK) >> TXPCU_TXBUF_DATA_679_LSB)
#define TXPCU_TXBUF_DATA_679_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_679_LSB) & TXPCU_TXBUF_DATA_679_MASK)
#define TXPCU_TXBUF_DATA_679_RESET                                             0x0
#define TXPCU_TXBUF_679_ADDRESS                                                (0x1a9c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_679_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_679_RESET                                                  0x0

// 0x1aa0 (TXPCU_TXBUF_680)
#define TXPCU_TXBUF_DATA_680_LSB                                               0
#define TXPCU_TXBUF_DATA_680_MSB                                               31
#define TXPCU_TXBUF_DATA_680_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_680_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_680_MASK) >> TXPCU_TXBUF_DATA_680_LSB)
#define TXPCU_TXBUF_DATA_680_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_680_LSB) & TXPCU_TXBUF_DATA_680_MASK)
#define TXPCU_TXBUF_DATA_680_RESET                                             0x0
#define TXPCU_TXBUF_680_ADDRESS                                                (0x1aa0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_680_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_680_RESET                                                  0x0

// 0x1aa4 (TXPCU_TXBUF_681)
#define TXPCU_TXBUF_DATA_681_LSB                                               0
#define TXPCU_TXBUF_DATA_681_MSB                                               31
#define TXPCU_TXBUF_DATA_681_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_681_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_681_MASK) >> TXPCU_TXBUF_DATA_681_LSB)
#define TXPCU_TXBUF_DATA_681_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_681_LSB) & TXPCU_TXBUF_DATA_681_MASK)
#define TXPCU_TXBUF_DATA_681_RESET                                             0x0
#define TXPCU_TXBUF_681_ADDRESS                                                (0x1aa4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_681_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_681_RESET                                                  0x0

// 0x1aa8 (TXPCU_TXBUF_682)
#define TXPCU_TXBUF_DATA_682_LSB                                               0
#define TXPCU_TXBUF_DATA_682_MSB                                               31
#define TXPCU_TXBUF_DATA_682_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_682_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_682_MASK) >> TXPCU_TXBUF_DATA_682_LSB)
#define TXPCU_TXBUF_DATA_682_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_682_LSB) & TXPCU_TXBUF_DATA_682_MASK)
#define TXPCU_TXBUF_DATA_682_RESET                                             0x0
#define TXPCU_TXBUF_682_ADDRESS                                                (0x1aa8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_682_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_682_RESET                                                  0x0

// 0x1aac (TXPCU_TXBUF_683)
#define TXPCU_TXBUF_DATA_683_LSB                                               0
#define TXPCU_TXBUF_DATA_683_MSB                                               31
#define TXPCU_TXBUF_DATA_683_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_683_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_683_MASK) >> TXPCU_TXBUF_DATA_683_LSB)
#define TXPCU_TXBUF_DATA_683_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_683_LSB) & TXPCU_TXBUF_DATA_683_MASK)
#define TXPCU_TXBUF_DATA_683_RESET                                             0x0
#define TXPCU_TXBUF_683_ADDRESS                                                (0x1aac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_683_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_683_RESET                                                  0x0

// 0x1ab0 (TXPCU_TXBUF_684)
#define TXPCU_TXBUF_DATA_684_LSB                                               0
#define TXPCU_TXBUF_DATA_684_MSB                                               31
#define TXPCU_TXBUF_DATA_684_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_684_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_684_MASK) >> TXPCU_TXBUF_DATA_684_LSB)
#define TXPCU_TXBUF_DATA_684_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_684_LSB) & TXPCU_TXBUF_DATA_684_MASK)
#define TXPCU_TXBUF_DATA_684_RESET                                             0x0
#define TXPCU_TXBUF_684_ADDRESS                                                (0x1ab0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_684_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_684_RESET                                                  0x0

// 0x1ab4 (TXPCU_TXBUF_685)
#define TXPCU_TXBUF_DATA_685_LSB                                               0
#define TXPCU_TXBUF_DATA_685_MSB                                               31
#define TXPCU_TXBUF_DATA_685_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_685_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_685_MASK) >> TXPCU_TXBUF_DATA_685_LSB)
#define TXPCU_TXBUF_DATA_685_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_685_LSB) & TXPCU_TXBUF_DATA_685_MASK)
#define TXPCU_TXBUF_DATA_685_RESET                                             0x0
#define TXPCU_TXBUF_685_ADDRESS                                                (0x1ab4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_685_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_685_RESET                                                  0x0

// 0x1ab8 (TXPCU_TXBUF_686)
#define TXPCU_TXBUF_DATA_686_LSB                                               0
#define TXPCU_TXBUF_DATA_686_MSB                                               31
#define TXPCU_TXBUF_DATA_686_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_686_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_686_MASK) >> TXPCU_TXBUF_DATA_686_LSB)
#define TXPCU_TXBUF_DATA_686_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_686_LSB) & TXPCU_TXBUF_DATA_686_MASK)
#define TXPCU_TXBUF_DATA_686_RESET                                             0x0
#define TXPCU_TXBUF_686_ADDRESS                                                (0x1ab8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_686_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_686_RESET                                                  0x0

// 0x1abc (TXPCU_TXBUF_687)
#define TXPCU_TXBUF_DATA_687_LSB                                               0
#define TXPCU_TXBUF_DATA_687_MSB                                               31
#define TXPCU_TXBUF_DATA_687_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_687_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_687_MASK) >> TXPCU_TXBUF_DATA_687_LSB)
#define TXPCU_TXBUF_DATA_687_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_687_LSB) & TXPCU_TXBUF_DATA_687_MASK)
#define TXPCU_TXBUF_DATA_687_RESET                                             0x0
#define TXPCU_TXBUF_687_ADDRESS                                                (0x1abc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_687_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_687_RESET                                                  0x0

// 0x1ac0 (TXPCU_TXBUF_688)
#define TXPCU_TXBUF_DATA_688_LSB                                               0
#define TXPCU_TXBUF_DATA_688_MSB                                               31
#define TXPCU_TXBUF_DATA_688_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_688_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_688_MASK) >> TXPCU_TXBUF_DATA_688_LSB)
#define TXPCU_TXBUF_DATA_688_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_688_LSB) & TXPCU_TXBUF_DATA_688_MASK)
#define TXPCU_TXBUF_DATA_688_RESET                                             0x0
#define TXPCU_TXBUF_688_ADDRESS                                                (0x1ac0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_688_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_688_RESET                                                  0x0

// 0x1ac4 (TXPCU_TXBUF_689)
#define TXPCU_TXBUF_DATA_689_LSB                                               0
#define TXPCU_TXBUF_DATA_689_MSB                                               31
#define TXPCU_TXBUF_DATA_689_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_689_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_689_MASK) >> TXPCU_TXBUF_DATA_689_LSB)
#define TXPCU_TXBUF_DATA_689_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_689_LSB) & TXPCU_TXBUF_DATA_689_MASK)
#define TXPCU_TXBUF_DATA_689_RESET                                             0x0
#define TXPCU_TXBUF_689_ADDRESS                                                (0x1ac4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_689_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_689_RESET                                                  0x0

// 0x1ac8 (TXPCU_TXBUF_690)
#define TXPCU_TXBUF_DATA_690_LSB                                               0
#define TXPCU_TXBUF_DATA_690_MSB                                               31
#define TXPCU_TXBUF_DATA_690_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_690_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_690_MASK) >> TXPCU_TXBUF_DATA_690_LSB)
#define TXPCU_TXBUF_DATA_690_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_690_LSB) & TXPCU_TXBUF_DATA_690_MASK)
#define TXPCU_TXBUF_DATA_690_RESET                                             0x0
#define TXPCU_TXBUF_690_ADDRESS                                                (0x1ac8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_690_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_690_RESET                                                  0x0

// 0x1acc (TXPCU_TXBUF_691)
#define TXPCU_TXBUF_DATA_691_LSB                                               0
#define TXPCU_TXBUF_DATA_691_MSB                                               31
#define TXPCU_TXBUF_DATA_691_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_691_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_691_MASK) >> TXPCU_TXBUF_DATA_691_LSB)
#define TXPCU_TXBUF_DATA_691_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_691_LSB) & TXPCU_TXBUF_DATA_691_MASK)
#define TXPCU_TXBUF_DATA_691_RESET                                             0x0
#define TXPCU_TXBUF_691_ADDRESS                                                (0x1acc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_691_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_691_RESET                                                  0x0

// 0x1ad0 (TXPCU_TXBUF_692)
#define TXPCU_TXBUF_DATA_692_LSB                                               0
#define TXPCU_TXBUF_DATA_692_MSB                                               31
#define TXPCU_TXBUF_DATA_692_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_692_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_692_MASK) >> TXPCU_TXBUF_DATA_692_LSB)
#define TXPCU_TXBUF_DATA_692_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_692_LSB) & TXPCU_TXBUF_DATA_692_MASK)
#define TXPCU_TXBUF_DATA_692_RESET                                             0x0
#define TXPCU_TXBUF_692_ADDRESS                                                (0x1ad0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_692_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_692_RESET                                                  0x0

// 0x1ad4 (TXPCU_TXBUF_693)
#define TXPCU_TXBUF_DATA_693_LSB                                               0
#define TXPCU_TXBUF_DATA_693_MSB                                               31
#define TXPCU_TXBUF_DATA_693_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_693_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_693_MASK) >> TXPCU_TXBUF_DATA_693_LSB)
#define TXPCU_TXBUF_DATA_693_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_693_LSB) & TXPCU_TXBUF_DATA_693_MASK)
#define TXPCU_TXBUF_DATA_693_RESET                                             0x0
#define TXPCU_TXBUF_693_ADDRESS                                                (0x1ad4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_693_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_693_RESET                                                  0x0

// 0x1ad8 (TXPCU_TXBUF_694)
#define TXPCU_TXBUF_DATA_694_LSB                                               0
#define TXPCU_TXBUF_DATA_694_MSB                                               31
#define TXPCU_TXBUF_DATA_694_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_694_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_694_MASK) >> TXPCU_TXBUF_DATA_694_LSB)
#define TXPCU_TXBUF_DATA_694_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_694_LSB) & TXPCU_TXBUF_DATA_694_MASK)
#define TXPCU_TXBUF_DATA_694_RESET                                             0x0
#define TXPCU_TXBUF_694_ADDRESS                                                (0x1ad8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_694_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_694_RESET                                                  0x0

// 0x1adc (TXPCU_TXBUF_695)
#define TXPCU_TXBUF_DATA_695_LSB                                               0
#define TXPCU_TXBUF_DATA_695_MSB                                               31
#define TXPCU_TXBUF_DATA_695_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_695_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_695_MASK) >> TXPCU_TXBUF_DATA_695_LSB)
#define TXPCU_TXBUF_DATA_695_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_695_LSB) & TXPCU_TXBUF_DATA_695_MASK)
#define TXPCU_TXBUF_DATA_695_RESET                                             0x0
#define TXPCU_TXBUF_695_ADDRESS                                                (0x1adc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_695_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_695_RESET                                                  0x0

// 0x1ae0 (TXPCU_TXBUF_696)
#define TXPCU_TXBUF_DATA_696_LSB                                               0
#define TXPCU_TXBUF_DATA_696_MSB                                               31
#define TXPCU_TXBUF_DATA_696_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_696_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_696_MASK) >> TXPCU_TXBUF_DATA_696_LSB)
#define TXPCU_TXBUF_DATA_696_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_696_LSB) & TXPCU_TXBUF_DATA_696_MASK)
#define TXPCU_TXBUF_DATA_696_RESET                                             0x0
#define TXPCU_TXBUF_696_ADDRESS                                                (0x1ae0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_696_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_696_RESET                                                  0x0

// 0x1ae4 (TXPCU_TXBUF_697)
#define TXPCU_TXBUF_DATA_697_LSB                                               0
#define TXPCU_TXBUF_DATA_697_MSB                                               31
#define TXPCU_TXBUF_DATA_697_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_697_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_697_MASK) >> TXPCU_TXBUF_DATA_697_LSB)
#define TXPCU_TXBUF_DATA_697_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_697_LSB) & TXPCU_TXBUF_DATA_697_MASK)
#define TXPCU_TXBUF_DATA_697_RESET                                             0x0
#define TXPCU_TXBUF_697_ADDRESS                                                (0x1ae4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_697_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_697_RESET                                                  0x0

// 0x1ae8 (TXPCU_TXBUF_698)
#define TXPCU_TXBUF_DATA_698_LSB                                               0
#define TXPCU_TXBUF_DATA_698_MSB                                               31
#define TXPCU_TXBUF_DATA_698_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_698_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_698_MASK) >> TXPCU_TXBUF_DATA_698_LSB)
#define TXPCU_TXBUF_DATA_698_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_698_LSB) & TXPCU_TXBUF_DATA_698_MASK)
#define TXPCU_TXBUF_DATA_698_RESET                                             0x0
#define TXPCU_TXBUF_698_ADDRESS                                                (0x1ae8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_698_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_698_RESET                                                  0x0

// 0x1aec (TXPCU_TXBUF_699)
#define TXPCU_TXBUF_DATA_699_LSB                                               0
#define TXPCU_TXBUF_DATA_699_MSB                                               31
#define TXPCU_TXBUF_DATA_699_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_699_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_699_MASK) >> TXPCU_TXBUF_DATA_699_LSB)
#define TXPCU_TXBUF_DATA_699_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_699_LSB) & TXPCU_TXBUF_DATA_699_MASK)
#define TXPCU_TXBUF_DATA_699_RESET                                             0x0
#define TXPCU_TXBUF_699_ADDRESS                                                (0x1aec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_699_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_699_RESET                                                  0x0

// 0x1af0 (TXPCU_TXBUF_700)
#define TXPCU_TXBUF_DATA_700_LSB                                               0
#define TXPCU_TXBUF_DATA_700_MSB                                               31
#define TXPCU_TXBUF_DATA_700_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_700_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_700_MASK) >> TXPCU_TXBUF_DATA_700_LSB)
#define TXPCU_TXBUF_DATA_700_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_700_LSB) & TXPCU_TXBUF_DATA_700_MASK)
#define TXPCU_TXBUF_DATA_700_RESET                                             0x0
#define TXPCU_TXBUF_700_ADDRESS                                                (0x1af0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_700_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_700_RESET                                                  0x0

// 0x1af4 (TXPCU_TXBUF_701)
#define TXPCU_TXBUF_DATA_701_LSB                                               0
#define TXPCU_TXBUF_DATA_701_MSB                                               31
#define TXPCU_TXBUF_DATA_701_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_701_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_701_MASK) >> TXPCU_TXBUF_DATA_701_LSB)
#define TXPCU_TXBUF_DATA_701_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_701_LSB) & TXPCU_TXBUF_DATA_701_MASK)
#define TXPCU_TXBUF_DATA_701_RESET                                             0x0
#define TXPCU_TXBUF_701_ADDRESS                                                (0x1af4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_701_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_701_RESET                                                  0x0

// 0x1af8 (TXPCU_TXBUF_702)
#define TXPCU_TXBUF_DATA_702_LSB                                               0
#define TXPCU_TXBUF_DATA_702_MSB                                               31
#define TXPCU_TXBUF_DATA_702_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_702_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_702_MASK) >> TXPCU_TXBUF_DATA_702_LSB)
#define TXPCU_TXBUF_DATA_702_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_702_LSB) & TXPCU_TXBUF_DATA_702_MASK)
#define TXPCU_TXBUF_DATA_702_RESET                                             0x0
#define TXPCU_TXBUF_702_ADDRESS                                                (0x1af8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_702_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_702_RESET                                                  0x0

// 0x1afc (TXPCU_TXBUF_703)
#define TXPCU_TXBUF_DATA_703_LSB                                               0
#define TXPCU_TXBUF_DATA_703_MSB                                               31
#define TXPCU_TXBUF_DATA_703_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_703_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_703_MASK) >> TXPCU_TXBUF_DATA_703_LSB)
#define TXPCU_TXBUF_DATA_703_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_703_LSB) & TXPCU_TXBUF_DATA_703_MASK)
#define TXPCU_TXBUF_DATA_703_RESET                                             0x0
#define TXPCU_TXBUF_703_ADDRESS                                                (0x1afc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_703_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_703_RESET                                                  0x0

// 0x1b00 (TXPCU_TXBUF_704)
#define TXPCU_TXBUF_DATA_704_LSB                                               0
#define TXPCU_TXBUF_DATA_704_MSB                                               31
#define TXPCU_TXBUF_DATA_704_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_704_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_704_MASK) >> TXPCU_TXBUF_DATA_704_LSB)
#define TXPCU_TXBUF_DATA_704_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_704_LSB) & TXPCU_TXBUF_DATA_704_MASK)
#define TXPCU_TXBUF_DATA_704_RESET                                             0x0
#define TXPCU_TXBUF_704_ADDRESS                                                (0x1b00 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_704_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_704_RESET                                                  0x0

// 0x1b04 (TXPCU_TXBUF_705)
#define TXPCU_TXBUF_DATA_705_LSB                                               0
#define TXPCU_TXBUF_DATA_705_MSB                                               31
#define TXPCU_TXBUF_DATA_705_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_705_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_705_MASK) >> TXPCU_TXBUF_DATA_705_LSB)
#define TXPCU_TXBUF_DATA_705_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_705_LSB) & TXPCU_TXBUF_DATA_705_MASK)
#define TXPCU_TXBUF_DATA_705_RESET                                             0x0
#define TXPCU_TXBUF_705_ADDRESS                                                (0x1b04 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_705_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_705_RESET                                                  0x0

// 0x1b08 (TXPCU_TXBUF_706)
#define TXPCU_TXBUF_DATA_706_LSB                                               0
#define TXPCU_TXBUF_DATA_706_MSB                                               31
#define TXPCU_TXBUF_DATA_706_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_706_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_706_MASK) >> TXPCU_TXBUF_DATA_706_LSB)
#define TXPCU_TXBUF_DATA_706_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_706_LSB) & TXPCU_TXBUF_DATA_706_MASK)
#define TXPCU_TXBUF_DATA_706_RESET                                             0x0
#define TXPCU_TXBUF_706_ADDRESS                                                (0x1b08 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_706_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_706_RESET                                                  0x0

// 0x1b0c (TXPCU_TXBUF_707)
#define TXPCU_TXBUF_DATA_707_LSB                                               0
#define TXPCU_TXBUF_DATA_707_MSB                                               31
#define TXPCU_TXBUF_DATA_707_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_707_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_707_MASK) >> TXPCU_TXBUF_DATA_707_LSB)
#define TXPCU_TXBUF_DATA_707_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_707_LSB) & TXPCU_TXBUF_DATA_707_MASK)
#define TXPCU_TXBUF_DATA_707_RESET                                             0x0
#define TXPCU_TXBUF_707_ADDRESS                                                (0x1b0c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_707_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_707_RESET                                                  0x0

// 0x1b10 (TXPCU_TXBUF_708)
#define TXPCU_TXBUF_DATA_708_LSB                                               0
#define TXPCU_TXBUF_DATA_708_MSB                                               31
#define TXPCU_TXBUF_DATA_708_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_708_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_708_MASK) >> TXPCU_TXBUF_DATA_708_LSB)
#define TXPCU_TXBUF_DATA_708_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_708_LSB) & TXPCU_TXBUF_DATA_708_MASK)
#define TXPCU_TXBUF_DATA_708_RESET                                             0x0
#define TXPCU_TXBUF_708_ADDRESS                                                (0x1b10 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_708_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_708_RESET                                                  0x0

// 0x1b14 (TXPCU_TXBUF_709)
#define TXPCU_TXBUF_DATA_709_LSB                                               0
#define TXPCU_TXBUF_DATA_709_MSB                                               31
#define TXPCU_TXBUF_DATA_709_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_709_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_709_MASK) >> TXPCU_TXBUF_DATA_709_LSB)
#define TXPCU_TXBUF_DATA_709_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_709_LSB) & TXPCU_TXBUF_DATA_709_MASK)
#define TXPCU_TXBUF_DATA_709_RESET                                             0x0
#define TXPCU_TXBUF_709_ADDRESS                                                (0x1b14 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_709_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_709_RESET                                                  0x0

// 0x1b18 (TXPCU_TXBUF_710)
#define TXPCU_TXBUF_DATA_710_LSB                                               0
#define TXPCU_TXBUF_DATA_710_MSB                                               31
#define TXPCU_TXBUF_DATA_710_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_710_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_710_MASK) >> TXPCU_TXBUF_DATA_710_LSB)
#define TXPCU_TXBUF_DATA_710_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_710_LSB) & TXPCU_TXBUF_DATA_710_MASK)
#define TXPCU_TXBUF_DATA_710_RESET                                             0x0
#define TXPCU_TXBUF_710_ADDRESS                                                (0x1b18 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_710_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_710_RESET                                                  0x0

// 0x1b1c (TXPCU_TXBUF_711)
#define TXPCU_TXBUF_DATA_711_LSB                                               0
#define TXPCU_TXBUF_DATA_711_MSB                                               31
#define TXPCU_TXBUF_DATA_711_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_711_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_711_MASK) >> TXPCU_TXBUF_DATA_711_LSB)
#define TXPCU_TXBUF_DATA_711_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_711_LSB) & TXPCU_TXBUF_DATA_711_MASK)
#define TXPCU_TXBUF_DATA_711_RESET                                             0x0
#define TXPCU_TXBUF_711_ADDRESS                                                (0x1b1c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_711_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_711_RESET                                                  0x0

// 0x1b20 (TXPCU_TXBUF_712)
#define TXPCU_TXBUF_DATA_712_LSB                                               0
#define TXPCU_TXBUF_DATA_712_MSB                                               31
#define TXPCU_TXBUF_DATA_712_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_712_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_712_MASK) >> TXPCU_TXBUF_DATA_712_LSB)
#define TXPCU_TXBUF_DATA_712_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_712_LSB) & TXPCU_TXBUF_DATA_712_MASK)
#define TXPCU_TXBUF_DATA_712_RESET                                             0x0
#define TXPCU_TXBUF_712_ADDRESS                                                (0x1b20 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_712_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_712_RESET                                                  0x0

// 0x1b24 (TXPCU_TXBUF_713)
#define TXPCU_TXBUF_DATA_713_LSB                                               0
#define TXPCU_TXBUF_DATA_713_MSB                                               31
#define TXPCU_TXBUF_DATA_713_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_713_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_713_MASK) >> TXPCU_TXBUF_DATA_713_LSB)
#define TXPCU_TXBUF_DATA_713_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_713_LSB) & TXPCU_TXBUF_DATA_713_MASK)
#define TXPCU_TXBUF_DATA_713_RESET                                             0x0
#define TXPCU_TXBUF_713_ADDRESS                                                (0x1b24 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_713_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_713_RESET                                                  0x0

// 0x1b28 (TXPCU_TXBUF_714)
#define TXPCU_TXBUF_DATA_714_LSB                                               0
#define TXPCU_TXBUF_DATA_714_MSB                                               31
#define TXPCU_TXBUF_DATA_714_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_714_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_714_MASK) >> TXPCU_TXBUF_DATA_714_LSB)
#define TXPCU_TXBUF_DATA_714_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_714_LSB) & TXPCU_TXBUF_DATA_714_MASK)
#define TXPCU_TXBUF_DATA_714_RESET                                             0x0
#define TXPCU_TXBUF_714_ADDRESS                                                (0x1b28 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_714_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_714_RESET                                                  0x0

// 0x1b2c (TXPCU_TXBUF_715)
#define TXPCU_TXBUF_DATA_715_LSB                                               0
#define TXPCU_TXBUF_DATA_715_MSB                                               31
#define TXPCU_TXBUF_DATA_715_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_715_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_715_MASK) >> TXPCU_TXBUF_DATA_715_LSB)
#define TXPCU_TXBUF_DATA_715_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_715_LSB) & TXPCU_TXBUF_DATA_715_MASK)
#define TXPCU_TXBUF_DATA_715_RESET                                             0x0
#define TXPCU_TXBUF_715_ADDRESS                                                (0x1b2c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_715_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_715_RESET                                                  0x0

// 0x1b30 (TXPCU_TXBUF_716)
#define TXPCU_TXBUF_DATA_716_LSB                                               0
#define TXPCU_TXBUF_DATA_716_MSB                                               31
#define TXPCU_TXBUF_DATA_716_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_716_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_716_MASK) >> TXPCU_TXBUF_DATA_716_LSB)
#define TXPCU_TXBUF_DATA_716_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_716_LSB) & TXPCU_TXBUF_DATA_716_MASK)
#define TXPCU_TXBUF_DATA_716_RESET                                             0x0
#define TXPCU_TXBUF_716_ADDRESS                                                (0x1b30 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_716_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_716_RESET                                                  0x0

// 0x1b34 (TXPCU_TXBUF_717)
#define TXPCU_TXBUF_DATA_717_LSB                                               0
#define TXPCU_TXBUF_DATA_717_MSB                                               31
#define TXPCU_TXBUF_DATA_717_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_717_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_717_MASK) >> TXPCU_TXBUF_DATA_717_LSB)
#define TXPCU_TXBUF_DATA_717_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_717_LSB) & TXPCU_TXBUF_DATA_717_MASK)
#define TXPCU_TXBUF_DATA_717_RESET                                             0x0
#define TXPCU_TXBUF_717_ADDRESS                                                (0x1b34 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_717_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_717_RESET                                                  0x0

// 0x1b38 (TXPCU_TXBUF_718)
#define TXPCU_TXBUF_DATA_718_LSB                                               0
#define TXPCU_TXBUF_DATA_718_MSB                                               31
#define TXPCU_TXBUF_DATA_718_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_718_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_718_MASK) >> TXPCU_TXBUF_DATA_718_LSB)
#define TXPCU_TXBUF_DATA_718_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_718_LSB) & TXPCU_TXBUF_DATA_718_MASK)
#define TXPCU_TXBUF_DATA_718_RESET                                             0x0
#define TXPCU_TXBUF_718_ADDRESS                                                (0x1b38 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_718_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_718_RESET                                                  0x0

// 0x1b3c (TXPCU_TXBUF_719)
#define TXPCU_TXBUF_DATA_719_LSB                                               0
#define TXPCU_TXBUF_DATA_719_MSB                                               31
#define TXPCU_TXBUF_DATA_719_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_719_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_719_MASK) >> TXPCU_TXBUF_DATA_719_LSB)
#define TXPCU_TXBUF_DATA_719_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_719_LSB) & TXPCU_TXBUF_DATA_719_MASK)
#define TXPCU_TXBUF_DATA_719_RESET                                             0x0
#define TXPCU_TXBUF_719_ADDRESS                                                (0x1b3c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_719_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_719_RESET                                                  0x0

// 0x1b40 (TXPCU_TXBUF_720)
#define TXPCU_TXBUF_DATA_720_LSB                                               0
#define TXPCU_TXBUF_DATA_720_MSB                                               31
#define TXPCU_TXBUF_DATA_720_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_720_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_720_MASK) >> TXPCU_TXBUF_DATA_720_LSB)
#define TXPCU_TXBUF_DATA_720_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_720_LSB) & TXPCU_TXBUF_DATA_720_MASK)
#define TXPCU_TXBUF_DATA_720_RESET                                             0x0
#define TXPCU_TXBUF_720_ADDRESS                                                (0x1b40 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_720_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_720_RESET                                                  0x0

// 0x1b44 (TXPCU_TXBUF_721)
#define TXPCU_TXBUF_DATA_721_LSB                                               0
#define TXPCU_TXBUF_DATA_721_MSB                                               31
#define TXPCU_TXBUF_DATA_721_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_721_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_721_MASK) >> TXPCU_TXBUF_DATA_721_LSB)
#define TXPCU_TXBUF_DATA_721_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_721_LSB) & TXPCU_TXBUF_DATA_721_MASK)
#define TXPCU_TXBUF_DATA_721_RESET                                             0x0
#define TXPCU_TXBUF_721_ADDRESS                                                (0x1b44 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_721_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_721_RESET                                                  0x0

// 0x1b48 (TXPCU_TXBUF_722)
#define TXPCU_TXBUF_DATA_722_LSB                                               0
#define TXPCU_TXBUF_DATA_722_MSB                                               31
#define TXPCU_TXBUF_DATA_722_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_722_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_722_MASK) >> TXPCU_TXBUF_DATA_722_LSB)
#define TXPCU_TXBUF_DATA_722_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_722_LSB) & TXPCU_TXBUF_DATA_722_MASK)
#define TXPCU_TXBUF_DATA_722_RESET                                             0x0
#define TXPCU_TXBUF_722_ADDRESS                                                (0x1b48 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_722_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_722_RESET                                                  0x0

// 0x1b4c (TXPCU_TXBUF_723)
#define TXPCU_TXBUF_DATA_723_LSB                                               0
#define TXPCU_TXBUF_DATA_723_MSB                                               31
#define TXPCU_TXBUF_DATA_723_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_723_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_723_MASK) >> TXPCU_TXBUF_DATA_723_LSB)
#define TXPCU_TXBUF_DATA_723_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_723_LSB) & TXPCU_TXBUF_DATA_723_MASK)
#define TXPCU_TXBUF_DATA_723_RESET                                             0x0
#define TXPCU_TXBUF_723_ADDRESS                                                (0x1b4c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_723_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_723_RESET                                                  0x0

// 0x1b50 (TXPCU_TXBUF_724)
#define TXPCU_TXBUF_DATA_724_LSB                                               0
#define TXPCU_TXBUF_DATA_724_MSB                                               31
#define TXPCU_TXBUF_DATA_724_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_724_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_724_MASK) >> TXPCU_TXBUF_DATA_724_LSB)
#define TXPCU_TXBUF_DATA_724_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_724_LSB) & TXPCU_TXBUF_DATA_724_MASK)
#define TXPCU_TXBUF_DATA_724_RESET                                             0x0
#define TXPCU_TXBUF_724_ADDRESS                                                (0x1b50 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_724_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_724_RESET                                                  0x0

// 0x1b54 (TXPCU_TXBUF_725)
#define TXPCU_TXBUF_DATA_725_LSB                                               0
#define TXPCU_TXBUF_DATA_725_MSB                                               31
#define TXPCU_TXBUF_DATA_725_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_725_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_725_MASK) >> TXPCU_TXBUF_DATA_725_LSB)
#define TXPCU_TXBUF_DATA_725_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_725_LSB) & TXPCU_TXBUF_DATA_725_MASK)
#define TXPCU_TXBUF_DATA_725_RESET                                             0x0
#define TXPCU_TXBUF_725_ADDRESS                                                (0x1b54 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_725_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_725_RESET                                                  0x0

// 0x1b58 (TXPCU_TXBUF_726)
#define TXPCU_TXBUF_DATA_726_LSB                                               0
#define TXPCU_TXBUF_DATA_726_MSB                                               31
#define TXPCU_TXBUF_DATA_726_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_726_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_726_MASK) >> TXPCU_TXBUF_DATA_726_LSB)
#define TXPCU_TXBUF_DATA_726_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_726_LSB) & TXPCU_TXBUF_DATA_726_MASK)
#define TXPCU_TXBUF_DATA_726_RESET                                             0x0
#define TXPCU_TXBUF_726_ADDRESS                                                (0x1b58 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_726_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_726_RESET                                                  0x0

// 0x1b5c (TXPCU_TXBUF_727)
#define TXPCU_TXBUF_DATA_727_LSB                                               0
#define TXPCU_TXBUF_DATA_727_MSB                                               31
#define TXPCU_TXBUF_DATA_727_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_727_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_727_MASK) >> TXPCU_TXBUF_DATA_727_LSB)
#define TXPCU_TXBUF_DATA_727_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_727_LSB) & TXPCU_TXBUF_DATA_727_MASK)
#define TXPCU_TXBUF_DATA_727_RESET                                             0x0
#define TXPCU_TXBUF_727_ADDRESS                                                (0x1b5c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_727_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_727_RESET                                                  0x0

// 0x1b60 (TXPCU_TXBUF_728)
#define TXPCU_TXBUF_DATA_728_LSB                                               0
#define TXPCU_TXBUF_DATA_728_MSB                                               31
#define TXPCU_TXBUF_DATA_728_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_728_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_728_MASK) >> TXPCU_TXBUF_DATA_728_LSB)
#define TXPCU_TXBUF_DATA_728_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_728_LSB) & TXPCU_TXBUF_DATA_728_MASK)
#define TXPCU_TXBUF_DATA_728_RESET                                             0x0
#define TXPCU_TXBUF_728_ADDRESS                                                (0x1b60 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_728_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_728_RESET                                                  0x0

// 0x1b64 (TXPCU_TXBUF_729)
#define TXPCU_TXBUF_DATA_729_LSB                                               0
#define TXPCU_TXBUF_DATA_729_MSB                                               31
#define TXPCU_TXBUF_DATA_729_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_729_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_729_MASK) >> TXPCU_TXBUF_DATA_729_LSB)
#define TXPCU_TXBUF_DATA_729_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_729_LSB) & TXPCU_TXBUF_DATA_729_MASK)
#define TXPCU_TXBUF_DATA_729_RESET                                             0x0
#define TXPCU_TXBUF_729_ADDRESS                                                (0x1b64 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_729_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_729_RESET                                                  0x0

// 0x1b68 (TXPCU_TXBUF_730)
#define TXPCU_TXBUF_DATA_730_LSB                                               0
#define TXPCU_TXBUF_DATA_730_MSB                                               31
#define TXPCU_TXBUF_DATA_730_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_730_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_730_MASK) >> TXPCU_TXBUF_DATA_730_LSB)
#define TXPCU_TXBUF_DATA_730_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_730_LSB) & TXPCU_TXBUF_DATA_730_MASK)
#define TXPCU_TXBUF_DATA_730_RESET                                             0x0
#define TXPCU_TXBUF_730_ADDRESS                                                (0x1b68 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_730_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_730_RESET                                                  0x0

// 0x1b6c (TXPCU_TXBUF_731)
#define TXPCU_TXBUF_DATA_731_LSB                                               0
#define TXPCU_TXBUF_DATA_731_MSB                                               31
#define TXPCU_TXBUF_DATA_731_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_731_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_731_MASK) >> TXPCU_TXBUF_DATA_731_LSB)
#define TXPCU_TXBUF_DATA_731_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_731_LSB) & TXPCU_TXBUF_DATA_731_MASK)
#define TXPCU_TXBUF_DATA_731_RESET                                             0x0
#define TXPCU_TXBUF_731_ADDRESS                                                (0x1b6c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_731_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_731_RESET                                                  0x0

// 0x1b70 (TXPCU_TXBUF_732)
#define TXPCU_TXBUF_DATA_732_LSB                                               0
#define TXPCU_TXBUF_DATA_732_MSB                                               31
#define TXPCU_TXBUF_DATA_732_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_732_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_732_MASK) >> TXPCU_TXBUF_DATA_732_LSB)
#define TXPCU_TXBUF_DATA_732_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_732_LSB) & TXPCU_TXBUF_DATA_732_MASK)
#define TXPCU_TXBUF_DATA_732_RESET                                             0x0
#define TXPCU_TXBUF_732_ADDRESS                                                (0x1b70 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_732_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_732_RESET                                                  0x0

// 0x1b74 (TXPCU_TXBUF_733)
#define TXPCU_TXBUF_DATA_733_LSB                                               0
#define TXPCU_TXBUF_DATA_733_MSB                                               31
#define TXPCU_TXBUF_DATA_733_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_733_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_733_MASK) >> TXPCU_TXBUF_DATA_733_LSB)
#define TXPCU_TXBUF_DATA_733_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_733_LSB) & TXPCU_TXBUF_DATA_733_MASK)
#define TXPCU_TXBUF_DATA_733_RESET                                             0x0
#define TXPCU_TXBUF_733_ADDRESS                                                (0x1b74 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_733_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_733_RESET                                                  0x0

// 0x1b78 (TXPCU_TXBUF_734)
#define TXPCU_TXBUF_DATA_734_LSB                                               0
#define TXPCU_TXBUF_DATA_734_MSB                                               31
#define TXPCU_TXBUF_DATA_734_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_734_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_734_MASK) >> TXPCU_TXBUF_DATA_734_LSB)
#define TXPCU_TXBUF_DATA_734_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_734_LSB) & TXPCU_TXBUF_DATA_734_MASK)
#define TXPCU_TXBUF_DATA_734_RESET                                             0x0
#define TXPCU_TXBUF_734_ADDRESS                                                (0x1b78 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_734_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_734_RESET                                                  0x0

// 0x1b7c (TXPCU_TXBUF_735)
#define TXPCU_TXBUF_DATA_735_LSB                                               0
#define TXPCU_TXBUF_DATA_735_MSB                                               31
#define TXPCU_TXBUF_DATA_735_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_735_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_735_MASK) >> TXPCU_TXBUF_DATA_735_LSB)
#define TXPCU_TXBUF_DATA_735_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_735_LSB) & TXPCU_TXBUF_DATA_735_MASK)
#define TXPCU_TXBUF_DATA_735_RESET                                             0x0
#define TXPCU_TXBUF_735_ADDRESS                                                (0x1b7c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_735_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_735_RESET                                                  0x0

// 0x1b80 (TXPCU_TXBUF_736)
#define TXPCU_TXBUF_DATA_736_LSB                                               0
#define TXPCU_TXBUF_DATA_736_MSB                                               31
#define TXPCU_TXBUF_DATA_736_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_736_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_736_MASK) >> TXPCU_TXBUF_DATA_736_LSB)
#define TXPCU_TXBUF_DATA_736_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_736_LSB) & TXPCU_TXBUF_DATA_736_MASK)
#define TXPCU_TXBUF_DATA_736_RESET                                             0x0
#define TXPCU_TXBUF_736_ADDRESS                                                (0x1b80 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_736_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_736_RESET                                                  0x0

// 0x1b84 (TXPCU_TXBUF_737)
#define TXPCU_TXBUF_DATA_737_LSB                                               0
#define TXPCU_TXBUF_DATA_737_MSB                                               31
#define TXPCU_TXBUF_DATA_737_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_737_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_737_MASK) >> TXPCU_TXBUF_DATA_737_LSB)
#define TXPCU_TXBUF_DATA_737_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_737_LSB) & TXPCU_TXBUF_DATA_737_MASK)
#define TXPCU_TXBUF_DATA_737_RESET                                             0x0
#define TXPCU_TXBUF_737_ADDRESS                                                (0x1b84 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_737_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_737_RESET                                                  0x0

// 0x1b88 (TXPCU_TXBUF_738)
#define TXPCU_TXBUF_DATA_738_LSB                                               0
#define TXPCU_TXBUF_DATA_738_MSB                                               31
#define TXPCU_TXBUF_DATA_738_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_738_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_738_MASK) >> TXPCU_TXBUF_DATA_738_LSB)
#define TXPCU_TXBUF_DATA_738_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_738_LSB) & TXPCU_TXBUF_DATA_738_MASK)
#define TXPCU_TXBUF_DATA_738_RESET                                             0x0
#define TXPCU_TXBUF_738_ADDRESS                                                (0x1b88 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_738_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_738_RESET                                                  0x0

// 0x1b8c (TXPCU_TXBUF_739)
#define TXPCU_TXBUF_DATA_739_LSB                                               0
#define TXPCU_TXBUF_DATA_739_MSB                                               31
#define TXPCU_TXBUF_DATA_739_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_739_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_739_MASK) >> TXPCU_TXBUF_DATA_739_LSB)
#define TXPCU_TXBUF_DATA_739_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_739_LSB) & TXPCU_TXBUF_DATA_739_MASK)
#define TXPCU_TXBUF_DATA_739_RESET                                             0x0
#define TXPCU_TXBUF_739_ADDRESS                                                (0x1b8c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_739_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_739_RESET                                                  0x0

// 0x1b90 (TXPCU_TXBUF_740)
#define TXPCU_TXBUF_DATA_740_LSB                                               0
#define TXPCU_TXBUF_DATA_740_MSB                                               31
#define TXPCU_TXBUF_DATA_740_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_740_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_740_MASK) >> TXPCU_TXBUF_DATA_740_LSB)
#define TXPCU_TXBUF_DATA_740_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_740_LSB) & TXPCU_TXBUF_DATA_740_MASK)
#define TXPCU_TXBUF_DATA_740_RESET                                             0x0
#define TXPCU_TXBUF_740_ADDRESS                                                (0x1b90 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_740_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_740_RESET                                                  0x0

// 0x1b94 (TXPCU_TXBUF_741)
#define TXPCU_TXBUF_DATA_741_LSB                                               0
#define TXPCU_TXBUF_DATA_741_MSB                                               31
#define TXPCU_TXBUF_DATA_741_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_741_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_741_MASK) >> TXPCU_TXBUF_DATA_741_LSB)
#define TXPCU_TXBUF_DATA_741_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_741_LSB) & TXPCU_TXBUF_DATA_741_MASK)
#define TXPCU_TXBUF_DATA_741_RESET                                             0x0
#define TXPCU_TXBUF_741_ADDRESS                                                (0x1b94 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_741_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_741_RESET                                                  0x0

// 0x1b98 (TXPCU_TXBUF_742)
#define TXPCU_TXBUF_DATA_742_LSB                                               0
#define TXPCU_TXBUF_DATA_742_MSB                                               31
#define TXPCU_TXBUF_DATA_742_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_742_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_742_MASK) >> TXPCU_TXBUF_DATA_742_LSB)
#define TXPCU_TXBUF_DATA_742_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_742_LSB) & TXPCU_TXBUF_DATA_742_MASK)
#define TXPCU_TXBUF_DATA_742_RESET                                             0x0
#define TXPCU_TXBUF_742_ADDRESS                                                (0x1b98 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_742_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_742_RESET                                                  0x0

// 0x1b9c (TXPCU_TXBUF_743)
#define TXPCU_TXBUF_DATA_743_LSB                                               0
#define TXPCU_TXBUF_DATA_743_MSB                                               31
#define TXPCU_TXBUF_DATA_743_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_743_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_743_MASK) >> TXPCU_TXBUF_DATA_743_LSB)
#define TXPCU_TXBUF_DATA_743_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_743_LSB) & TXPCU_TXBUF_DATA_743_MASK)
#define TXPCU_TXBUF_DATA_743_RESET                                             0x0
#define TXPCU_TXBUF_743_ADDRESS                                                (0x1b9c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_743_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_743_RESET                                                  0x0

// 0x1ba0 (TXPCU_TXBUF_744)
#define TXPCU_TXBUF_DATA_744_LSB                                               0
#define TXPCU_TXBUF_DATA_744_MSB                                               31
#define TXPCU_TXBUF_DATA_744_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_744_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_744_MASK) >> TXPCU_TXBUF_DATA_744_LSB)
#define TXPCU_TXBUF_DATA_744_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_744_LSB) & TXPCU_TXBUF_DATA_744_MASK)
#define TXPCU_TXBUF_DATA_744_RESET                                             0x0
#define TXPCU_TXBUF_744_ADDRESS                                                (0x1ba0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_744_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_744_RESET                                                  0x0

// 0x1ba4 (TXPCU_TXBUF_745)
#define TXPCU_TXBUF_DATA_745_LSB                                               0
#define TXPCU_TXBUF_DATA_745_MSB                                               31
#define TXPCU_TXBUF_DATA_745_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_745_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_745_MASK) >> TXPCU_TXBUF_DATA_745_LSB)
#define TXPCU_TXBUF_DATA_745_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_745_LSB) & TXPCU_TXBUF_DATA_745_MASK)
#define TXPCU_TXBUF_DATA_745_RESET                                             0x0
#define TXPCU_TXBUF_745_ADDRESS                                                (0x1ba4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_745_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_745_RESET                                                  0x0

// 0x1ba8 (TXPCU_TXBUF_746)
#define TXPCU_TXBUF_DATA_746_LSB                                               0
#define TXPCU_TXBUF_DATA_746_MSB                                               31
#define TXPCU_TXBUF_DATA_746_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_746_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_746_MASK) >> TXPCU_TXBUF_DATA_746_LSB)
#define TXPCU_TXBUF_DATA_746_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_746_LSB) & TXPCU_TXBUF_DATA_746_MASK)
#define TXPCU_TXBUF_DATA_746_RESET                                             0x0
#define TXPCU_TXBUF_746_ADDRESS                                                (0x1ba8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_746_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_746_RESET                                                  0x0

// 0x1bac (TXPCU_TXBUF_747)
#define TXPCU_TXBUF_DATA_747_LSB                                               0
#define TXPCU_TXBUF_DATA_747_MSB                                               31
#define TXPCU_TXBUF_DATA_747_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_747_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_747_MASK) >> TXPCU_TXBUF_DATA_747_LSB)
#define TXPCU_TXBUF_DATA_747_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_747_LSB) & TXPCU_TXBUF_DATA_747_MASK)
#define TXPCU_TXBUF_DATA_747_RESET                                             0x0
#define TXPCU_TXBUF_747_ADDRESS                                                (0x1bac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_747_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_747_RESET                                                  0x0

// 0x1bb0 (TXPCU_TXBUF_748)
#define TXPCU_TXBUF_DATA_748_LSB                                               0
#define TXPCU_TXBUF_DATA_748_MSB                                               31
#define TXPCU_TXBUF_DATA_748_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_748_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_748_MASK) >> TXPCU_TXBUF_DATA_748_LSB)
#define TXPCU_TXBUF_DATA_748_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_748_LSB) & TXPCU_TXBUF_DATA_748_MASK)
#define TXPCU_TXBUF_DATA_748_RESET                                             0x0
#define TXPCU_TXBUF_748_ADDRESS                                                (0x1bb0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_748_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_748_RESET                                                  0x0

// 0x1bb4 (TXPCU_TXBUF_749)
#define TXPCU_TXBUF_DATA_749_LSB                                               0
#define TXPCU_TXBUF_DATA_749_MSB                                               31
#define TXPCU_TXBUF_DATA_749_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_749_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_749_MASK) >> TXPCU_TXBUF_DATA_749_LSB)
#define TXPCU_TXBUF_DATA_749_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_749_LSB) & TXPCU_TXBUF_DATA_749_MASK)
#define TXPCU_TXBUF_DATA_749_RESET                                             0x0
#define TXPCU_TXBUF_749_ADDRESS                                                (0x1bb4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_749_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_749_RESET                                                  0x0

// 0x1bb8 (TXPCU_TXBUF_750)
#define TXPCU_TXBUF_DATA_750_LSB                                               0
#define TXPCU_TXBUF_DATA_750_MSB                                               31
#define TXPCU_TXBUF_DATA_750_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_750_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_750_MASK) >> TXPCU_TXBUF_DATA_750_LSB)
#define TXPCU_TXBUF_DATA_750_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_750_LSB) & TXPCU_TXBUF_DATA_750_MASK)
#define TXPCU_TXBUF_DATA_750_RESET                                             0x0
#define TXPCU_TXBUF_750_ADDRESS                                                (0x1bb8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_750_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_750_RESET                                                  0x0

// 0x1bbc (TXPCU_TXBUF_751)
#define TXPCU_TXBUF_DATA_751_LSB                                               0
#define TXPCU_TXBUF_DATA_751_MSB                                               31
#define TXPCU_TXBUF_DATA_751_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_751_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_751_MASK) >> TXPCU_TXBUF_DATA_751_LSB)
#define TXPCU_TXBUF_DATA_751_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_751_LSB) & TXPCU_TXBUF_DATA_751_MASK)
#define TXPCU_TXBUF_DATA_751_RESET                                             0x0
#define TXPCU_TXBUF_751_ADDRESS                                                (0x1bbc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_751_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_751_RESET                                                  0x0

// 0x1bc0 (TXPCU_TXBUF_752)
#define TXPCU_TXBUF_DATA_752_LSB                                               0
#define TXPCU_TXBUF_DATA_752_MSB                                               31
#define TXPCU_TXBUF_DATA_752_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_752_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_752_MASK) >> TXPCU_TXBUF_DATA_752_LSB)
#define TXPCU_TXBUF_DATA_752_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_752_LSB) & TXPCU_TXBUF_DATA_752_MASK)
#define TXPCU_TXBUF_DATA_752_RESET                                             0x0
#define TXPCU_TXBUF_752_ADDRESS                                                (0x1bc0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_752_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_752_RESET                                                  0x0

// 0x1bc4 (TXPCU_TXBUF_753)
#define TXPCU_TXBUF_DATA_753_LSB                                               0
#define TXPCU_TXBUF_DATA_753_MSB                                               31
#define TXPCU_TXBUF_DATA_753_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_753_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_753_MASK) >> TXPCU_TXBUF_DATA_753_LSB)
#define TXPCU_TXBUF_DATA_753_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_753_LSB) & TXPCU_TXBUF_DATA_753_MASK)
#define TXPCU_TXBUF_DATA_753_RESET                                             0x0
#define TXPCU_TXBUF_753_ADDRESS                                                (0x1bc4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_753_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_753_RESET                                                  0x0

// 0x1bc8 (TXPCU_TXBUF_754)
#define TXPCU_TXBUF_DATA_754_LSB                                               0
#define TXPCU_TXBUF_DATA_754_MSB                                               31
#define TXPCU_TXBUF_DATA_754_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_754_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_754_MASK) >> TXPCU_TXBUF_DATA_754_LSB)
#define TXPCU_TXBUF_DATA_754_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_754_LSB) & TXPCU_TXBUF_DATA_754_MASK)
#define TXPCU_TXBUF_DATA_754_RESET                                             0x0
#define TXPCU_TXBUF_754_ADDRESS                                                (0x1bc8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_754_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_754_RESET                                                  0x0

// 0x1bcc (TXPCU_TXBUF_755)
#define TXPCU_TXBUF_DATA_755_LSB                                               0
#define TXPCU_TXBUF_DATA_755_MSB                                               31
#define TXPCU_TXBUF_DATA_755_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_755_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_755_MASK) >> TXPCU_TXBUF_DATA_755_LSB)
#define TXPCU_TXBUF_DATA_755_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_755_LSB) & TXPCU_TXBUF_DATA_755_MASK)
#define TXPCU_TXBUF_DATA_755_RESET                                             0x0
#define TXPCU_TXBUF_755_ADDRESS                                                (0x1bcc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_755_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_755_RESET                                                  0x0

// 0x1bd0 (TXPCU_TXBUF_756)
#define TXPCU_TXBUF_DATA_756_LSB                                               0
#define TXPCU_TXBUF_DATA_756_MSB                                               31
#define TXPCU_TXBUF_DATA_756_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_756_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_756_MASK) >> TXPCU_TXBUF_DATA_756_LSB)
#define TXPCU_TXBUF_DATA_756_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_756_LSB) & TXPCU_TXBUF_DATA_756_MASK)
#define TXPCU_TXBUF_DATA_756_RESET                                             0x0
#define TXPCU_TXBUF_756_ADDRESS                                                (0x1bd0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_756_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_756_RESET                                                  0x0

// 0x1bd4 (TXPCU_TXBUF_757)
#define TXPCU_TXBUF_DATA_757_LSB                                               0
#define TXPCU_TXBUF_DATA_757_MSB                                               31
#define TXPCU_TXBUF_DATA_757_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_757_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_757_MASK) >> TXPCU_TXBUF_DATA_757_LSB)
#define TXPCU_TXBUF_DATA_757_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_757_LSB) & TXPCU_TXBUF_DATA_757_MASK)
#define TXPCU_TXBUF_DATA_757_RESET                                             0x0
#define TXPCU_TXBUF_757_ADDRESS                                                (0x1bd4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_757_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_757_RESET                                                  0x0

// 0x1bd8 (TXPCU_TXBUF_758)
#define TXPCU_TXBUF_DATA_758_LSB                                               0
#define TXPCU_TXBUF_DATA_758_MSB                                               31
#define TXPCU_TXBUF_DATA_758_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_758_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_758_MASK) >> TXPCU_TXBUF_DATA_758_LSB)
#define TXPCU_TXBUF_DATA_758_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_758_LSB) & TXPCU_TXBUF_DATA_758_MASK)
#define TXPCU_TXBUF_DATA_758_RESET                                             0x0
#define TXPCU_TXBUF_758_ADDRESS                                                (0x1bd8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_758_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_758_RESET                                                  0x0

// 0x1bdc (TXPCU_TXBUF_759)
#define TXPCU_TXBUF_DATA_759_LSB                                               0
#define TXPCU_TXBUF_DATA_759_MSB                                               31
#define TXPCU_TXBUF_DATA_759_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_759_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_759_MASK) >> TXPCU_TXBUF_DATA_759_LSB)
#define TXPCU_TXBUF_DATA_759_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_759_LSB) & TXPCU_TXBUF_DATA_759_MASK)
#define TXPCU_TXBUF_DATA_759_RESET                                             0x0
#define TXPCU_TXBUF_759_ADDRESS                                                (0x1bdc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_759_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_759_RESET                                                  0x0

// 0x1be0 (TXPCU_TXBUF_760)
#define TXPCU_TXBUF_DATA_760_LSB                                               0
#define TXPCU_TXBUF_DATA_760_MSB                                               31
#define TXPCU_TXBUF_DATA_760_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_760_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_760_MASK) >> TXPCU_TXBUF_DATA_760_LSB)
#define TXPCU_TXBUF_DATA_760_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_760_LSB) & TXPCU_TXBUF_DATA_760_MASK)
#define TXPCU_TXBUF_DATA_760_RESET                                             0x0
#define TXPCU_TXBUF_760_ADDRESS                                                (0x1be0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_760_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_760_RESET                                                  0x0

// 0x1be4 (TXPCU_TXBUF_761)
#define TXPCU_TXBUF_DATA_761_LSB                                               0
#define TXPCU_TXBUF_DATA_761_MSB                                               31
#define TXPCU_TXBUF_DATA_761_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_761_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_761_MASK) >> TXPCU_TXBUF_DATA_761_LSB)
#define TXPCU_TXBUF_DATA_761_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_761_LSB) & TXPCU_TXBUF_DATA_761_MASK)
#define TXPCU_TXBUF_DATA_761_RESET                                             0x0
#define TXPCU_TXBUF_761_ADDRESS                                                (0x1be4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_761_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_761_RESET                                                  0x0

// 0x1be8 (TXPCU_TXBUF_762)
#define TXPCU_TXBUF_DATA_762_LSB                                               0
#define TXPCU_TXBUF_DATA_762_MSB                                               31
#define TXPCU_TXBUF_DATA_762_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_762_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_762_MASK) >> TXPCU_TXBUF_DATA_762_LSB)
#define TXPCU_TXBUF_DATA_762_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_762_LSB) & TXPCU_TXBUF_DATA_762_MASK)
#define TXPCU_TXBUF_DATA_762_RESET                                             0x0
#define TXPCU_TXBUF_762_ADDRESS                                                (0x1be8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_762_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_762_RESET                                                  0x0

// 0x1bec (TXPCU_TXBUF_763)
#define TXPCU_TXBUF_DATA_763_LSB                                               0
#define TXPCU_TXBUF_DATA_763_MSB                                               31
#define TXPCU_TXBUF_DATA_763_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_763_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_763_MASK) >> TXPCU_TXBUF_DATA_763_LSB)
#define TXPCU_TXBUF_DATA_763_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_763_LSB) & TXPCU_TXBUF_DATA_763_MASK)
#define TXPCU_TXBUF_DATA_763_RESET                                             0x0
#define TXPCU_TXBUF_763_ADDRESS                                                (0x1bec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_763_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_763_RESET                                                  0x0

// 0x1bf0 (TXPCU_TXBUF_764)
#define TXPCU_TXBUF_DATA_764_LSB                                               0
#define TXPCU_TXBUF_DATA_764_MSB                                               31
#define TXPCU_TXBUF_DATA_764_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_764_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_764_MASK) >> TXPCU_TXBUF_DATA_764_LSB)
#define TXPCU_TXBUF_DATA_764_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_764_LSB) & TXPCU_TXBUF_DATA_764_MASK)
#define TXPCU_TXBUF_DATA_764_RESET                                             0x0
#define TXPCU_TXBUF_764_ADDRESS                                                (0x1bf0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_764_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_764_RESET                                                  0x0

// 0x1bf4 (TXPCU_TXBUF_765)
#define TXPCU_TXBUF_DATA_765_LSB                                               0
#define TXPCU_TXBUF_DATA_765_MSB                                               31
#define TXPCU_TXBUF_DATA_765_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_765_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_765_MASK) >> TXPCU_TXBUF_DATA_765_LSB)
#define TXPCU_TXBUF_DATA_765_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_765_LSB) & TXPCU_TXBUF_DATA_765_MASK)
#define TXPCU_TXBUF_DATA_765_RESET                                             0x0
#define TXPCU_TXBUF_765_ADDRESS                                                (0x1bf4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_765_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_765_RESET                                                  0x0

// 0x1bf8 (TXPCU_TXBUF_766)
#define TXPCU_TXBUF_DATA_766_LSB                                               0
#define TXPCU_TXBUF_DATA_766_MSB                                               31
#define TXPCU_TXBUF_DATA_766_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_766_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_766_MASK) >> TXPCU_TXBUF_DATA_766_LSB)
#define TXPCU_TXBUF_DATA_766_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_766_LSB) & TXPCU_TXBUF_DATA_766_MASK)
#define TXPCU_TXBUF_DATA_766_RESET                                             0x0
#define TXPCU_TXBUF_766_ADDRESS                                                (0x1bf8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_766_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_766_RESET                                                  0x0

// 0x1bfc (TXPCU_TXBUF_767)
#define TXPCU_TXBUF_DATA_767_LSB                                               0
#define TXPCU_TXBUF_DATA_767_MSB                                               31
#define TXPCU_TXBUF_DATA_767_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_767_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_767_MASK) >> TXPCU_TXBUF_DATA_767_LSB)
#define TXPCU_TXBUF_DATA_767_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_767_LSB) & TXPCU_TXBUF_DATA_767_MASK)
#define TXPCU_TXBUF_DATA_767_RESET                                             0x0
#define TXPCU_TXBUF_767_ADDRESS                                                (0x1bfc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_767_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_767_RESET                                                  0x0

// 0x1c00 (TXPCU_TXBUF_768)
#define TXPCU_TXBUF_DATA_768_LSB                                               0
#define TXPCU_TXBUF_DATA_768_MSB                                               31
#define TXPCU_TXBUF_DATA_768_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_768_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_768_MASK) >> TXPCU_TXBUF_DATA_768_LSB)
#define TXPCU_TXBUF_DATA_768_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_768_LSB) & TXPCU_TXBUF_DATA_768_MASK)
#define TXPCU_TXBUF_DATA_768_RESET                                             0x0
#define TXPCU_TXBUF_768_ADDRESS                                                (0x1c00 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_768_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_768_RESET                                                  0x0

// 0x1c04 (TXPCU_TXBUF_769)
#define TXPCU_TXBUF_DATA_769_LSB                                               0
#define TXPCU_TXBUF_DATA_769_MSB                                               31
#define TXPCU_TXBUF_DATA_769_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_769_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_769_MASK) >> TXPCU_TXBUF_DATA_769_LSB)
#define TXPCU_TXBUF_DATA_769_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_769_LSB) & TXPCU_TXBUF_DATA_769_MASK)
#define TXPCU_TXBUF_DATA_769_RESET                                             0x0
#define TXPCU_TXBUF_769_ADDRESS                                                (0x1c04 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_769_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_769_RESET                                                  0x0

// 0x1c08 (TXPCU_TXBUF_770)
#define TXPCU_TXBUF_DATA_770_LSB                                               0
#define TXPCU_TXBUF_DATA_770_MSB                                               31
#define TXPCU_TXBUF_DATA_770_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_770_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_770_MASK) >> TXPCU_TXBUF_DATA_770_LSB)
#define TXPCU_TXBUF_DATA_770_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_770_LSB) & TXPCU_TXBUF_DATA_770_MASK)
#define TXPCU_TXBUF_DATA_770_RESET                                             0x0
#define TXPCU_TXBUF_770_ADDRESS                                                (0x1c08 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_770_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_770_RESET                                                  0x0

// 0x1c0c (TXPCU_TXBUF_771)
#define TXPCU_TXBUF_DATA_771_LSB                                               0
#define TXPCU_TXBUF_DATA_771_MSB                                               31
#define TXPCU_TXBUF_DATA_771_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_771_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_771_MASK) >> TXPCU_TXBUF_DATA_771_LSB)
#define TXPCU_TXBUF_DATA_771_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_771_LSB) & TXPCU_TXBUF_DATA_771_MASK)
#define TXPCU_TXBUF_DATA_771_RESET                                             0x0
#define TXPCU_TXBUF_771_ADDRESS                                                (0x1c0c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_771_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_771_RESET                                                  0x0

// 0x1c10 (TXPCU_TXBUF_772)
#define TXPCU_TXBUF_DATA_772_LSB                                               0
#define TXPCU_TXBUF_DATA_772_MSB                                               31
#define TXPCU_TXBUF_DATA_772_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_772_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_772_MASK) >> TXPCU_TXBUF_DATA_772_LSB)
#define TXPCU_TXBUF_DATA_772_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_772_LSB) & TXPCU_TXBUF_DATA_772_MASK)
#define TXPCU_TXBUF_DATA_772_RESET                                             0x0
#define TXPCU_TXBUF_772_ADDRESS                                                (0x1c10 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_772_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_772_RESET                                                  0x0

// 0x1c14 (TXPCU_TXBUF_773)
#define TXPCU_TXBUF_DATA_773_LSB                                               0
#define TXPCU_TXBUF_DATA_773_MSB                                               31
#define TXPCU_TXBUF_DATA_773_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_773_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_773_MASK) >> TXPCU_TXBUF_DATA_773_LSB)
#define TXPCU_TXBUF_DATA_773_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_773_LSB) & TXPCU_TXBUF_DATA_773_MASK)
#define TXPCU_TXBUF_DATA_773_RESET                                             0x0
#define TXPCU_TXBUF_773_ADDRESS                                                (0x1c14 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_773_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_773_RESET                                                  0x0

// 0x1c18 (TXPCU_TXBUF_774)
#define TXPCU_TXBUF_DATA_774_LSB                                               0
#define TXPCU_TXBUF_DATA_774_MSB                                               31
#define TXPCU_TXBUF_DATA_774_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_774_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_774_MASK) >> TXPCU_TXBUF_DATA_774_LSB)
#define TXPCU_TXBUF_DATA_774_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_774_LSB) & TXPCU_TXBUF_DATA_774_MASK)
#define TXPCU_TXBUF_DATA_774_RESET                                             0x0
#define TXPCU_TXBUF_774_ADDRESS                                                (0x1c18 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_774_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_774_RESET                                                  0x0

// 0x1c1c (TXPCU_TXBUF_775)
#define TXPCU_TXBUF_DATA_775_LSB                                               0
#define TXPCU_TXBUF_DATA_775_MSB                                               31
#define TXPCU_TXBUF_DATA_775_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_775_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_775_MASK) >> TXPCU_TXBUF_DATA_775_LSB)
#define TXPCU_TXBUF_DATA_775_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_775_LSB) & TXPCU_TXBUF_DATA_775_MASK)
#define TXPCU_TXBUF_DATA_775_RESET                                             0x0
#define TXPCU_TXBUF_775_ADDRESS                                                (0x1c1c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_775_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_775_RESET                                                  0x0

// 0x1c20 (TXPCU_TXBUF_776)
#define TXPCU_TXBUF_DATA_776_LSB                                               0
#define TXPCU_TXBUF_DATA_776_MSB                                               31
#define TXPCU_TXBUF_DATA_776_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_776_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_776_MASK) >> TXPCU_TXBUF_DATA_776_LSB)
#define TXPCU_TXBUF_DATA_776_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_776_LSB) & TXPCU_TXBUF_DATA_776_MASK)
#define TXPCU_TXBUF_DATA_776_RESET                                             0x0
#define TXPCU_TXBUF_776_ADDRESS                                                (0x1c20 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_776_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_776_RESET                                                  0x0

// 0x1c24 (TXPCU_TXBUF_777)
#define TXPCU_TXBUF_DATA_777_LSB                                               0
#define TXPCU_TXBUF_DATA_777_MSB                                               31
#define TXPCU_TXBUF_DATA_777_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_777_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_777_MASK) >> TXPCU_TXBUF_DATA_777_LSB)
#define TXPCU_TXBUF_DATA_777_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_777_LSB) & TXPCU_TXBUF_DATA_777_MASK)
#define TXPCU_TXBUF_DATA_777_RESET                                             0x0
#define TXPCU_TXBUF_777_ADDRESS                                                (0x1c24 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_777_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_777_RESET                                                  0x0

// 0x1c28 (TXPCU_TXBUF_778)
#define TXPCU_TXBUF_DATA_778_LSB                                               0
#define TXPCU_TXBUF_DATA_778_MSB                                               31
#define TXPCU_TXBUF_DATA_778_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_778_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_778_MASK) >> TXPCU_TXBUF_DATA_778_LSB)
#define TXPCU_TXBUF_DATA_778_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_778_LSB) & TXPCU_TXBUF_DATA_778_MASK)
#define TXPCU_TXBUF_DATA_778_RESET                                             0x0
#define TXPCU_TXBUF_778_ADDRESS                                                (0x1c28 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_778_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_778_RESET                                                  0x0

// 0x1c2c (TXPCU_TXBUF_779)
#define TXPCU_TXBUF_DATA_779_LSB                                               0
#define TXPCU_TXBUF_DATA_779_MSB                                               31
#define TXPCU_TXBUF_DATA_779_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_779_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_779_MASK) >> TXPCU_TXBUF_DATA_779_LSB)
#define TXPCU_TXBUF_DATA_779_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_779_LSB) & TXPCU_TXBUF_DATA_779_MASK)
#define TXPCU_TXBUF_DATA_779_RESET                                             0x0
#define TXPCU_TXBUF_779_ADDRESS                                                (0x1c2c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_779_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_779_RESET                                                  0x0

// 0x1c30 (TXPCU_TXBUF_780)
#define TXPCU_TXBUF_DATA_780_LSB                                               0
#define TXPCU_TXBUF_DATA_780_MSB                                               31
#define TXPCU_TXBUF_DATA_780_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_780_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_780_MASK) >> TXPCU_TXBUF_DATA_780_LSB)
#define TXPCU_TXBUF_DATA_780_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_780_LSB) & TXPCU_TXBUF_DATA_780_MASK)
#define TXPCU_TXBUF_DATA_780_RESET                                             0x0
#define TXPCU_TXBUF_780_ADDRESS                                                (0x1c30 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_780_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_780_RESET                                                  0x0

// 0x1c34 (TXPCU_TXBUF_781)
#define TXPCU_TXBUF_DATA_781_LSB                                               0
#define TXPCU_TXBUF_DATA_781_MSB                                               31
#define TXPCU_TXBUF_DATA_781_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_781_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_781_MASK) >> TXPCU_TXBUF_DATA_781_LSB)
#define TXPCU_TXBUF_DATA_781_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_781_LSB) & TXPCU_TXBUF_DATA_781_MASK)
#define TXPCU_TXBUF_DATA_781_RESET                                             0x0
#define TXPCU_TXBUF_781_ADDRESS                                                (0x1c34 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_781_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_781_RESET                                                  0x0

// 0x1c38 (TXPCU_TXBUF_782)
#define TXPCU_TXBUF_DATA_782_LSB                                               0
#define TXPCU_TXBUF_DATA_782_MSB                                               31
#define TXPCU_TXBUF_DATA_782_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_782_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_782_MASK) >> TXPCU_TXBUF_DATA_782_LSB)
#define TXPCU_TXBUF_DATA_782_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_782_LSB) & TXPCU_TXBUF_DATA_782_MASK)
#define TXPCU_TXBUF_DATA_782_RESET                                             0x0
#define TXPCU_TXBUF_782_ADDRESS                                                (0x1c38 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_782_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_782_RESET                                                  0x0

// 0x1c3c (TXPCU_TXBUF_783)
#define TXPCU_TXBUF_DATA_783_LSB                                               0
#define TXPCU_TXBUF_DATA_783_MSB                                               31
#define TXPCU_TXBUF_DATA_783_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_783_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_783_MASK) >> TXPCU_TXBUF_DATA_783_LSB)
#define TXPCU_TXBUF_DATA_783_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_783_LSB) & TXPCU_TXBUF_DATA_783_MASK)
#define TXPCU_TXBUF_DATA_783_RESET                                             0x0
#define TXPCU_TXBUF_783_ADDRESS                                                (0x1c3c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_783_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_783_RESET                                                  0x0

// 0x1c40 (TXPCU_TXBUF_784)
#define TXPCU_TXBUF_DATA_784_LSB                                               0
#define TXPCU_TXBUF_DATA_784_MSB                                               31
#define TXPCU_TXBUF_DATA_784_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_784_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_784_MASK) >> TXPCU_TXBUF_DATA_784_LSB)
#define TXPCU_TXBUF_DATA_784_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_784_LSB) & TXPCU_TXBUF_DATA_784_MASK)
#define TXPCU_TXBUF_DATA_784_RESET                                             0x0
#define TXPCU_TXBUF_784_ADDRESS                                                (0x1c40 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_784_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_784_RESET                                                  0x0

// 0x1c44 (TXPCU_TXBUF_785)
#define TXPCU_TXBUF_DATA_785_LSB                                               0
#define TXPCU_TXBUF_DATA_785_MSB                                               31
#define TXPCU_TXBUF_DATA_785_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_785_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_785_MASK) >> TXPCU_TXBUF_DATA_785_LSB)
#define TXPCU_TXBUF_DATA_785_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_785_LSB) & TXPCU_TXBUF_DATA_785_MASK)
#define TXPCU_TXBUF_DATA_785_RESET                                             0x0
#define TXPCU_TXBUF_785_ADDRESS                                                (0x1c44 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_785_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_785_RESET                                                  0x0

// 0x1c48 (TXPCU_TXBUF_786)
#define TXPCU_TXBUF_DATA_786_LSB                                               0
#define TXPCU_TXBUF_DATA_786_MSB                                               31
#define TXPCU_TXBUF_DATA_786_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_786_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_786_MASK) >> TXPCU_TXBUF_DATA_786_LSB)
#define TXPCU_TXBUF_DATA_786_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_786_LSB) & TXPCU_TXBUF_DATA_786_MASK)
#define TXPCU_TXBUF_DATA_786_RESET                                             0x0
#define TXPCU_TXBUF_786_ADDRESS                                                (0x1c48 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_786_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_786_RESET                                                  0x0

// 0x1c4c (TXPCU_TXBUF_787)
#define TXPCU_TXBUF_DATA_787_LSB                                               0
#define TXPCU_TXBUF_DATA_787_MSB                                               31
#define TXPCU_TXBUF_DATA_787_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_787_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_787_MASK) >> TXPCU_TXBUF_DATA_787_LSB)
#define TXPCU_TXBUF_DATA_787_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_787_LSB) & TXPCU_TXBUF_DATA_787_MASK)
#define TXPCU_TXBUF_DATA_787_RESET                                             0x0
#define TXPCU_TXBUF_787_ADDRESS                                                (0x1c4c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_787_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_787_RESET                                                  0x0

// 0x1c50 (TXPCU_TXBUF_788)
#define TXPCU_TXBUF_DATA_788_LSB                                               0
#define TXPCU_TXBUF_DATA_788_MSB                                               31
#define TXPCU_TXBUF_DATA_788_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_788_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_788_MASK) >> TXPCU_TXBUF_DATA_788_LSB)
#define TXPCU_TXBUF_DATA_788_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_788_LSB) & TXPCU_TXBUF_DATA_788_MASK)
#define TXPCU_TXBUF_DATA_788_RESET                                             0x0
#define TXPCU_TXBUF_788_ADDRESS                                                (0x1c50 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_788_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_788_RESET                                                  0x0

// 0x1c54 (TXPCU_TXBUF_789)
#define TXPCU_TXBUF_DATA_789_LSB                                               0
#define TXPCU_TXBUF_DATA_789_MSB                                               31
#define TXPCU_TXBUF_DATA_789_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_789_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_789_MASK) >> TXPCU_TXBUF_DATA_789_LSB)
#define TXPCU_TXBUF_DATA_789_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_789_LSB) & TXPCU_TXBUF_DATA_789_MASK)
#define TXPCU_TXBUF_DATA_789_RESET                                             0x0
#define TXPCU_TXBUF_789_ADDRESS                                                (0x1c54 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_789_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_789_RESET                                                  0x0

// 0x1c58 (TXPCU_TXBUF_790)
#define TXPCU_TXBUF_DATA_790_LSB                                               0
#define TXPCU_TXBUF_DATA_790_MSB                                               31
#define TXPCU_TXBUF_DATA_790_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_790_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_790_MASK) >> TXPCU_TXBUF_DATA_790_LSB)
#define TXPCU_TXBUF_DATA_790_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_790_LSB) & TXPCU_TXBUF_DATA_790_MASK)
#define TXPCU_TXBUF_DATA_790_RESET                                             0x0
#define TXPCU_TXBUF_790_ADDRESS                                                (0x1c58 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_790_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_790_RESET                                                  0x0

// 0x1c5c (TXPCU_TXBUF_791)
#define TXPCU_TXBUF_DATA_791_LSB                                               0
#define TXPCU_TXBUF_DATA_791_MSB                                               31
#define TXPCU_TXBUF_DATA_791_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_791_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_791_MASK) >> TXPCU_TXBUF_DATA_791_LSB)
#define TXPCU_TXBUF_DATA_791_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_791_LSB) & TXPCU_TXBUF_DATA_791_MASK)
#define TXPCU_TXBUF_DATA_791_RESET                                             0x0
#define TXPCU_TXBUF_791_ADDRESS                                                (0x1c5c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_791_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_791_RESET                                                  0x0

// 0x1c60 (TXPCU_TXBUF_792)
#define TXPCU_TXBUF_DATA_792_LSB                                               0
#define TXPCU_TXBUF_DATA_792_MSB                                               31
#define TXPCU_TXBUF_DATA_792_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_792_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_792_MASK) >> TXPCU_TXBUF_DATA_792_LSB)
#define TXPCU_TXBUF_DATA_792_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_792_LSB) & TXPCU_TXBUF_DATA_792_MASK)
#define TXPCU_TXBUF_DATA_792_RESET                                             0x0
#define TXPCU_TXBUF_792_ADDRESS                                                (0x1c60 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_792_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_792_RESET                                                  0x0

// 0x1c64 (TXPCU_TXBUF_793)
#define TXPCU_TXBUF_DATA_793_LSB                                               0
#define TXPCU_TXBUF_DATA_793_MSB                                               31
#define TXPCU_TXBUF_DATA_793_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_793_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_793_MASK) >> TXPCU_TXBUF_DATA_793_LSB)
#define TXPCU_TXBUF_DATA_793_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_793_LSB) & TXPCU_TXBUF_DATA_793_MASK)
#define TXPCU_TXBUF_DATA_793_RESET                                             0x0
#define TXPCU_TXBUF_793_ADDRESS                                                (0x1c64 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_793_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_793_RESET                                                  0x0

// 0x1c68 (TXPCU_TXBUF_794)
#define TXPCU_TXBUF_DATA_794_LSB                                               0
#define TXPCU_TXBUF_DATA_794_MSB                                               31
#define TXPCU_TXBUF_DATA_794_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_794_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_794_MASK) >> TXPCU_TXBUF_DATA_794_LSB)
#define TXPCU_TXBUF_DATA_794_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_794_LSB) & TXPCU_TXBUF_DATA_794_MASK)
#define TXPCU_TXBUF_DATA_794_RESET                                             0x0
#define TXPCU_TXBUF_794_ADDRESS                                                (0x1c68 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_794_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_794_RESET                                                  0x0

// 0x1c6c (TXPCU_TXBUF_795)
#define TXPCU_TXBUF_DATA_795_LSB                                               0
#define TXPCU_TXBUF_DATA_795_MSB                                               31
#define TXPCU_TXBUF_DATA_795_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_795_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_795_MASK) >> TXPCU_TXBUF_DATA_795_LSB)
#define TXPCU_TXBUF_DATA_795_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_795_LSB) & TXPCU_TXBUF_DATA_795_MASK)
#define TXPCU_TXBUF_DATA_795_RESET                                             0x0
#define TXPCU_TXBUF_795_ADDRESS                                                (0x1c6c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_795_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_795_RESET                                                  0x0

// 0x1c70 (TXPCU_TXBUF_796)
#define TXPCU_TXBUF_DATA_796_LSB                                               0
#define TXPCU_TXBUF_DATA_796_MSB                                               31
#define TXPCU_TXBUF_DATA_796_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_796_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_796_MASK) >> TXPCU_TXBUF_DATA_796_LSB)
#define TXPCU_TXBUF_DATA_796_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_796_LSB) & TXPCU_TXBUF_DATA_796_MASK)
#define TXPCU_TXBUF_DATA_796_RESET                                             0x0
#define TXPCU_TXBUF_796_ADDRESS                                                (0x1c70 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_796_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_796_RESET                                                  0x0

// 0x1c74 (TXPCU_TXBUF_797)
#define TXPCU_TXBUF_DATA_797_LSB                                               0
#define TXPCU_TXBUF_DATA_797_MSB                                               31
#define TXPCU_TXBUF_DATA_797_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_797_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_797_MASK) >> TXPCU_TXBUF_DATA_797_LSB)
#define TXPCU_TXBUF_DATA_797_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_797_LSB) & TXPCU_TXBUF_DATA_797_MASK)
#define TXPCU_TXBUF_DATA_797_RESET                                             0x0
#define TXPCU_TXBUF_797_ADDRESS                                                (0x1c74 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_797_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_797_RESET                                                  0x0

// 0x1c78 (TXPCU_TXBUF_798)
#define TXPCU_TXBUF_DATA_798_LSB                                               0
#define TXPCU_TXBUF_DATA_798_MSB                                               31
#define TXPCU_TXBUF_DATA_798_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_798_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_798_MASK) >> TXPCU_TXBUF_DATA_798_LSB)
#define TXPCU_TXBUF_DATA_798_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_798_LSB) & TXPCU_TXBUF_DATA_798_MASK)
#define TXPCU_TXBUF_DATA_798_RESET                                             0x0
#define TXPCU_TXBUF_798_ADDRESS                                                (0x1c78 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_798_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_798_RESET                                                  0x0

// 0x1c7c (TXPCU_TXBUF_799)
#define TXPCU_TXBUF_DATA_799_LSB                                               0
#define TXPCU_TXBUF_DATA_799_MSB                                               31
#define TXPCU_TXBUF_DATA_799_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_799_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_799_MASK) >> TXPCU_TXBUF_DATA_799_LSB)
#define TXPCU_TXBUF_DATA_799_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_799_LSB) & TXPCU_TXBUF_DATA_799_MASK)
#define TXPCU_TXBUF_DATA_799_RESET                                             0x0
#define TXPCU_TXBUF_799_ADDRESS                                                (0x1c7c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_799_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_799_RESET                                                  0x0

// 0x1c80 (TXPCU_TXBUF_800)
#define TXPCU_TXBUF_DATA_800_LSB                                               0
#define TXPCU_TXBUF_DATA_800_MSB                                               31
#define TXPCU_TXBUF_DATA_800_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_800_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_800_MASK) >> TXPCU_TXBUF_DATA_800_LSB)
#define TXPCU_TXBUF_DATA_800_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_800_LSB) & TXPCU_TXBUF_DATA_800_MASK)
#define TXPCU_TXBUF_DATA_800_RESET                                             0x0
#define TXPCU_TXBUF_800_ADDRESS                                                (0x1c80 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_800_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_800_RESET                                                  0x0

// 0x1c84 (TXPCU_TXBUF_801)
#define TXPCU_TXBUF_DATA_801_LSB                                               0
#define TXPCU_TXBUF_DATA_801_MSB                                               31
#define TXPCU_TXBUF_DATA_801_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_801_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_801_MASK) >> TXPCU_TXBUF_DATA_801_LSB)
#define TXPCU_TXBUF_DATA_801_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_801_LSB) & TXPCU_TXBUF_DATA_801_MASK)
#define TXPCU_TXBUF_DATA_801_RESET                                             0x0
#define TXPCU_TXBUF_801_ADDRESS                                                (0x1c84 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_801_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_801_RESET                                                  0x0

// 0x1c88 (TXPCU_TXBUF_802)
#define TXPCU_TXBUF_DATA_802_LSB                                               0
#define TXPCU_TXBUF_DATA_802_MSB                                               31
#define TXPCU_TXBUF_DATA_802_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_802_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_802_MASK) >> TXPCU_TXBUF_DATA_802_LSB)
#define TXPCU_TXBUF_DATA_802_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_802_LSB) & TXPCU_TXBUF_DATA_802_MASK)
#define TXPCU_TXBUF_DATA_802_RESET                                             0x0
#define TXPCU_TXBUF_802_ADDRESS                                                (0x1c88 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_802_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_802_RESET                                                  0x0

// 0x1c8c (TXPCU_TXBUF_803)
#define TXPCU_TXBUF_DATA_803_LSB                                               0
#define TXPCU_TXBUF_DATA_803_MSB                                               31
#define TXPCU_TXBUF_DATA_803_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_803_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_803_MASK) >> TXPCU_TXBUF_DATA_803_LSB)
#define TXPCU_TXBUF_DATA_803_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_803_LSB) & TXPCU_TXBUF_DATA_803_MASK)
#define TXPCU_TXBUF_DATA_803_RESET                                             0x0
#define TXPCU_TXBUF_803_ADDRESS                                                (0x1c8c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_803_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_803_RESET                                                  0x0

// 0x1c90 (TXPCU_TXBUF_804)
#define TXPCU_TXBUF_DATA_804_LSB                                               0
#define TXPCU_TXBUF_DATA_804_MSB                                               31
#define TXPCU_TXBUF_DATA_804_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_804_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_804_MASK) >> TXPCU_TXBUF_DATA_804_LSB)
#define TXPCU_TXBUF_DATA_804_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_804_LSB) & TXPCU_TXBUF_DATA_804_MASK)
#define TXPCU_TXBUF_DATA_804_RESET                                             0x0
#define TXPCU_TXBUF_804_ADDRESS                                                (0x1c90 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_804_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_804_RESET                                                  0x0

// 0x1c94 (TXPCU_TXBUF_805)
#define TXPCU_TXBUF_DATA_805_LSB                                               0
#define TXPCU_TXBUF_DATA_805_MSB                                               31
#define TXPCU_TXBUF_DATA_805_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_805_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_805_MASK) >> TXPCU_TXBUF_DATA_805_LSB)
#define TXPCU_TXBUF_DATA_805_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_805_LSB) & TXPCU_TXBUF_DATA_805_MASK)
#define TXPCU_TXBUF_DATA_805_RESET                                             0x0
#define TXPCU_TXBUF_805_ADDRESS                                                (0x1c94 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_805_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_805_RESET                                                  0x0

// 0x1c98 (TXPCU_TXBUF_806)
#define TXPCU_TXBUF_DATA_806_LSB                                               0
#define TXPCU_TXBUF_DATA_806_MSB                                               31
#define TXPCU_TXBUF_DATA_806_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_806_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_806_MASK) >> TXPCU_TXBUF_DATA_806_LSB)
#define TXPCU_TXBUF_DATA_806_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_806_LSB) & TXPCU_TXBUF_DATA_806_MASK)
#define TXPCU_TXBUF_DATA_806_RESET                                             0x0
#define TXPCU_TXBUF_806_ADDRESS                                                (0x1c98 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_806_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_806_RESET                                                  0x0

// 0x1c9c (TXPCU_TXBUF_807)
#define TXPCU_TXBUF_DATA_807_LSB                                               0
#define TXPCU_TXBUF_DATA_807_MSB                                               31
#define TXPCU_TXBUF_DATA_807_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_807_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_807_MASK) >> TXPCU_TXBUF_DATA_807_LSB)
#define TXPCU_TXBUF_DATA_807_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_807_LSB) & TXPCU_TXBUF_DATA_807_MASK)
#define TXPCU_TXBUF_DATA_807_RESET                                             0x0
#define TXPCU_TXBUF_807_ADDRESS                                                (0x1c9c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_807_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_807_RESET                                                  0x0

// 0x1ca0 (TXPCU_TXBUF_808)
#define TXPCU_TXBUF_DATA_808_LSB                                               0
#define TXPCU_TXBUF_DATA_808_MSB                                               31
#define TXPCU_TXBUF_DATA_808_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_808_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_808_MASK) >> TXPCU_TXBUF_DATA_808_LSB)
#define TXPCU_TXBUF_DATA_808_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_808_LSB) & TXPCU_TXBUF_DATA_808_MASK)
#define TXPCU_TXBUF_DATA_808_RESET                                             0x0
#define TXPCU_TXBUF_808_ADDRESS                                                (0x1ca0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_808_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_808_RESET                                                  0x0

// 0x1ca4 (TXPCU_TXBUF_809)
#define TXPCU_TXBUF_DATA_809_LSB                                               0
#define TXPCU_TXBUF_DATA_809_MSB                                               31
#define TXPCU_TXBUF_DATA_809_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_809_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_809_MASK) >> TXPCU_TXBUF_DATA_809_LSB)
#define TXPCU_TXBUF_DATA_809_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_809_LSB) & TXPCU_TXBUF_DATA_809_MASK)
#define TXPCU_TXBUF_DATA_809_RESET                                             0x0
#define TXPCU_TXBUF_809_ADDRESS                                                (0x1ca4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_809_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_809_RESET                                                  0x0

// 0x1ca8 (TXPCU_TXBUF_810)
#define TXPCU_TXBUF_DATA_810_LSB                                               0
#define TXPCU_TXBUF_DATA_810_MSB                                               31
#define TXPCU_TXBUF_DATA_810_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_810_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_810_MASK) >> TXPCU_TXBUF_DATA_810_LSB)
#define TXPCU_TXBUF_DATA_810_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_810_LSB) & TXPCU_TXBUF_DATA_810_MASK)
#define TXPCU_TXBUF_DATA_810_RESET                                             0x0
#define TXPCU_TXBUF_810_ADDRESS                                                (0x1ca8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_810_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_810_RESET                                                  0x0

// 0x1cac (TXPCU_TXBUF_811)
#define TXPCU_TXBUF_DATA_811_LSB                                               0
#define TXPCU_TXBUF_DATA_811_MSB                                               31
#define TXPCU_TXBUF_DATA_811_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_811_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_811_MASK) >> TXPCU_TXBUF_DATA_811_LSB)
#define TXPCU_TXBUF_DATA_811_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_811_LSB) & TXPCU_TXBUF_DATA_811_MASK)
#define TXPCU_TXBUF_DATA_811_RESET                                             0x0
#define TXPCU_TXBUF_811_ADDRESS                                                (0x1cac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_811_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_811_RESET                                                  0x0

// 0x1cb0 (TXPCU_TXBUF_812)
#define TXPCU_TXBUF_DATA_812_LSB                                               0
#define TXPCU_TXBUF_DATA_812_MSB                                               31
#define TXPCU_TXBUF_DATA_812_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_812_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_812_MASK) >> TXPCU_TXBUF_DATA_812_LSB)
#define TXPCU_TXBUF_DATA_812_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_812_LSB) & TXPCU_TXBUF_DATA_812_MASK)
#define TXPCU_TXBUF_DATA_812_RESET                                             0x0
#define TXPCU_TXBUF_812_ADDRESS                                                (0x1cb0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_812_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_812_RESET                                                  0x0

// 0x1cb4 (TXPCU_TXBUF_813)
#define TXPCU_TXBUF_DATA_813_LSB                                               0
#define TXPCU_TXBUF_DATA_813_MSB                                               31
#define TXPCU_TXBUF_DATA_813_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_813_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_813_MASK) >> TXPCU_TXBUF_DATA_813_LSB)
#define TXPCU_TXBUF_DATA_813_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_813_LSB) & TXPCU_TXBUF_DATA_813_MASK)
#define TXPCU_TXBUF_DATA_813_RESET                                             0x0
#define TXPCU_TXBUF_813_ADDRESS                                                (0x1cb4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_813_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_813_RESET                                                  0x0

// 0x1cb8 (TXPCU_TXBUF_814)
#define TXPCU_TXBUF_DATA_814_LSB                                               0
#define TXPCU_TXBUF_DATA_814_MSB                                               31
#define TXPCU_TXBUF_DATA_814_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_814_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_814_MASK) >> TXPCU_TXBUF_DATA_814_LSB)
#define TXPCU_TXBUF_DATA_814_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_814_LSB) & TXPCU_TXBUF_DATA_814_MASK)
#define TXPCU_TXBUF_DATA_814_RESET                                             0x0
#define TXPCU_TXBUF_814_ADDRESS                                                (0x1cb8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_814_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_814_RESET                                                  0x0

// 0x1cbc (TXPCU_TXBUF_815)
#define TXPCU_TXBUF_DATA_815_LSB                                               0
#define TXPCU_TXBUF_DATA_815_MSB                                               31
#define TXPCU_TXBUF_DATA_815_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_815_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_815_MASK) >> TXPCU_TXBUF_DATA_815_LSB)
#define TXPCU_TXBUF_DATA_815_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_815_LSB) & TXPCU_TXBUF_DATA_815_MASK)
#define TXPCU_TXBUF_DATA_815_RESET                                             0x0
#define TXPCU_TXBUF_815_ADDRESS                                                (0x1cbc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_815_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_815_RESET                                                  0x0

// 0x1cc0 (TXPCU_TXBUF_816)
#define TXPCU_TXBUF_DATA_816_LSB                                               0
#define TXPCU_TXBUF_DATA_816_MSB                                               31
#define TXPCU_TXBUF_DATA_816_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_816_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_816_MASK) >> TXPCU_TXBUF_DATA_816_LSB)
#define TXPCU_TXBUF_DATA_816_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_816_LSB) & TXPCU_TXBUF_DATA_816_MASK)
#define TXPCU_TXBUF_DATA_816_RESET                                             0x0
#define TXPCU_TXBUF_816_ADDRESS                                                (0x1cc0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_816_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_816_RESET                                                  0x0

// 0x1cc4 (TXPCU_TXBUF_817)
#define TXPCU_TXBUF_DATA_817_LSB                                               0
#define TXPCU_TXBUF_DATA_817_MSB                                               31
#define TXPCU_TXBUF_DATA_817_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_817_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_817_MASK) >> TXPCU_TXBUF_DATA_817_LSB)
#define TXPCU_TXBUF_DATA_817_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_817_LSB) & TXPCU_TXBUF_DATA_817_MASK)
#define TXPCU_TXBUF_DATA_817_RESET                                             0x0
#define TXPCU_TXBUF_817_ADDRESS                                                (0x1cc4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_817_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_817_RESET                                                  0x0

// 0x1cc8 (TXPCU_TXBUF_818)
#define TXPCU_TXBUF_DATA_818_LSB                                               0
#define TXPCU_TXBUF_DATA_818_MSB                                               31
#define TXPCU_TXBUF_DATA_818_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_818_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_818_MASK) >> TXPCU_TXBUF_DATA_818_LSB)
#define TXPCU_TXBUF_DATA_818_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_818_LSB) & TXPCU_TXBUF_DATA_818_MASK)
#define TXPCU_TXBUF_DATA_818_RESET                                             0x0
#define TXPCU_TXBUF_818_ADDRESS                                                (0x1cc8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_818_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_818_RESET                                                  0x0

// 0x1ccc (TXPCU_TXBUF_819)
#define TXPCU_TXBUF_DATA_819_LSB                                               0
#define TXPCU_TXBUF_DATA_819_MSB                                               31
#define TXPCU_TXBUF_DATA_819_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_819_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_819_MASK) >> TXPCU_TXBUF_DATA_819_LSB)
#define TXPCU_TXBUF_DATA_819_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_819_LSB) & TXPCU_TXBUF_DATA_819_MASK)
#define TXPCU_TXBUF_DATA_819_RESET                                             0x0
#define TXPCU_TXBUF_819_ADDRESS                                                (0x1ccc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_819_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_819_RESET                                                  0x0

// 0x1cd0 (TXPCU_TXBUF_820)
#define TXPCU_TXBUF_DATA_820_LSB                                               0
#define TXPCU_TXBUF_DATA_820_MSB                                               31
#define TXPCU_TXBUF_DATA_820_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_820_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_820_MASK) >> TXPCU_TXBUF_DATA_820_LSB)
#define TXPCU_TXBUF_DATA_820_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_820_LSB) & TXPCU_TXBUF_DATA_820_MASK)
#define TXPCU_TXBUF_DATA_820_RESET                                             0x0
#define TXPCU_TXBUF_820_ADDRESS                                                (0x1cd0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_820_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_820_RESET                                                  0x0

// 0x1cd4 (TXPCU_TXBUF_821)
#define TXPCU_TXBUF_DATA_821_LSB                                               0
#define TXPCU_TXBUF_DATA_821_MSB                                               31
#define TXPCU_TXBUF_DATA_821_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_821_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_821_MASK) >> TXPCU_TXBUF_DATA_821_LSB)
#define TXPCU_TXBUF_DATA_821_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_821_LSB) & TXPCU_TXBUF_DATA_821_MASK)
#define TXPCU_TXBUF_DATA_821_RESET                                             0x0
#define TXPCU_TXBUF_821_ADDRESS                                                (0x1cd4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_821_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_821_RESET                                                  0x0

// 0x1cd8 (TXPCU_TXBUF_822)
#define TXPCU_TXBUF_DATA_822_LSB                                               0
#define TXPCU_TXBUF_DATA_822_MSB                                               31
#define TXPCU_TXBUF_DATA_822_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_822_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_822_MASK) >> TXPCU_TXBUF_DATA_822_LSB)
#define TXPCU_TXBUF_DATA_822_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_822_LSB) & TXPCU_TXBUF_DATA_822_MASK)
#define TXPCU_TXBUF_DATA_822_RESET                                             0x0
#define TXPCU_TXBUF_822_ADDRESS                                                (0x1cd8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_822_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_822_RESET                                                  0x0

// 0x1cdc (TXPCU_TXBUF_823)
#define TXPCU_TXBUF_DATA_823_LSB                                               0
#define TXPCU_TXBUF_DATA_823_MSB                                               31
#define TXPCU_TXBUF_DATA_823_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_823_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_823_MASK) >> TXPCU_TXBUF_DATA_823_LSB)
#define TXPCU_TXBUF_DATA_823_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_823_LSB) & TXPCU_TXBUF_DATA_823_MASK)
#define TXPCU_TXBUF_DATA_823_RESET                                             0x0
#define TXPCU_TXBUF_823_ADDRESS                                                (0x1cdc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_823_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_823_RESET                                                  0x0

// 0x1ce0 (TXPCU_TXBUF_824)
#define TXPCU_TXBUF_DATA_824_LSB                                               0
#define TXPCU_TXBUF_DATA_824_MSB                                               31
#define TXPCU_TXBUF_DATA_824_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_824_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_824_MASK) >> TXPCU_TXBUF_DATA_824_LSB)
#define TXPCU_TXBUF_DATA_824_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_824_LSB) & TXPCU_TXBUF_DATA_824_MASK)
#define TXPCU_TXBUF_DATA_824_RESET                                             0x0
#define TXPCU_TXBUF_824_ADDRESS                                                (0x1ce0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_824_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_824_RESET                                                  0x0

// 0x1ce4 (TXPCU_TXBUF_825)
#define TXPCU_TXBUF_DATA_825_LSB                                               0
#define TXPCU_TXBUF_DATA_825_MSB                                               31
#define TXPCU_TXBUF_DATA_825_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_825_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_825_MASK) >> TXPCU_TXBUF_DATA_825_LSB)
#define TXPCU_TXBUF_DATA_825_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_825_LSB) & TXPCU_TXBUF_DATA_825_MASK)
#define TXPCU_TXBUF_DATA_825_RESET                                             0x0
#define TXPCU_TXBUF_825_ADDRESS                                                (0x1ce4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_825_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_825_RESET                                                  0x0

// 0x1ce8 (TXPCU_TXBUF_826)
#define TXPCU_TXBUF_DATA_826_LSB                                               0
#define TXPCU_TXBUF_DATA_826_MSB                                               31
#define TXPCU_TXBUF_DATA_826_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_826_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_826_MASK) >> TXPCU_TXBUF_DATA_826_LSB)
#define TXPCU_TXBUF_DATA_826_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_826_LSB) & TXPCU_TXBUF_DATA_826_MASK)
#define TXPCU_TXBUF_DATA_826_RESET                                             0x0
#define TXPCU_TXBUF_826_ADDRESS                                                (0x1ce8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_826_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_826_RESET                                                  0x0

// 0x1cec (TXPCU_TXBUF_827)
#define TXPCU_TXBUF_DATA_827_LSB                                               0
#define TXPCU_TXBUF_DATA_827_MSB                                               31
#define TXPCU_TXBUF_DATA_827_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_827_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_827_MASK) >> TXPCU_TXBUF_DATA_827_LSB)
#define TXPCU_TXBUF_DATA_827_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_827_LSB) & TXPCU_TXBUF_DATA_827_MASK)
#define TXPCU_TXBUF_DATA_827_RESET                                             0x0
#define TXPCU_TXBUF_827_ADDRESS                                                (0x1cec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_827_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_827_RESET                                                  0x0

// 0x1cf0 (TXPCU_TXBUF_828)
#define TXPCU_TXBUF_DATA_828_LSB                                               0
#define TXPCU_TXBUF_DATA_828_MSB                                               31
#define TXPCU_TXBUF_DATA_828_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_828_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_828_MASK) >> TXPCU_TXBUF_DATA_828_LSB)
#define TXPCU_TXBUF_DATA_828_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_828_LSB) & TXPCU_TXBUF_DATA_828_MASK)
#define TXPCU_TXBUF_DATA_828_RESET                                             0x0
#define TXPCU_TXBUF_828_ADDRESS                                                (0x1cf0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_828_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_828_RESET                                                  0x0

// 0x1cf4 (TXPCU_TXBUF_829)
#define TXPCU_TXBUF_DATA_829_LSB                                               0
#define TXPCU_TXBUF_DATA_829_MSB                                               31
#define TXPCU_TXBUF_DATA_829_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_829_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_829_MASK) >> TXPCU_TXBUF_DATA_829_LSB)
#define TXPCU_TXBUF_DATA_829_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_829_LSB) & TXPCU_TXBUF_DATA_829_MASK)
#define TXPCU_TXBUF_DATA_829_RESET                                             0x0
#define TXPCU_TXBUF_829_ADDRESS                                                (0x1cf4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_829_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_829_RESET                                                  0x0

// 0x1cf8 (TXPCU_TXBUF_830)
#define TXPCU_TXBUF_DATA_830_LSB                                               0
#define TXPCU_TXBUF_DATA_830_MSB                                               31
#define TXPCU_TXBUF_DATA_830_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_830_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_830_MASK) >> TXPCU_TXBUF_DATA_830_LSB)
#define TXPCU_TXBUF_DATA_830_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_830_LSB) & TXPCU_TXBUF_DATA_830_MASK)
#define TXPCU_TXBUF_DATA_830_RESET                                             0x0
#define TXPCU_TXBUF_830_ADDRESS                                                (0x1cf8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_830_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_830_RESET                                                  0x0

// 0x1cfc (TXPCU_TXBUF_831)
#define TXPCU_TXBUF_DATA_831_LSB                                               0
#define TXPCU_TXBUF_DATA_831_MSB                                               31
#define TXPCU_TXBUF_DATA_831_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_831_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_831_MASK) >> TXPCU_TXBUF_DATA_831_LSB)
#define TXPCU_TXBUF_DATA_831_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_831_LSB) & TXPCU_TXBUF_DATA_831_MASK)
#define TXPCU_TXBUF_DATA_831_RESET                                             0x0
#define TXPCU_TXBUF_831_ADDRESS                                                (0x1cfc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_831_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_831_RESET                                                  0x0

// 0x1d00 (TXPCU_TXBUF_832)
#define TXPCU_TXBUF_DATA_832_LSB                                               0
#define TXPCU_TXBUF_DATA_832_MSB                                               31
#define TXPCU_TXBUF_DATA_832_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_832_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_832_MASK) >> TXPCU_TXBUF_DATA_832_LSB)
#define TXPCU_TXBUF_DATA_832_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_832_LSB) & TXPCU_TXBUF_DATA_832_MASK)
#define TXPCU_TXBUF_DATA_832_RESET                                             0x0
#define TXPCU_TXBUF_832_ADDRESS                                                (0x1d00 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_832_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_832_RESET                                                  0x0

// 0x1d04 (TXPCU_TXBUF_833)
#define TXPCU_TXBUF_DATA_833_LSB                                               0
#define TXPCU_TXBUF_DATA_833_MSB                                               31
#define TXPCU_TXBUF_DATA_833_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_833_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_833_MASK) >> TXPCU_TXBUF_DATA_833_LSB)
#define TXPCU_TXBUF_DATA_833_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_833_LSB) & TXPCU_TXBUF_DATA_833_MASK)
#define TXPCU_TXBUF_DATA_833_RESET                                             0x0
#define TXPCU_TXBUF_833_ADDRESS                                                (0x1d04 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_833_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_833_RESET                                                  0x0

// 0x1d08 (TXPCU_TXBUF_834)
#define TXPCU_TXBUF_DATA_834_LSB                                               0
#define TXPCU_TXBUF_DATA_834_MSB                                               31
#define TXPCU_TXBUF_DATA_834_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_834_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_834_MASK) >> TXPCU_TXBUF_DATA_834_LSB)
#define TXPCU_TXBUF_DATA_834_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_834_LSB) & TXPCU_TXBUF_DATA_834_MASK)
#define TXPCU_TXBUF_DATA_834_RESET                                             0x0
#define TXPCU_TXBUF_834_ADDRESS                                                (0x1d08 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_834_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_834_RESET                                                  0x0

// 0x1d0c (TXPCU_TXBUF_835)
#define TXPCU_TXBUF_DATA_835_LSB                                               0
#define TXPCU_TXBUF_DATA_835_MSB                                               31
#define TXPCU_TXBUF_DATA_835_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_835_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_835_MASK) >> TXPCU_TXBUF_DATA_835_LSB)
#define TXPCU_TXBUF_DATA_835_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_835_LSB) & TXPCU_TXBUF_DATA_835_MASK)
#define TXPCU_TXBUF_DATA_835_RESET                                             0x0
#define TXPCU_TXBUF_835_ADDRESS                                                (0x1d0c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_835_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_835_RESET                                                  0x0

// 0x1d10 (TXPCU_TXBUF_836)
#define TXPCU_TXBUF_DATA_836_LSB                                               0
#define TXPCU_TXBUF_DATA_836_MSB                                               31
#define TXPCU_TXBUF_DATA_836_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_836_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_836_MASK) >> TXPCU_TXBUF_DATA_836_LSB)
#define TXPCU_TXBUF_DATA_836_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_836_LSB) & TXPCU_TXBUF_DATA_836_MASK)
#define TXPCU_TXBUF_DATA_836_RESET                                             0x0
#define TXPCU_TXBUF_836_ADDRESS                                                (0x1d10 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_836_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_836_RESET                                                  0x0

// 0x1d14 (TXPCU_TXBUF_837)
#define TXPCU_TXBUF_DATA_837_LSB                                               0
#define TXPCU_TXBUF_DATA_837_MSB                                               31
#define TXPCU_TXBUF_DATA_837_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_837_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_837_MASK) >> TXPCU_TXBUF_DATA_837_LSB)
#define TXPCU_TXBUF_DATA_837_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_837_LSB) & TXPCU_TXBUF_DATA_837_MASK)
#define TXPCU_TXBUF_DATA_837_RESET                                             0x0
#define TXPCU_TXBUF_837_ADDRESS                                                (0x1d14 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_837_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_837_RESET                                                  0x0

// 0x1d18 (TXPCU_TXBUF_838)
#define TXPCU_TXBUF_DATA_838_LSB                                               0
#define TXPCU_TXBUF_DATA_838_MSB                                               31
#define TXPCU_TXBUF_DATA_838_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_838_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_838_MASK) >> TXPCU_TXBUF_DATA_838_LSB)
#define TXPCU_TXBUF_DATA_838_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_838_LSB) & TXPCU_TXBUF_DATA_838_MASK)
#define TXPCU_TXBUF_DATA_838_RESET                                             0x0
#define TXPCU_TXBUF_838_ADDRESS                                                (0x1d18 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_838_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_838_RESET                                                  0x0

// 0x1d1c (TXPCU_TXBUF_839)
#define TXPCU_TXBUF_DATA_839_LSB                                               0
#define TXPCU_TXBUF_DATA_839_MSB                                               31
#define TXPCU_TXBUF_DATA_839_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_839_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_839_MASK) >> TXPCU_TXBUF_DATA_839_LSB)
#define TXPCU_TXBUF_DATA_839_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_839_LSB) & TXPCU_TXBUF_DATA_839_MASK)
#define TXPCU_TXBUF_DATA_839_RESET                                             0x0
#define TXPCU_TXBUF_839_ADDRESS                                                (0x1d1c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_839_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_839_RESET                                                  0x0

// 0x1d20 (TXPCU_TXBUF_840)
#define TXPCU_TXBUF_DATA_840_LSB                                               0
#define TXPCU_TXBUF_DATA_840_MSB                                               31
#define TXPCU_TXBUF_DATA_840_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_840_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_840_MASK) >> TXPCU_TXBUF_DATA_840_LSB)
#define TXPCU_TXBUF_DATA_840_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_840_LSB) & TXPCU_TXBUF_DATA_840_MASK)
#define TXPCU_TXBUF_DATA_840_RESET                                             0x0
#define TXPCU_TXBUF_840_ADDRESS                                                (0x1d20 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_840_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_840_RESET                                                  0x0

// 0x1d24 (TXPCU_TXBUF_841)
#define TXPCU_TXBUF_DATA_841_LSB                                               0
#define TXPCU_TXBUF_DATA_841_MSB                                               31
#define TXPCU_TXBUF_DATA_841_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_841_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_841_MASK) >> TXPCU_TXBUF_DATA_841_LSB)
#define TXPCU_TXBUF_DATA_841_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_841_LSB) & TXPCU_TXBUF_DATA_841_MASK)
#define TXPCU_TXBUF_DATA_841_RESET                                             0x0
#define TXPCU_TXBUF_841_ADDRESS                                                (0x1d24 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_841_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_841_RESET                                                  0x0

// 0x1d28 (TXPCU_TXBUF_842)
#define TXPCU_TXBUF_DATA_842_LSB                                               0
#define TXPCU_TXBUF_DATA_842_MSB                                               31
#define TXPCU_TXBUF_DATA_842_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_842_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_842_MASK) >> TXPCU_TXBUF_DATA_842_LSB)
#define TXPCU_TXBUF_DATA_842_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_842_LSB) & TXPCU_TXBUF_DATA_842_MASK)
#define TXPCU_TXBUF_DATA_842_RESET                                             0x0
#define TXPCU_TXBUF_842_ADDRESS                                                (0x1d28 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_842_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_842_RESET                                                  0x0

// 0x1d2c (TXPCU_TXBUF_843)
#define TXPCU_TXBUF_DATA_843_LSB                                               0
#define TXPCU_TXBUF_DATA_843_MSB                                               31
#define TXPCU_TXBUF_DATA_843_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_843_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_843_MASK) >> TXPCU_TXBUF_DATA_843_LSB)
#define TXPCU_TXBUF_DATA_843_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_843_LSB) & TXPCU_TXBUF_DATA_843_MASK)
#define TXPCU_TXBUF_DATA_843_RESET                                             0x0
#define TXPCU_TXBUF_843_ADDRESS                                                (0x1d2c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_843_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_843_RESET                                                  0x0

// 0x1d30 (TXPCU_TXBUF_844)
#define TXPCU_TXBUF_DATA_844_LSB                                               0
#define TXPCU_TXBUF_DATA_844_MSB                                               31
#define TXPCU_TXBUF_DATA_844_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_844_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_844_MASK) >> TXPCU_TXBUF_DATA_844_LSB)
#define TXPCU_TXBUF_DATA_844_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_844_LSB) & TXPCU_TXBUF_DATA_844_MASK)
#define TXPCU_TXBUF_DATA_844_RESET                                             0x0
#define TXPCU_TXBUF_844_ADDRESS                                                (0x1d30 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_844_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_844_RESET                                                  0x0

// 0x1d34 (TXPCU_TXBUF_845)
#define TXPCU_TXBUF_DATA_845_LSB                                               0
#define TXPCU_TXBUF_DATA_845_MSB                                               31
#define TXPCU_TXBUF_DATA_845_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_845_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_845_MASK) >> TXPCU_TXBUF_DATA_845_LSB)
#define TXPCU_TXBUF_DATA_845_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_845_LSB) & TXPCU_TXBUF_DATA_845_MASK)
#define TXPCU_TXBUF_DATA_845_RESET                                             0x0
#define TXPCU_TXBUF_845_ADDRESS                                                (0x1d34 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_845_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_845_RESET                                                  0x0

// 0x1d38 (TXPCU_TXBUF_846)
#define TXPCU_TXBUF_DATA_846_LSB                                               0
#define TXPCU_TXBUF_DATA_846_MSB                                               31
#define TXPCU_TXBUF_DATA_846_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_846_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_846_MASK) >> TXPCU_TXBUF_DATA_846_LSB)
#define TXPCU_TXBUF_DATA_846_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_846_LSB) & TXPCU_TXBUF_DATA_846_MASK)
#define TXPCU_TXBUF_DATA_846_RESET                                             0x0
#define TXPCU_TXBUF_846_ADDRESS                                                (0x1d38 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_846_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_846_RESET                                                  0x0

// 0x1d3c (TXPCU_TXBUF_847)
#define TXPCU_TXBUF_DATA_847_LSB                                               0
#define TXPCU_TXBUF_DATA_847_MSB                                               31
#define TXPCU_TXBUF_DATA_847_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_847_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_847_MASK) >> TXPCU_TXBUF_DATA_847_LSB)
#define TXPCU_TXBUF_DATA_847_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_847_LSB) & TXPCU_TXBUF_DATA_847_MASK)
#define TXPCU_TXBUF_DATA_847_RESET                                             0x0
#define TXPCU_TXBUF_847_ADDRESS                                                (0x1d3c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_847_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_847_RESET                                                  0x0

// 0x1d40 (TXPCU_TXBUF_848)
#define TXPCU_TXBUF_DATA_848_LSB                                               0
#define TXPCU_TXBUF_DATA_848_MSB                                               31
#define TXPCU_TXBUF_DATA_848_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_848_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_848_MASK) >> TXPCU_TXBUF_DATA_848_LSB)
#define TXPCU_TXBUF_DATA_848_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_848_LSB) & TXPCU_TXBUF_DATA_848_MASK)
#define TXPCU_TXBUF_DATA_848_RESET                                             0x0
#define TXPCU_TXBUF_848_ADDRESS                                                (0x1d40 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_848_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_848_RESET                                                  0x0

// 0x1d44 (TXPCU_TXBUF_849)
#define TXPCU_TXBUF_DATA_849_LSB                                               0
#define TXPCU_TXBUF_DATA_849_MSB                                               31
#define TXPCU_TXBUF_DATA_849_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_849_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_849_MASK) >> TXPCU_TXBUF_DATA_849_LSB)
#define TXPCU_TXBUF_DATA_849_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_849_LSB) & TXPCU_TXBUF_DATA_849_MASK)
#define TXPCU_TXBUF_DATA_849_RESET                                             0x0
#define TXPCU_TXBUF_849_ADDRESS                                                (0x1d44 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_849_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_849_RESET                                                  0x0

// 0x1d48 (TXPCU_TXBUF_850)
#define TXPCU_TXBUF_DATA_850_LSB                                               0
#define TXPCU_TXBUF_DATA_850_MSB                                               31
#define TXPCU_TXBUF_DATA_850_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_850_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_850_MASK) >> TXPCU_TXBUF_DATA_850_LSB)
#define TXPCU_TXBUF_DATA_850_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_850_LSB) & TXPCU_TXBUF_DATA_850_MASK)
#define TXPCU_TXBUF_DATA_850_RESET                                             0x0
#define TXPCU_TXBUF_850_ADDRESS                                                (0x1d48 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_850_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_850_RESET                                                  0x0

// 0x1d4c (TXPCU_TXBUF_851)
#define TXPCU_TXBUF_DATA_851_LSB                                               0
#define TXPCU_TXBUF_DATA_851_MSB                                               31
#define TXPCU_TXBUF_DATA_851_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_851_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_851_MASK) >> TXPCU_TXBUF_DATA_851_LSB)
#define TXPCU_TXBUF_DATA_851_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_851_LSB) & TXPCU_TXBUF_DATA_851_MASK)
#define TXPCU_TXBUF_DATA_851_RESET                                             0x0
#define TXPCU_TXBUF_851_ADDRESS                                                (0x1d4c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_851_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_851_RESET                                                  0x0

// 0x1d50 (TXPCU_TXBUF_852)
#define TXPCU_TXBUF_DATA_852_LSB                                               0
#define TXPCU_TXBUF_DATA_852_MSB                                               31
#define TXPCU_TXBUF_DATA_852_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_852_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_852_MASK) >> TXPCU_TXBUF_DATA_852_LSB)
#define TXPCU_TXBUF_DATA_852_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_852_LSB) & TXPCU_TXBUF_DATA_852_MASK)
#define TXPCU_TXBUF_DATA_852_RESET                                             0x0
#define TXPCU_TXBUF_852_ADDRESS                                                (0x1d50 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_852_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_852_RESET                                                  0x0

// 0x1d54 (TXPCU_TXBUF_853)
#define TXPCU_TXBUF_DATA_853_LSB                                               0
#define TXPCU_TXBUF_DATA_853_MSB                                               31
#define TXPCU_TXBUF_DATA_853_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_853_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_853_MASK) >> TXPCU_TXBUF_DATA_853_LSB)
#define TXPCU_TXBUF_DATA_853_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_853_LSB) & TXPCU_TXBUF_DATA_853_MASK)
#define TXPCU_TXBUF_DATA_853_RESET                                             0x0
#define TXPCU_TXBUF_853_ADDRESS                                                (0x1d54 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_853_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_853_RESET                                                  0x0

// 0x1d58 (TXPCU_TXBUF_854)
#define TXPCU_TXBUF_DATA_854_LSB                                               0
#define TXPCU_TXBUF_DATA_854_MSB                                               31
#define TXPCU_TXBUF_DATA_854_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_854_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_854_MASK) >> TXPCU_TXBUF_DATA_854_LSB)
#define TXPCU_TXBUF_DATA_854_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_854_LSB) & TXPCU_TXBUF_DATA_854_MASK)
#define TXPCU_TXBUF_DATA_854_RESET                                             0x0
#define TXPCU_TXBUF_854_ADDRESS                                                (0x1d58 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_854_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_854_RESET                                                  0x0

// 0x1d5c (TXPCU_TXBUF_855)
#define TXPCU_TXBUF_DATA_855_LSB                                               0
#define TXPCU_TXBUF_DATA_855_MSB                                               31
#define TXPCU_TXBUF_DATA_855_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_855_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_855_MASK) >> TXPCU_TXBUF_DATA_855_LSB)
#define TXPCU_TXBUF_DATA_855_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_855_LSB) & TXPCU_TXBUF_DATA_855_MASK)
#define TXPCU_TXBUF_DATA_855_RESET                                             0x0
#define TXPCU_TXBUF_855_ADDRESS                                                (0x1d5c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_855_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_855_RESET                                                  0x0

// 0x1d60 (TXPCU_TXBUF_856)
#define TXPCU_TXBUF_DATA_856_LSB                                               0
#define TXPCU_TXBUF_DATA_856_MSB                                               31
#define TXPCU_TXBUF_DATA_856_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_856_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_856_MASK) >> TXPCU_TXBUF_DATA_856_LSB)
#define TXPCU_TXBUF_DATA_856_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_856_LSB) & TXPCU_TXBUF_DATA_856_MASK)
#define TXPCU_TXBUF_DATA_856_RESET                                             0x0
#define TXPCU_TXBUF_856_ADDRESS                                                (0x1d60 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_856_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_856_RESET                                                  0x0

// 0x1d64 (TXPCU_TXBUF_857)
#define TXPCU_TXBUF_DATA_857_LSB                                               0
#define TXPCU_TXBUF_DATA_857_MSB                                               31
#define TXPCU_TXBUF_DATA_857_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_857_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_857_MASK) >> TXPCU_TXBUF_DATA_857_LSB)
#define TXPCU_TXBUF_DATA_857_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_857_LSB) & TXPCU_TXBUF_DATA_857_MASK)
#define TXPCU_TXBUF_DATA_857_RESET                                             0x0
#define TXPCU_TXBUF_857_ADDRESS                                                (0x1d64 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_857_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_857_RESET                                                  0x0

// 0x1d68 (TXPCU_TXBUF_858)
#define TXPCU_TXBUF_DATA_858_LSB                                               0
#define TXPCU_TXBUF_DATA_858_MSB                                               31
#define TXPCU_TXBUF_DATA_858_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_858_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_858_MASK) >> TXPCU_TXBUF_DATA_858_LSB)
#define TXPCU_TXBUF_DATA_858_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_858_LSB) & TXPCU_TXBUF_DATA_858_MASK)
#define TXPCU_TXBUF_DATA_858_RESET                                             0x0
#define TXPCU_TXBUF_858_ADDRESS                                                (0x1d68 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_858_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_858_RESET                                                  0x0

// 0x1d6c (TXPCU_TXBUF_859)
#define TXPCU_TXBUF_DATA_859_LSB                                               0
#define TXPCU_TXBUF_DATA_859_MSB                                               31
#define TXPCU_TXBUF_DATA_859_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_859_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_859_MASK) >> TXPCU_TXBUF_DATA_859_LSB)
#define TXPCU_TXBUF_DATA_859_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_859_LSB) & TXPCU_TXBUF_DATA_859_MASK)
#define TXPCU_TXBUF_DATA_859_RESET                                             0x0
#define TXPCU_TXBUF_859_ADDRESS                                                (0x1d6c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_859_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_859_RESET                                                  0x0

// 0x1d70 (TXPCU_TXBUF_860)
#define TXPCU_TXBUF_DATA_860_LSB                                               0
#define TXPCU_TXBUF_DATA_860_MSB                                               31
#define TXPCU_TXBUF_DATA_860_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_860_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_860_MASK) >> TXPCU_TXBUF_DATA_860_LSB)
#define TXPCU_TXBUF_DATA_860_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_860_LSB) & TXPCU_TXBUF_DATA_860_MASK)
#define TXPCU_TXBUF_DATA_860_RESET                                             0x0
#define TXPCU_TXBUF_860_ADDRESS                                                (0x1d70 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_860_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_860_RESET                                                  0x0

// 0x1d74 (TXPCU_TXBUF_861)
#define TXPCU_TXBUF_DATA_861_LSB                                               0
#define TXPCU_TXBUF_DATA_861_MSB                                               31
#define TXPCU_TXBUF_DATA_861_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_861_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_861_MASK) >> TXPCU_TXBUF_DATA_861_LSB)
#define TXPCU_TXBUF_DATA_861_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_861_LSB) & TXPCU_TXBUF_DATA_861_MASK)
#define TXPCU_TXBUF_DATA_861_RESET                                             0x0
#define TXPCU_TXBUF_861_ADDRESS                                                (0x1d74 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_861_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_861_RESET                                                  0x0

// 0x1d78 (TXPCU_TXBUF_862)
#define TXPCU_TXBUF_DATA_862_LSB                                               0
#define TXPCU_TXBUF_DATA_862_MSB                                               31
#define TXPCU_TXBUF_DATA_862_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_862_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_862_MASK) >> TXPCU_TXBUF_DATA_862_LSB)
#define TXPCU_TXBUF_DATA_862_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_862_LSB) & TXPCU_TXBUF_DATA_862_MASK)
#define TXPCU_TXBUF_DATA_862_RESET                                             0x0
#define TXPCU_TXBUF_862_ADDRESS                                                (0x1d78 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_862_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_862_RESET                                                  0x0

// 0x1d7c (TXPCU_TXBUF_863)
#define TXPCU_TXBUF_DATA_863_LSB                                               0
#define TXPCU_TXBUF_DATA_863_MSB                                               31
#define TXPCU_TXBUF_DATA_863_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_863_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_863_MASK) >> TXPCU_TXBUF_DATA_863_LSB)
#define TXPCU_TXBUF_DATA_863_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_863_LSB) & TXPCU_TXBUF_DATA_863_MASK)
#define TXPCU_TXBUF_DATA_863_RESET                                             0x0
#define TXPCU_TXBUF_863_ADDRESS                                                (0x1d7c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_863_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_863_RESET                                                  0x0

// 0x1d80 (TXPCU_TXBUF_864)
#define TXPCU_TXBUF_DATA_864_LSB                                               0
#define TXPCU_TXBUF_DATA_864_MSB                                               31
#define TXPCU_TXBUF_DATA_864_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_864_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_864_MASK) >> TXPCU_TXBUF_DATA_864_LSB)
#define TXPCU_TXBUF_DATA_864_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_864_LSB) & TXPCU_TXBUF_DATA_864_MASK)
#define TXPCU_TXBUF_DATA_864_RESET                                             0x0
#define TXPCU_TXBUF_864_ADDRESS                                                (0x1d80 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_864_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_864_RESET                                                  0x0

// 0x1d84 (TXPCU_TXBUF_865)
#define TXPCU_TXBUF_DATA_865_LSB                                               0
#define TXPCU_TXBUF_DATA_865_MSB                                               31
#define TXPCU_TXBUF_DATA_865_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_865_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_865_MASK) >> TXPCU_TXBUF_DATA_865_LSB)
#define TXPCU_TXBUF_DATA_865_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_865_LSB) & TXPCU_TXBUF_DATA_865_MASK)
#define TXPCU_TXBUF_DATA_865_RESET                                             0x0
#define TXPCU_TXBUF_865_ADDRESS                                                (0x1d84 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_865_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_865_RESET                                                  0x0

// 0x1d88 (TXPCU_TXBUF_866)
#define TXPCU_TXBUF_DATA_866_LSB                                               0
#define TXPCU_TXBUF_DATA_866_MSB                                               31
#define TXPCU_TXBUF_DATA_866_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_866_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_866_MASK) >> TXPCU_TXBUF_DATA_866_LSB)
#define TXPCU_TXBUF_DATA_866_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_866_LSB) & TXPCU_TXBUF_DATA_866_MASK)
#define TXPCU_TXBUF_DATA_866_RESET                                             0x0
#define TXPCU_TXBUF_866_ADDRESS                                                (0x1d88 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_866_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_866_RESET                                                  0x0

// 0x1d8c (TXPCU_TXBUF_867)
#define TXPCU_TXBUF_DATA_867_LSB                                               0
#define TXPCU_TXBUF_DATA_867_MSB                                               31
#define TXPCU_TXBUF_DATA_867_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_867_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_867_MASK) >> TXPCU_TXBUF_DATA_867_LSB)
#define TXPCU_TXBUF_DATA_867_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_867_LSB) & TXPCU_TXBUF_DATA_867_MASK)
#define TXPCU_TXBUF_DATA_867_RESET                                             0x0
#define TXPCU_TXBUF_867_ADDRESS                                                (0x1d8c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_867_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_867_RESET                                                  0x0

// 0x1d90 (TXPCU_TXBUF_868)
#define TXPCU_TXBUF_DATA_868_LSB                                               0
#define TXPCU_TXBUF_DATA_868_MSB                                               31
#define TXPCU_TXBUF_DATA_868_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_868_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_868_MASK) >> TXPCU_TXBUF_DATA_868_LSB)
#define TXPCU_TXBUF_DATA_868_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_868_LSB) & TXPCU_TXBUF_DATA_868_MASK)
#define TXPCU_TXBUF_DATA_868_RESET                                             0x0
#define TXPCU_TXBUF_868_ADDRESS                                                (0x1d90 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_868_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_868_RESET                                                  0x0

// 0x1d94 (TXPCU_TXBUF_869)
#define TXPCU_TXBUF_DATA_869_LSB                                               0
#define TXPCU_TXBUF_DATA_869_MSB                                               31
#define TXPCU_TXBUF_DATA_869_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_869_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_869_MASK) >> TXPCU_TXBUF_DATA_869_LSB)
#define TXPCU_TXBUF_DATA_869_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_869_LSB) & TXPCU_TXBUF_DATA_869_MASK)
#define TXPCU_TXBUF_DATA_869_RESET                                             0x0
#define TXPCU_TXBUF_869_ADDRESS                                                (0x1d94 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_869_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_869_RESET                                                  0x0

// 0x1d98 (TXPCU_TXBUF_870)
#define TXPCU_TXBUF_DATA_870_LSB                                               0
#define TXPCU_TXBUF_DATA_870_MSB                                               31
#define TXPCU_TXBUF_DATA_870_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_870_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_870_MASK) >> TXPCU_TXBUF_DATA_870_LSB)
#define TXPCU_TXBUF_DATA_870_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_870_LSB) & TXPCU_TXBUF_DATA_870_MASK)
#define TXPCU_TXBUF_DATA_870_RESET                                             0x0
#define TXPCU_TXBUF_870_ADDRESS                                                (0x1d98 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_870_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_870_RESET                                                  0x0

// 0x1d9c (TXPCU_TXBUF_871)
#define TXPCU_TXBUF_DATA_871_LSB                                               0
#define TXPCU_TXBUF_DATA_871_MSB                                               31
#define TXPCU_TXBUF_DATA_871_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_871_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_871_MASK) >> TXPCU_TXBUF_DATA_871_LSB)
#define TXPCU_TXBUF_DATA_871_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_871_LSB) & TXPCU_TXBUF_DATA_871_MASK)
#define TXPCU_TXBUF_DATA_871_RESET                                             0x0
#define TXPCU_TXBUF_871_ADDRESS                                                (0x1d9c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_871_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_871_RESET                                                  0x0

// 0x1da0 (TXPCU_TXBUF_872)
#define TXPCU_TXBUF_DATA_872_LSB                                               0
#define TXPCU_TXBUF_DATA_872_MSB                                               31
#define TXPCU_TXBUF_DATA_872_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_872_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_872_MASK) >> TXPCU_TXBUF_DATA_872_LSB)
#define TXPCU_TXBUF_DATA_872_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_872_LSB) & TXPCU_TXBUF_DATA_872_MASK)
#define TXPCU_TXBUF_DATA_872_RESET                                             0x0
#define TXPCU_TXBUF_872_ADDRESS                                                (0x1da0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_872_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_872_RESET                                                  0x0

// 0x1da4 (TXPCU_TXBUF_873)
#define TXPCU_TXBUF_DATA_873_LSB                                               0
#define TXPCU_TXBUF_DATA_873_MSB                                               31
#define TXPCU_TXBUF_DATA_873_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_873_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_873_MASK) >> TXPCU_TXBUF_DATA_873_LSB)
#define TXPCU_TXBUF_DATA_873_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_873_LSB) & TXPCU_TXBUF_DATA_873_MASK)
#define TXPCU_TXBUF_DATA_873_RESET                                             0x0
#define TXPCU_TXBUF_873_ADDRESS                                                (0x1da4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_873_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_873_RESET                                                  0x0

// 0x1da8 (TXPCU_TXBUF_874)
#define TXPCU_TXBUF_DATA_874_LSB                                               0
#define TXPCU_TXBUF_DATA_874_MSB                                               31
#define TXPCU_TXBUF_DATA_874_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_874_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_874_MASK) >> TXPCU_TXBUF_DATA_874_LSB)
#define TXPCU_TXBUF_DATA_874_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_874_LSB) & TXPCU_TXBUF_DATA_874_MASK)
#define TXPCU_TXBUF_DATA_874_RESET                                             0x0
#define TXPCU_TXBUF_874_ADDRESS                                                (0x1da8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_874_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_874_RESET                                                  0x0

// 0x1dac (TXPCU_TXBUF_875)
#define TXPCU_TXBUF_DATA_875_LSB                                               0
#define TXPCU_TXBUF_DATA_875_MSB                                               31
#define TXPCU_TXBUF_DATA_875_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_875_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_875_MASK) >> TXPCU_TXBUF_DATA_875_LSB)
#define TXPCU_TXBUF_DATA_875_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_875_LSB) & TXPCU_TXBUF_DATA_875_MASK)
#define TXPCU_TXBUF_DATA_875_RESET                                             0x0
#define TXPCU_TXBUF_875_ADDRESS                                                (0x1dac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_875_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_875_RESET                                                  0x0

// 0x1db0 (TXPCU_TXBUF_876)
#define TXPCU_TXBUF_DATA_876_LSB                                               0
#define TXPCU_TXBUF_DATA_876_MSB                                               31
#define TXPCU_TXBUF_DATA_876_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_876_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_876_MASK) >> TXPCU_TXBUF_DATA_876_LSB)
#define TXPCU_TXBUF_DATA_876_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_876_LSB) & TXPCU_TXBUF_DATA_876_MASK)
#define TXPCU_TXBUF_DATA_876_RESET                                             0x0
#define TXPCU_TXBUF_876_ADDRESS                                                (0x1db0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_876_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_876_RESET                                                  0x0

// 0x1db4 (TXPCU_TXBUF_877)
#define TXPCU_TXBUF_DATA_877_LSB                                               0
#define TXPCU_TXBUF_DATA_877_MSB                                               31
#define TXPCU_TXBUF_DATA_877_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_877_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_877_MASK) >> TXPCU_TXBUF_DATA_877_LSB)
#define TXPCU_TXBUF_DATA_877_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_877_LSB) & TXPCU_TXBUF_DATA_877_MASK)
#define TXPCU_TXBUF_DATA_877_RESET                                             0x0
#define TXPCU_TXBUF_877_ADDRESS                                                (0x1db4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_877_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_877_RESET                                                  0x0

// 0x1db8 (TXPCU_TXBUF_878)
#define TXPCU_TXBUF_DATA_878_LSB                                               0
#define TXPCU_TXBUF_DATA_878_MSB                                               31
#define TXPCU_TXBUF_DATA_878_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_878_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_878_MASK) >> TXPCU_TXBUF_DATA_878_LSB)
#define TXPCU_TXBUF_DATA_878_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_878_LSB) & TXPCU_TXBUF_DATA_878_MASK)
#define TXPCU_TXBUF_DATA_878_RESET                                             0x0
#define TXPCU_TXBUF_878_ADDRESS                                                (0x1db8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_878_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_878_RESET                                                  0x0

// 0x1dbc (TXPCU_TXBUF_879)
#define TXPCU_TXBUF_DATA_879_LSB                                               0
#define TXPCU_TXBUF_DATA_879_MSB                                               31
#define TXPCU_TXBUF_DATA_879_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_879_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_879_MASK) >> TXPCU_TXBUF_DATA_879_LSB)
#define TXPCU_TXBUF_DATA_879_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_879_LSB) & TXPCU_TXBUF_DATA_879_MASK)
#define TXPCU_TXBUF_DATA_879_RESET                                             0x0
#define TXPCU_TXBUF_879_ADDRESS                                                (0x1dbc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_879_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_879_RESET                                                  0x0

// 0x1dc0 (TXPCU_TXBUF_880)
#define TXPCU_TXBUF_DATA_880_LSB                                               0
#define TXPCU_TXBUF_DATA_880_MSB                                               31
#define TXPCU_TXBUF_DATA_880_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_880_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_880_MASK) >> TXPCU_TXBUF_DATA_880_LSB)
#define TXPCU_TXBUF_DATA_880_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_880_LSB) & TXPCU_TXBUF_DATA_880_MASK)
#define TXPCU_TXBUF_DATA_880_RESET                                             0x0
#define TXPCU_TXBUF_880_ADDRESS                                                (0x1dc0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_880_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_880_RESET                                                  0x0

// 0x1dc4 (TXPCU_TXBUF_881)
#define TXPCU_TXBUF_DATA_881_LSB                                               0
#define TXPCU_TXBUF_DATA_881_MSB                                               31
#define TXPCU_TXBUF_DATA_881_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_881_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_881_MASK) >> TXPCU_TXBUF_DATA_881_LSB)
#define TXPCU_TXBUF_DATA_881_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_881_LSB) & TXPCU_TXBUF_DATA_881_MASK)
#define TXPCU_TXBUF_DATA_881_RESET                                             0x0
#define TXPCU_TXBUF_881_ADDRESS                                                (0x1dc4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_881_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_881_RESET                                                  0x0

// 0x1dc8 (TXPCU_TXBUF_882)
#define TXPCU_TXBUF_DATA_882_LSB                                               0
#define TXPCU_TXBUF_DATA_882_MSB                                               31
#define TXPCU_TXBUF_DATA_882_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_882_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_882_MASK) >> TXPCU_TXBUF_DATA_882_LSB)
#define TXPCU_TXBUF_DATA_882_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_882_LSB) & TXPCU_TXBUF_DATA_882_MASK)
#define TXPCU_TXBUF_DATA_882_RESET                                             0x0
#define TXPCU_TXBUF_882_ADDRESS                                                (0x1dc8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_882_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_882_RESET                                                  0x0

// 0x1dcc (TXPCU_TXBUF_883)
#define TXPCU_TXBUF_DATA_883_LSB                                               0
#define TXPCU_TXBUF_DATA_883_MSB                                               31
#define TXPCU_TXBUF_DATA_883_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_883_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_883_MASK) >> TXPCU_TXBUF_DATA_883_LSB)
#define TXPCU_TXBUF_DATA_883_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_883_LSB) & TXPCU_TXBUF_DATA_883_MASK)
#define TXPCU_TXBUF_DATA_883_RESET                                             0x0
#define TXPCU_TXBUF_883_ADDRESS                                                (0x1dcc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_883_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_883_RESET                                                  0x0

// 0x1dd0 (TXPCU_TXBUF_884)
#define TXPCU_TXBUF_DATA_884_LSB                                               0
#define TXPCU_TXBUF_DATA_884_MSB                                               31
#define TXPCU_TXBUF_DATA_884_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_884_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_884_MASK) >> TXPCU_TXBUF_DATA_884_LSB)
#define TXPCU_TXBUF_DATA_884_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_884_LSB) & TXPCU_TXBUF_DATA_884_MASK)
#define TXPCU_TXBUF_DATA_884_RESET                                             0x0
#define TXPCU_TXBUF_884_ADDRESS                                                (0x1dd0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_884_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_884_RESET                                                  0x0

// 0x1dd4 (TXPCU_TXBUF_885)
#define TXPCU_TXBUF_DATA_885_LSB                                               0
#define TXPCU_TXBUF_DATA_885_MSB                                               31
#define TXPCU_TXBUF_DATA_885_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_885_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_885_MASK) >> TXPCU_TXBUF_DATA_885_LSB)
#define TXPCU_TXBUF_DATA_885_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_885_LSB) & TXPCU_TXBUF_DATA_885_MASK)
#define TXPCU_TXBUF_DATA_885_RESET                                             0x0
#define TXPCU_TXBUF_885_ADDRESS                                                (0x1dd4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_885_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_885_RESET                                                  0x0

// 0x1dd8 (TXPCU_TXBUF_886)
#define TXPCU_TXBUF_DATA_886_LSB                                               0
#define TXPCU_TXBUF_DATA_886_MSB                                               31
#define TXPCU_TXBUF_DATA_886_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_886_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_886_MASK) >> TXPCU_TXBUF_DATA_886_LSB)
#define TXPCU_TXBUF_DATA_886_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_886_LSB) & TXPCU_TXBUF_DATA_886_MASK)
#define TXPCU_TXBUF_DATA_886_RESET                                             0x0
#define TXPCU_TXBUF_886_ADDRESS                                                (0x1dd8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_886_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_886_RESET                                                  0x0

// 0x1ddc (TXPCU_TXBUF_887)
#define TXPCU_TXBUF_DATA_887_LSB                                               0
#define TXPCU_TXBUF_DATA_887_MSB                                               31
#define TXPCU_TXBUF_DATA_887_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_887_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_887_MASK) >> TXPCU_TXBUF_DATA_887_LSB)
#define TXPCU_TXBUF_DATA_887_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_887_LSB) & TXPCU_TXBUF_DATA_887_MASK)
#define TXPCU_TXBUF_DATA_887_RESET                                             0x0
#define TXPCU_TXBUF_887_ADDRESS                                                (0x1ddc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_887_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_887_RESET                                                  0x0

// 0x1de0 (TXPCU_TXBUF_888)
#define TXPCU_TXBUF_DATA_888_LSB                                               0
#define TXPCU_TXBUF_DATA_888_MSB                                               31
#define TXPCU_TXBUF_DATA_888_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_888_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_888_MASK) >> TXPCU_TXBUF_DATA_888_LSB)
#define TXPCU_TXBUF_DATA_888_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_888_LSB) & TXPCU_TXBUF_DATA_888_MASK)
#define TXPCU_TXBUF_DATA_888_RESET                                             0x0
#define TXPCU_TXBUF_888_ADDRESS                                                (0x1de0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_888_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_888_RESET                                                  0x0

// 0x1de4 (TXPCU_TXBUF_889)
#define TXPCU_TXBUF_DATA_889_LSB                                               0
#define TXPCU_TXBUF_DATA_889_MSB                                               31
#define TXPCU_TXBUF_DATA_889_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_889_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_889_MASK) >> TXPCU_TXBUF_DATA_889_LSB)
#define TXPCU_TXBUF_DATA_889_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_889_LSB) & TXPCU_TXBUF_DATA_889_MASK)
#define TXPCU_TXBUF_DATA_889_RESET                                             0x0
#define TXPCU_TXBUF_889_ADDRESS                                                (0x1de4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_889_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_889_RESET                                                  0x0

// 0x1de8 (TXPCU_TXBUF_890)
#define TXPCU_TXBUF_DATA_890_LSB                                               0
#define TXPCU_TXBUF_DATA_890_MSB                                               31
#define TXPCU_TXBUF_DATA_890_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_890_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_890_MASK) >> TXPCU_TXBUF_DATA_890_LSB)
#define TXPCU_TXBUF_DATA_890_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_890_LSB) & TXPCU_TXBUF_DATA_890_MASK)
#define TXPCU_TXBUF_DATA_890_RESET                                             0x0
#define TXPCU_TXBUF_890_ADDRESS                                                (0x1de8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_890_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_890_RESET                                                  0x0

// 0x1dec (TXPCU_TXBUF_891)
#define TXPCU_TXBUF_DATA_891_LSB                                               0
#define TXPCU_TXBUF_DATA_891_MSB                                               31
#define TXPCU_TXBUF_DATA_891_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_891_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_891_MASK) >> TXPCU_TXBUF_DATA_891_LSB)
#define TXPCU_TXBUF_DATA_891_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_891_LSB) & TXPCU_TXBUF_DATA_891_MASK)
#define TXPCU_TXBUF_DATA_891_RESET                                             0x0
#define TXPCU_TXBUF_891_ADDRESS                                                (0x1dec + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_891_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_891_RESET                                                  0x0

// 0x1df0 (TXPCU_TXBUF_892)
#define TXPCU_TXBUF_DATA_892_LSB                                               0
#define TXPCU_TXBUF_DATA_892_MSB                                               31
#define TXPCU_TXBUF_DATA_892_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_892_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_892_MASK) >> TXPCU_TXBUF_DATA_892_LSB)
#define TXPCU_TXBUF_DATA_892_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_892_LSB) & TXPCU_TXBUF_DATA_892_MASK)
#define TXPCU_TXBUF_DATA_892_RESET                                             0x0
#define TXPCU_TXBUF_892_ADDRESS                                                (0x1df0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_892_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_892_RESET                                                  0x0

// 0x1df4 (TXPCU_TXBUF_893)
#define TXPCU_TXBUF_DATA_893_LSB                                               0
#define TXPCU_TXBUF_DATA_893_MSB                                               31
#define TXPCU_TXBUF_DATA_893_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_893_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_893_MASK) >> TXPCU_TXBUF_DATA_893_LSB)
#define TXPCU_TXBUF_DATA_893_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_893_LSB) & TXPCU_TXBUF_DATA_893_MASK)
#define TXPCU_TXBUF_DATA_893_RESET                                             0x0
#define TXPCU_TXBUF_893_ADDRESS                                                (0x1df4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_893_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_893_RESET                                                  0x0

// 0x1df8 (TXPCU_TXBUF_894)
#define TXPCU_TXBUF_DATA_894_LSB                                               0
#define TXPCU_TXBUF_DATA_894_MSB                                               31
#define TXPCU_TXBUF_DATA_894_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_894_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_894_MASK) >> TXPCU_TXBUF_DATA_894_LSB)
#define TXPCU_TXBUF_DATA_894_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_894_LSB) & TXPCU_TXBUF_DATA_894_MASK)
#define TXPCU_TXBUF_DATA_894_RESET                                             0x0
#define TXPCU_TXBUF_894_ADDRESS                                                (0x1df8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_894_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_894_RESET                                                  0x0

// 0x1dfc (TXPCU_TXBUF_895)
#define TXPCU_TXBUF_DATA_895_LSB                                               0
#define TXPCU_TXBUF_DATA_895_MSB                                               31
#define TXPCU_TXBUF_DATA_895_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_895_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_895_MASK) >> TXPCU_TXBUF_DATA_895_LSB)
#define TXPCU_TXBUF_DATA_895_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_895_LSB) & TXPCU_TXBUF_DATA_895_MASK)
#define TXPCU_TXBUF_DATA_895_RESET                                             0x0
#define TXPCU_TXBUF_895_ADDRESS                                                (0x1dfc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_895_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_895_RESET                                                  0x0

// 0x1e00 (TXPCU_TXBUF_896)
#define TXPCU_TXBUF_DATA_896_LSB                                               0
#define TXPCU_TXBUF_DATA_896_MSB                                               31
#define TXPCU_TXBUF_DATA_896_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_896_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_896_MASK) >> TXPCU_TXBUF_DATA_896_LSB)
#define TXPCU_TXBUF_DATA_896_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_896_LSB) & TXPCU_TXBUF_DATA_896_MASK)
#define TXPCU_TXBUF_DATA_896_RESET                                             0x0
#define TXPCU_TXBUF_896_ADDRESS                                                (0x1e00 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_896_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_896_RESET                                                  0x0

// 0x1e04 (TXPCU_TXBUF_897)
#define TXPCU_TXBUF_DATA_897_LSB                                               0
#define TXPCU_TXBUF_DATA_897_MSB                                               31
#define TXPCU_TXBUF_DATA_897_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_897_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_897_MASK) >> TXPCU_TXBUF_DATA_897_LSB)
#define TXPCU_TXBUF_DATA_897_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_897_LSB) & TXPCU_TXBUF_DATA_897_MASK)
#define TXPCU_TXBUF_DATA_897_RESET                                             0x0
#define TXPCU_TXBUF_897_ADDRESS                                                (0x1e04 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_897_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_897_RESET                                                  0x0

// 0x1e08 (TXPCU_TXBUF_898)
#define TXPCU_TXBUF_DATA_898_LSB                                               0
#define TXPCU_TXBUF_DATA_898_MSB                                               31
#define TXPCU_TXBUF_DATA_898_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_898_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_898_MASK) >> TXPCU_TXBUF_DATA_898_LSB)
#define TXPCU_TXBUF_DATA_898_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_898_LSB) & TXPCU_TXBUF_DATA_898_MASK)
#define TXPCU_TXBUF_DATA_898_RESET                                             0x0
#define TXPCU_TXBUF_898_ADDRESS                                                (0x1e08 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_898_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_898_RESET                                                  0x0

// 0x1e0c (TXPCU_TXBUF_899)
#define TXPCU_TXBUF_DATA_899_LSB                                               0
#define TXPCU_TXBUF_DATA_899_MSB                                               31
#define TXPCU_TXBUF_DATA_899_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_899_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_899_MASK) >> TXPCU_TXBUF_DATA_899_LSB)
#define TXPCU_TXBUF_DATA_899_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_899_LSB) & TXPCU_TXBUF_DATA_899_MASK)
#define TXPCU_TXBUF_DATA_899_RESET                                             0x0
#define TXPCU_TXBUF_899_ADDRESS                                                (0x1e0c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_899_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_899_RESET                                                  0x0

// 0x1e10 (TXPCU_TXBUF_900)
#define TXPCU_TXBUF_DATA_900_LSB                                               0
#define TXPCU_TXBUF_DATA_900_MSB                                               31
#define TXPCU_TXBUF_DATA_900_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_900_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_900_MASK) >> TXPCU_TXBUF_DATA_900_LSB)
#define TXPCU_TXBUF_DATA_900_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_900_LSB) & TXPCU_TXBUF_DATA_900_MASK)
#define TXPCU_TXBUF_DATA_900_RESET                                             0x0
#define TXPCU_TXBUF_900_ADDRESS                                                (0x1e10 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_900_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_900_RESET                                                  0x0

// 0x1e14 (TXPCU_TXBUF_901)
#define TXPCU_TXBUF_DATA_901_LSB                                               0
#define TXPCU_TXBUF_DATA_901_MSB                                               31
#define TXPCU_TXBUF_DATA_901_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_901_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_901_MASK) >> TXPCU_TXBUF_DATA_901_LSB)
#define TXPCU_TXBUF_DATA_901_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_901_LSB) & TXPCU_TXBUF_DATA_901_MASK)
#define TXPCU_TXBUF_DATA_901_RESET                                             0x0
#define TXPCU_TXBUF_901_ADDRESS                                                (0x1e14 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_901_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_901_RESET                                                  0x0

// 0x1e18 (TXPCU_TXBUF_902)
#define TXPCU_TXBUF_DATA_902_LSB                                               0
#define TXPCU_TXBUF_DATA_902_MSB                                               31
#define TXPCU_TXBUF_DATA_902_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_902_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_902_MASK) >> TXPCU_TXBUF_DATA_902_LSB)
#define TXPCU_TXBUF_DATA_902_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_902_LSB) & TXPCU_TXBUF_DATA_902_MASK)
#define TXPCU_TXBUF_DATA_902_RESET                                             0x0
#define TXPCU_TXBUF_902_ADDRESS                                                (0x1e18 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_902_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_902_RESET                                                  0x0

// 0x1e1c (TXPCU_TXBUF_903)
#define TXPCU_TXBUF_DATA_903_LSB                                               0
#define TXPCU_TXBUF_DATA_903_MSB                                               31
#define TXPCU_TXBUF_DATA_903_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_903_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_903_MASK) >> TXPCU_TXBUF_DATA_903_LSB)
#define TXPCU_TXBUF_DATA_903_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_903_LSB) & TXPCU_TXBUF_DATA_903_MASK)
#define TXPCU_TXBUF_DATA_903_RESET                                             0x0
#define TXPCU_TXBUF_903_ADDRESS                                                (0x1e1c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_903_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_903_RESET                                                  0x0

// 0x1e20 (TXPCU_TXBUF_904)
#define TXPCU_TXBUF_DATA_904_LSB                                               0
#define TXPCU_TXBUF_DATA_904_MSB                                               31
#define TXPCU_TXBUF_DATA_904_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_904_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_904_MASK) >> TXPCU_TXBUF_DATA_904_LSB)
#define TXPCU_TXBUF_DATA_904_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_904_LSB) & TXPCU_TXBUF_DATA_904_MASK)
#define TXPCU_TXBUF_DATA_904_RESET                                             0x0
#define TXPCU_TXBUF_904_ADDRESS                                                (0x1e20 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_904_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_904_RESET                                                  0x0

// 0x1e24 (TXPCU_TXBUF_905)
#define TXPCU_TXBUF_DATA_905_LSB                                               0
#define TXPCU_TXBUF_DATA_905_MSB                                               31
#define TXPCU_TXBUF_DATA_905_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_905_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_905_MASK) >> TXPCU_TXBUF_DATA_905_LSB)
#define TXPCU_TXBUF_DATA_905_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_905_LSB) & TXPCU_TXBUF_DATA_905_MASK)
#define TXPCU_TXBUF_DATA_905_RESET                                             0x0
#define TXPCU_TXBUF_905_ADDRESS                                                (0x1e24 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_905_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_905_RESET                                                  0x0

// 0x1e28 (TXPCU_TXBUF_906)
#define TXPCU_TXBUF_DATA_906_LSB                                               0
#define TXPCU_TXBUF_DATA_906_MSB                                               31
#define TXPCU_TXBUF_DATA_906_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_906_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_906_MASK) >> TXPCU_TXBUF_DATA_906_LSB)
#define TXPCU_TXBUF_DATA_906_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_906_LSB) & TXPCU_TXBUF_DATA_906_MASK)
#define TXPCU_TXBUF_DATA_906_RESET                                             0x0
#define TXPCU_TXBUF_906_ADDRESS                                                (0x1e28 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_906_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_906_RESET                                                  0x0

// 0x1e2c (TXPCU_TXBUF_907)
#define TXPCU_TXBUF_DATA_907_LSB                                               0
#define TXPCU_TXBUF_DATA_907_MSB                                               31
#define TXPCU_TXBUF_DATA_907_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_907_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_907_MASK) >> TXPCU_TXBUF_DATA_907_LSB)
#define TXPCU_TXBUF_DATA_907_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_907_LSB) & TXPCU_TXBUF_DATA_907_MASK)
#define TXPCU_TXBUF_DATA_907_RESET                                             0x0
#define TXPCU_TXBUF_907_ADDRESS                                                (0x1e2c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_907_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_907_RESET                                                  0x0

// 0x1e30 (TXPCU_TXBUF_908)
#define TXPCU_TXBUF_DATA_908_LSB                                               0
#define TXPCU_TXBUF_DATA_908_MSB                                               31
#define TXPCU_TXBUF_DATA_908_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_908_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_908_MASK) >> TXPCU_TXBUF_DATA_908_LSB)
#define TXPCU_TXBUF_DATA_908_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_908_LSB) & TXPCU_TXBUF_DATA_908_MASK)
#define TXPCU_TXBUF_DATA_908_RESET                                             0x0
#define TXPCU_TXBUF_908_ADDRESS                                                (0x1e30 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_908_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_908_RESET                                                  0x0

// 0x1e34 (TXPCU_TXBUF_909)
#define TXPCU_TXBUF_DATA_909_LSB                                               0
#define TXPCU_TXBUF_DATA_909_MSB                                               31
#define TXPCU_TXBUF_DATA_909_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_909_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_909_MASK) >> TXPCU_TXBUF_DATA_909_LSB)
#define TXPCU_TXBUF_DATA_909_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_909_LSB) & TXPCU_TXBUF_DATA_909_MASK)
#define TXPCU_TXBUF_DATA_909_RESET                                             0x0
#define TXPCU_TXBUF_909_ADDRESS                                                (0x1e34 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_909_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_909_RESET                                                  0x0

// 0x1e38 (TXPCU_TXBUF_910)
#define TXPCU_TXBUF_DATA_910_LSB                                               0
#define TXPCU_TXBUF_DATA_910_MSB                                               31
#define TXPCU_TXBUF_DATA_910_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_910_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_910_MASK) >> TXPCU_TXBUF_DATA_910_LSB)
#define TXPCU_TXBUF_DATA_910_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_910_LSB) & TXPCU_TXBUF_DATA_910_MASK)
#define TXPCU_TXBUF_DATA_910_RESET                                             0x0
#define TXPCU_TXBUF_910_ADDRESS                                                (0x1e38 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_910_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_910_RESET                                                  0x0

// 0x1e3c (TXPCU_TXBUF_911)
#define TXPCU_TXBUF_DATA_911_LSB                                               0
#define TXPCU_TXBUF_DATA_911_MSB                                               31
#define TXPCU_TXBUF_DATA_911_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_911_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_911_MASK) >> TXPCU_TXBUF_DATA_911_LSB)
#define TXPCU_TXBUF_DATA_911_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_911_LSB) & TXPCU_TXBUF_DATA_911_MASK)
#define TXPCU_TXBUF_DATA_911_RESET                                             0x0
#define TXPCU_TXBUF_911_ADDRESS                                                (0x1e3c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_911_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_911_RESET                                                  0x0

// 0x1e40 (TXPCU_TXBUF_912)
#define TXPCU_TXBUF_DATA_912_LSB                                               0
#define TXPCU_TXBUF_DATA_912_MSB                                               31
#define TXPCU_TXBUF_DATA_912_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_912_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_912_MASK) >> TXPCU_TXBUF_DATA_912_LSB)
#define TXPCU_TXBUF_DATA_912_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_912_LSB) & TXPCU_TXBUF_DATA_912_MASK)
#define TXPCU_TXBUF_DATA_912_RESET                                             0x0
#define TXPCU_TXBUF_912_ADDRESS                                                (0x1e40 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_912_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_912_RESET                                                  0x0

// 0x1e44 (TXPCU_TXBUF_913)
#define TXPCU_TXBUF_DATA_913_LSB                                               0
#define TXPCU_TXBUF_DATA_913_MSB                                               31
#define TXPCU_TXBUF_DATA_913_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_913_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_913_MASK) >> TXPCU_TXBUF_DATA_913_LSB)
#define TXPCU_TXBUF_DATA_913_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_913_LSB) & TXPCU_TXBUF_DATA_913_MASK)
#define TXPCU_TXBUF_DATA_913_RESET                                             0x0
#define TXPCU_TXBUF_913_ADDRESS                                                (0x1e44 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_913_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_913_RESET                                                  0x0

// 0x1e48 (TXPCU_TXBUF_914)
#define TXPCU_TXBUF_DATA_914_LSB                                               0
#define TXPCU_TXBUF_DATA_914_MSB                                               31
#define TXPCU_TXBUF_DATA_914_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_914_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_914_MASK) >> TXPCU_TXBUF_DATA_914_LSB)
#define TXPCU_TXBUF_DATA_914_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_914_LSB) & TXPCU_TXBUF_DATA_914_MASK)
#define TXPCU_TXBUF_DATA_914_RESET                                             0x0
#define TXPCU_TXBUF_914_ADDRESS                                                (0x1e48 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_914_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_914_RESET                                                  0x0

// 0x1e4c (TXPCU_TXBUF_915)
#define TXPCU_TXBUF_DATA_915_LSB                                               0
#define TXPCU_TXBUF_DATA_915_MSB                                               31
#define TXPCU_TXBUF_DATA_915_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_915_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_915_MASK) >> TXPCU_TXBUF_DATA_915_LSB)
#define TXPCU_TXBUF_DATA_915_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_915_LSB) & TXPCU_TXBUF_DATA_915_MASK)
#define TXPCU_TXBUF_DATA_915_RESET                                             0x0
#define TXPCU_TXBUF_915_ADDRESS                                                (0x1e4c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_915_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_915_RESET                                                  0x0

// 0x1e50 (TXPCU_TXBUF_916)
#define TXPCU_TXBUF_DATA_916_LSB                                               0
#define TXPCU_TXBUF_DATA_916_MSB                                               31
#define TXPCU_TXBUF_DATA_916_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_916_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_916_MASK) >> TXPCU_TXBUF_DATA_916_LSB)
#define TXPCU_TXBUF_DATA_916_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_916_LSB) & TXPCU_TXBUF_DATA_916_MASK)
#define TXPCU_TXBUF_DATA_916_RESET                                             0x0
#define TXPCU_TXBUF_916_ADDRESS                                                (0x1e50 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_916_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_916_RESET                                                  0x0

// 0x1e54 (TXPCU_TXBUF_917)
#define TXPCU_TXBUF_DATA_917_LSB                                               0
#define TXPCU_TXBUF_DATA_917_MSB                                               31
#define TXPCU_TXBUF_DATA_917_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_917_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_917_MASK) >> TXPCU_TXBUF_DATA_917_LSB)
#define TXPCU_TXBUF_DATA_917_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_917_LSB) & TXPCU_TXBUF_DATA_917_MASK)
#define TXPCU_TXBUF_DATA_917_RESET                                             0x0
#define TXPCU_TXBUF_917_ADDRESS                                                (0x1e54 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_917_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_917_RESET                                                  0x0

// 0x1e58 (TXPCU_TXBUF_918)
#define TXPCU_TXBUF_DATA_918_LSB                                               0
#define TXPCU_TXBUF_DATA_918_MSB                                               31
#define TXPCU_TXBUF_DATA_918_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_918_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_918_MASK) >> TXPCU_TXBUF_DATA_918_LSB)
#define TXPCU_TXBUF_DATA_918_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_918_LSB) & TXPCU_TXBUF_DATA_918_MASK)
#define TXPCU_TXBUF_DATA_918_RESET                                             0x0
#define TXPCU_TXBUF_918_ADDRESS                                                (0x1e58 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_918_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_918_RESET                                                  0x0

// 0x1e5c (TXPCU_TXBUF_919)
#define TXPCU_TXBUF_DATA_919_LSB                                               0
#define TXPCU_TXBUF_DATA_919_MSB                                               31
#define TXPCU_TXBUF_DATA_919_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_919_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_919_MASK) >> TXPCU_TXBUF_DATA_919_LSB)
#define TXPCU_TXBUF_DATA_919_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_919_LSB) & TXPCU_TXBUF_DATA_919_MASK)
#define TXPCU_TXBUF_DATA_919_RESET                                             0x0
#define TXPCU_TXBUF_919_ADDRESS                                                (0x1e5c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_919_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_919_RESET                                                  0x0

// 0x1e60 (TXPCU_TXBUF_920)
#define TXPCU_TXBUF_DATA_920_LSB                                               0
#define TXPCU_TXBUF_DATA_920_MSB                                               31
#define TXPCU_TXBUF_DATA_920_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_920_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_920_MASK) >> TXPCU_TXBUF_DATA_920_LSB)
#define TXPCU_TXBUF_DATA_920_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_920_LSB) & TXPCU_TXBUF_DATA_920_MASK)
#define TXPCU_TXBUF_DATA_920_RESET                                             0x0
#define TXPCU_TXBUF_920_ADDRESS                                                (0x1e60 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_920_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_920_RESET                                                  0x0

// 0x1e64 (TXPCU_TXBUF_921)
#define TXPCU_TXBUF_DATA_921_LSB                                               0
#define TXPCU_TXBUF_DATA_921_MSB                                               31
#define TXPCU_TXBUF_DATA_921_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_921_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_921_MASK) >> TXPCU_TXBUF_DATA_921_LSB)
#define TXPCU_TXBUF_DATA_921_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_921_LSB) & TXPCU_TXBUF_DATA_921_MASK)
#define TXPCU_TXBUF_DATA_921_RESET                                             0x0
#define TXPCU_TXBUF_921_ADDRESS                                                (0x1e64 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_921_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_921_RESET                                                  0x0

// 0x1e68 (TXPCU_TXBUF_922)
#define TXPCU_TXBUF_DATA_922_LSB                                               0
#define TXPCU_TXBUF_DATA_922_MSB                                               31
#define TXPCU_TXBUF_DATA_922_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_922_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_922_MASK) >> TXPCU_TXBUF_DATA_922_LSB)
#define TXPCU_TXBUF_DATA_922_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_922_LSB) & TXPCU_TXBUF_DATA_922_MASK)
#define TXPCU_TXBUF_DATA_922_RESET                                             0x0
#define TXPCU_TXBUF_922_ADDRESS                                                (0x1e68 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_922_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_922_RESET                                                  0x0

// 0x1e6c (TXPCU_TXBUF_923)
#define TXPCU_TXBUF_DATA_923_LSB                                               0
#define TXPCU_TXBUF_DATA_923_MSB                                               31
#define TXPCU_TXBUF_DATA_923_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_923_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_923_MASK) >> TXPCU_TXBUF_DATA_923_LSB)
#define TXPCU_TXBUF_DATA_923_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_923_LSB) & TXPCU_TXBUF_DATA_923_MASK)
#define TXPCU_TXBUF_DATA_923_RESET                                             0x0
#define TXPCU_TXBUF_923_ADDRESS                                                (0x1e6c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_923_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_923_RESET                                                  0x0

// 0x1e70 (TXPCU_TXBUF_924)
#define TXPCU_TXBUF_DATA_924_LSB                                               0
#define TXPCU_TXBUF_DATA_924_MSB                                               31
#define TXPCU_TXBUF_DATA_924_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_924_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_924_MASK) >> TXPCU_TXBUF_DATA_924_LSB)
#define TXPCU_TXBUF_DATA_924_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_924_LSB) & TXPCU_TXBUF_DATA_924_MASK)
#define TXPCU_TXBUF_DATA_924_RESET                                             0x0
#define TXPCU_TXBUF_924_ADDRESS                                                (0x1e70 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_924_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_924_RESET                                                  0x0

// 0x1e74 (TXPCU_TXBUF_925)
#define TXPCU_TXBUF_DATA_925_LSB                                               0
#define TXPCU_TXBUF_DATA_925_MSB                                               31
#define TXPCU_TXBUF_DATA_925_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_925_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_925_MASK) >> TXPCU_TXBUF_DATA_925_LSB)
#define TXPCU_TXBUF_DATA_925_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_925_LSB) & TXPCU_TXBUF_DATA_925_MASK)
#define TXPCU_TXBUF_DATA_925_RESET                                             0x0
#define TXPCU_TXBUF_925_ADDRESS                                                (0x1e74 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_925_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_925_RESET                                                  0x0

// 0x1e78 (TXPCU_TXBUF_926)
#define TXPCU_TXBUF_DATA_926_LSB                                               0
#define TXPCU_TXBUF_DATA_926_MSB                                               31
#define TXPCU_TXBUF_DATA_926_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_926_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_926_MASK) >> TXPCU_TXBUF_DATA_926_LSB)
#define TXPCU_TXBUF_DATA_926_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_926_LSB) & TXPCU_TXBUF_DATA_926_MASK)
#define TXPCU_TXBUF_DATA_926_RESET                                             0x0
#define TXPCU_TXBUF_926_ADDRESS                                                (0x1e78 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_926_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_926_RESET                                                  0x0

// 0x1e7c (TXPCU_TXBUF_927)
#define TXPCU_TXBUF_DATA_927_LSB                                               0
#define TXPCU_TXBUF_DATA_927_MSB                                               31
#define TXPCU_TXBUF_DATA_927_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_927_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_927_MASK) >> TXPCU_TXBUF_DATA_927_LSB)
#define TXPCU_TXBUF_DATA_927_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_927_LSB) & TXPCU_TXBUF_DATA_927_MASK)
#define TXPCU_TXBUF_DATA_927_RESET                                             0x0
#define TXPCU_TXBUF_927_ADDRESS                                                (0x1e7c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_927_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_927_RESET                                                  0x0

// 0x1e80 (TXPCU_TXBUF_928)
#define TXPCU_TXBUF_DATA_928_LSB                                               0
#define TXPCU_TXBUF_DATA_928_MSB                                               31
#define TXPCU_TXBUF_DATA_928_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_928_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_928_MASK) >> TXPCU_TXBUF_DATA_928_LSB)
#define TXPCU_TXBUF_DATA_928_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_928_LSB) & TXPCU_TXBUF_DATA_928_MASK)
#define TXPCU_TXBUF_DATA_928_RESET                                             0x0
#define TXPCU_TXBUF_928_ADDRESS                                                (0x1e80 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_928_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_928_RESET                                                  0x0

// 0x1e84 (TXPCU_TXBUF_929)
#define TXPCU_TXBUF_DATA_929_LSB                                               0
#define TXPCU_TXBUF_DATA_929_MSB                                               31
#define TXPCU_TXBUF_DATA_929_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_929_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_929_MASK) >> TXPCU_TXBUF_DATA_929_LSB)
#define TXPCU_TXBUF_DATA_929_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_929_LSB) & TXPCU_TXBUF_DATA_929_MASK)
#define TXPCU_TXBUF_DATA_929_RESET                                             0x0
#define TXPCU_TXBUF_929_ADDRESS                                                (0x1e84 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_929_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_929_RESET                                                  0x0

// 0x1e88 (TXPCU_TXBUF_930)
#define TXPCU_TXBUF_DATA_930_LSB                                               0
#define TXPCU_TXBUF_DATA_930_MSB                                               31
#define TXPCU_TXBUF_DATA_930_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_930_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_930_MASK) >> TXPCU_TXBUF_DATA_930_LSB)
#define TXPCU_TXBUF_DATA_930_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_930_LSB) & TXPCU_TXBUF_DATA_930_MASK)
#define TXPCU_TXBUF_DATA_930_RESET                                             0x0
#define TXPCU_TXBUF_930_ADDRESS                                                (0x1e88 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_930_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_930_RESET                                                  0x0

// 0x1e8c (TXPCU_TXBUF_931)
#define TXPCU_TXBUF_DATA_931_LSB                                               0
#define TXPCU_TXBUF_DATA_931_MSB                                               31
#define TXPCU_TXBUF_DATA_931_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_931_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_931_MASK) >> TXPCU_TXBUF_DATA_931_LSB)
#define TXPCU_TXBUF_DATA_931_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_931_LSB) & TXPCU_TXBUF_DATA_931_MASK)
#define TXPCU_TXBUF_DATA_931_RESET                                             0x0
#define TXPCU_TXBUF_931_ADDRESS                                                (0x1e8c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_931_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_931_RESET                                                  0x0

// 0x1e90 (TXPCU_TXBUF_932)
#define TXPCU_TXBUF_DATA_932_LSB                                               0
#define TXPCU_TXBUF_DATA_932_MSB                                               31
#define TXPCU_TXBUF_DATA_932_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_932_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_932_MASK) >> TXPCU_TXBUF_DATA_932_LSB)
#define TXPCU_TXBUF_DATA_932_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_932_LSB) & TXPCU_TXBUF_DATA_932_MASK)
#define TXPCU_TXBUF_DATA_932_RESET                                             0x0
#define TXPCU_TXBUF_932_ADDRESS                                                (0x1e90 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_932_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_932_RESET                                                  0x0

// 0x1e94 (TXPCU_TXBUF_933)
#define TXPCU_TXBUF_DATA_933_LSB                                               0
#define TXPCU_TXBUF_DATA_933_MSB                                               31
#define TXPCU_TXBUF_DATA_933_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_933_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_933_MASK) >> TXPCU_TXBUF_DATA_933_LSB)
#define TXPCU_TXBUF_DATA_933_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_933_LSB) & TXPCU_TXBUF_DATA_933_MASK)
#define TXPCU_TXBUF_DATA_933_RESET                                             0x0
#define TXPCU_TXBUF_933_ADDRESS                                                (0x1e94 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_933_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_933_RESET                                                  0x0

// 0x1e98 (TXPCU_TXBUF_934)
#define TXPCU_TXBUF_DATA_934_LSB                                               0
#define TXPCU_TXBUF_DATA_934_MSB                                               31
#define TXPCU_TXBUF_DATA_934_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_934_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_934_MASK) >> TXPCU_TXBUF_DATA_934_LSB)
#define TXPCU_TXBUF_DATA_934_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_934_LSB) & TXPCU_TXBUF_DATA_934_MASK)
#define TXPCU_TXBUF_DATA_934_RESET                                             0x0
#define TXPCU_TXBUF_934_ADDRESS                                                (0x1e98 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_934_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_934_RESET                                                  0x0

// 0x1e9c (TXPCU_TXBUF_935)
#define TXPCU_TXBUF_DATA_935_LSB                                               0
#define TXPCU_TXBUF_DATA_935_MSB                                               31
#define TXPCU_TXBUF_DATA_935_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_935_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_935_MASK) >> TXPCU_TXBUF_DATA_935_LSB)
#define TXPCU_TXBUF_DATA_935_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_935_LSB) & TXPCU_TXBUF_DATA_935_MASK)
#define TXPCU_TXBUF_DATA_935_RESET                                             0x0
#define TXPCU_TXBUF_935_ADDRESS                                                (0x1e9c + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_935_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_935_RESET                                                  0x0

// 0x1ea0 (TXPCU_TXBUF_936)
#define TXPCU_TXBUF_DATA_936_LSB                                               0
#define TXPCU_TXBUF_DATA_936_MSB                                               31
#define TXPCU_TXBUF_DATA_936_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_936_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_936_MASK) >> TXPCU_TXBUF_DATA_936_LSB)
#define TXPCU_TXBUF_DATA_936_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_936_LSB) & TXPCU_TXBUF_DATA_936_MASK)
#define TXPCU_TXBUF_DATA_936_RESET                                             0x0
#define TXPCU_TXBUF_936_ADDRESS                                                (0x1ea0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_936_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_936_RESET                                                  0x0

// 0x1ea4 (TXPCU_TXBUF_937)
#define TXPCU_TXBUF_DATA_937_LSB                                               0
#define TXPCU_TXBUF_DATA_937_MSB                                               31
#define TXPCU_TXBUF_DATA_937_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_937_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_937_MASK) >> TXPCU_TXBUF_DATA_937_LSB)
#define TXPCU_TXBUF_DATA_937_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_937_LSB) & TXPCU_TXBUF_DATA_937_MASK)
#define TXPCU_TXBUF_DATA_937_RESET                                             0x0
#define TXPCU_TXBUF_937_ADDRESS                                                (0x1ea4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_937_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_937_RESET                                                  0x0

// 0x1ea8 (TXPCU_TXBUF_938)
#define TXPCU_TXBUF_DATA_938_LSB                                               0
#define TXPCU_TXBUF_DATA_938_MSB                                               31
#define TXPCU_TXBUF_DATA_938_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_938_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_938_MASK) >> TXPCU_TXBUF_DATA_938_LSB)
#define TXPCU_TXBUF_DATA_938_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_938_LSB) & TXPCU_TXBUF_DATA_938_MASK)
#define TXPCU_TXBUF_DATA_938_RESET                                             0x0
#define TXPCU_TXBUF_938_ADDRESS                                                (0x1ea8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_938_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_938_RESET                                                  0x0

// 0x1eac (TXPCU_TXBUF_939)
#define TXPCU_TXBUF_DATA_939_LSB                                               0
#define TXPCU_TXBUF_DATA_939_MSB                                               31
#define TXPCU_TXBUF_DATA_939_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_939_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_939_MASK) >> TXPCU_TXBUF_DATA_939_LSB)
#define TXPCU_TXBUF_DATA_939_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_939_LSB) & TXPCU_TXBUF_DATA_939_MASK)
#define TXPCU_TXBUF_DATA_939_RESET                                             0x0
#define TXPCU_TXBUF_939_ADDRESS                                                (0x1eac + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_939_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_939_RESET                                                  0x0

// 0x1eb0 (TXPCU_TXBUF_940)
#define TXPCU_TXBUF_DATA_940_LSB                                               0
#define TXPCU_TXBUF_DATA_940_MSB                                               31
#define TXPCU_TXBUF_DATA_940_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_940_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_940_MASK) >> TXPCU_TXBUF_DATA_940_LSB)
#define TXPCU_TXBUF_DATA_940_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_940_LSB) & TXPCU_TXBUF_DATA_940_MASK)
#define TXPCU_TXBUF_DATA_940_RESET                                             0x0
#define TXPCU_TXBUF_940_ADDRESS                                                (0x1eb0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_940_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_940_RESET                                                  0x0

// 0x1eb4 (TXPCU_TXBUF_941)
#define TXPCU_TXBUF_DATA_941_LSB                                               0
#define TXPCU_TXBUF_DATA_941_MSB                                               31
#define TXPCU_TXBUF_DATA_941_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_941_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_941_MASK) >> TXPCU_TXBUF_DATA_941_LSB)
#define TXPCU_TXBUF_DATA_941_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_941_LSB) & TXPCU_TXBUF_DATA_941_MASK)
#define TXPCU_TXBUF_DATA_941_RESET                                             0x0
#define TXPCU_TXBUF_941_ADDRESS                                                (0x1eb4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_941_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_941_RESET                                                  0x0

// 0x1eb8 (TXPCU_TXBUF_942)
#define TXPCU_TXBUF_DATA_942_LSB                                               0
#define TXPCU_TXBUF_DATA_942_MSB                                               31
#define TXPCU_TXBUF_DATA_942_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_942_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_942_MASK) >> TXPCU_TXBUF_DATA_942_LSB)
#define TXPCU_TXBUF_DATA_942_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_942_LSB) & TXPCU_TXBUF_DATA_942_MASK)
#define TXPCU_TXBUF_DATA_942_RESET                                             0x0
#define TXPCU_TXBUF_942_ADDRESS                                                (0x1eb8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_942_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_942_RESET                                                  0x0

// 0x1ebc (TXPCU_TXBUF_943)
#define TXPCU_TXBUF_DATA_943_LSB                                               0
#define TXPCU_TXBUF_DATA_943_MSB                                               31
#define TXPCU_TXBUF_DATA_943_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_943_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_943_MASK) >> TXPCU_TXBUF_DATA_943_LSB)
#define TXPCU_TXBUF_DATA_943_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_943_LSB) & TXPCU_TXBUF_DATA_943_MASK)
#define TXPCU_TXBUF_DATA_943_RESET                                             0x0
#define TXPCU_TXBUF_943_ADDRESS                                                (0x1ebc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_943_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_943_RESET                                                  0x0

// 0x1ec0 (TXPCU_TXBUF_944)
#define TXPCU_TXBUF_DATA_944_LSB                                               0
#define TXPCU_TXBUF_DATA_944_MSB                                               31
#define TXPCU_TXBUF_DATA_944_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_944_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_944_MASK) >> TXPCU_TXBUF_DATA_944_LSB)
#define TXPCU_TXBUF_DATA_944_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_944_LSB) & TXPCU_TXBUF_DATA_944_MASK)
#define TXPCU_TXBUF_DATA_944_RESET                                             0x0
#define TXPCU_TXBUF_944_ADDRESS                                                (0x1ec0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_944_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_944_RESET                                                  0x0

// 0x1ec4 (TXPCU_TXBUF_945)
#define TXPCU_TXBUF_DATA_945_LSB                                               0
#define TXPCU_TXBUF_DATA_945_MSB                                               31
#define TXPCU_TXBUF_DATA_945_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_945_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_945_MASK) >> TXPCU_TXBUF_DATA_945_LSB)
#define TXPCU_TXBUF_DATA_945_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_945_LSB) & TXPCU_TXBUF_DATA_945_MASK)
#define TXPCU_TXBUF_DATA_945_RESET                                             0x0
#define TXPCU_TXBUF_945_ADDRESS                                                (0x1ec4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_945_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_945_RESET                                                  0x0

// 0x1ec8 (TXPCU_TXBUF_946)
#define TXPCU_TXBUF_DATA_946_LSB                                               0
#define TXPCU_TXBUF_DATA_946_MSB                                               31
#define TXPCU_TXBUF_DATA_946_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_946_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_946_MASK) >> TXPCU_TXBUF_DATA_946_LSB)
#define TXPCU_TXBUF_DATA_946_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_946_LSB) & TXPCU_TXBUF_DATA_946_MASK)
#define TXPCU_TXBUF_DATA_946_RESET                                             0x0
#define TXPCU_TXBUF_946_ADDRESS                                                (0x1ec8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_946_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_946_RESET                                                  0x0

// 0x1ecc (TXPCU_TXBUF_947)
#define TXPCU_TXBUF_DATA_947_LSB                                               0
#define TXPCU_TXBUF_DATA_947_MSB                                               31
#define TXPCU_TXBUF_DATA_947_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_947_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_947_MASK) >> TXPCU_TXBUF_DATA_947_LSB)
#define TXPCU_TXBUF_DATA_947_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_947_LSB) & TXPCU_TXBUF_DATA_947_MASK)
#define TXPCU_TXBUF_DATA_947_RESET                                             0x0
#define TXPCU_TXBUF_947_ADDRESS                                                (0x1ecc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_947_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_947_RESET                                                  0x0

// 0x1ed0 (TXPCU_TXBUF_948)
#define TXPCU_TXBUF_DATA_948_LSB                                               0
#define TXPCU_TXBUF_DATA_948_MSB                                               31
#define TXPCU_TXBUF_DATA_948_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_948_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_948_MASK) >> TXPCU_TXBUF_DATA_948_LSB)
#define TXPCU_TXBUF_DATA_948_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_948_LSB) & TXPCU_TXBUF_DATA_948_MASK)
#define TXPCU_TXBUF_DATA_948_RESET                                             0x0
#define TXPCU_TXBUF_948_ADDRESS                                                (0x1ed0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_948_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_948_RESET                                                  0x0

// 0x1ed4 (TXPCU_TXBUF_949)
#define TXPCU_TXBUF_DATA_949_LSB                                               0
#define TXPCU_TXBUF_DATA_949_MSB                                               31
#define TXPCU_TXBUF_DATA_949_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_949_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_949_MASK) >> TXPCU_TXBUF_DATA_949_LSB)
#define TXPCU_TXBUF_DATA_949_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_949_LSB) & TXPCU_TXBUF_DATA_949_MASK)
#define TXPCU_TXBUF_DATA_949_RESET                                             0x0
#define TXPCU_TXBUF_949_ADDRESS                                                (0x1ed4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_949_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_949_RESET                                                  0x0

// 0x1ed8 (TXPCU_TXBUF_950)
#define TXPCU_TXBUF_DATA_950_LSB                                               0
#define TXPCU_TXBUF_DATA_950_MSB                                               31
#define TXPCU_TXBUF_DATA_950_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_950_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_950_MASK) >> TXPCU_TXBUF_DATA_950_LSB)
#define TXPCU_TXBUF_DATA_950_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_950_LSB) & TXPCU_TXBUF_DATA_950_MASK)
#define TXPCU_TXBUF_DATA_950_RESET                                             0x0
#define TXPCU_TXBUF_950_ADDRESS                                                (0x1ed8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_950_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_950_RESET                                                  0x0

// 0x1edc (TXPCU_TXBUF_951)
#define TXPCU_TXBUF_DATA_951_LSB                                               0
#define TXPCU_TXBUF_DATA_951_MSB                                               31
#define TXPCU_TXBUF_DATA_951_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_951_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_951_MASK) >> TXPCU_TXBUF_DATA_951_LSB)
#define TXPCU_TXBUF_DATA_951_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_951_LSB) & TXPCU_TXBUF_DATA_951_MASK)
#define TXPCU_TXBUF_DATA_951_RESET                                             0x0
#define TXPCU_TXBUF_951_ADDRESS                                                (0x1edc + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_951_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_951_RESET                                                  0x0

// 0x1ee0 (TXPCU_TXBUF_952)
#define TXPCU_TXBUF_DATA_952_LSB                                               0
#define TXPCU_TXBUF_DATA_952_MSB                                               31
#define TXPCU_TXBUF_DATA_952_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_952_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_952_MASK) >> TXPCU_TXBUF_DATA_952_LSB)
#define TXPCU_TXBUF_DATA_952_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_952_LSB) & TXPCU_TXBUF_DATA_952_MASK)
#define TXPCU_TXBUF_DATA_952_RESET                                             0x0
#define TXPCU_TXBUF_952_ADDRESS                                                (0x1ee0 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_952_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_952_RESET                                                  0x0

// 0x1ee4 (TXPCU_TXBUF_953)
#define TXPCU_TXBUF_DATA_953_LSB                                               0
#define TXPCU_TXBUF_DATA_953_MSB                                               31
#define TXPCU_TXBUF_DATA_953_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_953_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_953_MASK) >> TXPCU_TXBUF_DATA_953_LSB)
#define TXPCU_TXBUF_DATA_953_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_953_LSB) & TXPCU_TXBUF_DATA_953_MASK)
#define TXPCU_TXBUF_DATA_953_RESET                                             0x0
#define TXPCU_TXBUF_953_ADDRESS                                                (0x1ee4 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_953_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_953_RESET                                                  0x0

// 0x1ee8 (TXPCU_TXBUF_954)
#define TXPCU_TXBUF_DATA_954_LSB                                               0
#define TXPCU_TXBUF_DATA_954_MSB                                               31
#define TXPCU_TXBUF_DATA_954_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_954_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_954_MASK) >> TXPCU_TXBUF_DATA_954_LSB)
#define TXPCU_TXBUF_DATA_954_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_954_LSB) & TXPCU_TXBUF_DATA_954_MASK)
#define TXPCU_TXBUF_DATA_954_RESET                                             0x0
#define TXPCU_TXBUF_954_ADDRESS                                                (0x1ee8 + __MAC_TXPCU_REG_BASE_ADDRESS)
#define TXPCU_TXBUF_954_RSTMASK                                                0xffffffff
#define TXPCU_TXBUF_954_RESET                                                  0x0

// 0x1eec (TXPCU_TXBUF_955)
#define TXPCU_TXBUF_DATA_955_LSB                                               0
#define TXPCU_TXBUF_DATA_955_MSB                                               31
#define TXPCU_TXBUF_DATA_955_MASK                                              0xffffffff
#define TXPCU_TXBUF_DATA_955_GET(x)                                            (((x) & TXPCU_TXBUF_DATA_955_MASK) >> TXPCU_TXBUF_DATA_955_LSB)
#define TXPCU_TXBUF_DATA_955_SET(x)                                            (((0 | (x)) << TXPCU_TXBUF_DATA_955_LSB) & TXPCU_TXBUF_DATA_955_MASK)
#define TXPCU_TXBUF_DATA_955_RESET                                             0x0
#define TXPCU_