// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _RX_LOCATION_INFO_H_
#define _RX_LOCATION_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	rtt_corr_value[16:0], cir_status[17], fac_status[19:18], pkt_bw[22:20], rtt_tx_frame_phase[24:23], rtt_mac_phy_phase[25], rtt_tx_data_start_x_phase[26], reserved[29:27], hw_ifft_mode[30], rx_location_info_valid[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_RX_LOCATION_INFO 1

struct rx_location_info {
             uint32_t rtt_corr_value                  : 17, //[16:0]
                      cir_status                      :  1, //[17]
                      fac_status                      :  2, //[19:18]
                      pkt_bw                          :  3, //[22:20]
                      rtt_tx_frame_phase              :  2, //[24:23]
                      rtt_mac_phy_phase               :  1, //[25]
                      rtt_tx_data_start_x_phase       :  1, //[26]
                      reserved                        :  3, //[29:27]
                      hw_ifft_mode                    :  1, //[30]
                      rx_location_info_valid          :  1; //[31]
};

/*

rtt_corr_value
			
			RTT correction value
			
			<legal all>

cir_status
			
			CIR (Channel Impulse Resposne) status
			
			0: CIR in memory is not reliable
			
			1: CIR in memory is reliable 

fac_status
			
			FAC (First Arrival Correction) status
			
			<enum 0     location_fac_invalid >
			
			<enum 1     location_legacy_fac_valid>
			
			<enum 2     location_ht_vht_fac_valid>
			
			<legal 0-2>

pkt_bw
			
			Packet bandwidth
			
			<enum 0     location_legacy>
			
			<enum 1     location_ht_vht20>
			
			<enum 2     location_ht_vht40>
			
			<enum 3     location_ht_vht80>
			
			<legal 0-3>

rtt_tx_frame_phase
			
			For BW20 only. If rtt_tx_frame_phase == 2'b11, reduce
			TOA by one MAC clock. Otherwise, don't need to adjust
			timestamp.

rtt_mac_phy_phase
			
			For VHT80 only.
			
			0: rx_begin_data is asserted at low phase of clk80 - TOA
			need to be increased by one clk160.
			
			1: rx_begin_data is asserted at high phase of clk80 -
			doesn't need to adjust TOA

rtt_tx_data_start_x_phase
			
			Indicate phase relationship between tx_data_start_x &
			clk_common_div2
			
			0: tx_data_start_x is asserted at low phase of
			clk_common_div2: adjust timestamp by adding one clk80/88
			
			1: tx_data_start_x is asserted at high phase of
			clk_common_div2: don't need to adjust timestamp

reserved
			
			Reserved - set to 0 by PHY  <legal 0>

hw_ifft_mode
			
			1 - HW iFFT mode, 0 - SW mode
			
			The rtt_corr_value[16:0] is valid only if it's HW iFFT
			mode. 

rx_location_info_valid
			
			0: Whole rx_location_info TLV invalid
			
			1: Whole rx_location_info TLV valid
			
			<legal 0-1>
*/


/* Description		RX_LOCATION_INFO_0_RTT_CORR_VALUE
			
			RTT correction value
			
			<legal all>
*/
#define RX_LOCATION_INFO_0_RTT_CORR_VALUE_OFFSET                     0x00000000
#define RX_LOCATION_INFO_0_RTT_CORR_VALUE_LSB                        0
#define RX_LOCATION_INFO_0_RTT_CORR_VALUE_MASK                       0x0001ffff

/* Description		RX_LOCATION_INFO_0_CIR_STATUS
			
			CIR (Channel Impulse Resposne) status
			
			0: CIR in memory is not reliable
			
			1: CIR in memory is reliable 
*/
#define RX_LOCATION_INFO_0_CIR_STATUS_OFFSET                         0x00000000
#define RX_LOCATION_INFO_0_CIR_STATUS_LSB                            17
#define RX_LOCATION_INFO_0_CIR_STATUS_MASK                           0x00020000

/* Description		RX_LOCATION_INFO_0_FAC_STATUS
			
			FAC (First Arrival Correction) status
			
			<enum 0     location_fac_invalid >
			
			<enum 1     location_legacy_fac_valid>
			
			<enum 2     location_ht_vht_fac_valid>
			
			<legal 0-2>
*/
#define RX_LOCATION_INFO_0_FAC_STATUS_OFFSET                         0x00000000
#define RX_LOCATION_INFO_0_FAC_STATUS_LSB                            18
#define RX_LOCATION_INFO_0_FAC_STATUS_MASK                           0x000c0000

/* Description		RX_LOCATION_INFO_0_PKT_BW
			
			Packet bandwidth
			
			<enum 0     location_legacy>
			
			<enum 1     location_ht_vht20>
			
			<enum 2     location_ht_vht40>
			
			<enum 3     location_ht_vht80>
			
			<legal 0-3>
*/
#define RX_LOCATION_INFO_0_PKT_BW_OFFSET                             0x00000000
#define RX_LOCATION_INFO_0_PKT_BW_LSB                                20
#define RX_LOCATION_INFO_0_PKT_BW_MASK                               0x00700000

/* Description		RX_LOCATION_INFO_0_RTT_TX_FRAME_PHASE
			
			For BW20 only. If rtt_tx_frame_phase == 2'b11, reduce
			TOA by one MAC clock. Otherwise, don't need to adjust
			timestamp.
*/
#define RX_LOCATION_INFO_0_RTT_TX_FRAME_PHASE_OFFSET                 0x00000000
#define RX_LOCATION_INFO_0_RTT_TX_FRAME_PHASE_LSB                    23
#define RX_LOCATION_INFO_0_RTT_TX_FRAME_PHASE_MASK                   0x01800000

/* Description		RX_LOCATION_INFO_0_RTT_MAC_PHY_PHASE
			
			For VHT80 only.
			
			0: rx_begin_data is asserted at low phase of clk80 - TOA
			need to be increased by one clk160.
			
			1: rx_begin_data is asserted at high phase of clk80 -
			doesn't need to adjust TOA
*/
#define RX_LOCATION_INFO_0_RTT_MAC_PHY_PHASE_OFFSET                  0x00000000
#define RX_LOCATION_INFO_0_RTT_MAC_PHY_PHASE_LSB                     25
#define RX_LOCATION_INFO_0_RTT_MAC_PHY_PHASE_MASK                    0x02000000

/* Description		RX_LOCATION_INFO_0_RTT_TX_DATA_START_X_PHASE
			
			Indicate phase relationship between tx_data_start_x &
			clk_common_div2
			
			0: tx_data_start_x is asserted at low phase of
			clk_common_div2: adjust timestamp by adding one clk80/88
			
			1: tx_data_start_x is asserted at high phase of
			clk_common_div2: don't need to adjust timestamp
*/
#define RX_LOCATION_INFO_0_RTT_TX_DATA_START_X_PHASE_OFFSET          0x00000000
#define RX_LOCATION_INFO_0_RTT_TX_DATA_START_X_PHASE_LSB             26
#define RX_LOCATION_INFO_0_RTT_TX_DATA_START_X_PHASE_MASK            0x04000000

/* Description		RX_LOCATION_INFO_0_RESERVED
			
			Reserved - set to 0 by PHY  <legal 0>
*/
#define RX_LOCATION_INFO_0_RESERVED_OFFSET                           0x00000000
#define RX_LOCATION_INFO_0_RESERVED_LSB                              27
#define RX_LOCATION_INFO_0_RESERVED_MASK                             0x38000000

/* Description		RX_LOCATION_INFO_0_HW_IFFT_MODE
			
			1 - HW iFFT mode, 0 - SW mode
			
			The rtt_corr_value[16:0] is valid only if it's HW iFFT
			mode. 
*/
#define RX_LOCATION_INFO_0_HW_IFFT_MODE_OFFSET                       0x00000000
#define RX_LOCATION_INFO_0_HW_IFFT_MODE_LSB                          30
#define RX_LOCATION_INFO_0_HW_IFFT_MODE_MASK                         0x40000000

/* Description		RX_LOCATION_INFO_0_RX_LOCATION_INFO_VALID
			
			0: Whole rx_location_info TLV invalid
			
			1: Whole rx_location_info TLV valid
			
			<legal 0-1>
*/
#define RX_LOCATION_INFO_0_RX_LOCATION_INFO_VALID_OFFSET             0x00000000
#define RX_LOCATION_INFO_0_RX_LOCATION_INFO_VALID_LSB                31
#define RX_LOCATION_INFO_0_RX_LOCATION_INFO_VALID_MASK               0x80000000


#endif // _RX_LOCATION_INFO_H_
