// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _SCH_RESPONSE_TABLE_ENTRY_H_
#define _SCH_RESPONSE_TABLE_ENTRY_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	ps_poll_response_ptr[31:0]
//	1	u_apsd_response_ptr[31:0]
//	2	qboost_response_ptr[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_SCH_RESPONSE_TABLE_ENTRY 3

struct sch_response_table_entry {
    volatile uint32_t ps_poll_response_ptr            : 32; //[31:0]
    volatile uint32_t u_apsd_response_ptr             : 32; //[31:0]
    volatile uint32_t qboost_response_ptr             : 32; //[31:0]
};

/*

ps_poll_response_ptr
			
			This field can only be evaluated when the
			SCH_RX_FRAME_INFO TLV indicates a PS-POLL frame has been
			received.
			
			
			
			This field is a pointer to a PS_POLL_RESPONSE  TLV
			describing the response handling details to receiving the
			PS_POLL frame.
			
			
			
			When NULL, there is no response defined, and no SIFS
			response will be generated. <legal all>

u_apsd_response_ptr
			
			This field can only be evaluated when the
			SCH_RX_FRAME_INFO TLV indicates a QoS Data frame has been
			received AND the STA power state (also indicated in this
			TLV) is set to power save.
			
			 
			
			This field is a pointer to UAPSD_RESPONSE TLV describing
			the response handling to receiving a potential U_APSD
			trigger.
			
			
			
			When NULL, there is no response defined, and no SIFS
			response will be generated. <legal all>

qboost_response_ptr
			
			This field can only be evaluated when the
			SCH_RX_FRAME_INFO TLV indicates a QoS Data frame has been
			received AND the STA power state (also indicated in this
			TLV) is NOT in power save.
			
			This field is a pointer to a QBOOST_RESPONSE  TLV
			describing the response to receiving a potential Qboost
			trigger.
			
			
			
			When NULL, there is no response defined, and no SIFS
			response will be generated. <legal all>
*/


/* Description		SCH_RESPONSE_TABLE_ENTRY_0_PS_POLL_RESPONSE_PTR
			
			This field can only be evaluated when the
			SCH_RX_FRAME_INFO TLV indicates a PS-POLL frame has been
			received.
			
			
			
			This field is a pointer to a PS_POLL_RESPONSE  TLV
			describing the response handling details to receiving the
			PS_POLL frame.
			
			
			
			When NULL, there is no response defined, and no SIFS
			response will be generated. <legal all>
*/
#define SCH_RESPONSE_TABLE_ENTRY_0_PS_POLL_RESPONSE_PTR_OFFSET       0x00000000
#define SCH_RESPONSE_TABLE_ENTRY_0_PS_POLL_RESPONSE_PTR_LSB          0
#define SCH_RESPONSE_TABLE_ENTRY_0_PS_POLL_RESPONSE_PTR_MASK         0xffffffff

/* Description		SCH_RESPONSE_TABLE_ENTRY_1_U_APSD_RESPONSE_PTR
			
			This field can only be evaluated when the
			SCH_RX_FRAME_INFO TLV indicates a QoS Data frame has been
			received AND the STA power state (also indicated in this
			TLV) is set to power save.
			
			 
			
			This field is a pointer to UAPSD_RESPONSE TLV describing
			the response handling to receiving a potential U_APSD
			trigger.
			
			
			
			When NULL, there is no response defined, and no SIFS
			response will be generated. <legal all>
*/
#define SCH_RESPONSE_TABLE_ENTRY_1_U_APSD_RESPONSE_PTR_OFFSET        0x00000004
#define SCH_RESPONSE_TABLE_ENTRY_1_U_APSD_RESPONSE_PTR_LSB           0
#define SCH_RESPONSE_TABLE_ENTRY_1_U_APSD_RESPONSE_PTR_MASK          0xffffffff

/* Description		SCH_RESPONSE_TABLE_ENTRY_2_QBOOST_RESPONSE_PTR
			
			This field can only be evaluated when the
			SCH_RX_FRAME_INFO TLV indicates a QoS Data frame has been
			received AND the STA power state (also indicated in this
			TLV) is NOT in power save.
			
			This field is a pointer to a QBOOST_RESPONSE  TLV
			describing the response to receiving a potential Qboost
			trigger.
			
			
			
			When NULL, there is no response defined, and no SIFS
			response will be generated. <legal all>
*/
#define SCH_RESPONSE_TABLE_ENTRY_2_QBOOST_RESPONSE_PTR_OFFSET        0x00000008
#define SCH_RESPONSE_TABLE_ENTRY_2_QBOOST_RESPONSE_PTR_LSB           0
#define SCH_RESPONSE_TABLE_ENTRY_2_QBOOST_RESPONSE_PTR_MASK          0xffffffff


#endif // _SCH_RESPONSE_TABLE_ENTRY_H_
