// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _QBOOST_RESPONSE_H_
#define _QBOOST_RESPONSE_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	valid_qboost_queue_bitmap[9:0], rr_qid_selection[10], fes_control_mode[12:11], reserved_0[15:13], qboost_trigger_tid_map[31:16]
//	1	resp_mpdu_queue0[13:0], reserved_1a[15:14], resp_mpdu_queue1[29:16], reserved_1b[31:30]
//	2	resp_mpdu_queue2[13:0], reserved_2a[15:14], resp_mpdu_queue3[29:16], reserved_2b[31:30]
//	3	resp_mpdu_queue4[13:0], reserved_3a[15:14], resp_mpdu_queue5[29:16], reserved_3b[31:30]
//	4	resp_mpdu_queue6[13:0], reserved_4a[15:14], resp_mpdu_queue7[29:16], reserved_4b[31:30]
//	5	resp_mpdu_queue8[13:0], reserved_5a[15:14], resp_mpdu_queue9[29:16], reserved_5b[31:30]
//	6	scheduler_tlv_ptr[31:0]
//	7	next_q_bitmap_id_to_evaluate[3:0], reserved_7[31:4]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_QBOOST_RESPONSE 8

struct qboost_response {
    volatile uint32_t valid_qboost_queue_bitmap       : 10, //[9:0]
                      rr_qid_selection                :  1, //[10]
                      fes_control_mode                :  2, //[12:11]
                      reserved_0                      :  3, //[15:13]
                      qboost_trigger_tid_map          : 16; //[31:16]
    volatile uint32_t resp_mpdu_queue0                : 14, //[13:0]
                      reserved_1a                     :  2, //[15:14]
                      resp_mpdu_queue1                : 14, //[29:16]
                      reserved_1b                     :  2; //[31:30]
    volatile uint32_t resp_mpdu_queue2                : 14, //[13:0]
                      reserved_2a                     :  2, //[15:14]
                      resp_mpdu_queue3                : 14, //[29:16]
                      reserved_2b                     :  2; //[31:30]
    volatile uint32_t resp_mpdu_queue4                : 14, //[13:0]
                      reserved_3a                     :  2, //[15:14]
                      resp_mpdu_queue5                : 14, //[29:16]
                      reserved_3b                     :  2; //[31:30]
    volatile uint32_t resp_mpdu_queue6                : 14, //[13:0]
                      reserved_4a                     :  2, //[15:14]
                      resp_mpdu_queue7                : 14, //[29:16]
                      reserved_4b                     :  2; //[31:30]
    volatile uint32_t resp_mpdu_queue8                : 14, //[13:0]
                      reserved_5a                     :  2, //[15:14]
                      resp_mpdu_queue9                : 14, //[29:16]
                      reserved_5b                     :  2; //[31:30]
    volatile uint32_t scheduler_tlv_ptr               : 32; //[31:0]
    volatile uint32_t next_q_bitmap_id_to_evaluate    :  4, //[3:0]
                      reserved_7                      : 28; //[31:4]
};

/*

valid_qboost_queue_bitmap
			
			Valid response queue bitmap in case a valid QBoost
			trigger frame was received.
			
			
			
			The bitmap indicates which of the following QIDs are
			valid and from which QBoost response data frames are allowed
			to be fetched from this queue.
			
			
			
			The scheduler will evaluate the valid MPDU queues one at
			a time (starting from Resp_mpdu_queue0) and stop when the
			first queue with data is found.
			
			The response data will be sent from this queue.
			
			
			
			When all queues are empty, no data will be sent back. 
			
			<legal all>

rr_qid_selection
			
			Round Robin QueueID selection
			
			When set, the Scheduler will transmit from queues in a
			Round Robin method, always remembering that after
			transmission from a queue, the scheduler should try and
			transmit from the next queue first.
			
			For this it updates the Next_q_bitmap_id_to_evaluate
			field after each successful transmission.
			
			<legal all>

fes_control_mode
			
			1-0: Reserved
			
			2: SW initiated transmission (initiated by SIFS response
			table) For this setting the scheduler will NOT perform any
			checks with the QM. SW has preprogrammed the entire response
			(data frames or a NULL frame) in the scheduling command.
			
			3: HW initiated transmission (initiated by SIFS response
			table) For this setting the scheduler will perform all the
			MPDU queue checks with the QM. Based on the result of those
			checks and other settings in this descriptor, the scheduler
			might initiate a data transmission, null transmission or not
			initiate a transmission at all.
			
			<legal 3-2>

reserved_0
			
			<legal 0>

qboost_trigger_tid_map
			
			Field used to determine if the incoming QoS data frame
			is a Qboost trigger frame.
			
			
			
			Bit 16 corresponds to TID 0 
			
			Bit 17 to TiD1 etc.
			
			
			
			Values
			
			0: The received QoS data frame with the corresponding
			TID value is NOT a qboost trigger frame
			
			1: The received QoS data frame with the corresponding
			TID value IS a Qboost trigger frame. Response data from
			valid_qboost_queue_bitmap should be sent.
			
			<legal all>

resp_mpdu_queue0
			
			Field only valid when valid_qboost_queue_bitmap[0] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_1a
			
			<legal 0>

resp_mpdu_queue1
			
			Field only valid when valid_qboost_queue_bitmap[1] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_1b
			
			<legal 0>

resp_mpdu_queue2
			
			Field only valid when valid_qboost_queue_bitmap[2] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_2a
			
			<legal 0>

resp_mpdu_queue3
			
			Field only valid when valid_qboost_queue_bitmap[3] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_2b
			
			<legal 0>

resp_mpdu_queue4
			
			Field only valid when valid_qboost_queue_bitmap[4] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_3a
			
			<legal 0>

resp_mpdu_queue5
			
			Field only valid when valid_qboost_queue_bitmap[5] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_3b
			
			<legal 0>

resp_mpdu_queue6
			
			Field only valid when valid_qboost_queue_bitmap[6] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_4a
			
			<legal 0>

resp_mpdu_queue7
			
			Field only valid when valid_qboost_queue_bitmap[7] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_4b
			
			<legal 0>

resp_mpdu_queue8
			
			Field only valid when valid_qboost_queue_bitmap[8] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>

reserved_5a
			
			<legal 0>

resp_mpdu_queue9
			
			Field only valid when valid_qboost_queue_bitmap[9] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			<legal all>

reserved_5b
			
			<legal 0>

scheduler_tlv_ptr
			
			The address location for the transmit TLVs.
			
			These TLVs get read/interpreted by the scheduler and
			when applicable pushed down the transmit chain to the other
			transmit modules. <legal all>

next_q_bitmap_id_to_evaluate
			
			Only valid when RR_qid_selection is set.
			
			
			
			This field indicates the next queue bitmap id from which
			the scheduler should try to transmit first on reception of a
			new PS-POLL frame.
			
			
			
			This field is put in a separate word, as HW will update
			this field on regular basis.
			
			<legal 9-0>

reserved_7
			
			<legal 0>
*/


/* Description		QBOOST_RESPONSE_0_VALID_QBOOST_QUEUE_BITMAP
			
			Valid response queue bitmap in case a valid QBoost
			trigger frame was received.
			
			
			
			The bitmap indicates which of the following QIDs are
			valid and from which QBoost response data frames are allowed
			to be fetched from this queue.
			
			
			
			The scheduler will evaluate the valid MPDU queues one at
			a time (starting from Resp_mpdu_queue0) and stop when the
			first queue with data is found.
			
			The response data will be sent from this queue.
			
			
			
			When all queues are empty, no data will be sent back. 
			
			<legal all>
*/
#define QBOOST_RESPONSE_0_VALID_QBOOST_QUEUE_BITMAP_OFFSET           0x00000000
#define QBOOST_RESPONSE_0_VALID_QBOOST_QUEUE_BITMAP_LSB              0
#define QBOOST_RESPONSE_0_VALID_QBOOST_QUEUE_BITMAP_MASK             0x000003ff

/* Description		QBOOST_RESPONSE_0_RR_QID_SELECTION
			
			Round Robin QueueID selection
			
			When set, the Scheduler will transmit from queues in a
			Round Robin method, always remembering that after
			transmission from a queue, the scheduler should try and
			transmit from the next queue first.
			
			For this it updates the Next_q_bitmap_id_to_evaluate
			field after each successful transmission.
			
			<legal all>
*/
#define QBOOST_RESPONSE_0_RR_QID_SELECTION_OFFSET                    0x00000000
#define QBOOST_RESPONSE_0_RR_QID_SELECTION_LSB                       10
#define QBOOST_RESPONSE_0_RR_QID_SELECTION_MASK                      0x00000400

/* Description		QBOOST_RESPONSE_0_FES_CONTROL_MODE
			
			1-0: Reserved
			
			2: SW initiated transmission (initiated by SIFS response
			table) For this setting the scheduler will NOT perform any
			checks with the QM. SW has preprogrammed the entire response
			(data frames or a NULL frame) in the scheduling command.
			
			3: HW initiated transmission (initiated by SIFS response
			table) For this setting the scheduler will perform all the
			MPDU queue checks with the QM. Based on the result of those
			checks and other settings in this descriptor, the scheduler
			might initiate a data transmission, null transmission or not
			initiate a transmission at all.
			
			<legal 3-2>
*/
#define QBOOST_RESPONSE_0_FES_CONTROL_MODE_OFFSET                    0x00000000
#define QBOOST_RESPONSE_0_FES_CONTROL_MODE_LSB                       11
#define QBOOST_RESPONSE_0_FES_CONTROL_MODE_MASK                      0x00001800

/* Description		QBOOST_RESPONSE_0_RESERVED_0
			
			<legal 0>
*/
#define QBOOST_RESPONSE_0_RESERVED_0_OFFSET                          0x00000000
#define QBOOST_RESPONSE_0_RESERVED_0_LSB                             13
#define QBOOST_RESPONSE_0_RESERVED_0_MASK                            0x0000e000

/* Description		QBOOST_RESPONSE_0_QBOOST_TRIGGER_TID_MAP
			
			Field used to determine if the incoming QoS data frame
			is a Qboost trigger frame.
			
			
			
			Bit 16 corresponds to TID 0 
			
			Bit 17 to TiD1 etc.
			
			
			
			Values
			
			0: The received QoS data frame with the corresponding
			TID value is NOT a qboost trigger frame
			
			1: The received QoS data frame with the corresponding
			TID value IS a Qboost trigger frame. Response data from
			valid_qboost_queue_bitmap should be sent.
			
			<legal all>
*/
#define QBOOST_RESPONSE_0_QBOOST_TRIGGER_TID_MAP_OFFSET              0x00000000
#define QBOOST_RESPONSE_0_QBOOST_TRIGGER_TID_MAP_LSB                 16
#define QBOOST_RESPONSE_0_QBOOST_TRIGGER_TID_MAP_MASK                0xffff0000

/* Description		QBOOST_RESPONSE_1_RESP_MPDU_QUEUE0
			
			Field only valid when valid_qboost_queue_bitmap[0] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_1_RESP_MPDU_QUEUE0_OFFSET                    0x00000004
#define QBOOST_RESPONSE_1_RESP_MPDU_QUEUE0_LSB                       0
#define QBOOST_RESPONSE_1_RESP_MPDU_QUEUE0_MASK                      0x00003fff

/* Description		QBOOST_RESPONSE_1_RESERVED_1A
			
			<legal 0>
*/
#define QBOOST_RESPONSE_1_RESERVED_1A_OFFSET                         0x00000004
#define QBOOST_RESPONSE_1_RESERVED_1A_LSB                            14
#define QBOOST_RESPONSE_1_RESERVED_1A_MASK                           0x0000c000

/* Description		QBOOST_RESPONSE_1_RESP_MPDU_QUEUE1
			
			Field only valid when valid_qboost_queue_bitmap[1] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_1_RESP_MPDU_QUEUE1_OFFSET                    0x00000004
#define QBOOST_RESPONSE_1_RESP_MPDU_QUEUE1_LSB                       16
#define QBOOST_RESPONSE_1_RESP_MPDU_QUEUE1_MASK                      0x3fff0000

/* Description		QBOOST_RESPONSE_1_RESERVED_1B
			
			<legal 0>
*/
#define QBOOST_RESPONSE_1_RESERVED_1B_OFFSET                         0x00000004
#define QBOOST_RESPONSE_1_RESERVED_1B_LSB                            30
#define QBOOST_RESPONSE_1_RESERVED_1B_MASK                           0xc0000000

/* Description		QBOOST_RESPONSE_2_RESP_MPDU_QUEUE2
			
			Field only valid when valid_qboost_queue_bitmap[2] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_2_RESP_MPDU_QUEUE2_OFFSET                    0x00000008
#define QBOOST_RESPONSE_2_RESP_MPDU_QUEUE2_LSB                       0
#define QBOOST_RESPONSE_2_RESP_MPDU_QUEUE2_MASK                      0x00003fff

/* Description		QBOOST_RESPONSE_2_RESERVED_2A
			
			<legal 0>
*/
#define QBOOST_RESPONSE_2_RESERVED_2A_OFFSET                         0x00000008
#define QBOOST_RESPONSE_2_RESERVED_2A_LSB                            14
#define QBOOST_RESPONSE_2_RESERVED_2A_MASK                           0x0000c000

/* Description		QBOOST_RESPONSE_2_RESP_MPDU_QUEUE3
			
			Field only valid when valid_qboost_queue_bitmap[3] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_2_RESP_MPDU_QUEUE3_OFFSET                    0x00000008
#define QBOOST_RESPONSE_2_RESP_MPDU_QUEUE3_LSB                       16
#define QBOOST_RESPONSE_2_RESP_MPDU_QUEUE3_MASK                      0x3fff0000

/* Description		QBOOST_RESPONSE_2_RESERVED_2B
			
			<legal 0>
*/
#define QBOOST_RESPONSE_2_RESERVED_2B_OFFSET                         0x00000008
#define QBOOST_RESPONSE_2_RESERVED_2B_LSB                            30
#define QBOOST_RESPONSE_2_RESERVED_2B_MASK                           0xc0000000

/* Description		QBOOST_RESPONSE_3_RESP_MPDU_QUEUE4
			
			Field only valid when valid_qboost_queue_bitmap[4] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_3_RESP_MPDU_QUEUE4_OFFSET                    0x0000000c
#define QBOOST_RESPONSE_3_RESP_MPDU_QUEUE4_LSB                       0
#define QBOOST_RESPONSE_3_RESP_MPDU_QUEUE4_MASK                      0x00003fff

/* Description		QBOOST_RESPONSE_3_RESERVED_3A
			
			<legal 0>
*/
#define QBOOST_RESPONSE_3_RESERVED_3A_OFFSET                         0x0000000c
#define QBOOST_RESPONSE_3_RESERVED_3A_LSB                            14
#define QBOOST_RESPONSE_3_RESERVED_3A_MASK                           0x0000c000

/* Description		QBOOST_RESPONSE_3_RESP_MPDU_QUEUE5
			
			Field only valid when valid_qboost_queue_bitmap[5] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_3_RESP_MPDU_QUEUE5_OFFSET                    0x0000000c
#define QBOOST_RESPONSE_3_RESP_MPDU_QUEUE5_LSB                       16
#define QBOOST_RESPONSE_3_RESP_MPDU_QUEUE5_MASK                      0x3fff0000

/* Description		QBOOST_RESPONSE_3_RESERVED_3B
			
			<legal 0>
*/
#define QBOOST_RESPONSE_3_RESERVED_3B_OFFSET                         0x0000000c
#define QBOOST_RESPONSE_3_RESERVED_3B_LSB                            30
#define QBOOST_RESPONSE_3_RESERVED_3B_MASK                           0xc0000000

/* Description		QBOOST_RESPONSE_4_RESP_MPDU_QUEUE6
			
			Field only valid when valid_qboost_queue_bitmap[6] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_4_RESP_MPDU_QUEUE6_OFFSET                    0x00000010
#define QBOOST_RESPONSE_4_RESP_MPDU_QUEUE6_LSB                       0
#define QBOOST_RESPONSE_4_RESP_MPDU_QUEUE6_MASK                      0x00003fff

/* Description		QBOOST_RESPONSE_4_RESERVED_4A
			
			<legal 0>
*/
#define QBOOST_RESPONSE_4_RESERVED_4A_OFFSET                         0x00000010
#define QBOOST_RESPONSE_4_RESERVED_4A_LSB                            14
#define QBOOST_RESPONSE_4_RESERVED_4A_MASK                           0x0000c000

/* Description		QBOOST_RESPONSE_4_RESP_MPDU_QUEUE7
			
			Field only valid when valid_qboost_queue_bitmap[7] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_4_RESP_MPDU_QUEUE7_OFFSET                    0x00000010
#define QBOOST_RESPONSE_4_RESP_MPDU_QUEUE7_LSB                       16
#define QBOOST_RESPONSE_4_RESP_MPDU_QUEUE7_MASK                      0x3fff0000

/* Description		QBOOST_RESPONSE_4_RESERVED_4B
			
			<legal 0>
*/
#define QBOOST_RESPONSE_4_RESERVED_4B_OFFSET                         0x00000010
#define QBOOST_RESPONSE_4_RESERVED_4B_LSB                            30
#define QBOOST_RESPONSE_4_RESERVED_4B_MASK                           0xc0000000

/* Description		QBOOST_RESPONSE_5_RESP_MPDU_QUEUE8
			
			Field only valid when valid_qboost_queue_bitmap[8] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			 <legal all>
*/
#define QBOOST_RESPONSE_5_RESP_MPDU_QUEUE8_OFFSET                    0x00000014
#define QBOOST_RESPONSE_5_RESP_MPDU_QUEUE8_LSB                       0
#define QBOOST_RESPONSE_5_RESP_MPDU_QUEUE8_MASK                      0x00003fff

/* Description		QBOOST_RESPONSE_5_RESERVED_5A
			
			<legal 0>
*/
#define QBOOST_RESPONSE_5_RESERVED_5A_OFFSET                         0x00000014
#define QBOOST_RESPONSE_5_RESERVED_5A_LSB                            14
#define QBOOST_RESPONSE_5_RESERVED_5A_MASK                           0x0000c000

/* Description		QBOOST_RESPONSE_5_RESP_MPDU_QUEUE9
			
			Field only valid when valid_qboost_queue_bitmap[9] is
			set.
			
			
			
			The QID of an MPDU queue from which QBoost response data
			can be sent.
			
			<legal all>
*/
#define QBOOST_RESPONSE_5_RESP_MPDU_QUEUE9_OFFSET                    0x00000014
#define QBOOST_RESPONSE_5_RESP_MPDU_QUEUE9_LSB                       16
#define QBOOST_RESPONSE_5_RESP_MPDU_QUEUE9_MASK                      0x3fff0000

/* Description		QBOOST_RESPONSE_5_RESERVED_5B
			
			<legal 0>
*/
#define QBOOST_RESPONSE_5_RESERVED_5B_OFFSET                         0x00000014
#define QBOOST_RESPONSE_5_RESERVED_5B_LSB                            30
#define QBOOST_RESPONSE_5_RESERVED_5B_MASK                           0xc0000000

/* Description		QBOOST_RESPONSE_6_SCHEDULER_TLV_PTR
			
			The address location for the transmit TLVs.
			
			These TLVs get read/interpreted by the scheduler and
			when applicable pushed down the transmit chain to the other
			transmit modules. <legal all>
*/
#define QBOOST_RESPONSE_6_SCHEDULER_TLV_PTR_OFFSET                   0x00000018
#define QBOOST_RESPONSE_6_SCHEDULER_TLV_PTR_LSB                      0
#define QBOOST_RESPONSE_6_SCHEDULER_TLV_PTR_MASK                     0xffffffff

/* Description		QBOOST_RESPONSE_7_NEXT_Q_BITMAP_ID_TO_EVALUATE
			
			Only valid when RR_qid_selection is set.
			
			
			
			This field indicates the next queue bitmap id from which
			the scheduler should try to transmit first on reception of a
			new PS-POLL frame.
			
			
			
			This field is put in a separate word, as HW will update
			this field on regular basis.
			
			<legal 9-0>
*/
#define QBOOST_RESPONSE_7_NEXT_Q_BITMAP_ID_TO_EVALUATE_OFFSET        0x0000001c
#define QBOOST_RESPONSE_7_NEXT_Q_BITMAP_ID_TO_EVALUATE_LSB           0
#define QBOOST_RESPONSE_7_NEXT_Q_BITMAP_ID_TO_EVALUATE_MASK          0x0000000f

/* Description		QBOOST_RESPONSE_7_RESERVED_7
			
			<legal 0>
*/
#define QBOOST_RESPONSE_7_RESERVED_7_OFFSET                          0x0000001c
#define QBOOST_RESPONSE_7_RESERVED_7_LSB                             4
#define QBOOST_RESPONSE_7_RESERVED_7_MASK                            0xfffffff0


#endif // _QBOOST_RESPONSE_H_
