// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _MSDU_LINK_H_
#define _MSDU_LINK_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	next_msdu_index[15:0], encap_type[17:16], wds[18], reserved_0a[31:19]
//	1	msdu_link_ext_address[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_MSDU_LINK 2

struct msdu_link {
    volatile uint32_t next_msdu_index                 : 16, //[15:0]
                      encap_type                      :  2, //[17:16]
                      wds                             :  1, //[18]
                      reserved_0a                     : 13; //[31:19]
    volatile uint32_t msdu_link_ext_address           : 32; //[31:0]
};

/*

next_msdu_index
			
			The  index of the next MSDU frame  that is part of this
			A-MSDU.
			
			Value: 0x0 represents the NULL pointer.  <legal all>

encap_type
			
			Indicates the encapsulation that HW will perform:
			
			<enum 0 RAW> No encapsulation
			
			<enum 1 Native_WiFi>
			
			<enum 2 Ethernet> Ethernet 2 (DIX)  
			
			<enum 3 802_3> 802.3 (uses SNAP/LLC)
			
			Used by the OLE during encapsulation.
			
			
			
			Note: Enc_type shall have the same setting for all the
			MSDUs within and A-MSDU.
			
			
			
			<legal all>

wds
			
			The bit is only evaluated when this MSDU is the first
			MSDU in an MPDU. For other MSDUs this bit setting is
			ignored.
			
			
			
			If set the current packet is 4-address frame.  Required
			because an aggregate can include some frames with 3 address
			format and other frames with 4 address format.  
			
			Used by the OLE during encapsulation.  
			
			<legal all>

reserved_0a
			
			<legal 0>

msdu_link_ext_address
			
			Address of the linked msdu_link_ext
			
			<legal all>
*/


/* Description		MSDU_LINK_0_NEXT_MSDU_INDEX
			
			The  index of the next MSDU frame  that is part of this
			A-MSDU.
			
			Value: 0x0 represents the NULL pointer.  <legal all>
*/
#define MSDU_LINK_0_NEXT_MSDU_INDEX_OFFSET                           0x00000000
#define MSDU_LINK_0_NEXT_MSDU_INDEX_LSB                              0
#define MSDU_LINK_0_NEXT_MSDU_INDEX_MASK                             0x0000ffff

/* Description		MSDU_LINK_0_ENCAP_TYPE
			
			Indicates the encapsulation that HW will perform:
			
			<enum 0 RAW> No encapsulation
			
			<enum 1 Native_WiFi>
			
			<enum 2 Ethernet> Ethernet 2 (DIX)  
			
			<enum 3 802_3> 802.3 (uses SNAP/LLC)
			
			Used by the OLE during encapsulation.
			
			
			
			Note: Enc_type shall have the same setting for all the
			MSDUs within and A-MSDU.
			
			
			
			<legal all>
*/
#define MSDU_LINK_0_ENCAP_TYPE_OFFSET                                0x00000000
#define MSDU_LINK_0_ENCAP_TYPE_LSB                                   16
#define MSDU_LINK_0_ENCAP_TYPE_MASK                                  0x00030000

/* Description		MSDU_LINK_0_WDS
			
			The bit is only evaluated when this MSDU is the first
			MSDU in an MPDU. For other MSDUs this bit setting is
			ignored.
			
			
			
			If set the current packet is 4-address frame.  Required
			because an aggregate can include some frames with 3 address
			format and other frames with 4 address format.  
			
			Used by the OLE during encapsulation.  
			
			<legal all>
*/
#define MSDU_LINK_0_WDS_OFFSET                                       0x00000000
#define MSDU_LINK_0_WDS_LSB                                          18
#define MSDU_LINK_0_WDS_MASK                                         0x00040000

/* Description		MSDU_LINK_0_RESERVED_0A
			
			<legal 0>
*/
#define MSDU_LINK_0_RESERVED_0A_OFFSET                               0x00000000
#define MSDU_LINK_0_RESERVED_0A_LSB                                  19
#define MSDU_LINK_0_RESERVED_0A_MASK                                 0xfff80000

/* Description		MSDU_LINK_1_MSDU_LINK_EXT_ADDRESS
			
			Address of the linked msdu_link_ext
			
			<legal all>
*/
#define MSDU_LINK_1_MSDU_LINK_EXT_ADDRESS_OFFSET                     0x00000004
#define MSDU_LINK_1_MSDU_LINK_EXT_ADDRESS_LSB                        0
#define MSDU_LINK_1_MSDU_LINK_EXT_ADDRESS_MASK                       0xffffffff


#endif // _MSDU_LINK_H_
