// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _UPDATE_DESC_CMD_H_
#define _UPDATE_DESC_CMD_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	cmd_id[3:0], reserved_0a[7:4], sw_cmd_ref[15:8], desc_type[19:16], word_offset[24:20], reserved_0b[31:25]
//	1	desc_index[15:0], reserved_1[31:16]
//	2	data_mask[31:0]
//	3	new_data_value[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_UPDATE_DESC_CMD 4

struct update_desc_cmd {
    volatile uint32_t cmd_id                          :  4, //[3:0]
                      reserved_0a                     :  4, //[7:4]
                      sw_cmd_ref                      :  8, //[15:8]
                      desc_type                       :  4, //[19:16]
                      word_offset                     :  5, //[24:20]
                      reserved_0b                     :  7; //[31:25]
    volatile uint32_t desc_index                      : 16, //[15:0]
                      reserved_1                      : 16; //[31:16]
    volatile uint32_t data_mask                       : 32; //[31:0]
    volatile uint32_t new_data_value                  : 32; //[31:0]
};

/*

cmd_id
			
			Command ID:
			
			Set to 0x5 (which indicates Update Descriptor comand)
			<legal  5>

reserved_0a
			
			FW will set to 0, MAC will ignore.  <legal 0>

sw_cmd_ref
			
			SW command reference. A field only used by SW and
			ignored by QM. This field can aid SW to map this command to
			its originator and is used for tracking/debugging purposes. 
			<legal all>

desc_type
			
			The descriptor type, for which an update needs to
			happen. 
			
			<enum 0 mpdu_link_> 
			
			<enum 1 mpdu_link_ext_> 
			
			<enum 2 msdu_link_> 
			
			<enum 3 msdu_link_ext_> 
			
			<enum 4 mpdu_queue_> 
			
			<enum 5 mpdu_queue_ext_> 

word_offset
			
			The word offset of the word in the descriptor that needs
			to be updated by the QM <legal all>

reserved_0b
			
			FW will set to 0, MAC will ignore.  <legal 0>

desc_index
			
			The index of the descriptor for which an update needs to
			happen <legal all>

reserved_1
			
			FW will set to 0, MAC will ignore.  <legal 0>

data_mask
			
			Data mask. For each bit set in this mask, the QM update
			the corresponding bit in the descriptor word with the value
			indicated with the New_data_value field. The result is a
			read-modify-write operation on the descriptor word, with
			only those bits updated that were indicated in this field 
			<legal all>

new_data_value
			
			New data value.  <legal all>
*/


/* Description		UPDATE_DESC_CMD_0_CMD_ID
			
			Command ID:
			
			Set to 0x5 (which indicates Update Descriptor comand)
			<legal  5>
*/
#define UPDATE_DESC_CMD_0_CMD_ID_OFFSET                              0x00000000
#define UPDATE_DESC_CMD_0_CMD_ID_LSB                                 0
#define UPDATE_DESC_CMD_0_CMD_ID_MASK                                0x0000000f

/* Description		UPDATE_DESC_CMD_0_RESERVED_0A
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define UPDATE_DESC_CMD_0_RESERVED_0A_OFFSET                         0x00000000
#define UPDATE_DESC_CMD_0_RESERVED_0A_LSB                            4
#define UPDATE_DESC_CMD_0_RESERVED_0A_MASK                           0x000000f0

/* Description		UPDATE_DESC_CMD_0_SW_CMD_REF
			
			SW command reference. A field only used by SW and
			ignored by QM. This field can aid SW to map this command to
			its originator and is used for tracking/debugging purposes. 
			<legal all>
*/
#define UPDATE_DESC_CMD_0_SW_CMD_REF_OFFSET                          0x00000000
#define UPDATE_DESC_CMD_0_SW_CMD_REF_LSB                             8
#define UPDATE_DESC_CMD_0_SW_CMD_REF_MASK                            0x0000ff00

/* Description		UPDATE_DESC_CMD_0_DESC_TYPE
			
			The descriptor type, for which an update needs to
			happen. 
			
			<enum 0 mpdu_link_> 
			
			<enum 1 mpdu_link_ext_> 
			
			<enum 2 msdu_link_> 
			
			<enum 3 msdu_link_ext_> 
			
			<enum 4 mpdu_queue_> 
			
			<enum 5 mpdu_queue_ext_> 
*/
#define UPDATE_DESC_CMD_0_DESC_TYPE_OFFSET                           0x00000000
#define UPDATE_DESC_CMD_0_DESC_TYPE_LSB                              16
#define UPDATE_DESC_CMD_0_DESC_TYPE_MASK                             0x000f0000

/* Description		UPDATE_DESC_CMD_0_WORD_OFFSET
			
			The word offset of the word in the descriptor that needs
			to be updated by the QM <legal all>
*/
#define UPDATE_DESC_CMD_0_WORD_OFFSET_OFFSET                         0x00000000
#define UPDATE_DESC_CMD_0_WORD_OFFSET_LSB                            20
#define UPDATE_DESC_CMD_0_WORD_OFFSET_MASK                           0x01f00000

/* Description		UPDATE_DESC_CMD_0_RESERVED_0B
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define UPDATE_DESC_CMD_0_RESERVED_0B_OFFSET                         0x00000000
#define UPDATE_DESC_CMD_0_RESERVED_0B_LSB                            25
#define UPDATE_DESC_CMD_0_RESERVED_0B_MASK                           0xfe000000

/* Description		UPDATE_DESC_CMD_1_DESC_INDEX
			
			The index of the descriptor for which an update needs to
			happen <legal all>
*/
#define UPDATE_DESC_CMD_1_DESC_INDEX_OFFSET                          0x00000004
#define UPDATE_DESC_CMD_1_DESC_INDEX_LSB                             0
#define UPDATE_DESC_CMD_1_DESC_INDEX_MASK                            0x0000ffff

/* Description		UPDATE_DESC_CMD_1_RESERVED_1
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define UPDATE_DESC_CMD_1_RESERVED_1_OFFSET                          0x00000004
#define UPDATE_DESC_CMD_1_RESERVED_1_LSB                             16
#define UPDATE_DESC_CMD_1_RESERVED_1_MASK                            0xffff0000

/* Description		UPDATE_DESC_CMD_2_DATA_MASK
			
			Data mask. For each bit set in this mask, the QM update
			the corresponding bit in the descriptor word with the value
			indicated with the New_data_value field. The result is a
			read-modify-write operation on the descriptor word, with
			only those bits updated that were indicated in this field 
			<legal all>
*/
#define UPDATE_DESC_CMD_2_DATA_MASK_OFFSET                           0x00000008
#define UPDATE_DESC_CMD_2_DATA_MASK_LSB                              0
#define UPDATE_DESC_CMD_2_DATA_MASK_MASK                             0xffffffff

/* Description		UPDATE_DESC_CMD_3_NEW_DATA_VALUE
			
			New data value.  <legal all>
*/
#define UPDATE_DESC_CMD_3_NEW_DATA_VALUE_OFFSET                      0x0000000c
#define UPDATE_DESC_CMD_3_NEW_DATA_VALUE_LSB                         0
#define UPDATE_DESC_CMD_3_NEW_DATA_VALUE_MASK                        0xffffffff


#endif // _UPDATE_DESC_CMD_H_
