// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_FES_STATUS_H_
#define _TX_FES_STATUS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	schedule_id[15:0], schedule_cmd_ring_id[20:16], fes_control_mode[22:21], number_of_users[24:23], user_id[27:25], fes_transmit_result[31:28]
//	1	fes_error_status[7:0], reserved_1[11:8], phy_err_user_mask[15:12], transmit_fes_type[19:16], medium_prot_type[22:20], response_type[25:23], data_underflow_warning[27:26], schedule_try[31:28]
//	2	underflow_mpdu_cnt[5:0], qc_eosp_setting[6], fc_more_data_setting[7], fc_pwr_mgt_setting[8], mpdu_tx_cnt[15:9], underflow_byte_cnt[31:16]
//	3	start_seq_num[11:0], used_warm_tx[12], ndp_frame[13], cbf_bw_received[15:14], expect_cbf[16], cbf_user_number[18:17], cv_id[26:19], reserved_3[31:27]
//	4	seqnum_bitmap_31_0[31:0]
//	5	seqnum_bitmap_63_32[31:0]
//	6	response_frame_rcvd[2:0], ba_valid[3], ba_tid[7:4], reserved_6a[15:8], ba_start_seq_num[27:16], reserved_6b[31:28]
//	7	ba_bitmap_31_0[31:0]
//	8	ba_bitmap_63_32[31:0]
//	9	medium_prot_bandwidth[1:0], packet_bw[3:2], coex_abort_mpdu_cnt_valid[4], coex_abort_mpdu_cnt[11:5], tx_phy_error_status[19:12], reserved_9[31:20]
//	10	prot_timestamp[31:0]
//	11	ppdu_timestamp[31:0]
//	12	struct rx_location_info rx_location_info;
//	13	ack_rssi_chain0_pri20[7:0], ack_rssi_chain0_sec20[15:8], ack_rssi_chain0_sec40[23:16], ack_rssi_chain0_sec80[31:24]
//	14	ack_rssi_chain1_pri20[7:0], ack_rssi_chain1_sec20[15:8], ack_rssi_chain1_sec40[23:16], ack_rssi_chain1_sec80[31:24]
//	15	ack_rssi_chain2_pri20[7:0], ack_rssi_chain2_sec20[15:8], ack_rssi_chain2_sec40[23:16], ack_rssi_chain2_sec80[31:24]
//	16	ack_rssi_chain3_pri20[7:0], ack_rssi_chain3_sec20[15:8], ack_rssi_chain3_sec40[23:16], ack_rssi_chain3_sec80[31:24]
//	17	ack_rssi_ave[7:0], reserved_18[31:8]
//	18	phy_timestamp_1[31:0]
//	19	phy_timestamp_2[31:0]
//	20	l_sig[31:0]
//	21	ht_sig_vht_sig_a_1[31:0]
//	22	ht_sig_vht_sig_a_2[31:0]
//	23	vht_sig_b_user0[31:0]
//	24	vht_sig_b_user1[31:0]
//	25	vht_sig_b_user2[31:0]
//	26	tx_service[31:0]
//	27	tx_phy_desc_1[31:0]
//	28	tx_phy_desc_2[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_FES_STATUS 29

struct tx_fes_status {
    volatile uint32_t schedule_id                     : 16, //[15:0]
                      schedule_cmd_ring_id            :  5, //[20:16]
                      fes_control_mode                :  2, //[22:21]
                      number_of_users                 :  2, //[24:23]
                      user_id                         :  3, //[27:25]
                      fes_transmit_result             :  4; //[31:28]
    volatile uint32_t fes_error_status                :  8, //[7:0]
                      reserved_1                      :  4, //[11:8]
                      phy_err_user_mask               :  4, //[15:12]
                      transmit_fes_type               :  4, //[19:16]
                      medium_prot_type                :  3, //[22:20]
                      response_type                   :  3, //[25:23]
                      data_underflow_warning          :  2, //[27:26]
                      schedule_try                    :  4; //[31:28]
    volatile uint32_t underflow_mpdu_cnt              :  6, //[5:0]
                      qc_eosp_setting                 :  1, //[6]
                      fc_more_data_setting            :  1, //[7]
                      fc_pwr_mgt_setting              :  1, //[8]
                      mpdu_tx_cnt                     :  7, //[15:9]
                      underflow_byte_cnt              : 16; //[31:16]
    volatile uint32_t start_seq_num                   : 12, //[11:0]
                      used_warm_tx                    :  1, //[12]
                      ndp_frame                       :  1, //[13]
                      cbf_bw_received                 :  2, //[15:14]
                      expect_cbf                      :  1, //[16]
                      cbf_user_number                 :  2, //[18:17]
                      cv_id                           :  8, //[26:19]
                      reserved_3                      :  5; //[31:27]
    volatile uint32_t seqnum_bitmap_31_0              : 32; //[31:0]
    volatile uint32_t seqnum_bitmap_63_32             : 32; //[31:0]
    volatile uint32_t response_frame_rcvd             :  3, //[2:0]
                      ba_valid                        :  1, //[3]
                      ba_tid                          :  4, //[7:4]
                      reserved_6a                     :  8, //[15:8]
                      ba_start_seq_num                : 12, //[27:16]
                      reserved_6b                     :  4; //[31:28]
    volatile uint32_t ba_bitmap_31_0                  : 32; //[31:0]
    volatile uint32_t ba_bitmap_63_32                 : 32; //[31:0]
    volatile uint32_t medium_prot_bandwidth           :  2, //[1:0]
                      packet_bw                       :  2, //[3:2]
                      coex_abort_mpdu_cnt_valid       :  1, //[4]
                      coex_abort_mpdu_cnt             :  7, //[11:5]
                      tx_phy_error_status             :  8, //[19:12]
                      reserved_9                      : 12; //[31:20]
    volatile uint32_t prot_timestamp                  : 32; //[31:0]
    volatile uint32_t ppdu_timestamp                  : 32; //[31:0]
    struct            rx_location_info                       rx_location_info;
    volatile uint32_t ack_rssi_chain0_pri20           :  8, //[7:0]
                      ack_rssi_chain0_sec20           :  8, //[15:8]
                      ack_rssi_chain0_sec40           :  8, //[23:16]
                      ack_rssi_chain0_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_chain1_pri20           :  8, //[7:0]
                      ack_rssi_chain1_sec20           :  8, //[15:8]
                      ack_rssi_chain1_sec40           :  8, //[23:16]
                      ack_rssi_chain1_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_chain2_pri20           :  8, //[7:0]
                      ack_rssi_chain2_sec20           :  8, //[15:8]
                      ack_rssi_chain2_sec40           :  8, //[23:16]
                      ack_rssi_chain2_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_chain3_pri20           :  8, //[7:0]
                      ack_rssi_chain3_sec20           :  8, //[15:8]
                      ack_rssi_chain3_sec40           :  8, //[23:16]
                      ack_rssi_chain3_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_ave                    :  8, //[7:0]
                      reserved_18                     : 24; //[31:8]
    volatile uint32_t phy_timestamp_1                 : 32; //[31:0]
    volatile uint32_t phy_timestamp_2                 : 32; //[31:0]
    volatile uint32_t l_sig                           : 32; //[31:0]
    volatile uint32_t ht_sig_vht_sig_a_1              : 32; //[31:0]
    volatile uint32_t ht_sig_vht_sig_a_2              : 32; //[31:0]
    volatile uint32_t vht_sig_b_user0                 : 32; //[31:0]
    volatile uint32_t vht_sig_b_user1                 : 32; //[31:0]
    volatile uint32_t vht_sig_b_user2                 : 32; //[31:0]
    volatile uint32_t tx_service                      : 32; //[31:0]
    volatile uint32_t tx_phy_desc_1                   : 32; //[31:0]
    volatile uint32_t tx_phy_desc_2                   : 32; //[31:0]
};

/*

schedule_id
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.

schedule_cmd_ring_id
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>

fes_control_mode
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>

number_of_users
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users

user_id
			
			The user ID for this FES status 
			
			0: User 0
			
			1: User 1
			
			2: User 2
			
			7-3: Reserved

fes_transmit_result
			
			Transmit result:
			
			
			
			<enum 0 tx_ok> Successful transmission of entire Frame
			exchange sequence
			
			<enum 1 prot_resp_rx_timeout> No protection response
			frame received so timeout is triggered.
			
			<enum 2 ppdu_resp_rx_timeout> No PPDU response frame
			received so timeout is triggered. 
			
			<enum 3 flush_cmd_rcvd> Flush command received
			
			In case of transmitting self generated BAR, DataNull or
			QoSDataNull frame and no BAR or ACK frame is received this
			indication is also set (Not supported in Beeliner)
			
			<enum 4 fes_error> MAC HW error resulting in abort:
			Error details located in fes_error_status field
			
			<enum 5 tx_phy_error> PHY error resulting in abort.
			Error details located in tx_phy_error_status field
			
			<enum 6 resp_frame_crc_err> Response frame was received
			with an invalid FCS.
			
			<enum 7 SU_Response_type_mismatch> Response frame is
			received without CRC error but it's not matched with
			expected SU_Response_type. 
			
			<enum 8 cbf_mimo_ctrl_mismatch> Set if CBF is received
			without any error but the Nr, Nc, BW, type or token in VHT
			MIMO control field is not matched with expected values which
			are specified by TX_FES_SETUP.cbf_* fields. 
			
			<legal 0-2, 4-8>

fes_error_status
			
			Field only valid when fes_transmit_result is set to 4:
			MAC HW error.
			
			
			
			<enum 0 no_error>
			
			<enum 1 preamble_timeout>
			
			
			
			<legal 0-1>

reserved_1
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

phy_err_user_mask
			
			Indicates which users this message relates to. This
			field is only valid for error conditions that are
			user-specific.
			
			
			
			<legal 0-7>

transmit_fes_type
			
			<enum 0 regular_transmission>  A Scheduled SU or MU
			transmission
			
			
			
			15-1 Reserved
			
			<legal 0>

medium_prot_type
			
			Self Gen Medium Protection type used
			
			<enum 0 No_protection>
			
			<enum 1 RTS_legacy>
			
			<enum 2 RTS_11ac_static_bw>
			
			<enum 3 RTS_11ac_dynamic_bw>
			
			<enum 4 CTS2Self>
			
			<legal 0-4>
			
			Field only valid for user0 FES status.

response_type
			
			PPDU transmission Response type expected:
			
			
			
			<enum 0 No_response_expected>
			
			<enum 1 ACK_expected>
			
			<enum 2 BA_expected>
			
			<enum 3 ActionNoAck_expected> SW sets this after sending
			NDP or BR-Poll.
			
			<enum 4 ACK_BA_expected> SW sets this after sending VHT
			single MPDU. Some vendor chip might send BA rather than ACK
			in response to VHT single MPDU but still we want to accept
			BA as well. That's why this type is added.   
			
			<enum 5 CTS_expected> SW sets this after queuing RTS
			frame as standalone packet and sending it.  
			
			<enum 6 ACK_Data_expected> SW sets this after sending
			PS-Poll. 
			
			<enum 7 Any_response_accepted> SW sets this if SW wants
			to accept any directed CRC-pass frame while waiting for
			response. This is mainly for debug purpose.
			
			<legal all>

data_underflow_warning
			
			Mac data underflow warning for this user
			
			
			
			<enum 0 no_data_underrun> No data underflow
			
			<enum 1 data_underrun_between_mpdu> PCU experienced data
			underflow in between MPDUs
			
			<enum 2 data_underrun_within_mpdu> PCU experienced data
			underflow within an MPDU
			
			<legal 0-2>

schedule_try
			
			The number of times this scheduler command has been
			tried
			
			<legal all>

underflow_mpdu_cnt
			
			The MPDU count correctly received from TX DMA when the
			first underrun condition was detected

qc_eosp_setting
			
			This field indicates if TX PCU set the eosp bit in the
			QoS control field for this user (indicated in field
			User_Id.)
			
			0: No action
			
			1: eosp bit is set in all the transmitted frames. This
			is done upon request of the PDG.
			
			<legal all>

fc_more_data_setting
			
			This field indicates if TX PCU set the More data bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			
			
			0: No action
			
			1: More Data bit is set in all the transmitted frames.
			This is done upon request of the PDG.
			
			<legal all>

fc_pwr_mgt_setting
			
			This field indicates if TX PCU set the pwr_mgt  bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			0: pwr_mgt bit NOT set
			
			1: pwr_mgt bit is set
			
			<legal all>

mpdu_tx_cnt
			
			Number of MPDU frames transmitted 
			
			This is the actual amount of frame transmitted, taking
			underflow scenarios and transmit aborts due to BT
			coexistence into account.

underflow_byte_cnt
			
			The (A)MPDU byte count correctly received from TX DMA
			when the first underrun condition was detected

start_seq_num
			
			Indicates the sequence number of the head MPDU
			transmitted.

used_warm_tx
			
			If set indicates that this PPDU was transmitted with
			warm TX.

ndp_frame
			
			Bit copied from the TX_FES_SETUP TLV

cbf_bw_received
			
			Field only valid when ndp_frame is set.
			
			
			
			<enum 0  20MHz_cbf> cbf BW is 20 Mhz
			
			<enum 1  40MHz_cbf> cbf BW is 40 Mhz
			
			<enum 2  80MHz_cbf> cbf BW is 80 Mhz
			
			
			
			<legal 0-2>

expect_cbf
			
			Bit copied from tx_fes_setup.send_tx_expect_cbf

cbf_user_number
			
			Bit copied from tx_fes_setup.cbf_user_number

cv_id
			
			Bit copied from tx_fes_setup.cv_id

reserved_3
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

seqnum_bitmap_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap. 
			This field is used to specify the sequence numbers of all
			the MPDU in this PPDU based on the start_seq_num field
			<legal all>

seqnum_bitmap_63_32
			
			Upper 32 bits of the 64 bit sequence number bitmap.  See
			description for seq_num_bitmap_31_0. <legal all>

response_frame_rcvd
			
			
			
			<enum 0 no_resp_rcvd> No response frame received
			
			<enum 1 ACK_rcvd> ACk frame received  (QM removes the
			head frame of the queue)
			
			<enum 2 BA_rcvd> BA frame received (QM removes the
			acknowledged frames (in BA bitmap) from the queue.
			
			<enum 3 ActionNoAck_rcvd>
			
			<enum 4 data_rcvd> Data frame received (Unicast data
			frame is received after transmitting PS-Poll)
			
			<enum 5 CTS_rcvd>
			
			<enum 6 Others_rcvd> Frame not defined above is
			received. 
			
			<legal 0-6>
			
			(In case of HW transmit mode, field snooped by QM, to
			determine if frames should be removed from the queue)

ba_valid
			
			When set, all the BA related fields are valid

ba_tid
			
			Tid field of the BA frame

reserved_6a
			
			0

ba_start_seq_num
			
			Only valid when Response frame is BA frame
			
			The start sequence number in the BA frame

reserved_6b
			
			0

ba_bitmap_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.

ba_bitmap_63_32
			
			The upper 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.

medium_prot_bandwidth
			
			Indicates the bandwidth used to transmit the Medium
			protection frame. Only valid when field 'Medium_Prot_type'
			indicates
			
			
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>

packet_bw
			
			Indicates the bandwidth used to transmit data packet or
			self gen(non medium protection) frame.  Only valid if the
			packet bit is also set.
			
			
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>

coex_abort_mpdu_cnt_valid
			
			When set to 1, the (A-MPDU) transmission was silently
			aborted in the middle of transmission. The PHY faked the
			remaining transmission on the medium, so that TX PCU is
			still waiting for the BA frame to be received.  

coex_abort_mpdu_cnt
			
			Field only valid when 'Coex_abort_mpdu_cnt_valid' is
			set.
			
			The number of MPDU frames that were properly sent before
			the coex transmit abort request was received

tx_phy_error_status
			
			<enum_typedef tx_pkt_end status>
			
			<enum 1 error_tx_underrun> PHY ran out of transmit data
			due to transmit underrun - this field is user-specific (see
			user_mask field)
			
			<enum 2 error_tx_chain_mask_zero>
			
			<enum 3 error_tx_extra_sym_mismatch>
			
			<enum 4 error_tx_vht_length_not_multiple_of_3>
			
			<enum 5 error_tx_bw_is_gt_dyn_bw>
			
			<enum 6 error_tx_11b_rate_illegal>
			
			<enum 7 error_tx_legacy_rate_illegal>
			
			<enum 8 error_tx_ht_rate_illegal>
			
			<enum 9 error_tx_vht_rate_illegal>
			
			<enum 10 error_tx_overflow>
			
			<enum 11 error_mac_tx_abort>
			
			<enum 12 error_mac_rf_only_abort>
			
			<enum 13 error_unsupported_cbf>
			
			<enum 14 error_cv_static_bandwidth_mismatch>
			
			<enum 15 error_cv_dynamic_bandwidth_mismatch>
			
			<enum 16 error_cv_unsupported_nss_total>
			
			<enum 17 error_nss_bf_params_mismatch>
			
			<enum 18 error_txbf_fail>
			
			<enum 19 error_illegal_nss>
			
			<enum 20 error_otp_txbf>
			
			<legal 1-20>

reserved_9
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

prot_timestamp
			
			Global timer value at start of Protection transmission

ppdu_timestamp
			
			Global timer value at start of PPDU transmission

struct rx_location_info rx_location_info
			
			Format defined in MAC_PHY interface

ack_rssi_chain0_pri20
			
			RSSI of Ack on chain 0 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain0_sec20
			
			RSSI of Ack on chain 0 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain0_sec40
			
			RSSI of Ack on chain 0 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain0_sec80
			
			RSSI of Ack on chain 0 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_pri20
			
			RSSI of Ack on chain 1 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_sec20
			
			RSSI of Ack on chain 1 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_sec40
			
			RSSI of Ack on chain 1 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_sec80
			
			RSSI of Ack on chain 1 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_pri20
			
			RSSI of Ack on chain 2 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_sec20
			
			RSSI of Ack on chain 2 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_sec40
			
			RSSI of Ack on chain 2 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_sec80
			
			RSSI of Ack on chain 2 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_pri20
			
			RSSI of Ack on chain 3 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_sec20
			
			RSSI of Ack on chain 3 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_sec40
			
			RSSI of Ack on chain 3 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_sec80
			
			RSSI of Ack on chain 3 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_ave
			
			RSSI of Ack of all active chains and bandwidths.
			
			Value of 0x80 indicates invalid.

reserved_18
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

phy_timestamp_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.

phy_timestamp_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.

l_sig
			
			The Struct L_SIG_B or Struct L_SIG_A sent to PHY is
			copied here. 
			
			
			
			Note that all of these preamble informations from l_sig
			field up to tx_phy_desc_1/2 field are copied from PPDU
			frame, not protection (MPROT) frame.  

ht_sig_vht_sig_a_1
			
			The 1st dword of Struct HT_SIG or Struct VHT_SIG_A sent
			to PHY is copied here. Set to 0 if not present. 

ht_sig_vht_sig_a_2
			
			The 2nd dword of Struct HT_SIG or Struct VHT_SIG_A sent
			to PHY is copied here. Set to 0 if not present. 

vht_sig_b_user0
			
			The 1st dword of Struct VHT_SIG_B of user0 sent to PHY
			is copied here. Set to 0 if not present. 

vht_sig_b_user1
			
			The 1st dword of Struct VHT_SIG_B of user1 sent to PHY
			is copied here. Set to 0 if not present.

vht_sig_b_user2
			
			The 1st dword of Struct VHT_SIG_B of user2 sent to PHY
			is copied here. Set to 0 if not present.

tx_service
			
			The Struct TX_SERVICE sent to PHY is copied here.

tx_phy_desc_1
			
			The 1st dword of Struct TX_PHY_DESC sent to PHY is
			copied here. The pkt_type in TX_PHY_DESC will tell which
			preamble fields like l_sig, ht_sig, vht_sig are valid. 

tx_phy_desc_2
			
			The 2nd dword of Struct TX_PHY_DESC sent to PHY is
			copied here.
*/


/* Description		TX_FES_STATUS_0_SCHEDULE_ID
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.
*/
#define TX_FES_STATUS_0_SCHEDULE_ID_OFFSET                           0x00000000
#define TX_FES_STATUS_0_SCHEDULE_ID_LSB                              0
#define TX_FES_STATUS_0_SCHEDULE_ID_MASK                             0x0000ffff

/* Description		TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>
*/
#define TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID_OFFSET                  0x00000000
#define TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID_LSB                     16
#define TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID_MASK                    0x001f0000

/* Description		TX_FES_STATUS_0_FES_CONTROL_MODE
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>
*/
#define TX_FES_STATUS_0_FES_CONTROL_MODE_OFFSET                      0x00000000
#define TX_FES_STATUS_0_FES_CONTROL_MODE_LSB                         21
#define TX_FES_STATUS_0_FES_CONTROL_MODE_MASK                        0x00600000

/* Description		TX_FES_STATUS_0_NUMBER_OF_USERS
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users
*/
#define TX_FES_STATUS_0_NUMBER_OF_USERS_OFFSET                       0x00000000
#define TX_FES_STATUS_0_NUMBER_OF_USERS_LSB                          23
#define TX_FES_STATUS_0_NUMBER_OF_USERS_MASK                         0x01800000

/* Description		TX_FES_STATUS_0_USER_ID
			
			The user ID for this FES status 
			
			0: User 0
			
			1: User 1
			
			2: User 2
			
			7-3: Reserved
*/
#define TX_FES_STATUS_0_USER_ID_OFFSET                               0x00000000
#define TX_FES_STATUS_0_USER_ID_LSB                                  25
#define TX_FES_STATUS_0_USER_ID_MASK                                 0x0e000000

/* Description		TX_FES_STATUS_0_FES_TRANSMIT_RESULT
			
			Transmit result:
			
			
			
			<enum 0 tx_ok> Successful transmission of entire Frame
			exchange sequence
			
			<enum 1 prot_resp_rx_timeout> No protection response
			frame received so timeout is triggered.
			
			<enum 2 ppdu_resp_rx_timeout> No PPDU response frame
			received so timeout is triggered. 
			
			<enum 3 flush_cmd_rcvd> Flush command received
			
			In case of transmitting self generated BAR, DataNull or
			QoSDataNull frame and no BAR or ACK frame is received this
			indication is also set (Not supported in Beeliner)
			
			<enum 4 fes_error> MAC HW error resulting in abort:
			Error details located in fes_error_status field
			
			<enum 5 tx_phy_error> PHY error resulting in abort.
			Error details located in tx_phy_error_status field
			
			<enum 6 resp_frame_crc_err> Response frame was received
			with an invalid FCS.
			
			<enum 7 SU_Response_type_mismatch> Response frame is
			received without CRC error but it's not matched with
			expected SU_Response_type. 
			
			<enum 8 cbf_mimo_ctrl_mismatch> Set if CBF is received
			without any error but the Nr, Nc, BW, type or token in VHT
			MIMO control field is not matched with expected values which
			are specified by TX_FES_SETUP.cbf_* fields. 
			
			<legal 0-2, 4-8>
*/
#define TX_FES_STATUS_0_FES_TRANSMIT_RESULT_OFFSET                   0x00000000
#define TX_FES_STATUS_0_FES_TRANSMIT_RESULT_LSB                      28
#define TX_FES_STATUS_0_FES_TRANSMIT_RESULT_MASK                     0xf0000000

/* Description		TX_FES_STATUS_1_FES_ERROR_STATUS
			
			Field only valid when fes_transmit_result is set to 4:
			MAC HW error.
			
			
			
			<enum 0 no_error>
			
			<enum 1 preamble_timeout>
			
			
			
			<legal 0-1>
*/
#define TX_FES_STATUS_1_FES_ERROR_STATUS_OFFSET                      0x00000004
#define TX_FES_STATUS_1_FES_ERROR_STATUS_LSB                         0
#define TX_FES_STATUS_1_FES_ERROR_STATUS_MASK                        0x000000ff

/* Description		TX_FES_STATUS_1_RESERVED_1
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_1_RESERVED_1_OFFSET                            0x00000004
#define TX_FES_STATUS_1_RESERVED_1_LSB                               8
#define TX_FES_STATUS_1_RESERVED_1_MASK                              0x00000f00

/* Description		TX_FES_STATUS_1_PHY_ERR_USER_MASK
			
			Indicates which users this message relates to. This
			field is only valid for error conditions that are
			user-specific.
			
			
			
			<legal 0-7>
*/
#define TX_FES_STATUS_1_PHY_ERR_USER_MASK_OFFSET                     0x00000004
#define TX_FES_STATUS_1_PHY_ERR_USER_MASK_LSB                        12
#define TX_FES_STATUS_1_PHY_ERR_USER_MASK_MASK                       0x0000f000

/* Description		TX_FES_STATUS_1_TRANSMIT_FES_TYPE
			
			<enum 0 regular_transmission>  A Scheduled SU or MU
			transmission
			
			
			
			15-1 Reserved
			
			<legal 0>
*/
#define TX_FES_STATUS_1_TRANSMIT_FES_TYPE_OFFSET                     0x00000004
#define TX_FES_STATUS_1_TRANSMIT_FES_TYPE_LSB                        16
#define TX_FES_STATUS_1_TRANSMIT_FES_TYPE_MASK                       0x000f0000

/* Description		TX_FES_STATUS_1_MEDIUM_PROT_TYPE
			
			Self Gen Medium Protection type used
			
			<enum 0 No_protection>
			
			<enum 1 RTS_legacy>
			
			<enum 2 RTS_11ac_static_bw>
			
			<enum 3 RTS_11ac_dynamic_bw>
			
			<enum 4 CTS2Self>
			
			<legal 0-4>
			
			Field only valid for user0 FES status.
*/
#define TX_FES_STATUS_1_MEDIUM_PROT_TYPE_OFFSET                      0x00000004
#define TX_FES_STATUS_1_MEDIUM_PROT_TYPE_LSB                         20
#define TX_FES_STATUS_1_MEDIUM_PROT_TYPE_MASK                        0x00700000

/* Description		TX_FES_STATUS_1_RESPONSE_TYPE
			
			PPDU transmission Response type expected:
			
			
			
			<enum 0 No_response_expected>
			
			<enum 1 ACK_expected>
			
			<enum 2 BA_expected>
			
			<enum 3 ActionNoAck_expected> SW sets this after sending
			NDP or BR-Poll.
			
			<enum 4 ACK_BA_expected> SW sets this after sending VHT
			single MPDU. Some vendor chip might send BA rather than ACK
			in response to VHT single MPDU but still we want to accept
			BA as well. That's why this type is added.   
			
			<enum 5 CTS_expected> SW sets this after queuing RTS
			frame as standalone packet and sending it.  
			
			<enum 6 ACK_Data_expected> SW sets this after sending
			PS-Poll. 
			
			<enum 7 Any_response_accepted> SW sets this if SW wants
			to accept any directed CRC-pass frame while waiting for
			response. This is mainly for debug purpose.
			
			<legal all>
*/
#define TX_FES_STATUS_1_RESPONSE_TYPE_OFFSET                         0x00000004
#define TX_FES_STATUS_1_RESPONSE_TYPE_LSB                            23
#define TX_FES_STATUS_1_RESPONSE_TYPE_MASK                           0x03800000

/* Description		TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING
			
			Mac data underflow warning for this user
			
			
			
			<enum 0 no_data_underrun> No data underflow
			
			<enum 1 data_underrun_between_mpdu> PCU experienced data
			underflow in between MPDUs
			
			<enum 2 data_underrun_within_mpdu> PCU experienced data
			underflow within an MPDU
			
			<legal 0-2>
*/
#define TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING_OFFSET                0x00000004
#define TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING_LSB                   26
#define TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING_MASK                  0x0c000000

/* Description		TX_FES_STATUS_1_SCHEDULE_TRY
			
			The number of times this scheduler command has been
			tried
			
			<legal all>
*/
#define TX_FES_STATUS_1_SCHEDULE_TRY_OFFSET                          0x00000004
#define TX_FES_STATUS_1_SCHEDULE_TRY_LSB                             28
#define TX_FES_STATUS_1_SCHEDULE_TRY_MASK                            0xf0000000

/* Description		TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT
			
			The MPDU count correctly received from TX DMA when the
			first underrun condition was detected
*/
#define TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT_OFFSET                    0x00000008
#define TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT_LSB                       0
#define TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT_MASK                      0x0000003f

/* Description		TX_FES_STATUS_2_QC_EOSP_SETTING
			
			This field indicates if TX PCU set the eosp bit in the
			QoS control field for this user (indicated in field
			User_Id.)
			
			0: No action
			
			1: eosp bit is set in all the transmitted frames. This
			is done upon request of the PDG.
			
			<legal all>
*/
#define TX_FES_STATUS_2_QC_EOSP_SETTING_OFFSET                       0x00000008
#define TX_FES_STATUS_2_QC_EOSP_SETTING_LSB                          6
#define TX_FES_STATUS_2_QC_EOSP_SETTING_MASK                         0x00000040

/* Description		TX_FES_STATUS_2_FC_MORE_DATA_SETTING
			
			This field indicates if TX PCU set the More data bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			
			
			0: No action
			
			1: More Data bit is set in all the transmitted frames.
			This is done upon request of the PDG.
			
			<legal all>
*/
#define TX_FES_STATUS_2_FC_MORE_DATA_SETTING_OFFSET                  0x00000008
#define TX_FES_STATUS_2_FC_MORE_DATA_SETTING_LSB                     7
#define TX_FES_STATUS_2_FC_MORE_DATA_SETTING_MASK                    0x00000080

/* Description		TX_FES_STATUS_2_FC_PWR_MGT_SETTING
			
			This field indicates if TX PCU set the pwr_mgt  bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			0: pwr_mgt bit NOT set
			
			1: pwr_mgt bit is set
			
			<legal all>
*/
#define TX_FES_STATUS_2_FC_PWR_MGT_SETTING_OFFSET                    0x00000008
#define TX_FES_STATUS_2_FC_PWR_MGT_SETTING_LSB                       8
#define TX_FES_STATUS_2_FC_PWR_MGT_SETTING_MASK                      0x00000100

/* Description		TX_FES_STATUS_2_MPDU_TX_CNT
			
			Number of MPDU frames transmitted 
			
			This is the actual amount of frame transmitted, taking
			underflow scenarios and transmit aborts due to BT
			coexistence into account.
*/
#define TX_FES_STATUS_2_MPDU_TX_CNT_OFFSET                           0x00000008
#define TX_FES_STATUS_2_MPDU_TX_CNT_LSB                              9
#define TX_FES_STATUS_2_MPDU_TX_CNT_MASK                             0x0000fe00

/* Description		TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT
			
			The (A)MPDU byte count correctly received from TX DMA
			when the first underrun condition was detected
*/
#define TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT_OFFSET                    0x00000008
#define TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT_LSB                       16
#define TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT_MASK                      0xffff0000

/* Description		TX_FES_STATUS_3_START_SEQ_NUM
			
			Indicates the sequence number of the head MPDU
			transmitted.
*/
#define TX_FES_STATUS_3_START_SEQ_NUM_OFFSET                         0x0000000c
#define TX_FES_STATUS_3_START_SEQ_NUM_LSB                            0
#define TX_FES_STATUS_3_START_SEQ_NUM_MASK                           0x00000fff

/* Description		TX_FES_STATUS_3_USED_WARM_TX
			
			If set indicates that this PPDU was transmitted with
			warm TX.
*/
#define TX_FES_STATUS_3_USED_WARM_TX_OFFSET                          0x0000000c
#define TX_FES_STATUS_3_USED_WARM_TX_LSB                             12
#define TX_FES_STATUS_3_USED_WARM_TX_MASK                            0x00001000

/* Description		TX_FES_STATUS_3_NDP_FRAME
			
			Bit copied from the TX_FES_SETUP TLV
*/
#define TX_FES_STATUS_3_NDP_FRAME_OFFSET                             0x0000000c
#define TX_FES_STATUS_3_NDP_FRAME_LSB                                13
#define TX_FES_STATUS_3_NDP_FRAME_MASK                               0x00002000

/* Description		TX_FES_STATUS_3_CBF_BW_RECEIVED
			
			Field only valid when ndp_frame is set.
			
			
			
			<enum 0  20MHz_cbf> cbf BW is 20 Mhz
			
			<enum 1  40MHz_cbf> cbf BW is 40 Mhz
			
			<enum 2  80MHz_cbf> cbf BW is 80 Mhz
			
			
			
			<legal 0-2>
*/
#define TX_FES_STATUS_3_CBF_BW_RECEIVED_OFFSET                       0x0000000c
#define TX_FES_STATUS_3_CBF_BW_RECEIVED_LSB                          14
#define TX_FES_STATUS_3_CBF_BW_RECEIVED_MASK                         0x0000c000

/* Description		TX_FES_STATUS_3_EXPECT_CBF
			
			Bit copied from tx_fes_setup.send_tx_expect_cbf
*/
#define TX_FES_STATUS_3_EXPECT_CBF_OFFSET                            0x0000000c
#define TX_FES_STATUS_3_EXPECT_CBF_LSB                               16
#define TX_FES_STATUS_3_EXPECT_CBF_MASK                              0x00010000

/* Description		TX_FES_STATUS_3_CBF_USER_NUMBER
			
			Bit copied from tx_fes_setup.cbf_user_number
*/
#define TX_FES_STATUS_3_CBF_USER_NUMBER_OFFSET                       0x0000000c
#define TX_FES_STATUS_3_CBF_USER_NUMBER_LSB                          17
#define TX_FES_STATUS_3_CBF_USER_NUMBER_MASK                         0x00060000

/* Description		TX_FES_STATUS_3_CV_ID
			
			Bit copied from tx_fes_setup.cv_id
*/
#define TX_FES_STATUS_3_CV_ID_OFFSET                                 0x0000000c
#define TX_FES_STATUS_3_CV_ID_LSB                                    19
#define TX_FES_STATUS_3_CV_ID_MASK                                   0x07f80000

/* Description		TX_FES_STATUS_3_RESERVED_3
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_3_RESERVED_3_OFFSET                            0x0000000c
#define TX_FES_STATUS_3_RESERVED_3_LSB                               27
#define TX_FES_STATUS_3_RESERVED_3_MASK                              0xf8000000

/* Description		TX_FES_STATUS_4_SEQNUM_BITMAP_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap. 
			This field is used to specify the sequence numbers of all
			the MPDU in this PPDU based on the start_seq_num field
			<legal all>
*/
#define TX_FES_STATUS_4_SEQNUM_BITMAP_31_0_OFFSET                    0x00000010
#define TX_FES_STATUS_4_SEQNUM_BITMAP_31_0_LSB                       0
#define TX_FES_STATUS_4_SEQNUM_BITMAP_31_0_MASK                      0xffffffff

/* Description		TX_FES_STATUS_5_SEQNUM_BITMAP_63_32
			
			Upper 32 bits of the 64 bit sequence number bitmap.  See
			description for seq_num_bitmap_31_0. <legal all>
*/
#define TX_FES_STATUS_5_SEQNUM_BITMAP_63_32_OFFSET                   0x00000014
#define TX_FES_STATUS_5_SEQNUM_BITMAP_63_32_LSB                      0
#define TX_FES_STATUS_5_SEQNUM_BITMAP_63_32_MASK                     0xffffffff

/* Description		TX_FES_STATUS_6_RESPONSE_FRAME_RCVD
			
			
			
			<enum 0 no_resp_rcvd> No response frame received
			
			<enum 1 ACK_rcvd> ACk frame received  (QM removes the
			head frame of the queue)
			
			<enum 2 BA_rcvd> BA frame received (QM removes the
			acknowledged frames (in BA bitmap) from the queue.
			
			<enum 3 ActionNoAck_rcvd>
			
			<enum 4 data_rcvd> Data frame received (Unicast data
			frame is received after transmitting PS-Poll)
			
			<enum 5 CTS_rcvd>
			
			<enum 6 Others_rcvd> Frame not defined above is
			received. 
			
			<legal 0-6>
			
			(In case of HW transmit mode, field snooped by QM, to
			determine if frames should be removed from the queue)
*/
#define TX_FES_STATUS_6_RESPONSE_FRAME_RCVD_OFFSET                   0x00000018
#define TX_FES_STATUS_6_RESPONSE_FRAME_RCVD_LSB                      0
#define TX_FES_STATUS_6_RESPONSE_FRAME_RCVD_MASK                     0x00000007

/* Description		TX_FES_STATUS_6_BA_VALID
			
			When set, all the BA related fields are valid
*/
#define TX_FES_STATUS_6_BA_VALID_OFFSET                              0x00000018
#define TX_FES_STATUS_6_BA_VALID_LSB                                 3
#define TX_FES_STATUS_6_BA_VALID_MASK                                0x00000008

/* Description		TX_FES_STATUS_6_BA_TID
			
			Tid field of the BA frame
*/
#define TX_FES_STATUS_6_BA_TID_OFFSET                                0x00000018
#define TX_FES_STATUS_6_BA_TID_LSB                                   4
#define TX_FES_STATUS_6_BA_TID_MASK                                  0x000000f0

/* Description		TX_FES_STATUS_6_RESERVED_6A
			
			0
*/
#define TX_FES_STATUS_6_RESERVED_6A_OFFSET                           0x00000018
#define TX_FES_STATUS_6_RESERVED_6A_LSB                              8
#define TX_FES_STATUS_6_RESERVED_6A_MASK                             0x0000ff00

/* Description		TX_FES_STATUS_6_BA_START_SEQ_NUM
			
			Only valid when Response frame is BA frame
			
			The start sequence number in the BA frame
*/
#define TX_FES_STATUS_6_BA_START_SEQ_NUM_OFFSET                      0x00000018
#define TX_FES_STATUS_6_BA_START_SEQ_NUM_LSB                         16
#define TX_FES_STATUS_6_BA_START_SEQ_NUM_MASK                        0x0fff0000

/* Description		TX_FES_STATUS_6_RESERVED_6B
			
			0
*/
#define TX_FES_STATUS_6_RESERVED_6B_OFFSET                           0x00000018
#define TX_FES_STATUS_6_RESERVED_6B_LSB                              28
#define TX_FES_STATUS_6_RESERVED_6B_MASK                             0xf0000000

/* Description		TX_FES_STATUS_7_BA_BITMAP_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.
*/
#define TX_FES_STATUS_7_BA_BITMAP_31_0_OFFSET                        0x0000001c
#define TX_FES_STATUS_7_BA_BITMAP_31_0_LSB                           0
#define TX_FES_STATUS_7_BA_BITMAP_31_0_MASK                          0xffffffff

/* Description		TX_FES_STATUS_8_BA_BITMAP_63_32
			
			The upper 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.
*/
#define TX_FES_STATUS_8_BA_BITMAP_63_32_OFFSET                       0x00000020
#define TX_FES_STATUS_8_BA_BITMAP_63_32_LSB                          0
#define TX_FES_STATUS_8_BA_BITMAP_63_32_MASK                         0xffffffff

/* Description		TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH
			
			Indicates the bandwidth used to transmit the Medium
			protection frame. Only valid when field 'Medium_Prot_type'
			indicates
			
			
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>
*/
#define TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH_OFFSET                 0x00000024
#define TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH_LSB                    0
#define TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH_MASK                   0x00000003

/* Description		TX_FES_STATUS_9_PACKET_BW
			
			Indicates the bandwidth used to transmit data packet or
			self gen(non medium protection) frame.  Only valid if the
			packet bit is also set.
			
			
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>
*/
#define TX_FES_STATUS_9_PACKET_BW_OFFSET                             0x00000024
#define TX_FES_STATUS_9_PACKET_BW_LSB                                2
#define TX_FES_STATUS_9_PACKET_BW_MASK                               0x0000000c

/* Description		TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT_VALID
			
			When set to 1, the (A-MPDU) transmission was silently
			aborted in the middle of transmission. The PHY faked the
			remaining transmission on the medium, so that TX PCU is
			still waiting for the BA frame to be received.  
*/
#define TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT_VALID_OFFSET             0x00000024
#define TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT_VALID_LSB                4
#define TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT_VALID_MASK               0x00000010

/* Description		TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT
			
			Field only valid when 'Coex_abort_mpdu_cnt_valid' is
			set.
			
			The number of MPDU frames that were properly sent before
			the coex transmit abort request was received
*/
#define TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT_OFFSET                   0x00000024
#define TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT_LSB                      5
#define TX_FES_STATUS_9_COEX_ABORT_MPDU_CNT_MASK                     0x00000fe0

/* Description		TX_FES_STATUS_9_TX_PHY_ERROR_STATUS
			
			<enum_typedef tx_pkt_end status>
			
			<enum 1 error_tx_underrun> PHY ran out of transmit data
			due to transmit underrun - this field is user-specific (see
			user_mask field)
			
			<enum 2 error_tx_chain_mask_zero>
			
			<enum 3 error_tx_extra_sym_mismatch>
			
			<enum 4 error_tx_vht_length_not_multiple_of_3>
			
			<enum 5 error_tx_bw_is_gt_dyn_bw>
			
			<enum 6 error_tx_11b_rate_illegal>
			
			<enum 7 error_tx_legacy_rate_illegal>
			
			<enum 8 error_tx_ht_rate_illegal>
			
			<enum 9 error_tx_vht_rate_illegal>
			
			<enum 10 error_tx_overflow>
			
			<enum 11 error_mac_tx_abort>
			
			<enum 12 error_mac_rf_only_abort>
			
			<enum 13 error_unsupported_cbf>
			
			<enum 14 error_cv_static_bandwidth_mismatch>
			
			<enum 15 error_cv_dynamic_bandwidth_mismatch>
			
			<enum 16 error_cv_unsupported_nss_total>
			
			<enum 17 error_nss_bf_params_mismatch>
			
			<enum 18 error_txbf_fail>
			
			<enum 19 error_illegal_nss>
			
			<enum 20 error_otp_txbf>
			
			<legal 1-20>
*/
#define TX_FES_STATUS_9_TX_PHY_ERROR_STATUS_OFFSET                   0x00000024
#define TX_FES_STATUS_9_TX_PHY_ERROR_STATUS_LSB                      12
#define TX_FES_STATUS_9_TX_PHY_ERROR_STATUS_MASK                     0x000ff000

/* Description		TX_FES_STATUS_9_RESERVED_9
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_9_RESERVED_9_OFFSET                            0x00000024
#define TX_FES_STATUS_9_RESERVED_9_LSB                               20
#define TX_FES_STATUS_9_RESERVED_9_MASK                              0xfff00000

/* Description		TX_FES_STATUS_10_PROT_TIMESTAMP
			
			Global timer value at start of Protection transmission
*/
#define TX_FES_STATUS_10_PROT_TIMESTAMP_OFFSET                       0x00000028
#define TX_FES_STATUS_10_PROT_TIMESTAMP_LSB                          0
#define TX_FES_STATUS_10_PROT_TIMESTAMP_MASK                         0xffffffff

/* Description		TX_FES_STATUS_11_PPDU_TIMESTAMP
			
			Global timer value at start of PPDU transmission
*/
#define TX_FES_STATUS_11_PPDU_TIMESTAMP_OFFSET                       0x0000002c
#define TX_FES_STATUS_11_PPDU_TIMESTAMP_LSB                          0
#define TX_FES_STATUS_11_PPDU_TIMESTAMP_MASK                         0xffffffff
#define TX_FES_STATUS_12_RX_LOCATION_INFO_RX_LOCATION_INFO_OFFSET    0x00000030
#define TX_FES_STATUS_12_RX_LOCATION_INFO_RX_LOCATION_INFO_LSB       0
#define TX_FES_STATUS_12_RX_LOCATION_INFO_RX_LOCATION_INFO_MASK      0xffffffff

/* Description		TX_FES_STATUS_13_ACK_RSSI_CHAIN0_PRI20
			
			RSSI of Ack on chain 0 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_PRI20_OFFSET                0x00000034
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_PRI20_LSB                   0
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC20
			
			RSSI of Ack on chain 0 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC20_OFFSET                0x00000034
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC20_LSB                   8
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC40
			
			RSSI of Ack on chain 0 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC40_OFFSET                0x00000034
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC40_LSB                   16
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC80
			
			RSSI of Ack on chain 0 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC80_OFFSET                0x00000034
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC80_LSB                   24
#define TX_FES_STATUS_13_ACK_RSSI_CHAIN0_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN1_PRI20
			
			RSSI of Ack on chain 1 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_PRI20_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_PRI20_LSB                   0
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC20
			
			RSSI of Ack on chain 1 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC20_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC20_LSB                   8
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC40
			
			RSSI of Ack on chain 1 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC40_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC40_LSB                   16
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC80
			
			RSSI of Ack on chain 1 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC80_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC80_LSB                   24
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN1_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN2_PRI20
			
			RSSI of Ack on chain 2 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_PRI20_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_PRI20_LSB                   0
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC20
			
			RSSI of Ack on chain 2 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC20_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC20_LSB                   8
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC40
			
			RSSI of Ack on chain 2 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC40_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC40_LSB                   16
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC80
			
			RSSI of Ack on chain 2 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC80_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC80_LSB                   24
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN2_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN3_PRI20
			
			RSSI of Ack on chain 3 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_PRI20_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_PRI20_LSB                   0
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC20
			
			RSSI of Ack on chain 3 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC20_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC20_LSB                   8
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC40
			
			RSSI of Ack on chain 3 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC40_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC40_LSB                   16
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC80
			
			RSSI of Ack on chain 3 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC80_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC80_LSB                   24
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN3_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_17_ACK_RSSI_AVE
			
			RSSI of Ack of all active chains and bandwidths.
			
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_17_ACK_RSSI_AVE_OFFSET                         0x00000044
#define TX_FES_STATUS_17_ACK_RSSI_AVE_LSB                            0
#define TX_FES_STATUS_17_ACK_RSSI_AVE_MASK                           0x000000ff

/* Description		TX_FES_STATUS_17_RESERVED_18
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_17_RESERVED_18_OFFSET                          0x00000044
#define TX_FES_STATUS_17_RESERVED_18_LSB                             8
#define TX_FES_STATUS_17_RESERVED_18_MASK                            0xffffff00

/* Description		TX_FES_STATUS_18_PHY_TIMESTAMP_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.
*/
#define TX_FES_STATUS_18_PHY_TIMESTAMP_1_OFFSET                      0x00000048
#define TX_FES_STATUS_18_PHY_TIMESTAMP_1_LSB                         0
#define TX_FES_STATUS_18_PHY_TIMESTAMP_1_MASK                        0xffffffff

/* Description		TX_FES_STATUS_19_PHY_TIMESTAMP_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.
*/
#define TX_FES_STATUS_19_PHY_TIMESTAMP_2_OFFSET                      0x0000004c
#define TX_FES_STATUS_19_PHY_TIMESTAMP_2_LSB                         0
#define TX_FES_STATUS_19_PHY_TIMESTAMP_2_MASK                        0xffffffff

/* Description		TX_FES_STATUS_20_L_SIG
			
			The Struct L_SIG_B or Struct L_SIG_A sent to PHY is
			copied here. 
			
			
			
			Note that all of these preamble informations from l_sig
			field up to tx_phy_desc_1/2 field are copied from PPDU
			frame, not protection (MPROT) frame.  
*/
#define TX_FES_STATUS_20_L_SIG_OFFSET                                0x00000050
#define TX_FES_STATUS_20_L_SIG_LSB                                   0
#define TX_FES_STATUS_20_L_SIG_MASK                                  0xffffffff

/* Description		TX_FES_STATUS_21_HT_SIG_VHT_SIG_A_1
			
			The 1st dword of Struct HT_SIG or Struct VHT_SIG_A sent
			to PHY is copied here. Set to 0 if not present. 
*/
#define TX_FES_STATUS_21_HT_SIG_VHT_SIG_A_1_OFFSET                   0x00000054
#define TX_FES_STATUS_21_HT_SIG_VHT_SIG_A_1_LSB                      0
#define TX_FES_STATUS_21_HT_SIG_VHT_SIG_A_1_MASK                     0xffffffff

/* Description		TX_FES_STATUS_22_HT_SIG_VHT_SIG_A_2
			
			The 2nd dword of Struct HT_SIG or Struct VHT_SIG_A sent
			to PHY is copied here. Set to 0 if not present. 
*/
#define TX_FES_STATUS_22_HT_SIG_VHT_SIG_A_2_OFFSET                   0x00000058
#define TX_FES_STATUS_22_HT_SIG_VHT_SIG_A_2_LSB                      0
#define TX_FES_STATUS_22_HT_SIG_VHT_SIG_A_2_MASK                     0xffffffff

/* Description		TX_FES_STATUS_23_VHT_SIG_B_USER0
			
			The 1st dword of Struct VHT_SIG_B of user0 sent to PHY
			is copied here. Set to 0 if not present. 
*/
#define TX_FES_STATUS_23_VHT_SIG_B_USER0_OFFSET                      0x0000005c
#define TX_FES_STATUS_23_VHT_SIG_B_USER0_LSB                         0
#define TX_FES_STATUS_23_VHT_SIG_B_USER0_MASK                        0xffffffff

/* Description		TX_FES_STATUS_24_VHT_SIG_B_USER1
			
			The 1st dword of Struct VHT_SIG_B of user1 sent to PHY
			is copied here. Set to 0 if not present.
*/
#define TX_FES_STATUS_24_VHT_SIG_B_USER1_OFFSET                      0x00000060
#define TX_FES_STATUS_24_VHT_SIG_B_USER1_LSB                         0
#define TX_FES_STATUS_24_VHT_SIG_B_USER1_MASK                        0xffffffff

/* Description		TX_FES_STATUS_25_VHT_SIG_B_USER2
			
			The 1st dword of Struct VHT_SIG_B of user2 sent to PHY
			is copied here. Set to 0 if not present.
*/
#define TX_FES_STATUS_25_VHT_SIG_B_USER2_OFFSET                      0x00000064
#define TX_FES_STATUS_25_VHT_SIG_B_USER2_LSB                         0
#define TX_FES_STATUS_25_VHT_SIG_B_USER2_MASK                        0xffffffff

/* Description		TX_FES_STATUS_26_TX_SERVICE
			
			The Struct TX_SERVICE sent to PHY is copied here.
*/
#define TX_FES_STATUS_26_TX_SERVICE_OFFSET                           0x00000068
#define TX_FES_STATUS_26_TX_SERVICE_LSB                              0
#define TX_FES_STATUS_26_TX_SERVICE_MASK                             0xffffffff

/* Description		TX_FES_STATUS_27_TX_PHY_DESC_1
			
			The 1st dword of Struct TX_PHY_DESC sent to PHY is
			copied here. The pkt_type in TX_PHY_DESC will tell which
			preamble fields like l_sig, ht_sig, vht_sig are valid. 
*/
#define TX_FES_STATUS_27_TX_PHY_DESC_1_OFFSET                        0x0000006c
#define TX_FES_STATUS_27_TX_PHY_DESC_1_LSB                           0
#define TX_FES_STATUS_27_TX_PHY_DESC_1_MASK                          0xffffffff

/* Description		TX_FES_STATUS_28_TX_PHY_DESC_2
			
			The 2nd dword of Struct TX_PHY_DESC sent to PHY is
			copied here.
*/
#define TX_FES_STATUS_28_TX_PHY_DESC_2_OFFSET                        0x00000070
#define TX_FES_STATUS_28_TX_PHY_DESC_2_LSB                           0
#define TX_FES_STATUS_28_TX_PHY_DESC_2_MASK                          0xffffffff


#endif // _TX_FES_STATUS_H_
