// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_FES_SETUP_H_
#define _TX_FES_SETUP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	schedule_id[15:0], schedule_cmd_ring_id[20:16], fes_control_mode[22:21], number_of_users[24:23], schedule_try[28:25], ndp_frame[29], txbf[30], send_tx_expect_cbf[31]
//	1	fc_to_ds_mask[0], fc_from_ds_mask[1], fc_more_frag_mask[2], fc_retry_mask[3], fc_pwr_mgt_mask[4], fc_more_data_mask[5], fc_prot_frame_mask[6], fc_order_mask[7], duration_field_mask[8], sequence_control_mask[9], qc_tid_mask[10], qc_eosp_mask[11], qc_ack_policy_mask[12], qc_amsdu_mask[13], reserved_1[14], qc_15to8_mask[15], iv_mask[16], fc_to_ds_setting[17], fc_from_ds_setting[18], fc_more_frag_setting[19], fc_retry_setting[21:20], fc_pwr_mgt_setting[22], fc_more_data_setting[24:23], fc_prot_frame_setting[26:25], fc_order_setting[27], qc_tid_setting[31:28]
//	2	qc_eosp_setting[1:0], qc_ack_policy_setting[2], qc_amsdu_setting[3], qc_15to8_setting[11:4], raw_already_encrypted[12], allow_txop_exceed_in_1st_pkt[13], mprot_addr_sel[14], ignore_bw_available[15], fes_time_20mhz[31:16]
//	3	fes_time_40mhz[15:0], fes_time_80mhz[31:16]
//	4	max_txop_time[15:0], reserved_4[20:16], peer_idx[31:21]
//	5	num_ss_user0[2:0], num_ss_user1[5:3], num_ss_user2[8:6], use_static_bw[9], static_bandwidth[11:10], cbf_user_number[13:12], cv_id[21:14], frame_type[24:22], tx_chain_mask[28:25], bf_type[30:29], send_tx_bf_params[31]
//	6	cbf_nc_index[2:0], cbf_nc_index_mask[3], cbf_nr_index[6:4], cbf_nr_index_mask[7], cbf_bw[9:8], cbf_bw_mask[10], cbf_feedback_type[11], cbf_feedback_type_mask[12], cbf_sounding_token[18:13], cbf_sounding_token_mask[19], txbf_per_packet_no_csd_no_walsh[20], ignore_tbtt[21], reserved_6[31:22]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_FES_SETUP 7

struct tx_fes_setup {
    volatile uint32_t schedule_id                     : 16, //[15:0]
                      schedule_cmd_ring_id            :  5, //[20:16]
                      fes_control_mode                :  2, //[22:21]
                      number_of_users                 :  2, //[24:23]
                      schedule_try                    :  4, //[28:25]
                      ndp_frame                       :  1, //[29]
                      txbf                            :  1, //[30]
                      send_tx_expect_cbf              :  1; //[31]
    volatile uint32_t fc_to_ds_mask                   :  1, //[0]
                      fc_from_ds_mask                 :  1, //[1]
                      fc_more_frag_mask               :  1, //[2]
                      fc_retry_mask                   :  1, //[3]
                      fc_pwr_mgt_mask                 :  1, //[4]
                      fc_more_data_mask               :  1, //[5]
                      fc_prot_frame_mask              :  1, //[6]
                      fc_order_mask                   :  1, //[7]
                      duration_field_mask             :  1, //[8]
                      sequence_control_mask           :  1, //[9]
                      qc_tid_mask                     :  1, //[10]
                      qc_eosp_mask                    :  1, //[11]
                      qc_ack_policy_mask              :  1, //[12]
                      qc_amsdu_mask                   :  1, //[13]
                      reserved_1                      :  1, //[14]
                      qc_15to8_mask                   :  1, //[15]
                      iv_mask                         :  1, //[16]
                      fc_to_ds_setting                :  1, //[17]
                      fc_from_ds_setting              :  1, //[18]
                      fc_more_frag_setting            :  1, //[19]
                      fc_retry_setting                :  2, //[21:20]
                      fc_pwr_mgt_setting              :  1, //[22]
                      fc_more_data_setting            :  2, //[24:23]
                      fc_prot_frame_setting           :  2, //[26:25]
                      fc_order_setting                :  1, //[27]
                      qc_tid_setting                  :  4; //[31:28]
    volatile uint32_t qc_eosp_setting                 :  2, //[1:0]
                      qc_ack_policy_setting           :  1, //[2]
                      qc_amsdu_setting                :  1, //[3]
                      qc_15to8_setting                :  8, //[11:4]
                      raw_already_encrypted           :  1, //[12]
                      allow_txop_exceed_in_1st_pkt    :  1, //[13]
                      mprot_addr_sel                  :  1, //[14]
                      ignore_bw_available             :  1, //[15]
                      fes_time_20mhz                  : 16; //[31:16]
    volatile uint32_t fes_time_40mhz                  : 16, //[15:0]
                      fes_time_80mhz                  : 16; //[31:16]
    volatile uint32_t max_txop_time                   : 16, //[15:0]
                      reserved_4                      :  5, //[20:16]
                      peer_idx                        : 11; //[31:21]
    volatile uint32_t num_ss_user0                    :  3, //[2:0]
                      num_ss_user1                    :  3, //[5:3]
                      num_ss_user2                    :  3, //[8:6]
                      use_static_bw                   :  1, //[9]
                      static_bandwidth                :  2, //[11:10]
                      cbf_user_number                 :  2, //[13:12]
                      cv_id                           :  8, //[21:14]
                      frame_type                      :  3, //[24:22]
                      tx_chain_mask                   :  4, //[28:25]
                      bf_type                         :  2, //[30:29]
                      send_tx_bf_params               :  1; //[31]
    volatile uint32_t cbf_nc_index                    :  3, //[2:0]
                      cbf_nc_index_mask               :  1, //[3]
                      cbf_nr_index                    :  3, //[6:4]
                      cbf_nr_index_mask               :  1, //[7]
                      cbf_bw                          :  2, //[9:8]
                      cbf_bw_mask                     :  1, //[10]
                      cbf_feedback_type               :  1, //[11]
                      cbf_feedback_type_mask          :  1, //[12]
                      cbf_sounding_token              :  6, //[18:13]
                      cbf_sounding_token_mask         :  1, //[19]
                      txbf_per_packet_no_csd_no_walsh :  1, //[20]
                      ignore_tbtt                     :  1, //[21]
                      reserved_6                      : 10; //[31:22]
};

/*

schedule_id
			
			This field is overwritten by the scheduler module and
			it's value is coming from theschedule_id field in the 
			Scheduler command.
			
			
			
			Configured by scheduler in HW transmit mode
			
			A field that HW copies over into the scheduling status
			report, so that SW can determine to which scheduler command
			the status report belongs.
			
			This schedule ID is also reported in the PPDU status.   
			  
			
			<legal all>

schedule_cmd_ring_id
			
			This field is overwritten by the scheduler module and
			its value is based on the scheduler ring where the command
			is initiated.
			
			
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			<legal 0-15>

fes_control_mode
			
			This field is overwritten by the scheduler module and
			it's value is coming from the FES_control_mode field in the 
			Scheduler command.
			
			
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			<legal 0-1> 

number_of_users
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users.
			
			When number of users is 1, only user0 fields in any of
			the descriptors are applicable.
			
			When number of users is 2, only user0 and user1 fields
			are applicable.
			
			<legal 1-3>

schedule_try
			
			This field is overwritten by the scheduler module and
			it's value is coming from an internal counter in the
			scheduler that keeps track of how many times a scheduling
			command has been tried.
			
			
			
			The number of times this scheduler command has been
			tried
			
			<legal all>

ndp_frame
			
			This field is overwritten by the scheduler module and
			it's value is coming from thendp_frame field in the 
			Scheduler command.
			
			
			
			When set, the scheduling command contains an NDP frame.
			This can only be done using the SW transmit mode. <legal
			all>

txbf
			
			If set, this bit indicates that this is a TX beamformed
			SU transaction or MU transaction

send_tx_expect_cbf
			
			Indicates to the TXPCU whether to send the TX_EXPECT_CBF
			TLV to the PHY or not.  If this is a NDP or BR Poll which is
			used in a SIFS burst with beamformed or MU packet, this
			should be set.  Otherwise if sounding sequence and the
			beamformed transmission and not performed in a SIFS burst
			then the CBF should go directly to software which will
			decode and apply it to some later transmit beamformed
			packet.  In this situation there is no need for the PHY to
			get the TX_EXPECT_CBF TLV in this case and in fact will
			confuse the SVD engine.

fc_to_ds_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			Note: Enc_type is NOT allowed b
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_to_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_from_ds_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_from_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_more_frag_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_frag_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_retry_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_retry_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_pwr_mgt_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_pwr_mgt_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_more_data_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			TX_PCU has the abilty of overwrite the More data field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_data_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_prot_frame_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for the Protected frame bit on the key_type setting 
			in the peer entry. When NO encryption is needed, the bit
			will be set to 0, When the any encryption is needed, the bit
			will be set to 0.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_prot_frame_setting. When fc_prot_frame_setting is
			set, OLE will encrypt the frame, based on the encryption
			type indicate with the key_type setting  in the peer entry
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			<legal all>

fc_order_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_order_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

duration_field_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, TX PCU will get the
			value for this field from the Duration fields in the
			PPDU_SS_... TLVs from PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (TX_PCU) will insert is coming from
			the Duration fields in the PPDU_SS_... TLVs from PDG
			(similar as with NON RAW/Native WiFi frames).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

sequence_control_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the start_seq_num and 
			seqnum_bitmap_31_0, seqnum_bitmap_63_32 fields from the
			mpdu_queue_ext datastructure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the same as
			with  NON RAW/Native WiFi frames (see description above).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_tid_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: qc_tid_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_eosp_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			TX_PCU has the abilty of overwrite the QoS eosp field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			eosp field. The value that HW (OLE) will insert is the given
			in field: qc_eosp_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_ack_policy_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			ack policy field. The value that HW (OLE) will insert is
			determined by field: qc_ack_pol_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_amsdu_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			amsdu field. The value that HW (OLE) will insert is
			determined by field: qc_amsdu_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

reserved_1
			
			<legal 0>

qc_15to8_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			control field, bits 15-8. The value that HW (OLE) will
			insert is determined by field: qc_15to8_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

iv_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			IV field insertion/value on the on the encryption type
			indicate with the key_type setting  in the peer entry
			
			
			
			<enum 0 mask_disable>: OLE is allowed to overwrite the
			IV field, in case key_type setting  in the peer entry
			indicates some encryption.
			
			
			
			<enum 1 mask_enable>: OLE  is not allowed to overwrite
			any of the IV field contents.

fc_to_ds_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_to_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field, to
			ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, to
			ds bit to 1
			
			<legal all>

fc_from_ds_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_from_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			from ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, from
			ds bit to 1
			
			<legal all>

fc_more_frag_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_frag_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			more frag bit to 0
			
			<enum 1 set>: OLE will set the frame control field, more
			frag bit to 1
			
			<legal all>

fc_retry_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_retry_mask is not set.
			
			
			
			<enum 0 fc_retry_clear>: OLE will set the frame control
			field, retry bit to 0
			
			<enum 1 fc_retry_set>: OLE will set the frame control
			field, retry bit to 1
			
			<enum 2 fc_retry_bimap_based>: OLE will base the setting
			for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<legal 0-2>

fc_pwr_mgt_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_pwr_mgt_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			pwr_mgt bit to 0
			
			<enum 1 set>: OLE will set the frame control field,
			pwr_mgt bit to 1
			
			<legal all>

fc_more_data_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_Data_mask is not
			set.
			
			
			
			<enum 0 fc_more_data_clear>: OLE will set the frame
			control field, More data bit to 0
			
			<enum 1 fc_more_data_set>: OLE will set the frame
			control field, More data bit to 1
			
			
			
			<enum 2 fc_more_data_pdg_based>: OLE will set the Frame
			control, More data bit to 0, but TX_PCU has the abilty to
			overwrite this based on the Set_fc_more_data field in the
			PPDU_SS_... TLVs given by PDG.
			
			
			
			<legal 0-2>

fc_prot_frame_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_prot_frame_mask is not
			set.
			
			
			
			<enum 0 fc_prot_frame_clear>: OLE will set the frame
			control field , order bit to 0
			
			<enum 1 fc_prot_frame_set>: OLE will set the frame
			control field , order bit to 1
			
			<enum 2 fc_prot_frame_encap_type_based>: OLE configures
			the Frame Control field, Prot frame bit according to the
			following rule: When the encryption type indicated with the
			key_type setting  in the peer entry is set to no crypto, the
			fc prot_frame bit is set to zero. When the encryption type
			indicated with the key_type setting in the peer entry is set
			to some encryption  type, the OLE will encrypt the frame AND
			set the fc prot frame bit to 1.

fc_order_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_order_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field ,
			order bit to 0
			
			<enum 1 set>: OLE will set the frame control field ,
			order bit to 1
			
			<legal all>

qc_tid_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_tid_mask is not set.
			
			
			
			OLE sets the TID field in the QoS control field to this
			value.
			
			
			
			<legal all>

qc_eosp_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_eosp_mask is not set.
			
			
			
			<enum 0 qc_eosp_clear>: OLE will set the QoS control bit
			to 0
			
			<enum 1 qc_eosp_set>: OLE will set the QoS control bit
			to 1
			
			<enum 2 qc_eosp_pdg_based>: OLE will set the QoS control
			bit to 0, but TX_PCU has the abilty of overwrite the QoS
			eosp field, based on the Set_fc_more_data field in the
			PPDU_SS_... TLVs given by PDG.
			
			
			
			<legal 0-2>

qc_ack_policy_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_ack_policy_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field ack
			policy bit to 0
			
			<enum 1 set>: OLE will set the QoS control ack policy
			bit to 1
			
			
			
			<legal all>

qc_amsdu_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_amsdu_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field amsdu
			bit to 0
			
			<enum 1 set>: OLE will set the QoS control field amsdu
			bit to 1
			
			
			
			<legal all>

qc_15to8_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_15to8_mask is not set.
			
			
			
			OLE sets bit 8 to 16 in the QoS control field to this
			value.
			
			
			
			<legal all>

raw_already_encrypted
			
			If set it indicates that the RAW MPDU has already been
			encrypted and does not require HW encryption.  If clear and
			if the frame control indicates that this is a protected MPDU
			and the peer key type indicates a cipher type then the HW is
			expected to encrypt this packet.
			
			<legal all>

allow_txop_exceed_in_1st_pkt
			
			If set, the single MPDU after RBO is allowed to exceed
			TXOP. If clear, single MPDU after RBO is not allowed to
			exceed TXOP.
			
			<legal all>

mprot_addr_sel
			
			If set, address 1/2 of protection frame (RTS and
			CTS2Self) will be taken directly from address 1/2 of USER0
			PPDU frame. If clear, address 1/2 of protection frame will
			be come from mac_addr_a/b/c fields of peer_entry. 
			
			<enum 0 from_peer_entry>
			
			<enum 1 from_ppdu>
			
			<legal all>

ignore_bw_available
			
			If set, TXPCU ignores 'BW available signals' from the
			scheduler and transmit using the single BW that SW has
			programmed the transmission to go out in. This bit should be
			set for SIFS response frame to PS-Poll/uAPSD/QBoost and note
			that for this mode, SW is only allowed to program a single
			transmit BW.
			
			<legal all>

fes_time_20mhz
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			
			
			The amount of time (in us)  the SW defined frame
			exchange sequence takes when transmission BW is 20 Mhz.
			
			
			
			If this bandwidth is not supported, SW should program
			the value in this field equal to the smallest of valid
			Fes_time_40MHz or Fes_time_80Mhz fields.
			
			
			
			Used by TX PCU to confirm that transmission will fit in
			available TXOP time

fes_time_40mhz
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			
			
			The amount of time (in us)  the SW defined frame
			exchange sequence takes when transmission BW is 40 Mhz.
			
			
			
			If this bandwidth is not supported, SW should program
			the value in this field equal to the smallest of valid
			Fes_time_20MHz or Fes_time_80Mhz fields.
			
			
			
			Used by TX PCU to confirm that transmission will fit in
			available TXOP time

fes_time_80mhz
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			
			
			The amount of time (in us)  the SW defined frame
			exchange sequence takes when transmission BW is 80 Mhz.
			
			
			
			If this bandwidth is not supported, SW should program
			the value in this field equal to the smallest of valid
			Fes_time_20MHz or Fes_time_40Mhz fields.
			
			
			
			Used by TX PCU to confirm that transmission will fit in
			available TXOP time

max_txop_time
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			The maximum TXOP time (in us) allowed for the upcoming
			Frame Exchange Sequence (FES) in SW transmit mode. Scheduler
			determines this field based on all TXOP related boundary
			checks.
			
			
			
			This field is used by TX PCU to confirm that the
			upcoming transmission (after BW selection result is known)
			will within this time.
			
			
			
			The max_txop_time is used for a SIFS burst of transmit
			packets.  It may include time reservation for multiple FES.
			
			
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			
			
			<legal all>

reserved_4
			
			<legal 0>

peer_idx
			
			Used for implicit BF sounding capture on receive Ack/BA.
			The RXPCU needs to tag the receive sounding with peer_idx
			so FW will know which STA is associated with Ack/BA
			sounding. 

num_ss_user0
			
			Part of TX_BF_PARAMS: Number of spatial streams assigned
			to user 0 in the next MU MIMO packet or the number of
			streams in the next SU packet.  For MU packets the values
			can be 1 or 2, for SU packets the value can be 1, 2, or
			3<legal 1-3>

num_ss_user1
			
			Part of TX_BF_PARAMS: Number of spatial streams assigned
			to user 1 in the next MIMO packet.  <legal 0-2>

num_ss_user2
			
			Part of TX_BF_PARAMS: Number of spatial streams assigned
			to user 2 in the next MIMO packet.  <legal 0-2>

use_static_bw
			
			Part of TX_BF_PARAMS: This field is used to indicate to
			the SVD that the b/w that will be defined in the TX_PHY_DESC
			for the upcoming TXBF packet will be the same as the static
			bandwidth, i.e. the bandwidth that was in operation during
			sounding for the clients in question

static_bandwidth
			
			Part of TX_BF_PARAMS: Packet bandwidth when
			use_static_bw is set:
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			Field is reserved when use_static_bw is clear.
			
			<legal 0-2>

cbf_user_number
			
			This field is only valid when expect_cbf is set.
			
			This field is inserted into the TX_EXPECT_CBF TLV
			generated by the TX PCU.
			
			
			
			Defines the source of the expected CBF.  
			
			<legal 0-2>

cv_id
			
			This field is only valid when expect_cbf is set.
			
			
			
			A unique ID corresponding to the CV data expected from
			the CBF frame. 
			
			
			
			TXPCU copies this field over to the TX_FES_STATUS TLV

frame_type
			
			(Not supported in Beeliner)
			
			
			
			Frame type indication. Indicates what type of frame is
			being sent. Supported values:
			
			0: default
			
			1: PS-Poll
			
			2-7: Reserved
			
			<legal 0-1>

tx_chain_mask
			
			Tx chain mask to support up to 4 antennas.  
			
			
			
			This field is used for VECTOR_TRANSFER_START and
			TX_CBF_OFFSET. 
			
			
			
			<legal: 1-15>

bf_type
			
			Defines the type of beamforming that is required using
			this CV data
			
			
			
			This field is used for TXPCU to construct
			VECTOR_TRANSFER_START. 
			
			
			
			<enum 0    reserved>
			
			<enum 1    LEGACY_BF>
			
			<enum 2    SU_BF>
			
			<enum 3    MU_BF>
			
			 <legal 1-3>

send_tx_bf_params
			
			If set indicates that the TXPCU should send the
			TX_BF_PARAMS associated with this FES.  If
			send_tx_expect_cbf is set then the tx_bf_params would be
			sent after TXPCU sends the TX_CBF_OFFSET TLV.  If txbf is
			set then the tx_bf_params is sent as soon as possible after
			the VECTOR_TRANSFER_START.  For the case of MU, the
			TX_BF_PARAMS is sent as soon as possible after the last
			VECTOR_TRANSFER_START.

cbf_nc_index
			
			Expected Nc_index of received CBF frame after sending
			NDP or BR-Poll. This field is compared only if
			cbf_nc_index_mask is set to 1. 
			
			<enum 0 nc_1>
			
			<enum 1 nc_2>
			
			<enum 2 nc_3>
			
			<legal 0-2>

cbf_nc_index_mask
			
			Mask bit for cbf_nc_index

cbf_nr_index
			
			Expected Nr_index of received CBF frame after sending
			NDP or BR-Poll. This field is compared only if
			cbf_nr_index_mask is set to 1. 
			
			<enum 0 nr_1>
			
			<enum 1 nr_2>
			
			<enum 2 nr_3>
			
			<enum 3 nr_4>
			
			<legal 0-3>

cbf_nr_index_mask
			
			Mask bit for cbf_nr_index

cbf_bw
			
			Expected channel width of received CBF frame after
			sending NDP or BR-Poll. This field is compared only if
			cbf_bw_mask is set to 1. 
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>

cbf_bw_mask
			
			Mask bit for cbf_bw

cbf_feedback_type
			
			Expected feedback type of received CBF frame after
			sending NDP or BR-Poll. This field is compared only if
			cbf_feedback_type_mask is set to 1. 
			
			<enum 0     SU>
			
			<enum 1     MU>
			
			<legal all>

cbf_feedback_type_mask
			
			Mask bit for cbf_feedback_type

cbf_sounding_token
			
			Expected sounding token of received CBF frame after
			sending NDP or BR-Poll. This field is compared only if
			cbf_sounding_token_mask is set to 1. 
			
			<legal all>

cbf_sounding_token_mask
			
			Mask bit for cbf_sounding_token

txbf_per_packet_no_csd_no_walsh
			
			If set, no_csd and no_walsh is applied to steering
			packet. 
			
			TXPCU copies this field to VECTOR_FRAGMENT_START TLV and
			TX_PHY_DESC TLV. 

ignore_tbtt
			
			If set, PDG ignores remaining TBTTs in PPDU time
			calculation. 

reserved_6
			
			Reserved - MAC to set this field to 0, PHY to ignore
			this field. <legal 0>
*/


/* Description		TX_FES_SETUP_0_SCHEDULE_ID
			
			This field is overwritten by the scheduler module and
			it's value is coming from theschedule_id field in the 
			Scheduler command.
			
			
			
			Configured by scheduler in HW transmit mode
			
			A field that HW copies over into the scheduling status
			report, so that SW can determine to which scheduler command
			the status report belongs.
			
			This schedule ID is also reported in the PPDU status.   
			  
			
			<legal all>
*/
#define TX_FES_SETUP_0_SCHEDULE_ID_OFFSET                            0x00000000
#define TX_FES_SETUP_0_SCHEDULE_ID_LSB                               0
#define TX_FES_SETUP_0_SCHEDULE_ID_MASK                              0x0000ffff

/* Description		TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID
			
			This field is overwritten by the scheduler module and
			its value is based on the scheduler ring where the command
			is initiated.
			
			
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			<legal 0-15>
*/
#define TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID_OFFSET                   0x00000000
#define TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID_LSB                      16
#define TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID_MASK                     0x001f0000

/* Description		TX_FES_SETUP_0_FES_CONTROL_MODE
			
			This field is overwritten by the scheduler module and
			it's value is coming from the FES_control_mode field in the 
			Scheduler command.
			
			
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			<legal 0-1> 
*/
#define TX_FES_SETUP_0_FES_CONTROL_MODE_OFFSET                       0x00000000
#define TX_FES_SETUP_0_FES_CONTROL_MODE_LSB                          21
#define TX_FES_SETUP_0_FES_CONTROL_MODE_MASK                         0x00600000

/* Description		TX_FES_SETUP_0_NUMBER_OF_USERS
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users.
			
			When number of users is 1, only user0 fields in any of
			the descriptors are applicable.
			
			When number of users is 2, only user0 and user1 fields
			are applicable.
			
			<legal 1-3>
*/
#define TX_FES_SETUP_0_NUMBER_OF_USERS_OFFSET                        0x00000000
#define TX_FES_SETUP_0_NUMBER_OF_USERS_LSB                           23
#define TX_FES_SETUP_0_NUMBER_OF_USERS_MASK                          0x01800000

/* Description		TX_FES_SETUP_0_SCHEDULE_TRY
			
			This field is overwritten by the scheduler module and
			it's value is coming from an internal counter in the
			scheduler that keeps track of how many times a scheduling
			command has been tried.
			
			
			
			The number of times this scheduler command has been
			tried
			
			<legal all>
*/
#define TX_FES_SETUP_0_SCHEDULE_TRY_OFFSET                           0x00000000
#define TX_FES_SETUP_0_SCHEDULE_TRY_LSB                              25
#define TX_FES_SETUP_0_SCHEDULE_TRY_MASK                             0x1e000000

/* Description		TX_FES_SETUP_0_NDP_FRAME
			
			This field is overwritten by the scheduler module and
			it's value is coming from thendp_frame field in the 
			Scheduler command.
			
			
			
			When set, the scheduling command contains an NDP frame.
			This can only be done using the SW transmit mode. <legal
			all>
*/
#define TX_FES_SETUP_0_NDP_FRAME_OFFSET                              0x00000000
#define TX_FES_SETUP_0_NDP_FRAME_LSB                                 29
#define TX_FES_SETUP_0_NDP_FRAME_MASK                                0x20000000

/* Description		TX_FES_SETUP_0_TXBF
			
			If set, this bit indicates that this is a TX beamformed
			SU transaction or MU transaction
*/
#define TX_FES_SETUP_0_TXBF_OFFSET                                   0x00000000
#define TX_FES_SETUP_0_TXBF_LSB                                      30
#define TX_FES_SETUP_0_TXBF_MASK                                     0x40000000

/* Description		TX_FES_SETUP_0_SEND_TX_EXPECT_CBF
			
			Indicates to the TXPCU whether to send the TX_EXPECT_CBF
			TLV to the PHY or not.  If this is a NDP or BR Poll which is
			used in a SIFS burst with beamformed or MU packet, this
			should be set.  Otherwise if sounding sequence and the
			beamformed transmission and not performed in a SIFS burst
			then the CBF should go directly to software which will
			decode and apply it to some later transmit beamformed
			packet.  In this situation there is no need for the PHY to
			get the TX_EXPECT_CBF TLV in this case and in fact will
			confuse the SVD engine.
*/
#define TX_FES_SETUP_0_SEND_TX_EXPECT_CBF_OFFSET                     0x00000000
#define TX_FES_SETUP_0_SEND_TX_EXPECT_CBF_LSB                        31
#define TX_FES_SETUP_0_SEND_TX_EXPECT_CBF_MASK                       0x80000000

/* Description		TX_FES_SETUP_1_FC_TO_DS_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			Note: Enc_type is NOT allowed b
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_to_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_TO_DS_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_FC_TO_DS_MASK_LSB                             0
#define TX_FES_SETUP_1_FC_TO_DS_MASK_MASK                            0x00000001

/* Description		TX_FES_SETUP_1_FC_FROM_DS_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_from_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_FROM_DS_MASK_OFFSET                        0x00000004
#define TX_FES_SETUP_1_FC_FROM_DS_MASK_LSB                           1
#define TX_FES_SETUP_1_FC_FROM_DS_MASK_MASK                          0x00000002

/* Description		TX_FES_SETUP_1_FC_MORE_FRAG_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_frag_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_MORE_FRAG_MASK_OFFSET                      0x00000004
#define TX_FES_SETUP_1_FC_MORE_FRAG_MASK_LSB                         2
#define TX_FES_SETUP_1_FC_MORE_FRAG_MASK_MASK                        0x00000004

/* Description		TX_FES_SETUP_1_FC_RETRY_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_retry_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_RETRY_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_FC_RETRY_MASK_LSB                             3
#define TX_FES_SETUP_1_FC_RETRY_MASK_MASK                            0x00000008

/* Description		TX_FES_SETUP_1_FC_PWR_MGT_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_pwr_mgt_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_PWR_MGT_MASK_OFFSET                        0x00000004
#define TX_FES_SETUP_1_FC_PWR_MGT_MASK_LSB                           4
#define TX_FES_SETUP_1_FC_PWR_MGT_MASK_MASK                          0x00000010

/* Description		TX_FES_SETUP_1_FC_MORE_DATA_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			TX_PCU has the abilty of overwrite the More data field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_data_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_MORE_DATA_MASK_OFFSET                      0x00000004
#define TX_FES_SETUP_1_FC_MORE_DATA_MASK_LSB                         5
#define TX_FES_SETUP_1_FC_MORE_DATA_MASK_MASK                        0x00000020

/* Description		TX_FES_SETUP_1_FC_PROT_FRAME_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for the Protected frame bit on the key_type setting 
			in the peer entry. When NO encryption is needed, the bit
			will be set to 0, When the any encryption is needed, the bit
			will be set to 0.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_prot_frame_setting. When fc_prot_frame_setting is
			set, OLE will encrypt the frame, based on the encryption
			type indicate with the key_type setting  in the peer entry
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_PROT_FRAME_MASK_OFFSET                     0x00000004
#define TX_FES_SETUP_1_FC_PROT_FRAME_MASK_LSB                        6
#define TX_FES_SETUP_1_FC_PROT_FRAME_MASK_MASK                       0x00000040

/* Description		TX_FES_SETUP_1_FC_ORDER_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_order_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_ORDER_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_FC_ORDER_MASK_LSB                             7
#define TX_FES_SETUP_1_FC_ORDER_MASK_MASK                            0x00000080

/* Description		TX_FES_SETUP_1_DURATION_FIELD_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, TX PCU will get the
			value for this field from the Duration fields in the
			PPDU_SS_... TLVs from PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (TX_PCU) will insert is coming from
			the Duration fields in the PPDU_SS_... TLVs from PDG
			(similar as with NON RAW/Native WiFi frames).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_DURATION_FIELD_MASK_OFFSET                    0x00000004
#define TX_FES_SETUP_1_DURATION_FIELD_MASK_LSB                       8
#define TX_FES_SETUP_1_DURATION_FIELD_MASK_MASK                      0x00000100

/* Description		TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the start_seq_num and 
			seqnum_bitmap_31_0, seqnum_bitmap_63_32 fields from the
			mpdu_queue_ext datastructure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the same as
			with  NON RAW/Native WiFi frames (see description above).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK_OFFSET                  0x00000004
#define TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK_LSB                     9
#define TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK_MASK                    0x00000200

/* Description		TX_FES_SETUP_1_QC_TID_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: qc_tid_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_TID_MASK_OFFSET                            0x00000004
#define TX_FES_SETUP_1_QC_TID_MASK_LSB                               10
#define TX_FES_SETUP_1_QC_TID_MASK_MASK                              0x00000400

/* Description		TX_FES_SETUP_1_QC_EOSP_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			TX_PCU has the abilty of overwrite the QoS eosp field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			eosp field. The value that HW (OLE) will insert is the given
			in field: qc_eosp_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_EOSP_MASK_OFFSET                           0x00000004
#define TX_FES_SETUP_1_QC_EOSP_MASK_LSB                              11
#define TX_FES_SETUP_1_QC_EOSP_MASK_MASK                             0x00000800

/* Description		TX_FES_SETUP_1_QC_ACK_POLICY_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			ack policy field. The value that HW (OLE) will insert is
			determined by field: qc_ack_pol_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_ACK_POLICY_MASK_OFFSET                     0x00000004
#define TX_FES_SETUP_1_QC_ACK_POLICY_MASK_LSB                        12
#define TX_FES_SETUP_1_QC_ACK_POLICY_MASK_MASK                       0x00001000

/* Description		TX_FES_SETUP_1_QC_AMSDU_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			amsdu field. The value that HW (OLE) will insert is
			determined by field: qc_amsdu_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_AMSDU_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_QC_AMSDU_MASK_LSB                             13
#define TX_FES_SETUP_1_QC_AMSDU_MASK_MASK                            0x00002000

/* Description		TX_FES_SETUP_1_RESERVED_1
			
			<legal 0>
*/
#define TX_FES_SETUP_1_RESERVED_1_OFFSET                             0x00000004
#define TX_FES_SETUP_1_RESERVED_1_LSB                                14
#define TX_FES_SETUP_1_RESERVED_1_MASK                               0x00004000

/* Description		TX_FES_SETUP_1_QC_15TO8_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			control field, bits 15-8. The value that HW (OLE) will
			insert is determined by field: qc_15to8_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_15TO8_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_QC_15TO8_MASK_LSB                             15
#define TX_FES_SETUP_1_QC_15TO8_MASK_MASK                            0x00008000

/* Description		TX_FES_SETUP_1_IV_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			IV field insertion/value on the on the encryption type
			indicate with the key_type setting  in the peer entry
			
			
			
			<enum 0 mask_disable>: OLE is allowed to overwrite the
			IV field, in case key_type setting  in the peer entry
			indicates some encryption.
			
			
			
			<enum 1 mask_enable>: OLE  is not allowed to overwrite
			any of the IV field contents.
*/
#define TX_FES_SETUP_1_IV_MASK_OFFSET                                0x00000004
#define TX_FES_SETUP_1_IV_MASK_LSB                                   16
#define TX_FES_SETUP_1_IV_MASK_MASK                                  0x00010000

/* Description		TX_FES_SETUP_1_FC_TO_DS_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_to_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field, to
			ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, to
			ds bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_TO_DS_SETTING_OFFSET                       0x00000004
#define TX_FES_SETUP_1_FC_TO_DS_SETTING_LSB                          17
#define TX_FES_SETUP_1_FC_TO_DS_SETTING_MASK                         0x00020000

/* Description		TX_FES_SETUP_1_FC_FROM_DS_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_from_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			from ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, from
			ds bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_FROM_DS_SETTING_OFFSET                     0x00000004
#define TX_FES_SETUP_1_FC_FROM_DS_SETTING_LSB                        18
#define TX_FES_SETUP_1_FC_FROM_DS_SETTING_MASK                       0x00040000

/* Description		TX_FES_SETUP_1_FC_MORE_FRAG_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_frag_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			more frag bit to 0
			
			<enum 1 set>: OLE will set the frame control field, more
			frag bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_MORE_FRAG_SETTING_OFFSET                   0x00000004
#define TX_FES_SETUP_1_FC_MORE_FRAG_SETTING_LSB                      19
#define TX_FES_SETUP_1_FC_MORE_FRAG_SETTING_MASK                     0x00080000

/* Description		TX_FES_SETUP_1_FC_RETRY_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_retry_mask is not set.
			
			
			
			<enum 0 fc_retry_clear>: OLE will set the frame control
			field, retry bit to 0
			
			<enum 1 fc_retry_set>: OLE will set the frame control
			field, retry bit to 1
			
			<enum 2 fc_retry_bimap_based>: OLE will base the setting
			for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<legal 0-2>
*/
#define TX_FES_SETUP_1_FC_RETRY_SETTING_OFFSET                       0x00000004
#define TX_FES_SETUP_1_FC_RETRY_SETTING_LSB                          20
#define TX_FES_SETUP_1_FC_RETRY_SETTING_MASK                         0x00300000

/* Description		TX_FES_SETUP_1_FC_PWR_MGT_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_pwr_mgt_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			pwr_mgt bit to 0
			
			<enum 1 set>: OLE will set the frame control field,
			pwr_mgt bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_PWR_MGT_SETTING_OFFSET                     0x00000004
#define TX_FES_SETUP_1_FC_PWR_MGT_SETTING_LSB                        22
#define TX_FES_SETUP_1_FC_PWR_MGT_SETTING_MASK                       0x00400000

/* Description		TX_FES_SETUP_1_FC_MORE_DATA_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_Data_mask is not
			set.
			
			
			
			<enum 0 fc_more_data_clear>: OLE will set the frame
			control field, More data bit to 0
			
			<enum 1 fc_more_data_set>: OLE will set the frame
			control field, More data bit to 1
			
			
			
			<enum 2 fc_more_data_pdg_based>: OLE will set the Frame
			control, More data bit to 0, but TX_PCU has the abilty to
			overwrite this based on the Set_fc_more_data field in the
			PPDU_SS_... TLVs given by PDG.
			
			
			
			<legal 0-2>
*/
#define TX_FES_SETUP_1_FC_MORE_DATA_SETTING_OFFSET                   0x00000004
#define TX_FES_SETUP_1_FC_MORE_DATA_SETTING_LSB                      23
#define TX_FES_SETUP_1_FC_MORE_DATA_SETTING_MASK                     0x01800000

/* Description		TX_FES_SETUP_1_FC_PROT_FRAME_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_prot_frame_mask is not
			set.
			
			
			
			<enum 0 fc_prot_frame_clear>: OLE will set the frame
			control field , order bit to 0
			
			<enum 1 fc_prot_frame_set>: OLE will set the frame
			control field , order bit to 1
			
			<enum 2 fc_prot_frame_encap_type_based>: OLE configures
			the Frame Control field, Prot frame bit according to the
			following rule: When the encryption type indicated with the
			key_type setting  in the peer entry is set to no crypto, the
			fc prot_frame bit is set to zero. When the encryption type
			indicated with the key_type setting in the peer entry is set
			to some encryption  type, the OLE will encrypt the frame AND
			set the fc prot frame bit to 1.
*/
#define TX_FES_SETUP_1_FC_PROT_FRAME_SETTING_OFFSET                  0x00000004
#define TX_FES_SETUP_1_FC_PROT_FRAME_SETTING_LSB                     25
#define TX_FES_SETUP_1_FC_PROT_FRAME_SETTING_MASK                    0x06000000

/* Description		TX_FES_SETUP_1_FC_ORDER_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_order_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field ,
			order bit to 0
			
			<enum 1 set>: OLE will set the frame control field ,
			order bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_ORDER_SETTING_OFFSET                       0x00000004
#define TX_FES_SETUP_1_FC_ORDER_SETTING_LSB                          27
#define TX_FES_SETUP_1_FC_ORDER_SETTING_MASK                         0x08000000

/* Description		TX_FES_SETUP_1_QC_TID_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_tid_mask is not set.
			
			
			
			OLE sets the TID field in the QoS control field to this
			value.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_QC_TID_SETTING_OFFSET                         0x00000004
#define TX_FES_SETUP_1_QC_TID_SETTING_LSB                            28
#define TX_FES_SETUP_1_QC_TID_SETTING_MASK                           0xf0000000

/* Description		TX_FES_SETUP_2_QC_EOSP_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_eosp_mask is not set.
			
			
			
			<enum 0 qc_eosp_clear>: OLE will set the QoS control bit
			to 0
			
			<enum 1 qc_eosp_set>: OLE will set the QoS control bit
			to 1
			
			<enum 2 qc_eosp_pdg_based>: OLE will set the QoS control
			bit to 0, but TX_PCU has the abilty of overwrite the QoS
			eosp field, based on the Set_fc_more_data field in the
			PPDU_SS_... TLVs given by PDG.
			
			
			
			<legal 0-2>
*/
#define TX_FES_SETUP_2_QC_EOSP_SETTING_OFFSET                        0x00000008
#define TX_FES_SETUP_2_QC_EOSP_SETTING_LSB                           0
#define TX_FES_SETUP_2_QC_EOSP_SETTING_MASK                          0x00000003

/* Description		TX_FES_SETUP_2_QC_ACK_POLICY_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_ack_policy_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field ack
			policy bit to 0
			
			<enum 1 set>: OLE will set the QoS control ack policy
			bit to 1
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_2_QC_ACK_POLICY_SETTING_OFFSET                  0x00000008
#define TX_FES_SETUP_2_QC_ACK_POLICY_SETTING_LSB                     2
#define TX_FES_SETUP_2_QC_ACK_POLICY_SETTING_MASK                    0x00000004

/* Description		TX_FES_SETUP_2_QC_AMSDU_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_amsdu_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field amsdu
			bit to 0
			
			<enum 1 set>: OLE will set the QoS control field amsdu
			bit to 1
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_2_QC_AMSDU_SETTING_OFFSET                       0x00000008
#define TX_FES_SETUP_2_QC_AMSDU_SETTING_LSB                          3
#define TX_FES_SETUP_2_QC_AMSDU_SETTING_MASK                         0x00000008

/* Description		TX_FES_SETUP_2_QC_15TO8_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_15to8_mask is not set.
			
			
			
			OLE sets bit 8 to 16 in the QoS control field to this
			value.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_2_QC_15TO8_SETTING_OFFSET                       0x00000008
#define TX_FES_SETUP_2_QC_15TO8_SETTING_LSB                          4
#define TX_FES_SETUP_2_QC_15TO8_SETTING_MASK                         0x00000ff0

/* Description		TX_FES_SETUP_2_RAW_ALREADY_ENCRYPTED
			
			If set it indicates that the RAW MPDU has already been
			encrypted and does not require HW encryption.  If clear and
			if the frame control indicates that this is a protected MPDU
			and the peer key type indicates a cipher type then the HW is
			expected to encrypt this packet.
			
			<legal all>
*/
#define TX_FES_SETUP_2_RAW_ALREADY_ENCRYPTED_OFFSET                  0x00000008
#define TX_FES_SETUP_2_RAW_ALREADY_ENCRYPTED_LSB                     12
#define TX_FES_SETUP_2_RAW_ALREADY_ENCRYPTED_MASK                    0x00001000

/* Description		TX_FES_SETUP_2_ALLOW_TXOP_EXCEED_IN_1ST_PKT
			
			If set, the single MPDU after RBO is allowed to exceed
			TXOP. If clear, single MPDU after RBO is not allowed to
			exceed TXOP.
			
			<legal all>
*/
#define TX_FES_SETUP_2_ALLOW_TXOP_EXCEED_IN_1ST_PKT_OFFSET           0x00000008
#define TX_FES_SETUP_2_ALLOW_TXOP_EXCEED_IN_1ST_PKT_LSB              13
#define TX_FES_SETUP_2_ALLOW_TXOP_EXCEED_IN_1ST_PKT_MASK             0x00002000

/* Description		TX_FES_SETUP_2_MPROT_ADDR_SEL
			
			If set, address 1/2 of protection frame (RTS and
			CTS2Self) will be taken directly from address 1/2 of USER0
			PPDU frame. If clear, address 1/2 of protection frame will
			be come from mac_addr_a/b/c fields of peer_entry. 
			
			<enum 0 from_peer_entry>
			
			<enum 1 from_ppdu>
			
			<legal all>
*/
#define TX_FES_SETUP_2_MPROT_ADDR_SEL_OFFSET                         0x00000008
#define TX_FES_SETUP_2_MPROT_ADDR_SEL_LSB                            14
#define TX_FES_SETUP_2_MPROT_ADDR_SEL_MASK                           0x00004000

/* Description		TX_FES_SETUP_2_IGNORE_BW_AVAILABLE
			
			If set, TXPCU ignores 'BW available signals' from the
			scheduler and transmit using the single BW that SW has
			programmed the transmission to go out in. This bit should be
			set for SIFS response frame to PS-Poll/uAPSD/QBoost and note
			that for this mode, SW is only allowed to program a single
			transmit BW.
			
			<legal all>
*/
#define TX_FES_SETUP_2_IGNORE_BW_AVAILABLE_OFFSET                    0x00000008
#define TX_FES_SETUP_2_IGNORE_BW_AVAILABLE_LSB                       15
#define TX_FES_SETUP_2_IGNORE_BW_AVAILABLE_MASK                      0x00008000

/* Description		TX_FES_SETUP_2_FES_TIME_20MHZ
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			
			
			The amount of time (in us)  the SW defined frame
			exchange sequence takes when transmission BW is 20 Mhz.
			
			
			
			If this bandwidth is not supported, SW should program
			the value in this field equal to the smallest of valid
			Fes_time_40MHz or Fes_time_80Mhz fields.
			
			
			
			Used by TX PCU to confirm that transmission will fit in
			available TXOP time
*/
#define TX_FES_SETUP_2_FES_TIME_20MHZ_OFFSET                         0x00000008
#define TX_FES_SETUP_2_FES_TIME_20MHZ_LSB                            16
#define TX_FES_SETUP_2_FES_TIME_20MHZ_MASK                           0xffff0000

/* Description		TX_FES_SETUP_3_FES_TIME_40MHZ
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			
			
			The amount of time (in us)  the SW defined frame
			exchange sequence takes when transmission BW is 40 Mhz.
			
			
			
			If this bandwidth is not supported, SW should program
			the value in this field equal to the smallest of valid
			Fes_time_20MHz or Fes_time_80Mhz fields.
			
			
			
			Used by TX PCU to confirm that transmission will fit in
			available TXOP time
*/
#define TX_FES_SETUP_3_FES_TIME_40MHZ_OFFSET                         0x0000000c
#define TX_FES_SETUP_3_FES_TIME_40MHZ_LSB                            0
#define TX_FES_SETUP_3_FES_TIME_40MHZ_MASK                           0x0000ffff

/* Description		TX_FES_SETUP_3_FES_TIME_80MHZ
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			
			
			The amount of time (in us)  the SW defined frame
			exchange sequence takes when transmission BW is 80 Mhz.
			
			
			
			If this bandwidth is not supported, SW should program
			the value in this field equal to the smallest of valid
			Fes_time_20MHz or Fes_time_40Mhz fields.
			
			
			
			Used by TX PCU to confirm that transmission will fit in
			available TXOP time
*/
#define TX_FES_SETUP_3_FES_TIME_80MHZ_OFFSET                         0x0000000c
#define TX_FES_SETUP_3_FES_TIME_80MHZ_LSB                            16
#define TX_FES_SETUP_3_FES_TIME_80MHZ_MASK                           0xffff0000

/* Description		TX_FES_SETUP_4_MAX_TXOP_TIME
			
			Field only valid if FES_control_mode  is set to
			SW_transmit_mode
			
			
			
			The maximum TXOP time (in us) allowed for the upcoming
			Frame Exchange Sequence (FES) in SW transmit mode. Scheduler
			determines this field based on all TXOP related boundary
			checks.
			
			
			
			This field is used by TX PCU to confirm that the
			upcoming transmission (after BW selection result is known)
			will within this time.
			
			
			
			The max_txop_time is used for a SIFS burst of transmit
			packets.  It may include time reservation for multiple FES.
			
			
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_4_MAX_TXOP_TIME_OFFSET                          0x00000010
#define TX_FES_SETUP_4_MAX_TXOP_TIME_LSB                             0
#define TX_FES_SETUP_4_MAX_TXOP_TIME_MASK                            0x0000ffff

/* Description		TX_FES_SETUP_4_RESERVED_4
			
			<legal 0>
*/
#define TX_FES_SETUP_4_RESERVED_4_OFFSET                             0x00000010
#define TX_FES_SETUP_4_RESERVED_4_LSB                                16
#define TX_FES_SETUP_4_RESERVED_4_MASK                               0x001f0000

/* Description		TX_FES_SETUP_4_PEER_IDX
			
			Used for implicit BF sounding capture on receive Ack/BA.
			The RXPCU needs to tag the receive sounding with peer_idx
			so FW will know which STA is associated with Ack/BA
			sounding. 
*/
#define TX_FES_SETUP_4_PEER_IDX_OFFSET                               0x00000010
#define TX_FES_SETUP_4_PEER_IDX_LSB                                  21
#define TX_FES_SETUP_4_PEER_IDX_MASK                                 0xffe00000

/* Description		TX_FES_SETUP_5_NUM_SS_USER0
			
			Part of TX_BF_PARAMS: Number of spatial streams assigned
			to user 0 in the next MU MIMO packet or the number of
			streams in the next SU packet.  For MU packets the values
			can be 1 or 2, for SU packets the value can be 1, 2, or
			3<legal 1-3>
*/
#define TX_FES_SETUP_5_NUM_SS_USER0_OFFSET                           0x00000014
#define TX_FES_SETUP_5_NUM_SS_USER0_LSB                              0
#define TX_FES_SETUP_5_NUM_SS_USER0_MASK                             0x00000007

/* Description		TX_FES_SETUP_5_NUM_SS_USER1
			
			Part of TX_BF_PARAMS: Number of spatial streams assigned
			to user 1 in the next MIMO packet.  <legal 0-2>
*/
#define TX_FES_SETUP_5_NUM_SS_USER1_OFFSET                           0x00000014
#define TX_FES_SETUP_5_NUM_SS_USER1_LSB                              3
#define TX_FES_SETUP_5_NUM_SS_USER1_MASK                             0x00000038

/* Description		TX_FES_SETUP_5_NUM_SS_USER2
			
			Part of TX_BF_PARAMS: Number of spatial streams assigned
			to user 2 in the next MIMO packet.  <legal 0-2>
*/
#define TX_FES_SETUP_5_NUM_SS_USER2_OFFSET                           0x00000014
#define TX_FES_SETUP_5_NUM_SS_USER2_LSB                              6
#define TX_FES_SETUP_5_NUM_SS_USER2_MASK                             0x000001c0

/* Description		TX_FES_SETUP_5_USE_STATIC_BW
			
			Part of TX_BF_PARAMS: This field is used to indicate to
			the SVD that the b/w that will be defined in the TX_PHY_DESC
			for the upcoming TXBF packet will be the same as the static
			bandwidth, i.e. the bandwidth that was in operation during
			sounding for the clients in question
*/
#define TX_FES_SETUP_5_USE_STATIC_BW_OFFSET                          0x00000014
#define TX_FES_SETUP_5_USE_STATIC_BW_LSB                             9
#define TX_FES_SETUP_5_USE_STATIC_BW_MASK                            0x00000200

/* Description		TX_FES_SETUP_5_STATIC_BANDWIDTH
			
			Part of TX_BF_PARAMS: Packet bandwidth when
			use_static_bw is set:
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			Field is reserved when use_static_bw is clear.
			
			<legal 0-2>
*/
#define TX_FES_SETUP_5_STATIC_BANDWIDTH_OFFSET                       0x00000014
#define TX_FES_SETUP_5_STATIC_BANDWIDTH_LSB                          10
#define TX_FES_SETUP_5_STATIC_BANDWIDTH_MASK                         0x00000c00

/* Description		TX_FES_SETUP_5_CBF_USER_NUMBER
			
			This field is only valid when expect_cbf is set.
			
			This field is inserted into the TX_EXPECT_CBF TLV
			generated by the TX PCU.
			
			
			
			Defines the source of the expected CBF.  
			
			<legal 0-2>
*/
#define TX_FES_SETUP_5_CBF_USER_NUMBER_OFFSET                        0x00000014
#define TX_FES_SETUP_5_CBF_USER_NUMBER_LSB                           12
#define TX_FES_SETUP_5_CBF_USER_NUMBER_MASK                          0x00003000

/* Description		TX_FES_SETUP_5_CV_ID
			
			This field is only valid when expect_cbf is set.
			
			
			
			A unique ID corresponding to the CV data expected from
			the CBF frame. 
			
			
			
			TXPCU copies this field over to the TX_FES_STATUS TLV
*/
#define TX_FES_SETUP_5_CV_ID_OFFSET                                  0x00000014
#define TX_FES_SETUP_5_CV_ID_LSB                                     14
#define TX_FES_SETUP_5_CV_ID_MASK                                    0x003fc000

/* Description		TX_FES_SETUP_5_FRAME_TYPE
			
			(Not supported in Beeliner)
			
			
			
			Frame type indication. Indicates what type of frame is
			being sent. Supported values:
			
			0: default
			
			1: PS-Poll
			
			2-7: Reserved
			
			<legal 0-1>
*/
#define TX_FES_SETUP_5_FRAME_TYPE_OFFSET                             0x00000014
#define TX_FES_SETUP_5_FRAME_TYPE_LSB                                22
#define TX_FES_SETUP_5_FRAME_TYPE_MASK                               0x01c00000

/* Description		TX_FES_SETUP_5_TX_CHAIN_MASK
			
			Tx chain mask to support up to 4 antennas.  
			
			
			
			This field is used for VECTOR_TRANSFER_START and
			TX_CBF_OFFSET. 
			
			
			
			<legal: 1-15>
*/
#define TX_FES_SETUP_5_TX_CHAIN_MASK_OFFSET                          0x00000014
#define TX_FES_SETUP_5_TX_CHAIN_MASK_LSB                             25
#define TX_FES_SETUP_5_TX_CHAIN_MASK_MASK                            0x1e000000

/* Description		TX_FES_SETUP_5_BF_TYPE
			
			Defines the type of beamforming that is required using
			this CV data
			
			
			
			This field is used for TXPCU to construct
			VECTOR_TRANSFER_START. 
			
			
			
			<enum 0    reserved>
			
			<enum 1    LEGACY_BF>
			
			<enum 2    SU_BF>
			
			<enum 3    MU_BF>
			
			 <legal 1-3>
*/
#define TX_FES_SETUP_5_BF_TYPE_OFFSET                                0x00000014
#define TX_FES_SETUP_5_BF_TYPE_LSB                                   29
#define TX_FES_SETUP_5_BF_TYPE_MASK                                  0x60000000

/* Description		TX_FES_SETUP_5_SEND_TX_BF_PARAMS
			
			If set indicates that the TXPCU should send the
			TX_BF_PARAMS associated with this FES.  If
			send_tx_expect_cbf is set then the tx_bf_params would be
			sent after TXPCU sends the TX_CBF_OFFSET TLV.  If txbf is
			set then the tx_bf_params is sent as soon as possible after
			the VECTOR_TRANSFER_START.  For the case of MU, the
			TX_BF_PARAMS is sent as soon as possible after the last
			VECTOR_TRANSFER_START.
*/
#define TX_FES_SETUP_5_SEND_TX_BF_PARAMS_OFFSET                      0x00000014
#define TX_FES_SETUP_5_SEND_TX_BF_PARAMS_LSB                         31
#define TX_FES_SETUP_5_SEND_TX_BF_PARAMS_MASK                        0x80000000

/* Description		TX_FES_SETUP_6_CBF_NC_INDEX
			
			Expected Nc_index of received CBF frame after sending
			NDP or BR-Poll. This field is compared only if
			cbf_nc_index_mask is set to 1. 
			
			<enum 0 nc_1>
			
			<enum 1 nc_2>
			
			<enum 2 nc_3>
			
			<legal 0-2>
*/
#define TX_FES_SETUP_6_CBF_NC_INDEX_OFFSET                           0x00000018
#define TX_FES_SETUP_6_CBF_NC_INDEX_LSB                              0
#define TX_FES_SETUP_6_CBF_NC_INDEX_MASK                             0x00000007

/* Description		TX_FES_SETUP_6_CBF_NC_INDEX_MASK
			
			Mask bit for cbf_nc_index
*/
#define TX_FES_SETUP_6_CBF_NC_INDEX_MASK_OFFSET                      0x00000018
#define TX_FES_SETUP_6_CBF_NC_INDEX_MASK_LSB                         3
#define TX_FES_SETUP_6_CBF_NC_INDEX_MASK_MASK                        0x00000008

/* Description		TX_FES_SETUP_6_CBF_NR_INDEX
			
			Expected Nr_index of received CBF frame after sending
			NDP or BR-Poll. This field is compared only if
			cbf_nr_index_mask is set to 1. 
			
			<enum 0 nr_1>
			
			<enum 1 nr_2>
			
			<enum 2 nr_3>
			
			<enum 3 nr_4>
			
			<legal 0-3>
*/
#define TX_FES_SETUP_6_CBF_NR_INDEX_OFFSET                           0x00000018
#define TX_FES_SETUP_6_CBF_NR_INDEX_LSB                              4
#define TX_FES_SETUP_6_CBF_NR_INDEX_MASK                             0x00000070

/* Description		TX_FES_SETUP_6_CBF_NR_INDEX_MASK
			
			Mask bit for cbf_nr_index
*/
#define TX_FES_SETUP_6_CBF_NR_INDEX_MASK_OFFSET                      0x00000018
#define TX_FES_SETUP_6_CBF_NR_INDEX_MASK_LSB                         7
#define TX_FES_SETUP_6_CBF_NR_INDEX_MASK_MASK                        0x00000080

/* Description		TX_FES_SETUP_6_CBF_BW
			
			Expected channel width of received CBF frame after
			sending NDP or BR-Poll. This field is compared only if
			cbf_bw_mask is set to 1. 
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>
*/
#define TX_FES_SETUP_6_CBF_BW_OFFSET                                 0x00000018
#define TX_FES_SETUP_6_CBF_BW_LSB                                    8
#define TX_FES_SETUP_6_CBF_BW_MASK                                   0x00000300

/* Description		TX_FES_SETUP_6_CBF_BW_MASK
			
			Mask bit for cbf_bw
*/
#define TX_FES_SETUP_6_CBF_BW_MASK_OFFSET                            0x00000018
#define TX_FES_SETUP_6_CBF_BW_MASK_LSB                               10
#define TX_FES_SETUP_6_CBF_BW_MASK_MASK                              0x00000400

/* Description		TX_FES_SETUP_6_CBF_FEEDBACK_TYPE
			
			Expected feedback type of received CBF frame after
			sending NDP or BR-Poll. This field is compared only if
			cbf_feedback_type_mask is set to 1. 
			
			<enum 0     SU>
			
			<enum 1     MU>
			
			<legal all>
*/
#define TX_FES_SETUP_6_CBF_FEEDBACK_TYPE_OFFSET                      0x00000018
#define TX_FES_SETUP_6_CBF_FEEDBACK_TYPE_LSB                         11
#define TX_FES_SETUP_6_CBF_FEEDBACK_TYPE_MASK                        0x00000800

/* Description		TX_FES_SETUP_6_CBF_FEEDBACK_TYPE_MASK
			
			Mask bit for cbf_feedback_type
*/
#define TX_FES_SETUP_6_CBF_FEEDBACK_TYPE_MASK_OFFSET                 0x00000018
#define TX_FES_SETUP_6_CBF_FEEDBACK_TYPE_MASK_LSB                    12
#define TX_FES_SETUP_6_CBF_FEEDBACK_TYPE_MASK_MASK                   0x00001000

/* Description		TX_FES_SETUP_6_CBF_SOUNDING_TOKEN
			
			Expected sounding token of received CBF frame after
			sending NDP or BR-Poll. This field is compared only if
			cbf_sounding_token_mask is set to 1. 
			
			<legal all>
*/
#define TX_FES_SETUP_6_CBF_SOUNDING_TOKEN_OFFSET                     0x00000018
#define TX_FES_SETUP_6_CBF_SOUNDING_TOKEN_LSB                        13
#define TX_FES_SETUP_6_CBF_SOUNDING_TOKEN_MASK                       0x0007e000

/* Description		TX_FES_SETUP_6_CBF_SOUNDING_TOKEN_MASK
			
			Mask bit for cbf_sounding_token
*/
#define TX_FES_SETUP_6_CBF_SOUNDING_TOKEN_MASK_OFFSET                0x00000018
#define TX_FES_SETUP_6_CBF_SOUNDING_TOKEN_MASK_LSB                   19
#define TX_FES_SETUP_6_CBF_SOUNDING_TOKEN_MASK_MASK                  0x00080000

/* Description		TX_FES_SETUP_6_TXBF_PER_PACKET_NO_CSD_NO_WALSH
			
			If set, no_csd and no_walsh is applied to steering
			packet. 
			
			TXPCU copies this field to VECTOR_FRAGMENT_START TLV and
			TX_PHY_DESC TLV. 
*/
#define TX_FES_SETUP_6_TXBF_PER_PACKET_NO_CSD_NO_WALSH_OFFSET        0x00000018
#define TX_FES_SETUP_6_TXBF_PER_PACKET_NO_CSD_NO_WALSH_LSB           20
#define TX_FES_SETUP_6_TXBF_PER_PACKET_NO_CSD_NO_WALSH_MASK          0x00100000

/* Description		TX_FES_SETUP_6_IGNORE_TBTT
			
			If set, PDG ignores remaining TBTTs in PPDU time
			calculation. 
*/
#define TX_FES_SETUP_6_IGNORE_TBTT_OFFSET                            0x00000018
#define TX_FES_SETUP_6_IGNORE_TBTT_LSB                               21
#define TX_FES_SETUP_6_IGNORE_TBTT_MASK                              0x00200000

/* Description		TX_FES_SETUP_6_RESERVED_6
			
			Reserved - MAC to set this field to 0, PHY to ignore
			this field. <legal 0>
*/
#define TX_FES_SETUP_6_RESERVED_6_OFFSET                             0x00000018
#define TX_FES_SETUP_6_RESERVED_6_LSB                                22
#define TX_FES_SETUP_6_RESERVED_6_MASK                               0xffc00000


#endif // _TX_FES_SETUP_H_
