// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_BUFFERS_SETUP_H_
#define _TX_BUFFERS_SETUP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	pcu_buf0_size[7:0], pcu_buf1_size[15:8], tx_dma_highest_rate_user[17:16], reserved_0[31:18]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_BUFFERS_SETUP 1

struct tx_buffers_setup {
    volatile uint32_t pcu_buf0_size                   :  8, //[7:0]
                      pcu_buf1_size                   :  8, //[15:8]
                      tx_dma_highest_rate_user        :  2, //[17:16]
                      reserved_0                      : 14; //[31:18]
};

/*

pcu_buf0_size
			
			Specifies the size of the transmit buffer in the PCU for
			user 0 in case of 2 or 3 user MU-MIMO transmissions.
			
			For SU transmission this field will be ignored.
			
			In units of 128 bytes.
			
			<legal all>

pcu_buf1_size
			
			Specifies the size of the transmit buffer in the PCU for
			user 1 in case of 3 user MU-MIMO transmissions
			
			For SU and 2 user MU-MIMO transmissions this field will
			be ignored.  
			
			For 2 STA MU-MIMO transmissions, user 1 will get the
			remainder of total buffer size minus pcu_buf0_size.
			
			
			
			For 3 STA MU-MIMO transmissions, user 2 will get the
			remainder of total buffer size minus (pcu_buf0_size +
			pcu_buf1_size)
			
			
			
			In units of 128 bytes.
			
			<legal all>

tx_dma_highest_rate_user
			
			Indicates the user with the highest data rate for TX DMA
			to allocate resources
			
			For Su transmission this field will be ignored.  
			
			<legal 1-3>

reserved_0
			
			Generator should set to 0 and consumer shall ignore. 
			<legal 0>
*/


/* Description		TX_BUFFERS_SETUP_0_PCU_BUF0_SIZE
			
			Specifies the size of the transmit buffer in the PCU for
			user 0 in case of 2 or 3 user MU-MIMO transmissions.
			
			For SU transmission this field will be ignored.
			
			In units of 128 bytes.
			
			<legal all>
*/
#define TX_BUFFERS_SETUP_0_PCU_BUF0_SIZE_OFFSET                      0x00000000
#define TX_BUFFERS_SETUP_0_PCU_BUF0_SIZE_LSB                         0
#define TX_BUFFERS_SETUP_0_PCU_BUF0_SIZE_MASK                        0x000000ff

/* Description		TX_BUFFERS_SETUP_0_PCU_BUF1_SIZE
			
			Specifies the size of the transmit buffer in the PCU for
			user 1 in case of 3 user MU-MIMO transmissions
			
			For SU and 2 user MU-MIMO transmissions this field will
			be ignored.  
			
			For 2 STA MU-MIMO transmissions, user 1 will get the
			remainder of total buffer size minus pcu_buf0_size.
			
			
			
			For 3 STA MU-MIMO transmissions, user 2 will get the
			remainder of total buffer size minus (pcu_buf0_size +
			pcu_buf1_size)
			
			
			
			In units of 128 bytes.
			
			<legal all>
*/
#define TX_BUFFERS_SETUP_0_PCU_BUF1_SIZE_OFFSET                      0x00000000
#define TX_BUFFERS_SETUP_0_PCU_BUF1_SIZE_LSB                         8
#define TX_BUFFERS_SETUP_0_PCU_BUF1_SIZE_MASK                        0x0000ff00

/* Description		TX_BUFFERS_SETUP_0_TX_DMA_HIGHEST_RATE_USER
			
			Indicates the user with the highest data rate for TX DMA
			to allocate resources
			
			For Su transmission this field will be ignored.  
			
			<legal 1-3>
*/
#define TX_BUFFERS_SETUP_0_TX_DMA_HIGHEST_RATE_USER_OFFSET           0x00000000
#define TX_BUFFERS_SETUP_0_TX_DMA_HIGHEST_RATE_USER_LSB              16
#define TX_BUFFERS_SETUP_0_TX_DMA_HIGHEST_RATE_USER_MASK             0x00030000

/* Description		TX_BUFFERS_SETUP_0_RESERVED_0
			
			Generator should set to 0 and consumer shall ignore. 
			<legal 0>
*/
#define TX_BUFFERS_SETUP_0_RESERVED_0_OFFSET                         0x00000000
#define TX_BUFFERS_SETUP_0_RESERVED_0_LSB                            18
#define TX_BUFFERS_SETUP_0_RESERVED_0_MASK                           0xfffc0000


#endif // _TX_BUFFERS_SETUP_H_
