// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _SCH_RX_FRAME_INFO_H_
#define _SCH_RX_FRAME_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	power_state[0], frame_type_received[2:1], frame_subtype_received[6:3], qos_tid[10:7], reserved_0[31:11]
//	1	peer_entry_ptr[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_SCH_RX_FRAME_INFO 2

struct sch_rx_frame_info {
    volatile uint32_t power_state                     :  1, //[0]
                      frame_type_received             :  2, //[2:1]
                      frame_subtype_received          :  4, //[6:3]
                      qos_tid                         :  4, //[10:7]
                      reserved_0                      : 21; //[31:11]
    volatile uint32_t peer_entry_ptr                  : 32; //[31:0]
};

/*

power_state
			
			The power state of the STA.
			
			
			
			0: The STA is NOT in power save mode
			
			1: The STA IS in power save mode
			
			<legal all>

frame_type_received
			
			The frame type from the Frame control field of the frame
			received.
			
			<legal all> 

frame_subtype_received
			
			The frame subtype from the Frame control field of the
			frame received.
			
			<legal all> 

qos_tid
			
			Only valid when Frame type/subtype indicates a QoS data
			frame.
			
			
			
			The TID from the QOS control field of the received frame
			<legal all>

reserved_0
			
			<legal 0>

peer_entry_ptr
			
			Pointer to the peer entry.
			
			This pointer is used by the scheduler to update the
			power state of the STA in the peer entry.
			
			This field is also used by the scheduler to determine if
			there are some pending transmissions for this STA, and if
			they should be cancelled if the STA just transitioned into a
			power save mode.
			
			
			
			<legal all>
*/


/* Description		SCH_RX_FRAME_INFO_0_POWER_STATE
			
			The power state of the STA.
			
			
			
			0: The STA is NOT in power save mode
			
			1: The STA IS in power save mode
			
			<legal all>
*/
#define SCH_RX_FRAME_INFO_0_POWER_STATE_OFFSET                       0x00000000
#define SCH_RX_FRAME_INFO_0_POWER_STATE_LSB                          0
#define SCH_RX_FRAME_INFO_0_POWER_STATE_MASK                         0x00000001

/* Description		SCH_RX_FRAME_INFO_0_FRAME_TYPE_RECEIVED
			
			The frame type from the Frame control field of the frame
			received.
			
			<legal all> 
*/
#define SCH_RX_FRAME_INFO_0_FRAME_TYPE_RECEIVED_OFFSET               0x00000000
#define SCH_RX_FRAME_INFO_0_FRAME_TYPE_RECEIVED_LSB                  1
#define SCH_RX_FRAME_INFO_0_FRAME_TYPE_RECEIVED_MASK                 0x00000006

/* Description		SCH_RX_FRAME_INFO_0_FRAME_SUBTYPE_RECEIVED
			
			The frame subtype from the Frame control field of the
			frame received.
			
			<legal all> 
*/
#define SCH_RX_FRAME_INFO_0_FRAME_SUBTYPE_RECEIVED_OFFSET            0x00000000
#define SCH_RX_FRAME_INFO_0_FRAME_SUBTYPE_RECEIVED_LSB               3
#define SCH_RX_FRAME_INFO_0_FRAME_SUBTYPE_RECEIVED_MASK              0x00000078

/* Description		SCH_RX_FRAME_INFO_0_QOS_TID
			
			Only valid when Frame type/subtype indicates a QoS data
			frame.
			
			
			
			The TID from the QOS control field of the received frame
			<legal all>
*/
#define SCH_RX_FRAME_INFO_0_QOS_TID_OFFSET                           0x00000000
#define SCH_RX_FRAME_INFO_0_QOS_TID_LSB                              7
#define SCH_RX_FRAME_INFO_0_QOS_TID_MASK                             0x00000780

/* Description		SCH_RX_FRAME_INFO_0_RESERVED_0
			
			<legal 0>
*/
#define SCH_RX_FRAME_INFO_0_RESERVED_0_OFFSET                        0x00000000
#define SCH_RX_FRAME_INFO_0_RESERVED_0_LSB                           11
#define SCH_RX_FRAME_INFO_0_RESERVED_0_MASK                          0xfffff800

/* Description		SCH_RX_FRAME_INFO_1_PEER_ENTRY_PTR
			
			Pointer to the peer entry.
			
			This pointer is used by the scheduler to update the
			power state of the STA in the peer entry.
			
			This field is also used by the scheduler to determine if
			there are some pending transmissions for this STA, and if
			they should be cancelled if the STA just transitioned into a
			power save mode.
			
			
			
			<legal all>
*/
#define SCH_RX_FRAME_INFO_1_PEER_ENTRY_PTR_OFFSET                    0x00000004
#define SCH_RX_FRAME_INFO_1_PEER_ENTRY_PTR_LSB                       0
#define SCH_RX_FRAME_INFO_1_PEER_ENTRY_PTR_MASK                      0xffffffff


#endif // _SCH_RX_FRAME_INFO_H_
