// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PPDU_TX_PHY_DESC_H_
#define _PPDU_TX_PHY_DESC_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0-1	struct pre_tx_phy_desc pre_tx_phy_desc_bw20;
//	2-3	struct pre_tx_phy_desc pre_tx_phy_desc_bw40;
//	4-5	struct pre_tx_phy_desc pre_tx_phy_desc_bw80;
//	6	ppdu_tx_antenna_sector_ctrl_20[23:0], pdg_sifs_response_valid[24], pdg_sifs_response_bw[26:25], reserved_6[31:27]
//	7	ppdu_tx_antenna_sector_ctrl_40[23:0], reserved_7[31:24]
//	8	ppdu_tx_antenna_sector_ctrl_80[23:0], reserved_8[31:24]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PPDU_TX_PHY_DESC 9

struct ppdu_tx_phy_desc {
    struct            pre_tx_phy_desc                       pre_tx_phy_desc_bw20;
    struct            pre_tx_phy_desc                       pre_tx_phy_desc_bw40;
    struct            pre_tx_phy_desc                       pre_tx_phy_desc_bw80;
    volatile uint32_t ppdu_tx_antenna_sector_ctrl_20  : 24, //[23:0]
                      pdg_sifs_response_valid         :  1, //[24]
                      pdg_sifs_response_bw            :  2, //[26:25]
                      reserved_6                      :  5; //[31:27]
    volatile uint32_t ppdu_tx_antenna_sector_ctrl_40  : 24, //[23:0]
                      reserved_7                      :  8; //[31:24]
    volatile uint32_t ppdu_tx_antenna_sector_ctrl_80  : 24, //[23:0]
                      reserved_8                      :  8; //[31:24]
};

/*

struct pre_tx_phy_desc pre_tx_phy_desc_bw20
			
			Field only valid in case 20MH PPDU transmission is
			allowed (ppdu_allow_bw20 is set)
			
			
			
			See structure description of: PRE_TX_PHY_DESC 

struct pre_tx_phy_desc pre_tx_phy_desc_bw40
			
			Field only valid in case 40MH PPDU transmission is
			allowed (ppdu_allow_bw40 is set)
			
			 
			
			See structure description of: PRE_TX_PHY_DESC 

struct pre_tx_phy_desc pre_tx_phy_desc_bw80
			
			Field only valid in case 80MH PPDU transmission is
			allowed (ppdu_allow_bw80 is set)
			
			 
			
			See structure description of: PRE_TX_PHY_DESC 

ppdu_tx_antenna_sector_ctrl_20
			
			Sectored transmit antenna control for the medium
			protection frame when transmitted at 20 MHz. <legal all>

pdg_sifs_response_valid
			
			When set, this TLV is generated by the PDG as a result
			of receiving the PDG_RESPONSE TLV
			
			<legal all>

pdg_sifs_response_bw
			
			Only valid when pdg_sifs_response_valid is set.
			
			<enum 0 response_20bw>  Only the pre_tx_phy_desc_bw20
			contains valid info
			
			<enum 1 response_40bw>  Only the pre_tx_phy_desc_bw40
			contains valid info
			
			<enum 2 response_80bw>  Only the pre_tx_phy_desc_bw80
			contains valid info

reserved_6
			
			<legal 0>

ppdu_tx_antenna_sector_ctrl_40
			
			Sectored transmit antenna control for the medium
			protection frame when transmitted at 40 MHz. <legal all>

reserved_7
			
			<legal 0>

ppdu_tx_antenna_sector_ctrl_80
			
			Sectored transmit antenna control for the medium
			protection frame when transmitted at 80 MHz. <legal all>

reserved_8
			
			<legal 0>
*/

#define PPDU_TX_PHY_DESC_0_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW20_OFFSET 0x00000000
#define PPDU_TX_PHY_DESC_0_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW20_LSB  24
#define PPDU_TX_PHY_DESC_0_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW20_MASK 0xffffffff
#define PPDU_TX_PHY_DESC_1_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW20_OFFSET 0x00000004
#define PPDU_TX_PHY_DESC_1_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW20_LSB  24
#define PPDU_TX_PHY_DESC_1_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW20_MASK 0xffffffff
#define PPDU_TX_PHY_DESC_2_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW40_OFFSET 0x00000008
#define PPDU_TX_PHY_DESC_2_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW40_LSB  24
#define PPDU_TX_PHY_DESC_2_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW40_MASK 0xffffffff
#define PPDU_TX_PHY_DESC_3_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW40_OFFSET 0x0000000c
#define PPDU_TX_PHY_DESC_3_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW40_LSB  24
#define PPDU_TX_PHY_DESC_3_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW40_MASK 0xffffffff
#define PPDU_TX_PHY_DESC_4_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW80_OFFSET 0x00000010
#define PPDU_TX_PHY_DESC_4_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW80_LSB  24
#define PPDU_TX_PHY_DESC_4_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW80_MASK 0xffffffff
#define PPDU_TX_PHY_DESC_5_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW80_OFFSET 0x00000014
#define PPDU_TX_PHY_DESC_5_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW80_LSB  24
#define PPDU_TX_PHY_DESC_5_PRE_TX_PHY_DESC_PRE_TX_PHY_DESC_BW80_MASK 0xffffffff

/* Description		PPDU_TX_PHY_DESC_6_PPDU_TX_ANTENNA_SECTOR_CTRL_20
			
			Sectored transmit antenna control for the medium
			protection frame when transmitted at 20 MHz. <legal all>
*/
#define PPDU_TX_PHY_DESC_6_PPDU_TX_ANTENNA_SECTOR_CTRL_20_OFFSET     0x00000018
#define PPDU_TX_PHY_DESC_6_PPDU_TX_ANTENNA_SECTOR_CTRL_20_LSB        0
#define PPDU_TX_PHY_DESC_6_PPDU_TX_ANTENNA_SECTOR_CTRL_20_MASK       0x00ffffff

/* Description		PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_VALID
			
			When set, this TLV is generated by the PDG as a result
			of receiving the PDG_RESPONSE TLV
			
			<legal all>
*/
#define PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_VALID_OFFSET            0x00000018
#define PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_VALID_LSB               24
#define PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_VALID_MASK              0x01000000

/* Description		PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_BW
			
			Only valid when pdg_sifs_response_valid is set.
			
			<enum 0 response_20bw>  Only the pre_tx_phy_desc_bw20
			contains valid info
			
			<enum 1 response_40bw>  Only the pre_tx_phy_desc_bw40
			contains valid info
			
			<enum 2 response_80bw>  Only the pre_tx_phy_desc_bw80
			contains valid info
*/
#define PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_BW_OFFSET               0x00000018
#define PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_BW_LSB                  25
#define PPDU_TX_PHY_DESC_6_PDG_SIFS_RESPONSE_BW_MASK                 0x06000000

/* Description		PPDU_TX_PHY_DESC_6_RESERVED_6
			
			<legal 0>
*/
#define PPDU_TX_PHY_DESC_6_RESERVED_6_OFFSET                         0x00000018
#define PPDU_TX_PHY_DESC_6_RESERVED_6_LSB                            27
#define PPDU_TX_PHY_DESC_6_RESERVED_6_MASK                           0xf8000000

/* Description		PPDU_TX_PHY_DESC_7_PPDU_TX_ANTENNA_SECTOR_CTRL_40
			
			Sectored transmit antenna control for the medium
			protection frame when transmitted at 40 MHz. <legal all>
*/
#define PPDU_TX_PHY_DESC_7_PPDU_TX_ANTENNA_SECTOR_CTRL_40_OFFSET     0x0000001c
#define PPDU_TX_PHY_DESC_7_PPDU_TX_ANTENNA_SECTOR_CTRL_40_LSB        0
#define PPDU_TX_PHY_DESC_7_PPDU_TX_ANTENNA_SECTOR_CTRL_40_MASK       0x00ffffff

/* Description		PPDU_TX_PHY_DESC_7_RESERVED_7
			
			<legal 0>
*/
#define PPDU_TX_PHY_DESC_7_RESERVED_7_OFFSET                         0x0000001c
#define PPDU_TX_PHY_DESC_7_RESERVED_7_LSB                            24
#define PPDU_TX_PHY_DESC_7_RESERVED_7_MASK                           0xff000000

/* Description		PPDU_TX_PHY_DESC_8_PPDU_TX_ANTENNA_SECTOR_CTRL_80
			
			Sectored transmit antenna control for the medium
			protection frame when transmitted at 80 MHz. <legal all>
*/
#define PPDU_TX_PHY_DESC_8_PPDU_TX_ANTENNA_SECTOR_CTRL_80_OFFSET     0x00000020
#define PPDU_TX_PHY_DESC_8_PPDU_TX_ANTENNA_SECTOR_CTRL_80_LSB        0
#define PPDU_TX_PHY_DESC_8_PPDU_TX_ANTENNA_SECTOR_CTRL_80_MASK       0x00ffffff

/* Description		PPDU_TX_PHY_DESC_8_RESERVED_8
			
			<legal 0>
*/
#define PPDU_TX_PHY_DESC_8_RESERVED_8_OFFSET                         0x00000020
#define PPDU_TX_PHY_DESC_8_RESERVED_8_LSB                            24
#define PPDU_TX_PHY_DESC_8_RESERVED_8_MASK                           0xff000000


#endif // _PPDU_TX_PHY_DESC_H_
