// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PDG_FES_SETUP_H_
#define _PDG_FES_SETUP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	transmit_fes_type[3:0], medium_prot_type[6:4], su_response_type[9:7], update_timestamp_32[10], update_timestamp_64[11], reserved_0_a[17:12], mprot_required_bw20[18], mprot_required_bw40[19], mprot_required_bw80[20], ppdu_allowed_bw20[21], ppdu_allowed_bw40[22], ppdu_allowed_bw80[23], other_queues_more_data[24], bw_indication_enable[25], set_fc_pwr_mgt[26], reserved_0c[31:27]
//	1	location_req[0], location_type[1], remaining_tbtt[17:2], mu_ndp[18], ibfcal_enable[19], bf_type[21:20], reserved_1c[27:22], channel_capture[28], txop_tbtt[29], clpc_en[30], measure_power[31]
//	2	max_fes_time[15:0], max_ppdu_time[31:16]
//	3	max_txop_time[15:0], extend_duration_value[31:16]
//	4	duration_field_ctrl[1:0], duration_extension[2], group_id[8:3], hw_mode_mprot_scrambler_seed_mode[11:9], hw_mode_ppdu_scrambler_seed_mode[14:12], reserved_4[15], insert_timestamp_offset[31:16]
//	5-6	struct tx_rate_setting tx_rate_ctr_mprot_bw20;
//	7-8	struct tx_rate_setting tx_rate_ctr_mprot_bw40;
//	9-10	struct tx_rate_setting tx_rate_ctr_mprot_bw80;
//	11-12	struct tx_rate_setting response_rate_mprot_bw20;
//	13-14	struct tx_rate_setting response_rate_mprot_bw40;
//	15-16	struct tx_rate_setting response_rate_mprot_bw80;
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PDG_FES_SETUP 17

struct pdg_fes_setup {
    volatile uint32_t transmit_fes_type               :  4, //[3:0]
                      medium_prot_type                :  3, //[6:4]
                      su_response_type                :  3, //[9:7]
                      update_timestamp_32             :  1, //[10]
                      update_timestamp_64             :  1, //[11]
                      reserved_0_a                    :  6, //[17:12]
                      mprot_required_bw20             :  1, //[18]
                      mprot_required_bw40             :  1, //[19]
                      mprot_required_bw80             :  1, //[20]
                      ppdu_allowed_bw20               :  1, //[21]
                      ppdu_allowed_bw40               :  1, //[22]
                      ppdu_allowed_bw80               :  1, //[23]
                      other_queues_more_data          :  1, //[24]
                      bw_indication_enable            :  1, //[25]
                      set_fc_pwr_mgt                  :  1, //[26]
                      reserved_0c                     :  5; //[31:27]
    volatile uint32_t location_req                    :  1, //[0]
                      location_type                   :  1, //[1]
                      remaining_tbtt                  : 16, //[17:2]
                      mu_ndp                          :  1, //[18]
                      ibfcal_enable                   :  1, //[19]
                      bf_type                         :  2, //[21:20]
                      reserved_1c                     :  6, //[27:22]
                      channel_capture                 :  1, //[28]
                      txop_tbtt                       :  1, //[29]
                      clpc_en                         :  1, //[30]
                      measure_power                   :  1; //[31]
    volatile uint32_t max_fes_time                    : 16, //[15:0]
                      max_ppdu_time                   : 16; //[31:16]
    volatile uint32_t max_txop_time                   : 16, //[15:0]
                      extend_duration_value           : 16; //[31:16]
    volatile uint32_t duration_field_ctrl             :  2, //[1:0]
                      duration_extension              :  1, //[2]
                      group_id                        :  6, //[8:3]
                      hw_mode_mprot_scrambler_seed_mode:  3, //[11:9]
                      hw_mode_ppdu_scrambler_seed_mode:  3, //[14:12]
                      reserved_4                      :  1, //[15]
                      insert_timestamp_offset         : 16; //[31:16]
    struct            tx_rate_setting                       tx_rate_ctr_mprot_bw20;
    struct            tx_rate_setting                       tx_rate_ctr_mprot_bw40;
    struct            tx_rate_setting                       tx_rate_ctr_mprot_bw80;
    struct            tx_rate_setting                       response_rate_mprot_bw20;
    struct            tx_rate_setting                       response_rate_mprot_bw40;
    struct            tx_rate_setting                       response_rate_mprot_bw80;
};

/*

transmit_fes_type
			
			<enum 0 regular_transmission>  A Scheduled SU or MU
			transmission
			
			-
			
			
			
			15-1 Reserved
			
			<legal 0>

medium_prot_type
			
			Self Gen Medium Protection type used
			
			<enum 0 No_protection>
			
			<enum 1 RTS_legacy>
			
			<enum 2 RTS_11ac_static_bw>
			
			<enum 3 RTS_11ac_dynamic_bw>
			
			<enum 4 CTS2Self>
			
			<legal 0-4>

su_response_type
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			
			
			<enum 0 No_response_expected>
			
			<enum 1 ACK_expected>
			
			<enum 2 BA_expected>
			
			<enum 3 ActionNoAck_expected> SW sets this after sending
			NDP or BR-Poll.
			
			<enum 4 ACK_BA_expected> SW sets this after sending VHT
			single MPDU. Some vendor chip might send BA rather than ACK
			in response to VHT single MPDU but still we want to accept
			BA as well. That's why this type is added.   
			
			<enum 5 CTS_expected> SW sets this after queuing RTS
			frame as standalone packet and sending it.  
			
			<enum 6 ACK_Data_expected> SW sets this after sending
			PS-Poll. 
			
			<enum 7 Any_response_accepted> SW sets this if SW wants
			to accept any directed CRC-pass frame while waiting for
			response. This is mainly for debug purpose.
			
			<legal all>
			
			
			
			Note: For MU transmission this field is only valid for
			the datastructures for this user 0.  For user 1 and user 2
			this field should be set to No response expected.  

update_timestamp_32
			
			Update the 32 bit timestamp at the offset specified by
			the insert_timestamp_offset.  This will be used for AWDL
			action frames.  The value of the TSF will be added to the
			timestamp field in the packet buffer in memory.  The
			tx_delay should also be included in the timestamp
			field<legal all>

update_timestamp_64
			
			Update the 64 bit TSF at the offset specified by the
			insert_timestamp_offset.  This will be used for beacons and
			probe response frames.  The value of the TSF will be added
			to the TSF field in the packet buffer in memory.  The

reserved_0_a
			

mprot_required_bw20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>

mprot_required_bw40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0<legal all>

mprot_required_bw80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>

ppdu_allowed_bw20
			
			When set, allow PPDU transmission with 20 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>

ppdu_allowed_bw40
			
			When set, allow PPDU transmission with 40 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>

ppdu_allowed_bw80
			
			When set, allow PPDU transmission with 80 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0 <legal all>

other_queues_more_data
			
			This setting is passed on to the PCU in the
			PCU_PPDU_SETUP TLV. It is used by the PCU TX to determine if
			it needs to set the More data bit in the FC field for the
			transmitted frames

bw_indication_enable
			
			If set, indicates that the bw should be indicated in the
			service field.  This is only used for legacy OFDM 11a/11g
			PPDUs.

set_fc_pwr_mgt
			
			When set, the TX PCU will set the power management bit
			in the Frame Control field for the transmitted frames.
			
			This will only be set for the SW generated path.
			
			<legal all>

reserved_0c
			
			<legal 0>

location_req
			
			(Not supported in Beeliner)
			
			
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.

location_type
			
			(Not supported in Beeliner)
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>

remaining_tbtt
			
			This field indicates remaining TBTT, which is filled by
			HWSCH after considering remaining TBTT1 /2 with TBTT1/2 mask
			fields.

mu_ndp
			
			If set indicates that this packet is an NDP used for MU
			channel estimation.  This bit will be used by the TPC to
			signal that the analog gain settings can be updated. The
			analog gain settings will not change for subsequent MU data
			packets.

ibfcal_enable
			
			Defines the current packet as test packet for implicit
			BF calibration purposes  <legal 0-1>

bf_type
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>

reserved_1c
			
			<legal 0>

channel_capture
			
			When set, indicates that the BB should be armed to
			capture the channel on the next received packet. This
			channel estimate is passed to the MAC if the packet is
			successfully received. 
			
			Copied by PDG into the channel_capture field in the
			PPDU_TX_PHY_DESC TLV
			
			<legal 0-1>

txop_tbtt
			
			(Not supported in Beeliner)
			
			
			
			0: TXOP
			
			1: remaining TBTT
			
			By design, HWSCH populates minimum of { TXOP, remaining
			TBTT} in max_TXOP_time of PDG_FES_SETUP and this txop_tbtt
			field tells which one is currently populated in
			max_TXOP_time. If TXOP is populated and if
			ignore_txop_1st_pkt is set in TX_FES_SETUP TLV, then PDG is
			allowed to transmit single MPDU despite exceeding
			max_TXOP_time. However, if remaining TBTT is populated, PDG
			is not allowed to transmit any single MPDU if exceeding
			max_TXOP_time, regardless of ignore_txop_1st_pkt. 
			
			<legal 0-1>

clpc_en
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>

measure_power
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0     measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1     measure_en> TPC will latch power measurement
			result for current packet

max_fes_time
			
			The maximum medium time (in us) that the total Frame
			exchange sequence is allowed to take.  FES time will include
			the PPDU time plus the optional SIFS + Ack/BA time and if
			medium protection is included the RTS + SIFS + CTS + SIFS
			time or CTS + SIFS time.
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			<legal all>

max_ppdu_time
			
			The maximum medium time (in us) that the PPDU Frame is
			allowed to take. This value is to exceed 5484 usec which is
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			 <legal all>

max_txop_time
			
			The maximum TXOP time (in us) for the upcoming Frame
			Exchange Sequence (FES). 
			
			
			
			The upcoming frame exchange sequence that PDG will
			calculate is not allowed to go beyond this time (and other
			transmit boundaries like max_fes_time).
			
			
			
			The max_TXOP_time field is sometimes also used to
			calculate the value that needs to be inserted in the
			duration fields of the frames transmitted. (See field:
			Duration_field_ctrl).
			
			
			
			max_txop_time is used for a SIFS burst of transmit
			packets.  It may include time reservation for multiple FES.
			
			
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			
			
			  <legal all>

extend_duration_value
			
			Field only valid when Duration_extension is set and
			Duration_field_ctrl is set to protect FES or protect TXOP.
			
			
			
			Based on TLV field  Duration_field_ctrl, the PDG will
			calculate the normal duration field value to be inserted in
			the transmitted frames. 
			
			When Duration extension is set, and Duration_field_ctrl
			is set to protect FES or protect TXOP, this calculated
			duration value is increased with the Extend_duration_value.
			
			
			
			Max duration value defined in standard spec is 32,767
			us. So, note that after calculation, final duration value
			can't exceed this. 
			
			<legal all>

duration_field_ctrl
			
			Duration field value generation control
			
			<enum 0 set_dur_zero> Set duration field to 0
			
			<enum 1 protect_entire_fes> Duration field will only
			coverer all the frames in the current Frame Excange Sequence
			that PDG is calculating: Typically the ACK/BA after the data
			frame.
			
			<enum 2 protect_entire_txop> The duration field protects
			the medium up to the end of TXOP, given in field:
			max_TXOP_time
			
			<legal 0-2>

duration_extension
			
			Duration extension control
			
			0: No action
			
			1: Add the extra_duration_value to the calculated
			duration field.

group_id
			
			Field only valid when Transmit_fes_type indicates a
			regular (non self generated) transmission
			
			
			
			When PDG detects that the transmission is at a VHT rate,

hw_mode_mprot_scrambler_seed_mode
			
			Field only valid in pdg_transmit_mode. 
			
			
			
			<enum 0 legacy_mode> 
			
			Automatic based on medium_prot_type. 
			
			<enum 1 gen_4bit_static> Generate lower 4 bits
			
			dyn_bandwidth = 0 (static)
			
			<enum 2 gen_4bit_dynamic>
			
			Generate lower 4 bits
			
			dyn_bandwidth = 1 (dynamic)
			
			<enum 3 gen_5bit>
			
			Generate lower 5 bits
			
			<enum 4 gen_7bit>
			
			Generate all 7 bits
			
			<legal 0-4>

hw_mode_ppdu_scrambler_seed_mode
			
			Field only valid in pdg_transmit_mode. 
			
			
			
			<enum 0 legacy_mode> 
			
			Generate all 7 bits
			
			<enum 1 gen_4bit_static> Generate lower 4 bits
			
			dyn_bandwidth = 0 (static)
			
			<enum 2 gen_4bit_dynamic>
			
			Generate lower 4 bits
			
			dyn_bandwidth = 1 (dynamic)
			
			<enum 3 gen_5bit>
			
			Generate lower 5 bits
			
			<enum 4 gen_7bit>
			
			Generate all 7 bits
			
			<legal 0-4>

reserved_4
			
			<legal 0>

insert_timestamp_offset
			
			Byte offset  to the first byte of the timestamp to be
			inserted.  This is applicable to both beacon and probe
			response TSF and the AWDL timestamp<legal all>

struct tx_rate_setting tx_rate_ctr_mprot_bw20
			
			Field only valid when Mprot_required_bw20 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 20 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting tx_rate_ctr_mprot_bw40
			
			Field only valid when Mprot_required_bw40 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 40 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting tx_rate_ctr_mprot_bw80
			
			Field only valid when Mprot_required_bw80 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 80 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting response_rate_mprot_bw20
			
			Field only valid when Mprot_required_bw20 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 20 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting response_rate_mprot_bw40
			
			Field only valid when Mprot_required_bw40 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 40 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting response_rate_mprot_bw80
			
			Field only valid when Mprot_required_bw80 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 80 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0
*/


/* Description		PDG_FES_SETUP_0_TRANSMIT_FES_TYPE
			
			<enum 0 regular_transmission>  A Scheduled SU or MU
			transmission
			
			-
			
			
			
			15-1 Reserved
			
			<legal 0>
*/
#define PDG_FES_SETUP_0_TRANSMIT_FES_TYPE_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_TRANSMIT_FES_TYPE_LSB                        0
#define PDG_FES_SETUP_0_TRANSMIT_FES_TYPE_MASK                       0x0000000f

/* Description		PDG_FES_SETUP_0_MEDIUM_PROT_TYPE
			
			Self Gen Medium Protection type used
			
			<enum 0 No_protection>
			
			<enum 1 RTS_legacy>
			
			<enum 2 RTS_11ac_static_bw>
			
			<enum 3 RTS_11ac_dynamic_bw>
			
			<enum 4 CTS2Self>
			
			<legal 0-4>
*/
#define PDG_FES_SETUP_0_MEDIUM_PROT_TYPE_OFFSET                      0x00000000
#define PDG_FES_SETUP_0_MEDIUM_PROT_TYPE_LSB                         4
#define PDG_FES_SETUP_0_MEDIUM_PROT_TYPE_MASK                        0x00000070

/* Description		PDG_FES_SETUP_0_SU_RESPONSE_TYPE
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			
			
			<enum 0 No_response_expected>
			
			<enum 1 ACK_expected>
			
			<enum 2 BA_expected>
			
			<enum 3 ActionNoAck_expected> SW sets this after sending
			NDP or BR-Poll.
			
			<enum 4 ACK_BA_expected> SW sets this after sending VHT
			single MPDU. Some vendor chip might send BA rather than ACK
			in response to VHT single MPDU but still we want to accept
			BA as well. That's why this type is added.   
			
			<enum 5 CTS_expected> SW sets this after queuing RTS
			frame as standalone packet and sending it.  
			
			<enum 6 ACK_Data_expected> SW sets this after sending
			PS-Poll. 
			
			<enum 7 Any_response_accepted> SW sets this if SW wants
			to accept any directed CRC-pass frame while waiting for
			response. This is mainly for debug purpose.
			
			<legal all>
			
			
			
			Note: For MU transmission this field is only valid for
			the datastructures for this user 0.  For user 1 and user 2
			this field should be set to No response expected.  
*/
#define PDG_FES_SETUP_0_SU_RESPONSE_TYPE_OFFSET                      0x00000000
#define PDG_FES_SETUP_0_SU_RESPONSE_TYPE_LSB                         7
#define PDG_FES_SETUP_0_SU_RESPONSE_TYPE_MASK                        0x00000380

/* Description		PDG_FES_SETUP_0_UPDATE_TIMESTAMP_32
			
			Update the 32 bit timestamp at the offset specified by
			the insert_timestamp_offset.  This will be used for AWDL
			action frames.  The value of the TSF will be added to the
			timestamp field in the packet buffer in memory.  The
			tx_delay should also be included in the timestamp
			field<legal all>
*/
#define PDG_FES_SETUP_0_UPDATE_TIMESTAMP_32_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_UPDATE_TIMESTAMP_32_LSB                      10
#define PDG_FES_SETUP_0_UPDATE_TIMESTAMP_32_MASK                     0x00000400

/* Description		PDG_FES_SETUP_0_UPDATE_TIMESTAMP_64
			
			Update the 64 bit TSF at the offset specified by the
			insert_timestamp_offset.  This will be used for beacons and
			probe response frames.  The value of the TSF will be added
			to the TSF field in the packet buffer in memory.  The
*/
#define PDG_FES_SETUP_0_UPDATE_TIMESTAMP_64_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_UPDATE_TIMESTAMP_64_LSB                      11
#define PDG_FES_SETUP_0_UPDATE_TIMESTAMP_64_MASK                     0x00000800

/* Description		PDG_FES_SETUP_0_RESERVED_0_A
			
*/
#define PDG_FES_SETUP_0_RESERVED_0_A_OFFSET                          0x00000000
#define PDG_FES_SETUP_0_RESERVED_0_A_LSB                             12
#define PDG_FES_SETUP_0_RESERVED_0_A_MASK                            0x0003f000

/* Description		PDG_FES_SETUP_0_MPROT_REQUIRED_BW20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>
*/
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW20_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW20_LSB                      18
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW20_MASK                     0x00040000

/* Description		PDG_FES_SETUP_0_MPROT_REQUIRED_BW40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0<legal all>
*/
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW40_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW40_LSB                      19
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW40_MASK                     0x00080000

/* Description		PDG_FES_SETUP_0_MPROT_REQUIRED_BW80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>
*/
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW80_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW80_LSB                      20
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW80_MASK                     0x00100000

/* Description		PDG_FES_SETUP_0_PPDU_ALLOWED_BW20
			
			When set, allow PPDU transmission with 20 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>
*/
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW20_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW20_LSB                        21
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW20_MASK                       0x00200000

/* Description		PDG_FES_SETUP_0_PPDU_ALLOWED_BW40
			
			When set, allow PPDU transmission with 40 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>
*/
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW40_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW40_LSB                        22
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW40_MASK                       0x00400000

/* Description		PDG_FES_SETUP_0_PPDU_ALLOWED_BW80
			
			When set, allow PPDU transmission with 80 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0 <legal all>
*/
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW80_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW80_LSB                        23
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW80_MASK                       0x00800000

/* Description		PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA
			
			This setting is passed on to the PCU in the
			PCU_PPDU_SETUP TLV. It is used by the PCU TX to determine if
			it needs to set the More data bit in the FC field for the
			transmitted frames
*/
#define PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA_OFFSET                0x00000000
#define PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA_LSB                   24
#define PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA_MASK                  0x01000000

/* Description		PDG_FES_SETUP_0_BW_INDICATION_ENABLE
			
			If set, indicates that the bw should be indicated in the
			service field.  This is only used for legacy OFDM 11a/11g
			PPDUs.
*/
#define PDG_FES_SETUP_0_BW_INDICATION_ENABLE_OFFSET                  0x00000000
#define PDG_FES_SETUP_0_BW_INDICATION_ENABLE_LSB                     25
#define PDG_FES_SETUP_0_BW_INDICATION_ENABLE_MASK                    0x02000000

/* Description		PDG_FES_SETUP_0_SET_FC_PWR_MGT
			
			When set, the TX PCU will set the power management bit
			in the Frame Control field for the transmitted frames.
			
			This will only be set for the SW generated path.
			
			<legal all>
*/
#define PDG_FES_SETUP_0_SET_FC_PWR_MGT_OFFSET                        0x00000000
#define PDG_FES_SETUP_0_SET_FC_PWR_MGT_LSB                           26
#define PDG_FES_SETUP_0_SET_FC_PWR_MGT_MASK                          0x04000000

/* Description		PDG_FES_SETUP_0_RESERVED_0C
			
			<legal 0>
*/
#define PDG_FES_SETUP_0_RESERVED_0C_OFFSET                           0x00000000
#define PDG_FES_SETUP_0_RESERVED_0C_LSB                              27
#define PDG_FES_SETUP_0_RESERVED_0C_MASK                             0xf8000000

/* Description		PDG_FES_SETUP_1_LOCATION_REQ
			
			(Not supported in Beeliner)
			
			
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.
*/
#define PDG_FES_SETUP_1_LOCATION_REQ_OFFSET                          0x00000004
#define PDG_FES_SETUP_1_LOCATION_REQ_LSB                             0
#define PDG_FES_SETUP_1_LOCATION_REQ_MASK                            0x00000001

/* Description		PDG_FES_SETUP_1_LOCATION_TYPE
			
			(Not supported in Beeliner)
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_LOCATION_TYPE_OFFSET                         0x00000004
#define PDG_FES_SETUP_1_LOCATION_TYPE_LSB                            1
#define PDG_FES_SETUP_1_LOCATION_TYPE_MASK                           0x00000002

/* Description		PDG_FES_SETUP_1_REMAINING_TBTT
			
			This field indicates remaining TBTT, which is filled by
			HWSCH after considering remaining TBTT1 /2 with TBTT1/2 mask
			fields.
*/
#define PDG_FES_SETUP_1_REMAINING_TBTT_OFFSET                        0x00000004
#define PDG_FES_SETUP_1_REMAINING_TBTT_LSB                           2
#define PDG_FES_SETUP_1_REMAINING_TBTT_MASK                          0x0003fffc

/* Description		PDG_FES_SETUP_1_MU_NDP
			
			If set indicates that this packet is an NDP used for MU
			channel estimation.  This bit will be used by the TPC to
			signal that the analog gain settings can be updated. The
			analog gain settings will not change for subsequent MU data
			packets.
*/
#define PDG_FES_SETUP_1_MU_NDP_OFFSET                                0x00000004
#define PDG_FES_SETUP_1_MU_NDP_LSB                                   18
#define PDG_FES_SETUP_1_MU_NDP_MASK                                  0x00040000

/* Description		PDG_FES_SETUP_1_IBFCAL_ENABLE
			
			Defines the current packet as test packet for implicit
			BF calibration purposes  <legal 0-1>
*/
#define PDG_FES_SETUP_1_IBFCAL_ENABLE_OFFSET                         0x00000004
#define PDG_FES_SETUP_1_IBFCAL_ENABLE_LSB                            19
#define PDG_FES_SETUP_1_IBFCAL_ENABLE_MASK                           0x00080000

/* Description		PDG_FES_SETUP_1_BF_TYPE
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>
*/
#define PDG_FES_SETUP_1_BF_TYPE_OFFSET                               0x00000004
#define PDG_FES_SETUP_1_BF_TYPE_LSB                                  20
#define PDG_FES_SETUP_1_BF_TYPE_MASK                                 0x00300000

/* Description		PDG_FES_SETUP_1_RESERVED_1C
			
			<legal 0>
*/
#define PDG_FES_SETUP_1_RESERVED_1C_OFFSET                           0x00000004
#define PDG_FES_SETUP_1_RESERVED_1C_LSB                              22
#define PDG_FES_SETUP_1_RESERVED_1C_MASK                             0x0fc00000

/* Description		PDG_FES_SETUP_1_CHANNEL_CAPTURE
			
			When set, indicates that the BB should be armed to
			capture the channel on the next received packet. This
			channel estimate is passed to the MAC if the packet is
			successfully received. 
			
			Copied by PDG into the channel_capture field in the
			PPDU_TX_PHY_DESC TLV
			
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_CHANNEL_CAPTURE_OFFSET                       0x00000004
#define PDG_FES_SETUP_1_CHANNEL_CAPTURE_LSB                          28
#define PDG_FES_SETUP_1_CHANNEL_CAPTURE_MASK                         0x10000000

/* Description		PDG_FES_SETUP_1_TXOP_TBTT
			
			(Not supported in Beeliner)
			
			
			
			0: TXOP
			
			1: remaining TBTT
			
			By design, HWSCH populates minimum of { TXOP, remaining
			TBTT} in max_TXOP_time of PDG_FES_SETUP and this txop_tbtt
			field tells which one is currently populated in
			max_TXOP_time. If TXOP is populated and if
			ignore_txop_1st_pkt is set in TX_FES_SETUP TLV, then PDG is
			allowed to transmit single MPDU despite exceeding
			max_TXOP_time. However, if remaining TBTT is populated, PDG
			is not allowed to transmit any single MPDU if exceeding
			max_TXOP_time, regardless of ignore_txop_1st_pkt. 
			
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_TXOP_TBTT_OFFSET                             0x00000004
#define PDG_FES_SETUP_1_TXOP_TBTT_LSB                                29
#define PDG_FES_SETUP_1_TXOP_TBTT_MASK                               0x20000000

/* Description		PDG_FES_SETUP_1_CLPC_EN
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_CLPC_EN_OFFSET                               0x00000004
#define PDG_FES_SETUP_1_CLPC_EN_LSB                                  30
#define PDG_FES_SETUP_1_CLPC_EN_MASK                                 0x40000000

/* Description		PDG_FES_SETUP_1_MEASURE_POWER
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0     measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1     measure_en> TPC will latch power measurement
			result for current packet
*/
#define PDG_FES_SETUP_1_MEASURE_POWER_OFFSET                         0x00000004
#define PDG_FES_SETUP_1_MEASURE_POWER_LSB                            31
#define PDG_FES_SETUP_1_MEASURE_POWER_MASK                           0x80000000

/* Description		PDG_FES_SETUP_2_MAX_FES_TIME
			
			The maximum medium time (in us) that the total Frame
			exchange sequence is allowed to take.  FES time will include
			the PPDU time plus the optional SIFS + Ack/BA time and if
			medium protection is included the RTS + SIFS + CTS + SIFS
			time or CTS + SIFS time.
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			<legal all>
*/
#define PDG_FES_SETUP_2_MAX_FES_TIME_OFFSET                          0x00000008
#define PDG_FES_SETUP_2_MAX_FES_TIME_LSB                             0
#define PDG_FES_SETUP_2_MAX_FES_TIME_MASK                            0x0000ffff

/* Description		PDG_FES_SETUP_2_MAX_PPDU_TIME
			
			The maximum medium time (in us) that the PPDU Frame is
			allowed to take. This value is to exceed 5484 usec which is
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			 <legal all>
*/
#define PDG_FES_SETUP_2_MAX_PPDU_TIME_OFFSET                         0x00000008
#define PDG_FES_SETUP_2_MAX_PPDU_TIME_LSB                            16
#define PDG_FES_SETUP_2_MAX_PPDU_TIME_MASK                           0xffff0000

/* Description		PDG_FES_SETUP_3_MAX_TXOP_TIME
			
			The maximum TXOP time (in us) for the upcoming Frame
			Exchange Sequence (FES). 
			
			
			
			The upcoming frame exchange sequence that PDG will
			calculate is not allowed to go beyond this time (and other
			transmit boundaries like max_fes_time).
			
			
			
			The max_TXOP_time field is sometimes also used to
			calculate the value that needs to be inserted in the
			duration fields of the frames transmitted. (See field:
			Duration_field_ctrl).
			
			
			
			max_txop_time is used for a SIFS burst of transmit
			packets.  It may include time reservation for multiple FES.
			
			
			
			Allowed transmit time needs to have room for 4us extra,
			in case an extra symbol is needed for LDPC.
			
			
			
			  <legal all>
*/
#define PDG_FES_SETUP_3_MAX_TXOP_TIME_OFFSET                         0x0000000c
#define PDG_FES_SETUP_3_MAX_TXOP_TIME_LSB                            0
#define PDG_FES_SETUP_3_MAX_TXOP_TIME_MASK                           0x0000ffff

/* Description		PDG_FES_SETUP_3_EXTEND_DURATION_VALUE
			
			Field only valid when Duration_extension is set and
			Duration_field_ctrl is set to protect FES or protect TXOP.
			
			
			
			Based on TLV field  Duration_field_ctrl, the PDG will
			calculate the normal duration field value to be inserted in
			the transmitted frames. 
			
			When Duration extension is set, and Duration_field_ctrl
			is set to protect FES or protect TXOP, this calculated
			duration value is increased with the Extend_duration_value.
			
			
			
			Max duration value defined in standard spec is 32,767
			us. So, note that after calculation, final duration value
			can't exceed this. 
			
			<legal all>
*/
#define PDG_FES_SETUP_3_EXTEND_DURATION_VALUE_OFFSET                 0x0000000c
#define PDG_FES_SETUP_3_EXTEND_DURATION_VALUE_LSB                    16
#define PDG_FES_SETUP_3_EXTEND_DURATION_VALUE_MASK                   0xffff0000

/* Description		PDG_FES_SETUP_4_DURATION_FIELD_CTRL
			
			Duration field value generation control
			
			<enum 0 set_dur_zero> Set duration field to 0
			
			<enum 1 protect_entire_fes> Duration field will only
			coverer all the frames in the current Frame Excange Sequence
			that PDG is calculating: Typically the ACK/BA after the data
			frame.
			
			<enum 2 protect_entire_txop> The duration field protects
			the medium up to the end of TXOP, given in field:
			max_TXOP_time
			
			<legal 0-2>
*/
#define PDG_FES_SETUP_4_DURATION_FIELD_CTRL_OFFSET                   0x00000010
#define PDG_FES_SETUP_4_DURATION_FIELD_CTRL_LSB                      0
#define PDG_FES_SETUP_4_DURATION_FIELD_CTRL_MASK                     0x00000003

/* Description		PDG_FES_SETUP_4_DURATION_EXTENSION
			
			Duration extension control
			
			0: No action
			
			1: Add the extra_duration_value to the calculated
			duration field.
*/
#define PDG_FES_SETUP_4_DURATION_EXTENSION_OFFSET                    0x00000010
#define PDG_FES_SETUP_4_DURATION_EXTENSION_LSB                       2
#define PDG_FES_SETUP_4_DURATION_EXTENSION_MASK                      0x00000004

/* Description		PDG_FES_SETUP_4_GROUP_ID
			
			Field only valid when Transmit_fes_type indicates a
			regular (non self generated) transmission
			
			
			
			When PDG detects that the transmission is at a VHT rate,
*/
#define PDG_FES_SETUP_4_GROUP_ID_OFFSET                              0x00000010
#define PDG_FES_SETUP_4_GROUP_ID_LSB                                 3
#define PDG_FES_SETUP_4_GROUP_ID_MASK                                0x000001f8

/* Description		PDG_FES_SETUP_4_HW_MODE_MPROT_SCRAMBLER_SEED_MODE
			
			Field only valid in pdg_transmit_mode. 
			
			
			
			<enum 0 legacy_mode> 
			
			Automatic based on medium_prot_type. 
			
			<enum 1 gen_4bit_static> Generate lower 4 bits
			
			dyn_bandwidth = 0 (static)
			
			<enum 2 gen_4bit_dynamic>
			
			Generate lower 4 bits
			
			dyn_bandwidth = 1 (dynamic)
			
			<enum 3 gen_5bit>
			
			Generate lower 5 bits
			
			<enum 4 gen_7bit>
			
			Generate all 7 bits
			
			<legal 0-4>
*/
#define PDG_FES_SETUP_4_HW_MODE_MPROT_SCRAMBLER_SEED_MODE_OFFSET     0x00000010
#define PDG_FES_SETUP_4_HW_MODE_MPROT_SCRAMBLER_SEED_MODE_LSB        9
#define PDG_FES_SETUP_4_HW_MODE_MPROT_SCRAMBLER_SEED_MODE_MASK       0x00000e00

/* Description		PDG_FES_SETUP_4_HW_MODE_PPDU_SCRAMBLER_SEED_MODE
			
			Field only valid in pdg_transmit_mode. 
			
			
			
			<enum 0 legacy_mode> 
			
			Generate all 7 bits
			
			<enum 1 gen_4bit_static> Generate lower 4 bits
			
			dyn_bandwidth = 0 (static)
			
			<enum 2 gen_4bit_dynamic>
			
			Generate lower 4 bits
			
			dyn_bandwidth = 1 (dynamic)
			
			<enum 3 gen_5bit>
			
			Generate lower 5 bits
			
			<enum 4 gen_7bit>
			
			Generate all 7 bits
			
			<legal 0-4>
*/
#define PDG_FES_SETUP_4_HW_MODE_PPDU_SCRAMBLER_SEED_MODE_OFFSET      0x00000010
#define PDG_FES_SETUP_4_HW_MODE_PPDU_SCRAMBLER_SEED_MODE_LSB         12
#define PDG_FES_SETUP_4_HW_MODE_PPDU_SCRAMBLER_SEED_MODE_MASK        0x00007000

/* Description		PDG_FES_SETUP_4_RESERVED_4
			
			<legal 0>
*/
#define PDG_FES_SETUP_4_RESERVED_4_OFFSET                            0x00000010
#define PDG_FES_SETUP_4_RESERVED_4_LSB                               15
#define PDG_FES_SETUP_4_RESERVED_4_MASK                              0x00008000

/* Description		PDG_FES_SETUP_4_INSERT_TIMESTAMP_OFFSET
			
			Byte offset  to the first byte of the timestamp to be
			inserted.  This is applicable to both beacon and probe
			response TSF and the AWDL timestamp<legal all>
*/
#define PDG_FES_SETUP_4_INSERT_TIMESTAMP_OFFSET_OFFSET               0x00000010
#define PDG_FES_SETUP_4_INSERT_TIMESTAMP_OFFSET_LSB                  16
#define PDG_FES_SETUP_4_INSERT_TIMESTAMP_OFFSET_MASK                 0xffff0000
#define PDG_FES_SETUP_5_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_OFFSET 0x00000014
#define PDG_FES_SETUP_5_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_LSB   16
#define PDG_FES_SETUP_5_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_MASK  0xffffffff
#define PDG_FES_SETUP_6_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_OFFSET 0x00000018
#define PDG_FES_SETUP_6_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_LSB   16
#define PDG_FES_SETUP_6_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_MASK  0xffffffff
#define PDG_FES_SETUP_7_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_OFFSET 0x0000001c
#define PDG_FES_SETUP_7_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_LSB   16
#define PDG_FES_SETUP_7_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_MASK  0xffffffff
#define PDG_FES_SETUP_8_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_OFFSET 0x00000020
#define PDG_FES_SETUP_8_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_LSB   16
#define PDG_FES_SETUP_8_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_MASK  0xffffffff
#define PDG_FES_SETUP_9_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_OFFSET 0x00000024
#define PDG_FES_SETUP_9_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_LSB   16
#define PDG_FES_SETUP_9_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_MASK  0xffffffff
#define PDG_FES_SETUP_10_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_OFFSET 0x00000028
#define PDG_FES_SETUP_10_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_LSB  16
#define PDG_FES_SETUP_10_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_MASK 0xffffffff
#define PDG_FES_SETUP_11_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_OFFSET 0x0000002c
#define PDG_FES_SETUP_11_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_LSB 16
#define PDG_FES_SETUP_11_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_MASK 0xffffffff
#define PDG_FES_SETUP_12_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_OFFSET 0x00000030
#define PDG_FES_SETUP_12_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_LSB 16
#define PDG_FES_SETUP_12_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_MASK 0xffffffff
#define PDG_FES_SETUP_13_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_OFFSET 0x00000034
#define PDG_FES_SETUP_13_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_LSB 16
#define PDG_FES_SETUP_13_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_MASK 0xffffffff
#define PDG_FES_SETUP_14_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_OFFSET 0x00000038
#define PDG_FES_SETUP_14_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_LSB 16
#define PDG_FES_SETUP_14_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_MASK 0xffffffff
#define PDG_FES_SETUP_15_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_OFFSET 0x0000003c
#define PDG_FES_SETUP_15_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_LSB 16
#define PDG_FES_SETUP_15_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_MASK 0xffffffff
#define PDG_FES_SETUP_16_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_OFFSET 0x00000040
#define PDG_FES_SETUP_16_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_LSB 16
#define PDG_FES_SETUP_16_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_MASK 0xffffffff


#endif // _PDG_FES_SETUP_H_
