// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PCU_PPDU_SETUP_H_
#define _PCU_PPDU_SETUP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	transmit_fes_type[3:0], medium_prot_type[6:4], su_response_type[9:7], mprot_required_bw20[10], mprot_required_bw40[11], mprot_required_bw80[12], ppdu_allow_bw20[13], ppdu_allow_bw40[14], ppdu_allow_bw80[15], insert_timestamp_offset[31:16]
//	1	location_req[0], location_type[1], reserved_1a[19:2], update_timestamp_32[20], update_timestamp_64[21], reserved_1c[31:22]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PCU_PPDU_SETUP 2

struct pcu_ppdu_setup {
    volatile uint32_t transmit_fes_type               :  4, //[3:0]
                      medium_prot_type                :  3, //[6:4]
                      su_response_type                :  3, //[9:7]
                      mprot_required_bw20             :  1, //[10]
                      mprot_required_bw40             :  1, //[11]
                      mprot_required_bw80             :  1, //[12]
                      ppdu_allow_bw20                 :  1, //[13]
                      ppdu_allow_bw40                 :  1, //[14]
                      ppdu_allow_bw80                 :  1, //[15]
                      insert_timestamp_offset         : 16; //[31:16]
    volatile uint32_t location_req                    :  1, //[0]
                      location_type                   :  1, //[1]
                      reserved_1a                     : 18, //[19:2]
                      update_timestamp_32             :  1, //[20]
                      update_timestamp_64             :  1, //[21]
                      reserved_1c                     : 10; //[31:22]
};

/*

transmit_fes_type
			
			<enum 0 regular_transmission>  A Scheduled SU or MU
			transmission
			
			-
			
			
			
			15-1 Reserved
			
			<legal 0>

medium_prot_type
			
			Self Gen Medium Protection type used
			
			<enum 0 No_protection>
			
			<enum 1 RTS_legacy>
			
			<enum 2 RTS_11ac_static_bw>
			
			<enum 3 RTS_11ac_dynamic_bw>
			
			<enum 4 CTS2Self>
			
			<legal 0-4>

su_response_type
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			<enum 0 No_response_expected>
			
			<enum 1 ACK_expected>
			
			<enum 2 BA_expected>
			
			<enum 3 ActionNoAck_expected> SW sets this after sending
			NDP or BR-Poll.
			
			<enum 4 ACK_BA_expected> SW sets this after sending VHT
			single MPDU. Some vendor chip might send BA rather than ACK
			in response to VHT single MPDU but still we want to accept
			BA as well. That's why this type is added.   
			
			<enum 5 CTS_expected> SW sets this after queuing RTS
			frame as standalone packet and sending it.  
			
			<enum 6 ACK_Data_expected> SW sets this after sending
			PS-Poll. 
			
			<enum 7 Any_response_accepted> SW sets this if SW wants
			to accept any directed CRC-pass frame while waiting for
			response. This is mainly for debug purpose.
			
			<legal all>
			
			
			
			Note: For MU transmission this field is only valid for
			the datastructures for this user 0.  For user 1 and user 2
			this field should be set to No response expected.  

mprot_required_bw20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission <legal all>

mprot_required_bw40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission <legal all>

mprot_required_bw80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission <legal all>

ppdu_allow_bw20
			
			When set, allow PPDU transmission with 20 MHz bandwidth
			<legal all>

ppdu_allow_bw40
			
			When set, allow PPDU transmission with 40 MHz bandwidth
			<legal all>

ppdu_allow_bw80
			
			When set, allow PPDU transmission with 80 MHz bandwidth
			<legal all>

insert_timestamp_offset
			
			Byte offset  to the first byte of the timestamp to be
			inserted.  This is applicable to both beacon and probe
			response TSF and the AWDL timestamp<legal all>

location_req
			
			(Not supported in Beeliner)
			
			
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.

location_type
			
			(Not supported in Beeliner)
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>

reserved_1a
			
			Reserved: Generator should set to 0, Consumer shall
			ignore.  <legal 0>

update_timestamp_32
			
			Update the 32 bit timestamp at the offset specified by
			the insert_timestamp_offset.  This will be used for AWDL
			action frames.  The value of the TSF will be added to the
			timestamp field in the packet buffer in memory.  The
			tx_delay should also be included in the timestamp
			field<legal all>

update_timestamp_64
			
			Update the 64 bit TSF at the offset specified by the
			insert_timestamp_offset.  This will be used for beacons and
			probe response frames.  The value of the TSF will be added
			to the TSF field in the packet buffer in memory.  The

reserved_1c
			
			<legal 0>
*/


/* Description		PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE
			
			<enum 0 regular_transmission>  A Scheduled SU or MU
			transmission
			
			-
			
			
			
			15-1 Reserved
			
			<legal 0>
*/
#define PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE_OFFSET                    0x00000000
#define PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE_LSB                       0
#define PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE_MASK                      0x0000000f

/* Description		PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE
			
			Self Gen Medium Protection type used
			
			<enum 0 No_protection>
			
			<enum 1 RTS_legacy>
			
			<enum 2 RTS_11ac_static_bw>
			
			<enum 3 RTS_11ac_dynamic_bw>
			
			<enum 4 CTS2Self>
			
			<legal 0-4>
*/
#define PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE_OFFSET                     0x00000000
#define PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE_LSB                        4
#define PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE_MASK                       0x00000070

/* Description		PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			<enum 0 No_response_expected>
			
			<enum 1 ACK_expected>
			
			<enum 2 BA_expected>
			
			<enum 3 ActionNoAck_expected> SW sets this after sending
			NDP or BR-Poll.
			
			<enum 4 ACK_BA_expected> SW sets this after sending VHT
			single MPDU. Some vendor chip might send BA rather than ACK
			in response to VHT single MPDU but still we want to accept
			BA as well. That's why this type is added.   
			
			<enum 5 CTS_expected> SW sets this after queuing RTS
			frame as standalone packet and sending it.  
			
			<enum 6 ACK_Data_expected> SW sets this after sending
			PS-Poll. 
			
			<enum 7 Any_response_accepted> SW sets this if SW wants
			to accept any directed CRC-pass frame while waiting for
			response. This is mainly for debug purpose.
			
			<legal all>
			
			
			
			Note: For MU transmission this field is only valid for
			the datastructures for this user 0.  For user 1 and user 2
			this field should be set to No response expected.  
*/
#define PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE_OFFSET                     0x00000000
#define PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE_LSB                        7
#define PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE_MASK                       0x00000380

/* Description		PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission <legal all>
*/
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20_OFFSET                  0x00000000
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20_LSB                     10
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20_MASK                    0x00000400

/* Description		PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission <legal all>
*/
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40_OFFSET                  0x00000000
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40_LSB                     11
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40_MASK                    0x00000800

/* Description		PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission <legal all>
*/
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80_OFFSET                  0x00000000
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80_LSB                     12
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80_MASK                    0x00001000

/* Description		PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20
			
			When set, allow PPDU transmission with 20 MHz bandwidth
			<legal all>
*/
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20_OFFSET                      0x00000000
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20_LSB                         13
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20_MASK                        0x00002000

/* Description		PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40
			
			When set, allow PPDU transmission with 40 MHz bandwidth
			<legal all>
*/
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40_OFFSET                      0x00000000
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40_LSB                         14
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40_MASK                        0x00004000

/* Description		PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80
			
			When set, allow PPDU transmission with 80 MHz bandwidth
			<legal all>
*/
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80_OFFSET                      0x00000000
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80_LSB                         15
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80_MASK                        0x00008000

/* Description		PCU_PPDU_SETUP_0_INSERT_TIMESTAMP_OFFSET
			
			Byte offset  to the first byte of the timestamp to be
			inserted.  This is applicable to both beacon and probe
			response TSF and the AWDL timestamp<legal all>
*/
#define PCU_PPDU_SETUP_0_INSERT_TIMESTAMP_OFFSET_OFFSET              0x00000000
#define PCU_PPDU_SETUP_0_INSERT_TIMESTAMP_OFFSET_LSB                 16
#define PCU_PPDU_SETUP_0_INSERT_TIMESTAMP_OFFSET_MASK                0xffff0000

/* Description		PCU_PPDU_SETUP_1_LOCATION_REQ
			
			(Not supported in Beeliner)
			
			
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.
*/
#define PCU_PPDU_SETUP_1_LOCATION_REQ_OFFSET                         0x00000004
#define PCU_PPDU_SETUP_1_LOCATION_REQ_LSB                            0
#define PCU_PPDU_SETUP_1_LOCATION_REQ_MASK                           0x00000001

/* Description		PCU_PPDU_SETUP_1_LOCATION_TYPE
			
			(Not supported in Beeliner)
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>
*/
#define PCU_PPDU_SETUP_1_LOCATION_TYPE_OFFSET                        0x00000004
#define PCU_PPDU_SETUP_1_LOCATION_TYPE_LSB                           1
#define PCU_PPDU_SETUP_1_LOCATION_TYPE_MASK                          0x00000002

/* Description		PCU_PPDU_SETUP_1_RESERVED_1A
			
			Reserved: Generator should set to 0, Consumer shall
			ignore.  <legal 0>
*/
#define PCU_PPDU_SETUP_1_RESERVED_1A_OFFSET                          0x00000004
#define PCU_PPDU_SETUP_1_RESERVED_1A_LSB                             2
#define PCU_PPDU_SETUP_1_RESERVED_1A_MASK                            0x000ffffc

/* Description		PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_32
			
			Update the 32 bit timestamp at the offset specified by
			the insert_timestamp_offset.  This will be used for AWDL
			action frames.  The value of the TSF will be added to the
			timestamp field in the packet buffer in memory.  The
			tx_delay should also be included in the timestamp
			field<legal all>
*/
#define PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_32_OFFSET                  0x00000004
#define PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_32_LSB                     20
#define PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_32_MASK                    0x00100000

/* Description		PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_64
			
			Update the 64 bit TSF at the offset specified by the
			insert_timestamp_offset.  This will be used for beacons and
			probe response frames.  The value of the TSF will be added
			to the TSF field in the packet buffer in memory.  The
*/
#define PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_64_OFFSET                  0x00000004
#define PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_64_LSB                     21
#define PCU_PPDU_SETUP_1_UPDATE_TIMESTAMP_64_MASK                    0x00200000

/* Description		PCU_PPDU_SETUP_1_RESERVED_1C
			
			<legal 0>
*/
#define PCU_PPDU_SETUP_1_RESERVED_1C_OFFSET                          0x00000004
#define PCU_PPDU_SETUP_1_RESERVED_1C_LSB                             22
#define PCU_PPDU_SETUP_1_RESERVED_1C_MASK                            0xffc00000


#endif // _PCU_PPDU_SETUP_H_
