//
// -----------------------------------------------------------------------------
// Copyright (c) 2011-2014 Qualcomm Atheros, Inc.  All rights reserved.
// -----------------------------------------------------------------------------
// FILE         : soc_pcie_reg.h
// DESCRIPTION  : Software Header File for WiFi 2.0
// THIS FILE IS AUTOMATICALLY GENERATED BY DENALI BLUEPRINT, DO NOT EDIT
// -----------------------------------------------------------------------------
//

#ifndef _SOC_PCIE_REG_H_
#define _SOC_PCIE_REG_H_


#ifndef __SOC_PCIE_REG_BASE_ADDRESS
#define __SOC_PCIE_REG_BASE_ADDRESS (0x81000)
#endif


// 0x0 (PCIE_DEBUG_LOW)
#define PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_LSB                                 0
#define PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_MSB                                 31
#define PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_MASK                                0xffffffff
#define PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_GET(x)                              (((x) & PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_MASK) >> PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_LSB)
#define PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_SET(x)                              (((0 | (x)) << PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_LSB) & PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_MASK)
#define PCIE_DEBUG_LOW_CXPL_DEBUG_INFO_LOW_RESET                               0x0
#define PCIE_DEBUG_LOW_ADDRESS                                                 (0x0 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_DEBUG_LOW_RSTMASK                                                 0xffffffff
#define PCIE_DEBUG_LOW_RESET                                                   0x0

// 0x4 (PCIE_DEBUG_HIGH)
#define PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_LSB                               0
#define PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_MSB                               31
#define PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_MASK                              0xffffffff
#define PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_GET(x)                            (((x) & PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_MASK) >> PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_LSB)
#define PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_SET(x)                            (((0 | (x)) << PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_LSB) & PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_MASK)
#define PCIE_DEBUG_HIGH_CXPL_DEBUG_INFO_HIGH_RESET                             0x0
#define PCIE_DEBUG_HIGH_ADDRESS                                                (0x4 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_DEBUG_HIGH_RSTMASK                                                0xffffffff
#define PCIE_DEBUG_HIGH_RESET                                                  0x0

// 0x8 (PCIE_PM)
#define PCIE_PM_PCIE_RATE_LSB                                                  28
#define PCIE_PM_PCIE_RATE_MSB                                                  28
#define PCIE_PM_PCIE_RATE_MASK                                                 0x10000000
#define PCIE_PM_PCIE_RATE_GET(x)                                               (((x) & PCIE_PM_PCIE_RATE_MASK) >> PCIE_PM_PCIE_RATE_LSB)
#define PCIE_PM_PCIE_RATE_SET(x)                                               (((0 | (x)) << PCIE_PM_PCIE_RATE_LSB) & PCIE_PM_PCIE_RATE_MASK)
#define PCIE_PM_PCIE_RATE_RESET                                                0x0
#define PCIE_PM_PM_LINKST_IN_L0S_LSB                                           27
#define PCIE_PM_PM_LINKST_IN_L0S_MSB                                           27
#define PCIE_PM_PM_LINKST_IN_L0S_MASK                                          0x8000000
#define PCIE_PM_PM_LINKST_IN_L0S_GET(x)                                        (((x) & PCIE_PM_PM_LINKST_IN_L0S_MASK) >> PCIE_PM_PM_LINKST_IN_L0S_LSB)
#define PCIE_PM_PM_LINKST_IN_L0S_SET(x)                                        (((0 | (x)) << PCIE_PM_PM_LINKST_IN_L0S_LSB) & PCIE_PM_PM_LINKST_IN_L0S_MASK)
#define PCIE_PM_PM_LINKST_IN_L0S_RESET                                         0x0
#define PCIE_PM_XMLH_RL0S_LSB                                                  26
#define PCIE_PM_XMLH_RL0S_MSB                                                  26
#define PCIE_PM_XMLH_RL0S_MASK                                                 0x4000000
#define PCIE_PM_XMLH_RL0S_GET(x)                                               (((x) & PCIE_PM_XMLH_RL0S_MASK) >> PCIE_PM_XMLH_RL0S_LSB)
#define PCIE_PM_XMLH_RL0S_SET(x)                                               (((0 | (x)) << PCIE_PM_XMLH_RL0S_LSB) & PCIE_PM_XMLH_RL0S_MASK)
#define PCIE_PM_XMLH_RL0S_RESET                                                0x0
#define PCIE_PM_WAKE_LSB                                                       25
#define PCIE_PM_WAKE_MSB                                                       25
#define PCIE_PM_WAKE_MASK                                                      0x2000000
#define PCIE_PM_WAKE_GET(x)                                                    (((x) & PCIE_PM_WAKE_MASK) >> PCIE_PM_WAKE_LSB)
#define PCIE_PM_WAKE_SET(x)                                                    (((0 | (x)) << PCIE_PM_WAKE_LSB) & PCIE_PM_WAKE_MASK)
#define PCIE_PM_WAKE_RESET                                                     0x0
#define PCIE_PM_XMLH_L1_EXIT_LSB                                               24
#define PCIE_PM_XMLH_L1_EXIT_MSB                                               24
#define PCIE_PM_XMLH_L1_EXIT_MASK                                              0x1000000
#define PCIE_PM_XMLH_L1_EXIT_GET(x)                                            (((x) & PCIE_PM_XMLH_L1_EXIT_MASK) >> PCIE_PM_XMLH_L1_EXIT_LSB)
#define PCIE_PM_XMLH_L1_EXIT_SET(x)                                            (((0 | (x)) << PCIE_PM_XMLH_L1_EXIT_LSB) & PCIE_PM_XMLH_L1_EXIT_MASK)
#define PCIE_PM_XMLH_L1_EXIT_RESET                                             0x0
#define PCIE_PM_LINK_REQ_RST_N_LSB                                             23
#define PCIE_PM_LINK_REQ_RST_N_MSB                                             23
#define PCIE_PM_LINK_REQ_RST_N_MASK                                            0x800000
#define PCIE_PM_LINK_REQ_RST_N_GET(x)                                          (((x) & PCIE_PM_LINK_REQ_RST_N_MASK) >> PCIE_PM_LINK_REQ_RST_N_LSB)
#define PCIE_PM_LINK_REQ_RST_N_SET(x)                                          (((0 | (x)) << PCIE_PM_LINK_REQ_RST_N_LSB) & PCIE_PM_LINK_REQ_RST_N_MASK)
#define PCIE_PM_LINK_REQ_RST_N_RESET                                           0x1
#define PCIE_PM_RDLH_LINK_UP_LSB                                               22
#define PCIE_PM_RDLH_LINK_UP_MSB                                               22
#define PCIE_PM_RDLH_LINK_UP_MASK                                              0x400000
#define PCIE_PM_RDLH_LINK_UP_GET(x)                                            (((x) & PCIE_PM_RDLH_LINK_UP_MASK) >> PCIE_PM_RDLH_LINK_UP_LSB)
#define PCIE_PM_RDLH_LINK_UP_SET(x)                                            (((0 | (x)) << PCIE_PM_RDLH_LINK_UP_LSB) & PCIE_PM_RDLH_LINK_UP_MASK)
#define PCIE_PM_RDLH_LINK_UP_RESET                                             0x0
#define PCIE_PM_MASTER_STATE_LSB                                               17
#define PCIE_PM_MASTER_STATE_MSB                                               21
#define PCIE_PM_MASTER_STATE_MASK                                              0x3e0000
#define PCIE_PM_MASTER_STATE_GET(x)                                            (((x) & PCIE_PM_MASTER_STATE_MASK) >> PCIE_PM_MASTER_STATE_LSB)
#define PCIE_PM_MASTER_STATE_SET(x)                                            (((0 | (x)) << PCIE_PM_MASTER_STATE_LSB) & PCIE_PM_MASTER_STATE_MASK)
#define PCIE_PM_MASTER_STATE_RESET                                             0x0
#define PCIE_PM_PME_EN_LSB                                                     16
#define PCIE_PM_PME_EN_MSB                                                     16
#define PCIE_PM_PME_EN_MASK                                                    0x10000
#define PCIE_PM_PME_EN_GET(x)                                                  (((x) & PCIE_PM_PME_EN_MASK) >> PCIE_PM_PME_EN_LSB)
#define PCIE_PM_PME_EN_SET(x)                                                  (((0 | (x)) << PCIE_PM_PME_EN_LSB) & PCIE_PM_PME_EN_MASK)
#define PCIE_PM_PME_EN_RESET                                                   0x0
#define PCIE_PM_AUX_PM_EN_LSB                                                  15
#define PCIE_PM_AUX_PM_EN_MSB                                                  15
#define PCIE_PM_AUX_PM_EN_MASK                                                 0x8000
#define PCIE_PM_AUX_PM_EN_GET(x)                                               (((x) & PCIE_PM_AUX_PM_EN_MASK) >> PCIE_PM_AUX_PM_EN_LSB)
#define PCIE_PM_AUX_PM_EN_SET(x)                                               (((0 | (x)) << PCIE_PM_AUX_PM_EN_LSB) & PCIE_PM_AUX_PM_EN_MASK)
#define PCIE_PM_AUX_PM_EN_RESET                                                0x0
#define PCIE_PM_XTLH_BLOCK_TLP_LSB                                             14
#define PCIE_PM_XTLH_BLOCK_TLP_MSB                                             14
#define PCIE_PM_XTLH_BLOCK_TLP_MASK                                            0x4000
#define PCIE_PM_XTLH_BLOCK_TLP_GET(x)                                          (((x) & PCIE_PM_XTLH_BLOCK_TLP_MASK) >> PCIE_PM_XTLH_BLOCK_TLP_LSB)
#define PCIE_PM_XTLH_BLOCK_TLP_SET(x)                                          (((0 | (x)) << PCIE_PM_XTLH_BLOCK_TLP_LSB) & PCIE_PM_XTLH_BLOCK_TLP_MASK)
#define PCIE_PM_XTLH_BLOCK_TLP_RESET                                           0x0
#define PCIE_PM_DSTATE_LSB                                                     11
#define PCIE_PM_DSTATE_MSB                                                     13
#define PCIE_PM_DSTATE_MASK                                                    0x3800
#define PCIE_PM_DSTATE_GET(x)                                                  (((x) & PCIE_PM_DSTATE_MASK) >> PCIE_PM_DSTATE_LSB)
#define PCIE_PM_DSTATE_SET(x)                                                  (((0 | (x)) << PCIE_PM_DSTATE_LSB) & PCIE_PM_DSTATE_MASK)
#define PCIE_PM_DSTATE_RESET                                                   0x0
#define PCIE_PM_LTSSM_STATE_LSB                                                5
#define PCIE_PM_LTSSM_STATE_MSB                                                10
#define PCIE_PM_LTSSM_STATE_MASK                                               0x7e0
#define PCIE_PM_LTSSM_STATE_GET(x)                                             (((x) & PCIE_PM_LTSSM_STATE_MASK) >> PCIE_PM_LTSSM_STATE_LSB)
#define PCIE_PM_LTSSM_STATE_SET(x)                                             (((0 | (x)) << PCIE_PM_LTSSM_STATE_LSB) & PCIE_PM_LTSSM_STATE_MASK)
#define PCIE_PM_LTSSM_STATE_RESET                                              0x0
#define PCIE_PM_STATUS_LSB                                                     4
#define PCIE_PM_STATUS_MSB                                                     4
#define PCIE_PM_STATUS_MASK                                                    0x10
#define PCIE_PM_STATUS_GET(x)                                                  (((x) & PCIE_PM_STATUS_MASK) >> PCIE_PM_STATUS_LSB)
#define PCIE_PM_STATUS_SET(x)                                                  (((0 | (x)) << PCIE_PM_STATUS_LSB) & PCIE_PM_STATUS_MASK)
#define PCIE_PM_STATUS_RESET                                                   0x0
#define PCIE_PM_XMLH_LINK_UP_LSB                                               3
#define PCIE_PM_XMLH_LINK_UP_MSB                                               3
#define PCIE_PM_XMLH_LINK_UP_MASK                                              0x8
#define PCIE_PM_XMLH_LINK_UP_GET(x)                                            (((x) & PCIE_PM_XMLH_LINK_UP_MASK) >> PCIE_PM_XMLH_LINK_UP_LSB)
#define PCIE_PM_XMLH_LINK_UP_SET(x)                                            (((0 | (x)) << PCIE_PM_XMLH_LINK_UP_LSB) & PCIE_PM_XMLH_LINK_UP_MASK)
#define PCIE_PM_XMLH_LINK_UP_RESET                                             0x0
#define PCIE_PM_CURNT_STATE_LSB                                                0
#define PCIE_PM_CURNT_STATE_MSB                                                2
#define PCIE_PM_CURNT_STATE_MASK                                               0x7
#define PCIE_PM_CURNT_STATE_GET(x)                                             (((x) & PCIE_PM_CURNT_STATE_MASK) >> PCIE_PM_CURNT_STATE_LSB)
#define PCIE_PM_CURNT_STATE_SET(x)                                             (((0 | (x)) << PCIE_PM_CURNT_STATE_LSB) & PCIE_PM_CURNT_STATE_MASK)
#define PCIE_PM_CURNT_STATE_RESET                                              0x0
#define PCIE_PM_ADDRESS                                                        (0x8 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_PM_RSTMASK                                                        0x1fffffff
#define PCIE_PM_RESET                                                          0x800000

// 0xc (PCIE_CTRL)
#define PCIE_CTRL_STICKY_RST_FIX_EN_LSB                                        30
#define PCIE_CTRL_STICKY_RST_FIX_EN_MSB                                        30
#define PCIE_CTRL_STICKY_RST_FIX_EN_MASK                                       0x40000000
#define PCIE_CTRL_STICKY_RST_FIX_EN_GET(x)                                     (((x) & PCIE_CTRL_STICKY_RST_FIX_EN_MASK) >> PCIE_CTRL_STICKY_RST_FIX_EN_LSB)
#define PCIE_CTRL_STICKY_RST_FIX_EN_SET(x)                                     (((0 | (x)) << PCIE_CTRL_STICKY_RST_FIX_EN_LSB) & PCIE_CTRL_STICKY_RST_FIX_EN_MASK)
#define PCIE_CTRL_STICKY_RST_FIX_EN_RESET                                      0x0
#define PCIE_CTRL_STICKY_RST_FIX_OVRD_LSB                                      29
#define PCIE_CTRL_STICKY_RST_FIX_OVRD_MSB                                      29
#define PCIE_CTRL_STICKY_RST_FIX_OVRD_MASK                                     0x20000000
#define PCIE_CTRL_STICKY_RST_FIX_OVRD_GET(x)                                   (((x) & PCIE_CTRL_STICKY_RST_FIX_OVRD_MASK) >> PCIE_CTRL_STICKY_RST_FIX_OVRD_LSB)
#define PCIE_CTRL_STICKY_RST_FIX_OVRD_SET(x)                                   (((0 | (x)) << PCIE_CTRL_STICKY_RST_FIX_OVRD_LSB) & PCIE_CTRL_STICKY_RST_FIX_OVRD_MASK)
#define PCIE_CTRL_STICKY_RST_FIX_OVRD_RESET                                    0x0
#define PCIE_CTRL_IGNORE_PCIE_INTX_LSB                                         28
#define PCIE_CTRL_IGNORE_PCIE_INTX_MSB                                         28
#define PCIE_CTRL_IGNORE_PCIE_INTX_MASK                                        0x10000000
#define PCIE_CTRL_IGNORE_PCIE_INTX_GET(x)                                      (((x) & PCIE_CTRL_IGNORE_PCIE_INTX_MASK) >> PCIE_CTRL_IGNORE_PCIE_INTX_LSB)
#define PCIE_CTRL_IGNORE_PCIE_INTX_SET(x)                                      (((0 | (x)) << PCIE_CTRL_IGNORE_PCIE_INTX_LSB) & PCIE_CTRL_IGNORE_PCIE_INTX_MASK)
#define PCIE_CTRL_IGNORE_PCIE_INTX_RESET                                       0x0
#define PCIE_CTRL_PME_GNT_EN_LSB                                               27
#define PCIE_CTRL_PME_GNT_EN_MSB                                               27
#define PCIE_CTRL_PME_GNT_EN_MASK                                              0x8000000
#define PCIE_CTRL_PME_GNT_EN_GET(x)                                            (((x) & PCIE_CTRL_PME_GNT_EN_MASK) >> PCIE_CTRL_PME_GNT_EN_LSB)
#define PCIE_CTRL_PME_GNT_EN_SET(x)                                            (((0 | (x)) << PCIE_CTRL_PME_GNT_EN_LSB) & PCIE_CTRL_PME_GNT_EN_MASK)
#define PCIE_CTRL_PME_GNT_EN_RESET                                             0x1
#define PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_LSB                                  26
#define PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_MSB                                  26
#define PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_MASK                                 0x4000000
#define PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_GET(x)                               (((x) & PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_MASK) >> PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_LSB)
#define PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_SET(x)                               (((0 | (x)) << PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_LSB) & PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_MASK)
#define PCIE_CTRL_IGNORE_RTC_SLEEP_FOR_L1_RESET                                0x1
#define PCIE_CTRL_APP_REQ_RETRY_EN_LSB                                         25
#define PCIE_CTRL_APP_REQ_RETRY_EN_MSB                                         25
#define PCIE_CTRL_APP_REQ_RETRY_EN_MASK                                        0x2000000
#define PCIE_CTRL_APP_REQ_RETRY_EN_GET(x)                                      (((x) & PCIE_CTRL_APP_REQ_RETRY_EN_MASK) >> PCIE_CTRL_APP_REQ_RETRY_EN_LSB)
#define PCIE_CTRL_APP_REQ_RETRY_EN_SET(x)                                      (((0 | (x)) << PCIE_CTRL_APP_REQ_RETRY_EN_LSB) & PCIE_CTRL_APP_REQ_RETRY_EN_MASK)
#define PCIE_CTRL_APP_REQ_RETRY_EN_RESET                                       0x0
#define PCIE_CTRL_ASPM_APP_REQ_L1_DIS_LSB                                      24
#define PCIE_CTRL_ASPM_APP_REQ_L1_DIS_MSB                                      24
#define PCIE_CTRL_ASPM_APP_REQ_L1_DIS_MASK                                     0x1000000
#define PCIE_CTRL_ASPM_APP_REQ_L1_DIS_GET(x)                                   (((x) & PCIE_CTRL_ASPM_APP_REQ_L1_DIS_MASK) >> PCIE_CTRL_ASPM_APP_REQ_L1_DIS_LSB)
#define PCIE_CTRL_ASPM_APP_REQ_L1_DIS_SET(x)                                   (((0 | (x)) << PCIE_CTRL_ASPM_APP_REQ_L1_DIS_LSB) & PCIE_CTRL_ASPM_APP_REQ_L1_DIS_MASK)
#define PCIE_CTRL_ASPM_APP_REQ_L1_DIS_RESET                                    0x0
#define PCIE_CTRL_OBS_MUX1_LSB                                                 22
#define PCIE_CTRL_OBS_MUX1_MSB                                                 23
#define PCIE_CTRL_OBS_MUX1_MASK                                                0xc00000
#define PCIE_CTRL_OBS_MUX1_GET(x)                                              (((x) & PCIE_CTRL_OBS_MUX1_MASK) >> PCIE_CTRL_OBS_MUX1_LSB)
#define PCIE_CTRL_OBS_MUX1_SET(x)                                              (((0 | (x)) << PCIE_CTRL_OBS_MUX1_LSB) & PCIE_CTRL_OBS_MUX1_MASK)
#define PCIE_CTRL_OBS_MUX1_RESET                                               0x0
#define PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_LSB                                 21
#define PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_MSB                                 21
#define PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_MASK                                0x200000
#define PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_GET(x)                              (((x) & PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_MASK) >> PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_LSB)
#define PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_SET(x)                              (((0 | (x)) << PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_LSB) & PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_MASK)
#define PCIE_CTRL_ENABLE_DBI_AFTER_LINK_UP_RESET                               0x0
#define PCIE_CTRL_RST_MASK_LSB                                                 20
#define PCIE_CTRL_RST_MASK_MSB                                                 20
#define PCIE_CTRL_RST_MASK_MASK                                                0x100000
#define PCIE_CTRL_RST_MASK_GET(x)                                              (((x) & PCIE_CTRL_RST_MASK_MASK) >> PCIE_CTRL_RST_MASK_LSB)
#define PCIE_CTRL_RST_MASK_SET(x)                                              (((0 | (x)) << PCIE_CTRL_RST_MASK_LSB) & PCIE_CTRL_RST_MASK_MASK)
#define PCIE_CTRL_RST_MASK_RESET                                               0x0
#define PCIE_CTRL_OBS_MUX_LSB                                                  17
#define PCIE_CTRL_OBS_MUX_MSB                                                  19
#define PCIE_CTRL_OBS_MUX_MASK                                                 0xe0000
#define PCIE_CTRL_OBS_MUX_GET(x)                                               (((x) & PCIE_CTRL_OBS_MUX_MASK) >> PCIE_CTRL_OBS_MUX_LSB)
#define PCIE_CTRL_OBS_MUX_SET(x)                                               (((0 | (x)) << PCIE_CTRL_OBS_MUX_LSB) & PCIE_CTRL_OBS_MUX_MASK)
#define PCIE_CTRL_OBS_MUX_RESET                                                0x0
#define PCIE_CTRL_IGNORE_AXI_PCIE_L1_LSB                                       16
#define PCIE_CTRL_IGNORE_AXI_PCIE_L1_MSB                                       16
#define PCIE_CTRL_IGNORE_AXI_PCIE_L1_MASK                                      0x10000
#define PCIE_CTRL_IGNORE_AXI_PCIE_L1_GET(x)                                    (((x) & PCIE_CTRL_IGNORE_AXI_PCIE_L1_MASK) >> PCIE_CTRL_IGNORE_AXI_PCIE_L1_LSB)
#define PCIE_CTRL_IGNORE_AXI_PCIE_L1_SET(x)                                    (((0 | (x)) << PCIE_CTRL_IGNORE_AXI_PCIE_L1_LSB) & PCIE_CTRL_IGNORE_AXI_PCIE_L1_MASK)
#define PCIE_CTRL_IGNORE_AXI_PCIE_L1_RESET                                     0x0
#define PCIE_CTRL_IGNORE_MAC_FOR_L1_LSB                                        15
#define PCIE_CTRL_IGNORE_MAC_FOR_L1_MSB                                        15
#define PCIE_CTRL_IGNORE_MAC_FOR_L1_MASK                                       0x8000
#define PCIE_CTRL_IGNORE_MAC_FOR_L1_GET(x)                                     (((x) & PCIE_CTRL_IGNORE_MAC_FOR_L1_MASK) >> PCIE_CTRL_IGNORE_MAC_FOR_L1_LSB)
#define PCIE_CTRL_IGNORE_MAC_FOR_L1_SET(x)                                     (((0 | (x)) << PCIE_CTRL_IGNORE_MAC_FOR_L1_LSB) & PCIE_CTRL_IGNORE_MAC_FOR_L1_MASK)
#define PCIE_CTRL_IGNORE_MAC_FOR_L1_RESET                                      0x0
#define PCIE_CTRL_TARGET_L1_EN_LSB                                             14
#define PCIE_CTRL_TARGET_L1_EN_MSB                                             14
#define PCIE_CTRL_TARGET_L1_EN_MASK                                            0x4000
#define PCIE_CTRL_TARGET_L1_EN_GET(x)                                          (((x) & PCIE_CTRL_TARGET_L1_EN_MASK) >> PCIE_CTRL_TARGET_L1_EN_LSB)
#define PCIE_CTRL_TARGET_L1_EN_SET(x)                                          (((0 | (x)) << PCIE_CTRL_TARGET_L1_EN_LSB) & PCIE_CTRL_TARGET_L1_EN_MASK)
#define PCIE_CTRL_TARGET_L1_EN_RESET                                           0x0
#define PCIE_CTRL_HOST_L1_EN_LSB                                               13
#define PCIE_CTRL_HOST_L1_EN_MSB                                               13
#define PCIE_CTRL_HOST_L1_EN_MASK                                              0x2000
#define PCIE_CTRL_HOST_L1_EN_GET(x)                                            (((x) & PCIE_CTRL_HOST_L1_EN_MASK) >> PCIE_CTRL_HOST_L1_EN_LSB)
#define PCIE_CTRL_HOST_L1_EN_SET(x)                                            (((0 | (x)) << PCIE_CTRL_HOST_L1_EN_LSB) & PCIE_CTRL_HOST_L1_EN_MASK)
#define PCIE_CTRL_HOST_L1_EN_RESET                                             0x0
#define PCIE_CTRL_TRAINING_RST_EN_LSB                                          12
#define PCIE_CTRL_TRAINING_RST_EN_MSB                                          12
#define PCIE_CTRL_TRAINING_RST_EN_MASK                                         0x1000
#define PCIE_CTRL_TRAINING_RST_EN_GET(x)                                       (((x) & PCIE_CTRL_TRAINING_RST_EN_MASK) >> PCIE_CTRL_TRAINING_RST_EN_LSB)
#define PCIE_CTRL_TRAINING_RST_EN_SET(x)                                       (((0 | (x)) << PCIE_CTRL_TRAINING_RST_EN_LSB) & PCIE_CTRL_TRAINING_RST_EN_MASK)
#define PCIE_CTRL_TRAINING_RST_EN_RESET                                        0x0
#define PCIE_CTRL_RDLH_LINK_RST_EN_LSB                                         11
#define PCIE_CTRL_RDLH_LINK_RST_EN_MSB                                         11
#define PCIE_CTRL_RDLH_LINK_RST_EN_MASK                                        0x800
#define PCIE_CTRL_RDLH_LINK_RST_EN_GET(x)                                      (((x) & PCIE_CTRL_RDLH_LINK_RST_EN_MASK) >> PCIE_CTRL_RDLH_LINK_RST_EN_LSB)
#define PCIE_CTRL_RDLH_LINK_RST_EN_SET(x)                                      (((0 | (x)) << PCIE_CTRL_RDLH_LINK_RST_EN_LSB) & PCIE_CTRL_RDLH_LINK_RST_EN_MASK)
#define PCIE_CTRL_RDLH_LINK_RST_EN_RESET                                       0x0
#define PCIE_CTRL_LINK_REQ_RST_EN_LSB                                          10
#define PCIE_CTRL_LINK_REQ_RST_EN_MSB                                          10
#define PCIE_CTRL_LINK_REQ_RST_EN_MASK                                         0x400
#define PCIE_CTRL_LINK_REQ_RST_EN_GET(x)                                       (((x) & PCIE_CTRL_LINK_REQ_RST_EN_MASK) >> PCIE_CTRL_LINK_REQ_RST_EN_LSB)
#define PCIE_CTRL_LINK_REQ_RST_EN_SET(x)                                       (((0 | (x)) << PCIE_CTRL_LINK_REQ_RST_EN_LSB) & PCIE_CTRL_LINK_REQ_RST_EN_MASK)
#define PCIE_CTRL_LINK_REQ_RST_EN_RESET                                        0x0
#define PCIE_CTRL_XMLH_LINK_RST_EN_LSB                                         9
#define PCIE_CTRL_XMLH_LINK_RST_EN_MSB                                         9
#define PCIE_CTRL_XMLH_LINK_RST_EN_MASK                                        0x200
#define PCIE_CTRL_XMLH_LINK_RST_EN_GET(x)                                      (((x) & PCIE_CTRL_XMLH_LINK_RST_EN_MASK) >> PCIE_CTRL_XMLH_LINK_RST_EN_LSB)
#define PCIE_CTRL_XMLH_LINK_RST_EN_SET(x)                                      (((0 | (x)) << PCIE_CTRL_XMLH_LINK_RST_EN_LSB) & PCIE_CTRL_XMLH_LINK_RST_EN_MASK)
#define PCIE_CTRL_XMLH_LINK_RST_EN_RESET                                       0x0
#define PCIE_CTRL_APP_LTSSM_ENABLE_LSB                                         8
#define PCIE_CTRL_APP_LTSSM_ENABLE_MSB                                         8
#define PCIE_CTRL_APP_LTSSM_ENABLE_MASK                                        0x100
#define PCIE_CTRL_APP_LTSSM_ENABLE_GET(x)                                      (((x) & PCIE_CTRL_APP_LTSSM_ENABLE_MASK) >> PCIE_CTRL_APP_LTSSM_ENABLE_LSB)
#define PCIE_CTRL_APP_LTSSM_ENABLE_SET(x)                                      (((0 | (x)) << PCIE_CTRL_APP_LTSSM_ENABLE_LSB) & PCIE_CTRL_APP_LTSSM_ENABLE_MASK)
#define PCIE_CTRL_APP_LTSSM_ENABLE_RESET                                       0x0
#define PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_LSB                              7
#define PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_MSB                              7
#define PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_MASK                             0x80
#define PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_GET(x)                           (((x) & PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_MASK) >> PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_LSB)
#define PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_SET(x)                           (((0 | (x)) << PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_LSB) & PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_MASK)
#define PCIE_CTRL_ASPM_TIMER_BASED_L1_DISABLE_RESET                            0x0
#define PCIE_CTRL_SYS_AUX_PWR_DET_LSB                                          6
#define PCIE_CTRL_SYS_AUX_PWR_DET_MSB                                          6
#define PCIE_CTRL_SYS_AUX_PWR_DET_MASK                                         0x40
#define PCIE_CTRL_SYS_AUX_PWR_DET_GET(x)                                       (((x) & PCIE_CTRL_SYS_AUX_PWR_DET_MASK) >> PCIE_CTRL_SYS_AUX_PWR_DET_LSB)
#define PCIE_CTRL_SYS_AUX_PWR_DET_SET(x)                                       (((0 | (x)) << PCIE_CTRL_SYS_AUX_PWR_DET_LSB) & PCIE_CTRL_SYS_AUX_PWR_DET_MASK)
#define PCIE_CTRL_SYS_AUX_PWR_DET_RESET                                        0x1
#define PCIE_CTRL_D3_TO_L1_DISABLE_EN_LSB                                      5
#define PCIE_CTRL_D3_TO_L1_DISABLE_EN_MSB                                      5
#define PCIE_CTRL_D3_TO_L1_DISABLE_EN_MASK                                     0x20
#define PCIE_CTRL_D3_TO_L1_DISABLE_EN_GET(x)                                   (((x) & PCIE_CTRL_D3_TO_L1_DISABLE_EN_MASK) >> PCIE_CTRL_D3_TO_L1_DISABLE_EN_LSB)
#define PCIE_CTRL_D3_TO_L1_DISABLE_EN_SET(x)                                   (((0 | (x)) << PCIE_CTRL_D3_TO_L1_DISABLE_EN_LSB) & PCIE_CTRL_D3_TO_L1_DISABLE_EN_MASK)
#define PCIE_CTRL_D3_TO_L1_DISABLE_EN_RESET                                    0x0
#define PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_LSB                                 4
#define PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_MSB                                 4
#define PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_MASK                                0x10
#define PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_GET(x)                              (((x) & PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_MASK) >> PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_LSB)
#define PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_SET(x)                              (((0 | (x)) << PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_LSB) & PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_MASK)
#define PCIE_CTRL_D3_TO_L1_DISABLE_REAL_EN_RESET                               0x0
#define PCIE_CTRL_NO_NAK_WA_EN_LSB                                             3
#define PCIE_CTRL_NO_NAK_WA_EN_MSB                                             3
#define PCIE_CTRL_NO_NAK_WA_EN_MASK                                            0x8
#define PCIE_CTRL_NO_NAK_WA_EN_GET(x)                                          (((x) & PCIE_CTRL_NO_NAK_WA_EN_MASK) >> PCIE_CTRL_NO_NAK_WA_EN_LSB)
#define PCIE_CTRL_NO_NAK_WA_EN_SET(x)                                          (((0 | (x)) << PCIE_CTRL_NO_NAK_WA_EN_LSB) & PCIE_CTRL_NO_NAK_WA_EN_MASK)
#define PCIE_CTRL_NO_NAK_WA_EN_RESET                                           0x0
#define PCIE_CTRL_GDATA_WA_EN_LSB                                              2
#define PCIE_CTRL_GDATA_WA_EN_MSB                                              2
#define PCIE_CTRL_GDATA_WA_EN_MASK                                             0x4
#define PCIE_CTRL_GDATA_WA_EN_GET(x)                                           (((x) & PCIE_CTRL_GDATA_WA_EN_MASK) >> PCIE_CTRL_GDATA_WA_EN_LSB)
#define PCIE_CTRL_GDATA_WA_EN_SET(x)                                           (((0 | (x)) << PCIE_CTRL_GDATA_WA_EN_LSB) & PCIE_CTRL_GDATA_WA_EN_MASK)
#define PCIE_CTRL_GDATA_WA_EN_RESET                                            0x1
#define PCIE_CTRL_TS2_WA_EN_LSB                                                1
#define PCIE_CTRL_TS2_WA_EN_MSB                                                1
#define PCIE_CTRL_TS2_WA_EN_MASK                                               0x2
#define PCIE_CTRL_TS2_WA_EN_GET(x)                                             (((x) & PCIE_CTRL_TS2_WA_EN_MASK) >> PCIE_CTRL_TS2_WA_EN_LSB)
#define PCIE_CTRL_TS2_WA_EN_SET(x)                                             (((0 | (x)) << PCIE_CTRL_TS2_WA_EN_LSB) & PCIE_CTRL_TS2_WA_EN_MASK)
#define PCIE_CTRL_TS2_WA_EN_RESET                                              0x1
#define PCIE_CTRL_TS1_WA_EN_LSB                                                0
#define PCIE_CTRL_TS1_WA_EN_MSB                                                0
#define PCIE_CTRL_TS1_WA_EN_MASK                                               0x1
#define PCIE_CTRL_TS1_WA_EN_GET(x)                                             (((x) & PCIE_CTRL_TS1_WA_EN_MASK) >> PCIE_CTRL_TS1_WA_EN_LSB)
#define PCIE_CTRL_TS1_WA_EN_SET(x)                                             (((0 | (x)) << PCIE_CTRL_TS1_WA_EN_LSB) & PCIE_CTRL_TS1_WA_EN_MASK)
#define PCIE_CTRL_TS1_WA_EN_RESET                                              0x1
#define PCIE_CTRL_ADDRESS                                                      (0xc + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_CTRL_RSTMASK                                                      0x7fffffff
#define PCIE_CTRL_RESET                                                        0xc000047

// 0x10 (PCIE_NFTS)
#define PCIE_NFTS_CNTL_EN_LSB                                                  8
#define PCIE_NFTS_CNTL_EN_MSB                                                  8
#define PCIE_NFTS_CNTL_EN_MASK                                                 0x100
#define PCIE_NFTS_CNTL_EN_GET(x)                                               (((x) & PCIE_NFTS_CNTL_EN_MASK) >> PCIE_NFTS_CNTL_EN_LSB)
#define PCIE_NFTS_CNTL_EN_SET(x)                                               (((0 | (x)) << PCIE_NFTS_CNTL_EN_LSB) & PCIE_NFTS_CNTL_EN_MASK)
#define PCIE_NFTS_CNTL_EN_RESET                                                0x0
#define PCIE_NFTS_ADJ_LSB                                                      0
#define PCIE_NFTS_ADJ_MSB                                                      7
#define PCIE_NFTS_ADJ_MASK                                                     0xff
#define PCIE_NFTS_ADJ_GET(x)                                                   (((x) & PCIE_NFTS_ADJ_MASK) >> PCIE_NFTS_ADJ_LSB)
#define PCIE_NFTS_ADJ_SET(x)                                                   (((0 | (x)) << PCIE_NFTS_ADJ_LSB) & PCIE_NFTS_ADJ_MASK)
#define PCIE_NFTS_ADJ_RESET                                                    0x0
#define PCIE_NFTS_ADDRESS                                                      (0x10 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_NFTS_RSTMASK                                                      0x1ff
#define PCIE_NFTS_RESET                                                        0x0

// 0x14 (PCIE_MSI_STATUS)
#define PCIE_MSI_STATUS_MSI_INT_PENDING_LSB                                    21
#define PCIE_MSI_STATUS_MSI_INT_PENDING_MSB                                    24
#define PCIE_MSI_STATUS_MSI_INT_PENDING_MASK                                   0x1e00000
#define PCIE_MSI_STATUS_MSI_INT_PENDING_GET(x)                                 (((x) & PCIE_MSI_STATUS_MSI_INT_PENDING_MASK) >> PCIE_MSI_STATUS_MSI_INT_PENDING_LSB)
#define PCIE_MSI_STATUS_MSI_INT_PENDING_SET(x)                                 (((0 | (x)) << PCIE_MSI_STATUS_MSI_INT_PENDING_LSB) & PCIE_MSI_STATUS_MSI_INT_PENDING_MASK)
#define PCIE_MSI_STATUS_MSI_INT_PENDING_RESET                                  0x0
#define PCIE_MSI_STATUS_MULTI_LSB                                              18
#define PCIE_MSI_STATUS_MULTI_MSB                                              20
#define PCIE_MSI_STATUS_MULTI_MASK                                             0x1c0000
#define PCIE_MSI_STATUS_MULTI_GET(x)                                           (((x) & PCIE_MSI_STATUS_MULTI_MASK) >> PCIE_MSI_STATUS_MULTI_LSB)
#define PCIE_MSI_STATUS_MULTI_SET(x)                                           (((0 | (x)) << PCIE_MSI_STATUS_MULTI_LSB) & PCIE_MSI_STATUS_MULTI_MASK)
#define PCIE_MSI_STATUS_MULTI_RESET                                            0x0
#define PCIE_MSI_STATUS__64_BIT_LSB                                            17
#define PCIE_MSI_STATUS__64_BIT_MSB                                            17
#define PCIE_MSI_STATUS__64_BIT_MASK                                           0x20000
#define PCIE_MSI_STATUS__64_BIT_GET(x)                                         (((x) & PCIE_MSI_STATUS__64_BIT_MASK) >> PCIE_MSI_STATUS__64_BIT_LSB)
#define PCIE_MSI_STATUS__64_BIT_SET(x)                                         (((0 | (x)) << PCIE_MSI_STATUS__64_BIT_LSB) & PCIE_MSI_STATUS__64_BIT_MASK)
#define PCIE_MSI_STATUS__64_BIT_RESET                                          0x0
#define PCIE_MSI_STATUS_DATA_LSB                                               1
#define PCIE_MSI_STATUS_DATA_MSB                                               16
#define PCIE_MSI_STATUS_DATA_MASK                                              0x1fffe
#define PCIE_MSI_STATUS_DATA_GET(x)                                            (((x) & PCIE_MSI_STATUS_DATA_MASK) >> PCIE_MSI_STATUS_DATA_LSB)
#define PCIE_MSI_STATUS_DATA_SET(x)                                            (((0 | (x)) << PCIE_MSI_STATUS_DATA_LSB) & PCIE_MSI_STATUS_DATA_MASK)
#define PCIE_MSI_STATUS_DATA_RESET                                             0x0
#define PCIE_MSI_STATUS_EN_LSB                                                 0
#define PCIE_MSI_STATUS_EN_MSB                                                 0
#define PCIE_MSI_STATUS_EN_MASK                                                0x1
#define PCIE_MSI_STATUS_EN_GET(x)                                              (((x) & PCIE_MSI_STATUS_EN_MASK) >> PCIE_MSI_STATUS_EN_LSB)
#define PCIE_MSI_STATUS_EN_SET(x)                                              (((0 | (x)) << PCIE_MSI_STATUS_EN_LSB) & PCIE_MSI_STATUS_EN_MASK)
#define PCIE_MSI_STATUS_EN_RESET                                               0x0
#define PCIE_MSI_STATUS_ADDRESS                                                (0x14 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_MSI_STATUS_RSTMASK                                                0x1ffffff
#define PCIE_MSI_STATUS_RESET                                                  0x0

// 0x18 (PCIE_MSI_MASK)
#define PCIE_MSI_MASK_VALUE_LSB                                                0
#define PCIE_MSI_MASK_VALUE_MSB                                                31
#define PCIE_MSI_MASK_VALUE_MASK                                               0xffffffff
#define PCIE_MSI_MASK_VALUE_GET(x)                                             (((x) & PCIE_MSI_MASK_VALUE_MASK) >> PCIE_MSI_MASK_VALUE_LSB)
#define PCIE_MSI_MASK_VALUE_SET(x)                                             (((0 | (x)) << PCIE_MSI_MASK_VALUE_LSB) & PCIE_MSI_MASK_VALUE_MASK)
#define PCIE_MSI_MASK_VALUE_RESET                                              0x0
#define PCIE_MSI_MASK_ADDRESS                                                  (0x18 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_MSI_MASK_RSTMASK                                                  0xffffffff
#define PCIE_MSI_MASK_RESET                                                    0x0

// 0x1c (PCIE_MSI_ADDR)
#define PCIE_MSI_ADDR_LOW_LSB                                                  0
#define PCIE_MSI_ADDR_LOW_MSB                                                  31
#define PCIE_MSI_ADDR_LOW_MASK                                                 0xffffffff
#define PCIE_MSI_ADDR_LOW_GET(x)                                               (((x) & PCIE_MSI_ADDR_LOW_MASK) >> PCIE_MSI_ADDR_LOW_LSB)
#define PCIE_MSI_ADDR_LOW_SET(x)                                               (((0 | (x)) << PCIE_MSI_ADDR_LOW_LSB) & PCIE_MSI_ADDR_LOW_MASK)
#define PCIE_MSI_ADDR_LOW_RESET                                                0x0
#define PCIE_MSI_ADDR_ADDRESS                                                  (0x1c + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_MSI_ADDR_RSTMASK                                                  0xffffffff
#define PCIE_MSI_ADDR_RESET                                                    0x0

// 0x20 (PCIE_CO_ERR_CTR0)
#define PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_LSB                                      16
#define PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_MSB                                      23
#define PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_MASK                                     0xff0000
#define PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_GET(x)                                   (((x) & PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_MASK) >> PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_LSB)
#define PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_SET(x)                                   (((0 | (x)) << PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_LSB) & PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_MASK)
#define PCIE_CO_ERR_CTR0_BAD_DLLP_ERR_RESET                                    0x0
#define PCIE_CO_ERR_CTR0_BAD_TLP_ERR_LSB                                       8
#define PCIE_CO_ERR_CTR0_BAD_TLP_ERR_MSB                                       15
#define PCIE_CO_ERR_CTR0_BAD_TLP_ERR_MASK                                      0xff00
#define PCIE_CO_ERR_CTR0_BAD_TLP_ERR_GET(x)                                    (((x) & PCIE_CO_ERR_CTR0_BAD_TLP_ERR_MASK) >> PCIE_CO_ERR_CTR0_BAD_TLP_ERR_LSB)
#define PCIE_CO_ERR_CTR0_BAD_TLP_ERR_SET(x)                                    (((0 | (x)) << PCIE_CO_ERR_CTR0_BAD_TLP_ERR_LSB) & PCIE_CO_ERR_CTR0_BAD_TLP_ERR_MASK)
#define PCIE_CO_ERR_CTR0_BAD_TLP_ERR_RESET                                     0x0
#define PCIE_CO_ERR_CTR0_RCVD_ERR_LSB                                          0
#define PCIE_CO_ERR_CTR0_RCVD_ERR_MSB                                          7
#define PCIE_CO_ERR_CTR0_RCVD_ERR_MASK                                         0xff
#define PCIE_CO_ERR_CTR0_RCVD_ERR_GET(x)                                       (((x) & PCIE_CO_ERR_CTR0_RCVD_ERR_MASK) >> PCIE_CO_ERR_CTR0_RCVD_ERR_LSB)
#define PCIE_CO_ERR_CTR0_RCVD_ERR_SET(x)                                       (((0 | (x)) << PCIE_CO_ERR_CTR0_RCVD_ERR_LSB) & PCIE_CO_ERR_CTR0_RCVD_ERR_MASK)
#define PCIE_CO_ERR_CTR0_RCVD_ERR_RESET                                        0x0
#define PCIE_CO_ERR_CTR0_ADDRESS                                               (0x20 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_CO_ERR_CTR0_RSTMASK                                               0xffffff
#define PCIE_CO_ERR_CTR0_RESET                                                 0x0

// 0x24 (PCIE_CO_ERR_CTR1)
#define PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_LSB                                   8
#define PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_MSB                                   15
#define PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_MASK                                  0xff00
#define PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_GET(x)                                (((x) & PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_MASK) >> PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_LSB)
#define PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_SET(x)                                (((0 | (x)) << PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_LSB) & PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_MASK)
#define PCIE_CO_ERR_CTR1_RPLY_NUM_RO_ERR_RESET                                 0x0
#define PCIE_CO_ERR_CTR1_RPLY_TO_ERR_LSB                                       0
#define PCIE_CO_ERR_CTR1_RPLY_TO_ERR_MSB                                       7
#define PCIE_CO_ERR_CTR1_RPLY_TO_ERR_MASK                                      0xff
#define PCIE_CO_ERR_CTR1_RPLY_TO_ERR_GET(x)                                    (((x) & PCIE_CO_ERR_CTR1_RPLY_TO_ERR_MASK) >> PCIE_CO_ERR_CTR1_RPLY_TO_ERR_LSB)
#define PCIE_CO_ERR_CTR1_RPLY_TO_ERR_SET(x)                                    (((0 | (x)) << PCIE_CO_ERR_CTR1_RPLY_TO_ERR_LSB) & PCIE_CO_ERR_CTR1_RPLY_TO_ERR_MASK)
#define PCIE_CO_ERR_CTR1_RPLY_TO_ERR_RESET                                     0x0
#define PCIE_CO_ERR_CTR1_ADDRESS                                               (0x24 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_CO_ERR_CTR1_RSTMASK                                               0xffff
#define PCIE_CO_ERR_CTR1_RESET                                                 0x0

// 0x28 (PCIE_CO_ERR_CTR_CTRL)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_LSB                 9
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_MSB                 9
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_MASK                0x200
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_GET(x)              (((x) & PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_MASK) >> PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_LSB)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_SET(x)              (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_LSB) & PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_MASK)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_AUTO_STOP_RESET               0x0
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_LSB                       8
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_MSB                       8
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_MASK                      0x100
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_GET(x)                    (((x) & PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_MASK) >> PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_LSB)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_SET(x)                    (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_LSB) & PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_MASK)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_NUM_RO_ERR_CTR_RUN_RESET                     0x0
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_LSB                     7
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_MSB                     7
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_MASK                    0x80
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_GET(x)                  (((x) & PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_MASK) >> PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_LSB)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_SET(x)                  (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_LSB) & PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_MASK)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_AUTO_STOP_RESET                   0x0
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_LSB                           6
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_MSB                           6
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_MASK                          0x40
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_GET(x)                        (((x) & PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_MASK) >> PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_LSB)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_SET(x)                        (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_LSB) & PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_MASK)
#define PCIE_CO_ERR_CTR_CTRL_RPLY_TO_ERR_CTR_RUN_RESET                         0x0
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_LSB                    5
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_MSB                    5
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_MASK                   0x20
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_GET(x)                 (((x) & PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_MASK) >> PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_LSB)
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_SET(x)                 (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_LSB) & PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_MASK)
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_AUTO_STOP_RESET                  0x0
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_LSB                          4
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_MSB                          4
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_MASK                         0x10
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_GET(x)                       (((x) & PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_MASK) >> PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_LSB)
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_SET(x)                       (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_LSB) & PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_MASK)
#define PCIE_CO_ERR_CTR_CTRL_BAD_DLLP_ERR_CTR_RUN_RESET                        0x0
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_LSB                     3
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_MSB                     3
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_MASK                    0x8
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_GET(x)                  (((x) & PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_MASK) >> PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_LSB)
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_SET(x)                  (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_LSB) & PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_MASK)
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_AUTO_STOP_RESET                   0x0
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_LSB                           2
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_MSB                           2
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_MASK                          0x4
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_GET(x)                        (((x) & PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_MASK) >> PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_LSB)
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_SET(x)                        (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_LSB) & PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_MASK)
#define PCIE_CO_ERR_CTR_CTRL_BAD_TLP_ERR_CTR_RUN_RESET                         0x0
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_LSB                        1
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_MSB                        1
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_MASK                       0x2
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_GET(x)                     (((x) & PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_MASK) >> PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_LSB)
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_SET(x)                     (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_LSB) & PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_MASK)
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_AUTO_STOP_RESET                      0x0
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_LSB                              0
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_MSB                              0
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_MASK                             0x1
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_GET(x)                           (((x) & PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_MASK) >> PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_LSB)
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_SET(x)                           (((0 | (x)) << PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_LSB) & PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_MASK)
#define PCIE_CO_ERR_CTR_CTRL_RCVD_ERR_CTR_RUN_RESET                            0x0
#define PCIE_CO_ERR_CTR_CTRL_ADDRESS                                           (0x28 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_CO_ERR_CTR_CTRL_RSTMASK                                           0x3ff
#define PCIE_CO_ERR_CTR_CTRL_RESET                                             0x0

// 0x2c (PCIE_MISC_STATUS)
#define PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_LSB                                9
#define PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_MSB                                9
#define PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_MASK                               0x200
#define PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_GET(x)                             (((x) & PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_MASK) >> PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_LSB)
#define PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_SET(x)                             (((0 | (x)) << PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_LSB) & PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_MASK)
#define PCIE_MISC_STATUS_CFG_PM_NO_SOFT_RST_RESET                              0x0
#define PCIE_MISC_STATUS_CFG_RCB_LSB                                           8
#define PCIE_MISC_STATUS_CFG_RCB_MSB                                           8
#define PCIE_MISC_STATUS_CFG_RCB_MASK                                          0x100
#define PCIE_MISC_STATUS_CFG_RCB_GET(x)                                        (((x) & PCIE_MISC_STATUS_CFG_RCB_MASK) >> PCIE_MISC_STATUS_CFG_RCB_LSB)
#define PCIE_MISC_STATUS_CFG_RCB_SET(x)                                        (((0 | (x)) << PCIE_MISC_STATUS_CFG_RCB_LSB) & PCIE_MISC_STATUS_CFG_RCB_MASK)
#define PCIE_MISC_STATUS_CFG_RCB_RESET                                         0x0
#define PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_LSB                              5
#define PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_MSB                              7
#define PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_MASK                             0xe0
#define PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_GET(x)                           (((x) & PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_MASK) >> PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_LSB)
#define PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_SET(x)                           (((0 | (x)) << PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_LSB) & PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_MASK)
#define PCIE_MISC_STATUS_CFG_MAX_PAYLOAD_SIZE_RESET                            0x0
#define PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_LSB                               2
#define PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_MSB                               4
#define PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_MASK                              0x1c
#define PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_GET(x)                            (((x) & PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_MASK) >> PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_LSB)
#define PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_SET(x)                            (((0 | (x)) << PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_LSB) & PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_MASK)
#define PCIE_MISC_STATUS_CFG_MAX_RD_REQ_SIZE_RESET                             0x0
#define PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_LSB                                  1
#define PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_MSB                                  1
#define PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_MASK                                 0x2
#define PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_GET(x)                               (((x) & PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_MASK) >> PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_LSB)
#define PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_SET(x)                               (((0 | (x)) << PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_LSB) & PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_MASK)
#define PCIE_MISC_STATUS_CFG_MEM_SPACE_EN_RESET                                0x0
#define PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_LSB                                 0
#define PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_MSB                                 0
#define PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_MASK                                0x1
#define PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_GET(x)                              (((x) & PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_MASK) >> PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_LSB)
#define PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_SET(x)                              (((0 | (x)) << PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_LSB) & PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_MASK)
#define PCIE_MISC_STATUS_CFG_BUS_MASTER_EN_RESET                               0x0
#define PCIE_MISC_STATUS_ADDRESS                                               (0x2c + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_MISC_STATUS_RSTMASK                                               0x3ff
#define PCIE_MISC_STATUS_RESET                                                 0x0

// 0x30 (PCIE_BAR0_START)
#define PCIE_BAR0_START_VAL_LSB                                                0
#define PCIE_BAR0_START_VAL_MSB                                                31
#define PCIE_BAR0_START_VAL_MASK                                               0xffffffff
#define PCIE_BAR0_START_VAL_GET(x)                                             (((x) & PCIE_BAR0_START_VAL_MASK) >> PCIE_BAR0_START_VAL_LSB)
#define PCIE_BAR0_START_VAL_SET(x)                                             (((0 | (x)) << PCIE_BAR0_START_VAL_LSB) & PCIE_BAR0_START_VAL_MASK)
#define PCIE_BAR0_START_VAL_RESET                                              0x0
#define PCIE_BAR0_START_ADDRESS                                                (0x30 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_BAR0_START_RSTMASK                                                0xffffffff
#define PCIE_BAR0_START_RESET                                                  0x0

// 0x34 (PCIE_BAR0_LIMIT)
#define PCIE_BAR0_LIMIT_VAL_LSB                                                0
#define PCIE_BAR0_LIMIT_VAL_MSB                                                31
#define PCIE_BAR0_LIMIT_VAL_MASK                                               0xffffffff
#define PCIE_BAR0_LIMIT_VAL_GET(x)                                             (((x) & PCIE_BAR0_LIMIT_VAL_MASK) >> PCIE_BAR0_LIMIT_VAL_LSB)
#define PCIE_BAR0_LIMIT_VAL_SET(x)                                             (((0 | (x)) << PCIE_BAR0_LIMIT_VAL_LSB) & PCIE_BAR0_LIMIT_VAL_MASK)
#define PCIE_BAR0_LIMIT_VAL_RESET                                              0x0
#define PCIE_BAR0_LIMIT_ADDRESS                                                (0x34 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_BAR0_LIMIT_RSTMASK                                                0xffffffff
#define PCIE_BAR0_LIMIT_RESET                                                  0x0

// 0x38 (AUTOCOMPL)
#define AUTOCOMPL_ENABLE_LSB                                                   0
#define AUTOCOMPL_ENABLE_MSB                                                   0
#define AUTOCOMPL_ENABLE_MASK                                                  0x1
#define AUTOCOMPL_ENABLE_GET(x)                                                (((x) & AUTOCOMPL_ENABLE_MASK) >> AUTOCOMPL_ENABLE_LSB)
#define AUTOCOMPL_ENABLE_SET(x)                                                (((0 | (x)) << AUTOCOMPL_ENABLE_LSB) & AUTOCOMPL_ENABLE_MASK)
#define AUTOCOMPL_ENABLE_RESET                                                 0x1
#define AUTOCOMPL_ADDRESS                                                      (0x38 + __SOC_PCIE_REG_BASE_ADDRESS)
#define AUTOCOMPL_RSTMASK                                                      0x1
#define AUTOCOMPL_RESET                                                        0x1

// 0x3c (NUM_READS_WR_PENDING)
#define NUM_READS_WR_PENDING_V_LSB                                             0
#define NUM_READS_WR_PENDING_V_MSB                                             4
#define NUM_READS_WR_PENDING_V_MASK                                            0x1f
#define NUM_READS_WR_PENDING_V_GET(x)                                          (((x) & NUM_READS_WR_PENDING_V_MASK) >> NUM_READS_WR_PENDING_V_LSB)
#define NUM_READS_WR_PENDING_V_SET(x)                                          (((0 | (x)) << NUM_READS_WR_PENDING_V_LSB) & NUM_READS_WR_PENDING_V_MASK)
#define NUM_READS_WR_PENDING_V_RESET                                           0x8
#define NUM_READS_WR_PENDING_ADDRESS                                           (0x3c + __SOC_PCIE_REG_BASE_ADDRESS)
#define NUM_READS_WR_PENDING_RSTMASK                                           0x1f
#define NUM_READS_WR_PENDING_RESET                                             0x8

// 0x40 (PCIE_SCRATCH_0)
#define PCIE_SCRATCH_0_VAL_LSB                                                 0
#define PCIE_SCRATCH_0_VAL_MSB                                                 31
#define PCIE_SCRATCH_0_VAL_MASK                                                0xffffffff
#define PCIE_SCRATCH_0_VAL_GET(x)                                              (((x) & PCIE_SCRATCH_0_VAL_MASK) >> PCIE_SCRATCH_0_VAL_LSB)
#define PCIE_SCRATCH_0_VAL_SET(x)                                              (((0 | (x)) << PCIE_SCRATCH_0_VAL_LSB) & PCIE_SCRATCH_0_VAL_MASK)
#define PCIE_SCRATCH_0_VAL_RESET                                               0x0
#define PCIE_SCRATCH_0_ADDRESS                                                 (0x40 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_SCRATCH_0_RSTMASK                                                 0xffffffff
#define PCIE_SCRATCH_0_RESET                                                   0x0

// 0x44 (PCIE_SCRATCH_1)
#define PCIE_SCRATCH_1_VAL_LSB                                                 0
#define PCIE_SCRATCH_1_VAL_MSB                                                 31
#define PCIE_SCRATCH_1_VAL_MASK                                                0xffffffff
#define PCIE_SCRATCH_1_VAL_GET(x)                                              (((x) & PCIE_SCRATCH_1_VAL_MASK) >> PCIE_SCRATCH_1_VAL_LSB)
#define PCIE_SCRATCH_1_VAL_SET(x)                                              (((0 | (x)) << PCIE_SCRATCH_1_VAL_LSB) & PCIE_SCRATCH_1_VAL_MASK)
#define PCIE_SCRATCH_1_VAL_RESET                                               0x80000
#define PCIE_SCRATCH_1_ADDRESS                                                 (0x44 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_SCRATCH_1_RSTMASK                                                 0xffffffff
#define PCIE_SCRATCH_1_RESET                                                   0x80000

// 0x48 (PCIE_PHY_CTRL1)
#define PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_LSB                                 26
#define PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_MSB                                 30
#define PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_MASK                                0x7c000000
#define PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_GET(x)                              (((x) & PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_MASK) >> PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_LSB)
#define PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_SET(x)                              (((0 | (x)) << PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_LSB) & PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_MASK)
#define PCIE_PHY_CTRL1_PHY_TX0_TERM_OFFSET_RESET                               0x0
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_LSB                                  20
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_MSB                                  25
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_MASK                                 0x3f00000
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_GET(x)                               (((x) & PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_MASK) >> PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_LSB)
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_SET(x)                               (((0 | (x)) << PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_LSB) & PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_MASK)
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN1_RESET                                0x15
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_LSB                              14
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_MSB                              19
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_MASK                             0xfc000
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_GET(x)                           (((x) & PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_MASK) >> PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_LSB)
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_SET(x)                           (((0 | (x)) << PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_LSB) & PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_MASK)
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_6DB_RESET                            0x20
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_LSB                            8
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_MSB                            13
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_MASK                           0x3f00
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_GET(x)                         (((x) & PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_MASK) >> PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_LSB)
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_SET(x)                         (((0 | (x)) << PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_LSB) & PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_MASK)
#define PCIE_PHY_CTRL1_PCS_TX_DEEMPH_GEN2_3P5DB_RESET                          0x15
#define PCIE_PHY_CTRL1_PHY_RX0_EQ_LSB                                          5
#define PCIE_PHY_CTRL1_PHY_RX0_EQ_MSB                                          7
#define PCIE_PHY_CTRL1_PHY_RX0_EQ_MASK                                         0xe0
#define PCIE_PHY_CTRL1_PHY_RX0_EQ_GET(x)                                       (((x) & PCIE_PHY_CTRL1_PHY_RX0_EQ_MASK) >> PCIE_PHY_CTRL1_PHY_RX0_EQ_LSB)
#define PCIE_PHY_CTRL1_PHY_RX0_EQ_SET(x)                                       (((0 | (x)) << PCIE_PHY_CTRL1_PHY_RX0_EQ_LSB) & PCIE_PHY_CTRL1_PHY_RX0_EQ_MASK)
#define PCIE_PHY_CTRL1_PHY_RX0_EQ_RESET                                        0x2
#define PCIE_PHY_CTRL1_PHY_RTUNE_REQ_LSB                                       4
#define PCIE_PHY_CTRL1_PHY_RTUNE_REQ_MSB                                       4
#define PCIE_PHY_CTRL1_PHY_RTUNE_REQ_MASK                                      0x10
#define PCIE_PHY_CTRL1_PHY_RTUNE_REQ_GET(x)                                    (((x) & PCIE_PHY_CTRL1_PHY_RTUNE_REQ_MASK) >> PCIE_PHY_CTRL1_PHY_RTUNE_REQ_LSB)
#define PCIE_PHY_CTRL1_PHY_RTUNE_REQ_SET(x)                                    (((0 | (x)) << PCIE_PHY_CTRL1_PHY_RTUNE_REQ_LSB) & PCIE_PHY_CTRL1_PHY_RTUNE_REQ_MASK)
#define PCIE_PHY_CTRL1_PHY_RTUNE_REQ_RESET                                     0x0
#define PCIE_PHY_CTRL1_PHY_LOS_BIAS_LSB                                        1
#define PCIE_PHY_CTRL1_PHY_LOS_BIAS_MSB                                        3
#define PCIE_PHY_CTRL1_PHY_LOS_BIAS_MASK                                       0xe
#define PCIE_PHY_CTRL1_PHY_LOS_BIAS_GET(x)                                     (((x) & PCIE_PHY_CTRL1_PHY_LOS_BIAS_MASK) >> PCIE_PHY_CTRL1_PHY_LOS_BIAS_LSB)
#define PCIE_PHY_CTRL1_PHY_LOS_BIAS_SET(x)                                     (((0 | (x)) << PCIE_PHY_CTRL1_PHY_LOS_BIAS_LSB) & PCIE_PHY_CTRL1_PHY_LOS_BIAS_MASK)
#define PCIE_PHY_CTRL1_PHY_LOS_BIAS_RESET                                      0x2
#define PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_LSB                                  0
#define PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_MSB                                  0
#define PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_MASK                                 0x1
#define PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_GET(x)                               (((x) & PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_MASK) >> PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_LSB)
#define PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_SET(x)                               (((0 | (x)) << PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_LSB) & PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_MASK)
#define PCIE_PHY_CTRL1_PIPE0_TX2RX_LOOPBK_RESET                                0x0
#define PCIE_PHY_CTRL1_ADDRESS                                                 (0x48 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_PHY_CTRL1_RSTMASK                                                 0x7fffffff
#define PCIE_PHY_CTRL1_RESET                                                   0x1581544

// 0x4c (PCIE_PHY_CTRL2)
#define PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_LSB                                   14
#define PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_MSB                                   16
#define PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_MASK                                  0x1c000
#define PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_GET(x)                                (((x) & PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_MASK) >> PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_LSB)
#define PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_SET(x)                                (((0 | (x)) << PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_LSB) & PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_MASK)
#define PCIE_PHY_CTRL2_PHY_TX_VBOOST_LVL_RESET                                 0x4
#define PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_LSB                                    7
#define PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_MSB                                    13
#define PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_MASK                                   0x3f80
#define PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_GET(x)                                 (((x) & PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_MASK) >> PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_LSB)
#define PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_SET(x)                                 (((0 | (x)) << PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_LSB) & PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_MASK)
#define PCIE_PHY_CTRL2_PCS_TX_SWING_LOW_RESET                                  0x73
#define PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_LSB                                   0
#define PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_MSB                                   6
#define PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_MASK                                  0x7f
#define PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_GET(x)                                (((x) & PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_MASK) >> PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_LSB)
#define PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_SET(x)                                (((0 | (x)) << PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_LSB) & PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_MASK)
#define PCIE_PHY_CTRL2_PCS_TX_SWING_FULL_RESET                                 0x73
#define PCIE_PHY_CTRL2_ADDRESS                                                 (0x4c + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_PHY_CTRL2_RSTMASK                                                 0x1ffff
#define PCIE_PHY_CTRL2_RESET                                                   0x139f3

// 0x50 (PCIE_CORE_CTRL1)
#define PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_LSB                            30
#define PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_MSB                            31
#define PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_MASK                           0xc0000000
#define PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_GET(x)                         (((x) & PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_MASK) >> PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_LSB)
#define PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_SET(x)                         (((0 | (x)) << PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_LSB) & PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_MASK)
#define PCIE_CORE_CTRL1_SINGLE_PORT_READ_TIMING_RESET                          0x1
#define PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_LSB                           28
#define PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_MSB                           29
#define PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_MASK                          0x30000000
#define PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_GET(x)                        (((x) & PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_MASK) >> PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_LSB)
#define PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_SET(x)                        (((0 | (x)) << PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_LSB) & PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_MASK)
#define PCIE_CORE_CTRL1_SINGLE_PORT_WRITE_TIMING_RESET                         0x1
#define PCIE_CORE_CTRL1_TARGET_L1_EN_LSB                                       27
#define PCIE_CORE_CTRL1_TARGET_L1_EN_MSB                                       27
#define PCIE_CORE_CTRL1_TARGET_L1_EN_MASK                                      0x8000000
#define PCIE_CORE_CTRL1_TARGET_L1_EN_GET(x)                                    (((x) & PCIE_CORE_CTRL1_TARGET_L1_EN_MASK) >> PCIE_CORE_CTRL1_TARGET_L1_EN_LSB)
#define PCIE_CORE_CTRL1_TARGET_L1_EN_SET(x)                                    (((0 | (x)) << PCIE_CORE_CTRL1_TARGET_L1_EN_LSB) & PCIE_CORE_CTRL1_TARGET_L1_EN_MASK)
#define PCIE_CORE_CTRL1_TARGET_L1_EN_RESET                                     0x0
#define PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_LSB                                     26
#define PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_MSB                                     26
#define PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_MASK                                    0x4000000
#define PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_GET(x)                                  (((x) & PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_MASK) >> PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_LSB)
#define PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_SET(x)                                  (((0 | (x)) << PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_LSB) & PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_MASK)
#define PCIE_CORE_CTRL1_RX_Q_NOT_EMPTY_RESET                                   0x0
#define PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_LSB                             25
#define PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_MSB                             25
#define PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_MASK                            0x2000000
#define PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_GET(x)                          (((x) & PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_MASK) >> PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_LSB)
#define PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_SET(x)                          (((0 | (x)) << PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_LSB) & PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_MASK)
#define PCIE_CORE_CTRL1_LINK_TIMEOUT_FLUSH_NOT_RESET                           0x1
#define PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_LSB             24
#define PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_MSB             24
#define PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_MASK            0x1000000
#define PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_GET(x)          (((x) & PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_MASK) >> PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_LSB)
#define PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_SET(x)          (((0 | (x)) << PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_LSB) & PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_MASK)
#define PCIE_CORE_CTRL1_MAN_L1_MAC_POWERDOWN_OVERRIDE_TO_P2_EN_RESET           0x1
#define PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_LSB                           23
#define PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_MSB                           23
#define PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_MASK                          0x800000
#define PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_GET(x)                        (((x) & PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_MASK) >> PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_LSB)
#define PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_SET(x)                        (((0 | (x)) << PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_LSB) & PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_MASK)
#define PCIE_CORE_CTRL1_MAN_L1_AUX_CLK_SWITCH_EN_RESET                         0x1
#define PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_LSB                                    20
#define PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_MSB                                    22
#define PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_MASK                                   0x700000
#define PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_GET(x)                                 (((x) & PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_MASK) >> PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_LSB)
#define PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_SET(x)                                 (((0 | (x)) << PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_LSB) & PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_MASK)
#define PCIE_CORE_CTRL1_TX_PIPE_OBS_SEL_RESET                                  0x0
#define PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_LSB                                    18
#define PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_MSB                                    19
#define PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_MASK                                   0xc0000
#define PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_GET(x)                                 (((x) & PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_MASK) >> PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_LSB)
#define PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_SET(x)                                 (((0 | (x)) << PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_LSB) & PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_MASK)
#define PCIE_CORE_CTRL1_RX_PIPE_OBS_SEL_RESET                                  0x0
#define PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_LSB                                 8
#define PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_MSB                                 17
#define PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_MASK                                0x3ff00
#define PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_GET(x)                              (((x) & PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_MASK) >> PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_LSB)
#define PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_SET(x)                              (((0 | (x)) << PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_LSB) & PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_MASK)
#define PCIE_CORE_CTRL1_CORE_DEBUG_BUS_SEL_RESET                               0x0
#define PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_LSB                         3
#define PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_MSB                         3
#define PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_MASK                        0x8
#define PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_GET(x)                      (((x) & PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_MASK) >> PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_LSB)
#define PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_SET(x)                      (((0 | (x)) << PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_LSB) & PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_MASK)
#define PCIE_CORE_CTRL1_DIAGNOSTICS_FAST_LINK_MODE_RESET                       0x0
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_LSB                        2
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_MSB                        2
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_MASK                       0x4
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_GET(x)                     (((x) & PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_MASK) >> PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_LSB)
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_SET(x)                     (((0 | (x)) << PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_LSB) & PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_MASK)
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_ECRC_ERR_RESET                      0x0
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_LSB                        1
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_MSB                        1
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_MASK                       0x2
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_GET(x)                     (((x) & PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_MASK) >> PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_LSB)
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_SET(x)                     (((0 | (x)) << PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_LSB) & PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_MASK)
#define PCIE_CORE_CTRL1_DIAGNOSTICS_INSERT_LCRC_ERR_RESET                      0x0
#define PCIE_CORE_CTRL1_APP_CLK_PM_EN_LSB                                      0
#define PCIE_CORE_CTRL1_APP_CLK_PM_EN_MSB                                      0
#define PCIE_CORE_CTRL1_APP_CLK_PM_EN_MASK                                     0x1
#define PCIE_CORE_CTRL1_APP_CLK_PM_EN_GET(x)                                   (((x) & PCIE_CORE_CTRL1_APP_CLK_PM_EN_MASK) >> PCIE_CORE_CTRL1_APP_CLK_PM_EN_LSB)
#define PCIE_CORE_CTRL1_APP_CLK_PM_EN_SET(x)                                   (((0 | (x)) << PCIE_CORE_CTRL1_APP_CLK_PM_EN_LSB) & PCIE_CORE_CTRL1_APP_CLK_PM_EN_MASK)
#define PCIE_CORE_CTRL1_APP_CLK_PM_EN_RESET                                    0x0
#define PCIE_CORE_CTRL1_ADDRESS                                                (0x50 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_CORE_CTRL1_RSTMASK                                                0xffffff0f
#define PCIE_CORE_CTRL1_RESET                                                  0x53800000

// 0x54 (PCIE_WRAP_INTR_MASK)
#define PCIE_WRAP_INTR_MASK_CONTROL_LSB                                        0
#define PCIE_WRAP_INTR_MASK_CONTROL_MSB                                        31
#define PCIE_WRAP_INTR_MASK_CONTROL_MASK                                       0xffffffff
#define PCIE_WRAP_INTR_MASK_CONTROL_GET(x)                                     (((x) & PCIE_WRAP_INTR_MASK_CONTROL_MASK) >> PCIE_WRAP_INTR_MASK_CONTROL_LSB)
#define PCIE_WRAP_INTR_MASK_CONTROL_SET(x)                                     (((0 | (x)) << PCIE_WRAP_INTR_MASK_CONTROL_LSB) & PCIE_WRAP_INTR_MASK_CONTROL_MASK)
#define PCIE_WRAP_INTR_MASK_CONTROL_RESET                                      0x0
#define PCIE_WRAP_INTR_MASK_ADDRESS                                            (0x54 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_WRAP_INTR_MASK_RSTMASK                                            0xffffffff
#define PCIE_WRAP_INTR_MASK_RESET                                              0x0

// 0x58 (PCIE_WRAP_INTR_STATUS)
#define PCIE_WRAP_INTR_STATUS_VALUE_LSB                                        0
#define PCIE_WRAP_INTR_STATUS_VALUE_MSB                                        31
#define PCIE_WRAP_INTR_STATUS_VALUE_MASK                                       0xffffffff
#define PCIE_WRAP_INTR_STATUS_VALUE_GET(x)                                     (((x) & PCIE_WRAP_INTR_STATUS_VALUE_MASK) >> PCIE_WRAP_INTR_STATUS_VALUE_LSB)
#define PCIE_WRAP_INTR_STATUS_VALUE_SET(x)                                     (((0 | (x)) << PCIE_WRAP_INTR_STATUS_VALUE_LSB) & PCIE_WRAP_INTR_STATUS_VALUE_MASK)
#define PCIE_WRAP_INTR_STATUS_VALUE_RESET                                      0x0
#define PCIE_WRAP_INTR_STATUS_ADDRESS                                          (0x58 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_WRAP_INTR_STATUS_RSTMASK                                          0xffffffff
#define PCIE_WRAP_INTR_STATUS_RESET                                            0x0

// 0x5c (PCIE_SCRATCH_2)
#define PCIE_SCRATCH_2_VALUE_LSB                                               0
#define PCIE_SCRATCH_2_VALUE_MSB                                               31
#define PCIE_SCRATCH_2_VALUE_MASK                                              0xffffffff
#define PCIE_SCRATCH_2_VALUE_GET(x)                                            (((x) & PCIE_SCRATCH_2_VALUE_MASK) >> PCIE_SCRATCH_2_VALUE_LSB)
#define PCIE_SCRATCH_2_VALUE_SET(x)                                            (((0 | (x)) << PCIE_SCRATCH_2_VALUE_LSB) & PCIE_SCRATCH_2_VALUE_MASK)
#define PCIE_SCRATCH_2_VALUE_RESET                                             0x0
#define PCIE_SCRATCH_2_ADDRESS                                                 (0x5c + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_SCRATCH_2_RSTMASK                                                 0xffffffff
#define PCIE_SCRATCH_2_RESET                                                   0x0

// 0x60 (PCIE_MSI_ADDR_UPPER)
#define PCIE_MSI_ADDR_UPPER_HIGH_LSB                                           0
#define PCIE_MSI_ADDR_UPPER_HIGH_MSB                                           31
#define PCIE_MSI_ADDR_UPPER_HIGH_MASK                                          0xffffffff
#define PCIE_MSI_ADDR_UPPER_HIGH_GET(x)                                        (((x) & PCIE_MSI_ADDR_UPPER_HIGH_MASK) >> PCIE_MSI_ADDR_UPPER_HIGH_LSB)
#define PCIE_MSI_ADDR_UPPER_HIGH_SET(x)                                        (((0 | (x)) << PCIE_MSI_ADDR_UPPER_HIGH_LSB) & PCIE_MSI_ADDR_UPPER_HIGH_MASK)
#define PCIE_MSI_ADDR_UPPER_HIGH_RESET                                         0x0
#define PCIE_MSI_ADDR_UPPER_ADDRESS                                            (0x60 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_MSI_ADDR_UPPER_RSTMASK                                            0xffffffff
#define PCIE_MSI_ADDR_UPPER_RESET                                              0x0

// 0x64 (PCIE_BAR0_START_UPPER)
#define PCIE_BAR0_START_UPPER_VAL_LSB                                          0
#define PCIE_BAR0_START_UPPER_VAL_MSB                                          31
#define PCIE_BAR0_START_UPPER_VAL_MASK                                         0xffffffff
#define PCIE_BAR0_START_UPPER_VAL_GET(x)                                       (((x) & PCIE_BAR0_START_UPPER_VAL_MASK) >> PCIE_BAR0_START_UPPER_VAL_LSB)
#define PCIE_BAR0_START_UPPER_VAL_SET(x)                                       (((0 | (x)) << PCIE_BAR0_START_UPPER_VAL_LSB) & PCIE_BAR0_START_UPPER_VAL_MASK)
#define PCIE_BAR0_START_UPPER_VAL_RESET                                        0x0
#define PCIE_BAR0_START_UPPER_ADDRESS                                          (0x64 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_BAR0_START_UPPER_RSTMASK                                          0xffffffff
#define PCIE_BAR0_START_UPPER_RESET                                            0x0

// 0x68 (PCIE_BAR0_LIMIT_UPPER)
#define PCIE_BAR0_LIMIT_UPPER_VAL_LSB                                          0
#define PCIE_BAR0_LIMIT_UPPER_VAL_MSB                                          31
#define PCIE_BAR0_LIMIT_UPPER_VAL_MASK                                         0xffffffff
#define PCIE_BAR0_LIMIT_UPPER_VAL_GET(x)                                       (((x) & PCIE_BAR0_LIMIT_UPPER_VAL_MASK) >> PCIE_BAR0_LIMIT_UPPER_VAL_LSB)
#define PCIE_BAR0_LIMIT_UPPER_VAL_SET(x)                                       (((0 | (x)) << PCIE_BAR0_LIMIT_UPPER_VAL_LSB) & PCIE_BAR0_LIMIT_UPPER_VAL_MASK)
#define PCIE_BAR0_LIMIT_UPPER_VAL_RESET                                        0x0
#define PCIE_BAR0_LIMIT_UPPER_ADDRESS                                          (0x68 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_BAR0_LIMIT_UPPER_RSTMASK                                          0xffffffff
#define PCIE_BAR0_LIMIT_UPPER_RESET                                            0x0

// 0x6c (PCIE_CPL_TIMEOUT)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_LSB                              21
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_MSB                              28
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_MASK                             0x1fe00000
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_GET(x)                           (((x) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_MASK) >> PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_LSB)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_SET(x)                           (((0 | (x)) << PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_LSB) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_MASK)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TAG_RESET                            0x0
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_LSB                              9
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_MSB                              20
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_MASK                             0x1ffe00
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_GET(x)                           (((x) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_MASK) >> PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_LSB)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_SET(x)                           (((0 | (x)) << PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_LSB) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_MASK)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_LEN_RESET                            0x0
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_LSB                             7
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_MSB                             8
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_MASK                            0x180
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_GET(x)                          (((x) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_MASK) >> PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_LSB)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_SET(x)                          (((0 | (x)) << PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_LSB) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_MASK)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_ATTR_RESET                           0x0
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_LSB                               4
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_MSB                               6
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_MASK                              0x70
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_GET(x)                            (((x) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_MASK) >> PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_LSB)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_SET(x)                            (((0 | (x)) << PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_LSB) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_MASK)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_CPL_TC_RESET                             0x0
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_LSB                             1
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_MSB                             3
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_MASK                            0xe
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_GET(x)                          (((x) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_MASK) >> PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_LSB)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_SET(x)                          (((0 | (x)) << PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_LSB) & PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_MASK)
#define PCIE_CPL_TIMEOUT_RADM_TIMEOUT_FUNC_NUM_RESET                           0x0
#define PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_LSB                                  0
#define PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_MSB                                  0
#define PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_MASK                                 0x1
#define PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_GET(x)                               (((x) & PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_MASK) >> PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_LSB)
#define PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_SET(x)                               (((0 | (x)) << PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_LSB) & PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_MASK)
#define PCIE_CPL_TIMEOUT_RADM_CPL_TIMEOUT_RESET                                0x0
#define PCIE_CPL_TIMEOUT_ADDRESS                                               (0x6c + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_CPL_TIMEOUT_RSTMASK                                               0x1fffffff
#define PCIE_CPL_TIMEOUT_RESET                                                 0x0

// 0x70 (PCIE_RX_NFTS_PATCH)
#define PCIE_RX_NFTS_PATCH_EN_LSB                                              31
#define PCIE_RX_NFTS_PATCH_EN_MSB                                              31
#define PCIE_RX_NFTS_PATCH_EN_MASK                                             0x80000000
#define PCIE_RX_NFTS_PATCH_EN_GET(x)                                           (((x) & PCIE_RX_NFTS_PATCH_EN_MASK) >> PCIE_RX_NFTS_PATCH_EN_LSB)
#define PCIE_RX_NFTS_PATCH_EN_SET(x)                                           (((0 | (x)) << PCIE_RX_NFTS_PATCH_EN_LSB) & PCIE_RX_NFTS_PATCH_EN_MASK)
#define PCIE_RX_NFTS_PATCH_EN_RESET                                            0x0
#define PCIE_RX_NFTS_PATCH_GEN2_EN_LSB                                         30
#define PCIE_RX_NFTS_PATCH_GEN2_EN_MSB                                         30
#define PCIE_RX_NFTS_PATCH_GEN2_EN_MASK                                        0x40000000
#define PCIE_RX_NFTS_PATCH_GEN2_EN_GET(x)                                      (((x) & PCIE_RX_NFTS_PATCH_GEN2_EN_MASK) >> PCIE_RX_NFTS_PATCH_GEN2_EN_LSB)
#define PCIE_RX_NFTS_PATCH_GEN2_EN_SET(x)                                      (((0 | (x)) << PCIE_RX_NFTS_PATCH_GEN2_EN_LSB) & PCIE_RX_NFTS_PATCH_GEN2_EN_MASK)
#define PCIE_RX_NFTS_PATCH_GEN2_EN_RESET                                       0x0
#define PCIE_RX_NFTS_PATCH_GEN2_VAL_LSB                                        8
#define PCIE_RX_NFTS_PATCH_GEN2_VAL_MSB                                        15
#define PCIE_RX_NFTS_PATCH_GEN2_VAL_MASK                                       0xff00
#define PCIE_RX_NFTS_PATCH_GEN2_VAL_GET(x)                                     (((x) & PCIE_RX_NFTS_PATCH_GEN2_VAL_MASK) >> PCIE_RX_NFTS_PATCH_GEN2_VAL_LSB)
#define PCIE_RX_NFTS_PATCH_GEN2_VAL_SET(x)                                     (((0 | (x)) << PCIE_RX_NFTS_PATCH_GEN2_VAL_LSB) & PCIE_RX_NFTS_PATCH_GEN2_VAL_MASK)
#define PCIE_RX_NFTS_PATCH_GEN2_VAL_RESET                                      0x3f
#define PCIE_RX_NFTS_PATCH_VAL_LSB                                             0
#define PCIE_RX_NFTS_PATCH_VAL_MSB                                             7
#define PCIE_RX_NFTS_PATCH_VAL_MASK                                            0xff
#define PCIE_RX_NFTS_PATCH_VAL_GET(x)                                          (((x) & PCIE_RX_NFTS_PATCH_VAL_MASK) >> PCIE_RX_NFTS_PATCH_VAL_LSB)
#define PCIE_RX_NFTS_PATCH_VAL_SET(x)                                          (((0 | (x)) << PCIE_RX_NFTS_PATCH_VAL_LSB) & PCIE_RX_NFTS_PATCH_VAL_MASK)
#define PCIE_RX_NFTS_PATCH_VAL_RESET                                           0x3f
#define PCIE_RX_NFTS_PATCH_ADDRESS                                             (0x70 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_RX_NFTS_PATCH_RSTMASK                                             0xc000ffff
#define PCIE_RX_NFTS_PATCH_RESET                                               0x3f3f

// 0x74 (PCIE_RX_NFTS_TMO)
#define PCIE_RX_NFTS_TMO_CLR_LSB                                               31
#define PCIE_RX_NFTS_TMO_CLR_MSB                                               31
#define PCIE_RX_NFTS_TMO_CLR_MASK                                              0x80000000
#define PCIE_RX_NFTS_TMO_CLR_GET(x)                                            (((x) & PCIE_RX_NFTS_TMO_CLR_MASK) >> PCIE_RX_NFTS_TMO_CLR_LSB)
#define PCIE_RX_NFTS_TMO_CLR_SET(x)                                            (((0 | (x)) << PCIE_RX_NFTS_TMO_CLR_LSB) & PCIE_RX_NFTS_TMO_CLR_MASK)
#define PCIE_RX_NFTS_TMO_CLR_RESET                                             0x0
#define PCIE_RX_NFTS_TMO_CNT_LSB                                               0
#define PCIE_RX_NFTS_TMO_CNT_MSB                                               15
#define PCIE_RX_NFTS_TMO_CNT_MASK                                              0xffff
#define PCIE_RX_NFTS_TMO_CNT_GET(x)                                            (((x) & PCIE_RX_NFTS_TMO_CNT_MASK) >> PCIE_RX_NFTS_TMO_CNT_LSB)
#define PCIE_RX_NFTS_TMO_CNT_SET(x)                                            (((0 | (x)) << PCIE_RX_NFTS_TMO_CNT_LSB) & PCIE_RX_NFTS_TMO_CNT_MASK)
#define PCIE_RX_NFTS_TMO_CNT_RESET                                             0x0
#define PCIE_RX_NFTS_TMO_ADDRESS                                               (0x74 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_RX_NFTS_TMO_RSTMASK                                               0x8000ffff
#define PCIE_RX_NFTS_TMO_RESET                                                 0x0

// 0x78 (PCIE_CORE_CTRL2)
#define PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_LSB                                16
#define PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_MSB                                16
#define PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_MASK                               0x10000
#define PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_GET(x)                             (((x) & PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_MASK) >> PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_LSB)
#define PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_SET(x)                             (((0 | (x)) << PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_LSB) & PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_MASK)
#define PCIE_CORE_CTRL2_HW_AUTO_SP_DIS_OVRD_RESET                              0x0
#define PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_LSB                                  0
#define PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_MSB                                  7
#define PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_MASK                                 0xff
#define PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_GET(x)                               (((x) & PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_MASK) >> PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_LSB)
#define PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_SET(x)                               (((0 | (x)) << PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_LSB) & PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_MASK)
#define PCIE_CORE_CTRL2_L1_INTX_DELAY_VAL_RESET                                0xa
#define PCIE_CORE_CTRL2_ADDRESS                                                (0x78 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_CORE_CTRL2_RSTMASK                                                0x100ff
#define PCIE_CORE_CTRL2_RESET                                                  0xa

// 0x7c (PCIE_IDLE_DLY)
#define PCIE_IDLE_DLY_IDLE_DLY_EN_LSB                                          31
#define PCIE_IDLE_DLY_IDLE_DLY_EN_MSB                                          31
#define PCIE_IDLE_DLY_IDLE_DLY_EN_MASK                                         0x80000000
#define PCIE_IDLE_DLY_IDLE_DLY_EN_GET(x)                                       (((x) & PCIE_IDLE_DLY_IDLE_DLY_EN_MASK) >> PCIE_IDLE_DLY_IDLE_DLY_EN_LSB)
#define PCIE_IDLE_DLY_IDLE_DLY_EN_SET(x)                                       (((0 | (x)) << PCIE_IDLE_DLY_IDLE_DLY_EN_LSB) & PCIE_IDLE_DLY_IDLE_DLY_EN_MASK)
#define PCIE_IDLE_DLY_IDLE_DLY_EN_RESET                                        0x0
#define PCIE_IDLE_DLY_IDLE_DLY_CLR_LSB                                         30
#define PCIE_IDLE_DLY_IDLE_DLY_CLR_MSB                                         30
#define PCIE_IDLE_DLY_IDLE_DLY_CLR_MASK                                        0x40000000
#define PCIE_IDLE_DLY_IDLE_DLY_CLR_GET(x)                                      (((x) & PCIE_IDLE_DLY_IDLE_DLY_CLR_MASK) >> PCIE_IDLE_DLY_IDLE_DLY_CLR_LSB)
#define PCIE_IDLE_DLY_IDLE_DLY_CLR_SET(x)                                      (((0 | (x)) << PCIE_IDLE_DLY_IDLE_DLY_CLR_LSB) & PCIE_IDLE_DLY_IDLE_DLY_CLR_MASK)
#define PCIE_IDLE_DLY_IDLE_DLY_CLR_RESET                                       0x0
#define PCIE_IDLE_DLY_IDLE_DLY_SCALE_LSB                                       16
#define PCIE_IDLE_DLY_IDLE_DLY_SCALE_MSB                                       19
#define PCIE_IDLE_DLY_IDLE_DLY_SCALE_MASK                                      0xf0000
#define PCIE_IDLE_DLY_IDLE_DLY_SCALE_GET(x)                                    (((x) & PCIE_IDLE_DLY_IDLE_DLY_SCALE_MASK) >> PCIE_IDLE_DLY_IDLE_DLY_SCALE_LSB)
#define PCIE_IDLE_DLY_IDLE_DLY_SCALE_SET(x)                                    (((0 | (x)) << PCIE_IDLE_DLY_IDLE_DLY_SCALE_LSB) & PCIE_IDLE_DLY_IDLE_DLY_SCALE_MASK)
#define PCIE_IDLE_DLY_IDLE_DLY_SCALE_RESET                                     0x0
#define PCIE_IDLE_DLY_IDLE_DLY_VALUE_LSB                                       0
#define PCIE_IDLE_DLY_IDLE_DLY_VALUE_MSB                                       15
#define PCIE_IDLE_DLY_IDLE_DLY_VALUE_MASK                                      0xffff
#define PCIE_IDLE_DLY_IDLE_DLY_VALUE_GET(x)                                    (((x) & PCIE_IDLE_DLY_IDLE_DLY_VALUE_MASK) >> PCIE_IDLE_DLY_IDLE_DLY_VALUE_LSB)
#define PCIE_IDLE_DLY_IDLE_DLY_VALUE_SET(x)                                    (((0 | (x)) << PCIE_IDLE_DLY_IDLE_DLY_VALUE_LSB) & PCIE_IDLE_DLY_IDLE_DLY_VALUE_MASK)
#define PCIE_IDLE_DLY_IDLE_DLY_VALUE_RESET                                     0x0
#define PCIE_IDLE_DLY_ADDRESS                                                  (0x7c + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_IDLE_DLY_RSTMASK                                                  0xc00fffff
#define PCIE_IDLE_DLY_RESET                                                    0x0

// 0x80 (PCIE_WRAP_INTR_HOST_MASK)
#define PCIE_WRAP_INTR_HOST_MASK_CONTROL_LSB                                   0
#define PCIE_WRAP_INTR_HOST_MASK_CONTROL_MSB                                   31
#define PCIE_WRAP_INTR_HOST_MASK_CONTROL_MASK                                  0xffffffff
#define PCIE_WRAP_INTR_HOST_MASK_CONTROL_GET(x)                                (((x) & PCIE_WRAP_INTR_HOST_MASK_CONTROL_MASK) >> PCIE_WRAP_INTR_HOST_MASK_CONTROL_LSB)
#define PCIE_WRAP_INTR_HOST_MASK_CONTROL_SET(x)                                (((0 | (x)) << PCIE_WRAP_INTR_HOST_MASK_CONTROL_LSB) & PCIE_WRAP_INTR_HOST_MASK_CONTROL_MASK)
#define PCIE_WRAP_INTR_HOST_MASK_CONTROL_RESET                                 0x0
#define PCIE_WRAP_INTR_HOST_MASK_ADDRESS                                       (0x80 + __SOC_PCIE_REG_BASE_ADDRESS)
#define PCIE_WRAP_INTR_HOST_MASK_RSTMASK                                       0xffffffff
#define PCIE_WRAP_INTR_HOST_MASK_RESET                                         0x0



#endif /* _SOC_PCIE_REG_H_ */
