// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _VHT_SIG_B_SU80_H_
#define _VHT_SIG_B_SU80_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	length[20:0], vhtb_reserved[22:21], tail[28:23], reserved_0[30:29], rx_ndp[31]
//	1	length_copy_a[20:0], vhtb_reserved_copy_a[22:21], tail_copy_a[28:23], reserved_1[30:29], rx_ndp_copy_a[31]
//	2	length_copy_b[20:0], vhtb_reserved_copy_b[22:21], tail_copy_b[28:23], reserved_2[30:29], rx_ndp_copy_b[31]
//	3	length_copy_c[20:0], vhtb_reserved_copy_c[22:21], tail_copy_c[28:23], reserved_3[30:29], rx_ndp_copy_c[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_VHT_SIG_B_SU80 4

struct vht_sig_b_su80 {
    volatile uint32_t length                          : 21, //[20:0]
                      vhtb_reserved                   :  2, //[22:21]
                      tail                            :  6, //[28:23]
                      reserved_0                      :  2, //[30:29]
                      rx_ndp                          :  1; //[31]
    volatile uint32_t length_copy_a                   : 21, //[20:0]
                      vhtb_reserved_copy_a            :  2, //[22:21]
                      tail_copy_a                     :  6, //[28:23]
                      reserved_1                      :  2, //[30:29]
                      rx_ndp_copy_a                   :  1; //[31]
    volatile uint32_t length_copy_b                   : 21, //[20:0]
                      vhtb_reserved_copy_b            :  2, //[22:21]
                      tail_copy_b                     :  6, //[28:23]
                      reserved_2                      :  2, //[30:29]
                      rx_ndp_copy_b                   :  1; //[31]
    volatile uint32_t length_copy_c                   : 21, //[20:0]
                      vhtb_reserved_copy_c            :  2, //[22:21]
                      tail_copy_c                     :  6, //[28:23]
                      reserved_3                      :  2, //[30:29]
                      rx_ndp_copy_c                   :  1; //[31]
};

/*

length
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)
			
			<legal all>

vhtb_reserved
			
			Reserved:  Set  to all ones for non-NDP frames and
			ignored on receive  <legal 1,3>

tail
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>

reserved_0
			
			Not part of VHT-SIG-B.
			
			Reserved: Set to 0 and ignored on receive  <legal 0>

rx_ndp
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>

length_copy_a
			
			Same as length <legal all>

vhtb_reserved_copy_a
			
			Same as vhtb_reserved  <legal 1,3>

tail_copy_a
			
			Same as tail  <legal 0>

reserved_1
			
			Reserved: Set to 0 and ignored on receive  <legal 0>

rx_ndp_copy_a
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>

length_copy_b
			
			Same as length <legal all>

vhtb_reserved_copy_b
			
			Same as vhtb_reserved  <legal 1,3>

tail_copy_b
			
			Same as tail  <legal 0>

reserved_2
			
			Reserved: Set to 0 and ignored on receive <legal 0>

rx_ndp_copy_b
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>

length_copy_c
			
			Same as length <legal all>

vhtb_reserved_copy_c
			
			Same as vhtb_reserved  <legal 1,3>

tail_copy_c
			
			Same as tail  <legal 0>

reserved_3
			
			Reserved: Set to 0 and ignored on receive <legal 0>

rx_ndp_copy_c
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/


/* Description		VHT_SIG_B_SU80_0_LENGTH
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)
			
			<legal all>
*/
#define VHT_SIG_B_SU80_0_LENGTH_OFFSET                               0x00000000
#define VHT_SIG_B_SU80_0_LENGTH_LSB                                  0
#define VHT_SIG_B_SU80_0_LENGTH_MASK                                 0x001fffff

/* Description		VHT_SIG_B_SU80_0_VHTB_RESERVED
			
			Reserved:  Set  to all ones for non-NDP frames and
			ignored on receive  <legal 1,3>
*/
#define VHT_SIG_B_SU80_0_VHTB_RESERVED_OFFSET                        0x00000000
#define VHT_SIG_B_SU80_0_VHTB_RESERVED_LSB                           21
#define VHT_SIG_B_SU80_0_VHTB_RESERVED_MASK                          0x00600000

/* Description		VHT_SIG_B_SU80_0_TAIL
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>
*/
#define VHT_SIG_B_SU80_0_TAIL_OFFSET                                 0x00000000
#define VHT_SIG_B_SU80_0_TAIL_LSB                                    23
#define VHT_SIG_B_SU80_0_TAIL_MASK                                   0x1f800000

/* Description		VHT_SIG_B_SU80_0_RESERVED_0
			
			Not part of VHT-SIG-B.
			
			Reserved: Set to 0 and ignored on receive  <legal 0>
*/
#define VHT_SIG_B_SU80_0_RESERVED_0_OFFSET                           0x00000000
#define VHT_SIG_B_SU80_0_RESERVED_0_LSB                              29
#define VHT_SIG_B_SU80_0_RESERVED_0_MASK                             0x60000000

/* Description		VHT_SIG_B_SU80_0_RX_NDP
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/
#define VHT_SIG_B_SU80_0_RX_NDP_OFFSET                               0x00000000
#define VHT_SIG_B_SU80_0_RX_NDP_LSB                                  31
#define VHT_SIG_B_SU80_0_RX_NDP_MASK                                 0x80000000

/* Description		VHT_SIG_B_SU80_1_LENGTH_COPY_A
			
			Same as length <legal all>
*/
#define VHT_SIG_B_SU80_1_LENGTH_COPY_A_OFFSET                        0x00000004
#define VHT_SIG_B_SU80_1_LENGTH_COPY_A_LSB                           0
#define VHT_SIG_B_SU80_1_LENGTH_COPY_A_MASK                          0x001fffff

/* Description		VHT_SIG_B_SU80_1_VHTB_RESERVED_COPY_A
			
			Same as vhtb_reserved  <legal 1,3>
*/
#define VHT_SIG_B_SU80_1_VHTB_RESERVED_COPY_A_OFFSET                 0x00000004
#define VHT_SIG_B_SU80_1_VHTB_RESERVED_COPY_A_LSB                    21
#define VHT_SIG_B_SU80_1_VHTB_RESERVED_COPY_A_MASK                   0x00600000

/* Description		VHT_SIG_B_SU80_1_TAIL_COPY_A
			
			Same as tail  <legal 0>
*/
#define VHT_SIG_B_SU80_1_TAIL_COPY_A_OFFSET                          0x00000004
#define VHT_SIG_B_SU80_1_TAIL_COPY_A_LSB                             23
#define VHT_SIG_B_SU80_1_TAIL_COPY_A_MASK                            0x1f800000

/* Description		VHT_SIG_B_SU80_1_RESERVED_1
			
			Reserved: Set to 0 and ignored on receive  <legal 0>
*/
#define VHT_SIG_B_SU80_1_RESERVED_1_OFFSET                           0x00000004
#define VHT_SIG_B_SU80_1_RESERVED_1_LSB                              29
#define VHT_SIG_B_SU80_1_RESERVED_1_MASK                             0x60000000

/* Description		VHT_SIG_B_SU80_1_RX_NDP_COPY_A
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/
#define VHT_SIG_B_SU80_1_RX_NDP_COPY_A_OFFSET                        0x00000004
#define VHT_SIG_B_SU80_1_RX_NDP_COPY_A_LSB                           31
#define VHT_SIG_B_SU80_1_RX_NDP_COPY_A_MASK                          0x80000000

/* Description		VHT_SIG_B_SU80_2_LENGTH_COPY_B
			
			Same as length <legal all>
*/
#define VHT_SIG_B_SU80_2_LENGTH_COPY_B_OFFSET                        0x00000008
#define VHT_SIG_B_SU80_2_LENGTH_COPY_B_LSB                           0
#define VHT_SIG_B_SU80_2_LENGTH_COPY_B_MASK                          0x001fffff

/* Description		VHT_SIG_B_SU80_2_VHTB_RESERVED_COPY_B
			
			Same as vhtb_reserved  <legal 1,3>
*/
#define VHT_SIG_B_SU80_2_VHTB_RESERVED_COPY_B_OFFSET                 0x00000008
#define VHT_SIG_B_SU80_2_VHTB_RESERVED_COPY_B_LSB                    21
#define VHT_SIG_B_SU80_2_VHTB_RESERVED_COPY_B_MASK                   0x00600000

/* Description		VHT_SIG_B_SU80_2_TAIL_COPY_B
			
			Same as tail  <legal 0>
*/
#define VHT_SIG_B_SU80_2_TAIL_COPY_B_OFFSET                          0x00000008
#define VHT_SIG_B_SU80_2_TAIL_COPY_B_LSB                             23
#define VHT_SIG_B_SU80_2_TAIL_COPY_B_MASK                            0x1f800000

/* Description		VHT_SIG_B_SU80_2_RESERVED_2
			
			Reserved: Set to 0 and ignored on receive <legal 0>
*/
#define VHT_SIG_B_SU80_2_RESERVED_2_OFFSET                           0x00000008
#define VHT_SIG_B_SU80_2_RESERVED_2_LSB                              29
#define VHT_SIG_B_SU80_2_RESERVED_2_MASK                             0x60000000

/* Description		VHT_SIG_B_SU80_2_RX_NDP_COPY_B
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/
#define VHT_SIG_B_SU80_2_RX_NDP_COPY_B_OFFSET                        0x00000008
#define VHT_SIG_B_SU80_2_RX_NDP_COPY_B_LSB                           31
#define VHT_SIG_B_SU80_2_RX_NDP_COPY_B_MASK                          0x80000000

/* Description		VHT_SIG_B_SU80_3_LENGTH_COPY_C
			
			Same as length <legal all>
*/
#define VHT_SIG_B_SU80_3_LENGTH_COPY_C_OFFSET                        0x0000000c
#define VHT_SIG_B_SU80_3_LENGTH_COPY_C_LSB                           0
#define VHT_SIG_B_SU80_3_LENGTH_COPY_C_MASK                          0x001fffff

/* Description		VHT_SIG_B_SU80_3_VHTB_RESERVED_COPY_C
			
			Same as vhtb_reserved  <legal 1,3>
*/
#define VHT_SIG_B_SU80_3_VHTB_RESERVED_COPY_C_OFFSET                 0x0000000c
#define VHT_SIG_B_SU80_3_VHTB_RESERVED_COPY_C_LSB                    21
#define VHT_SIG_B_SU80_3_VHTB_RESERVED_COPY_C_MASK                   0x00600000

/* Description		VHT_SIG_B_SU80_3_TAIL_COPY_C
			
			Same as tail  <legal 0>
*/
#define VHT_SIG_B_SU80_3_TAIL_COPY_C_OFFSET                          0x0000000c
#define VHT_SIG_B_SU80_3_TAIL_COPY_C_LSB                             23
#define VHT_SIG_B_SU80_3_TAIL_COPY_C_MASK                            0x1f800000

/* Description		VHT_SIG_B_SU80_3_RESERVED_3
			
			Reserved: Set to 0 and ignored on receive <legal 0>
*/
#define VHT_SIG_B_SU80_3_RESERVED_3_OFFSET                           0x0000000c
#define VHT_SIG_B_SU80_3_RESERVED_3_LSB                              29
#define VHT_SIG_B_SU80_3_RESERVED_3_MASK                             0x60000000

/* Description		VHT_SIG_B_SU80_3_RX_NDP_COPY_C
			
			Not part of VHT-SIG-B.
			
			Used to identify received NDP frame
			
			<legal 0,1>
*/
#define VHT_SIG_B_SU80_3_RX_NDP_COPY_C_OFFSET                        0x0000000c
#define VHT_SIG_B_SU80_3_RX_NDP_COPY_C_LSB                           31
#define VHT_SIG_B_SU80_3_RX_NDP_COPY_C_MASK                          0x80000000


#endif // _VHT_SIG_B_SU80_H_
