// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_PHY_DESC_H_
#define _TX_PHY_DESC_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	chain_mask[3:0], paprd_chain_mask[7:4], bf_type[9:8], wait_sifs[10], reserved_0b[14:11], dot11b_preamble_type[15], pkt_type[18:16], reserved_0c[20:19], bandwidth[22:21], ndp[23], reserved_0d[29:24], channel_capture[30], warm_tx[31]
//	1	tpc_init_pwr_cfg[2:0], dpd_enable[3], tx_pwr[10:4], clpc_enable[11], measure_power[12], reserved_1a[16:13], ibfcal_enable[17], mu_ndp[18], heavy_clip_nss[21:19], txbf_per_packet_no_csd_no_walsh[22], reserved_1b[31:23]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_PHY_DESC 2

struct tx_phy_desc {
    volatile uint32_t chain_mask                      :  4, //[3:0]
                      paprd_chain_mask                :  4, //[7:4]
                      bf_type                         :  2, //[9:8]
                      wait_sifs                       :  1, //[10]
                      reserved_0b                     :  4, //[14:11]
                      dot11b_preamble_type            :  1, //[15]
                      pkt_type                        :  3, //[18:16]
                      reserved_0c                     :  2, //[20:19]
                      bandwidth                       :  2, //[22:21]
                      ndp                             :  1, //[23]
                      reserved_0d                     :  6, //[29:24]
                      channel_capture                 :  1, //[30]
                      warm_tx                         :  1; //[31]
    volatile uint32_t tpc_init_pwr_cfg                :  3, //[2:0]
                      dpd_enable                      :  1, //[3]
                      tx_pwr                          :  7, //[10:4]
                      clpc_enable                     :  1, //[11]
                      measure_power                   :  1, //[12]
                      reserved_1a                     :  4, //[16:13]
                      ibfcal_enable                   :  1, //[17]
                      mu_ndp                          :  1, //[18]
                      heavy_clip_nss                  :  3, //[21:19]
                      txbf_per_packet_no_csd_no_walsh :  1, //[22]
                      reserved_1b                     :  9; //[31:23]
};

/*

chain_mask
			
			Chain mask to support up to 4 antennas.  <legal: 1-15>

paprd_chain_mask
			
			Chain mask for the PA predistortion function.  <legal:
			0,1,2,4,8>  

bf_type
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>

wait_sifs
			
			If set, the AMPI will hold this tx_phy_desc TLV from the
			TX PCU until SIFS has elapsed and then forward the
			tx_phy_desc to the PHY.  The PHY should ignore this bit. 
			This bit is used to make sure that transmit SIFS response to
			a receive frame is cycle accurate and consistent to enable
			accurate RTT measurement.   

reserved_0b
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>

dot11b_preamble_type
			
			Valid for 802.11b packets only.
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>

pkt_type
			
			Packet type:
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<enum 4     dot11n_gf>
			
			
			
			Note: HT Greenfield packet type is not supported.
			However, 3-bit field facilitates Greenfield packet
			generation in DV environment.
			
			<legal 0-4>

reserved_0c
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>

bandwidth
			
			Packet bandwidth:
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			For legacy packets, if this parameter is not set to 0,
			duplicate subbands shall be generated to fill the bandwidth
			specified. For instance, if (pkt_type == 3'h0) && (bandwidth
			== 2'h1), the PHY shall produce 2 duplicate 20MHz subbands
			to fill the 40MHz packet bandwidth.
			
			For OFDM legacy packets, enum value 0, 1, 2 are legal,
			i.e., 20MHz, duplicate 40MHz and duplicate 80MHz.
			
			For CCK legacy packets, only enum value 0 and 1 are
			legal, i.e., 20MHz and duplicate 40MHz, where  duplicate
			40MHz CCK legacy packet is not supported by standard spec
			but supported as proprietary feature. 
			
			For HT packets, enum value 0 and 1 are legal, i.e., HT20
			and HT40. 
			
			For VHT packets, enum value 0, 1 and 2 are legal, i.e.,
			VHT20, VHT40 and VHT80. 
			
			
			
			<legal 0-2>

ndp
			
			Flag to define NDP transmission  <legal 0-1>

reserved_0d
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>

channel_capture
			
			Indicates that the PHY should be armed to capture the
			channel on the next received packet. This channel estimate
			is passed to the MAC if the packet is successfully received.
			<legal 0-1>

warm_tx
			
			Indicates that this PPDU is being transmitted early in
			warm_tx mode. <legal 0-1>

tpc_init_pwr_cfg
			
			0~4: traverse mode
			
			Initial analog gain and PA configuration setting where 0
			has the highest power consumption and best EVM,  and 4 has
			the lowest power consumption and worst EVM 
			
			5~7: low power mode
			
			No traverse. Force TPC to select the specified GLUT set
			(5, 6 or 7) for the low power mode or other special
			purposes.
			
			<legal 0-7>

dpd_enable
			
			<enum 0     dpd_off> DPD profile not applied to current
			packet
			
			<enum 1     dpd_on> DPD profile applied to current
			packet if available
			
			<legal 0-1>

tx_pwr
			
			Transmit Power (signed value) in units of 0.5 dBm <legal
			all>

clpc_enable
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>

measure_power
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0     measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1     measure_en> TPC will latch power measurement
			result for current packet

reserved_1a
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>

ibfcal_enable
			
			Defines the current packet as test packet for implicit
			BF calibration purposes  <legal 0-1>

mu_ndp
			
			If set indicates that this packet is an NDP used for MU
			channel estimation.  This bit will be used by the TPC to
			signal that the analog gain settings can be updated. The
			analog gain settings will not change for subsequent MU data
			packets.

heavy_clip_nss
			
			Number of active spatial streams in current packet. This
			parameter is used by the heavy clip function in the
			transmitter. In case of MU PPDU, this is total Nss of all
			users. 
			
			0: 1 spatial stream
			
			1: 2 spatial stream
			
			2: 3 spatial stream
			
			3: 4 spatial stream
			
			4-7: Reserved
			
			<legal 0-3>

txbf_per_packet_no_csd_no_walsh
			
			If set, no_csd and no_walsh is applied to steering
			packet.

reserved_1b
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/


/* Description		TX_PHY_DESC_0_CHAIN_MASK
			
			Chain mask to support up to 4 antennas.  <legal: 1-15>
*/
#define TX_PHY_DESC_0_CHAIN_MASK_OFFSET                              0x00000000
#define TX_PHY_DESC_0_CHAIN_MASK_LSB                                 0
#define TX_PHY_DESC_0_CHAIN_MASK_MASK                                0x0000000f

/* Description		TX_PHY_DESC_0_PAPRD_CHAIN_MASK
			
			Chain mask for the PA predistortion function.  <legal:
			0,1,2,4,8>  
*/
#define TX_PHY_DESC_0_PAPRD_CHAIN_MASK_OFFSET                        0x00000000
#define TX_PHY_DESC_0_PAPRD_CHAIN_MASK_LSB                           4
#define TX_PHY_DESC_0_PAPRD_CHAIN_MASK_MASK                          0x000000f0

/* Description		TX_PHY_DESC_0_BF_TYPE
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>
*/
#define TX_PHY_DESC_0_BF_TYPE_OFFSET                                 0x00000000
#define TX_PHY_DESC_0_BF_TYPE_LSB                                    8
#define TX_PHY_DESC_0_BF_TYPE_MASK                                   0x00000300

/* Description		TX_PHY_DESC_0_WAIT_SIFS
			
			If set, the AMPI will hold this tx_phy_desc TLV from the
			TX PCU until SIFS has elapsed and then forward the
			tx_phy_desc to the PHY.  The PHY should ignore this bit. 
			This bit is used to make sure that transmit SIFS response to
			a receive frame is cycle accurate and consistent to enable
			accurate RTT measurement.   
*/
#define TX_PHY_DESC_0_WAIT_SIFS_OFFSET                               0x00000000
#define TX_PHY_DESC_0_WAIT_SIFS_LSB                                  10
#define TX_PHY_DESC_0_WAIT_SIFS_MASK                                 0x00000400

/* Description		TX_PHY_DESC_0_RESERVED_0B
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/
#define TX_PHY_DESC_0_RESERVED_0B_OFFSET                             0x00000000
#define TX_PHY_DESC_0_RESERVED_0B_LSB                                11
#define TX_PHY_DESC_0_RESERVED_0B_MASK                               0x00007800

/* Description		TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE
			
			Valid for 802.11b packets only.
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>
*/
#define TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_OFFSET                    0x00000000
#define TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_LSB                       15
#define TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_MASK                      0x00008000

/* Description		TX_PHY_DESC_0_PKT_TYPE
			
			Packet type:
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<enum 4     dot11n_gf>
			
			
			
			Note: HT Greenfield packet type is not supported.
			However, 3-bit field facilitates Greenfield packet
			generation in DV environment.
			
			<legal 0-4>
*/
#define TX_PHY_DESC_0_PKT_TYPE_OFFSET                                0x00000000
#define TX_PHY_DESC_0_PKT_TYPE_LSB                                   16
#define TX_PHY_DESC_0_PKT_TYPE_MASK                                  0x00070000

/* Description		TX_PHY_DESC_0_RESERVED_0C
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/
#define TX_PHY_DESC_0_RESERVED_0C_OFFSET                             0x00000000
#define TX_PHY_DESC_0_RESERVED_0C_LSB                                19
#define TX_PHY_DESC_0_RESERVED_0C_MASK                               0x00180000

/* Description		TX_PHY_DESC_0_BANDWIDTH
			
			Packet bandwidth:
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			For legacy packets, if this parameter is not set to 0,
			duplicate subbands shall be generated to fill the bandwidth
			specified. For instance, if (pkt_type == 3'h0) && (bandwidth
			== 2'h1), the PHY shall produce 2 duplicate 20MHz subbands
			to fill the 40MHz packet bandwidth.
			
			For OFDM legacy packets, enum value 0, 1, 2 are legal,
			i.e., 20MHz, duplicate 40MHz and duplicate 80MHz.
			
			For CCK legacy packets, only enum value 0 and 1 are
			legal, i.e., 20MHz and duplicate 40MHz, where  duplicate
			40MHz CCK legacy packet is not supported by standard spec
			but supported as proprietary feature. 
			
			For HT packets, enum value 0 and 1 are legal, i.e., HT20
			and HT40. 
			
			For VHT packets, enum value 0, 1 and 2 are legal, i.e.,
			VHT20, VHT40 and VHT80. 
			
			
			
			<legal 0-2>
*/
#define TX_PHY_DESC_0_BANDWIDTH_OFFSET                               0x00000000
#define TX_PHY_DESC_0_BANDWIDTH_LSB                                  21
#define TX_PHY_DESC_0_BANDWIDTH_MASK                                 0x00600000

/* Description		TX_PHY_DESC_0_NDP
			
			Flag to define NDP transmission  <legal 0-1>
*/
#define TX_PHY_DESC_0_NDP_OFFSET                                     0x00000000
#define TX_PHY_DESC_0_NDP_LSB                                        23
#define TX_PHY_DESC_0_NDP_MASK                                       0x00800000

/* Description		TX_PHY_DESC_0_RESERVED_0D
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/
#define TX_PHY_DESC_0_RESERVED_0D_OFFSET                             0x00000000
#define TX_PHY_DESC_0_RESERVED_0D_LSB                                24
#define TX_PHY_DESC_0_RESERVED_0D_MASK                               0x3f000000

/* Description		TX_PHY_DESC_0_CHANNEL_CAPTURE
			
			Indicates that the PHY should be armed to capture the
			channel on the next received packet. This channel estimate
			is passed to the MAC if the packet is successfully received.
			<legal 0-1>
*/
#define TX_PHY_DESC_0_CHANNEL_CAPTURE_OFFSET                         0x00000000
#define TX_PHY_DESC_0_CHANNEL_CAPTURE_LSB                            30
#define TX_PHY_DESC_0_CHANNEL_CAPTURE_MASK                           0x40000000

/* Description		TX_PHY_DESC_0_WARM_TX
			
			Indicates that this PPDU is being transmitted early in
			warm_tx mode. <legal 0-1>
*/
#define TX_PHY_DESC_0_WARM_TX_OFFSET                                 0x00000000
#define TX_PHY_DESC_0_WARM_TX_LSB                                    31
#define TX_PHY_DESC_0_WARM_TX_MASK                                   0x80000000

/* Description		TX_PHY_DESC_1_TPC_INIT_PWR_CFG
			
			0~4: traverse mode
			
			Initial analog gain and PA configuration setting where 0
			has the highest power consumption and best EVM,  and 4 has
			the lowest power consumption and worst EVM 
			
			5~7: low power mode
			
			No traverse. Force TPC to select the specified GLUT set
			(5, 6 or 7) for the low power mode or other special
			purposes.
			
			<legal 0-7>
*/
#define TX_PHY_DESC_1_TPC_INIT_PWR_CFG_OFFSET                        0x00000004
#define TX_PHY_DESC_1_TPC_INIT_PWR_CFG_LSB                           0
#define TX_PHY_DESC_1_TPC_INIT_PWR_CFG_MASK                          0x00000007

/* Description		TX_PHY_DESC_1_DPD_ENABLE
			
			<enum 0     dpd_off> DPD profile not applied to current
			packet
			
			<enum 1     dpd_on> DPD profile applied to current
			packet if available
			
			<legal 0-1>
*/
#define TX_PHY_DESC_1_DPD_ENABLE_OFFSET                              0x00000004
#define TX_PHY_DESC_1_DPD_ENABLE_LSB                                 3
#define TX_PHY_DESC_1_DPD_ENABLE_MASK                                0x00000008

/* Description		TX_PHY_DESC_1_TX_PWR
			
			Transmit Power (signed value) in units of 0.5 dBm <legal
			all>
*/
#define TX_PHY_DESC_1_TX_PWR_OFFSET                                  0x00000004
#define TX_PHY_DESC_1_TX_PWR_LSB                                     4
#define TX_PHY_DESC_1_TX_PWR_MASK                                    0x000007f0

/* Description		TX_PHY_DESC_1_CLPC_ENABLE
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>
*/
#define TX_PHY_DESC_1_CLPC_ENABLE_OFFSET                             0x00000004
#define TX_PHY_DESC_1_CLPC_ENABLE_LSB                                11
#define TX_PHY_DESC_1_CLPC_ENABLE_MASK                               0x00000800

/* Description		TX_PHY_DESC_1_MEASURE_POWER
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0     measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1     measure_en> TPC will latch power measurement
			result for current packet
*/
#define TX_PHY_DESC_1_MEASURE_POWER_OFFSET                           0x00000004
#define TX_PHY_DESC_1_MEASURE_POWER_LSB                              12
#define TX_PHY_DESC_1_MEASURE_POWER_MASK                             0x00001000

/* Description		TX_PHY_DESC_1_RESERVED_1A
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/
#define TX_PHY_DESC_1_RESERVED_1A_OFFSET                             0x00000004
#define TX_PHY_DESC_1_RESERVED_1A_LSB                                13
#define TX_PHY_DESC_1_RESERVED_1A_MASK                               0x0001e000

/* Description		TX_PHY_DESC_1_IBFCAL_ENABLE
			
			Defines the current packet as test packet for implicit
			BF calibration purposes  <legal 0-1>
*/
#define TX_PHY_DESC_1_IBFCAL_ENABLE_OFFSET                           0x00000004
#define TX_PHY_DESC_1_IBFCAL_ENABLE_LSB                              17
#define TX_PHY_DESC_1_IBFCAL_ENABLE_MASK                             0x00020000

/* Description		TX_PHY_DESC_1_MU_NDP
			
			If set indicates that this packet is an NDP used for MU
			channel estimation.  This bit will be used by the TPC to
			signal that the analog gain settings can be updated. The
			analog gain settings will not change for subsequent MU data
			packets.
*/
#define TX_PHY_DESC_1_MU_NDP_OFFSET                                  0x00000004
#define TX_PHY_DESC_1_MU_NDP_LSB                                     18
#define TX_PHY_DESC_1_MU_NDP_MASK                                    0x00040000

/* Description		TX_PHY_DESC_1_HEAVY_CLIP_NSS
			
			Number of active spatial streams in current packet. This
			parameter is used by the heavy clip function in the
			transmitter. In case of MU PPDU, this is total Nss of all
			users. 
			
			0: 1 spatial stream
			
			1: 2 spatial stream
			
			2: 3 spatial stream
			
			3: 4 spatial stream
			
			4-7: Reserved
			
			<legal 0-3>
*/
#define TX_PHY_DESC_1_HEAVY_CLIP_NSS_OFFSET                          0x00000004
#define TX_PHY_DESC_1_HEAVY_CLIP_NSS_LSB                             19
#define TX_PHY_DESC_1_HEAVY_CLIP_NSS_MASK                            0x00380000

/* Description		TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH
			
			If set, no_csd and no_walsh is applied to steering
			packet.
*/
#define TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH_OFFSET         0x00000004
#define TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH_LSB            22
#define TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH_MASK           0x00400000

/* Description		TX_PHY_DESC_1_RESERVED_1B
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/
#define TX_PHY_DESC_1_RESERVED_1B_OFFSET                             0x00000004
#define TX_PHY_DESC_1_RESERVED_1B_LSB                                23
#define TX_PHY_DESC_1_RESERVED_1B_MASK                               0xff800000


#endif // _TX_PHY_DESC_H_
