// Copyright (c) 2013 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_BF_PARAMS_H_
#define _TX_BF_PARAMS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	num_ss_user0[2:0], num_ss_user1[5:3], num_ss_user2[8:6], use_static_bw[9], static_bandwidth[11:10], reserved[31:12]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_BF_PARAMS 1

struct tx_bf_params {
    volatile uint32_t num_ss_user0                    :  3, //[2:0]
                      num_ss_user1                    :  3, //[5:3]
                      num_ss_user2                    :  3, //[8:6]
                      use_static_bw                   :  1, //[9]
                      static_bandwidth                :  2, //[11:10]
                      reserved                        : 20; //[31:12]
};

/*

num_ss_user0
			
			Number of spatial streams assigned to hardware user 0 in
			the next MU MIMO packet or the number of streams in the next
			SU packet.  For MU packets the values can be 1 or 2, for SU
			packets the value can be 1, 2, or 3<legal 1-3>

num_ss_user1
			
			Number of spatial streams assigned to hardware user 1 in
			the next MU MIMO packet.  <legal 0-2>

num_ss_user2
			
			Number of spatial streams assigned to hardware user 2 in
			the next MU MIMO packet.  <legal 0-2>

use_static_bw
			
			This field is used to indicate to the SVD that the b/w
			that will be defined in the TX_PHY_DESC for the upcoming
			TXBF packet will be the same as the static bandwidth, i.e.
			the bandwidth that was in operation during sounding for the
			clients in question <legal all>

static_bandwidth
			
			Packet bandwidth when use_static_bw is set:
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			Field is reserved when use_static_bw is clear.
			
			<legal 0-2>

reserved
			
			Reserved - MAC to set this field to 0, PHY to ignore
			this field. <legal 0>
*/


/* Description		TX_BF_PARAMS_0_NUM_SS_USER0
			
			Number of spatial streams assigned to hardware user 0 in
			the next MU MIMO packet or the number of streams in the next
			SU packet.  For MU packets the values can be 1 or 2, for SU
			packets the value can be 1, 2, or 3<legal 1-3>
*/
#define TX_BF_PARAMS_0_NUM_SS_USER0_OFFSET                           0x00000000
#define TX_BF_PARAMS_0_NUM_SS_USER0_LSB                              0
#define TX_BF_PARAMS_0_NUM_SS_USER0_MASK                             0x00000007

/* Description		TX_BF_PARAMS_0_NUM_SS_USER1
			
			Number of spatial streams assigned to hardware user 1 in
			the next MU MIMO packet.  <legal 0-2>
*/
#define TX_BF_PARAMS_0_NUM_SS_USER1_OFFSET                           0x00000000
#define TX_BF_PARAMS_0_NUM_SS_USER1_LSB                              3
#define TX_BF_PARAMS_0_NUM_SS_USER1_MASK                             0x00000038

/* Description		TX_BF_PARAMS_0_NUM_SS_USER2
			
			Number of spatial streams assigned to hardware user 2 in
			the next MU MIMO packet.  <legal 0-2>
*/
#define TX_BF_PARAMS_0_NUM_SS_USER2_OFFSET                           0x00000000
#define TX_BF_PARAMS_0_NUM_SS_USER2_LSB                              6
#define TX_BF_PARAMS_0_NUM_SS_USER2_MASK                             0x000001c0

/* Description		TX_BF_PARAMS_0_USE_STATIC_BW
			
			This field is used to indicate to the SVD that the b/w
			that will be defined in the TX_PHY_DESC for the upcoming
			TXBF packet will be the same as the static bandwidth, i.e.
			the bandwidth that was in operation during sounding for the
			clients in question <legal all>
*/
#define TX_BF_PARAMS_0_USE_STATIC_BW_OFFSET                          0x00000000
#define TX_BF_PARAMS_0_USE_STATIC_BW_LSB                             9
#define TX_BF_PARAMS_0_USE_STATIC_BW_MASK                            0x00000200

/* Description		TX_BF_PARAMS_0_STATIC_BANDWIDTH
			
			Packet bandwidth when use_static_bw is set:
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			Field is reserved when use_static_bw is clear.
			
			<legal 0-2>
*/
#define TX_BF_PARAMS_0_STATIC_BANDWIDTH_OFFSET                       0x00000000
#define TX_BF_PARAMS_0_STATIC_BANDWIDTH_LSB                          10
#define TX_BF_PARAMS_0_STATIC_BANDWIDTH_MASK                         0x00000c00

/* Description		TX_BF_PARAMS_0_RESERVED
			
			Reserved - MAC to set this field to 0, PHY to ignore
			this field. <legal 0>
*/
#define TX_BF_PARAMS_0_RESERVED_OFFSET                               0x00000000
#define TX_BF_PARAMS_0_RESERVED_LSB                                  12
#define TX_BF_PARAMS_0_RESERVED_MASK                                 0xfffff000


#endif // _TX_BF_PARAMS_H_
