



//
// check saved calibration information
//
extern AR9300DLLSPEC int Ar9300EepromReport(void (*print)(char *format, ...), int all);

//
// specify which templates may be used in compression.
// if many=0, all templates are allowed.
//
extern AR9300DLLSPEC int Ar9300EepromTemplateAllowed(unsigned int *value, unsigned int many);

//
// turn compression on/off.
//
extern AR9300DLLSPEC int Ar9300EepromCompress(unsigned int value);

//
// turn overwrite on/off.
//
extern AR9300DLLSPEC int Ar9300EepromOverwrite(unsigned int value);

//
// override default address for saving 
//
extern AR9300DLLSPEC int Ar9300EepromSaveAddressSet(int address);

//
// override default memory type for saving 
//
extern AR9300DLLSPEC int Ar9300EepromSaveMemorySet(int memory);


extern AR9300DLLSPEC int Ar9300EepromTemplatePreference(int preference);
extern AR9300DLLSPEC int Ar9300EepromSize(void);
extern AR9300DLLSPEC int Ar9300CalibrationDataAddressSet(int size);
extern AR9300DLLSPEC int Ar9300CalibrationDataAddressGet(void);
extern AR9300DLLSPEC int Ar9300CalibrationDataSet(int source);
extern AR9300DLLSPEC int Ar9300CalibrationDataGet(void);
extern AR9300DLLSPEC int Ar9300EepromTemplateInstall(int preference);

extern AR9300DLLSPEC int Ar9300ConfigurationSave(void);
extern AR9300DLLSPEC int Ar9300ConfigurationRestore(void);

//
// returns lowest free memory address
//
int Ar9300EepromUsed(void);

//=================================================================
//
// Jet Function
//
//=================================================================

//
// check saved calibration information
//
extern AR9300DLLSPEC int Ar5500EepromReport(void (*print)(char *format, ...), int all);

//
// specify which templates may be used in compression.
// if many=0, all templates are allowed.
//
extern AR9300DLLSPEC int Ar5500EepromTemplateAllowed(unsigned int *value, unsigned int many);

//
// turn compression on/off.
//
extern AR9300DLLSPEC int Ar5500EepromCompress(unsigned int value);

//
// turn overwrite on/off.
//
extern AR9300DLLSPEC int Ar5500EepromOverwrite(unsigned int value);

//
// override default address for saving 
//
extern AR9300DLLSPEC int Ar5500EepromSaveAddressSet(int address);

//
// override default memory type for saving 
//
extern AR9300DLLSPEC int Ar5500EepromSaveMemorySet(int memory);


extern AR9300DLLSPEC int Ar5500EepromTemplatePreference(int preference);
extern AR9300DLLSPEC int Ar5500EepromSize(void);
extern AR9300DLLSPEC int Ar5500CalibrationDataAddressSet(int size);
extern AR9300DLLSPEC int Ar5500CalibrationDataAddressGet(void);
extern AR9300DLLSPEC int Ar5500CalibrationDataSet(int source);
extern AR9300DLLSPEC int Ar5500CalibrationDataGet(void);
extern AR9300DLLSPEC int Ar5500EepromTemplateInstall(int preference);

extern AR9300DLLSPEC int Ar5500ConfigurationSave(void);
extern AR9300DLLSPEC int Ar5500ConfigurationRestore(void);

//
// returns lowest free memory address
//
int Ar5500EepromUsed(void);