#ifndef AR9300DEVICE_H
#define AR9300DEVICE_H

#include "ParameterSelect.h"

#ifdef _WINDOWS
#ifdef AR9300DLL
		#define AR9300DLLSPEC __declspec(dllexport)
	#else
		#define AR9300DLLSPEC __declspec(dllimport)
	#endif
#else
	#define AR9300DLLSPEC
#endif

//
// clear all device control function pointers and set to default behavior
//
extern AR9300DLLSPEC int Ar9300DeviceSelect();

extern AR9300DLLSPEC int Ar9300is2GHz(void);

extern AR9300DLLSPEC int Ar9300is5GHz(void);

extern AR9300DLLSPEC int Ar9300TxChainMany(void);

extern AR9300DLLSPEC int Ar9300RxChainMany(void);

extern AR9300DLLSPEC int Ar9300EepromRead(unsigned int address, unsigned char *buffer, int many);

extern AR9300DLLSPEC int Ar9300EepromWrite(unsigned int address, unsigned char *buffer, int many);

extern AR9300DLLSPEC int Ar9300OtpRead(unsigned int address, unsigned char *buffer, int many, int is_wifi);

extern AR9300DLLSPEC int Ar9300OtpWrite(unsigned int address, unsigned char *buffer, int many,int is_wifi);

extern AR9300DLLSPEC int Ar9300RxChainSet(int rxChain);

extern AR9300DLLSPEC int Ar9300DeafMode(int deaf); 

extern AR9300DLLSPEC int Ar9300Attach(int devid, int ssid);

extern AR9300DLLSPEC int Ar9300Reset(int frequency, unsigned int txchain, unsigned int rxchain, int bandwidth);

extern AR9300DLLSPEC int Ar9300GetParameterSplice(struct _ParameterList *list);

extern AR9300DLLSPEC int Ar9300SetParameterSplice(struct _ParameterList *list);

extern AR9300DLLSPEC int Ar9300SetCommand(int client);

extern AR9300DLLSPEC int Ar9300GetCommand(int client);

extern AR9300DLLSPEC int Ar9300_get_corr_coeff(int coeff_type, unsigned int **coeff_array, unsigned int *max_row, unsigned int *max_col);

extern struct ath_hal *AH;

//=================================================
//
// Jet Function
//
//=================================================
//
// clear all device control function pointers and set to default behavior
//
extern AR9300DLLSPEC int Ar5500DeviceSelect();

extern AR9300DLLSPEC int Ar5500is2GHz(void);

extern AR9300DLLSPEC int Ar5500is5GHz(void);

extern AR9300DLLSPEC int Ar5500TxChainMany(void);

extern AR9300DLLSPEC int Ar5500RxChainMany(void);

extern AR9300DLLSPEC int Ar5500EepromRead(unsigned int address, unsigned char *buffer, int many);

extern AR9300DLLSPEC int Ar5500EepromWrite(unsigned int address, unsigned char *buffer, int many);

extern AR9300DLLSPEC int Ar5500OtpRead(unsigned int address, unsigned char *buffer, int many, int is_wifi);

extern AR9300DLLSPEC int Ar5500OtpWrite(unsigned int address, unsigned char *buffer, int many,int is_wifi);

extern AR9300DLLSPEC int Ar5500RxChainSet(int rxChain);

extern AR9300DLLSPEC int Ar5500DeafMode(int deaf); 

extern AR9300DLLSPEC int Ar5500Attach(int devid, int ssid);

extern AR9300DLLSPEC int Ar5500Reset(int frequency, unsigned int txchain, unsigned int rxchain, int bandwidth);

extern AR9300DLLSPEC int Ar5500GetParameterSplice(struct _ParameterList *list);

extern AR9300DLLSPEC int Ar5500SetParameterSplice(struct _ParameterList *list);

extern AR9300DLLSPEC int Ar5500SetCommand(int client);

extern AR9300DLLSPEC int Ar5500GetCommand(int client);

extern AR9300DLLSPEC int Ar5500_get_corr_coeff(int coeff_type, unsigned int **coeff_array, unsigned int *max_row, unsigned int *max_col);

#endif /* AR9300DEVICE_H */

