- infos = Information about the yambi plugin is in keys below
- infos/author = René Schwaiger <sanssecours@me.com>
- infos/licence = BSD
- infos/needs = directoryvalue yamlsmith
- infos/provides = storage/yaml
- infos/recommends =
- infos/placements = getstorage
- infos/status = maintained unittest preview experimental unfinished nodoc concept discouraged
- infos/metadata =
- infos/description = This storage plugin use a parser generated by Bison to read YAML files

# YAMBi

## Introduction

This plugin uses Bison to generate a parser for the [YAML](http://yaml.org) serialization format.

## Dependencies

The plugin requires [Bison](https://www.gnu.org/software/bison/) (3.0 or later).

## Examples

### Mappings

```sh
# Mount plugin
sudo kdb mount config.yaml user/tests/yambi yambi

kdb set user/tests/yambi 'Mount Point'
kdb get user/tests/yambi
#> Mount Point

kdb set user/tests/yambi/bambi 'Mule Deer'
kdb get user/tests/yambi/bambi
#> Mule Deer

kdb set user/tests/yambi/thumper 'Rabbit'
kdb get user/tests/yambi/thumper
#> Rabbit

kdb set user/tests/yambi/bambi/baby 'Bobby Stewart'
kdb set user/tests/yambi/bambi/young 'Donnie Dunagan'
kdb set user/tests/yambi/bambi/adolescent 'Hardie Albright'
kdb set user/tests/yambi/bambi/adult 'John Sutherland'

kdb get user/tests/yambi/bambi/baby
#> Bobby Stewart

kdb ls user/tests/yambi
#> user/tests/yambi
#> user/tests/yambi/bambi
#> user/tests/yambi/bambi/adolescent
#> user/tests/yambi/bambi/adult
#> user/tests/yambi/bambi/baby
#> user/tests/yambi/bambi/young
#> user/tests/yambi/thumper

# Undo modifications
kdb rm -r user/tests/yambi
sudo kdb umount user/tests/yambi
```

### Arrays

```sh
# Mount plugin
sudo kdb mount config.yaml user/tests/yambi yambi

kdb set user/tests/yambi/friends
kdb set user/tests/yambi/friends/#0 Thumper
kdb set user/tests/yambi/friends/#1 Flower

# Retrieve last array index
kdb getmeta user/tests/yambi/friends array
#> #1

kdb get user/tests/yambi/friends/#0
#> Thumper
kdb get user/tests/yambi/friends/#1
#> Flower

# Undo modifications
kdb rm -r user/tests/yambi
sudo kdb umount user/tests/yambi
```

### Error Messages

```sh
# Mount plugin
sudo kdb mount config.yaml user/tests/yambi yambi

# Manually add data containing a syntax error
printf -- 'Thumper: - Eating greens is a special treat.\n'      >  `kdb file user/tests/yambi`
printf -- '         - It makes long ears and great big feet.\n' >> `kdb file user/tests/yambi`
printf -- '- But it sure is awful stuff to eat.'                >> `kdb file user/tests/yambi`

# Try to retrieve data
kdb get user/tests/yambi/Thumper/#2
# RET: 5
# STDERR: .*config.yaml:3:1: syntax error, unexpected ELEMENT, expecting MAP_END or KEY.*

# Fix syntax error
printf -- 'Thumper: - Eating greens is a special treat.\n'      >  `kdb file user/tests/yambi`
printf -- '         - It makes long ears and great big feet.\n' >> `kdb file user/tests/yambi`
printf -- '         - But it sure is awful stuff to eat.'       >> `kdb file user/tests/yambi`

# Retrieve data
kdb get user/tests/yambi/Thumper/#2
#> But it sure is awful stuff to eat.

# Undo modifications
kdb rm -r user/tests/yambi
sudo kdb umount user/tests/yambi
```

## Limitations

The plugin supports the same limited YAML syntax as [Yan LR](../yanlr/).

- The plugin always assumes **UTF-8** encoded data.
