/**
 * @file
 *
 * @brief
 *
 * @copyright BSD License (see LICENSE.md or https://www.libelektra.org)
 */

#include "parser.hpp"

#include <algorithm>
#include <fstream>
#include <iostream>

#ifndef _WIN32
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#endif

using namespace std;

static ostream & printKDBErrors (ostream & os, parse_t & p)
{
	os << "/*This is an auto-generated file generated by exporterrors. Do not modify it.*/" << endl
	   << endl
	   << "#ifndef KDBERRORS_H" << endl
	   << "#define KDBERRORS_H" << endl
	   << endl
	   << "#include <kdb.h>" << endl
	   << "#include <kdbhelper.h>" << endl
	   << "#include <kdblogger.h>" << endl
	   << "#include <kdbmacros.h>" << endl
	   << "#include <string.h>" << endl
	   << endl
	   << "#ifdef __cplusplus" << endl
	   << "	using namespace ckdb;" << endl
	   << endl
	   << "#endif" << endl
	   << "#define ELEKTRA_SET_ERROR(number, key, text) ELEKTRA_SET_ERROR_HELPER\\" << endl
	   << "	(number, key, text, __FILE__, __LINE__)" << endl
	   << endl
	   << "#define ELEKTRA_SET_ERROR_HELPER(number, key, text, file, line) ELEKTRA_SET_ERROR_HELPER_HELPER\\" << endl
	   << "	(number, key, text, file, line)" << endl
	   << endl
	   << "#define ELEKTRA_SET_ERROR_HELPER_HELPER(number, key, text, file, line) do {ELEKTRA_LOG (\"Add Error %d: %s\", "
	      "number, text); elektraSetError ## number\\"
	   << endl
	   << "	(key, text, file, #line); } while (0)" << endl
	   << endl
	   << endl
	   << "#define ELEKTRA_ADD_WARNING(number, key, text) ELEKTRA_ADD_WARNING_HELPER\\" << endl
	   << "	(number, key, text, __FILE__, __LINE__)" << endl
	   << "" << endl
	   << "#define ELEKTRA_ADD_WARNING_HELPER(number, key, text, file, line) ELEKTRA_ADD_WARNING_HELPER_HELPER\\" << endl
	   << "	(number, key, text, file, line)" << endl
	   << "" << endl
	   << "#define ELEKTRA_ADD_WARNING_HELPER_HELPER(number, key, text, file, line) do {ELEKTRA_LOG (\"Add Warning %d: %s\", "
	      "number, text);  elektraAddWarning ## number\\"
	   << endl
	   << "	(key, text, file, #line);} while (0)" << endl
	   << endl
	   << endl
	   << "#define ELEKTRA_SET_ERRORF(number, key, text, ...) ELEKTRA_SET_ERRORF_HELPER\\" << endl
	   << "	(number, key, text, __FILE__, __LINE__, __VA_ARGS__)" << endl
	   << endl
	   << "#define ELEKTRA_SET_ERRORF_HELPER(number, key, text, file, line, ...) ELEKTRA_SET_ERRORF_HELPER_HELPER\\" << endl
	   << "	(number, key, text, file, line, __VA_ARGS__)" << endl
	   << endl
	   << "#define ELEKTRA_SET_ERRORF_HELPER_HELPER(number, key, text, file, line, ...) do {ELEKTRA_LOG (\"Add Error \" "
	      "ELEKTRA_STRINGIFY(number) \" : \" text, __VA_ARGS__); elektraSetErrorf ## number\\"
	   << endl
	   << "	(key, text, file, #line,  __VA_ARGS__); } while (0)" << endl
	   << endl
	   << endl
	   << "#define ELEKTRA_ADD_WARNINGF(number, key, text, ...) ELEKTRA_ADD_WARNINGF_HELPER\\" << endl
	   << "	(number, key, text, __FILE__, __LINE__, __VA_ARGS__)" << endl
	   << "" << endl
	   << "#define ELEKTRA_ADD_WARNINGF_HELPER(number, key, text, file, line, ...) ELEKTRA_ADD_WARNINGF_HELPER_HELPER\\" << endl
	   << "	(number, key, text, file, line, __VA_ARGS__)" << endl
	   << "" << endl
	   << "#define ELEKTRA_ADD_WARNINGF_HELPER_HELPER(number, key, text, file, line, ...)  do {ELEKTRA_LOG (\"Add Warning \" "
	      "ELEKTRA_STRINGIFY(number) \" : \" text, __VA_ARGS__); elektraAddWarningf ## number\\"
	   << endl
	   << "	(key, text, file, #line, __VA_ARGS__); } while (0)" << endl
	   << endl
	   << endl;

	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["macro"].empty ())
		{
			continue;
		}

		os << "#define ELEKTRA_";
		if (p[i]["severity"] == "warning")
		{
			os << "WARNING_";
		}
		else
		{
			os << "ERROR_";
		}
		os << p[i]["macro"] << " " << i << endl;
	}

	os << endl << endl;

	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["severity"] == "warning")
		{
			for (int f = 0; f < 2; ++f)
			{
				if (f == 0)
				{
					os << "static inline void elektraAddWarningf" << i << "(Key *warningKey, const char *reason,"
					   << endl
					   << "	const char *file, const char *line, ...)  __attribute__ ((format (printf, 2, 5)));" << endl;
					os << "static inline void elektraAddWarningf" << i << "(Key *warningKey, const char *reason,"
					   << endl
					   << "	const char *file, const char *line, ...)" << endl;
				}
				else
				{
					os << "static inline void elektraAddWarning" << i << "(Key *warningKey, const char *reason," << endl
					   << "	const char *file, const char *line)" << endl;
				}
				os << "{" << endl
				   << "	if (!warningKey) return;" << endl
				   << "" << endl
				   << "	char buffer[25] = \"warnings/#00\";buffer[12] = '\\0';" << endl
				   << "	const Key *meta = keyGetMeta(warningKey, \"warnings\");" << endl
				   << "	if (meta)" << endl
				   << "	{" << endl
				   << "		buffer[10] = keyString(meta)[0];" << endl
				   << "		buffer[11] = keyString(meta)[1];" << endl
				   << "		buffer[11]++;" << endl
				   << "		if (buffer[11] > '9')" << endl
				   << "		{" << endl
				   << "			buffer[11] = '0';" << endl
				   << "			buffer[10]++;" << endl
				   << "			if (buffer[10] > '9') buffer[10] = '0';" << endl
				   << "		}" << endl
				   << "		keySetMeta(warningKey, \"warnings\", &buffer[10]);" << endl
				   << "	} else  keySetMeta(warningKey, \"warnings\", \"00\");" << endl
				   << "" << endl
				   << "	keySetMeta(warningKey, buffer, \"number description ingroup module file line function reason\");"
				   << endl
				   << "	strcat(buffer, \"/number\" );" << endl
				   << "	keySetMeta(warningKey, buffer, \"" << i << "\");" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/description\");" << endl
				   << "	keySetMeta(warningKey, buffer, \"" << p[i]["description"] << "\");" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/ingroup\");" << endl
				   << "	keySetMeta(warningKey, buffer, \"" << p[i]["ingroup"] << "\");" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/module\");" << endl
				   << "	keySetMeta(warningKey, buffer, \"" << p[i]["module"] << "\");" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/file\");" << endl // should be called sourcefile
				   << "	keySetMeta(warningKey, buffer, file);" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/line\");" << endl
				   << "	keySetMeta(warningKey, buffer, line);" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/mountpoint\");" << endl
				   << "	keySetMeta(warningKey, buffer, keyName(warningKey));" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/configfile\");" << endl
				   << "	keySetMeta(warningKey, buffer, keyString(warningKey));" << endl
				   << "	buffer[12] = '\\0'; strcat(buffer, \"/reason\");" << endl;
				if (f == 0)
				{
					os << "	va_list arg;" << endl
					   << "	va_start(arg, line);" << endl
					   << "	char * r = elektraVFormat(reason, arg);" << endl
					   << "	keySetMeta(warningKey, buffer, r);" << endl
					   << "	elektraFree(r);" << endl
					   << "	va_end(arg);" << endl;
				}
				else
				{
					os << "	keySetMeta(warningKey, buffer, reason);" << endl;
				}
				os << "}" << endl << endl;
			}
		}
		else
		{
			for (int f = 0; f < 2; ++f)
			{
				if (f == 0)
				{
					os << "static inline void elektraSetErrorf" << i << "(Key *errorKey, const char *reason," << endl
					   << "	const char *file, const char *line, ...)  __attribute__ ((format (printf, 2, 5)));" << endl
					   << "static inline void elektraSetErrorf" << i << "(Key *errorKey, const char *reason," << endl
					   << "	const char *file, const char *line, ...)" << endl;
				}
				else
				{
					os << "static inline void elektraSetError" << i << "(Key *errorKey, const char *reason," << endl
					   << "	const char *file, const char *line)" << endl;
				}
				os << "{" << endl
				   << "	if (!errorKey) return;" << endl
				   << "	char buffer[25] = \"warnings/#00\";" << endl
				   << " 	const Key *meta = keyGetMeta(errorKey, \"error\");" << endl
				   << "	if (meta)" << endl
				   << "	{" << endl
				   << "		const Key *warningMeta = keyGetMeta(errorKey, \"warnings\");" << endl
				   << "		if (warningMeta)" << endl
				   << "		{" << endl
				   << "			buffer[10] = keyString(warningMeta)[0];" << endl
				   << "			buffer[11] = keyString(warningMeta)[1];" << endl
				   << "			buffer[11]++;" << endl
				   << "			if (buffer[11] > '9')" << endl
				   << "			{" << endl
				   << "				buffer[11] = '0';" << endl
				   << "				buffer[10]++;" << endl
				   << "				if (buffer[10] > '9') buffer[10] = '0';" << endl
				   << "			}" << endl
				   << "			keySetMeta(errorKey, \"warnings\", &buffer[10]);" << endl
				   << "		} else	keySetMeta(errorKey, \"warnings\", \"00\");" << endl
				   << "		keySetMeta(errorKey, buffer, \"number description ingroup module file line function "
				      "reason\");"
				   << endl
				   << "		strcat(buffer, \"/number\" );" << endl
				   << "		keySetMeta(errorKey, buffer, \"" << i << "\");" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/description\");" << endl
				   << "		keySetMeta(errorKey, buffer, \"" << p[i]["description"] << "\");" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/ingroup\");" << endl
				   << "		keySetMeta(errorKey, buffer, \"" << p[i]["ingroup"] << "\");" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/module\");" << endl
				   << "		keySetMeta(errorKey, buffer, \"" << p[i]["module"] << "\");" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/file\");" << endl // should be called sourcefile
				   << "		keySetMeta(errorKey, buffer, file);" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/line\");" << endl
				   << "		keySetMeta(errorKey, buffer, line);" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/mountpoint\");" << endl
				   << "		keySetMeta(errorKey, buffer, keyName(errorKey));" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/configfile\");" << endl
				   << "		keySetMeta(errorKey, buffer, keyString(errorKey));" << endl
				   << "		buffer[12] = '\\0'; strcat(buffer, \"/reason\");" << endl
				   << "	}" << endl
				   << " 	else" << endl
				   << " 	{" << endl
				   << "		keySetMeta(errorKey, \"error\", \""
				   << "number description ingroup module file line function reason"
				   << "\");" << endl
				   << "		keySetMeta(errorKey, \"error/number\", \"" << i << "\");" << endl
				   << "		keySetMeta(errorKey, \"error/description\", \"" << p[i]["description"] << "\");" << endl
				   << "		keySetMeta(errorKey, \"error/ingroup\", \"" << p[i]["ingroup"] << "\");" << endl
				   << "		keySetMeta(errorKey, \"error/module\", \"" << p[i]["module"] << "\");" << endl
				   << "		keySetMeta(errorKey, \"error/file\", "
				   << "file"
				   << ");" << endl
				   << "		keySetMeta(errorKey, \"error/line\", "
				   << "line"
				   << ");" << endl
				   << "		keySetMeta(errorKey, \"error/mountpoint\", "
				   << "keyName(errorKey)"
				   << ");" << endl
				   << "		keySetMeta(errorKey, \"error/configfile\", "
				   << "keyString(errorKey)"
				   << ");" << endl
				   << " 	}" << endl;
				if (f == 0)
				{
					os << "	va_list arg;" << endl
					   << "	va_start(arg, line);" << endl
					   << "	char * r = elektraVFormat(reason, arg);" << endl
					   << " 	if(meta)" << endl
					   << "			keySetMeta(errorKey, buffer, r);" << endl
					   << " 	else" << endl
					   << "			keySetMeta(errorKey, \"error/reason\", "
					   << "r"
					   << ");" << endl
					   << "	elektraFree(r);" << endl
					   << "	va_end(arg);" << endl;
				}
				else
				{
					os << " 	if(meta)" << endl
					   << "			keySetMeta(errorKey, buffer, reason);" << endl
					   << " 	else" << endl
					   << "			keySetMeta(errorKey, \"error/reason\", reason);" << endl;
				}
				os << "}" << endl << endl;
			}
		}
	}

	os << "static inline KeySet *elektraErrorSpecification (void)" << endl
	   << "{" << endl
	   << "	return ksNew (30," << endl
	   << "		keyNew (\"system/elektra/modules/error/specification\"," << endl
	   << "			KEY_VALUE, \"the specification of all error codes\", KEY_END)," << endl;
	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		os << "		keyNew (\"system/elektra/modules/error/specification/" << i << "\"," << endl
		   << "			KEY_END)," << endl
		   << "		keyNew (\"system/elektra/modules/error/specification/" << i << "/description\"," << endl
		   << "			KEY_VALUE, \"" << p[i]["description"] << "\", KEY_END)," << endl
		   << "		keyNew (\"system/elektra/modules/error/specification/" << i << "/ingroup\"," << endl
		   << "			KEY_VALUE, \"" << p[i]["ingroup"] << "\", KEY_END)," << endl
		   << "		keyNew (\"system/elektra/modules/error/specification/" << i << "/severity\"," << endl
		   << "			KEY_VALUE, \"" << p[i]["severity"] << "\", KEY_END)," << endl
		   << "		keyNew (\"system/elektra/modules/error/specification/" << i << "/module\"," << endl
		   << "			KEY_VALUE, \"" << p[i]["module"] << "\", KEY_END)," << endl;
	}
	os << "		KS_END);" << endl << "}" << endl;

	os << "static inline void elektraTriggerWarnings (int nr, Key *parentKey, const char *message)" << endl
	   << "{" << endl
	   << "	switch (nr)" << endl
	   << "	{" << endl;
	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["severity"] != "warning") continue;
		os << "		case " << i << ": ELEKTRA_ADD_WARNING (" << i << ", parentKey, message);" << endl
		   << "			break;" << endl;
	}
	os << "		default: ELEKTRA_ADD_WARNING (45, parentKey, \"in default branch\");" << endl
	   << "			 break;" << endl
	   << "	}" << endl
	   << "}" << endl
	   << "" << endl;
	os << "static inline void elektraTriggerError (int nr, Key *parentKey, const char *message)" << endl
	   << "{" << endl
	   << "	switch (nr)" << endl
	   << "	{" << endl;
	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["severity"] == "warning") continue;
		os << "		case " << i << ": ELEKTRA_SET_ERROR (" << i << ", parentKey, message);" << endl
		   << "			break;" << endl;
	}
	os << "		default: ELEKTRA_SET_ERROR (44, parentKey, \"in default branch\");" << endl
	   << "			 break;" << endl
	   << "	}" << endl
	   << "}" << endl;


	os << "#endif" << endl;
	return os;
}

static ostream & printCreatorSignature (ostream & os, map<string, string> & data)
{
	string name = data["name"];
	bool wasUnderscore = true;
	for (char & cur : name)
	{
		if (isalpha (cur))
		{
			if (wasUnderscore)
			{
				cur = static_cast<char> (toupper (cur));
			}
			else
			{
				cur = static_cast<char> (tolower (cur));
			}
		}
		wasUnderscore = cur == '_';
	}
	name.erase (remove (name.begin (), name.end (), '_'), name.end ());

	os << "ElektraError * elektraError" << name << "(";

	string severity = data["severity"];

	int args = data.find ("args") != data.end () ? stoi (data["args"]) : 0;
	if (args > 0)
	{
		if (severity == "*")
		{
			os << "ElektraErrorSeverity severity, ";
		}

		os << data["type1"] << " " << data["arg1"];
		for (int j = 2; j <= args; j++)
		{
			os << ", " << data["type" + to_string (j)] << " " << data["arg" + to_string (j)];
		}
	}

	os << ")";
	return os;
}

static ostream & printCodes (ostream & os, parse_t & p)
{
	os << "/*This is an auto-generated file generated by exporterrors_highlevel. Do not modify it.*/" << endl
	   << endl
	   << "#ifndef ELEKTRA_ERROR_CODES_H" << endl
	   << "#define ELEKTRA_ERROR_CODES_H" << endl
	   << endl
	   << "#ifdef __cplusplus" << endl
	   << "extern \"C\" {" << endl
	   << "#endif" << endl
	   << "typedef enum" << endl
	   << "{" << endl;

	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["name"].empty ())
		{
			continue;
		}

		os << "\tELEKTRA_ERROR_CODE_" << p[i]["name"] << " = " << i << "," << endl;
	}

	os << "} ElektraErrorCode;" << endl;
	os << endl;

	os << "#ifdef __cplusplus" << endl << "}" << endl;

	os << "namespace elektra {" << endl;
	os << "enum class ElektraErrorCode {" << endl;
	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["name"].empty ())
		{
			continue;
		}

		os << "\t" << p[i]["name"] << " = ELEKTRA_ERROR_CODE_" << p[i]["name"] << "," << endl;
	}
	os << "};" << endl;
	os << "}" << endl;

	os << "#endif" << endl;

	os << "#endif // ELEKTRA_ERROR_CODES_H" << endl;
	os << endl;
	return os;
}

static ostream & printPublic (ostream & os, parse_t & p)
{
	os << "/*This is an auto-generated file generated by exporterrors_highlevel. Do not modify it.*/" << endl
	   << endl
	   << "#ifndef ELEKTRA_ERRORS_H" << endl
	   << "#define ELEKTRA_ERRORS_H" << endl
	   << endl
	   << "#include <elektra/types.h>" << endl
	   << "#include <elektra/error.h>" << endl
	   << endl
	   << "#ifdef __cplusplus" << endl
	   << "extern \"C\" {" << endl
	   << "#endif" << endl;

	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["name"].empty ())
		{
			continue;
		}

		if (p[i]["visibility"] != "public")
		{
			continue;
		}

		printCreatorSignature (os, p[i]) << ";" << endl;
	}
	os << endl;

	os << "#ifdef __cplusplus" << endl << "}" << endl << "#endif" << endl;

	os << "#endif // ELEKTRA_ERRORS_H" << endl;
	os << endl;
	return os;
}

static ostream & printPrivate (ostream & os, parse_t & p)
{
	os << "/*This is an auto-generated file generated by exporterrors_highlevel. Do not modify it.*/" << endl
	   << endl
	   << "#ifndef ELEKTRA_ERRORS_PRIVATE_H" << endl
	   << "#define ELEKTRA_ERRORS_PRIVATE_H" << endl
	   << endl
	   << "#include <elektra/types.h>" << endl
	   << "#include <elektra/error.h>" << endl
	   << "#include <kdbprivate.h>" << endl
	   << endl
	   << "#ifdef __cplusplus" << endl
	   << "extern \"C\" {" << endl
	   << "#endif" << endl;

	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["name"].empty ())
		{
			continue;
		}

		if (p[i]["visibility"] == "public")
		{
			continue;
		}

		printCreatorSignature (os, p[i]) << ";" << endl;
	}
	os << endl;

	os << "#ifdef __cplusplus" << endl << "}" << endl << "#endif" << endl;

	os << "#endif // ELEKTRA_ERRORS_PRIVATE_H" << endl;
	os << endl;
	return os;
}

static ostream & printSource (ostream & os, parse_t & p, const char * headerPublic, const char * headerPrivate)
{
	os << "/*This is an auto-generated file generated by exporterrors_highlevel. Do not modify it.*/" << endl
	   << endl
	   << "#include <" << headerPublic << ">" << endl
	   << "#include <" << headerPrivate << ">" << endl
	   << "#include <kdbprivate.h>" << endl
	   << "#include <kdbhelper.h>" << endl
	   << endl;

	for (size_t i = 1; i < p.size (); ++i)
	{
		if (p[i]["unused"] == "yes")
		{
			continue;
		}

		if (p[i]["name"].empty ())
		{
			continue;
		}

		printCreatorSignature (os, p[i]) << endl << "{" << endl;

		string severity = p[i]["severity"];


		if (severity != "*")
		{
			std::transform (severity.begin (), severity.end (), severity.begin (), ::toupper);
			os << "\tElektraErrorSeverity severity = "
			   << "ELEKTRA_ERROR_SEVERITY_" << severity << ";" << endl;
		}

		int args = p[i].find ("args") != p[i].end () ? stoi (p[i]["args"]) : 0;

		if (args > 0)
		{
			os << "\tchar * errorString = elektraFormat (\"" << p[i]["description"] << "\"";
			for (int j = 1; j <= args; j++)
			{
				os << ", " << p[i]["arg" + std::to_string (j)];
			}
			os << ");" << endl;
		}
		else
		{
			os << "\tconst char * errorString = \"" << p[i]["description"] << "\"";
		}

		os << "\tElektraError * error = elektraErrorCreate (ELEKTRA_ERROR_CODE_" << p[i]["name"] << ", errorString, severity);"
		   << endl;

		if (args > 0)
		{
			os << "\telektraFree (errorString);" << endl;
		}

		os << "\treturn error;" << endl;
		os << "}" << endl;
		os << endl;
	}

	return os;
}

template <typename Func>
static int writeFile (parse_t & data, const char * filename, Func printFn)
{
	std::string tmpfile = filename;
#ifndef _WIN32
	tmpfile += ".tmp";
	tmpfile += to_string (getpid ());
#endif
	{
		ofstream fout (tmpfile);
		if (!fout.is_open ())
		{
			cerr << "Could not open output file " << filename << endl;
			return 1;
		}
		printFn (fout, data);
	}

#ifndef _WIN32
	int fd = open (tmpfile.c_str (), O_RDWR);
	if (fd == -1)
	{
		cerr << "Could not reopen file " << filename << endl;
		return 2;
	}
	if (fsync (fd) == -1)
	{
		cerr << "Could not fsync config file " << filename << " because ", strerror (errno);
		close (fd);
		return 3;
	}
	close (fd);

	if (rename (tmpfile.c_str (), filename) == -1)
	{
		cerr << "Could not rename file " << tmpfile << " to " << filename << endl;
		return 4;
	}
#endif
	return 0;
}

static void printUsage (const std::string & name)
{
	cerr << "Usage " << name << "MODE infile [options]"
	     << "\tMODES:" << endl
	     << "\t\tkdb\t\t options: outfile" << endl
	     << "\t\thighlevel\t\t options: outcodes outpublic outprivate outsource includepublic includeprivate" << endl
	     << "\t\t\t outcodes: outfile for error codes enum" << endl
	     << "\t\t\t outpublic: outfile for public header" << endl
	     << "\t\t\t outprivate: outfile for private header" << endl
	     << "\t\t\t outsource: outfile for source code" << endl
	     << "\t\t\t includepublic: include path (including file name) for public header" << endl
	     << "\t\t\t includeprivate: include path (including file name) for private header" << endl
	     << endl;
}

int main (int argc, char ** argv) try
{
	if (argc < 2)
	{
		printUsage (argv[0]);
		return 1;
	}

	std::string mode = argv[1];

	if (mode == "kdb")
	{
		switch (argc)
		{
		case 3:
		{
			string infile = argv[2];
			parse_t data = parse (infile);
			printKDBErrors (cout, data);
			break;
		}
		case 4:
		{
			string infile = argv[2];
			parse_t data = parse (infile);
			writeFile (data, argv[3], printKDBErrors);
			break;
		}
		default:
			printUsage (argv[0]);
			return 1;
		}
	}
	else if (mode == "highlevel")
	{
		switch (argc)
		{
		case 3:
		{
			string infile = argv[2];
			parse_t data = parse (infile);
			printCodes (cout, data);
			cout << endl << endl;
			printPublic (cout, data);
			cout << endl << endl;
			printPrivate (cout, data);
			cout << endl << endl;
			printSource (cout, data, "", "");
			break;
		}
		case 9:
		{
			string infile = argv[2];
			parse_t data = parse (infile);
			writeFile (data, argv[3], printCodes);
			writeFile (data, argv[4], printPublic);
			writeFile (data, argv[5], printPrivate);

			auto func = [&](ostream & os, parse_t & d) { printSource (os, d, argv[7], argv[8]); };

			writeFile (data, argv[6], func);
			break;
		}
		default:
			printUsage (argv[0]);

			return 1;
		}
	}
	else
	{
		cerr << "Unknown mode" << endl;
		printUsage (argv[0]);
		return 1;
	}


	return 0;
}
catch (parse_error const & e)
{
	cerr << "The line " << e.linenr << " caused following parse error: " << e.info << endl;
	return 2;
}
