# 0.8.10 Release

- guid: 6ce57ecf-420a-4a31-821e-1c5fe5532eb4
- author: Markus Raab
- pubDate: Tue, 02 Dec 2014 18:37:51 +0100
- shortDesc: adds XDG/OpenICC compatibility & java binding

Hello,

we are delighted to announce our latest feature release providing
major updates in:

- compatibility with standards,
- tooling,
- plugins (hosts, rename),
- Qt-Gui and
- a new Java binding

## XDG Compatibility

Elektra now is
[fully XDG 0.8](http://standards.freedesktop.org/basedir-spec/basedir-spec-0.8.html)
compliant. Following changes were necessary:

- newly created configuration files for user/ now have the permissions
  0600
- newly created configuration directories for user/ now have the
  permissions 0700
- existing configuration files will retain their permissions.
- The default path to store user configuration is now ~/.config
- A new resolver variant x (for user and system) is introduced
  - implements handling of XDG environment variables
  - ignores empty dirs and absolute paths in envvar
- add new shell based test suite for (xdg)-resolver

For example, we could use `resolver_fm_xhp_x`:

    kdb mount --resolver=resolver_fm_xhp_x file.dump /example dump
    kdb file user/example
    kdb file system/example

Will show you that for both user+system the resolver respects
XDG environment variables, e.g. above lines will print:

    /home/m/.config/file.dump
    /etc/xdg/file.dump

Of course, any attempts to get and set keys below user/example and
system/example will also be in these files.

The letters after `_` describe the variant of the resolver:

- `f` .. file based locking
- `m` .. mutex based locking (for multiple KDB per process)
- for user configuration (after next `_`)
  - `x` .. first check `XDG_CONFIG_HOME` environment
  - `h` .. then check `HOME` environment
  - `p` .. then fall back to passwd
- for system configuration (after next `_`)
  - `x` .. check all paths in `XDG_CONFIG_DIRS` and falls back to `/etc/xdg`

A lot of such resolver variants are added when `-DPLUGINS=ALL` is used.
Of course you can create new variants with different behaviour by adding
them to PLUGINS.

To make your application (that uses Elektra) XDG aware, you have nothing
to do: you get it to free. Make sure to always use cascading lookup.
Additionally, an XDG conforming application should not write system/
keys.

## OpenICC Compatibility

Based on that, Elektra now also implements the draft for
[the OpenICC specification](https://www.openicc.info/index.php%3Ftitle=OpenICC_Configuration_0.1.html).

The mount command looks like quite complicated, but it consists of
simple parts:

    kdb mount --resolver=resolver_fm_xhp_x \
      color/settings/openicc-devices.json /org/freedesktop/openicc \
      yajl rename cut=org/freedesktop/openicc

We already know the first two lines: we use the XDG resolver already
introduced above. Only the file name and the path where it should be
mounted differs.

The plugin yajl is a storage plugin that reads/writes json. The plugin
rename was the missing link to support OpenICC (thanks to Felix
Berlakovich for closing this gap). It is needed, because every OpenICC
file starts like this:

    { "org": { "freedesktop": { "openicc": {

Because the backend is mounted at /org/freedesktop/openicc, it would
lead to keys below /org/freedesktop/openicc/org/freedesktop/openicc
which we obviously do not want. So we simply get rid of the common
prefix by cutting it out using the rename plugin.

Of course this renaming functionality can be used in every situation and
is not limited to OpenICC.

## Tools

A large number of old and new tools were added, mostly for convenience
e.g.:

    kdb mount-openicc

saves you from writing the long mount command we had in the previous
section.

To get a list of all tools that are installed, now the command (which is
also an external tool and as such currently not displayed in kdb --help):

    kdb list-tools

is available. Do not be surprised: on typical installations this will
be a large list. You can run each of these tools by using kdb <command>.
Most of the tools, however, are part of the test suite,
which you can run using:

    kdb run_all

Other tools are "old friends", e.g. convert-fstab written in 2006 by Avi
Alkalay still works:

    kdb convert-fstab | kdb import system/filesystems xmltool

It will parse your /etc/fstab and generate a XML. This XML then can be
imported. Other convert tools directly produce kdb commands, though.

kdb now uses KDB itself for many commands:

- /sw/kdb/current/resolver .. You always want a different default
  resolver than that was compiled in as default when mounting
  backends?
- /sw/kdb/current/format .. If you are annoyed by the default format
  dump format for import/export.
- /sw/kdb/current/plugins .. If you always forget to add some plugins
  when mounting something.

By default the plugin "sync" is added automatically (it makes sure that
fsync is executed on config files, the directory is already done by the
resolver), you should not remove it from /sw/kdb/current/plugins
otherwise the next mount command will not add it. To preserve it use a
space separated list, e.g.:

    kdb set user/sw/kdb/current/plugins "sync syslog"

Last, but not least, kdb get now supports cascading get:

    kdb get /sw/kdb/current/plugins

This feature allows you to see the configuration exactly as seen by the
application.

Other options:

- -123 options for hiding nth column in `kdb mount`
- hide warnings during script usage of `kdb mount`
- -0 option accepted in some tools (null termination)
- Mount got a new -c option for backend configuration. For example
  -c cut=org/freedesktop/openicc would be the parameter cut for all
  plugins. Have a look at #146 if you want to use it.

## Compatibility

The core API (kdb.h), as always, stayed API/ABI compatible. The only
changes in kdb.h is the addition of `KEY_CASCADING_NAME` and
`KEY_META_NAME`. So applications compiled against 0.8.10 and using these
constants, will not work with Elektra 0.8.9.

The constants allow us to create following kinds of keys:

- empty names: this was always possible, because invalid names
  (including empty names) did not cause keyNew to abort
- metanames: this is a new feature that allows us to compare key names
  with metakeys
- cascading names: names starting with / have the special meaning that
  they do not specify which namespace they have. When such names are
  used for
  - kdbGet() and kdbSet() keys are retrieved from all namespaces
  - ksLookup() keys are searched in all namespaces
  - ksLookupByName() is now just a wrapper for ksLookup().
    The method does not do much except creating a key and passing
    them to ksLookup().

Usage in C is:

    Key *c = keyNew("/org/freedesktop", KEY_CASCADING_NAME, KEY_END);
    Key *m = keyNew("comment/#0", KEY_META_NAME, KEY_END);

The same functionality exists, of course, in available in all bindings,
too.

Changes in non-core API are:

- xmltool now does not output default (unchanged) uid,gid and mode
- ksLookupBySpec from kdbproposal.h was removed, is now integrated into
  ksLookup
- extension keyNameGetNamespace was removed
- the hosts comment format has changed
- the default resolver has changed (uses passwd)
- kdb::tools::Backend::Backend constructor, tryPlugin and addPlugin
  have changed:
- mountname is now automatically calculated
- addPlugin allows us to add a KeySet to validate plugins with different
  contracts correctly
- C++ binding now throws std::bad_alloc on allocation problems (and not
  InvalidName)

## CMake

It is now possible to remove a plugin/binding/tools by prefixing a name
with "-". The new "-element" syntax is accepted by TOOLS, BINDINGS and
PLUGINS. It is very handy in combination with ALL, e.g.:

    -DPLUGINS="ALL;-xmltool"

will include all plugins except xmltool.

## Improved comments

Comment preserving was improved a lot. Especially, the hosts plugin was
rewritten completely. Now multiple different comment styles can be
intermixed without losing information. E.g. some INI formats support
both ; and # for comments. With the new comments it is possible to
preserve that information and even better: applications can iterate
over that information (metadata).

To mount the new hosts plugin use (if you already have mounted it, you
have nothing to do):

    kdb mount /etc/hosts system/hosts hosts

The hosts plugin now separates from ipv4 and ipv6 which makes the host
names canonical again, e.g.:

    kdb get system/hosts/ipv4/localhost
    kdb get system/hosts/ipv6/localhost

To access the inline-comment, use:

    kdb getmeta system/hosts/ipv4/localhost "comment/#0"

For other meta information, see:

    kdb lsmeta system/hosts/ipv4/localhost

Additionally, a small API for specific metadata operations emerges.
These operations will be moved to a separate library and will not stay
in Elektra’s core library.

## Proposal

- lookup options:
  - `KDB_O_SPEC` uses the lookup key as specification
  - `KDB_O_CREATE` creates a key if it could not be found
- `elektraKeyGetMetaKeySet` creates a KeySet from metadata
- `elektraKsFilter` allows us to filter a KeySet arbitrarily (not only
  `keyIsBelow` in case of `ksCut`). It reintroduces more functional
  programming.
- `keyGetNamespace` was reintroduced. In one of the next versions of
  Elektra we will introduce new namespaces. `keyGetNamespace` allows the
  compiler to output a warning when some namespaces are not handled in
  your C/C++ code.

## Java binding

Elektra now fully supports applications written in Java and also Plugins
written in the same language.

The
[new binding was developed using jna.](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/jna)
For the
[plugin interface JNI](https://github.com/ElektraInitiative/libelektra/tree/master/src/plugins/jni)
was used.
We developed already
[some plugins](https://master.libelektra.org/src/bindings/jna/libelektra4j/src/main/java/org/libelektra/plugin).

## Qt-Gui

Raffael Pancheri released the version 0.0.2 of the Qt-Gui:

- added Backend Wizard for mounting
- user can hover over TreeView items and quickly see key name, key value
  and metakeys
- it is now easily possible to create and edit arrays
- added header to MetaArea for better clarity
- many small layout and view update fixes

## Further stuff and small fixes

- Two new error/warnings information: mountpoint and configfile.
  It is added automatically and all tools will print it.
- C++ I/O for key(s) now allows null terminator next to new-line
  terminator
- fix error plugin: now use `on_open`/`trigger_warnings` to be consistent
- fix metaset: now correctly append new key
- arrays are also available when compiled with mingw
  (but tests still have to be excluded for successful compilation)
- fix #136
- fix long help text in `kdb check`
- signed release tags are now used

## Get It!

You can download the release from
[here](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.10.tar.gz)

- size: 1915277
- md5sum: 2b16a4b555bc187562a0b38919d822a1
- sha1: 08b1d0139fc5eb0d03c52408478e68b91b1825dc
- sha256: 526e2ed61e87d89966eb36ddad78d8139b976e01ce18aab340d8a1df47132355

already built API-Docu can be found
[here](https://doc.libelektra.org/api/0.8.10/html/)

## Stay tuned!

Subscribe to the
[new RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/6ce57ecf-420a-4a31-821e-1c5fe5532eb4.html)

For more information, see https://www.libelektra.org

Best regards,
Markus
