# Augeas and Config::Model

- author: Markus Raab
- guid: eca69e19-5ddb-438c-ac06-57c20b1a9160
- pubDate: Mon, 22 Oct 2014 17:31:42 +0200

A common question is: now we have Augeas for editing config files,
why do we need Elektra, Config::Model or something else?

First, it is clear that Augeas is a huge step forward and improved
configuration of Linux systems, especially when used with centralized
configuration management tools.

Augeas, in short, introduces a special-purpose programming language that
allows to transform configuration files into configuration trees and
back. This transformation is it strength (so it is easy to add support
for a particular legacy configuration files), but also it weakness (the
mapping is implementation-defined by a language that is limited to a bit
more than regular expressions). Augeas is not able nor is it intended
to provide more abstraction over the configuration files. Instead Augeas
mirrors the structure of the configuration as closely as possible.

Elektra’s goal, instead, is not only to provide access to legacy
configuration files, but to provide access to the configuration
exactly as the programs itself uses it. So with Elektra, the developers of
applications are part of Elektra’s ecosystem by providing specifications
how their configuration should look like and by writing plugins that
define how the configuration is accessed and checked. Ideally, after
some time of legacy issues and migration, developers will also not
have to care about writing plugins anymore, but just use any available
ones (and users of their application can choose any other compatible
plugin). What is about to stay is a specification that defines the
application's configuration, e.g. in INI (could be any syntax):

    [/yourapp/file_dialog/show_hidden_files]
    type=Boolean
    default=true

allows other applications to reuse your setting show_hidden_files by
referring to above specification. So Elektra not only abstracts from
cross-platform-related issues with an consistent API, but also allows
us to be aware of other applications' configurations, leveraging easy
application integration.

Config::Model shares most of Elektra’s goals, especially those regarding
validation (you saw the type=Boolean above) and having a unified
interface for all programs (this feature is unavoidable with any such
approach). The projects mainly differs that Elektra is supposed to be used
by the programs themselves (and not only by GUIs and validation tools)
and that Elektra uses self-describing data: the specification itself
is also in Elektra’s key database, stored in metadata and e.g. below
system/elektra/mountpoints. In Elektra validators can be
written in any language (because the specification is just data)
and can enforce constraints on any access (because plugins define
the behaviour of the key database).
