# Ideas for Contributing to Elektra

Thank you for being interested in contributing to Elektra!

## How can I get started?

We prepared
[good first issues](https://github.com/ElektraInitiative/libelektra/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22)
for you.

- We encourage you to improve documentation.
- In the source code, you should look into [libs](/src/libs/) and [plugins](/src/plugins/).
- You can always peek into the [TODOs](/doc/todo), if you don't know what to do.
- An ideal project is to [elektrify](/doc/help/elektra-glossary.md) some free software.

Elektrify means:

- Patch the application so that it uses Elektra as its configuration system.
- Write a specification that describes how the configuration of the application
  looks like.

If you are interested in directly improving Elektra, other projects might be of
more interest to you:

- Further configuration file formats could be supported.
- The tools could be improved.

## What are the requirements to participate?

Anyone can join!

First you should familiarize with the Elektra Initiative:

- If you did not yet look at the [home page](https://www.libelektra.org/) please do so!
- Look into the [contributing guidelines](/.github/CONTRIBUTING.md)
- Look into the [issue tracker](https://issues.libelektra.org/) and pick an easy task.
- Say hello in the issue you are interested in participating, or create a new issue.
- Create a PR which solves the issue.
- We will give you further feedback.
