# Documentation

We use a fork and pull model, you can read about
[forking repos at github help](https://help.github.com/articles/fork-a-repo/).

Any typo fixes, spelling fixes, fixes in documentation,
or README.md can be done without any further considerations!
Simply do the fixes in your cloned repo and create a pull request.

# Issues

If you have any questions you can ask them using
[github issue](https://github.com/ElektraInitiative/libelektra/issues/new).
Simply ignore the template in this case.

See also [FAQ](/doc/help/elektra-faq.md) for some details
about creating issues.

# General

We recommend that you read:

- [The big picture what Elektra is](/doc/BIGPICTURE.md)
- [The tutorials to get some practice](/doc/tutorials/)

# Code

Before you issue a pull request that modifies code:

- You should read the [coding document](/doc/CODING.md).
- Make sure you fulfilled the [checklist](/.github/PULL_REQUEST_TEMPLATE.md).

# Architecture

Before you start making fundamental changes:

- Propose it by creating a [github issue](https://github.com/ElektraInitiative/libelektra/issues/new)
  for discussions.
- You should read the [design document](/doc/DESIGN.md).
- Create a [decision](/doc/decisions/README.md) describing you want to do
  to keep the discussion more efficient and architecture documented.

# Labels

- If you do not want your PR to be merged, please label
  the PR with the label "work in progress".
- If you included changes after a review and you think you
  are ready, please tag your PR with the label "ready to merge".
