#ifndef NET_SNMP_INCLUDES_H
#define NET_SNMP_INCLUDES_H

    /**
     *  Convenience header file to pull in the full
     *     Net-SNMP library API in one go, together with
     *     certain commonly-required system header files.
     */


#ifndef NET_SNMP_CONFIG_H
#error "Please include <net-snmp/net-snmp-config.h> before this file"
#endif

#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

    /*
     *  The full Net-SNMP API
     */
#include <net-snmp/definitions.h>
#include <net-snmp/types.h>

#include <net-snmp/library/getopt.h>
#include <net-snmp/utilities.h>
#include <net-snmp/session_api.h>
#include <net-snmp/pdu_api.h>
#include <net-snmp/mib_api.h>
#include <net-snmp/varbind_api.h>
#include <net-snmp/config_api.h>
#include <net-snmp/output_api.h>
#include <net-snmp/snmpv3_api.h>


#ifdef RTK_NETSNMP_PATCH
#include <libsal/sal_snmp.h>

/*
 * To debug snmpd invoke "exit()" when error occurred.
 */
#ifndef SNMPD_EXIT_OVERWRITE
#define SNMPD_EXIT_OVERWRITE
#define exit(__r__)             SNMP_DBG("Exit()!!!");sal_util_dump_stack();raise(9)
#endif /* SNMPD_EXIT_OVERWRITE */

#define SNMP_DBG(__fmt__, ...)  snmp_dbg_prt("%s: "__fmt__" (%lu, %d)\n", __func__, ##__VA_ARGS__, now_ms(), __LINE__)
#define SEC_TO_MSEC(__x__)      ((__x__)*1000)
#define USEC_TO_MSEC(__x__)     ((__x__)/1000)

#define swapl32(x)\
        ((((x) & 0xff000000U) >> 24) | \
         (((x) & 0x00ff0000U) >>  8) | \
         (((x) & 0x0000ff00U) <<  8) | \
         (((x) & 0x000000ffU) << 24))



#include <fcntl.h>
static inline unsigned int now_ms(void)
{
    struct timeval tv;
    struct timezone tz;
    unsigned int msecs;

    gettimeofday(&tv, &tz);
    msecs = (unsigned int)(SEC_TO_MSEC(tv.tv_sec) + USEC_TO_MSEC(tv.tv_usec));

    return msecs;
}
static inline void snmp_dbg_prt(char *pFmt, ...)
{
    FILE *fp;
    char buffer[1024 + 1] = {0};
    va_list args;
    int n;

    fp = fopen(SNMP_DBG_FILE, "a");

    va_start(args, pFmt);
    n = vsnprintf(buffer, 1024, pFmt, args);
    va_end(args);

    fprintf(fp, buffer);
    fclose(fp);
}
#endif /* RTK_NETSNMP_PATCH */

#endif                          /* NET_SNMP_INCLUDES_H */
