/*
 * Copyright (C) 2010 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: 9406 $
 * $Date: 2010-05-06 10:16:46 +0800 (Thu, 06 May 2010) $
 *
 * Purpose : CLI Main
 *
 * Feature :
 *
 */

#ifndef __CLI_MAIN_H__
#define __CLI_MAIN_H__


/*
 * Include Files
 */
#include <common/sys_def.h>

/*
 * Symbol Definition
 */

/*
 * Data Declaration
 */

/*
 * Macro Declaration
 */
#define CLI_ERR_HDL(op)                     \
do {                                        \
    int32 err;                              \
    if ((err = (int32)(op)) != SYS_ERR_OK) \
        cli_cmd_errHandle(err);             \
} while(0)

/*
 * Function Declaration
 */
extern void cli_cmd_dump(void);

/* Function Name:
 *      cli_cmd_init
 * Description:
 *      CLI command init
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      SYS_ERR_OK
 * Note:
 *      None
 */
extern int32 cli_cmd_init(void);

/* Function Name:
 *      cli_cmd_errHandle
 * Description:
 *      CLI command error handling
 * Input:
 *      cmdErr - command error id
 * Output:
 *      None
 * Return:
 *      SYS_ERR_OK
 * Note:
 *      None
 */
extern int32 cli_cmd_errHandle(int cmdErr);


#endif /* __CLI_MAIN_H__ */

