/*
 * Copyright (C) 2010 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: 16319 $
 * $Date: 2011-03-17 13:37:50 +0800 (Thu, 17 Mar 2011) $
 *
 * Purpose : CLI Main
 *
 * Feature :
 *
 */

/*
 * Include Files
 */
#include <cli/cli_main.h>
#include <cli/cli_debug.h>
#include <cli/cli_readline_use.h>

#include <libcmd/cmd.h>
#ifdef CONFIG_SYS_PLAT_DBGMOD
#include <libclicmd/cmd_debug.h>
#endif


/*
 * Symbol Definition
 */

/*
 * Data Declaration
 */

/*
 * Macro Definition
 */

/*
 * Function Declaration
 */

static void install_commands(const cmd_inst_tbl_t *tbl)
{
    uint32 i;
    uint32 isConfig = FALSE;

    if (tbl == cmdSetTbl)
        isConfig = TRUE;
    /* Register commands to CLI engine */
    i = 0;
    while (NULL != tbl[i].cmdset)
    {
        if (NULL != tbl[i].cmdext)
        {
            tbl[i].cmdext(tbl[i].nodemask,
                          tbl[i].attrmask,
                          tbl[i].cmdset,
                          tbl[i].cmdstr,
                          tbl[i].cmddesc);

            i++;
            continue;
        }

        cmd_util_install(tbl[i].nodemask,
                         tbl[i].attrmask,
                         tbl[i].cmdset,
                         tbl[i].cmdstr,
                         tbl[i].cmddesc,
                         isConfig,
                         NULL);

        i++;
    }
}

void cli_cmd_dump(void)
{
    install_commands((const cmd_inst_tbl_t *)cmdSetTbl);
    install_commands((const cmd_inst_tbl_t *)cmdCommonTbl);


    cli_debug_install_command();
    cli_readline_use_command_install();

#ifdef CONFIG_SYS_PLAT_DBGMOD
    install_commands((const cmd_inst_tbl_t *)cmdDebugTbl);
#endif

    SYS_PRINTF("{%d} %s\n", ENABLE_NODE, "configure");
    SYS_PRINTF("{%d} %s\n", ENABLE_NODE, "configure");

    return;
}

/* Function Name:
 *      cli_cmd_init
 * Description:
 *      CLI command init
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      SYS_ERR_OK
 * Note:
 *      None
 */
int32 cli_cmd_init (void)
{
    install_commands((const cmd_inst_tbl_t *)cmdSetTbl);
    install_commands((const cmd_inst_tbl_t *)cmdCommonTbl);


    cli_debug_install_command();
#ifndef CONFIG_SYS_UI_MINICLI
    cli_readline_use_command_install();
#endif

#ifdef CONFIG_SYS_PLAT_DBGMOD
    install_commands((const cmd_inst_tbl_t *)cmdDebugTbl);
#endif /* CONFIG_SYS_PLAT_DBGMOD */

    return SYS_ERR_OK;
}

/* Function Name:
 *      cli_cmd_errHandle
 * Description:
 *      CLI command error handling
 * Input:
 *      cmdErr - command error id
 * Output:
 *      None
 * Return:
 *      SYS_ERR_OK
 * Note:
 *      None
 */
int32 cli_cmd_errHandle(int cmdErr)
{
    SYS_PRINTF("%s\n", SYS_ERR_STR(cmdErr));
    return SYS_ERR_OK;
}

