/*
 * Copyright (C) 2021 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision$
 * $Date$
 *
 * Purpose : RTK switch soc driver
 *
 * Feature : RTK switch soc driver
 *
 */

#ifndef __RTK_SW_H__
#define __RTK_SW_H__

/*
 * Include Files
 */

/*
 * Symbol Definition
 */


#define RT_ERR_OK           0
#define RT_ERR_FAILED       (-1)
#define RT_ERR_INPUT        0xF001


#define RTK_BSP_DEFAULT_UNIT    0

typedef struct rtk_bsp_mapper_s {
    int   (*chip_reset)(void);
    int   (*irq_get)(unsigned int, unsigned int *, unsigned int *);
} rtk_bsp_mapper_t;


typedef struct rtk_sw_match_data_s {
    int (*mapper_hook)(rtk_bsp_mapper_t *);
} rtk_sw_match_data_t;


/*
 * Macro Definition
 */

/* Interrupt device tree node name */
#define DTS_NODE_NULL                                      "rtk_null"
#define DTS_NODE_TC0                                       "tc0"
#define DTS_NODE_TC1                                       "tc1"
#define DTS_NODE_TC2                                       "tc2"
#define DTS_NODE_TC3                                       "tc3"
#define DTS_NODE_TC4                                       "tc4"
#define DTS_NODE_TC5                                       "tc5"
#define DTS_NODE_TC6                                       "tc6"
#define DTS_NODE_WDT_PH1TO                                 "wdt_ph1to"
#define DTS_NODE_WDT_PH2TO                                 "wdt_ph2to"
#define DTS_NODE_RXI300                                    "rxi300"
#define DTS_NODE_DRAM_BUS_INTR                             "dram_bus_intr"
#define DTS_NODE_DFI_INTR                                  "dfi_intr"
#define DTS_NODE_DFI_ECC_INTR                              "dfi_ecc_intr"
#define DTS_NODE_SPIF_INTR_R                               "spif_intr_r"
#define DTS_NODE_UART0                                     "uart0"
#define DTS_NODE_UART1                                     "uart1"
#define DTS_NODE_UART2                                     "uart2"
#define DTS_NODE_GPIO_ABCD                                 "gpio_abcd"
#define DTS_NODE_TC4_DELAY_INT                             "tc4_delay_int"
#define DTS_NODE_TC5_DELAY_INT                             "tc5_delay_int"
#define DTS_NODE_TC6_DELAY_INT                             "tc6_delay_int"
#define DTS_NODE_LXSTO                                     "lxsto"
#define DTS_NODE_LXMTO                                     "lxmto"
#define DTS_NODE_BTG                                       "btg"
#define DTS_NODE_Parallel_NAND                             "parallel_nand"
#define DTS_NODE_SPI_NAND                                  "spi_nand"
#define DTS_NODE_ECC                                       "ecc"
#define DTS_NODE_USB_H2                                    "usb_h2"
#define DTS_NODE_PCIE_RC_MSI                               "pcie_rc_msi"
#define DTS_NODE_PCIE_RC_INT_LINK_REQ_RST                  "pcie_rc_int_link_req_rst"
#define DTS_NODE_PCIE_RC_INT_A                             "pcie_rc_int_a"
#define DTS_NODE_PCIE_RC_INT_B                             "pcie_rc_int_b"
#define DTS_NODE_PCIE_RC_INT_C                             "pcie_rc_int_c"
#define DTS_NODE_PCIE_RC_INT_D                             "pcie_rc_int_d"
#define DTS_NODE_PCIE_EP_INT                               "pcie_ep_int"
#define DTS_NODE_PCIE_EP_INT_LINK_REQ_RST                  "pcie_ep_int_link_req_rst"
#define DTS_NODE_INT_GMAC_INTR                             "int_gmac_intr"
#define DTS_NODE_SRAM_ECC_INTR                             "sram_ecc_intr"
#define DTS_NODE_TM_INTR                                   "tm_intr"
#define DTS_NODE_NIC_RX_DONE_0                             "nic_rx_done_0"
#define DTS_NODE_NIC_RX_DONE_1                             "nic_rx_done_1"
#define DTS_NODE_NIC_RX_DONE_2                             "nic_rx_done_2"
#define DTS_NODE_NIC_RX_DONE_3                             "nic_rx_done_3"
#define DTS_NODE_NIC_RX_DONE_4                             "nic_rx_done_4"
#define DTS_NODE_NIC_RX_DONE_5                             "nic_rx_done_5"
#define DTS_NODE_NIC_RX_DONE_6                             "nic_rx_done_6"
#define DTS_NODE_NIC_RX_DONE_7                             "nic_rx_done_7"
#define DTS_NODE_NIC_RX_DONE_8                             "nic_rx_done_8"
#define DTS_NODE_NIC_RX_DONE_9                             "nic_rx_done_9"
#define DTS_NODE_NIC_RX_DONE_10                            "nic_rx_done_10"
#define DTS_NODE_NIC_RX_DONE_11                            "nic_rx_done_11"
#define DTS_NODE_NIC_RX_RUNOUT_0                           "nic_rx_runout_0"
#define DTS_NODE_NIC_RX_RUNOUT_1                           "nic_rx_runout_1"
#define DTS_NODE_NIC_RX_RUNOUT_2                           "nic_rx_runout_2"
#define DTS_NODE_NIC_RX_RUNOUT_3                           "nic_rx_runout_3"
#define DTS_NODE_NIC_RX_RUNOUT_4                           "nic_rx_runout_4"
#define DTS_NODE_NIC_RX_RUNOUT_5                           "nic_rx_runout_5"
#define DTS_NODE_NIC_RX_RUNOUT_6                           "nic_rx_runout_6"
#define DTS_NODE_NIC_RX_RUNOUT_7                           "nic_rx_runout_7"
#define DTS_NODE_NIC_RX_RUNOUT_8                           "nic_rx_runout_8"
#define DTS_NODE_NIC_RX_RUNOUT_9                           "nic_rx_runout_9"
#define DTS_NODE_NIC_RX_RUNOUT_10                          "nic_rx_runout_10"
#define DTS_NODE_NIC_RX_RUNOUT_11                          "nic_rx_runout_11"
#define DTS_NODE_NIC_TX_0                                  "nic_tx_0"
#define DTS_NODE_NIC_TX_1                                  "nic_tx_1"
#define DTS_NODE_NIC_TX_2                                  "nic_tx_2"
#define DTS_NODE_NIC_TX_3                                  "nic_tx_3"
#define DTS_NODE_IGLB_OAM_DYGASP                           "iglb_oam_dygasp"
#define DTS_NODE_IGLB_RLFD                                 "iglb_rlfd"
#define DTS_NODE_IGLB_MISC                                 "iglb_misc"
#define DTS_NODE_L2_NTFY_LOCAL_NTFY_BUF_RUN_OUT            "l2_ntfy_local_ntfy_buf_run_out"
#define DTS_NODE_L2_NTFY_RX_RUN_OUT                        "l2_ntfy_rx_run_out"
#define DTS_NODE_L2_NTFY_RX_DONE                           "l2_ntfy_rx_done"
#define DTS_NODE_AXI_MASTER                                "axi_master"

#define DTS_NODE_REG_SWCORE                                "switchreg"
#define DTS_NODE_REG_SOC                                   "socreg"

/*
 * Function Declaration
 */


/* Function Name:
 *      bsp_mem32_read
 * Description:
 *      Get the value from register.
 * Input:
 *      unit - unit id
 *      addr - register address
 * Output:
 *      pVal - pointer buffer of the register value
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 * Note:
 *      1. Support single unit right now and ignore unit
 *      2. When we support the multiple chip in future, we will check the input unit
 */
extern int32_t
bsp_mem32_read(uint32_t unit, uint32_t addr, uint32_t *pVal);

/* Function Name:
 *      bsp_mem32_write
 * Description:
 *      Set the value to register.
 * Input:
 *      unit - unit id
 *      addr - register address
 *      val  - the value to write register
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 * Note:
 *      1. Support single unit right now and ignore unit
 *      2. When we support the multiple chip in future, we will check the input unit
 */
extern int32_t
bsp_mem32_write(uint32_t unit, uint32_t addr, uint32_t val);

extern int32_t
rtk_sw_socBaseAddr_get(void __iomem **addr);
extern int32_t
rtk_sw_swcoreBaseAddr_get(void __iomem **addr);

#endif /* __RTK_SW_H__ */
