/*
 * Realtek Semiconductor Corp.
 *
 * bsp/bspchip.h:
 *   bsp chip address and IRQ mapping file
 *
 * Copyright (C) 2006-2015 Tony Wu (tonywu@realtek.com)
 */

#ifndef _BSPCHIP_H_
#define _BSPCHIP_H_

#include <linux/version.h>

#define UART0_IRQ                   31
#define UART1_IRQ                   30
#define TC0_IRQ                     29
#define TC1_IRQ                     28
#define OCPTO_IRQ                   27
#define HLXTO_IRQ                   26
#define SLXTO_IRQ                   25
#define NIC_IRQ                     24
#define GPIO_ABCD_IRQ               23
#define GPIO_EFGH_IRQ               22
#define RTC_IRQ                     21
#define	SWCORE_IRQ                  20
#define WDT_IP1_IRQ                 19
#define WDT_IP2_IRQ                 18
#define USB_H2_IRQ                  17
#define TC2_IRQ                     16
#define TC3_IRQ                     15
#define TC4_IRQ                     14
#define TC5_IRQ                     13
#define TC6_IRQ                     12
#define NIC_RX_DONE_0_IRQ           32
#define NIC_RX_DONE_1_IRQ           33
#define NIC_RX_DONE_2_IRQ           34
#define NIC_RX_DONE_3_IRQ           35
#define NIC_RX_DONE_4_IRQ           36
#define NIC_RX_DONE_5_IRQ           37
#define NIC_RX_DONE_6_IRQ           38
#define NIC_RX_DONE_7_IRQ           39
#define NIC_RX_DONE_8_IRQ           40
#define NIC_RX_DONE_9_IRQ           41
#define NIC_RX_DONE_10_IRQ          42
#define NIC_RX_DONE_11_IRQ          43
#define NIC_RX_RUNOUT_0_IRQ         44
#define NIC_RX_RUNOUT_1_IRQ         45
#define NIC_RX_RUNOUT_2_IRQ         46
#define NIC_RX_RUNOUT_3_IRQ         47
#define NIC_RX_RUNOUT_4_IRQ         48
#define NIC_RX_RUNOUT_5_IRQ         49
#define NIC_RX_RUNOUT_6_IRQ         50
#define NIC_RX_RUNOUT_7_IRQ         51
#define NIC_RX_RUNOUT_8_IRQ         52
#define NIC_RX_RUNOUT_9_IRQ         53
#define NIC_RX_RUNOUT_10_IRQ        54
#define NIC_RX_RUNOUT_11_IRQ        55
#define NIC_TX_0_IRQ                56
#define NIC_TX_1_IRQ                57
#define NIC_TX_2_IRQ                58
#define NIC_TX_3_IRQ                59


/*  * IRQ Controller  */
#define BSP_IRQ_CPU_BASE            0
#define BSP_IRQ_CPU_NUM             8

#define BSP_IRQ_ICTL_BASE           (BSP_IRQ_CPU_BASE + BSP_IRQ_CPU_NUM)

#define BSP_UART0_EXT_IRQ           (BSP_IRQ_ICTL_BASE + UART0_IRQ)
#define BSP_UART1_EXT_IRQ           (BSP_IRQ_ICTL_BASE + UART1_IRQ)
#define BSP_TC0_EXT_IRQ             (BSP_IRQ_ICTL_BASE + TC0_IRQ)
#define BSP_TC1_EXT_IRQ             (BSP_IRQ_ICTL_BASE + TC1_IRQ)
#define BSP_OCPTO_EXT_IRQ           (BSP_IRQ_ICTL_BASE + OCPTO_IRQ)
#define BSP_HLXTO_EXT_IRQ           (BSP_IRQ_ICTL_BASE + HLXTO_IRQ)
#define BSP_SLXTO_EXT_IRQ           (BSP_IRQ_ICTL_BASE + SLXTO_IRQ)
#define BSP_NIC_EXT_IRQ             (BSP_IRQ_ICTL_BASE + NIC_IRQ)
#define BSP_GPIO_ABCD_EXT_IRQ       (BSP_IRQ_ICTL_BASE + GPIO_ABCD_IRQ)
#define BSP_GPIO_EFGH_EXT_IRQ       (BSP_IRQ_ICTL_BASE + GPIO_EFGH_IRQ)
#define BSP_SWCORE_EXT_IRQ          (BSP_IRQ_ICTL_BASE + SWCORE_IRQ)
#define	BSP_WDT_IP1_IRQ             (BSP_IRQ_ICTL_BASE + WDT_IP1_IRQ)
#define	BSP_WDT_IP2_IRQ             (BSP_IRQ_ICTL_BASE + WDT_IP2_IRQ)
#define	BSP_USB_H2_IRQ              (BSP_IRQ_ICTL_BASE + USB_H2_IRQ)
#define BSP_TC2_EXT_IRQ             (BSP_IRQ_ICTL_BASE + TC2_IRQ)
#define BSP_TC3_EXT_IRQ             (BSP_IRQ_ICTL_BASE + TC3_IRQ)
#define BSP_TC4_EXT_IRQ             (BSP_IRQ_ICTL_BASE + TC4_IRQ)
#define BSP_TC5_EXT_IRQ             (BSP_IRQ_ICTL_BASE + TC5_IRQ)
#define BSP_TC6_EXT_IRQ             (BSP_IRQ_ICTL_BASE + TC6_IRQ)
#define BSP_NIC_RX_DONE_0_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_0_IRQ)
#define BSP_NIC_RX_DONE_1_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_1_IRQ)
#define BSP_NIC_RX_DONE_2_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_2_IRQ)
#define BSP_NIC_RX_DONE_3_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_3_IRQ)
#define BSP_NIC_RX_DONE_4_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_4_IRQ)
#define BSP_NIC_RX_DONE_5_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_5_IRQ)
#define BSP_NIC_RX_DONE_6_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_6_IRQ)
#define BSP_NIC_RX_DONE_7_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_7_IRQ)
#define BSP_NIC_RX_DONE_8_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_8_IRQ)
#define BSP_NIC_RX_DONE_9_IRQ       (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_9_IRQ)
#define BSP_NIC_RX_DONE_10_IRQ      (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_10_IRQ)
#define BSP_NIC_RX_DONE_11_IRQ      (BSP_IRQ_ICTL_BASE + NIC_RX_DONE_11_IRQ)
#define BSP_NIC_RX_RUNOUT_0_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_0_IRQ)
#define BSP_NIC_RX_RUNOUT_1_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_1_IRQ)
#define BSP_NIC_RX_RUNOUT_2_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_2_IRQ)
#define BSP_NIC_RX_RUNOUT_3_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_3_IRQ)
#define BSP_NIC_RX_RUNOUT_4_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_4_IRQ)
#define BSP_NIC_RX_RUNOUT_5_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_5_IRQ)
#define BSP_NIC_RX_RUNOUT_6_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_6_IRQ)
#define BSP_NIC_RX_RUNOUT_7_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_7_IRQ)
#define BSP_NIC_RX_RUNOUT_8_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_8_IRQ)
#define BSP_NIC_RX_RUNOUT_9_IRQ     (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_9_IRQ)
#define BSP_NIC_RX_RUNOUT_10_IRQ    (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_10_IRQ)
#define BSP_NIC_RX_RUNOUT_11_IRQ    (BSP_IRQ_ICTL_BASE + NIC_RX_RUNOUT_11_IRQ)
#define BSP_NIC_TX_0_IRQ            (BSP_IRQ_ICTL_BASE + NIC_TX_0_IRQ)
#define BSP_NIC_TX_1_IRQ            (BSP_IRQ_ICTL_BASE + NIC_TX_1_IRQ)
#define BSP_NIC_TX_2_IRQ            (BSP_IRQ_ICTL_BASE + NIC_TX_2_IRQ)
#define BSP_NIC_TX_3_IRQ            (BSP_IRQ_ICTL_BASE + NIC_TX_3_IRQ)

#define RTK_BSP_ENABLE              1
#define RTK_BSP_DISABLE             0

#endif   /* _BSPCHIP_H */
