#ifndef ___REG_SPI_NOR_RXI310_H__
#define ___REG_SPI_NOR_RXI310_H__ 1
#include <reg_skc35.h>

#include <reg_map_util.h>
#ifdef CONFIG_UNDER_UBOOT
#include <common.h>
#define BYTE_ORDER __BYTE_ORDER
#else// ATF, FIXME
#define BYTE_ORDER __BYTE_ORDER
//#include <endian.h>
#endif

#ifndef __BYTE_ORDER__
#	error "__BYTE_ORDER__ is not defined"
#endif

#if (__BYTE_ORDER__ != __ORDER_BIG_ENDIAN__) && \
    (__BYTE_ORDER__ != __ORDER_LITTLE_ENDIAN__)
#	error "unknown __BYTE_ORDER__ value"
#endif

#ifndef _REG_SPI_NOR_RXI310
#	define _REG_SPI_NOR_RXI310 (0x01020000)
#endif

SKC35_REG_DEC(
	CTRLR0, (_REG_SPI_NOR_RXI310 + 0x0),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 31, prm_2nd_phase);
	RFIELD(30, 28, ddr_en);
	RFIELD(27, 23, ck_mtimes);
	RFIELD(22, 22, fast_rd);
	RFIELD(21, 20, cmd_ch);
	RFIELD(19, 18, data_ch);
	RFIELD(17, 16, addr_ch);
	RF_RSV(15, 10);
	RFIELD(9, 8, tmod);
	RFIELD(7, 7, scpol);
	RFIELD(6, 6, scph);
	RF_RSV(5, 0);
#else
	RF_RSV(5, 0);
	RFIELD(6, 6, scph);
	RFIELD(7, 7, scpol);
	RFIELD(9, 8, tmod);
	RF_RSV(15, 10);
	RFIELD(17, 16, addr_ch);
	RFIELD(19, 18, data_ch);
	RFIELD(21, 20, cmd_ch);
	RFIELD(22, 22, fast_rd);
	RFIELD(27, 23, ck_mtimes);
	RFIELD(30, 28, ddr_en);
	RFIELD(31, 31, prm_2nd_phase);
#endif
	);

SKC35_REG_DEC(
	CTRLR1, (_REG_SPI_NOR_RXI310 + 0x4),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 16);
	RFIELD(15, 0, ndf);
#else
	RFIELD(15, 0, ndf);
	RF_RSV(31, 16);
#endif
	);

SKC35_REG_DEC(
	SSIEN, (_REG_SPI_NOR_RXI310 + 0x8),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 5);
	RFIELD(4, 4, pgm_rst_test_en);
	RF_RSV(3, 2);
	RFIELD(1, 1, atck_cmd);
	RFIELD(0, 0, spic_en);
#else
	RFIELD(0, 0, spic_en);
	RFIELD(1, 1, atck_cmd);
	RF_RSV(3, 2);
	RFIELD(4, 4, pgm_rst_test_en);
	RF_RSV(31, 5);
#endif
	);

//skip offset 0xc ~ 0xc due to reserved

SKC35_REG_DEC(
	SER, (_REG_SPI_NOR_RXI310 + 0x10),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 2);
	RFIELD(1, 0, ser);
#else
	RFIELD(1, 0, ser);
	RF_RSV(31, 2);
#endif
	);

SKC35_REG_DEC(
	BAUDR, (_REG_SPI_NOR_RXI310 + 0x14),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 12);
	RFIELD(11, 0, sckdv);
#else
	RFIELD(11, 0, sckdv);
	RF_RSV(31, 12);
#endif
	);

SKC35_REG_DEC(
	TXFTLR, (_REG_SPI_NOR_RXI310 + 0x18),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 6);
	RFIELD(5, 0, tft);
#else
	RFIELD(5, 0, tft);
	RF_RSV(31, 6);
#endif
	);

SKC35_REG_DEC(
	RXFTLR, (_REG_SPI_NOR_RXI310 + 0x1c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 6);
	RFIELD(5, 0, rft);
#else
	RFIELD(5, 0, rft);
	RF_RSV(31, 6);
#endif
	);

SKC35_REG_DEC(
	TXFLR, (_REG_SPI_NOR_RXI310 + 0x20),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 7);
	RFIELD(6, 0, txflr);
#else
	RFIELD(6, 0, txflr);
	RF_RSV(31, 7);
#endif
	);

SKC35_REG_DEC(
	RXFLR, (_REG_SPI_NOR_RXI310 + 0x24),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 7);
	RFIELD(6, 0, rxflr);
#else
	RFIELD(6, 0, rxflr);
	RF_RSV(31, 7);
#endif
	);

SKC35_REG_DEC(
	SR, (_REG_SPI_NOR_RXI310 + 0x28),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 7, boot_fin);
	RFIELD(6, 6, dcol);
	RFIELD(5, 5, txe);
	RFIELD(4, 4, rff);
	RFIELD(3, 3, rfne);
	RFIELD(2, 2, tfe);
	RFIELD(1, 1, tfnf);
	RFIELD(0, 0, busy);
#else
	RFIELD(0, 0, busy);
	RFIELD(1, 1, tfnf);
	RFIELD(2, 2, tfe);
	RFIELD(3, 3, rfne);
	RFIELD(4, 4, rff);
	RFIELD(5, 5, txe);
	RFIELD(6, 6, dcol);
	RFIELD(7, 7, boot_fin);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	SPI_IMR, (_REG_SPI_NOR_RXI310 + 0x2c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 12);
	RFIELD(11, 11, acsim);
	RFIELD(10, 10, rxsim);
	RFIELD(9, 9, txsim);
	RFIELD(8, 8, aceim);
	RFIELD(7, 7, byeim);
	RFIELD(6, 6, wbeim);
	RFIELD(5, 5, fseim);
	RFIELD(4, 4, rxfim);
	RFIELD(3, 3, rxoim);
	RFIELD(2, 2, rxuim);
	RFIELD(1, 1, txoim);
	RFIELD(0, 0, txeim);
#else
	RFIELD(0, 0, txeim);
	RFIELD(1, 1, txoim);
	RFIELD(2, 2, rxuim);
	RFIELD(3, 3, rxoim);
	RFIELD(4, 4, rxfim);
	RFIELD(5, 5, fseim);
	RFIELD(6, 6, wbeim);
	RFIELD(7, 7, byeim);
	RFIELD(8, 8, aceim);
	RFIELD(9, 9, txsim);
	RFIELD(10, 10, rxsim);
	RFIELD(11, 11, acsim);
	RF_RSV(31, 12);
#endif
	);

SKC35_REG_DEC(
	SPI_ISR, (_REG_SPI_NOR_RXI310 + 0x30),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 12);
	RFIELD(11, 11, acsis);
	RFIELD(10, 10, rxsis);
	RFIELD(9, 9, txsis);
	RFIELD(8, 8, aceis);
	RFIELD(7, 7, byeis);
	RFIELD(6, 6, wbeis);
	RFIELD(5, 5, fseis);
	RFIELD(4, 4, rxfis);
	RFIELD(3, 3, rxois);
	RFIELD(2, 2, rxuis);
	RFIELD(1, 1, txois);
	RFIELD(0, 0, txeis);
#else
	RFIELD(0, 0, txeis);
	RFIELD(1, 1, txois);
	RFIELD(2, 2, rxuis);
	RFIELD(3, 3, rxois);
	RFIELD(4, 4, rxfis);
	RFIELD(5, 5, fseis);
	RFIELD(6, 6, wbeis);
	RFIELD(7, 7, byeis);
	RFIELD(8, 8, aceis);
	RFIELD(9, 9, txsis);
	RFIELD(10, 10, rxsis);
	RFIELD(11, 11, acsis);
	RF_RSV(31, 12);
#endif
	);

SKC35_REG_DEC(
	RISR, (_REG_SPI_NOR_RXI310 + 0x34),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 12);
	RFIELD(11, 11, acsir);
	RFIELD(10, 10, rxsir);
	RFIELD(9, 9, txsir);
	RFIELD(8, 8, aceir);
	RFIELD(7, 7, byeir);
	RFIELD(6, 6, wbeir);
	RFIELD(5, 5, fseir);
	RFIELD(4, 4, rxfir);
	RFIELD(3, 3, rxoir);
	RFIELD(2, 2, rxuir);
	RFIELD(1, 1, txoir);
	RFIELD(0, 0, txeir);
#else
	RFIELD(0, 0, txeir);
	RFIELD(1, 1, txoir);
	RFIELD(2, 2, rxuir);
	RFIELD(3, 3, rxoir);
	RFIELD(4, 4, rxfir);
	RFIELD(5, 5, fseir);
	RFIELD(6, 6, wbeir);
	RFIELD(7, 7, byeir);
	RFIELD(8, 8, aceir);
	RFIELD(9, 9, txsir);
	RFIELD(10, 10, rxsir);
	RFIELD(11, 11, acsir);
	RF_RSV(31, 12);
#endif
	);

SKC35_REG_DEC(
	TXOICR, (_REG_SPI_NOR_RXI310 + 0x38),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, txoicr);
#else
	RFIELD(0, 0, txoicr);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	RXOICR, (_REG_SPI_NOR_RXI310 + 0x3c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, rxoicr);
#else
	RFIELD(0, 0, rxoicr);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	RXUICR, (_REG_SPI_NOR_RXI310 + 0x40),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, rxuicr);
#else
	RFIELD(0, 0, rxuicr);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	MSTICR, (_REG_SPI_NOR_RXI310 + 0x44),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, msticr);
#else
	RFIELD(0, 0, msticr);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	ICR, (_REG_SPI_NOR_RXI310 + 0x48),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, icr);
#else
	RFIELD(0, 0, icr);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	DMACR, (_REG_SPI_NOR_RXI310 + 0x4c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 2);
	RFIELD(1, 1, tx_dmac_en);
	RFIELD(0, 0, rx_dmac_en);
#else
	RFIELD(0, 0, rx_dmac_en);
	RFIELD(1, 1, tx_dmac_en);
	RF_RSV(31, 2);
#endif
	);

SKC35_REG_DEC(
	DMATDLR, (_REG_SPI_NOR_RXI310 + 0x50),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 6);
	RFIELD(5, 0, dmatdl);
#else
	RFIELD(5, 0, dmatdl);
	RF_RSV(31, 6);
#endif
	);

SKC35_REG_DEC(
	DMARDLR, (_REG_SPI_NOR_RXI310 + 0x54),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 6);
	RFIELD(5, 0, dmardl);
#else
	RFIELD(5, 0, dmardl);
	RF_RSV(31, 6);
#endif
	);

SKC35_REG_DEC(
	IDR, (_REG_SPI_NOR_RXI310 + 0x58),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, idcode);
#else
	RFIELD(31, 0, idcode);
#endif
	);

SKC35_REG_DEC(
	SPIC_VERSION, (_REG_SPI_NOR_RXI310 + 0x5c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, spic_version);
#else
	RFIELD(31, 0, spic_version);
#endif
	);

SKC35_REG_DEC(
	DR0, (_REG_SPI_NOR_RXI310 + 0x60),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr0);
#else
	RFIELD(31, 0, dr0);
#endif
	);

SKC35_REG_DEC(
	DR1, (_REG_SPI_NOR_RXI310 + 0x64),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr1);
#else
	RFIELD(31, 0, dr1);
#endif
	);

SKC35_REG_DEC(
	DR2, (_REG_SPI_NOR_RXI310 + 0x68),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr2);
#else
	RFIELD(31, 0, dr2);
#endif
	);

SKC35_REG_DEC(
	DR3, (_REG_SPI_NOR_RXI310 + 0x6c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr3);
#else
	RFIELD(31, 0, dr3);
#endif
	);

SKC35_REG_DEC(
	DR4, (_REG_SPI_NOR_RXI310 + 0x70),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr4);
#else
	RFIELD(31, 0, dr4);
#endif
	);

SKC35_REG_DEC(
	DR5, (_REG_SPI_NOR_RXI310 + 0x74),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr5);
#else
	RFIELD(31, 0, dr5);
#endif
	);

SKC35_REG_DEC(
	DR6, (_REG_SPI_NOR_RXI310 + 0x78),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr6);
#else
	RFIELD(31, 0, dr6);
#endif
	);

SKC35_REG_DEC(
	DR7, (_REG_SPI_NOR_RXI310 + 0x7c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr7);
#else
	RFIELD(31, 0, dr7);
#endif
	);

SKC35_REG_DEC(
	DR8, (_REG_SPI_NOR_RXI310 + 0x80),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr8);
#else
	RFIELD(31, 0, dr8);
#endif
	);

SKC35_REG_DEC(
	DR9, (_REG_SPI_NOR_RXI310 + 0x84),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dr9);
#else
	RFIELD(31, 0, dr9);
#endif
	);

//skip offset 0x88 ~ 0xdc due to reserved

SKC35_REG_DEC(
	READ_FAST_SINGLE, (_REG_SPI_NOR_RXI310 + 0xe0),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 16);
	RFIELD(15, 0, frd_cmd);
#else
	RFIELD(15, 0, frd_cmd);
	RF_RSV(31, 16);
#endif
	);

SKC35_REG_DEC(
	READ_DUAL_DATA, (_REG_SPI_NOR_RXI310 + 0xe4),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 0, read_dual_o_cmd);
#else
	RFIELD(7, 0, read_dual_o_cmd);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	READ_DUAL_ADDR_DATA, (_REG_SPI_NOR_RXI310 + 0xe8),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 0, read_dual_io_cmd);
#else
	RFIELD(7, 0, read_dual_io_cmd);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	READ_QUAD_DATA, (_REG_SPI_NOR_RXI310 + 0xec),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 0, read_quad_o_cmd);
#else
	RFIELD(7, 0, read_quad_o_cmd);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	READ_QUAD_ADDR_DATA, (_REG_SPI_NOR_RXI310 + 0xf0),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 24);
	RFIELD(23, 16, prm_value);
	RF_RSV(15, 8);
	RFIELD(7, 0, read_quad_io_cmd);
#else
	RFIELD(7, 0, read_quad_io_cmd);
	RF_RSV(15, 8);
	RFIELD(23, 16, prm_value);
	RF_RSV(31, 24);
#endif
	);

SKC35_REG_DEC(
	WRITE_SINGLE, (_REG_SPI_NOR_RXI310 + 0xf4),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 16);
	RFIELD(15, 0, wr_cmd);
#else
	RFIELD(15, 0, wr_cmd);
	RF_RSV(31, 16);
#endif
	);

SKC35_REG_DEC(
	WRITE_DUAL_DATA, (_REG_SPI_NOR_RXI310 + 0xf8),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 0, write_dual_i_cmd);
#else
	RFIELD(7, 0, write_dual_i_cmd);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	WRITE_DUAL_ADDR_DATA, (_REG_SPI_NOR_RXI310 + 0xfc),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 0, write_dual_ii_cmd);
#else
	RFIELD(7, 0, write_dual_ii_cmd);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	WRITE_QUAD_DATA, (_REG_SPI_NOR_RXI310 + 0x100),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 0, wr_quad_i_cmd);
#else
	RFIELD(7, 0, wr_quad_i_cmd);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	WRITE_QUAD_ADDR_DATA, (_REG_SPI_NOR_RXI310 + 0x104),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 8);
	RFIELD(7, 0, wr_quad_ii_cmd);
#else
	RFIELD(7, 0, wr_quad_ii_cmd);
	RF_RSV(31, 8);
#endif
	);

SKC35_REG_DEC(
	WRITE_ENABLE, (_REG_SPI_NOR_RXI310 + 0x108),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 16);
	RFIELD(15, 0, wr_en_cmd);
#else
	RFIELD(15, 0, wr_en_cmd);
	RF_RSV(31, 16);
#endif
	);

SKC35_REG_DEC(
	READ_STATUS, (_REG_SPI_NOR_RXI310 + 0x10c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 31, addr_en);
	RFIELD(30, 29, addr_len);
	RFIELD(28, 28, addr_sel);
	RFIELD(27, 27, interval_en);
	RF_RSV(26, 16);
	RFIELD(15, 0, rd_st_cmd);
#else
	RFIELD(15, 0, rd_st_cmd);
	RF_RSV(26, 16);
	RFIELD(27, 27, interval_en);
	RFIELD(28, 28, addr_sel);
	RFIELD(30, 29, addr_len);
	RFIELD(31, 31, addr_en);
#endif
	);

SKC35_REG_DEC(
	CTRLR2, (_REG_SPI_NOR_RXI310 + 0x110),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 15);
	RF_RSV(14, 14);
	RFIELD(13, 12, cs_active_hold);
	RFIELD(11, 8, rx_fifo_en);
	RFIELD(7, 4, fifo_entry_w_tx_fifo_entry);
	RFIELD(3, 3, seq_en);
	RFIELD(2, 2, wpn_dnum);
	RFIELD(1, 1, wpn_set);
	RFIELD(0, 0, so_dnum);
#else
	RFIELD(0, 0, so_dnum);
	RFIELD(1, 1, wpn_set);
	RFIELD(2, 2, wpn_dnum);
	RFIELD(3, 3, seq_en);
	RFIELD(7, 4, fifo_entry_w_tx_fifo_entry);
	RFIELD(11, 8, rx_fifo_en);
	RFIELD(13, 12, cs_active_hold);
	RF_RSV(14, 14);
	RF_RSV(31, 15);
#endif
	);

SKC35_REG_DEC(
	FBAUDR, (_REG_SPI_NOR_RXI310 + 0x114),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 12);
	RFIELD(11, 0, fsckdv);
#else
	RFIELD(11, 0, fsckdv);
	RF_RSV(31, 12);
#endif
	);

SKC35_REG_DEC(
	ADDR_LENGTH, (_REG_SPI_NOR_RXI310 + 0x118),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 3);
	RFIELD(2, 0, addr_phase_length);
#else
	RFIELD(2, 0, addr_phase_length);
	RF_RSV(31, 3);
#endif
	);

SKC35_REG_DEC(
	AUTO_LENGTH, (_REG_SPI_NOR_RXI310 + 0x11c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 28, cs_h_wr_dum_len);
	RFIELD(27, 26, cs_h_rd_dum_len);
	RFIELD(25, 18, auto_dum_len);
	RFIELD(17, 16, auto_addr_length);
	RFIELD(15, 12, in_physical_cyc);
	RFIELD(11, 0, rd_dummy_length);
#else
	RFIELD(11, 0, rd_dummy_length);
	RFIELD(15, 12, in_physical_cyc);
	RFIELD(17, 16, auto_addr_length);
	RFIELD(25, 18, auto_dum_len);
	RFIELD(27, 26, cs_h_rd_dum_len);
	RFIELD(31, 28, cs_h_wr_dum_len);
#endif
	);

SKC35_REG_DEC(
	VALID_CMD, (_REG_SPI_NOR_RXI310 + 0x120),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 15);
	RFIELD(14, 14, seq_trans_en);
	RF_RSV(13, 13);
	RFIELD(12, 12, ctrlr0_ch);
	RFIELD(11, 11, prm_en);
	RF_RSV(10, 10);
	RFIELD(9, 9, wr_blocking);
	RFIELD(8, 8, wr_quad_ii);
	RFIELD(7, 7, wr_quad_i);
	RFIELD(6, 6, wr_dual_ii);
	RFIELD(5, 5, wr_dual_i);
	RFIELD(4, 4, rd_quad_io);
	RFIELD(3, 3, rd_quad_o);
	RFIELD(2, 2, rd_dual_io);
	RFIELD(1, 1, rd_dual_i);
	RFIELD(0, 0, frd_singel);
#else
	RFIELD(0, 0, frd_singel);
	RFIELD(1, 1, rd_dual_i);
	RFIELD(2, 2, rd_dual_io);
	RFIELD(3, 3, rd_quad_o);
	RFIELD(4, 4, rd_quad_io);
	RFIELD(5, 5, wr_dual_i);
	RFIELD(6, 6, wr_dual_ii);
	RFIELD(7, 7, wr_quad_i);
	RFIELD(8, 8, wr_quad_ii);
	RFIELD(9, 9, wr_blocking);
	RF_RSV(10, 10);
	RFIELD(11, 11, prm_en);
	RFIELD(12, 12, ctrlr0_ch);
	RF_RSV(13, 13);
	RFIELD(14, 14, seq_trans_en);
	RF_RSV(31, 15);
#endif
	);

SKC35_REG_DEC(
	FLASH_SIZE, (_REG_SPI_NOR_RXI310 + 0x124),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 4);
	RFIELD(3, 0, flash_size);
#else
	RFIELD(3, 0, flash_size);
	RF_RSV(31, 4);
#endif
	);

SKC35_REG_DEC(
	FLUSH_FIFO, (_REG_SPI_NOR_RXI310 + 0x128),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 2);
	RFIELD(1, 1, flush_pgm_rst_fifo);
	RFIELD(0, 0, flush_fifo);
#else
	RFIELD(0, 0, flush_fifo);
	RFIELD(1, 1, flush_pgm_rst_fifo);
	RF_RSV(31, 2);
#endif
	);

SKC35_REG_DEC(
	PGM_RST_FIFO_1, (_REG_SPI_NOR_RXI310 + 0x140),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 16);
	RFIELD(15, 12, cnt);
	RFIELD(11, 10, sta);
	RFIELD(9, 8, ch);
	RFIELD(7, 0, cmd);
#else
	RFIELD(7, 0, cmd);
	RFIELD(9, 8, ch);
	RFIELD(11, 10, sta);
	RFIELD(15, 12, cnt);
	RF_RSV(31, 16);
#endif
	);

SKC35_REG_DEC(
	PGM_RST_FIFO_2, (_REG_SPI_NOR_RXI310 + 0x144),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 16);
	RFIELD(15, 12, cnt);
	RFIELD(11, 10, sta);
	RFIELD(9, 8, ch);
	RFIELD(7, 0, cmd);
#else
	RFIELD(7, 0, cmd);
	RFIELD(9, 8, ch);
	RFIELD(11, 10, sta);
	RFIELD(15, 12, cnt);
	RF_RSV(31, 16);
#endif
	);
#endif
