#ifndef NOR_SPIF_CORE_H
#define NOR_SPIF_CORE_H

#include <nor_spif_register.h>
#define _BE32TOH
#define _LE
#if defined(CONFIG_UNDER_UBOOT) || defined(__LUNA_KERNEL__)
#include <common.h>
#include <compiler.h>
#include <asm/io.h>
#ifndef CONFIG_SYS_FLASH_BASE
#define CONFIG_SYS_FLASH_BASE  0
#endif
#ifndef CONFIG_SYS_FLASH_SIZE
#define CONFIG_SYS_FLASH_SIZE  (16*1024*1024)
#endif
#define ORIN_FLASH_BASE	CONFIG_SYS_FLASH_BASE
#define ORIN_FLASH_SIZE	CONFIG_SYS_FLASH_SIZE
#define __CPU_TO_BE32	cpu_to_be32
#define __CPU_TO_LE32	cpu_to_le32
#define __CPU_TO_LE16	cpu_to_le16
#define __BE32_TO_CPU	be32_to_cpu
#define __LE32_TO_CPU	le32_to_cpu
#define __LE16_TO_CPU	le16_to_cpu
#else // ATF
#include <common/bl_common.h>
#include <common/debug.h>
#include <platform_def.h>
#include <endian.h>
#define __CPU_TO_BE32	be32toh
#define __CPU_TO_LE32	le32toh
#define __CPU_TO_LE16	le16toh
#define __BE32_TO_CPU	htobe32
#define __LE32_TO_CPU	htole32
#define __LE16_TO_CPU	htole16
#endif

/****** WRAPPER ******/
#ifndef VZERO
#define VZERO ((void*)0)
#endif
#define DCACHE_LINE_SZ_B CACHE_WRITEBACK_GRANULE

#ifndef NORSF_QSPI_EN
#define NORSF_QSPI_EN 0
#endif
#define RETURN_STACK_SAVE(_bpctl_backup)
#define RETURN_STACK_RESTORE(_bpctl_backup)
/****** WRAPPER END ******/

#ifndef NORSF_MMIO_4B_EN
#define NORSF_MMIO_4B_EN (1)
#endif

#ifndef NORSF_CHIP_NUM
#define NORSF_CHIP_NUM (2)
#endif

#define NORSFG2_T2_WIP_TIMEOUT   -12
#define NORSFG2_E4_OFFSET_NALIGN -31
#define NORSFG2_E4_LEN_NALIGN    -32
#define NORSFG2_E4_BAD_CMD_AND_OFFSET -33
#define NORSFG2_E4_UNKNOWN       -34
#define NORSFG2_T4_LEN_OVERFLOW  -35

extern void __iomem *rxi310_flash_ctl_base;

struct norsf_info_s;
typedef struct norsf_info_s norsf_info_t;

typedef enum {
	norsf_sio = 0x0,
	norsf_dio = 0x1,
	norsf_qio = 0x2,
} spif_io_mode_t;

typedef enum {
	norsf_ptx = 0x0,
	norsf_prx = 0x1,
} spif_payload_dir_t;

typedef enum {
	norsf_3b_addr = 0x1,
	norsf_4b_mode = 0x2,
	norsf_4b_cmd  = 0x4,
	norsf_4b_ear  = 0x8,
} spif_addr_mode_t;

typedef struct {
	uint32_t cs:1;
	uint32_t cmd:8;
	uint32_t plen_b:11;
	uint32_t write_en:1;
	uint32_t dummy_ck:4;
	uint32_t cmode:2;  // cmd io
	uint32_t amode:2;  // address io
	uint32_t pmode:2;  // data io
	uint32_t pdir:1;
} nsf_trx_attr_t;

typedef struct {
	nsf_trx_attr_t a;
	uint32_t to_us;
	uint32_t sz_b;
	int32_t offset_lmt; /* For non-uniform sector devices,
	                     +: from the begining; -: from the tail; 0: no limit. I.e.,
	                     first 128KB = +0x20000; the last 128KB: = -0x20000. */
} norsf_erase_cmd_t;

typedef int (norsf_wip_t)(const uint32_t);

typedef struct {
	uint32_t to_c;
	norsf_wip_t *wip;
} norsf_wip_info_t;

typedef int (norsf_erase_t)(const norsf_erase_cmd_t *, const uint32_t, const uint32_t, const norsf_wip_info_t *);
typedef int (norsf_prog_t) (const norsf_info_t *,   const uint32_t, const uint32_t, const uint32_t, const void *, const norsf_wip_info_t *);
typedef int (norsf_read_t) (const norsf_info_t *,   const uint32_t, const uint32_t, const uint32_t, void *);
typedef int (norsf_4b_mode_en_t)(const norsf_info_t *, const uint32_t);
typedef int (norsf_4b_mode_ex_t)(const norsf_info_t *, const uint32_t);
typedef int (norsf_4b_ear_set_t)(const norsf_info_t *, const uint32_t, const uint8_t);

typedef int (norsf_xread_en_t)(const norsf_info_t *, const uint32_t);
typedef int (norsf_xread_ex_t)(const norsf_info_t *, const uint32_t);

typedef struct {
	nsf_trx_attr_t a;
	norsf_xread_en_t *xread_en;
	norsf_xread_ex_t *xread_ex;
} norsf_read_cmd_t;

typedef struct {
	norsf_erase_cmd_t *cerase;

	nsf_trx_attr_t cprog_attr;
	uint32_t          cprog_to_us;
	uint16_t          cprog_lim_b;

	uint16_t          cerase_cmd_num;

	norsf_read_cmd_t *cread;
} norsf_cmd_info_t;

typedef struct {
	norsf_4b_mode_en_t *arch_en4b;
	norsf_4b_mode_ex_t *arch_ex4b;
} norsf_4b_mode_func_t;

typedef struct {
	norsf_4b_ear_set_t *arch_wrear;
} norsf_4b_ear_func_t;

typedef struct {
	uint32_t start;
	uint32_t end;
} norsf_usable_addr_t;

struct norsf_info_s {
	uint32_t id;
	uint8_t  num_chips;
	uint8_t  addr_mode:4;
	uint8_t  is_mr4a:1;
	uint8_t  dyn_4b_addr_switch:1;
	uint8_t  pio_addr_len:2;

	uint32_t sec_sz_b;
	uint32_t size_per_chip_b;

	norsf_erase_t *arch_erase;
	norsf_prog_t  *arch_prog;
	norsf_read_t  *arch_read;
	norsf_wip_t   *arch_wip;
	union {
		norsf_4b_mode_func_t mode;
		norsf_4b_ear_func_t  ear;
	} am;

	norsf_cmd_info_t *cmd_info;
};

typedef norsf_info_t *(norsf_probe_t)(void);

void norsf_detect(void);
int32_t norsf_rdid(const uint32_t);

int32_t norsf_compound_cmd  (const uint32_t addr, uint8_t *payload, const nsf_trx_attr_t attr, const norsf_wip_info_t *wi);

void norsf_proj_4b_addr_en(uint32_t en);

int32_t norsf_cmn_arch_wip  (const uint32_t cs);
int32_t norsf_cmn_arch_erase(const norsf_erase_cmd_t *cmd, const uint32_t cs, const uint32_t offset, const norsf_wip_info_t *wi);
int32_t norsf_cmn_arch_prog (const norsf_info_t *ni,    const uint32_t cs, const uint32_t offset, const uint32_t len,           const void *buf, const norsf_wip_info_t *wi);
int32_t norsf_cmn_arch_read (const norsf_info_t *ni,    const uint32_t cs, const uint32_t offset, const uint32_t len,                 void *buf);
int32_t norsf_cmn_4b_mode_en(const norsf_info_t *ni,    const uint32_t cs);
int32_t norsf_cmn_4b_mode_ex(const norsf_info_t *ni,    const uint32_t cs);

int norsf_erase(const norsf_info_t *ni, const uint32_t offset, const uint32_t len, const uint32_t strict_len, const uint32_t verbose);
int norsf_prog (const norsf_info_t *ni, const uint32_t offset, const uint32_t len,        const void *buf, const uint32_t verbose);
int norsf_read (const norsf_info_t *ni, const uint32_t offset, const uint32_t len,              void *buf, const uint32_t verbose);
int norsf_flashsize_get(void);

#ifndef SECTION_NOR_SPIF_PROBE_FUNC
#define SECTION_NOR_SPIF_PROBE_FUNC __attribute__ ((section (".nor_spif_probe_func")))
// #define SECTION_NOR_SPIF_PROBE_FUNC
#endif

#define REG_NOR_SPIF_PROBE_FUNC(fn) norsf_probe_t* __nspf_ ## fn ## _ \
	SECTION_NOR_SPIF_PROBE_FUNC = (norsf_probe_t*) fn

#ifndef SECTION_NOR_SPIF_CORE
#undef noinline
//#define SECTION_NOR_SPIF_CORE __attribute__ ((section (".text.cacheline_alignment"), noinline, aligned(32)))
#define SECTION_NOR_SPIF_CORE
#endif

#ifndef SECTION_NOR_SPIF_COREDATA
#define SECTION_NOR_SPIF_COREDATA
#endif

#ifndef SECTION_NOR_SPIF_MISC
#define SECTION_NOR_SPIF_MISC
#endif

#ifndef SECTION_NOR_SPIF_PARAM
#define SECTION_NOR_SPIF_PARAM
#endif

extern norsf_info_t norsf_info;
extern norsf_cmd_info_t cmn_cmd_info;
extern norsf_erase_cmd_t cmn_erase_cmds[];

#define NORSF_READ(offset, len, buf, verbose) \
	norsf_read(&norsf_info, offset, len, buf, verbose)

#define NORSF_PROG(offset, len, buf, verbose) \
	norsf_prog(&norsf_info, offset, len, buf, verbose)

#define NORSF_ERASE(offset, len, verbose, is_strict_len) \
	norsf_erase(&norsf_info, offset, len, is_strict_len, verbose)

/* For development. */
extern uint32_t exp_norsf_sel_addr_type;

#define NORSF_MIN(x, y) (y ^ ((x ^ y) & -(x < y)))

#endif
