#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  XTX, Manufacture ID: 0x0B
  ***********************************************/
static void xtx_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

#define XTX_ECC_UNCOR_ERROR     (0xF)

static int xtx_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint32_t eccs_off = 4;
    if (info->pm.did == 0xe3) {    //XT26G04A
        eccs_off = 2;
    }

    uint8_t ecst = snand_get_feature_bits(info, cs, 0xC0, eccs_off, 4);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);

    if (info->pm.did == 0xe3) {    //XT26G04A
        if (ecst == 0x8) ecst=XTX_ECC_UNCOR_ERROR;
        if (ecst == 0xa) ecst=8;
    }

    if (SNAF_ECC_NO_BITFLIPS == ecst) {
        return 0;
    } else if (XTX_ECC_UNCOR_ERROR == ecst) {
        ERROR("ECC Uncorrected Error Detected\n");
        return -2;
    } else if (ecst <= info->pm.ecc_bits) {
        return ecst;
    }
    return -1;
}

void xtx_quad_enable(snaf_info_t *info, uint8_t cs, uint8_t v)
{
    uint8_t wpe = (v==1)?0:1;
    snand_quad_enable2(info, cs, wpe);
}

static void xtx_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 500, __FUNCTION__);
        snand_unlock(info, cs);
        snand_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC));
    }
    if (ondie_en) {
        info->ecc_decode = xtx_ecc_decode;
        info->ecc_encode = xtx_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 1400;
    info->tread = 140;
    info->tberase = 10000;
}

#define XTX_OPS   (SNAF_ON_DIE_ECC|SNAF_SERIAL_IO)

/*    Manu ID, Device ID, num of block, init func, options */
const snaf_pm_t xtx_chips_info[] = {
    /*********** 3.3 V ***********/
    SNDB(MID_XTX, "XT26G01C", 0x11, 1024,  64, 2048, 128, 8, XTX_OPS|SNAF_EXTRA_ECSP), // 1Gb
    SNDB(MID_XTX, "XT26G04A", 0xe3, 2048, 128, 2048,  64, 8, XTX_OPS), // 4Gb
    // "XT26G02E", 2Gb, is same as Micron MT29F2G01ABAGD

    /*********** 1.8 V ***********/
    SNDB(MID_XTX, "XT26Q04C", 0x23, 2048,  64, 4096, 256, 8, XTX_OPS|SNAF_EXTRA_ECSP), // 4Gb

};

const snaf_manu_t xtx_manu_info = {
    .mid = MID_XTX,
    .mname = "XTX",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(xtx_chips_info),
    .chips = xtx_chips_info,
    .init = xtx_init,
};
