#ifndef ___SPI_NAND_XFER_CMD_H__
#define ___SPI_NAND_XFER_CMD_H__ 1

typedef struct {
    uint32_t v;
    uint8_t nbytes;
    uint8_t mode;   // address io
} snaf_xfer_unit_t;

typedef struct {
    void *v;
    uint32_t nbytes;
    uint8_t mode;   // address io
} snaf_xfer_data_t;

typedef struct {
    uint8_t cs;
    uint8_t pdir;
    snaf_xfer_unit_t cmd;
    snaf_xfer_unit_t addr;
    snaf_xfer_unit_t dummy;
    snaf_xfer_data_t data[2];
} snaf_xfer_attr_t;

#define XFER_NONE                   { .v = 0, .nbytes = 0, .mode = 0 }
#define XFER_CMD(_op )              { .v = (_op), .nbytes = 1, .mode = snaf_sio }
#define XFER_ADDR(_ad, _ad_b, _m)   { .v = (_ad), .nbytes = (_ad_b), .mode = (_m) }
#define XFER_DUMMY(_dm, _dm_b, _m)  { .v = (_dm), .nbytes = (_dm_b), .mode = (_m) }
#define XFER_DATA(_da, _da_b, _m)   { .v = (_da), .nbytes = (_da_b), .mode = (_m) }
//#define XFER_DATA(_da, _da_b, _m)   { {(_da), NULL}, {(_da_b), 0}, (_m) }

#define XFER_OP(__cs, __pdir, __cmd, __addr, __dummy, __data, __data1) \
        { .cs = __cs, .pdir = __pdir,\
          .cmd = __cmd, .addr = __addr, \
          .dummy = __dummy, \
          .data[0] = __data, .data[1] = __data1 }

#define XFER_CMD_RDID(_cs, _op, _addr, _data, _data_b) \
        XFER_OP(_cs, snaf_xfer_rx,  \
                XFER_CMD(_op), \
                XFER_ADDR(_addr, 1, snaf_sio), \
                XFER_NONE, \
                XFER_DATA(_data, _data_b, snaf_sio), XFER_NONE)

#define XFER_CMD_ONLY(_cs, _op) \
        XFER_OP(_cs, snaf_xfer_tx, \
                XFER_CMD(_op),\
                XFER_NONE, \
                XFER_NONE, \
                XFER_NONE, XFER_NONE)

#define XFER_CMD_SET(_cs, _op, _addr, _data) \
        XFER_OP(_cs, snaf_xfer_tx, \
                XFER_CMD(_op),\
                XFER_ADDR(_addr, 1, snaf_sio), \
                XFER_NONE, \
                XFER_DATA(_data, 1, snaf_sio), XFER_NONE)

#define XFER_CMD_GET(_cs, _op, _addr, _data) \
        XFER_OP(_cs, snaf_xfer_rx, \
                XFER_CMD(_op),\
                XFER_ADDR(_addr, 1, snaf_sio), \
                XFER_NONE, \
                XFER_DATA(_data, 1, snaf_sio), XFER_NONE)

#define XFER_CMD_EXEC(_cs, _op, _addr, _addr_b) \
        XFER_OP(_cs, snaf_xfer_tx,  \
                XFER_CMD(_op), \
                XFER_ADDR(_addr, _addr_b, snaf_sio), \
                XFER_NONE, \
                XFER_NONE, XFER_NONE)

#define _XFER_CMD_READ(_cs, _p_dir, _op, _addr, _a_mode, _data, _data_b, _spare, _spare_b, _d_mode, _dummy_b) \
        XFER_OP(_cs, _p_dir,  \
                XFER_CMD(_op), \
                XFER_ADDR(_addr, 2, _a_mode), \
                XFER_DUMMY(0, _dummy_b, snaf_sio), \
                XFER_DATA(_data, _data_b, _d_mode), \
                XFER_DATA(_spare, _spare_b, _d_mode))

// 1-1-X READ
#define XFER_CMD_READ(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode, _dummy_b) \
        _XFER_CMD_READ(_cs, snaf_xfer_rx, _op, _addr, snaf_sio, _data, _data_b, _spare, _spare_b, _mode, _dummy_b)

#define XFER_CMD_READ_DMA(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode, _dummy_b) \
        _XFER_CMD_READ(_cs, snaf_xfer_rx_dma, _op, _addr, snaf_sio, _data, _data_b, _spare, _spare_b, _mode, _dummy_b)

// 1-X-X FAST READ
#define XFER_CMD_FAST_READ(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode, _dummy_b) \
        _XFER_CMD_READ(_cs, snaf_xfer_rx, _op, _addr, _mode, _data, _data_b, _spare, _spare_b, _mode, _dummy_b)

#define XFER_CMD_FAST_READ_DMA(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode, _dummy_b) \
        _XFER_CMD_READ(_cs, snaf_xfer_rx_dma, _op, _addr, _mode, _data, _data_b, _spare, _spare_b, _mode, _dummy_b)


#define _XFER_CMD_PROG(_cs, _p_dir, _op, _addr, _a_mode, _data, _data_b, _spare, _spare_b, _d_mode) \
        XFER_OP(_cs, _p_dir,  \
                XFER_CMD(_op), \
                XFER_ADDR(_addr, 2, _a_mode), \
                XFER_NONE, \
                XFER_DATA(_data, _data_b, _d_mode), \
                XFER_DATA(_spare, _spare_b, _d_mode))

// 1-1-X PROG
#define XFER_CMD_PROG(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode) \
        _XFER_CMD_PROG(_cs, snaf_xfer_tx, _op, _addr, snaf_sio, _data, _data_b, _spare, _spare_b, _mode)

#define XFER_CMD_PROG_DMA(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode) \
        _XFER_CMD_PROG(_cs, snaf_xfer_tx_dma, _op, _addr, snaf_sio, _data, _data_b, _spare, _spare_b, _mode)

// 1-X-X FAST PROG
#define XFER_CMD_FAST_PROG(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode) \
        _XFER_CMD_PROG(_cs, snaf_xfer_tx, _op, _addr, _mode, _data, _data_b, _spare, _spare_b, _mode)

#define XFER_CMD_FAST_PROG_DMA(_cs, _op, _addr, _data, _data_b, _spare, _spare_b, _mode) \
        _XFER_CMD_PROG(_cs, snaf_xfer_tx_dma, _op, _addr, _mode, _data, _data_b, _spare, _spare_b, _mode)

__attribute__((unused))
static int buswidth_transfer(uint32_t bw)
{
    uint32_t _bw;
    if (bw==4) {
        _bw = snaf_qio;
    } else if (bw==2) {
        _bw = snaf_dio;
    } else {
        _bw = snaf_sio;
    }
    return _bw;
}

#endif //___SPI_NAND_XFER_CMD_H__
