#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  WINBOND, Manufacture ID: 0xEF
  ***********************************************/
static void winbond_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int winbond_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_ecfail(info, cs);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);
    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
        case SNAF_ECC_HAS_ELT_BITFLIPS: // 2: winbond defined The entire data output experienced a 2 bit error event in multiple pages.
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        case SNAF_ECC_HAS_LT_BITFLIPS:
            return 1;
        default:
            break;
    }
    return -1;
}

static void winbond_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    /* WP_EN, 1: WP Enable, hardware protect, Quad are disabled
              0: WP Disable, Quad enable (default) */
    uint32_t wp_en = CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO)?0:1;
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 500, __FUNCTION__);
        snand_unlock(info, cs);
        snand_quad_enable2(info, cs, wp_en);
        snand_set_ecc_en(info, cs, ondie_en);
    }
    if (ondie_en) {
        info->ecc_decode = winbond_ecc_decode;
        info->ecc_encode = winbond_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 700;
    info->tread = 60;
    info->tberase = 10000;
}

#define WINBOND_OPS   (SNAF_ON_DIE_ECC|SNAF_SERIAL_IO)

const snaf_pm_t winbond_chips_info[] = {
    /*********** 3.3 V ***********/
    SNDB(MID_WINBOND, "W25N512GV", 0xAA20,  512, 64, 2048, 64, 1, WINBOND_OPS), // 512Mb
    SNDB(MID_WINBOND, "W25N01GV",  0xAA21, 1024, 64, 2048, 64, 1, WINBOND_OPS), // 1Gb
    SNDB(MID_WINBOND, "W25N02GV",  0xAB21, 2048, 64, 2048, 64, 1, WINBOND_OPS|SNAF_STACK_DIE), // 2Gb

    /*********** 1.8 V ***********/
    SNDB(MID_WINBOND, "W25N512GW", 0xBA20,  512, 64, 2048, 64, 1, WINBOND_OPS), // 512Mb
    SNDB(MID_WINBOND, "W25N01GW",  0xBA21, 1024, 64, 2048, 64, 1, WINBOND_OPS), // 1Gb
    SNDB(MID_WINBOND, "W25N02GW",  0xBB21, 2048, 64, 2048, 64, 1, WINBOND_OPS|SNAF_STACK_DIE), // 2Gb
};

const snaf_manu_t winbond_manu_info = {
    .mid = MID_WINBOND,
    .mname = "WINBOND",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(winbond_chips_info),
    .chips = winbond_chips_info,
    .init = winbond_init,
};