#ifndef ___REG_SPI_NAND_H__
#define ___REG_SPI_NAND_H__ 1
#include <reg_skc35.h>

#ifndef __BYTE_ORDER__
#	error "__BYTE_ORDER__ is not defined"
#endif

#if (__BYTE_ORDER__ != __ORDER_BIG_ENDIAN__) && \
    (__BYTE_ORDER__ != __ORDER_LITTLE_ENDIAN__)
#	error "unknown __BYTE_ORDER__ value"
#endif

#ifndef _REG_SPI_NAND
#	define _REG_SPI_NAND (0x01024000)
#endif

SKC35_REG_DEC(
	SNAFCFR, (_REG_SPI_NAND + 0x0),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 29);
	RFIELD(28, 28, nafc_nf);
	RF_RSV(27, 27);
	RFIELD(26, 24, debug_select);
	RF_RSV(23, 23);
	RFIELD(22, 22, rbo);
	RFIELD(21, 21, wbo);
	RFIELD(20, 20, dma_ie);
	RF_RSV(19, 15);
	RFIELD(14, 14, slv_endian);
	RFIELD(13, 13, dma_endian);
	RFIELD(12, 12, precise);
	RF_RSV(11, 10);
	RFIELD(9, 8, pipe_lat);
	RF_RSV(7, 7);
	RFIELD(6, 4, spi_clk_div);
	RF_RSV(3, 2);
	RFIELD(1, 0, lbc_bsz);
#else
	RFIELD(1, 0, lbc_bsz);
	RF_RSV(3, 2);
	RFIELD(6, 4, spi_clk_div);
	RF_RSV(7, 7);
	RFIELD(9, 8, pipe_lat);
	RF_RSV(11, 10);
	RFIELD(12, 12, precise);
	RFIELD(13, 13, dma_endian);
	RFIELD(14, 14, slv_endian);
	RF_RSV(19, 15);
	RFIELD(20, 20, dma_ie);
	RFIELD(21, 21, wbo);
	RFIELD(22, 22, rbo);
	RF_RSV(23, 23);
	RFIELD(26, 24, debug_select);
	RF_RSV(27, 27);
	RFIELD(28, 28, nafc_nf);
	RF_RSV(31, 29);
#endif
	);

SKC35_REG_DEC(
	SNAFCCR, (_REG_SPI_NAND + 0x4),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 5);
	RFIELD(4, 4, cecs1);
	RF_RSV(3, 1);
	RFIELD(0, 0, cecs0);
#else
	RFIELD(0, 0, cecs0);
	RF_RSV(3, 1);
	RFIELD(4, 4, cecs1);
	RF_RSV(31, 5);
#endif
	);

SKC35_REG_DEC(
	SNAFWCMR, (_REG_SPI_NAND + 0x8),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 30);
	RFIELD(29, 28, w_io_width);
	RF_RSV(27, 2);
	RFIELD(1, 0, w_len);
#else
	RFIELD(1, 0, w_len);
	RF_RSV(27, 2);
	RFIELD(29, 28, w_io_width);
	RF_RSV(31, 30);
#endif
	);

SKC35_REG_DEC(
	SNAFRCMR, (_REG_SPI_NAND + 0xc),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 30);
	RFIELD(29, 28, r_io_width);
	RF_RSV(27, 2);
	RFIELD(1, 0, r_len);
#else
	RFIELD(1, 0, r_len);
	RF_RSV(27, 2);
	RFIELD(29, 28, r_io_width);
	RF_RSV(31, 30);
#endif
	);

SKC35_REG_DEC(
	SNAFRDR, (_REG_SPI_NAND + 0x10),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 24, rdata3);
	RFIELD(23, 16, rdata2);
	RFIELD(15, 8, rdata1);
	RFIELD(7, 0, rdata0);
#else
	RFIELD(7, 0, rdata0);
	RFIELD(15, 8, rdata1);
	RFIELD(23, 16, rdata2);
	RFIELD(31, 24, rdata3);
#endif
	);

SKC35_REG_DEC(
	SNAFWR, (_REG_SPI_NAND + 0x14),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 24, wdata3);
	RFIELD(23, 16, wdata2);
	RFIELD(15, 8, wdata1);
	RFIELD(7, 0, wdata0);
#else
	RFIELD(7, 0, wdata0);
	RFIELD(15, 8, wdata1);
	RFIELD(23, 16, wdata2);
	RFIELD(31, 24, wdata3);
#endif
	);

SKC35_REG_DEC(
	SNAFDTR, (_REG_SPI_NAND + 0x18),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, dmarwe);
#else
	RFIELD(0, 0, dmarwe);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	SNAFDRSAR, (_REG_SPI_NAND + 0x1c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, addr);
#else
	RFIELD(31, 0, addr);
#endif
	);

SKC35_REG_DEC(
	SNAFDIR, (_REG_SPI_NAND + 0x20),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, dma_ip);
#else
	RFIELD(0, 0, dma_ip);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	SNAFDLR, (_REG_SPI_NAND + 0x24),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 30);
	RFIELD(29, 28, dma_io_width);
	RF_RSV(27, 16);
	RFIELD(15, 0, len);
#else
	RFIELD(15, 0, len);
	RF_RSV(27, 16);
	RFIELD(29, 28, dma_io_width);
	RF_RSV(31, 30);
#endif
	);

SKC35_REG_DEC(
	SNAFDCDSR, (_REG_SPI_NAND + 0x28),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 17);
	RFIELD(16, 0, clenc);
#else
	RFIELD(16, 0, clenc);
	RF_RSV(31, 17);
#endif
	);

//skip offset 0x2c ~ 0x3c due to reserved

SKC35_REG_DEC(
	SNAFSR, (_REG_SPI_NAND + 0x40),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 6);
	RFIELD(5, 5, dmars);
	RFIELD(4, 4, cs1);
	RFIELD(3, 3, nfcos);
	RFIELD(2, 2, nfdrs);
	RFIELD(1, 1, nfdws);
	RFIELD(0, 0, cs0);
#else
	RFIELD(0, 0, cs0);
	RFIELD(1, 1, nfdws);
	RFIELD(2, 2, nfdrs);
	RFIELD(3, 3, nfcos);
	RFIELD(4, 4, cs1);
	RFIELD(5, 5, dmars);
	RF_RSV(31, 6);
#endif
	);

#endif
