#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  MXIC, Manufacture ID: 0xC2
  ***********************************************/
static void mxic_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int mxic_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_ecfail(info, cs);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);
    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        case SNAF_ECC_HAS_LT_BITFLIPS:
            // internal ECC read (C7 command, only available for 1Gb)
            // so return max ecc bits
            return info->pm.ecc_bits;
        default:
            break;
    }
    return -1;
}

static void mxic_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 500, __FUNCTION__);
        snand_unlock(info, cs);
        snand_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, ondie_en);
    }
    if (ondie_en) {
        info->ecc_decode = mxic_ecc_decode;
        info->ecc_encode = mxic_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 600;
    info->tread = 70;
    info->tberase = 3500;
}

#define MXIC_OPS   (SNAF_SERIAL_IO)

const snaf_pm_t mxic_chips_info[] = {
    /*********** 3.3 V ***********/
    SNDB(MID_MXIC, "MX35LF1GE4AB",  0x12, 1024, 64, 2048,  64, 4, MXIC_OPS|SNAF_ON_DIE_ECC), // 1Gb
    SNDB(MID_MXIC, "MX35LF2GE4AB",  0x22, 2048, 64, 2048,  64, 4, MXIC_OPS|SNAF_PLANE_ARCH|SNAF_ON_DIE_ECC), // 2Gb
    SNDB(MID_MXIC, "MX35LF2G14AC",  0x20, 2048, 64, 2048,  64, 4, MXIC_OPS|SNAF_PLANE_ARCH), // 2Gb, program issue !!!!
    SNDB(MID_MXIC, "MX35LF1G24AD",  0x14, 1024, 64, 2048, 128, 8, MXIC_OPS), // 1Gb
    SNDB(MID_MXIC, "MX35LF2G24AD",  0x24, 2048, 64, 2048, 128, 8, MXIC_OPS|SNAF_PLANE_ARCH), // 2Gb
    SNDB(MID_MXIC, "MX35LF4G24AD",  0x35, 2048, 64, 4096, 256, 8, MXIC_OPS|SNAF_PLANE_ARCH), // 4Gb
    SNDB(MID_MXIC, "MX35LF2GE4AD",  0x26, 2048, 64, 2048, 128, 8, MXIC_OPS|SNAF_ON_DIE_ECC|SNAF_EXTRA_ECSP), // 2Gb
    SNDB(MID_MXIC, "MX35LF4GE4AD",  0x37, 2048, 64, 4096, 256, 8, MXIC_OPS|SNAF_ON_DIE_ECC|SNAF_EXTRA_ECSP), // 4Gb

    /*********** 1.8 V ***********/
    SNDB(MID_MXIC, "MX35UF1G24AD",  0x94, 1024, 64, 2048, 128, 8, MXIC_OPS), // 1Gb
    SNDB(MID_MXIC, "MX35UF2G24AD",  0xA4, 2048, 64, 2048, 128, 8, MXIC_OPS|SNAF_PLANE_ARCH), // 2Gb
    SNDB(MID_MXIC, "MX35UF4G24AD",  0xB5, 2048, 64, 4096, 256, 8, MXIC_OPS|SNAF_PLANE_ARCH), // 4Gb

};

const snaf_manu_t mxic_manu_info = {
    .mid = MID_MXIC,
    .mname = "MXIC",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(mxic_chips_info),
    .chips = mxic_chips_info,
    .init = mxic_init,
};
