#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  Heyangtek, Manufacture ID: 0xC9
  ***********************************************/
static void hyt_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int hyt_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_feature_bits(info, cs, 0xC0, 4, 4);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);

    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        default:
            return ecst;    // max bit-flips
    }
    return -1;
}

void hyt_quad_enable(snaf_info_t *info, uint8_t cs, uint8_t v)
{
    uint8_t wpe = (v==1)?0:1;
    snand_quad_enable2(info, cs, wpe);
}

static void hyt_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 500, __FUNCTION__);
        snand_unlock(info, cs);
        snand_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC));
    }
    if (ondie_en) {
        info->ecc_decode = hyt_ecc_decode;
        info->ecc_encode = hyt_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 1400;
    info->tread = 140;
    info->tberase = 10000;
}

#define Heyangtek_OPS   (SNAF_ON_DIE_ECC|SNAF_SERIAL_IO)

/*    Manu ID, Device ID, num of block, init func, options */
const snaf_pm_t hyt_chips_info[] = {
    /*********** 3.3 V ***********/
    SNDB(MID_HEYANGTEK, "HYF4GQ4UAACBE", 0xD4, 2048, 64, 4096, 256, 14, Heyangtek_OPS), // 4Gb, no parameter page

    /*********** 1.8 V ***********/

};

const snaf_manu_t hyt_manu_info = {
    .mid = MID_HEYANGTEK,
    .mname = "HEYANGTEK",
    .nchips = ARRAY_SIZE(hyt_chips_info),
    .chips = hyt_chips_info,
    .init = hyt_init,
};
