#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  GIGADEVICE(GD), Manufacture ID: 0xC8
  ***********************************************/
static void gd_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int gd_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_ecfail(info, cs);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);
    uint32_t ret;

    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        case SNAF_ECC_HAS_LT_BITFLIPS:
            ret = snand_get_feature(info, cs, 0xf0);
            VERBOSE("Feature 0xf0: %x, MAX Bit-Flips %d bits\n", ret, ret>>4);
            return (ret>>4)&0x3;    // max bit-flips
        default:
            break;
    }
    return -1;
}

static void gd_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 500, __FUNCTION__);
        snand_unlock(info, cs);
        snand_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC));
    }
    if (ondie_en) {
        info->ecc_decode = gd_ecc_decode;
        info->ecc_encode = gd_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 600;
    info->tread = 60;
    info->tberase = 5000;
}

#define GD_OPS   (SNAF_SERIAL_IO|SNAF_ON_DIE_ECC)

/*    Manu ID, Device ID, num of block, init func, options */
const snaf_pm_t gd_chips_info[] = {
    /*********** 3.3 V ***********/
    // E version, Q4, no parameter page
    SNDB(MID_GD, "GD5F1GQ4UExxG",   0xD1, 1024, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 1Gb
    SNDB(MID_GD, "GD5F1GQ4UExxH",   0xD9, 1024, 64, 2048,  64, 8, GD_OPS), // 1Gb
    // E version, Q5
    SNDB(MID_GD, "GD5F1GQ5UExxG",   0x51, 1024, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 1Gb
    SNDB(MID_GD, "GD5F1GQ5UExxH",   0x31, 1024, 64, 2048,  64, 4, GD_OPS), // 1Gb
    SNDB(MID_GD, "GD5F2GQ5UExxG",   0x52, 2048, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 2Gb
    SNDB(MID_GD, "GD5F2GQ5UExxH",   0x32, 2048, 64, 2048,  64, 4, GD_OPS), // 2Gb
    // E version, Q6
    SNDB(MID_GD, "GD5F4GQ6UExxG",   0x55, 4096, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 4Gb
    SNDB(MID_GD, "GD5F4GQ6UExxH",   0x35, 4096, 64, 2048,  64, 4, GD_OPS), // 4Gb

    /*********** 1.8 V ***********/
    // E version, Q4, no parameter page
    SNDB(MID_GD, "GD5F1GQ4RExxG",   0xC1, 1024, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 1Gb
    SNDB(MID_GD, "GD5F1GQ4RExxH",   0xC9, 1024, 64, 2048,  64, 8, GD_OPS), // 1Gb
    // E version, Q5
    SNDB(MID_GD, "GD5F1GQ5RExxG",   0x41, 1024, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 1Gb
    SNDB(MID_GD, "GD5F1GQ5RExxH",   0x21, 1024, 64, 2048,  64, 4, GD_OPS), // 1Gb
    SNDB(MID_GD, "GD5F2GQ5RExxG",   0x42, 2048, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 2Gb
    SNDB(MID_GD, "GD5F2GQ5RExxH",   0x22, 2048, 64, 2048,  64, 4, GD_OPS), // 2Gb
    // E version, Q6
    SNDB(MID_GD, "GD5F4GQ6RExxG",   0x45, 4096, 64, 2048, 128, 4, GD_OPS|SNAF_EXTRA_ECSP), // 4Gb
    SNDB(MID_GD, "GD5F4GQ6RExxH",   0x25, 4096, 64, 2048,  64, 4, GD_OPS), // 4Gb
};

const snaf_manu_t gd_manu_info = {
    .mid = MID_GD,
    .mname = "GIGADEVICE",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(gd_chips_info),
    .chips = gd_chips_info,
    .init = gd_init,
};
